# 犀牛书作者：最该忘记的JavaScript特性

> 原文：https://davidflanagan.com/2020/05/12/javascript-to-forget.html
> 
> 作者：David Flanagan


JavaScript这门语言的第一个演示版差不多就在25年前诞生。

![](https://p1.ssl.qhimg.com/t01dc4aa45e94f4c5c9.jpg)

> 没记错的话，25年前的今天，1995年5月10日，星期三，我刚刚过了创造JavaScript（代号为“Mocha”）的“5月的10天”冲刺的一半。我正在写下个周一就要交付的一个演示，目的是展示JS与Netscape的深度浏览器集成（相对于Java小应用）。

1995年秋天，这门语言在Netscape Navigator的一个测试版中发布，当时叫LiveScript。那一年的年底，又被改名为JavaScript。也是在那一年，David Flanagan开始写*JavaScript: The Definitive Guide*的第一版，并由O'Reilly在1996年8月出版。如今，24年过去了。

犀牛书（英文版）第7版再过几个星期就要面世了。为此，David回忆了一下，想告诉大家有哪些JavaScript特性可以放心地忘掉。一个原因是第七版比第6版薄了不少。而这主要是因为之前的很多东西2020年的开发者已经不用关心了。Web兼容性永远存在（至少25年以来一直如此），浏览器厂商可能在很长时期内仍然需要支持那些陈旧的、难以理解的语言和平台特性。但对我们而言，已经没有必要再为这些特性分心了。

也就是说，有不少JavaScript和Web平台特性在第7版里已经销声匿迹了。应该说，能对这些特性说再见是件高兴的事。以下就是David凭记忆列出的几个应该忘记的特性。

- `arguments`对象已经被ES6的`...args`语法完全取代。要解释清楚`arguments`与命名参数的关系，以及始终注意它对性能的影响着实不易。在遗留的前端代码中，也许还会看到它的身影。在严格模式下如果想将局部变量或函数参数命名为`arguments`，那浏览器也会提醒你它的存在。不过现在有了剩余参数，它就应该悄悄地被人遗忘了。
- 曾几何时，我们还会担心重复拼接字符串导致的性能问题。有一段时间，大家都学会了先把字符串推到数组里，最后再使用`join()`把它们拼接起来。后来，JavaScript变快了，我们就把这个模式给忘了。而现在有了模板字面量，谁还会再拼接字符串呢？
- `document.write()`在很早以前，确切地说是在DOM问世之前，曾经是JavaScript中最重要的特性。（如果你没在20世纪写过JavaScript，那可能想象不到DOM出现之前的日子，但那个时代真的存在过。）如果没记错的话，人们甚至可以使用`document.write()`向文档中插入脚本。不过这时候要小心，因为你得把末尾的`</script>`标签拆成两个字符串。这样HTML解析器才不会把它解释为当前运行脚本的结束标签。
- HTML早期是没有`<iframe>`的，不过有`<frameset>`和`<frame>`。`window.frames`属性是一个数组，包含嵌套的`window`对象，表示文档中的窗格。实际上，可以在窗格中调用文档的`open()`方法，然后使用`document.write()`在该窗格中动态生成整个文档。不管怎么说，这还真有点酷。因为窗格可以嵌套在其他窗格中，每个`window`对象都有一个`frames`数组包含自己的子窗格、一个`parent`属性引用包含窗口和一个`top`属性引用顶级窗口。犀牛书的早期版本专门用了几节篇幅和复杂的示意图来解释这些内容。
- 在文档中直接引用特定元素的技术基本上都废弃了。前面说到的`frames`数组是一个，没记错的话，还有`links`和`images`数组，包含文档中的所有链接和所有图片。IE（我记得应该是版本4）一步到位，引入了`document.all`，这是一个包含文档中所有元素的数组。（这也是“DHTML”也就是“动态HTML”及后来DOM的发端，有点像人类进化史上第一条爬上陆地的鱼。）`document.all`有各种各样新奇的特性，它这个数组本身还有很多按名字或按其他条件来查询元素的方法。`document.all`最终没有被写进标准，但即便是标准的`document.getElementById()`、`document.getElementsByName()`、`document.getElementsByTagName()`和`docuemnt.getElementsByClassName()`方法，在今天看来似乎也已经没多少人用了。因为受到了jQuery的`$()`及受它启发而引入标准的`document.querySelector()`和`document.querySelectorAll()`的排挤。借用CSS选择符的威力，这两个方法直接就把之前的那些方法都给废掉了。
- 说起我最恨Internet Explorer的一件事，就是他们非要使用`attachEvent()`来注册事件处理程序。在我的印象中，他们是在标准已经规定了`addEventListener()`方法之后这么搞的，这可真是太讨厌了。事件及其处理程序一直以来都是Web开发中一个最大的不兼容问题。多少年以来，JavaScript程序员（和JavaScript图书作者）都必须处理IE事件模型与标准事件模型的各种差异。为此，处理事件的代码必须写两遍，一遍针对IE，一遍针对Firefox。书中介绍事件的章节相应地也会两倍长，因为有两套非常相似但却完全不兼容的事件处理机制。jQuery的一个主要特性就是实现了自己的事件兼容层，于是开发者只需掌握一种事件处理方式即可。我怀疑这也是它快速流行的一个重要原因。
- 最初的DOM API是在人们疯狂迷恋XML的时代定义的。（当时的人们确实相信用不了几年，XML就可以解决所有数据问题。真是个难以置信的时代。）某种程度上，正是W3C的认可，才让Java那些人影响了DOM API，这些人觉得最好只定义一套API，JavaScript程序员能用它操作HTML文档，而Java程序员能用它操作XML数据。这也是为什么会有Attr节点（最好当它不存在）这么怪异的东西的原因。DOM Level 3 API中最让我不理解的一个操作是从文档中删除元素e，你不能像今天这样写成e.remove()，而是必须写成e.parentNode.removeChild(e)。


不管怎么说，现在都已经2020年了。犀牛书第7版将不会再花笔墨描述这些陈旧的特性，这些特性大家最好还是忘掉。
