# iOS 13 新增了哪些无障碍功能？

iOS 在移动无障碍方面一直做得很好。在 iOS 13 里又新增了：
- 语音控制：这是一个全新的辅助技术
- 在系统范围内，开启/禁用多媒体的自动播放
- 新 API：可以让开发人员更轻松地自定义辅助功能

## 语音控制

启用语音控制之后，每个可激活元素旁边都会有一个数字，这些数字是在一个覆盖层上显示的。你可以用这些数字引用对应的元素，并对它们进行操作。

语音控制缺少一个有效的“快速入门”的介绍，所以发现正确的语音命令格式有点困难。下面是测试成功的语音控制命令：
- 显示名称：更改覆盖层来显示名称
- 显示数字：更改覆盖层来显示数字
- 点击1：单击屏幕上的第一个控件
- 点击“应用程序”：单击标有“应用程序”的控件
- 递增{名称/数字}：递增可调控件
- 递减{名称/数字}：递减可调控件
- 回首页
- 返回

语音控制是 iOS 无障碍功能系列的一个很好补充。

此外，它还能简化无障碍的测试过程。

作为开发人员，不停地打开和关闭 VoiceOver 挺浪费时间的（要验证标签是否合适）；作为无障碍测试人员，会更频繁地开关 VoiceOver。语音控制可以极大地改善这些情况。

可以加快焦点测试（WCAG 2.4.3）。任何在 SwitchControl 里可以激活的元素，都可以在 VoiceOver 里激活；何在 VoiceOver 里可以激活的元素，都可以在 SwitchControl 里激活。要测试屏幕上的每个项目是否能在 VoiceOver 和 SwitchControl 中正确聚焦，语音控制测试要比开关控制测试快很多。

开发人员在做无障碍测试时，两个首要目的应该是：确保每个可激活控件可被激活，且都有一个合适的描述性名称；执行无障碍功能的自动化测试。语音控制功能可以让你更轻松地检查。

## 禁用多媒体的自动播放

在系统级禁用自动播放媒体的功能对残障用户来说是一项强大的功能。虽然一段时间以来，许多应用程序都单独支持此功能，尤其是主要用于显示媒体的应用程序，例如 YouTube 和 Facebook。

这和 [WCAG 1.4.2 – 语音控制](https://www.w3.org/TR/UNDERSTANDING-WCAG20/visual-audio-contrast-dis-audio.html) 直接相关：“如果同时播放其他音频，那么使用屏幕阅读软件的人将会很难听到语音”。此设置就可以让用户避免这种情况。

在代码里可以这样判断：
```js
if UIAccessibility.isVideoAutoplayEnabled {
    // Autoplay annoying media
} else {
    // Don’t autoplay annoying media.
}

```

## 新 API `UIAccessibilityCustomActionHandler`

对于开发 Accessibility iOS 应用程序的人来说，UIAccessibilityCustomAction 是一个功能强大的工具，它可以让你将多个操作与一个可聚焦的目标相关联，这非常适合允许 VoiceOver 或 Switch Control 用户执行通常由手势执行的操作。感兴趣的朋友可查看 [UIAccessibilityCustomAction](https://developer.apple.com/documentation/uikit/uiaccessibilitycustomaction/handler)。

## 小结
iOS 13 中没有开创性的辅助功能更改，尤其是没有重要的 VoiceOver 更新。但是，有一些受欢迎的工具和可靠的迭代改进表明 Apple 对残障用户的承诺。此外，语音控制是一个很棒的新工具，应该成为每个应用程序开发团队测试过程的一部分。

https://www.deque.com/blog/new-in-ios-13-accessibility-voice-control-and-more/
