# W3C万维物联网标准解析：架构篇

2019年10月21日，作者在[“W3C万维物联网标准简介”](https://mp.weixin.qq.com/s/cDrjKQ_YhpmVCA7BD2xNfQ)一文中简单介绍了W3C Web of Things（WoT）工作组制定的WoT标准以及它们的最新状态：

| 规范                                    | 当前状态           |
| --------------------------------------- | ------------------ |
| WoT Architecture                        | CR                 |
| WoT Thing Description                   | CR                 |
| WoT Scripting API                       | WD，Working Draft  |
| WoT Binding Templates                   | Working Group Note |
| WoT Security and Privacy Considerations | Working Group Note |

本系列将从WoT标准本身出发，对目前已经进入CR阶段（W3C标准的阶段参见下图）的WoT Architecture（WoT架构）、WoT Thing Description（WoT物描述）以及处于WD阶段的WoT Scripting API（WoT编程API）进行一次快速解析。

如下图所示，标准进入CR阶段意味着内容已经相对稳定，WD阶段则意味着较大的不确定性，而Working Group Note（工作组备忘）则变数很大。因此处于CR阶段的“架构”和“物描述”是值得花时间了解的（成为正式推荐标准REC的可能性很大），而处于WD阶段的编程API最近（2019年10月28日）刚刚做了一次大的内容改版，几乎完全废弃了上一版的内容，只能说接近稳定状态，但编程API始终是开发者所喜闻乐见的，所以本系列也会介绍。

![](https://p5.ssl.qhimg.com/t01a681425860dcff64.png)

> W3C Process Document，<https://www.w3.org/2019/Process-20190301/#recs-and-notes>

## 1. WoT架构

WoT架构规范的核心分别从7个方面描述了WoT相关的术语及这些术语之间的相关关系。架构的本质就是术语及其关系。术语代表业界约定俗成的概念，是架构的骨骼和肌肉；关系描述术语的交互与特性，是架构的血液和神经。

- Overview（概述）
- Affordances（可识别功能）
- Web Thing（Web物）
- Interaction Model（交互模型）
- Hypermedia Controls（超媒体控件）
- Protocol Bindings（协议绑定）
- WoT System Components and Their Interconnectivity（组件及互联）

## 2. 概述

这一部分从宏观上定义了Thing、Consumer和Intermediary三个基础概念及其相互关系。

- Thing（物）：指的是某个物理或虚拟实体（如设备或房间）的抽象表示，由标准化的元数据描述。在W3C WoT中，描述元数据**必须**是WoT Thing Description（TD）。
- Consumer（消费者）：消费者**必须**能够解析和处理基于JSON的TD。
- Intermediary（中介）：可以充当物体的代理，此时中介拥有与背后的物类似的TD，但指向的是由这个中介提供的WoT接口。中介也可以给背后的物添加额外的能力或者将多个可用的物体组合起来，从而构成虚拟实体。对消费者而言，中介看起来就像一个物，因为它拥有TD且提供WoT接口。

消费者与物直接交互是最简单直观的方式：

![](https://p1.ssl.qhimg.com/t015ba733a9f39711b2.png)



物TD中可以包含指向其他物或资源的链接：

![](https://p2.ssl.qhimg.com/t0137468b684240e8eb.png)

互联网无法访问本地网络是实际部署中面临的一个典型问题，通常是因为存在IPv4 NAT（Network Address Translation）或防火墙。为解决这个问题，W3C WoT允许物与消费者之间存在中介。

![](https://p5.ssl.qhimg.com/t01d700c28c4de02391.png)

上述几个概念适用于IoT应用的各个层面：设备层、边缘层和云计算层。在这些层面应用上述概念能够促进跨层级通用接口和API的产生，进而促成IoT应用间不同的交互模式如物与物、物与网关、物与云、网关与云，甚至云联盟（如两个或多个服务提供商的云计算环境互联）。

![](https://p0.ssl.qhimg.com/t01478576d3b127b513.png)

## 3. 可识别功能

Affordance（可识别功能）是借用认知心理学领域的一个术语，“指的是某物可察觉且实际存在的属性，而且特指决定怎么使用它们的根本属性。”（Donald Norman）比如，看到门边有一块板，就知道需要推开它。

![](https://p1.ssl.qhimg.com/t015dbaf9a9ef7c0aca.png)

（参见：<https://communitywiki.org/wiki/WhatIsAffordance>）

可识别功能在TD中用于描述物的能力。WoT将以下4个概念归为可识别功能：

- 导航
- 属性
- 动作
- 事件

其中，导航使用的是超链接。对超链接的描述（比如链接关系类型和链接目标属性）就是一种功能，它告诉Web客户端如何导航以及怎么处理链接的资源。换句话说，链接提供了导航这种可识别功能。

而属性、动作和事件使用另一个超媒体控件，表单来描述。相对于超链接，表单能实现与物的更复杂的交互。

## 4. Web物

Web物涉及4个方面：

- Behavior（行为）

- Interaction Affordance（交互可识别功能）

- Security Configuration（安全配置）

- Protocol Binding（协议绑定）

如下图所示，除了行为之外，交互可识别功能、安全配置和协议绑定都需要在TD中体现。这里的行为，可以理解为在其他3方面之上的基于场景的控制逻辑。

TD中描述的交互可识别功能可以为消费者提供了一个交互模型，但不涉及特定网络协议或数据编码。交互可识别功能到特定协议消息的映射由协议绑定来提供。一般来说，不同协议通常用于支持不同的交互可识别功能。而物的安全配置则代表交互可识别功能的访问控制机制，以及对相关公共或私有元数据的管理。

![](https://p5.ssl.qhimg.com/t0128d98ca952c840a4.jpg)

**物架构**

## 5. 交互模型

如前所述，WoT在导航的基础之上，又正式规定了3种交互可识别功能：

- 属性
- 动作
- 事件

属性作为一种交互可识别功能，用于暴露物体的状态。属性暴露的状态**必须**可获取（可读）。可选地，属性暴露的状态**可以**被更新（可写）。物体可以通过在某个变化之后推送新状态让属性可观察（参见Observing Resources [[RFC7641](https://www.w3.org/TR/wot-architecture/#bib-rfc7641)]）。只写状态应该通过某个动作来更新。

属性的例子有传感器的值（只读）、有状态执行器（读写）、配置参数（读写）、物体状态（只读或读写），以及计算结果（只读）。

动作作为一种交互可识别功能，允许激活物体的某个功能。动作**可以**操作直接暴露的状态（参见属性）、同时操作多个属性或基于内部逻辑操作属性（如切换）。触发动作也**可以**触发物体上某个随时间推移而操作状态（包括通过执行器改变物理状态）的流程。

动作的例子包括同时改变多个属性、随时间推移或通过一个不应泄露的流程（如专有控制循环算法）改变属性（如调暗灯光），或者启动一个持续较长时间的流程（如打印文件）。

事件作为一种交互可识别功能，描述异步把数据从物体推送到消费者的事件来源。这里重点不在于传送状态，而在于传送状态变化（如事件）。事件**可以**通过未暴露为属性的条件触发。

事件的例子包括警报等离散事件，也包括定时推送的时序采样事件。

无论属性、动作，还是事件，如果交互过程中的数据没有被协议绑定（通过媒体类型）完全定义，那么它们都可以额外包含相应的数据模式（Data Schema）。

## 6. 超媒体控件

W3C WoT用到了两种超媒体控件：众所周知的在网上冲浪的Web链接（[RFC8288](https://www.w3.org/TR/wot-architecture/#bib-rfc8288)）和更强大的可以支持任意操作的Web表单。链接在其他IoT标准和IoT平台中已经被用到了，比如CoRE Link Format [[RFC6690](https://www.w3.org/TR/wot-architecture/#bib-rfc6690)]、OMA LWM2M [[LWM2M](https://www.w3.org/TR/wot-architecture/#bib-lwm2m)]、OCF [[OCF](https://www.w3.org/TR/wot-architecture/#bib-ocf)]。表单则是一个新概念，除了W3C WoT，IETF的*Constrained RESTful Application Language (CoRAL)* [[CoRAL](https://www.w3.org/TR/wot-architecture/#bib-coral)]也用到了它。 

### 6.1 链接

链接让消费者（或者更宽泛地讲Web客户端）改变当前上下文（Web浏览器当前呈现的各种资源）或者在当前上下文中包含更多资源，取决于上下文与链接目标的关系。消费者通过对目标URI解引用也就是通过跟进链接来获取资源表示来实现这一操作。

W3C WoT遵循Web链接（[[RFC8288](https://www.w3.org/TR/wot-architecture/#bib-rfc8288)]）的定义，也就是说一个链接包含：

- 链接上下文
- 关系类型
- 链接目标
- 目标属性（可选）

在WoT中，链接用于发现和表示物体之间的关系（如层次关系或功能关系），以及物体与Web上其他文档的关系（如手册或CAD模型等替代表示）。

### 6.2 表单

表单让消费者（或者更宽泛地讲Web客户端）执行超出解引用URI以外的操作（如操作物体的状态）。消费者通过填充并将表单提交给提交目标来实现上述操作。这通常需要比链接更详细的（请求）消息细节（如方法、首部字段或其他协议选项）。可以将表单看成一个请求模板，提供商会根据自己的接口和状态预先填充部分信息，剩余的字段由消费者（或Web客户端）填写。

W3C WoT把表单定义为一种新的超媒体控件。注意，CoRAL（ [[CoRAL](https://www.w3.org/TR/wot-architecture/#bib-coral)]）中的定义也差不多，可以看成是一致的。表单包含：

- 表单上下文
- 操作类型
- 提交目标
- 请求方法
- 表单字段（可选）

表单可以看成这么一句话：“在**表单上下文**中执行指定**操作类型**的操作，以指定的**请求方法**向**提交目标**发送请求”，然后可选的字段用于进一步描述请求。 

**WoT的常见操作类型**

| 操作类型                | 说明                                                         |
| ----------------------- | ------------------------------------------------------------ |
| readproperty            | 标识属性可识别功能的读操作，用于获取相应数据                 |
| writeproperty           | 标识属性可识别功能的写操作，用于更新相应数据                 |
| observeproperty         | 标识属性可识别功能的观察操作，当属性被更新时会收到包含新数据的通知 |
| unobserveproperty       | 标识属性可识别功能的取消观察操作，停止接收相应的通知         |
| invokeaction            | 标识动作可识别功能的调用操作，以执行相应的动作               |
| subscribeevent          | 标识事件可识别功能的订阅操作，当物体的事件发生时会收到通知   |
| unsubscribeevent        | 标识事件可识别功能的取消订阅操作，停止接收相应的通知         |
| readallproperties       | 标识物体的读取全部属性操作，用于一次性获取所有属性的数据     |
| writeallproperties      | 标识物体的写入全部属性操作，用于一次性写入所有属性的数据     |
| readmultipleproperties  | 标识物体的读取多个属性操作，用于一次性获取选择属性的数据     |
| writemultipleproperties | 标识物体的写入多个属性操作，用于一次性写入选择属性的数据     |

## 7. 协议绑定

协议绑定就是从一个交互可识别功能到某个特定协议（如HTTP [[RFC7231](https://www.w3.org/TR/wot-architecture/#bib-rfc7231)]、CoAP [[RFC7252](https://www.w3.org/TR/wot-architecture/#bib-rfc7252)]或MQTT [[MQTT](https://www.w3.org/TR/wot-architecture/#bib-mqtt)]）具体消息的映射。协议绑定让消费者知道如何通过面向网络的接口激活交互可识别功能。为支持互操作，协议绑定遵循REST（[[REST](https://www.w3.org/TR/wot-architecture/#bib-rest)] ）的统一接口规范。

WoT对协议绑定从如下几方面做出了限制。

### 7.1 超媒体驱动

交互可识别功能**必须**包含一或多个协议绑定。协议绑定**必须**被序列化为超媒体控件，能够自解释如何激活交互可识别功能。超媒体控件**必须**由提供交互可识别功能的物体主体给出。所谓主体可以是物体自身，在运行时产生TD文档（基于自己当前状态并包含IP地址等网络参数），也可以从内存里给出（只包含当前网络参数）。主体也可以是能全面且实时掌握物体及其网络参数、内部结构的外部实体（如软件栈）。这可以让物体与消费者实现松散耦合，从而让它们拥有独立的生命周期并独立演进。超媒体控件可以被缓存在物体外部，以便离线时使用缓存的尚在有效期的元数据。

### 7.2 URI

符合W3C WoT要求的协议必须具有在IANA（[[RFC4395](https://www.w3.org/TR/wot-architecture/#bib-rfc4395)]）注册的URI模式。超媒体控件依赖URI辨别链接和提交目标。因此，URI模式（冒号前的第一个组件）表示与物体的交互可识别功能通信时使用的协议。W3C WoT称这些协议为传输协议。

### 7.3 标准方法

符合W3C WoT要求的协议必须基于众所周知的标准方法。标准方法让消息可以自解释，从而让交互可识别功能可以进行中间处理，如通过代理来处理或者从一个协议绑定转换为另一个协议绑定[[REST](https://www.w3.org/TR/wot-architecture/#bib-rest)]。另外，还可能让消费者拥有可重用的传输协议栈，如HTTP、CoAP或MQTT，避免消费者编写特定于物体的代码或插件。

### 7.4 媒体类型

在激活交互可识别功能时交换的所有数据（或者说内容）都必须通过协议绑定中的媒体类型[[RFC6838](https://www.w3.org/TR/wot-architecture/#bib-rfc6838)] 来标识。媒体类型表示内容格式，如`application/json` for JSON [[RFC8259](https://www.w3.org/TR/wot-architecture/#bib-rfc8259)] or `application/cbor` for CBOR [[RFC7049](https://www.w3.org/TR/wot-architecture/#bib-rfc7049)]。媒体类型由IANA管理。

有些媒体类型可能需要提供额外参数才能完整指定内容使用的格式。如`text/plain; charset=utf-8` or `application/ld+json; profile="http://www.w3.org/ns/json-ld#compacted"`。在描述发送给物体的数据时，需要特别注意这一点。传输过程中可能需要对数据进行标准的转换，如内容编码 [[RFC7231](https://www.w3.org/TR/wot-architecture/#bib-rfc7231)]。协议绑定可以包含额外信息，用于在媒体类型之外提供更具体的信息以供确定内容格式。

注意，很多媒体类型只标识一种通用的序列化格式，并不能对内容组成（如XML、JSON、CBOR）提供更多语义。因此，对应的交互可识别功能应该声明数据模式，以便为数据交换提供更具体的语法级元数据。

## 8. 组件及其互联

概述中从抽象WoT架构组件角度描述了WoT架构，包括物、消费者和中介。在把这些抽象的架构组件实现为软件栈，而这些软件栈在WoT架构中扮演相应角色时，这些软件栈就被称为服务套件（Servient）。

这一部分通过示意图来说明服务套件如何协同工作以构成基于WoT架构的系统。

首先，物可以被实现为服务套件。我们称包含物表示（TD）的服务套件软件栈为暴露体（Exposed Thing），该软件栈对物的消费者暴露WoT接口。暴露体可以由服务套件上的其他软件组件使用，以实现物的行为。

![](https://p3.ssl.qhimg.com/t0117324a923c4ccb47.jpg)

**物服务套件**

其次，消费者则始终会通过服务套件实现，因为它们必须能够处理TD，而且必须有一个可以通过TD中包含的协议绑定信息来配置的协议栈。

在消费者中，我们称提供物表示的服务套件软件栈为消费体（Consumed Thing），该软件栈让运行于这个服务套件之上、需要处理TD的应用可以与物体交互。

![](https://p4.ssl.qhimg.com/t0169f5ccf3d707886b.jpg)

**消费者服务套件**

服务套件软件栈中消费体的实例旨在从应用中分离协议级别的复杂性，代替应用与暴露体进行通信。

最后，中介也是由服务套件实现的一个WoT架构组件。中介位于物与消费者之间，同时扮演消费者（对物而言）和物（对消费者而言）的角色。在中介服务套件中，软件栈既包含消费者（消费体）也包含物（暴露体）。

![](https://p5.ssl.qhimg.com/t015c6834566ce4e85c.jpg)

**中介服务套件**

### 8.1 直接通信

下图展示了物与消费者之间的直接通信，物通过TD暴露交互可识别功能，消费者通过该交互可识别功能来使用物。直接通信适用于双方的服务套件使用相同网络协议，且可以相互访问的场景。

![](https://p5.ssl.qhimg.com/t011fb54e10b827aa2a.jpg)

**消费者与物直接通信**

暴露体是物抽象的软件表示，为物提供的交互可识别功能暴露WoT接口。

消费体是被消费者消费的一个远程物的软件表示，作为应用访问远程物的接口。消费者可以通过解析和处理TD生成一个消费体实例。消费者与物的交互通过消费体与暴露体直接连接并交换数据实现。

### 8.2 间接通信

下图展示了消费者和物通过中介相互连接在一起。如果实现消费者与物的服务套件使用不同协议，或者消费者与物位于需要认证才能访问的不同网络，则它们之间必须通过中介实现通信。

![](https://p3.ssl.qhimg.com/t01fc5d4f3d0c75441d.jpg)

**通过中介通信**

中介同时包含暴露体和消费体的功能。中介的功能包括为消费者和物的交互可识别功能转发消息、可选地缓存物体的数据以加速响应，以及在物的功能被中介扩展的情况下进行通信转换。在中介里，消费体会创建物的暴露体的代理对象，消费者可以通过自己的消费体访问这个代理对象（即中介的暴露体）。

中介与消费者通信使用的协议可以不同于与物通信使用的协议。比如，使用CoAP的物与使用HTTP的消费者可以通过中介作为桥梁。

即使中介与物之间使用多种不同协议，消费者也可以只使用一种协议通过中介与这些物通信。同样，在认证的时候也是这样。消费者的消费体只需使用一种安全机制与中介的暴露体进行认证，而中介则可能需要通过多种安全机制对不同的物进行认证。

通常，中介会根据原始物的TD来创建其代理对象的TD。根据用例的需求，这个代理对象的TD可以使用与原始物TD相同的标识符，也可以被赋予一个新标识符。必要情况下，中介生成的TD可以包含支持其他通信协议的接口。

## 9. 小结

本文作为“W3C万维物联网标准解析”系列的第一篇，主要讲解了WoT架构的核心概念。架构的本质是概念及其关系。WoT架构描述了很多概念，包括物、中介、消费者、可识别功能（属性、动作、属性）、超媒体控件（链接、表单）、服务套件、暴露体、消费体，等等。其中物是对物理或虚拟设备的抽象，代表服务端功能。消费者是对WoT应用的抽象，代表客户端功能。而中介则兼具物的抽象和应用的抽象。物、消费者和中介的实现称为服务套件，有直接和间接两种通信模式。

WoT架构的核心是规定了物描述（TD）包含交互可识别功能、安全配置和协议绑定。物可以拥有导航、属性、动作和属性等4种交互可识别功能，并通过超媒体控件（链接、表单）提供。这就是所谓的交互模型。WoT架构当前定义了12用常用交互操作，其中8种与属性相关、1种与动作相关，2种与事件相关。

协议绑定是交互可识别功能到具体协议调用的映射。安全配置代表交互可识别功能的访问控制机制。

## 10. 扩展阅读

关于W3C成立WoT工作组制定WoT标准的初衷，可以参考该文章。

- [“W3C万维物联网标准简介”](https://mp.weixin.qq.com/s/cDrjKQ_YhpmVCA7BD2xNfQ)
- 知乎用户“尧以俊德”的回答：<https://www.zhihu.com/question/26469697/answer/537098445>

## 11. 相关链接

- WoT Architecture：https://www.w3.org/TR/wot-architecture/
- WoT Thing Description：https://www.w3.org/TR/wot-thing-description/
- WoT Scripting API：https://www.w3.org/TR/wot-scripting-api/
- WoT Binding Templates:https://www.w3.org/TR/wot-binding-templates/
- WoT Security and Privacy Considerations：https://www.w3.org/TR/wot-security/
- WoT兴趣组：https://www.w3.org/2019/07/wot-ig-2019.html
- WoT工作组：https://www.w3.org/2016/12/wot-wg-2016.html