# 具有“脚本魔力”的属性们

属性的“脚本魔力”，是指仅仅通过一行简单的属性设置，就能实现看起来要 JS 才能完成的交互功能。包括但不限于：
- CSS 属性
    - `touch-action`
    - `pointer-events`
    - `resize`
    - `text-transform`
    - `shape-outside`
- HTML 属性
    - `inputmode`
    - `accesskey`
    - `contenteditable`
    - `draggable`

## touch-action
`touch-action`可以控制用户在触摸屏上的行为，诸如滚动（横向滚动、纵向滚动）、网页缩放等。它能决定在此元素上触发的触摸行为，能否触发浏览器的默认行为。

它的取值可以是：
```css
touch-action: auto | none | [ [ pan-x | pan-left | pan-right ] || [ pan-y | pan-up | pan-down ] || pinch-zoom ] | manipulation
```

取值说明：
- `auto` 默认值。由浏览器自己决定触摸行为
- `none` 会禁用浏览器自带的一切触摸行为
- `manipulation` 浏览器只能滚动和缩放，它等价于 `pan-x pan-y pinch-zoom`
- 以下三组的任意组合，设置浏览器只能在指定方向上触发自带的触摸行为
    - `pan-x | pan-left | pan-right` 横向滚动
    - `pan-y | pan-up | pan-down` 纵向滚动
    - `pinch-zoom` 缩放页面

> 特别说明：
> - 术语 pan 和 scroll 是同义词，用来定义触发 panning（平移）和 scrolling（滚动）
> - pinch 单词释义：捏、掐、撮
> - zoom 单词释义：放大

该属性最常用的使用场景：
- 图片的轮播/横滑，可以显式指定`touch-action: pan-y pinch-zoom;`。在一些浏览器中，横滑会触发浏览器自带的“上一页/下一页”的功能，用这行 CSS 可以很好的兼容此类问题。
- 消除移动端点击事件的300ms延迟，可以显式指定`touch-action: manipulation;`。300ms延迟的问题，是设备为了区分手势是 tap 还是 double-tap。禁用一些默认的触摸行为，能让浏览器更快地响应其它行为。
- 禁用元素上的所有手势，可以明确指定`touch-action: none;`。这在一些特殊场景下很有用，比如地图、游戏之类，它们会提供自己特有的拖拽和缩放功能。

它的原理是浏览器在响应触摸事件之前，会先判断下属性`touch-action`的值。更多内容，详见标准 [Pointer Events / Details of touch-action values](https://w3c.github.io/pointerevents/#details-of-touch-action-values)。

> 不建议用 touch-action: none; 这会影响到无障碍特性。它会禁止操作浏览器的缩放功能，不方便弱视人群阅读网页。

## pointer-events
`pointer-events`可以定义元素如何响应鼠标事件。

```css
pointer-events: auto | none | fill | stroke | all | bounding-box | visiblePainted | visibleFill | visibleStroke | visible | painted 
```

它的取值可以是：
- `auto`
- `none` 该元素不可能成为鼠标事件的目标
- 其它值，是 SVG 元素特有。此处不展开讲了

`pointer-events: none` 在下面的场景下很有用：
- 弹层的点击穿透。即点击了弹层，但它下面的元素链接却跳转了
- 模态遮罩层，让下面的网页内容不响应垂直方向的滚动事件


## 其它 CSS 属性

- `resize` 元素是否可以拖拽，以及在哪个方向上拖拽
- `text-transform` 控制文本的大小写
- `shape-outside` 控制元素的对外占位

以上三个比较直观，可以直接看[在线例子](https://codepen.io/anjia/pen/mddEwXv)。

> - `scroll-*` 元素的滚动行为
> - `animation` 动画相关


## HTML 属性
- `inputmode` 指定输入键盘的样式，这在移动端很有用。
    - 它的兼容性不好，替代方案是用`<input type="">`的`type`属性
    - 取值可以是`text`、`tel`、`url`、`email`
- `accesskey` 指定元素的快捷键。不同操作系统不同浏览器的组合键会略有差异，详见 [accesskey](https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes/accesskey)
- `contenteditable="true"` 元素可编辑
- `draggable="true"` 元素可拖拽

## 小结

了解这些小小的属性，可以让我们在特定场景下事半功倍。:)
