#【译】移动App的可访问性陷阱和测试方法

> 原文：[Mobile App Accessibility Pitfalls, Plus an Intro on Testing for Accessibility.](https://www.microassist.com/digital-accessibility/mobile-application-accessibility-part-2-of-2/)

![](https://p2.ssl.qhimg.com/t01c7464a397f1130f4.jpg)


## 确保残障用户可以访问移动应用程序：给设计师和开发人员的提示和测试指南
在[第1部分：移动应用程序可访问性的关键开发注意事项](https://www.microassist.com/digital-accessibility/mobile-application-accessibility-part-1-of-2/#utm_source=microassist&utm_medium=mobilapps&utm_campaign=Pt2)中，我们讨论了可访问性的人权和法律案例，了解了可访问性在移动应用程序和网站上的异同，也知道了实现移动应用程序可访问性的基本内容。

本文我们将介绍13个阻碍残障用户使用移动应用程序的可访问性问题，它们都会使企业面临潜在的法律诉讼或投诉；我们还将介绍如何[审计移动应用程序的可访问性](https://www.microassist.com/accessibility/accessibility-audit-services/)，并介绍其最佳实践。

在多数情况下，我们都会参考与手头问题相关的[Web内容可访问性指南（WCAG）2.0](https://www.w3.org/TR/WCAG20/#guidelines#utm_source=microassist&utm_medium=mobilapps&utm_campaign=Pt2)的标准。如第1部分所述，WCAG 2.0是国际公认的建议，旨在使数字内容（无论是网站还是应用程序）更易于访问，并且对所有人都更好用。

![](https://p1.ssl.qhimg.com/t01fce6e46985f50130.png)

## 13个常见的移动可访问性问题
在移动应用程序和移动网站的设计和开发阶段，需要考虑许多可访问性问题。根据我们的经验，以下是最常见的应用程序开发实践，可确保残障用户很好地导航和使用你的应用程序。

为了确保应用程序的良好访问性，设计团队和开发团队在编写移动网站和移动应用程序时需要避开下面的做法。

1. **禁用双指缩放** - 双指缩放是一个非常有用的辅助工具，它允许有视力障碍的人通过简单的多点触控手势放大一段内容。移动网页若使用了`user-scalable=no`的meta视口属性，便就阻止了用户使用扩大网站文本和图像的标准双指捏合缩放手势。绝不应该禁用这种非常常见的手势。
2. **未读出的表单验证错误消息** - 屏幕阅读器无法访问验证的错误消息是移动网站和原生应用程序的常见问题。对于看得见的用户，当他给表单提交了无效数据时，就会出现红色错误消息。对于屏幕阅读器用户，开发人员需要测试错误消息和其它修复建议是否被大声读出，以便盲人用户能听到他们哪里填错了。
3. **未读出的成功和公告消息** - 当操作完成时，开发人员通常会在屏幕顶部显示成功和公告消息。如果该应用没有适当的辅助功能公告通知方法，屏幕阅读器将无法大声读出这些内容。对于移动Web页面，开发人员需要使用 WAI-ARIA Assertive 和 Polite Live Regions，例如`<div role="alert">`用于断言公告，`<div role="status">`用于不会中断用户的礼貌公告。对于原生应用程序，有特定的辅助功能API可以让屏幕阅读器大声读出成功和公告消息。W3C有[基于ARIA的网站警报示例](http://w3c.github.io/aria-practices/examples/alert/index.html#utm_source=microassist&utm_medium=mobilapps&utm_campaign=Pt2)。
4. **没有`<label>`的占位符** - 放在表单域内的示例文本（也称为“占位符文本”或“内联标签”）在移动应用程序和站点中很常见。这种常见做法发生在`<input>`元素使用了`placeholder`属性，而没有使用`<label>`文本元素。因为`placeholder`是把文本放在表单字段中而不是字段的上方或旁边，所以这样做会节省空间，看起来也更简洁些。这样做的理由往往是用户能看到该字段的示例文本（例如，“紧急联系人姓名”）并知道它需要什么信息。但是，这样做是不利于认知可访问性的：一旦用户开始输入，文本就会消失；有了输入信息了，便不会再出现；除此之外，这种短暂的形式字段文本会对短期记忆造成压力；也不方便用户在提交表单之前检查他们的信息。另一个重要问题是占位符的对比度非常低，不符合WCAG可访问性要求。WCAG 2.0 AA是全球范围内实施的可访问性标准，所以满足它的颜色对比要求是很重要的，即使你认为用户不需要占位符的帮助文本也能完成表单的填写。对于可访问性和可用性，我们建议设计人员对所有字段使用标准的`<label>`元素，确保文本标签始终显示在输入字段上方。例如，没有可见`label`的错误代码是：`<input type="text" placeholder="First Name">`，而正确的有`label`的输入框是：`<label for="first">名字</label><input id="first" type="text" placeholder="John">`。
5. **缺少独特且有意义的页面标题** - 单页面应用程序（SPA）是一种Web应用程序，它可以加载单个HTML页面，并在用户与应用程序交互时动态更新该页面。单页应用的一个常见问题就是应用程序中的每个页面都缺少唯一且有意义的页面标题。它在新屏下动态加载内容而不是打开新的HTML页签，因此开发人员不会考虑在每次加载新屏时动态更新页面`<title>`文本。但是，页面标题是用户了解他们在应用程序中的位置以及他们可以期望的页面内容的关键指示符。拥有一个独特而有意义的页面标题是WCAG的特定要求，称为[2.4.2页面标题](https://www.w3.org/TR/UNDERSTANDING-WCAG20/navigation-mechanisms-title.html#utm_source=microassist&utm_medium=mobilapps&utm_campaign=Pt2)。
6. **糟糕的焦点顺序** - 在基本术语中，“焦点”表示光标在哪里或者哪个元素正等待激活（例如菜单项或按钮）。在移动电话上，屏幕阅读器会显示当前聚焦元素的周围轮廓，如果用户双击，将激活该元素。单页应用则需要将键盘焦点从前一屏的焦点区域移到新屏中去；否则，每当新屏加载时，辅助技术用户将必须向左滑动（类似在PC上按`Tab`键切换聚焦元素）才能找到新的聚焦元素。糟糕的焦点顺序会影响使用键盘和屏幕阅读器的用户，因为他们的焦点要么还保留在旧内容上，要么已经跳过新内容了。
7. **模态框焦点问题** - 模式框是个窗口，强制用户在返回使用主应用程序之前与其进行交互。模态对话框的问题在于它们在被打开后却没有获得屏幕阅读器的焦点，换句话说就是，模态对话框没有把焦点放在对话框中最合逻辑的地方，以便用户可以直接采取行动。此外，开发人员通常不会将键盘和屏幕阅读器焦点限制在主要内容区域内，即使该区域已在视觉上变灰并被禁用。结果就是，可能存在这种情况：即使屏幕阅读器用户已经打开了模态对话框，但焦点仍然在打开它的按钮上；他们向左滑动以尝试阅读新内容，但仍保留在灰色主要内容中的模式对话框下方，无法采取所需操作。
8. **汉堡菜单和手风琴未正确实现** - 如果代码写的不对，汉堡菜单和手风琴设计元素可能会导致视障人士的可访问性问题。汉堡菜单图标由三条水平线组成，出现在许多移动屏幕的顶部，无论是最左侧还是最右侧（图1）。通过触摸或点击汉堡菜单图标，它会打开一个侧面菜单，其中包含一系列选项或其它页面。

![](https://p5.ssl.qhimg.com/t013cf948cbadd7a9a0.png)
*图1.汉堡菜单示例：顶部示例显示了在其缩小和展开状态下右侧的汉堡菜单。*


手风琴是一种设计元素，可以在某些地方展开以暴露隐藏信息。手风琴将页面内容向下推，而不是像一个层或者模态框那样覆盖在页面上。手风琴元素的一个常见示例是当用户激活菜单标题时显示子菜单项的菜单，图2中的W3C示例显示了一个手风琴元素，展示与不同类别信息相关的表单输入字段，可在[W3C.github.io上的交互式手风琴示例](http://w3c.github.io/aria-practices/examples/accordion/accordion.html#utm_source=microassist&utm_medium=mobilapps&utm_campaign=Pt2)在线体验下，以便更好地了解此功能。

![](https://p1.ssl.qhimg.com/t018bca3289af4f967a.gif)
*图2.折叠元素示例：在上面的三屏幕图中，左侧屏幕显示一个折叠所有选项的折叠元素。当用户点击或点击“个人信息”部分时，它会展开以显示与个人信息相关的输入字段，在屏幕下方按下第二部分“结算地址”，如中心屏幕所示。右侧屏幕显示“个人信息”部分关闭，并在用户激活“帐单地址”部分时显示不同的输入字段。*

展开和收起汉堡菜单和手风琴需要有有意义的可访问名称和动态状态（例如`<button aria-expanded="true">, <button aria-expanded="false">`）以使它们能用于屏幕读者用户。在编写手风琴和菜单时，开发人员需要为只能使用键盘的用户提供切换到手风琴或汉堡菜单的功能，并确保他们可以看到键盘焦点轮廓。

9. **假`<div>`按钮** -  Web开发人员通常会使用`<div>`和`<span>`元素来模拟按钮，因为这样可以使用CSS轻松设置样式。在原生应用程序中，当使用非按钮元素（如`<ImageView>`）来编写按钮，或者使用不是从原生按钮派生的自定义控件时，会出现模拟按钮问题。非标准按钮会导致严重的可访问性问题。当点击按钮时，它们可以工作正常，但对于键盘和屏幕阅读器来说它们是不可操作的。此外，模拟按钮也不会把自己正确地暴露给可访问性API。简单的解决办法就是使用真正的`<button>`而不是`<div>`。
10. **不支持的动态类型** - 创建应用时，支持动态类型非常重要。动态类型允许用户指定其首选字体大小（图3），这使视力不佳的用户可以轻松增加文本的大小。原生应用程序需要绑定到操作系统的大文本辅助功能API，以检查用户何时更改其文本大小首选项。然后，API将能够更新应用程序的文本以响应用户的新文本大小设置。当使用默认原生视图而不是自定义视图时，很容易支持动态类型。

![](https://p3.ssl.qhimg.com/t01bf5a63c7700666fd.png)
*图3：动态类型选项：动态类型允许用户指定其首选字体大小。此处针对iPhone显示的“更大文本”辅助功能设置也可用于Android，使视障用户可以轻松增加任何应用程序中文本的大小。*

11. **文本和背景之间的对比度差** - WCAG的色彩对比度要求尽量选择能够在内容和背景之间提供足够对比度的颜色，以便任何具有视力障碍和颜色缺陷的人都可以看到内容。WCAG 2.0 AA级要求普通文本的对比度为4.5:1，大文本的对比度为3:1。大文本可以具有较低的对比度，因为它的大小更容易阅读。许多网站和应用程序设计不符合WCAG对比度要求，例如，许多应用程序在白色背景上使用浅灰色文本，在白色上使用红色文本以显示错误消息，而非标准蓝色链接文本则不足以满足WCAG对普通文本的4.5:1的比率要求。输入占位符（请参阅上面的问题4）、表单错误消息、灰色页脚文本都是对比度失败的常见区域。设计人员需要确保移动网络和应用程序设计中使用的文本在根据文本背景进行测量时符合WCAG 2.0 AA级颜色对比度要求。
12. **WAI-ARIA使用不正确** - 可访问的富Internet应用程序（WAI-ARIA）定义了使残障人士更容易访问Web内容和Web应用程序的方法。它特别有助于使用了Ajax、HTML、JavaScript和相关技术开发的动态内容和高级用户界面控件。目前，某些残障用户无法使用网站中的某些功能，尤其是依赖屏幕阅读器和不能使用鼠标的用户。来自W3C Web可访问性计划的可访问的富Internet应用程序规范WAI-ARIA解决了这些可访问性挑战。解决这些挑战的一种方法是为辅助技术定义了新功能，通过WAI-ARIA，开发人员可以让高级Web应用程序也能供残障人士使用。但是，不正确的使用可能会产生意想不到的影响。可访问性很难自行理解，并且，开发人员在编码代码时，会经常不测试在屏幕阅读器上的效果；再加开发人员也并非透彻理解即庞大又复杂的WAI-ARIA规范，也缺少使用屏幕阅读器进行测试的经验，导致灾难经常出现。一个常见的问题是React模态对话框，将`aria-hidden=true`属性/值放在`<body>`标记上，这完全对屏幕阅读器用户隐藏了整个页面。浏览器和屏幕阅读器依据的是代码，而不是屏幕上的可见内容。因此，如果你的代码说使用`aria-hidden=true`来隐藏整个页面，那么屏幕阅读器就会看不到了。为了克服复杂应用程序的可访问性问题，开发人员对WAI-ARIA和可访问性的教育至关重要。使用屏幕阅读器测试你的代码，并通过自动可访问性测试工具（如aXe和[W3C的HTML5验证器](https://validator.w3.org/nu/#utm_source=microassist&utm_medium=mobilapps&utm_campaign=Pt2))运行下代码，有助于避免不正确使用WAI-ARIA时出现的许多问题。
13. **输入类型缺少移动键盘可用性增强功能** - 移动手机可以根据用户在其设备上键入的数据类型来显示不同的触摸屏键盘。例如，你想要用户输入电话号码，但是你却弹出完整的QWERTY键盘，那这就会出现明显的可用性问题。HTML5输入类型允许你为特定的数据类型显示更可用和更简化的键盘。开发人员需要为所需的输入指定正确的键盘类型。例如，在移动应用程序中包含表单输入字段时，请确保使用`<input type=tel, number, email, etc.>`，这可以让在移动设备的输入更轻松。从手机上访问Paul Adam的“[HTML5输入类型演示](http://pauljadam.com/demos/html5-input-types.html?utm_source=microassist&utm_medium=mobilapps&utm_campaign=Pt2)”，了解不同虚拟键盘的示例。

通过在开发期间避免这些常见的移动应用程序可访问性问题，你将给大家提供一个更易访问的产品。

## 测试移动辅助功能
基于[WebAIM屏幕阅读器用户偏好调查](http://webaim.org/projects/screenreadersurvey/#utm_source=microassist&utm_medium=mobilapps&utm_campaign=Pt2)，显然iOS和Android平台在用户群中占据主导地位。因此，在测试移动应用程序是否符合WCAG 2.0 AA时，可重点测试下iOS和Android平台。

为了帮助你在这些平台上进行测试，熟悉每个平台的内置辅助功能是非常有用的。此外，这两个平台都有功能齐全的屏幕阅读器可以帮助测试：Android上的Google TalkBack和iOS上的VoiceOver。这些功能与桌面屏幕阅读器的功能大致相同，只是它们主要使用触摸手势而不是按键组合。Apple的VoiceOver软件是内置在Mac和移动操作系统中的屏幕阅读器。当用户将手指放在图标和文本上时，这两个工具都会从移动屏幕上朗读信息（有关每个系统的屏幕阅读器的更多信息，请参阅第1部分中的“移动屏幕阅读器：iOS VoiceOver与Android TalkBack”）。

Apple和Android移动设备也可与蓝牙连接的盲文键盘配合使用。此外，Apple、Google Android和其他移动设备提供的“辅助触摸”应用程序，也可以帮助用户执行所需的某些手势，例如多指滑动。


### 简单的移动端QA测试流程
在Paul Adam的网站上列出了完整的[移动辅助功能QA测试清单](http://pauljadam.com/demos/mobilechecklist.html#utm_source=microassist&utm_medium=mobilapps&utm_campaign=Pt2)。但是呢，一个简单的可访问性质量保证测试过程是：
- 通过语义元素导航页面，比如使用VoiceOver Rotor、键盘导航、触摸浏览来选择元素并听其可访问性属性。相关平台、屏幕阅读器导航（包括VoiceOver Rotor）以及iOS和Android设备之间的键盘差异的比较，请参阅第1部分
- 使用Tab键盘、滑动和箭头键遍历所有元素，确保以合理的方式访问所有元素
- 将焦点设置到每个可聚焦元素上，验证屏幕阅读器是否读出了正确的可访问名称、角色、值和状态
- 仅使用屏幕阅读器激活所有动态控件
- 仅使用键盘激活所有动态控件
- 检查键盘焦点顺序和焦点可见性是否正确（这与屏幕阅读器焦点不同，因此请禁用屏幕阅读器）
- 在表单中输入空白和无效值，测试可访问性的错误验证。看提示的错误信息是否都能大声读出？


### Google辅助功能扫描程序
对于原生Android应用，通过从Play商店[下载谷歌的辅助功能扫描仪应用](https://play.google.com/store/apps/details?id=com.google.android.apps.accessibility.auditor&hl=en)，大家都可以直接在Android手机上进行辅助功能测试。

这个应用程序在手机上使用非常方便，可以测试任何原生应用程序的常见移动应用程序可访问性问题，诸如图标按钮缺少可访问名称、按钮太小（可能会导致无法轻松点击）、文本颜色对比度不足等（如图4）。同时，它也会列出解决这些问题的开发文档，也支持把问题列表发到指定邮箱。如果你有Android手机，那这是一款不错的免费辅助功能测试应用。

![](https://p3.ssl.qhimg.com/t01ee454b004d828cce.png)
*图4. Google Play的Android辅助功能扫描程序是一款强烈推荐的免费辅助功能测试应用程序。*

## 结论
移动可访问性很重要的原因是移动电话可以让人们访问世界范围内的商品和服务。移动网络和应用程序可以访问商业、通信、医疗保健和运输的各个方面，这些都是有合法访问性要求的重要服务，应该能供所有人从他的移动设备上使用和购买。此外，如果你的移动网站或应用程序无法访问，你可能会失去残障用户，也可能会失去非常庞大的老龄化人口，他们中的大多数随着年纪的增长会患有不同程度的残疾。这些用户有足够的资金，并且越来熟练地使用网络和移动应用程序来满足自己、亲人和企业的各种需求。然而，无法访问的网站或应用程序会导致糟糕的用户体验，进而阻止他们使用。

要创建一个让每个人都受益的可访问体验，请务必解决此处列出的13个常见移动应用程序可访问性问题，并在软件开发的生命周期里定期测试你的应用程序。在应用程序创建的各个阶段，诸如需求评审、设计、开发和测试阶段，引入可访问性。此外，在你的应用里使用的所有第三方平台的合同中，明确指出可访问性需求，例如满足WCAG 2.0 AA级标准。


如果开发人员和质量保证人员有适当的可访问性测试工具、检查清单和培训文档，最常见的移动端可访问性问题是很容易发现和测试的。让开发人员和设计师负责可访问性测试，让他们能够在所有项目中集成可访问性（也许先和他们分享下这个文档~！）。最后，避免在项目结束时才开始考虑可访问性，通常情况下，在发布前进行必要的更改既晚又贵。


## 更多

- [第1部分：移动应用程序可访问性的关键开发注意事项](https://www.microassist.com/digital-accessibility/mobile-application-accessibility-part-1-of-2/#utm_source=microassist&utm_medium=mobilapps&utm_campaign=Pt2)
- [移动辅助功能QA测试清单](http://pauljadam.com/demos/mobilechecklist.html#utm_source=microassist&utm_medium=mobilapps&utm_campaign=Pt2)
- [移动无障碍功能：WCAG 2.0 和其他 W3C/WAI 指南如何应用于移动](https://www.w3.org/TR/mobile-accessibility-mapping/)
- [网站无障碍诉讼：企业需要知道什么](https://www.microassist.com/digital-accessibility/accessibility-litigation-factors/)
