# 如何测试网站的可访问性

站在 Web 开发的角度，一提到网站的可访问性，可能大部分人最想知道的就是：如何评判一个网站的可访问性的好坏？是否有自动化的检测工具可用，可以很直接地指出问题所在和改进策略？

本篇文章就来聊聊这个话题，主要包括：
1. 自动化测试工具
2. 手动测试的方法和工具
3. 可访问性需要覆盖的特性列表

## 一、自动化测试工具
比较常用的四个工具：
- [axe-core](https://github.com/dequelabs/axe-core) 是一个用于测试 Web UI 可访问性的引擎。可以将它合并到自动化测试套件中，在命令行中运行
- 浏览器扩展 [aXe](https://chrome.google.com/webstore/detail/axe/lhdoppojpmngadmnindnejefpokejbdd?utm_source=chrome-ntp-icon) 或者 [WAVE](https://chrome.google.com/webstore/detail/wave-evaluation-tool/jbbplnpkjmmeebjpijfedlgcdilocofh?utm_source=chrome-ntp-icon)
- Chrome 插件 [Lighthouse](https://chrome.google.com/webstore/detail/lighthouse/blipmdconlkpinefehnmjammfjpmpbjk?utm_source=chrome-ntp-icon)，它内置了 axe-core，也能提供可访问性检测
- Chrome 开发者工具里也内置了可访问性检测，见 Audits 面板（它内置了 Lighthouse）

我们就以 Chrome 开发者工具里的 Audits 面板为例，看看自动化检测工具都提供了哪些功能。

下图是 Audits 面板：

![Audits面板](https://p3.ssl.qhimg.com/t018bf6986a507884d1.png)

用它检测[360课程培训](https://www.so.com/zt/training.html#/?q=%E4%BC%9A%E8%AE%A1&srcg=a11y)页面，审计结果如下：

![](https://p0.ssl.qhimg.com/t01027d5fd11e5b04f0.png)

结果涵盖了以下五个方面：
1. 对比度
2. 表单控件的名字和标签
3. 需要手动检查的项目
4. 通过的测试项
5. 未应用到的项

### 1. 对比度
对比度属于可阅读范畴，检测结果显示“背景色和前景色没有足够的对比度”（点击[文本元素必须与背景有足够的颜色对比度](https://dequeuniversity.com/rules/axe/3.3/color-contrast)查看更多）。

![1/5.Contrast](https://p5.ssl.qhimg.com/t01c928d1d09a126888.png)

呃，修改这个...似乎有点难度，因为绿白是360搜索的主题配色。那有没有什么“曲线救国”的方式呢？答案是有的，高对比度模式。至少我们可以做到，在开启高对比度模式的时候，页面 UI 仍然是可见&可用的。比如安装了 Chrome 插件[高对比度模式](https://chrome.google.com/webstore/detail/high-contrast/djcfdncoelnlbldjfhinnjlhdjlikmph)，开启“增加对比度”后，页面长这个样子：

![](https://p1.ssl.qhimg.com/t01824b45bd1553ec4e.png)
![](https://p2.ssl.qhimg.com/t01d8209b6a56659b09.png)

大家也可以尝试其它选项，比如翻转颜色。高对比度模式，可以开启操作系统级别的，也可以开启应用程序级别的。

### 2. 表单控件的名字和标签
检测结果显示“表单元素没有关联的标签”（点击 [input 元素必须要有标签](https://dequeuniversity.com/rules/axe/3.3/label)查看更多）。
![2/5.names and labels](https://p3.ssl.qhimg.com/t01cfe3f92a63dd860e.png)

一般情况，表单控件需要有以下信息：
- `Role` 角色，比如是编辑文本、单选框、复选框、还是按钮
- `Name/Label` 名字，用来说明字段的含义。比如要输入的是“姓名”，还是“城市名”；要选择的是“性别”还是“日期”
- `State` 状态，比如下拉框是否展开，单选框或多选框的选项是否被选中
- `Value` 值

这些信息都会传给无障碍树，以方便辅助技术更好地“理解”页面。无障碍树类似 DOM 树，只是 DOM 树是给网页的渲染引擎用的，而无障碍树是给辅助技术用的。比如，下图就是一个简化版的无障碍树。

![无障碍树](https://p4.ssl.qhimg.com/t0164ca95f9c119bb62.jpg)

### 3. 需要手动检查的项目
自动化检测的 cases 覆盖不全可访问性的所有特性，需要我们手动测试。包括：键盘焦点的顺序是否合理、可交互元素是否易于理解、是否有键盘陷阱、自定义组件是否也易于理解和使用等等。详见下图。
![3/5.manually](https://p3.ssl.qhimg.com/t013231e4513187987b.png)

机器的自动化检测有覆盖不到的情况，也不难理解，毕竟“可访问性”本身就是为了方便“人”使用。需要手动检查的项目，我们在第二小节中介绍。


### 4. 通过的测试项
通过的测试项，包括：按钮有可访问的名字、文档有标题、id 唯一、图片有`alt`属性等等。详见下图。
![4/5.passed](https://p0.ssl.qhimg.com/t018f27b5a8522c0dcd.png)

### 5. 未应用到的项
![5/5.not applicable](https://p0.ssl.qhimg.com/t012de04e6aa85262c5.png)

自动化工具只能检测可访问性问题的子集，因此手工测试必不可少。

## 二、手动测试的方法和工具
关于手动测试，重点和大家分享三点：键盘的可访问性、屏幕阅读器、缩放功能。

### 键盘的可访问性
重点关注页面上的所有可交互元素，须同时满足以下两点：
- 元素可被选中，当按`Tab`键时
- 元素可交互，当按`Enter`/`空格`/`箭头键`/`Esc`键时

我们继续以[360课程培训](https://www.so.com/zt/training.html#/?q=%E4%BC%9A%E8%AE%A1&srcg=a11y)为例，下面是手动测试的结果：

页面| 可交互的元素 | `Tab`键可被选中 | 可交互 | 说明
---|-----------|----------------|--------|-----
头部| logo   | 通过 | 通过 | 按`Enter`跳转至列表页 
&nbsp;| input 框 | 通过 | 通过  | 按`Enter`可执行搜索
&nbsp;| “搜一下”按钮 | 通过 | 通过  | 按`Enter`可执行搜索
筛选区| 课程 | 通过 | 不通过 | 1. 按`Enter`键，打开弹层<br/>2. 按`方向键`，在弹层里选择元素<br/>3. 按`Esc`键，关闭弹层
&nbsp;| 形式 | 通过 | 通过 80% | 按`Enter`可进行筛选<br/><br/>可优化为：<br/>1. 按`Tab`进入下一个筛选项“级别”<br/>2. 按`Tab`+`Shift`进入上一个筛选项<br/>3. 按`箭头键`可在本层内的选项前后移动“不限/线上/线下”<br/>4. 按`空格`键可触发筛选交互
&nbsp;| 级别/设置/周期 | 同上
&nbsp;| 已选条件 | 通过 | 通过 10% | 1. 按`Enter`键重新筛选<br/>2. 但此时，键盘焦点丢失
列表区 | 图像/标题/按钮 | 通过 | 通过 | 按`Enter`跳转至其它页面
翻页区 | 按钮 | 通过 | 通过 80% | 1. 按`Enter`触发翻页<br/>2. 按`Tab`进行下一项<br/>3. 按`Tab`+`Shift`进入上一项<br/>同理，可优化成“形式”的交互

### 屏幕阅读器
操作系统都有自带的屏幕阅读器，我们就直接用它了。比如 Mac 上的 [VoiceOver](https://webaim.org/articles/voiceover/)，在“系统偏好设置/辅助功能/VoiceOver” 中启用它。
![](https://p2.ssl.qhimg.com/t012a95311ac2712bbe.png)

首先简单介绍下它的键盘操作，更多信息可查看上面截图里的“使用指南”。
- 在运行 VoiceOver 时，普通的键盘操作保持不变。比如`TAB` `Shift+TAB` `箭头键` `空格键` `Enter`等
- `CMD+L` 跳到地址栏，可输入URL
- `CTRL+Option+U`：打开 Web Router，即导航面板
- 在打开 Web Router 的情况下：
    - `CTRL + Option + ← ↑ ↓ →`：浏览内容
    - `CTRL + Option + CMD + H`：逐个标题向前移动
    - `CTRL + Option + CMD + H + Shift`：逐个标题向后移动

本次重点和大家分享下它的 Web Router，即导航面板。它主要有四种导航形式：按标题导航、按页面结构导航、按表单元素导航、按链接导航。

以下是[360课程培训](https://www.so.com/zt/training.html#/?q=%E4%BC%9A%E8%AE%A1&srcg=a11y)页面上四种导航的截图：

按标题 | 按页面结构 | 按表单控件  | 按链接 
:----:|:--------:|:---------:|:---------:|
![](https://p3.ssl.qhimg.com/t01ed6a3f016858ce38.jpg)| ![](https://p4.ssl.qhimg.com/t01b3ab3ca1429781a9.jpg) | ![](https://p2.ssl.qhimg.com/t017f9e6cff89fac293.jpg) | ![](https://p5.ssl.qhimg.com/t01ac8d8f986befa32f.jpg)<br/>![](https://p4.ssl.qhimg.com/t01a845010d6d7006fd.jpg)

我们发现，导航信息还是有一些不足的。比如：
- 按“页面结构”导航时，信息有点单薄。比如我想告诉屏幕阅读器用户，页面有搜索区域、筛选区域、列表区域和翻页区域
- 按“页面结构”导航时，有混入不恰当的信息。比如“导航”，它其实是按钮式的翻页区域
- 按“表单空间”导航时，不够全面。页面应该告诉用户还有个“筛选”区
- 按“链接”导航时，呃...里面就有点一言难尽了。因为它混入了“筛选”区的表单信息，也混入了“翻页”区的按钮区

当用户第一次登录他们不熟悉的页面时，更倾向于用标题导航和页面结构导航；当他们熟悉了之后，按表单控件和按链接导航有利于提高他们的导航效率。

### 缩放功能
对于视觉障碍的用户，有时需要使用放大镜来阅读页面。这里介绍两种：
- 页面缩放：浏览器自带的缩放功能
- 设置大字体：浏览器里设置字号。比如`chrome://settings/`里的字号可以设置“特小、小、中、大、特大”

[360课程培训](https://www.so.com/zt/training.html#/?q=%E4%BC%9A%E8%AE%A1&srcg=a11y)网站是支持页面缩放的，感兴趣的小伙伴可以在线试用。


## 三、可访问性需要覆盖的特性列表
现在，我们对网站的可访问性有了更具象的认识。良好的页面可访问性，需要（至少）涵盖以下特性：
- 足够的对比度
- 表单控件需要有角色、名字或标签、状态
- 良好的键盘可访问性：所有可交互的元素可被键盘选中、可与键盘交互；不可交互的元素可以不被聚焦
- 使用恰当的标题和链接、良好的页面结构
- 页面支持缩放

## 总结
本文主要讲了两部分，第一部分是可访问性的自动化测试工具，重点介绍了 Chrome 开发者工具的 Audits 面板；第二部分是手动测试网站的可访问性，包括键盘可访问性、屏幕阅读器的导航、页面缩放。

虽然自动化工具只测试了可访问性特性的一个子集，但它能帮助我们检测很多琐碎的细节，同时它也给出了非常全面的参考信息，里面的“learn more”链接非常贴心。

键盘可访问性和页面缩放，功能比较直观，理解起来也没有歧义，这部分完全可以通过 Web 开发人员的自测满足，测试量也不大。

让屏幕阅读器提供精简、准确的信息也是非常重要的，但这部分需要我们结合着屏幕阅读器的使用再进一步细化。

## 下一步
本文里其实已经暴露出了几个可访问性问题了，诸如已选条件的bug、自定义下拉框/弹层的键盘可访问性、屏幕阅读器导航信息不精准。这些需要通过 HTML 语义化和 ARIA 技术来解决，如何修复这些问题，咱们下回见~！

## 主要参考
https://developers.google.com/web/fundamentals/accessibility/
