## 文件上传漏洞及危害

文件上传漏洞是指网络攻击者上传了一个可执行的文件到服务器上，当开发者没有对该文件进行合理的校验及处理的时候，很有可能让程序执行这个上传文件导致安全漏洞。大部分网站都会有文件上传的功能，例如头像、图片、视频等，这块的逻辑如果处理不当，很容易触发服务器漏洞。这种漏洞在以文件名为 URL 特征的程序中比较多见。嗯，是的说的就是世界上最好的语言 PHP。例如用户上传了一个 PHP 文件，拿到对应文件的地址之后就可以执行它了，其中的危害自然不言而喻。那在 Node.js 中就没有文件上传漏洞了么？答案肯定是否的。除了可执行文件外，还有以下几个潜在的问题。

### 文件名

用户上传的文件里有两个东西经常会被程序使用，一个是文件本身，还有一个就是文件名了。如果文件名被用来读取或者存储内容，那么你就要小心了。攻击者很有可能会构造一个类似 `../../../attack.jpg` 的文件名，如果程序没有注意直接使用的话很有可能就把服务器的关键文件覆盖导致程序崩溃，甚至更有可能直接将 `/etc/passwd` 覆盖写上攻击者指定的密码从而攻破服务器。

有些同学可能会说了，`/` 等字符是文件名非法字符，用户是定义不了这种名字的。你说的没错，但是我们要知道我们并不是直接和用户的文件进行交互的，而是通过 HTTP 请求拿到用户的文件。在 HTTP 表单上传请求中，文件名是作为字符串存储的。只要是合法的 HTTP 请求格式，攻击者可以构造请求中的任何内容用于提交给服务器。

```
POST /upload HTTP/1.1
Host: test.com
Connection: keep-alive
Content-Length: 4237161
Accept: */*
Origin: http://test.com
User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/75.0.3770.100 Safari/537.36
Content-Type: multipart/form-data; boundary=----WebKitFormBoundary9pQqgBGwpDfftP8l
Referer: http://test.com
Accept-Encoding: gzip, deflate
Accept-Language: en,zh-CN;q=0.9,zh;q=0.8,zh-TW;q=0.7,da;q=0.6

------WebKitFormBoundary9pQqgBGwpDfftP8l
Content-Disposition: form-data; name="file"; filename="../../attack.jpg"
Content-Type: image/jpeg

------WebKitFormBoundary9pQqgBGwpDfftP8l--
```

### HTML 和 SVG

虽然说 Node.js 在文件上传服务端可执行程序的漏洞没有 PHP 那么高，但是除了服务端可执行之外我们还有客户端可执行问题，所以还是要做好防备。假设用户可以上传任意格式的文件，而如果攻击者上传了 HTML 文件后可以配合 CSRF 攻击进一步制造 XSS 攻击。

如果你是一个图片上传的接口，如果你仅限制 HTML 格式的话也存在问题，因为图片中有一种特别的存在是 SVG 格式。SVG 是一种矢量图形格式，它使用 XML 来描述图片，在其内部我们是可以插入 `<html>`, `<style>`, `<script>` 等 DOM 标签的。如果不对 SVG 中的文件内容进行过滤的话，也会发生意想不到的效果。

```svg
<svg viewBox="0 0 100 100" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <script>alert(111)</script>
    <rect x="25" y="25" width="50" height="50" />
</svg>
```

### 软链

我们知道在操作系统中软链本质上也是一种文件，只是这个文件中不包含实际的内容，它包含另外一个文件的路径名。可以是任意文件或目录，可以链接不同文件系统的文件。如果攻击者上传了一个软链文件，软链描述对应的是 `/etc/passwd` 的话，攻击者利用程序可以直接读取到服务器的关键文件内容，导致服务器被攻陷。

### 服务器磁盘

除了文件本身的问题之外，还有一种情况我们需要考虑到的是文件上传之后的处理。如果我们将用户上传的文件存储到了本地，而没有限制用户的上传频率的话，就很有可能被攻击者利用。攻击者会频繁的上传文件导致服务器磁盘占用 100%，撑爆服务器之后没办法处理程序的其它任务进而导致服务器宕机。

## 防御方法

针对以上几个可能出现的漏洞场景，我们需要做到以下几点：

1. 对用户传入的文件名在使用的时候尽量进行白名单过滤，可以的话尽量不要使用用户传入文件名，杜绝从文件名上导致的安全漏洞。
1. 对文件内容本身做好格式验证，黑名单或者白名单的方式都可以，不过白名单的方式安全性会更高一点。文件格式不能简单的判断文件后缀或者是表单上传时带有的 `Content-Type` 字段，因为这两个是用户上传内容，都是可被构造的。最好是通过文件头的魔术数字来读取，配合白名单列表就能避免这方面的问题。比较著名的使用魔术数字来判断文件类型的模块是 [https://github.com/sindresorhus/file-type](https://github.com/sindresorhus/file-type)，推荐直接使用。
1. 如果允许用户上传 `.svg` 格式图片的话，需要针对 SVG 内容进行 HTML 解析，过滤掉 `<script>`, `<foreignObject>` 等相关标签。当然，使用白名单的话是最好不过的了。这里提供一个比较全的 [SVG 合法标签白名单列表](https://gist.github.com/lizheming/1b69b00d8575047b0b9b4a0f739ee0b4)。

需要额外提醒的是，如果用户上传的压缩包，程序有解压的行为，那么不仅要按照上述规则校验压缩包本身，还需要按照相同的逻辑校验解压之后的所有内容。同时针对服务器磁盘被撑爆的情况，推荐限制用户的上传频率降低风险，同时增加磁盘监控告警实时关注线上服务器的状态。如果存储到本地不是必须的话也可以使用外部存储服务来降低服务器这块的风险。
