# CSS Color Adjust 速览

近来，各大平台的操作系统纷纷引入 Dark Mode 深色模式，包括 Windows、MacOS 以及 Android 甚至 iOS 13 也将引入该模式。深色模式引入的同时，同时允许我们基于用户的偏好设计特定的样式。

近期，W3C CSS 工作组发布了 CSS Color Adjust Level 1 编辑草案，也是第一版公开的工作组草案。该标准引入三个新的 CSS 属性，帮助为浏览器提供特定信息，决定浏览器在基于用户的色彩偏好时能对页面展现做出多少的改动。

## color-scheme

`color-scheme`属性是标准中定义的第一个属性，同时也是本标准的中心。这个属性接受两个属性值：`light`和`dark`，如字面它们分别指代了亮色模式和深色模式。

这个属性有着一些非常重要的作用。

其中一个重要的作用是允许我们基于用户的系统偏好设定样式，对体验上做一些更完整的把控；另一个重要的作用是可以让浏览器负责去确定一些元素的颜色，当我们设定 `color-scheme`为 `light` 或 `dark` 时，告知浏览器，这个元素是可以"适应"特定配色设定的，同时可以根据设定的偏好由浏览器决定该元素的样式。另外，也可以使用`auto`属性值，让浏览器基于用户的系统偏好做相应的设置。

值得一题的是，使用 `prefers-color-scheme` 这个媒体查询，让开发者知道当前系统的偏好设置，并应用对应的样式。

#### only 属性值

only 属性值后面必须跟着一个样式属性值，例如  `only && light` ，告知浏览器必须使用指定的色彩配置渲染，即使用户指定了其他的色彩配置。

### forced-color-adjust

当该属性值设定为 `none` 时，可以将指定元素的样式控制从浏览器转交回 CSS 中，从而允许元素不受 `color-scheme` 指定的数值所影响。

### color-adjust

在大多数显示设备上，对于页面上使用何种颜色，对于显示设备来说都是没有区别的。但是在某些情况下，例如打印机，打印机通常在白纸上使用黑色墨水打印文档，但如果打印一份以黑色背景为主的文档来说，就显得非常的浪费。

在这种情况下，更希望浏览器根据实际输出设备对输出的样式进行适当的调整。要达到这个目的，可以使用 `color-adjust` 属性。

它有两个属性值，`economy` 以及 `exact`：`economy` 表示需要根据目标设备的情况做相应的更改，以符合最佳的使用效果。`exact` 则表示保留原有样式不需要更改。

### 小结

虽然该草案比较简单，但是也能让我们看到 W3C 成员们在更好的 web 体验上所作出的贡献。

### 参考

https://css-tricks.com/a-quick-look-at-the-first-public-working-draft-for-color-adjust-module-1/

https://www.w3.org/TR/2019/WD-css-color-adjust-1-20190521/

