![](https://p1.ssl.qhimg.com/t014f7bfe0040406ac1.png)

### 引子

2019 年 5 月 20 日，科技界最火爆的消息莫过于[谷歌暂停支持华为部分业务](http://www.xinhuanet.com/tech/2019-05/20/c_1124519710.htm)。关于这个事件将产生的影响，大家可以从相关的科技媒体上找到详细的分析。比较一致的看法是：谷歌的这个做法，对于国内的华为用户，影响不大；对于海外的华为用户，尤其是在上游应用生态环境上，会有一定的影响。

这是由于，谷歌暂停合作的服务，都是在用户空间的服务。用户空间与安卓底层内核遵从不同的协议，因此不必开源，进而导致替换成本高企。基于现有生态，在海外市场构建应用生态环境难度非常大。

这篇文章将尝试从这则新闻涉及的开源协议来分析一下，这个做法背后相关的逻辑，并籍此，跟各位读者聊一聊主流的开源协议。

<!--more-->

### 安卓与开源协议

开源软件或称自由软件是自由获取，源代码开放的，人们可以自由地获取和使用这些软件。同时，为了维护开发者和贡献者的合法权利，使得软件能够更好的被使用并不影响软件的正常发展，开源社区开发出了各种开源协议。软件开发者可以根据软件的属性和自身需要的权责主张选择合适的开源协议；下载并使用这些软件的用户，原则上，要求遵守开源协议的要求。

众所周知，安卓系统是基于 Linux 的。而 Linux 本身是基于 GPL(GNU General Public License)v2 开源协议的。GPL 协议规定，只要这种程序在整体上或者其某个部分来源于遵循 GPL 的程序，该程序的整体就必须按照 GPL 流通，不仅源码必须向社会公开，而且对于这种程序的流通不准许附加修改者自己作出的限制。

用通俗的语言来讲，只要一个软件使用了采用 GPL 开源协议的开源软件，则在分发、传播、发布过程中，必须一并开放源代码。则这个软件也就成为了 GPL 开源协议的软件。这被称为 GPL 协议的“传染性”。

笔者曾经研究过一个开源的位图轮廓矢量化算法名曰：[Potrace](http://potrace.sourceforge.net)。因为高效的算法被广泛采用。由于其创始人使用 GPL 协议，因此，所有基于此算法的软件，也都清一色的使用了 GPL 协议。

按照这个逻辑，基于 Linux 的安卓，也应该开源所有的技术代码，即遵循 GPLv2 协议。然而，这在现实中并没有发生，原因是安卓系统本身并不是遵循 GPL 协议的，而是采用了对商业友好的 APL(Apache Software License)。该协议不强制要求后续代码开源，也为安卓上层软件、驱动等商业活动打好了基础。

那么现在问题变成了，为什么基于 GPL 协议的软件开发的安卓可以采用 APL 呢？说好的“传染性”呢？

首先说明，“传染性”的边界在哪？Linux 内核的作者 Linus 以及内核开发人员多次强调普通系统调用为不是 GPL 的作用范围。大家在 Linux 内核的源码 COPYING 文档中也可以找到[这些文字](https://github.com/torvalds/linux/blob/master/LICENSES/exceptions/Linux-syscall-note)。这些为 Linux 用户空间的程序采用非 GPL 的授权许可证打好了基础。

![](https://p3.ssl.qhimg.com/t01c480a7f432df6e9c.jpg)

好的，既然系统调用可以不是 GPL 的管辖范围。这里面谷歌做了一件事情，就是把原来在内核层的驱动剥离出来，在内核中留有调用接口。并把驱动等部分提升到用户空间，形成 HAL(Hardware Abstraction Layer)。一方面起到了对硬件驱动层进行抽象，防止有问题的驱动对于内核的影响，同时也把 GPL 的影响控制在“内核层”。

![](https://p1.ssl.qhimg.com/t01722fb014602270c5.png)

上图是 [Openfoundry](http://www.openfoundry.org/)绘制的安卓授权许可证结构。仅仅内核部分使用了 GPL2.0。因此，构建在用户空间上的应用由于遵从的 APL 协议，不强制要求开源，避免了商业软件和 GPL 中开源要求的冲突。

这次谷歌对华为暂停合作的软件正位于用户空间，如 GMail，Google Map，Youtube，更新推送等。

由于中国用户对这些应用以及底层服务没有很强的依赖，而且国内的安卓在用户空间这一层已经有很强的用户生态，故而问题不大。

而对于境外用户，由于用户对这些应用已经极为依赖，另外，当地的应用也或多或少地依赖这些底层服务，同时国内的应用尚且没有在境外有充分的布局。因此，目前的状况，会使得后续境外的华为用户，无软件可用。

那么，能否重建境外的软件生态呢？答案是并不容易。

一方面，这些软件并不开源，无法从源代码找到软件运作逻辑。另一方面，即便按照黑盒方式构建出类似软件，也有法律和信任方面的问题。总而言之，这不是单纯的技术问题。

因此，笔者谨慎的推测，华为如果决定在海外挽回移动市场份额，推广自主操作系统、重建软件生态、打破垄断的局面，将是一件非常艰苦的任务，而且真的需要各方面的通力配合。不光要靠华为的努力，也需要生态链上的企业共同努力。

同时，对于依赖于闭源的操作系统的服务和软件，同样有被釜底抽薪的概率，虽然这种情况出现的概率极低，但是风险的规模也注定和企业自身的体量正相关。

### 常见的开源许可

除了上面提到的 GPL、APL 等，还有一些常见的开源协议。当我们进行软件开发和使用其他开源软件时候，毋需以审慎的态度对待。随着国内对知识产权保护的认识逐渐提高，保护越来越严格，这方面的风险是每一个软件作者需要考虑到的，如果选择了一个开源协议的软件，需要对相应的权责作出响应，否则可能会承担法律的风险。当然，除了义务，也有对于免责的声明，比如 MIT 协议：由于使用此软件造成的问题，作者可以不负责。

阮一峰老师在[这篇文章](http://www.ruanyifeng.com/blog/2011/05/how_to_choose_free_software_licenses.html)翻译并解释了 Paul Bagwell 对这些开源协议的选择逻辑。

![](https://p4.ssl.qhimg.com/t01721147a082455164.png)

这里面，NodeJS 中的 ISC 协议近乎等于 BSD 协议。

对于更复杂的情况 网友[phodal](https://github.com/phodal)总结了更多的情况：

![](https://s3.ssl.qhres.com/static/a2e1faf3947c5f06.svg)

还有一个来自于<!--begin sup text-->GcsSloop 博文中基于场景的选择图<!--end sup text-->[GcsSloop 博文中基于场景的选择图](https://www.gcssloop.com/tips/choose-license)

可以根据编写时候的场景进行选择：

![](https://p1.ssl.qhimg.com/t017cc8350408e5ae73.png)

[这个网站](https://spdx.org/licenses/)总结了主流的开源协议。有一个帮助你选择开源协议的[网站](https://choosealicense.com/)，供大家参考。

下面列出了主流的开源协议的权责义务：

![](https://p0.ssl.qhimg.com/t01542d1d3e04ec7dd8.png)

主流的开源软件的选择，也许是我们的一个参考，下面的表中列出了一些流行软件的开源许可。供大家参考。

| 协议 | 软件                             |
| ---- | -------------------------------- |
| MIT  | babel、.net core、rails、ThinkJS |
| GPL  | Bash、GIMP、Potrace              |
| APL  | AOSP                             |

### 许可覆盖

大家在接触 NodeJS 开发时候，使用 npm 初始一个软件的时候，lisence 默认是 ISC。这也导致了更多的 NodeJS 软件是使用 ISC 这个开源协议，或者更进一步选择更为宽松的 MIT 协议。由于这都是比较宽松的协议，如果底层依赖或者想法借鉴了更为严格的协议软件。这个协议就是不合适的，因为阻断了开源协议的约束传播，就像你把一个类的 Private 属性变成了 Public，基于此构建的软件也会忽视掉底层的协议。对于此，尤其是做类库的开发者更需要注意。

### 附录：近期关于 lisence 的一些热点事件

1. Facebook 围绕 React Native 的 BSD+Patents 协议的争端
2. Redis Modules 变更许可证
3. MongoDB 协议更改
4. Oracle JDK 11 改用商用协议
