# 无障碍 Web
“Accessibility”，在 Web 发展的初期，人们习惯把它翻译成“无障碍”，因为它主要考虑如何让残障人士更容易地访问 Web 内容。诸如有行动障碍的人难以完成需要用鼠标进行的精确手部动作，他们更多的需要靠键盘；有视觉障碍的人（低视力、色盲、失明）需要使用屏幕放大镜（物理放大镜、网页的缩放功能、网页设置大字体）或屏幕阅读器来浏览网页内容；有听觉障碍的人需要靠阅读文本来替代音频和视频；有认知障碍的人需要网页本身尽可能地简单清晰、符合逻辑。

如今，访问 Web 的场景、设备和人群越来越多样化，Accessibility 已不再局限于满足残疾人的需求，它也涵盖了在特定场景下的网站可用性，比如移动设备、弱网环境、忘带鼠标、触摸板坏掉了、老年人访问等等。

当然，你也可以把 Accessibility 理解为平等地对待每一个人，无论对方的能力和环境如何，都给他们平等的机会。

所以，我要把文章的题目从《无障碍 Web》改成《有良好访问性的 Web》。

> 标题党？呃...有点，但也不全是。更多的是想方便大家理解的有意为之。

# 有良好访问性的 Web

良好的 Web 可访问性，就是把你的网站建设成让尽可能多的人都觉得好用，可以让每一个人受益。

## HTML 语义化
之前，我对 HTML 语义化的理解，更多地是局限在代码的良好可读性，以及即使是在 [CSS 裸奔节](https://css-naked-day.github.io/)的时候，网页也能良好显示。后来才发现，语义化 HTML 也是确保 Web 良好访问性的关键。

先和大家分享五个实例。

### 页面的内容结构

曾经，对于文本，我得意于少写标签，觉得精简了好呀。比如我会这么写：
```html
<h2>静夜思</h2>
[唐] 李白
<!-- 上下若有留白，则用此 div 撑开 -->
<div>
    床前明月光，疑是地上霜。<br/>
    举头望明月，低头思故乡。
</div>
<!--
    不要父容器，标签们全是有效内容。
    链接排排放，更宽的间距用 &nbsp; 来撑开
-->
<a href="#">译文</a> &nbsp; <a href="#">注释</a> &nbsp; <a href="#">作者介绍</a>
```
殊不知，这样非常不利于屏幕阅读器。其实应该让标题、段落、列表等各司其职，让整个页面内容结构清晰，比如：
```html
<article>
    <h2>静夜思</h2>
    <p>[唐] 李白</p>
    <div>
        床前明月光，疑是地上霜。<br/>
        举头望明月，低头思故乡。
    </div>
    <ul>
        <li><a href="#">译文</a></li>
        <li><a href="#">注释</a></li>
        <li><a href="#">作者介绍</a></li>
    </ul>
</article>
```

大家可以打开电脑上的屏幕阅读器，亲自感受下内容结构是否清晰对可访问性的影响：[好的语义](https://mdn.github.io/learning-area/accessibility/html/good-semantics.html) vs [不好的语义](https://mdn.github.io/learning-area/accessibility/html/bad-semantics.html)。

你会发现，当是不好的语义时，屏幕阅读器会一次性读出所有的内容；当是好的语义时，屏幕阅读器会：
- 在你浏览内容时，读取每个标题，通知标题是什么，段落是什么等
- 它会在每个元素之后停止，让你有个短暂的停歇
- 你可以跳转到上一个/下一个标题
- ...等


### 简写和缩写
之前，为了看起来清晰，我会不经意在文本里直接写符号 “+” “/” 来表示“和” “或”。比如“根据固有尺寸 + 指定大小 + 默认对象大小，计算具体对象大小”、“指定大小 > 固有尺寸 > 默认对象大小”（摘自[《CSS 是怎样确定图像大小的？》](https://github.com/anjia/blog/issues/44)），比如“当你发现一个好玩/有趣/有价值/有意义的 Web 新特性时”、“视频+PPT”（摘自[《TPAC 2018 参会总结》](https://github.com/anjia/blog/issues/28)）。

殊不知，我破坏了 Web 的可访问性，由于我用了不清晰的语言。以上书写方式（“+” “/” “>”等）会让屏幕阅读器读出来的内容不利于人理解，我应该直接用对应的汉字来表述。

除此之外，“5-10年”应该写成“5到10年”；初次出现的缩写，应该在 HTML 里也写个全称，比如`<abbr title="HyperText Markup Language">HTML</abbr>`，这会有助于屏幕阅读器提取其它辅助信息。

### form 表单
之前，看到下面的代码，我会觉得 HTML 写的好繁琐哦。诸如 `<label>` 标签有点多余；给 `<input>` 写的 `id` 又不会在 CSS 和 JS 里使用，写它是不是有点浪费了。

```html
<form>
    <div>
        <label for="name">姓名：</label>
        <input type="text" id="name" name="name">
    </div>
    <div>
        <label for="age">年龄：</label>
        <input type="text" id="age" name="age">
    </div>
    <div>
        <label for="gender">性别：</label>
        <select id="gender" name="gender">
            <option>男</option>
            <option>女</option>
        </select>
    </div>
</form>
```

殊不知，是我忽略了它们对可访问性的友好作用：`<label>` 标签可以让提示文本和输入框完美的对应起来，还可以扩大激活输入框的范围，方便用户选择和输入。


### 键盘可访问性
键盘可访问包括按 tab 键能让页面中的元素获得焦点、按 Return/Enter 键能激活该元素、表单元素`<select>`在获得焦点时按方向键可以上下切换选项。自带键盘可访问性的标签有`<a>`、`<button>`、`<label>`以及表单元素。

之前，我还会暗暗窃喜自己在 HTML 里主动设置了 `tabindex`，确保了键盘的可访问性。殊不知，其实如果 HTML 标签选择得当、源码里标签的放置顺序本身就和页面中想导航元素的顺序一致，大多数情况下就可以避免手动设置 `tabindex` 属性了。

此外，配合`<label>`标签和表单元素，既可以轻松自定义元素样式，又能不破坏它们自带的键盘可访问性，还是很方便的。


### alt 属性
以前，知道图片的 `alt` 属性可以在图片加载失败的时候显示出来，以让用户知道挂掉的图片是什么，却不知道应该把它写的友好一点。比如下面这张图：
![](https://mdn.mozillademos.org/files/14333/title-attribute.png)

它对应的 HTML代码如下。之前肯定不会这么写 `alt` 的，一是考虑到它太长了万一要显示出来，不好看；二是...呃，就没想到还可以写这么详细。
```html
<img src="dinosaur.png"
     alt="红色霸王龙：一种双腿恐龙，像人一样直立，有小胳膊，头部有很多锋利的牙齿。"
     title="The Mozilla red dinosaur">
```

其实，上面书写`<img>`的方式，对屏幕阅读器是非常友好的。屏幕阅读器能识别`<img>`，但它不会描述图像，它只会简单地说一句“图像”。当`<img>`标签里没有设置`alt`属性时，屏幕阅读器会读出`src`属性的值，以尽量提供点有效信息。但是大部分情况下，网页中的图片 url 里是没有图片的相关信息的，比如用手机或者相机拍的照片。所以设置有效的`alt`属性，就显得很有意义了。

如果图片是内容性的，则需要我们写有意义的 `alt` 属性，尽量能提供图片在视觉上要传达的内容；如果图片是纯装饰性的，则可以把`alt`属性设置成空，或者直接用 CSS 渲染图片。

> 关于图片的文本替代方案，还可以用 ARIA 技术，这能覆盖更多的场景。比如非语义化的 HTML 代码是来自第三方或者是由服务器端直接生成的，比如多张图片想共用一段文本描述。这个会在后面单独介绍，此处就不展开了，感兴趣的朋友可以阅读 [Accessible Rich Internet Applications](https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA)。



## WCAG 2.0

WCAG，Web Content Accessibility Guidelines，Web 内容可访问性指南。

上面介绍了影响页面可访问性的五个实例，相信大家对“可访问性”（旧时也称“无障碍性”）的印象，也从抽象的概念落地到了具体的实践上。这时，再认识 WCAG 2.0，就会觉得其实它也没那么枯燥，它是有血有肉的。

Web 内容可访问性指南：
1. 可感知
    1. 文本替代方案：为任何非文本内容提供文本替代方案
    2. 基于时间的媒体：为基于时间的媒体提供替代方案
    3. 适应性：创建可以以不同方式呈现的内容（例如更简单的布局），而不会丢失信息或结构
    4. 可区分：让用户更容易看到和听到内容，包括将前景色与背景色分开
2. 可操作
    1. 键盘可访问：通过键盘能访问到所有功能
    2. 足够的时间：为用户提供足够的时间来阅读和使用
    3. 适当地动画：不要以已知会导致癫痫发作的方式设计内容
    4. 可导航：提供帮助用户导航、查找内容和确定其位置的方法
3. 可理解
    1. 可读：使文本内容易读和易懂
    2. 可预测：使网页以可预测的方式显示和运行
    3. 输入帮助：帮助用户避免和纠正错误
4. 健壮健全：可以让各种用户代理（浏览器、辅助技术）可靠地解释
    1. 最大限度地兼容当前和未来的用户代理，包括辅助技术


更详细的内容，可直接查看标准 [Web Content Accessibility Guidelines (WCAG) 2.0](https://www.w3.org/TR/WCAG20/)，这里面有非常详细的解释，包括每条指南应该如何理解、怎么做才能满足它。

![](https://p0.ssl.qhimg.com/t0178bdf038ad839117.png)


## 总结
本文重点介绍了三部分内容：
1. 为什么 Web 需要有良好的可访问性
2. HTML 语义化对 Web 的可访问性至关重要
    - 良好的页面结构和布局、清晰的文本描述
    - 键盘可访问性
    - 文本的替代方案
3. Web 内容可访问性指南


## 下一步
1. 系统地体验各种辅助技术
    - 从键盘、屏幕放大器、屏幕阅读器入手，亲身感受下什么是好的可访问性，什么是不好的可访问性
    - 结合这个有现实意义的角度，重新理解 HTML5 的各个语义化标签
2. 垂直调研 [WCAG 2.0](https://www.w3.org/TR/WCAG20/)
    - 以确保做到，至少在意识层面，能全方位地理解 Web 内容的可访问性
3. [ARIA 技术](https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA)


## 主要参考
- https://developer.mozilla.org/en-US/docs/Web/Accessibility
- https://www.w3.org/TR/WCAG20/
