# 关于“放量”

所谓放量其实就是灰度发布，不过在我们组内部喜欢叫“放量”。关于放量其实有很多种规则：时间、地区、用户区间、随机放量等。

## 为什么要放量

放量只有在大流量的C端项目中才有这个需求，流量小的产品或者公司内部使用的管理系统通常不需要做放量。

这里衍生出一个问题“为什么大流量C端项目需要做放量？”。

以某门户网站为例，假设去年日均PV是二个亿，一年的总收入是30亿人民币。

那么可以推算出，如果不做任何改动的情况下，今年的收入和去年比不会有太多的波动；但是部门给规定的目标通常要高于去年的收入，所以产品需要做一些事情来增加收入。

![某门户网站简笔画](https://p5.ssl.qhimg.com/t01b92b3d80302ff16c.png)
图1 - 某门户网站简笔画

经过一系列调研与讨论，最终决定把图中红圈的位置做一个改动，希望这个位置可以得到更好的商业化效果，提升一些收入。

但我们并不知道这个改动的结果是正面的还是负面的，如果这个改动上线之后导致了负面效果（用户很讨厌这个改动，疯狂骂我们），不但没增加收入反而降低了收入，这个后果是非常严重的。

所以我们通常会做一件事就是“放量”，先小规模放10%的量看看效果如何。

这里的放量通常又根据不同的情况分好几种：

1. 按用户区间放量（这是我们最常用的放量方案）。
2. 按地域放量（例如某些功能只放量给北京地区的用户）。
3. 按时间放量（双十一期间页面会做一些开屏动画之类的活动效果，一般都是提前开发好，在指定的时间段内放全量）。

地域放量与时间放量很容易理解，这里主要解释下什么是按**用户区间**放量。

![放量10%的用户](https://p0.ssl.qhimg.com/t01f6ec70b068e64fe5.png)
图2 - 放量10%的用户

假设我们的产品总共有10亿个用户，放量10%，那么我们可以选择一个区间，是放给`0~1亿`这个区间的用户还是放给`1亿~2亿`这个区间，这个就是**用户区间**。

> 当然，这个名字是我随便起的，只是为了朗朗上口。

这里你可能会有一个疑问，为什么要按照用户区间放10%的量，直接随机放10%的量不行么？

答案是“也可以”，但随机放量无法满足下列需求。

我们还是举个例子，假设`图1`的红圈位置经过一系列讨论，现在有两个升级方案，但不确定哪个效果好，最终决定将这两个版本都开发出来，然后对比下哪个效果好就使用哪个版本。

这时候随机放量就无法满足需求了，但是按用户区间放量可以满足需求。

![方案1与方案2同时放量](https://p0.ssl.qhimg.com/t0120adad0bd9177c81.png)
图3 - 方案1与方案2同时放量

我们可以将方案一放量给`0~1亿`这个区间的用户，把方案二投放给`1亿~2亿`区间的用户。

## 如何放量

任何产品都会为用户分配一个ID，假设为用户分配的ID是一个散列值MD5，那么当用户访问我们的产品时，我们就可以根据用户的ID来分辨该用户会命中哪个版本（版本一？版本二？或者是未命中？）。

具体实现方案是，取用户ID的后三位（当然，后两位也行），然后用这个数除以三位的最大值，得到一个百分比。举个例子：

假设我的用户ID为`4b3ab369fa40ca4faae404b2f8332b65`，这是一个MD5值，我们取出后三位`b65`，三位16进制的最大数转换成10进制为`16^3 = 4096`，所以我们将`b65`转换成10进制后在除以`4096`，最终得出的数字为：`(b65 = 2917) / 4096 = 0.71`。

上述例子将“方案一”投放给`0~1亿`这个区间的人，将“方案二”投放给`1亿~2亿`这个区间的人，很显然，当我访问页面时，红圈位置会发现我的数值是`0.71`，不在`0~0.1`这个区间，也不在`0.1~0.2`这个区间，所以我没有命中这一次的小规模放量测试，我的页面上该位置显示的是现有的稳定版。

这样实现的好处是：

1. 可以通过简单且轻量的计算快速获得用户的所属区间。
2. 不需要知道总用户数就可以进行准确的放量。

## 总结

相同的放量策略和实现方式可以放到服务端，也可以放到客户端；具体如何放量需要“具体情况，具体分析”。
