本次大会共有 7 个主题：

1. 新时代 CSS 布局。陈慧晶
2. 剖析 css-tricks 新版，为你所用。大漠
3. CSS 创意与视觉表现。张鑫旭
4. CSS 生成艺术。袁川
5. 你（可能）不知道的五个 CSS 新特性。勾三股四
6. 10 things I wish CSS authors knew about animations。Brian Birtles
7. CSS TIME。陈在真

> 下文若引用了相关主题的内容，则会用对应的角标 <sup>n</sup> 标出

聊几个有意思的技术点。

### margin: auto

`margin: auto` 配合 `display: flex` 带来的惊喜 <sup>1</sup>。

示例1：轻松实现水平垂直居中（[在线预览](https://codepen.io/anjia/pen/zXKvxZ)）
![](https://p4.ssl.qhimg.com/t0120c5825b1ed68b37.png)

关键代码：
```html
<div class="demo1">
  <div class="cont"></div>
</div>

<style>
.demo1 {
  display: flex;
}
.demo1 .cont {
  margin: auto;
}
</style>
```


示例2：一层 HTML 结构实现左“右”布局（[在线预览](https://codepen.io/anjia/pen/zXKvxZ)）
![](https://p3.ssl.qhimg.com/t01c1cf521f6995cf66.png)

关键代码：
```html
<ul class="demo2">
  <li>首页</li>
  <li>动态</li>
  <li>话题</li>
  <li>活动</li>
  <li>登录 &nbsp; 注册</li>
</ul>

<style>
.demo2 {
  display: flex;
}
.demo2 > li:last-child {
  margin-left: auto;
}
</style>
```

### @supports
`@supports` 是 CSS 的特性查询。它定义的一组规则，只有当浏览器支持的时候才会生效。非常适合做一些纯 CSS 层面的渐进增强和优雅降级。

eg.
```css
@supports (display: grid) {
  div {
    display: grid;
  }
}

@supports not (display: grid) {
  div {
    float: right;
  }
}
```

> CSS Conditional Rules 共有四个规则，分别是：
> - `@supports` 特性查询
> - `@media` 媒体查询
> - `@import` 引入外链样式的
> - `@document` 基于 url 加载样式（尚在实验中）
> 
> 详见 [CSS Conditional Rules Module Level 3](https://drafts.csswg.org/css-conditional-3/)


这种特性检测也有对应的 JS API `CSS.supports()`。

eg.
```js
var result = CSS.supports('display: grid'); // 返回 boolean
var result = CSS.supports('display', 'grid'); 
```

### CSS 的边界技巧

技巧是灵活运用 CSS 属性值的“有效”区间。

eg. `opacity` <sup>3</sup>
当它的值小于 0 时，会被当成 0 处理；当它的值大于 1 时，会被当成 1 来处理。所以，用它就可以实现 CSS 里的 Boolean 值了。比如下面的效果 <sup>3</sup>：[在线预览](https://www.zhangxinxu.com/study/201903/css-idea/animation-pie.php)

![](https://p4.ssl.qhimg.com/t0190178d1ef0e22bc1.jpg)


eg. CSS 渐变里的 `<color-stop> = <color> <length-percentage>?`
当`<length-percentage>`的值比它上一个颜色的位置的值小时，则会被“修正”成和上一个位置相等的值。这样就可以“偷懒”实现下面的效果了：[在线预览](https://codepen.io/anjia/pen/vMxKxJ)

![](https://p4.ssl.qhimg.com/t01b17bee4b1c8b911b.png)

> `<length-percentage>`之所以这样“修正”，是和渐变本身的特性相关的。详见[深入理解 CSS linear-gradient](https://mp.weixin.qq.com/s/Ot0tqtPUiqjX0mrOWhXAEg)


### css-doodle

[css-doodle](https://css-doodle.com/) 的效果简直是太惊艳了，我只想说袁川是一名拿着 CSS 画笔的画家。在线欣赏他的各种作品 [codepen.io/collections](https://codepen.io/yuanchuan/collections/popular/)。

基础素材：各种形状（直线/虚线/圆角/圆形/半圆/三角形/多边形等）和 Unicode 字符（等）
方式：平铺、随机、数量（等）
配色：[Color Hunt](https://colorhunt.co/)、[Coolors.co](https://coolors.co/)（等）
画龙点睛：设计感和思考力（等）

> 后面都加了“（等）”，是因为这些都是我作为一名观众的心得，比较主观

关于 css-doodle 更准确的信息，可查看其源码 [yuanchuan/css-doodle](https://github.com/css-doodle/css-doodle)。


### 其它
- 滚动特性 <sup>2,5</sup>
  - 自定义滚动条样式
    - `scrollbar-width`
    - `scrollbar-color`
  - 让锚点定位的滚动更“平滑”。性价比很高的一个特性
    - `scroll-behavior: smooth`
  - 让由触摸滑动或鼠标滚轮触发的滚动更精细
    - `scroll-snap-type: x|y|both mandatory|proximity` 滚动-捕捉-类型
    - `scroll-snap-align: none|start|end|center` 滚动-捕捉-对齐
    - `scroll-snap-stop: normal|always` 滚动-捕捉-停止
    - 详见 [CSS Scroll Snap Module Level 1](https://drafts.csswg.org/css-scroll-snap-1/)
- 可变字体 <sup>5</sup>
  - 好处是加载一个字体文件，便可以得到不同风格的字体。你可以动态设置它的`width` `weight`和`style`等
  - 在线体验功能 [Variable Fonts](https://v-fonts.com/)
  - 入门可查看 [Variable fonts guide](https://developer.mozilla.org/en-US/docs/Web/CSS/CSS_Fonts/Variable_Fonts_Guide)
- 设置打印样式 <sup>5</sup>
  - `@media print {}`


### 更多

- 所有的 PPT 和视频均可在线查看 https://www.yuque.com/cssconf/5th
- [知乎 / 参加2019年03月30日深圳第五届CSSConf是如何体验？](https://www.zhihu.com/question/318056547/answer/636586391)
- [照片墙 / 中国第五届CSS大会](http://s.taopaipai.com/v3/indexpc.html?id=9077)
