# 逻辑属性和逻辑值 

今天，和大家聊一个很简单但很重要的东西：逻辑属性和逻辑值。

说它“简单”，是因为概念上简单；说它“重要”，是因为思路上重要。

## 什么是逻辑属性和逻辑值？

先来看个例子。这是一段 HTML 代码：
```html
<section>
    <h2>第一章</h2>
    <div>本章介绍了逻辑属性和逻辑值，这是一个演示示例。</div>
</section>
```
要实现下面的效果：

![](https://p0.ssl.qhimg.com/t01cf8ed0877a1973fa.png)


需要编写 CSS：

```css
section {
    text-align: left;
}
h2 {
    border-left: .3em solid #ccc;   
    padding-left: .5em;
}
```

现在把中文换成阿拉伯语，因为阿拉伯语是从右至左书写的，所以预期的效果是这样的：

![](https://p1.ssl.qhimg.com/t016196d9edca8d15f7.png)

基于上面的 CSS，我们要做如下修改：
```css
section {
    text-align: right;   /* left -> right */
}
h2 {
    border-right: .3em solid #ccc; /* border-left -> border-right */
    padding-right: .5em;           /* padding-left -> padding-right */
}
```

那么，问题来了：同一个页面，在遇到不同的书写模式时，却要维护不同的代码。成本有点高。

逻辑属性和逻辑值的引入就是来解决这种问题的。我们可以只写一组 CSS 就能完美适应不同的书写模式。完整代码如下：

```html
<style>
  section {
    text-align: start;    /* start 逻辑值 */
  }
  h2 {
    border-inline-start: .3em solid #ccc; /* border-inline-start 逻辑属性 */
    padding-inline-start: .5em;           /* padding-inline-start 逻辑属性 */
}
</style>

<section dir="auto">
  <h2>第一章</h2>
  <div>本章介绍了逻辑属性和逻辑值，这是一个演示示例。</div>
</section>

<section dir="auto">
  <h2>الفصل الأول</h2>
  <div>يقدم هذا الفصل القيم المنطقية والمنطقية ، والتي هي مثال توضيحي.</div>
</section>
```

在上面的 CSS 代码中：
- `text-align: start` 中的 `start` 就是逻辑值
- `border-inline-start: .3em solid #ccc;` 中的 `border-inline-start` 就是逻辑属性
- `padding-inline-start: .5em;` 中的 `padding-inline-start` 也是逻辑属性

坦白讲，逻辑属性和逻辑值并没有引入新的 CSS 特性，它只是提供了一种控制布局的新方式。

## 哪些属性新增了逻辑值？

现有的 CSS 属性  | 新增的逻辑值 
---------------|--------
`text-align`   | `start` `end`
`float` `clear` | `inline-start` `inline-end`
`caption-side` | `inline-start` `inline-end`
`resize`       | `block` `inline`


CSS 属性值，有这两大类：
- 物理值，是相对页面的。包括 `left` `right` `top` `bottom` 
- 逻辑值（下文也称“流相对值”），是相对内容流的。包括：
    - `start` `end`
    - `inline-start` `inline-end` `inline`
    - `block-start` `block-end` `block`

## 新增了哪些逻辑属性？

有这 6 个逻辑属性组：


序号 | 逻辑属性组 | 逻辑属性   | 备注
-------|-------|-----------|------
1 | 逻辑高度、逻辑宽度 | `block-size`<br/>`inline-size` | 最终对应到 width 还是 height<br/>取决于书写模式
&nbsp; | &nbsp; | `max-block-size`<br/>`max-inline-size`
&nbsp; | &nbsp; | `min-block-size`<br/>`min-inline-size`
2 | 流相对外边距 | `margin-block-start`<br/>`margin-block-end`<br/>`margin-inline-start`<br/>`margin-inline-end` 
&nbsp; | &nbsp; | `margin-block`<br/>`margin-inline` 
3 | 流相对内边距 | `padding-block-start`<br/>`padding-block-end`<br/>`padding-inline-start`<br/>`padding-inline-end` |
&nbsp; | &nbsp; | `padding-block`<br/>`padding-inline`
4 | 流相对边框 | `border-block-start-*`<br/>`border-block-end-*`<br/>`border-inline-start-*`<br/>`border-inline-end-*` | `*`可以是<br/>`width`<br/>`style`<br/>`color`
&nbsp; | &nbsp; | `border-block-*`<br/>`border-inline-*` | 同上
&nbsp; | &nbsp; | `border-block-start`<br/>`border-block-end`<br/>`border-inline-start`<br/>`border-inline-end` |
&nbsp; | &nbsp; | `border-block`<br/>`border-inline` |
5 | 流相对圆角 | `border-start-start-radius`<br/>`border-start-end-radius`<br/>`border-end-start-radius`<br/>`border-end-end-radius` |
6 | 流相对偏移 | `inset-block-start`<br/>`inset-block-end`<br/>`inset-inline-start`<br/>`inset-inline-end`
&nbsp; | &nbsp; | `inset-block`<br/>`inset-inline`<br/>`inset`

> 以上表格包括单属性（longhand sub-properties）和简写属性（shorthand property）

## 如何计算逻辑属性和逻辑值？

1. 首先，将逻辑值按照一定的规则，映射到物理值上
2. 然后，逻辑属性和物理属性一起，根据 [CSS 级联](https://www.w3.org/TR/css-cascade-3/) 的规则计算出最终的计算值（computed value）

在第一步做映射的时候，有一张表格可供参考，如下：

![](https://p5.ssl.qhimg.com/t017a4a87c850cd2267.png)
*图片来自 [Abstract-to-Physical Mappings](https://www.w3.org/TR/css-writing-modes-4/#logical-to-physical)*

特别说明，逻辑属性具体映射到哪个物理属性上，这取决于元素自身的书写模式。书写模式是由这三个属性 `writing-mode`,`direction`和`text-orientation` 共同决定的，详见 [CSS Writing Modes Level 4](https://www.w3.org/TR/css-writing-modes-4/#text-flow)。

## 小结
本文介绍了：
- 什么是逻辑属性和逻辑值，以及它解决的主要问题
- 哪些属性新增了逻辑值
- 新增了哪些逻辑属性
- 如何计算逻辑属性和逻辑值


## 主要参考
https://www.w3.org/TR/2018/WD-css-logical-1-20180827
