# 优雅适配低端移动设备

## 什么是低端移动设备

本文中所指的*低端移动设备*，特指内存不足*1 GiB*。(该数字为作者主观判定)

## 为什么要自动适配

理想状态下，前端工程师都希望一套代码走天下。可实际情况往往并非如此。

由于*低端移动设备*的存在，一些复杂计算、交互，会在用户那里导致卡顿、耗电大的问题。因此，各类 lite 版、极速版的应用（原生 + Web）曾出不穷。

以 Web 应用为例，多版本往往意味着，多套域名/URL，对产品的宣传颇为不利（例如用户对多版本的存在感到疑惑；对于同一产品，用户往往只会记住一个域名/URL）。

那么，能否在发出请求后，服务端根据设备信息，自动返回不同版本的页面资源呢？

答案是：现在不能，未来或许可以。

## Device Memory

2018-09-25，一个值得记住的日子。W3C Web Performance 工作小组公开了 `Device Memory` 工作草案，旨在解决自动适配*低端移动设备*的问题。

`Device Memory` 本质就是将设备的内存大小（RAM）通过请求头部的方式，通知给服务端。

## 流程简述

简单而言，流程如下：

Server 通过 `Accept-CH` 表明支持 `Device-Memory`:

```text
Accept-CH: Device-Memory
```

Client 发现 Server 支持后，请求资源时，自动带上 `Device-Memory` 请求头部：

```text
Device-Memory: 0.5
```

Server 接受到请求后，可以根据 `Device-Memory` 的值，返回不同的页面资源。

## 字段简析

该头部由 `Device-Memory` + `:` + `#memory-value`（纯数字，表示内存大小）组成。

```text
"Device-Memory" ":" #memory-value
```

其中 `#memory-value` 的默认单位为 `GiB`。

不足 1 GiB 时，会进行四舍五入。

> 需要提前设置好一个内存值的列表，并且明确内存下限和上线。草案推荐的下限、上限分别为：0.25 和 8 。之后真实使用的 `#memory-value` 只能来自于列表。

> 对于内存值列表，当前的可选值为 0.25，0.5，1，2，4，8 。（意味着超出 8 GiB 的设备将显示 8，而低于 256 MiB 的设备则显示 0.25）

> 此列表的设计初衷之一，包含了保护隐私的考虑，即避免暴露用户设备的绝对真实信息。

## JS 交互

```js
const deviceMemory = navigator.deviceMemory;
```

## 限制

请求头部 + JS 交互只适用于 https 环境。

## 兼容性

截至到 2018-11-18 日，仅 Chrome 63+ 和 Opera50+ 支持了具体实现。

## 总结

为了给*低端移动设备*提供适合的用户体验，往往需要提供一个*简版*的服务。对应的，或是产生新的域名，或是维护一个很大的 UA 数据库，用于返回对应内容。

随着各大浏览器支持 `Device Memory`，上面的方式就会终结。根据设备的内存大小，返回不同资源，一劳永逸。
