## 前言

相信大家应该都遇到过下面这个问题：“**HTML源码中行内元素之间的空白显示在了屏幕上**”。可能大家都有自己的小技巧来消除这些意料之外的空白。但是方法有很多，有时候不能满足于一种方法，不同的方法适合于不同的场景。就像我之前一直用的方法，今天总结了之后才发现还有更好的方法。废话不多说，接下来我给大家总结一下消除行内元素HTML源码空白的小技巧。

下文中以一个`div`中的两个`span`标签为例。我们将两个`div`内的两个`span`设为`display:inline-block;width:50%;`，会发现两个`span`元素并没有在同一行，这就是**源码中的空白导致的**。

示例图与代码如下：

![](http://p8.qhimg.com/t019453ca72aadcf4b0.png)

HTML：

```html
<div class="Resolve">
  <span>左侧行内元素</span>
  <span>右侧行内元素</span>
</div>
```

CSS：

```css
.Resolve {
  width: 90%;
  border: 1px solid #dd4b39;
  color: white;
}
.Resolve span {
  display:inline-block;
  width: 50%;
}
.Resolve span:first-child {
  height: 40px;
  background: #37b8ea;
}
.Resolve span:last-child {
  height: 30px;
  background: #5cb767;
}
```

## 解决方案1：源码中直接就写成一行

相信大家看到这个解决方案的时候，会想这不是废话嘛。有时候我们就是为了代码的美观，才将两个span标签分两行显示的，写在一行根本就没解决问题好不好？

不过，我觉得这并不是废话，之所以将其列为一种解决方案，是防止有的人不知道是什么原因导致的空白的显示。知道了这个原因，如果两个行内元素的横向宽度(此处指代码宽度)不大，写在一行也算是最快最直接的解决方法。

示例图与代码如下：

![](http://p1.qhimg.com/t01170b34cfbc5321db.png)

HTML：

```html
<div class="Resolve Resolve1">
  <span>左侧行内元素</span><span>右侧行内元素</span>
</div>
```

## 解决方案2：font-size: 0; （笔者一直使用的方法）

问题中`span`标签之间的空白是因为换行符/Tab制表符/空格等产生的间隔，并且据笔者测试，得出这个距离是<span class="text-highlight">**字体大小的1/3倍**</span>（请先记住这个值）。那么既然空格和字体大小`font-size`相关。那么也可以通过字体大小来消除这个空隙。

在父级元素上设置`font-size: 0;`，然后再在内部的`span`设置需要的字体大小即可。

示例图与代码如下：

![](http://p1.qhimg.com/t01170b34cfbc5321db.png)

HTML：

```html
<div class="Resolve Resolve2">
  <span>左侧行内元素</span>
  <span>右侧行内元素</span>
</div>
```

CSS：

```css
.Resolve2 {
  font-size: 0;
}
.Resolve2 span {
  font-size: 14px;
}
```

这种情况在内部的行内元素字体大小比较统一时，处理起来较为方便，但如果包含的行内元素中存在多种字体大小，需要一一指定，较为繁琐。不过往往这种时候内部的多种字体大小也是单独指定。可以根据具体场景决定是否使用该方案。

## 解决方案3：margin-left设为负值

如果行内元素为块级行内元素，则可以使用margin属性来抵消空白。在【解决方案2】中有提到行内元素之间的距离是<span class="text-highlight">字体大小的1/3倍</span>。所以我们只需要将第二个`span`元素的`margin-left`设置为`-0.333333em`即可。

示例图与代码如下：

![](http://p8.qhimg.com/t0166e4cff711034545.png)

HTML：

```html
<div class="Resolve Resolve3">
  <span>左侧行内元素</span>
  <span>右侧行内元素</span>
</div>
```

CSS：

```css
.Resolve3 span:last-child {
  margin-left: -0.333333em;
}
```

不过从上面可以看出，最右边还会存在一点点的白边误差。这是由于`margin-left`的计算精度导致的。所以为避免效果误差，不建议使用该方法。

## 解决方案4：letter-spacing消除文字间距离

同方案2、方案3，我们还可以通过`letter-spacing`改变行内元素之间空隙的大小，将`letter-spacing`设为`-0.333333em`即可。但是与`font-size`一样，改变`letter-spacing`时会改变内部子元素的间隙，需要在子元素内手动进行矫正。

示例图与代码如下：

![](http://p1.qhimg.com/t01170b34cfbc5321db.png)

HTML：

```html
<div class="Resolve Resolve4">
  <span>左侧行内元素</span>
  <span>右侧行内元素</span>
</div>
```

CSS：

```css
.Resolve4 {
  letter-spacing: -0.333333em;
}
.Resolve4 span {
  letter-spacing: 0;
}
```

## 解决方案5：HTML注释（推荐使用）

除了调整css样式之外，我们可以使用html注释来抵消空格，这种情况下不用额外进行css处理。此外笔者觉得还有一个好处，可以加上文字注释，告知为什么会加入注释。

**推荐使用该方式，能够有效保持代码整齐，并且不用额外添加css样式**。

示例图与代码如下：

![](http://p1.qhimg.com/t01170b34cfbc5321db.png)

HTML：

```html
<div class="Resolve Resolve5">
  <span>左侧行内元素</span><!-- 消除行内元素换行导致的空白
--><span>右侧行内元素</span>
</div>
```

## 总结

以上就是消除行内元素间HTML空白的5种方案，虽然这些方案都不是很理想，但是有时候在特定的情况下，我们往往需要其中之一作为解决方案。