# TPAC 2018 参会总结

今年，我有幸参加了 2018 年的 TPAC 大会。第一次参会，感触颇多。

所以，想在这里分享一些信息，希望对大家有所帮助。

![](https://p3.ssl.qhimg.com/t01bf425083c245bc60.png)

目录：
1. TPAC 是什么
2. TPAC 2018 的行程安排
3. CSS 工作组的新提议
4. CSS Houdini 的最新进展
5. WICG 及 W3C：对新技术和 W3C 标准感兴趣的朋友看过来

## TPAC 是什么

TPAC，全称 W3C Combined Technical Plenary / Advisory Committee Meetings Week，是 W3C 的年度重要技术会议之一。届时，W3C 的技术架构组（Technical Architecture Group，TAG）、顾问委员会理事会（Advisory Board，AB）、会员代表组成的顾问委员会（Advisory Committee，AC）、W3C 各技术小组以及公众邀请专家等，将进行为期五天的紧密合作，共同商讨未来 Web 的技术方向，深入讨论 W3C 的组织策略（摘自 [W3C中国](http://www.chinaw3c.org/TPAC2018-Overview.html)）。

这里，我们划三个关键词：W3C、参会人员、年度技术大会。

## W3C

[W3C](https://www.w3.org)（World Wide Web Consortium，万维网联盟）旨在制定开放的 Web 标准，确保 Web 的长期发展。目前共有 1161 个 [Web 标准和草案](https://www.w3.org/TR/)，包括`WD` `CR` `PR` `PER` `REC` `ret` `Note` 这 7 种。

> - `WD` Working Draft 工作草案  ✔
>     - 不稳定也不完整。目的是创建当前规范的一个快照，也能征求 W3C 和公众的意见
> - `CR` Candidate Recommendation 候选推荐标准  ✔
>     - 所有的已知 issues 都被解决了，向 implementor 征集实现
>     - AC 正式审查，可能有三种结果：成为标准、返回工作组继续完善、废弃
>         - 此阶段的很有可能成为标准，且如有改动，则需给出改动原因
> - `PR` Proposed Recommendation 提案推荐标准  ✔
>     - 从`CR`到`PR`需要全面的 test suite 和实现报告，以证明每个特性都在至少2款浏览器里实现了
>     - 意味着其质量足以成为`REC`。此时，W3C 成员再最后一次 review 下规范
>         - 一般不会有实质性的改动；若有，则只能再发布一个新的`WD`或`CR`
> - `PER` Proposed Edited Recommendation 已修订的提案推荐标准
> - `REC` Recommendation 推荐标准，通常称之为 standard，即事实标准  ✔
>    - 此时，就不会有太多变动了，当然依然可以收勘误
>     - 它可能成为
>       - Edited Recommendation 编辑推荐标准。微小改动，然后生成推荐的 Revised Edition 
>       - Amended Recommendation 修订推荐标准。不增加新功能的实质性更改
>       - `SPSD` Superseded Recommendation 被取代的推荐标准（缺少足够的市场相关性）
> - `ret` Retired 退役的
> - `Note` Group Note 工作组说明
> 	- 不打算成为标准的文档。已经停止使用了
> 	- 通常记录规范以外的信息，eg.规范的用例及其最佳实践、解释规范被弃用的原因


W3C 是一个国际社区，它没有单一的物理总部，而是由四个机构共同主持的。分别是：美国的麻省理工学院、法国的 ERCIM、日本的庆应义塾大学、中国的北京航空航天大学。这四个 Host 里的成员，即 [W3C 员工](https://www.w3.org/People/)，目前共 62 个人。

此外，W3C 还在世界各地设有 19 个 [W3C Offices](https://www.w3.org/Consortium/Offices/)；它也积极和企业进行合作，截至 2018 年 11 月 4 日，W3C 有 475 个[会员单位](https://www.w3.org/Consortium/Member/List)。

> 其中，中国有 18+ 家会员单位，包括 360、阿里、百度、腾讯、华为、中国移动、白鹭科技、遨游、21CN、北京知道创宇、北京文因互联、博彦集智、中国信通院、中国电子科技集团公司信息科学研究院、中国电子标准化研究所、中科院、西南科技大学、浙江大学等。



## 参会人员
符合以下条件之一的，便可参加 TPAC：

- W3C `TAG`或`AB`成员
    - `TAG` Technical Architecture Group 技术架构组
    - `AB` Advisory Board 顾问委员会理事会
- W3C 会员单位的`AC`代表
    - `AC` Advisory Committee 会员代表组成的顾问委员会
- W3C 各技术小组的成员
    - `WG` Working Group 工作组
    - `IG` Interest Group 兴趣组
    - `BG` Business Group 商务组
    - `CG` Community Group 社区组
- W3C 会员单位的员工
- 受邀嘉宾
- W3C 或 W3C Office 的员工

## 历年 TPAC

从 2010 年开始，TPAC 已经过了 9 个年头。

- TPAC 2018 法国，里昂（今年）
- TPAC 2017 美国，加州
- TPAC 2016 葡萄牙，里斯本
- TPAC 2015 日本，札幌
- TPAC 2014 美国，加州
- TPAC 2013 中国，深圳
- TPAC 2012 法国，里昂
- TPAC 2011 美国，加州
- TPAC 2010 法国，里昂

> 更多信息，可查看 [W3C/TPAC](https://www.w3.org/wiki/TPAC) 


## TPAC 2018 的行程安排

TPAC 期间将举行小组会议、AC 会议，以及技术开放日。其中，技术开放日采取分组开放讨论的形式，讨论与 W3C 未来技术相关的话题，对公众及所有参会者开放，其会议纪要也对外公开。顾问委员会会议及小组会议通常仅对 W3C 会员和特邀专家开放。TPAC 给参与的各方提供了一次面对面讨论的机会，这是非常难得的。

下表是 2018 年 TPAC 的行程安排。

&nbsp;|周一    | 周二   | 周三 | 周四        | 周五
------|-----------|--------|-----|------------|----
7:00-8:30|&nbsp; | [ChairsBreakfast](https://lists.w3.org/Archives/Member/chairs/2018JulSep/0136.html) | &nbsp;  |  |
8:00-8:30| 注册 | 注册 | 注册 | 注册 | 注册
8:30-18:00 |`WG`17个 | `WG`17个 | [技术开放日](https://www.w3.org/wiki/TPAC/2018) | `WG`19个 | `WG`18个
15:00-18:00 |&nbsp;  | [AC会议](https://www.w3.org/2018/10/TPAC/ac-agenda.html) | | AC会议
8:30-17:30 |`CG`4个 | `CG`4个       | | `CG`4个 | `CG`3个
晚上 |[开发者见面会](https://www.w3.org/2018/10/Meetup/)<br/>18:30-22:30 | AC晚宴<br>19:00-21:30 | TP招待会<br/>18:30-21:00 | 

> - 小组会议，Group Meetings
>   - `WG` Working Group 工作组
>   - `CG` Community Group 社区组
> - AC 会议，Advisory Committee Meeting，顾问委员会会议
> - 技术开放日，Technical Plenary Day，`TP`

[Chairs-Breakfast](https://lists.w3.org/Archives/Member/chairs/2018JulSep/0136.html) 是 TPAC 主席们的早餐时间，也是一次非正式会议，边吃边聊。项目负责人用大约 5 分钟的时间介绍下项目概况及最新进展。

注册。之前已经在线注册过的，在前台根据护照/ID换取胸卡即可。TPAC 也支持现场注册。

小组会议，包括`WG`（工作组）和`CG`（社区组）。是在周一、周二、周四、周五这四天里举行的，详情可参阅 [TPAC 2018 时间表](https://www.w3.org/2018/10/TPAC/schedule.html)（点击某个工作组的标题，则可看到它详细的议题列表）。我是参加了 CSS 和 Houdini 的小组会议，这在后面会介绍。

[AC 会议](https://www.w3.org/2018/10/TPAC/ac-agenda.html)是在周二和周四举行的，仅限 AC 代表或其委托人参加。

周一晚上的开发者见面会，有 12 个主题的 Demo 演示，展示了正在进行中的和还在探索中的标准化工作，包括 CSS Houdini、WebAuth、WebAudio、VR/AR、WoT、网络支付、WebML、WebVMT 等，可去 [Demo 演示](https://www.w3.org/2018/10/Meetup/demos.html) 页面查看主题详情。之后，有五个小演讲，分别是关于 CSS 新布局、Web 隐私、MDN 与 Web 标准、CSS 工作组和 Web 国际化的，感兴趣的朋友可以去页面 [W3C开发者见面会](https://www.w3.org/2018/10/Meetup/) 查看相应的介绍和在线 PPT。

周三的技术开放日，上午是 Jeff Jaffe 的欢迎致辞、TAG 组的介绍及公开答疑；中午和下午是话题分组讨论，共有 13*4-2=50 个话题，你可以挑选自己感兴趣的四个进行参与。当天的在线 PPT、议题列表及对应的会议纪要都在 [TPAC 2018 Wiki](https://www.w3.org/wiki/TPAC/2018) 里列出来了，感兴趣的小伙伴可自取。

![](https://p4.ssl.qhimg.com/t0156cf627c0a2736a1.png)

分组讨论的话题里，有两个来自中国企业：
- Quick App and W3C，快应用和 W3C，来自华为
- Web Accessibility Communication，Web 可访问性通信和 AI，来自中国移动

> 据说快应用的“现场讨论非常激烈，并且在 Google 负责 PWA 的 Alex Russell 也对快应用非常感兴趣” 摘自彭星的[《小程序应和Web一样开放 | W3C TPAC Lyon 2018 参会感悟》](https://mp.weixin.qq.com/s/ZLgsyZTcRedaS57ATC1isg)


## CSS 工作组的新提议

CSS 工作组的小组会议是在周一和周二进行的，共有 47+ 个话题。会议纪要可以在线查看，如下。

[周一.会议纪要](https://www.w3.org/2018/10/22-css-minutes.html)  | [周二.会议纪要](https://www.w3.org/2018/10/23-css-minutes.html)
:-------|:-----
![](https://p3.ssl.qhimg.com/t0148c7e12455f7bb19.png) | ![](https://p0.ssl.qhimg.com/t015817165150a149ec.png)

进入会议纪要页面，点击你感兴趣话题，便可定位到彼时的讨论细节。值得一提的是，在纪要里一般都会给出对应的 Github 地址。点开 Github 地址便可看到关于此话题的来龙去脉，包括背景、要解决的问题、对应的规范以及在线讨论等非常有价值的信息，而且线下讨论的内容也会同步在评论区。非常推荐大家去 Github 上 [w3c/csswg-drafts](https://github.com/w3c/csswg-drafts/issues) 垂直跟进自己感兴趣的 CSS 特性。

![](https://p3.ssl.qhimg.com/t01433182b67a2aafbc.png)



这里，我想和大家分享五个有意思的案例。

[Spatial Navigation](https://wicg.github.io/spatial-navigation/)，空间导航。是在 Web 页面上使用方向键，根据元素的显示位置来进行导航。它是在 TPAC 2017 的技术开放日那天第一次和大家见面的，是 LG 的工程师将一个特定于电视领域的问题抽象出来，扩展在了 Web 上，详细的会议纪要见 [2017/11/08-spatnav-irc](https://www.w3.org/2017/11/08-spatnav-irc)。在之后的一年里，LG 的 Web 研究员 [Jihye Hong](https://github.com/jihyerish) 和 W3C 的特邀专家 [Florian Rivoal](https://github.com/frivoal) 共同起草了这份编辑草案，并带着相应的 Web Polyfill 再一次来到了 TPAC 2018。本次会议上已将此规范纳入了 CSS WG `ED`，并会向`FPWD`推进。

- `ED` Editors' Draft 编辑草案（不是 W3C 技术报告/规范）
- `FPWD` First Public Working Draft 首个公开工作草案

> Web 上的现有导航策略是，根据元素的`tabindex`属性或在 HTML 代码里的位置（无`tabindex`时），按 Tab 键来导航。不得不说，在无鼠标操作的场景下，Spatial Navigation 还是很有优势的。

[Constructable Stylesheet Objects](https://github.com/WICG/construct-stylesheets)，可构造的样式表对象。它定义了 CSSOM 的附加功能，使 StyleSheet 对象可以直接构造，也提供了在自定义元素中方便操作样式表的 API。它解决的是 Web 组件操作 Shadow DOM 样式的性能问题。

[Aspect Ratio](https://drafts.csswg.org/css-sizing-4/#ratios)，宽高比。目的是让图片有良好的响应性。本次提议是增加一个 CSS 属性 `aspect-ratio`，让它来控制图片的宽高比。之前还有个提议是给替换元素设置一个 [intrinsic size](https://jonathankingston.github.io/logical-sizing-properties/)，是考虑到替换元素自带宽高比信息。在此会议上，对该问题尚未给出最终解决方案。如果你有什么想法，欢迎去 [Issues.Aspect Ratio](https://github.com/w3c/csswg-drafts/issues?utf8=%E2%9C%93&q=is%3Aopen+label%3Acss-sizing-4+Aspect+Ratio) 留言。

[CSS Environment Variables](https://drafts.csswg.org/css-env-1/)，CSS 环境变量。在开会之前，我是第一次见这个特性，于是便简单地调研了下[什么是 CSS 环境变量](https://github.com/anjia/blog/issues/27#issuecomment-431619575)，结果发现它最初想要解决的竟然是 iPhone 的“刘海”问题，然后就不禁疑惑：这特定浏览器下的问题，也能提成 Web 规范？针对是否要将此草案升级为`FPWD`的问题，大家进行了激烈的讨论。最后，综合各方意见，结论是升为`FPWD`。

> 有个有说服力的观点：虽然问题是产生于特定浏览器，但场景是通用的，规范应该推动这类特性的发展

[Scroll Linked Animations](https://wicg.github.io/scroll-animations/)，滚动链接动画。该提案目前是在 WICG 里的。它定义了一种纯 CSS 写法，可以控制滚动类动画，实现的功能如 [demos](https://scrolltimeline-playground.glitch.me/) 所示。本次的诉求是将此规范从 WICG 移到 CSS WG。会议中，特邀专家 [fantasai](https://github.com/fantasai) 确定后续会 review 此规范，且浏览器厂商们均对此提案表达了兴趣。相信此特性在后续的推进上，会比较流畅。想想用纯 CSS 就可以实现视差滚动了，有没有很兴奋？

> demos 需要在 Chrome Canary 里运行，因为它目前是用 Animation Worklet 模拟的。Animation Worklet 是 Houdini 的一部分，感兴趣的小伙伴，请移驾下节。


## CSS Houdini 的最新进展

Houdini 的小组会议是在周四进行的，议程安排见 [TPAC 2018 F2F](https://github.com/w3c/css-houdini-drafts/wiki/TPAC-F2F-October-2018)，会议纪要见 [2018-10-25](https://www.w3.org/2018/10/25-houdini-irc)。

从规范的整体进度上看，有这两处改动：
1. CSS Layout 的 API 做了调整，比较重大的改动有：
    - API 是基于 async 函数，而不是 generators 了。详见 [Run a Work Queue](https://drafts.css-houdini.org/css-layout-api/#run-a-work-queue)
    - 之前返回 dictionary，现在是返回带有 dictionary 的 FragmentResult 构造函数
    - 传给 layout 的 Edges 对象现在也会包含滚动条的 padding
2. CSS Animation Worklet 升级为 `FPWD`

至此，CSS Houdini 的相关规范及其最新进度如下：

&nbsp;| 规范 | 进度 | 说明
---| -----------------|:---:|-----
1 |[CSS Painting API 1](https://www.w3.org/TR/css-paint-api-1/)| `CR` | 用JS自定义CSS[图像类型](https://www.w3.org/TR/css3-images/#image-type)
2 |[CSS Layout API Level 1](https://www.w3.org/TR/css-layout-api-1/)| `FPWD` | 用JS自定义布局
3 |[CSS Animation Worklet 1](https://wicg.github.io/animation-worklet/)| `FPWD` | 可控制一组动画效果的脚本动画
4 |[CSS Typed OM 1](https://www.w3.org/TR/css-typed-om-1/)| `WD` | 将CSSOM的值的字符串转成JS对象，性能好点
5 |[CSS Properties and Values API 1](https://www.w3.org/TR/css-properties-values-api-1/)| `WD` | 注册新的CSS属性，可定义类型/继承/赋初始值
&nbsp; |[Font Metrics API](https://drafts.css-houdini.org/font-metrics-api/)|  | 提供基本的字体指标
&nbsp; |[CSS Parser API](https://drafts.css-houdini.org/css-parser-api/)| | 提供CSS解析的API

最后，再分享两个有用的链接：
- [Is Houdini ready yet?](https://ishoudinireadyyet.com/) 实时关注浏览器的支持情况、及标准的推进情况
- [Houdini Samples](https://googlechromelabs.github.io/houdini-samples/) 通过实例，非常直观的感受 Houdini 的功能



## WICG 及 W3C

[WICG](https://github.com/WICG)，全称 Web Incubator Community Group，Web 孵化器社区组。它提供了一个轻量场所，方便开发人员提出 Web 新特性、新提议，也方便大家在 Github 上公开讨论。当提案变稳定和成熟了之后，就会考虑迁移到 W3C 工作组。

所以，对 Web 特性有新提议或者想关注新特性的小伙伴，就去逛 [WICG](https://github.com/WICG) 吧。

> 要将草案提交到 WICG，须至少有一个浏览器厂商对此 API 有兴趣

关于 W3C 的规范和标准。身为前端开发人员，当遇到一个新出炉的 Web 特性时，很多人难免会问“浏览器支持度如何？”。这完全能够理解。但在这里，我想说，就技术层面，浏览器厂商之间还是很有爱的。如果一个特性深受广大开发者的喜爱，大家都乐意实现它。

所以，下次当你发现一个好玩/有趣/有价值/有意义的 Web 新特性时，在感叹完“浏览器兼容性”之后，不要犹豫，就去 [github.com/w3c](https://github.com/w3c) 上表达你的喜爱吧~！有用的 Web 特性，让更多的人知道它的价值，是你的义务，更是你的权利。

Web 的持续发展，离不开每一个人的意见和建议。


## 结束语
经过这五天的面对面会议，深感我们还能做更多。我们，也要做更多。

最后，感谢 360 公司、奇舞团、360 搜索、360 导航对 [360 W3C 工作组](https://github.com/75team/w3c) 的大力支持。

---

![](https://p3.ssl.qhimg.com/t015bf3415eca307ad7.png)

*图为来到 TPAC 现场的 CSS 工作组成员。拍摄于法国里昂，2018.10.23*
