## 前言

众所周知，在Web开发中，缓存很重要、很有用。但同时其也很复杂。

本文将从以下5个方面全面地介绍下缓存相关的内容。

1. 缓存的判断策略
2. 必知必会的缓存基础
3. 各类缓存的优缺点
4. 缓存的最佳实践
5. 小试牛刀，看看你掌握了没有？

## 一、缓存的判断策略

浏览器对于所请求资源的缓存处理有一套完整的机制，主要包含以下三个策略：**存储策略、过期策略、协商策略**。

其中，**存储策略发生在收到请求响应后，用于决定是否缓存相应资源；过期策略发生在请求前，用于判断缓存是否过期；协商策略发生在请求中，用于判断缓存资源是否更新。**

浏览器在应用缓存策略时，具体的判断流程如下：
![浏览器缓存判断策略](http://p3.qhimg.com/t01ce32ad8eab945a87.png)

上图中的缓存判断流程是浏览器在应用缓存时完整的判断流程。但是在浏览器中访问资源的方式不同也会导致判断流程的不同。**判断流程会根据不同方式跳过一些流程。**

浏览器下访问资源的方式主要有以下7种：

1. (新标签)地址栏回车
2. 链接跳转
3. 前进、后退
4. 从收藏栏打开链接
5. (window.open)新开窗口
6. 刷新（Command + R / F5）
7. 强制刷新（Command + Shift + R / Ctrl + F5）

使用这7种方式访问资源时，应用缓存的策略会有一些不同。如下图所示。通过上述7种方式访问资源，会从不同的缓存应用判断步骤开始。此处不做验证，相信大家看了后面的内容，能够自行验证的。
![不同访问方式下的浏览器资源判断](http://p7.qhimg.com/t0165f74b42fc87a808.png)

需要注意的是，Chrome中在当前地址栏，不改变内容，直接回车，等同于刷新当前页，而在Firefox下与其他在地址栏回车一样。这一点比较特殊，需要适当区分下。

> 本文配有测试脚本，代码在[github](https://github.com/verymuch/learning-web-cache)上。下文会按照测试脚本进行述说，使用说明见下载链接。验证上述内容，可以执行`node cache-ETag+max-age.js`，会同时开启`ETag`和`max-age`，然后触发相应的动作，通过Network面板和node日志即可验证，此处篇幅有限先不赘述。

此外，这里提一个概念，webkit资源分为**主资源和派生资源**。主资源是地址栏输入的URL请求返回的资源，派生资源是主资源中所引用的JS、CSS、图片等资源。

在Chrome下刷新时，只有主资源的缓存应用方式如上图所示，**派生资源的缓存应用方式与新标签打开类似，会判断缓存是否过期**。强缓存生效时的区别在于新标签打开为`from disk cache`，而当前页刷新派生资源是`from memory cache`。

而在Firefox下，当前页面刷新，所有资源都会如上图所示。下文也会利用Chrome的这一特点在当前页刷新，派生资源会使用缓存进行测试。不然每次都需要打开新标签较为繁琐。

## 二、必知必会的缓存基础

HTTP中与缓存有关的字段主要有以下10个，如下表所示。为明确表示其功能及用法，下表中分别区分了存储策略、过期策略、协商策略、请求头、响应头。

![缓存相关头字段表格](http://p0.qhimg.com/t0150916ff62c7bb4b5.png)

注：乄表示半对，`Last-Modified`之所以是半对，是因为有可能会触发启发式缓存，也会缓存文件。具体见下文。

> 缓存又分为强缓存和弱缓存（又称为协商缓存）。其中强缓存包括`Expires`和`Cache-Control`，主要是在过期策略生效时应用的缓存。弱缓存包括`Last-Modified`和`ETag`，是在协商策略后应用的缓存。强弱缓存之间的主要区别在于**获取资源时是否会发送请求**。

### 2.1 Expires

如上所述，`Expires`指定缓存的过期时间，为绝对时间，即某一时刻。参考本地时间进行比对，在指定时刻后过期。**[RFC 2616](https://tools.ietf.org/html/rfc2616)建议最大值不要超过1年**。

`Expire`头字段是响应头字段，格式如下：`Expires: Sat Oct 20 2018 00:00:00 GMT+0800 (CST)`。

可以尝试以下步骤进行验证：

1. 执行`node cache-Expires.js`，该脚本会给请求的资源设定`Expires`，值为："2018-10-20 00:00:00"。
2. 访问地址`http://localhost:1030/`，开启Network Tab，查看avatar.jpg图片，Expires值如下所示。
  ![Expires缓存设置](http://p5.qhimg.com/t01d532b7d32bb9e86c.png)
3. 再次刷新会看到该资源已经被缓存，size栏显示为`(from memory cache)`。此时修改本地时间，将时间修改为“2018-10-15 00:00:00”，再刷新，会发现缓存仍然有效。
  ![Expires缓存生效](http://p4.qhimg.com/t013d3b2d30c5f32a69.png)
4. 如果将本地时间修改为“2018-10-25 00:00:00”，再刷新，会发现图片不再使用缓存，而是重新获取了，因为本地时间超过了设定值。
  ![Expires缓存过期，重新获取](http://p4.qhimg.com/t0186607030ed25a32b.png)

### 2.2 Cache-Control

`Cache-Control`用于指定资源的缓存机制，可以同时在请求头和响应头中设定，涉及上述三个策略中的两个策略：**存储策略、过期策略**。

`Cache-Control`的语法如下：`Cache-Control: cache-directive[,cache-directive]`。`cache-directive`为缓存指令，**大小写不敏感**，共有12个与HTTP缓存标准相关，如下表所示。其中请求指令7种，响应指令9种。`Cache-Control`可以设置多个缓存指令，以逗号`,`分隔。

![Cache-Control 指令表](http://p3.qhimg.com/t011802c8bd2e967108.png)

#### 2.3.1 cache-directive大小写不敏感

如上，cache-directive指令大小写不敏感，所以在设置Cache-Control时，指令可以不区分大小写。不过建议统一使用小写。验证如下：

1. 执行`node cache-directive-case-insensitive.js`，会服务端会将`max-age`写成大写，如下`Cache-Control: MAX-AGE=86400`。
2. 再次请求浏览器会发现缓存同样会生效。

#### 2.3.2 在请求头中的max-age

max-age在请求头中的主要应用为`max-age=0`表示不使用缓存。Chrome和Firefox浏览器下的刷新操作（Command+ R / F5）均是在请求头上添加了`max-age=0`指令，表示**不使用强缓存，但允许协商缓存**（在介绍了协商缓存的`Last-Modified`和`ETag`之后，可以自行验证下这一点）。

刷新时`Cache-Control`为`max-age=0`验证如下：

1. 单独访问图片资源`http://localhost:1030/avatar.jpg`，开启Network
2. 刷新，可在响应头中看到上述内容。如下图所示。（Firefox下相同，不单独验证，主要最开始提到的主资源和派生资源在两个浏览器中表现形式的不同）。
  ![Chrome下刷新时，请求中的max-age值](http://p2.qhimg.com/t014c0409d8f7dbf22c.png)

此外，经验证，Chrome和Firefox均对`max-age`>0的情况支持不好。

1. 在Chrome下，通过`Modify Headers`插件（Chrome和Firefox下均有类似插件）给请求添加`max-age=7200`。
2. 执行`node cache-max-age.js`，访问`http://localhost:1030`，先强刷保证资源更新。
3. 打开NetWork，查看`avatar.jpg`，刷新，会发现，资源访问仍然走的是缓存。如果按照规范的定义应该是不生效。
  ![max-age > 0 在Chrome/Firefox下无效](http://p2.qhimg.com/t01d200661ae3d4b1ae.png)

#### 2.3.3 max-age与Expires

Cache-Control中的`max-age`指令用于指定缓存过期的相对时间。资源达到指定时间后过期。该功能与Expires类似。但**其优先级高于Expires**，如果同时设置max-age和Expires，max-age生效，忽略Expires。验证如下：

1. 执行`node cache-max-age+Expires.js`，会同时设置`Cache-Control: max-age=86400` / `Expires: Mon Oct 20 2018 00:00:00 GMT+0800 (CST)`，如下所示。
  ![同时设置max-age和Expires](http://p0.qhimg.com/t013235a81cbaeed0cf.png)
2. 刷新，然后再把本地时间改成当前时间延后2小时(不超过20号)，会发现缓存生效。(以下两步不再附截图，与上述示例类似)。
3. 如果将时间改为两天后（假设20号离现在大于两天，否则结果相反），会发现缓存不再生效，因为超出了max-age的限制。

相反，可以再试一下，max-age的有效时间大于Expires的情况，会发现依然是max-age生效。

#### 2.3.4 no-cache和no-store

还有一点需要注意的是，no-cache并不是指不缓存文件，**no-store才是指不缓存文件**。no-cache仅仅是表明跳过强缓存，强制进入协商策略。

### 2.3 Pragma

http1.0字段, 通常设置为`Pragma:no-cache`, 作用与`Cache-Control:no-cache`相同。当在浏览器进行强刷（Comand + Shift + R / Ctrl + F5）或在NetWork面板内勾选禁用缓存（Disable Caches）时，会自动带上`Pragma:no-cache`和`Cache-Control:no-cache`，**并且不会带上协商策略中所涉及的信息（下面介绍的`If-Modified-Since`/`If-None-Match`）**。这是不会使用任何缓存，重新获取资源。如下图所示。

![强刷浏览器自动设置no-cache](http://p4.qhimg.com/t011df7bbf3fa5b7d16.png)

### 2.4 Last-Modified/If-Modified-Since/If-Unmodified-Since

`Last-Modified`用于标记请求资源的最后一次修改时间。语法格式为：`Last-Modified: <day-name>，<day> <month> <year> <hour>:<minute>:<second> GMT`，即GMT(格林尼治标准时间)。可用 new Date().toGMTString()获取当前GMT时间。由于Last-Modified只能精确到秒，因此不适合在一秒内多次改变的资源。

如果Expires，Cache-Control: max-age，或 Cache-Control:s-maxage都没有在响应头中出现，并且设置了`Last-Modified`时，那么浏览器默认会采用一个启发式的算法，即**启发式缓存**。通常会取响应头的Date_value - Last-Modified_value值的10%作为缓存时间。验证如下：

1. 执行`node cache-Last-Modified.js`，服务器会获取资源的最后修改时间，设置为`Last-Modified`的值。访问`localhost:1030`，查看`avatar.jpg`，如下图所示：
  ![Last-Modified设定](http://p6.qhimg.com/t01814d14cf95c9d80d.png)
2. 刷新浏览器，会发现图片会从缓存获取。
3. 通过启发式缓存的公司可以计算出缓存的时间，修改本地时间超过缓存时间后，再刷新，会发现缓存失效。

#### 2.4.1 If-Modified-Since

返回的资源带有`Last-Modified`标识时，再次请求该资源，浏览器会自动带上`If-Modified-Since`，值为返回的`Last-Modified`值。请求到达服务器后，服务器进行判断，如果从上次更新后没有再更新，则返回304。如果更新了则重新返回。验证如下：

1. 执行`node cache-Last-Modified.js`，服务器会获取资源的最后修改时间，设置为`Last-Modified`的值。如下图所示，并且注意看一下资源的大小。
  ![Last-Modified设定](http://p2.qhimg.com/t013a99f89320b5141e.png)
  ![请求资源大小](http://p2.qhimg.com/t01a6808c9517773efa.png)
2. 刷新页面，再次查看NetWork。会发现请求头中带上了`If-Modified-Since`。如果服务器判断资源未改变，则返回304，此外由于服务器返回304，资源会从缓存获取，所以资源大小也减少了，如下所示。
  ![304 资源未修改](http://p0.qhimg.com/t01d195bed860fb752c.png)
  ![304 请求资源大小](http://p3.qhimg.com/t0174f2ab6f3e4852df.png)
3. 修改`index.html`文件的内容，再次刷新。会发现返回变成200，html内容更新了，并且返回了新的`Last-Modified`的值，资源大小也相应地改变了。
  ![修改资源文件，内容刷新](http://p9.qhimg.com/t013cf0d5c313d91bdf.png)
  ![修改后资源大小](http://p5.qhimg.com/t0171f354163c89aca0.png)

> 304请求也可以触发存储策略，如文章开头的流程判断图所示，可自行验证，返回时添加相应header即可。

注意，`If-Modified-Since`只能用于GET、HEAD请求。

#### 2.4.2 If-Unmodified-Since

`If-Unmodified-Since`表示资源未修改则正常执行更新，否则返回412(Precondition Failed)状态码的响应。主要有如下两种场景。

1. 用于不安全的请求中从而是请求具备条件性（如POST或者其他不安全的方法），如请求更新wiki文档，文档未修改时才执行更新。
2. 与`If-Range`字段同时使用时，可以用来保证新的片段请求来自一个未修改的文档。

### 2.5 ETag/If-Match/If-None-Match

ETag是请求资源在服务器的唯一标识，浏览器可以根据ETag值缓存数据。在再次请求时通过`If-None-Match`携带上次的ETag值，如果值不变，则返回304，如果改变你则返回新的内容。

需要注意的是，ETag和If-None-Match的值均为双引号包裹的。

验证步骤与`Last-Modified`相似。执行`node cache-ETag.js`即可。此处不再详述。

`If-Match`判断逻辑逻辑与`If-None-Match`相反。

最后，**`ETag`的优先级高于`Last-Modified`**。当`ETag`和`Last-Modified`，`ETag`优先级更高，但不会忽略`Last-Modified`，需要服务端实现。验证如下，其中服务端判断优先级：

1. 执行`node cache-ETag+Last-Modified.js`。服务端会在资源的响应头中，同时设置`ETag`和`Last-Modified`。如下图：
  ![同时设置ETag和Last-Modified](http://p0.qhimg.com/t01d971d0dcf74b6704.png)
2. 刷新浏览器，会发现`index.html`请求时304。查看node日志，会看到`ETag生效`。如下：
  ![ETag生效，优先级更高](http://p1.qhimg.com/t018ffe20955180535f.png)

## 三、缓存的优缺点

好了，通过长长的第二部分，我们简单介绍了一下HTTP Cache的基础知识。下面我再汇总一下各类缓存之间的优缺点吧。如下表所示：

![缓存优缺点表](http://p4.qhimg.com/t015c20f794a728db55.png)

## 四、最佳实践

从上面各类缓存的优缺点可以看出，每一种缓存都不是完美的。所以**建议像下面这样做**：

1. 不要缓存HTML，避免缓存后用户无法及时获取到更新内容。
2. 使用`Cache-Control`和`ETag`来控制HTML中所使用的静态资源的缓存。一般是将`Cache-Control`的`max-age`设成一个比较大的值，然后用`ETag`进行验证。
3. 使用签名或者版本来区分静态资源。这样静态资源会生成不同的资源访问链接，不会产生修改之后无法感知的情况。

还有两个本文没有介绍的内容，但是不建议大家使用：

1. 使用HTML的meta标签来指定缓存行为
2. 使用查询字符串来避免缓存。因为缓存有一些[已知的问题](https://gtmetrix.com/remove-query-strings-from-static-resources.html)，使用查询字符串会导致有些代理服务器不缓存资源。

## 五、小试牛刀，看看你掌握了没有？

看了这么多内容，是时候来看看成果了。那么一起看下下面的问题吧。

如果首次访问`localhost:1030`时，页面中 avatar.png 响应头信息如下：

```
HTTP/1.1 200 OK
Cache-Control: no-cache
Content-Type: image/png
Last-Modified: Tue, 16 Oct 2018 11:42:28 GMT
Accept-Ranges: bytes
Date: Tue, 16 Oct 2018 15:57:21 GMT

```
问题1：请问当刷新该页面后，avatar.png如何二次加载？

问题2：如果将上述信息中的`Cache-Control`设置为 private，那么结果又会如何呢？

大家先回忆下上面的内容，思考一下。

> 试题来源：[彻底弄懂 Http 缓存机制 - 基于缓存策略三要素分解法](https://mp.weixin.qq.com/s?__biz=MzA3NTYzODYzMg==&mid=2653578381&idx=1&sn=3f676e2b2e08bcff831c69d31cf51c51&key=dde62796d24517c892043e67f2520e046c13fc0558822ef7ba7fbe8003ddde05e22230fb4ccb2c31133df2a507940c5d4561c7b4f4570969a47cf1388ff57e4bfea70a3810f3fc805e2a5d9aa3192439&ascene=0&uin=MTM4MjU5NzA0MA%3D%3D&devicetype=iMac+MacBookPro12%2C1+OSX+OSX+10.11.6+build&version=12010110&nettype=WIFI&fontScale=100&pass_ticket=n3plsW%2FV7Vb6O9hKzPNig5MYpXUoJo3tNUNxhJ5Jh6e9AS%2BRXmvJPbIzUeUmL3S2)。在此致谢。

好了公布答案。

问题1：会带着`If-Modified-Since`和服务端进行验证。未改变返回304，改变返回200。

问题2：`Cache-Control`设置为 private，这时候会触发启发式缓存，则再次刷新时，avatar.png命中强缓存，从缓存中换取。

## 总结

好了，文章到此结束，希望能对大家有帮助。

## 致谢

感谢《深入浅出Vue.js》作者[刘博文](https://github.com/berwin)对本文提出的宝贵建议。

## 参考链接

> 1. [MDN | Cache-Control
 ](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Cache-Control)
> 2. [彻底弄懂 Http 缓存机制 - 基于缓存策略三要素分解法](https://mp.weixin.qq.com/s?__biz=MzA3NTYzODYzMg==&mid=2653578381&idx=1&sn=3f676e2b2e08bcff831c69d31cf51c51&key=dde62796d24517c892043e67f2520e046c13fc0558822ef7ba7fbe8003ddde05e22230fb4ccb2c31133df2a507940c5d4561c7b4f4570969a47cf1388ff57e4bfea70a3810f3fc805e2a5d9aa3192439&ascene=0&uin=MTM4MjU5NzA0MA%3D%3D&devicetype=iMac+MacBookPro12%2C1+OSX+OSX+10.11.6+build&version=12010110&nettype=WIFI&fontScale=100&pass_ticket=n3plsW%2FV7Vb6O9hKzPNig5MYpXUoJo3tNUNxhJ5Jh6e9AS%2BRXmvJPbIzUeUmL3S2)
> 3. [由memoryCache和diskCache产生的浏览器缓存机制的思考](https://segmentfault.com/a/1190000011286027)
> 4. [A Web Developer’s Guide to Browser Caching](https://medium.com/@codebyamir/a-web-developers-guide-to-browser-caching-cc41f3b73e7c)
> 5. [浏览器缓存机制剖析](http://louiszhai.github.io/2017/04/07/http-cache/)
> 6. [HTTP 缓存](https://developers.google.com/web/fundamentals/performance/optimizing-content-efficiency/http-caching)
> 7. [Are Your Cache-Control Directives Doing What They Are Supposed to Do?](https://techblog.thescore.com/2014/11/19/are-your-cache-control-directives-doing-what-they-are-supposed-to-do/)
> 8. [Hypertext Transfer Protocol](https://tools.ietf.org/html/rfc7234#section-5.2.1)
