# 谈，前端框架的『御剑之道』

> 你在使剑，是的，但是你的目的是杀人，直追你的目标，忘记手中长剑，才能使出最高的剑法... 而这世上又有多少剑客， 拘泥于手中快剑而落入俗套，终究无法到达登峰造极的境界... ----阿莱克西斯

剑，是剑客的武器，而现代前端工程师的剑可以理解为前端框架(当然不止是前端框架，但今天我们**只谈前端框架**)。

所谓御剑之道，指的是如何驾驭所有前端框架。对，你没有看错，是所有，而不是某一个。

如果是介绍如何驾驭某一个框架，那么本文的标题可能就要改成“御剑之术”，但本文介绍的是“御剑之道”。

现代前端程序员刚一入行就要选择一款前端框架来作为自己的技术栈，比如Vue，React，Angular等。包括各种公司的招聘信息上也会写上自己希望应聘者掌握至少一种前端框架。所以很多人就会有一种困惑：我应该选择哪款框架作为我的技术栈？

![图片来自@jwcarrol](https://p2.ssl.qhimg.com/t018c80a72ca410a7f6.jpg)
图片来自[@jwcarrol](https://twitter.com/jwcarroll)

如果你存在下面这些困惑，那么本篇文章会帮助到你：

1. 你是初学者，不知道应该学习哪款框架来入门。
2. 你是有经验的程序员，对于不断出现的新东西感到困惑，不知道应该“投资”哪种技术。
3. 刚学会一个新东西，然后就发现过时了。累觉不爱，求别更新老子学不动了。
4. 你的团队为使用哪个框架而争论不休，甚至发生宗教斗争。

我本人对Vue是最熟的，熟悉到什么程度呢？几个月前我就已经写完了一本介绍Vue原理的书（《深入浅出Vue.js》）还没上市，但我并不觉得自己是Vue阵营的人。我觉得自己是无阵营的，或者换一种角度来讲，“框架并不是我的剑”。

> 这本书是与人民邮电出版社签约的，预计过不了多久就会和大家见面了。
> 
> 对于这本书的内容质量大家尽管放心。人民邮电出版社出版的书，质量都不会差。就算大家不相信我，也要相信出版社。

对于初学者来说，开局能够掌握一把绝世好剑，固然会在前期得到很大的帮助，一招练成，出手就能伤人。但也正是这把剑，如果不能在合适的阶段把它丢掉，那么它会限制自己无法到达登峰造极的境界。

独孤求败被称为『剑魔』，而他最终的境界是无剑。

> 《天龙八部》中描述段誉无形有质的六脉神剑时，曾写道：“使剑全仗手腕灵活，但出剑收剑，不论如何迅速，总是有数尺的距离，他以食指运那无形剑气，却不过是手指在数寸范围内转动，一点一戳，何等方便？（没错，前端工程师的剑也是同样的道理）

## 1. 重视框架特性，而不是框架语法

很多人在学习前端框架时，会进入到一个误区，这个误区是太过在意框架提供的语法（API）。并且喜欢对各种框架孰优孰劣要争论个高低。

在实际工作中我从来不和人争论这些，但有一次和朋友们聊天刚好聊到这个话题，我说所有框架都一样用，只不过语法有点区别。其中一个朋友可能并没有理解我这句话的意思，然后发了一篇文章说Vue和React在设计理念上是有一些区别的，不只是语法。

设计理念不同导致提供的语法不同，但再怎么不同，差异再怎么大，它们要解决的问题是相同的。现在这些框架其实没有什么React能做到的事换成Vue就做不了。反而是React能做的事，使用Vue都能做，反之亦然。那么对于我来说，这两把剑就是一样的，只是使用起来手感不太一样。还是那句话，要直追我们的目标，不要拘泥于手中的剑。

站在“术”的角度看，它们确实不一样，而且可以说几乎没有一样地方。但是站在道的角度看，它们是一样的。

所以你会发现，**我关注的根本就不是框架提供的语法，我关注的是框架的特性**。我说的框架特性，指的不是React提供了JSX，或者Vue提供了模板语法。这些不是我所说的特性，这些其实还是语法。

那么框架的特性到底指的是什么呢？我们举两个例子来感受一下。

### 1.1 声明式 & 数据驱动渲染

更深一步思考，React提供的JSX和Vue提供的模板，它们的目的是什么？目的是为了实现声明式渲染的功能。不论是JSX，或者是Vue中的模板，本质上都是描述了『状态』与『视图』之间的映射关系。

所以声明式渲染是框架的特性。

声明了映射关系之后，可以得到一个公式：

> UI = render(state)

状态与视图之间的映射关系，等同于`render`函数。熟悉React的同学对这个公式应该并不陌生。JSX与Vue的模板在这一点上是相同的。在框架的内部，不论是JSX还是Vue的模板，最终会编译成`render`函数。

上面这个公式，输入的是state，输出的是DOM。所以输入变了输出就变了。

这个特性就是我们常说的数据驱动视图。

这里会引出一个问题，框架必须要知道Web应用在**运行时**”状态“是否发生了变化，然后才能使用前面提到的公式重新输出一个新的UI。所以**如何知道Web应用的状态在运行时是否发生了变化**这个问题是所有框架必须去解决的。

解决方案有很多种。不同框架，或者同一个框架的不同版本对这个问题的解决方案都不同，但相同的是都可以解决问题。关于这个问题如何解决，我在曾在我的文章、分享的PPT以及目前还未上市的书中都有详细的介绍。这个问题不是本文所讨论的重点，[感兴趣的同学可以点击这里了解更多信息](https://github.com/berwin/Blog)。

**不同的解决方案，导致的直接结果就是它所提供给用户的上层语法或API完全不一样。**

> 不同的永远是语法，相同的永远是特性。----Berwin

### 1.2 组件

现代主流框架都具备的一个特性是“组件”，它们都会以“组件”作为一个基本的抽象单元。

可能不同的框架，它所提供的操控组件的方式不一样，但概念上是相似的。

之前听过一次尤雨溪的知乎Live，他将实际应用中的组件分为四种类型并依次介绍了四种组件之间的区别：

* **展示型组件**

	展示型组件是最直接也是最常用的组件，就是用数据渲染视图，“数据进，DOM出”。

* **接入型组件**

	接入型组件通常会跟接入数据的`service`层打交道。包含一些和服务器或数据源打交道的逻辑，然后接入型组件会将数据往下传，传给比较简单的展示型组件。在React中这种类型的组件被称为“容器组件（`container component`）”。

* **交互型组件**

	交互型组件典型的例子是对表单组件的封装和增强。大部分组件库，像ElementUI都是以交互型组件为主。这一类组件会有比较复杂的交互逻辑，但是它是一个非常通用的逻辑，所以它强调复用。

* **功能型组件**

	功能型组件是比较抽象的组件。用Vue举例，路由的`<router-view>`和Vue自带的`<transition>`都属于功能型组件。它本身不渲染任何内容，它是一个逻辑型的组件。它通常作为一个扩展或一种抽象机制存在。

不同框架操控组件的方式可能不一样，但使用组件的“心法”永远是一样的。这就是关注特性带来的好处，你可以切换到任意一个框架，使用组件或封装组件时，总是上面列出的几种类型。

掌握了“心法”的程序员在切换框架时，他的状态通常是这样的：我现在想写一个交互型组件，这个框架都提供了哪些API？去翻翻文档看一下。然后就可以写出一个很优雅的组件出来，哪怕刚使用这个框架才不到一天。

如果没有掌握“心法”，用了一个框架写出的代码很糟糕，那么换了一个框架也不会写出更好的代码，甚至更糟糕。

> 绝顶剑法，不在于使用的是什么剑，而是使剑的人。

### 1.3 其他特性

前面详细介绍了两个特性给大家感受下为什么要重视特性。框架的特性太多不能每一个都详细介绍，下面列出一些大家比较熟悉的通用特性：

* 路由
* 状态和数据流管理
* CLI工具
* 同构/服务端渲染
* CSS 管理方案
* ...

### 1.5 小结

对于初学者不知道应该学哪种框架的问题，其实大可不必这么纠结，随便选一个去学（当然是学特性），以后切换到其他框架也是很轻松的事情。

有经验的程序员也无需担心投资了一个框架，刚学会就过时了。框架虽然过时了，但内功心法却深深地扎在你的脑袋里。

为团队选择技术栈所考虑的因素与人不一样。就目前来看，各大主流框架所提供的能力与社区的繁荣程度并没有明显的差距，所以框架是否靠谱等问题基本上不需要考虑，更多要考虑的因素反而是：

1. 团队大部分成员的口味更倾向于哪种。
2. 技术栈是否容易招人。
3. 团队内是否存在该技术栈的专家。
4. 其他因素。

当团队确定好了技术栈之后，最重要的是统一。一个团队内部只存在一种技术栈并打磨出成熟的架构与工作流之后，会大幅提升团队内的生产效率。

## 2. 自己动手实现框架特性

在学会了框架的特性之后，若想达到“无剑”的境界，那就需要具备实现这些特性的能力。只有具备了这样的能力，你才能完全理解一种“特性”，从而达到人剑合一的境界。否则这些特性对你来说是一个黑盒，你永远不知道它内部发生了什么，你就只是这把剑的使用者，无法真正的驾驭它们。你会被框架的设计者牵着鼻子走，然后无奈地说一句：求别更新，老子学不动了。

注意，前面提到的是实现这些“特性”的能力，当然如果能实现一个完整的框架更好。但一个框架通常会有很多很繁琐的东西会消耗掉很多精力，而那些东西其实并不是很关键，就像我们平时写代码一样，总是有很多没什么技术含量的体力活。

举例来说，真正能让我们完全理解“声明式 & 数据驱动渲染”这个特性的方式就是亲自动手去实现它。当然，不同框架或者同一个框架的不同版本对这个特性的实现方式都不太一样。但这都没关系，当我们亲自动手用某一种方式实现它之后，我们就能真正理解不同的实现方式之间各自有什么取舍，只有亲自动手实现了某个特性之后我们才能知道不同的实现方式有哪些优势，为了得到它而付出的代价（舍弃的）是什么。

对“声明式 & 数据驱动渲染”这个特性的实现方式感兴趣的同学可以看我的另一篇文章[《聊聊我对现代前端框架的认知》](https://github.com/berwin/Blog/issues/20)，在这篇文章中，有一个小节“现代前端框架对渲染的处理”对这个问题进行了相关的介绍。

## 3. 总结

本文说了这么多，但其实只讲了一个道理，就是要重视『特性』，而不是语法与API。

还有就是本文开头的那句话，如果想达到登峰造极的境界，就不要过于专注手里的剑。框架既是神兵利器，也是枷锁。既赋予我们力量，也束缚着我们。

若想挣脱这个枷锁，就要达到“手中无剑，心中有剑”的境界。

初学者最开始学武往往急于求成，学了一招出手就想伤人。但殊不知真正的高手很少杀人。

中前期学发，中后期学收，收发自如，神功乃成。