# 简析Web应用6种主要漏洞及解决方案

Web应用基于C/S（Client/Server）服务模型搭建：客户端发送请求，服务端负责响应。一般客户端就是浏览器，但可以向服务器发送请求的软件则远远不限于浏览器。Web服务器通常以公开的域名接收请求并提供服务，需要应对任何来源的请求。

保障Web应用的安全需要前后端配合，但主要还是服务端。服务端需要全面分析项目所实现的功能，对任何可能暴露漏洞、引发攻击的接口，都要提前拟定防御措施，由前后端共同配合实施，落实到位。

本文总结了Web应用最常见的6种漏洞，并对这些漏洞的危害、成因以及解决方案进行了简要分析。

- SQL注入
- 权限绕过
- XSS
- CSRF
- SSRF
- 邮件/短信轰炸

## 1. XSS

> 漏洞危害：
>
> - 泄露用户隐私
> - 执行恶意代码
> - 绕过访问控制

XSS（Cross Site Scripting，跨站点脚本），是由于没有恰当过滤用户输入，导致攻击者把恶意脚本上传到服务器，进而注入到网页中。

要堵住这个漏洞，关键不在于输入过滤，而在于输出过滤。

解决方案：用户可以通过表单向服务器提交任意文本，但在服务器要渲染用户输入内容时，必须进行反XSS过滤。

## 2. SQL注入

> 漏洞危害：
>
> - 可导致数据库被拖
> - 重要信息泄露
> - 上传webshell
> - 执行系统命令，进而控制服务器

之所以会发生SQL注入，主要因为代码中存在拼接SQL语句的情况。比如：

```sql
SELECT field FROM tableName WHERE ( name = " + name + " )
```

这个查询使用参数`name`拼接了一条`SELECT`语句。

要堵住这个漏洞，关键是保证参数`name`的值必须合法有效。

解决方案：在实际拼接SQL语句之前，要对`name`进行合法性验证，通过验证后再去拼接。

## 3. 权限绕过

> 漏洞危害：
>
> - 攻击者执行未经授权的功能
> - 攻击者访问其他正常用户的信息
> - 攻击者越权使用高权限用户的功能

权限绕过，显然是因为没有对用户身份及权限进行验证或者验证不完善造成的。

要堵住这个漏洞，核心是确保用户有权发送相应请求。

解决方案：服务器给用户浏览器种上cookie，同时根据cookie生成唯一的token，与cookie值一同保存在服务器上（或数据库里）。对于敏感的操作（比如发表、修改文章），服务端要验证cookie是否与token一致。

## 4. CSRF

> 漏洞危害：
>
> - 攻击者能够欺骗受害用户完成应用允许的任一状态改变的操作

CSRF（Cross-Site Request Forgery，跨站点请求伪造），就是利用受站点信任的用户发送恶意请求。

要堵住这个漏洞，核心也是确保用户有权限发送相应请求。

解决方案：在重要请求中的每一个URL和所有的表单中添加token，并在服务器端验证该token。

## 5. SSRF

> 漏洞危害：
>
> - 攻击者可以利用这个漏洞，让服务器替他请求资源，特别是内网资源
> - 对内网web应用进行指纹识别
> - 利用file协议读取本地文件

SSRF（Server Side Request Forge，服务端请求伪造），利用Web服务器可以访问内网窃取内网信息或攻击内网服务器。

要堵住这个漏洞，关键在于验证用户输入的网址，特别是网址解析后的IP地址。

解决方案：解析用户提交的网址得到IP，对于短链接或[http://xip.io](http://xip.io/)等代理服务生成的IP必须跟踪解析，然后屏蔽内网IP段。

## 6. 邮件/短信轰炸

> 漏洞危害：
>
> - 骚扰未知用户
> - 消耗服务器资源

邮件/短信轰炸，主要由于邮件订阅或短信验证接口没有做好防护。

要堵住这个漏洞，可以限制发送频率和使用验证码验证。

解决方案：在发送邮件或短信的表单中操作增加输入验证码功能，包括服务器端验证码或短信验证码。另外，短信验证码要限制发送时间间隔，比如1分钟以后允许重发。

## 写在最后

Web应用，归根结底就是请求和响应。理论上，只要把住接收数据和发送数据这两道关，就可以杜绝安全漏洞。实践中，可以将前端发送请求的API统一管理，所有请求都走这个统一的接口发送请求。这样便于对请求进行验证和防护。服务端也类似，但相对复杂一些。一些针对cookie和token的操作可以统一完成。