> 何处望神州？满眼风光北固楼。千古兴亡多少事？悠悠。不尽长江滚滚流。年少万兜鍪，坐断东南战未休。天下英雄谁敌手？曹刘。生子当如孙仲谋。 ——宋·辛弃疾《南乡子·登京口北固亭有怀》

### 源起

![](https://p3.ssl.qhimg.com/t01836cbd38aa59a31a.png)

2016 年前后，在技术论坛里面看到 Raspberry Pi（树莓派）的广告的时候，这种小巧、廉价、便携的设备，深深打动了笔者。积习慢慢侵袭，二话不说果断地入手一台。在短暂的折腾了一阵之后，就放在了一边。近期，WoT 大潮正以迅雷不及掩耳之势席卷而来，笔者想到这个躲在角落吃灰的玩意儿，立马翻出来，吹一吹上面的灰尘......

![](https://p5.ssl.qhimg.com/t018d0558633b73a430.jpg)

半个小时后，当尘烟渐渐散去，一个干净如新的 Raspberry Pi 2 跃然眼前，虽然型号已经有一些过时，但是，鉴于硬件架构是类似的，这个“中年”还是可以充分发挥余热的。是的，正如网上流行的观点，“不要大声责骂年轻人，他们会立刻辞职的，但是你可以往死里骂那些中年人”。那吾辈在此，不妨往死里糙磨这个“中年”树莓派。

但是，这番折腾，还是需要一些目标的。这样，我们就可以不断地从目标的达成中，获得正反馈，进而给坚持不断探索以坚实的理由——在用拖把擦拭地板时候，我这样想。

创意总是丰富的，搜索知乎上可以找到不少相关的问题，比如这个：[有哪些对树莓派的有趣改造和扩展应用](https://www.zhihu.com/question/20697024/answer/15888489)。笔者从这里找到很多好玩的创意，非常希望能将这些创意在树莓派上实现。为此，开设这个系列，希望能够记录一些小创意的动手实现过程，并且给读者今后做这些应用一些借鉴。

### 认识树莓派

树莓派，最早由英国剑桥某实验室由物理学家埃本·阿普顿花费六年时间研制，于 2012 年 3 月开始正式发售。树莓派外形仅有一张信用卡大小，却具有电脑的所有基本功能。

大多数的树莓派都支持多个 USB 接口，以及以太网接口。树莓派的 CPU 架构为 ARM，与传统意义上的个人电脑的 x86 架构不同。[这篇文章](http://m.elecfans.com/article/678193.html)详述了两种架构的区别。体积小、低功耗、低成本的 ARM 架构 CPU 在移动设备、单片机等设备上已经得到了广泛使用。ARM 架构的这些优点也正是和树莓派的研发目的高度契合的。

树莓派最新的版本是 3+，有着更强劲的处理器，更快的网络支持，同时直接整合了蓝牙适配器，支持蓝牙 4.2 协议。目前很多物联网的研究也基于树莓派实现。

作为一个单板计算机，树莓派有很多操作系统可供使用。这里推荐树莓派官方的 Raspbian，这个系统基于 Linux 的发行版 Debian 进行了深度定制。安装上这个系统，你的树莓派可以获得 Linux 的系统能力、基础设备的驱动，以及浩如烟海的高质量软件包。

树莓派包含有 40 组 GPIO 输入输出引脚，通过高低电平的变化感知，可以与传感器配合做出一系列非常有意思的应用。很多高级语言（环境）如 C/C++、Python 和 NodeJS 都支持对 GPIO 操控的封装。这也是树莓派的一个非常吸引人的特色。

除了树莓派，还有很多类似的单板计算机产品，如香蕉派、Arduino 等，有兴趣的读者可以延伸阅读相关资料。

### 需要购置的最少设备

让我们开始我们的树莓派之旅。

不同于其他的软件实践，第一个拦路虎就是需要购置一定的设备。还是之前的原则，新手上路，可以循序渐进。先让树莓派“跑起来”，然后在不断的正向反馈中，慢慢入坑。

为了确定最少的设备投入，需要先来确认这一次要做什么，达成哪些目标。

经过一番审慎的计划，笔者把这次的目标定为：**使用树莓派，搭建一个内网可以访问的 NodeJS 网站开发环境。**

首先，我们需要一个树莓派主机，即一块单板，最新版的是 3+。笔者这边是之前的树莓派 2。

其次，为了保证主机可以免受周围环境的影响，同时也保证取用放置方便，所以我们需要给主机一个外壳。

再有，为了散热方便，你可以购置一些散热片或散热风扇。考虑散热效果和操作便利性，建议购买散热风扇。

另外，树莓派的系统一般烧录在 SD 卡上。卡的读取速度，会影响整个树莓派的运行效率，因此建议使用高速卡。卡的大小最好大于 4GB（话说现在已经很少见到这个容量以下的卡了，也很少见到低速卡了），同时还需要一个读卡器。如果笔记本电脑已经配备了读卡器，则这项开支时可以剩下的。

为了第一次将树莓派连上网，请准备一条网线。

同时，如果有无线路由器，为了操作方便，建议再购置一个无线网卡。

最后，如果你不想每次关机就大把抓拔电源，可以买一个带开关的电源。

OK 了，上述东西已经足够完成这次的目标了。

读者可以从某宝某东上搜索相关的产品进行购买，或者从官网的[购买](https://www.raspberrypi.org/products/#buy-now-modal)链接点击到对应购买页面，原则上这些东西 200-400 大洋就能搞定。

![](https://p4.ssl.qhimg.com/t0112e989f86d9d3463.jpg)

来吧，上面这些东西来个开箱照片。

![](https://p3.ssl.qhimg.com/t01c2635c919547b7f3.jpg)

将它们攒起来，还是很妥帖的。

当然，后面我们的系列文章中会出现传感器、跳线等小元件。笔者感觉周期性的购置那些，才是最烧钱的环节:-)

### 安装系统

你的树莓派和你的小宇宙都准备好爆发了么？在爆发之前，先把操作系统安好。

如前文所说，建议先安装官方推荐的 Raspbian。读者可以去[这里](https://www.raspberrypi.org/downloads/raspbian/)下载安装包。目前有两个版本，一个是包含桌面版的，安装包比较大，如果你配置好了相关的显示器和键盘鼠标可以考虑这一版。如果暂时不需要桌面支持（需要时候可以再安装），可以考虑下载 Lite 版。

这里，我们以 Lite 版为例。

下载回来的是一个 Zip 包，借助压缩包查看工具看到，压缩包里面包含一个.img 文件，我们将把它烧录到 SD 卡上面。

完成这项工作，需要借助一些工具。这里，官方推荐的是 Etcher。这个软件是一个图形化的写卡工具，有 Mac、Linux 以及 Windows 的对应版本。读者遵循下列步骤即可完成烧录。

1. 从[这里](https://etcher.io/)下载符合你的系统的 Etcher，并安装之。
2. 连接读卡器，插入待写入的 SD 卡
3. 运行 Etcher，选择刚刚下载的 Zip 文件或解压过的.img 文件。
4. 选择待写入的 SD 卡。
5. 点击“Flash”，然后去泡一杯茶或者咖啡，等待烧录完成。

### 初始化系统

#### 确认 IP

装好了系统之后，我们将其通过网线接入路由器。此时，树莓派会自动连接上网络。因为没有购买显示屏和键盘鼠标，可以通过 SSH 远程连接到树莓派进行操作。现在的问题在于如何确认树莓派的 IP。

有几种方案，这里介绍一种最简便的方案：用手机或 PC（如果没有......，那还是给树莓派配上显示器和键盘鼠标吧）打开路由器的管理界面（不了解这个界面的，可以咨询路由器厂商。如果没有特殊设置过，一般是 http://192.168.0.1/admin ），并转到设备管理页面，此时会发现名为 raspberry 设备，此时可以记下它的 IP (如 192.168.0.10)

#### 用户设置

现在可以用 SSH 客户端连接树莓派，如果读者使用的是 Mac 或者 Linux ，系统会自带 SSH 连接终端，如果是 windows，请读者下载安装 Putty 等 SSH 连接软件。

如果树莓派的 SSH 服务没有打开，在烧录好镜像之后，在`boot`分区中新建一个名为`ssh`的文件夹，正常开机，通过 SSH 即可连接到树莓派。

默认地，树莓派分配了一个用户 pi，默认密码是：raspberry。因为是默认的，为了安全第一步应该把登录上去把它的密码修改掉。

```bash
ssh pi@192.168.0.10
```

在提示符下我们可以输入 raspberry 完成登录。立即修改密码。

```bash
passwd
```

此时，根据弹出的提示，修改掉默认的密码。这样可以在一定程度上，提高树莓派的安全性。

另外，建议新建一个用户作为常用账户，如：

```bash
sudo adduser leon
sudo passwd leon
```

这样就建立了一个名为 leon 的新用户，同时可以为 leon 设置账号密码。

为了能够进行系统级的操作，可以将 leon 加入 sudoer。

```bash
sudo visudoer
```

在编辑界面下，将 leon 加入列表并保存。以后，SSH 登录树莓派就可以使用 leon 作为用户名了。

#### 配置工具

树莓派本身也提供一个配置工具界面。在命令行下键入命令`sudo raspi-config`。显示如下图。

![](https://p0.ssl.qhimg.com/t01c428b5281a72360a.jpg)

#### 更换源

在中国大陆的同学，建议更换国内的源，以保证更快的下载速度。这里使用阿里的源，如果读者有更好的源，可以类似地更换。

因为我们安装的系统是以 Debian 发行版作为基础。所以 Debian 的软件包管理工具在这里是可用的。同理可知，换源的方法也是类似的。

```bash
# 先备份，后悔药先备上
sudo cp /etc/apt/sources.list /etc/apt/sources.list.bak

# 打开软件源列表文件
sudo vim /etc/apt/sources.list
```

下面，注释掉原来的源，添加以下两行

```bash
deb http://mirrors.aliyun.com/raspbian/raspbian/ wheezy main non-free contrib
deb-src http://mirrors.aliyun.com/raspbian/raspbian/ wheezy main non-free contrib
```

这里需要注意的是，不同的 Raspbian 系统版本， `wheezy`这一列可能会变成 `Jessies`。造成这种变化的原因是，基于不同的 Debian 系统，系统的名称不同。稳妥的办法是参照原来的源的写法，仅仅修改掉域名即可。

修改完毕后，可以运行`sudo apt-get upgrade`完成软件包资源索引的更新。成功更新后，就可以高速下载对应的软件了。

#### 关于中文乱码

解决的办法是安装中文字库和输入法，同时修改系统的默认字符集。

```bash
sudo apt-get install ttf-wqy-zenhei
sudo apt-get install scim-pinyin
```

在上面所说的配置工具中，选择第 5 项，根据提示进行配置。接下来的屏幕，选择 Change Locale

![](https://p3.ssl.qhimg.com/t014a50eeef3d743d02.jpg)

在接下来的屏幕中，去掉 en_GB.UTF-8 UTF-8，选中“en_US.UTF-8 UTF-8”、“zh_CN.UTF-8 UTF-8”和“zh_CN.GBK GBK”。并在下一屏幕默认语言选 zh_CN.UTF-8。

重启树莓派，使得结果生效。

#### 更换时区

默认地，树莓派的时区是 UTC0，对于时间相关的应用会造成问题。中国大陆位于东八区，我们可以通过`sudo raspi-config`来设置。

选择 `亚洲 > ShangHai` 切回主页面后按 Finish 保存退出。 即可完成设置。

#### 无线网卡配置

如果你没有移动树莓派的需求，那么插着网线就能解决网络的问题了，如果是这种情况，读者可以跳过这一节。不过，如果今后有想法做需要移动的应用，或者不喜欢插网线，还是推荐装好无线网卡。

首先，你需要确认你的无线网卡已经被正确驱动。可以通过连接树莓派，输入`ifconfig`命令查看所有树莓派的网络设备。不能找到网卡的情况很少见，如果不幸遇到，请先确认网卡可用，并寻找对应的驱动程序安装。

下面，准备好相应的 WIFI 信息。编辑`wpa_supplicant.conf`文件。`sudo vim /etc/wpa_supplicant/wpa_supplicant.conf`，在此文件结尾增加，如下代码：

```
network={
    ssid="WIFI名称"
    key_mgmt=WPA-PSK
    psk="WIFI密码"
}
```

这里注意：

1. ssid 名称不推荐中文
1. 最好不要带有`.`等特殊符号

此时即可重启网络 `/etc/init.d/networking restart`

可以再次使用`ifconfig`查看网络。同时可以打开上面提到的路由器管理页面，查看是否有新设备加入。如果你的无线网卡被发现了，你就可以：

1. 放心的拔掉网线
1. 连接 IP，使用无线网卡的 IP。

### 安装 Web 服务器软件

上面我们已经把系统的主要功能做了配置。下面我们开始进行 Web 服务器软件的配置。这里我们使用 Nginx 作为服务器软件。

因为系统是基于 Debian 的，并且已经配置了较快的软件源，所以下面的操作是比较愉快的。

```bash
sudo apt-get install nginx -y
```

此时，Nginx 的默认 www 根目录在`/usr/share/nginx/www`，你可以修改 `/etc/nginx/sites-available/default` 来配置网站的目录、端口、代理等等。

### 配置 NodeJS 开发环境

理论上，可以通过`sudo apt-get install nodejs`来安装。但是，这种方法安装的 NodeJS 版本可能会比较旧。如果从源码安装，鉴于树莓派的处理能力比较弱，故而不推荐。

这里推荐一种比较省力和完善的方法。

1. 使用`uname -a` 查询系统版本，找到 arm\*\*\*字样。
1. 打开 https://nodejs.org/dist/latest/ 找到符合这个“arm”的软件包，下载之。
1. 解压缩。
1. 将解压过的 node 文件夹，如“node-v10.10.0-linux-armv7l”移动到/usr/local/目录下，将其重命名为 node。
1. 运行`echo PATH=$PATH:/usr/local/node/bin >> ~/.bashrc; source ~/.bashrc`

如此即可完成 NodeJS 的安装。

安装完成后，我们就可以自由发挥创造力来构建基于 NodeJS 的网站。这里推荐一下奇舞团出品的 NodeJS 框架 ThinkJS，最新的版本是 3.2.8。官网是：https://www.thinkjs.org/ 。我们基于这个框架可以快速的搭建网站。

看，下面就是 ThinkJS 的表演时间，美滋滋 :-)

![](https://p1.ssl.qhimg.com/t01596b76d898aa2dd2.png)

### 小结

本篇文章中，笔者带大家简单了解了树莓派，并详述了系统安装和一些系统初始化配置，安装了网站服务器环境和 NodeJS 开发环境，建立了一个 NodeJS 网站开发环境。借此完成了树莓派的新手上路。有关传感器等更加有趣的内容，将在今后的系列文字中不断出现。笔者也会加紧时间，给大家呈现更有意思的树莓派。

![](https://p2.ssl.qhimg.com/t0139e194d6255aad8e.jpg)

### 致谢

感谢何文力为本文提出的修改建议。设计师王旋 mm，为本文设计的精美题图，在此一并表示诚挚的谢意。
