![](http://p6.qhimg.com/t0175daa7ad24da3641.jpg)

> 本文作者：[高峰](http://verymuch.site/)，360奇舞团前端工程师，W3C性能工作组成员，同时参与WOT工作组的学习。

## 一、引言

W3C的标准很多，你看或不看，它都在那，有增无减。既然如此，那我们为什么要读标准呢？笔者认为可能有以下4点原因：

1. 有一颗贡献标准的心，想要通过自己的努力为标准作出贡献；
2. 对知识内容有执着的追求，想通过标准来彻底了解某些知识点；
3. 熟悉标准已经成为我们应聘时的加分项甚至是基本项，我们不得不学；
4. 当然，我们还可以通过学习W3C标准来提升英语阅读能力以及写作缜密性。

或许你阅读标准的理由不是上面之一，但我们总归是要开始读标准了，不是吗？开始之前，我们准确地了解下W3C是什么。

**万维网联盟（World Wide Web Consortium，以下简称W3C）**创建于1994年，是Web技术领域最具权威和影响力的国际中立性技术标准机构。它的使命是开发促进万维网发展、确保万维网互操作性的通用协议，从而尽展万维网的全部潜能。

W3C一共有**36个工作组**（截止至2018年8月21日，本文书写时间），已经制定了**200多个标准**。如此多的工作组是如何**有序而又保证质量地**完成如此多的标准制定的呢？正所谓没有规矩不成方圆，如此庞大的工作必然需要一个准则，所以W3C制定了[流程文档](https://www.w3.org/2018/Process-20180201/#tag-participation)<sup>1</sup>。**该文档描述了W3C的组织结构以及为完成W3C自身使命而履行的职责和职能相关的流程。**

流程文档的主要受众是标准制定相关成员，但是其中也有一部分内容有助于作为读者的我们理清阅读的思路，笔者即将这一部分提取出来，以供大家阅读。

那么，我们先从简单了解Web技术标准化的过程概览开始吧。

## 二、Web技术标准化过程概览

通常情况下，W3C标准的标准化过程包括以下几步：

1. 首先，有人开始对某个特定的话题产生兴趣。
2. 当这个特定话题的关注度越来越高时，W3C主任会宣布为一个或多个兴趣组以及工作组开发提案章程。W3C成员审查提案章程。
3. 当W3C内部有人支持在某个被关注的主题上投入资源时，W3C主任会批准成立工作组，该小组正式开始工作。
4. 工作组章程包含了每个小组期望的可交付成果，工作组会按照这一期望建立标准和指南。
5. 这些标准和指南需要经过反复的修订和审核，要接受W3C成员和大众的审核，且要满足实现和互操作性方面的要求。
6. 最后，顾问委员会审查成熟的技术报告，如果通过则发布为标准

上述是标准产生的一个简要过程，具体的过程包括标准化过程中所涉及的组以及标准所经历的版本（或成熟度等级）下面会详细介绍。我们先从标准化过程中所涉及的组开始。

## 三、W3C中的组

上面的标准化流程概览中提到了很多参与者，下面我们来具体介绍下，W3C标准制作过程中所涉及的各个组，主要包括以下5个。

1. **顾问委员会**

  **顾问委员会（Advisory Committee，简称AC）由来自各个[成员组织](https://www.w3.org/Consortium/Member/List)<sup>2</sup>的代表组成，每个组织一个代表**（参见[AC列表](https://www.w3.org/Member/ACList)<sup>3</sup>）。
    
  他们主要负责以下工作：
  * 在每次的顾问委员会会议上审查W3C的计划;
  * 审查W3C主任（W3C Director）给出的正式提案，包括章程提案、提案标准以及提案的流程文档。
  * 推选董事会（Advisory Board）成员而非董事会主席
  * 推选技术架构组的大多数参与者

2. **董事会**

  董事会（Advisory Board，简称AB）创建于1998年3月，它会就战略、管理、法律事务、流程和冲突解决等问题向团队提供持续指导。也通过记录顾问委员会会议之间提出的问题，征求成员们对此类问题的意见以及提出解决这些问题的行动，为成员们提供服务。

  与顾问委员会的主要不同在于**董事会在W3C内没有决策权，它的作用是仅限于咨询**。

3. **技术架构组**

  技术架构组（Technical Architecture Group，简称TAG）创建于2001年2月，主要任务是管理Web架构，可以分为以下三个方面：

  1. 建立Web架构原则相关共识，并形成文档，在必要的时候对这些原则进行解释和阐明。
  2. 解决涉及TAG的通用Web架构问题;
  3. 帮助协调W3C内外部跨技术架构的开发。

4. **工作组**

  **工作组（Working Group）是某一Web技术的具体制定者，通常会产生一系列的可交付成果**（例如标准跟踪技术报告、软件、测试套件以及其他组可交付成果的审查）。

5. **兴趣组**

  兴趣小组的主要目标是**将有意评估潜在Web技术和策略的人员聚集在一起**，便于他们交流想法。

## 四、技术报告的成熟度等级

说完标准化过程中所涉及的组，我们再来了解一下标准所经历的版本，用流程文档中的话说是**技术报告的成熟度等级**。技术报告即为上述提到的工作组所产生的标准或指南等，可以在[技术报告页](https://www.w3.org/TR/)<sup>4</sup>查看已发布的技术报告。

W3C的技术报告的成熟度划分为如下6个等级。

1. **工作草案（Working Draft，简称WD）**

  工作草案是W3C发布的文档，供**W3C成员，公众和其他技术组织审查**。大多数工作草案都旨在推进成为标准，如果不再想推进成标准，则应当发布为工作组笔记。

  > 值得一提的是，工作组草案不一定代表整个工作组的共识，并且也不代表W3C已经认可，因为现阶段W3C或其成员仅是同意其在某个通用技术领域成立工作组。

2. **候选标准（Candidate Recommendation，简称CR）**

  如果工作草案满足了对应工作组的技术要求或者没有再进行实质性的修改（#如何区分实质性的改动，见下文#），并且已经通过广泛的审查（工作草案中提到的审查，加粗部分），则可以发布成为候选标准。发布为候选标准则意味着：

    * 告诉广大社区，是时候进行最后的审查了
    * 收集实现方案
    * 由顾问委员会开始正式审查，这时这一标准可能有三个结果：推荐为W3C标准、返回工作组继续完善或者废弃。

  注：候选标准已经有望成为标准，这一阶段如果再有改动，需要给出改动的原因。

3. **提案标准（Proposed Recommendation，简称PR）**

  **提案标准表示该文档已经被W3C主任所接受并认为其质量足以成为正式的W3C标准**。进入这一阶段后会给顾问委员会设定一个具体的审查截止日期。这一阶段不能再有实质性的改动了，如果有的话只能再发布一个新的工作草案和候选标准。

4. **正式标准（W3C Recommendation，简称REC）**

  **W3C正式标准是一份规范、一套指南或要求，已达成广泛的共识，并且获得了W3C成员和主任的认可。W3C会推荐其作为Web标准进行实施。**

  虽然经过了重重的努力和审查才形成了每一份标准，但是人无完人，标准也可能会有一定的缺陷。随着科技的进步，正式的标准有可能会演变成以下4种：

  * **修订标准**：工作组可能会对标准进行编辑或者其他细微的改动，W3C会发布一个新的修订版本。
  * **编辑标准**：该标准添加了不包含新特性的实质性改动时，并且该标准已经不属于现有的活跃工作组，由W3C团队完成整个制作过程。
  * **过时标准**：当一个标准缺乏足够的市场相关性来推进其实施，但其本身没有本质的问题需要被废弃时，就会变成一个过时标准。如果过时标准重新获得了足够的市场相关性，W3C可以将其恢复到推荐状态。
  * **被取代的标准**：当一个标准被W3C推荐用一个更新后的版本取代时，该标准则变为被取代的标准。

5. **废弃标准（Rescinded Recommendation）**

  废弃标准是W3C不再认可、同时认为其不太可能再恢复到标准状态的标准。

6. **工作组/兴趣组笔记（Working Group Note/Interest Group Note，简称笔记）**

  工作组/兴趣组笔记主要是为了记录有用但不会成为标准的文档，或者是没能成为标准时所要放弃的工作。

  此外，工作组和兴趣小组可能还会提供“编辑草案”。需要知道的是，编辑草案没有任何官方声明，没有在组内达成共识，也没有W3C的认可。这一版本会因为小组成员的讨论而持续变动。

> #### 如何区分实质性改动和编辑性改动？
> 前面提到了实质性改以及与其对应的编辑性改动，那么如何区分一个改动究竟是哪种改动呢？
> 标准的改动可以分为以下四类。**其中前两类是编辑性改动，后两类是实质性改动。**
> 1. *无文字内容改动*：包括修复损坏的链接、样式文件或无效标记。
> 2. *不影响一致性的改动*：实现者不会将其理解成架构、互操作性要求或者实现方案更改的改动。
> 3. *可能影响一致性的改动*
>   * 符合要求的数据、处理器或者其他代理在新版本中不再符合要求。
>   * 不符合要求的数据、处理器或者其他代理在新版本中符合要求。
>   * 清除了规范中含糊不清的或不明确的部分。
> 4. *新特性*：添加了一个新功能或者元素等。

## 五、完整的开发流程

上面介绍完了标准化过程中所涉及的组、标准所经历的版本，相信大家从中已经能对标准的开发流程有一定的了解了。下面我们再图文并茂地完整地梳理一遍标准的开发流程。

一份技术报告推进成标准的过程，主要遵循下面这些步骤，可以结合下图查看：

  1. 发布初版工作草案
  2. 发布0个及以上的修订版工作草案
  3. 发布候选标准
  4. 发布提案标准
  5. 发布W3C标准
  6. 可能会发布的编辑标准和修订标准

![W3C标准的开发过程](http://p8.qhimg.com/t0150d03291de0118cd.jpg)

上面提到正式的标准也会存在一定的变动，对已有标准进行编辑所遵循的过程可以参见下图黑色加粗部分。

![W3C标准的修改过程](http://p1.qhimg.com/t01ffb28198a19ec7bf.jpg)

从图中可以看出，如果改动不是实质性改动，则直接发布一个修订版本。如果是实质性改动，但没有增加新特性，则可以直接发布一个新的候选标准。如果是新的特性则需要从工作草案阶段进行整个开发流程。

## 总结

至此介绍完了关于W3C标准的标准化流程，本文谨代表笔者对于万维网联盟流程文档的理解，加之流程文档也会不断地进行更新，所以如本文与流程文档有冲突，请以文档为主。

## 文内链接

> 1. https://www.w3.org/2018/Process-20180201/#tag-participation
> 2. https://www.w3.org/Consortium/Member/List
> 3. https://www.w3.org/Member/ACList
> 4. https://www.w3.org/TR/

## 参考链接

> 1. [万维网联盟流程文档](https://www.w3.org/2018/Process-20180201/#maturity-levels)
