# 程序员未必知道的5个概念

计算机科学领域有几个概念，乍一听很相似，但实际上差别非常大，它们是：迭代、遍历、枚举、递归、循环。

这些概念，对于写码为生的人而言，大部分都应该不陌生。但如果让谁确切地说出它们的含义，恐怕还真没有几个能够全都说对的。时间关系，本文就简单地对这些概念做一番梳理，供大家参考。

## 1. 迭代（iteration）

![](https://p4.ssl.qhimg.com/t01900f9ec4eaddf69c.png)

**迭代**，是一个重复的过程，目的是为了输出一系列值（可能是无穷序列）。每次重复的过程也叫一次“迭代”，一次迭代的结果，可以作为下一次迭代的起点。

## 2. 遍历（traversal）

![](https://p2.ssl.qhimg.com/t0194902ac865264d20.gif)

遍历，一般是指对树形数据结构的操作，比如树遍历（也叫树搜索），就是对树形数据结构每个节点进行访问（为了检查和/或更新），且每个节点只访问一次。这种遍历是按照访问节点的顺序分类的，比如深度优先或宽度优先。

## 3. 枚举（enumeration）

![](https://p0.ssl.qhimg.com/t01246cb30b03406112.png)

在编程语言中，有一种数据类型叫可枚举数据类型，由一组有名字的值构成，每个值称为该类型数据的一个元素、成员、可枚举项。

## 4. 递归（recursion）

![](https://p3.ssl.qhimg.com/t0133c8b2c411d35cc0.gif)

递归是一种解决问题的方法，解决方案取决于对相同问题更小实例的解决方案。递归方法可用于解决很多问题，是计算机科学的核心思想。

## 5. 循环（loop）

![](https://p2.ssl.qhimg.com/t01e422fbc3f3a9206e.jpg)

循环指的是一组语句只写一次，但后续会多次执行。循环“内部”（循环体内）的代码可以执行指定次数，可以对某个集合中的每一项都执行一次，也可以执行无穷次。

## 深入了解

- https://en.wikipedia.org/wiki/Iteration
- https://en.wikipedia.org/wiki/Tree_traversal
- https://en.wikipedia.org/wiki/Enumerated_type
- https://en.wikipedia.org/wiki/Recursion_(computer_science)
- https://en.wikipedia.org/wiki/Control_flow#Loops