# 再见jQuery，我的老朋友

 - [（奇舞周刊）别了，jQuery](https://mp.weixin.qq.com/s/7IW4WPTqjOieNVpQX9vBFQ)
 - [（掘金）再见JQuery，我的老朋友](https://juejin.im/post/5b5af8565188251b186bcfcb)
 - [（知乎）再见JQuery，我的老朋友](https://zhuanlan.zhihu.com/p/40739079)

> **免责声明**
>
> 本文是仓促之作，从构思到成文不足半天。文中没有提到很多优秀的库和框架，提前在此致歉，因为没时间搜集整理。但这不代表笔者对这些库和框架没有敬意。实际上，包括jQuery在内，我的敬意是给这些名字背后整个社区和贡献者的，当然包括库和框架的最初编写者，比如John Resig。
>
> 另外，时间所限，本文粗略、不严谨，甚至可能不客观地描绘了前端技术的发展脉络。对前端发展走向的这个判断，仅代表本人自己的主观认知，并非业界共识，恳请广大读者了解。千万不要以本文观点作为评价前端技术发展的依据。谢谢！

## Github抛弃jQuery

2018年7月25日，[Mislav Marohnić](https://twitter.com/mislav)发了一条推文，宣布GitHub.com前端已经彻底删除了jQuery（下图）。而且，还自问自答地解释（低调炫耀），删除jQuery之后也没用其他框架，而是全部依赖原生API。

![Github removing jQuery](https://p0.ssl.qhimg.com/t010de7c2fee04c90da.jpg)

很多人不知道，我和jQuery颇有渊源。大概11年前（2007年），因为“疯狂迷恋”jQuery，我在国内率先翻译了jQuery 1.1的文档。后来有同好基于我翻译的版本继续翻译了jQuery新版文档，还不忘记在“关于”中提到我（http://hemin.cn/jq/about.html）：

![关于jQuery文档](https://p1.ssl.qhimg.com/t01f8ac0f3b3beb2e96.jpg)

居然称我为“国内jQuery的引路人”，惭愧。但在当时jQuery文档奇缺的情况下，我翻译的中文版应该是帮到了不少同学的。后来，我还翻译了*Learning jQuery*（《jQuery基础教程》）。

正因与jQuery的这个不解之缘，GitHub.com彻底抛弃jQuery的消息才触动我想了一些事。于是，决定写这篇小文，以飨读者（但愿有用，哈哈）。

## jQuery的辉煌

jQuery最初诞生于2006年8月，作者是John Resig（https://zh.wikipedia.org/wiki/JQuery）。10多年前，网页开发者（当时还没有“前端”这个概念）深受浏览器不兼容性之苦。以jQuery为代表的一批JavaScript库/框架应运而生：

- Dojo
- jQuery
- MooTools
- Prototype
- Yahoo! User Interface Library (YUI)
- Script.aculo.us

这些库有的像jQuery一样是主打通用性，比如Dojo、Prototype；有的则走更专业化的路线，比如YUI（组件化）和Script.aculo.us（动画交互）。从通用功能看，这些库大都提供了如下特性：

- 语法糖：链式调用、实用函数
- 选择元素：基于各种标准选择符和库自定义的选择符，以及通过回调进行筛选
- 操作DOM：创建和操作元素，乃至各种属性操作
- 处理事件：ready事件及各种注册和触发事件的方法，乃至委托
- 动画：基于animate的CSS属性动画，以及内置动画方法
- Ajax：封装原生的XMLHttpRequest API，简化请求方法及回调处理

一批宣传和推广这些库和框架的书籍相继面世，迅速推动了这些库的采用。2010年出版的*DOM Scripting, 2nd*（《JavaScript DOM脚本编程艺术（第2版）》）就是其中之一。这本书专门有一个附录，介绍当时流行的库，主推jQuery。

![DOM Scripting, 2nd](https://p2.ssl.qhimg.com/t011e5872354678517b.jpg)

当时jQuery官网的自我描述是这样的：

> “a fast and concise JavaScript Library that simplifies HTML document traversing, event handling, animating, and Ajax interactions for rapid web development. jQuery is designed to change the way that you write JavaScript.”

不错，正是这样。jQuery凭借其选择器方法、面向集合的链式调用、对事件和Ajax的完善支持、简单而强大的动效等独有优势，迅速风靡，成为几乎所有网站开发必备的JavaScript库，乃至开创了jQuery编程风格。

开发者选择jQuery的理由简单直接：

- 跨浏览器
- 简单高效
- 稳定可靠
- 插件丰富

2011年新版的“犀牛书”第6版——*JavaScript: The Definitive Guide, 6th*甚至拿出第19章整整64页篇幅隆重讲解了jQuery（“Chapter 19. The jQuery Library”）。

![JavaScript: The Definitive Guide](https://p4.ssl.qhimg.com/t01c64e0a1d2f2d7155.jpg)

jQuery从此走向鼎盛和辉煌。后来，随着前端交互越来越重和移动应用的普及，jQuery UI、jQuery Mobile相继面世。

时至今日，jQuery仍然在支撑着数以千万计各种规模网站的运作——尽管聚光灯下已经不常看到她的身影。

## 历史的选择

最近10年，是“前端行业”有史以来发展最快的10年。

移动社交时代的到来不仅没有让桌面Web失色，反倒刺激了Web标准的迅猛改进。HTML5不仅带来了极大的向后兼容性，也带来了更丰富的原生DOM API。CSS从CSS3开始走上模块化的快车道，文本样式、排版布局、媒体查询，各种新模块让人目不暇接。

各大主流浏览器也在快速跟进，Firefox、Chrome、Opera、Safari、IE乃至Edge，都在积极重构甚至重写内核，争做支持Web标准的“楷模”。在这个大背景下，各大互联网公司不断调高兼容的IE版本号，从8到9到10，再到11。

当然，还有ECMAScript语言标准。自从划时代的ES6（ECMAScript 2015）发布之后，JavaScript终于真正开始摆脱“玩具”语言的尴尬境地。更重要的，从ES6起，ECMAScript也进入了快速迭代、每年发一版的节奏。ES7、ES8，以及ES9，每次都会给这门语言注入更强大的语言特性。

与此同时，Node.js和Babel等服务端运行时及转译工具的出现，也让前端工程化，以及向传统工业级软件开发最佳实践靠拢的速度日益加快。

2012年，笔者在图灵社区翻译过一篇文章“JavaScript宝座：七大框架论剑”（http://www.ituring.com.cn/article/8108）。当时的“七大框架”是：

- Backbone
- Knockout
- Spine
- CanJS
- Ember
- AngularJS
- Batman
- Meteor

后来，谷歌主打SPA（Single Page Application，单页应用）的Angular可谓一枝独秀。不久，脸书推出的“在JS里写HTML一样很优雅”的React高歌猛进。最终，组件化开发“三剑客”的第三位、集各家所长且简单易用的Vue又脱颖而出。

前端开发已经从后“刀耕火种”时代的“农业文明”，逐渐进化为以大规模、可扩展、规范化、自动化为特征的准“工业文明”时代。

俗话说：“皮之不存，毛将焉附。”随着时代变迁、技术进步，jQuery赖以生成的环境正逐渐消失。如前所述，新的环境催生了一批框架新秀。曾经辉煌的jQuery到了可以华丽谢幕时候了。

## 几句忠告

8年前，*DOM Scripting, 2nd*在推荐开发者使用前端库时，语重心长地说过下面这段话：

> “开发中使用库当然没问题，但前提是不要仅仅只知道怎么使用，更要知道它的工作原理。如果不能超越这些库，那在这些库变成你的拐杖之时，你也会随之“残废”。在使用某个库之前，一定要花时间学习掌握JavaScript和DOM。我们从一开头就强调“知其所以然”的重要性，告诉大家不能满足于仅仅“知其然”。如果使用了库，却不晓得其背后原理，无论对自己还是对产品都将是有害的。”

2012年，从后端转前端不久的Ray Nicholus接手了一个跨浏览器文件上传库（https://github.com/FineUploader）的维护和开发工作。他的第一反应就是用jQuery重写这个库。然而，用户反对引入任何对其他库的依赖。结果他只能使用原生浏览器的API。那又怎样呢？他发现，原来放弃jQuery的写法比自己想象的要容易。

2014年，Ray发表了：“You Don't Need jQuery!”系列博客（https://blog.garstasio.com/you-dont-need-jquery/）。2016年，他的著作*Beyond jQuery* （Apress，https://www.amazon.com/dp/1484222342/）出版。Ray建议，学习前端开发，本来应该是这个顺序：

1. 学习JavaScript
2. 学习Web API
3. 学习jQuery（或其他框架/库）

但很多人实际上是从#3开始的，然后过了很久才开始#1和#2（甚至从来没想过#1和#2）。结果就是“只知其然，而不知其所以然”。

![Beyond jQuery](https://p0.ssl.qhimg.com/t01f0c2ee70b704c8d4.jpg)

如今，时移世易，jQuery即将谢幕，新一代组件化开发框粉墨登场。然而，“太阳底下没有新鲜事。”不管是使用Angular，还是React，抑或是Vue，还是要真正理解它们背后的工作原理。

（为避免广告嫌疑，我在这里就不着重推荐360导航前端的刘博文同学即将出版的《深入浅出Vue.js》一书了，哈哈哈～～，因为没有封面可以展示。）

## 尾声

jQuery作为第一代前端库的优秀代表，成就了今天Web的繁荣，也成就了一代Web开发者。作为“国内jQuery的引路人”（这个帽子是别人给的，我借用一下，哈哈），我个人对jQuery的感情是复杂的。既不希望它离开，又希望它早点离开。我想，这应该也是很多早期接触jQuery的前端开发者的心声吧。