# 同学，W3C了解一下

> 虚拟人物A：“同学，W3C了解一下？”
>
> 我：“嗷，是那个Web标准化组织吗？这个组织里的人每天都做什么？平时写不写bug呀？”

你第一次看到W3C这个词的时候，内心是不是秒演上面这段戏？别慌，我们都一样～

直到4月份一个瘦瘦高高的小哥哥来访我数字公司，我才了解这个“神秘”的组织。这个小哥哥叫薛富侨，是W3C中国的北航总部团队成员。他的演讲解答了我心中的很多疑惑，并激发了我加入W3C工作组的兴趣。一周前小编加入Web性能工作组。想了解小编如何参加W3C工作组可以直接跳到最后一节查看～

## 什么是W3C？

首先普及一下基础知识。[W3C](https://www.w3.org/)，全称World Wide Web Consortium，被称作万维网联盟，又称W3C理事会。它是万维网的主要国际标准组织。更准确地说它是一个国际性的社区。我们熟知的一些Web标准，比如[HTML](https://www.w3.org/TR/html52/)、[CSS](https://www.w3.org/Style/CSS/specs.en.html)，现在很火的[Web of Things](https://www.w3.org/WoT/WG/)等，都是由W3C制定哒。

![](https://p5.ssl.qhimg.com/t011b3d0617318b0d55.jpg)

（W3C的理事长是万维网之父Tim Berners-Lee爵士，2017年获得图灵奖。）

W3C有很多**工作组**（Working Groups），每个工作组负责不同的领域。比如CSS工作组，Web性能工作组等。每个工作组的**参与者**（participants）包括：会员组织成员，W3C的工作者，以及特邀专家等。

## 标准是怎么诞生的？

一个标准的制定工作需要会员组织（比如谷歌、苹果、阿里、360等），W3C的员工，以及**公众**们一起集思广益，出谋划策。所以**即使你不是W3C的成员，也可以参与标准的制定哦**～比如你可以去github提issue，或者给W3C工作组发邮件。只要是合理的意见和建议，都有可能被采纳。想象一下自己提的issue最后被落实到标准中，是不是有点小激动呢？

![excitement](https://p2.ssl.qhimg.com/t01c3f0522b6307143e.gif)

一个标准的形成要经历几个主要阶段：工作草案（Working Draft，**WD**），候选推荐（Candidate Recommendation，**CR**），推荐（Recommendation，**Rec**）。一个标准要进入推荐阶段，它的所有功能必须要有**至少两种独立**的实现。因此主流**浏览器厂商**在W3C的会员席位中占有很高的比例，他们对标准的形成和推广起到了决定性的作用。

![](https://p0.ssl.qhimg.com/t01b222edefbd5dd7f5.jpg)

（标准的诞生历程）

## 工作组的人平时做什么？

小编也很好奇，所以特地加入了Web性能工作组一探究竟（才不是因为主席之一Ilya是小编的男神呢）。

![](https://p4.ssl.qhimg.com/t014ad5e3bd757ec5cf.jpg)

（左边的帅小哥哥：360 AC代表李松峰；右边的帅小哥哥：Web性能工作组联席主席Ilya Grigorik。TPAC 2015。）

根据小编为期一周的暗中观察，这个工作组制定的标准覆盖了用来观测和提升应用性能的各种功能和API。小编数了数一共有多少个标准，结果发现手指不够用。随便列举几个：Performance Timeline，High Resolution Time，Beacon，Preload …

这个工作组的参与者有些是W3C的员工，剩下的大部分来自各种大厂，有谷歌，苹果，微软，国内的包括BAT，360等。参与者们在各自的公司有自己的工作职责，比如小编平时主要是在写bug…

![](https://p5.ssl.qhimg.com/t01d1ff23f2a2b584fb.gif)

性能工作组每两周开一次远程会议（北京时间凌晨2点，小编还没参加过，感觉应该会很困）。参会者根据github上面的issue和公开邮件组的内容，进行几个主要议题的讨论。在会后主席会将会议内容整理成邮件，并制定之后的计划，或者形成文档。

此外，W3C每年会进行两次线下会议，分别是AC和TPAC。今年的AC会议于5月份在柏林召开。小编的两位同事参加了此次会议。

![](https://p4.ssl.qhimg.com/t010b0c2879d7edc4a6.jpg)

（两位同事在AC 2018与W3C CEO、W3C北航负责人及部分中国参会代表合影。左1: W3C北航总部胡春明老师；左2：华为余志强；左3：360前端技术经理刘观宇；左4：W3C CEO Jeff博士；左5：360前端攻城狮冯通；右1：W3C北航总部团队成员李振杰；右2：百度陶清乾；右3: W3C北航总部李安琪经理；右4：百度尹力）

## 如何加入工作组？

由于360是W3C正式会员，所以公司的员工能够加入W3C工作组。小编选择了Web性能工作组。我参加工作组的过程如下：

- 首先，用公司邮箱[注册W3C帐号](https://www.w3.org/accounts/request)。
- 在W3C > Participate > Groups页面阅读工作组们的简介，点击自己喜欢的工作组，点击join，点击“send request to join to AC Rep”。
- 公司的会员代表（AC Rep）确认。
- 工作组的主席发欢迎邮件。
- 回复邮件做自我介绍。
- 阅读工作组章程，了解工作组的制度，正在制定哪些标准。重点是找到工作组例会的时间点。

小编之所以选择Web性能工作组，是因为以前看过主席之一Ilya关于HTTP/2的演讲，培养了对Web性能的兴趣。小编在加入工作组的过程中遇到了一点小问题——查不到下次例会的时间点。于是回复欢迎邮件的时候直接抛出了问题。W3C的吴小倩小姐姐首先回复了邮件，告诉我邮件组的订阅链接和例会时间，后来Ilya补充了一份日程文档的链接。大家敲贴心的～

![sweet](https://p1.ssl.qhimg.com/t019943bec61d50c47e.gif)

加入工作组之后，第一时间仔细阅读了Web性能工作组的章程。以及一些扩展阅读。小编今天读[A Primer for Web Performance Timing API](https://w3c.github.io/perf-timing-primer/) 的时候，发现一个拼写错误，顺手提了个PR，Ilya很快就merge了。看了一下当地时间，发现男神下班也挺晚的。

另外订阅了邮件组之后，平时会收到一些邮件，需要抽空阅读才能跟上进度。本周有一封主题叫“[每周github摘要（Web性能工作组标准）](https://lists.w3.org/Archives/Public/public-web-perf/2018Jun/0003.html)”的邮件成功引起了我的注意。这封邮件罗列了性能工作组负责的几个标准的github仓库上的issue和PR。点击某一个issue的链接，就能看到大家对具体问题的讨论。

以上就是小编加入工作组一周的经历和所学，希望能让大家更了解W3C。小编已经在期待下次的工作组例会了～

【未完待续】

