
# Actuators
## ON/OFF Functionality
The ON/OFF module of the OpenMQTTGateway provides you with the capability to control actuators, such as relays or LEDs, by assigning a HIGH or LOW value to a specific PIN through MQTT topics. For instance, you might connect a transistor to power a relay or an LED to the PIN.

To operate the default GPIO, identified as ACTUATOR_ONOFF_GPIO, you'll need to issue certain commands which comply with the JSON receiving format.

### Standard ON/OFF control
The OFF command can be executed as follows:
`mosquitto_pub -t home/OpenMQTTGateway/commands/MQTTtoONOFF -m '{"cmd":0}'`

For the ON command, use:
`mosquitto_pub -t home/OpenMQTTGateway/commands/MQTTtoONOFF -m '{"cmd":1}'`

You can also specify the GPIO number that you wish to control:
`mosquitto_pub -t home/OpenMQTTGateway/commands/MQTTtoONOFF -m '{"gpio":15,"cmd":1}'`

The status of the actuator will be published to the topic below every 2 minutes or upon state change.
`home/OpenMQTTGateway/ONOFFtoMQTT '{"cmd":0}'`

In the case of the simple receiving format, the commands can be executed as follows:
OFF command: `mosquitto_pub -t home/OpenMQTTGateway/commands/MQTTtoONOFF/setOFF -m 15`
ON command: `mosquitto_pub -t home/OpenMQTTGateway/commands/MQTTtoONOFF/setON -m 15`

### Pulse control for short activations
Additionally, the module also supports short activations, during which the PIN changes state for just half a second. This can be particularly useful when operating a relay board to trigger a step relay, thus allowing your home automation system to function as an auxiliary switch, without interfering with the existing switches in your house.

This functionality is available only through the JSON receiving format.

To switch ON for half a second before reverting to OFF:
`mosquitto_pub -t home/OpenMQTTGateway/commands/MQTTtoONOFF -m '{"gpio":15,"cmd":"high_pulse"}'`

To switch OFF for half a second before reverting to ON:
`mosquitto_pub -t home/OpenMQTTGateway/commands/MQTTtoONOFF -m '{"gpio":15,"cmd":"low_pulse}'`

If you need to specify an activation duration other than half a second, include the pulse_length parameter along with the duration in milliseconds (ms).

To switch ON for 25 ms before reverting to OFF:
`mosquitto_pub -t home/OpenMQTTGateway/commands/MQTTtoONOFF -m '{"gpio":15,"cmd":"high_pulse","pulse_length":25}'`

To switch OFF for 25 ms before reverting to ON:
`mosquitto_pub -t home/OpenMQTTGateway/commands/MQTTtoONOFF -m '{"gpio":15,"cmd":"low_pulse","pulse_length":25}'`

Recovery Functionality (ESP32 only)
In the event of power loss, by default, the module will record the last known state of the actuator and attempt to revert to this state upon restarting. For example, if a relay was ON at the time of a power outage, the firmware will attempt to switch the relay ON again once power is restored.

If you prefer to disable this functionality, you can set the macro USE_LAST_STATE_ON_RESTART to false during the build time. Alternatively, you can issue the following command at runtime:
`mosquitto_pub -t home/OpenMQTTGateway/commands/MQTTtoONOFF/config -m '{"uselaststate":false,"save":true}'`

## FASTLED
### The FASTLED module support 2 different operation modes
1. control one specific RGB LED
* Set color
* Set blink

2. Start fire animation (Fire2012)

### Hardware wiring
Theoretically it should be possible to use every free IO pin. But after some tests only pin D2 works at WEMOS D1. Other platforms can work.
The default setting use NEOPIXEL (WS2812B). The simplest wiring is direct connect D2 to data pin of LED stripe and connect VCC/GND to power source. You should also add a capacitor.

## PWM
This module allows control over PWM outputs.
It's primary use is for controlling LEDs, but it should be equally at home controlling anything that's controlled using PWM.
E.g. LEDs, servos, PC fans.
You would typically connect a PWM output to a transistor or MOSFET to allow control over higher power devices.

* JSON message format allows you to set any or all channels in a single message.
* Each channel can be set to smoothly transition from its current setting to the new setting over a specified number of seconds.
* Each channel can be calibrated with min and max settings, as well as a gamma curve.

### Configuration
In order to use the PWM actuator, you need to configure which pins the PWM output channels will be connected to.
There are a couple of `#defines that achieve this.
They can be defined in the `build_flags` section of the env, or by directly editing `config_PWM.h`.

```c
#define PWM_CHANNEL_NAMES {"r", "g", "b", "w0", "w1"}
#define PWM_CHANNEL_PINS  { 25,  33,  32,   23,   22}
```

`PWM_CHANNEL_NAMES` lists the names that you would like to assign to each channel, and determines the number of channels.
`PWM_CHANNEL_PINS` lists the corresponding output pins that the channels will be connected to.
The number of entries in `PWM_CHANNEL_PINS` must exactly match the number of entries in `PWM_CHANNEL_NAMES`.

### Usage

#### Set
`mosquitto_pub -t home/OpenMQTTGateway/commands/MQTTtoPWM/set -m '{"r":0.5,"g":0.2,"b":1,"fade":10.0}'`

This example sets new values for the channels named `r`, `g`, and `b`.
These channels will transition from their current values to the new values over 10s.

#### Calibrate
Calibration allows that min and max levels to be configured for each channel, so that the full 0-1 range of values
that can be specified with the `set` command actually do things.

`mosquitto_pub -t home/OpenMQTTGateway/commands/MQTTtoPWM/calibrate -m '{"min-r":0.01,"max-r":1.0,"gamma-r":2.5}'`

This example calibrates the channel named `r`.
After this calibration, if you set the `r` channel to 0.0, it will be remapped to 0.01 internally.
Also, the gamma curve for this channel will be set to 2.5.
This means that input values are raised to the power 2.5 internally.
This can be used to improve the linearity of inputs.

## Somfy RTS
This actuator allows to control Somfy RTS devices.

### Setup
Before the module can be used, virtual Somfy RTS remotes must be created.
This is done in `config_Somfy.h`.

`SOMFY_REMOTE_NUM` must be set to the number of virtual Somfy RTS remotes you want to have.
Then create for each of the virtual Somfy RTS remotes a unique 3-byte code and add them to `somfyRemotes`.
After a remote is setup, the order and codes should not be changed, else the setup process for all remotes have to be repeated.
Adding new codes at the end of the list is no problem.
Example of three virtual Somfy RTS remote codes:
```C
const uint32_t somfyRemotes[SOMFY_REMOTE_NUM] = {0x5184c8, 0xba24d0, 0xb77753};
```

Next the virtual Somfy RTS remotes must be paired with the Somfy RTS devices you want to control.
The next section describes how the PROG command/button of the virtual remote can be used.
Use the manual of the device you want to control for instructions on how to pair the virtual remote with the device.

### Commands
Commands must be send to the `commands/MQTTtoSomfy` subtopic.
Only json messages are supported.
The json message must contain two properties:
* remote: the index of the remote which is used to send the command (index start at zero)
* command: the command which should be send with the remote as string, see [table of command names](https://github.com/Legion2/Somfy_Remote_Lib#available-commands).

Optionally it can contain the following property:
* repeat: the number how often the command is repeated, default 4. Should be used to simulate long button presses, by increasing the repeat number, e.g. 20.

::: tip
The middle button on physical Somfy RTS Remote controls is called "My".
:::

The frequency key is optional, if not set the gateway will use the default frequency defined by MQTTtoRF command at runtime or `RF_FREQUENCY` at buildtime.

Send PROG command with remote 0:

`mosquitto_pub -t home/OpenMQTTGateway_Somfy/commands/MQTTtoSomfy -m '{"remote":0,"command":"Prog","frequency":433.42}'`

Send Up command with remote 1:

`mosquitto_pub -t home/OpenMQTTGateway_Somfy/commands/MQTTtoSomfy -m '{"remote":1,"command":"Up","frequency":433.42}'`
