// MODIFIED clmtrackr.js
// Ctrl+F "PATCHED IN" for modifications
// Original: https://github.com/auduno/clmtrackr/blob/0c702208c70ea19ca0cb8c8ca603a86c45db141f/build/clmtrackr.js

(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
	typeof define === 'function' && define.amd ? define(factory) :
	(global.clm = factory());
}(this, (function () { 'use strict';

var commonjsGlobal = typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};





function createCommonjsModule(fn, module) {
	return module = { exports: {} }, fn(module, module.exports), module.exports;
}

var numeric1_2_6 = createCommonjsModule(function (module, exports) {
"use strict";

var numeric = exports;
if(typeof commonjsGlobal !== "undefined") { commonjsGlobal.numeric = numeric; }

numeric.version = "1.2.6";

// 1. Utility functions
numeric.bench = function bench (f,interval) {
    var t1,t2,n,i;
    if(typeof interval === "undefined") { interval = 15; }
    n = 0.5;
    t1 = new Date();
    while(1) {
        n*=2;
        for(i=n;i>3;i-=4) { f(); f(); f(); f(); }
        while(i>0) { f(); i--; }
        t2 = new Date();
        if(t2-t1 > interval) break;
    }
    for(i=n;i>3;i-=4) { f(); f(); f(); f(); }
    while(i>0) { f(); i--; }
    t2 = new Date();
    return 1000*(3*n-1)/(t2-t1);
};

numeric._myIndexOf = (function _myIndexOf(w) {
    var n = this.length,k;
    for(k=0;k<n;++k) if(this[k]===w) return k;
    return -1;
});
numeric.myIndexOf = (Array.prototype.indexOf)?Array.prototype.indexOf:numeric._myIndexOf;

numeric.Function = Function;
numeric.precision = 4;
numeric.largeArray = 50;

numeric.prettyPrint = function prettyPrint(x) {
    function fmtnum(x) {
        if(x === 0) { return '0'; }
        if(isNaN(x)) { return 'NaN'; }
        if(x<0) { return '-'+fmtnum(-x); }
        if(isFinite(x)) {
            var scale = Math.floor(Math.log(x) / Math.log(10));
            var normalized = x / Math.pow(10,scale);
            var basic = normalized.toPrecision(numeric.precision);
            if(parseFloat(basic) === 10) { scale++; normalized = 1; basic = normalized.toPrecision(numeric.precision); }
            return parseFloat(basic).toString()+'e'+scale.toString();
        }
        return 'Infinity';
    }
    var ret = [];
    function foo(x) {
        var k;
        if(typeof x === "undefined") { ret.push(Array(numeric.precision+8).join(' ')); return false; }
        if(typeof x === "string") { ret.push('"'+x+'"'); return false; }
        if(typeof x === "boolean") { ret.push(x.toString()); return false; }
        if(typeof x === "number") {
            var a = fmtnum(x);
            var b = x.toPrecision(numeric.precision);
            var c = parseFloat(x.toString()).toString();
            var d = [a,b,c,parseFloat(b).toString(),parseFloat(c).toString()];
            for(k=1;k<d.length;k++) { if(d[k].length < a.length) a = d[k]; }
            ret.push(Array(numeric.precision+8-a.length).join(' ')+a);
            return false;
        }
        if(x === null) { ret.push("null"); return false; }
        if(typeof x === "function") { 
            ret.push(x.toString());
            var flag = false;
            for(k in x) { if(x.hasOwnProperty(k)) { 
                if(flag) ret.push(',\n');
                else ret.push('\n{');
                flag = true; 
                ret.push(k); 
                ret.push(': \n'); 
                foo(x[k]); 
            } }
            if(flag) ret.push('}\n');
            return true;
        }
        if(x instanceof Array) {
            if(x.length > numeric.largeArray) { ret.push('...Large Array...'); return true; }
            var flag = false;
            ret.push('[');
            for(k=0;k<x.length;k++) { if(k>0) { ret.push(','); if(flag) ret.push('\n '); } flag = foo(x[k]); }
            ret.push(']');
            return true;
        }
        ret.push('{');
        var flag = false;
        for(k in x) { if(x.hasOwnProperty(k)) { if(flag) ret.push(',\n'); flag = true; ret.push(k); ret.push(': \n'); foo(x[k]); } }
        ret.push('}');
        return true;
    }
    foo(x);
    return ret.join('');
};

numeric.parseDate = function parseDate(d) {
    function foo(d) {
        if(typeof d === 'string') { return Date.parse(d.replace(/-/g,'/')); }
        if(!(d instanceof Array)) { throw new Error("parseDate: parameter must be arrays of strings"); }
        var ret = [],k;
        for(k=0;k<d.length;k++) { ret[k] = foo(d[k]); }
        return ret;
    }
    return foo(d);
};

numeric.parseFloat = function parseFloat_(d) {
    function foo(d) {
        if(typeof d === 'string') { return parseFloat(d); }
        if(!(d instanceof Array)) { throw new Error("parseFloat: parameter must be arrays of strings"); }
        var ret = [],k;
        for(k=0;k<d.length;k++) { ret[k] = foo(d[k]); }
        return ret;
    }
    return foo(d);
};

numeric.parseCSV = function parseCSV(t) {
    var foo = t.split('\n');
    var j,k;
    var ret = [];
    var pat = /(([^'",]*)|('[^']*')|("[^"]*")),/g;
    var patnum = /^\s*(([+-]?[0-9]+(\.[0-9]*)?(e[+-]?[0-9]+)?)|([+-]?[0-9]*(\.[0-9]+)?(e[+-]?[0-9]+)?))\s*$/;
    var stripper = function(n) { return n.substr(0,n.length-1); };
    var count = 0;
    for(k=0;k<foo.length;k++) {
      var bar = (foo[k]+",").match(pat),baz;
      if(bar.length>0) {
          ret[count] = [];
          for(j=0;j<bar.length;j++) {
              baz = stripper(bar[j]);
              if(patnum.test(baz)) { ret[count][j] = parseFloat(baz); }
              else ret[count][j] = baz;
          }
          count++;
      }
    }
    return ret;
};

numeric.toCSV = function toCSV(A) {
    var s = numeric.dim(A);
    var i,j,m,n,row,ret;
    m = s[0];
    n = s[1];
    ret = [];
    for(i=0;i<m;i++) {
        row = [];
        for(j=0;j<m;j++) { row[j] = A[i][j].toString(); }
        ret[i] = row.join(', ');
    }
    return ret.join('\n')+'\n';
};

numeric.getURL = function getURL(url) {
    var client = new XMLHttpRequest();
    client.open("GET",url,false);
    client.send();
    return client;
};

numeric.imageURL = function imageURL(img) {
    function base64(A) {
        var n = A.length, i,x,y,z,p,q,r,s;
        var key = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
        var ret = "";
        for(i=0;i<n;i+=3) {
            x = A[i];
            y = A[i+1];
            z = A[i+2];
            p = x >> 2;
            q = ((x & 3) << 4) + (y >> 4);
            r = ((y & 15) << 2) + (z >> 6);
            s = z & 63;
            if(i+1>=n) { r = s = 64; }
            else if(i+2>=n) { s = 64; }
            ret += key.charAt(p) + key.charAt(q) + key.charAt(r) + key.charAt(s);
            }
        return ret;
    }
    function crc32Array (a,from,to) {
        if(typeof from === "undefined") { from = 0; }
        if(typeof to === "undefined") { to = a.length; }
        var table = [0x00000000, 0x77073096, 0xEE0E612C, 0x990951BA, 0x076DC419, 0x706AF48F, 0xE963A535, 0x9E6495A3,
                     0x0EDB8832, 0x79DCB8A4, 0xE0D5E91E, 0x97D2D988, 0x09B64C2B, 0x7EB17CBD, 0xE7B82D07, 0x90BF1D91, 
                     0x1DB71064, 0x6AB020F2, 0xF3B97148, 0x84BE41DE, 0x1ADAD47D, 0x6DDDE4EB, 0xF4D4B551, 0x83D385C7,
                     0x136C9856, 0x646BA8C0, 0xFD62F97A, 0x8A65C9EC, 0x14015C4F, 0x63066CD9, 0xFA0F3D63, 0x8D080DF5, 
                     0x3B6E20C8, 0x4C69105E, 0xD56041E4, 0xA2677172, 0x3C03E4D1, 0x4B04D447, 0xD20D85FD, 0xA50AB56B, 
                     0x35B5A8FA, 0x42B2986C, 0xDBBBC9D6, 0xACBCF940, 0x32D86CE3, 0x45DF5C75, 0xDCD60DCF, 0xABD13D59, 
                     0x26D930AC, 0x51DE003A, 0xC8D75180, 0xBFD06116, 0x21B4F4B5, 0x56B3C423, 0xCFBA9599, 0xB8BDA50F,
                     0x2802B89E, 0x5F058808, 0xC60CD9B2, 0xB10BE924, 0x2F6F7C87, 0x58684C11, 0xC1611DAB, 0xB6662D3D,
                     0x76DC4190, 0x01DB7106, 0x98D220BC, 0xEFD5102A, 0x71B18589, 0x06B6B51F, 0x9FBFE4A5, 0xE8B8D433,
                     0x7807C9A2, 0x0F00F934, 0x9609A88E, 0xE10E9818, 0x7F6A0DBB, 0x086D3D2D, 0x91646C97, 0xE6635C01, 
                     0x6B6B51F4, 0x1C6C6162, 0x856530D8, 0xF262004E, 0x6C0695ED, 0x1B01A57B, 0x8208F4C1, 0xF50FC457, 
                     0x65B0D9C6, 0x12B7E950, 0x8BBEB8EA, 0xFCB9887C, 0x62DD1DDF, 0x15DA2D49, 0x8CD37CF3, 0xFBD44C65, 
                     0x4DB26158, 0x3AB551CE, 0xA3BC0074, 0xD4BB30E2, 0x4ADFA541, 0x3DD895D7, 0xA4D1C46D, 0xD3D6F4FB, 
                     0x4369E96A, 0x346ED9FC, 0xAD678846, 0xDA60B8D0, 0x44042D73, 0x33031DE5, 0xAA0A4C5F, 0xDD0D7CC9, 
                     0x5005713C, 0x270241AA, 0xBE0B1010, 0xC90C2086, 0x5768B525, 0x206F85B3, 0xB966D409, 0xCE61E49F, 
                     0x5EDEF90E, 0x29D9C998, 0xB0D09822, 0xC7D7A8B4, 0x59B33D17, 0x2EB40D81, 0xB7BD5C3B, 0xC0BA6CAD, 
                     0xEDB88320, 0x9ABFB3B6, 0x03B6E20C, 0x74B1D29A, 0xEAD54739, 0x9DD277AF, 0x04DB2615, 0x73DC1683, 
                     0xE3630B12, 0x94643B84, 0x0D6D6A3E, 0x7A6A5AA8, 0xE40ECF0B, 0x9309FF9D, 0x0A00AE27, 0x7D079EB1, 
                     0xF00F9344, 0x8708A3D2, 0x1E01F268, 0x6906C2FE, 0xF762575D, 0x806567CB, 0x196C3671, 0x6E6B06E7, 
                     0xFED41B76, 0x89D32BE0, 0x10DA7A5A, 0x67DD4ACC, 0xF9B9DF6F, 0x8EBEEFF9, 0x17B7BE43, 0x60B08ED5, 
                     0xD6D6A3E8, 0xA1D1937E, 0x38D8C2C4, 0x4FDFF252, 0xD1BB67F1, 0xA6BC5767, 0x3FB506DD, 0x48B2364B, 
                     0xD80D2BDA, 0xAF0A1B4C, 0x36034AF6, 0x41047A60, 0xDF60EFC3, 0xA867DF55, 0x316E8EEF, 0x4669BE79, 
                     0xCB61B38C, 0xBC66831A, 0x256FD2A0, 0x5268E236, 0xCC0C7795, 0xBB0B4703, 0x220216B9, 0x5505262F, 
                     0xC5BA3BBE, 0xB2BD0B28, 0x2BB45A92, 0x5CB36A04, 0xC2D7FFA7, 0xB5D0CF31, 0x2CD99E8B, 0x5BDEAE1D, 
                     0x9B64C2B0, 0xEC63F226, 0x756AA39C, 0x026D930A, 0x9C0906A9, 0xEB0E363F, 0x72076785, 0x05005713, 
                     0x95BF4A82, 0xE2B87A14, 0x7BB12BAE, 0x0CB61B38, 0x92D28E9B, 0xE5D5BE0D, 0x7CDCEFB7, 0x0BDBDF21, 
                     0x86D3D2D4, 0xF1D4E242, 0x68DDB3F8, 0x1FDA836E, 0x81BE16CD, 0xF6B9265B, 0x6FB077E1, 0x18B74777, 
                     0x88085AE6, 0xFF0F6A70, 0x66063BCA, 0x11010B5C, 0x8F659EFF, 0xF862AE69, 0x616BFFD3, 0x166CCF45, 
                     0xA00AE278, 0xD70DD2EE, 0x4E048354, 0x3903B3C2, 0xA7672661, 0xD06016F7, 0x4969474D, 0x3E6E77DB, 
                     0xAED16A4A, 0xD9D65ADC, 0x40DF0B66, 0x37D83BF0, 0xA9BCAE53, 0xDEBB9EC5, 0x47B2CF7F, 0x30B5FFE9, 
                     0xBDBDF21C, 0xCABAC28A, 0x53B39330, 0x24B4A3A6, 0xBAD03605, 0xCDD70693, 0x54DE5729, 0x23D967BF, 
                     0xB3667A2E, 0xC4614AB8, 0x5D681B02, 0x2A6F2B94, 0xB40BBE37, 0xC30C8EA1, 0x5A05DF1B, 0x2D02EF8D];
     
        var crc = -1, y = 0, n = a.length,i;

        for (i = from; i < to; i++) {
            y = (crc ^ a[i]) & 0xFF;
            crc = (crc >>> 8) ^ table[y];
        }
     
        return crc ^ (-1);
    }

    var h = img[0].length, w = img[0][0].length, s1, s2, next,k,length,a,b,i,j,adler32,crc32;
    var stream = [
                  137, 80, 78, 71, 13, 10, 26, 10,                           //  0: PNG signature
                  0,0,0,13,                                                  //  8: IHDR Chunk length
                  73, 72, 68, 82,                                            // 12: "IHDR" 
                  (w >> 24) & 255, (w >> 16) & 255, (w >> 8) & 255, w&255,   // 16: Width
                  (h >> 24) & 255, (h >> 16) & 255, (h >> 8) & 255, h&255,   // 20: Height
                  8,                                                         // 24: bit depth
                  2,                                                         // 25: RGB
                  0,                                                         // 26: deflate
                  0,                                                         // 27: no filter
                  0,                                                         // 28: no interlace
                  -1,-2,-3,-4,                                               // 29: CRC
                  -5,-6,-7,-8,                                               // 33: IDAT Chunk length
                  73, 68, 65, 84,                                            // 37: "IDAT"
                  // RFC 1950 header starts here
                  8,                                                         // 41: RFC1950 CMF
                  29                                                         // 42: RFC1950 FLG
                  ];
    crc32 = crc32Array(stream,12,29);
    stream[29] = (crc32>>24)&255;
    stream[30] = (crc32>>16)&255;
    stream[31] = (crc32>>8)&255;
    stream[32] = (crc32)&255;
    s1 = 1;
    s2 = 0;
    for(i=0;i<h;i++) {
        if(i<h-1) { stream.push(0); }
        else { stream.push(1); }
        a = (3*w+1+(i===0))&255; b = ((3*w+1+(i===0))>>8)&255;
        stream.push(a); stream.push(b);
        stream.push((~a)&255); stream.push((~b)&255);
        if(i===0) stream.push(0);
        for(j=0;j<w;j++) {
            for(k=0;k<3;k++) {
                a = img[k][i][j];
                if(a>255) a = 255;
                else if(a<0) a=0;
                else a = Math.round(a);
                s1 = (s1 + a )%65521;
                s2 = (s2 + s1)%65521;
                stream.push(a);
            }
        }
        stream.push(0);
    }
    adler32 = (s2<<16)+s1;
    stream.push((adler32>>24)&255);
    stream.push((adler32>>16)&255);
    stream.push((adler32>>8)&255);
    stream.push((adler32)&255);
    length = stream.length - 41;
    stream[33] = (length>>24)&255;
    stream[34] = (length>>16)&255;
    stream[35] = (length>>8)&255;
    stream[36] = (length)&255;
    crc32 = crc32Array(stream,37);
    stream.push((crc32>>24)&255);
    stream.push((crc32>>16)&255);
    stream.push((crc32>>8)&255);
    stream.push((crc32)&255);
    stream.push(0);
    stream.push(0);
    stream.push(0);
    stream.push(0);
//    a = stream.length;
    stream.push(73);  // I
    stream.push(69);  // E
    stream.push(78);  // N
    stream.push(68);  // D
    stream.push(174); // CRC1
    stream.push(66);  // CRC2
    stream.push(96);  // CRC3
    stream.push(130); // CRC4
    return 'data:image/png;base64,'+base64(stream);
};

// 2. Linear algebra with Arrays.
numeric._dim = function _dim(x) {
    var ret = [];
    while(typeof x === "object") { ret.push(x.length); x = x[0]; }
    return ret;
};

numeric.dim = function dim(x) {
    var y,z;
    if(typeof x === "object") {
        y = x[0];
        if(typeof y === "object") {
            z = y[0];
            if(typeof z === "object") {
                return numeric._dim(x);
            }
            return [x.length,y.length];
        }
        return [x.length];
    }
    return [];
};

numeric.mapreduce = function mapreduce(body,init) {
    return Function('x','accum','_s','_k',
            'if(typeof accum === "undefined") accum = '+init+';\n'+
            'if(typeof x === "number") { var xi = x; '+body+'; return accum; }\n'+
            'if(typeof _s === "undefined") _s = numeric.dim(x);\n'+
            'if(typeof _k === "undefined") _k = 0;\n'+
            'var _n = _s[_k];\n'+
            'var i,xi;\n'+
            'if(_k < _s.length-1) {\n'+
            '    for(i=_n-1;i>=0;i--) {\n'+
            '        accum = arguments.callee(x[i],accum,_s,_k+1);\n'+
            '    }'+
            '    return accum;\n'+
            '}\n'+
            'for(i=_n-1;i>=1;i-=2) { \n'+
            '    xi = x[i];\n'+
            '    '+body+';\n'+
            '    xi = x[i-1];\n'+
            '    '+body+';\n'+
            '}\n'+
            'if(i === 0) {\n'+
            '    xi = x[i];\n'+
            '    '+body+'\n'+
            '}\n'+
            'return accum;'
            );
};
numeric.mapreduce2 = function mapreduce2(body,setup) {
    return Function('x',
            'var n = x.length;\n'+
            'var i,xi;\n'+setup+';\n'+
            'for(i=n-1;i!==-1;--i) { \n'+
            '    xi = x[i];\n'+
            '    '+body+';\n'+
            '}\n'+
            'return accum;'
            );
};


numeric.same = function same(x,y) {
    var i,n;
    if(!(x instanceof Array) || !(y instanceof Array)) { return false; }
    n = x.length;
    if(n !== y.length) { return false; }
    for(i=0;i<n;i++) {
        if(x[i] === y[i]) { continue; }
        if(typeof x[i] === "object") { if(!same(x[i],y[i])) return false; }
        else { return false; }
    }
    return true;
};

numeric.rep = function rep(s,v,k) {
    if(typeof k === "undefined") { k=0; }
    var n = s[k], ret = Array(n), i;
    if(k === s.length-1) {
        for(i=n-2;i>=0;i-=2) { ret[i+1] = v; ret[i] = v; }
        if(i===-1) { ret[0] = v; }
        return ret;
    }
    for(i=n-1;i>=0;i--) { ret[i] = numeric.rep(s,v,k+1); }
    return ret;
};


numeric.dotMMsmall = function dotMMsmall(x,y) {
    var i,j,k,p,q,r,ret,foo,bar,woo,i0,k0,p0,r0;
    p = x.length; q = y.length; r = y[0].length;
    ret = Array(p);
    for(i=p-1;i>=0;i--) {
        foo = Array(r);
        bar = x[i];
        for(k=r-1;k>=0;k--) {
            woo = bar[q-1]*y[q-1][k];
            for(j=q-2;j>=1;j-=2) {
                i0 = j-1;
                woo += bar[j]*y[j][k] + bar[i0]*y[i0][k];
            }
            if(j===0) { woo += bar[0]*y[0][k]; }
            foo[k] = woo;
        }
        ret[i] = foo;
    }
    return ret;
};
numeric._getCol = function _getCol(A,j,x) {
    var n = A.length, i;
    for(i=n-1;i>0;--i) {
        x[i] = A[i][j];
        --i;
        x[i] = A[i][j];
    }
    if(i===0) x[0] = A[0][j];
};
numeric.dotMMbig = function dotMMbig(x,y){
    var gc = numeric._getCol, p = y.length, v = Array(p);
    var m = x.length, n = y[0].length, A = new Array(m), xj;
    var VV = numeric.dotVV;
    var i,j,k,z;
    --p;
    --m;
    for(i=m;i!==-1;--i) A[i] = Array(n);
    --n;
    for(i=n;i!==-1;--i) {
        gc(y,i,v);
        for(j=m;j!==-1;--j) {
            z=0;
            xj = x[j];
            A[j][i] = VV(xj,v);
        }
    }
    return A;
};

numeric.dotMV = function dotMV(x,y) {
    var p = x.length, q = y.length,i;
    var ret = Array(p), dotVV = numeric.dotVV;
    for(i=p-1;i>=0;i--) { ret[i] = dotVV(x[i],y); }
    return ret;
};

numeric.dotVM = function dotVM(x,y) {
    var i,j,k,p,q,r,ret,foo,bar,woo,i0,k0,p0,r0,s1,s2,s3,baz,accum;
    p = x.length; q = y[0].length;
    ret = Array(q);
    for(k=q-1;k>=0;k--) {
        woo = x[p-1]*y[p-1][k];
        for(j=p-2;j>=1;j-=2) {
            i0 = j-1;
            woo += x[j]*y[j][k] + x[i0]*y[i0][k];
        }
        if(j===0) { woo += x[0]*y[0][k]; }
        ret[k] = woo;
    }
    return ret;
};

numeric.dotVV = function dotVV(x,y) {
    var i,n=x.length,i1,ret = x[n-1]*y[n-1];
    for(i=n-2;i>=1;i-=2) {
        i1 = i-1;
        ret += x[i]*y[i] + x[i1]*y[i1];
    }
    if(i===0) { ret += x[0]*y[0]; }
    return ret;
};

numeric.dot = function dot(x,y) {
    var d = numeric.dim;
    switch(d(x).length*1000+d(y).length) {
    case 2002:
        if(y.length < 10) return numeric.dotMMsmall(x,y);
        else return numeric.dotMMbig(x,y);
    case 2001: return numeric.dotMV(x,y);
    case 1002: return numeric.dotVM(x,y);
    case 1001: return numeric.dotVV(x,y);
    case 1000: return numeric.mulVS(x,y);
    case 1: return numeric.mulSV(x,y);
    case 0: return x*y;
    default: throw new Error('numeric.dot only works on vectors and matrices');
    }
};

numeric.diag = function diag(d) {
    var i,i1,j,n = d.length, A = Array(n), Ai;
    for(i=n-1;i>=0;i--) {
        Ai = Array(n);
        i1 = i+2;
        for(j=n-1;j>=i1;j-=2) {
            Ai[j] = 0;
            Ai[j-1] = 0;
        }
        if(j>i) { Ai[j] = 0; }
        Ai[i] = d[i];
        for(j=i-1;j>=1;j-=2) {
            Ai[j] = 0;
            Ai[j-1] = 0;
        }
        if(j===0) { Ai[0] = 0; }
        A[i] = Ai;
    }
    return A;
};
numeric.getDiag = function(A) {
    var n = Math.min(A.length,A[0].length),i,ret = Array(n);
    for(i=n-1;i>=1;--i) {
        ret[i] = A[i][i];
        --i;
        ret[i] = A[i][i];
    }
    if(i===0) {
        ret[0] = A[0][0];
    }
    return ret;
};

numeric.identity = function identity(n) { return numeric.diag(numeric.rep([n],1)); };
numeric.pointwise = function pointwise(params,body,setup) {
    if(typeof setup === "undefined") { setup = ""; }
    var fun = [];
    var k;
    var avec = /\[i\]$/,p,thevec = '';
    var haveret = false;
    for(k=0;k<params.length;k++) {
        if(avec.test(params[k])) {
            p = params[k].substring(0,params[k].length-3);
            thevec = p;
        } else { p = params[k]; }
        if(p==='ret') haveret = true;
        fun.push(p);
    }
    fun[params.length] = '_s';
    fun[params.length+1] = '_k';
    fun[params.length+2] = (
            'if(typeof _s === "undefined") _s = numeric.dim('+thevec+');\n'+
            'if(typeof _k === "undefined") _k = 0;\n'+
            'var _n = _s[_k];\n'+
            'var i'+(haveret?'':', ret = Array(_n)')+';\n'+
            'if(_k < _s.length-1) {\n'+
            '    for(i=_n-1;i>=0;i--) ret[i] = arguments.callee('+params.join(',')+',_s,_k+1);\n'+
            '    return ret;\n'+
            '}\n'+
            setup+'\n'+
            'for(i=_n-1;i!==-1;--i) {\n'+
            '    '+body+'\n'+
            '}\n'+
            'return ret;'
            );
    return Function.apply(null,fun);
};
numeric.pointwise2 = function pointwise2(params,body,setup) {
    if(typeof setup === "undefined") { setup = ""; }
    var fun = [];
    var k;
    var avec = /\[i\]$/,p,thevec = '';
    var haveret = false;
    for(k=0;k<params.length;k++) {
        if(avec.test(params[k])) {
            p = params[k].substring(0,params[k].length-3);
            thevec = p;
        } else { p = params[k]; }
        if(p==='ret') haveret = true;
        fun.push(p);
    }
    fun[params.length] = (
            'var _n = '+thevec+'.length;\n'+
            'var i'+(haveret?'':', ret = Array(_n)')+';\n'+
            setup+'\n'+
            'for(i=_n-1;i!==-1;--i) {\n'+
            body+'\n'+
            '}\n'+
            'return ret;'
            );
    return Function.apply(null,fun);
};
numeric._biforeach = (function _biforeach(x,y,s,k,f) {
    if(k === s.length-1) { f(x,y); return; }
    var i,n=s[k];
    for(i=n-1;i>=0;i--) { _biforeach(typeof x==="object"?x[i]:x,typeof y==="object"?y[i]:y,s,k+1,f); }
});
numeric._biforeach2 = (function _biforeach2(x,y,s,k,f) {
    if(k === s.length-1) { return f(x,y); }
    var i,n=s[k],ret = Array(n);
    for(i=n-1;i>=0;--i) { ret[i] = _biforeach2(typeof x==="object"?x[i]:x,typeof y==="object"?y[i]:y,s,k+1,f); }
    return ret;
});
numeric._foreach = (function _foreach(x,s,k,f) {
    if(k === s.length-1) { f(x); return; }
    var i,n=s[k];
    for(i=n-1;i>=0;i--) { _foreach(x[i],s,k+1,f); }
});
numeric._foreach2 = (function _foreach2(x,s,k,f) {
    if(k === s.length-1) { return f(x); }
    var i,n=s[k], ret = Array(n);
    for(i=n-1;i>=0;i--) { ret[i] = _foreach2(x[i],s,k+1,f); }
    return ret;
});

/*numeric.anyV = numeric.mapreduce('if(xi) return true;','false');
numeric.allV = numeric.mapreduce('if(!xi) return false;','true');
numeric.any = function(x) { if(typeof x.length === "undefined") return x; return numeric.anyV(x); }
numeric.all = function(x) { if(typeof x.length === "undefined") return x; return numeric.allV(x); }*/

numeric.ops2 = {
        add: '+',
        sub: '-',
        mul: '*',
        div: '/',
        mod: '%',
        and: '&&',
        or:  '||',
        eq:  '===',
        neq: '!==',
        lt:  '<',
        gt:  '>',
        leq: '<=',
        geq: '>=',
        band: '&',
        bor: '|',
        bxor: '^',
        lshift: '<<',
        rshift: '>>',
        rrshift: '>>>'
};
numeric.opseq = {
        addeq: '+=',
        subeq: '-=',
        muleq: '*=',
        diveq: '/=',
        modeq: '%=',
        lshifteq: '<<=',
        rshifteq: '>>=',
        rrshifteq: '>>>=',
        bandeq: '&=',
        boreq: '|=',
        bxoreq: '^='
};
numeric.mathfuns = ['abs','acos','asin','atan','ceil','cos',
                    'exp','floor','log','round','sin','sqrt','tan',
                    'isNaN','isFinite'];
numeric.mathfuns2 = ['atan2','pow','max','min'];
numeric.ops1 = {
        neg: '-',
        not: '!',
        bnot: '~',
        clone: ''
};
numeric.mapreducers = {
        any: ['if(xi) return true;','var accum = false;'],
        all: ['if(!xi) return false;','var accum = true;'],
        sum: ['accum += xi;','var accum = 0;'],
        prod: ['accum *= xi;','var accum = 1;'],
        norm2Squared: ['accum += xi*xi;','var accum = 0;'],
        norminf: ['accum = max(accum,abs(xi));','var accum = 0, max = Math.max, abs = Math.abs;'],
        norm1: ['accum += abs(xi)','var accum = 0, abs = Math.abs;'],
        sup: ['accum = max(accum,xi);','var accum = -Infinity, max = Math.max;'],
        inf: ['accum = min(accum,xi);','var accum = Infinity, min = Math.min;']
};

(function () {
    var i,o;
    for(i=0;i<numeric.mathfuns2.length;++i) {
        o = numeric.mathfuns2[i];
        numeric.ops2[o] = o;
    }
    for(i in numeric.ops2) {
        if(numeric.ops2.hasOwnProperty(i)) {
            o = numeric.ops2[i];
            var code, codeeq, setup = '';
            if(numeric.myIndexOf.call(numeric.mathfuns2,i)!==-1) {
                setup = 'var '+o+' = Math.'+o+';\n';
                code = function(r,x,y) { return r+' = '+o+'('+x+','+y+')'; };
                codeeq = function(x,y) { return x+' = '+o+'('+x+','+y+')'; };
            } else {
                code = function(r,x,y) { return r+' = '+x+' '+o+' '+y; };
                if(numeric.opseq.hasOwnProperty(i+'eq')) {
                    codeeq = function(x,y) { return x+' '+o+'= '+y; };
                } else {
                    codeeq = function(x,y) { return x+' = '+x+' '+o+' '+y; };                    
                }
            }
            numeric[i+'VV'] = numeric.pointwise2(['x[i]','y[i]'],code('ret[i]','x[i]','y[i]'),setup);
            numeric[i+'SV'] = numeric.pointwise2(['x','y[i]'],code('ret[i]','x','y[i]'),setup);
            numeric[i+'VS'] = numeric.pointwise2(['x[i]','y'],code('ret[i]','x[i]','y'),setup);
            numeric[i] = Function(
                    'var n = arguments.length, i, x = arguments[0], y;\n'+
                    'var VV = numeric.'+i+'VV, VS = numeric.'+i+'VS, SV = numeric.'+i+'SV;\n'+
                    'var dim = numeric.dim;\n'+
                    'for(i=1;i!==n;++i) { \n'+
                    '  y = arguments[i];\n'+
                    '  if(typeof x === "object") {\n'+
                    '      if(typeof y === "object") x = numeric._biforeach2(x,y,dim(x),0,VV);\n'+
                    '      else x = numeric._biforeach2(x,y,dim(x),0,VS);\n'+
                    '  } else if(typeof y === "object") x = numeric._biforeach2(x,y,dim(y),0,SV);\n'+
                    '  else '+codeeq('x','y')+'\n'+
                    '}\nreturn x;\n');
            numeric[o] = numeric[i];
            numeric[i+'eqV'] = numeric.pointwise2(['ret[i]','x[i]'], codeeq('ret[i]','x[i]'),setup);
            numeric[i+'eqS'] = numeric.pointwise2(['ret[i]','x'], codeeq('ret[i]','x'),setup);
            numeric[i+'eq'] = Function(
                    'var n = arguments.length, i, x = arguments[0], y;\n'+
                    'var V = numeric.'+i+'eqV, S = numeric.'+i+'eqS\n'+
                    'var s = numeric.dim(x);\n'+
                    'for(i=1;i!==n;++i) { \n'+
                    '  y = arguments[i];\n'+
                    '  if(typeof y === "object") numeric._biforeach(x,y,s,0,V);\n'+
                    '  else numeric._biforeach(x,y,s,0,S);\n'+
                    '}\nreturn x;\n');
        }
    }
    for(i=0;i<numeric.mathfuns2.length;++i) {
        o = numeric.mathfuns2[i];
        delete numeric.ops2[o];
    }
    for(i=0;i<numeric.mathfuns.length;++i) {
        o = numeric.mathfuns[i];
        numeric.ops1[o] = o;
    }
    for(i in numeric.ops1) {
        if(numeric.ops1.hasOwnProperty(i)) {
            setup = '';
            o = numeric.ops1[i];
            if(numeric.myIndexOf.call(numeric.mathfuns,i)!==-1) {
                if(Math.hasOwnProperty(o)) setup = 'var '+o+' = Math.'+o+';\n';
            }
            numeric[i+'eqV'] = numeric.pointwise2(['ret[i]'],'ret[i] = '+o+'(ret[i]);',setup);
            numeric[i+'eq'] = Function('x',
                    'if(typeof x !== "object") return '+o+'x\n'+
                    'var i;\n'+
                    'var V = numeric.'+i+'eqV;\n'+
                    'var s = numeric.dim(x);\n'+
                    'numeric._foreach(x,s,0,V);\n'+
                    'return x;\n');
            numeric[i+'V'] = numeric.pointwise2(['x[i]'],'ret[i] = '+o+'(x[i]);',setup);
            numeric[i] = Function('x',
                    'if(typeof x !== "object") return '+o+'(x)\n'+
                    'var i;\n'+
                    'var V = numeric.'+i+'V;\n'+
                    'var s = numeric.dim(x);\n'+
                    'return numeric._foreach2(x,s,0,V);\n');
        }
    }
    for(i=0;i<numeric.mathfuns.length;++i) {
        o = numeric.mathfuns[i];
        delete numeric.ops1[o];
    }
    for(i in numeric.mapreducers) {
        if(numeric.mapreducers.hasOwnProperty(i)) {
            o = numeric.mapreducers[i];
            numeric[i+'V'] = numeric.mapreduce2(o[0],o[1]);
            numeric[i] = Function('x','s','k',
                    o[1]+
                    'if(typeof x !== "object") {'+
                    '    xi = x;\n'+
                    o[0]+';\n'+
                    '    return accum;\n'+
                    '}'+
                    'if(typeof s === "undefined") s = numeric.dim(x);\n'+
                    'if(typeof k === "undefined") k = 0;\n'+
                    'if(k === s.length-1) return numeric.'+i+'V(x);\n'+
                    'var xi;\n'+
                    'var n = x.length, i;\n'+
                    'for(i=n-1;i!==-1;--i) {\n'+
                    '   xi = arguments.callee(x[i]);\n'+
                    o[0]+';\n'+
                    '}\n'+
                    'return accum;\n');
        }
    }
}());

numeric.truncVV = numeric.pointwise(['x[i]','y[i]'],'ret[i] = round(x[i]/y[i])*y[i];','var round = Math.round;');
numeric.truncVS = numeric.pointwise(['x[i]','y'],'ret[i] = round(x[i]/y)*y;','var round = Math.round;');
numeric.truncSV = numeric.pointwise(['x','y[i]'],'ret[i] = round(x/y[i])*y[i];','var round = Math.round;');
numeric.trunc = function trunc(x,y) {
    if(typeof x === "object") {
        if(typeof y === "object") return numeric.truncVV(x,y);
        return numeric.truncVS(x,y);
    }
    if (typeof y === "object") return numeric.truncSV(x,y);
    return Math.round(x/y)*y;
};

numeric.inv = function inv(x) {
    var s = numeric.dim(x), abs = Math.abs, m = s[0], n = s[1];
    var A = numeric.clone(x), Ai, Aj;
    var I = numeric.identity(m), Ii, Ij;
    var i,j,k,x;
    for(j=0;j<n;++j) {
        var i0 = -1;
        var v0 = -1;
        for(i=j;i!==m;++i) { k = abs(A[i][j]); if(k>v0) { i0 = i; v0 = k; } }
        Aj = A[i0]; A[i0] = A[j]; A[j] = Aj;
        Ij = I[i0]; I[i0] = I[j]; I[j] = Ij;
        x = Aj[j];
        for(k=j;k!==n;++k)    Aj[k] /= x; 
        for(k=n-1;k!==-1;--k) Ij[k] /= x;
        for(i=m-1;i!==-1;--i) {
            if(i!==j) {
                Ai = A[i];
                Ii = I[i];
                x = Ai[j];
                for(k=j+1;k!==n;++k)  Ai[k] -= Aj[k]*x;
                for(k=n-1;k>0;--k) { Ii[k] -= Ij[k]*x; --k; Ii[k] -= Ij[k]*x; }
                if(k===0) Ii[0] -= Ij[0]*x;
            }
        }
    }
    return I;
};

numeric.det = function det(x) {
    var s = numeric.dim(x);
    if(s.length !== 2 || s[0] !== s[1]) { throw new Error('numeric: det() only works on square matrices'); }
    var n = s[0], ret = 1,i,j,k,A = numeric.clone(x),Aj,Ai,alpha,temp,k1,k2,k3;
    for(j=0;j<n-1;j++) {
        k=j;
        for(i=j+1;i<n;i++) { if(Math.abs(A[i][j]) > Math.abs(A[k][j])) { k = i; } }
        if(k !== j) {
            temp = A[k]; A[k] = A[j]; A[j] = temp;
            ret *= -1;
        }
        Aj = A[j];
        for(i=j+1;i<n;i++) {
            Ai = A[i];
            alpha = Ai[j]/Aj[j];
            for(k=j+1;k<n-1;k+=2) {
                k1 = k+1;
                Ai[k] -= Aj[k]*alpha;
                Ai[k1] -= Aj[k1]*alpha;
            }
            if(k!==n) { Ai[k] -= Aj[k]*alpha; }
        }
        if(Aj[j] === 0) { return 0; }
        ret *= Aj[j];
    }
    return ret*A[j][j];
};

numeric.transpose = function transpose(x) {
    var i,j,m = x.length,n = x[0].length, ret=Array(n),A0,A1,Bj;
    for(j=0;j<n;j++) ret[j] = Array(m);
    for(i=m-1;i>=1;i-=2) {
        A1 = x[i];
        A0 = x[i-1];
        for(j=n-1;j>=1;--j) {
            Bj = ret[j]; Bj[i] = A1[j]; Bj[i-1] = A0[j];
            --j;
            Bj = ret[j]; Bj[i] = A1[j]; Bj[i-1] = A0[j];
        }
        if(j===0) {
            Bj = ret[0]; Bj[i] = A1[0]; Bj[i-1] = A0[0];
        }
    }
    if(i===0) {
        A0 = x[0];
        for(j=n-1;j>=1;--j) {
            ret[j][0] = A0[j];
            --j;
            ret[j][0] = A0[j];
        }
        if(j===0) { ret[0][0] = A0[0]; }
    }
    return ret;
};
numeric.negtranspose = function negtranspose(x) {
    var i,j,m = x.length,n = x[0].length, ret=Array(n),A0,A1,Bj;
    for(j=0;j<n;j++) ret[j] = Array(m);
    for(i=m-1;i>=1;i-=2) {
        A1 = x[i];
        A0 = x[i-1];
        for(j=n-1;j>=1;--j) {
            Bj = ret[j]; Bj[i] = -A1[j]; Bj[i-1] = -A0[j];
            --j;
            Bj = ret[j]; Bj[i] = -A1[j]; Bj[i-1] = -A0[j];
        }
        if(j===0) {
            Bj = ret[0]; Bj[i] = -A1[0]; Bj[i-1] = -A0[0];
        }
    }
    if(i===0) {
        A0 = x[0];
        for(j=n-1;j>=1;--j) {
            ret[j][0] = -A0[j];
            --j;
            ret[j][0] = -A0[j];
        }
        if(j===0) { ret[0][0] = -A0[0]; }
    }
    return ret;
};

numeric._random = function _random(s,k) {
    var i,n=s[k],ret=Array(n), rnd;
    if(k === s.length-1) {
        rnd = Math.random;
        for(i=n-1;i>=1;i-=2) {
            ret[i] = rnd();
            ret[i-1] = rnd();
        }
        if(i===0) { ret[0] = rnd(); }
        return ret;
    }
    for(i=n-1;i>=0;i--) ret[i] = _random(s,k+1);
    return ret;
};
numeric.random = function random(s) { return numeric._random(s,0); };

numeric.norm2 = function norm2(x) { return Math.sqrt(numeric.norm2Squared(x)); };

numeric.linspace = function linspace(a,b,n) {
    if(typeof n === "undefined") n = Math.max(Math.round(b-a)+1,1);
    if(n<2) { return n===1?[a]:[]; }
    var i,ret = Array(n);
    n--;
    for(i=n;i>=0;i--) { ret[i] = (i*b+(n-i)*a)/n; }
    return ret;
};

numeric.getBlock = function getBlock(x,from,to) {
    var s = numeric.dim(x);
    function foo(x,k) {
        var i,a = from[k], n = to[k]-a, ret = Array(n);
        if(k === s.length-1) {
            for(i=n;i>=0;i--) { ret[i] = x[i+a]; }
            return ret;
        }
        for(i=n;i>=0;i--) { ret[i] = foo(x[i+a],k+1); }
        return ret;
    }
    return foo(x,0);
};

numeric.setBlock = function setBlock(x,from,to,B) {
    var s = numeric.dim(x);
    function foo(x,y,k) {
        var i,a = from[k], n = to[k]-a;
        if(k === s.length-1) { for(i=n;i>=0;i--) { x[i+a] = y[i]; } }
        for(i=n;i>=0;i--) { foo(x[i+a],y[i],k+1); }
    }
    foo(x,B,0);
    return x;
};

numeric.getRange = function getRange(A,I,J) {
    var m = I.length, n = J.length;
    var i,j;
    var B = Array(m), Bi, AI;
    for(i=m-1;i!==-1;--i) {
        B[i] = Array(n);
        Bi = B[i];
        AI = A[I[i]];
        for(j=n-1;j!==-1;--j) Bi[j] = AI[J[j]];
    }
    return B;
};

numeric.blockMatrix = function blockMatrix(X) {
    var s = numeric.dim(X);
    if(s.length<4) return numeric.blockMatrix([X]);
    var m=s[0],n=s[1],M,N,i,j,Xij;
    M = 0; N = 0;
    for(i=0;i<m;++i) M+=X[i][0].length;
    for(j=0;j<n;++j) N+=X[0][j][0].length;
    var Z = Array(M);
    for(i=0;i<M;++i) Z[i] = Array(N);
    var I=0,J,ZI,k,l,Xijk;
    for(i=0;i<m;++i) {
        J=N;
        for(j=n-1;j!==-1;--j) {
            Xij = X[i][j];
            J -= Xij[0].length;
            for(k=Xij.length-1;k!==-1;--k) {
                Xijk = Xij[k];
                ZI = Z[I+k];
                for(l = Xijk.length-1;l!==-1;--l) ZI[J+l] = Xijk[l];
            }
        }
        I += X[i][0].length;
    }
    return Z;
};

numeric.tensor = function tensor(x,y) {
    if(typeof x === "number" || typeof y === "number") return numeric.mul(x,y);
    var s1 = numeric.dim(x), s2 = numeric.dim(y);
    if(s1.length !== 1 || s2.length !== 1) {
        throw new Error('numeric: tensor product is only defined for vectors');
    }
    var m = s1[0], n = s2[0], A = Array(m), Ai, i,j,xi;
    for(i=m-1;i>=0;i--) {
        Ai = Array(n);
        xi = x[i];
        for(j=n-1;j>=3;--j) {
            Ai[j] = xi * y[j];
            --j;
            Ai[j] = xi * y[j];
            --j;
            Ai[j] = xi * y[j];
            --j;
            Ai[j] = xi * y[j];
        }
        while(j>=0) { Ai[j] = xi * y[j]; --j; }
        A[i] = Ai;
    }
    return A;
};

// 3. The Tensor type T
numeric.T = function T(x,y) { this.x = x; this.y = y; };
numeric.t = function t(x,y) { return new numeric.T(x,y); };

numeric.Tbinop = function Tbinop(rr,rc,cr,cc,setup) {
    var io = numeric.indexOf;
    if(typeof setup !== "string") {
        var k;
        setup = '';
        for(k in numeric) {
            if(numeric.hasOwnProperty(k) && (rr.indexOf(k)>=0 || rc.indexOf(k)>=0 || cr.indexOf(k)>=0 || cc.indexOf(k)>=0) && k.length>1) {
                setup += 'var '+k+' = numeric.'+k+';\n';
            }
        }
    }
    return Function(['y'],
            'var x = this;\n'+
            'if(!(y instanceof numeric.T)) { y = new numeric.T(y); }\n'+
            setup+'\n'+
            'if(x.y) {'+
            '  if(y.y) {'+
            '    return new numeric.T('+cc+');\n'+
            '  }\n'+
            '  return new numeric.T('+cr+');\n'+
            '}\n'+
            'if(y.y) {\n'+
            '  return new numeric.T('+rc+');\n'+
            '}\n'+
            'return new numeric.T('+rr+');\n'
    );
};

numeric.T.prototype.add = numeric.Tbinop(
        'add(x.x,y.x)',
        'add(x.x,y.x),y.y',
        'add(x.x,y.x),x.y',
        'add(x.x,y.x),add(x.y,y.y)');
numeric.T.prototype.sub = numeric.Tbinop(
        'sub(x.x,y.x)',
        'sub(x.x,y.x),neg(y.y)',
        'sub(x.x,y.x),x.y',
        'sub(x.x,y.x),sub(x.y,y.y)');
numeric.T.prototype.mul = numeric.Tbinop(
        'mul(x.x,y.x)',
        'mul(x.x,y.x),mul(x.x,y.y)',
        'mul(x.x,y.x),mul(x.y,y.x)',
        'sub(mul(x.x,y.x),mul(x.y,y.y)),add(mul(x.x,y.y),mul(x.y,y.x))');

numeric.T.prototype.reciprocal = function reciprocal() {
    var mul = numeric.mul, div = numeric.div;
    if(this.y) {
        var d = numeric.add(mul(this.x,this.x),mul(this.y,this.y));
        return new numeric.T(div(this.x,d),div(numeric.neg(this.y),d));
    }
    return new T(div(1,this.x));
};
numeric.T.prototype.div = function div(y) {
    if(!(y instanceof numeric.T)) y = new numeric.T(y);
    if(y.y) { return this.mul(y.reciprocal()); }
    var div = numeric.div;
    if(this.y) { return new numeric.T(div(this.x,y.x),div(this.y,y.x)); }
    return new numeric.T(div(this.x,y.x));
};
numeric.T.prototype.dot = numeric.Tbinop(
        'dot(x.x,y.x)',
        'dot(x.x,y.x),dot(x.x,y.y)',
        'dot(x.x,y.x),dot(x.y,y.x)',
        'sub(dot(x.x,y.x),dot(x.y,y.y)),add(dot(x.x,y.y),dot(x.y,y.x))'
        );
numeric.T.prototype.transpose = function transpose() {
    var t = numeric.transpose, x = this.x, y = this.y;
    if(y) { return new numeric.T(t(x),t(y)); }
    return new numeric.T(t(x));
};
numeric.T.prototype.transjugate = function transjugate() {
    var t = numeric.transpose, x = this.x, y = this.y;
    if(y) { return new numeric.T(t(x),numeric.negtranspose(y)); }
    return new numeric.T(t(x));
};
numeric.Tunop = function Tunop(r,c,s) {
    if(typeof s !== "string") { s = ''; }
    return Function(
            'var x = this;\n'+
            s+'\n'+
            'if(x.y) {'+
            '  '+c+';\n'+
            '}\n'+
            r+';\n'
    );
};

numeric.T.prototype.exp = numeric.Tunop(
        'return new numeric.T(ex)',
        'return new numeric.T(mul(cos(x.y),ex),mul(sin(x.y),ex))',
        'var ex = numeric.exp(x.x), cos = numeric.cos, sin = numeric.sin, mul = numeric.mul;');
numeric.T.prototype.conj = numeric.Tunop(
        'return new numeric.T(x.x);',
        'return new numeric.T(x.x,numeric.neg(x.y));');
numeric.T.prototype.neg = numeric.Tunop(
        'return new numeric.T(neg(x.x));',
        'return new numeric.T(neg(x.x),neg(x.y));',
        'var neg = numeric.neg;');
numeric.T.prototype.sin = numeric.Tunop(
        'return new numeric.T(numeric.sin(x.x))',
        'return x.exp().sub(x.neg().exp()).div(new numeric.T(0,2));');
numeric.T.prototype.cos = numeric.Tunop(
        'return new numeric.T(numeric.cos(x.x))',
        'return x.exp().add(x.neg().exp()).div(2);');
numeric.T.prototype.abs = numeric.Tunop(
        'return new numeric.T(numeric.abs(x.x));',
        'return new numeric.T(numeric.sqrt(numeric.add(mul(x.x,x.x),mul(x.y,x.y))));',
        'var mul = numeric.mul;');
numeric.T.prototype.log = numeric.Tunop(
        'return new numeric.T(numeric.log(x.x));',
        'var theta = new numeric.T(numeric.atan2(x.y,x.x)), r = x.abs();\n'+
        'return new numeric.T(numeric.log(r.x),theta.x);');
numeric.T.prototype.norm2 = numeric.Tunop(
        'return numeric.norm2(x.x);',
        'var f = numeric.norm2Squared;\n'+
        'return Math.sqrt(f(x.x)+f(x.y));');
numeric.T.prototype.inv = function inv() {
    var A = this;
    if(typeof A.y === "undefined") { return new numeric.T(numeric.inv(A.x)); }
    var n = A.x.length, i, j, k;
    var Rx = numeric.identity(n),Ry = numeric.rep([n,n],0);
    var Ax = numeric.clone(A.x), Ay = numeric.clone(A.y);
    var Aix, Aiy, Ajx, Ajy, Rix, Riy, Rjx, Rjy;
    var i,j,k,d,d1,ax,ay,bx,by,temp;
    for(i=0;i<n;i++) {
        ax = Ax[i][i]; ay = Ay[i][i];
        d = ax*ax+ay*ay;
        k = i;
        for(j=i+1;j<n;j++) {
            ax = Ax[j][i]; ay = Ay[j][i];
            d1 = ax*ax+ay*ay;
            if(d1 > d) { k=j; d = d1; }
        }
        if(k!==i) {
            temp = Ax[i]; Ax[i] = Ax[k]; Ax[k] = temp;
            temp = Ay[i]; Ay[i] = Ay[k]; Ay[k] = temp;
            temp = Rx[i]; Rx[i] = Rx[k]; Rx[k] = temp;
            temp = Ry[i]; Ry[i] = Ry[k]; Ry[k] = temp;
        }
        Aix = Ax[i]; Aiy = Ay[i];
        Rix = Rx[i]; Riy = Ry[i];
        ax = Aix[i]; ay = Aiy[i];
        for(j=i+1;j<n;j++) {
            bx = Aix[j]; by = Aiy[j];
            Aix[j] = (bx*ax+by*ay)/d;
            Aiy[j] = (by*ax-bx*ay)/d;
        }
        for(j=0;j<n;j++) {
            bx = Rix[j]; by = Riy[j];
            Rix[j] = (bx*ax+by*ay)/d;
            Riy[j] = (by*ax-bx*ay)/d;
        }
        for(j=i+1;j<n;j++) {
            Ajx = Ax[j]; Ajy = Ay[j];
            Rjx = Rx[j]; Rjy = Ry[j];
            ax = Ajx[i]; ay = Ajy[i];
            for(k=i+1;k<n;k++) {
                bx = Aix[k]; by = Aiy[k];
                Ajx[k] -= bx*ax-by*ay;
                Ajy[k] -= by*ax+bx*ay;
            }
            for(k=0;k<n;k++) {
                bx = Rix[k]; by = Riy[k];
                Rjx[k] -= bx*ax-by*ay;
                Rjy[k] -= by*ax+bx*ay;
            }
        }
    }
    for(i=n-1;i>0;i--) {
        Rix = Rx[i]; Riy = Ry[i];
        for(j=i-1;j>=0;j--) {
            Rjx = Rx[j]; Rjy = Ry[j];
            ax = Ax[j][i]; ay = Ay[j][i];
            for(k=n-1;k>=0;k--) {
                bx = Rix[k]; by = Riy[k];
                Rjx[k] -= ax*bx - ay*by;
                Rjy[k] -= ax*by + ay*bx;
            }
        }
    }
    return new numeric.T(Rx,Ry);
};
numeric.T.prototype.get = function get(i) {
    var x = this.x, y = this.y, k = 0, ik, n = i.length;
    if(y) {
        while(k<n) {
            ik = i[k];
            x = x[ik];
            y = y[ik];
            k++;
        }
        return new numeric.T(x,y);
    }
    while(k<n) {
        ik = i[k];
        x = x[ik];
        k++;
    }
    return new numeric.T(x);
};
numeric.T.prototype.set = function set(i,v) {
    var x = this.x, y = this.y, k = 0, ik, n = i.length, vx = v.x, vy = v.y;
    if(n===0) {
        if(vy) { this.y = vy; }
        else if(y) { this.y = undefined; }
        this.x = x;
        return this;
    }
    if(vy) {
        if(y) { /* ok */ }
        else {
            y = numeric.rep(numeric.dim(x),0);
            this.y = y;
        }
        while(k<n-1) {
            ik = i[k];
            x = x[ik];
            y = y[ik];
            k++;
        }
        ik = i[k];
        x[ik] = vx;
        y[ik] = vy;
        return this;
    }
    if(y) {
        while(k<n-1) {
            ik = i[k];
            x = x[ik];
            y = y[ik];
            k++;
        }
        ik = i[k];
        x[ik] = vx;
        if(vx instanceof Array) y[ik] = numeric.rep(numeric.dim(vx),0);
        else y[ik] = 0;
        return this;
    }
    while(k<n-1) {
        ik = i[k];
        x = x[ik];
        k++;
    }
    ik = i[k];
    x[ik] = vx;
    return this;
};
numeric.T.prototype.getRows = function getRows(i0,i1) {
    var n = i1-i0+1, j;
    var rx = Array(n), ry, x = this.x, y = this.y;
    for(j=i0;j<=i1;j++) { rx[j-i0] = x[j]; }
    if(y) {
        ry = Array(n);
        for(j=i0;j<=i1;j++) { ry[j-i0] = y[j]; }
        return new numeric.T(rx,ry);
    }
    return new numeric.T(rx);
};
numeric.T.prototype.setRows = function setRows(i0,i1,A) {
    var j;
    var rx = this.x, ry = this.y, x = A.x, y = A.y;
    for(j=i0;j<=i1;j++) { rx[j] = x[j-i0]; }
    if(y) {
        if(!ry) { ry = numeric.rep(numeric.dim(rx),0); this.y = ry; }
        for(j=i0;j<=i1;j++) { ry[j] = y[j-i0]; }
    } else if(ry) {
        for(j=i0;j<=i1;j++) { ry[j] = numeric.rep([x[j-i0].length],0); }
    }
    return this;
};
numeric.T.prototype.getRow = function getRow(k) {
    var x = this.x, y = this.y;
    if(y) { return new numeric.T(x[k],y[k]); }
    return new numeric.T(x[k]);
};
numeric.T.prototype.setRow = function setRow(i,v) {
    var rx = this.x, ry = this.y, x = v.x, y = v.y;
    rx[i] = x;
    if(y) {
        if(!ry) { ry = numeric.rep(numeric.dim(rx),0); this.y = ry; }
        ry[i] = y;
    } else if(ry) {
        ry = numeric.rep([x.length],0);
    }
    return this;
};

numeric.T.prototype.getBlock = function getBlock(from,to) {
    var x = this.x, y = this.y, b = numeric.getBlock;
    if(y) { return new numeric.T(b(x,from,to),b(y,from,to)); }
    return new numeric.T(b(x,from,to));
};
numeric.T.prototype.setBlock = function setBlock(from,to,A) {
    if(!(A instanceof numeric.T)) A = new numeric.T(A);
    var x = this.x, y = this.y, b = numeric.setBlock, Ax = A.x, Ay = A.y;
    if(Ay) {
        if(!y) { this.y = numeric.rep(numeric.dim(this),0); y = this.y; }
        b(x,from,to,Ax);
        b(y,from,to,Ay);
        return this;
    }
    b(x,from,to,Ax);
    if(y) b(y,from,to,numeric.rep(numeric.dim(Ax),0));
};
numeric.T.rep = function rep(s,v) {
    var T = numeric.T;
    if(!(v instanceof T)) v = new T(v);
    var x = v.x, y = v.y, r = numeric.rep;
    if(y) return new T(r(s,x),r(s,y));
    return new T(r(s,x));
};
numeric.T.diag = function diag(d) {
    if(!(d instanceof numeric.T)) d = new numeric.T(d);
    var x = d.x, y = d.y, diag = numeric.diag;
    if(y) return new numeric.T(diag(x),diag(y));
    return new numeric.T(diag(x));
};
numeric.T.eig = function eig() {
    if(this.y) { throw new Error('eig: not implemented for complex matrices.'); }
    return numeric.eig(this.x);
};
numeric.T.identity = function identity(n) { return new numeric.T(numeric.identity(n)); };
numeric.T.prototype.getDiag = function getDiag() {
    var n = numeric;
    var x = this.x, y = this.y;
    if(y) { return new n.T(n.getDiag(x),n.getDiag(y)); }
    return new n.T(n.getDiag(x));
};

// 4. Eigenvalues of real matrices

numeric.house = function house(x) {
    var v = numeric.clone(x);
    var s = x[0] >= 0 ? 1 : -1;
    var alpha = s*numeric.norm2(x);
    v[0] += alpha;
    var foo = numeric.norm2(v);
    if(foo === 0) { /* this should not happen */ throw new Error('eig: internal error'); }
    return numeric.div(v,foo);
};

numeric.toUpperHessenberg = function toUpperHessenberg(me) {
    var s = numeric.dim(me);
    if(s.length !== 2 || s[0] !== s[1]) { throw new Error('numeric: toUpperHessenberg() only works on square matrices'); }
    var m = s[0], i,j,k,x,v,A = numeric.clone(me),B,C,Ai,Ci,Q = numeric.identity(m),Qi;
    for(j=0;j<m-2;j++) {
        x = Array(m-j-1);
        for(i=j+1;i<m;i++) { x[i-j-1] = A[i][j]; }
        if(numeric.norm2(x)>0) {
            v = numeric.house(x);
            B = numeric.getBlock(A,[j+1,j],[m-1,m-1]);
            C = numeric.tensor(v,numeric.dot(v,B));
            for(i=j+1;i<m;i++) { Ai = A[i]; Ci = C[i-j-1]; for(k=j;k<m;k++) Ai[k] -= 2*Ci[k-j]; }
            B = numeric.getBlock(A,[0,j+1],[m-1,m-1]);
            C = numeric.tensor(numeric.dot(B,v),v);
            for(i=0;i<m;i++) { Ai = A[i]; Ci = C[i]; for(k=j+1;k<m;k++) Ai[k] -= 2*Ci[k-j-1]; }
            B = Array(m-j-1);
            for(i=j+1;i<m;i++) B[i-j-1] = Q[i];
            C = numeric.tensor(v,numeric.dot(v,B));
            for(i=j+1;i<m;i++) { Qi = Q[i]; Ci = C[i-j-1]; for(k=0;k<m;k++) Qi[k] -= 2*Ci[k]; }
        }
    }
    return {H:A, Q:Q};
};

numeric.epsilon = 2.220446049250313e-16;

numeric.QRFrancis = function(H,maxiter) {
    if(typeof maxiter === "undefined") { maxiter = 10000; }
    H = numeric.clone(H);
    var H0 = numeric.clone(H);
    var s = numeric.dim(H),m=s[0],x,v,a,b,c,d,det,tr, Hloc, Q = numeric.identity(m), Qi, Hi, B, C, Ci,i,j,k,iter;
    if(m<3) { return {Q:Q, B:[ [0,m-1] ]}; }
    var epsilon = numeric.epsilon;
    for(iter=0;iter<maxiter;iter++) {
        for(j=0;j<m-1;j++) {
            if(Math.abs(H[j+1][j]) < epsilon*(Math.abs(H[j][j])+Math.abs(H[j+1][j+1]))) {
                var QH1 = numeric.QRFrancis(numeric.getBlock(H,[0,0],[j,j]),maxiter);
                var QH2 = numeric.QRFrancis(numeric.getBlock(H,[j+1,j+1],[m-1,m-1]),maxiter);
                B = Array(j+1);
                for(i=0;i<=j;i++) { B[i] = Q[i]; }
                C = numeric.dot(QH1.Q,B);
                for(i=0;i<=j;i++) { Q[i] = C[i]; }
                B = Array(m-j-1);
                for(i=j+1;i<m;i++) { B[i-j-1] = Q[i]; }
                C = numeric.dot(QH2.Q,B);
                for(i=j+1;i<m;i++) { Q[i] = C[i-j-1]; }
                return {Q:Q,B:QH1.B.concat(numeric.add(QH2.B,j+1))};
            }
        }
        a = H[m-2][m-2]; b = H[m-2][m-1];
        c = H[m-1][m-2]; d = H[m-1][m-1];
        tr = a+d;
        det = (a*d-b*c);
        Hloc = numeric.getBlock(H, [0,0], [2,2]);
        if(tr*tr>=4*det) {
            var s1,s2;
            s1 = 0.5*(tr+Math.sqrt(tr*tr-4*det));
            s2 = 0.5*(tr-Math.sqrt(tr*tr-4*det));
            Hloc = numeric.add(numeric.sub(numeric.dot(Hloc,Hloc),
                                           numeric.mul(Hloc,s1+s2)),
                               numeric.diag(numeric.rep([3],s1*s2)));
        } else {
            Hloc = numeric.add(numeric.sub(numeric.dot(Hloc,Hloc),
                                           numeric.mul(Hloc,tr)),
                               numeric.diag(numeric.rep([3],det)));
        }
        x = [Hloc[0][0],Hloc[1][0],Hloc[2][0]];
        v = numeric.house(x);
        B = [H[0],H[1],H[2]];
        C = numeric.tensor(v,numeric.dot(v,B));
        for(i=0;i<3;i++) { Hi = H[i]; Ci = C[i]; for(k=0;k<m;k++) Hi[k] -= 2*Ci[k]; }
        B = numeric.getBlock(H, [0,0],[m-1,2]);
        C = numeric.tensor(numeric.dot(B,v),v);
        for(i=0;i<m;i++) { Hi = H[i]; Ci = C[i]; for(k=0;k<3;k++) Hi[k] -= 2*Ci[k]; }
        B = [Q[0],Q[1],Q[2]];
        C = numeric.tensor(v,numeric.dot(v,B));
        for(i=0;i<3;i++) { Qi = Q[i]; Ci = C[i]; for(k=0;k<m;k++) Qi[k] -= 2*Ci[k]; }
        var J;
        for(j=0;j<m-2;j++) {
            for(k=j;k<=j+1;k++) {
                if(Math.abs(H[k+1][k]) < epsilon*(Math.abs(H[k][k])+Math.abs(H[k+1][k+1]))) {
                    var QH1 = numeric.QRFrancis(numeric.getBlock(H,[0,0],[k,k]),maxiter);
                    var QH2 = numeric.QRFrancis(numeric.getBlock(H,[k+1,k+1],[m-1,m-1]),maxiter);
                    B = Array(k+1);
                    for(i=0;i<=k;i++) { B[i] = Q[i]; }
                    C = numeric.dot(QH1.Q,B);
                    for(i=0;i<=k;i++) { Q[i] = C[i]; }
                    B = Array(m-k-1);
                    for(i=k+1;i<m;i++) { B[i-k-1] = Q[i]; }
                    C = numeric.dot(QH2.Q,B);
                    for(i=k+1;i<m;i++) { Q[i] = C[i-k-1]; }
                    return {Q:Q,B:QH1.B.concat(numeric.add(QH2.B,k+1))};
                }
            }
            J = Math.min(m-1,j+3);
            x = Array(J-j);
            for(i=j+1;i<=J;i++) { x[i-j-1] = H[i][j]; }
            v = numeric.house(x);
            B = numeric.getBlock(H, [j+1,j],[J,m-1]);
            C = numeric.tensor(v,numeric.dot(v,B));
            for(i=j+1;i<=J;i++) { Hi = H[i]; Ci = C[i-j-1]; for(k=j;k<m;k++) Hi[k] -= 2*Ci[k-j]; }
            B = numeric.getBlock(H, [0,j+1],[m-1,J]);
            C = numeric.tensor(numeric.dot(B,v),v);
            for(i=0;i<m;i++) { Hi = H[i]; Ci = C[i]; for(k=j+1;k<=J;k++) Hi[k] -= 2*Ci[k-j-1]; }
            B = Array(J-j);
            for(i=j+1;i<=J;i++) B[i-j-1] = Q[i];
            C = numeric.tensor(v,numeric.dot(v,B));
            for(i=j+1;i<=J;i++) { Qi = Q[i]; Ci = C[i-j-1]; for(k=0;k<m;k++) Qi[k] -= 2*Ci[k]; }
        }
    }
    throw new Error('numeric: eigenvalue iteration does not converge -- increase maxiter?');
};

numeric.eig = function eig(A,maxiter) {
    var QH = numeric.toUpperHessenberg(A);
    var QB = numeric.QRFrancis(QH.H,maxiter);
    var T = numeric.T;
    var n = A.length,i,k,flag = false,B = QB.B,H = numeric.dot(QB.Q,numeric.dot(QH.H,numeric.transpose(QB.Q)));
    var Q = new T(numeric.dot(QB.Q,QH.Q)),Q0;
    var m = B.length,j;
    var a,b,c,d,p1,p2,disc,x,y,p,q,n1,n2;
    var sqrt = Math.sqrt;
    for(k=0;k<m;k++) {
        i = B[k][0];
        if(i === B[k][1]) {
            // nothing
        } else {
            j = i+1;
            a = H[i][i];
            b = H[i][j];
            c = H[j][i];
            d = H[j][j];
            if(b === 0 && c === 0) continue;
            p1 = -a-d;
            p2 = a*d-b*c;
            disc = p1*p1-4*p2;
            if(disc>=0) {
                if(p1<0) x = -0.5*(p1-sqrt(disc));
                else     x = -0.5*(p1+sqrt(disc));
                n1 = (a-x)*(a-x)+b*b;
                n2 = c*c+(d-x)*(d-x);
                if(n1>n2) {
                    n1 = sqrt(n1);
                    p = (a-x)/n1;
                    q = b/n1;
                } else {
                    n2 = sqrt(n2);
                    p = c/n2;
                    q = (d-x)/n2;
                }
                Q0 = new T([[q,-p],[p,q]]);
                Q.setRows(i,j,Q0.dot(Q.getRows(i,j)));
            } else {
                x = -0.5*p1;
                y = 0.5*sqrt(-disc);
                n1 = (a-x)*(a-x)+b*b;
                n2 = c*c+(d-x)*(d-x);
                if(n1>n2) {
                    n1 = sqrt(n1+y*y);
                    p = (a-x)/n1;
                    q = b/n1;
                    x = 0;
                    y /= n1;
                } else {
                    n2 = sqrt(n2+y*y);
                    p = c/n2;
                    q = (d-x)/n2;
                    x = y/n2;
                    y = 0;
                }
                Q0 = new T([[q,-p],[p,q]],[[x,y],[y,-x]]);
                Q.setRows(i,j,Q0.dot(Q.getRows(i,j)));
            }
        }
    }
    var R = Q.dot(A).dot(Q.transjugate()), n = A.length, E = numeric.T.identity(n);
    for(j=0;j<n;j++) {
        if(j>0) {
            for(k=j-1;k>=0;k--) {
                var Rk = R.get([k,k]), Rj = R.get([j,j]);
                if(numeric.neq(Rk.x,Rj.x) || numeric.neq(Rk.y,Rj.y)) {
                    x = R.getRow(k).getBlock([k],[j-1]);
                    y = E.getRow(j).getBlock([k],[j-1]);
                    E.set([j,k],(R.get([k,j]).neg().sub(x.dot(y))).div(Rk.sub(Rj)));
                } else {
                    E.setRow(j,E.getRow(k));
                    continue;
                }
            }
        }
    }
    for(j=0;j<n;j++) {
        x = E.getRow(j);
        E.setRow(j,x.div(x.norm2()));
    }
    E = E.transpose();
    E = Q.transjugate().dot(E);
    return { lambda:R.getDiag(), E:E };
};

// 5. Compressed Column Storage matrices
numeric.ccsSparse = function ccsSparse(A) {
    var m = A.length,n,foo, i,j, counts = [];
    for(i=m-1;i!==-1;--i) {
        foo = A[i];
        for(j in foo) {
            j = parseInt(j);
            while(j>=counts.length) counts[counts.length] = 0;
            if(foo[j]!==0) counts[j]++;
        }
    }
    var n = counts.length;
    var Ai = Array(n+1);
    Ai[0] = 0;
    for(i=0;i<n;++i) Ai[i+1] = Ai[i] + counts[i];
    var Aj = Array(Ai[n]), Av = Array(Ai[n]);
    for(i=m-1;i!==-1;--i) {
        foo = A[i];
        for(j in foo) {
            if(foo[j]!==0) {
                counts[j]--;
                Aj[Ai[j]+counts[j]] = i;
                Av[Ai[j]+counts[j]] = foo[j];
            }
        }
    }
    return [Ai,Aj,Av];
};
numeric.ccsFull = function ccsFull(A) {
    var Ai = A[0], Aj = A[1], Av = A[2], s = numeric.ccsDim(A), m = s[0], n = s[1], i,j,j0,j1,k;
    var B = numeric.rep([m,n],0);
    for(i=0;i<n;i++) {
        j0 = Ai[i];
        j1 = Ai[i+1];
        for(j=j0;j<j1;++j) { B[Aj[j]][i] = Av[j]; }
    }
    return B;
};
numeric.ccsTSolve = function ccsTSolve(A,b,x,bj,xj) {
    var Ai = A[0], Aj = A[1], Av = A[2],m = Ai.length-1, max = Math.max,n=0;
    if(typeof bj === "undefined") x = numeric.rep([m],0);
    if(typeof bj === "undefined") bj = numeric.linspace(0,x.length-1);
    if(typeof xj === "undefined") xj = [];
    function dfs(j) {
        var k;
        if(x[j] !== 0) return;
        x[j] = 1;
        for(k=Ai[j];k<Ai[j+1];++k) dfs(Aj[k]);
        xj[n] = j;
        ++n;
    }
    var i,j,j0,j1,k,l,l0,l1,a;
    for(i=bj.length-1;i!==-1;--i) { dfs(bj[i]); }
    xj.length = n;
    for(i=xj.length-1;i!==-1;--i) { x[xj[i]] = 0; }
    for(i=bj.length-1;i!==-1;--i) { j = bj[i]; x[j] = b[j]; }
    for(i=xj.length-1;i!==-1;--i) {
        j = xj[i];
        j0 = Ai[j];
        j1 = max(Ai[j+1],j0);
        for(k=j0;k!==j1;++k) { if(Aj[k] === j) { x[j] /= Av[k]; break; } }
        a = x[j];
        for(k=j0;k!==j1;++k) {
            l = Aj[k];
            if(l !== j) x[l] -= a*Av[k];
        }
    }
    return x;
};
numeric.ccsDFS = function ccsDFS(n) {
    this.k = Array(n);
    this.k1 = Array(n);
    this.j = Array(n);
};
numeric.ccsDFS.prototype.dfs = function dfs(J,Ai,Aj,x,xj,Pinv) {
    var m = 0,foo,n=xj.length;
    var k = this.k, k1 = this.k1, j = this.j,km,k11;
    if(x[J]!==0) return;
    x[J] = 1;
    j[0] = J;
    k[0] = km = Ai[J];
    k1[0] = k11 = Ai[J+1];
    while(1) {
        if(km >= k11) {
            xj[n] = j[m];
            if(m===0) return;
            ++n;
            --m;
            km = k[m];
            k11 = k1[m];
        } else {
            foo = Pinv[Aj[km]];
            if(x[foo] === 0) {
                x[foo] = 1;
                k[m] = km;
                ++m;
                j[m] = foo;
                km = Ai[foo];
                k1[m] = k11 = Ai[foo+1];
            } else ++km;
        }
    }
};
numeric.ccsLPSolve = function ccsLPSolve(A,B,x,xj,I,Pinv,dfs) {
    var Ai = A[0], Aj = A[1], Av = A[2],m = Ai.length-1, n=0;
    var Bi = B[0], Bj = B[1], Bv = B[2];
    
    var i,i0,i1,j,J,j0,j1,k,l,l0,l1,a;
    i0 = Bi[I];
    i1 = Bi[I+1];
    xj.length = 0;
    for(i=i0;i<i1;++i) { dfs.dfs(Pinv[Bj[i]],Ai,Aj,x,xj,Pinv); }
    for(i=xj.length-1;i!==-1;--i) { x[xj[i]] = 0; }
    for(i=i0;i!==i1;++i) { j = Pinv[Bj[i]]; x[j] = Bv[i]; }
    for(i=xj.length-1;i!==-1;--i) {
        j = xj[i];
        j0 = Ai[j];
        j1 = Ai[j+1];
        for(k=j0;k<j1;++k) { if(Pinv[Aj[k]] === j) { x[j] /= Av[k]; break; } }
        a = x[j];
        for(k=j0;k<j1;++k) {
            l = Pinv[Aj[k]];
            if(l !== j) x[l] -= a*Av[k];
        }
    }
    return x;
};
numeric.ccsLUP1 = function ccsLUP1(A,threshold) {
    var m = A[0].length-1;
    var L = [numeric.rep([m+1],0),[],[]], U = [numeric.rep([m+1], 0),[],[]];
    var Li = L[0], Lj = L[1], Lv = L[2], Ui = U[0], Uj = U[1], Uv = U[2];
    var x = numeric.rep([m],0), xj = numeric.rep([m],0);
    var i,j,k,j0,j1,a,e,c,d,K;
    var sol = numeric.ccsLPSolve, max = Math.max, abs = Math.abs;
    var P = numeric.linspace(0,m-1),Pinv = numeric.linspace(0,m-1);
    var dfs = new numeric.ccsDFS(m);
    if(typeof threshold === "undefined") { threshold = 1; }
    for(i=0;i<m;++i) {
        sol(L,A,x,xj,i,Pinv,dfs);
        a = -1;
        e = -1;
        for(j=xj.length-1;j!==-1;--j) {
            k = xj[j];
            if(k <= i) continue;
            c = abs(x[k]);
            if(c > a) { e = k; a = c; }
        }
        if(abs(x[i])<threshold*a) {
            j = P[i];
            a = P[e];
            P[i] = a; Pinv[a] = i;
            P[e] = j; Pinv[j] = e;
            a = x[i]; x[i] = x[e]; x[e] = a;
        }
        a = Li[i];
        e = Ui[i];
        d = x[i];
        Lj[a] = P[i];
        Lv[a] = 1;
        ++a;
        for(j=xj.length-1;j!==-1;--j) {
            k = xj[j];
            c = x[k];
            xj[j] = 0;
            x[k] = 0;
            if(k<=i) { Uj[e] = k; Uv[e] = c;   ++e; }
            else     { Lj[a] = P[k]; Lv[a] = c/d; ++a; }
        }
        Li[i+1] = a;
        Ui[i+1] = e;
    }
    for(j=Lj.length-1;j!==-1;--j) { Lj[j] = Pinv[Lj[j]]; }
    return {L:L, U:U, P:P, Pinv:Pinv};
};
numeric.ccsDFS0 = function ccsDFS0(n) {
    this.k = Array(n);
    this.k1 = Array(n);
    this.j = Array(n);
};
numeric.ccsDFS0.prototype.dfs = function dfs(J,Ai,Aj,x,xj,Pinv,P) {
    var m = 0,foo,n=xj.length;
    var k = this.k, k1 = this.k1, j = this.j,km,k11;
    if(x[J]!==0) return;
    x[J] = 1;
    j[0] = J;
    k[0] = km = Ai[Pinv[J]];
    k1[0] = k11 = Ai[Pinv[J]+1];
    while(1) {
        if(isNaN(km)) throw new Error("Ow!");
        if(km >= k11) {
            xj[n] = Pinv[j[m]];
            if(m===0) return;
            ++n;
            --m;
            km = k[m];
            k11 = k1[m];
        } else {
            foo = Aj[km];
            if(x[foo] === 0) {
                x[foo] = 1;
                k[m] = km;
                ++m;
                j[m] = foo;
                foo = Pinv[foo];
                km = Ai[foo];
                k1[m] = k11 = Ai[foo+1];
            } else ++km;
        }
    }
};
numeric.ccsLPSolve0 = function ccsLPSolve0(A,B,y,xj,I,Pinv,P,dfs) {
    var Ai = A[0], Aj = A[1], Av = A[2],m = Ai.length-1, n=0;
    var Bi = B[0], Bj = B[1], Bv = B[2];
    
    var i,i0,i1,j,J,j0,j1,k,l,l0,l1,a;
    i0 = Bi[I];
    i1 = Bi[I+1];
    xj.length = 0;
    for(i=i0;i<i1;++i) { dfs.dfs(Bj[i],Ai,Aj,y,xj,Pinv,P); }
    for(i=xj.length-1;i!==-1;--i) { j = xj[i]; y[P[j]] = 0; }
    for(i=i0;i!==i1;++i) { j = Bj[i]; y[j] = Bv[i]; }
    for(i=xj.length-1;i!==-1;--i) {
        j = xj[i];
        l = P[j];
        j0 = Ai[j];
        j1 = Ai[j+1];
        for(k=j0;k<j1;++k) { if(Aj[k] === l) { y[l] /= Av[k]; break; } }
        a = y[l];
        for(k=j0;k<j1;++k) y[Aj[k]] -= a*Av[k];
        y[l] = a;
    }
};
numeric.ccsLUP0 = function ccsLUP0(A,threshold) {
    var m = A[0].length-1;
    var L = [numeric.rep([m+1],0),[],[]], U = [numeric.rep([m+1], 0),[],[]];
    var Li = L[0], Lj = L[1], Lv = L[2], Ui = U[0], Uj = U[1], Uv = U[2];
    var y = numeric.rep([m],0), xj = numeric.rep([m],0);
    var i,j,k,j0,j1,a,e,c,d,K;
    var sol = numeric.ccsLPSolve0, max = Math.max, abs = Math.abs;
    var P = numeric.linspace(0,m-1),Pinv = numeric.linspace(0,m-1);
    var dfs = new numeric.ccsDFS0(m);
    if(typeof threshold === "undefined") { threshold = 1; }
    for(i=0;i<m;++i) {
        sol(L,A,y,xj,i,Pinv,P,dfs);
        a = -1;
        e = -1;
        for(j=xj.length-1;j!==-1;--j) {
            k = xj[j];
            if(k <= i) continue;
            c = abs(y[P[k]]);
            if(c > a) { e = k; a = c; }
        }
        if(abs(y[P[i]])<threshold*a) {
            j = P[i];
            a = P[e];
            P[i] = a; Pinv[a] = i;
            P[e] = j; Pinv[j] = e;
        }
        a = Li[i];
        e = Ui[i];
        d = y[P[i]];
        Lj[a] = P[i];
        Lv[a] = 1;
        ++a;
        for(j=xj.length-1;j!==-1;--j) {
            k = xj[j];
            c = y[P[k]];
            xj[j] = 0;
            y[P[k]] = 0;
            if(k<=i) { Uj[e] = k; Uv[e] = c;   ++e; }
            else     { Lj[a] = P[k]; Lv[a] = c/d; ++a; }
        }
        Li[i+1] = a;
        Ui[i+1] = e;
    }
    for(j=Lj.length-1;j!==-1;--j) { Lj[j] = Pinv[Lj[j]]; }
    return {L:L, U:U, P:P, Pinv:Pinv};
};
numeric.ccsLUP = numeric.ccsLUP0;

numeric.ccsDim = function ccsDim(A) { return [numeric.sup(A[1])+1,A[0].length-1]; };
numeric.ccsGetBlock = function ccsGetBlock(A,i,j) {
    var s = numeric.ccsDim(A),m=s[0],n=s[1];
    if(typeof i === "undefined") { i = numeric.linspace(0,m-1); }
    else if(typeof i === "number") { i = [i]; }
    if(typeof j === "undefined") { j = numeric.linspace(0,n-1); }
    else if(typeof j === "number") { j = [j]; }
    var p,p0,p1,P = i.length,q,Q = j.length,r,jq,ip;
    var Bi = numeric.rep([n],0), Bj=[], Bv=[], B = [Bi,Bj,Bv];
    var Ai = A[0], Aj = A[1], Av = A[2];
    var x = numeric.rep([m],0),count=0,flags = numeric.rep([m],0);
    for(q=0;q<Q;++q) {
        jq = j[q];
        var q0 = Ai[jq];
        var q1 = Ai[jq+1];
        for(p=q0;p<q1;++p) {
            r = Aj[p];
            flags[r] = 1;
            x[r] = Av[p];
        }
        for(p=0;p<P;++p) {
            ip = i[p];
            if(flags[ip]) {
                Bj[count] = p;
                Bv[count] = x[i[p]];
                ++count;
            }
        }
        for(p=q0;p<q1;++p) {
            r = Aj[p];
            flags[r] = 0;
        }
        Bi[q+1] = count;
    }
    return B;
};

numeric.ccsDot = function ccsDot(A,B) {
    var Ai = A[0], Aj = A[1], Av = A[2];
    var Bi = B[0], Bj = B[1], Bv = B[2];
    var sA = numeric.ccsDim(A), sB = numeric.ccsDim(B);
    var m = sA[0], n = sA[1], o = sB[1];
    var x = numeric.rep([m],0), flags = numeric.rep([m],0), xj = Array(m);
    var Ci = numeric.rep([o],0), Cj = [], Cv = [], C = [Ci,Cj,Cv];
    var i,j,k,j0,j1,i0,i1,l,p,a,b;
    for(k=0;k!==o;++k) {
        j0 = Bi[k];
        j1 = Bi[k+1];
        p = 0;
        for(j=j0;j<j1;++j) {
            a = Bj[j];
            b = Bv[j];
            i0 = Ai[a];
            i1 = Ai[a+1];
            for(i=i0;i<i1;++i) {
                l = Aj[i];
                if(flags[l]===0) {
                    xj[p] = l;
                    flags[l] = 1;
                    p = p+1;
                }
                x[l] = x[l] + Av[i]*b;
            }
        }
        j0 = Ci[k];
        j1 = j0+p;
        Ci[k+1] = j1;
        for(j=p-1;j!==-1;--j) {
            b = j0+j;
            i = xj[j];
            Cj[b] = i;
            Cv[b] = x[i];
            flags[i] = 0;
            x[i] = 0;
        }
        Ci[k+1] = Ci[k]+p;
    }
    return C;
};

numeric.ccsLUPSolve = function ccsLUPSolve(LUP,B) {
    var L = LUP.L, U = LUP.U, P = LUP.P;
    var Bi = B[0];
    var flag = false;
    if(typeof Bi !== "object") { B = [[0,B.length],numeric.linspace(0,B.length-1),B]; Bi = B[0]; flag = true; }
    var Bj = B[1], Bv = B[2];
    var n = L[0].length-1, m = Bi.length-1;
    var x = numeric.rep([n],0), xj = Array(n);
    var b = numeric.rep([n],0), bj = Array(n);
    var Xi = numeric.rep([m+1],0), Xj = [], Xv = [];
    var sol = numeric.ccsTSolve;
    var i,j,j0,j1,k,J,N=0;
    for(i=0;i<m;++i) {
        k = 0;
        j0 = Bi[i];
        j1 = Bi[i+1];
        for(j=j0;j<j1;++j) { 
            J = LUP.Pinv[Bj[j]];
            bj[k] = J;
            b[J] = Bv[j];
            ++k;
        }
        bj.length = k;
        sol(L,b,x,bj,xj);
        for(j=bj.length-1;j!==-1;--j) b[bj[j]] = 0;
        sol(U,x,b,xj,bj);
        if(flag) return b;
        for(j=xj.length-1;j!==-1;--j) x[xj[j]] = 0;
        for(j=bj.length-1;j!==-1;--j) {
            J = bj[j];
            Xj[N] = J;
            Xv[N] = b[J];
            b[J] = 0;
            ++N;
        }
        Xi[i+1] = N;
    }
    return [Xi,Xj,Xv];
};

numeric.ccsbinop = function ccsbinop(body,setup) {
    if(typeof setup === "undefined") setup='';
    return Function('X','Y',
            'var Xi = X[0], Xj = X[1], Xv = X[2];\n'+
            'var Yi = Y[0], Yj = Y[1], Yv = Y[2];\n'+
            'var n = Xi.length-1,m = Math.max(numeric.sup(Xj),numeric.sup(Yj))+1;\n'+
            'var Zi = numeric.rep([n+1],0), Zj = [], Zv = [];\n'+
            'var x = numeric.rep([m],0),y = numeric.rep([m],0);\n'+
            'var xk,yk,zk;\n'+
            'var i,j,j0,j1,k,p=0;\n'+
            setup+
            'for(i=0;i<n;++i) {\n'+
            '  j0 = Xi[i]; j1 = Xi[i+1];\n'+
            '  for(j=j0;j!==j1;++j) {\n'+
            '    k = Xj[j];\n'+
            '    x[k] = 1;\n'+
            '    Zj[p] = k;\n'+
            '    ++p;\n'+
            '  }\n'+
            '  j0 = Yi[i]; j1 = Yi[i+1];\n'+
            '  for(j=j0;j!==j1;++j) {\n'+
            '    k = Yj[j];\n'+
            '    y[k] = Yv[j];\n'+
            '    if(x[k] === 0) {\n'+
            '      Zj[p] = k;\n'+
            '      ++p;\n'+
            '    }\n'+
            '  }\n'+
            '  Zi[i+1] = p;\n'+
            '  j0 = Xi[i]; j1 = Xi[i+1];\n'+
            '  for(j=j0;j!==j1;++j) x[Xj[j]] = Xv[j];\n'+
            '  j0 = Zi[i]; j1 = Zi[i+1];\n'+
            '  for(j=j0;j!==j1;++j) {\n'+
            '    k = Zj[j];\n'+
            '    xk = x[k];\n'+
            '    yk = y[k];\n'+
            body+'\n'+
            '    Zv[j] = zk;\n'+
            '  }\n'+
            '  j0 = Xi[i]; j1 = Xi[i+1];\n'+
            '  for(j=j0;j!==j1;++j) x[Xj[j]] = 0;\n'+
            '  j0 = Yi[i]; j1 = Yi[i+1];\n'+
            '  for(j=j0;j!==j1;++j) y[Yj[j]] = 0;\n'+
            '}\n'+
            'return [Zi,Zj,Zv];'
            );
};

(function() {
    var k,A,B,C;
    for(k in numeric.ops2) {
        if(isFinite(eval('1'+numeric.ops2[k]+'0'))) A = '[Y[0],Y[1],numeric.'+k+'(X,Y[2])]';
        else A = 'NaN';
        if(isFinite(eval('0'+numeric.ops2[k]+'1'))) B = '[X[0],X[1],numeric.'+k+'(X[2],Y)]';
        else B = 'NaN';
        if(isFinite(eval('1'+numeric.ops2[k]+'0')) && isFinite(eval('0'+numeric.ops2[k]+'1'))) C = 'numeric.ccs'+k+'MM(X,Y)';
        else C = 'NaN';
        numeric['ccs'+k+'MM'] = numeric.ccsbinop('zk = xk '+numeric.ops2[k]+'yk;');
        numeric['ccs'+k] = Function('X','Y',
                'if(typeof X === "number") return '+A+';\n'+
                'if(typeof Y === "number") return '+B+';\n'+
                'return '+C+';\n'
                );
    }
}());

numeric.ccsScatter = function ccsScatter(A) {
    var Ai = A[0], Aj = A[1], Av = A[2];
    var n = numeric.sup(Aj)+1,m=Ai.length;
    var Ri = numeric.rep([n],0),Rj=Array(m), Rv = Array(m);
    var counts = numeric.rep([n],0),i;
    for(i=0;i<m;++i) counts[Aj[i]]++;
    for(i=0;i<n;++i) Ri[i+1] = Ri[i] + counts[i];
    var ptr = Ri.slice(0),k,Aii;
    for(i=0;i<m;++i) {
        Aii = Aj[i];
        k = ptr[Aii];
        Rj[k] = Ai[i];
        Rv[k] = Av[i];
        ptr[Aii]=ptr[Aii]+1;
    }
    return [Ri,Rj,Rv];
};

numeric.ccsGather = function ccsGather(A) {
    var Ai = A[0], Aj = A[1], Av = A[2];
    var n = Ai.length-1,m = Aj.length;
    var Ri = Array(m), Rj = Array(m), Rv = Array(m);
    var i,j,j0,j1,p;
    p=0;
    for(i=0;i<n;++i) {
        j0 = Ai[i];
        j1 = Ai[i+1];
        for(j=j0;j!==j1;++j) {
            Rj[p] = i;
            Ri[p] = Aj[j];
            Rv[p] = Av[j];
            ++p;
        }
    }
    return [Ri,Rj,Rv];
};

// The following sparse linear algebra routines are deprecated.

numeric.sdim = function dim(A,ret,k) {
    if(typeof ret === "undefined") { ret = []; }
    if(typeof A !== "object") return ret;
    if(typeof k === "undefined") { k=0; }
    if(!(k in ret)) { ret[k] = 0; }
    if(A.length > ret[k]) ret[k] = A.length;
    var i;
    for(i in A) {
        if(A.hasOwnProperty(i)) dim(A[i],ret,k+1);
    }
    return ret;
};

numeric.sclone = function clone(A,k,n) {
    if(typeof k === "undefined") { k=0; }
    if(typeof n === "undefined") { n = numeric.sdim(A).length; }
    var i,ret = Array(A.length);
    if(k === n-1) {
        for(i in A) { if(A.hasOwnProperty(i)) ret[i] = A[i]; }
        return ret;
    }
    for(i in A) {
        if(A.hasOwnProperty(i)) ret[i] = clone(A[i],k+1,n);
    }
    return ret;
};

numeric.sdiag = function diag(d) {
    var n = d.length,i,ret = Array(n),i1,i2,i3;
    for(i=n-1;i>=1;i-=2) {
        i1 = i-1;
        ret[i] = []; ret[i][i] = d[i];
        ret[i1] = []; ret[i1][i1] = d[i1];
    }
    if(i===0) { ret[0] = []; ret[0][0] = d[i]; }
    return ret;
};

numeric.sidentity = function identity(n) { return numeric.sdiag(numeric.rep([n],1)); };

numeric.stranspose = function transpose(A) {
    var ret = [], n = A.length, i,j,Ai;
    for(i in A) {
        if(!(A.hasOwnProperty(i))) continue;
        Ai = A[i];
        for(j in Ai) {
            if(!(Ai.hasOwnProperty(j))) continue;
            if(typeof ret[j] !== "object") { ret[j] = []; }
            ret[j][i] = Ai[j];
        }
    }
    return ret;
};

numeric.sLUP = function LUP(A,tol) {
    throw new Error("The function numeric.sLUP had a bug in it and has been removed. Please use the new numeric.ccsLUP function instead.");
};

numeric.sdotMM = function dotMM(A,B) {
    var p = A.length, q = B.length, BT = numeric.stranspose(B), r = BT.length, Ai, BTk;
    var i,j,k,accum;
    var ret = Array(p),reti;
    for(i=p-1;i>=0;i--) {
        reti = [];
        Ai = A[i];
        for(k=r-1;k>=0;k--) {
            accum = 0;
            BTk = BT[k];
            for(j in Ai) {
                if(!(Ai.hasOwnProperty(j))) continue;
                if(j in BTk) { accum += Ai[j]*BTk[j]; }
            }
            if(accum) reti[k] = accum;
        }
        ret[i] = reti;
    }
    return ret;
};

numeric.sdotMV = function dotMV(A,x) {
    var p = A.length, Ai, i,j;
    var ret = Array(p), accum;
    for(i=p-1;i>=0;i--) {
        Ai = A[i];
        accum = 0;
        for(j in Ai) {
            if(!(Ai.hasOwnProperty(j))) continue;
            if(x[j]) accum += Ai[j]*x[j];
        }
        if(accum) ret[i] = accum;
    }
    return ret;
};

numeric.sdotVM = function dotMV(x,A) {
    var i,j,Ai,alpha;
    var ret = [], accum;
    for(i in x) {
        if(!x.hasOwnProperty(i)) continue;
        Ai = A[i];
        alpha = x[i];
        for(j in Ai) {
            if(!Ai.hasOwnProperty(j)) continue;
            if(!ret[j]) { ret[j] = 0; }
            ret[j] += alpha*Ai[j];
        }
    }
    return ret;
};

numeric.sdotVV = function dotVV(x,y) {
    var i,ret=0;
    for(i in x) { if(x[i] && y[i]) ret+= x[i]*y[i]; }
    return ret;
};

numeric.sdot = function dot(A,B) {
    var m = numeric.sdim(A).length, n = numeric.sdim(B).length;
    var k = m*1000+n;
    switch(k) {
    case 0: return A*B;
    case 1001: return numeric.sdotVV(A,B);
    case 2001: return numeric.sdotMV(A,B);
    case 1002: return numeric.sdotVM(A,B);
    case 2002: return numeric.sdotMM(A,B);
    default: throw new Error('numeric.sdot not implemented for tensors of order '+m+' and '+n);
    }
};

numeric.sscatter = function scatter(V) {
    var n = V[0].length, Vij, i, j, m = V.length, A = [], Aj;
    for(i=n-1;i>=0;--i) {
        if(!V[m-1][i]) continue;
        Aj = A;
        for(j=0;j<m-2;j++) {
            Vij = V[j][i];
            if(!Aj[Vij]) Aj[Vij] = [];
            Aj = Aj[Vij];
        }
        Aj[V[j][i]] = V[j+1][i];
    }
    return A;
};

numeric.sgather = function gather(A,ret,k) {
    if(typeof ret === "undefined") ret = [];
    if(typeof k === "undefined") k = [];
    var n,i,Ai;
    n = k.length;
    for(i in A) {
        if(A.hasOwnProperty(i)) {
            k[n] = parseInt(i);
            Ai = A[i];
            if(typeof Ai === "number") {
                if(Ai) {
                    if(ret.length === 0) {
                        for(i=n+1;i>=0;--i) ret[i] = [];
                    }
                    for(i=n;i>=0;--i) ret[i].push(k[i]);
                    ret[n+1].push(Ai);
                }
            } else gather(Ai,ret,k);
        }
    }
    if(k.length>n) k.pop();
    return ret;
};

// 6. Coordinate matrices
numeric.cLU = function LU(A) {
    var I = A[0], J = A[1], V = A[2];
    var p = I.length, m=0, i,j,k,a,b,c;
    for(i=0;i<p;i++) if(I[i]>m) m=I[i];
    m++;
    var L = Array(m), U = Array(m), left = numeric.rep([m],Infinity), right = numeric.rep([m],-Infinity);
    var Ui, Uj,alpha;
    for(k=0;k<p;k++) {
        i = I[k];
        j = J[k];
        if(j<left[i]) left[i] = j;
        if(j>right[i]) right[i] = j;
    }
    for(i=0;i<m-1;i++) { if(right[i] > right[i+1]) right[i+1] = right[i]; }
    for(i=m-1;i>=1;i--) { if(left[i]<left[i-1]) left[i-1] = left[i]; }
    var countL = 0, countU = 0;
    for(i=0;i<m;i++) {
        U[i] = numeric.rep([right[i]-left[i]+1],0);
        L[i] = numeric.rep([i-left[i]],0);
        countL += i-left[i]+1;
        countU += right[i]-i+1;
    }
    for(k=0;k<p;k++) { i = I[k]; U[i][J[k]-left[i]] = V[k]; }
    for(i=0;i<m-1;i++) {
        a = i-left[i];
        Ui = U[i];
        for(j=i+1;left[j]<=i && j<m;j++) {
            b = i-left[j];
            c = right[i]-i;
            Uj = U[j];
            alpha = Uj[b]/Ui[a];
            if(alpha) {
                for(k=1;k<=c;k++) { Uj[k+b] -= alpha*Ui[k+a]; }
                L[j][i-left[j]] = alpha;
            }
        }
    }
    var Ui = [], Uj = [], Uv = [], Li = [], Lj = [], Lv = [];
    var p,q,foo;
    p=0; q=0;
    for(i=0;i<m;i++) {
        a = left[i];
        b = right[i];
        foo = U[i];
        for(j=i;j<=b;j++) {
            if(foo[j-a]) {
                Ui[p] = i;
                Uj[p] = j;
                Uv[p] = foo[j-a];
                p++;
            }
        }
        foo = L[i];
        for(j=a;j<i;j++) {
            if(foo[j-a]) {
                Li[q] = i;
                Lj[q] = j;
                Lv[q] = foo[j-a];
                q++;
            }
        }
        Li[q] = i;
        Lj[q] = i;
        Lv[q] = 1;
        q++;
    }
    return {U:[Ui,Uj,Uv], L:[Li,Lj,Lv]};
};

numeric.cLUsolve = function LUsolve(lu,b) {
    var L = lu.L, U = lu.U, ret = numeric.clone(b);
    var Li = L[0], Lj = L[1], Lv = L[2];
    var Ui = U[0], Uj = U[1], Uv = U[2];
    var p = Ui.length, q = Li.length;
    var m = ret.length,i,j,k;
    k = 0;
    for(i=0;i<m;i++) {
        while(Lj[k] < i) {
            ret[i] -= Lv[k]*ret[Lj[k]];
            k++;
        }
        k++;
    }
    k = p-1;
    for(i=m-1;i>=0;i--) {
        while(Uj[k] > i) {
            ret[i] -= Uv[k]*ret[Uj[k]];
            k--;
        }
        ret[i] /= Uv[k];
        k--;
    }
    return ret;
};

numeric.cgrid = function grid(n,shape) {
    if(typeof n === "number") n = [n,n];
    var ret = numeric.rep(n,-1);
    var i,j,count;
    if(typeof shape !== "function") {
        switch(shape) {
        case 'L':
            shape = function(i,j) { return (i>=n[0]/2 || j<n[1]/2); };
            break;
        default:
            shape = function(i,j) { return true; };
            break;
        }
    }
    count=0;
    for(i=1;i<n[0]-1;i++) for(j=1;j<n[1]-1;j++) 
        if(shape(i,j)) {
            ret[i][j] = count;
            count++;
        }
    return ret;
};

numeric.cdelsq = function delsq(g) {
    var dir = [[-1,0],[0,-1],[0,1],[1,0]];
    var s = numeric.dim(g), m = s[0], n = s[1], i,j,k,p,q;
    var Li = [], Lj = [], Lv = [];
    for(i=1;i<m-1;i++) for(j=1;j<n-1;j++) {
        if(g[i][j]<0) continue;
        for(k=0;k<4;k++) {
            p = i+dir[k][0];
            q = j+dir[k][1];
            if(g[p][q]<0) continue;
            Li.push(g[i][j]);
            Lj.push(g[p][q]);
            Lv.push(-1);
        }
        Li.push(g[i][j]);
        Lj.push(g[i][j]);
        Lv.push(4);
    }
    return [Li,Lj,Lv];
};

numeric.cdotMV = function dotMV(A,x) {
    var ret, Ai = A[0], Aj = A[1], Av = A[2],k,p=Ai.length,N;
    N=0;
    for(k=0;k<p;k++) { if(Ai[k]>N) N = Ai[k]; }
    N++;
    ret = numeric.rep([N],0);
    for(k=0;k<p;k++) { ret[Ai[k]]+=Av[k]*x[Aj[k]]; }
    return ret;
};

// 7. Splines

numeric.Spline = function Spline(x,yl,yr,kl,kr) { this.x = x; this.yl = yl; this.yr = yr; this.kl = kl; this.kr = kr; };
numeric.Spline.prototype._at = function _at(x1,p) {
    var x = this.x;
    var yl = this.yl;
    var yr = this.yr;
    var kl = this.kl;
    var kr = this.kr;
    var x1,a,b,t;
    var add = numeric.add, sub = numeric.sub, mul = numeric.mul;
    a = sub(mul(kl[p],x[p+1]-x[p]),sub(yr[p+1],yl[p]));
    b = add(mul(kr[p+1],x[p]-x[p+1]),sub(yr[p+1],yl[p]));
    t = (x1-x[p])/(x[p+1]-x[p]);
    var s = t*(1-t);
    return add(add(add(mul(1-t,yl[p]),mul(t,yr[p+1])),mul(a,s*(1-t))),mul(b,s*t));
};
numeric.Spline.prototype.at = function at(x0) {
    if(typeof x0 === "number") {
        var x = this.x;
        var n = x.length;
        var p,q,mid,floor = Math.floor,a,b,t;
        p = 0;
        q = n-1;
        while(q-p>1) {
            mid = floor((p+q)/2);
            if(x[mid] <= x0) p = mid;
            else q = mid;
        }
        return this._at(x0,p);
    }
    var n = x0.length, i, ret = Array(n);
    for(i=n-1;i!==-1;--i) ret[i] = this.at(x0[i]);
    return ret;
};
numeric.Spline.prototype.diff = function diff() {
    var x = this.x;
    var yl = this.yl;
    var yr = this.yr;
    var kl = this.kl;
    var kr = this.kr;
    var n = yl.length;
    var i,dx,dy;
    var zl = kl, zr = kr, pl = Array(n), pr = Array(n);
    var add = numeric.add, mul = numeric.mul, div = numeric.div, sub = numeric.sub;
    for(i=n-1;i!==-1;--i) {
        dx = x[i+1]-x[i];
        dy = sub(yr[i+1],yl[i]);
        pl[i] = div(add(mul(dy, 6),mul(kl[i],-4*dx),mul(kr[i+1],-2*dx)),dx*dx);
        pr[i+1] = div(add(mul(dy,-6),mul(kl[i], 2*dx),mul(kr[i+1], 4*dx)),dx*dx);
    }
    return new numeric.Spline(x,zl,zr,pl,pr);
};
numeric.Spline.prototype.roots = function roots() {
    function sqr(x) { return x*x; }
    var ret = [];
    var x = this.x, yl = this.yl, yr = this.yr, kl = this.kl, kr = this.kr;
    if(typeof yl[0] === "number") {
        yl = [yl];
        yr = [yr];
        kl = [kl];
        kr = [kr];
    }
    var m = yl.length,n=x.length-1,i,j,k,y,s,t;
    var ai,bi,ci,di, ret = Array(m),ri,k0,k1,y0,y1,A,B,D,dx,cx,stops,z0,z1,zm,t0,t1,tm;
    var sqrt = Math.sqrt;
    for(i=0;i!==m;++i) {
        ai = yl[i];
        bi = yr[i];
        ci = kl[i];
        di = kr[i];
        ri = [];
        for(j=0;j!==n;j++) {
            if(j>0 && bi[j]*ai[j]<0) ri.push(x[j]);
            dx = (x[j+1]-x[j]);
            cx = x[j];
            y0 = ai[j];
            y1 = bi[j+1];
            k0 = ci[j]/dx;
            k1 = di[j+1]/dx;
            D = sqr(k0-k1+3*(y0-y1)) + 12*k1*y0;
            A = k1+3*y0+2*k0-3*y1;
            B = 3*(k1+k0+2*(y0-y1));
            if(D<=0) {
                z0 = A/B;
                if(z0>x[j] && z0<x[j+1]) stops = [x[j],z0,x[j+1]];
                else stops = [x[j],x[j+1]];
            } else {
                z0 = (A-sqrt(D))/B;
                z1 = (A+sqrt(D))/B;
                stops = [x[j]];
                if(z0>x[j] && z0<x[j+1]) stops.push(z0);
                if(z1>x[j] && z1<x[j+1]) stops.push(z1);
                stops.push(x[j+1]);
            }
            t0 = stops[0];
            z0 = this._at(t0,j);
            for(k=0;k<stops.length-1;k++) {
                t1 = stops[k+1];
                z1 = this._at(t1,j);
                if(z0 === 0) {
                    ri.push(t0); 
                    t0 = t1;
                    z0 = z1;
                    continue;
                }
                if(z1 === 0 || z0*z1>0) {
                    t0 = t1;
                    z0 = z1;
                    continue;
                }
                var side = 0;
                while(1) {
                    tm = (z0*t1-z1*t0)/(z0-z1);
                    if(tm <= t0 || tm >= t1) { break; }
                    zm = this._at(tm,j);
                    if(zm*z1>0) {
                        t1 = tm;
                        z1 = zm;
                        if(side === -1) z0*=0.5;
                        side = -1;
                    } else if(zm*z0>0) {
                        t0 = tm;
                        z0 = zm;
                        if(side === 1) z1*=0.5;
                        side = 1;
                    } else break;
                }
                ri.push(tm);
                t0 = stops[k+1];
                z0 = this._at(t0, j);
            }
            if(z1 === 0) ri.push(t1);
        }
        ret[i] = ri;
    }
    if(typeof this.yl[0] === "number") return ret[0];
    return ret;
};
numeric.spline = function spline(x,y,k1,kn) {
    var n = x.length, b = [], dx = [], dy = [];
    var i;
    var sub = numeric.sub,mul = numeric.mul,add = numeric.add;
    for(i=n-2;i>=0;i--) { dx[i] = x[i+1]-x[i]; dy[i] = sub(y[i+1],y[i]); }
    if(typeof k1 === "string" || typeof kn === "string") { 
        k1 = kn = "periodic";
    }
    // Build sparse tridiagonal system
    var T = [[],[],[]];
    switch(typeof k1) {
    case "undefined":
        b[0] = mul(3/(dx[0]*dx[0]),dy[0]);
        T[0].push(0,0);
        T[1].push(0,1);
        T[2].push(2/dx[0],1/dx[0]);
        break;
    case "string":
        b[0] = add(mul(3/(dx[n-2]*dx[n-2]),dy[n-2]),mul(3/(dx[0]*dx[0]),dy[0]));
        T[0].push(0,0,0);
        T[1].push(n-2,0,1);
        T[2].push(1/dx[n-2],2/dx[n-2]+2/dx[0],1/dx[0]);
        break;
    default:
        b[0] = k1;
        T[0].push(0);
        T[1].push(0);
        T[2].push(1);
        break;
    }
    for(i=1;i<n-1;i++) {
        b[i] = add(mul(3/(dx[i-1]*dx[i-1]),dy[i-1]),mul(3/(dx[i]*dx[i]),dy[i]));
        T[0].push(i,i,i);
        T[1].push(i-1,i,i+1);
        T[2].push(1/dx[i-1],2/dx[i-1]+2/dx[i],1/dx[i]);
    }
    switch(typeof kn) {
    case "undefined":
        b[n-1] = mul(3/(dx[n-2]*dx[n-2]),dy[n-2]);
        T[0].push(n-1,n-1);
        T[1].push(n-2,n-1);
        T[2].push(1/dx[n-2],2/dx[n-2]);
        break;
    case "string":
        T[1][T[1].length-1] = 0;
        break;
    default:
        b[n-1] = kn;
        T[0].push(n-1);
        T[1].push(n-1);
        T[2].push(1);
        break;
    }
    if(typeof b[0] !== "number") b = numeric.transpose(b);
    else b = [b];
    var k = Array(b.length);
    if(typeof k1 === "string") {
        for(i=k.length-1;i!==-1;--i) {
            k[i] = numeric.ccsLUPSolve(numeric.ccsLUP(numeric.ccsScatter(T)),b[i]);
            k[i][n-1] = k[i][0];
        }
    } else {
        for(i=k.length-1;i!==-1;--i) {
            k[i] = numeric.cLUsolve(numeric.cLU(T),b[i]);
        }
    }
    if(typeof y[0] === "number") k = k[0];
    else k = numeric.transpose(k);
    return new numeric.Spline(x,y,y,k,k);
};

// 8. FFT
numeric.fftpow2 = function fftpow2(x,y) {
    var n = x.length;
    if(n === 1) return;
    var cos = Math.cos, sin = Math.sin, i,j;
    var xe = Array(n/2), ye = Array(n/2), xo = Array(n/2), yo = Array(n/2);
    j = n/2;
    for(i=n-1;i!==-1;--i) {
        --j;
        xo[j] = x[i];
        yo[j] = y[i];
        --i;
        xe[j] = x[i];
        ye[j] = y[i];
    }
    fftpow2(xe,ye);
    fftpow2(xo,yo);
    j = n/2;
    var t,k = (-6.2831853071795864769252867665590057683943387987502116419/n),ci,si;
    for(i=n-1;i!==-1;--i) {
        --j;
        if(j === -1) j = n/2-1;
        t = k*i;
        ci = cos(t);
        si = sin(t);
        x[i] = xe[j] + ci*xo[j] - si*yo[j];
        y[i] = ye[j] + ci*yo[j] + si*xo[j];
    }
};
numeric._ifftpow2 = function _ifftpow2(x,y) {
    var n = x.length;
    if(n === 1) return;
    var cos = Math.cos, sin = Math.sin, i,j;
    var xe = Array(n/2), ye = Array(n/2), xo = Array(n/2), yo = Array(n/2);
    j = n/2;
    for(i=n-1;i!==-1;--i) {
        --j;
        xo[j] = x[i];
        yo[j] = y[i];
        --i;
        xe[j] = x[i];
        ye[j] = y[i];
    }
    _ifftpow2(xe,ye);
    _ifftpow2(xo,yo);
    j = n/2;
    var t,k = (6.2831853071795864769252867665590057683943387987502116419/n),ci,si;
    for(i=n-1;i!==-1;--i) {
        --j;
        if(j === -1) j = n/2-1;
        t = k*i;
        ci = cos(t);
        si = sin(t);
        x[i] = xe[j] + ci*xo[j] - si*yo[j];
        y[i] = ye[j] + ci*yo[j] + si*xo[j];
    }
};
numeric.ifftpow2 = function ifftpow2(x,y) {
    numeric._ifftpow2(x,y);
    numeric.diveq(x,x.length);
    numeric.diveq(y,y.length);
};
numeric.convpow2 = function convpow2(ax,ay,bx,by) {
    numeric.fftpow2(ax,ay);
    numeric.fftpow2(bx,by);
    var i,n = ax.length,axi,bxi,ayi,byi;
    for(i=n-1;i!==-1;--i) {
        axi = ax[i]; ayi = ay[i]; bxi = bx[i]; byi = by[i];
        ax[i] = axi*bxi-ayi*byi;
        ay[i] = axi*byi+ayi*bxi;
    }
    numeric.ifftpow2(ax,ay);
};
numeric.T.prototype.fft = function fft() {
    var x = this.x, y = this.y;
    var n = x.length, log = Math.log, log2 = log(2),
        p = Math.ceil(log(2*n-1)/log2), m = Math.pow(2,p);
    var cx = numeric.rep([m],0), cy = numeric.rep([m],0), cos = Math.cos, sin = Math.sin;
    var k, c = (-3.141592653589793238462643383279502884197169399375105820/n),t;
    var a = numeric.rep([m],0), b = numeric.rep([m],0),nhalf = Math.floor(n/2);
    for(k=0;k<n;k++) a[k] = x[k];
    if(typeof y !== "undefined") for(k=0;k<n;k++) b[k] = y[k];
    cx[0] = 1;
    for(k=1;k<=m/2;k++) {
        t = c*k*k;
        cx[k] = cos(t);
        cy[k] = sin(t);
        cx[m-k] = cos(t);
        cy[m-k] = sin(t);
    }
    var X = new numeric.T(a,b), Y = new numeric.T(cx,cy);
    X = X.mul(Y);
    numeric.convpow2(X.x,X.y,numeric.clone(Y.x),numeric.neg(Y.y));
    X = X.mul(Y);
    X.x.length = n;
    X.y.length = n;
    return X;
};
numeric.T.prototype.ifft = function ifft() {
    var x = this.x, y = this.y;
    var n = x.length, log = Math.log, log2 = log(2),
        p = Math.ceil(log(2*n-1)/log2), m = Math.pow(2,p);
    var cx = numeric.rep([m],0), cy = numeric.rep([m],0), cos = Math.cos, sin = Math.sin;
    var k, c = (3.141592653589793238462643383279502884197169399375105820/n),t;
    var a = numeric.rep([m],0), b = numeric.rep([m],0),nhalf = Math.floor(n/2);
    for(k=0;k<n;k++) a[k] = x[k];
    if(typeof y !== "undefined") for(k=0;k<n;k++) b[k] = y[k];
    cx[0] = 1;
    for(k=1;k<=m/2;k++) {
        t = c*k*k;
        cx[k] = cos(t);
        cy[k] = sin(t);
        cx[m-k] = cos(t);
        cy[m-k] = sin(t);
    }
    var X = new numeric.T(a,b), Y = new numeric.T(cx,cy);
    X = X.mul(Y);
    numeric.convpow2(X.x,X.y,numeric.clone(Y.x),numeric.neg(Y.y));
    X = X.mul(Y);
    X.x.length = n;
    X.y.length = n;
    return X.div(n);
};

//9. Unconstrained optimization
numeric.gradient = function gradient(f,x) {
    var n = x.length;
    var f0 = f(x);
    if(isNaN(f0)) throw new Error('gradient: f(x) is a NaN!');
    var max = Math.max;
    var i,x0 = numeric.clone(x),f1,f2, J = Array(n);
    var div = numeric.div, sub = numeric.sub,errest,roundoff,max = Math.max,eps = 1e-3,abs = Math.abs, min = Math.min;
    var t0,t1,t2,it=0,d1,d2,N;
    for(i=0;i<n;i++) {
        var h = max(1e-6*f0,1e-8);
        while(1) {
            ++it;
            if(it>20) { throw new Error("Numerical gradient fails"); }
            x0[i] = x[i]+h;
            f1 = f(x0);
            x0[i] = x[i]-h;
            f2 = f(x0);
            x0[i] = x[i];
            if(isNaN(f1) || isNaN(f2)) { h/=16; continue; }
            J[i] = (f1-f2)/(2*h);
            t0 = x[i]-h;
            t1 = x[i];
            t2 = x[i]+h;
            d1 = (f1-f0)/h;
            d2 = (f0-f2)/h;
            N = max(abs(J[i]),abs(f0),abs(f1),abs(f2),abs(t0),abs(t1),abs(t2),1e-8);
            errest = min(max(abs(d1-J[i]),abs(d2-J[i]),abs(d1-d2))/N,h/N);
            if(errest>eps) { h/=16; }
            else break;
            }
    }
    return J;
};

numeric.uncmin = function uncmin(f,x0,tol,gradient,maxit,callback,options) {
    var grad = numeric.gradient;
    if(typeof options === "undefined") { options = {}; }
    if(typeof tol === "undefined") { tol = 1e-8; }
    if(typeof gradient === "undefined") { gradient = function(x) { return grad(f,x); }; }
    if(typeof maxit === "undefined") maxit = 1000;
    x0 = numeric.clone(x0);
    var n = x0.length;
    var f0 = f(x0),f1,df0;
    if(isNaN(f0)) throw new Error('uncmin: f(x0) is a NaN!');
    var max = Math.max, norm2 = numeric.norm2;
    tol = max(tol,numeric.epsilon);
    var step,g0,g1,H1 = options.Hinv || numeric.identity(n);
    var dot = numeric.dot, inv = numeric.inv, sub = numeric.sub, add = numeric.add, ten = numeric.tensor, div = numeric.div, mul = numeric.mul;
    var all = numeric.all, isfinite = numeric.isFinite, neg = numeric.neg;
    var it=0,i,s,x1,y,Hy,Hs,ys,i0,t,nstep,t1,t2;
    var msg = "";
    g0 = gradient(x0);
    while(it<maxit) {
        if(typeof callback === "function") { if(callback(it,x0,f0,g0,H1)) { msg = "Callback returned true"; break; } }
        if(!all(isfinite(g0))) { msg = "Gradient has Infinity or NaN"; break; }
        step = neg(dot(H1,g0));
        if(!all(isfinite(step))) { msg = "Search direction has Infinity or NaN"; break; }
        nstep = norm2(step);
        if(nstep < tol) { msg="Newton step smaller than tol"; break; }
        t = 1;
        df0 = dot(g0,step);
        // line search
        x1 = x0;
        while(it < maxit) {
            if(t*nstep < tol) { break; }
            s = mul(step,t);
            x1 = add(x0,s);
            f1 = f(x1);
            if(f1-f0 >= 0.1*t*df0 || isNaN(f1)) {
                t *= 0.5;
                ++it;
                continue;
            }
            break;
        }
        if(t*nstep < tol) { msg = "Line search step size smaller than tol"; break; }
        if(it === maxit) { msg = "maxit reached during line search"; break; }
        g1 = gradient(x1);
        y = sub(g1,g0);
        ys = dot(y,s);
        Hy = dot(H1,y);
        H1 = sub(add(H1,
                mul(
                        (ys+dot(y,Hy))/(ys*ys),
                        ten(s,s)    )),
                div(add(ten(Hy,s),ten(s,Hy)),ys));
        x0 = x1;
        f0 = f1;
        g0 = g1;
        ++it;
    }
    return {solution: x0, f: f0, gradient: g0, invHessian: H1, iterations:it, message: msg};
};

// 10. Ode solver (Dormand-Prince)
numeric.Dopri = function Dopri(x,y,f,ymid,iterations,msg,events) {
    this.x = x;
    this.y = y;
    this.f = f;
    this.ymid = ymid;
    this.iterations = iterations;
    this.events = events;
    this.message = msg;
};
numeric.Dopri.prototype._at = function _at(xi,j) {
    function sqr(x) { return x*x; }
    var sol = this;
    var xs = sol.x;
    var ys = sol.y;
    var k1 = sol.f;
    var ymid = sol.ymid;
    var n = xs.length;
    var x0,x1,xh,y0,y1,yh,xi;
    var floor = Math.floor,h;
    var c = 0.5;
    var add = numeric.add, mul = numeric.mul,sub = numeric.sub, p,q,w;
    x0 = xs[j];
    x1 = xs[j+1];
    y0 = ys[j];
    y1 = ys[j+1];
    h  = x1-x0;
    xh = x0+c*h;
    yh = ymid[j];
    p = sub(k1[j  ],mul(y0,1/(x0-xh)+2/(x0-x1)));
    q = sub(k1[j+1],mul(y1,1/(x1-xh)+2/(x1-x0)));
    w = [sqr(xi - x1) * (xi - xh) / sqr(x0 - x1) / (x0 - xh),
         sqr(xi - x0) * sqr(xi - x1) / sqr(x0 - xh) / sqr(x1 - xh),
         sqr(xi - x0) * (xi - xh) / sqr(x1 - x0) / (x1 - xh),
         (xi - x0) * sqr(xi - x1) * (xi - xh) / sqr(x0-x1) / (x0 - xh),
         (xi - x1) * sqr(xi - x0) * (xi - xh) / sqr(x0-x1) / (x1 - xh)];
    return add(add(add(add(mul(y0,w[0]),
                           mul(yh,w[1])),
                           mul(y1,w[2])),
                           mul( p,w[3])),
                           mul( q,w[4]));
};
numeric.Dopri.prototype.at = function at(x) {
    var i,j,k,floor = Math.floor;
    if(typeof x !== "number") {
        var n = x.length, ret = Array(n);
        for(i=n-1;i!==-1;--i) {
            ret[i] = this.at(x[i]);
        }
        return ret;
    }
    var x0 = this.x;
    i = 0; j = x0.length-1;
    while(j-i>1) {
        k = floor(0.5*(i+j));
        if(x0[k] <= x) i = k;
        else j = k;
    }
    return this._at(x,i);
};

numeric.dopri = function dopri(x0,x1,y0,f,tol,maxit,event) {
    if(typeof tol === "undefined") { tol = 1e-6; }
    if(typeof maxit === "undefined") { maxit = 1000; }
    var xs = [x0], ys = [y0], k1 = [f(x0,y0)], k2,k3,k4,k5,k6,k7, ymid = [];
    var A2 = 1/5;
    var A3 = [3/40,9/40];
    var A4 = [44/45,-56/15,32/9];
    var A5 = [19372/6561,-25360/2187,64448/6561,-212/729];
    var A6 = [9017/3168,-355/33,46732/5247,49/176,-5103/18656];
    var b = [35/384,0,500/1113,125/192,-2187/6784,11/84];
    var bm = [0.5*6025192743/30085553152,
              0,
              0.5*51252292925/65400821598,
              0.5*-2691868925/45128329728,
              0.5*187940372067/1594534317056,
              0.5*-1776094331/19743644256,
              0.5*11237099/235043384];
    var c = [1/5,3/10,4/5,8/9,1,1];
    var e = [-71/57600,0,71/16695,-71/1920,17253/339200,-22/525,1/40];
    var i = 0,er,j;
    var h = (x1-x0)/10;
    var it = 0;
    var add = numeric.add, mul = numeric.mul, y1,erinf;
    var max = Math.max, min = Math.min, abs = Math.abs, norminf = numeric.norminf,pow = Math.pow;
    var any = numeric.any, lt = numeric.lt, and = numeric.and, sub = numeric.sub;
    var e0, e1, ev;
    var ret = new numeric.Dopri(xs,ys,k1,ymid,-1,"");
    if(typeof event === "function") e0 = event(x0,y0);
    while(x0<x1 && it<maxit) {
        ++it;
        if(x0+h>x1) h = x1-x0;
        k2 = f(x0+c[0]*h,                add(y0,mul(   A2*h,k1[i])));
        k3 = f(x0+c[1]*h,            add(add(y0,mul(A3[0]*h,k1[i])),mul(A3[1]*h,k2)));
        k4 = f(x0+c[2]*h,        add(add(add(y0,mul(A4[0]*h,k1[i])),mul(A4[1]*h,k2)),mul(A4[2]*h,k3)));
        k5 = f(x0+c[3]*h,    add(add(add(add(y0,mul(A5[0]*h,k1[i])),mul(A5[1]*h,k2)),mul(A5[2]*h,k3)),mul(A5[3]*h,k4)));
        k6 = f(x0+c[4]*h,add(add(add(add(add(y0,mul(A6[0]*h,k1[i])),mul(A6[1]*h,k2)),mul(A6[2]*h,k3)),mul(A6[3]*h,k4)),mul(A6[4]*h,k5)));
        y1 = add(add(add(add(add(y0,mul(k1[i],h*b[0])),mul(k3,h*b[2])),mul(k4,h*b[3])),mul(k5,h*b[4])),mul(k6,h*b[5]));
        k7 = f(x0+h,y1);
        er = add(add(add(add(add(mul(k1[i],h*e[0]),mul(k3,h*e[2])),mul(k4,h*e[3])),mul(k5,h*e[4])),mul(k6,h*e[5])),mul(k7,h*e[6]));
        if(typeof er === "number") erinf = abs(er);
        else erinf = norminf(er);
        if(erinf > tol) { // reject
            h = 0.2*h*pow(tol/erinf,0.25);
            if(x0+h === x0) {
                ret.msg = "Step size became too small";
                break;
            }
            continue;
        }
        ymid[i] = add(add(add(add(add(add(y0,
                mul(k1[i],h*bm[0])),
                mul(k3   ,h*bm[2])),
                mul(k4   ,h*bm[3])),
                mul(k5   ,h*bm[4])),
                mul(k6   ,h*bm[5])),
                mul(k7   ,h*bm[6]));
        ++i;
        xs[i] = x0+h;
        ys[i] = y1;
        k1[i] = k7;
        if(typeof event === "function") {
            var yi,xl = x0,xr = x0+0.5*h,xi;
            e1 = event(xr,ymid[i-1]);
            ev = and(lt(e0,0),lt(0,e1));
            if(!any(ev)) { xl = xr; xr = x0+h; e0 = e1; e1 = event(xr,y1); ev = and(lt(e0,0),lt(0,e1)); }
            if(any(ev)) {
                var xc, yc, en,ei;
                var side=0, sl = 1.0, sr = 1.0;
                while(1) {
                    if(typeof e0 === "number") xi = (sr*e1*xl-sl*e0*xr)/(sr*e1-sl*e0);
                    else {
                        xi = xr;
                        for(j=e0.length-1;j!==-1;--j) {
                            if(e0[j]<0 && e1[j]>0) xi = min(xi,(sr*e1[j]*xl-sl*e0[j]*xr)/(sr*e1[j]-sl*e0[j]));
                        }
                    }
                    if(xi <= xl || xi >= xr) break;
                    yi = ret._at(xi, i-1);
                    ei = event(xi,yi);
                    en = and(lt(e0,0),lt(0,ei));
                    if(any(en)) {
                        xr = xi;
                        e1 = ei;
                        ev = en;
                        sr = 1.0;
                        if(side === -1) sl *= 0.5;
                        else sl = 1.0;
                        side = -1;
                    } else {
                        xl = xi;
                        e0 = ei;
                        sl = 1.0;
                        if(side === 1) sr *= 0.5;
                        else sr = 1.0;
                        side = 1;
                    }
                }
                y1 = ret._at(0.5*(x0+xi),i-1);
                ret.f[i] = f(xi,yi);
                ret.x[i] = xi;
                ret.y[i] = yi;
                ret.ymid[i-1] = y1;
                ret.events = ev;
                ret.iterations = it;
                return ret;
            }
        }
        x0 += h;
        y0 = y1;
        e0 = e1;
        h = min(0.8*h*pow(tol/erinf,0.25),4*h);
    }
    ret.iterations = it;
    return ret;
};

// 11. Ax = b
numeric.LU = function(A, fast) {
  fast = fast || false;

  var abs = Math.abs;
  var i, j, k, absAjk, Akk, Ak, Pk, Ai;
  var max;
  var n = A.length, n1 = n-1;
  var P = new Array(n);
  if(!fast) A = numeric.clone(A);

  for (k = 0; k < n; ++k) {
    Pk = k;
    Ak = A[k];
    max = abs(Ak[k]);
    for (j = k + 1; j < n; ++j) {
      absAjk = abs(A[j][k]);
      if (max < absAjk) {
        max = absAjk;
        Pk = j;
      }
    }
    P[k] = Pk;

    if (Pk != k) {
      A[k] = A[Pk];
      A[Pk] = Ak;
      Ak = A[k];
    }

    Akk = Ak[k];

    for (i = k + 1; i < n; ++i) {
      A[i][k] /= Akk;
    }

    for (i = k + 1; i < n; ++i) {
      Ai = A[i];
      for (j = k + 1; j < n1; ++j) {
        Ai[j] -= Ai[k] * Ak[j];
        ++j;
        Ai[j] -= Ai[k] * Ak[j];
      }
      if(j===n1) Ai[j] -= Ai[k] * Ak[j];
    }
  }

  return {
    LU: A,
    P:  P
  };
};

numeric.LUsolve = function LUsolve(LUP, b) {
  var i, j;
  var LU = LUP.LU;
  var n   = LU.length;
  var x = numeric.clone(b);
  var P   = LUP.P;
  var Pi, LUi, LUii, tmp;

  for (i=n-1;i!==-1;--i) x[i] = b[i];
  for (i = 0; i < n; ++i) {
    Pi = P[i];
    if (P[i] !== i) {
      tmp = x[i];
      x[i] = x[Pi];
      x[Pi] = tmp;
    }

    LUi = LU[i];
    for (j = 0; j < i; ++j) {
      x[i] -= x[j] * LUi[j];
    }
  }

  for (i = n - 1; i >= 0; --i) {
    LUi = LU[i];
    for (j = i + 1; j < n; ++j) {
      x[i] -= x[j] * LUi[j];
    }

    x[i] /= LUi[i];
  }

  return x;
};

numeric.solve = function solve(A,b,fast) { return numeric.LUsolve(numeric.LU(A,fast), b); };

// 12. Linear programming
numeric.echelonize = function echelonize(A) {
    var s = numeric.dim(A), m = s[0], n = s[1];
    var I = numeric.identity(m);
    var P = Array(m);
    var i,j,k,l,Ai,Ii,Z,a;
    var abs = Math.abs;
    var diveq = numeric.diveq;
    A = numeric.clone(A);
    for(i=0;i<m;++i) {
        k = 0;
        Ai = A[i];
        Ii = I[i];
        for(j=1;j<n;++j) if(abs(Ai[k])<abs(Ai[j])) k=j;
        P[i] = k;
        diveq(Ii,Ai[k]);
        diveq(Ai,Ai[k]);
        for(j=0;j<m;++j) if(j!==i) {
            Z = A[j]; a = Z[k];
            for(l=n-1;l!==-1;--l) Z[l] -= Ai[l]*a;
            Z = I[j];
            for(l=m-1;l!==-1;--l) Z[l] -= Ii[l]*a;
        }
    }
    return {I:I, A:A, P:P};
};

numeric.__solveLP = function __solveLP(c,A,b,tol,maxit,x,flag) {
    var sum = numeric.sum, log = numeric.log, mul = numeric.mul, sub = numeric.sub, dot = numeric.dot, div = numeric.div, add = numeric.add;
    var m = c.length, n = b.length,y;
    var unbounded = false, cb,i0=0;
    var alpha = 1.0;
    var f0,df0,AT = numeric.transpose(A), svd = numeric.svd,transpose = numeric.transpose,leq = numeric.leq, sqrt = Math.sqrt, abs = Math.abs;
    var muleq = numeric.muleq;
    var norm = numeric.norminf, any = numeric.any,min = Math.min;
    var all = numeric.all, gt = numeric.gt;
    var p = Array(m), A0 = Array(n),e=numeric.rep([n],1), H;
    var solve = numeric.solve, z = sub(b,dot(A,x)),count;
    var dotcc = dot(c,c);
    var g;
    for(count=i0;count<maxit;++count) {
        var i,j,d;
        for(i=n-1;i!==-1;--i) A0[i] = div(A[i],z[i]);
        var A1 = transpose(A0);
        for(i=m-1;i!==-1;--i) p[i] = (/*x[i]+*/sum(A1[i]));
        alpha = 0.25*abs(dotcc/dot(c,p));
        var a1 = 100*sqrt(dotcc/dot(p,p));
        if(!isFinite(alpha) || alpha>a1) alpha = a1;
        g = add(c,mul(alpha,p));
        H = dot(A1,A0);
        for(i=m-1;i!==-1;--i) H[i][i] += 1;
        d = solve(H,div(g,alpha),true);
        var t0 = div(z,dot(A,d));
        var t = 1.0;
        for(i=n-1;i!==-1;--i) if(t0[i]<0) t = min(t,-0.999*t0[i]);
        y = sub(x,mul(d,t));
        z = sub(b,dot(A,y));
        if(!all(gt(z,0))) return { solution: x, message: "", iterations: count };
        x = y;
        if(alpha<tol) return { solution: y, message: "", iterations: count };
        if(flag) {
            var s = dot(c,g), Ag = dot(A,g);
            unbounded = true;
            for(i=n-1;i!==-1;--i) if(s*Ag[i]<0) { unbounded = false; break; }
        } else {
            if(x[m-1]>=0) unbounded = false;
            else unbounded = true;
        }
        if(unbounded) return { solution: y, message: "Unbounded", iterations: count };
    }
    return { solution: x, message: "maximum iteration count exceeded", iterations:count };
};

numeric._solveLP = function _solveLP(c,A,b,tol,maxit) {
    var m = c.length, n = b.length,y;
    var sum = numeric.sum, log = numeric.log, mul = numeric.mul, sub = numeric.sub, dot = numeric.dot, div = numeric.div, add = numeric.add;
    var c0 = numeric.rep([m],0).concat([1]);
    var J = numeric.rep([n,1],-1);
    var A0 = numeric.blockMatrix([[A                   ,   J  ]]);
    var b0 = b;
    var y = numeric.rep([m],0).concat(Math.max(0,numeric.sup(numeric.neg(b)))+1);
    var x0 = numeric.__solveLP(c0,A0,b0,tol,maxit,y,false);
    var x = numeric.clone(x0.solution);
    x.length = m;
    var foo = numeric.inf(sub(b,dot(A,x)));
    if(foo<0) { return { solution: NaN, message: "Infeasible", iterations: x0.iterations }; }
    var ret = numeric.__solveLP(c, A, b, tol, maxit-x0.iterations, x, true);
    ret.iterations += x0.iterations;
    return ret;
};

numeric.solveLP = function solveLP(c,A,b,Aeq,beq,tol,maxit) {
    if(typeof maxit === "undefined") maxit = 1000;
    if(typeof tol === "undefined") tol = numeric.epsilon;
    if(typeof Aeq === "undefined") return numeric._solveLP(c,A,b,tol,maxit);
    var m = Aeq.length, n = Aeq[0].length, o = A.length;
    var B = numeric.echelonize(Aeq);
    var flags = numeric.rep([n],0);
    var P = B.P;
    var Q = [];
    var i;
    for(i=P.length-1;i!==-1;--i) flags[P[i]] = 1;
    for(i=n-1;i!==-1;--i) if(flags[i]===0) Q.push(i);
    var g = numeric.getRange;
    var I = numeric.linspace(0,m-1), J = numeric.linspace(0,o-1);
    var Aeq2 = g(Aeq,I,Q), A1 = g(A,J,P), A2 = g(A,J,Q), dot = numeric.dot, sub = numeric.sub;
    var A3 = dot(A1,B.I);
    var A4 = sub(A2,dot(A3,Aeq2)), b4 = sub(b,dot(A3,beq));
    var c1 = Array(P.length), c2 = Array(Q.length);
    for(i=P.length-1;i!==-1;--i) c1[i] = c[P[i]];
    for(i=Q.length-1;i!==-1;--i) c2[i] = c[Q[i]];
    var c4 = sub(c2,dot(c1,dot(B.I,Aeq2)));
    var S = numeric._solveLP(c4,A4,b4,tol,maxit);
    var x2 = S.solution;
    if(x2!==x2) return S;
    var x1 = dot(B.I,sub(beq,dot(Aeq2,x2)));
    var x = Array(c.length);
    for(i=P.length-1;i!==-1;--i) x[P[i]] = x1[i];
    for(i=Q.length-1;i!==-1;--i) x[Q[i]] = x2[i];
    return { solution: x, message:S.message, iterations: S.iterations };
};

numeric.MPStoLP = function MPStoLP(MPS) {
    if(MPS instanceof String) { MPS.split('\n'); }
    var state = 0;
    var states = ['Initial state','NAME','ROWS','COLUMNS','RHS','BOUNDS','ENDATA'];
    var n = MPS.length;
    var i,j,z,N=0,rows = {}, sign = [], rl = 0, vars = {}, nv = 0;
    var name;
    var c = [], A = [], b = [];
    function err(e) { throw new Error('MPStoLP: '+e+'\nLine '+i+': '+MPS[i]+'\nCurrent state: '+states[state]+'\n'); }
    for(i=0;i<n;++i) {
        z = MPS[i];
        var w0 = z.match(/\S*/g);
        var w = [];
        for(j=0;j<w0.length;++j) if(w0[j]!=="") w.push(w0[j]);
        if(w.length === 0) continue;
        for(j=0;j<states.length;++j) if(z.substr(0,states[j].length) === states[j]) break;
        if(j<states.length) {
            state = j;
            if(j===1) { name = w[1]; }
            if(j===6) return { name:name, c:c, A:numeric.transpose(A), b:b, rows:rows, vars:vars };
            continue;
        }
        switch(state) {
        case 0: case 1: err('Unexpected line');
        case 2: 
            switch(w[0]) {
            case 'N': if(N===0) N = w[1]; else err('Two or more N rows'); break;
            case 'L': rows[w[1]] = rl; sign[rl] = 1; b[rl] = 0; ++rl; break;
            case 'G': rows[w[1]] = rl; sign[rl] = -1;b[rl] = 0; ++rl; break;
            case 'E': rows[w[1]] = rl; sign[rl] = 0;b[rl] = 0; ++rl; break;
            default: err('Parse error '+numeric.prettyPrint(w));
            }
            break;
        case 3:
            if(!vars.hasOwnProperty(w[0])) { vars[w[0]] = nv; c[nv] = 0; A[nv] = numeric.rep([rl],0); ++nv; }
            var p = vars[w[0]];
            for(j=1;j<w.length;j+=2) {
                if(w[j] === N) { c[p] = parseFloat(w[j+1]); continue; }
                var q = rows[w[j]];
                A[p][q] = (sign[q]<0?-1:1)*parseFloat(w[j+1]);
            }
            break;
        case 4:
            for(j=1;j<w.length;j+=2) b[rows[w[j]]] = (sign[rows[w[j]]]<0?-1:1)*parseFloat(w[j+1]);
            break;
        case 5: /*FIXME*/ break;
        case 6: err('Internal error');
        }
    }
    err('Reached end of file without ENDATA');
};
// seedrandom.js version 2.0.
// Author: David Bau 4/2/2011
//
// Defines a method Math.seedrandom() that, when called, substitutes
// an explicitly seeded RC4-based algorithm for Math.random().  Also
// supports automatic seeding from local or network sources of entropy.
//
// Usage:
//
//   <script src=http://davidbau.com/encode/seedrandom-min.js></script>
//
//   Math.seedrandom('yipee'); Sets Math.random to a function that is
//                             initialized using the given explicit seed.
//
//   Math.seedrandom();        Sets Math.random to a function that is
//                             seeded using the current time, dom state,
//                             and other accumulated local entropy.
//                             The generated seed string is returned.
//
//   Math.seedrandom('yowza', true);
//                             Seeds using the given explicit seed mixed
//                             together with accumulated entropy.
//
//   <script src="http://bit.ly/srandom-512"></script>
//                             Seeds using physical random bits downloaded
//                             from random.org.
//
//   <script src="https://jsonlib.appspot.com/urandom?callback=Math.seedrandom">
//   </script>                 Seeds using urandom bits from call.jsonlib.com,
//                             which is faster than random.org.
//
// Examples:
//
//   Math.seedrandom("hello");            // Use "hello" as the seed.
//   document.write(Math.random());       // Always 0.5463663768140734
//   document.write(Math.random());       // Always 0.43973793770592234
//   var rng1 = Math.random;              // Remember the current prng.
//
//   var autoseed = Math.seedrandom();    // New prng with an automatic seed.
//   document.write(Math.random());       // Pretty much unpredictable.
//
//   Math.random = rng1;                  // Continue "hello" prng sequence.
//   document.write(Math.random());       // Always 0.554769432473455
//
//   Math.seedrandom(autoseed);           // Restart at the previous seed.
//   document.write(Math.random());       // Repeat the 'unpredictable' value.
//
// Notes:
//
// Each time seedrandom('arg') is called, entropy from the passed seed
// is accumulated in a pool to help generate future seeds for the
// zero-argument form of Math.seedrandom, so entropy can be injected over
// time by calling seedrandom with explicit data repeatedly.
//
// On speed - This javascript implementation of Math.random() is about
// 3-10x slower than the built-in Math.random() because it is not native
// code, but this is typically fast enough anyway.  Seeding is more expensive,
// especially if you use auto-seeding.  Some details (timings on Chrome 4):
//
// Our Math.random()            - avg less than 0.002 milliseconds per call
// seedrandom('explicit')       - avg less than 0.5 milliseconds per call
// seedrandom('explicit', true) - avg less than 2 milliseconds per call
// seedrandom()                 - avg about 38 milliseconds per call
//
// LICENSE (BSD):
//
// Copyright 2010 David Bau, all rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// 
//   1. Redistributions of source code must retain the above copyright
//      notice, this list of conditions and the following disclaimer.
//
//   2. Redistributions in binary form must reproduce the above copyright
//      notice, this list of conditions and the following disclaimer in the
//      documentation and/or other materials provided with the distribution.
// 
//   3. Neither the name of this module nor the names of its contributors may
//      be used to endorse or promote products derived from this software
//      without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
/**
 * All code is in an anonymous closure to keep the global namespace clean.
 *
 * @param {number=} overflow 
 * @param {number=} startdenom
 */

// Patched by Seb so that seedrandom.js does not pollute the Math object.
// My tests suggest that doing Math.trouble = 1 makes Math lookups about 5%
// slower.
numeric.seedrandom = { pow:Math.pow, random:Math.random };

(function (pool, math, width, chunks, significance, overflow, startdenom) {


//
// seedrandom()
// This is the seedrandom function described above.
//
math['seedrandom'] = function seedrandom(seed, use_entropy) {
  var key = [];
  var arc4;

  // Flatten the seed string or build one from local entropy if needed.
  seed = mixkey(flatten(
    use_entropy ? [seed, pool] :
    arguments.length ? seed :
    [new Date().getTime(), pool, window], 3), key);

  // Use the seed to initialize an ARC4 generator.
  arc4 = new ARC4(key);

  // Mix the randomness into accumulated entropy.
  mixkey(arc4.S, pool);

  // Override Math.random

  // This function returns a random double in [0, 1) that contains
  // randomness in every bit of the mantissa of the IEEE 754 value.

  math['random'] = function random() {  // Closure to return a random double:
    var n = arc4.g(chunks);             // Start with a numerator n < 2 ^ 48
    var d = startdenom;                 //   and denominator d = 2 ^ 48.
    var x = 0;                          //   and no 'extra last byte'.
    while (n < significance) {          // Fill up all significant digits by
      n = (n + x) * width;              //   shifting numerator and
      d *= width;                       //   denominator and generating a
      x = arc4.g(1);                    //   new least-significant-byte.
    }
    while (n >= overflow) {             // To avoid rounding up, before adding
      n /= 2;                           //   last byte, shift everything
      d /= 2;                           //   right using integer math until
      x >>>= 1;                         //   we have exactly the desired bits.
    }
    return (n + x) / d;                 // Form the number within [0, 1).
  };

  // Return the seed that was used
  return seed;
};

//
// ARC4
//
// An ARC4 implementation.  The constructor takes a key in the form of
// an array of at most (width) integers that should be 0 <= x < (width).
//
// The g(count) method returns a pseudorandom integer that concatenates
// the next (count) outputs from ARC4.  Its return value is a number x
// that is in the range 0 <= x < (width ^ count).
//
/** @constructor */
function ARC4(key) {
  var t, u, me = this, keylen = key.length;
  var i = 0, j = me.i = me.j = me.m = 0;
  me.S = [];
  me.c = [];

  // The empty key [] is treated as [0].
  if (!keylen) { key = [keylen++]; }

  // Set up S using the standard key scheduling algorithm.
  while (i < width) { me.S[i] = i++; }
  for (i = 0; i < width; i++) {
    t = me.S[i];
    j = lowbits(j + t + key[i % keylen]);
    u = me.S[j];
    me.S[i] = u;
    me.S[j] = t;
  }

  // The "g" method returns the next (count) outputs as one number.
  me.g = function getnext(count) {
    var s = me.S;
    var i = lowbits(me.i + 1); var t = s[i];
    var j = lowbits(me.j + t); var u = s[j];
    s[i] = u;
    s[j] = t;
    var r = s[lowbits(t + u)];
    while (--count) {
      i = lowbits(i + 1); t = s[i];
      j = lowbits(j + t); u = s[j];
      s[i] = u;
      s[j] = t;
      r = r * width + s[lowbits(t + u)];
    }
    me.i = i;
    me.j = j;
    return r;
  };
  // For robust unpredictability discard an initial batch of values.
  // See http://www.rsa.com/rsalabs/node.asp?id=2009
  me.g(width);
}

//
// flatten()
// Converts an object tree to nested arrays of strings.
//
/** @param {Object=} result 
  * @param {string=} prop
  * @param {string=} typ */
function flatten(obj, depth, result, prop, typ) {
  result = [];
  typ = typeof(obj);
  if (depth && typ == 'object') {
    for (prop in obj) {
      if (prop.indexOf('S') < 5) {    // Avoid FF3 bug (local/sessionStorage)
        try { result.push(flatten(obj[prop], depth - 1)); } catch (e) {}
      }
    }
  }
  return (result.length ? result : obj + (typ != 'string' ? '\0' : ''));
}

//
// mixkey()
// Mixes a string seed into a key that is an array of integers, and
// returns a shortened string seed that is equivalent to the result key.
//
/** @param {number=} smear 
  * @param {number=} j */
function mixkey(seed, key, smear, j) {
  seed += '';                         // Ensure the seed is a string
  smear = 0;
  for (j = 0; j < seed.length; j++) {
    key[lowbits(j)] =
      lowbits((smear ^= key[lowbits(j)] * 19) + seed.charCodeAt(j));
  }
  seed = '';
  for (j in key) { seed += String.fromCharCode(key[j]); }
  return seed;
}

//
// lowbits()
// A quick "n mod width" for width a power of 2.
//
function lowbits(n) { return n & (width - 1); }

//
// The following constants are related to IEEE 754 limits.
//
startdenom = math.pow(width, chunks);
significance = math.pow(2, significance);
overflow = significance * 2;

//
// When seedrandom.js is loaded, we immediately mix a few bits
// from the built-in RNG into the entropy pool.  Because we do
// not want to intefere with determinstic PRNG state later,
// seedrandom will not call math.random on its own again after
// initialization.
//
mixkey(math.random(), pool);

// End anonymous scope, and pass initial values.
}(
  [],   // pool: entropy pool starts empty
  numeric.seedrandom, // math: package containing random, pow, and seedrandom
  256,  // width: each RC4 output is 0 <= x < 256
  6,    // chunks: at least six RC4 outputs for each double
  52    // significance: there are 52 significant digits in a double
  ));
/* This file is a slightly modified version of quadprog.js from Alberto Santini.
 * It has been slightly modified by Sébastien Loisel to make sure that it handles
 * 0-based Arrays instead of 1-based Arrays.
 * License is in resources/LICENSE.quadprog */
(function(exports) {

function base0to1(A) {
    if(typeof A !== "object") { return A; }
    var ret = [], i,n=A.length;
    for(i=0;i<n;i++) ret[i+1] = base0to1(A[i]);
    return ret;
}
function base1to0(A) {
    if(typeof A !== "object") { return A; }
    var ret = [], i,n=A.length;
    for(i=1;i<n;i++) ret[i-1] = base1to0(A[i]);
    return ret;
}

function dpori(a, lda, n) {
    var i, j, k, kp1, t;

    for (k = 1; k <= n; k = k + 1) {
        a[k][k] = 1 / a[k][k];
        t = -a[k][k];
        //~ dscal(k - 1, t, a[1][k], 1);
        for (i = 1; i < k; i = i + 1) {
            a[i][k] = t * a[i][k];
        }

        kp1 = k + 1;
        if (n < kp1) {
            break;
        }
        for (j = kp1; j <= n; j = j + 1) {
            t = a[k][j];
            a[k][j] = 0;
            //~ daxpy(k, t, a[1][k], 1, a[1][j], 1);
            for (i = 1; i <= k; i = i + 1) {
                a[i][j] = a[i][j] + (t * a[i][k]);
            }
        }
    }

}

function dposl(a, lda, n, b) {
    var i, k, kb, t;

    for (k = 1; k <= n; k = k + 1) {
        //~ t = ddot(k - 1, a[1][k], 1, b[1], 1);
        t = 0;
        for (i = 1; i < k; i = i + 1) {
            t = t + (a[i][k] * b[i]);
        }

        b[k] = (b[k] - t) / a[k][k];
    }

    for (kb = 1; kb <= n; kb = kb + 1) {
        k = n + 1 - kb;
        b[k] = b[k] / a[k][k];
        t = -b[k];
        //~ daxpy(k - 1, t, a[1][k], 1, b[1], 1);
        for (i = 1; i < k; i = i + 1) {
            b[i] = b[i] + (t * a[i][k]);
        }
    }
}

function dpofa(a, lda, n, info) {
    var i, j, jm1, k, t, s;

    for (j = 1; j <= n; j = j + 1) {
        info[1] = j;
        s = 0;
        jm1 = j - 1;
        if (jm1 < 1) {
            s = a[j][j] - s;
            if (s <= 0) {
                break;
            }
            a[j][j] = Math.sqrt(s);
        } else {
            for (k = 1; k <= jm1; k = k + 1) {
                //~ t = a[k][j] - ddot(k - 1, a[1][k], 1, a[1][j], 1);
                t = a[k][j];
                for (i = 1; i < k; i = i + 1) {
                    t = t - (a[i][j] * a[i][k]);
                }
                t = t / a[k][k];
                a[k][j] = t;
                s = s + t * t;
            }
            s = a[j][j] - s;
            if (s <= 0) {
                break;
            }
            a[j][j] = Math.sqrt(s);
        }
        info[1] = 0;
    }
}

function qpgen2(dmat, dvec, fddmat, n, sol, crval, amat,
    bvec, fdamat, q, meq, iact, nact, iter, work, ierr) {

    var i, j, l, l1, info, it1, iwzv, iwrv, iwrm, iwsv, iwuv, nvl, r, iwnbv,
        temp, sum, t1, tt, gc, gs, nu,
        t1inf, t2min,
        vsmall, tmpa, tmpb,
        go;

    r = Math.min(n, q);
    l = 2 * n + (r * (r + 5)) / 2 + 2 * q + 1;

    vsmall = 1.0e-60;
    do {
        vsmall = vsmall + vsmall;
        tmpa = 1 + 0.1 * vsmall;
        tmpb = 1 + 0.2 * vsmall;
    } while (tmpa <= 1 || tmpb <= 1);

    for (i = 1; i <= n; i = i + 1) {
        work[i] = dvec[i];
    }
    for (i = n + 1; i <= l; i = i + 1) {
        work[i] = 0;
    }
    for (i = 1; i <= q; i = i + 1) {
        iact[i] = 0;
    }

    info = [];

    if (ierr[1] === 0) {
        dpofa(dmat, fddmat, n, info);
        if (info[1] !== 0) {
            ierr[1] = 2;
            return;
        }
        dposl(dmat, fddmat, n, dvec);
        dpori(dmat, fddmat, n);
    } else {
        for (j = 1; j <= n; j = j + 1) {
            sol[j] = 0;
            for (i = 1; i <= j; i = i + 1) {
                sol[j] = sol[j] + dmat[i][j] * dvec[i];
            }
        }
        for (j = 1; j <= n; j = j + 1) {
            dvec[j] = 0;
            for (i = j; i <= n; i = i + 1) {
                dvec[j] = dvec[j] + dmat[j][i] * sol[i];
            }
        }
    }

    crval[1] = 0;
    for (j = 1; j <= n; j = j + 1) {
        sol[j] = dvec[j];
        crval[1] = crval[1] + work[j] * sol[j];
        work[j] = 0;
        for (i = j + 1; i <= n; i = i + 1) {
            dmat[i][j] = 0;
        }
    }
    crval[1] = -crval[1] / 2;
    ierr[1] = 0;

    iwzv = n;
    iwrv = iwzv + n;
    iwuv = iwrv + r;
    iwrm = iwuv + r + 1;
    iwsv = iwrm + (r * (r + 1)) / 2;
    iwnbv = iwsv + q;

    for (i = 1; i <= q; i = i + 1) {
        sum = 0;
        for (j = 1; j <= n; j = j + 1) {
            sum = sum + amat[j][i] * amat[j][i];
        }
        work[iwnbv + i] = Math.sqrt(sum);
    }
    nact = 0;
    iter[1] = 0;
    iter[2] = 0;

    function fn_goto_50() {
        iter[1] = iter[1] + 1;

        l = iwsv;
        for (i = 1; i <= q; i = i + 1) {
            l = l + 1;
            sum = -bvec[i];
            for (j = 1; j <= n; j = j + 1) {
                sum = sum + amat[j][i] * sol[j];
            }
            if (Math.abs(sum) < vsmall) {
                sum = 0;
            }
            if (i > meq) {
                work[l] = sum;
            } else {
                work[l] = -Math.abs(sum);
                if (sum > 0) {
                    for (j = 1; j <= n; j = j + 1) {
                        amat[j][i] = -amat[j][i];
                    }
                    bvec[i] = -bvec[i];
                }
            }
        }

        for (i = 1; i <= nact; i = i + 1) {
            work[iwsv + iact[i]] = 0;
        }

        nvl = 0;
        temp = 0;
        for (i = 1; i <= q; i = i + 1) {
            if (work[iwsv + i] < temp * work[iwnbv + i]) {
                nvl = i;
                temp = work[iwsv + i] / work[iwnbv + i];
            }
        }
        if (nvl === 0) {
            return 999;
        }

        return 0;
    }

    function fn_goto_55() {
        for (i = 1; i <= n; i = i + 1) {
            sum = 0;
            for (j = 1; j <= n; j = j + 1) {
                sum = sum + dmat[j][i] * amat[j][nvl];
            }
            work[i] = sum;
        }

        l1 = iwzv;
        for (i = 1; i <= n; i = i + 1) {
            work[l1 + i] = 0;
        }
        for (j = nact + 1; j <= n; j = j + 1) {
            for (i = 1; i <= n; i = i + 1) {
                work[l1 + i] = work[l1 + i] + dmat[i][j] * work[j];
            }
        }

        t1inf = true;
        for (i = nact; i >= 1; i = i - 1) {
            sum = work[i];
            l = iwrm + (i * (i + 3)) / 2;
            l1 = l - i;
            for (j = i + 1; j <= nact; j = j + 1) {
                sum = sum - work[l] * work[iwrv + j];
                l = l + j;
            }
            sum = sum / work[l1];
            work[iwrv + i] = sum;
            if (iact[i] < meq) {
                // continue;
                break;
            }
            if (sum < 0) {
                // continue;
                break;
            }
            t1inf = false;
            it1 = i;
        }

        if (!t1inf) {
            t1 = work[iwuv + it1] / work[iwrv + it1];
            for (i = 1; i <= nact; i = i + 1) {
                if (iact[i] < meq) {
                    // continue;
                    break;
                }
                if (work[iwrv + i] < 0) {
                    // continue;
                    break;
                }
                temp = work[iwuv + i] / work[iwrv + i];
                if (temp < t1) {
                    t1 = temp;
                    it1 = i;
                }
            }
        }

        sum = 0;
        for (i = iwzv + 1; i <= iwzv + n; i = i + 1) {
            sum = sum + work[i] * work[i];
        }
        if (Math.abs(sum) <= vsmall) {
            if (t1inf) {
                ierr[1] = 1;
                // GOTO 999
                return 999;
            } else {
                for (i = 1; i <= nact; i = i + 1) {
                    work[iwuv + i] = work[iwuv + i] - t1 * work[iwrv + i];
                }
                work[iwuv + nact + 1] = work[iwuv + nact + 1] + t1;
                // GOTO 700
                return 700;
            }
        } else {
            sum = 0;
            for (i = 1; i <= n; i = i + 1) {
                sum = sum + work[iwzv + i] * amat[i][nvl];
            }
            tt = -work[iwsv + nvl] / sum;
            t2min = true;
            if (!t1inf) {
                if (t1 < tt) {
                    tt = t1;
                    t2min = false;
                }
            }

            for (i = 1; i <= n; i = i + 1) {
                sol[i] = sol[i] + tt * work[iwzv + i];
                if (Math.abs(sol[i]) < vsmall) {
                    sol[i] = 0;
                }
            }

            crval[1] = crval[1] + tt * sum * (tt / 2 + work[iwuv + nact + 1]);
            for (i = 1; i <= nact; i = i + 1) {
                work[iwuv + i] = work[iwuv + i] - tt * work[iwrv + i];
            }
            work[iwuv + nact + 1] = work[iwuv + nact + 1] + tt;

            if (t2min) {
                nact = nact + 1;
                iact[nact] = nvl;

                l = iwrm + ((nact - 1) * nact) / 2 + 1;
                for (i = 1; i <= nact - 1; i = i + 1) {
                    work[l] = work[i];
                    l = l + 1;
                }

                if (nact === n) {
                    work[l] = work[n];
                } else {
                    for (i = n; i >= nact + 1; i = i - 1) {
                        if (work[i] === 0) {
                            // continue;
                            break;
                        }
                        gc = Math.max(Math.abs(work[i - 1]), Math.abs(work[i]));
                        gs = Math.min(Math.abs(work[i - 1]), Math.abs(work[i]));
                        if (work[i - 1] >= 0) {
                            temp = Math.abs(gc * Math.sqrt(1 + gs * gs / (gc * gc)));
                        } else {
                            temp = -Math.abs(gc * Math.sqrt(1 + gs * gs / (gc * gc)));
                        }
                        gc = work[i - 1] / temp;
                        gs = work[i] / temp;

                        if (gc === 1) {
                            // continue;
                            break;
                        }
                        if (gc === 0) {
                            work[i - 1] = gs * temp;
                            for (j = 1; j <= n; j = j + 1) {
                                temp = dmat[j][i - 1];
                                dmat[j][i - 1] = dmat[j][i];
                                dmat[j][i] = temp;
                            }
                        } else {
                            work[i - 1] = temp;
                            nu = gs / (1 + gc);
                            for (j = 1; j <= n; j = j + 1) {
                                temp = gc * dmat[j][i - 1] + gs * dmat[j][i];
                                dmat[j][i] = nu * (dmat[j][i - 1] + temp) - dmat[j][i];
                                dmat[j][i - 1] = temp;

                            }
                        }
                    }
                    work[l] = work[nact];
                }
            } else {
                sum = -bvec[nvl];
                for (j = 1; j <= n; j = j + 1) {
                    sum = sum + sol[j] * amat[j][nvl];
                }
                if (nvl > meq) {
                    work[iwsv + nvl] = sum;
                } else {
                    work[iwsv + nvl] = -Math.abs(sum);
                    if (sum > 0) {
                        for (j = 1; j <= n; j = j + 1) {
                            amat[j][nvl] = -amat[j][nvl];
                        }
                        bvec[nvl] = -bvec[nvl];
                    }
                }
                // GOTO 700
                return 700;
            }
        }

        return 0;
    }

    function fn_goto_797() {
        l = iwrm + (it1 * (it1 + 1)) / 2 + 1;
        l1 = l + it1;
        if (work[l1] === 0) {
            // GOTO 798
            return 798;
        }
        gc = Math.max(Math.abs(work[l1 - 1]), Math.abs(work[l1]));
        gs = Math.min(Math.abs(work[l1 - 1]), Math.abs(work[l1]));
        if (work[l1 - 1] >= 0) {
            temp = Math.abs(gc * Math.sqrt(1 + gs * gs / (gc * gc)));
        } else {
            temp = -Math.abs(gc * Math.sqrt(1 + gs * gs / (gc * gc)));
        }
        gc = work[l1 - 1] / temp;
        gs = work[l1] / temp;

        if (gc === 1) {
            // GOTO 798
            return 798;
        }
        if (gc === 0) {
            for (i = it1 + 1; i <= nact; i = i + 1) {
                temp = work[l1 - 1];
                work[l1 - 1] = work[l1];
                work[l1] = temp;
                l1 = l1 + i;
            }
            for (i = 1; i <= n; i = i + 1) {
                temp = dmat[i][it1];
                dmat[i][it1] = dmat[i][it1 + 1];
                dmat[i][it1 + 1] = temp;
            }
        } else {
            nu = gs / (1 + gc);
            for (i = it1 + 1; i <= nact; i = i + 1) {
                temp = gc * work[l1 - 1] + gs * work[l1];
                work[l1] = nu * (work[l1 - 1] + temp) - work[l1];
                work[l1 - 1] = temp;
                l1 = l1 + i;
            }
            for (i = 1; i <= n; i = i + 1) {
                temp = gc * dmat[i][it1] + gs * dmat[i][it1 + 1];
                dmat[i][it1 + 1] = nu * (dmat[i][it1] + temp) - dmat[i][it1 + 1];
                dmat[i][it1] = temp;
            }
        }

        return 0;
    }

    function fn_goto_798() {
        l1 = l - it1;
        for (i = 1; i <= it1; i = i + 1) {
            work[l1] = work[l];
            l = l + 1;
            l1 = l1 + 1;
        }

        work[iwuv + it1] = work[iwuv + it1 + 1];
        iact[it1] = iact[it1 + 1];
        it1 = it1 + 1;
        if (it1 < nact) {
            // GOTO 797
            return 797;
        }

        return 0;
    }

    function fn_goto_799() {
        work[iwuv + nact] = work[iwuv + nact + 1];
        work[iwuv + nact + 1] = 0;
        iact[nact] = 0;
        nact = nact - 1;
        iter[2] = iter[2] + 1;

        return 0;
    }

    go = 0;
    while (true) {
        go = fn_goto_50();
        if (go === 999) {
            return;
        }
        while (true) {
            go = fn_goto_55();
            if (go === 0) {
                break;
            }
            if (go === 999) {
                return;
            }
            if (go === 700) {
                if (it1 === nact) {
                    fn_goto_799();
                } else {
                    while (true) {
                        fn_goto_797();
                        go = fn_goto_798();
                        if (go !== 797) {
                            break;
                        }
                    }
                    fn_goto_799();
                }
            }
        }
    }

}

function solveQP(Dmat, dvec, Amat, bvec, meq, factorized) {
    Dmat = base0to1(Dmat);
    dvec = base0to1(dvec);
    Amat = base0to1(Amat);
    var i, n, q,
        nact, r,
        crval = [], iact = [], sol = [], work = [], iter = [],
        message;

    meq = meq || 0;
    factorized = factorized ? base0to1(factorized) : [undefined, 0];
    bvec = bvec ? base0to1(bvec) : [];

    // In Fortran the array index starts from 1
    n = Dmat.length - 1;
    q = Amat[1].length - 1;

    if (!bvec) {
        for (i = 1; i <= q; i = i + 1) {
            bvec[i] = 0;
        }
    }
    for (i = 1; i <= q; i = i + 1) {
        iact[i] = 0;
    }
    nact = 0;
    r = Math.min(n, q);
    for (i = 1; i <= n; i = i + 1) {
        sol[i] = 0;
    }
    crval[1] = 0;
    for (i = 1; i <= (2 * n + (r * (r + 5)) / 2 + 2 * q + 1); i = i + 1) {
        work[i] = 0;
    }
    for (i = 1; i <= 2; i = i + 1) {
        iter[i] = 0;
    }

    qpgen2(Dmat, dvec, n, n, sol, crval, Amat,
        bvec, n, q, meq, iact, nact, iter, work, factorized);

    message = "";
    if (factorized[1] === 1) {
        message = "constraints are inconsistent, no solution!";
    }
    if (factorized[1] === 2) {
        message = "matrix D in quadratic function is not positive definite!";
    }

    return {
        solution: base1to0(sol),
        value: base1to0(crval),
        unconstrained_solution: base1to0(dvec),
        iterations: base1to0(iter),
        iact: base1to0(iact),
        message: message
    };
}
exports.solveQP = solveQP;
}(numeric));
/*
Shanti Rao sent me this routine by private email. I had to modify it
slightly to work on Arrays instead of using a Matrix object.
It is apparently translated from http://stitchpanorama.sourceforge.net/Python/svd.py
*/

numeric.svd= function svd(A) {
    var temp;
//Compute the thin SVD from G. H. Golub and C. Reinsch, Numer. Math. 14, 403-420 (1970)
	var prec= numeric.epsilon; //Math.pow(2,-52) // assumes double prec
	var tolerance= 1.e-64/prec;
	var itmax= 50;
	var c=0;
	var i=0;
	var j=0;
	var k=0;
	var l=0;
	
	var u= numeric.clone(A);
	var m= u.length;
	
	var n= u[0].length;
	
	if (m < n) throw "Need more rows than columns"
	
	var e = new Array(n);
	var q = new Array(n);
	for (i=0; i<n; i++) e[i] = q[i] = 0.0;
	var v = numeric.rep([n,n],0);
//	v.zero();
	
 	function pythag(a,b)
 	{
		a = Math.abs(a);
		b = Math.abs(b);
		if (a > b)
			return a*Math.sqrt(1.0+(b*b/a/a))
		else if (b == 0.0) 
			return a
		return b*Math.sqrt(1.0+(a*a/b/b))
	}

	//Householder's reduction to bidiagonal form

	var f= 0.0;
	var g= 0.0;
	var h= 0.0;
	var x= 0.0;
	var y= 0.0;
	var z= 0.0;
	var s= 0.0;
	
	for (i=0; i < n; i++)
	{	
		e[i]= g;
		s= 0.0;
		l= i+1;
		for (j=i; j < m; j++) 
			s += (u[j][i]*u[j][i]);
		if (s <= tolerance)
			g= 0.0;
		else
		{	
			f= u[i][i];
			g= Math.sqrt(s);
			if (f >= 0.0) g= -g;
			h= f*g-s;
			u[i][i]=f-g;
			for (j=l; j < n; j++)
			{
				s= 0.0;
				for (k=i; k < m; k++) 
					s += u[k][i]*u[k][j];
				f= s/h;
				for (k=i; k < m; k++) 
					u[k][j]+=f*u[k][i];
			}
		}
		q[i]= g;
		s= 0.0;
		for (j=l; j < n; j++) 
			s= s + u[i][j]*u[i][j];
		if (s <= tolerance)
			g= 0.0;
		else
		{	
			f= u[i][i+1];
			g= Math.sqrt(s);
			if (f >= 0.0) g= -g;
			h= f*g - s;
			u[i][i+1] = f-g;
			for (j=l; j < n; j++) e[j]= u[i][j]/h;
			for (j=l; j < m; j++)
			{	
				s=0.0;
				for (k=l; k < n; k++) 
					s += (u[j][k]*u[i][k]);
				for (k=l; k < n; k++) 
					u[j][k]+=s*e[k];
			}	
		}
		y= Math.abs(q[i])+Math.abs(e[i]);
		if (y>x) 
			x=y;
	}
	
	// accumulation of right hand gtransformations
	for (i=n-1; i != -1; i+= -1)
	{	
		if (g != 0.0)
		{
		 	h= g*u[i][i+1];
			for (j=l; j < n; j++) 
				v[j][i]=u[i][j]/h;
			for (j=l; j < n; j++)
			{	
				s=0.0;
				for (k=l; k < n; k++) 
					s += u[i][k]*v[k][j];
				for (k=l; k < n; k++) 
					v[k][j]+=(s*v[k][i]);
			}	
		}
		for (j=l; j < n; j++)
		{
			v[i][j] = 0;
			v[j][i] = 0;
		}
		v[i][i] = 1;
		g= e[i];
		l= i;
	}
	
	// accumulation of left hand transformations
	for (i=n-1; i != -1; i+= -1)
	{	
		l= i+1;
		g= q[i];
		for (j=l; j < n; j++) 
			u[i][j] = 0;
		if (g != 0.0)
		{
			h= u[i][i]*g;
			for (j=l; j < n; j++)
			{
				s=0.0;
				for (k=l; k < m; k++) s += u[k][i]*u[k][j];
				f= s/h;
				for (k=i; k < m; k++) u[k][j]+=f*u[k][i];
			}
			for (j=i; j < m; j++) u[j][i] = u[j][i]/g;
		}
		else
			for (j=i; j < m; j++) u[j][i] = 0;
		u[i][i] += 1;
	}
	
	// diagonalization of the bidiagonal form
	prec= prec*x;
	for (k=n-1; k != -1; k+= -1)
	{
		for (var iteration=0; iteration < itmax; iteration++)
		{	// test f splitting
			var test_convergence = false;
			for (l=k; l != -1; l+= -1)
			{	
				if (Math.abs(e[l]) <= prec)
				{	test_convergence= true;
					break 
				}
				if (Math.abs(q[l-1]) <= prec)
					break 
			}
			if (!test_convergence)
			{	// cancellation of e[l] if l>0
				c= 0.0;
				s= 1.0;
				var l1= l-1;
				for (i =l; i<k+1; i++)
				{	
					f= s*e[i];
					e[i]= c*e[i];
					if (Math.abs(f) <= prec)
						break
					g= q[i];
					h= pythag(f,g);
					q[i]= h;
					c= g/h;
					s= -f/h;
					for (j=0; j < m; j++)
					{	
						y= u[j][l1];
						z= u[j][i];
						u[j][l1] =  y*c+(z*s);
						u[j][i] = -y*s+(z*c);
					} 
				}	
			}
			// test f convergence
			z= q[k];
			if (l== k)
			{	//convergence
				if (z<0.0)
				{	//q[k] is made non-negative
					q[k]= -z;
					for (j=0; j < n; j++)
						v[j][k] = -v[j][k];
				}
				break  //break out of iteration loop and move on to next k value
			}
			if (iteration >= itmax-1)
				throw 'Error: no convergence.'
			// shift from bottom 2x2 minor
			x= q[l];
			y= q[k-1];
			g= e[k-1];
			h= e[k];
			f= ((y-z)*(y+z)+(g-h)*(g+h))/(2.0*h*y);
			g= pythag(f,1.0);
			if (f < 0.0)
				f= ((x-z)*(x+z)+h*(y/(f-g)-h))/x;
			else
				f= ((x-z)*(x+z)+h*(y/(f+g)-h))/x;
			// next QR transformation
			c= 1.0;
			s= 1.0;
			for (i=l+1; i< k+1; i++)
			{	
				g= e[i];
				y= q[i];
				h= s*g;
				g= c*g;
				z= pythag(f,h);
				e[i-1]= z;
				c= f/z;
				s= h/z;
				f= x*c+g*s;
				g= -x*s+g*c;
				h= y*s;
				y= y*c;
				for (j=0; j < n; j++)
				{	
					x= v[j][i-1];
					z= v[j][i];
					v[j][i-1] = x*c+z*s;
					v[j][i] = -x*s+z*c;
				}
				z= pythag(f,h);
				q[i-1]= z;
				c= f/z;
				s= h/z;
				f= c*g+s*y;
				x= -s*g+c*y;
				for (j=0; j < m; j++)
				{
					y= u[j][i-1];
					z= u[j][i];
					u[j][i-1] = y*c+z*s;
					u[j][i] = -y*s+z*c;
				}
			}
			e[l]= 0.0;
			e[k]= f;
			q[k]= x;
		} 
	}
		
	//vt= transpose(v)
	//return (u,q,vt)
	for (i=0;i<q.length; i++) 
	  if (q[i] < prec) q[i] = 0;
	  
	//sort eigenvalues	
	for (i=0; i< n; i++)
	{	 
	//writeln(q)
	 for (j=i-1; j >= 0; j--)
	 {
	  if (q[j] < q[i])
	  {
	//  writeln(i,'-',j)
	   c = q[j];
	   q[j] = q[i];
	   q[i] = c;
	   for(k=0;k<u.length;k++) { temp = u[k][i]; u[k][i] = u[k][j]; u[k][j] = temp; }
	   for(k=0;k<v.length;k++) { temp = v[k][i]; v[k][i] = v[k][j]; v[k][j] = temp; }
//	   u.swapCols(i,j)
//	   v.swapCols(i,j)
	   i = j;	   
	  }
	 }	
	}
	
	return {U:u,S:q,V:v}
};
});

var performanceNow = createCommonjsModule(function (module) {
// Generated by CoffeeScript 1.12.2
(function() {
  var getNanoSeconds, hrtime, loadTime, moduleLoadTime, nodeLoadTime, upTime;

  if ((typeof performance !== "undefined" && performance !== null) && performance.now) {
    module.exports = function() {
      return performance.now();
    };
  } else if ((typeof process !== "undefined" && process !== null) && process.hrtime) {
    module.exports = function() {
      return (getNanoSeconds() - nodeLoadTime) / 1e6;
    };
    hrtime = process.hrtime;
    getNanoSeconds = function() {
      var hr;
      hr = hrtime();
      return hr[0] * 1e9 + hr[1];
    };
    moduleLoadTime = getNanoSeconds();
    upTime = process.uptime() * 1e9;
    nodeLoadTime = moduleLoadTime - upTime;
  } else if (Date.now) {
    module.exports = function() {
      return Date.now() - loadTime;
    };
    loadTime = Date.now();
  } else {
    module.exports = function() {
      return new Date().getTime() - loadTime;
    };
    loadTime = new Date().getTime();
  }

}).call(commonjsGlobal);


});

var root = typeof window === 'undefined' ? commonjsGlobal : window;
var vendors = ['moz', 'webkit'];
var suffix = 'AnimationFrame';
var raf = root['request' + suffix];
var caf = root['cancel' + suffix] || root['cancelRequest' + suffix];

for(var i = 0; !raf && i < vendors.length; i++) {
  raf = root[vendors[i] + 'Request' + suffix];
  caf = root[vendors[i] + 'Cancel' + suffix]
      || root[vendors[i] + 'CancelRequest' + suffix];
}

// Some versions of FF have rAF but not cAF
if(!raf || !caf) {
  var last = 0
    , id = 0
    , queue = []
    , frameDuration = 1000 / 60;

  raf = function(callback) {
    if(queue.length === 0) {
      var _now = performanceNow()
        , next = Math.max(0, frameDuration - (_now - last));
      last = next + _now;
      setTimeout(function() {
        var cp = queue.slice(0);
        // Clear queue here to prevent
        // callbacks from appending listeners
        // to the current frame's queue
        queue.length = 0;
        for(var i = 0; i < cp.length; i++) {
          if(!cp[i].cancelled) {
            try{
              cp[i].callback(last);
            } catch(e) {
              setTimeout(function() { throw e }, 0);
            }
          }
        }
      }, Math.round(next));
    }
    queue.push({
      handle: ++id,
      callback: callback,
      cancelled: false
    });
    return id
  };

  caf = function(handle) {
    for(var i = 0; i < queue.length; i++) {
      if(queue[i].handle === handle) {
        queue[i].cancelled = true;
      }
    }
  };
}

var index = function(fn) {
  // Wrap in a new function to prevent
  // `cancel` potentially being assigned
  // to the native rAF function
  return raf.call(root, fn)
};
var cancel = function() {
  caf.apply(root, arguments);
};
var polyfill = function() {
  root.requestAnimationFrame = raf;
  root.cancelAnimationFrame = caf;
};

index.cancel = cancel;
index.polyfill = polyfill;

var promise = createCommonjsModule(function (module) {
(function (root) {

  // Store setTimeout reference so promise-polyfill will be unaffected by
  // other code modifying setTimeout (like sinon.useFakeTimers())
  var setTimeoutFunc = setTimeout;

  function noop() {}
  
  // Polyfill for Function.prototype.bind
  function bind(fn, thisArg) {
    return function () {
      fn.apply(thisArg, arguments);
    };
  }

  function Promise(fn) {
    if (typeof this !== 'object') throw new TypeError('Promises must be constructed via new');
    if (typeof fn !== 'function') throw new TypeError('not a function');
    this._state = 0;
    this._handled = false;
    this._value = undefined;
    this._deferreds = [];

    doResolve(fn, this);
  }

  function handle(self, deferred) {
    while (self._state === 3) {
      self = self._value;
    }
    if (self._state === 0) {
      self._deferreds.push(deferred);
      return;
    }
    self._handled = true;
    Promise._immediateFn(function () {
      var cb = self._state === 1 ? deferred.onFulfilled : deferred.onRejected;
      if (cb === null) {
        (self._state === 1 ? resolve : reject)(deferred.promise, self._value);
        return;
      }
      var ret;
      try {
        ret = cb(self._value);
      } catch (e) {
        reject(deferred.promise, e);
        return;
      }
      resolve(deferred.promise, ret);
    });
  }

  function resolve(self, newValue) {
    try {
      // Promise Resolution Procedure: https://github.com/promises-aplus/promises-spec#the-promise-resolution-procedure
      if (newValue === self) throw new TypeError('A promise cannot be resolved with itself.');
      if (newValue && (typeof newValue === 'object' || typeof newValue === 'function')) {
        var then = newValue.then;
        if (newValue instanceof Promise) {
          self._state = 3;
          self._value = newValue;
          finale(self);
          return;
        } else if (typeof then === 'function') {
          doResolve(bind(then, newValue), self);
          return;
        }
      }
      self._state = 1;
      self._value = newValue;
      finale(self);
    } catch (e) {
      reject(self, e);
    }
  }

  function reject(self, newValue) {
    self._state = 2;
    self._value = newValue;
    finale(self);
  }

  function finale(self) {
    if (self._state === 2 && self._deferreds.length === 0) {
      Promise._immediateFn(function() {
        if (!self._handled) {
          Promise._unhandledRejectionFn(self._value);
        }
      });
    }

    for (var i = 0, len = self._deferreds.length; i < len; i++) {
      handle(self, self._deferreds[i]);
    }
    self._deferreds = null;
  }

  function Handler(onFulfilled, onRejected, promise) {
    this.onFulfilled = typeof onFulfilled === 'function' ? onFulfilled : null;
    this.onRejected = typeof onRejected === 'function' ? onRejected : null;
    this.promise = promise;
  }

  /**
   * Take a potentially misbehaving resolver function and make sure
   * onFulfilled and onRejected are only called once.
   *
   * Makes no guarantees about asynchrony.
   */
  function doResolve(fn, self) {
    var done = false;
    try {
      fn(function (value) {
        if (done) return;
        done = true;
        resolve(self, value);
      }, function (reason) {
        if (done) return;
        done = true;
        reject(self, reason);
      });
    } catch (ex) {
      if (done) return;
      done = true;
      reject(self, ex);
    }
  }

  Promise.prototype['catch'] = function (onRejected) {
    return this.then(null, onRejected);
  };

  Promise.prototype.then = function (onFulfilled, onRejected) {
    var prom = new (this.constructor)(noop);

    handle(this, new Handler(onFulfilled, onRejected, prom));
    return prom;
  };

  Promise.all = function (arr) {
    var args = Array.prototype.slice.call(arr);

    return new Promise(function (resolve, reject) {
      if (args.length === 0) return resolve([]);
      var remaining = args.length;

      function res(i, val) {
        try {
          if (val && (typeof val === 'object' || typeof val === 'function')) {
            var then = val.then;
            if (typeof then === 'function') {
              then.call(val, function (val) {
                res(i, val);
              }, reject);
              return;
            }
          }
          args[i] = val;
          if (--remaining === 0) {
            resolve(args);
          }
        } catch (ex) {
          reject(ex);
        }
      }

      for (var i = 0; i < args.length; i++) {
        res(i, args[i]);
      }
    });
  };

  Promise.resolve = function (value) {
    if (value && typeof value === 'object' && value.constructor === Promise) {
      return value;
    }

    return new Promise(function (resolve) {
      resolve(value);
    });
  };

  Promise.reject = function (value) {
    return new Promise(function (resolve, reject) {
      reject(value);
    });
  };

  Promise.race = function (values) {
    return new Promise(function (resolve, reject) {
      for (var i = 0, len = values.length; i < len; i++) {
        values[i].then(resolve, reject);
      }
    });
  };

  // Use polyfill for setImmediate for performance gains
  Promise._immediateFn = (typeof setImmediate === 'function' && function (fn) { setImmediate(fn); }) ||
    function (fn) {
      setTimeoutFunc(fn, 0);
    };

  Promise._unhandledRejectionFn = function _unhandledRejectionFn(err) {
    if (typeof console !== 'undefined' && console) {
      console.warn('Possible Unhandled Promise Rejection:', err); // eslint-disable-line no-console
    }
  };

  /**
   * Set the immediate function to execute callbacks
   * @param fn {function} Function to execute
   * @deprecated
   */
  Promise._setImmediateFn = function _setImmediateFn(fn) {
    Promise._immediateFn = fn;
  };

  /**
   * Change the function to execute on unhandled rejection
   * @param {function} fn Function to execute on unhandled rejection
   * @deprecated
   */
  Promise._setUnhandledRejectionFn = function _setUnhandledRejectionFn(fn) {
    Promise._unhandledRejectionFn = fn;
  };
  
  if ('object' !== 'undefined' && module.exports) {
    module.exports = Promise;
  } else if (!root.Promise) {
    root.Promise = Promise;
  }

})(commonjsGlobal);
});

// IE polyfill from MDN
(function () {
	if (typeof window.CustomEvent === 'function') return false;

	function CustomEvent (event, params) {
		params = params || {bubbles : false, cancelable : false, detail: undefined};
		var evt = document.createEvent('CustomEvent');
		evt.initCustomEvent(event, params.bubbles, params.cancelable, params.detail);
		return evt;
	}

	CustomEvent.prototype = window.Event.prototype;

	window.CustomEvent = CustomEvent;
})();

function emitEvent(eventName) {
	var evt = new CustomEvent(eventName, {'bubbles': true, 'cancelable': true});
	document.dispatchEvent(evt);
}

/**
 * Fast Fourier Transform
 * 1D-FFT/IFFT, 2D-FFT/IFFT (radix-2)
 * 
 * @author ryo / github.com/wellflat
 * Based on https://github.com/wellflat/jslib with some tiny optimizations
 */

function FFT() {
  
  var _n = 0,          // order
      _bitrev = null,  // bit reversal table
      _cstb = null;    // sin/cos table
  var _tre, _tim;
  
  this.init = function (n) {
    if(n !== 0 && (n & (n - 1)) === 0) {
      _n = n;
      _setVariables();
      _makeBitReversal();
      _makeCosSinTable();
    } else {
      throw new Error("init: radix-2 required");
    }
  };
    
  // 1D-FFT
  this.fft1d = function (re, im) {
    fft(re, im, 1);
  };
    
  // 1D-IFFT
  this.ifft1d = function (re, im) {
    var n = 1/_n;
    fft(re, im, -1);
    for(var i=0; i<_n; i++) {
      re[i] *= n;
      im[i] *= n;
    }
  };
  
  // 2D-FFT
  this.fft2d = function (re, im) {
    var i = 0;
    // x-axis
    for(var y=0; y<_n; y++) {
      i = y*_n;
      for(var x1=0; x1<_n; x1++) {
        _tre[x1] = re[x1 + i];
        _tim[x1] = im[x1 + i];
      }
      this.fft1d(_tre, _tim);
      for(var x2=0; x2<_n; x2++) {
        re[x2 + i] = _tre[x2];
        im[x2 + i] = _tim[x2];
      }
    }
    // y-axis
    for(var x=0; x<_n; x++) {
      for(var y1=0; y1<_n; y1++) {
        i = x + y1*_n;
        _tre[y1] = re[i];
        _tim[y1] = im[i];
      }
      this.fft1d(_tre, _tim);
      for(var y2=0; y2<_n; y2++) {
        i = x + y2*_n;
        re[i] = _tre[y2];
        im[i] = _tim[y2];
      }
    }
  };
  
  // 2D-IFFT
  this.ifft2d = function (re, im) {
    var i = 0;
    // x-axis
    for(var y=0; y<_n; y++) {
      i = y*_n;
      for(var x1=0; x1<_n; x1++) {
        _tre[x1] = re[x1 + i];
        _tim[x1] = im[x1 + i];
      }
      this.ifft1d(_tre, _tim);
      for(var x2=0; x2<_n; x2++) {
        re[x2 + i] = _tre[x2];
        im[x2 + i] = _tim[x2];
      }
    }
    // y-axis
    for(var x=0; x<_n; x++) {
      for(var y1=0; y1<_n; y1++) {
        i = x + y1*_n;
        _tre[y1] = re[i];
        _tim[y1] = im[i];
      }
      this.ifft1d(_tre, _tim);
      for(var y2=0; y2<_n; y2++) {
        i = x + y2*_n;
        re[i] = _tre[y2];
        im[i] = _tim[y2];
      }
    }
  };
  
  // core operation of FFT
  function fft(re, im, inv) {
    var d, h, ik, m, tmp, wr, wi, xr, xi,
        n4 = _n >> 2;
    // bit reversal
    for(var l=0; l<_n; l++) {
      m = _bitrev[l];
      if(l < m) {
        tmp = re[l];
        re[l] = re[m];
        re[m] = tmp;
        tmp = im[l];
        im[l] = im[m];
        im[m] = tmp;
      }
    }
    // butterfly operation
    for(var k=1; k<_n; k<<=1) {
      h = 0;
      d = _n/(k << 1);
      for(var j=0; j<k; j++) {
        wr = _cstb[h + n4];
        wi = inv*_cstb[h];
        for(var i=j; i<_n; i+=(k<<1)) {
          ik = i + k;
          xr = wr*re[ik] + wi*im[ik];
          xi = wr*im[ik] - wi*re[ik];
          re[ik] = re[i] - xr;
          re[i] += xr;
          im[ik] = im[i] - xi;
          im[i] += xi;
        }
        h += d;
      }
    }
  }
  
  // set variables
  function _setVariables() {
    if(typeof Uint8Array !== 'undefined') {
      _bitrev = new Uint8Array(_n);
    } else {
      _bitrev = new Array(_n);
    }
    if(typeof Float64Array !== 'undefined') {
      _cstb = new Float64Array(_n*1.25);
      _tre = new Float64Array(_n*_n);
      _tim = new Float64Array(_n*_n);
    } else {
      _cstb = new Array(_n*1.25);
      _tre = new Array(_n*_n);
      _tim = new Array(_n*_n);
    }
  }
  
  // make bit reversal table
  function _makeBitReversal() {
    var i = 0,
        j = 0,
        k = 0;
    _bitrev[0] = 0;
    while(++i < _n) {
      k = _n >> 1;
      while(k <= j) {
        j -= k;
        k >>= 1;
      }
      j += k;
      _bitrev[i] = j;
    }
  }
  
  // make trigonometric function table
  function _makeCosSinTable() {
    var n2 = _n >> 1,
        n4 = _n >> 2,
        n8 = _n >> 3,
        n2p4 = n2 + n4,
        t = Math.sin(Math.PI/_n),
        dc = 2*t*t,
        ds = Math.sqrt(dc*(2 - dc)),
        c = _cstb[n4] = 1,
        s = _cstb[0] = 0;
    t = 2*dc;
    for(var i=1; i<n8; i++) {
      c -= dc;
      dc += t*c;
      s += ds;
      ds -= t*s;
      _cstb[i] = s;
      _cstb[n4 - i] = c;
    }
    if(n8 !== 0) {
      _cstb[n8] = Math.sqrt(0.5);
    }
    for(var j=0; j<n4; j++) {
      _cstb[n2 - j]  = _cstb[j];
    }
    for(var k=0; k<n2p4; k++) {
      _cstb[k + n2] = -_cstb[k];
    }
  }
}

var left_eye_filter = {"real": [1.5419219943717721, 0.40010880110578706, -0.79043641265342957, -1.2685464969238938, 0.39878117336167285, -1.0673489992245377, -0.079880838229404019, -0.45374680224191505, -0.043474097938900787, -0.31125662385352687, 0.17092430376098702, -0.29613086164846153, 0.5616469648110296, -1.559786848789493, 0.64513037997492662, -1.2899747976234162, 1.1761667998175334, -1.2899747976233551, 0.64513037997490474, -1.5597868487894897, 0.56164696481102505, -0.29613086164845964, 0.17092430376099094, -0.31125662385352959, -0.043474097938900787, -0.45374680224191177, -0.079880838229404658, -1.0673489992245357, 0.39878117336167307, -1.2685464969238942, -0.79043641265343012, 0.40010880110578717, -1.3820969331049027, 0.069560471269205768, -1.9786339579213206, -1.9807415717551982, -0.78667274410450883, -1.2217002325587256, -0.19150029104902774, -0.35131617290773243, -0.17646388464205803, -0.16672095020503441, -0.092298612924566523, -0.028899376452253527, -0.1314555696102146, -0.32892265898101813, -0.40987148655061206, 0.11741827111366547, -0.67254330182605138, -0.46007833291519956, -0.67215259521101001, -0.44871907432473013, -0.034749316729184583, 0.0055639281302433969, -0.17675902360981591, -0.26196208085032191, -0.36301254306387037, -0.33546767337818123, -0.6458889740799838, -1.1981932989987978, 0.12372650763830917, -1.4996172161865935, -2.4084298023013888, -2.0505291279591722, -1.7249706159518585, -2.277646289702639, -3.1259631743419591, -2.9656385065342015, -2.8480835086962011, -1.4260964500310189, -0.61792590829173544, -0.2611655301498782, -0.38519889843539723, -0.17511899827006483, -0.32808050503227176, 0.0076800871037463036, -0.18710828510427668, 0.1976534820339281, -0.55444453100465052, 0.14583567590328381, -0.69844971117515287, -0.90188577233526623, -0.53500016384583371, -0.044420751861669799, 0.014727914354086128, -0.28084584584371913, -0.29890408748685848, -0.39431380149336548, -0.39569215798819307, -0.74351999988258299, -0.82502198370631752, -1.851491897104155, -0.74302378668934244, 0.21156442062863762, -3.3061472495599986, -1.7990472945779568, -2.2193764251732282, -2.3438802466919251, -3.3615971067123311, -3.5383249085863708, -2.2639673745086588, -2.0271757806780748, -0.75242583405872232, -0.30143411016839378, -0.3625272253546275, -0.25489431004647689, -0.18928491561467081, -0.1179891518538482, 0.027920290231533224, -0.035472107498143821, -0.29008721857562259, -0.3604588674139817, -0.39156143807433802, -0.82222257402876564, -0.44979914971695928, -0.098136330355476253, 0.065628582466229365, -0.33607304327303128, -0.32161201323497779, -0.41856090178723965, -0.64028425429629054, -0.7766428172010218, -1.3946448661671447, -2.2603422126144683, -0.38769722219534525, -0.95341593939478653, -1.412952994959813, -2.3602336858020432, -1.2756392437278019, -2.0983496132652038, -2.5682454610054268, -2.8791053946930378, -2.1809972632688095, -0.84281293847776861, -0.75998936793718697, -0.18584599820380068, -0.30105748355308259, -0.16098142942852958, -0.13792125740417191, -0.089790022871128708, -0.12321821342876504, -0.1128661923016878, -0.3924098378001975, -0.5780902167586397, -0.48685989567066695, -0.53565359443296234, -0.051036689850526382, -0.0068547033925117689, -0.18963405157839419, -0.22514761090777807, -0.35555823460888908, -0.46670603976585517, -0.56179541485257889, -0.7495095888115163, -1.4772075422260349, -1.5836466114968029, -2.3846549454186694, -1.4884613952536236, -1.8237453905245253, -1.6712324532934877, -1.5169157844507295, -1.6930052820597281, -2.1023566589276004, -2.2062031109308458, -1.7945281756942255, -0.26457398838912649, 0.22038139379151148, -0.43479836723775234, -0.19830827357221226, -0.18018565146479498, -0.097060879184795737, -0.10088329756370379, -0.063069709957272527, -0.17970932516041177, -0.1943040732581543, -0.37970560392277619, -0.47302301606251812, -0.30366967948052181, -0.064732391018915397, -0.08902516330269715, -0.082000200083027344, -0.22965854401457736, -0.32035624605031326, -0.31836783196552437, -0.40132058236311119, -0.65601747033470859, -0.59040483751417483, -1.8503084663080034, -1.8694842425148914, -1.9326778896298584, -1.6301578422923519, -1.4332006785118301, -1.305707665299106, -1.364200787821644, -1.5357935460809622, -1.6161992336951241, -0.74003518668370516, -0.29423824173210689, 0.025934598230976654, -0.043349004411304674, -0.25408021803022468, -0.066965686484977499, -0.075717498698635255, 0.007057189465364498, -0.042171356658338113, -0.036938315661768008, -0.34221561581756049, -0.20400167508805764, -0.37417116097079772, -0.25039909487805356, -0.070874531394524931, -0.0569972852039487, -0.067238206950403182, -0.17397285212300442, -0.20428337307808273, -0.23651154356493315, -0.33356498933276568, -0.07339749754226077, -0.70367959806681601, -0.82403680021595049, -1.6058616381755235, -1.6192427030685497, -1.5705638815427956, -1.4659201063980019, -0.95504179549951018, -0.97237526162739873, -1.0460191987834688, -0.91465668941265721, -0.60548232361398524, 0.01898438364933451, -0.19419044456729498, -0.039627851124307223, 0.0012357796666701798, -0.078110822445325079, 0.0048626364920250518, -0.040449089662379589, -0.0035054269587873454, -0.13387544724730729, -0.10031131456276647, -0.25968674675684189, -0.20555329767005767, -0.26509289948725284, -0.038788452621647145, -0.076999891872251258, -0.071661433038976499, -0.14182240789719938, -0.1654673053291095, -0.19859450279267193, -0.053382326365810369, -0.2156585383674445, -0.045097357284793499, -0.62449818579949512, -0.92624906744917224, -1.0411254782363617, -1.122035196738675, -1.0607692164246043, -0.57723811773534028, -0.63187735896388075, -0.54813311204421922, -0.55320252101738743, -0.30197299587482401, -0.047213249757838388, 0.082808930467383288, -0.067715134483222431, -0.01022881748368659, 0.042038311258956552, -0.063371767399980669, 0.029161890169972702, -0.091396316586836127, -0.0034600735070754811, -0.12424052925006424, -0.24432996418012101, -0.26521664175359499, -0.22745980283820413, -0.14361316535317664, -0.00075904203100577935, -0.020936168457862139, -0.14205665196423617, -0.19024248288823023, -0.079686122362245204, -0.15016133237735926, 0.049598910651295514, -0.11760486834511712, -0.1837522251545049, -0.38594205494114608, -0.53542516436999843, -0.57340991730807989, -0.52753621424018138, -0.23151163972118355, -0.22295096919949259, -0.33704349161770436, -0.26165852514054583, -0.13898866968588663, 0.034596483191139484, -0.012631210076789067, 0.047371310076345617, -0.038651839330751551, -0.0019970761454430018, 0.063048845258375494, -0.1124891762554399, 0.08556992539656616, -0.21043659051868199, -0.19223333969456, -0.39082994830035861, -0.19294368007162721, -0.41025595439938572, -0.17178084419175166, -0.010933041190555012, -0.089512936152074493, -0.21569610281495066, -0.09144756671688016, -0.19525258909505316, -0.029753598134641936, -0.021307245660079924, 0.029087127940551009, 0.037511290653097842, -0.20600990120705839, -0.26967580750352926, -0.21000923681194664, -0.28209018858285628, -0.11925518789339556, -0.24869348141289982, -0.21025892926356746, -0.15567029136726124, -0.040546729108395907, -0.0050266153100547101, 0.030710887069787196, -0.0061104340245858278, 0.0369376092260571, -0.054862661367900321, 0.013297880203253048, 0.19659447375886394, -0.2499491329142558, -0.062959699002865757, -0.53055029095956008, -0.38784811281629444, -0.53891285075962392, -0.41886712861154285, -0.099230097260325875, -0.16474199810952628, -0.28693665642627014, -0.0095667980850221105, -0.32619954993450928, -0.08627491478166284, -0.073253161755714766, 0.015634174038690329, 0.082440536547531792, 0.025411878261881942, -0.11318909242737961, -0.1270560226842935, -0.21657212936164139, -0.13993873549611191, -0.37510275237622831, -0.26472923111076219, -0.24460131567533192, -0.14127652303494026, -0.050428686591045178, 0.041347840374190772, -0.0061780445153000636, 0.0073990345210250153, -0.014062739037014381, 0.14348925152561878, -0.015321787554403667, 0.0017746672356015968, 0.25165135427361052, -0.626463828190993, -0.48167134330805639, -1.045863293770664, -0.69512591788493194, -0.44532127384388254, -0.28479724025368391, -0.39470955087317983, 0.20227228344720469, -0.53909912073488953, -0.12025629051789474, -0.1899243750597305, -0.048474806721595133, 0.060764771353227762, 0.090648151782516159, 0.091608208912697275, 0.0036582478916540977, -0.22492530005263131, -0.27295314658024766, -0.35559738025257359, -0.62902925014412947, -0.57166411974881004, -0.37258895173129181, -0.22157638610464933, 0.022494427132080854, 0.014769425415166171, 0.003526808789406817, -0.011346909674078769, 0.050921170848348289, 0.090308541799219627, 0.37260817254533324, -0.25909871392159911, -0.42379280974334355, -0.095380647808568128, -1.1906083748893519, -0.78599914414892469, -0.95277914352730275, -0.63659778359422337, -0.98026015008952749, 0.48173198285916102, -0.60092009018055192, -0.10265418316164113, -0.39913639006279306, -0.17310908908773887, -0.0194191171632387, 0.054047965289179878, 0.1388529643463832, 0.15661099050145999, -0.10898263774416243, -0.33291231456737602, -0.59569027865888713, -0.69353081584948972, -1.0999707493347484, -0.74392084753736687, -0.49074781214158159, -0.065190556733852961, 0.012289768389229717, 0.024577513704595676, 0.0040302804696096322, 0.036047756292976456, 0.058236765637246286, 0.13893846256790621, 0.036944676036934632, 0.41686279554239464, -0.85232286388185818, -1.2988315127624981, -0.47352779677305168, -0.81763632541546793, -0.77384457803621831, -1.4256240004519281, 0.52588993532360684, -0.89821724022902683, 0.1591911967653899, -0.55046596772346867, -0.30980016041271019, -0.16709614007114884, -0.046029700131955266, 0.044793268150423983, 0.1689242242845459, 0.14412365934528507, -0.0088250071313367359, -0.36778545124666312, -0.79393844517732104, -1.1610479066529615, -0.76523210008850662, -0.63009858032048405, -0.13947023057344932, -0.017173105577524262, 0.039030007688455846, 0.014491273083805401, 0.039792542943837252, 0.054072846696920814, 0.11729310469925348, 0.053609281522667675, 0.0081549498718087084, -0.30910813452845548, 0.25944224899607843, -1.3584842180322938, -1.5885570490138659, -0.65759582794618221, -1.139869490652734, 0.70928264080594694, -1.9674198903133462, 0.37712664425406606, -0.84336038390578949, -0.47788074719428036, -0.18342000086663721, -0.18811394573901796, -0.055050027645985648, 0.045043056834335606, 0.11486303559854361, 0.22023958716404868, 0.14735402009444676, -0.27894427087197998, -0.73080536953129638, -0.76794305693297227, -0.37355919765840223, 0.12353986794322802, 0.090505348376311842, 0.14069908672094206, 0.087373214380278855, 0.023353946735568523, 0.031400559920396587, 0.079550230446202241, 0.084927161382185437, 0.040777158255349423, -0.16274954314482293, -0.41184413435479567, -0.71871288822574875, 0.55302907456342854, -1.5309493464500674, -2.9026104205694736, 0.42043303599508353, -1.7138106264793671, 0.29513888249127102, -1.2517216433630918, -0.66769942176516839, -0.28576739334390183, -0.24127777006787937, -0.10778095858902549, -0.036092425009198861, 0.021519213385077923, 0.13414694961717147, 0.16917378957839613, 0.17307922682581758, 0.076246758829015673, -0.047904835134272621, -0.27544262702406924, 0.61826249566563185, 0.26987423123693399, 0.2085883517320696, 0.26073426210721973, 0.12070625812911842, 0.062945582093309679, 0.083649573916505432, 0.049688095345785867, 0.019564357607843069, -0.046035817476596949, -0.13409074070830324, -0.49027201814294552, -0.47756457321420159, -0.74403675135427549, -0.3080068432033089, -0.043712438842705037, -4.735594317158907, -0.043712438842706695, -0.30800684320330962, -0.74403675135427572, -0.47756457321420304, -0.49027201814294813, -0.13409074070830412, -0.046035817476598156, 0.019564357607843069, 0.049688095345786006, 0.083649573916506056, 0.062945582093310845, 0.12070625812911921, 0.26073426210722073, 0.20858835173207019, 0.26987423123693399, -0.37355919765836759, -0.27544262702403433, -0.047904835134273127, 0.076246758829012523, 0.17307922682581853, 0.16917378957839499, 0.13414694961716844, 0.02151921338507657, -0.036092425009199861, -0.1077809585890261, -0.24127777006787943, -0.2857673933439015, -0.66769942176516905, -1.2517216433630949, 0.29513888249127429, -1.7138106264793713, 0.42043303599507681, -2.902610420569474, -1.5309493464500692, 0.55302907456342232, -0.71871288822575019, -0.41184413435479833, -0.16274954314482265, 0.04077715825534866, 0.08492716138218645, 0.079550230446203143, 0.031400559920398419, 0.023353946735571576, 0.08737321438028138, 0.14069908672095732, 0.090505348376334033, 0.1235398679432393, -0.76523210008847808, -0.76794305693296139, -0.73080536953128505, -0.27894427087197604, 0.1473540200944477, 0.22023958716404682, 0.11486303559854165, 0.045043056834333829, -0.055050027645986453, -0.18811394573901843, -0.18342000086663854, -0.47788074719428042, -0.84336038390579149, 0.37712664425406617, -1.9674198903133469, 0.70928264080593695, -1.1398694906527307, -0.65759582794619398, -1.588557049013867, -1.3584842180322987, 0.25944224899607732, -0.30910813452845781, 0.0081549498718086911, 0.053609281522667279, 0.11729310469925426, 0.054072846696921202, 0.039792542943838709, 0.014491273083807311, 0.039030007688458185, -0.017173105577517028, -0.13947023057343994, -0.63009858032045107, -1.0999707493347308, -1.1610479066529467, -0.79393844517731305, -0.3677854512466584, -0.0088250071313340107, 0.14412365934528559, 0.16892422428454401, 0.044793268150420118, -0.046029700131956147, -0.16709614007115095, -0.30980016041271097, -0.55046596772347045, 0.15919119676539073, -0.8982172402290286, 0.52588993532360329, -1.4256240004519327, -0.77384457803621687, -0.8176363254154656, -0.47352779677305679, -1.2988315127625027, -0.85232286388185829, 0.41686279554239525, 0.036944676036935756, 0.13893846256790574, 0.058236765637246675, 0.036047756292977066, 0.0040302804696111128, 0.02457751370459911, 0.012289768389232913, -0.065190556733844662, -0.49074781214156804, -0.74392084753735632, -0.62902925014412903, -0.69353081584948562, -0.59569027865888302, -0.33291231456737491, -0.10898263774416028, 0.15661099050145985, 0.13885296434638142, 0.054047965289177706, -0.019419117163239467, -0.17310908908773912, -0.39913639006279433, -0.10265418316163986, -0.60092009018055315, 0.48173198285915786, -0.98026015008952594, -0.63659778359422126, -0.9527791435273002, -0.78599914414892458, -1.190608374889349, -0.095380647808570002, -0.42379280974334488, -0.25909871392159683, 0.37260817254533357, 0.09030854179921953, 0.050921170848348372, -0.011346909674079158, 0.0035268087894081549, 0.014769425415168456, 0.022494427132082863, -0.22157638610464575, -0.37258895173129003, -0.5716641197488066, -0.37510275237622537, -0.35559738025257059, -0.27295314658024672, -0.22492530005262792, 0.0036582478916564426, 0.091608208912696387, 0.090648151782514966, 0.060764771353224882, -0.048474806721595647, -0.18992437505973167, -0.12025629051789351, -0.53909912073488875, 0.20227228344720258, -0.39470955087317799, -0.28479724025368247, -0.44532127384387832, -0.69512591788493272, -1.04586329377066, -0.48167134330805861, -0.62646382819099156, 0.25165135427361029, 0.0017746672356018336, -0.0153217875544032, 0.14348925152561842, -0.01406273903701487, 0.0073990345210243587, -0.0061780445152985596, 0.04134784037419488, -0.050428686591041855, -0.1412765230349349, -0.2446013156753272, -0.26472923111076024, -0.11925518789339257, -0.13993873549610955, -0.21657212936163839, -0.1270560226842922, -0.11318909242737903, 0.025411878261882927, 0.082440536547530169, 0.015634174038688685, -0.073253161755715501, -0.086274914781661965, -0.326199549934509, -0.0095667980850238903, -0.28693665642627003, -0.16474199810952764, -0.099230097260324029, -0.41886712861154318, -0.53891285075962314, -0.38784811281629461, -0.53055029095956219, -0.062959699002866631, -0.24994913291425488, 0.1965944737588636, 0.013297880203252755, -0.054862661367901897, 0.036937609226056677, -0.0061104340245862225, 0.030710887069788338, -0.005026615310052167, -0.040546729108393256, -0.15567029136725916, -0.21025892926356554, -0.24869348141289621, -0.23151163972117689, -0.28209018858284918, -0.21000923681193823, -0.26967580750352416, -0.20600990120705304, 0.037511290653099091, 0.029087127940549885, -0.02130724566008323, -0.029753598134642099, -0.19525258909505444, -0.091447566716882075, -0.21569610281495041, -0.089512936152075853, -0.010933041190555782, -0.17178084419175305, -0.41025595439938806, -0.19294368007162768, -0.39082994830036216, -0.19223333969456258, -0.21043659051868269, 0.085569925396567076, -0.11248917625543933, 0.063048845258374231, -0.0019970761454456269, -0.038651839330752197, 0.047371310076345617, -0.012631210076786959, 0.034596483191142599, -0.13898866968588444, -0.26165852514053983, -0.33704349161769737, -0.22295096919948695, -0.57723811773534028, -0.52753621424018138, -0.57340991730807944, -0.53542516436999865, -0.38594205494114614, -0.1837522251545064, -0.11760486834511884, 0.049598910651293758, -0.15016133237735926, -0.07968612236224891, -0.1902424828882312, -0.14205665196423831, -0.020936168457862579, -0.00075904203100844866, -0.14361316535317845, -0.2274598028382093, -0.26521664175359499, -0.24432996418012529, -0.12424052925006639, -0.0034600735070760831, -0.09139631658683596, 0.029161890169972428, -0.063371767399980516, 0.042038311258955005, -0.01022881748368659, -0.067715134483221959, 0.082808930467383746, -0.047213249757837236, -0.3019729958748239, -0.55320252101738743, -0.548133112044219, -0.63187735896388053, -0.95504179549950285, -1.060769216424599, -1.1220351967386673, -1.0411254782363524, -0.92624906744916458, -0.62449818579949246, -0.045097357284792555, -0.21565853836744897, -0.053382326365811708, -0.19859450279267432, -0.16546730532911214, -0.14182240789720132, -0.07166143303897729, -0.076999891872253062, -0.038788452621649434, -0.2650928994872585, -0.20555329767005678, -0.25968674675684078, -0.10031131456276626, -0.13387544724730568, -0.0035054269587865765, -0.040449089662379971, 0.0048626364920241281, -0.078110822445325467, 0.0012357796666695618, -0.039627851124306598, -0.19419044456729473, 0.018984383649339364, -0.60548232361397991, -0.91465668941264988, -1.0460191987834631, -0.97237526162739263, -1.3057076652991049, -1.4659201063979992, -1.5705638815427927, -1.6192427030685486, -1.6058616381755215, -0.82403680021595249, -0.70367959806681868, -0.073397497542269388, -0.33356498933276529, -0.23651154356493967, -0.2042833730780847, -0.17397285212300875, -0.067238206950403417, -0.056997285203952995, -0.070874531394526111, -0.25039909487805306, -0.37417116097079761, -0.20400167508805389, -0.34221561581755761, -0.036938315661763657, -0.042171356658337315, 0.0070571894653653896, -0.075717498698634964, -0.066965686484977194, -0.25408021803022474, -0.043349004411301621, 0.025934598230977574, -0.29423824173210122, -0.74003518668370272, -1.6161992336951192, -1.5357935460809593, -1.3642007878216427, -1.5169157844507262, -1.4332006785118279, -1.6301578422923491, -1.932677889629856, -1.8694842425148879, -1.8503084663080056, -0.59040483751417916, -0.65601747033471336, -0.40132058236311047, -0.31836783196552787, -0.32035624605031593, -0.22965854401457814, -0.082000200083028219, -0.089025163302698024, -0.064732391018913552, -0.30366967948051288, -0.4730230160625184, -0.37970560392275871, -0.19430407325814622, -0.1797093251603995, -0.063069709957271444, -0.10088329756370083, -0.097060879184794432, -0.18018565146479387, -0.19830827357221226, -0.43479836723774673, 0.22038139379151372, -0.26457398838911428, -1.79452817569422, -2.2062031109308391, -2.102356658927595, -1.6930052820597257, -1.2756392437278008, -1.6712324532934884, -1.8237453905245253, -1.4884613952536252, -2.384654945418673, -1.5836466114968115, -1.4772075422260404, -0.74950958881152596, -0.561795414852579, -0.46670603976586306, -0.35555823460889052, -0.22514761090777982, -0.18963405157839525, -0.0068547033925124142, -0.051036689850529192, -0.53565359443295624, -0.48685989567066656, -0.57809021675862349, -0.39240983780018618, -0.11286619230167973, -0.12321821342876334, -0.089790022871127112, -0.13792125740417074, -0.16098142942852883, -0.30105748355308298, -0.18584599820379807, -0.75998936793718352, -0.8428129384777584, -2.1809972632688073, -2.8791053946930352, -2.5682454610054237, -2.0983496132652038, -2.219376425173226, -2.3602336858020396, -1.4129529949598048, -0.95341593939478875, -0.38769722219534936, -2.2603422126144772, -1.394644866167148, -0.77664281720103345, -0.64028425429629032, -0.41856090178724664, -0.3216120132349809, -0.33607304327303461, 0.065628582466230781, -0.098136330355478765, -0.44979914971695495, -0.82222257402878096, -0.39156143807433802, -0.36045886741397631, -0.29008721857562392, -0.035472107498135542, 0.027920290231535812, -0.117989151853845, -0.1892849156146684, -0.25489431004647656, -0.3625272253546275, -0.30143411016838906, -0.75242583405872021, -2.0271757806780628, -2.2639673745086539, -3.5383249085863659, -3.361597106712324, -2.3438802466919229, -1.7249706159518579, -1.7990472945779559, -3.3061472495599995, 0.21156442062862166, -0.74302378668934399, -1.8514918971041745, -0.82502198370632651, -0.74351999988260331, -0.39569215798819279, -0.3943138014933833, -0.29890408748686254, -0.28084584584372846, 0.01472791435408881, -0.04442075186168376, -0.53500016384583715, -0.90188577233528688, -0.69844971117515353, 0.14583567590324595, -0.5544445310046473, 0.1976534820339324, -0.18710828510427244, 0.0076800871037496377, -0.32808050503226982, -0.17511899827005836, -0.38519889843539723, -0.26116553014987143, -0.61792590829173255, -1.4260964500310052, -2.8480835086962002, -2.9656385065341997, -3.1259631743419583, -2.2776462897026373, -1.3820969331049018, -2.0505291279591713, -2.4084298023013879, -1.4996172161865962, 0.12372650763830863, -1.1981932989988076, -0.64588897407998824, -0.33546767337818667, -0.36301254306387043, -0.26196208085033179, -0.17675902360982099, 0.0055639281302357606, -0.034749316729180774, -0.44871907432473696, -0.67215259521100923, -0.46007833291523831, -0.67254330182605182, 0.11741827111366224, -0.409871486550618, -0.32892265898101625, -0.13145556961021479, -0.028899376452251727, -0.092298612924564649, -0.16672095020503341, -0.17646388464205828, -0.35131617290772521, -0.19150029104902661, -1.2217002325587201, -0.7866727441045076, -1.9807415717551959, -1.978633957921319, 0.069560471269209931], "bottom": {"real": [4103.3252596935745, 31959.928439656338, 10854.934870050551, 5174.7646941682715, 2670.3793024702013, 1512.8812431609856, 751.72119813508266, 487.34157279751093, 286.27976884850017, 202.21445228809756, 139.363320073941, 96.326676625874271, 67.416513392704019, 55.036039361563731, 42.617455049491909, 37.327841235406673, 35.198800209060273, 37.327841235406588, 42.617455049491802, 55.036039361563766, 67.416513392704019, 96.326676625874285, 139.36332007394108, 202.21445228809804, 286.27976884850017, 487.34157279751093, 751.72119813508289, 1512.8812431609856, 2670.3793024702018, 5174.7646941682751, 10854.934870050551, 31959.928439656363, 12454.694619943468, 7821.5833902765553, 5473.1790170642225, 2925.2286142376206, 1403.2127508507554, 917.05530556073552, 556.73350878905819, 335.58154911349368, 222.7562369115075, 161.71079893305554, 119.4497628246793, 75.609007514321249, 55.496087080936569, 43.998829489125107, 34.725029965122339, 29.983374804996487, 29.187336608781969, 30.714909872552553, 33.135728528562289, 38.780040560556557, 50.11926248444739, 62.426609296740132, 93.916765363567279, 123.96413175241418, 177.16967383039952, 250.50030243800805, 399.94920918463373, 596.1485322845399, 914.24633406931139, 1871.6210271277439, 4518.4223121248042, 13565.815861293135, 16084.742683461694, 10028.519769850123, 2736.2851033168113, 1377.4551350842332, 614.08174831750455, 382.39730464420114, 237.0105878631189, 156.24359018004319, 129.95938769710136, 95.53783206710068, 72.004092864891931, 47.804301653843083, 38.41781199466849, 32.452048622414502, 26.753427300507923, 23.772936248165699, 23.138404805980134, 23.598476471031617, 24.755859033283485, 28.713323989162731, 33.395537201677122, 40.850586549891439, 58.649881806718739, 74.872968711973769, 93.465129226367807, 123.19419955144703, 174.75706127058839, 262.71291650117263, 321.82068054258934, 657.05253635266399, 2163.5932265202309, 10212.960963472207, 3792.0213246064613, 2759.3366542985627, 1627.1011647050395, 788.44977202016776, 362.8509317865861, 253.90720770691448, 163.04342130809295, 117.95146004773997, 90.766106703902594, 66.207745096840526, 48.204553381452804, 35.429206551568903, 28.049881805648454, 23.25027473117818, 20.778936642061399, 19.004228801577, 17.585642163629327, 17.698181326434501, 18.806836162280465, 20.329571180523736, 23.456998427374465, 27.472702254518477, 37.193120035742723, 49.117252584083957, 59.574829012615233, 73.59994664128709, 112.97176733843995, 181.91972084309376, 284.0343016488693, 486.29648203694052, 857.05287855361007, 2037.977143592303, 2057.7285052573056, 2152.5952706253152, 1395.1090523951752, 736.25297680000074, 343.98700964912916, 189.68478304615005, 127.37774106216496, 91.12789293157843, 73.667255133763959, 55.964360327653644, 39.482567042532949, 28.14219415335706, 21.278934963706885, 18.193385040510105, 16.473354788100497, 15.086583853495943, 14.403945056404867, 14.533202056236952, 15.306988390608382, 16.092687824041843, 18.097466979870337, 20.289280537832838, 26.201109009342694, 34.023571220637564, 41.620492531599325, 50.685682074964014, 82.560701981631325, 127.19888958323958, 237.89761616945128, 410.06312322518994, 1062.2303232610248, 1612.0404058137353, 2295.1409914972487, 1787.3905923922546, 1192.2295048012345, 614.24882525880628, 260.82616895243024, 126.23242010647614, 84.151076288810984, 67.709414992782712, 60.122571559472298, 42.830591238304876, 28.733103940874788, 20.365121706656215, 16.211112474155353, 14.072758594539286, 13.483685068827034, 12.859628868618824, 11.868475605254234, 11.903201306554562, 12.816996745648828, 13.065794209061782, 14.312459824747068, 16.296926608708432, 20.657711991677495, 27.653390070235432, 33.593110413967857, 40.672720076575544, 55.856624618502167, 103.16047843117397, 179.23484372919035, 453.7513605151255, 902.26285048256875, 1683.7179352249004, 1784.083505146898, 1577.4265763170067, 936.66309122894188, 441.20892337587179, 176.43359667751182, 98.093971741535682, 65.995944695036641, 53.240295707495449, 45.85166507919449, 32.407485359783081, 22.496202298890402, 16.965613714417799, 13.731573445856062, 12.28236966845588, 11.747735381447885, 11.213125876643861, 10.807806034266576, 10.840341477375139, 11.066245600125107, 11.119452781179984, 12.424913044930788, 14.610027556462221, 16.887227742677396, 22.29462391228396, 27.978157381323118, 31.991250392971789, 44.052658881876532, 76.109568327798371, 159.13944268405785, 318.39207128278571, 686.00323178071869, 1336.6568589814267, 1043.0649603599104, 984.78746182807288, 618.0395600950327, 289.32426118556657, 132.98214831862998, 71.520048430881175, 52.57629039600819, 41.525598741467476, 33.633912722813989, 27.031255662449681, 19.489513580793098, 14.812681614273632, 12.21137274400836, 10.893625186679536, 10.482989068673637, 10.105487112246305, 9.7116899243817354, 9.9488069804828818, 10.161347795217756, 10.513274350469635, 11.294150924355744, 12.914730156139361, 14.478861048855546, 19.021661277112585, 23.907610167423496, 27.23573455134931, 38.742976413983023, 62.869223125902629, 111.92503010834605, 213.21062569137553, 433.61330953226366, 726.70269845820769, 562.21861410525219, 539.290746631297, 362.9446461846826, 211.46669660189423, 107.79772661917396, 60.676668375567573, 41.743276533116536, 34.42369696468284, 31.26708433258414, 25.313030406949355, 18.452791878453507, 13.956644256748325, 11.043046695375654, 10.111101652499672, 9.4550360444473061, 9.2429593469396529, 8.9521911222399257, 9.2321124164010211, 9.1908041669169815, 9.5662827353227868, 10.506864865879585, 11.825879962774797, 13.52813582962821, 15.999059082232355, 19.794027285196304, 22.478845287715099, 32.163272384867753, 47.951984523863096, 81.309242866655126, 150.93744536633105, 263.84630525991662, 439.27951033199258, 309.78719189559973, 306.63257299287005, 244.19689848939953, 151.98869039704036, 91.330482004276163, 57.352753322013349, 38.709160706067429, 33.087086449001383, 29.826655436967027, 23.987725148031473, 16.89184234468231, 13.041947079601194, 10.535809562752126, 9.5359471621683909, 8.9374483496855426, 8.5672643122912326, 8.4572735895659434, 8.4602804400971099, 8.5543457526330293, 9.3823763336699937, 10.377230417708629, 11.799673812944503, 12.361176855966248, 14.786798351390814, 16.739331260686697, 20.590148031359199, 25.753571174908508, 38.382893067866803, 63.23013835373618, 105.62437218489313, 175.68359833526657, 256.05708017959813, 224.80770864957879, 228.96753655549054, 172.54966320095522, 116.26546821946491, 80.46990226978717, 53.844334876610212, 37.483534347728245, 31.075867215997253, 26.284110672635684, 20.645029038002825, 15.025930043703783, 11.738276392873866, 10.201438772469425, 8.8203445227279982, 8.4945509856995365, 8.1968728409344909, 8.1790777304419588, 7.908377156922052, 8.6785477295074038, 9.6473715156890378, 10.339435934253908, 10.728035799158873, 11.983620383388951, 13.687783504221503, 16.433795900162693, 18.309125668572698, 22.485075799802843, 31.764684376383052, 49.270779583367755, 77.729851956279916, 123.50059845139852, 179.77043479461938, 159.57955623939222, 154.53329869380329, 127.96891349444883, 91.96783661678981, 66.921744646417011, 48.818287955893446, 36.591061653526779, 27.834277069623926, 23.041902152181589, 18.358713894245302, 13.567338391039883, 11.281789781943191, 9.6038295455647198, 8.7333277563772516, 8.338123667351045, 7.8992088061869676, 7.7104322426775909, 7.9983869985641034, 8.5436438490902269, 9.4432158844800043, 9.7870344410918424, 10.423788563863184, 11.253535869282553, 13.327727562718719, 15.178485067808285, 17.337135682195893, 21.668177060872456, 29.324826866357235, 41.492753218636352, 60.042185621507166, 90.318134916215342, 130.8805255687621, 104.24612656823803, 108.8028525877362, 89.555745560157249, 69.785669575239666, 56.746590174428, 44.171218069814536, 32.39838941697333, 25.182252759236459, 21.610810960419155, 16.972539478480535, 13.238333358456819, 10.614964653675054, 9.3806927946307859, 8.7492814832421075, 8.135298996501481, 7.634398163782139, 7.4852869889479292, 7.8316993609624435, 8.3853957415274643, 9.2315742305614634, 9.8389441629514209, 10.386606043801919, 11.354519695989614, 13.10793814373473, 15.240615596988986, 17.58979203150065, 21.461767190818147, 26.661531554562984, 36.123337028978582, 50.320731869274383, 69.065609719997795, 87.442260857354199, 76.677643276575949, 72.689147636714068, 65.50785565022079, 58.297658406357961, 49.558598741148941, 39.192968104211104, 29.954333787314212, 23.9458863540046, 19.99476230299754, 16.735792774046942, 12.901585018586687, 10.289994503175569, 9.3977765822679924, 8.6704196287803228, 7.8828328381527575, 7.5341478839019471, 7.4312929200041102, 7.7985159766257679, 8.1869060912414078, 9.142118635191288, 9.830770779287306, 10.340589147553608, 11.281171263863113, 12.984935438318947, 15.107976469419242, 18.19770629294057, 20.668346478928893, 25.761496132514932, 32.251424266134499, 39.95295492008993, 51.369438078625848, 65.569299562662465, 55.468849468729523, 55.86542097352833, 55.101138782973663, 50.531848368674723, 43.701470536966781, 35.866381440857431, 28.439396618258566, 22.42863349391925, 18.945030358082761, 15.596977301337661, 12.206893729284205, 10.050508612628137, 9.5473939482322869, 8.6463276280830179, 7.910774588392556, 7.2755514089661562, 7.5482842032534565, 7.5443879419641391, 7.9636187803325598, 8.9922015447577355, 9.6351997849989068, 10.0402383165895, 11.706284711344862, 13.336194440398188, 15.639893484781382, 17.791763978880017, 20.83131115781941, 25.6818621728188, 31.387128642704546, 37.143166049555219, 44.038766386780296, 52.904506937405849, 48.059389050535145, 50.072432061388255, 49.115010315515249, 44.160423468831148, 38.440953181308423, 32.35840674752788, 26.251111011761232, 21.081922570464979, 17.515101530242855, 14.10261621013594, 11.438986216849498, 10.422223192105227, 9.76207732514108, 8.7746319169344158, 7.5939451837729885, 7.2605949806802883, 7.4766919496025244, 7.419064545103371, 8.0187357229163059, 8.9266344512172839, 9.6975643711848107, 10.35689464395745, 11.451859179394017, 13.10319606057651, 15.460942026724263, 18.825021564083144, 22.773162722002358, 26.906890973713775, 31.803276985208164, 37.82902190094245, 42.388788349798304, 44.620105679799558, 48.859277780953818, 46.136110292205181, 41.908361785717766, 39.521022744549988, 35.052294933716347, 29.181343166303421, 23.802472557875006, 19.955746539759069, 16.22743816874862, 13.086681034223906, 11.226909204888067, 10.616041272149978, 9.8385492842648201, 8.6563005846195669, 7.8952678290472065, 7.2762149925656852, 7.3094046208482961, 7.276214992565686, 7.8952678290472083, 8.656300584619574, 9.8385492842648219, 10.616041272149991, 11.226909204888063, 13.086681034223904, 16.22743816874862, 19.955746539759044, 23.802472557874989, 29.181343166303414, 35.052294933716361, 39.521022744549988, 41.908361785717766, 46.136110292205167, 48.059389050535053, 44.620105679799494, 42.388788349798226, 37.82902190094255, 31.803276985208186, 26.906890973713825, 22.773162722002368, 18.825021564083173, 15.460942026724263, 13.103196060576508, 11.451859179394024, 10.356894643957441, 9.6975643711848196, 8.9266344512172751, 8.0187357229163005, 7.4190645451033674, 7.4766919496025226, 7.2605949806802919, 7.5939451837729957, 8.7746319169344176, 9.7620773251410817, 10.42222319210523, 11.438986216849505, 14.102616210135931, 17.515101530242841, 21.081922570464972, 26.251111011761218, 32.358406747527845, 38.44095318130838, 44.160423468831063, 49.115010315515164, 50.072432061388007, 55.468849468729232, 52.90450693740565, 44.038766386780239, 37.143166049555234, 31.387128642704567, 25.681862172818796, 20.831311157819414, 17.79176397888002, 15.639893484781378, 13.336194440398192, 11.706284711344864, 10.040238316589498, 9.6351997849989122, 8.9922015447577301, 7.9636187803325527, 7.5443879419641293, 7.5482842032534556, 7.2755514089661553, 7.9107745883925578, 8.6463276280830215, 9.5473939482322869, 10.050508612628141, 12.206893729284213, 15.596977301337661, 18.945030358082761, 22.428633493919239, 28.439396618258566, 35.866381440857388, 43.70147053696676, 50.531848368674645, 55.101138782973628, 55.865420973528131, 76.677643276575822, 65.569299562662337, 51.369438078625784, 39.952954920090001, 32.251424266134514, 25.761496132514949, 20.668346478928903, 18.19770629294057, 15.107976469419244, 12.984935438318949, 11.28117126386311, 10.340589147553612, 9.8307707792872954, 9.1421186351912915, 8.1869060912414096, 7.7985159766257599, 7.4312929200041067, 7.5341478839019365, 7.882832838152761, 8.6704196287803175, 9.3977765822679942, 10.289994503175565, 12.901585018586699, 16.735792774046928, 19.99476230299755, 23.945886354004585, 29.954333787314209, 39.19296810421109, 49.55859874114887, 58.297658406357826, 65.507855650220662, 72.689147636713827, 104.24612656823788, 87.442260857354213, 69.065609719997752, 50.320731869274368, 36.123337028978554, 26.661531554563005, 21.461767190818144, 17.589792031500657, 15.24061559698899, 13.107938143734735, 11.354519695989618, 10.386606043801917, 9.8389441629514156, 9.2315742305614528, 8.3853957415274607, 7.8316993609624372, 7.4852869889479301, 7.6343981637821372, 8.1352989965014757, 8.7492814832421111, 9.3806927946307876, 10.614964653675061, 13.238333358456819, 16.972539478480542, 21.610810960419155, 25.182252759236462, 32.39838941697333, 44.171218069814465, 56.746590174427972, 69.785669575239609, 89.555745560157177, 108.80285258773613, 159.57955623939191, 130.8805255687619, 90.318134916215342, 60.042185621507201, 41.492753218636388, 29.32482686635726, 21.668177060872456, 17.3371356821959, 15.178485067808294, 13.327727562718726, 11.253535869282553, 10.423788563863175, 9.7870344410918424, 9.4432158844800025, 8.5436438490902233, 7.9983869985640963, 7.7104322426775891, 7.8992088061869596, 8.338123667351045, 8.7333277563772533, 9.6038295455647145, 11.281789781943189, 13.567338391039879, 18.358713894245295, 23.041902152181613, 27.834277069623926, 36.591061653526772, 48.818287955893382, 66.921744646416983, 91.967836616789555, 127.96891349444861, 154.53329869380323, 224.80770864957842, 179.77043479461912, 123.50059845139837, 77.729851956279958, 49.27077958336772, 31.764684376383045, 22.485075799802868, 18.309125668572733, 16.433795900162703, 13.6877835042215, 11.983620383388955, 10.72803579915886, 10.339435934253904, 9.6473715156890254, 8.6785477295073967, 7.9083771569220449, 8.1790777304419553, 8.1968728409344909, 8.4945509856995347, 8.8203445227279857, 10.201438772469423, 11.738276392873869, 15.02593004370379, 20.645029038002832, 26.284110672635681, 31.075867215997253, 37.483534347728245, 53.844334876610127, 80.46990226978717, 116.26546821946468, 172.54966320095502, 228.96753655548974, 309.78719189559854, 256.05708017959756, 175.68359833526623, 105.62437218489312, 63.230138353736059, 38.382893067866796, 25.753571174908501, 20.590148031359234, 16.739331260686704, 14.786798351390802, 12.361176855966249, 11.799673812944498, 10.377230417708628, 9.3823763336699955, 8.5543457526330204, 8.4602804400970992, 8.4572735895659417, 8.567264312291222, 8.9374483496855408, 9.5359471621683873, 10.535809562752121, 13.041947079601202, 16.891842344682331, 23.987725148031487, 29.826655436966995, 33.087086449001376, 38.709160706067401, 57.35275332201325, 91.33048200427605, 151.98869039703999, 244.19689848939879, 306.63257299286875, 562.21861410525219, 439.27951033199281, 263.84630525991662, 150.93744536633125, 81.309242866655154, 47.951984523863167, 32.163272384867753, 22.478845287715121, 19.794027285196304, 15.999059082232373, 13.528135829628219, 11.82587996277479, 10.50686486587958, 9.5662827353227868, 9.190804166916978, 9.2321124164010211, 8.9521911222399257, 9.2429593469396458, 9.4550360444473043, 10.111101652499666, 11.043046695375656, 13.956644256748326, 18.452791878453535, 25.313030406949409, 31.26708433258414, 34.423696964682833, 41.743276533116529, 60.676668375567509, 107.79772661917396, 211.46669660189391, 362.94464618468271, 539.29074663129688, 1043.064960359907, 726.70269845820621, 433.61330953226252, 213.21062569137561, 111.92503010834588, 62.869223125902685, 38.742976413983001, 27.235734551349324, 23.907610167423499, 19.021661277112635, 14.478861048855546, 12.91473015613936, 11.29415092435573, 10.513274350469626, 10.161347795217747, 9.9488069804828747, 9.7116899243817407, 10.105487112246305, 10.48298906867363, 10.893625186679529, 12.211372744008356, 14.812681614273641, 19.489513580793123, 27.031255662449723, 33.633912722813953, 41.52559874146754, 52.576290396008147, 71.520048430881019, 132.98214831862995, 289.32426118556515, 618.03956009503077, 984.7874618280689, 1784.0835051468939, 1336.6568589814267, 686.00323178071801, 318.39207128278593, 159.1394426840578, 76.109568327798428, 44.05265888187656, 31.991250392971853, 27.978157381323108, 22.294623912284028, 16.8872277426774, 14.610027556462216, 12.424913044930783, 11.119452781179971, 11.066245600125109, 10.840341477375128, 10.807806034266576, 11.213125876643852, 11.747735381447885, 12.282369668455885, 13.731573445856061, 16.965613714417831, 22.496202298890438, 32.407485359783124, 45.85166507919449, 53.24029570749542, 65.99594469503667, 98.093971741535469, 176.43359667751176, 441.208923375871, 936.66309122894131, 1577.4265763170022, 2295.1409914972464, 1683.7179352249, 902.26285048256875, 453.75136051512629, 179.23484372919026, 103.16047843117398, 55.856624618502074, 40.67272007657553, 33.59311041396785, 27.653390070235471, 20.65771199167747, 16.296926608708404, 14.312459824747059, 13.065794209061782, 12.816996745648842, 11.903201306554557, 11.868475605254236, 12.859628868618808, 13.483685068827036, 14.072758594539282, 16.21111247415536, 20.365121706656261, 28.733103940874788, 42.830591238304876, 60.122571559472277, 67.709414992782641, 84.151076288810941, 126.23242010647601, 260.82616895243001, 614.24882525880446, 1192.2295048012338, 1787.3905923922525, 2057.7285052573061, 1612.0404058137367, 1062.2303232610243, 410.06312322519068, 237.89761616945111, 127.19888958323968, 82.560701981631325, 50.685682074964042, 41.620492531599325, 34.023571220637599, 26.201109009342684, 20.289280537832823, 18.09746697987034, 16.092687824041846, 15.306988390608383, 14.533202056236956, 14.40394505640487, 15.086583853495929, 16.47335478810048, 18.193385040510101, 21.278934963706888, 28.142194153357082, 39.482567042533006, 55.964360327653644, 73.667255133763959, 91.127892931578486, 127.37774106216477, 189.68478304614982, 343.98700964912905, 736.25297679999983, 1395.1090523951759, 2152.5952706253147, 3792.0213246064582, 2037.977143592301, 857.05287855360893, 486.29648203694126, 284.03430164886925, 181.91972084309373, 112.97176733844, 73.599946641287119, 59.574829012615204, 49.117252584084042, 37.193120035742723, 27.472702254518456, 23.456998427374469, 20.329571180523697, 18.806836162280476, 17.698181326434526, 17.585642163629327, 19.004228801577025, 20.77893664206141, 23.250274731178163, 28.04988180564844, 35.429206551568925, 48.204553381452833, 66.207745096840512, 90.766106703902594, 117.95146004774013, 163.04342130809306, 253.90720770691391, 362.85093178658599, 788.44977202016594, 1627.1011647050398, 2759.3366542985605, 16084.742683461691, 10212.960963472211, 2163.5932265202296, 657.05253635266433, 321.82068054258923, 262.71291650117286, 174.75706127058845, 123.19419955144714, 93.465129226367836, 74.87296871197394, 58.649881806718732, 40.850586549891496, 33.395537201677108, 28.713323989162756, 24.755859033283489, 23.59847647103166, 23.138404805980127, 23.77293624816566, 26.753427300507926, 32.452048622414509, 38.417811994668497, 47.804301653843162, 72.004092864892002, 95.537832067100879, 129.95938769710136, 156.24359018004333, 237.01058786311899, 382.39730464420052, 614.08174831750478, 1377.4551350842296, 2736.2851033168104, 10028.51976985012, 12454.694619943462, 13565.815861293133, 4518.4223121248006, 1871.6210271277425, 914.24633406931184, 596.14853228454001, 399.94920918463339, 250.50030243800833, 177.16967383039946, 123.96413175241405, 93.91676536356745, 62.426609296740118, 50.119262484447404, 38.780040560556571, 33.135728528562332, 30.714909872552628, 29.187336608781973, 29.983374804996448, 34.725029965122346, 43.998829489125086, 55.496087080936618, 75.609007514321277, 119.44976282467937, 161.7107989330556, 222.75623691150756, 335.58154911349339, 556.73350878905831, 917.05530556073529, 1403.2127508507556, 2925.2286142376206, 5473.1790170642225, 7821.5833902765453], "imag": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0]}, "imag": [0.0, 1.2364045139795619, -1.417097645517349, -0.56399113050110405, 0.44612204752934542, -0.22857396866743723, -0.12233724123958876, -0.22175063370253431, -0.081847654478992143, -0.082144528420219798, -0.016319194688300422, -0.22782269816808789, -0.31553723757062957, -0.34627737582788948, 1.2289873494343531, 0.23714731979244019, 0.0, -0.23714731979246589, -1.2289873494343397, 0.34627737582788415, 0.31553723757063035, 0.2278226981680877, 0.01631919468830003, 0.082144528420217924, 0.081847654478992143, 0.22175063370252604, 0.12233724123959235, 0.22857396866743548, -0.4461220475293452, 0.56399113050110417, 1.4170976455173483, -1.2364045139795607, 1.3606412475160685, 1.4411916754234004, -0.33639737707180672, -0.40059289889731398, 0.077869450453742065, 0.11933000679564014, -0.37020072416606636, -0.12600631152419078, -0.29291723130603109, -0.050683391882318747, -0.2123566898458312, -0.16517843825664788, -0.37438920939802389, 0.24863698196016526, 0.3956337373323095, 0.63308466384569972, -0.42643957249522613, -0.28749903579454716, -0.42301568032975828, 0.27971623762695519, 0.37808744252168813, 0.15296582393741001, 0.10558339349178479, 0.088135922159038316, 0.16705843369252343, 0.44192642538865684, 0.29915225181421068, -0.047649837051313024, -0.91046045526812369, 2.0668504460046964, 1.0236217631956717, 0.095775027331123308, 0.74327388531916394, -0.034562131954570079, 0.86361123753821734, 0.14688086473050152, -0.48040960369964397, 0.72553155869356101, -0.87865322612555963, -0.4386512882244577, -0.48573187070285989, -0.32017932907631874, -0.2830749986604581, -0.26990648117356825, 0.02650526715020339, 0.070485969368273949, 0.54370981678608021, -0.067938463814195812, 0.03776680164210118, -0.5672727000472354, 0.70317235961628322, -0.021133356436660328, 0.38778419454697149, -0.021237638325898506, 0.22272564345822293, -0.028529610958430065, 0.38389116569218468, 0.54015192300945081, 0.60890484535134959, -0.58851980199844323, -0.44257995715790832, -0.31054780878465871, 0.29452233058397137, 1.4203730522981519, 0.55042973333868539, 1.0635980503754177, -0.33223282315731317, 0.34444399750770754, 1.4812987845914649, 0.28203486996779931, -0.50640814880924923, -0.63152717265524028, -0.629560147993244, -0.38143909917016799, -0.26024004494781861, -0.19111004712688462, -0.0074049384249937926, 0.048145781851611912, 0.1775395908501845, -0.010766872600667563, -0.30557543109041663, -0.12790446781789691, 0.26497067484017217, 0.49718432792560446, 0.10847923107858634, 0.18362798444374009, 0.075793328725680426, 0.060915837919074359, 0.19352569039908019, 0.72484131059467238, 0.44769863619371908, 0.65727781823869813, -2.7705947112358387, -1.8545676439466314, 1.2534804319442749, -0.33201271766592177, -0.88179245186152566, -0.49191197464707653, 0.25061306335904526, 0.36434278784189494, 1.1059306596340364, 0.5161851914994362, -0.56259342729123341, -0.79818525223670012, -0.50614275317411506, -0.33450192958610769, -0.24220392956380443, -0.29363217368931438, -0.008975674876931768, 0.015702042401798396, 0.0043287613096781611, 0.11769772351691517, 0.14847974776257877, -0.070404205425901215, 0.15992872157624444, 0.12352253662711207, 0.22950814490677918, 0.17507285276321555, 0.13747467644410705, -0.011397583876153142, 0.1103654239578318, 0.24404333943616102, 1.1434123865171273, -0.60566186502851971, -1.3365493166122577, -1.1338250057068979, -1.8155993788135394, -1.0591766157447149, -0.69010247253016843, -0.46612626705839738, -0.20353239335470796, 0.51663850122650623, 0.2659701357580968, -0.10657803670351902, -0.69730138646619577, -0.60106744735123385, -0.33542800506255299, -0.30564289179799509, -0.26672832014897818, -0.19552146385155383, -0.070818253229817343, 0.24716165183995586, 0.24871001073085031, 0.087906272749659523, -0.066392764898707615, 0.11463822183417864, -0.097387114548935505, 0.203187369929616, 0.14292038700683402, 0.20736891492564988, 0.013685307258532538, -0.024371827339033106, -0.07233585420108031, 0.49291782026044645, 0.048917424863979306, 0.2263553910474094, 0.10839909954530379, -1.1957108711898896, -1.074771579950879, -1.1175823884839045, -0.23901621577757862, -0.12877260884038383, 0.23623861798820722, 0.17111767858219226, 0.46208690546761177, -0.23679486634226876, -0.53178862418379869, -0.34021620386249335, -0.23658495591681358, -0.22275756609764855, -0.20572232603908905, -0.14494733127712761, 0.042569660785953992, 0.077733070765218709, 0.20558191361174552, 0.031719635617051253, -0.031869312918226284, 0.0092446671691655703, 0.056907964871031128, 0.0068114015565279478, 0.20608602740074444, 0.023033890597355222, 0.064944626021130644, -0.089711600875347838, 0.051877409795188095, -0.22207073062343796, 0.24248276916859771, 0.82932242402320455, -0.0013771249391571728, -0.059139017637367147, -0.22067925957890699, -0.040068334939789486, 0.30677005181582889, 0.34490255487274107, 0.22221882441368751, 0.30818729583490434, 0.041656273199714877, 0.04389672863559383, -0.30032839778423015, -0.24246246508902861, -0.17809969240648099, -0.14126159805998126, -0.15553553242798068, -0.11510723629505018, 0.024565620333015844, 0.099324973861333238, 0.11314958231531824, 0.10920785431914558, -0.0027478677647314949, -0.002197448124614016, -0.069940656171551499, 0.14656177726216579, 0.078770189361086429, 0.10241250352514093, -0.021646587213105684, 0.019211160710794505, -0.26281055993233693, -0.055146819140509458, 0.35375643597531126, 0.22411418130009836, 0.3875457037899096, 0.25423051056794166, 0.30581901500051717, 0.085911462662090085, 0.39107302489471046, 0.24699055160378858, 0.29387297238508514, 0.15373347718831995, -0.002984582508486469, -0.017260207971634491, 0.072827255227658205, -0.062089135258224848, -0.11929552297831249, -0.14454547803177953, -0.095268264507681985, -0.10089614648569632, 0.048761457544342565, 0.09609679137720413, 0.10529567915508571, 0.012037966893712556, 0.076343100588013288, -0.20546035926376272, 0.13459193297647368, 0.025732944443593878, 0.15693288111736364, 0.043761647973181578, 0.083479299629684353, -0.15251693996845875, -0.10657849804550705, 0.038641816351084518, -0.10231188547257405, 0.21957600785318707, 0.264774413728534, 0.35686545376814865, 0.29428485506006929, 0.49934135456989248, 0.18285689914378289, 0.23675610338446562, 0.10353827744151976, 0.063107949091445251, 0.03846587209017991, 0.13661717625997899, 0.098122755354854277, -0.0039906200934582137, -0.09009439550122221, -0.16647262366552176, -0.19237746196753996, 0.026647194061990561, 0.048509383863749068, 0.1654716680991411, -0.035914795239386038, 0.099273739290017232, -0.11264804489487676, 0.14792025966567318, -0.093791526140286519, 0.10021979561886898, 0.0080449729031339574, 0.25399382193861558, -0.10951630791791984, -0.033548122233328939, -0.024275040060575473, -0.15565555640319179, -0.035231426543991154, 0.063485173587351437, 0.22814734409189322, 0.10684932807789806, 0.2355554633425988, 0.10407564589066262, 0.015525256999673128, -0.011913601076877599, -0.0039295920043740662, 0.044701593559494178, 0.16547295203389104, 0.15907957720488838, 0.074664630781852093, -0.04243906497357175, -0.11246394245376416, -0.16972427151540079, -0.21530290856092721, -0.15195750501651711, 0.40553391670472716, -0.05507255324487554, 0.18488826926783164, -0.03502892748503212, 0.37001387119519319, -0.15325722566754377, 0.27168929694820759, -0.059701216280397838, 0.48380889084850937, -0.13017614472815323, 0.047673421329954523, 0.071305584258896423, -0.15733503034508964, -0.079593566039511662, -0.075485820780456944, 0.06620598245919887, -0.0012785498169557718, 0.063827392702187832, -0.0024400785561267094, 0.050942947866382475, -0.16777938781510365, -0.092876049496631446, -0.010378011540593757, 0.1594331602275639, 0.19523869399925237, 0.18464942262011227, 0.063285121982437173, -0.077221658551183223, -0.1491589460269398, -0.17912928670535297, -0.11490318286815507, -0.11189726101521234, -0.20487634390276235, 0.76498375921014561, -0.23800865420158882, 0.74083633586796371, -0.083846748018997191, 0.46372256496136105, -0.16834959597660981, 0.80860396068755125, -0.25555617026146216, 0.19463913189037535, 0.30097794980879877, -0.16302064990391507, -0.10690976611351247, -0.13497815095121923, -0.049772201284698683, -0.079451894223961053, 0.040407604161455342, -0.09194915079908203, -0.14731166465811507, -0.26499922119954511, -0.15560186997026057, -0.069496867327866862, 0.16530147427910571, 0.22324548858793775, 0.26718136730575287, 0.19166419512490171, 0.060936923017668537, -0.088626234734120041, -0.14658150061325853, -0.15988330961851069, -0.18630425886720847, 0.20226767939927157, -0.086142375874942501, -0.77766311308853053, 1.4090153420038987, -0.3038886842868152, 1.2888777036518135, -0.074470758177722834, 1.2482190395029773, -0.80123249840125998, 0.47055407026248136, 0.75577199845745624, -0.11037652666672627, -0.054458369263067428, -0.19918107544886771, -0.10899116252888987, -0.15332031366957818, 0.043654486348545761, -0.022154991408309264, -0.15239448898889341, -0.19372066727324463, -0.023769000914279543, 0.24457812931884867, 0.51722906014629877, 0.4305115414461968, 0.4535547011943914, 0.3493581281435395, 0.21076698450898321, 0.063956239140020049, -0.043266091906771414, -0.12307402164456596, -0.17588597679362872, -0.057160335632577657, -0.0784239564694168, 0.14377922602722487, -0.28610637890062873, -1.3867297053543113, 2.7076021550256568, -0.12637740826622818, 2.0046873376560574, -1.442367549533677, 0.41516901914168741, 1.1637625900709285, 0.02187980097289477, 0.2119473473283329, -0.11885489129254229, -0.1159981397382039, -0.18899269201836941, -0.058557612447368006, -0.043992442353640485, -0.026879139952720663, -0.019298206516241499, 0.11425895652801879, -0.10204731321609413, 1.0976378910336273, 0.78083298172023552, 0.7892686156410853, 0.65585934200294294, 0.41963945036689065, 0.21495377802894691, 0.10907743849349204, -0.015003791740152183, -0.098108352324783196, -0.099983461914768382, -0.14074054993981988, -0.049222223079134708, -0.60225632344115432, 0.14822551318702831, -0.20779420774376042, -2.0348285284263787, 4.0251861194251459, -2.7420491756647705, 0.80731183784095106, 1.5256751899261984, -0.015777910213839702, 0.56481061463658855, 0.094745090670160736, 0.032305441115857418, -0.15496296066268442, -0.070898922964745509, -0.15185446167165811, -0.099013378837322308, -0.033839198092832617, 0.20170996830425536, 0.31395340400286426, 0.91804938453195506, 0.90837480132247328, 1.1212514777242175, 0.8111537128593137, 0.65461252772518352, 0.44812018281017851, 0.29338133862249183, 0.080942506543726575, -0.0048876135806632161, -0.042045437831147933, -0.048279129686226115, -0.13748504879992385, -0.22867414001479172, -0.65206021382919555, -1.4414816884582773, 0.34900156189272369, 1.2663064061664397, -4.4519069438082273, 2.3981175155339263, 2.0366543361516527, -0.11574419894478603, 0.9938253915317542, 0.40253059498542132, 0.29787521235777348, -0.048128801274628118, 0.001834095689180732, -0.063578064856638958, -0.14911097873279969, -0.17638384543546787, -0.15061392115741762, -0.13638564133647435, 0.3292785127452974, 0.45646012748955422, 0.0, -0.098380202448484569, 0.2889284460821786, 0.39981384774007012, 0.45036129401449043, 0.22152969012775114, 0.11073273247786891, 0.024117745722163984, -0.0050280129542534689, -0.087106960572679512, -0.083653448195472838, -0.51521426958714545, -0.86124262209127589, -0.78939851130304506, -0.74423225935393889, -1.1208061672534484, 0.0, 1.1208061672534437, 0.74423225935393811, 0.78939851130304262, 0.86124262209127656, 0.51521426958714389, 0.083653448195472491, 0.087106960572679332, 0.0050280129542534689, -0.02411774572216354, -0.11073273247786865, -0.22152969012775126, -0.45036129401449054, -0.39981384774006945, -0.28892844608217838, 0.098380202448484236, -0.90837480132241455, -0.45646012748952708, -0.32927851274525655, 0.13638564133649642, 0.15061392115742586, 0.17638384543547556, 0.14911097873280194, 0.063578064856639402, -0.0018340956891807838, 0.048128801274627743, -0.29787521235777292, -0.40253059498541977, -0.99382539153175098, 0.11574419894478773, -2.0366543361516536, -2.3981175155339201, 4.4519069438082379, -1.2663064061664346, -0.34900156189272086, 1.4414816884582851, 0.65206021382919577, 0.22867414001479336, 0.13748504879992438, 0.048279129686228148, 0.042045437831148495, 0.0048876135806649092, -0.08094250654372509, -0.29338133862248678, -0.44812018281017507, -0.6546125277251672, -0.81115371285928006, -1.1212514777241573, -1.0976378910335893, -0.91804938453192131, -0.31395340400284805, -0.20170996830424559, 0.033839198092839695, 0.09901337883732686, 0.1518544616716597, 0.070898922964745925, 0.15496296066268506, -0.032305441115858605, -0.09474509067015939, -0.56481061463658966, 0.01577791021384034, -1.5256751899262007, -0.80731183784094906, 2.7420491756647789, -4.0251861194251397, 2.0348285284263898, 0.20779420774376556, -0.14822551318702654, 0.60225632344115643, 0.049222223079135728, 0.14074054993982205, 0.099983461914770352, 0.098108352324783543, 0.015003791740153814, -0.10907743849349157, -0.21495377802894516, -0.41963945036688871, -0.65585934200294016, -0.78926861564106898, -0.78083298172020743, -0.24457812931883488, 0.10204731321609872, -0.11425895652800651, 0.019298206516249916, 0.026879139952725083, 0.04399244235364598, 0.058557612447370934, 0.18899269201837068, 0.11599813973820411, 0.11885489129254237, -0.21194734732833254, -0.021879800972893531, -1.1637625900709312, -0.4151690191416833, 1.4423675495336772, -2.0046873376560503, 0.12637740826623128, -2.7076021550256497, 1.3867297053543175, 0.28610637890063351, -0.14377922602722601, 0.078423956469422018, 0.057160335632579121, 0.1758859767936318, 0.12307402164456618, 0.043266091906772712, -0.063956239140019508, -0.21076698450897985, -0.34935812814353639, -0.45355470119438479, -0.43051154144618958, -0.51722906014628944, 0.15560186997025938, 0.02376900091427863, 0.1937206672732435, 0.15239448898889424, 0.022154991408310377, -0.043654486348542874, 0.15332031366958024, 0.10899116252889095, 0.19918107544886771, 0.054458369263066984, 0.11037652666672665, -0.75577199845745313, -0.47055407026248092, 0.80123249840126409, -1.2482190395029769, 0.074470758177730939, -1.2888777036518133, 0.30388868428682408, -1.4090153420038936, 0.77766311308853486, 0.086142375874943722, -0.20226767939927121, 0.18630425886721039, 0.15988330961851227, 0.14658150061325848, 0.088626234734120221, -0.060936923017667906, -0.19166419512490052, -0.26718136730575015, -0.22324548858793625, -0.16530147427910316, 0.069496867327866751, 0.16777938781510615, 0.26499922119954472, 0.14731166465811715, 0.091949150799082904, -0.040407604161453857, 0.07945189422396387, 0.049772201284700876, 0.13497815095122018, 0.10690976611351256, 0.16302064990391416, -0.30097794980879811, -0.19463913189037552, 0.25555617026146371, -0.80860396068754914, 0.16834959597661264, -0.46372256496135666, 0.083846748018996636, -0.7408363358679616, 0.23800865420159104, -0.76498375921014483, 0.20487634390276502, 0.11189726101521356, 0.11490318286815554, 0.17912928670535491, 0.14915894602693922, 0.077221658551183403, -0.063285121982436826, -0.18464942262010964, -0.19523869399925042, -0.15943316022756263, 0.01037801154059478, 0.09287604949663382, -0.015525256999667727, -0.050942947866376924, 0.0024400785561280833, -0.06382739270218761, 0.0012785498169549515, -0.066205982459197621, 0.075485820780458165, 0.079593566039511995, 0.1573350303450895, -0.071305584258897034, -0.047673421329955501, 0.13017614472815361, -0.48380889084851014, 0.05970121628039872, -0.27168929694820493, 0.1532572256675474, -0.37001387119519286, 0.035028927485033709, -0.18488826926782947, 0.055072553244877351, -0.40553391670472771, 0.15195750501651886, 0.21530290856092779, 0.16972427151540051, 0.11246394245376394, 0.042439064973571687, -0.07466463078185144, -0.159079577204887, -0.16547295203388937, -0.044701593559494109, 0.0039295920043746378, 0.011913601076878649, -0.18285689914377989, -0.10407564589066134, -0.23555546334259525, -0.10684932807789757, -0.22814734409189458, -0.063485173587349258, 0.035231426543992535, 0.15565555640319106, 0.02427504006057549, 0.033548122233326282, 0.10951630791791925, -0.25399382193861758, -0.0080449729031340841, -0.10021979561886678, 0.093791526140288961, -0.14792025966567243, 0.11264804489487593, -0.099273739290014568, 0.035914795239387988, -0.16547166809914049, -0.048509383863747611, -0.02664719406199113, 0.19237746196754099, 0.16647262366552154, 0.090094395501221572, 0.0039906200934596249, -0.098122755354853444, -0.1366171762599761, -0.038465872090180271, -0.063107949091446403, -0.10353827744152141, -0.2367561033844639, -0.39107302489471046, -0.4993413545698927, -0.29428485506006952, -0.35686545376814893, -0.26477441372853422, -0.21957600785318782, 0.10231188547257429, -0.038641816351083894, 0.10657849804550705, 0.15251693996845886, -0.083479299629685352, -0.043761647973181945, -0.1569328811173635, -0.025732944443590922, -0.13459193297646968, 0.2054603592637699, -0.076343100588013288, -0.012037966893705314, -0.10529567915508307, -0.096096791377201118, -0.048761457544342024, 0.10089614648569795, 0.095268264507682401, 0.14454547803178003, 0.11929552297831249, 0.062089135258225896, -0.072827255227657164, 0.017260207971635976, 0.0029845825084865137, -0.15373347718831978, -0.29387297238508514, -0.24699055160378858, -0.30677005181583211, -0.085911462662095636, -0.30581901500051922, -0.25423051056794305, -0.38754570378991321, -0.22411418130009808, -0.35375643597530843, 0.055146819140510416, 0.26281055993233621, -0.019211160710796572, 0.021646587213104713, -0.10241250352514171, -0.078770189361086179, -0.14656177726216213, 0.06994065617155748, 0.0021974481246246629, 0.002747867764730379, -0.10920785431913549, -0.11314958231531393, -0.099324973861329505, -0.024565620333014605, 0.11510723629505158, 0.15553553242798132, 0.1412615980599799, 0.1780996924064803, 0.24246246508902825, 0.30032839778422799, -0.043896728635589223, -0.041656273199716369, -0.30818729583490695, -0.22221882441369153, -0.34490255487274391, 0.23901621577757753, 0.040068334939789153, 0.22067925957890494, 0.059139017637366363, 0.0013771249391555669, -0.82932242402320322, -0.24248276916859551, 0.2220707306234446, -0.05187740979518813, 0.089711600875348782, -0.064944626021130755, -0.023033890597353883, -0.20608602740074317, -0.0068114015565181726, -0.056907964871020393, -0.0092446671691440163, 0.031869312918224861, -0.031719635617030659, -0.20558191361174011, -0.077733070765210868, -0.042569660785952056, 0.14494733127713064, 0.20572232603908944, 0.22275756609764749, 0.23658495591681294, 0.34021620386249518, 0.53178862418379935, 0.23679486634227159, -0.4620869054676115, -0.17111767858219507, -0.23623861798820922, 0.12877260884038208, 0.69010247253016699, 1.1175823884838996, 1.0747715799508781, 1.1957108711898863, -0.10839909954530788, -0.2263553910474054, -0.048917424863973949, -0.49291782026044056, 0.072335854201080588, 0.024371827339035017, -0.013685307258532536, -0.20736891492564691, -0.14292038700683141, -0.20318736992960118, 0.09738711454895084, -0.11463822183415182, 0.066392764898706338, -0.087906272749638886, -0.24871001073084317, -0.24716165183994784, 0.070818253229819925, 0.19552146385155544, 0.2667283201489779, 0.30564289179799059, 0.3354280050625516, 0.60106744735122974, 0.69730138646619622, 0.10657803670352221, -0.26597013575809814, -0.51663850122651156, 0.20353239335470413, 0.46612626705839527, 0.88179245186152555, 1.0591766157447142, 1.8155993788135401, 1.1338250057069015, 1.3365493166122591, 0.60566186502852537, -1.1434123865171271, -0.24404333943615408, -0.11036542395783162, 0.011397583876152599, -0.13747467644410641, -0.17507285276321236, -0.22950814490677501, -0.12352253662709391, -0.15992872157622667, 0.070404205425931329, -0.14847974776257952, -0.11769772351689584, -0.0043287613096706385, -0.01570204240179094, 0.0089756748769360926, 0.29363217368931571, 0.24220392956380496, 0.33450192958610414, 0.50614275317411517, 0.79818525223669812, 0.56259342729123207, -0.51618519149943443, -1.105930659634037, -0.36434278784189805, -0.25061306335904537, 0.49191197464707476, -0.55042973333868328, 0.33201271766592266, -1.2534804319442674, 1.8545676439466376, 2.7705947112358396, -0.65727781823869658, -0.44769863619371453, -0.72484131059467105, -0.19352569039907921, -0.06091583791907576, -0.075793328725683354, -0.18362798444373865, -0.10847923107858076, -0.4971843279255892, -0.26497067484015147, 0.12790446781792791, 0.30557543109041591, 0.010766872600696822, -0.17753959085018053, -0.04814578185160058, 0.007404938424997059, 0.19111004712688809, 0.26024004494781799, 0.38143909917016594, 0.62956014799324345, 0.63152717265524094, 0.50640814880924734, -0.28203486996779953, -1.481298784591466, -0.34444399750770943, 0.33223282315731145, -1.0635980503754157, -0.74327388531916416, -1.4203730522981521, -0.29452233058397176, 0.31054780878465887, 0.4425799571579111, 0.58851980199844711, -0.60890484535134703, -0.54015192300944392, -0.38389116569218451, 0.02852961095842791, -0.22272564345822352, 0.021237638325899852, -0.387784194546968, 0.021133356436687064, -0.70317235961626101, 0.56727270004732033, -0.037766801642101375, 0.06793846381428098, -0.54370981678606445, -0.070485969368251203, -0.02650526715020184, 0.26990648117357596, 0.2830749986604576, 0.32017932907632218, 0.48573187070286, 0.4386512882244713, 0.87865322612556163, -0.72553155869355623, 0.48040960369964236, -0.14688086473049994, -0.86361123753821778, 0.034562131954569586, -1.3606412475160699, -0.095775027331125598, -1.0236217631956728, -2.0668504460046977, 0.91046045526812469, 0.047649837051312177, -0.29915225181420874, -0.44192642538866073, -0.16705843369252318, -0.088135922159037081, -0.1055833934917848, -0.15296582393740679, -0.37808744252168625, -0.27971623762694292, 0.42301568032977793, 0.28749903579456393, 0.42643957249522774, -0.63308466384561635, -0.39563373733228846, -0.2486369819601503, 0.37438920939802361, 0.1651784382566546, 0.21235668984583117, 0.050683391882319691, 0.2929172313060312, 0.12600631152419559, 0.37020072416606892, -0.11933000679563836, -0.077869450453742661, 0.40059289889731342, 0.33639737707180556, -1.4411916754233998], "height": 32, "width": 32, "top": {"real": [6327.0074679827858, 12787.448651417644, -8580.1357782693794, -6564.4296251926053, 1064.8969915597925, -1614.7722808334524, -60.048119421842308, -221.12968025641604, -12.445754708845573, -62.940587713583341, 23.820578453457951, -28.525301748952867, 37.864280125154337, -85.844490405627994, 27.493814969643068, -48.151974443362732, 41.399660199307142, -48.151974443360345, 27.493814969642067, -85.844490405627866, 37.864280125154032, -28.525301748952689, 23.820578453458509, -62.940587713584037, -12.445754708845573, -221.12968025641445, -60.048119421842806, -1614.7722808334493, 1064.8969915597932, -6564.4296251926125, -8580.1357782693849, 12787.448651417659, -17213.595236981997, 544.07302669902936, -10829.417860945707, -5794.1219231083051, -1103.8692252742003, -1120.3666800727638, -106.61462896985108, -117.89522553300084, -39.308430893651213, -26.960578056534288, -11.025047422886351, -2.1850531713376355, -7.2952697383625882, -14.472211987615461, -14.23279965231924, 3.5205960317557246, -19.629747734378611, -14.131264529804582, -22.272265924680642, -17.401343902608428, -1.7416101263052008, 0.34733716754184635, -16.60063574625633, -32.47390190466588, -64.31481385096977, -84.034753639409303, -258.32278440436392, -714.30117659130417, 113.1165060355228, -2806.7151144576005, -10882.302955904926, -27817.100568112113, -27745.708494118069, -22841.420845008699, -8553.5264674688351, -4085.033989629072, -1748.9561003744159, -545.33543865452532, -146.45498278007594, -40.805440061891282, -50.060212982262158, -16.730489448484349, -23.62313915150434, 0.36714120063527833, -7.1882909197809326, 6.4142604093545659, -14.833291452397129, 3.4669422259569203, -16.161012153790594, -21.283130178011959, -13.244388638951026, -1.2754674400463286, 0.49184661171499777, -11.472717532816317, -17.530689402649369, -29.523444921912187, -36.983418680226812, -91.597351236026796, -144.17841735614732, -486.41083616652156, -239.1204206916959, 139.00893917602821, -7153.1577950265046, -18373.599790964956, -8415.9227315857388, -6467.5546779833858, -5469.6585676007244, -2789.7914675082047, -821.48267137489768, -514.71454200305448, -122.6780822655295, -35.554593402553344, -32.905184819607861, -16.875977506192179, -9.1243948190511883, -4.1802620318744168, 0.78316084097390803, -0.82473624462572925, -6.0277039354546789, -6.8502427898926159, -6.8858593350514123, -14.551844205848809, -8.4592989146599145, -1.9950695133570466, 1.5394495557011576, -9.232834653609892, -11.961754213185406, -20.558561534905806, -38.14482496917136, -57.160869905334089, -157.5554953403844, -411.20082432868492, -110.11930975746139, -463.64281724562954, -1210.9754315912523, -4810.1023052011815, -2624.9192342435695, -4516.897453633137, -3582.982491421491, -2119.7499173636902, -750.23472664477231, -159.86878938364373, -96.805728919101412, -16.935754226078267, -22.178078450833883, -9.0092227225989756, -5.4454852920506616, -2.5268882566736748, -2.6219523498948458, -2.0534180946008638, -6.4643064804236223, -8.7214065300148622, -7.0127031874072934, -7.7847619200438425, -0.78121801903708787, -0.11031060182209244, -3.4318959866990171, -4.568083040130742, -9.3160200641569482, -15.87900618307528, -23.382201868158507, -37.989404730637517, -121.95929165874175, -201.43809047465336, -567.30372690179445, -610.36312853782476, -1937.2376557226703, -2694.0942422163184, -3481.5355975420739, -3026.0617140239533, -2506.4916383888308, -1355.1576691715959, -468.0599091435185, -33.397814851582154, 18.545331481583979, -29.439943085485314, -11.922803368680741, -7.7174579848963036, -2.7888603302094261, -2.0545006330536419, -1.0224301618297007, -2.5290059501700397, -2.6199349314032494, -4.8828731457816774, -5.6140621268617785, -3.6146413255535528, -0.82967484502750599, -1.1631844631411599, -1.1736245693095499, -3.7427284368684024, -6.6178270656423424, -8.8039498431578131, -13.481606634721874, -26.682014936266803, -32.97802138197703, -190.87870662958537, -335.07671606134033, -876.95522185704988, -1470.8308615232113, -2413.1056871868645, -2329.4915082040015, -2151.9265781424592, -1438.5211303616525, -713.08152385953474, -130.56706965452, -28.862997769748436, 1.7115783105395304, -2.3079138134833856, -11.650001060370576, -2.1701895043697319, -1.7033561682904694, 0.11972955037883275, -0.5790790812653609, -0.45369004788794814, -4.0202584980239315, -2.2874964618085922, -4.0439693313887179, -2.7144116941037568, -0.78431497120559035, -0.63377862148075614, -0.83542887465582039, -2.5417481635934216, -3.4497798452119151, -5.2729359146939485, -9.3325337684514853, -2.3480777220919959, -30.998957295773433, -62.717085150656224, -255.55592612696097, -515.55403813953228, -1077.4118984564277, -1959.4321649356718, -996.17063256475433, -957.58296584245431, -646.48124546709357, -264.63237090275328, -80.518340163143705, 1.3577640380308329, -10.209813205700032, -1.6455702447745924, 0.041564105453412992, -2.1114336115237951, 0.094770419949782359, -0.59915948675603581, -0.042806075220647909, -1.4583889440112543, -1.0515624140257636, -2.6242610725724358, -1.9962698899057387, -2.6373580888952279, -0.39414295752688255, -0.80952098820947449, -0.80935504019781357, -1.8315981280862581, -2.3957781219887311, -3.7775973636187947, -1.2762438485839673, -5.8736187047076989, -1.7472058496177199, -39.26171578474986, -103.67045476207605, -221.97901463800724, -486.52939506954147, -770.86385201715837, -324.53401456188737, -340.76561269504333, -198.94197841299811, -116.98390967138687, -32.552002455687223, -2.8647426984892057, 3.4567160839115996, -2.3310052693731942, -0.31982529888503974, 1.0641170511547686, -1.1693860348016079, 0.40700212695667498, -1.0092937918537679, -0.034985154955161232, -1.1746986822405672, -2.2583319261560799, -2.3742700657768196, -2.0999344700147127, -1.3199204785521135, -0.00726121067659493, -0.21997349279604808, -1.6799449140427334, -2.573626149077699, -1.2749029797075579, -2.9722975102588807, 1.1149262389696764, -3.7825574143705132, -8.8112838568342262, -31.380656277665604, -80.815706494855448, -151.2920880811312, -231.73584987382, -71.719340760371239, -68.364029336894532, -82.304975309081328, -39.769136567332623, -12.693902195545155, 1.9842035662706039, -0.48894354077452629, 1.5673786316984977, -1.1528550937233366, -0.047905313676576855, 1.0650111541187497, -1.4670778837513785, 0.90154843827712783, -2.0067122081730173, -1.7180755446076856, -3.3483434682482898, -1.6317774897434336, -3.4708804264384949, -1.4694727348954268, -0.10257790692130256, -0.92889636381571783, -2.5451436559397584, -1.1303995452351283, -2.8871606625355204, -0.49805533537312113, -0.43871934228158149, 0.74909741969065036, 1.439791857975526, -13.026034555561825, -28.484337861014367, -36.895178406765908, -72.231190035838395, -26.809485534889244, -56.942733796520351, -36.280107429422031, -18.099079313675151, -3.2627913287121535, -0.27065475805048173, 1.1511525903295716, -0.1898870363801409, 0.97087220888025372, -1.1326412370424179, 0.19981301766363371, 2.3076802702931332, -2.5498407756566031, -0.55532623625253041, -4.5067864970337066, -3.1791416623515807, -4.4078100962970312, -3.3125592316970569, -0.86117313527739991, -1.5893272599995412, -2.966763176308445, -0.10263295233944174, -3.9090515756474873, -1.1809123553765606, -1.2038275093350199, 0.28624805719871799, 1.8536817132476691, 0.80720029239974944, -5.5769148242308617, -9.876045833403877, -26.746787584056406, -25.156847324745275, -59.858730768373135, -40.909481344220289, -31.301364606284917, -12.992896188265529, -3.3747756869001191, 2.018530777741562, -0.2260612077575776, 0.20594677690592242, -0.32403225688254972, 2.6342781156582364, -0.20787587650621794, 0.020021422684959465, 2.4168167113542753, -5.4711139391067487, -4.0162352275216753, -8.2614925402209369, -5.3597212899808353, -3.5618518868969149, -2.433206189931258, -3.72732750056158, 1.9796458045760836, -5.6194552495050392, -1.3533084788499918, -2.5312603283156982, -0.73577412998862446, 1.0534870856485199, 1.9641802030644013, 2.686394865901931, 0.15179077698100021, -13.505006616733285, -24.652619118640313, -46.540772018331772, -65.573862825648789, -62.198686950727755, -33.367481359773279, -15.462856466374785, 1.2764820376727259, 0.65238351077916601, 0.11426292455840634, -0.28574074744887695, 1.1004477970868616, 1.5327652909312646, 4.9327112002405187, -2.7503236900904393, -3.9754701567757182, -0.83451213573114202, -9.6859551174636032, -6.0006304228248837, -7.1318253263858704, -4.9856424549649869, -8.2198692881497966, 4.4471445589999075, -5.9124192136821829, -1.066228559248251, -4.5320020023541776, -2.2691032318803455, -0.29595929991781228, 0.95069246916243999, 2.9800299945570488, 4.1754888650460389, -3.9368165535394617, -16.752391317324459, -41.141712299851427, -60.643902512124761, -84.343164732157774, -54.074972316673119, -32.147836838432397, -3.8004568077904586, 0.60906370022349199, 0.96326571070502964, 0.12072436644318041, 0.86319547550846831, 1.1644302862121145, 2.3252453178811563, 0.4766448788746544, 4.2895158747096422, -8.0099398507205173, -11.261414242734404, -3.7327404661807368, -6.1601929909303115, -5.7506657339441176, -11.117751544185502, 4.3054115148233869, -8.2116085703478756, 1.5649721654809707, -5.692142411938895, -3.4949086671880489, -2.1697325908161673, -0.69541562648800392, 0.8151347377023449, 3.4913843961972888, 3.7128410928274609, -0.28461904914440361, -14.694115553922865, -40.784171797776878, -76.129097997930202, -42.446544168449137, -35.20072244442639, -7.6849685309209681, -0.86778876706269803, 1.7056687310546401, 0.51974952798739482, 1.1316759112288739, 1.2127800605381189, 2.2221214293211369, 0.8361427470500683, 0.099546606452808759, -3.1066939683116588, 2.4769973579809332, -11.745899626687375, -12.566716735550758, -4.7843722525441121, -8.6040588700645948, 5.3511034027408684, -15.66778198729919, 3.3911987930307137, -8.1259457896856588, -4.7980365887404339, -2.1471667518999764, -2.5087241573260579, -0.86097656871748596, 0.80139543608377761, 2.3927476350849495, 5.6561627225456101, 4.6250195847240709, -10.360873371570062, -32.183766942993408, -40.627648783043085, -17.95302681367091, 6.1859416444601623, 4.4451711191118575, 6.2133312512745986, 3.3587096432927233, 0.75569650762962715, 0.82429958430179118, 1.6770717987294814, 1.4875078542842981, 0.57506461301516931, -1.8616897808321822, -4.2923314886050523, -7.0161307894352376, 4.8526265686569623, -11.625945416074895, -21.07467865045702, 3.1434482955713889, -12.714871655934468, 2.366640700254353, -11.173661544979289, -6.475058123170597, -2.9596627855411386, -2.7630790459355632, -1.4122750319888788, -0.55802289067111654, 0.40509965601619852, 3.0549503122920978, 4.5519407117959005, 5.5044865911271481, 2.884340309618711, -2.0306279174386637, -12.290279126535582, 30.20785901727286, 12.45094729737127, 8.7415961086741216, 10.304484703022888, 4.2310313602871554, 1.8368366318675937, 1.9910666876255574, 0.99156303676388502, 0.31747940339256003, -0.60245605946597469, -1.5054245711483085, -5.2047479791857727, -4.6985425899868174, -6.4406057657264579, -2.4317965202694718, -0.31806110286890099, -34.614374984304249, -0.31806110286891309, -2.431796520269478, -6.440605765726465, -4.6985425899868325, -5.2047479791858065, -1.5054245711483181, -0.60245605946599046, 0.31747940339256003, 0.99156303676388657, 1.9910666876255707, 1.836836631867627, 4.2310313602871847, 10.304484703022929, 8.7415961086741465, 12.450947297371268, -17.953026813669211, -12.290279126534008, -2.0306279174386814, 2.8843403096185996, 5.504486591127181, 4.5519407117958774, 3.0549503122920303, 0.40509965601617365, -0.55802289067113198, -1.4122750319888866, -2.7630790459355659, -2.9596627855411324, -6.4750581231706095, -11.173661544979305, 2.3666407002543774, -12.714871655934495, 3.1434482955713383, -21.074678650457034, -11.625945416074918, 4.852626568656909, -7.0161307894352527, -4.2923314886050816, -1.8616897808321802, 0.57506461301515821, 1.4875078542843145, 1.6770717987294999, 0.82429958430183881, 0.75569650762972518, 3.3587096432928165, 6.2133312512752603, 4.4451711191129393, 6.1859416444606961, -42.446544168447332, -40.62764878304236, -32.183766942992868, -10.360873371569919, 4.6250195847241038, 5.6561627225455622, 2.3927476350849091, 0.80139543608374619, -0.86097656871749839, -2.5087241573260646, -2.1471667518999924, -4.7980365887404339, -8.1259457896856819, 3.3911987930307128, -15.667781987299181, 5.3511034027407849, -8.6040588700645682, -4.7843722525441965, -12.56671673555077, -11.745899626687423, 2.4769973579809226, -3.1066939683116837, 0.09954660645280862, 0.83614274705006209, 2.2221214293211515, 1.2127800605381271, 1.1316759112289154, 0.51974952798746277, 1.7056687310547414, -0.86778876706233132, -7.6849685309204459, -35.200722444424429, -84.343164732156296, -76.12909799792908, -40.784171797776416, -14.694115553922703, -0.28461904914431585, 3.7128410928274769, 3.4913843961972515, 0.81513473770227451, -0.69541562648801736, -2.1697325908161949, -3.4949086671880569, -5.6921424119389146, 1.5649721654809774, -8.2116085703478952, 4.3054115148233585, -11.117751544185527, -5.7506657339441034, -6.1601929909302848, -3.732740466180779, -11.261414242734437, -8.0099398507205191, 4.2895158747096467, 0.47664487887466933, 2.3252453178811465, 1.164430286212123, 0.86319547550848241, 0.12072436644322472, 0.96326571070516387, 0.60906370022364942, -3.8004568077899661, -32.147836838431445, -54.074972316672174, -65.573862825648646, -60.643902512124406, -41.141712299851122, -16.752391317324395, -3.9368165535393809, 4.1754888650460389, 2.9800299945570101, 0.95069246916240213, -0.29595929991782399, -2.2691032318803499, -4.5320020023541936, -1.0662285592482377, -5.9124192136821918, 4.4471445589998728, -8.2198692881497806, -4.9856424549649665, -7.1318253263858535, -6.0006304228248819, -9.685955117463573, -0.83451213573115879, -3.9754701567757316, -2.7503236900904167, 4.9327112002405231, 1.5327652909312637, 1.1004477970868634, -0.28574074744888678, 0.11426292455844969, 0.65238351077926593, 1.2764820376728394, -15.462856466374522, -33.367481359773095, -62.198686950727343, -59.858730768372553, -46.54077201833131, -24.652619118640224, -13.505006616733089, 0.15179077698109764, 2.6863948659019079, 1.9641802030643754, 1.0534870856484704, -0.73577412998863267, -2.5312603283157147, -1.3533084788499781, -5.6194552495050258, 1.979645804576063, -3.7273275005615623, -2.4332061899312447, -3.561851886896878, -5.3597212899808397, -8.2614925402208979, -4.0162352275216939, -5.471113939106738, 2.4168167113542718, 0.020021422684962133, -0.20787587650621156, 2.6342781156582284, -0.32403225688256132, 0.20594677690590416, -0.22606120775752253, 2.01853077774176, -3.3747756868998953, -12.992896188264998, -31.301364606284267, -40.909481344219984, -26.809485534888527, -25.156847324744817, -26.746787584056008, -9.8760458334037811, -5.576914824230828, 0.80720029239978064, 1.8536817132476344, 0.28624805719868845, -1.2038275093350328, -1.1809123553765482, -3.9090515756474855, -0.10263295233946072, -2.9667631763084428, -1.589327259999552, -0.86117313527738326, -3.3125592316970565, -4.4078100962970224, -3.179141662351582, -4.5067864970337235, -0.5553262362525373, -2.5498407756565928, 2.3076802702931301, 0.19981301766362944, -1.1326412370424508, 0.9708722088802425, -0.18988703638015317, 1.1511525903296145, -0.27065475805034434, -3.2627913287119403, -18.099079313674878, -36.280107429421662, -56.94273379651932, -71.719340760368894, -72.231190035836406, -36.895178406764366, -28.484337861013827, -13.026034555561461, 1.4397918579755735, 0.74909741969062116, -0.43871934228165033, -0.49805533537312413, -2.8871606625355364, -1.1303995452351521, -2.5451436559397544, -0.92889636381573193, -0.10257790692130979, -1.4694727348954375, -3.47088042643851, -1.6317774897434372, -3.3483434682483164, -1.7180755446077083, -2.0067122081730231, 0.90154843827713693, -1.4670778837513718, 1.0650111541187297, -0.047905313676639846, -1.1528550937233546, 1.5673786316984972, -0.48894354077444435, 1.9842035662707793, -12.693902195544938, -39.769136567331614, -82.304975309079381, -68.364029336892514, -324.53401456188737, -231.73584987382011, -151.29208808113108, -80.815706494855604, -31.380656277665615, -8.8112838568343115, -3.7825574143705687, 1.1149262389696379, -2.9722975102588807, -1.2749029797076188, -2.5736261490777141, -1.679944914042758, -0.21997349279605258, -0.0072612106766204651, -1.3199204785521295, -2.0999344700147602, -2.3742700657768196, -2.2583319261561177, -1.1746986822405874, -0.034985154955167297, -1.0092937918537661, 0.40700212695667115, -1.169386034801607, 1.0641170511547318, -0.31982529888503974, -2.3310052693731778, 3.4567160839116182, -2.8647426984891329, -32.552002455687209, -116.98390967138671, -198.94197841299811, -340.7656126950431, -996.17063256474341, -770.86385201715302, -486.52939506953675, -221.97901463800537, -103.67045476207502, -39.261715784749725, -1.7472058496176825, -5.8736187047078241, -1.2762438485839995, -3.7775973636188502, -2.3957781219887693, -1.831598128086283, -0.80935504019782156, -0.8095209882094927, -0.39414295752690548, -2.6373580888952821, -1.9962698899057312, -2.6242610725724247, -1.0515624140257607, -1.4583889440112356, -0.042806075220638506, -0.5991594867560418, 0.09477041994976447, -2.1114336115238088, 0.041564105453392161, -1.645570244774569, -10.20981320570001, 1.3577640380311771, -80.518340163142966, -264.63237090274987, -646.481245467088, -957.58296584244442, -2329.4915082039943, -1959.4321649356684, -1077.4118984564245, -515.55403813953228, -255.55592612696057, -62.717085150656416, -30.998957295773568, -2.3480777220922762, -9.3325337684514711, -5.2729359146941093, -3.4497798452119492, -2.5417481635934838, -0.83542887465582316, -0.63377862148080311, -0.78431497120560345, -2.7144116941037488, -4.0439693313887171, -2.2874964618085487, -4.0202584980238978, -0.45369004788789491, -0.57907908126534979, 0.1197295503788481, -1.7033561682904654, -2.1701895043697248, -11.650001060370577, -2.3079138134832218, 1.7115783105395919, -28.862997769747821, -130.56706965451951, -713.08152385953122, -1438.5211303616488, -2151.926578142451, -3481.535597542063, -2413.1056871868605, -1470.8308615232086, -876.95522185705033, -335.07671606133954, -190.87870662958562, -32.978021381977214, -26.682014936266988, -13.48160663472185, -8.8039498431579233, -6.6178270656423885, -3.7427284368684086, -1.1736245693095617, -1.1631844631411714, -0.82967484502748334, -3.6146413255534444, -5.614062126861783, -4.8828731457814465, -2.619934931403141, -2.5290059501698665, -1.0224301618296836, -2.0545006330535864, -2.7888603302093888, -7.7174579848962566, -11.922803368680738, -29.439943085484902, 18.545331481584157, -33.397814851580577, -468.05990914351662, -1355.1576691715877, -2506.491638388823, -3026.0617140239456, -2624.9192342435676, -2694.0942422163216, -1937.2376557226696, -610.36312853782647, -567.30372690179479, -201.43809047465459, -121.9592916587422, -37.989404730638029, -23.382201868158511, -15.879006183075566, -9.3160200641569801, -4.5680830401307739, -3.4318959866990371, -0.11031060182210287, -0.78121801903713106, -7.7847619200437572, -7.0127031874072889, -8.7214065300146117, -6.4643064804234296, -2.0534180946007163, -2.6219523498948099, -2.5268882566736321, -5.4454852920506234, -9.009222722598933, -22.178078450833912, -16.935754226078039, -96.805728919100844, -159.86878938364163, -750.23472664477129, -2119.7499173636857, -3582.9824914214882, -4516.8974536331352, -8415.9227315857224, -4810.1023052011687, -1210.9754315912437, -463.64281724563131, -110.11930975746253, -411.20082432868651, -157.55549534038482, -57.160869905334962, -38.144824969171324, -20.558561534906186, -11.961754213185522, -9.2328346536099755, 1.5394495557011911, -1.9950695133570939, -8.4592989146598381, -14.5518442058491, -6.8858593350514123, -6.8502427898925227, -6.0277039354547091, -0.82473624462553619, 0.7831608409739802, -4.1802620318743058, -9.1243948190510782, -16.875977506192154, -32.905184819607861, -35.55459340255284, -122.67808226552924, -514.71454200305027, -821.48267137489574, -2789.7914675081947, -5469.6585676007144, -6467.5546779833749, -27745.708494118051, -18373.599790964956, -7153.1577950265018, 139.0089391760178, -239.12042069169632, -486.41083616652713, -144.17841735614894, -91.597351236029397, -36.983418680226798, -29.52344492191359, -17.530689402649603, -11.472717532816715, 0.49184661171508715, -1.2754674400467305, -13.244388638951113, -21.283130178012485, -16.161012153790605, 3.4669422259560148, -14.833291452397047, 6.4142604093547071, -7.1882909197807701, 0.36714120063543831, -23.623139151504223, -16.730489448483766, -50.060212982262158, -40.805440061890259, -146.45498278007528, -545.33543865451918, -1748.9561003744159, -4085.0339896290589, -8553.5264674688297, -22841.42084500867, -17213.595236981979, -27817.100568112102, -10882.302955904914, -2806.7151144576032, 113.11650603552238, -714.3011765913102, -258.32278440436545, -84.034753639410752, -64.314813850969756, -32.473901904667066, -16.600635746256838, 0.34733716754136956, -1.7416101263050108, -17.401343902608698, -22.272265924680649, -14.131264529805808, -19.629747734378629, 3.5205960317556224, -14.232799652319452, -14.472211987615371, -7.2952697383626051, -2.1850531713375001, -11.025047422886134, -26.960578056534132, -39.308430893651277, -117.89522553299832, -106.61462896985047, -1120.3666800727583, -1103.8692252741987, -5794.1219231082987, -10829.417860945698, 544.0730266990613], "imag": [0.0, 39515.399789254865, -15382.502646592808, -2918.5213899411633, 1191.3150820979915, -345.80526987183259, -91.963497561164317, -108.06830259743781, -23.431327605037779, -16.610810822958811, -2.2742971526945692, -21.94540337447156, -21.272420402577179, -19.057735286082725, 52.376313120912741, 8.8521975026144215, 0.0, -8.8521975026153612, -52.376313120912044, 19.05773528608244, 21.272420402577229, 21.945403374471546, 2.2742971526945164, 16.61081082295847, 23.431327605037779, 108.06830259743377, 91.963497561167031, 345.80526987182992, -1191.3150820979911, 2918.521389941166, 15382.502646592799, -39515.399789254865, 16946.371225111547, 11272.400870696511, -1841.1630655848539, -1171.8258105148211, 109.26740577843201, 109.43221584454041, -206.10314812122442, -42.28539321936541, -65.249140172269108, -8.1960517939269071, -25.365956236318521, -12.488977779350739, -20.777136166915728, 10.939736173955986, 13.738393384077787, 18.982014759380824, -12.446635345723246, -8.8305069728752752, -14.016932746731957, 10.847407040619599, 18.949463773817904, 9.5491377266946333, 9.9160507928571491, 10.925693066643545, 29.597688207921799, 110.70270321520633, 119.64570653889598, -28.406380421737747, -832.38513354395832, 3868.3607546707453, 4625.1554139998552, 1299.266384884336, 11955.369188695569, -346.60702359457474, 2363.0865643328202, 202.32180136864196, -295.01076934839688, 277.44131247872377, -208.25011765184485, -68.536452109290167, -63.125416501511275, -30.589238972650307, -20.382558491276782, -12.902690844348575, 1.0182743702449766, 2.2874141051372452, 14.546101055958879, -1.6150967690531892, 0.87386354462209248, -13.38677146472326, 17.407635810762027, -0.60680891034428563, 12.950261495215786, -0.86756998254740836, 13.062832664150156, -2.136096668655318, 35.880437410281019, 66.543583791324124, 106.41042136702396, -154.61175360170367, -142.43138300706809, -204.04622542072212, 637.22651951043269, 14506.214536688893, 2087.241286517743, 2934.8250858413794, -540.57641351250766, 271.57679130866723, 537.49064424335052, 71.610686309506633, -82.566517160157844, -74.489552074506761, -57.142723569279489, -25.254222647826957, -12.544755138678799, -6.7708773337384622, -0.20770764759918051, 1.1194026551973495, 3.6890839097334878, -0.20461611038051675, -5.3737401851528386, -2.2636764639022453, 4.9832600695280087, 10.10754418440443, 2.544597152813191, 5.0447569422202223, 2.8189903732027388, 2.9920185974422946, 11.529259915073515, 53.348281783168488, 50.577306165813702, 119.57179721034167, -786.94393395792213, -901.86972095078409, 1074.2990124084633, -676.63432998511303, -1814.4894639161919, -1058.8873901892568, 349.63255334068964, 268.2484621242063, 380.4257804868011, 97.912476061205965, -71.661879904778658, -72.736940205390937, -37.286147332183255, -18.720186517652358, -9.5628328869678363, -8.2634536416369482, -0.19099280196160889, 0.28567330333833429, 0.071309220847330906, 1.775656575203522, 2.1386941287610384, -1.0231985430634363, 2.4480270844924137, 1.9878096211738889, 4.1535160740617325, 3.5521022242715827, 3.6019889835361654, -0.38778650675348675, 4.5934633035837322, 12.369503115173785, 94.400929285346393, -77.039516694541632, -317.96189631496532, -464.93982303098932, -1928.5847150696218, -1707.435501473529, -1583.8824730375936, -833.14970460709912, -242.65732454029356, 317.34459246185179, 69.371971565542168, -13.453603503282046, -58.678662168810511, -40.697925231357267, -20.16679423742438, -13.090865763493372, -7.6639325468155182, -3.9818184076004774, -1.1480426683317846, 3.4782462601712654, 3.3535274581593777, 1.1304420427842019, -0.78798091056569108, 1.3645618319176871, -1.2482103302418359, 2.6548043613808709, 2.0455422971726147, 3.3794759874708187, 0.28270713586437868, -0.67396364813071052, -2.4299863370655714, 20.048308524208917, 2.7323622379310764, 23.350930435926227, 19.428895667387472, -542.55543458513841, -969.72646934413422, -1881.6935115818319, -426.42488803140975, -203.12933548649579, 221.2759941924873, 75.498646737827528, 81.527654709232138, -23.228148927519229, -35.095892631083601, -18.113211298120703, -10.84781416147373, -7.2190125620904571, -4.6279710639736358, -2.4591204313834965, 0.58454842364750592, 0.9547463106026568, 2.4151219203224654, 0.35567626693527166, -0.34443735246553581, 0.10021534895843374, 0.62975751586612239, 0.075739057981468363, 2.5606009702294732, 0.33652577635989583, 1.0967346902818458, -2.0000864020848046, 1.451434335785166, -7.1043203483245918, 10.682010714917043, 63.119371696969466, -0.21915489532378957, -18.829394319190524, -151.38668525810633, -53.557614725234764, 319.98109193688521, 339.65571159114432, 137.34002448547074, 89.166061674211335, 5.5395407010458548, 3.1394961579749192, -15.790153056071546, -10.068399035154068, -5.990189510359599, -3.8184783724455591, -3.031311871551015, -1.7050468427375405, 0.29997994657424726, 1.0820090369221063, 1.186145834536469, 1.1035985643781976, -0.026686439684276222, -0.021861987241408937, -0.71069133238487792, 1.5408441736495715, 0.88964240698419117, 1.3226298476418663, -0.31341792844049038, 0.36542819178090652, -6.2831724147446009, -1.5019641274621849, 13.705577255286178, 14.08988446983488, 43.376064565045787, 54.204646228028693, 132.60719521227122, 62.432091745032416, 219.86853407025291, 133.19971898528303, 106.65962198554573, 32.509510578136677, -0.32173120932219279, -1.0472919151881939, 3.0400482541159932, -2.1373375769283371, -3.730023177462626, -3.658884080605465, -1.7579654575817145, -1.4081716233776314, 0.53847505259675243, 0.97164442609396484, 0.99557444173589427, 0.11126643861839057, 0.68343802732828218, -1.8968331338371984, 1.2370080984335854, 0.24616862215977253, 1.6488725749132858, 0.51751999590405229, 1.1293193043526017, -2.440127533596657, -2.1096176983280075, 0.86862341139232857, -3.2906850406637935, 10.529105330387669, 21.528607110729595, 53.864359931260871, 77.645971701549371, 219.35042572397626, 56.646725304489401, 72.597133152544643, 25.283726226154087, 9.5916945360518575, 3.5131066387109651, 7.8353712095885921, 3.7982495059531924, -0.1320379920173739, -2.6872144914167868, -3.9932995411602161, -3.2496097582258021, 0.34753129477634409, 0.51108563039490118, 1.5779290838292743, -0.32098662744154494, 0.85050436376706862, -0.95269533500567993, 1.2514468795435802, -0.80232514327112969, 0.9402998385797201, 0.083484537520043395, 2.9970442493787712, -1.3537504507858638, -0.49606931853204594, -0.40634793694041288, -3.2049709482452999, -0.90733505109423707, 2.4367446291982722, 14.425788131967863, 11.285893196605656, 41.383231407558732, 26.64930600456886, 3.49019745229235, -2.7278278900775033, -0.6780497768719117, 5.1972517053508067, 13.315592278460391, 8.5655340270495799, 2.7986942524720009, -1.3188307478897958, -2.9560147101356677, -3.5039625138893249, -3.2351264422424442, -1.7837191938553947, 4.1370294214229899, -0.48575889336608402, 1.5705428299533406, -0.28712766434912351, 3.0263722138472242, -1.2120159426024513, 2.3578685311613299, -0.57595981339550073, 5.0023110313506045, -1.3965343408401143, 0.57130018359553258, 0.97601539997779907, -2.5856117766371072, -1.4572886030272592, -1.697304402058907, 2.1030121366448049, -0.062995146217583023, 4.9612937854964008, -0.301351161950073, 9.1580358876592047, -26.774160253651129, -14.352442298363405, -1.3280628610826339, 14.662722831107068, 13.065714024917916, 9.0142686843581057, 2.3156698002103213, -2.1494090398895276, -3.4369058394752816, -3.2885833247038136, -1.5589303641797962, -1.2624013759488528, -1.9675974847606275, 6.6808538974877765, -1.9845455926326385, 5.8520209082315047, -0.64649466936933941, 3.7090325345277484, -1.4383189901623872, 7.6358217658181289, -2.5011370399824613, 2.0288771570791524, 3.3870661540364408, -2.1726948090167277, -1.6227282885568253, -2.3401345171732064, -1.0784728701462345, -2.329913042321786, 1.6766227476276099, -5.5208279800184377, -13.304914803323909, -34.683237345909106, -16.2208922311743, -7.5614574111833583, 14.803696771258469, 15.579335900760762, 15.161631552742872, 8.4660409590375174, 1.9742581617985508, -2.2318082441740326, -3.1677451000476946, -2.7136257844502993, -2.4663578849843404, 2.1470642674041458, -0.80807516468244989, -6.8039934755458935, 11.462761097859508, -2.3200072133134322, 9.6476195054900042, -0.58323258923086063, 10.466810618341768, -7.3966372849294499, 4.629755222962074, 7.8499060069144697, -1.2532724460122664, -0.71383693570895246, -3.0356422051110532, -1.9171318821546592, -3.2905248775997, 1.1638954652799918, -0.8003122215164804, -7.6686022187651925, -13.379436000591463, -2.0784151782651223, 18.753674553162941, 37.596939514973172, 28.201887912811504, 26.441177038828386, 17.313699289624569, 8.2605837012813357, 1.9157665349814501, -1.0360449197814665, -2.460835808457071, -2.9435912594789997, -0.73745892985465067, -0.80698208098757895, 1.3512050433752707, -2.4806623635392717, -10.931358459008862, 20.399475046734903, -0.93914753929729033, 15.633586230850142, -11.808527677086202, 3.7955244266493091, 11.440683264496995, 0.22625003249094855, 2.3910143241324033, -1.5433230899620785, -1.7524971656611896, -3.4392335008624597, -1.2102890230410412, -1.1333111335531953, -0.86689054652400055, -0.77102037498198228, 5.869418392294464, -6.6911708498309208, 60.884710948918006, 43.621563233816303, 43.489599527484941, 33.141784821271486, 18.338861076357606, 7.7096141949396086, 3.1020965354201242, -0.33651454595896624, -1.858665713174497, -1.559439785993801, -1.7180049365163976, -0.49470837698954684, -5.7499783777067037, 1.2816063498557866, -1.6438131382345036, -14.80449956699707, 30.383248800411909, -20.687082737158004, 6.4291237134149926, 13.719178799652914, -0.15202331710012035, 5.6708331746907428, 1.1091130063870853, 0.43083164420390874, -2.423604198850752, -1.2614169037455483, -3.1633275417854718, -2.5428479485652051, -1.0621152637056996, 7.4921468465754772, 13.826120615216594, 48.56895003285198, 43.655937980459306, 56.143788442077074, 39.839822974553684, 28.907966432346075, 17.226166967005444, 9.493352687280801, 2.1248307248495761, -0.10304029106189502, -0.73643011249607004, -0.68086203692422775, -1.5726895782452095, -2.38329292549688, -6.3654622280486342, -12.648471231222512, 2.6502987300644998, 9.1941379366153466, -33.28553680715055, 17.791788634489134, 16.331392880531652, -1.0332061538290742, 9.6376857080971341, 4.1689669632335153, 3.4112249849533103, -0.63064111926197686, 0.028356847121888181, -1.1968584419289052, -3.3957285823190806, -4.7459408986565164, -4.790016252397657, -5.1593354130915703, 13.957717184896774, 20.367299127198688, 0.0, -4.5388798707327584, 12.10851784859719, 15.801052170121357, 15.786196904526062, 6.4645339091427658, 2.6357128260629894, 0.48128762074186304, -0.08159176932681525, -1.1399410088753745, -0.93916966756638098, -5.4695359499377414, -8.4733779831544798, -6.8332707948903639, -5.8759130146162706, -8.1552266379296245, 0.0, 8.1552266379295908, 5.8759130146162661, 6.8332707948903488, 8.4733779831544869, 5.4695359499377316, 0.93916966756637688, 1.1399410088753721, 0.08159176932681525, -0.48128762074185355, -2.635712826062981, -6.4645339091427667, -15.786196904526072, -15.801052170121331, -12.108517848597181, 4.5388798707327416, -43.655937980456407, -20.367299127197448, -13.957717184895019, 5.1593354130924185, 4.7900162523979217, 4.7459408986567313, 3.395728582319133, 1.1968584419289152, -0.028356847121888983, 0.63064111926197186, -3.4112249849533058, -4.1689669632334958, -9.6376857080971128, 1.0332061538290882, -16.331392880531649, -17.79178863448908, 33.285536807150621, -9.1941379366153146, -2.6502987300644807, 12.648471231222583, 6.3654622280486368, 2.3832929254968982, 1.5726895782452166, 0.68086203692425595, 0.73643011249607926, 0.10304029106193066, -2.1248307248495362, -9.4933526872806269, -17.226166967005291, -28.907966432345297, -39.839822974551964, -56.143788442073777, -60.884710948915583, -48.568950032850019, -13.82612061521586, -7.4921468465751166, 1.0621152637059226, 2.5428479485653219, 3.1633275417855051, 1.261416903745556, 2.4236041988507613, -0.43083164420392467, -1.1091130063870698, -5.6708331746907525, 0.15202331710012659, -13.719178799652925, -6.4291237134149712, 20.687082737158036, -30.383248800411859, 14.804499566997148, 1.6438131382345447, -1.2816063498557717, 5.7499783777067242, 0.49470837698955733, 1.7180049365164254, 1.5594397859938318, 1.8586657131745035, 0.33651454595900265, -3.1020965354201109, -7.7096141949395376, -18.33886107635751, -33.141784821271301, -43.48959952748401, -43.621563233814584, -18.753674553161851, 6.6911708498312086, -5.8694183922938254, 0.77102037498232001, 0.86689054652414343, 1.1333111335533379, 1.2102890230411023, 3.4392335008624833, 1.7524971656611932, 1.5433230899620796, -2.3910143241323984, -0.22625003249093578, -11.440683264497009, -3.7955244266492731, 11.808527677086207, -15.633586230850069, 0.93914753929731287, -20.399475046734821, 10.931358459008916, 2.4806623635393117, -1.3512050433752816, 0.80698208098763236, 0.73745892985467021, 2.943591259479049, 2.4608358084570767, 1.0360449197814969, -1.9157665349814337, -8.2605837012812007, -17.313699289624388, -26.441177038827938, -28.201887912810978, -37.59693951497237, 16.220892231174151, 2.0784151782650429, 13.379436000591378, 7.6686022187652325, 0.80031222151651993, -1.1638954652799158, 3.290524877599744, 1.917131882154679, 3.0356422051110541, 0.71383693570894702, 1.2532724460122711, -7.849906006914436, -4.6297552229620669, 7.3966372849294793, -10.466810618341761, 0.58323258923092358, -9.6476195054900042, 2.3200072133134997, -11.462761097859458, 6.8039934755459344, 0.80807516468246154, -2.1470642674041431, 2.4663578849843657, 2.7136257844503273, 3.1677451000476933, 2.2318082441740374, -1.9742581617985304, -8.4660409590374517, -15.161631552742712, -15.579335900760643, -14.803696771258227, 7.5614574111833424, 26.774160253651477, 34.683237345909006, 13.304914803324097, 5.5208279800184936, -1.6766227476275497, 2.3299130423218712, 1.078472870146282, 2.3401345171732237, 1.6227282885568277, 2.1726948090167162, -3.3870661540364337, -2.0288771570791524, 2.5011370399824764, -7.6358217658181076, 1.4383189901624107, -3.7090325345277098, 0.64649466936933497, -5.8520209082314834, 1.984545592632657, -6.6808538974877711, 1.9675974847606519, 1.2624013759488664, 1.5589303641798025, 3.2885833247038483, 3.4369058394752718, 2.1494090398895325, -2.3156698002103084, -9.0142686843579654, -13.06571402491778, -14.662722831106908, 1.3280628610827629, 14.352442298363767, -3.4901974522911301, -9.158035887658194, 0.30135116195024236, -4.9612937854963866, 0.062995146217542555, -2.1030121366447649, 1.6973044020589363, 1.457288603027268, 2.5856117766371063, -0.97601539997780706, -0.57130018359554458, 1.396534340840117, -5.0023110313506107, 0.5759598133955085, -2.357868531161305, 1.2120159426024788, -3.0263722138472202, 0.28712766434913656, -1.5705428299533217, 0.48575889336609929, -4.1370294214229943, 1.783719193855416, 3.2351264422424548, 3.5039625138893205, 2.956014710135662, 1.3188307478897938, -2.7986942524719765, -8.5655340270494893, -13.315592278460258, -5.1972517053507898, 0.67804977687200962, 2.7278278900777337, -56.64672530448825, -26.649306004568476, -41.383231407558036, -11.285893196605604, -14.42578813196792, -2.4367446291981882, 0.90733505109427226, 3.2049709482452906, 0.40634793694041338, 0.49606931853200609, 1.3537504507858567, -2.9970442493787934, -0.083484537520044699, -0.94029983857969957, 0.80232514327114979, -1.2514468795435723, 0.95269533500567261, -0.85050436376704475, 0.32098662744156231, -1.5779290838292681, -0.51108563039488553, -0.3475312947763517, 3.2496097582258234, 3.9932995411602126, 2.687214491416765, 0.13203799201742056, -3.7982495059531578, -7.8353712095884145, -3.5131066387109939, -9.5916945360520085, -25.283726226154414, -72.597133152543805, -219.86853407025291, -219.35042572397646, -77.645971701549428, -53.864359931260992, -21.52860711072962, -10.52910533038772, 3.2906850406638011, -0.86862341139231525, 2.1096176983280075, 2.4401275335966615, -1.1293193043526162, -0.5175199959040564, -1.6488725749132833, -0.24616862215974425, -1.2370080984335483, 1.8968331338372646, -0.68343802732828218, -0.11126643861832354, -0.99557444173586918, -0.97164442609393387, -0.53847505259674655, 1.408171623377654, 1.757965457581725, 3.6588840806054854, 3.730023177462626, 2.1373375769283727, -3.0400482541159497, 1.0472919151882829, 0.32173120932219762, -32.509510578136599, -106.65962198554575, -133.199718985283, -319.98109193688754, -62.432091745036324, -132.60719521227176, -54.20464622802902, -43.376064565046129, -14.089884469834875, -13.705577255286062, 1.5019641274622118, 6.2831724147445849, -0.36542819178094682, 0.31341792844047633, -1.3226298476418761, -0.88964240698418728, -1.5408441736495315, 0.71069133238493809, 0.021861987241514846, 0.026686439684265401, -1.1035985643780957, -1.1861458345364231, -1.082009036922065, -0.29997994657423205, 1.7050468427375622, 3.031311871551031, 3.818478372445528, 5.9901895103595697, 10.068399035154069, 15.790153056071421, -3.1394961579745826, -5.539540701046052, -89.166061674211662, -137.34002448547281, -339.65571159114575, 426.42488803140685, 53.557614725234323, 151.38668525810476, 18.829394319190286, 0.21915489532353391, -63.119371696969402, -10.682010714916952, 7.1043203483248183, -1.4514343357851665, 2.0000864020848317, -1.0967346902818478, -0.33652577635987613, -2.5606009702294568, -0.075739057981359575, -0.6297575158660037, -0.1002153489582, 0.34443735246552043, -0.35567626693504045, -2.4151219203224019, -0.95474631060256077, -0.58454842364747928, 2.4591204313835524, 4.6279710639736518, 7.2190125620904322, 10.8478141614737, 18.113211298120788, 35.095892631083665, 23.228148927519459, -81.527654709232067, -75.498646737828622, -221.27599419248904, 203.12933548649244, 1583.8824730375886, 1881.6935115818235, 969.72646934413342, 542.55543458513785, -19.428895667388197, -23.350930435925818, -2.7323622379307726, -20.048308524208668, 2.4299863370655803, 0.67396364813076437, -0.28270713586437829, -3.3794759874707645, -2.0455422971725761, -2.6548043613806773, 1.248210330242034, -1.3645618319173671, 0.78798091056567598, -1.130442042783935, -3.3535274581592822, -3.4782462601711517, 1.1480426683318268, 3.9818184076005192, 7.6639325468155093, 13.090865763493181, 20.166794237424288, 40.697925231356948, 58.678662168810511, 13.453603503282435, -69.371971565542452, -317.34459246185418, 242.65732454028887, 833.14970460709446, 1814.4894639161919, 1707.4355014735293, 1928.5847150696216, 464.93982303099165, 317.96189631496537, 77.039516694542414, -94.400929285346379, -12.369503115173439, -4.5934633035837242, 0.38778650675346871, -3.6019889835361467, -3.5521022242715157, -4.1535160740616579, -1.9878096211735969, -2.4480270844921423, 1.0231985430638744, -2.1386941287610495, -1.7756565752032289, -0.071309220847206922, -0.28567330333819857, 0.19099280196170093, 8.2634536416369908, 9.5628328869678718, 18.720186517652159, 37.286147332183262, 72.736940205390795, 71.661879904778388, -97.912476061205524, -380.4257804868011, -268.24846212420823, -349.63255334068992, 1058.8873901892528, -2087.2412865177334, 676.63432998511416, -1074.2990124084556, 901.86972095078841, 786.94393395792224, -119.57179721034137, -50.577306165813212, -53.34828178316841, -11.529259915073451, -2.9920185974423683, -2.8189903732028481, -5.0447569422201788, -2.5445971528130604, -10.107544184404102, -4.9832600695276215, 2.2636764639027978, 5.3737401851528253, 0.20461611038107308, -3.6890839097334074, -1.119402655197085, 0.20770764759927202, 6.7708773337385892, 12.544755138678777, 25.254222647826818, 57.14272356927944, 74.489552074506946, 82.566517160157588, -71.610686309506534, -537.49064424335074, -271.57679130866813, 540.57641351250493, -2934.8250858413712, -11955.369188695569, -14506.214536688902, -637.22651951043315, 204.04622542072232, 142.43138300706894, 154.61175360170483, -106.41042136702355, -66.543583791323357, -35.880437410281012, 2.1360966686551617, -13.062832664150186, 0.86756998254746465, -12.950261495215663, 0.6068089103450538, -17.40763581076148, 13.386771464725289, -0.87386354462209659, 1.6150967690552112, -14.546101055958459, -2.2874141051365076, -1.0182743702449171, 12.902690844348964, 20.382558491276768, 30.589238972650698, 63.125416501511289, 68.536452109292355, 208.25011765184536, -277.4413124787215, 295.01076934839597, -202.32180136863923, -2363.0865643328207, 346.60702359456963, -16946.371225111554, -1299.266384884367, -4625.1554139998561, -3868.3607546707453, 832.38513354395968, 28.40638042173725, -119.64570653889508, -110.70270321520742, -29.597688207921749, -10.925693066643381, -9.9160507928571686, -9.5491377266944308, -18.949463773817815, -10.847407040619126, 14.016932746732627, 8.8305069728758134, 12.446635345723296, -18.982014759378298, -13.73839338407706, -10.939736173955323, 20.777136166915735, 12.48897777935125, 25.365956236318532, 8.1960517939270616, 65.249140172269151, 42.285393219366988, 206.10314812122587, -109.43221584453876, -109.26740577843286, 1171.8258105148195, 1841.1630655848473, -11272.400870696491]}};

var right_eye_filter = {"real": [1.8229079259010603, 0.097810498648582461, -0.55840092137248587, -0.99970462842356578, 0.18757876559092043, -0.81617694863114465, -0.17457078018685562, 0.13822182613073089, -0.13830885288846723, 0.14088352498892928, -0.11242245121823281, 0.64190144530750459, -0.18081689212517704, 0.84757445423403044, -2.0367692338977426, 2.3450651085370726, -3.2227771639624789, 2.3450651085369945, -2.0367692338977101, 0.84757445423403854, -0.18081689212518082, 0.64190144530750537, -0.11242245121823641, 0.14088352498894169, -0.13830885288846723, 0.13822182613073003, -0.17457078018684977, -0.81617694863113666, 0.18757876559091927, -0.99970462842356267, -0.55840092137248509, 0.097810498648581323, -1.0960340088024074, -1.9119199452512301, -2.4095702665388479, -0.55162352804953241, -0.50505328014021589, -1.3068505835636635, -0.49437187443975589, 0.23127204626685588, 0.043350794355039197, -0.071787406154436809, 0.070854449837205943, 0.17221102955705567, 0.44602122877614064, 0.074148205591900399, -0.015611524439393865, -0.79896724757292914, -0.67155961060437053, -0.49375784053273253, 0.028167647498424205, -0.3191891366103583, 0.53582170174408217, 0.20183473326047152, 0.12710467168208503, -0.071400263514192097, 0.074560604448017792, -0.12451483496807111, 0.051358135035693774, -0.77282398113384443, -0.42160647485916963, -1.1311602269894514, -1.4625324828122208, 0.3337871926813808, -1.77011609742092, -1.4302518240108344, -3.0428213499062116, -0.60631225487833551, -0.13683987631719793, -2.3692424085383519, -0.34105804260324346, -0.25969657852057992, 0.23610433796619859, -0.27685168579683173, 0.16986402710259335, 0.073612585805396993, 0.57704911017089122, -0.059867579479423505, 0.51680219528175042, -1.0666730319382505, -0.0056552094670686828, -0.75809939060745812, -0.064701320250044561, -0.19832318162238824, 0.37732986906226257, 0.20777584924550152, 0.15451076629740465, -0.013991851319401968, 0.13841341497021592, -0.086883949036928532, 0.25261423619714551, -1.1991385138433881, -1.9867837341406693, -2.275962773839737, -3.1079150257531585, -2.3995834975192567, -2.2937692343725722, -2.1872173045799017, -1.3988308931230504, -2.2073957813815439, -1.9667941627002865, -1.6748432066635108, -0.92650772032564344, -0.054197237250052703, -0.18026213329416008, -0.15232124758200827, -0.016555865669302033, 0.31289505893870784, 0.42806542968274719, 0.23124350286854853, -0.087366382764607439, -0.12552132795947232, -0.12547908619418155, -0.38089709050886683, -0.28444076658768042, -0.11944152964360766, 0.12056136689031131, 0.21189843131890268, 0.16581598470154221, 0.13376820638890077, 0.22205496825803592, 0.15120100371874812, 0.12380717441381156, -1.2352596784322261, -2.2222759116849211, -3.3782856809989692, -3.415076124219421, -2.7282977589825297, -1.5576789730825455, -1.6478932560447972, -2.067907968457094, -2.004290735457912, -2.6427456963680775, -1.9309474679838621, -0.16864865516592528, -0.22642518078963322, -0.13321306237600422, -0.20692971953006373, -0.068344938706069003, 0.14493915164047724, 0.46505832474821007, 0.32789481378377733, 0.1852927254910838, -0.1356638873386786, -0.03585192275390197, -0.17203834043005656, -0.15954900238018477, -0.059581713131431221, -0.017228379259871054, 0.12402459410135006, 0.1524538089963059, 0.16271946063708961, 0.24817234249560427, 0.26053579199245763, -0.04769125558408293, -0.81459993031792033, -2.0740660744196808, -3.1544891598954261, -2.9212825837849565, -2.4077419089431702, -1.6411629435379833, -1.576697627349694, -1.8007661961299257, -2.0001525985045707, -1.5107274159689619, -1.2839600483166405, -0.63196711118813498, 0.31071574064221719, -0.21370915949408273, -0.16393119308951343, -0.097481704015839707, 0.13767875532837173, 0.23695911940697742, 0.36158774196732829, -0.00066962538216623158, -0.1026502520704758, -0.18176695609293456, -0.059120611570986824, -0.13702193484548986, -0.0073538013157976303, 0.020281061259494877, 0.15032501459982059, 0.16876214929227357, 0.18780650312631536, 0.16308782299108887, 0.18583847563977354, 0.44907296092364651, -0.020800703185301726, -1.4297091333258476, -2.4259185480628145, -2.4053777736536626, -1.9821307035675879, -1.3372642957080885, -1.2989780551182537, -1.3731553217305845, -1.2269479805895975, -1.2032897772528626, -0.22206046284030648, -0.18415548289109809, -0.23415549346578352, 0.077936325689887453, -0.21633114300736572, -0.059449722211757941, 0.013318329293146938, 0.28775437300883983, 0.21963323601338633, 0.16649953505637383, -0.18974789333555656, -0.17379580132236441, -0.23416130311702454, -0.13478379984035538, -0.13112027137758978, 0.033522350558872455, 0.13259733500476653, 0.171380750952115, 0.15737574769334917, 0.092477162456605533, 0.13448891283084696, 0.41161459424817443, 0.35609170613712005, -0.55316449850203808, -1.540851379466907, -1.8005308506197801, -1.5719273509294158, -0.94040577953316051, -0.83899416480020927, -0.77336416928591256, -0.66562411016509948, -0.4002640865408188, -0.36750971454913561, 0.2414435659750552, -0.065677188177910795, -0.21341675767851534, -0.041369287190265204, -0.087404842921799578, 0.04460147122538273, 0.19583406251777175, 0.1830038441344799, 0.012219595757112435, -0.034593273427629516, -0.14926486203867156, -0.036665364495836496, -0.1306231554860259, -0.086381624051938985, 0.0020423415177502173, 0.11239290885891448, 0.12781279786870536, 0.10954302373131516, 0.14996801038078228, 0.12965098836907352, 0.14324588543961356, 0.0567484033157079, -0.079342592710004017, -0.77145898274835445, -1.1705860882999304, -1.0754357146023004, -0.5463269466436349, -0.37732231762995055, -0.29185933229148303, -0.18245346577017127, -0.15252816280103537, 0.00992307413149221, -0.05334501261419268, 0.10643359538216246, -0.069635302172998029, -0.20853401810086858, 0.03871878333386132, 0.024793140061197767, 0.22215018549405419, 0.19090693911120471, 0.13458393481660855, -0.1226120784542075, -0.060406846903667433, -0.083060383383984554, -0.016925686434954099, -0.033352938195947639, 0.056474422402956102, 0.04873056181166667, 0.092098221631537164, 0.13542751998114597, 0.15540921558269635, 0.10094403852684107, 0.050489672984821425, 0.089840998861512991, 0.018445471788018183, -0.44280324831238471, -0.64559475523542686, -0.64123409592876457, -0.25571779361731761, -0.15489773108593363, -0.10375533557574061, -0.074018947274090252, -0.074021765277388324, -0.034956034554291714, 0.065331700319185393, -0.079299771847393716, 0.035725424097319471, -0.10252861876832269, -0.22107962950770202, 0.20755848067860572, 0.23157078159613848, 0.34013467279608883, 0.23914223921471078, 0.043591964044129211, -0.20186945117744784, 0.04172561648658725, -0.038784831650455286, 0.076248151019351923, -0.060276976551200255, -0.0031358189183758184, 0.13054366560393055, 0.16122088670834137, 0.12129220423951546, 0.064624059271846127, 0.063153633523538075, 0.036868954773612302, 0.025599835220982206, -0.17872521900892777, -0.37577894082797708, -0.33418602947194676, -0.19087946198724595, -0.092430559387195924, -0.15843188266072916, -0.1178716916883143, -0.079832857077627425, -0.038455609721169501, 0.015668866487966955, 0.0052656766019976578, -0.12562510603385343, -0.024970842739258457, -0.030574039563531708, -0.21969881405226874, 0.59191387060782108, 0.39965780946904006, 0.22624763974293111, 0.077143781693831126, 0.078542516808501189, -0.0038697706067326258, 0.21858339549378, 0.083870133819846815, -0.19149929243694441, 0.053673315180545467, 0.22201073984886688, 0.16922848807595664, 0.12511007660405662, 0.095111634855384236, 0.084195395624058103, 0.010195208908487656, -0.016589123313681509, -0.076922699191606214, -0.17023093289451025, -0.26998035777525775, -0.28189859430096476, -0.32749231042729776, -0.240474927671948, -0.27714150491609907, -0.16857870511456344, -0.056310601502134704, 0.026291702225850644, -0.028508101274427284, -0.066307061790986485, -0.27187198211633473, 0.066219257946262391, 0.32825613521942065, -0.21303758386300781, 1.1917438602108388, 0.2807025357241521, 0.23447144426975483, 0.16511529097099151, 0.40113579910945835, 0.017152293761210982, -0.1450564820739392, 0.13833755803781553, 0.2361453534315919, 0.16033553043559276, 0.17442784770871, 0.17988585089228476, 0.143828955260344, 0.07132752932041192, 0.016244981011210025, -0.013577696292888701, -0.024045478766089354, -0.11184718959298219, -0.14666574805211069, 0.0080876817899727359, -0.16842937423863127, -0.43543489379944889, -0.29975286851709859, -0.22753898297998879, -0.069036032916579657, 0.014977564920406507, -0.020420877906038481, -0.13524198281736244, -0.15739380447541659, -0.33401260934309918, 0.46815371603113554, 0.93021729768322625, -0.26733338229185055, 1.4166629302294091, 0.60664479608939625, 0.3603810860087503, 0.4605515924213614, -0.32071019427276837, 0.15916183580862947, 0.55142162929110317, 0.20419289205444074, 0.051921880744650394, 0.24679565757292954, 0.2706202610478356, 0.15590400545853877, 0.081859441051199647, -0.040980231107277158, 0.019596242113331462, 0.094364427919773758, 0.065278519802775978, -0.029838116901178446, 0.15435464918439099, -0.039386655944161249, -0.077796406016204619, -0.28158476919608044, -0.033110128022724852, 0.018548614200940845, 0.067046107651037731, -0.044245201781535203, -0.1525534131110006, -0.22929077462390082, -0.085302710712388263, -0.049302393683332231, 0.85744368463127818, 1.8448220136861364, -0.68744556831975012, 1.810880881855317, 0.66237039703709566, -0.31567909429421087, 0.83232217907475781, 0.97863365922997991, 0.30994126117364096, -0.041163173314528664, 0.17633262873947353, 0.23161854928102976, 0.25087704366702551, 0.19868696729956423, 0.093569887694449877, 0.032362324442922322, -0.0027507666136337679, 0.21821986304703905, 0.37880734420129814, 0.40096920495374666, 0.93561154193066887, 0.61326039955329958, 0.1638528799494483, 0.1009541629695858, 0.056601591846233243, 0.15561323638878471, 0.073000292812971587, -0.0055442453146915694, -0.13817032242271102, -0.11770539535407684, -0.096245457278447424, 0.46442894125096079, 0.45587938373772585, 1.3432089992982477, 2.5059762271849535, -0.93829697639874887, 0.6492144586928863, 0.79782532034480069, 1.3025551528258366, 0.94174974100732234, 0.099921469659734793, 0.28712786266920659, 0.15853680079243379, 0.130717335778855, 0.17042917695126153, 0.19986443324539621, 0.13725228360851915, 0.029723534135295476, 0.098143635338702864, 0.19047751491127032, 0.49335337973435212, 0.78089304412099847, 0.29686587428828037, 0.38131881367791126, 0.40643673652514922, 0.19053499830856688, 0.20033550195294633, 0.13287714582076576, 0.10533560171090586, 0.00085487897815388243, -0.049435296406267468, -0.081309411554979491, 0.057947716710403128, 0.48207744089263116, 1.2538880645112733, 1.2204758332556214, 0.87793863876625744, 1.8796293205435075, -0.45285576127696725, 2.2308682152547137, 1.2382711063757557, -0.035207936995945072, 0.88175672278306683, 0.55916031961657942, 0.18718127547628777, 0.011764673252274449, 0.068747006595272581, 0.13522321325294812, 0.17151312046437606, 0.10315365060575944, -0.0011239413451798732, 0.14993420590829387, 0.38959110228082239, 0.38845862264410469, 0.69716730182732189, 0.51802064393501412, 0.28837767001488912, 0.10583936790249669, 0.071016615670210698, 0.16001776032454934, 0.10715662619027419, 0.056188716759532117, -0.035825840155044517, 0.0061469917968111389, 0.089493877843564718, 0.68387295014825999, 1.1016519558168656, 1.3182383587355595, 0.66635382040153524, 0.54863673632097221, 4.0547770231048936, 0.54863673632097154, 0.66635382040153424, 1.3182383587355562, 1.101651955816866, 0.68387295014826144, 0.089493877843565064, 0.0061469917968106288, -0.035825840155044517, 0.056188716759530431, 0.10715662619027334, 0.16001776032454856, 0.071016615670210018, 0.10583936790249539, 0.28837767001488829, 0.51802064393501346, 0.29686587428830957, 0.38845862264412201, 0.38959110228084654, 0.14993420590831108, -0.001123941345177488, 0.10315365060576374, 0.17151312046437922, 0.13522321325295103, 0.068747006595273552, 0.011764673252275867, 0.18718127547628682, 0.55916031961657786, 0.88175672278306205, -0.035207936995944634, 1.2382711063757532, 2.2308682152547106, -0.45285576127696175, 1.8796293205435037, 0.87793863876625788, 1.2204758332556218, 1.2538880645112747, 0.48207744089263271, 0.057947716710405182, -0.081309411554979547, -0.04943529640626837, 0.0008548789781495917, 0.10533560171090255, 0.13287714582076099, 0.20033550195294705, 0.19053499830855697, 0.40643673652513423, 0.38131881367792647, 0.93561154193068807, 0.78089304412102711, 0.49335337973436416, 0.19047751491127579, 0.098143635338704696, 0.029723534135297252, 0.13725228360851988, 0.19986443324539666, 0.17042917695126267, 0.13071733577885625, 0.15853680079243432, 0.28712786266920415, 0.099921469659732226, 0.94174974100731712, 1.3025551528258328, 0.79782532034480169, 0.64921445869288619, -0.93829697639874454, 2.5059762271849548, 1.3432089992982421, 0.45587938373772335, 0.46442894125096235, -0.096245457278447175, -0.11770539535407766, -0.13817032242271216, -0.0055442453146945193, 0.073000292812969436, 0.15561323638878341, 0.056601591846233208, 0.10095416296958591, 0.16385287994945555, 0.61326039955330602, 0.15435464918440814, 0.40096920495376004, 0.37880734420131523, 0.21821986304704899, -0.0027507666136306606, 0.032362324442924542, 0.093569887694449336, 0.19868696729956342, 0.25087704366702551, 0.23161854928103059, 0.17633262873947425, -0.041163173314526666, 0.30994126117363635, 0.97863365922997669, 0.83232217907475781, -0.31567909429421592, 0.66237039703709699, 1.810880881855315, -0.68744556831974835, 1.8448220136861369, 0.85744368463127729, -0.049302393683329601, -0.085302710712388291, -0.22929077462390179, -0.15255341311100187, -0.044245201781539331, 0.067046107651035594, 0.018548614200940294, -0.033110128022720509, -0.28158476919607578, -0.077796406016200054, -0.039386655944146774, 0.0080876817899761342, -0.029838116901173162, 0.065278519802780599, 0.09436442791977824, 0.019596242113334855, -0.040980231107276652, 0.08185944105119855, 0.15590400545853553, 0.2706202610478356, 0.24679565757292907, 0.051921880744651677, 0.20419289205443947, 0.55142162929109917, 0.15916183580862936, -0.32071019427277109, 0.46055159242136157, 0.36038108600874996, 0.60664479608939803, 1.4166629302294049, -0.2673333822918505, 0.93021729768322625, 0.46815371603113448, -0.3340126093430979, -0.15739380447541709, -0.13524198281736302, -0.020420877906040739, 0.014977564920405115, -0.069036032916578546, -0.22753898297998629, -0.29975286851709465, -0.43543489379944272, -0.16842937423862725, -0.28189859430095965, -0.14666574805210519, -0.1118471895929717, -0.024045478766081197, -0.013577696292883971, 0.016244981011212731, 0.071327529320409616, 0.14382895526034015, 0.1798858508922834, 0.17442784770871067, 0.16033553043559218, 0.23614535343159299, 0.13833755803781575, -0.14505648207394348, 0.017152293761212339, 0.40113579910946001, 0.16511529097099317, 0.23447144426975502, 0.28070253572415382, 1.1917438602108381, -0.21303758386300692, 0.32825613521942509, 0.066219257946262128, -0.27187198211633529, -0.066307061790987387, -0.028508101274429792, 0.026291702225849072, -0.056310601502134003, -0.1685787051145608, -0.27714150491609657, -0.24047492767194564, -0.32749231042729471, -0.19087946198724157, -0.26998035777525148, -0.17023093289450597, -0.076922699191602426, -0.016589123313677224, 0.01019520890848913, 0.084195395624057118, 0.095111634855381461, 0.12511007660405613, 0.1692284880759545, 0.22201073984886613, 0.053673315180547035, -0.19149929243694658, 0.083870133819847037, 0.21858339549377928, -0.0038697706067313737, 0.078542516808500606, 0.077143781693833222, 0.22624763974292969, 0.39965780946904111, 0.59191387060782175, -0.21969881405226852, -0.030574039563530501, -0.024970842739259945, -0.12562510603385371, 0.0052656766019967011, 0.015668866487966397, -0.038455609721168606, -0.079832857077626357, -0.11787169168831266, -0.15843188266072725, -0.092430559387194119, -0.25571779361731145, -0.33418602947193976, -0.37577894082796842, -0.17872521900892277, 0.025599835220983438, 0.036868954773614897, 0.063153633523536298, 0.064624059271844544, 0.12129220423951372, 0.1612208867083402, 0.13054366560393141, -0.0031358189183775171, -0.060276976551199596, 0.076248151019351354, -0.038784831650455917, 0.041725616486585258, -0.20186945117744698, 0.043591964044126186, 0.23914223921470992, 0.34013467279608772, 0.23157078159613964, 0.20755848067860685, -0.22107962950770196, -0.1025286187683216, 0.035725424097318138, -0.079299771847393549, 0.065331700319185088, -0.034956034554288036, -0.074021765277385243, -0.074018947274086908, -0.10375533557573537, -0.15489773108592672, -0.5463269466436349, -0.64123409592876401, -0.64559475523542686, -0.44280324831238616, 0.018445471788017767, 0.089840998861510313, 0.050489672984820259, 0.10094403852683856, 0.15540921558269635, 0.13542751998114574, 0.092098221631536192, 0.04873056181166658, 0.056474422402955825, -0.033352938195949811, -0.016925686434957218, -0.083060383383990535, -0.060406846903667433, -0.1226120784542102, 0.13458393481660744, 0.19090693911120402, 0.22215018549405383, 0.024793140061198739, 0.038718783333861403, -0.20853401810086775, -0.069635302172998029, 0.1064335953821621, -0.053345012614191917, 0.0099230741314936706, -0.15252816280103507, -0.18245346577017069, -0.29185933229148298, -0.3773223176299495, -0.94040577953315341, -1.0754357146022915, -1.1705860882999222, -0.77145898274834734, -0.079342592710004489, 0.05674840331570382, 0.14324588543960787, 0.12965098836906794, 0.14996801038078103, 0.10954302373131049, 0.12781279786870486, 0.11239290885891398, 0.0020423415177517252, -0.086381624051941733, -0.13062315548602732, -0.036665364495841957, -0.14926486203867201, -0.034593273427634852, 0.012219595757109143, 0.18300384413447635, 0.1958340625177715, 0.044601471225384402, -0.08740484292179726, -0.041369287190262873, -0.21341675767851565, -0.065677188177906895, 0.24144356597505726, -0.36750971454912684, -0.40026408654081164, -0.66562411016509171, -0.77336416928590557, -0.83899416480020206, -1.3372642957080858, -1.5719273509294132, -1.8005308506197781, -1.5408513794669076, -0.5531644985020383, 0.35609170613711127, 0.4116145942481696, 0.13448891283084041, 0.092477162456604783, 0.15737574769334561, 0.17138075095211283, 0.13259733500476581, 0.033522350558872378, -0.13112027137759125, -0.13478379984035713, -0.23416130311702804, -0.17379580132236419, -0.18974789333555622, 0.16649953505637016, 0.21963323601338522, 0.28775437300883855, 0.013318329293152468, -0.059449722211754409, -0.21633114300735917, 0.077936325689886982, -0.23415549346577649, -0.18415548289109335, -0.2220604628402971, -1.203289777252857, -1.2269479805895944, -1.3731553217305832, -1.2989780551182524, -1.64116294353798, -1.9821307035675826, -2.4053777736536572, -2.4259185480628087, -1.4297091333258454, -0.020800703185307738, 0.44907296092364196, 0.1858384756397643, 0.16308782299108818, 0.18780650312631128, 0.16876214929227229, 0.15032501459981898, 0.020281061259495404, -0.0073538013157964212, -0.13702193484548603, -0.059120611570979247, -0.18176695609293375, -0.10265025207047287, -0.00066962538216844151, 0.36158774196732713, 0.23695911940697681, 0.13767875532837892, -0.097481704015832935, -0.1639311930895031, -0.2137091594940832, 0.3107157406422304, -0.63196711118812665, -1.2839600483166249, -1.5107274159689543, -2.0001525985045667, -1.8007661961299211, -1.5766976273496909, -1.557678973082544, -2.4077419089431698, -2.9212825837849552, -3.1544891598954266, -2.0740660744196822, -0.81459993031793032, -0.047691255584086843, 0.26053579199245114, 0.24817234249560396, 0.16271946063708537, 0.1524538089963024, 0.12402459410134949, -0.017228379259870755, -0.059581713131428661, -0.15954900238017725, -0.17203834043004781, -0.03585192275390215, -0.13566388733867182, 0.18529272549107739, 0.32789481378377766, 0.46505832474821029, 0.14493915164048596, -0.068344938706060163, -0.20692971953005135, -0.13321306237600447, -0.22642518078961474, -0.16864865516591712, -1.9309474679838514, -2.6427456963680735, -2.0042907354579094, -2.0679079684570931, -1.6478932560447959, -2.2937692343725686, -2.7282977589825266, -3.4150761242194196, -3.3782856809989692, -2.2222759116849189, -1.2352596784322352, 0.12380717441380877, 0.15120100371873849, 0.22205496825803597, 0.13376820638889372, 0.16581598470153905, 0.21189843131890046, 0.1205613668903118, -0.11944152964360859, -0.2844407665876833, -0.38089709050886922, -0.1254790861941803, -0.12552132795948226, -0.087366382764606329, 0.2312435028685467, 0.42806542968274885, 0.31289505893871633, -0.016555865669298363, -0.15232124758199445, -0.18026213329416074, -0.054197237250036744, -0.92650772032563145, -1.6748432066634964, -1.9667941627002861, -2.2073957813815404, -1.3988308931230464, -2.1872173045798968, -1.7701160974209202, -2.3995834975192563, -3.1079150257531603, -2.2759627738397428, -1.9867837341406698, -1.1991385138433992, 0.25261423619714135, -0.086883949036943853, 0.13841341497021575, -0.013991851319408978, 0.15451076629740176, 0.20777584924549833, 0.37732986906226257, -0.1983231816223982, -0.064701320250050057, -0.75809939060751286, -0.0056552094670687921, -1.0666730319382445, 0.5168021952817432, -0.059867579479421881, 0.57704911017089144, 0.073612585805408248, 0.16986402710259826, -0.27685168579682035, 0.23610433796619823, -0.25969657852055217, -0.34105804260323408, -2.3692424085383355, -0.13683987631719494, -0.60631225487832385, -3.0428213499062093, -1.4302518240108333, -1.0960340088024054, 0.33378719268138207, -1.462532482812221, -1.1311602269894572, -0.42160647485916913, -0.77282398113385165, 0.051358135035689895, -0.12451483496808054, 0.074560604448017945, -0.071400263514198398, 0.12710467168208478, 0.20183473326046905, 0.53582170174408328, -0.31918913661037829, 0.028167647498415164, -0.49375784053277538, -0.67155961060436897, -0.79896724757297555, -0.015611524439376389, 0.074148205591898927, 0.44602122877613765, 0.17221102955705844, 0.070854449837212188, -0.07178740615442418, 0.043350794355038948, 0.23127204626685866, -0.49437187443974595, -1.3068505835636535, -0.50505328014021666, -0.55162352804951942, -2.4095702665388461, -1.9119199452512292], "bottom": {"real": [4046.4241509904555, 28839.973879370627, 10191.512031448321, 4381.7455807293263, 2071.9548413915022, 1107.2825867454831, 528.34551553150311, 308.97330299730402, 185.81061014820492, 130.08108126519062, 87.65365496956511, 59.09553675383809, 43.506269455848397, 34.575222311681692, 30.798097452905282, 25.523061346781674, 25.951646714603154, 25.523061346781589, 30.798097452905211, 34.575222311681706, 43.506269455848361, 59.095536753838019, 87.653654969565167, 130.08108126519082, 185.81061014820492, 308.97330299730379, 528.34551553150334, 1107.2825867454833, 2071.9548413915031, 4381.7455807293318, 10191.512031448323, 28839.973879370646, 13493.224333003216, 16392.519951456161, 4871.8353885075767, 1571.3337493887716, 567.64096645153529, 373.6703632325283, 244.24660034041102, 142.79597933554817, 106.13580676907658, 75.858347622710525, 58.061322564190078, 39.854538473021549, 30.569538051408923, 25.094853941398878, 22.929757321982656, 20.808198660555963, 22.04888812794956, 23.622937534136554, 29.138683151168021, 38.082981074479143, 54.39934218587819, 77.826621492011839, 121.61239162949131, 177.63416429867098, 254.30481783551838, 430.47940336338183, 664.63525809030591, 1219.8477670929726, 1935.5749815900854, 3358.0980991141623, 6069.2175916916049, 8660.7039291701622, 15384.540019848313, 11175.737303494303, 2216.879483433469, 674.59859086304846, 308.57630937597452, 222.13525013253278, 144.62539946693838, 89.351789047349641, 66.200283784031811, 53.5880480094322, 38.104835124660447, 27.112718944065261, 23.033311632510099, 19.858863545618888, 19.408029208714364, 19.38215160767772, 20.871711217553681, 24.726583224259915, 29.429525390428484, 39.688247321389746, 54.026677368666491, 71.509189516532359, 109.7023701375058, 145.30501493896827, 183.84765943176359, 237.38092500065588, 353.51632607639505, 531.27032729465725, 719.17065363709912, 1367.9024800373177, 2857.7322293344778, 8625.0149751320059, 3926.8611003464521, 2444.3527388912776, 1028.8359899085383, 585.56166554295623, 332.57137935864864, 180.13762334769046, 105.17011934648103, 61.496465220623485, 45.504823244138095, 37.908460172493172, 30.846794326525625, 21.222093075405745, 18.718288087401802, 17.679602313216872, 17.409839934721365, 17.794391783727544, 18.55926931620083, 21.348409581307148, 24.39997962145603, 30.767061622228063, 38.103008129659166, 44.81251118779231, 61.577721983396955, 87.291485884508717, 106.99539363556599, 134.18057082099898, 169.37440787587974, 269.99443977661724, 364.56248799144709, 674.50839546082307, 1521.022929703357, 2634.7343778883865, 2024.849011267275, 1926.8239401023498, 1491.9478410044117, 611.83627918833088, 316.43682665588744, 155.99683828976544, 89.673379864750018, 50.013293885425135, 37.528009707176061, 32.4518569290627, 24.966146703509182, 19.130394004010906, 15.343856356149828, 14.843145659919786, 14.861292517540363, 15.036681247518919, 15.312687438440403, 17.138709070816013, 19.446116741695533, 22.850207518010233, 27.457440287528367, 32.581505308308088, 40.985078317877736, 54.412823137373685, 75.762437644265901, 94.733059346587339, 128.1467358253355, 182.29010502256293, 275.95498073034861, 527.32695578494008, 1132.5867520786235, 1866.4077869841046, 2266.7457843108455, 2107.8495169895441, 1234.6592459623437, 673.70954283481137, 266.6693703142779, 139.47307538222793, 66.730731113314476, 41.917980917088734, 31.2590211502941, 26.786032891522527, 20.35627716260823, 16.038244917569745, 14.499148814332527, 13.459360575928033, 13.144389071570192, 12.567429683418663, 12.230328765246885, 13.466217665828195, 15.328301760046475, 17.144679989146308, 19.68756841312236, 24.074134044705339, 32.727034612286992, 43.026808431859955, 59.193773906230369, 78.820512563030945, 92.994178544706472, 120.42091176843755, 201.9182636225097, 436.44287859172925, 877.8862778005057, 1439.6385876846614, 1649.9911393469049, 1699.4038415062987, 1039.2560892520887, 495.51661529689329, 235.81544665938515, 113.58561083280532, 60.921551746622946, 35.725757089786256, 25.024628727892466, 22.490208420088727, 17.759823791920191, 13.543616943986416, 12.938917306264663, 11.956364952724385, 11.421939705679733, 11.372903592178258, 11.032765269291394, 11.408229662647633, 12.481114469594095, 13.60275540468532, 14.91952183557448, 17.807798659576154, 23.277252196336814, 31.950664619854233, 47.416694920263616, 56.268912844615144, 64.959626427586997, 85.070809539003847, 130.82046704446515, 257.67571935262418, 627.46721263291658, 1194.1693767483914, 1080.1900960853154, 902.674413704009, 600.04055794738224, 333.23520458041997, 166.5653831933532, 88.946305547571072, 50.717393232745131, 31.897215329939996, 23.060146944216118, 18.579780562544169, 15.572760511446054, 13.273777678692191, 12.224913053368416, 11.68638594982613, 10.392044527527784, 10.422646713468026, 10.113778554702394, 10.225072497047023, 10.776357928238541, 11.471833692521193, 12.585855785544721, 15.131216045563061, 18.856673404562432, 24.858220592568422, 32.657280802203381, 43.037987696240307, 51.536289299313914, 59.08796022590117, 89.418846636419246, 168.44781050782811, 382.14409608709747, 745.27797642375992, 544.93523795856049, 546.63255943550212, 362.69938393816085, 222.4530875664997, 124.78354764285341, 69.155510455436144, 41.705006957506896, 26.952419331651356, 19.778555411511121, 17.743475715717917, 14.471795156401063, 12.765457059373892, 11.899864411981882, 10.85818004844373, 10.325708895539952, 9.5692719745256376, 9.2113480820863387, 9.0680329970290128, 9.7734432560375648, 10.488284402310196, 11.323197140674811, 13.23504887223821, 16.674941080314653, 20.771526297093455, 27.569417818570489, 33.103068481604573, 37.131609415223707, 47.964760430736398, 66.578817507603574, 119.94841754808802, 237.18123750436465, 409.50889944188236, 307.01018353832677, 288.66760291638428, 236.16368190120858, 154.32114106589464, 92.303773245695481, 55.468009578938926, 35.843010431224045, 24.692475316947775, 18.31794202383119, 15.815283825259236, 13.970653175227845, 12.321358605090134, 11.166914874614415, 10.532076178141539, 9.9738582700772742, 9.4395532322934326, 8.8524779931517035, 8.5960325163902862, 8.7233150994257276, 9.4605465058702709, 10.702831587760128, 11.695932356823622, 14.406509159208545, 18.893042693096525, 25.031728162044864, 28.237283751764654, 32.110154440123182, 38.781782989560291, 56.412497176172337, 92.156945934839797, 157.10935603874077, 244.24925081430641, 218.20881258539546, 216.90433976724358, 169.13695858014356, 112.62100758585845, 68.70530790516959, 45.982361360241526, 32.725373555898344, 22.221572369125827, 17.135020014783734, 14.281960328360523, 12.699315839076576, 11.637118060780567, 11.004832210877884, 10.393382355075936, 9.6259602166533789, 8.7652013845999868, 8.5650120282362092, 8.5854476517741869, 8.1851518687531879, 9.1270872628576836, 9.8383977040140795, 11.693775785132257, 13.287947209975439, 16.544820171465705, 21.672488061489553, 27.762087103200397, 29.796933806391767, 35.443188490268959, 51.826480475596476, 76.692136618774384, 114.45554660359461, 172.81330831382385, 150.57608076172548, 151.07347077509746, 119.80060075739978, 84.307080896770614, 55.59442395215062, 38.954469932130465, 27.855857296119165, 21.147383956632677, 16.095362427853317, 14.114901096214023, 12.272097096384341, 11.279235865220194, 10.45557624282722, 10.213403723979409, 9.4352540004127672, 9.059591562681522, 8.4285767722705884, 8.2189676916739653, 8.2483207838968369, 8.7272133851807343, 9.3853417746714207, 10.436988631508529, 11.737372360714012, 14.160123000210135, 18.959579242189701, 24.173697545434358, 27.627516713161423, 33.591531685669004, 45.297439984936638, 65.897539497304663, 88.610944521286385, 122.51594786973793, 102.9717174324289, 99.771144171631136, 80.254636450195903, 61.009511746666256, 44.786912913807178, 34.271024500323179, 25.65851527359349, 19.184194785168692, 15.369946764821139, 13.384363033613122, 12.174478369218367, 10.905903566261369, 10.181651684644681, 9.6408755952533021, 9.5742304532973588, 8.9763308722412098, 8.5493032688069821, 8.0644484764315241, 8.4276865988342919, 8.7290963397981098, 9.1210926884309647, 10.045472592156113, 11.11042960636143, 12.723025686618605, 15.905816263070196, 20.709491045732211, 24.791931496783274, 30.865414152401307, 41.835714185623189, 55.039237230593706, 69.947250962386548, 86.305656954166849, 70.246077416654487, 70.163190967731239, 60.941585457354833, 46.988681551588527, 37.426824229947464, 31.105114654781531, 24.717957509432271, 18.191253220796238, 14.40571246916225, 12.794837539520243, 11.45286867499644, 10.555233980671725, 10.138595490186225, 9.7617939326440126, 9.2945114067021706, 9.1978519570897408, 8.5269704682665068, 8.3694986947733589, 8.3900850601209847, 8.9019780110016278, 9.4993224051697176, 10.189344774081897, 11.038776504531349, 12.139382952337165, 14.296273465828305, 18.325479810549485, 23.245126565071455, 28.658675517780157, 38.227879918404916, 50.026933715114076, 59.913478880080035, 67.142884728350211, 60.673200962744687, 56.006191670589025, 48.952383807337931, 41.877289900824969, 35.563752651142892, 29.381802508508265, 23.323351055229473, 18.385352146785323, 14.386074460433269, 11.971768024825069, 10.813949701229296, 10.104265892334448, 9.7873837360525968, 9.7876450182420029, 9.3736570608881902, 9.1067837514303367, 8.8782742568475381, 8.4108604655156682, 8.5145291911969032, 9.1444638633789328, 9.5903687569174956, 10.050972673200409, 10.599176866339214, 12.029252308933458, 13.885440808202775, 16.933840539652099, 20.949767453800131, 27.392670445772911, 35.246945811604022, 44.844494652773115, 53.527920120533459, 59.511906457614529, 53.048047546158344, 49.667902591204928, 45.161821768091436, 39.040569237963304, 34.153498370766542, 28.812200326236947, 21.915204963295363, 16.825291542921018, 14.194481006765461, 11.707465544074312, 10.438485210613589, 9.8151245648739263, 9.283134914271356, 9.0821420578250009, 9.0470505359514384, 9.0924089982219396, 8.8466944313913523, 8.4735939062643375, 8.4980702515250215, 9.0113445722107848, 9.2898710387292809, 9.9575678866832327, 10.426127211956205, 11.223822839806607, 13.773251241827809, 16.688691177663944, 20.746301629724744, 26.320191080313084, 33.979868436578599, 42.0788988747152, 48.313306819757166, 52.481937610238305, 49.070609767594966, 49.766679020971374, 46.544272852318578, 40.229040805773415, 32.559839637781486, 26.180018982316895, 21.083604085221012, 16.97356072267355, 13.301411970448795, 11.264067238060504, 10.255581922596939, 9.6536213682112031, 9.2153774062964224, 8.7468110761182825, 8.4356542718375049, 8.7323846743622209, 8.8458599078381237, 8.7323846743622209, 8.4356542718375032, 8.7468110761182896, 9.2153774062964278, 9.653621368211212, 10.255581922596944, 11.264067238060512, 13.301411970448795, 16.973560722673543, 21.083604085221008, 26.180018982316881, 32.559839637781494, 40.22904080577338, 46.544272852318571, 49.766679020971331, 53.048047546158344, 52.481937610238198, 48.313306819757052, 42.0788988747152, 33.979868436578577, 26.320191080313087, 20.746301629724748, 16.688691177663959, 13.773251241827822, 11.22382283980661, 10.426127211956201, 9.9575678866832256, 9.2898710387292791, 9.0113445722107919, 8.4980702515250268, 8.4735939062643357, 8.8466944313913505, 9.0924089982219467, 9.0470505359514402, 9.0821420578250063, 9.2831349142713542, 9.815124564873928, 10.438485210613582, 11.707465544074319, 14.194481006765461, 16.825291542921001, 21.915204963295366, 28.81220032623694, 34.153498370766549, 39.040569237963282, 45.161821768091372, 49.667902591204999, 60.67320096274468, 59.511906457614572, 53.527920120533402, 44.844494652773072, 35.246945811604007, 27.392670445772925, 20.949767453800135, 16.933840539652095, 13.88544080820277, 12.029252308933453, 10.599176866339214, 10.0509726732004, 9.5903687569174885, 9.1444638633789328, 8.5145291911969103, 8.4108604655156718, 8.8782742568475346, 9.1067837514303385, 9.3736570608881848, 9.7876450182420012, 9.7873837360526021, 10.10426589233446, 10.813949701229305, 11.971768024825074, 14.386074460433273, 18.385352146785333, 23.323351055229466, 29.381802508508251, 35.563752651142877, 41.877289900824962, 48.952383807337874, 56.006191670588912, 70.246077416654288, 67.142884728350111, 59.913478880079964, 50.026933715114062, 38.227879918404923, 28.658675517780189, 23.24512656507147, 18.325479810549478, 14.296273465828305, 12.139382952337156, 11.038776504531354, 10.189344774081897, 9.4993224051697229, 8.9019780110016331, 8.3900850601209847, 8.3694986947733572, 8.5269704682665068, 9.197851957089739, 9.2945114067021635, 9.7617939326440144, 10.138595490186225, 10.555233980671725, 11.452868674996441, 12.794837539520238, 14.405712469162248, 18.191253220796249, 24.717957509432264, 31.105114654781534, 37.426824229947449, 46.988681551588492, 60.941585457354776, 70.163190967731154, 102.97171743242879, 86.305656954166807, 69.947250962386491, 55.039237230593784, 41.835714185623168, 30.865414152401325, 24.791931496783278, 20.709491045732214, 15.905816263070196, 12.723025686618604, 11.110429606361421, 10.045472592156107, 9.1210926884309735, 8.7290963397981116, 8.4276865988342937, 8.0644484764315258, 8.5493032688069821, 8.9763308722412134, 9.5742304532973623, 9.6408755952533056, 10.181651684644681, 10.905903566261369, 12.174478369218367, 13.384363033613125, 15.369946764821144, 19.184194785168689, 25.658515273593498, 34.271024500323144, 44.78691291380715, 61.009511746666178, 80.25463645019579, 99.771144171631008, 150.57608076172505, 122.51594786973776, 88.610944521286228, 65.897539497304635, 45.297439984936574, 33.591531685669025, 27.627516713161402, 24.173697545434354, 18.959579242189701, 14.160123000210131, 11.737372360714007, 10.436988631508525, 9.3853417746714172, 8.7272133851807325, 8.2483207838968262, 8.2189676916739689, 8.4285767722705902, 9.0595915626815202, 9.4352540004127654, 10.213403723979411, 10.455576242827226, 11.279235865220191, 12.272097096384336, 14.114901096214016, 16.095362427853331, 21.147383956632702, 27.855857296119162, 38.954469932130408, 55.594423952150585, 84.307080896770429, 119.80060075739968, 151.07347077509721, 218.20881258539524, 172.81330831382382, 114.45554660359451, 76.692136618774427, 51.826480475596433, 35.443188490268959, 29.796933806391745, 27.762087103200372, 21.672488061489549, 16.544820171465698, 13.287947209975444, 11.693775785132251, 9.8383977040140866, 9.1270872628576836, 8.1851518687531897, 8.5854476517741798, 8.5650120282362074, 8.7652013845999939, 9.6259602166533789, 10.393382355075921, 11.004832210877884, 11.637118060780562, 12.699315839076572, 14.281960328360505, 17.135020014783741, 22.221572369125806, 32.725373555898322, 45.982361360241477, 68.705307905169562, 112.62100758585837, 169.13695858014344, 216.90433976724287, 307.01018353832563, 244.24925081430612, 157.1093560387404, 92.156945934839754, 56.412497176172316, 38.781782989560298, 32.110154440123168, 28.237283751764654, 25.031728162044857, 18.893042693096504, 14.406509159208543, 11.695932356823613, 10.702831587760132, 9.4605465058702674, 8.7233150994257205, 8.5960325163902844, 8.8524779931517052, 9.4395532322934272, 9.9738582700772813, 10.53207617814155, 11.166914874614413, 12.321358605090143, 13.970653175227838, 15.815283825259229, 18.317942023831186, 24.692475316947778, 35.843010431224023, 55.468009578938812, 92.303773245695368, 154.32114106589427, 236.16368190120789, 288.66760291638354, 544.93523795856049, 409.50889944188282, 237.18123750436465, 119.9484175480882, 66.578817507603574, 47.964760430736455, 37.131609415223693, 33.103068481604559, 27.569417818570489, 20.771526297093434, 16.674941080314646, 13.235048872238199, 11.323197140674804, 10.488284402310184, 9.7734432560375648, 9.068032997029011, 9.2113480820863387, 9.5692719745256465, 10.325708895539957, 10.85818004844373, 11.899864411981884, 12.765457059373892, 14.471795156401072, 17.743475715717903, 19.778555411511121, 26.952419331651342, 41.705006957506882, 69.155510455435987, 124.78354764285341, 222.45308756649936, 362.69938393816079, 546.63255943550212, 1080.190096085312, 745.27797642375788, 382.14409608709587, 168.44781050782805, 89.418846636419218, 59.087960225901135, 51.536289299313893, 43.037987696240307, 32.657280802203374, 24.858220592568383, 18.8566734045624, 15.131216045563052, 12.585855785544725, 11.471833692521184, 10.776357928238532, 10.225072497047019, 10.113778554702403, 10.422646713468026, 10.39204452752778, 11.686385949826136, 12.224913053368411, 13.273777678692191, 15.572760511446033, 18.579780562544141, 23.060146944216122, 31.897215329939918, 50.717393232745025, 88.946305547570788, 166.56538319335294, 333.23520458041884, 600.04055794738088, 902.6744137040065, 1649.9911393469013, 1194.1693767483896, 627.46721263291568, 257.67571935262464, 130.82046704446515, 85.070809539003903, 64.95962642758694, 56.268912844615201, 47.416694920263595, 31.950664619854226, 23.277252196336782, 17.807798659576147, 14.919521835574468, 13.60275540468532, 12.481114469594081, 11.408229662647638, 11.032765269291394, 11.37290359217827, 11.421939705679749, 11.956364952724407, 12.938917306264656, 13.543616943986398, 17.759823791920141, 22.490208420088635, 25.024628727892473, 35.725757089786228, 60.92155174662291, 113.58561083280503, 235.81544665938503, 495.51661529689198, 1039.2560892520876, 1699.403841506296, 2266.7457843108423, 1439.6385876846614, 877.88627780050422, 436.44287859172971, 201.91826362250967, 120.42091176843758, 92.994178544706443, 78.820512563031016, 59.193773906230312, 43.026808431859891, 32.72703461228695, 24.074134044705318, 19.687568413122339, 17.144679989146301, 15.32830176004647, 13.466217665828177, 12.230328765246888, 12.567429683418707, 13.144389071570203, 13.459360575928054, 14.499148814332536, 16.038244917569731, 20.356277162608194, 26.786032891522385, 31.259021150294068, 41.917980917088691, 66.730731113314405, 139.47307538222745, 266.66937031427761, 673.70954283481024, 1234.659245962343, 2107.8495169895405, 2024.849011267276, 1866.4077869841062, 1132.5867520786235, 527.32695578494054, 275.9549807303485, 182.29010502256293, 128.14673582533564, 94.733059346587495, 75.762437644265887, 54.412823137373678, 40.985078317877729, 32.581505308308067, 27.457440287528364, 22.850207518010212, 19.446116741695526, 17.138709070816009, 15.312687438440404, 15.036681247518965, 14.861292517540395, 14.843145659919811, 15.343856356149836, 19.130394004010878, 24.966146703509185, 32.451856929062608, 37.528009707176075, 50.013293885425036, 89.673379864749862, 155.99683828976509, 316.43682665588739, 611.83627918833008, 1491.9478410044112, 1926.8239401023493, 3926.8611003464503, 2634.734377888386, 1521.0229297033557, 674.50839546082398, 364.56248799144686, 269.99443977661741, 169.37440787587963, 134.18057082099915, 106.99539363556599, 87.291485884508702, 61.577721983396906, 44.812511187792317, 38.103008129659166, 30.767061622228066, 24.399979621456033, 21.348409581307155, 18.55926931620083, 17.794391783727576, 17.409839934721397, 17.67960231321689, 18.718288087401788, 21.222093075405763, 30.846794326525586, 37.908460172493079, 45.504823244138095, 61.496465220623335, 105.17011934648093, 180.13762334768973, 332.57137935864853, 585.56166554295532, 1028.8359899085369, 2444.3527388912739, 15384.540019848309, 8625.0149751320096, 2857.732229334476, 1367.9024800373199, 719.17065363709889, 531.27032729465782, 353.51632607639499, 237.38092500065625, 183.84765943176362, 145.3050149389683, 109.70237013750581, 71.509189516532217, 54.026677368666469, 39.688247321389689, 29.429525390428473, 24.726583224260004, 20.871711217553678, 19.382151607677731, 19.408029208714364, 19.858863545618949, 23.033311632510113, 27.11271894406525, 38.10483512466044, 53.588048009431979, 66.200283784031811, 89.351789047349371, 144.62539946693829, 222.13525013253218, 308.57630937597452, 674.59859086304834, 2216.8794834334685, 11175.737303494294, 13493.224333003214, 8660.703929170164, 6069.217591691604, 3358.0980991141591, 1935.5749815900851, 1219.8477670929722, 664.63525809030602, 430.47940336338263, 254.30481783551838, 177.63416429867087, 121.61239162949126, 77.826621492011839, 54.399342185878204, 38.082981074479164, 29.138683151168006, 23.622937534136597, 22.04888812794956, 20.808198660555991, 22.92975732198266, 25.094853941398917, 30.569538051408909, 39.854538473021513, 58.061322564190043, 75.858347622710383, 106.13580676907651, 142.795979335548, 244.24660034041099, 373.67036323252819, 567.64096645153575, 1571.3337493887695, 4871.835388507573, 16392.519951456165], "imag": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0]}, "imag": [0.0, -1.343901621327011, 1.7218333249394571, 1.3937858919791224, -0.90478486773452105, 0.99560837280124848, 0.13374486301187097, 0.79781790598886937, 0.081235430122062774, 0.47338465820086184, -0.078534664439216209, 0.29500119331967589, -0.62479162763734286, 0.29517170974740459, -1.8712573358384692, 0.14096520515743682, 0.0, -0.14096520515741828, 1.8712573358384816, -0.29517170974737811, 0.62479162763733731, -0.29500119331966146, 0.078534664439223051, -0.47338465820085962, -0.081235430122062774, -0.79781790598886004, -0.13374486301187369, -0.99560837280124848, 0.90478486773452083, -1.3937858919791226, -1.7218333249394557, 1.3439016213270112, 1.5871307700950068, 0.56370110925886319, 1.2603198064423482, 2.9317402483699255, -0.84090846562801591, 0.28395441021550888, 1.0393523450590114, 0.83104911233799517, 0.57334259680943678, 0.30043904784975134, 0.29266755430531527, 0.082930104064024152, -0.36502835420313379, -0.76213554623438207, -0.54316838647957832, -0.66028179246101926, 0.20250391456576916, -0.059393044635645806, 0.9730252602081445, -0.01782962412134724, 0.18933865423621773, 0.011846708470834844, 0.014269719747672759, -0.16281560265463554, -0.24410560657714067, -0.34963232308526365, -0.32234943120999277, -0.6691127915152365, 0.14162995430492473, -0.96909874957635578, -1.0446282489208472, 1.3612809629252947, 0.70464907960903156, 1.644656498115789, 1.457626495523533, -0.6840361527612806, -0.68147470897196205, 0.73118573872942638, 1.2398159392319572, 1.2736175855463174, 0.65550663858936109, 0.45897332874861019, 0.24948129249627171, 0.22959418801218681, -0.67355449112520815, -0.78917379441405089, -0.83366315887398401, -0.022795944141155908, 0.15753196960053301, 0.50836195321582456, 0.16292155588892338, 0.14047533322536612, -0.029004083819245446, 0.042892010327960466, -0.084780328674450303, -0.13217055914433321, -0.30971168558439593, -0.44061350110378666, -0.59380988893293396, -0.46719027726302742, -1.2068396187631398, -0.94969408752542273, 0.28960616895899027, -0.40038203546320883, 0.55620249274438927, 0.14065731983379595, 1.390858139437829, -0.67833342052765033, -2.0926714021100303, 1.5120873610545131, 1.7251253398279642, 1.0499886203647506, 0.6413261932720733, 0.43315407205712014, 0.32584150801434064, 0.17968537990933128, -0.27887473465086693, -0.72646685328097149, -0.95200274282553721, -0.38747270801185796, 0.31172559850957127, 0.3167238274644899, 0.25925756638025876, 0.20404659434537992, 0.19201780058118942, 0.0025274006864131854, -0.20254250312507205, -0.30146681989018398, -0.45156398868756126, -0.71583959398165176, -0.78636343748881254, -1.3089140888320636, 0.41393919421363429, -0.92308378001125058, -0.96086768695066838, 0.99489496750979101, -0.39381772120025876, -0.59264738582705545, -1.1161873115341066, -0.38954314931717815, 0.15776662530084892, 0.39428020304678685, 1.7089894615168126, 0.92868491010646026, 0.350973234838865, 0.32125288047075679, 0.23669588269358602, 0.19592809956108717, -0.32646969875093118, -0.5617213523679232, -0.76596137582739887, -0.4848448097808058, 0.0035984972735877987, 0.36234031342999445, 0.02584515038201295, 0.38132345964413561, 0.29172235696712762, 0.10460468586389386, -0.14942504329756173, -0.23406484190568319, -0.59702583417138988, -0.64791716309340031, -1.1972380302487249, -0.37081056871520385, 0.31028937719203986, -0.11181138224479611, 0.050224150041196312, -0.59242819035998506, -0.4703174557375312, -0.55567065990801068, -0.18073895078348806, -0.07286620180284567, 0.9080135456055427, 1.3448759333642528, 0.56391746646770735, 0.68824563709365816, 0.27054447491545203, 0.18555506064923469, 0.21628766080629094, 0.089227696371118645, -0.1330464412169812, -0.51044075389216448, -0.57482956329522528, -0.49992842173388902, -0.0088882269741786465, -0.026119953804469152, 0.16649307508904443, 0.18021017930701566, 0.24129551707937363, 0.051414766220490717, -0.054409237913703348, -0.21354052285348152, -0.34065461819243753, -0.83215952955458006, -0.65455151443418824, -0.51711748874533736, -0.34193161983249143, 0.25991967791421511, -0.31922838969311168, -0.25096233231074472, -0.019538834540300996, 0.23386297177233037, 0.39736821511961345, 0.72603823847118543, 0.8168297825020705, 1.0763583447726135, 0.80611388127401196, -0.023349196100613815, 0.09911450222934183, 0.11136104528246665, 0.11912886110102348, 0.1510441091194204, -0.10294245821664937, -0.34339582552474845, -0.46071517851602106, -0.27454988477746128, -0.021291149638310566, 0.035818571775215378, 0.08165077597052256, 0.19593247304969552, 0.16021249355536668, 0.073411101811457824, -0.094413661460628892, -0.14774431296435828, -0.3788677957633147, -0.38953231590523063, -0.62892221563014938, -0.80219655994233319, 0.19764870263775744, -0.28620163890053252, 0.041738811618785537, -0.047502831671303453, 0.42759360787810174, 0.44353340330745888, 0.61232760985457502, 0.70207820166905466, 0.72192603666395361, 0.63928791416871467, 0.32589261306510392, 0.17268517789923485, -0.11832252230060911, 0.049391580905339259, 0.12347320818582375, 0.064697981434016727, -0.0067102091687047593, -0.27370819742589092, -0.26939466873920287, -0.25176222060998998, 0.0081310228529853402, 0.013089808045657288, 0.185105158015618, 0.11713478908555769, 0.20974664985683705, 0.048745778368168922, -0.0069359534603168627, -0.18083894269546222, -0.15907734702039189, -0.30490326972545728, -0.49525043110711681, -0.20633977154543071, -0.28929558460304977, 0.017255660868048289, 0.089250558912840242, 0.34349774583430781, 0.38277205043588519, 0.56772102070325814, 0.48811475177501612, 0.43659704639067964, 0.38858095560717315, 0.35469216713625445, 0.11095078972724678, -0.050354098986562471, 0.010426074631633324, -0.023032548262322892, 0.068558023511485697, 0.1199625535177883, -0.0044347552049944488, -0.14323623171577524, -0.2742488887234425, -0.15059247824174998, -0.18695930341705305, 0.068136880204083733, 0.049162011568203073, 0.16362595169702937, 0.078325720975578078, 0.11153460033842358, -0.10346450949096449, -0.039250261082814021, -0.12027128091306288, -0.23113762225192683, -0.07885965728132803, -0.25982980909746989, -0.11219308206942701, -0.19372413199270677, 0.1843821378255476, 0.22544536191476028, 0.22838873802709003, 0.11856768480607156, 0.20011010622694389, 0.16443500436191505, 0.13441036107213369, 0.15600995797323181, 0.029984980792926118, -0.017950425588896139, -0.095997178609832007, 0.045815559155676679, 0.050600401411128038, 0.062555070152262096, 0.095362679574156284, -0.25884721081868178, -0.19352665675464722, -0.35758313393883445, 0.057241994101256972, -0.074489797691212556, 0.15760636776309309, 0.077110294424560424, 0.21793581355625327, -0.085384156728057797, 0.054278095118519401, -0.063513516552257218, -0.13925876777247995, -0.053090482149624127, -0.088550664314818353, 0.097053178020475875, 0.021982682491266895, -0.032057043772553598, 0.011606155190390474, 0.20297398899260674, 0.087137707937781944, 0.14235450986309658, -0.0066344290522644652, 0.069443551113326479, 0.037974760198136455, 0.02723212012252952, -0.030406089689394462, -0.062891439826322393, -0.033462702565164315, -0.13091343010011852, 0.18662643567548856, 0.14580799486104234, -0.055902479292620696, -0.12813917376287484, -0.43706544906097528, -0.097926711565598012, -0.17130544619864244, 0.30727693305691806, -0.2953735036217468, 0.22056405751825581, -0.16529753202987246, 0.34047455883436423, -0.0020829156573361745, -0.14775664020163451, -0.074518551996532553, -0.14850320507536691, -0.057283952975165524, 0.064665418468806371, 0.23511892751228192, 0.11870789775778592, 0.0625549454189092, -0.031298024311669038, 0.0064402102662661845, -0.079082063664820082, 0.0553675188881671, 0.025089334126077875, 0.063800091749494747, 0.015988824093570549, -0.048545356942180602, -0.11558972094679192, -0.097487343329346582, -0.00049492928166827938, -0.18157168721539482, 0.33942288969170681, 0.30522386319855388, -0.54639589537101751, 0.013830571830100688, -0.38850732372171304, 0.223075916963486, -0.31865288748874443, 0.25745374979707547, -0.81885347149607268, 0.50855168910609783, 0.20195166784419227, -0.069785743671890318, 0.050884179954965268, -0.18377202523753672, -0.17303565260659334, -0.15924096907201105, 0.092146932205194695, 0.26379835890783954, 0.35934781180257075, 0.24329566614587647, 0.18564601960109514, 0.24223475523068938, 0.28967646870392649, 0.15967526911861643, 0.22365254766781259, 0.12185893624650075, 0.070105150765122456, -0.045495054958742086, -0.13016925945874308, -0.12331107551299306, -0.096585989040329473, 0.22919036999990153, -0.39865574246315477, 0.3675558227752026, 0.45597314967635888, -0.93227329954448013, 0.32110784375924512, -0.59160024067907024, 0.39469180639349893, -1.5810043928614619, 0.71926168426275527, -0.095920343398476549, -0.084877145937512208, 0.40399573862898452, -0.041743397742653787, -0.10303861084867461, -0.21220001866353477, -0.17318676777643013, 0.015792824133968684, 0.37994714934071439, 0.4573031649737595, 0.48491463219236358, 0.278045596991639, 0.33099751793182702, 0.073461819418744675, 0.30445717300203839, 0.34815332433352569, 0.27336662525128713, 0.050113511094951838, -0.059405844632707393, -0.16261143474742229, -0.10891422081227681, -0.075070297171157971, 0.15348950297637756, 0.63132994551184463, -0.93604459898777692, 0.42325697055405742, 1.1782712312395338, -1.6700526640562563, 0.67307548012867768, -2.0365876460209691, 0.69665186973993298, -0.3990336398782886, -0.77751104168880314, 0.5628167675812451, 0.044468991083659551, 0.081278132745909976, -0.070993394358423723, -0.091852860366211056, -0.10956166698887557, 0.072941493094735049, 0.35167328896657912, 0.63488067579895824, 0.56199684605205058, 0.60627707274502263, -0.018970197624819329, 0.37668655809680845, 0.22317003729918369, 0.17596357423928666, 0.18202109891962201, 0.038230887694388455, -0.10475039750351335, -0.15123171993121909, -0.11278544639649389, 0.054110895720760221, 0.23852479976301316, 0.30802887330694756, 0.9587111952302938, -1.4503952980081434, -0.061458391503499687, 2.1389978076683529, -3.5142346308062073, 1.6764175122847729, -0.63252660757872936, -1.1970497991660358, 0.46027494328631885, -0.38868529039399474, 0.063066133758830412, 0.085024034480974467, 0.047630852690686495, -0.022775175196356016, 0.011847923870825085, 0.13095780969018636, 0.39870906011464996, 0.54100133271840178, 0.62859642257501991, 0.12859489098386362, -0.17371304193339687, -0.77135662792152559, -0.35696964892202537, -0.15350152251372465, -0.081108427029901481, -0.12890403553126065, -0.14048874638904316, -0.18368108831833277, -0.13143015225876853, 0.037318187986402011, 0.39815350666418903, 0.44685069559938601, 0.29854169122462937, 1.0193515924216456, -2.1696976832709978, -1.5476694374721527, 4.1115013597100623, -1.6066056279080296, -1.1129988398741206, 0.94641351902713078, -0.66464487182371434, -0.22405122030787003, -0.16845135046504239, 0.10281428632219461, 0.12776142939872864, 0.10903691838775739, 0.097477148948306502, 0.19622512970077355, 0.37581890109000032, 0.58152174984392169, 0.57588244896775898, 0.56835821427965394, 0.0, -0.075660591040101741, -0.5319087481065502, -0.49066506338765509, -0.25388521774435541, -0.17759782612549996, -0.17342105765811164, -0.17172379067488869, -0.17163733194043357, -0.0096917261033460274, 0.23320936684713756, 0.61544163247884909, 0.23031783223894131, 0.4504667163321609, -0.25422186154383031, -1.2338903723029762, 0.0, 1.2338903723029679, 0.25422186154382892, -0.45046671633216256, -0.23031783223894184, -0.61544163247884998, -0.2332093668471385, 0.0096917261033450074, 0.17163733194043357, 0.17172379067488885, 0.17342105765811225, 0.17759782612550043, 0.25388521774435546, 0.49066506338765642, 0.53190874810654976, 0.075660591040102837, 0.17371304193345374, -0.56835821427958444, -0.57588244896772234, -0.58152174984391114, -0.37581890108999716, -0.19622512970076919, -0.097477148948305531, -0.10903691838775691, -0.12776142939873006, -0.10281428632219579, 0.16845135046504131, 0.22405122030786861, 0.66464487182371257, -0.94641351902713855, 1.1129988398741191, 1.6066056279080259, -4.1115013597100578, 1.5476694374721462, 2.1696976832709982, -1.0193515924216472, -0.29854169122463242, -0.44685069559938834, -0.39815350666419097, -0.037318187986404149, 0.13143015225876697, 0.18368108831833294, 0.14048874638904385, 0.12890403553126736, 0.081108427029909794, 0.15350152251374438, 0.35696964892206617, 0.77135662792155557, 0.018970197624865574, -0.12859489098383081, -0.62859642257500314, -0.54100133271839856, -0.39870906011464824, -0.13095780969018578, -0.011847923870824886, 0.022775175196357359, -0.047630852690687051, -0.085024034480974689, -0.063066133758832563, 0.38868529039399197, -0.46027494328632251, 1.1970497991660347, 0.63252660757872814, -1.6764175122847713, 3.5142346308062082, -2.1389978076683618, 0.061458391503496308, 1.4503952980081398, -0.95871119523029713, -0.30802887330694667, -0.2385247997630148, -0.054110895720761498, 0.11278544639649313, 0.15123171993121864, 0.1047503975035141, -0.038230887694384028, -0.18202109891961496, -0.17596357423927469, -0.2231700372991606, -0.37668655809676688, -0.33099751793180054, -0.60627707274499654, -0.56199684605203359, -0.63488067579895024, -0.35167328896657507, -0.072941493094733675, 0.1095616669888755, 0.091852860366211805, 0.07099339435842339, -0.08127813274590924, -0.044468991083660724, -0.56281676758124888, 0.77751104168880336, 0.39903363987828711, -0.69665186973992854, 2.0365876460209633, -0.67307548012867546, 1.6700526640562572, -1.17827123123954, -0.42325697055405653, 0.93604459898777859, -0.63132994551184651, -0.15348950297637845, 0.075070297171156097, 0.10891422081227575, 0.16261143474742193, 0.059405844632708517, -0.050113511094947612, -0.27336662525128258, -0.34815332433351742, -0.30445717300202041, -0.073461819418725136, -0.24223475523068566, -0.278045596991634, -0.48491463219235625, -0.45730316497375445, -0.37994714934071183, -0.015792824133968708, 0.17318676777642958, 0.21220001866353638, 0.10303861084867472, 0.04174339774265514, -0.40399573862898636, 0.084877145937511819, 0.095920343398476396, -0.71926168426275106, 1.5810043928614652, -0.39469180639349549, 0.59160024067907002, -0.32110784375924395, 0.93227329954447902, -0.4559731496763611, -0.36755582277520088, 0.39865574246315755, -0.22919036999990147, 0.096585989040328876, 0.12331107551299252, 0.1301692594587433, 0.045495054958742745, -0.070105150765121721, -0.12185893624649984, -0.22365254766781101, -0.15967526911861513, -0.28967646870392255, -0.0064402102662611729, -0.18564601960108706, -0.24329566614587189, -0.35934781180256659, -0.2637983589078372, -0.092146932205193599, 0.15924096907201093, 0.17303565260659445, 0.18377202523753683, -0.05088417995496395, 0.069785743671890568, -0.20195166784419286, -0.50855168910609727, 0.81885347149607191, -0.25745374979707175, 0.3186528874887527, -0.22307591696348483, 0.38850732372171648, -0.013830571830101068, 0.54639589537102196, -0.30522386319855499, -0.33942288969170481, 0.18157168721539607, 0.0004949292816654663, 0.097487343329345874, 0.11558972094679136, 0.04854535694218131, -0.015988824093569717, -0.06380009174949508, -0.025089334126078205, -0.055367518888164394, 0.079082063664820748, -0.087137707937777115, 0.031298024311669809, -0.062554945418906743, -0.1187078977577844, -0.23511892751228033, -0.064665418468805788, 0.057283952975166051, 0.14850320507536743, 0.074518551996532748, 0.14775664020163706, 0.0020829156573371555, -0.34047455883436323, 0.16529753202987046, -0.22056405751825445, 0.29537350362174863, -0.30727693305691484, 0.17130544619864224, 0.097926711565602301, 0.43706544906097711, 0.12813917376287753, 0.055902479292622584, -0.14580799486104357, -0.18662643567548898, 0.13091343010011883, 0.03346270256516358, 0.062891439826322837, 0.030406089689394671, -0.027232120122529239, -0.037974760198136892, -0.069443551113326632, 0.0066344290522653612, -0.14235450986309153, -0.22838873802708684, -0.2029739889926063, -0.011606155190393872, 0.032057043772551565, -0.021982682491265355, -0.097053178020474681, 0.088550664314818187, 0.053090482149624633, 0.13925876777248047, 0.063513516552260146, -0.054278095118517826, 0.08538415672805795, -0.21793581355625447, -0.077110294424558939, -0.15760636776309189, 0.074489797691215873, -0.057241994101257694, 0.35758313393883939, 0.19352665675464989, 0.25884721081868634, -0.095362679574154757, -0.062555070152259029, -0.050600401411129904, -0.04581555915567774, 0.095997178609832215, 0.0179504255888953, -0.029984980792924155, -0.15600995797322956, -0.13441036107213314, -0.16443500436191227, -0.20011010622694014, -0.1185676848060674, -0.38277205043588519, -0.22544536191476122, -0.18438213782554774, 0.19372413199270522, 0.11219308206942717, 0.25982980909746933, 0.078859657281328127, 0.23113762225192824, 0.12027128091306288, 0.03925026108281611, 0.10346450949096535, -0.11153460033842286, -0.078325720975578092, -0.16362595169702793, -0.049162011568201006, -0.06813688020407746, 0.18695930341705305, 0.15059247824175628, 0.27424888872344572, 0.14323623171577923, 0.0044347552049957819, -0.11996255351778637, -0.068558023511484198, 0.023032548262321723, -0.010426074631633324, 0.05035409898656467, -0.11095078972724633, -0.35469216713625396, -0.38858095560717304, -0.43659704639067964, -0.48811475177501651, -0.56772102070325836, -0.42759360787810491, -0.34349774583431025, -0.089250558912845224, -0.017255660868053985, 0.28929558460304938, 0.20633977154543065, 0.49525043110711575, 0.30490326972545867, 0.15907734702039197, 0.18083894269546641, 0.0069359534603191542, -0.048745778368166057, -0.20974664985683683, -0.11713478908555536, -0.18510515801561447, -0.013089808045645399, -0.0081310228529865667, 0.25176222061000281, 0.2693946687392072, 0.27370819742589902, 0.0067102091687078758, -0.064697981434012536, -0.12347320818582255, -0.049391580905336498, 0.11832252230060807, -0.17268517789922963, -0.32589261306509937, -0.639287914168712, -0.72192603666395261, -0.70207820166905555, -0.61232760985457479, -0.44353340330746277, 0.019538834540299969, 0.047502831671299713, -0.041738811618788646, 0.28620163890052958, -0.19764870263775797, 0.80219655994233652, 0.62892221563015416, 0.38953231590523568, 0.37886779576331475, 0.14774431296436413, 0.094413661460632833, -0.073411101811453133, -0.16021249355536557, -0.19593247304968892, -0.081650775970513151, -0.035818571775193361, 0.021291149638310077, 0.27454988477748077, 0.46071517851603194, 0.34339582552475939, 0.10294245821665464, -0.15104410911941546, -0.11912886110102075, -0.1113610452824651, -0.099114502229341719, 0.023349196100618572, -0.80611388127400851, -1.0763583447726097, -0.8168297825020715, -0.72603823847118742, -0.39736821511961523, -0.23386297177233123, 0.4703174557375292, 0.25096233231074278, 0.31922838969310624, -0.25991967791422005, 0.34193161983249054, 0.51711748874534202, 0.65455151443419168, 0.83215952955458772, 0.34065461819243747, 0.21354052285348993, 0.054409237913707532, -0.051414766220484194, -0.24129551707937194, -0.18021017930700467, -0.16649307508903324, 0.02611995380449984, 0.0088882269741778191, 0.49992842173391339, 0.57482956329523827, 0.51044075389218102, 0.13304644121698647, -0.089227696371110179, -0.21628766080628836, -0.18555506064923225, -0.27054447491545125, -0.68824563709364495, -0.56391746646770291, -1.3448759333642519, -0.90801354560554559, 0.072866201802841646, 0.18073895078348665, 0.55567065990800857, 0.39381772120025821, 0.59242819035998318, -0.05022415004119711, 0.11181138224479518, -0.31028937719203997, 0.3708105687152074, 1.1972380302487284, 0.6479171630934083, 0.5970258341713901, 0.23406484190569171, 0.1494250432975659, -0.10460468586388726, -0.29172235696712562, -0.38132345964412656, -0.02584515038199919, -0.36234031342997136, -0.0035984972735878563, 0.484844809780835, 0.76596137582741564, 0.56172135236794307, 0.32646969875093934, -0.19592809956107882, -0.23669588269358457, -0.32125288047075495, -0.35097323483886461, -0.92868491010645182, -1.7089894615168075, -0.39428020304678818, -0.15776662530084981, 0.38954314931717637, 1.1161873115341048, 0.59264738582705467, -0.5562024927443876, -0.99489496750979078, 0.9608676869506646, 0.92308378001124303, -0.4139391942136339, 1.3089140888320632, 0.78636343748881332, 0.71583959398165975, 0.45156398868756092, 0.30146681989019147, 0.20254250312507779, -0.0025274006864056797, -0.19201780058118689, -0.20404659434537004, -0.25925756638025355, -0.31672382746446043, -0.31172559850957088, 0.38747270801190198, 0.95200274282556019, 0.72646685328099436, 0.2788747346508717, -0.17968537990931685, -0.3258415080143367, -0.43315407205711348, -0.64132619327207141, -1.0499886203647348, -1.7251253398279605, -1.5120873610545145, 2.092671402110029, 0.678333420527655, -1.3908581394378237, -0.14065731983379445, -0.704649079609032, 0.40038203546320611, -0.28960616895899161, 0.94969408752542028, 1.2068396187631385, 0.4671902772630277, 0.59380988893293563, 0.44061350110379105, 0.30971168558439566, 0.13217055914433939, 0.084780328674454217, -0.042892010327952576, 0.029004083819250629, -0.14047533322535441, -0.16292155588890503, -0.50836195321575572, -0.15753196960053273, 0.022795944141262008, 0.83366315887402342, 0.78917379441409119, 0.67355449112521315, -0.2295941880121686, -0.24948129249626083, -0.45897332874859181, -0.65550663858936065, -1.2736175855462932, -1.2398159392319503, -0.73118573872941783, 0.68147470897196305, 0.68403615276129381, -1.4576264955235338, -1.6446564981157907, -1.587130770095007, -1.361280962925294, 1.044628248920846, 0.96909874957635356, -0.14162995430492481, 0.66911279151523617, 0.32234943120999365, 0.34963232308526704, 0.244105606577141, 0.16281560265463482, -0.014269719747667968, -0.011846708470826806, -0.18933865423621368, 0.017829624121361812, -0.97302526020811309, 0.059393044635753067, -0.20250391456577049, 0.6602817924610479, 0.54316838647960974, 0.76213554623441593, 0.36502835420313695, -0.082930104064008442, -0.29266755430530383, -0.30043904784973247, -0.57334259680943656, -0.83104911233797829, -1.039352345059011, -0.28395441021550044, 0.84090846562801602, -2.9317402483699175, -1.2603198064423498, -0.5637011092588653], "height": 32, "width": 32, "top": {"real": [7376.2586563979694, 2820.8522261533344, -5690.9497085395169, -4380.4513376296127, 388.6547315083493, -903.73852292232903, -92.233688854560938, 42.706854165930984, -25.699252344104405, 18.326281263011424, -9.8542387499157442, 37.933510453511431, -7.8666684309670254, 29.305075180843883, -62.728617354661907, 59.853240627388928, -83.636374399044939, 59.853240627386725, -62.728617354660756, 29.305075180844177, -7.8666684309671826, 37.933510453511431, -9.8542387499160657, 18.326281263013065, -25.699252344104405, 42.706854165930693, -92.233688854557883, -903.7385229223205, 388.65473150834708, -4380.4513376296045, -5690.9497085395114, 2820.8522261533035, -14789.032757371706, -31341.185848117759, -11739.029695619593, -866.78466658113393, -286.68893204831016, -488.33133225087568, -120.74864963582691, 33.024718339611894, 4.6010715329524166, -5.4456740109959769, 4.1139030671062393, 6.8633911029603265, 13.634662924808397, 1.860738389345556, -0.35796846682150263, -16.625069210775109, -14.807142725465134, -11.664010623894898, 0.82076815557037341, -12.155673848711613, 29.148348103795893, 15.708115389403888, 15.457503110539639, -12.683126140048403, 18.961120931859309, -53.601071866945205, 34.13442733448511, -942.72760774202175, -816.05094481379797, -3798.5470080468217, -8876.4278731043305, 2890.8320511623124, -27232.421940549859, -15984.118662988652, -6745.5682223604126, -409.0173927639226, -42.225544009425754, -526.29225504527119, -49.325655652906178, -23.20435390028933, 15.630174176003303, -14.835941429972856, 6.4726407463551725, 1.9958373496876167, 13.291351981828791, -1.1889020916883648, 10.030112101155916, -20.674418420848429, -0.1180338988714332, -18.745207674116038, -1.9041291470929314, -7.8710994817942428, 20.385879097388031, 14.857882580655026, 16.950197274587541, -2.033086164989526, 25.446982376231624, -20.624592190095939, 89.303256695009566, -637.06671072120571, -1428.8365567175017, -3113.2951228079887, -8881.5889351276946, -20696.443600183225, -9007.3131796291163, -5346.3306090002807, -1439.1675666408983, -1292.5663502582722, -654.09944760377277, -301.70227472838963, -97.440927522083996, -3.3329385156017457, -8.2027965131620153, -5.7742639473870323, -0.51069538319854635, 6.6402880636318233, 8.0126520330591013, 4.0882931682311625, -1.5210347396074151, -2.2335756869246048, -2.3288001542285928, -8.1315470965115093, -6.9403489082507335, -3.6748649027980562, 4.5937507427443531, 9.4957008241539675, 10.21057060635477, 11.676825499792781, 23.758858737501662, 20.288236987689611, 20.969766857125101, -333.51324485695324, -810.1584353673162, -2278.6820540988888, -5194.4090916202094, -7188.339898707115, -3154.0647285180166, -3175.2001764803263, -3085.2108289353805, -1226.2977859942123, -836.26206181721784, -301.22169990911055, -15.123294918373254, -11.324269109892445, -4.9992210979693361, -6.7152536525607003, -1.7063097661780617, 2.7727430774894133, 7.1357881321682148, 4.8669904821248817, 2.7536893948953045, -2.039934630711028, -0.54898928719761031, -2.9485150656567436, -3.1026085263061316, -1.3614545093317587, -0.47304719477880164, 4.0409079710738931, 6.2483313015723709, 8.8540252326547968, 18.802141623354618, 24.681352644731625, -6.1114787305120313, -148.49350684902615, -572.34886359995278, -1663.447165744248, -3308.6059534728529, -4493.8282478995061, -3720.0991836319017, -3323.4413322476125, -2223.3326338682518, -1347.5218927383742, -402.86472873295924, -179.07785660663581, -42.171627369153548, 13.024576486879551, -6.680339136637107, -4.3910663300422375, -1.9843645852297727, 2.2081255979025864, 3.4357055351949564, 4.8667397989738959, -0.0088018165553918268, -1.2900498248809058, -2.2230696316747851, -0.79613102395178958, -2.1003135650570957, -0.12607857026311342, 0.39928478103703097, 3.6189445517483683, 5.5230847011321824, 8.0807144322734796, 9.6537837209938342, 14.647883903859292, 41.761171107733581, -2.5048396429986766, -288.68438568639834, -1058.7748743456032, -2111.6481404168812, -2853.5518466904464, -2206.4742388833251, -2207.4882969003411, -1427.0600295974209, -607.97311048711572, -283.75431628355585, -25.222873313531675, -11.21903778037437, -8.3653822807976148, 1.9503276148055415, -4.8653324939916756, -1.0558165909594248, 0.18037835028025548, 3.7232300368774149, 2.6260151255238955, 1.901747650437611, -2.157984497724208, -1.9174482807780493, -2.671365924063863, -1.6822520344543337, -1.7835969801453151, 0.50013744114287995, 2.3612666445612516, 3.9892729615099713, 5.0282597338489978, 4.3849613992965208, 7.5675449146459712, 26.738330274504211, 30.293009711209869, -72.365238046453968, -397.03998761961856, -1129.7740740979677, -1877.1475049531305, -1015.8170093531105, -757.33856581211364, -464.04986763483271, -221.8093865245269, -66.670140953208971, -32.688631361988044, 12.245388279073117, -2.09491941357581, -4.9214217924247272, -0.76863227802399692, -1.3611346863617457, 0.59203001318831738, 2.3940543871676745, 2.1386535528573569, 0.12698658321630202, -0.36055346759858353, -1.509631760657328, -0.37490601010058217, -1.4076418772333708, -0.9909556252137327, 0.025704615807234758, 1.7006413859335137, 2.4101241863335301, 2.7230446482899899, 4.8975474263529586, 5.5799176422335819, 7.3823613929523022, 3.3531473980019464, -7.0947231292717241, -129.95057654055665, -447.33256260550814, -801.49855315264267, -297.71280467242298, -206.25666421819534, -105.85720001872387, -40.587336797783266, -19.033005269759897, 0.68623525685047748, -2.224754122223199, 2.8686428937153541, -1.3772856826259623, -3.7001182860738422, 0.56033030111271653, 0.31649576481826269, 2.6435570864758695, 2.0729019173667451, 1.3896745329326239, -1.1733083260901866, -0.5564284933709801, -0.75319429727185228, -0.16542223594150865, -0.34981510145177358, 0.63947101827441399, 0.64495136714903334, 1.5357324193076427, 2.8130362926385226, 4.2845415972556511, 3.3415574201637508, 1.8747628167747612, 4.3092019872505318, 1.2280777000161127, -53.113548920223614, -153.12296297306594, -262.59106890839882, -78.507966752468647, -44.713956729763169, -24.503242066462356, -11.422688403833899, -6.8324882374101472, -1.9389416594991726, 2.3416848160301655, -1.9581076589813595, 0.65441624739147974, -1.6215192060328243, -3.0886268279599727, 2.5574024719687731, 2.5859312055320047, 3.582324284715654, 2.3851708003164411, 0.41148866509477899, -1.7870448740379692, 0.35867475608513461, -0.33833230756510146, 0.72134917870519866, -0.6451343286468626, -0.036676325952571386, 1.8806785141996829, 3.0459530955995717, 3.0361534846987768, 1.8248078988499765, 2.0278729258957484, 1.4298438030821454, 1.444150632114136, -16.470770345398158, -59.038387406403551, -81.624687331130716, -41.65158074717607, -20.04858945819673, -26.796686775361913, -13.274828683787613, -5.4849410264677898, -1.7682797425272327, 0.51276950901621554, 0.11701161368370352, -2.1525887062494076, -0.35663258536781867, -0.3882693848937121, -2.5566610369397282, 6.5139128293303541, 4.1537964250038213, 2.1778507792771808, 0.67618078211604771, 0.67271760119275736, -0.033223712968477391, 1.7891382881043305, 0.76549003012129324, -1.8840461990319548, 0.62764371336603419, 2.9500669911593334, 2.7998549031057309, 2.7114466415734606, 2.640497491382968, 2.5087646302130264, 0.3613507110411972, -0.85975587552377708, -5.8993661554875496, -19.483874473281006, -46.656198806892085, -42.447185502078959, -49.475399988407517, -28.809040802191632, -23.364991274814315, -9.3720360014436217, -2.193549633075087, 0.73237790527535407, -0.60287176352488314, -1.0672361910519921, -3.8374461384037328, 0.81264916316705227, 3.7024783733454592, -2.2274307006673761, 12.171761179906976, 2.6484997231173142, 2.1242155181960216, 1.3916869062247985, 3.2969221728544564, 0.14147762112210061, -1.2659388719629114, 1.2983452624583423, 2.4646463691490883, 1.8819178233751466, 2.4699197782172551, 3.4105600445409938, 3.476877662739366, 1.970602508408192, 0.54569379437115284, -0.61503488296082265, -1.584537886719974, -9.9108851118855448, -17.968893142628509, 0.83280248396047341, -16.804391379900096, -34.94566909960443, -18.287776152890835, -10.19076861522101, -2.3659355754892188, 0.38430207827148843, -0.39175809943359002, -2.0786620762717161, -2.1066158183404973, -4.0664292874937455, 5.1056392812224729, 9.4711485160420441, -2.577327881134023, 13.563457368659881, 5.4454444116217209, 3.0810071966308192, 3.71409458782056, -2.7028450063821525, 1.3893389983926554, 5.0295677911697716, 2.0512141006459763, 0.57687440104333121, 3.1399874906463121, 4.3044361492909653, 3.2286926050373941, 2.0294536549063102, -1.2648718051872285, 0.81982278416560761, 5.1937461344056883, 4.5660530070978913, -2.5751982814314349, 10.842808636227273, -2.7634934625905125, -4.7410363255116081, -13.231297049532179, -1.2392069417375811, 0.57695677140757395, 1.6572428400911725, -0.80487566941313171, -2.1976406054664008, -2.9337382106235617, -0.97696074341019468, -0.52039830113476337, 8.6932746740913363, 18.008772340009436, -6.3894706762347742, 16.656214263229323, 5.6480128145892756, -2.6420757676626341, 6.9832538798624686, 8.7117753152913409, 2.944231966553327, -0.4194257648970201, 1.9464964791115495, 2.8117062685871983, 3.586606822562346, 3.6410340078674697, 2.1750438821370093, 0.92746135521083628, -0.10515597578954901, 10.916870623975495, 22.695665816423684, 26.922229107827643, 56.766547106622895, 34.346379481364103, 8.0209890672230593, 4.2276867493724737, 2.0129650120803855, 4.5721973792850843, 1.7026114564114816, -0.10193290249876912, -1.9877285465951933, -1.4091416884493304, -1.0407935339809435, 4.6927135104950821, 4.461866465996299, 13.14685287043932, 23.490161756370188, -8.5448676586843408, 5.7639040157862622, 6.7103974452754578, 11.090643871879529, 8.6117964749879281, 0.95828374077, 2.8859143014026349, 1.6803595914225926, 1.5724318132354216, 2.3664842485474589, 3.3844724421254813, 2.8754034241014996, 0.81420697505183059, 3.4592633965370854, 8.5418678989119741, 26.408180301615612, 46.472433795130719, 15.748155014076561, 18.939305693948317, 18.355423454953527, 7.4385947937208252, 6.8421582395566496, 3.8284829441665011, 2.3084513014265475, 0.014383588041353481, -0.70170837590258439, -0.9519271341888802, 0.60488638387036897, 4.7316501322768225, 11.640012070252736, 11.084534895769892, 7.9427552323827459, 17.090358547431578, -4.0062765415124373, 18.903471314461139, 10.522914852414784, -0.31727085194714888, 8.1914062421872558, 5.5678768421215832, 1.9515757898119943, 0.13204460835173984, 0.94686979396028259, 2.2566984460298456, 3.5582629306092612, 2.7150237945754423, -0.038191379039643265, 6.3090662882758242, 18.822434458740766, 20.387061197767007, 34.210424610695611, 25.78016711295075, 13.422328957688888, 4.2578162502068047, 2.3122896178400203, 4.1892680028045364, 2.2592478817037658, 0.95372259584702335, -0.47653425908969432, 0.069240128911087023, 0.91781179579556105, 6.6018505246928774, 10.152138543237006, 11.530381877152177, 5.6211304516254526, 4.7909070280413646, 35.867989503906792, 4.7909070280413584, 5.6211304516254428, 11.530381877152157, 10.152138543237017, 6.6018505246928978, 0.91781179579556504, 0.069240128911081333, -0.47653425908969432, 0.95372259584699437, 2.2592478817037476, 4.1892680028045142, 2.3122896178399985, 4.2578162502067478, 13.422328957688848, 25.780167112950689, 15.74815501407811, 20.387061197767874, 18.822434458741888, 6.309066288276548, -0.038191379039562191, 2.7150237945755555, 3.5582629306093274, 2.2566984460298958, 0.94686979396029702, 0.1320446083517558, 1.9515757898119841, 5.5678768421215636, 8.1914062421872096, -0.31727085194714522, 10.522914852414772, 18.903471314461111, -4.0062765415123884, 17.090358547431556, 7.9427552323827513, 11.084534895769902, 11.640012070252746, 4.7316501322768385, 0.60488638387038995, -0.9519271341888812, -0.70170837590259716, 0.014383588041281273, 2.3084513014264751, 3.8284829441663635, 6.8421582395566762, 7.4385947937204353, 18.355423454952824, 18.939305693949098, 56.76654710662406, 46.472433795132453, 26.408180301616227, 8.5418678989122103, 3.4592633965371484, 0.81420697505187978, 2.8754034241015152, 3.3844724421254879, 2.3664842485474735, 1.572431813235436, 1.6803595914225982, 2.8859143014026083, 0.95828374076997469, 8.6117964749878801, 11.090643871879506, 6.7103974452754693, 5.7639040157862587, -8.5448676586843018, 23.490161756370185, 13.146852870439265, 4.4618664659962768, 4.6927135104951034, -1.0407935339809418, -1.4091416884493408, -1.9877285465952099, -0.10193290249882341, 1.7026114564114307, 4.5721973792850434, 2.0129650120803833, 4.2276867493724772, 8.0209890672234039, 34.346379481364394, 10.842808636228447, 26.9222291078285, 22.695665816424683, 10.916870623975989, -0.10515597578943024, 0.92746135521090112, 2.1750438821369982, 3.6410340078674537, 3.5866068225623455, 2.8117062685872063, 1.9464964791115584, -0.41942576489699973, 2.9442319665532848, 8.7117753152913178, 6.9832538798624677, -2.6420757676626758, 5.6480128145892872, 16.656214263229302, -6.389470676234752, 18.008772340009443, 8.6932746740913274, -0.52039830113473562, -0.97696074341019512, -2.9337382106235728, -2.1976406054664195, -0.80487566941320732, 1.657242840091119, 0.57695677140755675, -1.2392069417374179, -13.231297049531948, -4.7410363255113248, -2.7634934625894938, 0.83280248396082224, -2.5751982814309775, 4.566053007098211, 5.1937461344059415, 0.81982278416574916, -1.2648718051872136, 2.0294536549062832, 3.2286926050373275, 4.3044361492909653, 3.1399874906463054, 0.57687440104334498, 2.0512141006459621, 5.0295677911697396, 1.3893389983926545, -2.7028450063821756, 3.7140945878205622, 3.0810071966308161, 5.4454444116217395, 13.563457368659845, -2.5773278811340234, 9.4711485160420441, 5.1056392812224614, -4.0664292874937296, -2.1066158183405044, -2.0786620762717254, -0.39175809943363327, 0.38430207827145285, -2.3659355754891784, -10.190768615220893, -18.287776152890569, -34.94566909960389, -16.804391379899673, -42.447185502078064, -17.968893142627813, -9.910885111884598, -1.5845378867194357, -0.61503488296060749, 0.5456937943712441, 1.9706025084081269, 3.4768776627392723, 3.4105600445409681, 2.4699197782172639, 1.881917823375139, 2.4646463691490985, 1.2983452624583438, -1.2659388719629485, 0.1414776211221116, 3.2969221728544715, 1.3916869062248129, 2.1242155181960229, 2.6484997231173293, 12.171761179906973, -2.2274307006673681, 3.702478373345508, 0.81264916316704883, -3.8374461384037382, -1.0672361910520076, -0.60287176352493688, 0.73237790527531033, -2.1935496330750563, -9.3720360014434689, -23.364991274814056, -28.809040802191326, -49.47539998840697, -41.651580747175068, -46.656198806890998, -19.483874473280501, -5.8993661554872627, -0.85975587552355426, 0.36135071104124949, 2.5087646302129953, 2.6404974913828889, 2.7114466415734491, 2.7998549031056945, 2.9500669911593249, 0.62764371336605218, -1.8840461990319775, 0.76549003012129535, 1.789138288104325, -0.033223712968466615, 0.67271760119275215, 0.67618078211606658, 2.1778507792771671, 4.1537964250038266, 6.5139128293303603, -2.5566610369397242, -0.38826938489369667, -0.35663258536783948, -2.1525887062494129, 0.11701161368368215, 0.51276950901619689, -1.7682797425271899, -5.4849410264677143, -13.274828683787417, -26.796686775361572, -20.048589458196275, -78.507966752466459, -81.624687331128925, -59.038387406402052, -16.470770345397689, 1.4441506321142048, 1.429843803082246, 2.0278729258956907, 1.8248078988499317, 3.0361534846987319, 3.045953095599546, 1.8806785141996951, -0.036676325952591224, -0.64513432864685583, 0.72134917870519299, -0.33833230756510668, 0.35867475608511745, -1.7870448740379619, 0.41148866509475018, 2.385170800316434, 3.582324284715646, 2.5859312055320172, 2.5574024719687887, -3.08862682795997, -1.6215192060328063, 0.65441624739145521, -1.9581076589813555, 2.3416848160301531, -1.9389416594989646, -6.8324882374098541, -11.422688403833355, -24.503242066461048, -44.713956729761051, -297.71280467242298, -262.59106890839888, -153.12296297306594, -53.113548920223877, 1.2280777000160852, 4.3092019872504084, 1.8747628167747172, 3.341557420163666, 4.2845415972556511, 2.8130362926385151, 1.5357324193076258, 0.64495136714903156, 0.63947101827441044, -0.34981510145179595, -0.16542223594153913, -0.75319429727190634, -0.5564284933709801, -1.1733083260902135, 1.3896745329326132, 2.0729019173667376, 2.6435570864758655, 0.31649576481827513, 0.56033030111271809, -3.7001182860738244, -1.3772856826259623, 2.8686428937153425, -2.2247541222231662, 0.68623525685057685, -19.033005269759858, -40.587336797783074, -105.85720001872383, -206.25666421819477, -1015.8170093530997, -801.4985531526338, -447.3325626055032, -129.9505765405554, -7.094723129271765, 3.3531473980017035, 7.3823613929520073, 5.5799176422333412, 4.8975474263529168, 2.7230446482898696, 2.4101241863335168, 1.700641385933505, 0.025704615807253747, -0.99095562521376346, -1.4076418772333852, -0.37490601010063784, -1.5096317606573337, -0.36055346759863915, 0.12698658321626774, 2.1386535528573165, 2.3940543871676701, 0.59203001318833959, -1.3611346863617075, -0.7686322780239524, -4.9214217924247352, -2.0949194135756803, 12.245388279073195, -32.688631361987156, -66.670140953207678, -221.8093865245236, -464.04986763482748, -757.33856581210489, -2206.474238883316, -1877.1475049531243, -1129.7740740979648, -397.03998761961947, -72.365238046453996, 30.293009711209137, 26.738330274503873, 7.5675449146456106, 4.3849613992964835, 5.0282597338488833, 3.9892729615099154, 2.3612666445612378, 0.50013744114287839, -1.7835969801453351, -1.6822520344543537, -2.6713659240639043, -1.9174482807780469, -2.1579844977242066, 1.9017476504375719, 2.6260151255238871, 3.7232300368773963, 0.18037835028033014, -1.0558165909593593, -4.8653324939915077, 1.9503276148055297, -8.3653822807973572, -11.219037780374073, -25.222873313530549, -283.75431628355437, -607.97311048711254, -1427.0600295974182, -2207.4882969003352, -3720.099183631889, -2853.5518466904387, -2111.648140416873, -1058.7748743456016, -288.68438568639789, -2.5048396429994018, 41.761171107733141, 14.647883903858578, 9.6537837209937827, 8.0807144322732913, 5.5230847011321327, 3.6189445517483261, 0.3992847810370409, -0.12607857026309263, -2.1003135650570361, -0.79613102395168645, -2.2230696316747758, -1.2900498248808734, -0.0088018165554208834, 4.8667397989738888, 3.4357055351949497, 2.2081255979026997, -1.9843645852296314, -4.3910663300419372, -6.6803391366371141, 13.024576486880093, -42.171627369152944, -179.07785660663302, -402.86472873295685, -1347.5218927383694, -2223.332633868245, -3323.4413322476003, -3154.0647285180148, -4493.8282478995088, -3308.6059534728515, -1663.4471657442498, -572.34886359995289, -148.49350684902797, -6.1114787305125393, 24.681352644731046, 18.802141623354593, 8.8540252326545641, 6.2483313015722262, 4.0409079710738718, -0.47304719477879342, -1.361454509331699, -3.1026085263059842, -2.948515065656593, -0.5489892871976132, -2.0399346307109321, 2.7536893948952148, 4.8669904821248942, 7.1357881321682211, 2.7727430774895763, -1.706309766177841, -6.7152536525602784, -4.9992210979693477, -11.324269109891496, -15.123294918372496, -301.22169990910822, -836.26206181721659, -1226.2977859942089, -3085.2108289353782, -3175.2001764803231, -9007.3131796291, -7188.3398987071041, -5194.4090916202022, -2278.6820540988915, -810.15843536731495, -333.51324485695591, 20.969766857124615, 20.288236987688347, 23.758858737501669, 11.676825499792164, 10.210570606354567, 9.4957008241538698, 4.5937507427443718, -3.6748649027980855, -6.9403489082508045, -8.1315470965115626, -2.3288001542285697, -2.2335756869247856, -1.5210347396073984, 4.088293168231135, 8.0126520330591262, 6.6402880636320099, -0.51069538319843244, -5.7742639473864941, -8.2027965131620455, -3.3329385156007563, -97.440927522082632, -301.70227472838576, -654.09944760377232, -1292.5663502582681, -1439.1675666408923, -5346.3306090002598, -27232.421940549855, -20696.443600183229, -8881.5889351276946, -3113.2951228080024, -1428.8365567175017, -637.0667107212123, 89.303256695008088, -20.624592190099609, 25.446982376231595, -2.0330861649905447, 16.950197274587225, 14.857882580654767, 20.385879097388024, -7.8710994817946256, -1.9041291470930921, -18.745207674117459, -0.11803389887143546, -20.674418420848326, 10.030112101155776, -1.1889020916883362, 13.291351981828802, 1.9958373496879209, 6.472640746355359, -14.835941429972186, 15.63017417600328, -23.204353900286776, -49.325655652904786, -526.29225504526619, -42.22554400942483, -409.0173927639147, -6745.5682223604063, -15984.118662988625, -14789.032757371675, 2890.8320511623242, -8876.4278731043305, -3798.5470080468367, -816.05094481379706, -942.72760774203016, 34.134427334482538, -53.601071866949361, 18.961120931859348, -12.683126140049515, 15.4575031105396, 15.708115389403696, 29.148348103795954, -12.155673848712381, 0.82076815557010951, -11.664010623895932, -14.807142725465098, -16.625069210776097, -0.357968466821102, 1.860738389345522, 13.634662924808296, 6.8633911029604313, 4.1139030671065999, -5.4456740109950088, 4.6010715329523864, 33.024718339612249, -120.74864963582446, -488.33133225087175, -286.68893204831085, -866.78466658111245, -11739.029695619576, -31341.185848117751], "imag": [0.0, -38758.087655514835, 17548.085047269142, 6107.2151726624015, -1874.673387120311, 1102.4198144208276, 70.663498597697227, 246.50443360377355, 15.094404836632346, 61.578388193120794, -6.883850379905633, 17.433253862249003, -27.182352905748338, 10.205627484635695, -57.631165788617082, 3.5978635789949243, 0.0, -3.5978635789944389, 57.631165788617331, -10.205627484634785, 27.182352905748068, -17.433253862248129, 6.883850379906236, -61.578388193120603, -15.094404836632346, -246.50443360377048, -70.663498597698691, -1102.4198144208278, 1874.6733871203112, -6107.2151726624097, -17548.085047269135, 38758.087655514864, 21415.511526704078, 9240.4816801838842, 6140.0706338628515, 4606.7423967050836, -477.33409412636456, 106.10534760670754, 253.85827683649731, 118.670471872242, 60.852179067446961, 22.790809731222598, 16.992665274593527, 3.3051410229913314, -11.158748163655874, -19.125680216300069, -12.454719286949617, -13.739274709476872, 4.4649861577324996, -1.4030381833900449, 28.352674755287939, -0.67900523797834378, 10.299898240809684, 0.92198929608587377, 1.7353747463970652, -28.921613512340663, -62.077231813228479, -150.50951383829744, -214.24479740751684, -816.21574466320703, 274.1353961963593, -3254.3286688062722, -6340.0761451284025, 11789.651384311641, 10840.701965194425, 18380.248977426931, 3231.3822724351476, -461.44982475214084, -210.28695062763435, 162.42212696600188, 179.30887547689923, 113.80000983072934, 43.394725496932487, 24.59548477602943, 9.5064435172576207, 6.2249226907652995, -15.514190495563678, -15.67209469704693, -16.179758937655365, -0.44183444538403649, 3.28796177703477, 12.57005414423841, 4.7947040656811843, 5.5752197676029693, -1.566994278876134, 3.0671728952871886, -9.3006029966239439, -19.205045070959127, -56.939768493357462, -104.59324045979437, -209.92149032340299, -248.20433151041027, -867.92363746103479, -1299.0888976028032, 827.61688284819274, -3453.3010516440099, 2184.1299326736716, 343.81610498084558, 1430.9649107108667, -397.20604751762147, -695.96261474413006, 272.38382351444113, 181.43163787734565, 64.570588674311324, 29.183435066681643, 16.420203889130576, 10.051165980763317, 3.8132998567254699, -5.2200576234926608, -12.843645059741645, -16.574215370008311, -6.8948411718648668, 5.7853993354930253, 6.7615499928711884, 6.3258793363865982, 6.2779141420300757, 7.316455816584333, 0.11325917153592484, -12.472105947256997, -26.315486653091728, -48.315266721271882, -96.05176533673017, -133.18984159990899, -353.39952612993443, 150.90670251969735, -622.62775933130001, -1461.5017842629939, 2621.2839732861958, -797.42142339187535, -1141.9271710506443, -1665.2932495998289, -238.3366310615267, 49.923170262409073, 61.506465075545492, 153.25086116745172, 46.446591336114025, 13.171326963991907, 10.42525251508628, 5.9093841314446687, 3.7481817410606739, -5.009304162269796, -8.3377118534842136, -11.383176063308646, -7.2904568591879206, 0.055102663998529922, 6.2100452165049633, 0.50258781153530074, 8.7133201843540995, 8.0099491969619425, 3.408178127748358, -6.1241971022028396, -12.736128845291272, -45.232132533425755, -61.3791750629996, -153.42214558232837, -67.595097514570796, 85.625899103861244, -58.961155821254636, 56.883206971067992, -1105.7125877167775, -1066.0901100808514, -1171.2701320923616, -223.1510166903665, -49.090655504704266, 242.13940044346495, 187.57398243385657, 37.630624824958112, 28.849867481961542, 8.4569554634773265, 4.9702839577388582, 4.4028115702250554, 1.4310556478305501, -1.929060150422355, -6.8702061592831818, -7.5557834297932249, -6.2828152868831211, -0.10870593803434039, -0.35173698335235887, 2.5520560959229499, 3.0896458550054593, 4.7505220002799033, 1.2377659738692817, -1.7806530124299274, -9.1879671692559626, -20.164632449396379, -65.591240653702698, -60.869480400000917, -62.271759486118263, -69.04223895420877, 113.44009243151515, -280.24622279593513, -361.29505764988915, -32.2389038646619, 397.42763261597736, 412.9673372382922, 359.76401050336045, 192.6210800054142, 122.25882006598455, 49.109708531705785, -0.83416770813231356, 2.4803036198391495, 2.5045331182816137, 2.1157075816863125, 2.0456835555591151, -1.3319639541688315, -4.1057658132159602, -5.2622609905014679, -3.122429370817716, -0.23490025627283884, 0.40862649299968534, 1.0190926814192749, 2.6652215067301066, 2.3902937959311288, 1.3072901204360872, -2.1976906085986245, -4.7205289930149936, -17.964658686821839, -21.918559933832515, -40.854552179344822, -68.24351076369831, 25.856495589804037, -73.74721318359471, 26.189735785049756, -56.726426890704197, 461.88238037931336, 400.36625478870423, 367.42140066372616, 233.95717316464078, 120.24788693419019, 56.86229814651989, 16.528423808469729, 5.5081763037408891, -2.7285347510623343, 0.91768473485835012, 1.922818700657754, 0.85878662181529319, -0.082031723657331246, -3.1986596327501684, -2.7995613930163934, -2.624028681216124, 0.082235364558318216, 0.13384423623927519, 1.9947594371394528, 1.3437508199980643, 2.6398410865992954, 0.73758290379789837, -0.13078900915043976, -4.4953343292506398, -5.1950335909144894, -13.12242317098767, -25.523369493146305, -12.192196214097944, -25.868477512213353, 2.9066782920883432, 34.106574161015573, 256.00130492151595, 208.58597838816522, 310.3347945923577, 177.03891975992664, 97.122360992021001, 48.488510187113192, 24.528917872852549, 4.6272034575157122, -1.3571647909533122, 0.20621269482631011, -0.40867746076362715, 0.99215767258594889, 1.5313768256641691, -0.052772985639764861, -1.5552847934304939, -2.8318141898835965, -1.44106038161314, -1.7221472209588695, 0.61786747800524422, 0.48048213041449506, 1.7161555169971148, 0.88689757979195871, 1.4761658864245926, -1.7252645996654892, -0.81528783024945528, -3.3158091950668926, -7.6513645380807835, -2.9281859927886749, -12.462674546124116, -7.4696827367159715, -23.236903073402107, 43.7319836231637, 92.321882041990349, 70.117668379783737, 34.226649356314077, 47.258739472197036, 25.375797504306092, 12.406583490274283, 8.6535618432690811, 1.0747519793409035, -0.44324044078252567, -1.7584707522262704, 0.72458607165998101, 0.70692065864217946, 0.77076345191259166, 1.0649069250197341, -2.7261985428418192, -1.9302074459527443, -3.3754250277859401, 0.50673349306549698, -0.64031672309299725, 1.374850007673434, 0.72950552648490297, 2.3325303094340692, -0.9986473214357906, 0.78195787446934228, -1.1999635798104886, -3.4858876190620522, -1.4991310089769327, -2.8433755069243221, 3.7638952884372583, 1.2400980139632869, -2.9542792497780144, 1.8234355680479359, 49.576244746235467, 19.014215780516388, 30.877310974744532, -1.1221271518157558, 7.8208026967228905, 2.609067592037944, 1.2521971880796572, -0.99505064345958283, -1.3975466814991453, -0.57338407820284554, -1.8697004151394911, 2.3700280505641378, 1.696784850403636, -0.61519740478736618, -1.3317994275810727, -4.2071746247346917, -0.85834734780410316, -1.4672332071937433, 2.6381100233578914, -2.4176769851497171, 2.0131074000190821, -1.6262628596018911, 3.9814331515508763, -0.027677673297514374, -2.444607041276003, -1.6150024285043403, -4.1227589144067673, -1.7068861549694658, 2.2919486155920237, 12.185386506158462, 9.103962312567619, 7.1597604706792799, -5.4087151249860161, 0.96974162117579055, -11.947201833901593, 6.6330620252490986, 2.1152085218133552, 3.546929348907518, 0.62283616740311709, -1.3522725353705505, -2.4444202103018355, -1.5690941230144015, -0.0069858778603680161, -2.2282653754616524, 3.8284308308873771, 3.1912913728027457, -5.5805618725494135, 0.13049495818795365, -3.5197176720292105, 1.8802124921714005, -2.6189977871286096, 2.1235611153433935, -7.1463089769422359, 4.7729314123471731, 2.1077672614040215, -0.81910125894631813, 0.72052624692713507, -3.4842402749887631, -4.1829115306886377, -4.3994325344570067, 3.0953565929079909, 11.949390330752637, 23.680136621529911, 21.558658775121675, 22.744598059672118, 24.943328767928129, 28.901352722188449, 12.814680673201753, 13.644932734111247, 5.45768556544121, 2.4025753394703617, -1.1673355625318591, -2.4971924284976894, -1.8952846661475429, -1.2927419412763479, 2.7902732019969552, -4.3477010834394934, 3.7423253621601038, 4.3959804108055893, -8.9257994152947724, 2.882370251254919, -5.0577698714645729, 3.1829717367300585, -13.324209534416688, 6.2785045354550411, -0.87489834284363188, -0.85263104321571348, 4.4885662153073236, -0.53110232172652128, -1.6389132121610095, -4.3945543864166812, -4.2936344828625694, 0.48745205753098192, 15.895360345460416, 25.169617383292081, 33.918445473292621, 23.996907911576923, 23.251277269359601, 5.1543156647143702, 18.554102826608389, 16.359265688234956, 10.231244633613841, 1.5587865083621433, -1.4683911434431964, -2.958105786087343, -1.5689869488245065, -0.96051225634847215, 1.7578951205789273, 6.6638352938822507, -9.4901775499106478, 4.1317473271038834, 10.951455398944859, -15.360897164532773, 5.739294741971535, -17.045217645164048, 5.8449684444103616, -3.5521886878464675, -7.3858280585812945, 5.7347340895196259, 0.4908832539545151, 0.98666637905349674, -1.0149409800154179, -1.6832477381822215, -2.5467748158366237, 2.0904065823844138, 13.443724261124899, 31.761133485201317, 33.671186166611122, 40.707191608760652, -1.1509826127936451, 21.096779572504321, 10.924705320167561, 7.3688776104039446, 6.4733533392666498, 1.1232923919614803, -2.4431302941492752, -2.7804484266994756, -1.6225398299131664, 0.6478030911844409, 2.5793951871330139, 3.1124056384095988, 9.3832743597685244, -14.195954313031031, -0.57608988546761064, 19.479390479219269, -31.200338855208866, 14.100113777774123, -5.3856662644378392, -10.946378631138824, 4.4142064356850845, -3.9066652322250062, 0.66844910598604979, 1.0227755630951001, 0.66137538568075327, -0.38567118503773246, 0.24821124990411303, 3.5872841231435211, 14.053276636456639, 24.260931372233497, 33.647459095648763, 7.6529271231588307, -9.2151377078706354, -38.311665858686638, -16.121399661234683, -5.9927868178298498, -2.7701365304211771, -3.7140088945870469, -3.0788396721523017, -3.0904878618769733, -1.8655827999533823, 0.43690140001808947, 4.1561194908680763, 4.3858952392085353, 2.7714027971729753, 9.257895969243517, -19.629364588289473, -14.072043519544888, 36.373196183604975, -13.61372365841147, -9.4583423311161248, 8.5284583277520429, -6.1744651457950592, -2.2310052363098367, -1.75629520897435, 1.1539693350814639, 1.7596902661237352, 1.8196834579374304, 2.022290334087173, 5.1646829084835781, 12.770276815017757, 24.46979490512981, 27.822785449092486, 29.828540342091252, 0.0, -3.7653763488297254, -24.757305904406468, -19.738984856989376, -8.2664619761594462, -4.6495144591838038, -3.656340919703911, -2.9147641885479052, -2.2830188616483764, -0.10916825448095578, 2.3916977668177819, 5.941240494184604, 2.1224657474819093, 3.9401472638367774, -2.1445277323266949, -10.774805376941604, 0.0, 10.774805376941531, 2.1445277323266829, -3.9401472638367951, -2.1224657474819155, -5.9412404941846173, -2.3916977668177926, 0.10916825448094437, 2.2830188616483764, 2.9147641885479065, 3.6563409197039234, 4.6495144591838136, 8.2664619761594498, 19.738984856989411, 24.75730590440644, 3.7653763488297773, 9.2151377078736516, -29.828540342087546, -27.822785449090652, -24.469794905129369, -12.770276815017642, -5.1646829084834636, -2.022290334087153, -1.8196834579374237, -1.7596902661237566, -1.1539693350814775, 1.7562952089743382, 2.2310052363098212, 6.1744651457950415, -8.5284583277521193, 9.4583423311161194, 13.613723658411436, -36.373196183604932, 14.07204351954484, 19.629364588289484, -9.2578959692435348, -2.7714027971730033, -4.3858952392085584, -4.1561194908680932, -0.43690140001811473, 1.8655827999533605, 3.0904878618769729, 3.0788396721523177, 3.7140088945872396, 2.7701365304214618, 5.9927868178306163, 16.121399661236502, 38.31166585868818, 1.1509826127964509, -7.6529271231568821, -33.647459095647825, -24.260931372233326, -14.053276636456571, -3.5872841231435073, -0.24821124990410889, 0.3856711850377551, -0.66137538568076071, -1.0227755630951023, -0.66844910598607266, 3.9066652322249751, -4.4142064356851165, 10.946378631138813, 5.3856662644378339, -14.100113777774116, 31.200338855208855, -19.479390479219351, 0.57608988546757856, 14.195954313030994, -9.3832743597685617, -3.1124056384095939, -2.5793951871330338, -0.64780309118445645, 1.6225398299131557, 2.7804484266994689, 2.4431302941492916, -1.1232923919613498, -6.4733533392663958, -7.368877610403441, -10.924705320166419, -21.096779572501951, -23.251277269357679, -40.707191608758833, -33.671186166610063, -31.761133485200901, -13.443724261124748, -2.0904065823843769, 2.5467748158366237, 1.6832477381822348, 1.0149409800154132, -0.98666637905348697, -0.49088325395452825, -5.734734089519665, 7.3858280585813008, 3.5521886878464564, -5.8449684444103243, 17.045217645163998, -5.7392947419715155, 15.360897164532778, -10.951455398944907, -4.1317473271038754, 9.4901775499106655, -6.6638352938822702, -1.7578951205789377, 0.96051225634844795, 1.5689869488244914, 2.9581057860873381, 1.4683911434432237, -1.5587865083620118, -10.231244633613667, -16.359265688234554, -18.554102826607274, -5.1543156647129926, -24.943328767927714, -23.996907911576475, -33.918445473292081, -25.169617383291836, -15.895360345460304, -0.48745205753098297, 4.2936344828625552, 4.3945543864167149, 1.6389132121610113, 0.53110232172653837, -4.4885662153073405, 0.85263104321570904, 0.87489834284363122, -6.2785045354550046, 13.324209534416719, -3.1829717367300314, 5.0577698714645702, -2.8823702512549096, 8.9257994152947653, -4.3959804108056124, -3.742325362160086, 4.3477010834395236, -2.7902732019969543, 1.2927419412763401, 1.8952846661475349, 2.4971924284976934, 1.1673355625318764, -2.4025753394703346, -5.4576855654411656, -13.644932734111133, -12.814680673201632, -28.901352722188015, -0.96974162117503315, -22.744598059671098, -21.558658775121231, -23.680136621529623, -11.949390330752514, -3.0953565929079563, 4.3994325344570004, 4.1829115306886644, 3.4842402749887649, -0.72052624692711631, 0.81910125894632069, -2.1077672614040264, -4.772931412347166, 7.1463089769422288, -2.1235611153433602, 2.6189977871286789, -1.8802124921713912, 3.5197176720292407, -0.1304949581879572, 5.5805618725494606, -3.191291372802759, -3.8284308308873531, 2.228265375461667, 0.0069858778603283057, 1.5690941230143916, 2.4444202103018267, 1.3522725353705702, -0.62283616740308378, -3.546929348907534, -2.1152085218133783, -6.6330620252487682, 11.947201833901675, -19.014215780515311, 5.4087151249861485, -7.159760470678993, -9.1039623125675071, -12.18538650615837, -2.2919486155920032, 1.7068861549694805, 4.1227589144067789, 1.6150024285043441, 2.4446070412760443, 0.027677673297527423, -3.981433151550863, 1.6262628596018724, -2.0131074000190696, 2.4176769851497326, -2.6381100233578612, 1.4672332071937413, 0.85834734780414157, 4.2071746247347095, 1.3317994275810989, 0.61519740478738694, -1.6967848504036496, -2.3700280505641422, 1.8697004151394931, 0.5733840782028331, 1.397546681499154, 0.99505064345958893, -1.2521971880796428, -2.6090675920379729, -7.8208026967229012, 1.1221271518159068, -30.877310974743335, -70.117668379782501, -49.576244746235311, -1.8234355680484657, 2.9542792497778261, -1.2400980139631994, -3.7638952884372125, 2.8433755069243154, 1.499131008976947, 3.4858876190620642, 1.1999635798105424, -0.78195787446931964, 0.9986473214357916, -2.332530309434083, -0.72950552648488864, -1.3748500076734225, 0.64031672309302556, -0.50673349306550342, 3.375425027785985, 1.930207445952772, 2.7261985428418698, -1.0649069250197167, -0.77076345191255435, -0.7069206586422051, -0.72458607165999755, 1.7584707522262737, 0.44324044078250502, -1.0747519793408324, -8.6535618432689372, -12.406583490274217, -25.375797504305602, -47.258739472196019, -34.226649356312784, -208.58597838816522, -92.321882041990833, -43.731983623163735, 23.236903073401958, 7.4696827367159822, 12.462674546124104, 2.9281859927886771, 7.6513645380808271, 3.3158091950668926, 0.8152878302494978, 1.7252645996655027, -1.4761658864245817, -0.88689757979195827, -1.7161555169970975, -0.48048213041447491, -0.61786747800518715, 1.7221472209588695, 1.4410603816132017, 2.8318141898836315, 1.5552847934305372, 0.05277298563978073, -1.5313768256641445, -0.9921576725859278, 0.40867746076360606, -0.20621269482631011, 1.3571647909533708, -4.6272034575156908, -24.528917872852457, -48.488510187113178, -97.122360992020845, -177.03891975992676, -310.33479459235781, -461.88238037931535, -256.00130492151709, -34.106574161017335, -2.9066782920893011, 25.868477512213314, 12.192196214097933, 25.523369493146241, 13.12242317098773, 5.1950335909144911, 4.4953343292507366, 0.13078900915048275, -0.73758290379785463, -2.6398410865992936, -1.3437508199980366, -1.9947594371394133, -0.13384423623915356, -0.082235364558330679, 2.6240286812162581, 2.7995613930164374, 3.1986596327502643, 0.082031723657369299, -0.85878662181523746, -1.9228187006577324, -0.91768473485829727, 2.7285347510623108, -5.5081763037407097, -16.528423808469462, -56.862298146519464, -120.24788693418984, -233.9571731646403, -367.42140066372525, -400.36625478870656, 32.238903864660138, 56.726426890699642, -26.189735785051667, 73.747213183594084, -25.856495589804108, 68.243510763698637, 40.854552179345092, 21.918559933832821, 17.964658686821831, 4.7205289930151793, 2.1976906085987129, -1.3072901204360032, -2.3902937959311101, -2.6652215067300165, -1.0190926814191563, -0.40862649299943438, 0.23490025627283342, 3.1224293708179411, 5.2622609905015993, 4.1057658132160988, 1.331963954168899, -2.0456835555590454, -2.1157075816862583, -2.504533118281568, -2.4803036198391473, 0.83416770813248287, -49.109708531705543, -122.25882006598383, -192.62108000541431, -359.76401050336045, -412.96733723829362, -397.42763261597815, 1066.0901100808455, 361.29505764988636, 280.2462227959299, -113.44009243151743, 69.042238954208585, 62.271759486118853, 60.869480400001216, 65.591240653703366, 20.164632449396354, 9.1879671692563107, 1.7806530124300617, -1.2377659738691233, -4.7505220002798652, -3.0896458550052697, -2.5520560959227772, 0.35173698335277165, 0.10870593803433028, 6.2828152868834488, 7.5557834297934026, 6.8702061592834163, 1.9290601504224327, -1.4310556478304128, -4.402811570224995, -4.9702839577387659, -8.4569554634772928, -28.849867481960956, -37.630624824957771, -187.57398243385583, -242.13940044346546, 49.090655504701473, 223.15101669036463, 1171.270132092355, 797.42142339187455, 1105.712587716775, -56.883206971068894, 58.961155821254195, -85.625899103861229, 67.595097514571449, 153.42214558232899, 61.379175063000453, 45.232132533425769, 12.736128845291734, 6.1241971022030093, -3.4081781277481404, -8.0099491969618857, -8.7133201843538846, -0.50258781153503296, -6.2100452165045663, -0.055102663998530817, 7.2904568591883807, 11.383176063308918, 8.3377118534845209, 5.009304162269923, -3.7481817410605087, -5.9093841314446331, -10.425252515086191, -13.171326963991898, -46.446591336113507, -153.25086116745101, -61.506465075545563, -49.92317026240935, 238.33663106152528, 1665.2932495998259, 1141.9271710506428, -2184.1299326736644, -2621.2839732861944, 1461.5017842629866, 622.62775933129569, -150.90670251969709, 353.39952612993454, 133.18984159990904, 96.051765336731378, 48.315266721271847, 26.315486653092378, 12.47210594725734, -0.11325917153558851, -7.3164558165842362, -6.2779141420297728, -6.325879336386472, -6.7615499928705614, -5.7853993354930182, 6.8948411718656626, 16.574215370008741, 12.843645059742064, 5.220057623492746, -3.813299856725167, -10.051165980763182, -16.420203889130285, -29.183435066681557, -64.570588674310201, -181.43163787734505, -272.38382351444022, 695.96261474412938, 397.20604751762363, -1430.9649107108592, -343.81610498084137, -10840.70196519443, 3453.3010516439876, -827.61688284819604, 1299.088897602802, 867.92363746103354, 248.20433151041067, 209.92149032340356, 104.5932404597956, 56.939768493357427, 19.205045070960029, 9.3006029966243737, -3.0671728952866175, 1.5669942788764133, -5.5752197676024959, -4.7947040656806426, -12.570054144236753, -3.2879617770347638, 0.44183444538609318, 16.179758937656128, 15.672094697047777, 15.514190495563801, -6.2249226907648021, -9.506443517257205, -24.595484776028343, -43.394725496932452, -113.80000983072682, -179.30887547689812, -162.42212696599955, 210.28695062763467, 461.44982475214965, -3231.3822724351485, -18380.248977426934, -21415.511526704078, -11789.651384311637, 6340.0761451283952, 3254.3286688062612, -274.13539619635947, 816.21574466320624, 214.24479740751747, 150.50951383829917, 62.077231813228565, 28.921613512340514, -1.7353747463964819, -0.92198929608524804, -10.299898240809465, 0.679005237978899, -28.352674755287008, 1.4030381833925814, -4.4649861577325289, 13.739274709477487, 12.454719286950338, 19.12568021630095, 11.158748163655963, -3.3051410229907021, -16.992665274592852, -22.790809731221124, -60.852179067446897, -118.67047187223945, -253.85827683649717, -106.10534760670436, 477.33409412636507, -4606.7423967050645, -6140.0706338628543, -9240.4816801839206]}};

var mouth_filter = {"real": [4.6340891519992962, 0.7844322938332674, -1.1596739705934982, 3.9933365069793401, 1.0745202382104644, -0.86566739843778528, -0.97931984026536645, -0.55848113024930113, -0.35079784655500912, -0.28441072774545773, -0.088142362922499759, 0.027465161121858393, -0.014037496255053593, -0.0045512610044201119, -0.0097173297219694255, 0.0018722497460425004, 0.00034424707543540862, 0.0018722497460384895, -0.0097173297219602297, -0.0045512610044239907, -0.014037496255053029, 0.02746516112186332, -0.088142362922505241, -0.28441072774544834, -0.35079784655500912, -0.55848113024929857, -0.97931984026536589, -0.86566739843778451, 1.0745202382104642, 3.9933365069793414, -1.1596739705934984, 0.78443229383326629, -0.64146012074713299, -1.4031948309962614, -0.72621528546721359, 2.8301862310857646, 0.22901892606370081, -2.4871893946676962, -0.82292478776907829, -0.038551737265843086, -0.20580868221576679, -0.28505928673030462, -0.18459030185549916, 0.058925447647408556, 0.0086943334915795256, -0.0086001017349623815, -0.0048545170036036192, -0.0004539351773376722, 0.00092194354279838148, 0.0017350493936515445, -0.0021057925479370247, -0.0060275384450162546, -0.01880365799458189, -0.023918178864192268, -0.020757173724755319, -0.18669623657203888, -0.43413705625508531, -0.36480504844763911, -0.32161507141862777, -1.8059188349376913, 0.70639011502857929, 3.4760111666249314, -0.5602942662325473, -0.88313644188618323, -3.1958827705277328, -4.1322391810878196, 0.77904148145098406, 5.0612923845025648, 1.5447671531259652, -2.8176609661232312, -0.63748901957655968, 0.36914599600864362, -0.00037729870766316427, -0.17990982199486863, -0.032569510455235789, 0.0085089063175920673, -0.014523430514595712, -0.012452101483067112, -0.0012625852907501049, 0.00028475514852645983, 0.0011591891684665802, 0.00039450549224649017, -0.002943469227087628, -0.010724474299968166, 0.0061262158881635236, 0.029252238624593387, -0.12159824966625053, -0.31076930784864121, -0.41364470354134941, 0.022306497695738548, 0.074366913048009908, -2.6718092121882169, -0.77719061117874755, 3.9762898076403879, 3.2079354493433021, -4.4012300899429189, -2.5660816993858311, -2.553218193276197, 2.0684625359523285, 4.9974951908094045, 2.143461857355776, -1.7847370377532255, -0.28821333774369001, 0.10766200451394388, 0.18782859841053653, -0.019310891700896299, -0.0062567209274460587, -0.0064371871903130887, 0.0021510630118947156, -0.011505776785749768, -0.0029992319263973479, 0.00030084525589988385, 0.0010941864062154283, 0.00030288821499767468, -0.0032329177128834767, -0.010312595680378463, -0.0068340802376650614, 0.019823041367851263, -0.0078950524544473683, -0.23245655665346024, -0.14923618615195547, 0.056419081419621493, 0.16707514445150673, -2.1849562859013951, -0.54088886065646191, 4.0516538348232194, 4.2406226010125279, -1.7936849281843577, -2.9840428724267536, -3.2115132203593002, -1.9470763746691873, 4.1518693114943472, 2.4862294474678142, -0.30639511041804085, 0.024820417007377235, 0.27577100857260728, 0.055259784589899323, -0.14220319122433717, -0.08642751724431888, 0.023244530667997254, 0.012523451759435138, -0.0058546865987889477, -0.0029976575640192626, -3.5555809550126927e-05, 0.00047377824955015626, 0.00099596206424971642, -0.00098919816572873276, -0.0097580547506740285, -0.020619695697678356, -0.0037015241751264089, -0.003593154009926945, -0.045481667679613515, 0.090305489910112821, 0.19683301699858768, 0.20611623580645685, -0.90233672462032366, 0.065306828187895322, 4.7788333108246484, 2.9026377323781798, -3.2466266324527706, -2.1436478188271333, -2.2561432890218653, -1.9115416020763942, 2.2130343552583907, 1.9915993980953659, -0.056495739083329222, -0.2528646737117784, 0.14962266633073235, -0.0099224078218753502, -0.1479065510292869, -0.07230224268075354, 0.0058318523760505494, 0.0022686064052674618, -0.00013275302826153175, -0.00063102743369309689, 9.1509786481767957e-05, 0.00031972746011452689, 0.00053353867978528325, -0.00058791023420762787, -0.0052408752439335538, -0.0091860766601598153, 0.015159206837947898, 0.016910593952452414, -0.099017880584634829, -0.099839128057652077, 0.28004861021942001, 0.37300273050036969, -0.085260591440202538, 0.41189695036617391, 2.9117111935410587, 0.66045559278765098, -2.6585359534260435, -1.484629636420711, -1.5429215388219939, -1.0057598114385591, 1.6171176031175611, 1.3492912586213337, -0.42857897427067643, -0.50006058673779852, 0.027713169661722398, 0.11528070486941493, -0.039483986090959794, -0.044672910989708811, -0.0092116030206209065, 0.00050303223447250363, 0.00117999940390684, -0.00042184774624830218, 4.668492787763195e-06, 0.00031547415704219679, 0.0001689251312381811, -0.0012866387173093054, -0.0021139867571189981, -0.0022343140961022454, 0.0092259555638931588, -0.0022666885302687536, -0.077537144546569597, -0.14256276290766454, 0.027946173791502729, 0.115246314279082, -0.3242302049719249, 0.30841119378164411, 1.9739342660507115, 0.88921924763931337, -1.5931958725731872, -1.0137169086218167, -0.98220755452462893, -0.55271078229049098, 1.084545546778825, 1.0070569814426842, -0.18251897039350226, -0.37931318856894325, -0.013449845022921075, 0.075764515301197377, -0.035369123979370719, -0.015619619770784467, 0.003123860549792537, 0.0028409863743067009, -0.00016094314378723183, -0.0010442109044203019, -9.8941097057248808e-05, 0.00016280791369542986, 0.00021650467324038706, -0.00047567037374047843, -0.00092328459105976625, -0.0014357330004678133, -0.00013185634410259166, -0.0087980568614916873, -0.057667801386191805, -0.014139365016219003, 0.15150048657312606, -0.063156821697620796, -0.52703545490563852, -0.11064525699952842, 1.3541882686537436, 1.0048741532970387, -0.82641052291163419, -0.55788342432782989, -0.54692805386470211, -0.22545269169536206, 0.6740428991302807, 0.63746360531382218, 0.053213891179403915, -0.16323047770545179, -0.05067162930818387, 0.0058333166986499468, -0.012742844783306895, -0.0071596160198456604, -0.00093377357192446454, 0.0012222061966531139, 0.00017574396951624128, -0.0005642074481669886, -6.0828659546840626e-05, 9.2871290444668044e-05, 0.00015000413209498726, 4.777345737973158e-05, -0.000326961738278439, 0.00024195810565667486, 0.00080694685438762858, 0.0024162562143001782, -0.021930873945379376, -0.011688581845023685, 0.11525275913926007, -0.020751088469611444, -0.33588482906629819, -0.021354414893159417, 0.81277558638075542, 0.72624502554486348, -0.35235216014446363, -0.26240454745464498, -0.25116485949546724, -0.047416949334167319, 0.41581226861132581, 0.36754912691134745, 0.031499405618264475, -0.1182059528936131, -0.027325517544006306, 0.017104517731676545, -0.0028988620733824016, -0.0076630041566265582, -0.0029377702512214019, 0.00085784401988343753, 8.3233018006220044e-05, -6.6626176934615107e-05, 3.0121602117794285e-05, 2.7157707030347298e-05, 5.3948506612911946e-05, 4.1294414526828764e-05, -0.00045536935945395869, -0.00011944277202748304, 0.001701190526917767, 0.00018736852574408679, -0.0020488748359166246, -0.0058560651797691897, 0.014332522459211712, -0.02484159185287883, -0.16044866683911937, 0.063133068421675945, 0.47884903706850868, 0.46922977068813959, -0.1005858110717496, -0.10558450478212159, -0.094572659725636055, 0.030818986514241645, 0.17934859926238414, 0.13718905272203691, -0.010905020288841244, -0.05427060295960378, -0.0073090810457242502, 0.01494907224279079, 0.0034945285778568377, -0.0038412851930084225, -0.0011597829517094804, 0.00044322180186623985, 5.4551216944427788e-05, -9.2794624249969221e-06, 9.5078851906194622e-06, 4.2007998035232393e-06, 4.0012008897297825e-06, -1.1774818209916229e-05, -0.00027037083981188163, -0.00035658526841883775, 0.0010094103856456143, -0.00052904996994269221, -0.0074682098820876806, -0.0022588127195562607, 0.018210634042398671, -0.009508805432907743, -0.085651174753861262, -0.014342078173992242, 0.19289673419785613, 0.23928297364621173, 0.039149520251701771, -0.061014517221157215, -0.057366565922661691, -0.0080064655214225223, 0.076289242121436118, 0.062033108089888676, -0.0026674849249250141, -0.024627343791732099, -0.005372625137310909, 0.0080653113868279242, 0.0030108297249231111, -0.0014118319882570156, -0.00042245914300035952, 0.00026288061895118008, 3.9126968311475854e-05, -2.5576892658974124e-05, -1.3099831737018989e-05, 6.8014805414260688e-07, 6.9755222362157937e-06, 4.1140465083074929e-06, -6.1370755554305661e-05, -0.00013364764935139172, 0.00021919093935820536, -0.00034687380123466822, -0.0034793424266583023, 0.00040352462407419059, 0.01373845906597586, 0.0021423976061818307, -0.037152134230387414, -0.017035854478310443, 0.07316876401329736, 0.093558727298951636, 0.001337949029101016, -0.028771535917646113, -0.027836987718903094, -0.0056044573137369316, 0.030982713752819017, 0.025812139891197732, 0.00074892492781415969, -0.0079187798201619947, -0.002052401353006265, 0.0023870007142673053, 0.00047709621801237946, -0.00019244333515306637, 2.364174882971905e-06, 7.8630073383472148e-05, 1.0976829691696413e-05, -4.9478433448607269e-06, -2.9053042363364555e-06, 2.3830467829361056e-06, 3.9023671373108736e-06, -2.6460791618778472e-06, 1.0608628096643537e-05, 3.3021940418689286e-05, 0.0001912157704189101, 6.7444175547866513e-05, -0.00096115828672010788, 0.00087008244330741215, 0.0067484721896968842, 0.0013604220025846133, -0.013837221190936331, -0.0075049977300193776, 0.030023800478366884, 0.039750958563338108, -0.00010247159736706737, -0.01163043609268417, -0.0096266829589855638, -0.00012449081323135682, 0.0098966622932942921, 0.0080718452892629081, 0.0011587204509509821, -0.0023373825953736087, -0.00080711215646797813, 0.00063105697122019017, 0.00025055042762753488, -0.00015724082609640453, -2.9456254661901335e-05, 2.2436391551144613e-05, 5.7614021056943357e-06, 9.2836238115278777e-08, -2.983219466927386e-07, 3.9469148175242839e-07, -1.897541367332826e-07, 2.3086718690330816e-07, -3.2379878454182751e-06, 2.9136696178544169e-06, 9.1340416066903861e-05, 0.00013720705972618841, -0.00027185621825451397, -0.00025621479435585686, 0.001222650455527893, 8.5193002129657069e-05, -0.004064865703922135, -0.00029221589048634159, 0.011494835522638509, 0.01340946760762054, -0.00054241338513798362, -0.0039904416962682253, -0.0028675934245187911, 0.00011970246178788614, 0.0032259655922311906, 0.0027177896529416603, 0.00029039751533865968, -0.00056045647677372237, -0.00011868935035429348, 8.6932625960108793e-05, 4.0585244752836994e-05, -3.9685399626399569e-05, -3.3675702194659581e-05, 1.8041324860728306e-06, 7.1527415341150131e-07, -2.5874877778097139e-07, -3.5187588582041102e-07, -4.9612975448428711e-07, 4.7392836724258751e-08, -2.7763787498630026e-07, -8.4165778406209883e-07, 3.0761526067769889e-07, 1.927255849211769e-05, 3.5189855392011486e-06, -9.8678053133183447e-05, -6.2632939936424042e-05, 0.00017511504940116496, -9.4816296748496417e-05, -0.0010867114051789507, 0.00038291262596998446, 0.0037605600166853263, 0.0033513976296794821, -0.0010579625982184212, -0.00083900520021582383, -0.00052619171844538041, 0.00055771306950743252, 0.0012835447933515079, 0.00080151927400318277, 6.1491898000095208e-05, -0.00011622895984693472, -2.362760140891841e-05, 3.979172224729024e-05, 7.0290787962574776e-06, -8.7051393881149627e-06, -1.7451721719085544e-06, -1.971994185063341e-06, -7.5103971978779283e-08, -6.3110103076160124e-08, -6.5527443378366647e-08, -1.271443792432593e-07, 9.3246051218088246e-08, 1.5092375607837617e-07, -4.0633606215809979e-07, 4.8842482637076878e-07, 6.2006052053478677e-06, 9.9625085097078631e-06, -8.4218410398305216e-06, -2.1130341683092213e-05, -8.6580287858941996e-06, -0.00010846093496444906, -0.00019573231564846473, 0.00038253737826254207, 0.0014355018795734822, 0.0012361430930244762, -3.8330562655413493e-05, -0.00045693558279248441, -0.00013724958223101865, 0.0005563817789235216, 0.0008124065993596201, 0.00038839544015797694, 5.2654227599481573e-06, -2.0620767185676097e-05, 1.4058588768839616e-05, 2.4456681475752488e-06, -1.3038942789126752e-06, 3.2957272146113247e-06, 2.136839449678527e-06, -3.8521786796247972e-08, -3.9949631386029851e-07, -2.803297067646553e-08, -4.2841831822770929e-08, -2.708778766944344e-08, -4.2841831887488422e-08, -2.8032970597075431e-08, -3.9949631385981395e-07, -3.8521786746470003e-08, 2.1368394496269648e-06, 3.2957272146716597e-06, -1.3038942788497014e-06, 2.4456681475752488e-06, 1.4058588768888149e-05, -2.0620767185710351e-05, 5.2654227597687651e-06, 0.00038839544015800736, 0.00081240659935969219, 0.00055638177892360769, -0.00013724958223097121, -0.00083900520021596553, -3.833056265530287e-05, 0.0012361430930255431, 0.0014355018795735538, 0.00038253737826226555, -0.00019573231564817955, -0.0001084609349642516, -8.6580287858519462e-06, -2.1130341683048624e-05, -8.4218410398544215e-06, 9.9625085095730612e-06, 6.2006052055115093e-06, 4.8842482632655112e-07, -4.0633606237408006e-07, 1.5092375605026055e-07, 9.3246051443898654e-08, -1.2714437924313219e-07, -6.5527443487134095e-08, -6.3110103047252147e-08, -7.510397195070611e-08, -1.9719941850259958e-06, -1.7451721718998097e-06, -8.7051393879504859e-06, 7.0290787963321046e-06, 3.9791722247395916e-05, -2.3627601408864216e-05, -0.0001162289598470872, 6.1491898000005259e-05, 0.00080151927400328501, 0.0012835447933512035, 0.00055771306950693161, -0.00052619171844531059, -0.003990441696267554, -0.0010579625982183091, 0.0033513976296794508, 0.0037605600166856607, 0.00038291262597007754, -0.0010867114051789164, -9.4816296748372926e-05, 0.00017511504940131815, -6.2632939936292583e-05, -9.8678053133139699e-05, 3.5189855391400817e-06, 1.9272558492233388e-05, 3.0761526064323095e-07, -8.4165778419493996e-07, -2.7763787504721638e-07, 4.7392836831470689e-08, -4.9612975448445027e-07, -3.5187588609488416e-07, -2.5874877778167802e-07, 7.152741534536303e-07, 1.804132486106339e-06, -3.3675702194604274e-05, -3.9685399626282394e-05, 4.0585244752900393e-05, 8.6932625960089156e-05, -0.00011868935035428417, -0.0005604564767739365, 0.00029039751533834201, 0.0027177896529417466, 0.0032259655922308689, 0.00011970246178728064, -0.0028675934245188605, -0.011630436092684446, -0.00054241338513798633, 0.013409467607620592, 0.011494835522638138, -0.00029221589048616421, -0.0040648657039219702, 8.5193002129971217e-05, 0.001222650455528094, -0.00025621479435585409, -0.0002718562182545189, 0.00013720705972611116, 9.1340416066969292e-05, 2.9136696178498302e-06, -3.2379878454707733e-06, 2.3086718686225909e-07, -1.8975413675430027e-07, 3.9469148175231827e-07, -2.9832194662415222e-07, 9.2836238091981533e-08, 5.7614021057956332e-06, 2.243639155115928e-05, -2.9456254661848962e-05, -0.00015724082609634113, 0.00025055042762756014, 0.0006310569712201816, -0.00080711215646793249, -0.0023373825953734708, 0.0011587204509510469, 0.0080718452892626774, 0.0098966622932934109, -0.00012449081323185037, -0.0096266829589855153, -0.028771535917645582, -0.00010247159736742938, 0.03975095856333772, 0.030023800478366992, -0.0075049977300190333, -0.013837221190936397, 0.001360422002584686, 0.0067484721896969484, 0.00087008244330749834, -0.00096115828672011482, 6.7444175547800892e-05, 0.00019121577041898859, 3.3021940418677224e-05, 1.0608628096553211e-05, -2.6460791619305373e-06, 3.9023671372462814e-06, 2.3830467829358028e-06, -2.9053042364313164e-06, -4.9478433448600171e-06, 1.0976829691639238e-05, 7.863007338347967e-05, 2.3641748829703282e-06, -0.00019244333515297128, 0.00047709621801239502, 0.0023870007142673287, -0.0020524013530060455, -0.0079187798201617154, 0.00074892492781425889, 0.025812139891197631, 0.030982713752818712, -0.0056044573137374659, -0.027836987718902747, -0.061014517221157166, 0.0013379490291006914, 0.093558727298950733, 0.073168764013296958, -0.017035854478310443, -0.037152134230387518, 0.0021423976061819595, 0.013738459065975945, 0.00040352462407424605, -0.0034793424266582368, -0.00034687380123471886, 0.00021919093935825583, -0.00013364764935140623, -6.1370755554343757e-05, 4.1140465083160657e-06, 6.9755222361877128e-06, 6.8014805414205017e-07, -1.3099831737122968e-05, -2.5576892658968157e-05, 3.9126968311429429e-05, 0.00026288061895118621, -0.00042245914300031615, -0.0014118319882569644, 0.003010829724923217, 0.0080653113868278357, -0.0053726251373106982, -0.024627343791731683, -0.0026674849249247769, 0.06203310808988808, 0.076289242121435036, -0.0080064655214229473, -0.057366565922661421, -0.10558450478212106, 0.039149520251701674, 0.23928297364621154, 0.19289673419785586, -0.014342078173991857, -0.085651174753861178, -0.0095088054329078991, 0.018210634042398706, -0.002258812719556187, -0.0074682098820877006, -0.0005290499699428646, 0.0010094103856456574, -0.00035658526841884875, -0.00027037083981181821, -1.1774818209899307e-05, 4.0012008896968829e-06, 4.2007998035228361e-06, 9.5078851906702469e-06, -9.2794624249821973e-06, 5.45512169444116e-05, 0.0004432218018662688, -0.0011597829517094238, -0.0038412851930083049, 0.0034945285778569305, 0.014949072242790728, -0.0073090810457241244, -0.054270602959603668, -0.01090502028884107, 0.13718905272203655, 0.17934859926238284, 0.030818986514240795, -0.09457265972563568, -0.26240454745464348, -0.1005858110717494, 0.46922977068813976, 0.4788490370685089, 0.063133068421676597, -0.16044866683911846, -0.024841591852878687, 0.014332522459211764, -0.005856065179769227, -0.0020488748359166085, 0.00018736852574399146, 0.0017011905269178167, -0.00011944277202752463, -0.00045536935945402705, 4.1294414526791867e-05, 5.3948506612877123e-05, 2.7157707030347085e-05, 3.0121602117749643e-05, -6.6626176934661782e-05, 8.3233018006250646e-05, 0.0008578440198834165, -0.0029377702512214973, -0.0076630041566264767, -0.0028988620733823725, 0.017104517731676455, -0.027325517544006247, -0.11820595289361274, 0.031499405618264593, 0.36754912691134622, 0.41581226861132453, -0.04741694933416768, -0.2511648594954663, -0.55788342432782989, -0.35235216014446413, 0.72624502554486348, 0.8127755863807552, -0.021354414893159278, -0.33588482906629807, -0.020751088469611285, 0.11525275913925997, -0.011688581845023685, -0.021930873945379303, 0.0024162562143002332, 0.00080694685438767672, 0.00024195810565667153, -0.00032696173827853592, 4.7773457379814068e-05, 0.00015000413209503944, 9.2871290444668044e-05, -6.0828659546917042e-05, -0.00056420744816712695, 0.00017574396951636955, 0.0012222061966531885, -0.00093377357192450466, -0.007159616019845526, -0.01274284478330687, 0.0058333166986499468, -0.050671629308183697, -0.16323047770545204, 0.05321389117940345, 0.63746360531382207, 0.6740428991302817, -0.22545269169536208, -0.54692805386470211, -1.0137169086218165, -0.82641052291163497, 1.0048741532970369, 1.3541882686537434, -0.1106452569995289, -0.52703545490563775, -0.063156821697620685, 0.15150048657312606, -0.014139365016218914, -0.057667801386191833, -0.0087980568614915919, -0.00013185634410271281, -0.0014357330004678901, -0.00092328459105995816, -0.00047567037374023129, 0.00021650467324065207, 0.00016280791369542935, -9.8941097057279613e-05, -0.0010442109044203046, -0.00016094314378705795, 0.0028409863743067928, 0.0031238605497927777, -0.015619619770784359, -0.035369123979370198, 0.075764515301197433, -0.013449845022920601, -0.37931318856894264, -0.18251897039350262, 1.0070569814426831, 1.084545546778823, -0.55271078229049153, -0.9822075545246276, -1.4846296364207112, -1.5931958725731861, 0.88921924763931159, 1.9739342660507089, 0.30841119378164455, -0.32423020497192495, 0.11524631427908204, 0.027946173791502632, -0.14256276290766468, -0.077537144546569833, -0.002266688530268584, 0.0092259555638929507, -0.0022343140961023017, -0.0021139867571188628, -0.0012866387173093869, 0.00016892513123889085, 0.00031547415704219538, 4.668492787631832e-06, -0.00042184774624882054, 0.0011799994039063304, 0.00050303223447267277, -0.0092116030206206324, -0.044672910989708575, -0.03948398609095928, 0.11528070486941518, 0.027713169661722662, -0.5000605867377983, -0.42857897427067776, 1.3492912586213337, 1.6171176031175631, -1.0057598114385595, -1.5429215388219939, -2.143647818827132, -2.6585359534260422, 0.66045559278764887, 2.9117111935410573, 0.41189695036617402, -0.085260591440201997, 0.37300273050036942, 0.28004861021941868, -0.09983912805765198, -0.099017880584635037, 0.016910593952451765, 0.015159206837948214, -0.0091860766601597858, -0.005240875243933095, -0.00058791023420808302, 0.00053353867978554596, 0.00031972746011452689, 9.1509786481807435e-05, -0.00063102743369398116, -0.00013275302826212034, 0.0022686064052679666, 0.0058318523760503612, -0.072302242680752943, -0.14790655102928651, -0.0099224078218752652, 0.14962266633073282, -0.25286467371177851, -0.056495739083330138, 1.9915993980953646, 2.2130343552583911, -1.9115416020763922, -2.2561432890218649, -2.9840428724267536, -3.2466266324527679, 2.902637732378178, 4.7788333108246475, 0.065306828187895516, -0.90233672462032188, 0.20611623580645633, 0.19683301699858602, 0.090305489910112668, -0.045481667679613411, -0.00359315400992807, -0.0037015241751260411, -0.02061969569767819, -0.0097580547506737354, -0.00098919816572940519, 0.00099596206425130282, 0.00047377824955015637, -3.555580955030948e-05, -0.0029976575640203941, -0.0058546865987889858, 0.012523451759435134, 0.023244530667997261, -0.086427517244318533, -0.14220319122433661, 0.05525978458989915, 0.27577100857260672, 0.024820417007377481, -0.30639511041804179, 2.4862294474678128, 4.1518693114943428, -1.947076374669187, -3.2115132203593006, -2.5660816993858284, -1.7936849281843579, 4.2406226010125261, 4.0516538348232221, -0.54088886065646147, -2.1849562859013973, 0.1670751444515067, 0.05641908141962089, -0.1492361861519553, -0.23245655665346052, -0.0078950524544474775, 0.01982304136785135, -0.0068340802376656131, -0.010312595680378572, -0.0032329177128843376, 0.00030288821499861344, 0.0010941864062154279, 0.000300845255900019, -0.0029992319263979755, -0.011505776785751019, 0.0021510630118943804, -0.0064371871903127383, -0.0062567209274463683, -0.019310891700895682, 0.18782859841053667, 0.10766200451394509, -0.28821333774368862, -1.7847370377532281, 2.1434618573557747, 4.9974951908094001, 2.0684625359523268, -2.5532181932761979, -3.1958827705277333, -4.4012300899429215, 3.2079354493433048, 3.9762898076403923, -0.77719061117874688, -2.6718092121882195, 0.074366913048009561, 0.02230649769573629, -0.41364470354134925, -0.31076930784863965, -0.12159824966625225, 0.029252238624593849, 0.0061262158881634976, -0.010724474299966393, -0.0029434692270879645, 0.00039450549224720385, 0.0011591891684665805, 0.00028475514852767235, -0.0012625852907517934, -0.012452101483067435, -0.014523430514596241, 0.0085089063175917082, -0.032569510455234915, -0.17990982199486819, -0.00037729870766311575, 0.36914599600864506, -0.63748901957656057, -2.8176609661232312, 1.5447671531259644, 5.0612923845025639, 0.77904148145098462, -4.1322391810878223, -0.64146012074713366, -0.88313644188618345, -0.56029426623254674, 3.4760111666249305, 0.70639011502857829, -1.805918834937694, -0.32161507141862899, -0.36480504844764006, -0.43413705625508542, -0.1866962365720416, -0.020757173724754961, -0.023918178864192875, -0.018803657994580801, -0.0060275384450154063, -0.002105792547937667, 0.00173504939364955, 0.00092194354279838181, -0.00045393517734262397, -0.0048545170036007057, -0.0086001017349646748, 0.0086943334915797251, 0.058925447647409854, -0.18459030185549863, -0.28505928673030412, -0.20580868221576676, -0.038551737265842712, -0.82292478776907585, -2.4871893946676935, 0.22901892606369992, 2.8301862310857611, -0.72621528546721381, -1.4031948309962614], "bottom": {"real": [5678.1086041894205, 20900.18095010153, 3447.0499761258557, 3006.2920785513897, 1095.893903110946, 386.81104976321694, 202.87465181506209, 112.96922946840166, 74.157579598112093, 62.413315591675342, 46.931213065231809, 32.703444421117119, 23.138509584976408, 18.532485453515367, 13.839857335386801, 11.995391672846374, 11.011316958211436, 11.995391672846273, 13.839857335386798, 18.532485453515342, 23.138509584976408, 32.703444421117176, 46.931213065231873, 62.41331559167557, 74.157579598112093, 112.96922946840168, 202.87465181506209, 386.8110497632174, 1095.8939031109464, 3006.2920785513907, 3447.0499761258566, 20900.180950101545, 11652.541375531215, 6105.9976767437374, 3079.1167046754913, 1776.9919423314705, 759.63591736173282, 370.96222186223144, 186.72550653728851, 104.06222158598892, 72.776226915090177, 54.132047333262229, 40.617443247446026, 26.905297339122829, 20.596051003825067, 16.964451546104712, 12.574490983994691, 10.149549151428955, 9.456590806505238, 9.9768657536093883, 12.029240511903456, 15.043219420350251, 20.838711299344116, 30.553614566731468, 44.40616386235552, 58.565861412331529, 70.132835875061744, 104.51314473208357, 189.56857349608143, 377.16693201205015, 884.12700895693013, 2239.7595640192126, 3145.1913405539117, 6958.5740759503597, 9609.5106426127932, 4992.6608769394197, 1669.5618690661463, 1059.1995113905639, 549.16279790927274, 278.94923830500289, 170.62516999169446, 111.93749936902557, 73.270251985017907, 52.998042263483633, 37.142546768677903, 24.977928698896999, 19.757351140056166, 15.549412568397655, 12.287444953226689, 10.159177492646036, 9.2913516551568005, 9.4707404644445941, 11.366894624691977, 14.908412193461192, 19.162809661823754, 25.525875481280988, 36.846585979626177, 51.022038209027251, 67.247306229462055, 96.043853286628931, 163.05718048491738, 294.76980362823429, 519.23514670394684, 957.57039473443547, 1368.5173470150648, 3871.635585616455, 5303.4798274482118, 3579.2066474003154, 1207.1822867649944, 879.86972928318005, 366.88528484741369, 208.17182668800805, 144.26637111917213, 100.24198689599578, 68.818117171408701, 48.744575666300129, 36.079835978948523, 24.716276003836366, 18.3829469088219, 14.338503983471835, 11.518473012854098, 9.4389981542904859, 8.6855447757572897, 9.3111499128487676, 10.931731847155714, 14.242659983217518, 18.454273027639637, 22.997981877882626, 32.775354054937182, 47.784430534137819, 65.982333636303437, 97.039219839998921, 143.27997074170094, 205.80805308530745, 348.18684046898466, 831.79281380405996, 1177.2730197279227, 2733.3936378292215, 3938.2641458688445, 2819.7837494548567, 820.36462717097368, 471.37587503146102, 271.87929154854345, 194.2701704157619, 144.96617790506966, 97.576794771201833, 61.3119854017338, 44.971290338260182, 31.994561157116021, 22.178882955012892, 16.262756648609532, 13.335771300720145, 10.777277796853795, 9.4872372674219161, 8.4179220667115882, 8.8615504994164276, 10.464447670423642, 13.467380568991793, 17.380860604603019, 22.603085253093905, 31.976099529363569, 44.356708279359708, 58.842492346581366, 84.943606310881933, 129.92857886018368, 172.62888515328848, 240.58003385007751, 441.25082967480506, 690.43324997326704, 1627.6849016299075, 3510.6104569290264, 2572.5928689582997, 734.84965238283041, 346.49155817100205, 245.54955425961745, 154.38419406683067, 123.89126600552243, 73.592832336469911, 51.176815014056707, 38.823519356586488, 27.703018951863196, 20.40402437294096, 15.615914454631133, 12.262838166368205, 10.911393710353273, 9.2831005853774435, 8.0758021716500519, 8.9560352521382285, 10.337739417364297, 12.597356227543543, 15.877991319670912, 20.726370017730709, 27.911545681671033, 37.940376333065345, 53.075877633932322, 72.520382240797787, 117.05897406186033, 158.12669065273971, 212.38391288711696, 299.48678366969477, 458.16531800810117, 1452.4284055535941, 1811.7186422893874, 1492.3389942582992, 530.65233974797684, 291.76966991086613, 187.69065022036725, 128.13046637777484, 90.24516666546559, 62.18605129748434, 41.710267966739593, 31.806783986884078, 25.068630438788546, 18.542553262414661, 14.666394584276578, 11.150365108371181, 9.9606764098368359, 8.5525257374706207, 7.7030138744354231, 8.2863477700222052, 9.8144929913230374, 11.655898242076917, 14.231766288773079, 17.885476571421012, 23.413082960982251, 31.608461656401264, 43.352221767718426, 55.676412685850877, 83.620268450993763, 126.42534521303489, 156.87210807500801, 246.58019931340195, 341.88266569523688, 826.98358454061815, 1404.2471167163787, 1228.1386668678601, 466.96068651596903, 262.22064771032797, 169.28009741248692, 115.01657309947615, 81.656383365816069, 54.579351530742883, 37.960529311280091, 27.270275764980511, 21.626986342929015, 16.174148423485327, 13.175385803191114, 10.818108303701184, 9.0657850663622632, 7.6275792078218663, 7.6107016321135834, 7.1158024527040036, 8.9011265392735677, 10.779707882412266, 12.420331822356596, 16.598306303244669, 21.012033493538478, 26.831312912868523, 33.051774609079132, 46.309734418779385, 65.383201302087031, 99.002477905219891, 128.56748384849996, 196.60807492406175, 298.23398084325686, 608.36256258703634, 1076.3354380676617, 975.85098582002695, 374.17471043828004, 222.04753134206624, 153.76758510324842, 111.73984833658845, 72.541074744398003, 46.502855765338275, 35.062921303265831, 24.451970593539095, 20.281233326031273, 15.065285185027921, 11.707355473726542, 9.7459029487301194, 8.114918006499499, 7.0964681111892807, 6.6796982066891397, 6.5878914508655138, 7.8186051199031059, 9.5427463544095801, 11.594349559722247, 14.318362157023484, 17.836915226678599, 22.844712934499004, 29.434722992970055, 39.992087970322991, 55.284175542844757, 86.773492313502047, 121.99890155292813, 175.66007701025202, 246.61763210131207, 451.54810738357452, 628.04019623528905, 603.29388410781314, 273.42112436269019, 189.28495193605181, 134.97815383583696, 92.537932899584618, 56.665976520174233, 40.654050842358266, 31.171413996879973, 21.026413392061954, 18.00341753039012, 13.721993308218343, 10.669689426212042, 8.356205196082156, 7.3868882398016433, 6.517599896433226, 6.0584998866872368, 6.5638826426931418, 7.1336795088287781, 8.613838618839619, 10.802606348653876, 13.366335355351938, 15.820551075574965, 19.845163015492108, 26.999239022736937, 35.458458280870509, 46.363090584483807, 68.281465328502051, 105.62610076866049, 153.51240187831726, 202.14938057052223, 301.98539336713208, 397.56324291610815, 405.30563382951226, 215.91082743746526, 149.29333201310212, 99.680104111337215, 70.844144712189916, 48.696705114384329, 36.637056536037569, 25.596184359277657, 19.02307727771527, 15.749761366858216, 11.951033594401437, 10.086463061934033, 8.3506293881191844, 7.2022393029757437, 6.0807779602627861, 5.7612683150124271, 6.0273725182896527, 6.6165496542300648, 7.4365452715085159, 8.6783297077665154, 11.615060741665609, 13.833866336064673, 18.575864228781477, 23.246005390172172, 31.555902400033563, 40.677669500589332, 56.667715144820136, 81.408207108224573, 111.98547216305556, 158.44613292857147, 210.62780774515824, 290.55794842865595, 312.25621146691742, 170.30250321119885, 113.87454497096817, 82.354258183333911, 59.818603534093889, 44.07044665600381, 32.893778204904692, 22.496539871033299, 17.094011041557415, 14.588382118274911, 11.200549789992062, 9.5745830477514566, 8.087405619242082, 6.7925999368613024, 5.4961910805963576, 5.1971703023131628, 5.4199426306511533, 5.7678603293099391, 7.0020534104826666, 8.2642952032077304, 10.213916707261937, 12.095005343850676, 15.601004576857186, 19.781090153028195, 26.29348154312569, 36.515567090044549, 48.740864373075503, 65.517726973596552, 85.616867091925073, 121.65124801185172, 164.28464153081055, 206.40983634767443, 220.41852448872194, 129.10563781650259, 92.689146582332683, 70.791066599245255, 51.943563730344891, 38.624038300983216, 28.742887457924869, 20.6631866841911, 16.243037999103294, 13.925007170923269, 11.024255100844002, 8.4139950296861468, 7.0401470253813523, 6.2856888836418143, 5.3560804114466043, 4.9985348214397556, 5.25099810618907, 5.5809638553577701, 6.8223029788192386, 8.5634007206388532, 9.7563203496299558, 11.812088062444902, 14.805264064130581, 17.93575786748271, 22.626272918294738, 31.174402898500958, 43.302312307258802, 56.326841577080955, 74.050997536102813, 101.37453317449018, 126.60409524008277, 162.42301117619624, 177.05193776506522, 115.72813424994953, 82.326066966484547, 61.307330817502205, 44.340846370849256, 33.378870891164695, 24.521965532974615, 18.923945416120109, 15.051214231467789, 12.320737648353592, 9.7999756970991925, 7.7145670626644423, 6.8152552126005839, 5.790991468644493, 5.5254951271344099, 4.9037029711983342, 5.4977261939037048, 5.4210433665926923, 6.2988580763712889, 7.9430787323529524, 9.3778517337478533, 11.242198007971071, 14.240421326197554, 17.651811381705546, 21.659024896488908, 29.131550319460956, 38.485086199887071, 50.092317177842048, 64.493269139882599, 88.474033169854309, 111.97252766350397, 138.89119149223308, 144.08748993083097, 100.36203094373164, 71.130756050186491, 51.595222833795184, 37.837750442044026, 29.957897076201892, 23.307587216478719, 17.870061723923296, 13.548228816751676, 10.730279953947793, 8.7941383608544452, 7.5189392893151066, 6.705955395914339, 5.4286200247646947, 4.999797681915652, 4.6762703758000139, 5.2431836531184182, 5.2308729223806347, 6.1881055124038262, 7.5261510579683444, 8.5830144005603604, 10.380584080562716, 13.063097810243177, 16.764705389876635, 21.077788907239153, 26.946259601518928, 35.064067560413655, 44.053944420107648, 58.895199291399678, 80.480502591809355, 105.53062749300898, 125.53124807748995, 123.85180136306964, 91.386853748724988, 64.043808743881343, 47.377246890606187, 36.917795087421162, 29.986306366154221, 21.922248103539825, 16.586233036173578, 13.010233921941435, 10.477074169109398, 8.6985558893370474, 7.2537351369992162, 6.347024549002974, 5.3569268232459128, 5.0096575514846968, 4.7237151783382343, 5.0872350526917325, 5.223561398000081, 6.2419547006416494, 7.1521863771078822, 7.9320558557880068, 9.974158228854499, 13.174966641491576, 15.965377755431728, 19.871959533459759, 25.954935810295414, 33.854283766819641, 44.113318889386903, 56.699892234383839, 81.033857172535789, 104.09119566434012, 123.77824150517087, 114.20520067738279, 85.229693259738468, 60.295157098692592, 46.590785285134146, 36.201434834295654, 27.092016678743615, 20.190577794974832, 15.811850117592071, 12.818302458338326, 10.737776338076218, 8.4417395277092595, 7.2563660620061432, 6.1723041784468409, 5.4319323269044659, 5.4462365532477222, 4.8064386829859753, 5.4462365532477284, 5.4319323269044641, 6.1723041784468409, 7.2563660620061476, 8.4417395277092666, 10.737776338076216, 12.81830245833833, 15.811850117592071, 20.190577794974825, 27.092016678743608, 36.20143483429564, 46.590785285134125, 60.295157098692549, 85.229693259738468, 114.20520067738286, 125.53124807748999, 104.09119566434013, 81.033857172535832, 56.699892234383839, 44.113318889386896, 33.854283766819655, 25.954935810295371, 19.871959533459762, 15.965377755431739, 13.174966641491576, 9.9741582288545025, 7.9320558557880112, 7.1521863771078893, 6.241954700641652, 5.2235613980000775, 5.0872350526917307, 4.7237151783382378, 5.0096575514846968, 5.3569268232459146, 6.3470245490029713, 7.2537351369992198, 8.6985558893370474, 10.477074169109407, 13.010233921941426, 16.586233036173571, 21.922248103539818, 29.986306366154224, 36.917795087421148, 47.377246890606152, 64.043808743881314, 91.386853748724917, 123.85180136306961, 138.89119149223299, 105.53062749300904, 80.480502591809227, 58.895199291399692, 44.053944420107612, 35.064067560413633, 26.946259601518928, 21.077788907239164, 16.764705389876632, 13.063097810243177, 10.38058408056272, 8.5830144005603639, 7.5261510579683462, 6.1881055124038333, 5.2308729223806383, 5.2431836531184173, 4.6762703758000139, 4.9997976819156502, 5.4286200247646956, 6.7059553959143425, 7.518939289315103, 8.7941383608544399, 10.730279953947782, 13.548228816751662, 17.870061723923293, 23.307587216478719, 29.957897076201906, 37.837750442044026, 51.595222833795212, 71.130756050186449, 100.36203094373161, 144.08748993083097, 162.4230111761963, 111.97252766350395, 88.474033169854323, 64.493269139882642, 50.092317177842069, 38.485086199887057, 29.131550319460946, 21.659024896488901, 17.651811381705546, 14.240421326197549, 11.24219800797108, 9.3778517337478586, 7.9430787323529533, 6.2988580763712898, 5.4210433665926958, 5.4977261939037065, 4.9037029711983324, 5.5254951271344037, 5.7909914686444868, 6.8152552126005865, 7.7145670626644396, 9.7999756970991907, 12.320737648353587, 15.051214231467785, 18.923945416120109, 24.521965532974619, 33.378870891164681, 44.340846370849256, 61.307330817502212, 82.326066966484575, 115.72813424994952, 177.05193776506513, 206.40983634767417, 126.60409524008281, 101.37453317449015, 74.050997536102813, 56.326841577080955, 43.302312307258816, 31.174402898500965, 22.626272918294742, 17.93575786748271, 14.805264064130563, 11.812088062444909, 9.7563203496299522, 8.5634007206388585, 6.8223029788192431, 5.5809638553577683, 5.2509981061890709, 4.9985348214397556, 5.3560804114466061, 6.2856888836418072, 7.0401470253813523, 8.4139950296861485, 11.024255100844005, 13.925007170923264, 16.243037999103286, 20.663186684191096, 28.742887457924876, 38.624038300983237, 51.943563730344863, 70.791066599245227, 92.689146582332697, 129.10563781650256, 220.41852448872183, 290.55794842865578, 164.28464153081066, 121.65124801185169, 85.616867091925073, 65.517726973596524, 48.740864373075532, 36.515567090044541, 26.29348154312569, 19.781090153028192, 15.601004576857186, 12.095005343850689, 10.213916707261948, 8.2642952032077304, 7.0020534104826773, 5.7678603293099435, 5.4199426306511462, 5.1971703023131655, 5.496191080596355, 6.7925999368612997, 8.0874056192420785, 9.574583047751446, 11.20054978999206, 14.588382118274911, 17.094011041557405, 22.496539871033306, 32.893778204904692, 44.07044665600381, 59.818603534093839, 82.35425818333394, 113.87454497096807, 170.30250321119888, 312.25621146691731, 397.56324291610832, 210.62780774515818, 158.44613292857147, 111.98547216305556, 81.408207108224559, 56.66771514482015, 40.677669500589346, 31.555902400033585, 23.246005390172176, 18.575864228781501, 13.833866336064665, 11.615060741665616, 8.6783297077665136, 7.4365452715085221, 6.6165496542300621, 6.0273725182896607, 5.7612683150124271, 6.0807779602627852, 7.2022393029757401, 8.3506293881191827, 10.086463061934035, 11.951033594401432, 15.749761366858216, 19.023077277715267, 25.59618435927765, 36.637056536037541, 48.696705114384315, 70.844144712189944, 99.680104111337187, 149.29333201310209, 215.91082743746531, 405.30563382951209, 628.04019623528882, 301.98539336713219, 202.14938057052214, 153.51240187831741, 105.62610076866049, 68.281465328502051, 46.363090584483821, 35.458458280870502, 26.999239022736958, 19.845163015492105, 15.820551075574963, 13.366335355351934, 10.802606348653876, 8.6138386188396243, 7.1336795088287852, 6.5638826426931312, 6.0584998866872368, 6.5175998964332322, 7.3868882398016451, 8.3562051960821524, 10.669689426212047, 13.721993308218325, 18.003417530390131, 21.026413392061936, 31.171413996879959, 40.654050842358252, 56.665976520174254, 92.537932899584604, 134.97815383583699, 189.28495193605173, 273.42112436269031, 603.29388410781269, 1076.3354380676617, 451.54810738357469, 246.61763210131207, 175.66007701025202, 121.99890155292813, 86.773492313502132, 55.284175542844778, 39.992087970322984, 29.434722992970055, 22.844712934499, 17.836915226678613, 14.318362157023493, 11.594349559722259, 9.5427463544095765, 7.8186051199031059, 6.5878914508655102, 6.6796982066891397, 7.0964681111892833, 8.1149180064994972, 9.7459029487301141, 11.707355473726548, 15.065285185027918, 20.281233326031277, 24.451970593539112, 35.062921303265831, 46.502855765338289, 72.541074744397974, 111.73984833658835, 153.76758510324839, 222.04753134206618, 374.17471043828004, 975.85098582002649, 1404.247116716379, 608.36256258703611, 298.2339808432568, 196.60807492406164, 128.56748384850005, 99.002477905219948, 65.383201302087045, 46.309734418779399, 33.051774609079132, 26.831312912868544, 21.012033493538468, 16.598306303244666, 12.420331822356601, 10.779707882412263, 8.9011265392735623, 7.1158024527040018, 7.6107016321135861, 7.6275792078218707, 9.065785066362265, 10.81810830370118, 13.175385803191121, 16.174148423485349, 21.62698634292904, 27.270275764980493, 37.960529311280098, 54.579351530742926, 81.656383365816112, 115.0165730994761, 169.28009741248692, 262.22064771032797, 466.9606865159688, 1228.1386668678595, 1811.7186422893876, 826.98358454061849, 341.88266569523705, 246.58019931340198, 156.87210807500793, 126.42534521303487, 83.620268450993777, 55.676412685850913, 43.352221767718426, 31.608461656401282, 23.413082960982216, 17.885476571420995, 14.231766288773079, 11.65589824207691, 9.8144929913230339, 8.2863477700222088, 7.7030138744354231, 8.5525257374706172, 9.9606764098368394, 11.150365108371185, 14.666394584276583, 18.542553262414668, 25.068630438788542, 31.806783986884088, 41.710267966739572, 62.186051297484333, 90.245166665465547, 128.13046637777475, 187.69065022036725, 291.76966991086601, 530.65233974797684, 1492.3389942582987, 3510.6104569290255, 1452.4284055535948, 458.16531800810117, 299.48678366969483, 212.38391288711682, 158.12669065273965, 117.05897406186025, 72.520382240797787, 53.07587763393235, 37.940376333065323, 27.91154568167104, 20.726370017730687, 15.877991319670903, 12.597356227543528, 10.337739417364284, 8.9560352521382303, 8.0758021716500537, 9.2831005853774364, 10.911393710353279, 12.262838166368201, 15.615914454631143, 20.404024372940963, 27.703018951863204, 38.823519356586509, 51.176815014056693, 73.592832336469868, 123.89126600552244, 154.38419406683062, 245.54955425961754, 346.491558171002, 734.84965238283075, 2572.5928689582984, 3938.2641458688445, 1627.6849016299093, 690.43324997326704, 441.25082967480483, 240.58003385007751, 172.62888515328839, 129.92857886018368, 84.943606310881961, 58.842492346581359, 44.356708279359744, 31.976099529363548, 22.603085253093905, 17.380860604603011, 13.467380568991784, 10.46444767042364, 8.8615504994164098, 8.4179220667115935, 9.487237267421909, 10.777277796853792, 13.335771300720136, 16.262756648609525, 22.178882955012895, 31.994561157116046, 44.971290338260197, 61.311985401733793, 97.576794771201889, 144.96617790506969, 194.27017041576195, 271.87929154854334, 471.37587503146125, 820.36462717097379, 2819.7837494548558, 5303.4798274482137, 2733.3936378292242, 1177.2730197279232, 831.79281380405973, 348.18684046898477, 205.80805308530728, 143.27997074170079, 97.039219839998907, 65.982333636303451, 47.784430534137826, 32.775354054937196, 22.997981877882619, 18.45427302763963, 14.242659983217516, 10.931731847155714, 9.3111499128487569, 8.6855447757572897, 9.4389981542904824, 11.518473012854098, 14.33850398347184, 18.382946908821911, 24.716276003836377, 36.079835978948545, 48.744575666300136, 68.81811717140873, 100.24198689599579, 144.26637111917196, 208.17182668800794, 366.88528484741386, 879.86972928318096, 1207.1822867649948, 3579.2066474003141, 9609.5106426127932, 3871.635585616455, 1368.5173470150646, 957.5703947344349, 519.23514670394684, 294.76980362823411, 163.05718048491758, 96.043853286628973, 67.247306229462083, 51.022038209027237, 36.846585979626163, 25.525875481280988, 19.162809661823751, 14.908412193461192, 11.366894624691964, 9.4707404644445834, 9.2913516551568005, 10.159177492646041, 12.287444953226698, 15.549412568397658, 19.757351140056148, 24.977928698897006, 37.142546768677924, 52.99804226348364, 73.270251985017907, 111.93749936902559, 170.62516999169443, 278.94923830500301, 549.16279790927297, 1059.1995113905641, 1669.5618690661465, 4992.6608769394161, 11652.54137553122, 6958.5740759503597, 3145.1913405539112, 2239.7595640192112, 884.1270089569299, 377.16693201204993, 189.56857349608163, 104.51314473208359, 70.132835875061716, 58.565861412331529, 44.406163862355506, 30.553614566731444, 20.838711299344109, 15.043219420350246, 12.029240511903463, 9.9768657536093936, 9.4565908065052362, 10.149549151428952, 12.574490983994684, 16.964451546104694, 20.596051003825067, 26.905297339122818, 40.617443247446033, 54.132047333262229, 72.776226915090191, 104.06222158598892, 186.72550653728851, 370.96222186223156, 759.63591736173305, 1776.9919423314723, 3079.1167046754904, 6105.9976767437374], "imag": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0]}, "imag": [0.0, -0.027073229785536494, 0.59011929886938141, -0.96446761270548442, -0.6435513043684985, -0.68291153317050746, -0.33645866529024865, 0.1935415439422136, -0.12487037453098428, -0.012369715566745995, 0.0098216569471749459, 0.001542130029622399, 0.020818288300735281, 0.0037303920674802314, -0.0038837652177233549, 0.00060693078338958778, 0.0, -0.00060693078338692346, 0.0038837652177235778, -0.0037303920674795358, -0.020818288300735933, -0.0015421300296204468, -0.0098216569471759191, 0.012369715566746212, 0.12487037453098428, -0.19354154394221409, 0.33645866529024965, 0.68291153317050701, 0.64355130436849806, 0.96446761270548365, -0.59011929886938175, 0.027073229785536425, -2.3563074320989772, 2.5879403475863869, 2.1627258263390448, -3.1655869149224403, -0.41468157127337424, 0.73477199535913751, -1.2119335549119159, -0.10726288955095604, 0.30943623202091536, 0.23604949314849888, -1.983168313462914e-05, -0.015096007795395092, 0.0044172524913437313, 0.0012110563015863107, -0.00040440768488355977, 0.00056775738923005802, -0.00053942936844551652, 0.00087575929197146875, -0.002003234803528005, 0.0042603852180314204, -0.0062087670781442329, 0.017375416518930226, -0.014179868174360925, -0.10125602185153701, -0.15414023444697653, -0.035800396396009702, -0.96211078676818074, -0.96053455050253955, -1.1229487194040586, -2.1710672351706557, 1.4940913514434742, 2.7217236711600989, 1.1141581132568867, -0.84173680321989597, -5.2801379304709686, 1.1933011924316357, 3.2397405202403871, 0.58382335305071387, -1.2090975123731194, 0.11812270190565496, 0.29294962083792114, 0.38808563795590029, 0.017661918975066655, -0.0075287995749033759, -0.018334336057616411, 0.0080668085023426154, 0.0016882901545514294, 0.00017988558455360213, -0.00046271928878641557, -0.00012883481246306377, -0.0015037083336975181, -0.0051624614514164694, 0.0051337344665884242, 0.01635194779532648, -0.020739891572331103, 0.034224425977121886, 0.14660089916526936, 0.2579692221979365, -1.297902949650936, -0.81053000193538005, 2.2824415889165404, 1.3538813012752462, -3.6141509401212817, -1.3641708343500389, -2.525115924658619, -3.1276611078214884, -3.2520008240455529, 1.0086268501795932, 2.5763030038597452, 0.40772972397284202, -0.2975902384778692, -0.049496223745927298, -0.032511080574428759, 0.067130744005831466, -0.0201042966896933, -0.010577484531256129, 0.0093680389241231343, 0.0094203803992774487, 2.0439677469712496e-05, -0.00046042150692956042, 9.7927563908633831e-05, -0.00040743814870436565, -0.00074442767565903077, -0.0053134061063244819, -0.0081457928016647942, -0.016837193889943817, 0.00090322875228200043, 0.15679003542803616, 0.24794675857842086, 0.30815180494462813, -0.65229037787562094, -1.3408717866717259, 2.6508673621629431, 3.2598446139294937, -1.6423378558800314, -3.9986185110220567, 0.17392931664300956, 0.21368421587766026, -1.2315545205448162, -1.7422719766284609, 1.3054063480052003, 1.3750287394245329, -0.35022259842939119, -0.62247639588288617, -0.048937158811492604, 0.046213719349399378, -0.071248172851420807, -0.031638182474279769, 0.0092883221388230762, 0.0058947313405102496, 0.0020720238780862037, 0.00012946526299033534, -7.130655653596095e-05, -0.00038809112868830591, 0.0011018135930776953, 0.0010417550100125584, 0.0072040756024705759, -0.02451231341789871, -0.016921302325211343, 0.019764169882346385, 0.062587439504234885, -0.087282929002583373, -0.10008726366432093, -0.14363219386863416, 1.7469053421591101, 1.042390648919584, -1.364603392172089, -0.68321209765005841, 0.66892838780721486, 0.73208772838799607, -0.32755194356284695, -0.30510623667849596, 1.5181969873975902, 0.34278556022615442, -0.74313584277783451, -0.35705699907666322, 0.1310185858494092, 0.083590457495018811, -0.021674632648672316, -0.02469255214616152, -0.0043034893865322183, 0.0020376676236782713, 0.0021493865206610868, 0.00038855444421157756, -0.00023746053900133829, -0.00029830757497495967, -0.0001970006488720256, -0.00087982491421480442, 0.0074805689709430004, 0.010808720951461402, -0.035798177116234398, -0.091541716420706271, 0.0092010764075083195, -0.19110346978313567, -0.62579430924026735, -0.13482498836119824, 1.785974669626095, 1.1747425146844421, -1.173327779558617, 0.27670322508415535, 0.33562708516576978, 0.27104375713022649, -0.04917488399628335, -0.09917627706172702, 0.47021789966195177, 0.19299106678658604, -0.25337707381982333, -0.21158932458700433, -0.0038282192087294945, 0.079426421106262524, 0.0049276280752214097, -0.012631915096635613, -0.0020857584923047439, 0.0014730403106953706, 0.00056282220383548922, -5.2753025427967662e-05, -0.00011043948472760819, -0.00013701607546798722, 0.00024141713667198109, -0.00017599692518015115, 0.0033313264069332665, -0.0026415953474081991, -0.034551401114022419, -0.067614335954062313, 0.057375162080317274, 0.10414416266224315, -0.4897526648425265, -0.75726357904359276, 0.48971199898009016, 1.1084142254331173, 0.074442669441772358, 0.13102742771679016, -0.24374357403537103, -0.28356643882607668, -0.65203784187591463, -0.36850284921393173, 0.37230089042480646, 0.4991450162764402, 0.031449374349395147, -0.23992875156785609, -0.086092076891526551, 0.032374807759909224, 0.0062294082126362945, -0.0060917930216442444, -0.0010414824560445231, 0.00015455144974867572, -8.9980842426917249e-05, -1.5754152380049444e-05, 2.760348450088792e-07, -8.4925580282278396e-05, -9.538306571273261e-05, 0.0012356709589061894, 0.0019825160649420671, -0.0025172833852348821, -0.028888564425605757, -0.016030883614829267, 0.069260754853324724, 0.010501517567550991, -0.24153406544338693, -0.2847803977366839, 0.37357513895849587, 0.56507750226207965, -0.29338428828582186, -0.55012213491904771, -0.13256769577232769, -0.093306847874868315, -0.26668667634059962, -0.24770054522287138, 0.1944884297335735, 0.33591487261576602, 0.06235746981204858, -0.1546651423691924, -0.03904218756455085, 0.014396528935747412, -0.0017849945305527066, -0.0040798293321671533, -0.0019408045705910123, 0.00084895033746642374, 0.00039593785796133193, 5.5592435290972645e-05, -4.1965636442186823e-06, -6.2852929824007463e-05, -0.00034629566400638584, -4.8241347432061454e-06, 0.00057512008113313117, 0.00033489534843084444, -0.0031901125163299256, -0.010909574115055, 0.016920458777085551, -0.060786209275753178, -0.21998547499285445, 0.011288166830458734, 0.39450427611204475, 0.32156463816915598, -0.16694523801433098, -0.28285607915278405, -0.0086431961771640062, -0.016216948868002824, -0.12426113686156882, -0.13105274525765401, 0.01783418219228005, 0.12470331491202472, 0.037338151491471468, -0.053766563890133817, -0.017697451862990946, 0.0087641985076504225, 0.0020177112398541818, -0.0032903942418034261, -0.00098879884805599711, 0.00072826354344831883, 0.00023394715134995964, 1.1123369888840513e-05, -3.5001088996629374e-05, -3.1388155454884778e-06, -0.00015838596778406701, -0.00033445190756455149, -0.0001142558275417929, -0.00088473043957872045, -0.0055035547036739211, -0.0071882829440315203, 0.0056754664443316848, -0.024165671520133571, -0.12994912866694289, -0.03043154404819853, 0.19383851234462929, 0.16309710351628273, -0.074150026014186132, -0.12085880532211579, -0.044595013287817231, -0.043366337948898985, -0.090257019037460168, -0.073384871025009082, 0.023239798472538018, 0.07639283896145152, 0.011216629301030985, -0.0359133520966744, -0.013573759545388879, 0.0067665755556069575, 0.0030103388508484073, -0.00065141687607212645, -0.00041655443776571915, 0.00013094293222966718, 3.2292215967994378e-05, -1.526253885399206e-05, -1.5127801448997461e-05, -6.4845694559707764e-06, -1.5492547416280305e-05, -9.1308082212917993e-05, 0.00016667120940429337, -0.00041873515724890633, -0.0049027471727904112, -0.003075534798824412, 0.0092738136737237613, 0.0020660684229551027, -0.04064403555503323, -0.033233971766656843, 0.045775294033398174, 0.057167349545223407, -0.02508375199406394, -0.076725145240063103, -0.029192878339710793, -0.027962636418086263, -0.036204190826297326, -0.020723423884568531, 0.024267798198958853, 0.039127433373256276, 0.0066672447446462267, -0.015463651616642567, -0.007692451841204994, 0.0027471626893687531, 0.0010462542577807969, -0.00032293603684165713, -0.00014335933849004065, 2.7664402382146889e-06, 1.3817898707968035e-05, 2.5461973861614876e-06, -2.9451008005958465e-06, -4.0922137159052221e-07, 3.3208780384164378e-06, 2.2930933947507775e-06, 0.00019381368934935658, 0.00021177469863592545, -0.0013059386478791995, -0.00074739544714731232, 0.0074009891423913463, 0.0040508976947942563, -0.024179081541404416, -0.025786109831526915, 0.024427880538049996, 0.049513273245606421, 0.018107593495138536, -0.019155633990847833, -0.010866608608631909, -0.011586446122093948, -0.017758841021731874, -0.007715199561440257, 0.0099083442586334093, 0.016798455246852806, 0.0051385037481195082, -0.0053053978312845055, -0.0034294950764025521, 0.00061169662744445848, 0.00033799731924544067, -0.00024058911609197694, -0.00010154505453872226, 1.9807787751332398e-05, 1.1566718045558844e-05, 2.3526983774034052e-06, -3.1629035250083664e-06, -1.906633619859879e-06, -1.4241006555052951e-05, -3.3020030344899701e-05, 5.2908539732603441e-05, 5.1357289146045035e-05, -0.00039743496113234163, -0.00063432051689119376, 0.0027089055320300356, 0.0013503752362499016, -0.0082884630632301115, -0.0092589342553877248, 0.0088049724290094923, 0.022756702713130291, 0.011156251045765241, -0.0083450930318397683, -0.0049406694317385268, -0.0058001455908667206, -0.0076603598190790028, -0.0053021820779070323, 0.001845870794973378, 0.0051951770049388935, 0.001795161616712868, -0.0014758375936677148, -0.00091174996356954989, 0.00015619540664616496, 0.00011997798601084234, -7.415390708438721e-05, -4.7705175525428954e-05, 1.0498840541001561e-05, 5.7016743603087733e-06, -1.1348311617650734e-06, -1.0392532056220499e-06, -1.5023935068766505e-07, -4.5999439012728934e-06, -1.7083459920844721e-05, -9.6967633574418463e-06, 8.8789075877219231e-06, -0.00012444306086311345, -0.00019783492062566108, 0.00060624989809523425, 0.00033450965931121433, -0.0029572761111825215, -0.0037574725417352365, 0.00099233616545915107, 0.0061280004658490978, 0.0032489106979224094, -0.0026668961742810043, -0.0024385469973046831, -0.0029055731292758351, -0.0035330841487134718, -0.0021581469455770066, 0.00045127797385368442, 0.0018583554775031736, 0.0007285298435105804, -0.00040485086541622897, -0.00029259265207938966, 0.00012119187628647567, 5.7987669870543989e-05, -2.689854721032224e-05, -1.2650266391968962e-05, 1.4661018807957155e-06, 1.5771327546691322e-06, -3.698251896381977e-07, -2.9525581512606399e-07, -1.495621091456335e-07, 1.1697432596209132e-07, -2.2921786679761149e-06, -2.2344957140311543e-07, 9.0079557167444004e-06, -4.7951397864926913e-05, -8.9395111720587663e-05, 0.00025656486918183087, 0.00025588309866116956, -0.00073983779212979841, -0.0015213421071961196, -9.2403301086677145e-05, 0.0017855278470929681, 0.0015458463998575377, -0.00061369027212951951, -0.00026504628413918208, -0.00087036902540521815, -0.0012627180005201106, -0.00080421955077315159, 0.00014616084301033664, 0.00058802678854243985, 0.00023126432473923958, -0.00010449095558686259, -0.00010228145451208669, 1.9325523686774618e-05, 3.0323974870826362e-05, 1.2683141406816166e-06, -1.2058446868057975e-06, 8.8143768771753332e-07, 3.3549731120851134e-07, 9.1056799261659957e-08, 2.0577319091974112e-08, 9.2830259427826791e-08, -6.4704839947157811e-07, -4.5648010846713924e-07, 2.1033881238566881e-06, 7.32796229427314e-06, -2.4374370669839543e-05, -2.5898674317115741e-05, 0.00011257144284409361, 0.00014693728608109456, -0.00023924588800045181, -0.00050123772700090606, -7.4435208380385973e-05, 0.00068444397565025586, 0.00083207770824480598, 0.00048828956300996052, 0.0, -0.00043330868466009542, -0.00064651493374645564, -0.0004135205525089448, 5.8232578355565087e-05, 0.00026030164250996835, 0.00011785219152459624, -5.0479429154057332e-05, -4.1543191833568309e-05, 7.7550355275730399e-06, 8.5787889709012739e-06, 5.074268522214453e-08, -1.5265704867968537e-06, 7.6127420915855944e-07, 3.4322773606588538e-07, -2.4467237539618118e-08, 0.0, 2.4467237179738174e-08, -3.4322773619012653e-07, -7.6127420919217151e-07, 1.526570486753494e-06, -5.0742685069794458e-08, -8.578788970889695e-06, -7.7550355275692266e-06, 4.1543191833568309e-05, 5.0479429154150824e-05, -0.00011785219152460185, -0.00026030164250998353, -5.8232578355579629e-05, 0.00041352055250904981, 0.00064651493374653229, 0.00043330868466019738, 0.00026504628414032808, -0.00048828956301001061, -0.00083207770824431527, -0.00068444397564927856, 7.4435208380627533e-05, 0.00050123772700078214, 0.00023924588800066727, -0.00014693728608088972, -0.000112571442844023, 2.589867431722904e-05, 2.4374370669918344e-05, -7.3279622940927939e-06, -2.1033881238922216e-06, 4.5648010853483173e-07, 6.4704839933564965e-07, -9.2830259571647903e-08, -2.0577319091885375e-08, -9.1056799550122255e-08, -3.3549731127660601e-07, -8.8143768768718392e-07, 1.2058446867643514e-06, -1.2683141406445925e-06, -3.032397487090597e-05, -1.9325523686839914e-05, 0.00010228145451204714, 0.00010449095558694352, -0.00023126432473908535, -0.00058802678854225174, -0.00014616084301019596, 0.00080421955077363764, 0.0012627180005203068, 0.00087036902540495523, 0.0024385469973038903, 0.00061369027212936067, -0.0015458463998569551, -0.0017855278470920858, 9.2403301086626811e-05, 0.0015213421071961089, 0.00073983779212967297, -0.00025588309866126459, -0.00025656486918189489, 8.9395111720511796e-05, 4.795139786497207e-05, -9.0079557166165035e-06, 2.234495713888465e-07, 2.2921786679921674e-06, -1.1697432602157082e-07, 1.4956210883105962e-07, 2.9525581512599554e-07, 3.6982518948350376e-07, -1.5771327547503337e-06, -1.4661018806631417e-06, 1.2650266391950919e-05, 2.6898547210308593e-05, -5.7987669870649895e-05, -0.00012119187628649009, 0.0002925926520794114, 0.00040485086541640515, -0.00072852984351041105, -0.0018583554775031031, -0.00045127797385343153, 0.0021581469455775027, 0.0035330841487132328, 0.0029055731292758334, 0.0049406694317394081, 0.0026668961742812758, -0.0032489106979216591, -0.0061280004658477299, -0.00099233616545883708, 0.0037574725417350639, 0.0029572761111822826, -0.00033450965931128095, -0.00060624989809528011, 0.00019783492062561489, 0.00012444306086323596, -8.8789075876270673e-06, 9.6967633574076482e-06, 1.7083459920778764e-05, 4.5999439011767153e-06, 1.5023935031916601e-07, 1.039253205622084e-06, 1.1348311616083971e-06, -5.7016743603616383e-06, -1.04988405409158e-05, 4.7705175525396455e-05, 7.4153907084401847e-05, -0.00011997798601094042, -0.00015619540664609709, 0.00091174996356957938, 0.0014758375936678126, -0.0017951616167126566, -0.0051951770049386038, -0.0018458707949728875, 0.0053021820779076802, 0.0076603598190795076, 0.0058001455908669262, 0.010866608608631407, 0.0083450930318392878, -0.011156251045764934, -0.022756702713130041, -0.0088049724290099694, 0.0092589342553874195, 0.0082884630632298704, -0.0013503752362499656, -0.0027089055320300547, 0.00063432051689115061, 0.00039743496113240219, -5.135728914582959e-05, -5.2908539732616404e-05, 3.3020030344762441e-05, 1.4241006554950027e-05, 1.9066336197302612e-06, 3.1629035250082296e-06, -2.352698377375767e-06, -1.1566718045553533e-05, -1.9807787751344911e-05, 0.0001015450545386955, 0.00024058911609209111, -0.00033799731924550203, -0.00061169662744447323, 0.0034294950764026141, 0.0053053978312845272, -0.0051385037481194926, -0.016798455246852688, -0.00990834425863296, 0.0077151995614407626, 0.017758841021732009, 0.011586446122093877, 0.029192878339711306, 0.019155633990847316, -0.018107593495138137, -0.049513273245605283, -0.024427880538050034, 0.02578610983152671, 0.024179081541404305, -0.0040508976947941731, -0.0074009891423912162, 0.00074739544714725432, 0.0013059386478792266, -0.00021177469863582771, -0.00019381368934936018, -2.2930933947504607e-06, -3.3208780385072546e-06, 4.0922137139897878e-07, 2.9451008005957237e-06, -2.5461973862464916e-06, -1.3817898708041393e-05, -2.7664402380974939e-06, 0.00014335933849003848, 0.00032293603684169041, -0.0010462542577808741, -0.0027471626893686612, 0.0076924518412050408, 0.015463651616642399, -0.0066672447446463326, -0.039127433373255908, -0.024267798198958437, 0.020723423884568916, 0.036204190826296979, 0.02796263641808593, 0.04459501328781619, 0.076725145240063533, 0.02508375199406461, -0.05716734954522297, -0.045775294033398015, 0.033233971766656642, 0.04064403555503332, -0.0020660684229550407, -0.0092738136737237076, 0.0030755347988242901, 0.0049027471727904398, 0.00041873515724895311, -0.00016667120940430416, 9.1308082212913032e-05, 1.549254741618293e-05, 6.4845694559219288e-06, 1.5127801448997605e-05, 1.5262538853884928e-05, -3.2292215968025048e-05, -0.00013094293222960533, 0.00041655443776571118, 0.00065141687607211561, -0.0030103388508485036, -0.0067665755556069011, 0.013573759545388975, 0.035913352096674386, -0.011216629301031098, -0.076392838961451187, -0.023239798472537657, 0.073384871025009249, 0.090257019037460764, 0.043366337948898895, 0.0086431961771646949, 0.12085880532211546, 0.074150026014186479, -0.16309710351628132, -0.19383851234462879, 0.030431544048198395, 0.12994912866694291, 0.024165671520133634, -0.005675466444331592, 0.0071882829440315836, 0.0055035547036740139, 0.00088473043957880925, 0.00011425582754175175, 0.0003344519075645258, 0.00015838596778393289, 3.138815545460048e-06, 3.5001088996629286e-05, -1.1123369889024881e-05, -0.00023394715134996501, -0.00072826354344829888, 0.00098879884805594702, 0.003290394241803499, -0.0020177112398542039, -0.0087641985076504607, 0.017697451862991015, 0.053766563890133824, -0.037338151491471468, -0.12470331491202422, -0.01783418219227963, 0.13105274525765467, 0.12426113686156864, 0.016216948868002876, 0.13256769577232769, 0.28285607915278405, 0.16694523801433089, -0.32156463816915598, -0.39450427611204497, -0.011288166830458839, 0.21998547499285451, 0.060786209275753553, -0.016920458777085551, 0.010909574115054964, 0.0031901125163300605, -0.00033489534843075342, -0.00057512008113319081, 4.8241347431542723e-06, 0.00034629566400617116, 6.2852929823858467e-05, 4.1965636442186823e-06, -5.5592435290969e-05, -0.00039593785796146729, -0.00084895033746647957, 0.0019408045705911188, 0.0040798293321673848, 0.0017849945305527092, -0.014396528935747516, 0.03904218756455085, 0.15466514236919257, -0.062357469812048469, -0.3359148726157663, -0.19448842973357355, 0.24770054522287124, 0.26668667634059967, 0.093306847874868246, 0.24374357403537067, 0.55012213491904793, 0.2933842882858228, -0.56507750226207876, -0.37357513895849492, 0.28478039773668301, 0.24153406544338699, -0.010501517567550396, -0.069260754853324669, 0.016030883614829131, 0.02888856442560565, 0.0025172833852350443, -0.0019825160649420428, -0.0012356709589064721, 9.5383065712676177e-05, 8.4925580281910716e-05, -2.7603484500895416e-07, 1.575415238022084e-05, 8.9980842426463958e-05, -0.00015455144974887674, 0.0010414824560444731, 0.0060917930216443658, -0.0062294082126362589, -0.032374807759909592, 0.086092076891526537, 0.23992875156785606, -0.031449374349395362, -0.4991450162764392, -0.37230089042480613, 0.36850284921393162, 0.65203784187591551, 0.28356643882607629, -0.33562708516576939, -0.13102742771679063, -0.074442669441771941, -1.108414225433116, -0.48971199898009049, 0.75726357904359165, 0.48975266484252722, -0.10414416266224276, -0.057375162080317302, 0.067614335954062174, 0.034551401114022537, 0.0026415953474081431, -0.0033313264069329894, 0.00017599692518009282, -0.00024141713667201988, 0.00013701607546791344, 0.00011043948472760822, 5.2753025427777066e-05, -0.00056282220383580418, -0.001473040310695623, 0.0020857584923045986, 0.01263191509663575, -0.0049276280752216023, -0.079426421106262579, 0.0038282192087295479, 0.21158932458700425, 0.25337707381982338, -0.19299106678658623, -0.4702178996619516, 0.09917627706172702, 0.049174883996283732, -0.27104375713022683, -0.66892838780721375, -0.27670322508415546, 1.1733277795586157, -1.1747425146844417, -1.7859746696260967, 0.13482498836119791, 0.62579430924026835, 0.19110346978313578, -0.0092010764075083889, 0.091541716420705743, 0.035798177116234828, -0.01080872095146141, -0.0074805689709430082, 0.00087982491421515624, 0.00019700064887198773, 0.00029830757497410965, 0.00023746053900133802, -0.00038855444421207136, -0.0021493865206616879, -0.0020376676236788177, 0.0043034893865325514, 0.024692552146162169, 0.021674632648672077, -0.083590457495018658, -0.13101858584940929, 0.35705699907666349, 0.7431358427778344, -0.3427855602261542, -1.5181969873975907, 0.30510623667849562, 0.32755194356284562, -0.73208772838799718, -0.1739293166430094, 0.68321209765005741, 1.3646033921720888, -1.0423906489195836, -1.7469053421591101, 0.14363219386863219, 0.10008726366432133, 0.087282929002584164, -0.062587439504234912, -0.019764169882346593, 0.016921302325211187, 0.02451231341789838, -0.007204075602470608, -0.0010417550100130558, -0.0011018135930777443, 0.0003880911286887635, 7.1306556535960909e-05, -0.00012946526299007061, -0.0020720238780864522, -0.0058947313405104855, -0.0092883221388232445, 0.031638182474279679, 0.071248172851421404, -0.046213719349399086, 0.048937158811492507, 0.62247639588288617, 0.35022259842939113, -1.375028739424532, -1.3054063480052007, 1.7422719766284596, 1.2315545205448166, -0.21368421587766057, 2.5251159246586199, 3.9986185110220571, 1.6423378558800306, -3.2598446139294928, -2.6508673621629413, 1.3408717866717237, 0.65229037787562116, -0.30815180494462602, -0.24794675857842133, -0.1567900354280353, -0.00090322875228194491, 0.016837193889943952, 0.0081457928016650735, 0.0053134061063229068, 0.00074442767565938834, 0.00040743814870428352, -9.792756390863333e-05, 0.00046042150692909031, -2.0439677469763416e-05, -0.0094203803992774331, -0.0093680389241246331, 0.010577484531255831, 0.020104296689693778, -0.067130744005831841, 0.032511080574428954, 0.049496223745927104, 0.29759023847787003, -0.40772972397284141, -2.5763030038597421, -1.0086268501795939, 3.2520008240455529, 3.127661107821488, -1.1141581132568867, 1.3641708343500387, 3.614150940121283, -1.3538813012752458, -2.2824415889165408, 0.81053000193537672, 1.2979029496509369, -0.25796922219793567, -0.14660089916526964, -0.034224425977123246, 0.020739891572330926, -0.016351947795325953, -0.0051337344665883956, 0.0051624614514157383, 0.0015037083336985342, 0.00012883481245927331, 0.00046271928878641655, -0.00017988558455328343, -0.0016882901545534784, -0.0080668085023415624, 0.018334336057616227, 0.0075287995749028155, -0.017661918975066519, -0.38808563795590117, -0.29294962083792109, -0.11812270190565234, 1.2090975123731191, -0.58382335305071487, -3.2397405202403844, -1.1933011924316363, 5.2801379304709686, 0.84173680321989663, 2.3563074320989759, -2.7217236711600976, -1.4940913514434744, 2.1710672351706584, 1.1229487194040595, 0.96053455050254277, 0.96211078676817896, 0.035800396396013512, 0.15414023444697636, 0.10125602185153926, 0.014179868174359136, -0.01737541651892931, 0.0062087670781442571, -0.0042603852180286457, 0.0020032348035250135, -0.00087575929196809612, 0.00053942936844551738, -0.00056775738923165191, 0.00040440768488539494, -0.0012110563015865644, -0.0044172524913444079, 0.015096007795395007, 1.9831683135784154e-05, -0.23604949314850127, -0.30943623202091552, 0.10726288955095381, 1.2119335549119155, -0.73477199535914062, 0.41468157127337302, 3.1655869149224372, -2.162725826339043, -2.5879403475863874], "height": 32, "width": 32, "top": {"real": [26312.861486548059, 16394.776884218503, -3997.4541326480944, 12005.135907922067, 1177.5601778241692, -334.84971513551272, -198.67917160941846, -63.09118295690562, -26.0143192287494, -17.75101650843531, -4.1366280143888243, 0.89820537026572267, -0.32480674164662798, -0.084346178359567467, -0.13448645703297074, 0.022458369013166949, 0.0037906136595566063, 0.022458369013118644, -0.13448645703284343, -0.084346178359639243, -0.32480674164661494, 0.89820537026588532, -4.1366280143890872, -17.751016508434784, -26.0143192287494, -63.091182956905335, -198.67917160941835, -334.84971513551284, 1177.5601778241696, 12005.135907922073, -3997.4541326480962, 16394.776884218489, -7474.6405977592167, -8567.9043780819939, -2236.1016166727777, 5029.218127936877, 173.97100199359824, -922.65330403810697, -153.6610478382718, -4.01177942588299, -14.977979358030328, -15.430842802070819, -7.4975861096446677, 1.585406689794443, 0.17906893603683641, -0.1458960091743404, -0.061043080293462629, -0.0046072373939513231, 0.0087184428309440426, 0.017310354876342828, -0.025331085027308461, -0.090673583392976279, -0.39184400032069594, -0.73078681815467361, -0.92174645774086517, -10.93402591728189, -30.447262913620346, -38.126922827402865, -60.968110303669619, -681.13286643622507, 624.53857955695969, 7785.4292550857708, -1762.2326743166159, -6145.3703500362362, -30710.86949592911, -20630.868893573344, 1300.6579518513645, 5360.9184206698983, 848.32865192899703, -785.98438030181387, -108.77167233308913, 41.321279695295864, -0.027644771384101652, -9.534868349699865, -1.2097145653165393, 0.21253485530640887, -0.28694451643507407, -0.19362286330376682, -0.015513947258845627, 0.0028928780958250894, 0.010770434199071796, 0.0037362591288644677, -0.033458104535328603, -0.15988488342210658, 0.11739550901211815, 0.74668900068008903, -4.4804803612995503, -15.856083499246324, -27.816492049240171, 2.1424019920280393, 12.12605916297551, -787.56867680882806, -403.54468101232709, 3807.5774006807187, 4390.1153105308758, -17039.959036708919, -13609.16252827678, -9138.4955296375883, 2497.0113342386512, 4397.1447406314655, 786.4046140955403, -371.53196930683333, -41.579492344426484, 10.792253245683401, 12.926010493557772, -0.94130122169806685, -0.22574146482830848, -0.15910329528413825, 0.039542877145191092, -0.16497562627541082, -0.034546572003498262, 0.0028396778151660528, 0.0095036050242090567, 0.0028202375766785176, -0.035341389521162114, -0.14687879382002816, -0.12611798259866741, 0.45588994614236095, -0.25876313947681329, -11.107804183612142, -9.8469518252878121, 5.4748636450494486, 23.93852180867734, -449.68159927787053, -188.33038343684237, 3370.1365438276152, 4992.3705750204963, -4902.8469709692872, -11751.949054213763, -9055.7727899285892, -1597.312584178899, 1957.0910297219173, 675.954300804676, -59.523430315468971, 3.5981209875694646, 26.908851107336638, 3.3880871060788613, -6.3950609995768, -2.7652104861310596, 0.51553772502971873, 0.20366584836429452, -0.078076761518840479, -0.032306588307275633, -0.00033732640143732022, 0.0039882283816162498, 0.00882576812785189, -0.010351412440947377, -0.13141543694038546, -0.35838805663068013, -0.083665866496770311, -0.11489505024575582, -2.0174170653233996, 5.313800098890094, 16.719706304911163, 26.780389598343444, -155.76938280407634, 15.711518936085053, 2108.6641632789715, 2004.0776030609009, -5284.4851508729253, -7525.5124487476332, -5804.138136685775, -1404.695681801157, 766.79772203943867, 489.03634446603957, -8.722049146589729, -31.327724554225572, 11.011155797013167, -0.50779722959414419, -5.7422528468514669, -2.0029903992471274, 0.11899325802032906, 0.035426363555884931, -0.0016279289016664685, -0.0068853887710592244, 0.00084949455245666495, 0.0025820557167290517, 0.004778391224536287, -0.0060776628020400699, -0.066021172391945146, -0.14585644547184912, 0.31419533009862166, 0.4720008156080655, -3.7567756530835696, -5.2990493438664403, 20.309232259116531, 43.66331695464585, -13.481975167534534, 87.480286025038623, 872.01902032865974, 302.59784669978308, -3861.3331359414924, -2689.7311891987174, -2302.5619774650818, -533.70879716435536, 471.82586926866179, 253.24935366729582, -54.914023853010136, -45.128050992983141, 1.7233725901997559, 4.8083890914979186, -1.2558586165362935, -1.1198886962259056, -0.17080663964208292, 0.0073776692393840732, 0.01315742418122162, -0.0042018888945982991, 3.9927404722540691e-05, 0.0024301018087218612, 0.0013997723845362102, -0.01262770667339704, -0.024640414526077212, -0.031798236031438429, 0.16501061208698242, -0.053070166605889257, -2.4508298603470875, -6.1804125133917358, 1.555942705006216, 9.6369277380044327, -40.990915592068667, 48.381114122456317, 486.73310475433823, 304.00864677044143, -1317.5468335758922, -1423.509046098827, -1206.2870766014189, -258.09420634314597, 284.39023574769527, 170.47470391854262, -20.992706500305374, -30.973343141495711, -0.73408381954002189, 2.8760611038460322, -0.96452576448322436, -0.33780530346449972, 0.050525784186614971, 0.037431091543099905, -0.0017411003602284265, -0.0094665916234262064, -0.00075468105471295627, 0.0012390824544828156, 0.0015406044848658253, -0.0042340021876475491, -0.0099527381839567483, -0.017832280274117901, -0.0021885919874408454, -0.18486506545171935, -1.5473028239900652, -0.46733110563156899, 7.0159472975173207, -4.1293951866555583, -52.177815979563, -14.225382292199997, 266.2443485847607, 299.68761898427294, -502.75722346741452, -600.46969991458195, -533.72028053649831, -84.35869563264292, 149.66956177052822, 98.021239180316712, 5.9461121297863162, -11.840914283794969, -2.356375469113162, 0.20453312434178955, -0.31158766591945325, -0.14520584302328118, -0.014067565159284239, 0.014308802406409332, 0.0017127836707298723, -0.0045784971805314283, -0.0004316686427205439, 0.00062035219223615539, 0.00098821093942306776, 0.00037352179846464215, -0.0031201129359879932, 0.0028053468557916969, 0.01155415730259296, 0.043098557260407636, -0.50100451968487536, -0.34405016878893097, 4.6091984823197363, -1.1472068176591008, -29.145899633206373, -2.6052151602709381, 142.77222209569624, 179.10482852523111, -159.1039510457467, -164.80060347644744, -151.52622363641359, -12.964795600796743, 78.707005278515467, 49.611102594467418, 2.9148898834797565, -6.6982557512143011, -1.1108929795277851, 0.53317200343106397, -0.060952672321508208, -0.13796026336886294, -0.040312063728342999, 0.0091529292682895457, 0.00069551217754917558, -0.00049216012286125183, 0.00019632055084333887, 0.00016453496496604428, 0.00035411166615570894, 0.00029458111873911975, -0.0039224781743007692, -0.0012902932474049059, 0.022738683086130741, 0.0029642733314895081, -0.040660255117105054, -0.1581093035213153, 0.50820914967959807, -1.1517329733377961, -10.955670081779706, 6.6684998469426819, 73.509265817506147, 94.854507489855607, -30.375445723654334, -41.976518122871582, -38.330831793041703, 6.6541528790739966, 26.775549975763919, 13.67501905826837, -0.77255683543203624, -2.6427995487036586, -0.26778321549867995, 0.38263920912663341, 0.066476687185755071, -0.060499325131928558, -0.013860605018094061, 0.0044705403327676731, 0.00045553699537380387, -6.6832908987799432e-05, 5.7815338715827767e-05, 2.4201934805748865e-05, 2.4116728282913401e-05, -7.7908669355443089e-05, -0.0020106249903568347, -0.0030945645282710967, 0.011724362942541916, -0.0073188065692862368, -0.13872845280170487, -0.0525083726541943, 0.57465299048466112, -0.38679604474522938, -4.8536563727710194, -1.1675628703507077, 21.601631857858344, 37.913461849891526, 8.2459776248906191, -17.728252948144338, -17.913066539877509, -1.363521120172412, 8.6874027327585566, 5.1086905995493517, -0.15956522315726163, -1.0853380408525961, -0.17672593964480066, 0.18144159918607325, 0.051467156562084934, -0.020596344531497161, -0.004731774665412903, 0.0025169723177923789, 0.00031643566338613672, -0.00017373359946045594, -7.1999178350316855e-05, 3.5348452681660421e-06, 3.7806930339121046e-05, 2.3729245648202859e-05, -0.00042972130823292398, -0.0011045036274546954, 0.0022387979975912117, -0.0041954404795751096, -0.054281237122749564, 0.0079821569677783755, 0.36123191988222408, 0.078230863522083471, -1.8108271356936088, -1.1161504624718657, 6.2644803438069099, 11.381535938317967, 0.21980447663235644, -5.9387280202325705, -6.1357877592112944, -0.72356703610536932, 2.8717612965534967, 1.8272689141068139, 0.038901829717158748, -0.30585525507098987, -0.058991941107951799, 0.049323041374202826, 0.007749491998403548, -0.0026797748220028393, 2.6063267012890291e-05, 0.00066159304663239156, 7.7278494902114205e-05, -3.1100603910792207e-05, -1.5561043109534526e-05, 1.1911742325626112e-05, 2.0491322447673862e-05, -1.4767672160855649e-05, 7.2375275064916669e-05, 0.00028278010837829711, 0.0018655623121081823, 0.00079665654087039228, -0.014230202242318532, 0.015605588027909496, 0.15269277354560382, 0.042410343620558247, -0.5991836734745446, -0.42273281817515368, 2.2232923752479885, 4.029734867596904, -0.01297332387246361, -1.8890504514660771, -1.7044228721383259, -0.014407089546523855, 0.81475328270242842, 0.49486328945653796, 0.051378645502378667, -0.078019191874231134, -0.019791976482152574, 0.011942087677832957, 0.0037710881620078929, -0.0019373229659441914, -0.00028867057981419789, 0.000173087047265503, 3.9265425732721298e-05, 5.3761386290662811e-07, -1.6483764627679784e-06, 1.9354497917760563e-06, -1.043216287920153e-06, 1.251541032126094e-06, -2.0395625891304971e-05, 2.3143507174682374e-05, 0.0008565768791742647, 0.0015425089335333231, -0.0038713470880909978, -0.0045226552231720603, 0.026481416655982141, 0.0024818042284060491, -0.15643670700640799, -0.014637771070647379, 0.7413395210802084, 1.1863896819067066, -0.06073539777241771, -0.55423720177498148, -0.41318433868106841, 0.012013582173996683, 0.22946537156729221, 0.14022496275890783, 0.010987988714373856, -0.01679009744687791, -0.0027663623850498948, 0.0015534913917298809, 0.00054985818249530594, -0.00042583544807556255, -0.00029614878449876606, 1.3565162632662745e-05, 4.7965965686279184e-06, -1.4046487964451716e-06, -1.7593082382469076e-06, -2.320036873447806e-06, 2.4848934678754374e-07, -1.4522884424931378e-06, -5.2082671731122632e-06, 2.3151589195966712e-06, 0.00016541664707348802, 3.6529125267961852e-05, -0.0012890410598031484, -0.0010500227857359876, 0.0036910380457585109, -0.0025549445466396393, -0.038104522129866786, 0.016868811542239164, 0.22147893162995161, 0.26972216562160328, -0.11164745685412412, -0.1053213699265967, -0.065169792191789519, 0.050967642716828229, 0.082203097259608671, 0.037973776532028221, 0.002270145289904118, -0.0034852771985896215, -0.00051797014017785649, 0.00065999477810424847, 9.1449959395068298e-05, -9.1204391021716067e-05, -1.5180477673862282e-05, -1.4304323510152094e-05, -4.7668675387694358e-07, -3.3807620398649656e-07, -3.2827005154992035e-07, -6.0059383407177672e-07, 4.743645802817471e-07, 7.8835950629218593e-07, -2.5363312932279684e-06, 3.4933053894102948e-06, 4.918354682850915e-05, 9.9367636232135646e-05, -0.00011095747475971185, -0.00033735388707191222, -0.00017205199767281925, -0.0028150966049269007, -0.0066263773562998379, 0.016874993354405541, 0.081392801874071885, 0.10016944284496203, -0.0039898740972888948, -0.056558682919194136, -0.015674616081580436, 0.047420248352959368, 0.048984183536402902, 0.018095648558125472, 0.00019061585891928039, -0.00055865816852282587, 0.00028385103022481571, 3.8670538186828884e-05, -1.6713711240799624e-05, 3.5388781701807323e-05, 1.8038642046719724e-05, -2.7952818635613013e-07, -2.4658127673140311e-06, -1.5227319963665806e-07, -2.3332675048126655e-07, -1.3019579049092348e-07, -2.3332675083373355e-07, -1.5227319920541638e-07, -2.4658127673110402e-06, -2.7952818599492315e-07, 1.8038642046284464e-05, 3.5388781702455181e-05, -1.6713711239992412e-05, 3.8670538186828884e-05, 0.0002838510302257955, -0.00055865816852375373, 0.00019061585891278605, 0.01809564855812688, 0.048984183536407218, 0.047420248352966703, -0.01567461608157503, -0.10532136992661453, -0.0039898740972773798, 0.10016944284504853, 0.081392801874075937, 0.016874993354393339, -0.0066263773562901859, -0.0028150966049217711, -0.00017205199767197964, -0.00033735388707121654, -0.00011095747476002673, 9.9367636230791154e-05, 4.9183546829807197e-05, 3.4933053890940453e-06, -2.5363312945761086e-06, 7.8835950614532164e-07, 4.7436458143049758e-07, -6.005938340711767e-07, -3.2827005209480802e-07, -3.3807620383163872e-07, -4.7668675369876225e-07, -1.4304323509881206e-05, -1.5180477673786216e-05, -9.1204391019992904e-05, 9.1449959396039146e-05, 0.00065999477810600097, -0.00051797014017666832, -0.0034852771985941946, 0.0022701452899007964, 0.037973776532033036, 0.082203097259589145, 0.050967642716782412, -0.065169792191780859, -0.55423720177488789, -0.11164745685411237, 0.26972216562160034, 0.22147893162997134, 0.016868811542243251, -0.038104522129865558, -0.0025549445466363117, 0.0036910380457617423, -0.0010500227857337837, -0.0012890410598025771, 3.6529125267327953e-05, 0.00016541664707448109, 2.3151589193372615e-06, -5.2082671739343036e-06, -1.4522884428117831e-06, 2.4848934734967557e-07, -2.3200368734485688e-06, -1.7593082396192173e-06, -1.4046487964490078e-06, 4.7965965689104361e-06, 1.3565162632914686e-05, -0.00029614878449827947, -0.00042583544807430477, 0.0005498581824961642, 0.0015534913917295296, -0.002766362385049678, -0.016790097446884332, 0.010987988714361836, 0.14022496275891236, 0.22946537156726918, 0.012013582173935911, -0.4131843386810784, -1.8890504514661226, -0.060735397772418001, 1.1863896819067115, 0.74133952108018497, -0.014637771070638499, -0.15643670700640161, 0.0024818042284152002, 0.026481416655986481, -0.0045226552231720108, -0.0038713470880910664, 0.0015425089335324559, 0.00085657687917487868, 2.3143507174645941e-05, -2.0395625891635653e-05, 1.2515410319035661e-06, -1.0432162880357027e-06, 1.9354497917755154e-06, -1.648376462389003e-06, 5.3761386277171334e-07, 3.9265425733411684e-05, 0.00017308704726561608, -0.00028867057981368457, -0.0019373229659434092, 0.0037710881620082728, 0.011942087677832796, -0.019791976482151457, -0.078019191874226498, 0.051378645502381547, 0.4948632894565238, 0.81475328270235614, -0.014407089546580973, -1.7044228721383166, -5.9387280202324542, -0.012973323872509449, 4.0297348675968632, 2.2232923752479965, -0.42273281817513425, -0.5991836734745476, 0.042410343620560523, 0.15269277354560529, 0.015605588027911042, -0.014230202242318617, 0.00079665654086961773, 0.0018655623121089473, 0.00028278010837819401, 7.237527506430049e-05, -1.4767672161149705e-05, 2.0491322447334689e-05, 1.1911742325624598e-05, -1.5561043110042614e-05, -3.1100603910787708e-05, 7.7278494901711681e-05, 0.00066159304663245509, 2.6063267012872924e-05, -0.0026797748220015139, 0.0077494919984037978, 0.049323041374203298, -0.058991941107945506, -0.30585525507097922, 0.038901829717163883, 1.8272689141068059, 2.8717612965534687, -0.72356703610543815, -6.1357877592112144, -17.728252948144313, 0.21980447663230326, 11.381535938317855, 6.2644803438068752, -1.1161504624718652, -1.810827135693615, 0.078230863522088162, 0.3612319198822263, 0.0079821569677794718, -0.054281237122748544, -0.0041954404795757263, 0.00223879799759173, -0.0011045036274548153, -0.0004297213082331914, 2.3729245648252329e-05, 3.7806930338968797e-05, 3.5348452681631499e-06, -7.1999178350888311e-05, -0.00017373359946041533, 0.00031643566338576109, 0.0025169723177924353, -0.0047317746654124164, -0.020596344531496415, 0.051467156562086717, 0.18144159918607133, -0.17672593964479372, -1.0853380408525777, -0.1595652231572473, 5.1086905995493037, 8.6874027327584269, -1.3635211201724846, -17.913066539877416, -41.976518122871397, 8.245977624890596, 37.913461849891497, 21.601631857858315, -1.1675628703506762, -4.8536563727710167, -0.38679604474523593, 0.57465299048466256, -0.0525083726541926, -0.13872845280170543, -0.0073188065692886169, 0.011724362942542425, -0.0030945645282711917, -0.002010624990356365, -7.7908669355331091e-05, 2.4116728282715131e-05, 2.4201934805746541e-05, 5.7815338716136568e-05, -6.6832908987693356e-05, 0.00045553699537366862, 0.0044705403327679654, -0.013860605018093377, -0.060499325131926705, 0.066476687185756819, 0.38263920912663169, -0.26778321549867512, -2.6427995487036529, -0.77255683543202414, 13.67501905826833, 26.775549975763717, 6.6541528790738154, -38.33083179304154, -164.80060347644644, -30.375445723654281, 94.854507489855592, 73.509265817506247, 6.6684998469427503, -10.955670081779644, -1.1517329733377899, 0.50820914967959985, -0.15810930352131641, -0.040660255117104735, 0.0029642733314879993, 0.0227386830861314, -0.0012902932474053552, -0.0039224781743013607, 0.00029458111873885689, 0.00035411166615547979, 0.00016453496496604298, 0.00019632055084304811, -0.00049216012286159682, 0.00069551217754943101, 0.0091529292682893254, -0.040312063728344255, -0.13796026336886155, -0.060952672321507556, 0.53317200343106097, -1.1108929795277824, -6.6982557512142833, 2.9148898834797672, 49.611102594467262, 78.707005278515183, -12.964795600796847, -151.52622363641291, -600.46969991458195, -159.10395104574698, 179.10482852523111, 142.77222209569621, -2.6052151602709213, -29.145899633206394, -1.1472068176590924, 4.6091984823197309, -0.34405016878893097, -0.50100451968487369, 0.043098557260408649, 0.011554157302593657, 0.0028053468557916613, -0.003120112935988917, 0.00037352179846528708, 0.00098821093942341102, 0.00062035219223615539, -0.00043166864272108633, -0.0045784971805325507, 0.0017127836707311211, 0.014308802406410212, -0.014067565159284841, -0.14520584302327849, -0.31158766591945286, 0.20453312434178955, -2.3563754691131549, -11.840914283794984, 5.9461121297862585, 98.021239180316684, 149.66956177052836, -84.358695632642934, -533.72028053649808, -1423.509046098827, -502.75722346741475, 299.68761898427243, 266.24434858476053, -14.225382292200068, -52.177815979562951, -4.1293951866555521, 7.0159472975173225, -0.46733110563156605, -1.5473028239900675, -0.18486506545171727, -0.0021885919874428559, -0.017832280274118859, -0.0099527381839588144, -0.0042340021876453469, 0.0015406044848677103, 0.0012390824544828119, -0.00075468105471319154, -0.0094665916234262307, -0.0017411003602265445, 0.037431091543101133, 0.050525784186618933, -0.33780530346449777, -0.96452576448320959, 2.8760611038460344, -0.73408381953999657, -30.973343141495679, -20.992706500305406, 170.47470391854245, 284.39023574769476, -258.09420634314608, -1206.2870766014166, -2689.7311891987179, -1317.5468335758917, 304.00864677044098, 486.73310475433766, 48.38111412245636, -40.990915592068674, 9.636927738004438, 1.5559427050062113, -6.1804125133917411, -2.4508298603470964, -0.053070166605885212, 0.16501061208697854, -0.031798236031439234, -0.024640414526075623, -0.012627706673397836, 0.001399772384542092, 0.0024301018087218504, 3.9927404721417186e-05, -0.0042018888946034633, 0.013157424181215942, 0.0073776692393865565, -0.17080663964207793, -1.1198886962258996, -1.2558586165362777, 4.8083890914979266, 1.7233725901997718, -45.128050992983098, -54.914023853010271, 253.24935366729582, 471.82586926866219, -533.70879716435559, -2302.5619774650809, -7525.5124487476278, -3861.3331359414919, 302.59784669978211, 872.01902032865962, 87.480286025038581, -13.481975167534443, 43.663316954645794, 20.309232259116435, -5.2990493438664386, -3.7567756530835754, 0.47200081560804741, 0.31419533009862788, -0.14585644547184853, -0.066021172391939276, -0.0060776628020447684, 0.0047783912245386402, 0.0025820557167290522, 0.00084949455245703076, -0.0068853887710688764, -0.0016279289016736856, 0.035426363555892841, 0.11899325802032523, -2.0029903992471114, -5.7422528468514553, -0.50779722959413964, 11.011155797013195, -31.327724554225593, -8.7220491465898675, 489.03634446603934, 766.79772203943878, -1404.6956818011561, -5804.1381366857704, -11751.949054213763, -5284.4851508729271, 2004.0776030608997, 2108.6641632789701, 15.711518936085099, -155.76938280407595, 26.780389598343376, 16.719706304911028, 5.3138000988900851, -2.0174170653233965, -0.11489505024579171, -0.083665866496761998, -0.35838805663067708, -0.13141543694038144, -0.010351412440954411, 0.0088257681278659308, 0.0039882283816162533, -0.00033732640143905191, -0.032306588307287817, -0.078076761518840951, 0.20366584836429438, 0.51553772502971895, -2.7652104861310511, -6.3950609995767769, 3.3880871060788507, 26.908851107336602, 3.5981209875695015, -59.523430315469177, 675.95430080467531, 1957.0910297219166, -1597.3125841788988, -9055.7727899285874, -13609.162528276773, -4902.8469709692927, 4992.3705750204963, 3370.1365438276171, -188.33038343684228, -449.68159927787059, 23.938521808677311, 5.474863645049389, -9.8469518252878032, -11.107804183612158, -0.25876313947681701, 0.45588994614236283, -0.12611798259867754, -0.14687879382002969, -0.035341389521171523, 0.002820237576687255, 0.0095036050242090532, 0.002839677815167327, -0.034546572003505492, -0.16497562627542883, 0.039542877145184945, -0.15910329528412964, -0.2257414648283198, -0.94130122169803698, 12.926010493557788, 10.792253245683524, -41.579492344426235, -371.53196930683367, 786.40461409554018, 4397.1447406314655, 2497.0113342386503, -9138.4955296375883, -30710.869495929113, -17039.959036708926, 4390.1153105308786, 3807.5774006807205, -403.54468101232675, -787.5686768088284, 12.126059162975466, 2.1424019920278234, -27.816492049240171, -15.856083499246239, -4.4804803612996116, 0.7466890006801008, 0.11739550901211765, -0.15988488342208015, -0.033458104535332392, 0.0037362591288712223, 0.010770434199071798, 0.0028928780958374094, -0.015513947258866389, -0.19362286330377187, -0.28694451643508428, 0.21253485530639998, -1.2097145653165073, -9.5348683496998436, -0.027644771384098099, 41.321279695296035, -108.77167233308927, -785.98438030181433, 848.32865192899692, 5360.9184206698983, 1300.6579518513656, -20630.868893573341, -7474.6405977592276, -6145.3703500362381, -1762.2326743166138, 7785.4292550857645, 624.53857955695855, -681.13286643622564, -60.968110303669903, -38.126922827402971, -30.447262913620339, -10.93402591728205, -0.92174645774084907, -0.73078681815469149, -0.39184400032067312, -0.090673583392963469, -0.025331085027316205, 0.017310354876322938, 0.0087184428309440443, -0.0046072373940015798, -0.061043080293425964, -0.14589600917437914, 0.17906893603684051, 1.5854066897944772, -7.4975861096446481, -15.430842802070792, -14.977979358030328, -4.0117794258829509, -153.66104783827134, -922.65330403810628, 173.97100199359761, 5029.218127936876, -2236.1016166727782, -8567.9043780819939], "imag": [0.0, -565.83540142139123, 2034.1707150791078, -2899.4713440958676, -705.26395079653423, -264.15772704109196, -68.25893457091972, 21.864239089276673, -9.2600847387275351, -0.77203496144657713, 0.46094227484148159, 0.050432963713891818, 0.4817041633893655, 0.069133436726486502, -0.053750756537428696, 0.0072803724650655878, 0.0, -0.0072803724650335657, 0.053750756537431763, -0.069133436726473527, -0.4817041633893806, -0.050432963713828063, -0.46094227484152789, 0.77203496144659334, 9.2600847387275351, -21.864239089276733, 68.258934570919919, 264.15772704109207, 705.263950796534, 2899.4713440958658, -2034.1707150791096, 565.83540142139009, -27456.969846005039, 15801.95774991386, 6659.2852195136584, -5625.222440567115, -315.00701580725445, 272.57265196057085, -226.29890693046426, -11.162014580405042, 22.51960143730463, 12.777842336107099, -0.00080551226422213157, -0.40616257836882108, 0.090977957608488841, 0.020544905947865743, -0.0050852207874264883, 0.005762481528077454, -0.0051011628064007979, 0.008737332888475351, -0.024097393253454041, 0.064089909650063406, -0.12938270466631999, 0.53088177925581315, -0.6296735496972713, -5.9301461429211297, -10.810291764213344, -3.7416120100021248, -182.38596939283659, -362.28186950461651, -992.82929249872541, -4862.6686041022249, 4699.2031805565066, 18939.315780035107, 10706.514246895442, -4202.5064061160292, -8815.5169521241642, 1263.9440399653656, 1779.1449685952537, 162.85707963816941, -206.3024685851984, 13.222359870031848, 21.464492537709937, 20.567779042237813, 0.65600865155601296, -0.18805381897022255, -0.36223791541012046, 0.1254341335131833, 0.020744772339125268, 0.00182748958184843, -0.0042992876297386403, -0.0012201610716230688, -0.017092494175410845, -0.076964103250570653, 0.098376776437578264, 0.4173977832999109, -0.76419419802802224, 1.7461999698867376, 9.8585155596813561, 24.776358129244393, -211.6323955131393, -238.91976950528434, 1185.1238932642693, 1296.4366520857086, -4946.0282562867787, -5281.5723471297015, -13391.901368395223, -11194.545427930107, -3925.7577913329569, 887.46023361526534, 945.20766142433024, 84.877841434423829, -42.932263785691212, -4.9615998121405198, -2.2373513523401476, 3.2722596307272758, -0.72535972703625207, -0.26143602710083624, 0.17221216218193261, 0.13507416188085969, 0.00023543387332632535, -0.004345917754103765, 0.00085055424110927274, -0.0037937176827999176, -0.0081378837299059311, -0.075677036525131303, -0.15032468438850372, -0.38722147995532397, 0.029603642148641713, 7.4921225563560006, 16.360105748561345, 29.902810744114234, -93.460146257112015, -275.96221185192559, 922.99713133386672, 2711.515323984423, -1933.4800470053665, -10929.798398133844, 684.97959165063389, 602.54327944682984, -1010.3237650874754, -821.26497752603393, 354.91295307862521, 267.12706753457422, -50.770431510290891, -60.739251530981761, -3.0004343666525628, 2.078290590472712, -2.279554023627556, -0.70169954600639106, 0.15105372261757208, 0.07861078903623217, 0.022330776935849336, 0.0012282676678784887, -0.00060025303576528312, -0.0034390891352469423, 0.011529870687322991, 0.014029711179492978, 0.1252130338315626, -0.55405390993532211, -0.54107724731740914, 0.87667351785494574, 3.6828009300200657, -7.4141267588561011, -13.004195929909718, -24.795065499663313, 420.27054634951992, 459.95573868102485, -942.16755498192015, -1112.054015955898, 2348.3469931726836, 1883.3636695028392, -240.70143186447856, -105.71673535442261, 372.79259353377239, 52.920672453261901, -92.068040375826783, -26.276835867611968, 6.7051139314185226, 3.245275744583783, -0.60045275904084205, -0.50382743582039524, -0.067202922116500141, 0.024987588306014712, 0.02345280256265949, 0.0036069899885115028, -0.0019176843365481997, -0.0026716531574556067, -0.0020365413730906823, -0.011083467862231831, 0.11877640918683252, 0.22402554985838732, -0.99918245590032706, -3.4731271711763432, 0.48835520550537315, -13.858896676215748, -73.254839813416254, -21.319429226850428, 379.31228865246607, 351.81985736289278, -537.57809524921299, 401.89162402051699, 608.06184705207306, 404.48916791571293, -26.0947672494631, -28.936629621288695, 88.255503332807123, 24.728035394109561, -22.866056256077933, -13.157904592767515, -0.15967604903152702, 2.526299018978182, 0.12352888715752443, -0.23422795848566569, -0.030590557055647175, 0.016424937283601903, 0.0056060898486765369, -0.00045117160770213557, -0.00085071688314226489, -0.0011353628514113501, 0.0023693867958524341, -0.0020514022508182662, 0.047410658855092408, -0.047246191697244096, -0.80895482070078151, -2.1371851454270119, 2.4873407504647034, 5.7983733792054322, -40.953249308721645, -95.737309397844541, 76.822153629632922, 273.3130006291081, 25.450658270222483, 108.35753184636786, -342.27621105731498, -348.25890814832445, -304.47603827676795, -96.629055803978503, 63.023130997866865, 57.409949251798395, 2.568042168489272, -13.095155674154295, -3.2681008083097729, 0.88286993545095549, 0.13472332633921499, -0.098529564497226177, -0.013721933165641624, 0.0016719543218752051, -0.00081574697753264229, -0.00012016604513092251, 2.100818845429297e-06, -0.00060431365246994741, -0.00084901673761287883, 0.013320171975788974, 0.024623507369733132, -0.041782640680197221, -0.60700748329107235, -0.43012965453926089, 2.2891908586667724, 0.48632248954743251, -15.792270422196429, -28.193965034765785, 48.029615644247542, 111.09879990264463, -87.497164212346334, -334.6737117352032, -142.68730890272883, -91.053579482449521, -99.787409897491159, -55.001294578822431, 29.906016170654414, 37.535076920090127, 4.5234778785073582, -7.1923708075200636, -1.3689331500831903, 0.35202350218593043, -0.0362018905598291, -0.061463792395340174, -0.022721689012942182, 0.0082737875972394501, 0.0032130032530252534, 0.00039450994426574093, -2.8031778648544371e-05, -0.00041406827904942888, -0.0027075490516005737, -4.6035494233911042e-05, 0.0066681432594733418, 0.0047951528835353972, -0.05690176651734323, -0.24922608889607248, 0.498049017017482, -2.4309674287383847, -12.16171561638105, 0.97951365769633958, 48.129088343602525, 56.486069104567768, -41.171639289684258, -127.72312720337817, -5.4282746232061827, -9.7835860709552271, -33.975619755276277, -24.806312587182678, 2.4072249874859208, 11.539786987684712, 2.1158028157224305, -2.1858286220084042, -0.55165459871114553, 0.18427966087195025, 0.036325697906855962, -0.045150767767426783, -0.010550176613753719, 0.0060855196058800442, 0.0017281414610421119, 7.2497674435495387e-05, -0.00021205409372000895, -2.0602816877647228e-05, -0.0011298747328672136, -0.0028809147575241121, -0.0012342607279736744, -0.011825603754497111, -0.087069268286694118, -0.14265264682578704, 0.15323327509603407, -0.85687745542587679, -6.0248432237602145, -2.077910419819851, 20.474406237761055, 25.037428100181106, -14.989381828055835, -36.497593867080774, -17.729338100591551, -17.576621089243332, -19.487467662417078, -10.955871914675358, 2.3165455312690852, 5.4119853383600915, 0.54621288944966873, -1.3157595111644833, -0.34743645177227866, 0.1287210896998103, 0.047412118534244603, -0.0077851049698980206, -0.004201560949808625, 0.0010934558980435574, 0.00023257626702487001, -9.2808109881009371e-05, -8.7155323163908151e-05, -3.9084915731858744e-05, -0.00010250720925033233, -0.00067901668703098609, 0.0014464277080026529, -0.0048636342861169473, -0.067823949067901526, -0.057130716853855026, 0.21557912264683496, 0.06519665350656248, -1.6533046454778435, -1.8832932452039048, 3.7264846171107551, 6.4019126311322827, -3.9744235027987749, -16.160449140843355, -8.4822228391137156, -8.7315069105384708, -6.1656643244543572, -2.3598704650957352, 1.9985565184181031, 2.3405484242614913, 0.29382845386145329, -0.50865792651575648, -0.17305354955167165, 0.046960029345024031, 0.015263156905378368, -0.0036170611596276912, -0.0013726058920436061, 2.237332432783488e-05, 9.385945789129954e-05, 1.3994387363258527e-05, -1.5306190418175455e-05, -2.2179563572570082e-06, 1.915436069625878e-05, 1.6056362425269958e-05, 0.0016017335432058808, 0.0021630491325728405, -0.015795334924840046, -0.011660119791667443, 0.14639963344722604, 0.10651220377116319, -0.88291287420081066, -1.2568372820076821, 1.6004592076355926, 4.2391713347552544, 2.2028113471748907, -3.1469764634818462, -2.242974904561942, -2.5538673583000224, -2.2927664969925643, -0.71511526306228479, 0.70142225830116711, 0.87257163068624521, 0.19846976557711371, -0.15249245278412921, -0.070864296996220155, 0.0099358115635036701, 0.0047066150942456026, -0.0026523157902845263, -0.00085439958417801774, 0.00013944973801692797, 7.2704791039188404e-05, 1.2601241693252589e-05, -1.5809883406608869e-05, -1.0011729527080636e-05, -7.9478542847663604e-05, -0.00022527265138271089, 0.00045307702727412569, 0.00050105816519738884, -0.004694536759989586, -0.0093912827538699273, 0.048586273708375149, 0.030553958637497009, -0.25838788694247888, -0.40093326275917601, 0.49595628709938333, 1.6851565365398353, 1.1309597417418693, -1.056522952990393, -0.80247840632915779, -1.026927016182452, -0.88651914954529398, -0.43650779681426854, 0.11316541147379869, 0.23035854544536424, 0.059920467833033307, -0.036190438604187899, -0.01725390654373966, 0.0023509305274026565, 0.001478217289217426, -0.00072670648727194635, -0.0003680247758271001, 7.1552277723323216e-05, 3.3018347577537154e-05, -6.270504054453194e-06, -5.0961890322362396e-06, -8.2597481363066073e-07, -2.4936495372693928e-05, -0.00010760628949477799, -7.7022154797155748e-05, 8.3265078915305005e-05, -0.0013990135309411168, -0.0028172526227442643, 0.010701408851355284, 0.0072451530391376149, -0.086150037841453433, -0.14460665466238934, 0.049708417947223346, 0.39521478333333182, 0.28744423285388176, -0.29861910565037264, -0.3386926979654547, -0.41865673900782491, -0.35458750065998923, -0.15351062390629316, 0.023283787620964443, 0.070315990790370639, 0.021825222068831439, -0.0094360968553556454, -0.005228648752625107, 0.0016419352706606338, 0.00062222393158804063, -0.00023654954587354915, -9.5116584994877886e-05, 9.8316138184821904e-06, 8.5616544537091567e-06, -1.8490511258670774e-06, -1.3806960215566987e-06, -7.8418160579829819e-07, 6.1187783428882963e-07, -1.4184243450717458e-05, -1.6817152282181301e-06, 7.7315413636427208e-05, -0.00049776351731738936, -0.0011677770881636529, 0.0043012344452256343, 0.0053934499385103812, -0.019935861209744145, -0.053344442429226806, -0.0040707298903069475, 0.10515901839488417, 0.12441049519027374, -0.064763119504183633, -0.033271590846292554, -0.10779677164705558, -0.11539582523941379, -0.051505283097805894, 0.0069246983450398508, 0.021708652485324127, 0.0069347628931926159, -0.0022906766529511625, -0.0016964640398162575, 0.00025142958382895784, 0.00031770653382385736, 1.1032501437955532e-05, -8.7468779744470293e-06, 5.5945066423596016e-06, 1.7972345455397561e-06, 4.5616338203520101e-07, 9.7201394524267242e-08, 4.7224934971170761e-07, -3.3798970421174713e-06, -2.8493281587958699e-06, 1.5043823885218312e-05, 5.8125806227282977e-05, -0.00024311382978972981, -0.00034121417018685452, 0.0017972456094799462, 0.002919931802959911, -0.0062096116659288523, -0.016969044244524348, -0.0032835840838819309, 0.038807899659842743, 0.067426466166360513, 0.050826644444124935, 0.0, -0.049486105286858977, -0.055102269491050557, -0.024933286677064983, 0.0027131015547638831, 0.0094232929485847418, 0.0031928535384108483, -0.0010192088413809152, -0.00065687472267875711, 9.9406390967590554e-05, 9.2117117221092925e-05, 4.2835653158188598e-07, -1.1077354271652886e-05, 4.6988159821331912e-06, 1.8643898350265165e-06, -1.3325436344526307e-07, 0.0, 1.3325436148527189e-07, -1.8643898357013856e-06, -4.698815982340655e-06, 1.1077354271338259e-05, -4.2835653029578673e-07, -9.2117117220968567e-05, -9.9406390967541697e-05, 0.00065687472267875711, 0.0010192088413828024, -0.0031928535384109992, -0.0094232929485852882, -0.0027131015547645593, 0.024933286677071297, 0.055102269491057093, 0.049486105286870655, 0.033271590846436425, -0.050826644444130153, -0.067426466166320781, -0.038807899659787329, 0.0032835840838925869, 0.01696904424452016, 0.0062096116659344346, -0.0029199318029558409, -0.0017972456094788201, 0.00034121417018834725, 0.00024311382979051588, -5.8125806225852501e-05, -1.5043823885472467e-05, 2.8493281592184042e-06, 3.3798970414074387e-06, -4.7224935044335926e-07, -9.7201394523848146e-08, -4.5616338348029835e-07, -1.7972345459045348e-06, -5.5945066421669702e-06, 8.7468779741463935e-06, -1.1032501437633476e-05, -0.00031770653382469171, -0.00025142958382980715, 0.0016964640398156006, 0.0022906766529529358, -0.0069347628931879929, -0.021708652485317177, -0.0069246983450331808, 0.051505283097836994, 0.11539582523943163, 0.10779677164702299, 0.3386926979653444, 0.064763119504166911, -0.12441049519022664, -0.10515901839483223, 0.004070729890304727, 0.053344442429226403, 0.019935861209740766, -0.0053934499385123874, -0.0043012344452267063, 0.0011677770881626617, 0.00049776351731785828, -7.7315413635329507e-05, 1.6817152281107408e-06, 1.4184243450816806e-05, -6.1187783459995966e-07, 7.8418160414892948e-07, 1.3806960215563787e-06, 1.8490511250936381e-06, -8.5616544541499696e-06, -9.8316138175931616e-06, 9.5116584994742171e-05, 0.00023654954587342899, -0.00062222393158917633, -0.0016419352706608273, 0.0052286487526254947, 0.0094360968553597515, -0.021825222068826373, -0.070315990790367974, -0.023283787620951409, 0.15351062390632836, 0.35458750065996514, 0.41865673900782463, 0.80247840632930123, 0.29861910565040301, -0.28744423285381543, -0.39521478333324389, -0.049708417947207637, 0.14460665466238265, 0.086150037841446453, -0.0072451530391390538, -0.010701408851356092, 0.0028172526227436055, 0.0013990135309424952, -8.3265078914415499e-05, 7.7022154796884101e-05, 0.00010760628949436256, 2.4936495372172559e-05, 8.2597481160475411e-07, 5.0961890322364048e-06, 6.270504053587473e-06, -3.3018347577843258e-05, -7.1552277722738763e-05, 0.00036802477582684921, 0.00072670648727208957, -0.0014782172892186336, -0.0023509305274016343, 0.017253906543740219, 0.0361904386041903, -0.059920467833026222, -0.23035854544535139, -0.11316541147376862, 0.436507796814322, 0.88651914954535227, 1.0269270161824879, 2.2429749045618363, 1.0565229529903326, -1.1309597417418378, -1.6851565365398167, -0.49595628709941025, 0.40093326275916286, 0.25838788694247145, -0.030553958637498463, -0.048586273708375489, 0.0093912827538692768, 0.0046945367599903042, -0.00050105816519528668, -0.00045307702727423699, 0.00022527265138177463, 7.9478542847089153e-05, 1.0011729526400015e-05, 1.5809883406608184e-05, -1.2601241693104561e-05, -7.2704791039154929e-05, -0.00013944973801701606, 0.00085439958417779277, 0.0026523157902857862, -0.0047066150942464552, -0.0099358115635039043, 0.070864296996221418, 0.15249245278412987, -0.19846976557711321, -0.87257163068623855, -0.70142225830113492, 0.71511526306233175, 2.2927664969925812, 2.5538673583000056, 8.4822228391138594, 3.1469764634817636, -2.2028113471748418, -4.2391713347551567, -1.6004592076355943, 1.256837282007673, 0.88291287420080655, -0.10651220377116098, -0.14639963344722345, 0.011660119791666538, 0.015795334924840389, -0.0021630491325718448, -0.0016017335432059105, -1.6056362425267762e-05, -1.9154360696782612e-05, 2.2179563562188507e-06, 1.5306190418174822e-05, -1.3994387363725719e-05, -9.3859457891797799e-05, -2.2373324326887067e-05, 0.001372605892043584, 0.0036170611596280633, -0.015263156905379492, -0.046960029345022428, 0.17305354955167276, 0.50865792651575092, -0.29382845386145795, -2.3405484242614674, -1.9985565184180694, 2.3598704650957769, 6.1656643244542986, 8.7315069105383625, 17.729338100591146, 16.16044914084344, 3.9744235027988806, -6.4019126311322339, -3.7264846171107413, 1.8832932452038942, 1.6533046454778479, -0.065196653506560565, -0.21557912264683374, 0.057130716853852841, 0.067823949067901873, 0.0048636342861174938, -0.0014464277080027464, 0.00067901668703094988, 0.00010250720924968801, 3.9084915731564376e-05, 8.7155323163908978e-05, 9.2808109880357901e-05, -0.0002325762670250908, -0.0010934558980430407, 0.0042015609498085452, 0.0077851049698978879, -0.047412118534246123, -0.12872108969980919, 0.347436451772281, 1.3157595111644818, -0.54621288944967405, -5.4119853383600702, -2.3165455312690484, 10.955871914675381, 19.487467662417213, 17.576621089243289, 5.4282746232066126, 36.497593867080688, 14.989381828055899, -25.037428100180914, -20.474406237761002, 2.0779104198198417, 6.0248432237602181, 0.85687745542587901, -0.15323327509603168, 0.14265264682578829, 0.087069268286695561, 0.011825603754498296, 0.0012342607279732299, 0.0028809147575238926, 0.0011298747328662582, 2.0602816877460582e-05, 0.00021205409372000841, -7.2497674436697104e-05, -0.0017281414610421523, -0.006085519605879876, 0.010550176613753189, 0.04515076776742772, -0.036325697906856379, -0.18427966087195091, 0.55165459871114753, 2.1858286220084038, -2.1158028157224313, -11.539786987684664, -2.4072249874858644, 24.806312587182791, 33.975619755276242, 9.783586070955252, 142.68730890272883, 127.72312720337824, 41.171639289684236, -56.486069104567761, -48.129088343602554, -0.9795136576963499, 12.161715616381057, 2.4309674287383989, -0.498049017017482, 0.24922608889607162, 0.05690176651734568, -0.0047951528835340962, -0.00666814325947404, 4.6035494233416009e-05, 0.0027075490515988954, 0.00041406827904844702, 2.8031778648544371e-05, -0.00039450994426571523, -0.0032130032530263515, -0.0082737875972399878, 0.022721689012943438, 0.061463792395343643, 0.036201890559829163, -0.3520235021859332, 1.3689331500831903, 7.1923708075200734, -4.5234778785073484, -37.53507692009012, -29.906016170654418, 55.001294578822382, 99.787409897491187, 91.053579482449422, 342.27621105731453, 334.67371173520326, 87.497164212346618, -111.0987999026444, -48.029615644247457, 28.193965034765707, 15.792270422196436, -0.48632248954740509, -2.2891908586667706, 0.43012965453925761, 0.60700748329106979, 0.041782640680199906, -0.024623507369732841, -0.013320171975792017, 0.00084901673761237609, 0.0006043136524673308, -2.1008188454298679e-06, 0.0001201660451322299, 0.00081574697752853306, -0.0016719543218773789, 0.013721933165640972, 0.098529564497228272, -0.13472332633921438, -0.88286993545096504, 3.2681008083097729, 13.095155674154302, -2.5680421684892911, -57.409949251798253, -63.023130997866808, 96.62905580397846, 304.47603827676824, 348.25890814832377, -608.06184705207238, -108.3575318463683, -25.450658270222359, -273.31300062910782, -76.822153629632936, 95.737309397844399, 40.953249308721709, -5.7983733792054135, -2.4873407504647047, 2.1371851454270088, 0.80895482070078295, 0.047246191697243041, -0.047410658855088467, 0.0020514022508175854, -0.002369386795852814, 0.0011353628514107392, 0.00085071688314226511, 0.00045117160770050525, -0.0056060898486796759, -0.016424937283604724, 0.030590557055645055, 0.23422795848566832, -0.12352888715752926, -2.5262990189781851, 0.15967604903152918, 13.157904592767508, 22.866056256077929, -24.728035394109568, -88.255503332807095, 28.936629621288684, 26.094767249463303, -404.48916791571332, -2348.346993172679, -401.89162402051733, 537.57809524921231, -351.81985736289272, -379.31228865246618, 21.319429226850364, 73.254839813416325, 13.858896676215757, -0.48835520550537709, 3.4731271711763214, 0.99918245590033916, -0.22402554985838727, -0.11877640918683258, 0.011083467862236249, 0.0020365413730902885, 0.0026716531574479938, 0.001917684336548198, -0.0036069899885160838, -0.023452802562666058, -0.024987588306021404, 0.067202922116505387, 0.50382743582040856, 0.6004527590408355, -3.2452757445837785, -6.7051139314185244, 26.276835867611975, 92.068040375826797, -52.920672453261844, -372.79259353377256, 105.71673535442247, 240.70143186447768, -1883.363669502841, -684.97959165063321, 1112.0540159558975, 942.16755498192003, -459.95573868102451, -420.27054634951992, 24.795065499662957, 13.004195929909772, 7.4141267588561703, -3.682800930020067, -0.87667351785495562, 0.54107724731740381, 0.55405390993531467, -0.1252130338315631, -0.014029711179499669, -0.011529870687323501, 0.0034390891352509903, 0.00060025303576528312, -0.0012282676678759762, -0.022330776935852007, -0.078610789036235279, -0.15105372261757474, 0.70169954600638929, 2.2795540236275773, -2.0782905904726996, 3.000434366652557, 60.739251530981811, 50.770431510290891, -267.12706753457417, -354.91295307862521, 821.26497752603382, 1010.3237650874759, -602.54327944683052, 13391.901368395234, 10929.798398133857, 1933.4800470053663, -2711.5153239844217, -922.99713133386661, 275.96221185192491, 93.460146257111958, -29.902810744114028, -16.360105748561381, -7.4921225563559606, -0.029603642148639909, 0.38722147995532696, 0.15032468438850879, 0.075677036525108848, 0.0081378837299098394, 0.0037937176827991482, -0.00085055424110926829, 0.0043459177540993259, -0.00023543387332691185, -0.13507416188085952, -0.17221216218196025, 0.26143602710082897, 0.72535972703626972, -3.2722596307272944, 2.2373513523401622, 4.9615998121405012, 42.932263785691291, -84.877841434423658, -945.20766142432956, -887.46023361526682, 3925.7577913329583, 11194.545427930101, -10706.514246895442, 5281.5723471297006, 4946.0282562867797, -1296.4366520857075, -1185.1238932642696, 238.9197695052832, 211.6323955131397, -24.776358129244326, -9.8585155596813792, -1.7461999698868065, 0.76419419802801547, -0.41739778329989746, -0.098376776437577709, 0.076964103250559746, 0.017092494175422378, 0.0012201610715871689, 0.004299287629738649, -0.0018274895818451932, -0.020744772339150463, -0.12543413351316696, 0.36223791541011652, 0.18805381897020862, -0.65600865155600818, -20.567779042237863, -21.46449253770993, -13.222359870031557, 206.30246858519831, -162.85707963816978, -1779.1449685952532, -1263.9440399653668, 8815.516952124166, 4202.5064061160301, 27456.969846005039, -18939.315780035096, -4699.2031805565066, 4862.6686041022285, 992.82929249872586, 362.28186950461748, 182.38596939283644, 3.7416120100025241, 10.810291764213327, 5.9301461429212612, 0.62967354969719169, -0.53088177925578472, 0.12938270466632043, -0.064089909650021634, 0.024097393253418069, -0.0087373328884417078, 0.0051011628064008057, -0.0057624815280936303, 0.0050852207874495618, -0.020544905947870024, -0.090977957608502774, 0.40616257836881853, 0.00080551226426904543, -12.777842336107227, -22.519601437304647, 11.16201458040481, 226.29890693046417, -272.5726519605721, 315.00701580725359, 5625.222440567115, -6659.2852195136511, -15801.957749913861]}};

var nose_filter = {"real": [3.0408379415611857, 0.37822261363137938, 1.1747173276627942, 0.87791572866957501, 0.27429578524536991, -0.26015038230887205, -0.04589694540462394, 0.18194913988848616, -0.19035992880648842, -0.050064472206627651, -0.016354960260506177, 0.073013903204916478, 0.15053197342937383, -0.47378158951033317, -0.33333577915227425, -0.30434085338299055, 0.26372284406307878, -0.30434085338299449, -0.33333577915227836, -0.47378158951033028, 0.15053197342937505, 0.073013903204915576, -0.016354960260505706, -0.050064472206628768, -0.19035992880648842, 0.18194913988848541, -0.045896945404624932, -0.2601503823088735, 0.27429578524536952, 0.87791572866957457, 1.1747173276627942, 0.3782226136313796, 1.5638480130127614, -1.0502161590016221, -0.28144140655806793, 0.66007876209063499, 0.25575295594566605, -0.11471557758718753, 0.22751157962613866, -0.29100003355994186, 0.29242994865853178, 0.14950061311078749, -0.02214037256893809, 0.034503572794411914, -0.17412889405901469, 0.060297128338254534, -0.49717312826403576, -0.10585857030501357, 0.082780177430083327, -0.11056584899062352, -0.72499416196392785, -0.15612863751308359, -0.36586758725441215, -0.19718551141955715, -0.043434328775718851, -0.060442748560529294, 0.1383233017601592, -0.071714399164362744, 0.31725814504248484, 0.16801904131477274, 0.58675004339129755, 1.5155025161072819, 0.99232752650122635, -1.0129349058609656, -1.6725083187014358, -0.66077224091757791, 2.2217962254133496, 0.98390492917013095, -0.16319024909703178, 0.67271651276019184, 0.16380771710007475, 0.21989373735679621, -0.12296413131763459, -0.18224776807046256, -0.011168077595514938, 0.10364961453623285, 0.1359801303077682, -0.26339593722715721, 0.039396952561874886, -0.33866696253626483, -0.0043101841409601402, 0.17740469505625342, -0.10830858623812685, -0.33186051211466239, 0.12060535717228799, 0.084703474730635803, -0.086262426064740078, -0.1297477439897661, -0.28426475792188655, 0.21965961682575447, 0.24955999100642301, 0.46804088594167448, -0.46946217188769823, -0.31724338121882617, 1.7716903674840139, 0.56577881124465312, 0.71512595047089234, 0.4910867492003736, 0.92310119575914651, -1.0939934957719639, 0.18102793706565934, 0.35484595526186652, 0.48676804973393767, -0.097923922056211768, -7.8200063684236368e-05, -0.016095705887683227, -0.084263209727683391, 0.0080331646697531477, -0.044853168166469837, 0.0062170702455977547, -0.15890945005602863, 0.22815908460498888, 0.17110516400703918, -0.29052216822588434, -0.18224178792918044, -0.018421573557969844, 0.032535239746583795, -0.08121081614537759, -0.029175915115094032, 0.092929862040843081, 0.16824405476099044, -0.24679227625704581, 0.00030176170486908785, 0.023943010115746295, -0.43281940369171445, -0.57166836623813821, 1.2482467538506352, 0.74385331371246666, 0.54787745216002559, 0.92898941300038174, 0.54473301805335128, -0.4877077226718825, -0.40370312470951597, 0.39096527623299848, 0.12644205243911047, 0.0424168022733412, 0.049219693586430309, -0.077748186566067037, -0.043614575991677208, -0.0041635061718157101, 0.07897222152752259, 0.053944973270972973, 0.11232623315704468, -0.070445625631503542, -0.072057201177642652, 0.12706805404252855, -0.13757198545862262, -0.31639223989443899, -0.029240486244660611, 0.10973045554309782, 0.04102655016489614, 0.01891084247324943, -0.056922369420476487, 0.030805208457151782, -0.1512000567754726, -0.058122663069861934, -0.30506910575481916, -0.79033868813295383, 0.026308878650124864, 1.7521122327973906, 0.64566220514793682, 0.40042515638418263, -0.33461208848408402, -0.55369429571770823, -0.030140868003777126, 0.27230784814155334, 0.008194429787378334, -0.030645866021173498, 0.023928227792328404, 0.090706510487419734, -0.021569631345745226, -0.0064127815367693367, -0.026343653609827326, 0.0079365608693974798, -0.18791450411345401, 0.14319521757460194, 0.17003550871316017, -0.24661106106331201, -0.21167593067635404, -0.098206750946426211, -0.048592759447365123, 0.0028129255950110439, 0.049868939755416952, 0.039023237394102607, -0.0036267311717218496, -0.12930461632538415, -0.067411320951837855, 0.010801205387038189, 0.074931291451028059, 0.0657071501308885, -0.22930577035731903, -0.34894672904561169, 0.37107135970432037, 0.49136473213042475, 0.10645611255411164, -0.27741376367012294, -0.015474080963115254, 0.13417678111594294, -0.00046677178847574514, -0.064152245495751381, 0.038292630722847554, 0.017696001575747813, 0.0052157631901947011, -0.023883294001795573, 0.00060518848897931612, -0.088395093514235953, -0.11757758027246699, -0.019555697374511325, 0.025650630137194243, -0.043746931993730094, -0.08846438922222799, -0.074442233736365312, -0.0099104052825428144, 0.064871673248634965, 0.03524540038796406, -0.0065163090427015676, -0.065286881502250399, 0.023130909787941502, -0.028452880392855154, -0.098638256951482817, -0.23382813425811513, -0.077933249962103476, 0.069575788839216612, 0.86635491100693507, 0.33668792873864722, 0.34253529215971401, -0.019122146869457048, -0.016521364547457899, 0.098161425946316522, -0.011130337821465129, -0.092543539386829035, -0.0046973120649884213, -0.0086885172531639618, 0.041915865623990751, 0.004043623749362439, -0.037907101781325205, -0.03902357631677511, -0.037690963997300889, -0.11419210623041842, -0.076732726183972602, 0.12573571356763677, 0.012633232837618465, -0.098942005293094951, -0.061888601165125671, -0.0090012900880717846, -0.014247675993027883, 0.027023228844142398, -0.0050282774165556453, -0.031667371615742887, -0.033818612421867206, -0.01148054478950835, 0.002410610826462259, 0.084402385062259444, 0.069824545029654947, 0.043930202648898894, 0.078872059827297045, 0.055053359776043469, 0.0133618922103162, 0.068453834537836655, 0.081701490128889276, -0.023034972903402569, -0.042406682273060693, 0.035148729718712253, -0.037569795749083354, -0.0041828274568459145, 0.012961699649937737, -0.015475583648045266, -0.027857672235467607, 0.011169867646763214, -0.052725469767566695, -0.0070148730067698924, 0.053188940442296044, -0.095289423698368528, 0.016377276604450954, -0.015232023889946105, -0.077682201861009353, -0.048207693014304241, 0.014396940553395536, 0.021075876818278678, -0.0024069559974744716, -0.016758259649352489, 0.031865879706987753, 0.032824623168326933, -0.074182732572421473, -0.080036865363297197, 0.055652716802045685, 0.11130862970905192, 0.072952972838101024, 0.035098396968263772, 0.070242479721294437, 0.040747896169172335, -0.022459274904977577, 0.014257984954846613, 0.019887732012022184, -0.040811004345713692, 0.0088191619820225595, 0.012579825412037176, 0.0010521231241174983, 0.006430724322423028, -0.0107697788586532, -0.065313535534231901, -0.062769573271966861, 0.11452944472315789, 0.040092306883550234, 0.12236977033818973, 0.13624403896529741, 0.027359429809611827, -0.0259369720098807, -0.021419082531908291, -0.02797214703330133, 0.0080320798501609496, 0.0013100558771969473, -0.0052561866064455981, -0.0097375289490629017, 0.028455863356249757, 0.056425701741664613, -0.0014166564531825356, -0.032528933027316242, -0.019619112630340951, 0.065700689463789611, -0.027574493612476551, -0.032810042710946841, -0.021337213333243964, 0.019592990080295629, -0.019759750092557201, -0.030135000999364853, 0.031698488621630008, 0.023522054710864718, -0.021766544372719836, -0.0029827434432790761, 0.0078373508878122541, -0.0028057606437618767, -0.033232550782043478, -0.070830818977105636, 0.059080455669844649, 0.36951320092865036, 0.091411128665944044, 0.16404233417264649, 0.062598270207454218, 0.044986403519809939, -0.081510896741027974, -0.042341618007147169, -0.019737461729971092, -0.0048974001169366831, 0.01654258945512711, 0.0088012977267579451, -0.013696041496545335, -0.0020268100930256635, 0.015845305908809133, 0.016458612619479462, 0.00059474001274681517, -0.078529066256991353, -0.013402803779002156, -0.0036013299995064228, 0.037573591582025043, -0.0076636494655425947, -0.0021144243161753088, 0.032140257903604356, 0.0203960516207237, -0.013294834505552555, 0.0021732333351695376, 0.015223562704661827, -0.01560949450401263, 0.015060609589555461, 0.099241248305729085, -0.19173261262163863, 0.2450151004066432, 0.26383919410790774, 0.33963060937430933, 0.34586223870135113, 0.1799263961717959, 0.13137374163691276, -0.036493858716968031, -0.041981936023927684, -0.060258932305754208, -0.0099079010405710068, -0.010024579181759819, 0.016637976300589805, 0.031629106230310143, -0.011441752446030828, -0.010113005489671789, -0.027490450999295705, -0.018258671855796018, 0.061296263921274532, 0.10180457538537498, 0.097647442588889397, 0.063246459754600901, 0.0018146068702083835, -0.012539173975430248, -0.008345642545901014, 0.020763503842579332, 0.035996162307667869, -0.015675575409266479, -0.029662747125522582, 0.021312770128680401, 0.08274253615935892, -0.10682054954404013, -0.033729052458342255, -0.12662108035586636, 0.18053751384272299, 0.70940599530087467, -0.21337246968950196, 0.09763637724258438, 0.15345959634626791, -0.11690110107335749, 0.030098075283007168, 0.034186076429122053, -0.021402902917041923, 0.0046349096026103891, 0.011776544425663813, -0.0089673934626629329, 0.025701507905379287, -0.029333520957471802, 0.0051215906448292756, -9.6207917787476249e-05, -0.027988212781709806, 0.093695296747695708, 0.10174972110658871, 0.1657472048824174, 0.097917377942654052, 0.0075790364114050627, 0.031051039914505564, 0.015692601846482499, -0.015197940538429407, 0.026154427883432859, 0.038178927860434288, 0.07391023019778703, 0.0062621769249755375, 0.14786394857966245, -0.24133125024592791, 0.31944609486771169, 0.50715637065140251, 0.3628700351691248, 1.3060302403517683, -0.51467834215318464, -0.23826829822593068, -0.0093468845104923252, 0.16015106243072727, 0.02805086056222977, -0.0035899004350242064, -0.0055435803643170143, -0.026732920924661639, -0.010772744125100176, -0.024390993371714485, 0.012627431507206405, -0.0087203787935273471, 0.017390054254405412, 0.12375300108425245, 0.24623032442851775, 0.32220608581938742, 0.14931322115435106, -0.030460558403777184, 0.017160725214558258, -0.0094839753900354314, -0.040937983123008212, 0.021461267056132466, 0.052605242734811673, 0.082583919156513017, 0.060994911510484674, 0.19212485777257118, 0.030490864773295545, 0.17592824054988929, 0.2988664581273196, -0.3440942993173739, 1.3210609586317499, 0.059297195869563314, 0.66450815180221101, -0.18837022473974091, 0.34310308052214539, 0.41335445680081984, 0.18880277280085617, -0.0025387166530481263, -0.027056960212979365, -0.014992917126512385, -0.065825070508153574, 0.0059924400617866053, 0.016058491686644451, 0.096318218677932735, 0.11648035795043635, 0.083105673180647682, 0.32671351148908129, 0.21720864831216413, 0.29412476851730657, 0.14853499339159934, 0.018970981025801619, -0.0063191769526926853, -0.01818046447321878, -0.033255690840711123, 0.042088106914846247, 0.11598544099090941, 0.13859711550376397, -0.01128947190338442, 0.086653868373652729, 0.5559656926196751, 0.37680556076813249, 0.88488899182435787, -1.1019114795534606, 1.0072326177374842, -0.25696609936231163, 0.22595605005106759, 0.20124367647634336, 0.25020565573121023, 0.15194580903531119, 0.054188690404279045, -0.031588472981034531, -0.072469006265441768, -0.025752917138555535, -0.0471489088024604, 0.079293556902861981, 0.16429646904639772, 0.19502382977708654, 0.21468548823411557, 0.26510515339808566, 0.4121092848683291, 0.24137856300787749, 0.039245063706659693, 0.01328784964664576, 0.063938494959291103, -0.056808918829038463, -0.039159725623022792, 0.028736615885883075, 0.075674855852819814, 0.10715382591497533, 0.29941075202959372, 0.24751816611443234, -0.14971685838339424, 0.92725020353048182, -0.58030730777587713, 1.4965419400087898, -0.58030730777587824, 0.92725020353048315, -0.1497168583833956, 0.24751816611443228, 0.29941075202959394, 0.10715382591497527, 0.075674855852819592, 0.028736615885883075, -0.039159725623022994, -0.05680891882903847, 0.063938494959291325, 0.013287849646645755, 0.039245063706659422, 0.24137856300787733, 0.41210928486832976, 0.32671351148908501, 0.21468548823411696, 0.19502382977708541, 0.16429646904639761, 0.079293556902861592, -0.047148908802460261, -0.025752917138555938, -0.072469006265442351, -0.031588472981034621, 0.054188690404279302, 0.15194580903531177, 0.25020565573121106, 0.20124367647634361, 0.22595605005106811, -0.25696609936231096, 1.007232617737484, -1.1019114795534584, 0.88488899182435599, 0.37680556076813088, 0.55596569261967799, 0.086653868373653353, -0.011289471903383815, 0.13859711550376486, 0.11598544099090989, 0.042088106914846005, -0.033255690840710936, -0.018180464473218153, -0.0063191769526928735, 0.018970981025801085, 0.14853499339159881, 0.2941247685173069, 0.21720864831216452, 0.24623032442851894, 0.083105673180647877, 0.11648035795043606, 0.096318218677932249, 0.016058491686644111, 0.0059924400617863598, -0.065825070508153657, -0.014992917126512623, -0.027056960212979545, -0.0025387166530475712, 0.18880277280085703, 0.41335445680082034, 0.34310308052214539, -0.18837022473973905, 0.66450815180220979, 0.059297195869561843, 1.3210609586317497, -0.34409429931737384, 0.2988664581273206, 0.17592824054988909, 0.030490864773296485, 0.19212485777257224, 0.06099491151048541, 0.082583919156513072, 0.052605242734811722, 0.021461267056132546, -0.040937983123008163, -0.0094839753900352007, 0.017160725214558203, -0.030460558403777944, 0.14931322115435064, 0.32220608581938709, 0.093695296747697082, 0.1237530010842532, 0.017390054254405134, -0.0087203787935278762, 0.012627431507206037, -0.024390993371714388, -0.010772744125100247, -0.026732920924662094, -0.0055435803643169856, -0.0035899004350241582, 0.028050860562230339, 0.16015106243072863, -0.0093468845104915464, -0.23826829822592965, -0.51467834215318398, 1.3060302403517683, 0.3628700351691248, 0.5071563706514024, 0.31944609486771208, -0.24133125024592691, 0.14786394857966259, 0.0062621769249767058, 0.073910230197787502, 0.038178927860434683, 0.026154427883432977, -0.015197940538429256, 0.015692601846482655, 0.031051039914505491, 0.0075790364114048233, 0.097917377942654316, 0.16574720488241704, 0.10174972110658852, 0.10180457538537414, -0.027988212781709362, -9.6207917787273747e-05, 0.0051215906448293215, -0.029333520957471861, 0.025701507905379183, -0.0089673934626627958, 0.01177654442566399, 0.0046349096026104134, -0.021402902917041607, 0.03418607642912222, 0.030098075283007585, -0.1169011010733573, 0.15345959634626896, 0.097636377242582312, -0.21337246968950468, 0.70940599530087356, 0.18053751384272154, -0.12662108035586525, -0.033729052458342325, -0.1068205495440398, 0.082742536159359198, 0.021312770128680637, -0.02966274712552271, -0.015675575409266458, 0.03599616230766798, 0.020763503842579301, -0.0083456425459010053, -0.012539173975430275, 0.001814606870208027, 0.063246459754600651, 0.097647442588889521, -0.013402803779000846, 0.061296263921273318, -0.018258671855796015, -0.027490450999295389, -0.010113005489671634, -0.011441752446030721, 0.031629106230310081, 0.016637976300589583, -0.010024579181759814, -0.0099079010405707553, -0.060258932305754062, -0.041981936023927795, -0.036493858716967892, 0.13137374163691345, 0.17992639617179582, 0.34586223870135102, 0.3396306093743105, 0.26383919410790552, 0.24501510040664315, -0.19173261262163757, 0.099241248305728891, 0.015060609589555881, -0.015609494504012908, 0.015223562704661735, 0.0021732333351695459, -0.013294834505552418, 0.02039605162072387, 0.032140257903604141, -0.0021144243161752658, -0.0076636494655425496, 0.037573591582025015, -0.0036013299995066783, -0.027574493612477238, -0.078529066256990701, 0.00059474001274650921, 0.016458612619479316, 0.015845305908809258, -0.0020268100930258088, -0.013696041496545191, 0.0088012977267581446, 0.016542589455127047, -0.0048974001169365296, -0.019737461729970797, -0.042341618007146614, -0.081510896741027863, 0.044986403519810654, 0.062598270207453191, 0.16404233417264671, 0.091411128665944058, 0.36951320092864953, 0.059080455669845232, -0.070830818977105567, -0.033232550782043346, -0.0028057606437617323, 0.0078373508878121518, -0.0029827434432791976, -0.021766544372719729, 0.023522054710864829, 0.031698488621629953, -0.030135000999364715, -0.019759750092557201, 0.019592990080295483, -0.021337213333244086, -0.032810042710946043, 0.035098396968265562, 0.065700689463788264, -0.019619112630341284, -0.032528933027315937, -0.001416656453182401, 0.056425701741664544, 0.028455863356249663, -0.0097375289490629503, -0.0052561866064455114, 0.0013100558771970501, 0.0080320798501610554, -0.027972147033301621, -0.021419082531907708, -0.025936972009880058, 0.027359429809612409, 0.13624403896529816, 0.12236977033819048, 0.040092306883550463, 0.11452944472315811, -0.062769573271967, -0.065313535534231998, -0.010769778858653123, 0.0064307243224230766, 0.0010521231241173155, 0.012579825412037126, 0.0088191619820226965, -0.040811004345713484, 0.019887732012021993, 0.014257984954846677, -0.022459274904977573, 0.040747896169171828, 0.070242479721293896, 0.055053359776043469, 0.072952972838101038, 0.11130862970905199, 0.055652716802045553, -0.080036865363297377, -0.074182732572421722, 0.032824623168326919, 0.031865879706987767, -0.016758259649352489, -0.0024069559974744621, 0.021075876818278654, 0.014396940553395566, -0.048207693014304456, -0.077682201861009201, -0.015232023889946197, 0.016377276604451121, -0.095289423698368528, 0.053188940442295753, -0.007014873006770006, -0.052725469767566646, 0.011169867646763318, -0.027857672235467666, -0.015475583648045285, 0.012961699649937817, -0.0041828274568459145, -0.037569795749083312, 0.035148729718712211, -0.042406682273060839, -0.023034972903402475, 0.081701490128889429, 0.068453834537836641, 0.013361892210316275, 0.33668792873864783, 0.078872059827295921, 0.043930202648898596, 0.069824545029654933, 0.084402385062259569, 0.0024106108264623457, -0.011480544789508253, -0.033818612421867275, -0.031667371615742741, -0.00502827741655568, 0.027023228844142416, -0.014247675993027993, -0.0090012900880712381, -0.061888601165125297, -0.098942005293094756, 0.01263323283761883, 0.12573571356763666, -0.076732726183971922, -0.11419210623041808, -0.037690963997301666, -0.039023576316775249, -0.037907101781325052, 0.0040436237493623132, 0.041915865623990772, -0.0086885172531639947, -0.0046973120649884377, -0.092543539386828647, -0.011130337821465186, 0.098161425946316272, -0.016521364547457937, -0.019122146869457519, 0.34253529215971379, 0.37107135970432042, 0.86635491100693385, 0.069575788839216376, -0.077933249962103462, -0.23382813425811527, -0.09863825695148333, -0.028452880392854651, 0.02313090978794155, -0.065286881502250455, -0.0065163090427018816, 0.035245400387964018, 0.064871673248635159, -0.009910405282542379, -0.074442233736364327, -0.088464389222228296, -0.043746931993730226, 0.025650630137194336, -0.019555697374510583, -0.11757758027246727, -0.088395093514236453, 0.00060518848897882292, -0.023883294001795972, 0.0052157631901946491, 0.017696001575747886, 0.038292630722847568, -0.064152245495751242, -0.00046677178847581285, 0.13417678111594261, -0.015474080963115183, -0.27741376367012288, 0.10645611255411111, 0.49136473213042497, 0.64566220514793704, -0.34894672904561197, -0.22930577035731828, 0.065707150130888653, 0.074931291451028587, 0.010801205387038527, -0.067411320951837883, -0.12930461632538409, -0.0036267311717218076, 0.039023237394102503, 0.049868939755416578, 0.0028129255950110478, -0.048592759447364742, -0.098206750946425017, -0.21167593067635238, -0.24661106106331246, 0.17003550871316073, 0.14319521757460188, -0.18791450411345456, 0.0079365608693964147, -0.026343653609827478, -0.0064127815367698198, -0.021569631345745438, 0.090706510487419845, 0.023928227792328456, -0.030645866021173446, 0.0081944297873781744, 0.27230784814155318, -0.030140868003777244, -0.55369429571770845, -0.33461208848408441, 0.40042515638418175, 0.54787745216002603, 1.7521122327973908, 0.02630887865012415, -0.7903386881329546, -0.30506910575481899, -0.058122663069862322, -0.1512000567754718, 0.030805208457151921, -0.056922369420476453, 0.018910842473248434, 0.041026550164896362, 0.10973045554309671, -0.029240486244660805, -0.3163922398944391, -0.13757198545862218, 0.12706805404252669, -0.072057201177643526, -0.070445625631504319, 0.11232623315704422, 0.053944973270972273, 0.078972221527521536, -0.00416350617181658, -0.043614575991677791, -0.077748186566067592, 0.049219693586430378, 0.042416802273341318, 0.12644205243911066, 0.39096527623299887, -0.40370312470951558, -0.48770772267188234, 0.54473301805335006, 0.92898941300038107, 0.71512595047089234, 0.74385331371246577, 1.2482467538506357, -0.57166836623813888, -0.43281940369171401, 0.023943010115746077, 0.00030176170486927514, -0.24679227625704431, 0.16824405476099039, 0.092929862040844205, -0.029175915115095267, -0.081210816145377299, 0.032535239746583337, -0.018421573557966798, -0.18224178792918325, -0.29052216822588622, 0.17110516400703951, 0.22815908460498383, -0.15890945005602886, 0.0062170702455973175, -0.044853168166470177, 0.0080331646697508995, -0.0842632097276826, -0.016095705887684088, -7.820006368420517e-05, -0.097923922056211893, 0.48676804973393806, 0.35484595526186524, 0.18102793706565945, -1.0939934957719641, 0.9231011957591454, 0.49108674920037432, -1.6725083187014362, 0.56577881124465212, 1.7716903674840145, -0.31724338121882639, -0.46946217188769945, 0.46804088594167398, 0.2495599910064237, 0.21965961682575341, -0.28426475792188616, -0.12974774398976752, -0.086262426064739897, 0.084703474730633041, 0.12060535717228706, -0.33186051211466344, -0.10830858623812538, 0.17740469505624151, -0.0043101841409599814, -0.33866696253627121, 0.0393969525618715, -0.26339593722715154, 0.13598013030776659, 0.10364961453623139, -0.011168077595515221, -0.18224776807046214, -0.12296413131763473, 0.21989373735679868, 0.16380771710007386, 0.67271651276019118, -0.16319024909703136, 0.98390492917013062, 2.2217962254133496, -0.66077224091757802, 1.5638480130127614, -1.0129349058609651, 0.99232752650122769, 1.5155025161072819, 0.58675004339129688, 0.16801904131477496, 0.31725814504248523, -0.071714399164359219, 0.13832330176015895, -0.060442748560523389, -0.043434328775720558, -0.19718551141955432, -0.36586758725441343, -0.15612863751307984, -0.72499416196393318, -0.11056584899062098, 0.082780177430082938, -0.10585857030502534, -0.49717312826403764, 0.060297128338251849, -0.1741288940590143, 0.034503572794408806, -0.022140372568936324, 0.14950061311078439, 0.29242994865853189, -0.29100003355994419, 0.22751157962613949, -0.11471557758718894, 0.25575295594566499, 0.66007876209063321, -0.28144140655806837, -1.050216159001623], "bottom": {"real": [5837.242024063461, 16421.190569053251, 8527.2275182117319, 3938.41845467232, 969.21000043764093, 269.87346390668256, 193.53992011404216, 135.14631901451781, 58.523829955616236, 29.311524302602624, 20.863281166035843, 14.808244655557742, 11.401757474781434, 9.6386493936653288, 8.0538591094176777, 7.4714398062124641, 7.2711776175262477, 7.4714398062124241, 8.0538591094176653, 9.638649393665327, 11.401757474781416, 14.808244655557761, 20.863281166035858, 29.311524302602734, 58.523829955616236, 135.14631901451779, 193.53992011404216, 269.87346390668273, 969.21000043764059, 3938.4184546723186, 8527.2275182117301, 16421.190569053259, 14982.474506443205, 4755.1985786680198, 3083.8642011691682, 1502.8058566448747, 596.26851293203197, 262.35520536881347, 201.52671733896852, 108.13603201941604, 57.999252895466505, 28.992297197792773, 19.233600066307524, 13.871180161098291, 10.761421361485239, 8.8506828512506655, 7.8125584926262617, 7.1234501229356377, 6.6618841738486525, 7.1762884709606958, 8.1416889804019927, 8.8663632607744063, 11.328672883224474, 14.773155762512141, 20.058056528572401, 28.688344099071909, 57.995376649220766, 126.94075502116374, 211.30702516808583, 262.54448595536269, 752.96024761972672, 2141.5368023327851, 3891.3661973657881, 5583.5460990085166, 9500.6528086677681, 4225.3848573287933, 1708.1934289355966, 562.9450489663958, 526.41420210821127, 290.26438540271903, 151.34732218304231, 89.304597077577796, 50.161041673414204, 27.913649363990057, 19.253723232543383, 14.310501425792925, 10.622538104620221, 8.6520747616015274, 7.6796432895344049, 6.9311889072641995, 6.5442165971044535, 6.8352472963781299, 7.2531587818267287, 8.8125700197174819, 10.256278085266516, 13.962876672312342, 18.680978544191657, 27.641611280844351, 51.70590284164593, 92.383035108628647, 175.23999552329536, 238.6238705323166, 446.2130896894364, 589.84950644143407, 1459.800700420838, 2983.6421667816849, 6639.6980670311659, 3615.9230624353354, 1045.9683029029898, 541.95698246733389, 551.2292078912385, 269.01748102372522, 121.81702466062521, 78.619304368994548, 46.266475261147157, 26.895860643920866, 18.966790938143397, 14.141216689343503, 10.624588727031869, 8.5120674584469107, 7.5084078178458054, 7.127942028564302, 6.5505226441602824, 6.5976614570745582, 7.5671769464103935, 8.4293753366132105, 10.446992271959362, 13.755112829750516, 18.515159362788847, 25.868606557166544, 43.593025933023839, 76.847860046206122, 125.03651194390009, 241.77755195523335, 523.08499299660048, 633.36555854289827, 855.69476790230692, 2473.0066947172836, 2803.9496552692158, 1850.6397468329815, 645.77314636959022, 447.00563976857688, 381.6372474267435, 196.7755433249871, 93.586816816137713, 72.612365740746853, 43.711482900929944, 27.782222145016455, 18.647268962291367, 13.844325818813939, 10.350953817244738, 8.7140342291788997, 7.3516641952705921, 6.886474159529909, 6.1226840838853605, 6.7186507131414492, 7.0148796268173141, 7.9020046012660439, 9.6536048586555445, 13.744699851401226, 17.872279960942961, 25.025889030797831, 38.775468597625853, 68.228616115874232, 97.806667851841851, 178.52012140604563, 362.80035213144055, 506.96305099601244, 508.39785887877764, 1271.7627571663681, 1970.0713813014595, 1211.9708052435174, 448.82610946730466, 388.91483700385658, 294.26646682781944, 147.68595350614527, 76.563818921604266, 57.53338100926053, 37.094893522892434, 25.168957624787666, 17.405368368923924, 12.931100650610183, 10.211256703797424, 8.3783082007702649, 6.8845647672161352, 6.2954630311895761, 6.1711525716900475, 6.2852637654745882, 7.1318002457288037, 7.8126464614985656, 9.3562580058102185, 12.456351018938477, 17.12365920646733, 22.851195586808732, 34.22708028584924, 57.273965595477058, 82.126801795962663, 114.0182287640494, 248.69630423497404, 396.25330408596494, 382.77662480077174, 646.86127060880278, 1066.1959535576209, 770.74521634546068, 344.77171326148743, 328.21152488387929, 223.6732358532505, 124.39997807543456, 66.042124980023658, 49.833499278727395, 36.080812354502541, 24.010000461569632, 16.241873057458708, 11.94801819096188, 9.663620823552634, 8.1734814269274114, 6.8263151892657215, 6.1094005534487641, 5.5560364128866686, 6.0895161225652297, 6.7371553850929349, 7.5614980494024309, 9.3035460399083956, 11.904089289656403, 15.753116847312391, 22.116186781807659, 33.401673308199264, 45.775772578430164, 60.542807604917392, 91.412240599681226, 164.58197575163385, 289.97996145010069, 367.09809735899603, 433.51729458889321, 538.99714678707312, 436.9735160339028, 214.45700003213321, 226.27353228768246, 190.72528880002966, 104.24105887361294, 63.096291028318397, 44.895692115573439, 34.378771692376986, 22.743616534455565, 14.943130070579064, 11.306154107321404, 9.490726177732828, 8.057539867813432, 6.6249917656310648, 5.80530835366394, 5.6727594087192097, 5.6803994552580717, 6.4512234217242401, 7.3091820969038412, 8.9053168517088785, 11.147020821533502, 13.978280110937801, 19.308076160210224, 27.380246565144393, 39.45337202937899, 53.823906577074318, 70.344986096434994, 125.18491111128095, 220.27402210338624, 239.02095964975129, 253.52805611791149, 337.90351459641266, 301.96557555412664, 163.14862666039761, 176.1964602722083, 155.2640157056349, 91.402170635856464, 57.9223709952281, 44.132906015519367, 31.477476121951593, 19.994026988386896, 14.669539930994308, 10.52228821405147, 8.9499245076841039, 7.4160858759377133, 6.0652235290917815, 5.5336836347972449, 5.3453345499720717, 5.5251998880295652, 6.049359333226362, 7.4989544637904162, 8.6441457110666775, 10.17217183387787, 12.922358897606493, 16.497840703497662, 24.473525343022239, 36.893225695749557, 46.488420049270196, 60.008949681859932, 101.55324863109907, 172.57213254679178, 186.99209153386954, 177.69050334329205, 224.71115213821386, 219.35401697656656, 131.98987419085088, 139.58612051732652, 133.97255559613592, 83.717667146076977, 52.48988401855501, 39.948149447326976, 29.992243301791387, 19.792293237610107, 13.550533437330548, 10.191515700191694, 8.7251285565258279, 7.0130966099588283, 6.0412905020539274, 5.1695609453883042, 5.2335464217738297, 5.2748937601741233, 5.9151189141762242, 6.6404924993384702, 8.2525633194354864, 9.86505065394757, 11.857247340871206, 15.821441128307118, 21.809722446513074, 33.204842604441232, 45.292100524348356, 53.588237099743992, 86.046570865333351, 138.34470513151498, 144.28338780744133, 137.47961624149846, 184.36194031651988, 195.75342807998493, 111.69248606852764, 108.22432115257934, 110.31477193613289, 70.737952758714727, 45.316084199866118, 35.221165127538775, 25.132656234698317, 17.808708328889288, 13.205138111505544, 9.8319756958291311, 8.3851869715659166, 6.6979147774695411, 5.5577949826186863, 5.0640136062157843, 4.915924071395172, 5.1747375238921238, 5.621849200313962, 6.3926522738336189, 7.8838556827841355, 9.5880495388903295, 11.2702077240605, 14.675031755421674, 19.961485602094882, 28.340133288775018, 38.071807302485439, 46.211805942072893, 70.896288173632385, 115.46517347822648, 119.73189294718243, 110.21299532100423, 137.49078682179271, 145.21239507063157, 90.736475500202033, 84.820134662984671, 87.028887735269166, 58.592780926558561, 39.140475702708279, 30.030590426700837, 23.561748558876776, 17.07171690133644, 12.059539847971436, 9.1303469917064106, 7.8824915696444915, 6.5574577163884546, 5.4508327472027114, 4.6319487889521351, 4.8556936697031698, 5.0952139895658046, 5.3626061482546099, 6.0231504777267588, 7.3929124540904754, 8.8697139145390977, 10.839689611405708, 13.484775054138881, 18.125520870461621, 25.51326521840107, 33.814821758723511, 43.000660712963757, 59.289067569698993, 89.523100480006264, 96.002834501641331, 88.248403951505949, 114.22377327036351, 136.39754784126862, 85.133937137494058, 70.757613581150778, 72.941136445046624, 50.417131404641061, 35.29732697897046, 27.270836476117434, 20.337170678571646, 15.328073102208975, 11.227626008224609, 8.8894703399043831, 7.3066732490559749, 6.1117570010797007, 5.2240396800825373, 4.6927944754047974, 4.4462691956761722, 4.8997943453914665, 5.030120352863074, 5.8504059853355139, 6.9021030785339024, 8.6936481048417669, 10.014300550884089, 12.783989981758968, 16.915182814597465, 23.037925870268026, 29.781501040175886, 36.137786628939317, 46.659613314406016, 72.542096884400053, 80.098309124706176, 76.772569487169434, 87.96931966600367, 100.35528192635977, 66.390743706670477, 56.297220892995071, 57.449776912893739, 42.311817158751616, 30.3950154293208, 24.633397231162515, 18.800000277532757, 13.906344724637259, 10.685561612392762, 8.7726633553262534, 7.3765778222647702, 6.0238006847876884, 5.2082074327498917, 4.5886719664559399, 4.6166410353959701, 4.6115148269570563, 4.9920772309179853, 5.6445124723515159, 6.7980683034043956, 7.4975962005340229, 9.6066586869080837, 12.06652313244911, 16.251663826300451, 21.003823940677318, 27.622933573071261, 33.836788273738165, 41.877854423447168, 58.532835369703733, 68.239320296767971, 62.326149739008642, 71.583830955139561, 81.611391861674278, 61.290606958364052, 49.963935495056425, 49.744027747354536, 38.555965139546075, 28.313241453630848, 22.404376161451804, 17.69007471646092, 13.348861556136391, 10.46674681432143, 8.1507364253451371, 6.7804933363165576, 5.7303247473649055, 4.9737961537641029, 4.6591603640435002, 4.3691273542401863, 4.5876440856805019, 4.8775279419312838, 5.5643157824289267, 6.5106424514611394, 7.6517258774697732, 9.3978270674435489, 12.208065227131403, 15.316902707006163, 20.982661610009878, 26.317869298031479, 32.313264556083666, 38.062860113666069, 50.105167484748129, 58.219661124046276, 59.861157680092496, 61.019020366450448, 69.642805168222978, 57.634563900118565, 46.967523109902231, 43.85887184820529, 34.957640557066753, 26.505039983640941, 21.71545909517323, 16.236775633007202, 12.875777825381771, 9.9834739610997616, 7.8930497070448, 6.6829715569803687, 5.6672193704500122, 5.0794246915518446, 4.681264046528276, 4.6186632297539427, 4.6211092904368423, 5.0897865773957403, 5.5691810710797096, 6.5035187317991277, 7.2014326998593701, 9.1703620437944053, 12.475838151915292, 15.6623920524898, 19.528853843427893, 25.077028045409381, 30.833489267211636, 39.113296407386123, 46.770991427918581, 55.937485646720255, 57.570245344451905, 57.637817589030213, 59.860391566610879, 52.776195682327739, 43.839296967027423, 39.833012832197511, 33.598213438023812, 26.072700016436322, 20.276975501521189, 16.195672497297036, 12.239826665071417, 9.6875213487165066, 7.7379543893933631, 6.3786782254807157, 5.5950259327840586, 5.1232903828272987, 4.5786592309737237, 4.5178908466513406, 4.578659230973722, 5.1232903828272978, 5.5950259327840595, 6.3786782254807148, 7.7379543893933684, 9.6875213487165084, 12.239826665071421, 16.195672497297036, 20.276975501521182, 26.072700016436304, 33.598213438023805, 39.833012832197511, 43.839296967027416, 52.776195682327739, 59.860391566610836, 61.019020366450441, 57.570245344451919, 55.937485646720255, 46.770991427918517, 39.113296407386116, 30.833489267211636, 25.077028045409371, 19.528853843427893, 15.662392052489803, 12.475838151915296, 9.1703620437944, 7.2014326998593674, 6.5035187317991294, 5.5691810710797114, 5.0897865773957385, 4.6211092904368405, 4.6186632297539418, 4.6812640465282733, 5.0794246915518446, 5.6672193704500087, 6.6829715569803696, 7.8930497070447982, 9.9834739610997651, 12.875777825381764, 16.236775633007209, 21.715459095173252, 26.505039983640959, 34.957640557066775, 43.858871848205247, 46.967523109902238, 57.634563900118593, 69.642805168222949, 71.583830955139618, 59.861157680092482, 58.21966112404624, 50.105167484748137, 38.062860113666083, 32.313264556083666, 26.317869298031482, 20.982661610009867, 15.316902707006161, 12.208065227131399, 9.3978270674435436, 7.6517258774697732, 6.5106424514611394, 5.5643157824289284, 4.8775279419312856, 4.587644085680501, 4.3691273542401872, 4.6591603640434966, 4.973796153764102, 5.7303247473649037, 6.7804933363165594, 8.1507364253451371, 10.466746814321423, 13.348861556136386, 17.69007471646092, 22.404376161451779, 28.313241453630852, 38.555965139546039, 49.744027747354508, 49.963935495056418, 61.290606958364073, 81.611391861674235, 87.969319666003628, 62.326149739008663, 68.239320296767957, 58.532835369703712, 41.877854423447168, 33.836788273738158, 27.622933573071283, 21.003823940677311, 16.251663826300444, 12.066523132449106, 9.6066586869080837, 7.4975962005340202, 6.7980683034043929, 5.6445124723515194, 4.9920772309179844, 4.6115148269570598, 4.6166410353959719, 4.5886719664559372, 5.2082074327498908, 6.0238006847876866, 7.3765778222647711, 8.7726633553262587, 10.685561612392764, 13.906344724637258, 18.80000027753276, 24.633397231162533, 30.395015429320793, 42.311817158751609, 57.449776912893732, 56.297220892995028, 66.390743706670506, 100.35528192635975, 114.22377327036349, 76.772569487169449, 80.098309124706219, 72.542096884400053, 46.659613314406002, 36.137786628939317, 29.781501040175893, 23.037925870268033, 16.915182814597468, 12.783989981758975, 10.014300550884082, 8.6936481048417651, 6.9021030785339006, 5.8504059853355228, 5.0301203528630678, 4.8997943453914612, 4.4462691956761731, 4.6927944754048019, 5.2240396800825328, 6.1117570010797033, 7.3066732490559732, 8.8894703399043813, 11.227626008224609, 15.32807310220897, 20.337170678571649, 27.270836476117438, 35.297326978970467, 50.417131404641083, 72.941136445046638, 70.757613581150821, 85.133937137494073, 136.39754784126856, 137.49078682179265, 88.248403951506006, 96.002834501641317, 89.523100480006221, 59.289067569698972, 43.000660712963743, 33.814821758723504, 25.51326521840107, 18.125520870461624, 13.484775054138884, 10.839689611405714, 8.8697139145391013, 7.3929124540904745, 6.0231504777267606, 5.362606148254609, 5.0952139895658073, 4.8556936697031734, 4.6319487889521325, 5.4508327472027096, 6.5574577163884502, 7.8824915696444933, 9.1303469917064124, 12.059539847971436, 17.071716901336433, 23.561748558876776, 30.030590426700826, 39.140475702708279, 58.592780926558504, 87.028887735269151, 84.820134662984628, 90.73647550020199, 145.21239507063157, 184.36194031652002, 110.2129953210042, 119.73189294718252, 115.4651734782265, 70.896288173632399, 46.211805942072878, 38.071807302485439, 28.340133288775018, 19.961485602094882, 14.675031755421674, 11.270207724060505, 9.5880495388903277, 7.8838556827841364, 6.3926522738336233, 5.6218492003139611, 5.1747375238921247, 4.9159240713951746, 5.0640136062157861, 5.5577949826186863, 6.697914777469534, 8.3851869715659184, 9.8319756958291471, 13.205138111505548, 17.808708328889303, 25.13265623469832, 35.221165127538775, 45.316084199866097, 70.737952758714712, 110.3147719361329, 108.22432115257941, 111.69248606852767, 195.75342807998487, 224.71115213821398, 137.47961624149852, 144.28338780744139, 138.3447051315149, 86.046570865333337, 53.588237099743992, 45.292100524348342, 33.204842604441232, 21.809722446513071, 15.82144112830712, 11.857247340871208, 9.86505065394757, 8.2525633194354864, 6.640492499338464, 5.9151189141762242, 5.2748937601741233, 5.2335464217738297, 5.1695609453883096, 6.0412905020539247, 7.0130966099588328, 8.725128556525835, 10.191515700191694, 13.550533437330545, 19.792293237610103, 29.992243301791408, 39.948149447327012, 52.489884018555003, 83.717667146076963, 133.97255559613592, 139.58612051732649, 131.98987419085091, 219.35401697656653, 337.90351459641266, 177.69050334329216, 186.99209153386957, 172.57213254679186, 101.55324863109904, 60.008949681859939, 46.488420049270182, 36.893225695749557, 24.473525343022239, 16.497840703497666, 12.922358897606497, 10.172171833877869, 8.6441457110666775, 7.4989544637904126, 6.0493593332263602, 5.5251998880295634, 5.3453345499720717, 5.5336836347972458, 6.0652235290917806, 7.4160858759377133, 8.949924507684111, 10.522288214051471, 14.669539930994311, 19.994026988386889, 31.477476121951593, 44.13290601551936, 57.922370995228107, 91.402170635856407, 155.2640157056349, 176.1964602722083, 163.14862666039767, 301.96557555412653, 538.99714678707278, 253.5280561179116, 239.02095964975135, 220.2740221033861, 125.18491111128091, 70.344986096434923, 53.823906577074332, 39.453372029378947, 27.380246565144397, 19.308076160210238, 13.978280110937792, 11.147020821533506, 8.9053168517088821, 7.3091820969038439, 6.4512234217242392, 5.6803994552580681, 5.6727594087192079, 5.8053083536639392, 6.6249917656310666, 8.0575398678134302, 9.4907261777328298, 11.306154107321403, 14.943130070579077, 22.743616534455558, 34.378771692377001, 44.895692115573446, 63.09629102831839, 104.241058873613, 190.72528880002952, 226.27353228768243, 214.45700003213315, 436.97351603390234, 1066.1959535576209, 433.51729458889332, 367.09809735899597, 289.97996145010086, 164.58197575163376, 91.412240599681198, 60.542807604917364, 45.775772578430157, 33.401673308199264, 22.116186781807642, 15.753116847312398, 11.904089289656401, 9.303546039908392, 7.5614980494024362, 6.7371553850929322, 6.0895161225652297, 5.5560364128866677, 6.1094005534487605, 6.8263151892657268, 8.1734814269274096, 9.6636208235526269, 11.948018190961893, 16.241873057458722, 24.010000461569639, 36.080812354502534, 49.833499278727416, 66.042124980023658, 124.39997807543459, 223.67323585325056, 328.21152488387946, 344.77171326148749, 770.74521634546022, 1970.0713813014588, 646.86127060880301, 382.77662480077169, 396.2533040859646, 248.69630423497387, 114.01822876404945, 82.126801795962692, 57.273965595476994, 34.227080285849233, 22.851195586808739, 17.12365920646733, 12.456351018938475, 9.3562580058102167, 7.8126464614985656, 7.1318002457288037, 6.2852637654745882, 6.1711525716900475, 6.2954630311895787, 6.8845647672161387, 8.3783082007702561, 10.211256703797417, 12.931100650610194, 17.405368368923916, 25.168957624787648, 37.094893522892434, 57.533381009260523, 76.563818921604266, 147.68595350614524, 294.26646682781944, 388.91483700385658, 448.82610946730478, 1211.9708052435162, 2803.9496552692158, 1271.7627571663686, 508.39785887877753, 506.96305099601244, 362.80035213144049, 178.52012140604566, 97.806667851841823, 68.228616115874146, 38.775468597625853, 25.025889030797838, 17.872279960942965, 13.74469985140124, 9.6536048586555427, 7.9020046012660456, 7.0148796268173159, 6.7186507131414386, 6.1226840838853631, 6.8864741595299055, 7.3516641952705939, 8.7140342291789032, 10.350953817244736, 13.844325818813926, 18.64726896229136, 27.782222145016434, 43.711482900929937, 72.612365740746867, 93.586816816137656, 196.7755433249871, 381.63724742674339, 447.00563976857711, 645.77314636959011, 1850.6397468329806, 6639.698067031165, 2473.0066947172841, 855.69476790230704, 633.36555854289816, 523.0849929966007, 241.77755195523349, 125.03651194390012, 76.847860046206094, 43.593025933023853, 25.868606557166554, 18.515159362788847, 13.755112829750496, 10.44699227195936, 8.4293753366132176, 7.5671769464103917, 6.5976614570745609, 6.5505226441602797, 7.1279420285643011, 7.5084078178458018, 8.5120674584469089, 10.624588727031863, 14.141216689343507, 18.966790938143404, 26.895860643920869, 46.266475261147157, 78.619304368994577, 121.81702466062518, 269.01748102372505, 551.22920789123827, 541.95698246733446, 1045.9683029029893, 3615.9230624353345, 9500.6528086677681, 2983.6421667816867, 1459.8007004208382, 589.84950644143373, 446.2130896894364, 238.62387053231652, 175.23999552329542, 92.383035108628548, 51.705902841645944, 27.641611280844312, 18.680978544191667, 13.962876672312348, 10.256278085266519, 8.8125700197175014, 7.2531587818267402, 6.8352472963781254, 6.5442165971044517, 6.9311889072641986, 7.6796432895344058, 8.6520747616015186, 10.622538104620222, 14.310501425792921, 19.253723232543386, 27.913649363990046, 50.161041673414196, 89.304597077577839, 151.34732218304231, 290.26438540271909, 526.41420210821127, 562.94504896639603, 1708.1934289355961, 4225.3848573287914, 14982.474506443201, 5583.5460990085194, 3891.3661973657854, 2141.5368023327842, 752.9602476197266, 262.54448595536314, 211.30702516808589, 126.94075502116375, 57.995376649220773, 28.688344099071898, 20.058056528572401, 14.773155762512143, 11.328672883224492, 8.8663632607744169, 8.1416889804020052, 7.1762884709607109, 6.6618841738486552, 7.1234501229356262, 7.8125584926262608, 8.8506828512506655, 10.761421361485221, 13.871180161098282, 19.233600066307527, 28.992297197792769, 57.999252895466505, 108.13603201941609, 201.52671733896852, 262.35520536881353, 596.26851293203185, 1502.8058566448742, 3083.8642011691672, 4755.1985786680179], "imag": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0]}, "imag": [0.0, -0.13871927675086548, -0.55827571496092165, -0.85383263724083092, -0.46701193383615952, 0.047809537946767316, -0.3426920474802197, 0.15831589374137059, 0.20589774809377467, -0.21944378817656213, -0.12654666933988368, -0.19544466487854822, -0.096446269450190733, -0.2265628704083768, 0.10840537931386109, -0.055457499657790024, 0.0, 0.055457499657784036, -0.10840537931384955, 0.22656287040837902, 0.096446269450189581, 0.19544466487854698, 0.1265466693398799, 0.21944378817656165, -0.20589774809377467, -0.15831589374137045, 0.34269204748022014, -0.047809537946767663, 0.46701193383615958, 0.85383263724082981, 0.55827571496092188, 0.13871927675086551, -1.279550584464304, -0.80695903119669909, -0.5066002982483182, -1.4561178571661, -0.13414323846201096, -0.25055297311154978, -0.64027404819684697, -0.19951473048424853, 0.33137912963317689, -0.047498243759329373, -0.24064979253244873, 0.1395435157196932, 0.17789090203786645, -0.044374683774468404, -0.36806933922228663, 0.19528135326361654, 0.32999646269142918, -0.13015393203002068, 0.1959681784626765, 0.28571835588367483, 0.22705801052414751, -0.14508578389537852, 0.23457709892354506, 0.21163882649779878, -0.20150153854805303, 0.060946718066345364, 0.31004041285864392, -0.26258387187077481, 0.13955938857309563, -0.2449447076348287, 0.068510051090992716, -1.1758121586434307, -1.3682011726001491, -1.6899938281650106, -0.75019268688655194, 0.68911282851752931, 0.44086751164178845, -0.23155959034339019, -0.54510315877084203, 0.26585764990704713, 0.2624959582084973, -0.045146091846171167, 0.011517786678353055, -0.057907844320373422, 0.076854124253010955, 0.0035092112107953564, -0.23588030048916386, -0.048277840380711062, -0.21489820671404902, 0.26817287178185911, -0.027468417557455105, 0.29873174456545087, 0.072899207479288589, 0.023829771073631354, 0.0066491170121291982, 0.0048298736467919092, -0.13057930804766787, -0.26946209593128789, 0.39240115086507854, 0.85317721061416651, -0.11752989424299426, 0.99998707389668307, 0.55787436167296656, -1.0314907737559058, -1.5043263157657751, -1.3830149751777026, -0.20446853801739454, -0.28364033101911829, 0.68303147161529054, 0.03902721990981517, -0.18273076418691683, -0.013466871818696777, 0.028891896132398606, -0.068621242214500722, -0.026792869524675422, 0.18842973810535804, 0.068392282535087487, -0.17097210848547728, -0.23288712244734344, -0.31416612358708279, 0.27284169211913839, -0.072438990225411531, 0.1202436118466384, 0.067443262257117789, -0.0040452326400191837, -0.15231382612170316, 0.020438609938141238, 0.10773227995476008, -0.1646961578394999, -0.034526357222664054, 0.34045699686317549, 0.3582562672018631, 0.50203282214727851, -0.90050578840564854, 1.1141651843864948, -1.0547694551235964, 0.15113295529591572, -0.42011997382980693, -1.1306687523196075, 0.59904899563122349, 0.12782476119556421, -0.26469201284371935, -0.0028564673365734715, 0.25878855026626812, 0.00078645201341040851, -0.17181320075266995, 0.013143422355015144, 0.050238396740841747, 0.072156922858987921, 0.041604673982592558, -0.0112715468909201, -0.016101389694688766, -0.31269363662275068, 0.094974334151300396, -0.067869387966968731, 0.14811752790953986, 0.010724993842567176, -0.071495661604357427, -0.037154193600070516, 0.05779163337935353, 0.094937931062917286, -0.1272883333159909, -0.017408469796284951, 0.62003762386212868, 0.074417004563971767, -0.12904495334293709, -1.4636084587609224, -0.036743730082780299, -0.77470195486186, -0.60686918965332004, 0.62872636200456622, -0.46894237369717673, -0.18368617361305525, 0.26816260026693856, 0.13447215443394772, 0.041008154934057489, -0.017107991149299187, -0.0680369475996533, -0.01240601732954733, 0.059356927461924558, 0.12615835751185028, 0.053672308552617974, 0.037749743592242362, -0.10597138547480481, 0.022172258797336697, -0.058681894939636686, 0.12792055300624736, -0.060154323470105943, 0.032298308999269151, -0.015701976416949814, 0.0007367446231764113, 0.07712597645572114, 0.055644084876628218, -0.065981740018919821, -0.14567847379973994, 0.039540586335773356, 0.24917063867041539, -0.6432675339043068, 0.36754664039982821, -0.069649876974948205, 0.2952063874323651, -0.011417685121456805, -1.0450941798657123, -0.17374602795438093, 0.19930768818407893, -0.1556206112582631, 0.055817128538076119, 0.17900936499027481, 0.0052374024484263433, -0.042596098823283683, -0.020834261928533829, 0.036686593450547957, 0.00076880260958178746, 0.061719692477810909, 0.027700064466885506, 0.10661165850403151, -0.13945785164947772, -0.050544258155460708, -0.11937846922953205, 0.034399558837173369, 0.02521789889898339, -0.0047468618190418272, -0.028256857448446509, 0.029239764799856467, 0.046539635523190424, -0.033316423902485758, -0.15842957449053302, 0.14741145606308881, 0.1752194519195491, -0.075629282019522973, -0.91968716746889456, -0.45504702044764878, -0.12177128356890227, -0.10462001130261206, 0.1804016527269576, -0.047005347129142915, -0.19200701617075638, 0.1133507155810588, 0.14315736053243958, -0.067545520465919412, -0.0022066601859379556, 0.0084001340729883862, 0.0049338006978182497, 0.016196236751475263, 0.066419574069183293, -0.012240235365542763, 0.014433128838537781, 0.023674926554515096, -0.017114978073907605, -0.14379898617791109, 0.084303725772385638, 0.0056779923265117766, 0.048321020114327755, 0.022849248448590556, 0.012395399307186424, 0.023865191872962568, -0.0060375152678495622, -0.021897165586045375, -0.092173327221095822, -0.17587869380621102, 0.091992925322100877, 0.014980171338571357, 0.0086063527817299007, 0.098130362913165001, 0.130338354535672, 0.094203305677599436, -0.19730813245926024, -0.10041080102702246, 0.075932042745803577, 0.021134287621881041, -0.059575532325244519, 0.0082992125422013917, 0.015272751179096435, 0.0090248536114060952, -0.019251438395354602, -0.015788972597383853, 0.003250945662643008, 0.032968975479440332, -0.015058032290062954, 0.017643635220692015, -0.068857003169531444, 0.030070570566209365, -0.12793975070954616, -0.043534834876013277, 0.0017423598025251587, 0.028592812647173952, 0.0036967486190428137, 0.0090453167838253218, -0.016259252101333162, -0.0052076817297827191, 0.018046490267575967, -0.026168992315517926, -0.083077034868877908, 0.032798990212655046, -0.027546636940189637, -0.12409557570816734, -0.0088356071822206419, -0.034333260533212014, 0.056177295075322577, 0.057994393113440637, -0.032566171451921935, -0.010465798382464413, 0.020079425427313443, -0.017396471253638312, -0.017870360905994483, 0.010919865739753416, 0.012363627500514531, -0.014313215415815719, 0.034201557920817111, 0.10796975372596095, 0.21064351401911494, -0.046016401957029461, -0.083803307026608195, -0.15128619138644472, -0.070745415327885988, -0.06951503451164355, 0.070638418064815661, -0.0080019035626016123, 0.02654845111893607, 0.019862790828204354, -0.0038698355762961699, -0.020866890117519677, -0.0048084432749845906, -0.0036451640963975299, -0.0026341276434262537, -0.0023099396961399252, 0.043908100663757832, 0.096772033742844044, 0.04918905117971889, 0.070600771528734244, -0.026773628633603139, -0.05973226936448265, 0.013552286601009756, 0.0032289712715403013, -0.023046337829044056, -0.010405151723131599, 0.019427096259341661, 0.018256051683800133, -0.056759870222018213, -0.032960560091393032, -0.017399004273096801, 0.12185282737260948, 0.037984234337547759, -0.12270039394272629, -0.055947445070994896, 0.04621845892784341, -0.1857137618225036, -0.063810892086947277, 0.07053672326645595, 0.03906718120738633, 0.01577517031413787, -0.0047456570119124219, -0.019801411975277249, 0.024637199092487311, 0.019457415538283646, -0.0067710516924983765, -0.028346017012320548, -0.0065098329229195291, -0.0013352981567293612, -0.023151697315085987, -0.06519950655383687, -0.1042256990435297, -0.023224778901070588, 0.0072963544312097499, -0.034708386400909293, -0.0023809918522597964, 0.016167541663812009, -0.0054340236987463174, 0.0027208109883995382, 0.0066841964011560553, -0.023932611476630623, -0.039005803210705049, 0.016396390506166533, 0.058067983872416511, 0.15112210885707694, 0.091953539825334094, -0.30878981646904202, 0.23773808023122034, -0.11496619447060334, -0.15410637679425881, 0.16398523681965352, -0.042160123131605852, -0.0057838899052936009, 0.021159112170606904, -0.00089194024953267548, -0.043632529695206895, 0.025594278576058532, 0.04827977682701759, 0.008656372871138766, -0.025123508323013247, -0.021222695138498154, 0.012727342518660707, 0.0027327273075534982, 0.016727222825244921, -0.062351999721191126, -0.095086485134993501, 0.009789315676701096, 0.020526538310240195, -0.0017729650965628652, 0.0042367342426148282, 0.0096918161659650896, -0.014518052118829046, -0.0045810353743419062, -0.069451504639382974, -0.036289590762181183, 0.22708969966074724, 0.3665342673930222, -0.59625762091850343, 0.36774772058649913, 0.2627894192943519, -0.10703484463450727, -0.13950623949894417, -0.080806137493453625, -0.018761372187400087, -0.14807112835842171, 0.015533054933596769, -0.013156170331620851, 0.033053795814988449, 0.012901798319361097, 0.00377273404398293, -0.0087050725477761486, -0.026200884444946355, -0.069983120002794802, -0.045851102565308888, -0.0080215915074989454, -0.048063119818621811, -0.055909188302307122, 0.015567334119352533, -0.069113723063989038, -0.0072474243428621863, 0.042526562044161449, 0.039806904605142766, -0.027582495505149615, 0.0049261433754253488, -0.04754279011762625, -0.074122351214929355, 0.22223052073714245, -0.0077417273670608014, -0.080825286420915882, 0.62390518555370134, -0.18988737165776209, -0.013310214088767865, -0.13538196037364333, -0.38370084094404533, -0.32853605615928166, -0.23095349816725769, 0.0024573680892555631, -0.060148519255615616, 0.030360401196840837, -0.0084214745912351684, 0.033027304906486414, 0.030739864021722699, 0.0097039926999964547, -0.060698557392036313, -0.04746519227839175, -0.053530300822357386, -0.046174234082698239, 0.0052112044634668644, 0.020596160958060543, -0.15878906772803425, -0.02193329327109424, 0.0079342423803948989, 0.027919450264392773, 0.0070430807013025284, 0.020085011074200358, -0.075935043112063852, -0.041652272773957957, 0.16889959178925665, 0.18647295463827135, 0.014154913289577202, 0.060521107576468509, -0.63637312336837226, 0.90191957381577925, 0.27922666018549325, -0.48673882008850766, -0.33370031357259311, -0.3513559741645329, -0.2622745616761345, -0.17197492325356289, -0.0057315027931728107, -0.04469091820910031, 0.053283308768024513, 0.039465599946438043, -0.014174493080162808, -0.04946368453866596, -0.022857667990750397, -0.16881304090125779, -0.080812526909499666, 0.00058234446045326367, 0.084338425974376116, -0.12518231680881081, -0.040506406338050263, -0.08374410530080309, -0.001350704062862842, 0.030200114248426838, 0.042299889130269351, 0.011310849850443803, 0.081759178445920677, 0.035289563063634108, -0.12268118169149339, 0.058157249768416797, 0.19453030659557169, -0.32019695139960919, 1.2621857571853639, 0.24947885513851267, -0.86827138009746829, -0.26346017480935824, -0.40312000272498982, -0.22820944406317872, 0.0813299683314989, 0.0038871367161771898, -0.10891614598123801, 0.00043800911235750134, -0.043289297526922212, 0.012593343881888895, -0.0042686636670869688, -0.008833188472774969, -0.024141666831206311, -0.03923653338217388, -0.25435751708422283, 0.0, 0.13106581900761921, 0.22441332039311174, -0.094768447018961463, 0.0024812204443016074, 0.036286268392045858, 0.0056698536823630895, -0.010705526315732189, 0.082044918512892334, 0.0010532751265284197, 0.015101105715477795, 0.090653505450224631, 0.27613653682211553, 0.17494988738073455, 0.30956821269851931, 0.034540476362705901, 0.0, -0.034540476362701966, -0.30956821269851847, -0.17494988738073411, -0.27613653682211575, -0.090653505450227129, -0.015101105715478274, -0.0010532751265287738, -0.082044918512892334, 0.010705526315732109, -0.0056698536823632534, -0.036286268392045982, -0.0024812204443015839, 0.094768447018961921, -0.22441332039311199, -0.13106581900761924, -0.00058234446045052997, 0.25435751708422299, 0.039236533382173068, 0.024141666831206714, 0.0088331884727747174, 0.0042686636670865837, -0.012593343881888968, 0.04328929752692242, -0.00043800911235742604, 0.1089161459812379, -0.0038871367161778295, -0.081329968331500163, 0.22820944406317803, 0.40312000272499021, 0.26346017480936107, 0.86827138009747229, -0.24947885513851314, -1.2621857571853632, 0.32019695139960752, -0.19453030659557399, -0.058157249768416672, 0.12268118169149329, -0.035289563063634503, -0.081759178445920649, -0.011310849850443772, -0.042299889130268831, -0.030200114248426623, 0.0013507040628626303, 0.083744105300802674, 0.040506406338050895, 0.12518231680881103, -0.084338425974375644, 0.046174234082696289, 0.08081252690949875, 0.16881304090125832, 0.022857667990750261, 0.04946368453866589, 0.014174493080162815, -0.039465599946438334, -0.053283308768024965, 0.044690918209100129, 0.0057315027931725314, 0.1719749232535624, 0.26227456167613394, 0.3513559741645329, 0.33370031357259339, 0.48673882008850966, -0.27922666018549408, -0.90191957381578058, 0.63637312336837637, -0.060521107576467635, -0.014154913289577215, -0.18647295463827063, -0.16889959178925743, 0.041652272773958374, 0.075935043112064518, -0.020085011074200423, -0.0070430807013025249, -0.02791945026439252, -0.0079342423803949891, 0.021933293271094115, 0.15878906772803389, -0.02059616095805995, -0.0052112044634673969, 0.008021591507499164, 0.05353030082235833, 0.047465192278390397, 0.060698557392036064, -0.0097039926999963107, -0.030739864021722747, -0.033027304906486449, 0.008421474591235165, -0.03036040119684083, 0.060148519255615165, -0.0024573680892551967, 0.23095349816725866, 0.32853605615928261, 0.38370084094404566, 0.13538196037364647, 0.01331021408876858, 0.18988737165776171, -0.62390518555369734, 0.080825286420916714, 0.0077417273670609497, -0.22223052073714233, 0.074122351214929452, 0.047542790117626306, -0.0049261433754249724, 0.027582495505149737, -0.039806904605142586, -0.042526562044161428, 0.0072474243428622999, 0.069113723063988594, -0.015567334119352927, 0.055909188302305984, 0.048063119818621922, -0.0027327273075535455, 0.045851102565308353, 0.069983120002795093, 0.026200884444945973, 0.0087050725477759057, -0.0037727340439829347, -0.012901798319361227, -0.033053795814988754, 0.013156170331620811, -0.015533054933596691, 0.14807112835842184, 0.018761372187400604, 0.080806137493454139, 0.13950623949894433, 0.10703484463450816, -0.26278941929435246, -0.36774772058649907, 0.59625762091850687, -0.36653426739302131, -0.22708969966074771, 0.036289590762181079, 0.069451504639383266, 0.0045810353743422905, 0.014518052118829408, -0.0096918161659651156, -0.0042367342426148941, 0.0017729650965627938, -0.020526538310240098, -0.0097893156767009607, 0.095086485134992974, 0.062351999721190751, -0.01672722282524514, 0.065199506553837216, -0.012727342518659639, 0.021222695138497675, 0.025123508323013449, -0.0086563728711387469, -0.048279776827017555, -0.025594278576058595, 0.04363252969520693, 0.00089194024953267417, -0.021159112170607019, 0.0057838899052937813, 0.042160123131606046, -0.16398523681965352, 0.15410637679425865, 0.11496619447060411, -0.23773808023122042, 0.30878981646904247, -0.091953539825333053, -0.15112210885707561, -0.058067983872415838, -0.016396390506166002, 0.039005803210705077, 0.023932611476630637, -0.006684196401155907, -0.0027208109883995707, 0.0054340236987462662, -0.016167541663812044, 0.0023809918522598732, 0.034708386400909043, -0.0072963544312100569, 0.023224778901069786, 0.10422569904352962, -0.049189051179719279, 0.023151697315084544, 0.0013352981567299367, 0.0065098329229194736, 0.02834601701232067, 0.0067710516924982707, -0.019457415538283694, -0.024637199092487305, 0.019801411975277225, 0.0047456570119127489, -0.015775170314137797, -0.03906718120738624, -0.070536723266456214, 0.063810892086946833, 0.18571376182250354, -0.046218458927843417, 0.055947445070994993, 0.1227003939427266, -0.037984234337547038, -0.12185282737260873, 0.01739900427309727, 0.032960560091392817, 0.056759870222018227, -0.018256051683799891, -0.019427096259341584, 0.010405151723131587, 0.023046337829044038, -0.0032289712715403299, -0.013552286601009622, 0.059732269364482463, 0.026773628633603028, -0.070600771528734632, 0.008835607182220432, -0.096772033742842878, -0.043908100663758234, 0.0023099396961402566, 0.0026341276434262424, 0.0036451640963978101, 0.004808443274984581, 0.020866890117519587, 0.0038698355762962896, -0.019862790828204292, -0.026548451118935872, 0.0080019035626017337, -0.0706384180648158, 0.069515034511643051, 0.070745415327885364, 0.15128619138644453, 0.083803307026608292, 0.046016401957029593, -0.21064351401911435, -0.10796975372596025, -0.034201557920816583, 0.01431321541581594, -0.012363627500514576, -0.010919865739753575, 0.017870360905994497, 0.017396471253638378, -0.02007942542731345, 0.01046579838246435, 0.032566171451921762, -0.05799439311344054, -0.056177295075322847, 0.034333260533212451, -0.130338354535672, 0.12409557570816747, 0.027546636940189641, -0.032798990212655137, 0.083077034868877978, 0.026168992315517999, -0.018046490267575984, 0.005207681729782772, 0.016259252101333162, -0.009045316783825131, -0.0036967486190426836, -0.028592812647173869, -0.0017423598025251908, 0.043534834876013409, 0.12793975070954686, -0.030070570566209584, 0.068857003169531444, -0.017643635220692303, 0.015058032290063167, -0.032968975479440069, -0.0032509456626426633, 0.015788972597383943, 0.019251438395354474, -0.0090248536114061126, -0.015272751179096435, -0.0082992125422014836, 0.059575532325244533, -0.021134287621881149, -0.075932042745803632, 0.10041080102702246, 0.19730813245926007, -0.094203305677599283, 0.12177128356890216, -0.098130362913164085, -0.0086063527817301141, -0.014980171338571052, -0.091992925322100572, 0.17587869380621152, 0.092173327221095724, 0.021897165586045479, 0.0060375152678496429, -0.02386519187296254, -0.012395399307185896, -0.022849248448590303, -0.048321020114327692, -0.0056779923265118269, -0.084303725772385735, 0.1437989861779114, 0.017114978073907855, -0.023674926554513819, -0.014433128838537597, 0.012240235365543381, -0.066419574069182918, -0.016196236751474646, -0.0049338006978182185, -0.0084001340729884851, 0.0022066601859378697, 0.067545520465919467, -0.1431573605324398, -0.11335071558105927, 0.19200701617075636, 0.047005347129143109, -0.18040165272695829, 0.10462001130261284, -0.2952063874323646, 0.45504702044764878, 0.91968716746889512, 0.075629282019523555, -0.17521945191954877, -0.14741145606308895, 0.15842957449053352, 0.033316423902485841, -0.046539635523190549, -0.029239764799856394, 0.028256857448446561, 0.0047468618190423398, -0.025217898898983061, -0.034399558837173737, 0.11937846922953181, 0.050544258155460854, 0.1394578516494776, -0.10661165850403005, -0.027700064466883865, -0.061719692477810832, -0.00076880260958129979, -0.036686593450547596, 0.020834261928534131, 0.042596098823283357, -0.0052374024484263546, -0.17900936499027453, -0.055817128538076279, 0.1556206112582631, -0.19930768818407885, 0.17374602795438115, 1.0450941798657116, 0.011417685121456564, 0.77470195486186011, 0.069649876974948843, -0.36754664039982721, 0.64326753390430735, -0.24917063867041553, -0.039540586335773169, 0.14567847379973992, 0.065981740018920196, -0.055644084876628218, -0.07712597645572139, -0.00073674462317611055, 0.015701976416950342, -0.032298308999268784, 0.060154323470106401, -0.12792055300624763, 0.058681894939637193, -0.022172258797336572, 0.105971385474807, -0.037749743592242278, -0.053672308552617946, -0.12615835751184992, -0.059356927461923663, 0.012406017329547145, 0.068036947599653702, 0.017107991149299284, -0.041008154934057878, -0.13447215443394772, -0.26816260026693878, 0.18368617361305564, 0.46894237369717728, -0.62872636200456533, 0.60686918965331993, -0.15113295529591578, 0.036743730082780514, 1.463608458760923, 0.12904495334293731, -0.074417004563971351, -0.62003762386212891, 0.017408469796284774, 0.1272883333159911, -0.094937931062917147, -0.057791633379354237, 0.037154193600070003, 0.071495661604358593, -0.010724993842566222, -0.14811752790953939, 0.067869387966970118, -0.094974334151300438, 0.31269363662275046, 0.01610138969469304, 0.011271546890921311, -0.0416046739825933, -0.072156922858987255, -0.050238396740841143, -0.013143422355014638, 0.17181320075266959, -0.00078645201341033847, -0.2587885502662679, 0.0028564673365731054, 0.26469201284371935, -0.12782476119556443, -0.59904899563122194, 1.130668752319608, 0.4201199738298067, 1.5043263157657745, 1.0547694551235969, -1.1141651843864939, 0.90050578840564954, -0.50203282214727829, -0.35825626720186354, -0.34045699686317654, 0.034526357222664658, 0.16469615783949973, -0.10773227995476188, -0.020438609938140839, 0.15231382612170388, 0.0040452326400209297, -0.067443262257115694, -0.120243611846639, 0.072438990225412794, -0.27284169211913811, 0.31416612358708496, 0.23288712244734694, 0.17097210848547523, -0.068392282535087695, -0.1884297381053561, 0.026792869524674363, 0.068621242214500999, -0.028891896132398506, 0.01346687181869554, 0.18273076418691644, -0.039027219909814823, -0.68303147161529132, 0.28364033101911773, 0.20446853801739462, 1.3830149751777017, 1.3682011726001495, 1.0314907737559074, -0.55787436167296611, -0.99998707389668362, 0.11752989424299397, -0.85317721061416762, -0.39240115086507799, 0.26946209593128989, 0.13057930804766765, -0.0048298736467919578, -0.0066491170121302217, -0.023829771073630532, -0.072899207479286424, -0.29873174456544577, 0.027468417557455698, -0.26817287178186705, 0.21489820671404794, 0.048277840380711166, 0.23588030048916517, -0.0035092112107956196, -0.076854124253010928, 0.057907844320372041, -0.011517786678353752, 0.045146091846170348, -0.2624959582084973, -0.26585764990704652, 0.54510315877084026, 0.23155959034339049, -0.44086751164178861, -0.68911282851752897, 0.75019268688655205, 1.6899938281650098, 1.2795505844643045, 1.1758121586434311, -0.068510051090992494, 0.24494470763482898, -0.13955938857309558, 0.26258387187077409, -0.31004041285864437, -0.060946718066343622, 0.20150153854805294, -0.21163882649779717, -0.23457709892354675, 0.14508578389537688, -0.22705801052414679, -0.2857183558836735, -0.19596817846267664, 0.13015393203001066, -0.32999646269142935, -0.19528135326362211, 0.36806933922229168, 0.044374683774465004, -0.17789090203786717, -0.13954351571969323, 0.24064979253244634, 0.047498243759330878, -0.33137912963317673, 0.19951473048424839, 0.64027404819684597, 0.25055297311154973, 0.13414323846201037, 1.4561178571660989, 0.50660029824831798, 0.80695903119669876], "height": 32, "width": 32, "top": {"real": [17750.107020847583, 6210.8656159662787, 10017.081922566327, 3457.5995074393513, 265.850218137708, -70.207684810343054, -8.882891147089472, 24.589756503786479, -11.140592103834141, -1.46746599378154, -0.34121813437428317, 1.0812077419156148, 1.7163290532419633, -4.5666146304635689, -2.6846394014203829, -2.2738643666223468, 1.917575640981823, -2.2738643666223641, -2.6846394014204122, -4.5666146304635395, 1.7163290532419744, 1.0812077419156028, -0.34121813437427356, -1.4674659937815784, -11.140592103834141, 24.589756503786372, -8.8828911470896639, -70.20768481034348, 265.8502181377076, 3457.5995074393486, 10017.081922566325, 6210.8656159662851, 23430.31298691556, -4993.9863865787011, -867.92707841112326, 991.9702295167051, 152.49743471969379, -30.096228916888641, 45.849661798659078, -31.467588946689009, 16.960718546454469, 4.334366206560186, -0.42583907131000093, 0.47860527443285728, -1.8738744001784808, 0.5336707597630499, -3.8841941455247579, -0.75407824565303971, 0.55147195392985549, -0.79345242739339283, -5.9026769793174889, -1.384293215600769, -4.1447942145798233, -2.9130522743117342, -0.87120822186396762, -1.7340023689981476, 8.0221119849442548, -9.1034799758133218, 67.038874839272566, 44.112472832699858, 441.79945796279685, 3245.5044122716786, 3861.5097933424754, -5655.7687421695537, -15889.920855591003, -2792.0170209163471, 3795.2577126849956, 553.88440852995757, -85.905664770254234, 195.26564512659746, 24.791859336013662, 19.637521614531401, -6.1680089153590449, -5.0872002952886746, -0.21502707506361318, 1.4832779566036471, 1.4444541156654906, -2.278921340791467, 0.30255454236990775, -2.3473646939882187, -0.02820677859184775, 1.2126049622480428, -0.78557937342030726, -2.9245439997897638, 1.236962081731878, 1.1827041713801927, -1.6114665304853286, -3.5864367039316236, -14.698165954413065, 20.29282209316159, 43.732891706759197, 111.68572777077691, -209.48016621032312, -187.12585183373633, 2586.3148393820152, 1688.0815183011628, 4748.2203910254093, 1775.7319020900284, 965.53459113591498, -592.89741380746352, 99.787886354888371, 95.459765036004825, 59.296635518443523, -7.6987106331430111, -0.0036180413118668542, -0.43290786252066471, -1.598202682681902, 0.11359872229615781, -0.47654646487314006, 0.052920121324431191, -1.1931569571302629, 1.6263047283546588, 1.1208282513608689, -1.916766911729648, -1.3790558562903064, -0.15528235781115707, 0.33989539819890602, -1.1170639390757935, -0.54019671791116586, 2.4039660385463359, 7.3342674422729397, -18.965458306286095, 0.037731231015075362, 5.7888823722245277, -226.40133474887324, -362.07505408372458, 1068.1182163210274, 1839.5542246985658, 1536.2207931138801, 1719.2247320855465, 351.77395499971544, -218.00810259302051, -154.06814929171503, 76.932404651951941, 11.83330919947551, 3.0799843602247936, 2.1514657945922595, -2.1600173905506583, -0.81329272919310069, -0.057640935991259419, 0.81743781787660708, 0.47007834357539929, 0.82578474649026179, -0.485121980563267, -0.44118347877967812, 0.85372587191033056, -0.96505091801449949, -2.5001329354507269, -0.28227610008090631, 1.5082121759974054, 0.73323799037869442, 0.47326064521443867, -2.2071915479661444, 2.1017967421924912, -14.788373732218277, -10.376064867674437, -110.67917899227207, -400.67251265606825, 13.375377575225066, 2228.271084047331, 1272.0006323499422, 485.30359922269918, -150.18264185504094, -215.33992676901764, -8.8694467345951651, 40.216044199991913, 0.62739683840663496, -1.763160286154926, 0.88761506214793773, 2.2829883187502253, -0.37542737915458396, -0.082924323502338942, -0.2690018095258665, 0.066494953017985289, -1.2937095742683771, 0.90148019848405447, 1.049315066873844, -1.5500155662664761, -1.5096304544124948, -0.76725462527686761, -0.45464639460382006, 0.03503878860161394, 0.85393872935961013, 0.89172763012310696, -0.12413241898971583, -7.4057881467564117, -5.5362761946156125, 1.231534306746803, 18.635135255424384, 26.03667534143711, -87.772888824715437, -225.72012452523001, 395.63478219787083, 378.71701677039351, 36.703056312438811, -91.050394397947159, -3.4611377608751717, 16.691588629055683, -0.030826600791664327, -3.1969308796412692, 1.3816292236713215, 0.42488100600164197, 0.084713763632908196, -0.28535803119354425, 0.0058483120842748731, -0.72249565507011926, -0.80262162213105104, -0.11947358836291604, 0.14251583505573939, -0.26639764768858409, -0.59599833623749066, -0.56289480519068613, -0.092201911820288446, 0.77223819072116529, 0.55522491064190738, -0.14411590791637013, -2.1806910872492855, 1.0588352659849944, -1.722617263430356, -9.0167440767821265, -38.483896322518888, -22.599080819691828, 25.541139705127691, 375.57983717352784, 181.47383294778024, 149.67885098073037, -4.1008782517976057, -3.7383475143657869, 18.721866312633942, -1.1602382001305473, -5.8391540939420112, -0.21088907624048864, -0.29870055099180226, 0.95331837446181378, 0.060424395643205529, -0.42858353450158043, -0.37036207729837234, -0.30369644506457261, -0.75652176347658984, -0.44545713631522388, 0.71326845215283508, 0.071761808928956311, -0.63829698193917794, -0.45235505563855871, -0.080159340308425753, -0.15881914095274483, 0.37773826228539636, -0.097086363313521495, -0.86706044290909523, -1.3342582973973045, -0.61792777020441481, 0.16957438507140327, 10.565905071599056, 15.380533375221102, 10.500239194747859, 19.996280010030237, 18.60272375866586, 4.0348314717803326, 11.168149094486143, 14.395513359675057, -3.576502394652771, -3.8760628092228431, 2.0358977627782506, -1.6580642648165547, -0.13166485139511078, 0.2591565726162201, -0.22701969228044258, -0.29312645623416966, 0.099969472199353857, -0.39101661164543228, -0.042546772814251566, 0.29433076927773894, -0.50935384874181677, 0.090487726861141621, -0.092143985882572388, -0.58253529440268437, -0.41671432281001702, 0.14644815319126417, 0.2723500443275419, -0.039709576626662156, -0.41013369223337515, 1.1756350920235048, 1.5259648698081887, -4.4516278662013118, -8.128003687892722, 9.6041080205516938, 20.813833475064627, 12.963050463991683, 7.8870012209429445, 15.407970089260955, 5.3783096889109112, -3.1350030536179672, 1.9101786820520572, 1.6649545288728531, -2.1421648847872561, 0.35230920085802159, 0.37729718445187704, 0.020823929394603979, 0.087139744957248078, -0.10976037032555666, -0.56986899401739111, -0.44020908152219312, 0.69190564661152409, 0.20725962387572397, 0.64042787368671816, 0.71867283099896739, 0.16183428074791173, -0.17223426808716463, -0.17676233483878773, -0.27594664738318686, 0.095238357444986099, 0.020726971935864241, -0.11463597101365795, -0.32333311610982368, 1.2888258236383847, 3.0237538834517612, -0.12189842989060286, -4.5002056479068653, -2.8307120360813536, 9.0325055742836575, -5.0836871456416608, -6.4226783361185662, -2.3832064029645541, 2.1204380507892151, -2.1797923249754283, -2.1316882770768921, 1.4364513793862836, 0.82847417311036753, -0.54705107713687473, -0.053118808001263999, 0.10349330090189141, -0.027586170457780668, -0.27866115184949369, -0.4744187891270259, 0.32835706009268834, 1.8712198771790323, 0.44937016780231559, 0.8488760221500451, 0.35191803530681381, 0.28758243475250972, -0.6426201464805843, -0.40597353100929789, -0.22244529364246871, -0.071869502235051647, 0.33021466122988641, 0.24942995069051274, -0.5214330526633183, -0.093662554700336673, 1.1233733739102922, 1.9003965613191238, 0.07120934753760759, -8.6549236119446178, -1.8427620371931031, -0.52295775466804406, 3.4092952720370122, -0.65003177967723336, -0.1840159964371442, 1.8831870902689825, 0.7983111628921199, -0.39925172982701851, 0.051205177403033819, 0.2598923527237304, -0.18824332097783142, 0.13750859145926242, 0.78226830313090512, -1.2572785001190825, 1.3355363328556911, 1.2220896356262305, 1.6491421999762639, 1.7622421170936717, 0.96487439834416744, 0.79128381470112286, -0.26979590260649117, -0.37236776211072153, -0.65318812250908376, -0.13360581679076858, -0.1817007191765827, 0.4244891020544192, 1.0695325895656689, -0.49200291489349485, -0.59959066580988751, -2.4610304070506381, -1.7528842523917616, 5.4092974592427554, 11.628502736704702, 13.318871722095572, 5.3844201289172418, 0.12839725172390623, -0.91462159985003533, -0.4207633568928546, 0.73289618436063231, 0.98164545606019249, -0.31879685258307294, -0.45467275635234927, 0.23929181220408463, 0.73553732103708702, -0.78050285180289647, -0.20614377250205779, -0.66147354811396541, 0.84722544756444751, 3.1542100241342745, -1.0454812204468338, 0.49112272834774079, 0.89780094097137775, -0.80686344960242362, 0.26166207514350009, 0.34234964401672252, -0.27361449647202374, 0.078400343257288022, 0.27130715748636108, -0.26706243773596255, 0.92879560872659372, -1.3686907450256593, 0.37153092475944227, -0.0077060915391855903, -2.1487270106054996, 8.2423115107991176, 10.211121947580189, 11.004080199445575, 5.512476255300478, 0.43541395104991965, 1.3138259234516578, 0.47697687525002369, -0.37437690637871951, 0.49170325146724819, 0.53092933204425685, 0.78977231856458541, 0.054935970034302541, 1.0907299238052364, -1.4537313504920895, 1.6637415256529431, 2.3271742206176285, 1.6752406948773604, 6.0227778178364675, -2.5693140331095292, -1.3449083811022362, -0.063540759326359386, 1.2007479971921078, 0.26947504329539196, -0.043317616642408706, -0.090092404474960294, -0.56149356452164179, -0.29757479536733583, -0.82531287850485402, 0.52880973840083989, -0.51042849628299192, 1.1866854822445434, 7.7130480762288167, 17.626109919920186, 26.29568713002228, 9.1514979514586194, -1.521929375229722, 0.85364359123771261, -0.365663824522519, -1.1590870007863963, 0.48082630002696519, 0.93059067445638155, 1.1024013035834523, 0.63841829574218301, 1.5659590764611497, 0.20674310541385973, 1.0081259505833966, 1.4865008399227626, -1.6031905208728288, 5.7718835709767413, 0.2720344299284404, 3.2411570780563994, -1.0481514144590243, 2.2338214812745694, 3.1628749936702945, 1.7743358086362808, -0.03099281849361625, -0.41442882712954171, -0.31459130661253104, -1.7323756021672925, 0.19363530105298493, 0.61123212270521721, 4.8260404786904152, 6.7814469674820135, 4.974801806376985, 19.935738411546794, 15.127019575257112, 16.951752765718286, 6.976320734749117, 0.83204582564536733, -0.22090351652873133, -0.48187393778382737, -0.72216259413318939, 0.68337514879437744, 1.4934027691778771, 1.3836806937153638, -0.089108362899698895, 0.57910533764344185, 3.1507795425198797, 1.9139554692796912, 4.1423990225960203, -5.0893580330573318, 4.6545320074577088, -1.3079026033800338, 1.2583901568403451, 1.3087920196200225, 1.8018391908724931, 1.3933980798910508, 0.67604933114803067, -0.49475104816844406, -1.4152366315362725, -0.64580662533466104, -1.4537653735214031, 3.1014323943375786, 7.6843087454063586, 10.909142678924193, 12.359496229531475, 15.280082473470735, 24.669023160454167, 12.739042274822818, 1.7204760023261643, 0.52929508548715176, 2.1482192005482723, -1.481161898887601, -0.79404079710432474, 0.46540881956838565, 0.92624711854277975, 1.0380549761479756, 2.3168267428989626, 1.5788387366050483, -0.83766970523004924, 4.7505720502223729, -2.6570294115495297, 6.7612131323955511, -2.6570294115495336, 4.7505720502223783, -0.83766970523005702, 1.5788387366050476, 2.3168267428989657, 1.0380549761479752, 0.9262471185427773, 0.46540881956838565, -0.79404079710432862, -1.4811618988876001, 2.148219200548279, 0.52929508548715154, 1.7204760023261518, 12.739042274822809, 24.669023160454188, 19.935738411547018, 12.35949622953156, 10.909142678924129, 7.6843087454063417, 3.101432394337563, -1.4537653735213987, -0.64580662533467093, -1.4152366315362839, -0.49475104816844562, 0.67604933114803401, 1.3933980798910552, 1.8018391908724987, 1.3087920196200247, 1.2583901568403484, -1.3079026033800301, 4.6545320074577061, -5.0893580330573203, 4.1423990225960088, 1.913955469279683, 3.1507795425198943, 0.57910533764344618, -0.089108362899694094, 1.3836806937153729, 1.4934027691778826, 0.68337514879437378, -0.72216259413318618, -0.4818739377838111, -0.22090351652873805, 0.83204582564534302, 6.976320734749093, 16.951752765718314, 15.127019575257133, 17.626109919920285, 4.9748018063769956, 6.7814469674819922, 4.8260404786903921, 0.61123212270520444, 0.19363530105297699, -1.7323756021672947, -0.31459130661253587, -0.41442882712954437, -0.030992818493609464, 1.7743358086362877, 3.162874993670298, 2.2338214812745694, -1.0481514144590143, 3.241157078056395, 0.27203442992843363, 5.7718835709767413, -1.6031905208728274, 1.4865008399227673, 1.0081259505833953, 0.20674310541386615, 1.5659590764611582, 0.63841829574219022, 1.1024013035834526, 0.93059067445638244, 0.48082630002696636, -1.1590870007863949, -0.36566382452250978, 0.85364359123770939, -1.5219293752297598, 9.1514979514585963, 26.295687130022237, 8.2423115107992349, 7.7130480762288673, 1.1866854822445243, -0.51042849628302267, 0.52880973840082446, -0.82531287850485058, -0.297574795367338, -0.56149356452165111, -0.090092404474959795, -0.043317616642408116, 0.26947504329539745, 1.2007479971921178, -0.063540759326354057, -1.3449083811022313, -2.5693140331095257, 6.0227778178364719, 1.675240694877361, 2.3271742206176271, 1.6637415256529449, -1.4537313504920832, 1.0907299238052377, 0.054935970034312817, 0.78977231856459063, 0.53092933204426229, 0.49170325146725052, -0.37437690637871607, 0.4769768752500283, 1.3138259234516545, 0.43541395104990577, 5.5124762553004887, 11.004080199445557, 10.211121947580168, 11.628502736704604, -2.1487270106054663, -0.0077060915391693741, 0.37153092475944555, -1.3686907450256616, 0.92879560872659006, -0.26706243773595856, 0.27130715748636525, 0.078400343257288438, -0.27361449647201985, 0.34234964401672396, 0.26166207514350365, -0.80686344960242218, 0.8978009409713853, 0.49112272834772974, -1.045481220446846, 3.1542100241342701, 0.84722544756444151, -0.66147354811395898, -0.20614377250205829, -0.7805028518028938, 0.73553732103708935, 0.23929181220408727, -0.45467275635235105, -0.31879685258307255, 0.98164545606019549, 0.73289618436063131, -0.42076335689285432, -0.91462159985003766, 0.12839725172388108, 5.3844201289172204, 13.318871722095585, -1.8427620371929223, 5.4092974592426515, -1.7528842523917609, -2.4610304070506088, -0.59959066580987819, -0.49200291489348996, 1.0695325895656664, 0.42448910205441354, -0.18170071917658262, -0.13360581679076522, -0.65318812250908243, -0.3723677621107227, -0.26979590260649017, 0.7912838147011273, 0.96487439834416677, 1.7622421170936722, 1.6491421999762705, 1.2220896356262196, 1.3355363328556904, -1.2572785001190749, 0.78226830313090379, 0.13750859145926628, -0.18824332097783478, 0.25989235272372874, 0.051205177403034013, -0.39925172982701423, 0.79831116289212645, 1.8831870902689678, -0.18401599643714045, -0.65003177967722925, 3.4092952720370082, -0.52295775466808114, -5.0836871456417914, -8.654923611944545, 0.071209347537571008, 1.9003965613191072, 1.1233733739103013, -0.093662554700343362, -0.52143305266331286, 0.24942995069051838, 0.33021466122988513, -0.071869502235049398, -0.22244529364246549, -0.40597353100929245, -0.64262014648058341, 0.28758243475251449, 0.35191803530680799, 0.84887602215004632, 0.44937016780231587, 1.8712198771790289, 0.32835706009269156, -0.47441878912702484, -0.27866115184949264, -0.027586170457779294, 0.1034933009018901, -0.053118808001266206, -0.54705107713687218, 0.82847417311037153, 1.4364513793862805, -2.1316882770768819, -2.1797923249754287, 2.1204380507892009, -2.3832064029645679, -6.4226783361184081, 7.8870012209433504, 9.0325055742834763, -2.8307120360814029, -4.5002056479068191, -0.12189842989059124, 3.0237538834517572, 1.2888258236383801, -0.32333311610982529, -0.11463597101365604, 0.020726971935865871, 0.09523835744498739, -0.27594664738318975, -0.17676233483878293, -0.17223426808716019, 0.16183428074791517, 0.71867283099897139, 0.64042787368672205, 0.20725962387572536, 0.69190564661152509, -0.44020908152219435, -0.56986899401739244, -0.10976037032555588, 0.087139744957248716, 0.020823929394600361, 0.37729718445187588, 0.35230920085802736, -2.142164884787245, 1.6649545288728365, 1.9101786820520659, -3.1350030536179658, 5.3783096889108455, 15.40797008926083, 18.60272375866586, 12.963050463991696, 20.813833475064644, 9.604108020551676, -8.1280036878927362, -4.4516278662013278, 1.5259648698081876, 1.1756350920235052, -0.41013369223337515, -0.039709576626662003, 0.27235004432754167, 0.14644815319126442, -0.41671432281001886, -0.58253529440268281, -0.092143985882572915, 0.090487726861142509, -0.50935384874181677, 0.29433076927773738, -0.042546772814252246, -0.39101661164543189, 0.09996947219935487, -0.29312645623417033, -0.22701969228044291, 0.2591565726162216, -0.13166485139511078, -1.6580642648165524, 2.0358977627782484, -3.8760628092228537, -3.5765023946527563, 14.395513359675084, 11.168149094486147, 4.034831471780354, 181.47383294778047, 19.996280010029963, 10.50023919474779, 15.38053337522109, 10.565905071599067, 0.16957438507140921, -0.6179277702044097, -1.3342582973973056, -0.86706044290909146, -0.097086363313522245, 0.37773826228539636, -0.1588191409527461, -0.080159340308420923, -0.45235505563855616, -0.63829698193917661, 0.071761808928958337, 0.71326845215283419, -0.44545713631521988, -0.75652176347658784, -0.30369644506457882, -0.37036207729837373, -0.42858353450157866, 0.060424395643203697, 0.953318374461814, -0.29870055099180354, -0.21088907624048941, -5.8391540939419864, -1.1602382001305538, 18.721866312633882, -3.7383475143657954, -4.100878251797706, 149.67885098073012, 395.63478219787089, 375.57983717352744, 25.541139705127598, -22.599080819691835, -38.483896322518888, -9.0167440767821709, -1.7226172634303247, 1.0588352659849967, -2.1806910872492873, -0.14411590791637696, 0.55522491064190693, 0.77223819072116739, -0.092201911820284366, -0.56289480519067914, -0.59599833623749254, -0.26639764768858487, 0.14251583505573989, -0.11947358836291141, -0.80262162213105359, -0.72249565507012325, 0.0058483120842701027, -0.28535803119354936, 0.084713763632907418, 0.42488100600164375, 1.3816292236713219, -3.1969308796412634, -0.030826600791668796, 16.691588629055648, -3.4611377608751566, -91.050394397947187, 36.703056312438633, 378.71701677039351, 1272.0006323499422, -225.72012452523026, -87.772888824715139, 26.036675341437149, 18.635135255424501, 1.2315343067468421, -5.536276194615616, -7.4057881467564011, -0.12413241898971436, 0.89172763012310496, 0.8539387293596038, 0.035038788601613982, -0.4546463946038164, -0.76725462527685828, -1.509630454412483, -1.550015566266479, 1.0493150668738473, 0.90148019848405436, -1.2937095742683813, 0.066494953017976297, -0.26900180952586789, -0.082924323502345257, -0.37542737915458746, 2.2829883187502267, 0.88761506214793962, -1.7631602861549227, 0.62739683840662275, 40.216044199991877, -8.8694467345952006, -215.33992676901772, -150.18264185504114, 485.3035992226977, 1536.2207931138814, 2228.2710840473319, 13.3753775752247, -400.67251265606865, -110.679178992272, -10.376064867674508, -14.788373732218197, 2.1017967421924983, -2.207191547966143, 0.47326064521441386, 0.73323799037869852, 1.5082121759973919, -0.28227610008090809, -2.5001329354507282, -0.96505091801449672, 0.8537258719103169, -0.44118347877968372, -0.48512198056327205, 0.82578474649025857, 0.47007834357539341, 0.81743781787659597, -0.057640935991271409, -0.81329272919311113, -2.1600173905506721, 2.1514657945922622, 3.0799843602248034, 11.833309199475522, 76.932404651952027, -154.06814929171483, -218.00810259302057, 351.77395499971459, 1719.2247320855445, 4748.2203910254084, 1839.554224698564, 1068.1182163210278, -362.07505408372486, -226.40133474887313, 5.7888823722244789, 0.037731231015098787, -18.965458306285971, 7.3342674422729388, 2.4039660385463657, -0.54019671791118873, -1.1170639390757879, 0.33989539819890108, -0.15528235781113153, -1.3790558562903272, -1.9167669117296613, 1.1208282513608707, 1.6263047283546224, -1.193156957130264, 0.052920121324427458, -0.4765464648731435, 0.11359872229612604, -1.5982026826818876, -0.43290786252068791, -0.0036180413118654109, -7.6987106331430244, 59.296635518443559, 95.459765036004427, 99.787886354888386, -592.89741380746432, 965.53459113591339, 1775.7319020900306, -15889.920855591006, 1688.0815183011607, 2586.3148393820165, -187.12585183373636, -209.48016621032366, 111.68572777077674, 43.732891706759332, 20.292822093161472, -14.698165954413049, -3.5864367039316574, -1.611466530485326, 1.1827041713801545, 1.2369620817318689, -2.9245439997897797, -0.78557937342029793, 1.2126049622479607, -0.028206778591846705, -2.3473646939882631, 0.30255454236988177, -2.278921340791416, 1.4444541156654738, 1.483277956603626, -0.21502707506361871, -5.0872002952886604, -6.168008915359052, 19.637521614531632, 24.791859336013527, 195.26564512659732, -85.905664770254006, 553.88440852995757, 3795.2577126849942, -2792.0170209163462, 23430.312986915553, -5655.7687421695537, 3861.5097933424781, 3245.5044122716772, 441.79945796279628, 44.112472832700512, 67.038874839272665, -9.1034799758128742, 8.0221119849442406, -1.7340023689979776, -0.87120822186400182, -2.9130522743116929, -4.1447942145798446, -1.3842932156007377, -5.9026769793175413, -0.7934524273933764, 0.55147195392985315, -0.75407824565312243, -3.8841941455247726, 0.53367075976302614, -1.8738744001784735, 0.47860527443281381, -0.42583907130996707, 4.3343662065600954, 16.960718546454476, -31.467588946689279, 45.849661798659248, -30.096228916889014, 152.4974347196931, 991.97022951670215, -867.92707841112428, -4993.9863865787029], "imag": [0.0, -2277.9356791272003, -4760.5440393641002, -3362.7502157108247, -452.6326365977277, 12.902525613472081, -66.324591493039264, 21.395810280639775, 12.049924797684376, -6.4322319301924828, -2.6401787430633603, -2.8941924141450355, -1.0996569736184965, -2.1837600734887777, 0.87308165169681873, -0.4143473704962265, 0.0, 0.41434737049617953, -0.87308165169672458, 2.1837600734887985, 1.0996569736184816, 2.8941924141450213, 2.6401787430632839, 6.4322319301924944, -12.049924797684376, -21.395810280639751, 66.32459149303935, -12.902525613472182, 452.63263659772764, 3362.7502157108197, 4760.5440393641011, 2277.9356791272016, -19170.834011440937, -3837.2504381898657, -1562.2865240696121, -2188.2624437144, -79.985389317630222, -65.73387671644744, -129.03232713044309, -21.574731283989859, 19.219741943874205, -1.3770831994436832, -4.6285618656089973, 1.9356332468609161, 1.914358953204174, -0.39274625271235863, -2.8755632420164114, 1.3910769799127469, 2.1983982122300691, -0.93402216187723952, 1.5955119590990243, 2.5332827335358816, 2.5722659267438073, -2.1433748844126024, 4.7051607105169868, 6.0715674792926295, -11.686157623491814, 7.736622407403881, 65.513717323045199, -68.939947660481394, 105.08267177765576, -524.55810593663, 266.59769699529215, -6565.2013915603111, -12998.804313286138, -7140.8743305075541, -1281.4742181751476, 387.93265499317204, 232.0789193763446, -67.213502175129548, -82.499903393484686, 23.742310304940581, 13.167070698799225, -1.2601921779485123, 0.22176027695648487, -0.82869028871129857, 0.81638586337482588, 0.030361957750051641, -1.8114765667849664, -0.33462283171345614, -1.4063404110660631, 1.8330278968089115, -0.19923279402973898, 2.6325944160953934, 0.74767454410312451, 0.33273215463055067, 0.1242120122414053, 0.13350548988021607, -6.7517210150420688, -24.893726268864828, 68.764375920932309, 203.58844824671789, -52.443377241039173, 589.84188198577237, 814.38538391702434, -3077.5993672243876, -9988.2725309741327, -5000.8757444384873, -213.86760970710961, -153.72085790515706, 376.50689706328353, 10.499004391497454, -22.259718007212538, -1.0587560944123571, 1.3367261976572533, -1.845627367813951, -0.50817475490747221, 2.6646257572641145, 0.72663987403826902, -1.4553261209412862, -1.7486114908592469, -2.2393579162674944, 1.7872556824974239, -0.4779279337995983, 0.90990468751900189, 0.56850457149088529, -0.042260514128558184, -2.0950938638350283, 0.37842412015856491, 2.7868839636562086, -7.1796038797667068, -2.6532766677526052, 42.569555354666804, 86.618323256686423, 262.60583525697274, -570.34935164465662, 953.3853188584327, -2608.4519239039555, 423.76919790180068, -777.49072200787271, -730.15551768721184, 267.77827954485849, 48.782690015655945, -52.084914641107339, -0.26732768536918228, 18.791248861451912, 0.034376983736590996, -4.7733525107569852, 0.2450889317389604, 0.69551673309505335, 0.74689297610787508, 0.36254455317814038, -0.082864627703290866, -0.11088180406499534, -1.9145243520823481, 0.63809937787576865, -0.47609558693404908, 1.1704253870693357, 0.1035348526676573, -0.98268640942924379, -0.66403014974353547, 1.4462870038602533, 3.6812627646537175, -8.6847068298461885, -1.7026644231740631, 110.68919188818327, 26.998515460375977, -65.421023262373453, -744.09540667092062, -46.729307478653496, -1526.2181503116453, -735.50774046161519, 282.18880697804167, -182.37864683063907, -54.052681314235201, 39.603849315110104, 10.295701682078779, 2.359337802307917, -0.63461911007383953, -1.7124190510555728, -0.21593130161202514, 0.76755040332111413, 1.2882353738829533, 0.44968314290067118, 0.25989055470659483, -0.66713893962057369, 0.13682839189736165, -0.36883118795348507, 0.91230383136371929, -0.46996446240256329, 0.30219131214854422, -0.19558932994062075, 0.012615763849470061, 1.762420772813289, 1.9045345605049635, -3.7790359077733253, -11.964107143689581, 4.5083476182968525, 61.96781696120042, -254.89688572081204, 140.68826246910922, -45.053807917761794, 314.74785574475101, -8.8001261891015723, -360.31891091191073, -57.025448777424479, 44.579795546563595, -19.359200628613657, 3.6862817789376683, 8.9206630611283089, 0.18896973496668307, -1.0227323524081069, -0.33838743748909134, 0.43833208591156991, 0.0074294169071561673, 0.50446476014305897, 0.1890893708139402, 0.65133332546862077, -0.77483290182744535, -0.30779007494077709, -0.80427129683389309, 0.26011219704759059, 0.23461588343644721, -0.056507066939534729, -0.44513357712322738, 0.64667209976975049, 1.5545017016282721, -1.5250850436867627, -9.5917712473092696, 13.475211488788412, 28.837963587037802, -21.930976284520067, -337.61540934331555, -197.27075321520147, -65.634374404237917, -45.716174186409042, 38.688397244662028, -10.636065931319841, -36.620593610799475, 11.815798616251305, 9.0326984830007095, -3.0325028906240825, -0.075862266735019127, 0.19104942819406223, 0.073726425569811863, 0.18311714867084192, 0.63036999033226249, -0.098626184449280729, 0.095619359707605045, 0.13744024889930673, -0.097089152898782338, -0.81683568275166918, 0.54386217024143169, 0.041501479859297266, 0.43031399471588661, 0.25470104821283102, 0.17326636360277617, 0.46079094226119127, -0.16530865667454481, -0.86391702025516282, -4.9611285532463629, -12.372184270457062, 11.516126179313906, 3.2997425925449804, 2.0570987009733872, 24.878800155519915, 44.041788084316849, 28.446155418037641, -32.190550839656126, -17.692027714058376, 11.789513877445387, 1.9317197634824401, -3.4507560855810171, 0.36626836712779354, 0.48074766055651602, 0.18044316667269442, -0.28240974426973131, -0.16613612027343372, 0.029095718259237995, 0.24450075339721422, -0.091330331747513635, 0.097634295479075664, -0.36806371804963284, 0.16614591312540511, -0.77395352504544712, -0.3264657443238585, 0.015061212014132833, 0.29085100346092985, 0.047770712409502418, 0.14922819541222396, -0.39792121836056477, -0.1921281774085053, 0.83895281997413806, -1.5703737430868945, -8.4367427775736452, 5.6601916863792336, -5.1510032561702124, -22.050605310259861, -1.9854594697574779, -7.5311386138630718, 7.4148341093741337, 8.0952123464619365, -4.3629732153959058, -0.87617222540110651, 1.0539667118389069, -0.69495683349647086, -0.53597221218340763, 0.21612918483653182, 0.16753374785242167, -0.14587335963051168, 0.2984129896925935, 0.75720231383362635, 1.2725586605629424, -0.23788459440434945, -0.43858849762191893, -0.79801858694486538, -0.41846754429723099, -0.46161406526582383, 0.58294801786464678, -0.078939183973068427, 0.31479155143425391, 0.31425797573231379, -0.084400039832661436, -0.69288180199641103, -0.21778449617622889, -0.19533791786522492, -0.22665765093841067, -0.31956792613405932, 6.3352095159571435, 13.304182061875538, 9.0685889178215753, 13.820343051841526, -2.9904131431626517, -6.4644843028741459, 1.4950174056035006, 0.22841081726546483, -1.0443697855595202, -0.36648156701751267, 0.48825453192442753, 0.32511669967392476, -0.74952192547288132, -0.32406742573949188, -0.14589390394899102, 0.81615985313544603, 0.21110858701983537, -0.62135646441400272, -0.27503339195756299, 0.23916839371037824, -1.0440547633891395, -0.40792084439497517, 0.55610134656922072, 0.37457806876122546, 0.17778944632276653, -0.069642667350154328, -0.39526560004564598, 0.69822150614317735, 0.740778974977921, -0.31290252683747921, -2.0096273906801638, -0.75165898775917361, -0.15987777595408992, -2.5516179078608778, -8.9643314564796608, -15.134863386021781, -2.1073345817546003, 0.61887776540407591, -3.0206322635570779, -0.13950893398737912, 0.63280527166495781, -0.16318694006603662, 0.06410706438489891, 0.11411070867346804, -0.2886162817684455, -0.35613651800395313, 0.12924440993745664, 0.38077834891929796, 0.82374133978448782, 0.42592408743381815, -1.4993887570975311, 1.2113263922466315, -0.61651842130949264, -0.92820589700907985, 1.2123284995709924, -0.37394823077908607, -0.062695571319925397, 0.28532586796592635, -0.016166881608109255, -1.1132083022635739, 0.86546596809253507, 2.0760623026361933, 0.51322827606545562, -2.2491343600113889, -2.0374388890600263, 1.1231676638159473, 0.31214242438772172, 2.2815521755579042, -5.3082712246609329, -6.7280927719717081, 0.71404381047788856, 1.0348891792697787, -0.062580928735681385, 0.11553928672311624, 0.19710411955257187, -0.22253376417909151, -0.05143415191355815, -0.61738709055352659, -0.26515618204121805, 1.3879170617746586, 1.9147895569711311, -2.7981144693643607, 1.6351053618238791, 1.2876141106871726, -0.53839815046157202, -0.81616813855627257, -0.55773229035800009, -0.16310476776122179, -1.4828287822897712, 0.19857441865721279, -0.22253902629935005, 0.76149089771667944, 0.38423492006819204, 0.13633825788919049, -0.40617531895308634, -1.9006670978622686, -5.6055295794952666, -3.5201069577585091, -0.70565394755327504, -4.8233879396582013, -3.7118525914264513, 0.87639764763224848, -3.9705679716456896, -0.3066516936670704, 1.2925955094882555, 0.98057929368147423, -0.5185509231518588, 0.068504647941653091, -0.50802141302695303, -0.65025043431383311, 1.6393007306999561, -0.046634622615140439, -0.42095485749155304, 2.8628962346767608, -0.87664183209871016, -0.061380249620325719, -0.67583720185830587, -2.165804182360429, -2.2334105499018988, -1.7315960703588726, 0.023607096501577673, -0.72578349898044647, 0.49340703388266716, -0.17688316963519096, 0.91231104952944475, 1.0401382704665323, 0.40638239361664558, -3.5528586670065754, -3.2389924588328527, -3.336337544628424, -3.3053285670589143, 0.42529364953930032, 1.2623512061316915, -7.9337267372836493, -1.0910503490681764, 0.30591237262721482, 0.79049013658839029, 0.15779582936744363, 0.35530534658354934, -1.0136463777621887, -0.43596379336607172, 1.3766560550226186, 1.2643786263280588, 0.081112249920068616, 0.30101965208538256, -2.9649644331404845, 3.940601481283172, 1.2809925361642973, -2.3740821954043603, -1.8568139214134618, -2.2875531209700912, -2.0068530505793203, -1.6161905886738603, -0.069970559948539499, -0.68452644609555957, 1.1180256373411306, 1.0386505011587546, -0.45802414484767806, -1.8827293053017495, -1.1452872829873149, -9.8282380345909921, -4.8375314158562777, 0.035534088492687292, 5.8735645683280717, -7.2148282372822923, -1.9024855757814658, -3.6729219824305321, -0.04721742712852893, 0.80045523566507781, 0.91856151213872683, 0.18365173124028911, 1.0527130168554166, 0.35231243394437906, -0.96832866520995176, 0.38866324603453256, 1.1024459216780036, -1.6264163010988006, 5.9086248051519128, 1.1522588148293589, -4.0123769411888297, -1.3409560614230069, -2.2450482885496141, -1.484164394238348, 0.58569229342098317, 0.035646451001070931, -1.3588202093923047, 0.006860270440306241, -0.84539036438792836, 0.31580363771161246, -0.13161779536446233, -0.34549511895795371, -1.1291296924180168, -2.1947930228924113, -14.643424663744323, 0.0, 7.8456512467946364, 11.843681310787776, -4.1545820919682566, 0.098834485797376734, 1.2191537903053737, 0.14782839419733967, -0.21707569483499198, 1.3287726303022269, 0.012891904979339022, 0.146292284007916, 0.70147269041246085, 1.7613861146868823, 0.97884915683286033, 1.5860078469473597, 0.15814907094033309, 0.0, -0.158149070940315, -1.5860078469473551, -0.978849156832858, -1.7613861146868832, -0.70147269041248062, -0.14629228400792066, -0.012891904979343359, -1.3287726303022269, 0.21707569483499028, -0.14782839419734384, -1.2191537903053777, -0.098834485797375804, 4.1545820919682752, -11.843681310787789, -7.8456512467946329, -0.035534088492520481, 14.643424663744339, 2.194793022892366, 1.1291296924180338, 0.34549511895794383, 0.13161779536445045, -0.31580363771161418, 0.84539036438793247, -0.0068602704403050632, 1.3588202093923036, -0.035646451001076773, -0.58569229342099216, 1.484164394238344, 2.2450482885496172, 1.3409560614230207, 4.0123769411888466, -1.1522588148293609, -5.9086248051519057, 1.6264163010987922, -1.102445921678016, -0.38866324603453178, 0.96832866520995076, -0.35231243394438311, -1.0527130168554157, -0.18365173124028866, -0.91856151213871651, -0.80045523566507271, 0.047217427128521561, 3.6729219824305099, 1.9024855757814958, 7.21482823728231, -5.8735645683280371, 3.3053285670587775, 4.8375314158562217, 9.828238034591017, 1.1452872829873084, 1.8827293053017478, 0.45802414484767828, -1.0386505011587623, -1.1180256373411397, 0.68452644609555668, 0.069970559948536071, 1.6161905886738546, 2.0068530505793158, 2.2875531209700912, 1.856813921413464, 2.3740821954043709, -1.2809925361643011, -3.9406014812831787, 2.9649644331405014, -0.30101965208537818, -0.081112249920068671, -1.2643786263280541, -1.3766560550226248, 0.43596379336607571, 1.0136463777621971, -0.35530534658355051, -0.15779582936744335, -0.79049013658838307, -0.30591237262721799, 1.0910503490681696, 7.9337267372836298, -1.2623512061316555, -0.42529364953934357, 0.70565394755329391, 3.336337544628484, 3.2389924588327594, 3.5528586670065589, -0.40638239361663953, -1.0401382704665338, -0.91231104952944642, 0.17688316963519082, -0.49340703388266682, 0.72578349898044092, -0.023607096501574151, 1.7315960703588795, 2.2334105499019046, 2.1658041823604322, 0.67583720185832141, 0.061380249620329064, 0.87664183209870872, -2.8628962346767408, 0.4209548574915572, 0.046634622615141327, -1.6393007306999556, 0.65025043431383445, 0.50802141302695369, -0.068504647941647845, 0.51855092315186113, -0.98057929368147057, -1.2925955094882546, 0.30665169366707518, 3.9705679716456634, -0.8763976476322699, 3.7118525914263776, 4.8233879396582111, -0.31214242438772705, 3.5201069577584692, 5.6055295794952924, 1.9006670978622411, 0.40617531895307485, -0.13633825788919066, -0.38423492006819598, -0.76149089771668665, 0.22253902629934941, -0.1985744186572119, 1.4828287822897714, 0.16310476776122626, 0.55773229035800354, 0.8161681385562749, 0.5383981504615758, -1.2876141106871739, -1.6351053618238793, 2.7981144693643794, -1.9147895569711246, -1.3879170617746619, 0.26515618204121727, 0.61738709055352903, 0.051434151913562459, 0.22253376417909698, -0.19710411955257243, -0.11553928672311804, 0.062580928735678887, -1.0348891792697743, -0.71404381047787879, 6.7280927719716743, 5.3082712246609018, -2.2815521755579335, 8.9643314564797052, -1.1231676638158536, 2.0374388890599802, 2.2491343600114058, -0.51322827606545429, -2.0760623026361911, -0.86546596809253695, 1.1132083022635748, 0.016166881608109234, -0.28532586796592802, 0.062695571319927382, 0.37394823077908801, -1.2123284995709924, 0.92820589700907918, 0.61651842130949663, -1.2113263922466326, 1.4993887570975342, -0.42592408743381316, -0.82374133978448039, -0.38077834891929335, -0.12924440993745251, 0.35613651800395341, 0.28861628176844567, -0.11411070867346547, -0.064107064384899673, 0.16318694006603501, -0.63280527166495915, 0.13950893398738348, 3.0206322635570557, -0.61887776540410167, 2.1073345817545266, 15.134863386021769, -9.0685889178216552, 2.5516179078607184, 0.15987777595415892, 0.75165898775916729, 2.0096273906801727, 0.31290252683747422, -0.74077897497792289, -0.69822150614317713, 0.39526560004564548, 0.069642667350159129, -0.1777894463227658, -0.37457806876122451, -0.55610134656922283, 0.40792084439497267, 1.0440547633891391, -0.23916839371037832, 0.2750333919575636, 0.62135646441400449, -0.21110858701983135, -0.81615985313544015, 0.14589390394899499, 0.32406742573949032, 0.74952192547288177, -0.32511669967392071, -0.48825453192442569, 0.36648156701751228, 1.0443697855595189, -0.22841081726546683, -1.4950174056034862, 6.4644843028741308, 2.9904131431626397, -13.820343051841599, 1.9854594697574315, -13.304182061875386, -6.3352095159572039, 0.3195679261341049, 0.22665765093840967, 0.19533791786523994, 0.21778449617622839, 0.69288180199640803, 0.084400039832664031, -0.31425797573231284, -0.31479155143425158, 0.078939183973069621, -0.58294801786464789, 0.46161406526582016, 0.41846754429722727, 0.79801858694486438, 0.43858849762191948, 0.23788459440435036, -1.2725586605629382, -0.75720231383362191, -0.29841298969258917, 0.14587335963051393, -0.16753374785242225, -0.21612918483653495, 0.53597221218340851, 0.69495683349647419, -1.0539667118389073, 0.87617222540110107, 4.3629732153958827, -8.0952123464619206, -7.414834109374171, 7.5311386138631651, -44.041788084316849, 22.050605310259897, 5.1510032561702142, -5.6601916863792514, 8.4367427775736488, 1.5703737430868991, -0.83895281997413862, 0.19212817740850727, 0.39792121836056477, -0.14922819541222082, -0.047770712409500753, -0.2908510034609289, -0.015061212014133111, 0.32646574432385927, 0.77395352504545112, -0.16614591312540627, 0.36806371804963284, -0.097634295479077288, 0.091330331747514912, -0.24450075339721231, -0.029095718259234932, 0.16613612027343472, 0.28240974426972948, -0.18044316667269469, -0.48074766055651602, -0.36626836712779753, 3.4507560855810189, -1.9317197634824488, -11.789513877445398, 17.692027714058376, 32.190550839656112, -28.446155418037584, 65.634374404237818, -24.878800155519698, -2.0570987009734387, -3.2997425925449106, -11.516126179313863, 12.372184270457085, 4.9611285532463585, 0.86391702025516592, 0.16530865667454706, -0.46079094226119116, -0.1732663636027687, -0.25470104821282824, -0.43031399471588622, -0.041501479859297648, -0.54386217024143224, 0.81683568275167029, 0.097089152898783726, -0.13744024889929929, -0.095619359707603865, 0.098626184449285684, -0.63036999033225893, -0.18311714867083492, -0.07372642556981146, -0.19104942819406445, 0.075862266735016198, 3.0325028906240856, -9.0326984830007238, -11.815798616251362, 36.620593610799446, 10.636065931319884, -38.68839724466217, 45.716174186409333, -314.74785574475044, 197.27075321520152, 337.61540934331566, 21.930976284520245, -28.837963587037731, -13.475211488788421, 9.5917712473092944, 1.5250850436867665, -1.5545017016282761, -0.64667209976974838, 0.44513357712322837, 0.056507066939540815, -0.23461588343644407, -0.26011219704759359, 0.8042712968338912, 0.30779007494077798, 0.77483290182744469, -0.65133332546861145, -0.18908937081392915, -0.50446476014305819, -0.0074294169071514489, -0.43833208591156614, 0.3383874374890965, 1.0227323524080993, -0.18896973496668346, -8.9206630611282982, -3.6862817789376785, 19.35920062861366, -44.579795546563581, 57.025448777424586, 360.31891091191056, 8.8001261891013822, 1526.2181503116453, 45.053807917762221, -140.68826246910882, 254.89688572081207, -61.967816961200398, -4.5083476182968329, 11.964107143689583, 3.7790359077733431, -1.9045345605049631, -1.7624207728132955, -0.01261576384946491, 0.19558932994062728, -0.30219131214854072, 0.4699644624025669, -0.91230383136372128, 0.36883118795348824, -0.13682839189736087, 0.66713893962058779, -0.25989055470659439, -0.44968314290067052, -1.2882353738829488, -0.76755040332110314, 0.21593130161202181, 1.7124190510555817, 0.6346191100738432, -2.3593378023079388, -10.295701682078779, -39.603849315110132, 54.052681314235315, 182.3786468306393, -282.18880697804133, 735.50774046161428, -423.76919790180091, 46.72930747865378, 744.09540667092074, 65.421023262373566, -26.998515460375824, -110.68919188818332, 1.7026644231740455, 8.6847068298461902, -3.6812627646537122, -1.4462870038602713, 0.66403014974352648, 0.98268640942926089, -0.10353485266764806, -1.1704253870693322, 0.47609558693405896, -0.63809937787576798, 1.9145243520823476, 0.11088180406502474, 0.082864627703299776, -0.36254455317814699, -0.74689297610786809, -0.69551673309504447, -0.24508893173895085, 4.773352510756971, -0.034376983736587929, -18.791248861451901, 0.26732768536914786, 52.084914641107339, -48.782690015656009, -267.77827954485792, 730.15551768721207, 777.49072200787191, 9988.2725309741272, 2608.4519239039569, -953.38531885843202, 570.34935164465708, -262.60583525697274, -86.61832325668658, -42.569555354666946, 2.6532766677526505, 7.1796038797667014, -2.7868839636562561, -0.37842412015855753, 2.0950938638350354, 0.042260514128576405, -0.56850457149086808, -0.90990468751900622, 0.4779279337996068, -1.7872556824974217, 2.239357916267509, 1.748611490859272, 1.4553261209412682, -0.72663987403827102, -2.6646257572640879, 0.50817475490745234, 1.8456273678139588, -1.3367261976572486, 1.0587560944122603, 22.259718007212488, -10.499004391497355, -376.50689706328382, 153.72085790515695, 213.86760970710961, 5000.8757444384837, 12998.804313286144, 3077.5993672243935, -814.38538391702389, -589.84188198577237, 52.443377241039045, -203.58844824671809, -68.764375920932238, 24.893726268864992, 6.7517210150420599, -0.13350548988021724, -0.12421201224142447, -0.33273215463053935, -0.74767454410310241, -2.6325944160953538, 0.19923279402974362, -1.8330278968089646, 1.4063404110660558, 0.33462283171345686, 1.8114765667849764, -0.030361957750053889, -0.81638586337482577, 0.82869028871127859, -0.22176027695649836, 1.260192177948489, -13.167070698799225, -23.742310304940538, 82.499903393484416, 67.213502175129648, -232.07891937634469, -387.93265499317204, 1281.4742181751474, 7140.8743305075477, 19170.83401144094, 6565.2013915603166, -266.59769699529113, 524.55810593663034, -105.08267177765569, 68.939947660481323, -65.513717323045299, -7.7366224074036598, 11.686157623491809, -6.0715674792925807, -4.7051607105170206, 2.1433748844125784, -2.5722659267438033, -2.5332827335358727, -1.5955119590990279, 0.93402216187716958, -2.1983982122300714, -1.3910769799127845, 2.875563242016451, 0.39274625271232855, -1.9143589532041787, -1.9356332468609148, 4.6285618656089529, 1.3770831994437265, -19.219741943874194, 21.574731283989856, 129.03232713044289, 65.73387671644744, 79.985389317629867, 2188.2624437143977, 1562.286524069611, 3837.2504381898625]}};

var face_filter = {"real": [2.5919359538538909, 1.3480085770312511, -0.20482945082417442, 2.2477358192448036, 0.93540843887482139, 0.74314370383748074, 0.44299233336869565, 0.53646864525435445, -0.033677232548862526, -0.1522853308878499, -0.0031113453238400149, 0.052610669730581504, -0.0090421776029276455, 0.14571584983663624, 0.44057103654181279, -0.48335213540388067, -1.3567864542305328, -0.48335213540388222, 0.44057103654181745, 0.14571584983663588, -0.0090421776029276386, 0.052610669730583912, -0.0031113453238437146, -0.1522853308878454, -0.033677232548862526, 0.536468645254354, 0.44299233336869559, 0.74314370383748229, 0.9354084388748215, 2.2477358192448023, -0.20482945082417423, 1.3480085770312495, 2.0152106388329991, 0.85611134878653461, -1.3363494489312076, -0.52148568567931619, 1.2207493971968164, 0.88880185549210589, -0.12851357573552111, -0.1350280522901679, 0.041300904967699482, 0.44502243372725686, 0.029355734210915238, -0.51443976319946505, 0.08745222381708008, 1.2148708003194451, 1.1189080727093581, -0.27220544444671846, -0.36088426941083585, -0.093485947527556318, -0.9769818787641994, -0.68349100625395898, 0.024322257871818426, 0.60512811669399713, 0.15343788102432432, -0.4299366545774243, -0.15452787333937706, 0.9156200895039931, 1.19600272916941, 0.72364825206645089, 0.54200011692086325, 2.3400266438502029, -0.033608374945748302, 0.58898161413145322, 2.0269883277253808, 2.818789893714468, -3.5895244227646144, -3.5314332372596891, 2.0122812700890154, 0.93093181995227969, -0.96305400340897007, -0.73612667628472817, -0.053915776695886194, 0.42730242898842419, 0.029936824487282035, -0.35168293029190251, 0.25108420491884947, 0.8544524900293714, 0.16931894270710782, 0.0092385746333500125, 0.68672569869418298, 0.41915906104063394, -1.0984488703050921, -0.63697851900908631, 0.11186355371520935, 0.47269360156783113, 0.15279475225563477, -0.026106440237006989, -0.032262751173084157, 0.14542662300780329, 0.71981331903700141, 1.4137393979172745, 0.60857711312874896, -3.0736342072317173, -2.5537641666010327, 0.6337650914909162, 1.2343577579270657, 0.25345561236901865, -2.0331393954447585, 1.159193858429254, 3.0170447718709359, 0.49021233060315667, -0.684375328954414, -0.32927583863381799, -0.09284792777273311, -0.14740895498043241, -0.19413825853994604, 0.36919608239644319, 0.30546257655082493, -0.55256449500031701, -1.2130125640575424, 0.066961883917897494, -0.13876096422777703, 0.37902224678367341, 0.22718444978554084, 0.19963817528635963, 0.027529920247751867, -0.24231535965414738, -0.016338923407765684, 0.45136614923078927, 0.28975660783972312, -0.73094055491799104, -1.5465072446477164, -0.070769892332079726, 3.1701479989789885, 0.024916786279245037, -2.8717730703729369, -1.1681626968077414, -0.94600410103718435, -0.85872517244177848, 2.9516513032863374, 2.8131952593882126, -1.5261742763882251, -1.0558844683361728, 1.1680212024537544, 0.98450685108739822, 0.064067265719269059, -0.43727283330478184, -0.044395094277671916, 0.6179734700494115, 0.24878996343187737, -0.63891278340523816, -0.75864993025841965, -0.32304619466454659, -0.73387564471571265, -0.043145833390571785, 0.92391812888689884, 0.89946098537045804, 0.14871674926559622, -0.54822828954183223, -0.26728613142127311, 0.309011363128886, 0.21418689978013769, -0.52105157113820344, -1.0686411834884146, -1.3047927124000203, 1.0355627592914096, 2.9672746843849169, 1.9471218128812939, 0.36030875558033187, 0.22471825920653532, 1.3679256644146878, 2.3784795387427549, 0.73776440177250424, -2.2202952003703751, -0.98667153092188797, 0.60944427589951666, 0.29273424438530327, -0.054064553213066489, -0.1955430963609566, 0.13452976853580562, 0.17688857701463095, -0.02907863269662225, -0.037177619339377604, 0.22892611971691484, -0.22870850340942314, -0.41029268509332983, 0.061215349005760457, 0.37818604838169356, 0.34148146887082653, 0.099938245586444027, -0.099254338381423959, -0.11254516916626593, -0.2039622085642743, -0.20060216516957027, 0.30792957356810446, 1.1721236672075155, 0.56136417541067873, -2.3249600877666992, -2.4287881268668112, 2.0674326900187423, 2.8441511789848586, 0.050947133476877834, 0.30280142076825006, 0.23441985585068989, -0.69420211937437837, 0.50017210833819825, 0.9824320425486297, -0.30253127598451673, -0.35217802522066471, -0.25522460504160704, 0.12672156371020879, 0.11584743671788442, -0.27806946703293017, -0.28220471587289919, 0.2622813962834421, 0.46145186677272942, 0.088913779923943934, 0.31552668240292342, 0.083701767363049212, -0.20838882493274438, -0.45028623286649139, -0.21994207603667223, 0.24344265380915428, 0.14566519323380012, -0.26341476824800764, -0.25014860441221609, 0.23269603050324755, 0.65507472733677707, 0.58916939473049168, -1.2014518968451928, -1.4706959472537811, 0.73270160247544736, 1.4639339636380404, 0.46180491918070748, 0.46274052021248863, -1.2522772114725254, -1.0527125117724863, 1.1798416267497167, 0.8831199054956721, 0.0044403719443055645, -0.32008851183583215, -0.088039126814047713, 0.13435677108789251, -0.043849665988197006, -0.30055389900341628, -0.17300527880436442, 0.22268011829576431, 0.14506301721613848, 0.13541851865273877, 0.31252919184011202, 0.13643782704324722, -0.2095508102885523, -0.37861030355575276, -0.25285479563588548, 0.076566684841017141, 0.11737705239518459, 0.013018358464219467, -0.041516874353177323, 0.025396859515453351, -0.19237103418038187, -0.20754469441764836, 0.83543584581843078, 0.96010698083026003, -1.0523257697001149, -1.33376499327856, 0.31064795509136994, 0.20053594173979683, -0.099592610690013544, 0.046946926411794127, -0.26933425983580023, -0.25886956646489134, 0.16667582025681255, 0.16264384177267197, 0.10611595375861864, -0.0098404462838746383, -0.13572606372513804, -0.02258793083641232, 0.1626410940258704, 0.0084042334154625226, -0.31667685877385637, 0.013183667319477316, 0.0095114839461814711, 0.064735813239969756, 0.10654247281867815, 0.21331216355051069, 0.10213744987583113, -0.12973084349572184, -0.098085407735951202, 0.071599991117337544, 0.096012887125637492, -0.070622290324985737, -0.21061961456993025, 0.12811225495378645, 0.61116435171305805, 0.27931012230932523, -0.57076807310688515, -0.50218388849258644, -0.42922119360119421, -0.44865243467955651, 0.48865422280767501, 0.5325596193896186, -0.37999327914266867, -0.37733114800401457, 0.013506411710477314, 0.170066818452864, 0.060998910324659567, -0.13656793547637669, -0.090686593939375684, 0.3743991900961478, 0.47466547775213164, -0.40581229446604228, -0.4933460399621819, -0.38074360867450391, -0.49035943457716413, -0.12412531843683997, 0.30440943973074641, 0.59456571635307864, 0.39877140482842571, -0.17295292843566973, -0.26272159996092964, -0.046183226771098686, 0.047879446168886036, -0.01767919625538646, 0.11122639164092249, 0.28368537020126805, -0.25549013964140954, -0.47047462219224784, 0.42895932921703384, 0.49142711950580215, -0.37646529147307217, -0.2985208724149509, -0.14163512022800509, 0.036248242700393868, 0.16977635036237812, 0.13499908156480836, -0.01898512351822966, -0.069319801425736585, -0.048065151476023839, -0.091445654237596943, 0.063480780271467835, 0.36025783734460454, 0.079528415094702418, -0.1753773206782209, 0.12374069460012149, -0.28367021291499456, -0.3947284775676721, -0.2665809890749859, 0.18834221718468977, 0.27819651942933282, 0.17697914055115227, -0.044718494415980817, -0.10522429653700929, -0.056918990576836789, -0.038574904247242463, 0.0044720036764788907, 0.075029157257001891, -0.012042674487198736, -0.25791041993690383, 0.0094461444749257637, 0.45149640843334832, 0.15522942660639183, 0.16359187166611067, 0.27184060163390095, -0.26140872283435745, -0.36468827084356714, 0.092564696434539948, 0.17076044356298117, -0.081952166134050972, -0.094812402895013512, 0.056872171173511843, 0.14314060902527834, 0.090057378296037091, -0.49752310636724911, -0.90399504476626857, 0.68385321448233993, 1.5206479363861476, 0.97194500124059446, 0.37223376526843088, 0.050885418177567802, -0.35886815857743665, -0.85430361824055856, -0.54314517421482678, 0.35505625397063872, 0.41635160123016829, 0.1097676276443619, 0.0031094617237012487, 0.012467253683817481, -0.13435478466038733, -0.3025207327612856, 0.064227680246281948, 0.26667168729095614, -0.26695175931487575, -0.39070435016787081, 0.46272484969502237, 0.4478152924484996, -0.02777275619946918, -0.36406380803433314, -0.36482553236919035, -0.17145017383338396, -0.0022768560529046471, 0.19648856692552516, 0.19795501524240586, 0.11579620326491886, -0.20236218758832794, -1.3218815146594056, -0.89510126706911786, 0.91685720076146016, 1.0573193754484274, 1.0300227650328617, 1.2681463254528202, 0.54199794330131901, -0.81825453423342154, -1.1158895792994059, -0.48892024147971419, 0.37011029837274972, 0.52557441450178022, 0.12007696462970571, 0.0053871855361874443, 0.0980933520274576, 0.045813676675892742, -0.13973686519943007, -0.1315893019053164, -0.41025099029328865, -0.78307378558342511, -0.43058051319449592, -0.14586342722110873, -0.20332028656079115, -0.50991116383855117, -0.22496834802938576, -0.23147407593468516, -0.0020062182884880236, 0.35659057442027225, 0.21055136817067865, -0.090708657953189512, -0.093236555831976653, -0.39644071531856356, -0.15760046489763799, 0.85217092970404984, -0.006060772398080865, -1.1445855838899712, -0.40779542231222293, 0.57192337467361454, 0.38110042075214373, 0.18372151232217485, 0.45534551448489441, 0.44338161640444884, -0.33392303093222925, -0.30033251173404302, -0.018826279470074956, -0.0031918185582147274, 0.016996498806762936, 0.19478439409652604, 0.14839426734987179, -0.16993496725014728, -0.25233000300477815, -0.17163872305028913, -0.16896259214086029, -0.35048355912402168, -0.56666117156530804, -0.043075182629207294, 0.46189562289598257, 0.12201955959263491, 0.048431387757678836, 0.1008273185138992, -0.19670456422152316, -0.16642026644756419, -0.15046897531292064, 0.1609200706656915, 1.4039223524989202, 1.7178875241186931, -0.079850193819757748, -1.5066376684783904, -1.9250211671886128, -1.0545407692185655, -0.51176749353660089, 1.7285428258292277, 1.5863083779089326, 0.24208315366337785, -0.88837860391849655, -0.80449782923567614, -0.063049218988350142, 0.18072374426616816, 0.041279056588780935, -0.12639978427416398, -0.058413638180600282, 0.18149778190196758, 0.37146508613201623, 0.60005197547104183, 0.38887239681739694, 0.1152103935846736, -0.080081540793911096, 0.79737548580628892, 0.60164673103725985, 0.13967291436025694, -0.17870113794821088, -0.40389823435739103, -0.33510874790612805, -0.062682749064233156, 0.042125181720095217, 0.22750178782369759, 1.0883583281620091, 0.67976518601386504, -0.6792087414350455, -0.67769831799676505, 0.0071297652693774914, -0.21574274789108602, 0.73346137493748143, 0.69884011316820749, 0.12589091429626179, -0.68348492100050939, -0.41285410288550739, -0.18770950063360772, -0.15148842977747803, 0.047869931187020834, 0.21018250411743153, 0.068763639373895541, 0.0098401964213560011, -0.019137710950301583, -0.44014279794733802, -0.21656678437317001, 0.36831896296176964, 0.31965489003799819, 0.24180664285441536, -0.20287221126440233, -0.56181438279878848, -0.15470815549218525, 0.11910006502983214, -0.0029256323011974715, -0.04650506403640628, -0.11603914651892111, -0.15307567360464111, 0.4224212238432043, 0.15967260300989697, -0.83895691770827985, -1.4824802915019837, -0.37969523238638658, 0.89583132075795047, 1.77383273304373, 0.8958313207579488, -0.37969523238638764, -1.4824802915019843, -0.8389569177082784, 0.15967260300989483, 0.42242122384320435, -0.15307567360464003, -0.11603914651892111, -0.046505064036406023, -0.0029256323011973848, 0.11910006502983216, -0.15470815549218528, -0.56181438279878715, -0.20287221126440275, 0.24180664285441561, 0.11521039358467118, 0.36831896296176875, -0.2165667843731702, -0.44014279794733774, -0.019137710950301947, 0.0098401964213558832, 0.068763639373895805, 0.21018250411743131, 0.047869931187020681, -0.15148842977747892, -0.18770950063360678, -0.4128541028855055, -0.68348492100050762, 0.12589091429626098, 0.69884011316820926, 0.73346137493748531, -0.21574274789108297, 0.0071297652693808498, -0.67769831799676439, -0.67920874143504806, 0.6797651860138616, 1.0883583281620088, 0.22750178782369845, 0.042125181720095072, -0.06268274906423292, -0.33510874790612777, -0.40389823435739058, -0.17870113794821069, 0.13967291436025678, 0.6016467310372583, 0.79737548580629014, -0.080081540793910805, -0.35048355912402274, 0.38887239681739855, 0.60005197547104216, 0.37146508613201551, 0.18149778190196694, -0.058413638180600004, -0.12639978427416418, 0.041279056588780526, 0.1807237442661683, -0.063049218988349559, -0.80449782923567681, -0.88837860391849677, 0.24208315366337824, 1.5863083779089293, 1.7285428258292255, -0.51176749353659912, -1.0545407692185644, -1.9250211671886148, -1.506637668478394, -0.079850193819762688, 1.7178875241186904, 1.4039223524989211, 0.160920070665691, -0.15046897531292144, -0.16642026644756441, -0.19670456422152255, 0.10082731851389957, 0.048431387757679002, 0.122019559592635, 0.46189562289598279, -0.043075182629206808, -0.56666117156530804, -0.1458634272211089, -0.16896259214085926, -0.17163872305028846, -0.25233000300477826, -0.16993496725014781, 0.14839426734987166, 0.19478439409652576, 0.016996498806763023, -0.0031918185582146671, -0.01882627947007429, -0.30033251173404329, -0.3339230309322298, 0.44338161640444979, 0.45534551448489619, 0.18372151232217931, 0.38110042075214462, 0.57192337467361187, -0.40779542231222243, -1.1445855838899728, -0.0060607723980816422, 0.85217092970405028, -0.15760046489763638, -0.39644071531856373, -0.093236555831976972, -0.090708657953189803, 0.21055136817067863, 0.35659057442027281, -0.0020062182884879754, -0.23147407593468516, -0.22496834802938495, -0.50991116383855117, -0.20332028656079207, 0.46272484969502153, -0.43058051319449625, -0.78307378558342611, -0.41025099029328771, -0.13158930190531651, -0.13973686519943013, 0.04581367667589293, 0.098093352027458003, 0.0053871855361874036, 0.12007696462970524, 0.52557441450178122, 0.37011029837274845, -0.48892024147971336, -1.1158895792994052, -0.81825453423342154, 0.54199794330131867, 1.2681463254528189, 1.0300227650328604, 1.0573193754484311, 0.91685720076146382, -0.89510126706911664, -1.3218815146594056, -0.20236218758832747, 0.11579620326491913, 0.19795501524240555, 0.19648856692552533, -0.002276856052904625, -0.17145017383338415, -0.36482553236918996, -0.36406380803433286, -0.027772756199469509, 0.44781529244849971, 0.1635918716661118, -0.39070435016787175, -0.26695175931487636, 0.26667168729095614, 0.064227680246282309, -0.30252073276128633, -0.13435478466038722, 0.012467253683817804, 0.0031094617237012916, 0.10976762764436168, 0.41635160123016834, 0.35505625397063934, -0.54314517421482655, -0.85430361824056045, -0.35886815857743842, 0.050885418177567691, 0.3722337652684316, 0.97194500124059191, 1.5206479363861465, 0.68385321448234182, -0.90399504476626835, -0.49752310636725033, 0.09005737829603698, 0.14314060902527884, 0.056872171173512003, -0.094812402895013193, -0.081952166134050861, 0.17076044356298159, 0.092564696434540239, -0.36468827084356803, -0.26140872283435806, 0.27184060163390172, -0.37646529147307173, 0.15522942660639114, 0.45149640843334826, 0.009446144474926697, -0.25791041993690383, -0.012042674487198701, 0.07502915725700196, 0.0044720036764790416, -0.038574904247242366, -0.056918990576836755, -0.10522429653700935, -0.044718494415980962, 0.17697914055115149, 0.2781965194293311, 0.18834221718468852, -0.2665809890749849, -0.39472847756767171, -0.28367021291499434, 0.12374069460012085, -0.17537732067822176, 0.079528415094701682, 0.3602578373446047, 0.063480780271467876, -0.091445654237597165, -0.048065151476023728, -0.06931980142573653, -0.018985123518229702, 0.13499908156480855, 0.16977635036237826, 0.036248242700393465, -0.14163512022800506, -0.29852087241494996, -0.42922119360119487, 0.49142711950580192, 0.428959329217034, -0.47047462219224911, -0.25549013964141071, 0.28368537020126877, 0.111226391640923, -0.017679196255386387, 0.047879446168886071, -0.046183226771098616, -0.26272159996092947, -0.17295292843566987, 0.39877140482842616, 0.59456571635307809, 0.30440943973074525, -0.12412531843683972, -0.49035943457716313, -0.3807436086745018, -0.49334603996218179, -0.40581229446604117, 0.47466547775213147, 0.37439919009614836, -0.090686593939375629, -0.13656793547637694, 0.060998910324659573, 0.17006681845286384, 0.013506411710477128, -0.37733114800401446, -0.37999327914266845, 0.53255961938961804, 0.4886542228076744, -0.44865243467955757, 0.31064795509136994, -0.50218388849258644, -0.57076807310688515, 0.27931012230932423, 0.61116435171305772, 0.12811225495378684, -0.21061961456993031, -0.07062229032498564, 0.096012887125637492, 0.0715999911173376, -0.098085407735951036, -0.12973084349572186, 0.10213744987583084, 0.21331216355051105, 0.10654247281867847, 0.064735813239968978, 0.0095114839461814711, 0.013183667319477904, -0.31667685877385532, 0.0084042334154626214, 0.1626410940258709, -0.022587930836412171, -0.13572606372513854, -0.0098404462838748534, 0.10611595375861864, 0.16264384177267199, 0.16667582025681238, -0.2588695664648914, -0.26933425983580034, 0.046946926411794203, -0.099592610690013642, 0.20053594173979666, 0.46180491918070782, -1.3337649932785616, -1.0523257697001149, 0.96010698083025947, 0.835435845818432, -0.20754469441764875, -0.19237103418038279, 0.025396859515452976, -0.041516874353177122, 0.013018358464219362, 0.11737705239518428, 0.076566684841017002, -0.25285479563588431, -0.37861030355575326, -0.2095508102885513, 0.13643782704324786, 0.31252919184011235, 0.1354185186527376, 0.14506301721613746, 0.22268011829576351, -0.17300527880436414, -0.30055389900341645, -0.043849665988197138, 0.13435677108789171, -0.088039126814047811, -0.32008851183583126, 0.0044403719443063165, 0.8831199054956711, 1.179841626749716, -1.0527125117724856, -1.2522772114725254, 0.46274052021248885, 0.050947133476877821, 1.4639339636380404, 0.73270160247544602, -1.4706959472537806, -1.2014518968451935, 0.58916939473049124, 0.65507472733677696, 0.23269603050324741, -0.25014860441221576, -0.26341476824800797, 0.14566519323380028, 0.24344265380915459, -0.2199420760366726, -0.45028623286649283, -0.20838882493274519, 0.083701767363050281, 0.31552668240292281, 0.088913779923944877, 0.46145186677272854, 0.2622813962834421, -0.28220471587289875, -0.27806946703292978, 0.11584743671788453, 0.12672156371020837, -0.25522460504160699, -0.35217802522066505, -0.30253127598451701, 0.98243204254862915, 0.50017210833819781, -0.69420211937437803, 0.23441985585068889, 0.30280142076825051, 0.2247182592065364, 2.8441511789848586, 2.0674326900187419, -2.4287881268668121, -2.3249600877666978, 0.56136417541067796, 1.1721236672075159, 0.30792957356810535, -0.20060216516957047, -0.2039622085642748, -0.11254516916626582, -0.099254338381423668, 0.0999382455864435, 0.34148146887082625, 0.37818604838169406, 0.061215349005760457, -0.41029268509332922, -0.22870850340942214, 0.22892611971691548, -0.037177619339376564, -0.029078632696622427, 0.17688857701463057, 0.13452976853580567, -0.19554309636095565, -0.054064553213066628, 0.29273424438530188, 0.609444275899516, -0.98667153092188464, -2.2202952003703764, 0.73776440177250102, 2.3784795387427535, 1.367925664414688, -0.94600410103718391, 0.3603087555803301, 1.9471218128812944, 2.9672746843849187, 1.0355627592914098, -1.3047927124000192, -1.068641183488414, -0.52105157113820511, 0.21418689978013775, 0.30901136312888583, -0.26728613142127272, -0.54822828954183234, 0.1487167492655953, 0.89946098537045849, 0.92391812888689973, -0.043145833390572444, -0.73387564471571165, -0.32304619466454804, -0.75864993025841865, -0.63891278340523694, 0.24878996343187765, 0.61797347004941017, -0.044395094277671403, -0.43727283330478151, 0.064067265719269045, 0.98450685108739822, 1.1680212024537535, -1.0558844683361719, -1.5261742763882244, 2.813195259388213, 2.9516513032863356, -0.85872517244177815, 1.2343577579270646, -1.1681626968077381, -2.8717730703729356, 0.024916786279243767, 3.1701479989789867, -0.070769892332079906, -1.5465072446477184, -0.73094055491799181, 0.28975660783972312, 0.45136614923079016, -0.016338923407765823, -0.24231535965414835, 0.027529920247752079, 0.19963817528636058, 0.22718444978554045, 0.37902224678366964, -0.13876096422777742, 0.066961883917898354, -1.213012564057544, -0.55256449500031835, 0.30546257655082465, 0.36919608239644353, -0.1941382585399454, -0.14740895498043313, -0.092847927772733041, -0.32927583863381676, -0.68437532895441289, 0.49021233060315311, 3.0170447718709372, 1.1591938584292596, -2.0331393954447532, 0.25345561236901532, 2.0269883277253808, 0.6337650914909212, -2.5537641666010331, -3.0736342072317178, 0.60857711312874962, 1.4137393979172737, 0.71981331903700019, 0.14542662300780379, -0.032262751173084109, -0.026106440237006333, 0.15279475225563396, 0.47269360156783119, 0.11186355371520969, -0.63697851900908553, -1.0984488703050919, 0.41915906104063416, 0.68672569869418265, 0.0092385746333522867, 0.16931894270710687, 0.85445249002936896, 0.25108420491884997, -0.35168293029190173, 0.029936824487282226, 0.42730242898842274, -0.053915776695886201, -0.7361266762847285, -0.96305400340896929, 0.93093181995227892, 2.0122812700890154, -3.5314332372596846, -3.5895244227646144, 2.8187898937144658, 2.0152106388329991, 0.58898161413145356, -0.033608374945749073, 2.3400266438502024, 0.54200011692086181, 0.72364825206645078, 1.1960027291694086, 0.91562008950399532, -0.15452787333937676, -0.42993665457742386, 0.1534378810243246, 0.60512811669399758, 0.024322257871818742, -0.6834910062539612, -0.9769818787642004, -0.093485947527554653, -0.36088426941083557, -0.27220544444672085, 1.1189080727093528, 1.2148708003194422, 0.087452223817081023, -0.51443976319946561, 0.029355734210916126, 0.44502243372725681, 0.041300904967699399, -0.13502805229016995, -0.12851357573552075, 0.88880185549210555, 1.2207493971968146, -0.52148568567931763, -1.3363494489312078, 0.85611134878653028], "bottom": {"real": [10965.975170394304, 21271.915267962257, 3528.2703051611911, 4104.4756805864381, 1601.0616042188819, 1022.7399974894073, 557.80113750762041, 282.82230522781242, 145.15707521660474, 105.9441201571383, 59.012707266667213, 44.669628432443531, 36.50168205465414, 28.529134449096524, 21.777099980382825, 18.33532892478512, 16.253545459923078, 18.335328924785092, 21.777099980382847, 28.529134449096492, 36.50168205465414, 44.669628432443567, 59.012707266667277, 105.94412015713864, 145.15707521660474, 282.82230522781276, 557.80113750762041, 1022.7399974894074, 1601.0616042188824, 4104.4756805864426, 3528.2703051611911, 21271.91526796226, 12599.263825927621, 3215.125406898348, 5397.5422498759845, 1626.8549963375583, 805.20630634633005, 515.14459200644239, 359.3048107396736, 212.4360242127799, 110.43978615629422, 81.30134061470001, 50.82057050163526, 41.192651249931721, 32.936640633650484, 26.681133724080869, 18.01921088871573, 14.766368476202661, 15.422836018027418, 15.990808141800954, 20.022228188848842, 26.276495829612259, 35.717232769261116, 41.847677620126099, 54.320387908275151, 97.518896272497358, 133.8729941689642, 238.43595357759855, 456.937693043428, 711.66550404730731, 1144.8252089743219, 1902.8385884755523, 5206.768847980471, 3622.9684974910811, 13155.61342681755, 3416.7436429144991, 2812.4738667722154, 1400.147559944327, 383.1327908328127, 252.15177845425933, 197.2081578118225, 171.59960210222519, 82.275357677734092, 60.48297276194193, 40.777478884094478, 35.028553697203044, 28.877176436297923, 21.966647147933095, 16.371866219790679, 15.053935075225828, 14.23277610579999, 14.866315284596761, 18.218896084560566, 25.18211951926569, 33.821722307900131, 38.320413578940517, 45.570220260185515, 72.059479710744441, 97.660119608992957, 168.65094690401955, 268.62846926573025, 329.42984018623156, 467.75549674428515, 1002.4311488284067, 3554.1418329345079, 1764.397059903687, 4621.9583294760141, 1569.7087860062477, 1388.3341571422952, 628.37101334838883, 414.07061143445827, 168.53157442290524, 137.2795663029475, 102.11362429348972, 55.491719795512424, 49.073126751989768, 36.063389145893389, 30.634459542886617, 24.216782409074948, 18.667040937787934, 14.56741780053745, 12.905268434713205, 12.868626938575844, 13.095932326486089, 16.679039087380332, 21.80969609662603, 29.753917874884348, 36.827824955920349, 38.934743351431941, 57.668339838268878, 69.641961050084433, 131.28843074347486, 180.68252449032624, 169.44044949721729, 350.74973626382058, 497.02834719870827, 1746.1261590593115, 796.99783843130319, 3103.2479470123581, 1415.2337173839596, 752.81814346176623, 549.34301727365857, 201.53841636766998, 154.61036627522753, 104.58138455482165, 77.618781225118965, 49.392087964292358, 44.90232542624743, 31.105878831006294, 25.236762604525154, 19.175053589853054, 16.38453446468991, 12.823063914611339, 12.047936614807259, 11.554737628486025, 12.534926448772453, 14.323695266188452, 17.780247836887199, 24.191492945877869, 28.843093953252101, 32.767703049824149, 43.78366744373352, 51.550546699271386, 70.699184140809493, 109.08321361427502, 136.28687846912635, 199.77708080210388, 376.32680369835469, 796.83467383546451, 571.91471358300532, 984.41049770348889, 694.18752080971819, 999.69929532757897, 367.74073917398181, 338.97998181689366, 133.72435362068052, 109.5985079627268, 89.938945070024957, 49.039508255638331, 36.109063293014415, 25.98394571698211, 23.015774601871652, 16.882299112940213, 14.591336257090045, 11.32667094148311, 9.91803607895827, 9.6753965965616064, 10.57555888797221, 12.046190961831451, 14.768605661776913, 18.648763248771505, 21.576487249184964, 27.01336113453004, 36.908082411505312, 45.645009020283105, 60.837630874998482, 99.37203234809671, 111.28266970072299, 252.63182137130968, 273.92630278831501, 775.2357561437575, 815.85074837225181, 1655.1106419436521, 1107.4422783913506, 474.0637368651835, 355.64805874163005, 199.11678861892517, 123.46347336694488, 65.896409871808586, 68.918403190937497, 38.943190919202721, 28.774499596319636, 21.286505123099762, 17.663953414249985, 14.114074884510726, 11.879784189493673, 10.039166730615968, 8.3521719629346443, 8.4814596475391344, 9.0449476750100413, 9.8512979659284881, 12.153630271582001, 15.23168574488512, 19.437247877391961, 22.710514050850847, 28.755794586161894, 38.618352638886485, 59.942241598726909, 92.997872357952332, 88.111783673752711, 166.94308947555163, 243.79773811420219, 532.10468308026691, 428.26170612042944, 835.14389492248984, 575.84605817489046, 602.78945521124672, 339.57693755905132, 168.11833297683242, 117.99279203678798, 52.586639793255571, 42.047895128628383, 28.318592567301817, 25.001453363505657, 19.91641866758216, 16.823078359396845, 11.65888462925604, 10.364401595593858, 8.8573627978869887, 7.4173871264629518, 7.2681515499390361, 7.5915323421249861, 8.6807340620832107, 10.378269159275604, 12.701378035616356, 16.292785679101375, 18.804030398726262, 23.560923080173954, 30.503495373532754, 45.810504396910375, 65.229522054396952, 65.639482430818617, 177.29565831054776, 166.70872880265193, 491.9902921130938, 512.67235981711065, 747.45313809997936, 645.96141219737251, 307.54977114778814, 298.36000265745548, 105.95282903225828, 85.567113182097643, 44.672376324283228, 40.226583433899208, 25.615021546435344, 22.144491394300847, 16.131654569456256, 13.397071796412417, 10.408828566613494, 8.9591957313528034, 8.0604380452509936, 7.0442060411780956, 6.2883229388812003, 6.8496831982856676, 7.336687105800447, 8.4717730733339334, 9.9814777112217854, 13.121694879148574, 16.902165529440683, 20.643784740763845, 24.153222030769193, 29.725858725465727, 41.896421037553992, 52.630934346953957, 103.5859123323665, 116.76781276597193, 376.64744495733714, 306.93195832405218, 356.46238810538262, 374.90366628545218, 271.63698834940317, 203.15162979817489, 85.296077399229702, 77.649689466739304, 35.918272816149603, 33.069491090524735, 22.605820220395913, 17.296816509483932, 13.342699317421832, 11.640978884779956, 9.3586975241911539, 8.2623074625085575, 6.6065851632208821, 6.2827863632965242, 6.0744238279118932, 6.3582342010947102, 6.8252966967815532, 7.8556092062941403, 9.3209224203195777, 10.848369664421165, 14.056179340078513, 17.792540785133639, 21.540972163896267, 26.803938103683681, 40.50313838179877, 43.285550133972045, 91.691889335245591, 100.98276829758987, 225.59390630676836, 290.0678303886524, 373.60823131669014, 414.22422969876749, 141.37671573357548, 158.90321565708931, 63.837661879419102, 61.993039771960156, 32.588562049134531, 28.668162298507095, 18.426404144385732, 14.735821975464789, 11.992469004096597, 11.399293029930492, 8.7163999068023248, 7.2289667101344008, 6.5906881398505739, 5.7472695906024613, 5.6472990693532683, 5.8777570769595933, 6.4024098578192543, 7.4405650580225187, 8.4599769870087567, 10.256048021590846, 12.060831155359036, 13.785151925105749, 18.659998164390426, 22.921744826480442, 31.905227459883474, 34.302795951832735, 59.880411689763747, 69.971045180964353, 160.24793865518117, 163.52979203882799, 147.83029120770976, 178.6357867835558, 118.15132417284869, 114.19776495947795, 53.375296048832148, 57.177884093679019, 32.93952944330524, 24.968491799996325, 17.430516204833694, 13.433899198972929, 11.836714579435053, 10.548598460428181, 8.0486546171077791, 7.1187881891372964, 6.4594660557219088, 5.8159952878399759, 5.4767794038379067, 5.3908701504578147, 5.8976209996629629, 7.1301831132348088, 7.5675834428185693, 8.7517061416953652, 11.338462673842365, 13.133124938105077, 16.059093761394507, 18.849097825959038, 29.651622179353478, 34.09934210997649, 58.700399360289651, 65.261681531847529, 99.214909240790846, 146.35353694510258, 121.37679122991287, 165.76624382852509, 77.65397407030467, 91.338453331354174, 44.07807549608674, 44.566220734037245, 27.026614222359569, 22.147051076612073, 15.399396116974053, 12.432895564123392, 10.640074418564296, 9.3276298749700732, 7.5791206500207364, 6.7828789822837923, 6.1816087593787632, 5.6692811710818027, 5.1651813219751155, 5.3317492648801608, 5.5981461093243494, 6.4057146645582934, 7.2505243651475348, 8.4209913018587468, 10.969854167863348, 12.153630713859068, 14.766764339656312, 18.099354774134348, 25.326013884328763, 29.785949829841531, 46.424831391908171, 52.615859887304801, 82.573269999379406, 99.676304070074508, 86.640078828927244, 116.36860702141186, 64.2413414100685, 71.742693053970697, 38.10988368760168, 36.926827145978287, 25.897290737678322, 19.275080383374728, 14.749844663752917, 11.485010388879966, 9.4576647539678333, 8.8927162237613455, 7.4395778659669922, 6.0444335480941538, 5.7182084691628248, 5.0557935120943966, 5.0760457790692417, 5.2089717500439345, 5.7735220000474632, 5.9406732653680434, 6.7459275777069596, 7.820577383583708, 9.9835305123253484, 11.402400865496325, 14.118008059701465, 15.687873342054864, 23.860535436216686, 29.003043185839516, 40.145342185017675, 49.33744888297236, 59.017178205425914, 84.300643063132256, 70.160964533004119, 106.14414492511058, 57.343364605572859, 60.092652172041127, 35.035164226891368, 31.196728233049463, 22.848135981998073, 17.280291997569737, 14.215425049471765, 11.487894696175578, 9.2019617459917757, 8.157670273889595, 7.4731544987863776, 6.0230042880637562, 5.6300019663774918, 5.2449852175850884, 4.8944187843316493, 5.1794885290485126, 5.4428139254674495, 5.9866966335497871, 6.4988534667021369, 7.0161059288776793, 9.1662091602334215, 10.540688253938185, 13.221652899667433, 17.448751090247555, 21.405199921620568, 24.443644233674171, 34.565403798719835, 43.064932290411342, 53.896764023490427, 75.330615249002037, 57.139048850516261, 75.071278816121492, 44.304162032217924, 48.091094532561691, 33.4913106785217, 27.211025020176507, 22.453521092970409, 17.428281520682297, 14.160857290751922, 10.592079486422294, 9.2001673028330426, 7.5661166243087798, 6.5335689847346243, 5.8073593275643729, 5.7880621018967249, 5.3539074945975891, 5.3978132668570558, 5.2447316758230391, 5.4735425621066245, 5.861789820088422, 6.5375806061336013, 7.5634600669075329, 8.8416380446398435, 10.50698673124036, 13.949036764622399, 16.252252028090993, 22.019876112374043, 25.162704768394917, 31.578176229468394, 41.771493186860923, 42.955938687991988, 69.858651906447136, 50.780163528630226, 74.077510216304077, 43.697387961361706, 40.315818737884314, 29.770652812772006, 26.340522851312056, 22.034594395520614, 16.748599325796118, 12.845516284546591, 10.52499564475608, 9.2455018617556028, 7.4871364359448869, 6.8277975203922185, 5.6646016980044793, 5.288115481792067, 5.2498383547683662, 5.1849512003341403, 5.2498383547683662, 5.2881154817920599, 5.6646016980044767, 6.8277975203922212, 7.4871364359448904, 9.2455018617556082, 10.52499564475608, 12.845516284546591, 16.748599325796118, 22.034594395520603, 26.340522851312063, 29.770652812772006, 40.315818737884321, 43.697387961361706, 74.077510216304077, 57.139048850516232, 69.858651906447136, 42.955938687991953, 41.771493186860937, 31.578176229468383, 25.162704768394924, 22.019876112374046, 16.252252028090997, 13.949036764622383, 10.506986731240358, 8.8416380446398382, 7.5634600669075285, 6.5375806061335977, 5.8617898200884238, 5.4735425621066245, 5.2447316758230373, 5.3978132668570558, 5.3539074945975873, 5.7880621018967231, 5.807359327564372, 6.5335689847346252, 7.5661166243087798, 9.2001673028330391, 10.592079486422293, 14.16085729075192, 17.428281520682305, 22.453521092970401, 27.211025020176521, 33.491310678521693, 48.091094532561655, 44.304162032217938, 75.071278816121534, 70.160964533004076, 75.330615249002022, 53.89676402349037, 43.064932290411342, 34.565403798719814, 24.443644233674185, 21.405199921620568, 17.448751090247544, 13.221652899667435, 10.540688253938189, 9.1662091602334179, 7.0161059288776801, 6.4988534667021369, 5.9866966335497871, 5.4428139254674504, 5.17948852904851, 4.8944187843316449, 5.2449852175850866, 5.6300019663774892, 6.0230042880637509, 7.4731544987863758, 8.157670273889595, 9.2019617459917793, 11.487894696175564, 14.215425049471762, 17.280291997569748, 22.84813598199807, 31.19672823304948, 35.035164226891382, 60.092652172041191, 57.343364605572894, 106.14414492511065, 86.640078828927187, 84.30064306313227, 59.017178205425857, 49.337448882972346, 40.145342185017682, 29.003043185839513, 23.860535436216686, 15.687873342054866, 14.118008059701463, 11.402400865496327, 9.9835305123253519, 7.8205773835837116, 6.7459275777069578, 5.9406732653680443, 5.7735220000474641, 5.2089717500439328, 5.0760457790692435, 5.0557935120943975, 5.7182084691628221, 6.0444335480941556, 7.4395778659669922, 8.8927162237613491, 9.4576647539678262, 11.485010388879974, 14.749844663752919, 19.275080383374736, 25.897290737678308, 36.92682714597828, 38.109883687601666, 71.742693053970726, 64.241341410068529, 116.36860702141172, 121.37679122991284, 99.676304070074451, 82.57326999937942, 52.615859887304801, 46.424831391908185, 29.785949829841556, 25.32601388432877, 18.099354774134348, 14.766764339656312, 12.153630713859069, 10.96985416786335, 8.4209913018587539, 7.250524365147534, 6.4057146645582961, 5.5981461093243476, 5.3317492648801599, 5.1651813219751173, 5.6692811710818027, 6.1816087593787605, 6.7828789822837923, 7.5791206500207382, 9.3276298749700803, 10.640074418564305, 12.432895564123386, 15.399396116974053, 22.147051076612065, 27.026614222359573, 44.566220734037259, 44.078075496086726, 91.338453331354202, 77.653974070304727, 165.76624382852506, 147.83029120770976, 146.35353694510263, 99.214909240790945, 65.261681531847557, 58.700399360289673, 34.099342109976497, 29.651622179353467, 18.849097825959049, 16.059093761394511, 13.133124938105075, 11.338462673842358, 8.7517061416953563, 7.5675834428185675, 7.1301831132348097, 5.8976209996629647, 5.3908701504578165, 5.4767794038379076, 5.8159952878399785, 6.4594660557219132, 7.1187881891372955, 8.0486546171077809, 10.548598460428188, 11.836714579435059, 13.433899198972929, 17.430516204833697, 24.968491799996333, 32.93952944330524, 57.177884093679054, 53.375296048832141, 114.19776495947798, 118.15132417284869, 178.63578678355586, 373.60823131669019, 163.52979203882796, 160.24793865518112, 69.971045180964367, 59.880411689763726, 34.302795951832763, 31.905227459883484, 22.921744826480438, 18.659998164390412, 13.785151925105746, 12.060831155359033, 10.256048021590846, 8.4599769870087602, 7.4405650580225213, 6.4024098578192588, 5.8777570769595933, 5.6472990693532674, 5.7472695906024622, 6.5906881398505668, 7.2289667101344008, 8.7163999068023195, 11.399293029930499, 11.992469004096606, 14.735821975464788, 18.426404144385724, 28.66816229850712, 32.588562049134516, 61.993039771960206, 63.837661879419088, 158.90321565708933, 141.37671573357554, 414.22422969876766, 356.46238810538273, 290.06783038865245, 225.59390630676842, 100.98276829758977, 91.691889335245619, 43.285550133972016, 40.503138381798749, 26.803938103683674, 21.540972163896271, 17.792540785133639, 14.056179340078506, 10.84836966442117, 9.3209224203195813, 7.8556092062941412, 6.8252966967815567, 6.3582342010947119, 6.0744238279118923, 6.2827863632965206, 6.606585163220883, 8.2623074625085593, 9.3586975241911592, 11.640978884779955, 13.342699317421838, 17.296816509483932, 22.60582022039592, 33.069491090524764, 35.918272816149603, 77.649689466739304, 85.296077399229731, 203.15162979817504, 271.63698834940351, 374.90366628545223, 747.45313809997936, 306.93195832405206, 376.64744495733714, 116.76781276597193, 103.58591233236646, 52.630934346953964, 41.896421037553985, 29.725858725465734, 24.153222030769193, 20.643784740763849, 16.902165529440701, 13.121694879148574, 9.9814777112217961, 8.4717730733339316, 7.3366871058004506, 6.8496831982856659, 6.2883229388812003, 7.0442060411780965, 8.0604380452509936, 8.9591957313528034, 10.40882856661349, 13.397071796412414, 16.131654569456249, 22.144491394300825, 25.615021546435344, 40.226583433899208, 44.672376324283235, 85.567113182097643, 105.95282903225828, 298.36000265745565, 307.54977114778819, 645.9614121973724, 835.14389492248984, 512.67235981711053, 491.99029211309386, 166.70872880265185, 177.29565831054779, 65.639482430818575, 65.229522054396938, 45.810504396910396, 30.503495373532761, 23.560923080173971, 18.804030398726255, 16.292785679101371, 12.701378035616358, 10.378269159275604, 8.6807340620832214, 7.5915323421249852, 7.2681515499390352, 7.4173871264629581, 8.8573627978869904, 10.364401595593863, 11.65888462925604, 16.823078359396849, 19.91641866758215, 25.001453363505686, 28.31859256730182, 42.047895128628411, 52.5866397932556, 117.99279203678799, 168.11833297683248, 339.57693755905132, 602.78945521124683, 575.84605817489012, 1655.110641943653, 428.26170612042955, 532.10468308026725, 243.7977381142021, 166.94308947555166, 88.111783673752683, 92.997872357952346, 59.942241598726952, 38.618352638886499, 28.755794586161898, 22.71051405085084, 19.437247877391968, 15.231685744885109, 12.153630271581999, 9.8512979659284898, 9.0449476750100377, 8.4814596475391344, 8.3521719629346407, 10.039166730615969, 11.879784189493675, 14.114074884510734, 17.663953414249978, 21.286505123099776, 28.774499596319639, 38.943190919202728, 68.918403190937497, 65.896409871808544, 123.46347336694488, 199.11678861892523, 355.64805874163045, 474.06373686518356, 1107.4422783913496, 984.41049770348843, 815.85074837225181, 775.23575614375761, 273.92630278831501, 252.63182137130985, 111.28266970072293, 99.372032348096738, 60.83763087499851, 45.645009020283112, 36.908082411505283, 27.013361134530022, 21.576487249184932, 18.648763248771502, 14.768605661776908, 12.046190961831442, 10.575558887972219, 9.6753965965616082, 9.9180360789582664, 11.326670941483108, 14.591336257090044, 16.88229911294021, 23.015774601871662, 25.983945716982106, 36.109063293014408, 49.03950825563831, 89.938945070024914, 109.59850796272681, 133.72435362068057, 338.97998181689348, 367.74073917398209, 999.69929532757897, 694.18752080971819, 3103.247947012359, 571.91471358300578, 796.83467383546474, 376.32680369835435, 199.77708080210391, 136.28687846912629, 109.08321361427504, 70.699184140809436, 51.550546699271379, 43.783667443733499, 32.767703049824149, 28.843093953252076, 24.191492945877858, 17.780247836887195, 14.323695266188444, 12.534926448772453, 11.554737628486032, 12.047936614807259, 12.823063914611335, 16.384534464689928, 19.175053589853043, 25.236762604525165, 31.105878831006304, 44.902325426247451, 49.392087964292365, 77.618781225119008, 104.58138455482161, 154.6103662752277, 201.53841636767004, 549.34301727365869, 752.81814346176634, 1415.2337173839583, 4621.9583294760132, 796.99783843130297, 1746.1261590593119, 497.02834719870856, 350.74973626382069, 169.44044949721726, 180.68252449032624, 131.28843074347478, 69.641961050084447, 57.668339838268842, 38.934743351431905, 36.827824955920356, 29.753917874884323, 21.80969609662602, 16.679039087380357, 13.095932326486084, 12.868626938575838, 12.905268434713202, 14.567417800537427, 18.667040937787927, 24.216782409074952, 30.634459542886628, 36.063389145893439, 49.07312675198979, 55.491719795512452, 102.11362429348968, 137.27956630294753, 168.53157442290532, 414.07061143445821, 628.37101334838928, 1388.3341571422957, 1569.7087860062475, 13155.613426817548, 1764.3970599036886, 3554.1418329345083, 1002.4311488284069, 467.75549674428527, 329.4298401862315, 268.62846926573025, 168.65094690401969, 97.660119608993, 72.05947971074437, 45.570220260185501, 38.320413578940503, 33.821722307900103, 25.182119519265683, 18.218896084560566, 14.866315284596766, 14.232776105799996, 15.053935075225828, 16.371866219790657, 21.966647147933109, 28.877176436297923, 35.028553697203037, 40.777478884094542, 60.482972761941951, 82.275357677734107, 171.59960210222522, 197.20815781182262, 252.15177845425956, 383.13279083281282, 1400.1475599443277, 2812.4738667722154, 3416.7436429144982, 12599.263825927617, 3622.9684974910801, 5206.7688479804747, 1902.8385884755519, 1144.8252089743219, 711.66550404730719, 456.93769304342817, 238.43595357759864, 133.8729941689642, 97.518896272497358, 54.320387908275166, 41.847677620126085, 35.71723276926113, 26.276495829612255, 20.022228188848846, 15.990808141800953, 15.422836018027411, 14.766368476202668, 18.019210888715723, 26.681133724080873, 32.936640633650477, 41.192651249931764, 50.820570501635224, 81.30134061470001, 110.43978615629425, 212.43602421277993, 359.3048107396736, 515.14459200644205, 805.20630634633051, 1626.8549963375588, 5397.5422498759854, 3215.125406898349], "imag": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0]}, "imag": [0.0, -0.14902020441330027, -0.67710495110878655, -0.6881801226004951, 0.029443579937724847, -0.20094871849937471, -0.68791245552521774, -0.72827812731264463, 0.078068344484514218, 0.41313375345763731, -0.11919960000393952, -0.71935556472958995, -0.033994075615829664, 0.79310271815610678, 1.0485412757882202, 0.31963459583846549, 0.0, -0.31963459583845072, -1.0485412757882226, -0.79310271815610678, 0.033994075615829379, 0.71935556472959095, 0.11919960000393916, -0.41313375345763476, -0.078068344484514218, 0.72827812731264185, 0.68791245552521862, 0.20094871849937485, -0.029443579937724836, 0.68818012260049433, 0.67710495110878632, 0.14902020441330027, 1.1657398208090677, -0.38761332589064507, -2.5163414932492363, -2.5847428019012222, 1.7065268205659907, -0.26659947141883028, -1.7612103334384195, -0.72822101015527074, 0.12179041297535136, 0.18687402270680736, -0.12109853545440831, -0.38401966930786352, -0.088335680660082488, 0.055468788382486998, -0.088649319780239585, 0.10356786689233256, 1.1808955745571665, -0.062779809082666185, -0.91400202990551882, -0.6085517196782837, 0.0094930924522060312, 0.20081299805530148, -0.06803304935655391, 0.012577652358335469, 0.033553295747053846, -0.13629795514777901, -0.55322476205333171, 0.16665348831683371, 1.6347625123407883, -1.2112325279336729, -2.7678867797785314, -1.1631005581009268, 0.53321212268228979, 0.65777424026102749, -0.0059595089834900304, 0.64333558032637317, -0.013400706408967681, -1.6693935905986217, -0.063469706678883048, 0.54580806133266158, -0.065590467240471795, -0.42286579957171455, -0.20235216162881253, 0.49440559267811185, 0.3198533678523926, -1.0020973416135801, -0.94614545335921363, -0.32112572063647837, 0.67188974240307031, 0.12355783613973209, 0.29355063118446922, 0.63795269671082688, 0.21171161290294277, -0.40654495049723688, -0.14885884441008196, 0.40518645419156046, 0.25176669622887876, -0.4761471503847452, -1.2694305395629708, -0.50115245917544937, 1.7379359185439549, -1.5104148448809891, -1.8127000456147733, 1.3511857905116147, -2.2248814745809709, -2.9260010474168467, 2.8988227737472689, 2.4923883909800804, -1.3958450829260902, -0.082278705724815937, 2.2133069351689647, 1.0491520212286578, -0.079840002578371538, -0.49590260672839781, -0.029646930580498103, 0.78872177906031093, 0.19612727406574681, -0.75096042381039763, -0.61442756278477972, -0.34589242057405933, -0.55827984508264517, -0.057639041847566158, 0.56000672509604699, 1.1779553213485192, 0.34297063731481625, -0.31700999971207366, -0.056952598408498582, 0.1857688253715537, 0.059515398961152523, -0.23070889488422375, -0.067289667533411021, -0.45052222849242474, -0.042895027980831071, 1.6598740406764962, 1.7912379411122816, -0.11630227482832883, -2.003866342355487, -2.7192489258221713, 0.9217002223108024, 0.99386370915341038, -0.45711185122492165, 0.97539351588020684, 0.30440417133895387, -0.076378287793857885, 0.10477257582077601, 0.078900323673397929, 0.2630152461937153, 0.031794382449249342, -0.11240615902951592, 0.23783868068434, 0.44775143101136344, -0.20105686300455952, -1.0552137607230396, -0.51401383512929344, 0.054526011609804782, -0.026488236207787865, 0.16590740229872669, 0.18522424653870803, 0.046314810086569159, -0.24537254610227913, -0.28481464669570439, 0.34829742340973674, 1.0879631977925206, 1.2627265059936403, -0.49634217295171235, 1.3751434251570953, 2.5572924798905374, -2.3835279088157275, -0.34512363817546704, 0.04627556386614428, -0.28363975810469, -0.2387205493926067, 1.1836766662488489, 0.7304559467631897, -1.0994633527727609, -0.56900890379210023, -0.052741079187555495, 0.36596287984784248, 0.15532358639646346, -0.36091327743771645, -0.19067540763230895, 0.71462283256924886, 0.60857599156682896, 0.051411148277875428, -0.20391538842359699, -0.25954108900834599, -0.53918948446164328, -0.5935512086649235, -0.13740024164207204, 0.43579638717256186, 0.22502803407041108, -0.23772213393956157, -0.22688331070114534, 0.42727537166712742, 0.47834844059991255, 0.32734133863952164, -0.52361461628388295, -0.20363203779578987, 0.71022032181918715, 0.2819659388244356, 1.3792526471429849, 1.5283654352438392, -1.3044681939973228, -1.1436891608956035, 1.3490121369222494, 0.71922211831958782, -0.27032254521482335, -0.33653973458463504, -0.15391447881479364, 0.12480482561109964, -0.053989084045087433, -0.18576918773324888, 0.077197958779916712, 0.29699641531309923, -0.11903191000719174, 0.22681336512596068, 0.54520489108855463, 0.040990511598931259, -0.20653728920388259, -0.37081845053148882, -0.07530964105542165, 0.12159159821884764, 0.14350417348960001, 0.043165763689791151, -0.057977138737883523, -0.1379293882828701, -0.37919334928832643, -0.48456288814685777, 0.97887759552535047, 0.57420771517448999, -1.1922323352837048, -0.13841464698630696, 0.7604729654567205, 0.58367944495087776, -0.034817975520708581, 0.18370340800622625, -0.031292542572728878, -0.067318712633041858, 0.33696607725615524, 0.05414244352918586, -0.020415046981723958, -0.074435708294427722, -0.05732302224609874, 0.14754486034992467, 0.17049224676424324, -0.35431714454113261, -0.378008901790788, -0.088220333609354634, 0.20519624064542319, 0.17151350221764664, 0.17699487940227424, 0.19591419189057305, 0.0065199157977709234, -0.1674811218328473, -0.10967941676700359, 0.13440132102674274, 0.069755270915603892, -0.34407110156451998, -0.47647271020395277, 0.24778628953900186, 0.94881647182464612, 0.71445852536721188, -0.69300717410155177, -0.23252823659006602, -0.70126327582172698, -0.73508712834563017, 0.77441038277434426, 0.80063078785779984, -0.29211349969120898, -0.50261897876845574, -0.15844491832687652, 0.10672884533820617, 0.083096171746834438, -0.061219034404081496, 0.041606427790415887, 0.31036717878062553, 0.16259404663751506, -0.36128817330809687, -0.29370929634970039, -0.3179547262684097, -0.4515155411552858, -0.033181026716305836, 0.29522952049075729, 0.48699666134020275, 0.18589909016841552, -0.2294714118021266, -0.20114354017885722, -0.003121578634498275, 0.059620355744470117, -0.08629332168254554, -0.013702104296225414, 0.27636362870999703, -0.20367519268137141, -0.071823375624897781, 0.65390853098071755, 0.57936885621079115, -0.082507324096629489, 0.056565164700343597, 0.30313037910422419, 0.046580925466156033, -0.14205860955679683, -0.10567626674414661, -0.14942985439330783, 0.021649684970292335, 0.030697590171757046, -0.022837521893794246, 0.043322807027412293, 0.15694334998636744, 0.01091806619852779, 0.020198601252688204, 0.29902161442575942, -0.15020855085379564, -0.40608170156430695, -0.21661403238492213, 0.10933934038264595, 0.1999075728830931, 0.14959651238129035, 0.047092746667091859, -0.040888308386862755, -0.1125167716796989, -0.043845680385689492, 0.15335701874304222, 0.24380570184994388, -0.1171131305850218, -0.57195255260213129, -0.37275928254301222, 0.52232110568095647, 0.45087452742355255, 0.45399067647357039, 0.4510373698265433, -0.25445646061023242, -0.54674967268083918, -0.081775771006690631, 0.2737673334004137, 0.18625608494518781, 0.012289477611188196, -0.028787447589128854, -0.055397340673381909, -0.033006645910307206, -0.3893684484392882, -0.59052876986306613, 0.35206862979259157, 0.75972882974271683, 0.47741066022580114, 0.61795462873852247, -0.010739694431020583, -0.30365007670052568, -0.79734464193821375, -0.40014152475128489, 0.35743197872152449, 0.33543159046029042, -0.048324103015847428, -0.1196515677085014, 0.073496444899392971, 0.11953255023805801, -0.055918533770930395, 0.0274579890256498, -0.087565507326424513, -0.47798364115462866, -0.30556827592707503, -0.053529165520136063, -0.064762544527802626, -0.40460920017095653, -0.121109915711457, 0.34242949885797147, 0.25707377311839885, 0.18878454879876447, 0.05963524828049447, -0.042881345638875606, 0.080317301592987653, -0.066661209183029674, -0.78426965250242053, -0.67203925142686172, 0.38802788881902983, 0.13118499909748943, 0.3117062095733994, 0.51892211454846937, 0.28497632977966614, -0.6374756986952439, -0.78570616426150541, -0.55004558199035003, 0.081464209729413414, 0.32078878775035424, 0.10057675741278467, -0.038856958620208222, -0.093816614253325048, -0.12197711394968046, 0.10773217761141921, 0.53279302352225322, 0.49767840692700166, -0.40074591616539607, -0.4686202607911239, -0.47347988353308479, -0.38787976346044234, 0.0026864061776988978, 0.3750647268903417, 0.15775363291879776, -0.12070461118398887, 0.046341940929038844, 0.069762555352500089, 0.036760253935025015, 0.11153094686031426, -0.23193620085952527, -0.025338164060148199, 0.83717158631584143, 0.14069991818818439, -0.80636013277763063, -1.117979830240589, -0.53116916718597551, -0.29647728355917563, 0.43255465109120794, 1.0682488929022527, 0.7439367652619796, -0.27653752308302104, -0.43736635010141273, -0.051946126514290911, 0.075483221784175089, 0.041517261114611535, 0.089698476442270109, 0.18582746405096062, 0.11108661545235869, 0.17635934890910801, 0.26257982919312395, 0.014915731745956722, -0.051592883258874553, -0.15702165108916452, 0.26018009521205254, 0.10187767444835746, -0.5266864552492494, -0.19184365339748963, 0.12365061867406398, -0.0040460672180273232, -0.10695443147688474, -0.38062982787546124, -0.23013531228214942, 1.4911852257492946, 1.8656257067805557, -0.31189832297292175, -1.8409665915911073, -1.3523062385443718, -0.59758078449912422, -0.4109826389978809, 0.64471434504327652, 1.2836469730056959, 1.499792380953558, -0.050007892106663135, -0.70097924672910039, -0.37676357011449496, 0.039596089571393787, 0.16672200998370845, 0.27616851123315678, 0.25535752279806784, -0.25821883180569144, -0.71643423075370694, -0.2869241470876478, 0.19246225810939122, -0.48949334565382685, -0.6758600491934259, -0.60078389394518394, -0.1042403296189125, 0.33526929000920908, 0.41773479752161374, -0.015233071039077716, -0.23129559015563347, -0.27890178606409965, -0.36644166250128341, 0.53421537629701843, 1.5124695265818406, 0.46952715514837384, -1.6086255934377758, -0.58627286749798335, 0.2521262787687128, 0.81274320419200763, 1.0066444599512538, 0.13589799436620603, -0.52681222515518755, -0.80035014449929209, 0.17170214273365031, 0.32102965848797577, 0.015298055895547559, -0.0095152173876638588, -0.05852775349790857, -0.29325388964527122, -0.23187846370788526, 0.12261389073580377, 0.13365949638292357, 0.34550584055022809, 0.32834338818238823, -0.63681653846377151, -0.14332768166025622, -0.050699039849278892, 0.076799367032860139, 0.62304231858822723, 0.13934878438080031, -0.36565795334395523, -0.22525673769874993, 0.058882171297733404, 0.45328032825037023, 0.67278513933730488, -0.62930489911730125, -2.1514876673114358, -0.38381606543972158, 1.7701780351745315, 2.2434589636984619, 1.3655631816809142, 0.67716955795129208, 0.23622587273603302, -1.2645365769339125, -1.1592659817915987, 0.22681074823924935, 1.0532421029439241, 0.47375681144418214, -0.017283859373080118, -0.31852036401253409, -0.42276437548587065, -0.20851072339742521, 0.32537663103197029, 0.67802433082994906, 0.64221455700256691, -0.19334381074242141, 0.0, 0.98534755955725073, 0.93082832187418163, 0.090975734109736334, -0.23547278252877649, -0.42043029453907255, -0.16156648245217306, 0.14891910968678568, 0.27252999755409263, 0.21807537509429559, -0.1793267317851967, -1.3886930910143056, -1.2475969582391058, 0.82617687521947225, 1.688041333210945, 0.93307675660552747, 0.0, -0.93307675660552858, -1.688041333210949, -0.82617687521947558, 1.2475969582391047, 1.3886930910143054, 0.17932673178519704, -0.21807537509429575, -0.27252999755409263, -0.14891910968678598, 0.16156648245217331, 0.42043029453907194, 0.23547278252877635, -0.090975734109735945, -0.93082832187418285, -0.9853475595572504, 0.63681653846377428, 0.19334381074242313, -0.64221455700256724, -0.67802433082995051, -0.32537663103196973, 0.20851072339742566, 0.42276437548587059, 0.31852036401253342, 0.017283859373080232, -0.47375681144418219, -1.0532421029439241, -0.22681074823925124, 1.1592659817916007, 1.2645365769339141, -0.23622587273603313, -0.67716955795129263, -1.3655631816809146, -2.2434589636984619, -1.7701780351745346, 0.38381606543971747, 2.1514876673114336, 0.62930489911730425, -0.67278513933730544, -0.45328032825037173, -0.058882171297733529, 0.22525673769874915, 0.36565795334395551, -0.1393487843807989, -0.6230423185882269, -0.076799367032859514, 0.050699039849279363, 0.14332768166025514, 0.48949334565382807, -0.32834338818238801, -0.34550584055022948, -0.13365949638292388, -0.12261389073580344, 0.23187846370788381, 0.29325388964527066, 0.058527753497908265, 0.0095152173876637894, -0.015298055895547204, -0.32102965848797627, -0.17170214273365259, 0.80035014449929354, 0.52681222515519222, -0.13589799436620179, -1.0066444599512541, -0.81274320419201052, -0.25212627876871579, 0.5862728674979838, 1.6086255934377784, -0.46952715514837307, -1.5124695265818422, -0.53421537629701898, 0.36644166250128374, 0.27890178606409988, 0.23129559015563281, 0.01523307103907798, -0.41773479752161302, -0.33526929000920919, 0.1042403296189123, 0.6007838939451835, 0.67586004919342602, 0.051592883258874796, -0.19246225810939102, 0.28692414708764713, 0.71643423075370816, 0.25821883180569155, -0.25535752279806728, -0.27616851123315733, -0.16672200998370851, -0.039596089571393857, 0.37676357011449418, 0.70097924672910006, 0.05000789210666385, -1.4997923809535563, -1.2836469730056956, -0.64471434504327885, 0.41098263899788057, 0.59758078449912211, 1.352306238544366, 1.8409665915911118, 0.31189832297292347, -1.8656257067805575, -1.4911852257492944, 0.23013531228214901, 0.3806298278754614, 0.10695443147688473, 0.0040460672180278982, -0.12365061867406386, 0.19184365339748918, 0.52668645524924984, -0.10187767444835667, -0.26018009521205249, 0.15702165108916435, 0.47347988353308512, -0.014915731745956694, -0.26257982919312345, -0.17635934890910804, -0.11108661545235819, -0.18582746405096062, -0.089698476442269984, -0.041517261114611431, -0.075483221784175006, 0.051946126514290501, 0.43736635010141267, 0.27653752308302265, -0.74393676526197827, -1.068248892902254, -0.43255465109120911, 0.29647728355917641, 0.53116916718597607, 1.1179798302405872, 0.80636013277763019, -0.14069991818818398, -0.83717158631584188, 0.025338164060147935, 0.2319362008595256, -0.11153094686031419, -0.036760253935025175, -0.069762555352499631, -0.046341940929038775, 0.12070461118398874, -0.15775363291879749, -0.37506472689034165, -0.0026864061776987339, 0.38787976346044295, 0.053529165520136666, 0.46862026079112395, 0.40074591616539496, -0.49767840692700188, -0.53279302352225388, -0.1077321776114199, 0.12197711394968033, 0.093816614253324923, 0.038856958620208139, -0.10057675741278502, -0.32078878775035391, -0.081464209729413262, 0.55004558199034881, 0.78570616426150586, 0.63747569869524534, -0.28497632977966464, -0.51892211454846815, -0.31170620957339795, -0.13118499909748749, -0.38802788881902978, 0.67203925142686127, 0.78426965250242042, 0.06666120918302984, -0.080317301592987847, 0.042881345638875745, -0.05963524828049447, -0.18878454879876405, -0.25707377311839802, -0.34242949885797153, 0.12110991571145559, 0.40460920017095686, 0.064762544527803223, -0.45399067647357122, 0.30556827592707503, 0.47798364115462999, 0.087565507326423986, -0.027457989025650414, 0.055918533770930486, -0.11953255023805759, -0.073496444899393262, 0.11965156770850158, 0.048324103015847719, -0.33543159046028986, -0.35743197872152471, 0.40014152475128417, 0.79734464193821419, 0.30365007670052546, 0.010739694431020585, -0.61795462873852236, -0.4774106602258017, -0.75972882974271716, -0.35206862979259274, 0.59052876986306602, 0.38936844843928831, 0.033006645910306921, 0.055397340673381999, 0.028787447589128854, -0.012289477611188065, -0.18625608494518778, -0.2737673334004137, 0.08177577100669034, 0.54674967268084007, 0.25445646061023275, -0.45103736982654352, 0.082507324096629073, -0.45087452742355144, -0.52232110568095624, 0.37275928254301144, 0.5719525526021314, 0.11711313058502268, -0.24380570184994438, -0.15335701874304256, 0.043845680385689638, 0.11251677167969909, 0.040888308386862651, -0.047092746667091887, -0.14959651238128985, -0.19990757288309219, -0.10933934038264552, 0.21661403238492188, 0.40608170156430567, 0.15020855085379528, -0.29902161442575986, -0.020198601252688145, -0.010918066198527492, -0.15694334998636708, -0.043322807027412154, 0.022837521893794229, -0.030697590171757067, -0.02164968497029204, 0.14942985439330775, 0.10567626674414606, 0.14205860955679689, -0.0465809254661547, -0.30313037910422319, -0.05656516470034452, 0.70126327582172698, -0.57936885621079104, -0.65390853098071722, 0.071823375624897504, 0.20367519268137155, -0.2763636287099972, 0.013702104296225327, 0.086293321682545693, -0.059620355744470117, 0.0031215786344983188, 0.20114354017885719, 0.22947141180212641, -0.1858990901684156, -0.48699666134020314, -0.29522952049075735, 0.033181026716305816, 0.4515155411552858, 0.31795472626840998, 0.29370929634969961, 0.36128817330809659, -0.16259404663751492, -0.3103671787806257, -0.041606427790415977, 0.061219034404081517, -0.083096171746834438, -0.10672884533820629, 0.1584449183268766, 0.50261897876845563, 0.29211349969120898, -0.80063078785779973, -0.77441038277434415, 0.73508712834562984, -0.7604729654567195, 0.23252823659006566, 0.69300717410155133, -0.71445852536721133, -0.94881647182464579, -0.247786289539003, 0.47647271020395332, 0.34407110156452003, -0.06975527091560392, -0.13440132102674238, 0.10967941676700353, 0.16748112183284758, -0.0065199157977711844, -0.19591419189057413, -0.17699487940227479, -0.17151350221764519, -0.20519624064542319, 0.088220333609354384, 0.37800890179078739, 0.35431714454113228, -0.17049224676424349, -0.14754486034992517, 0.05732302224609858, 0.074435708294427874, 0.020415046981723993, -0.054142443529185957, -0.33696607725615474, 0.067318712633042552, 0.031292542572729155, -0.183703408006228, 0.034817975520707763, -0.58367944495087642, -1.3792526471429849, 0.1384146469863056, 1.1922323352837043, -0.57420771517448999, -0.97887759552535036, 0.48456288814685816, 0.37919334928832632, 0.13792938828286982, 0.057977138737883592, -0.043165763689791442, -0.14350417348959951, -0.12159159821884727, 0.0753096410554214, 0.37081845053148832, 0.20653728920388284, -0.040990511598931294, -0.5452048910885553, -0.22681336512596068, 0.11903191000719161, -0.29699641531309889, -0.077197958779916934, 0.18576918773324919, 0.053989084045087239, -0.12480482561109926, 0.15391447881479356, 0.33653973458463499, 0.27032254521482346, -0.71922211831958716, -1.3490121369222496, 1.143689160895601, 1.3044681939973219, -1.5283654352438407, 0.34512363817546499, -0.28196593882443538, -0.71022032181918571, 0.20363203779578934, 0.52361461628388117, -0.32734133863952108, -0.47834844059991177, -0.4272753716671272, 0.22688331070114495, 0.23772213393956154, -0.22502803407041136, -0.43579638717256142, 0.13740024164207254, 0.59355120866492272, 0.53918948446164539, 0.25954108900834527, 0.20391538842359649, -0.051411148277873762, -0.60857599156682773, -0.71462283256924997, 0.19067540763230911, 0.36091327743771712, -0.15532358639646357, -0.36596287984784226, 0.052741079187555578, 0.56900890379209967, 1.0994633527727615, -0.73045594676318792, -1.18367666624885, 0.23872054939260659, 0.28363975810469044, -0.046275563866146709, 2.0038663423554866, 2.3835279088157284, -2.5572924798905374, -1.3751434251570973, 0.49634217295171212, -1.2627265059936426, -1.0879631977925208, -0.34829742340973796, 0.28481464669570433, 0.24537254610228046, -0.046314810086569187, -0.18522424653870898, -0.16590740229872719, 0.026488236207788063, -0.054526011609805532, 0.514013835129293, 1.0552137607230383, 0.20105686300456052, -0.44775143101136289, -0.23783868068434011, 0.11240615902951644, -0.031794382449249259, -0.26301524619371552, -0.078900323673398332, -0.10477257582077593, 0.076378287793858177, -0.30440417133895292, -0.97539351588020617, 0.45711185122492154, -0.99386370915341027, -0.92170022231080229, 2.7192489258221721, 2.2248814745809713, 0.11630227482833386, -1.7912379411122841, -1.6598740406764991, 0.042895027980832189, 0.45052222849242363, 0.067289667533409939, 0.23070889488422444, -0.059515398961152315, -0.18576882537155384, 0.056952598408498437, 0.31700999971207372, -0.3429706373148162, -1.1779553213485197, -0.56000672509604887, 0.057639041847566339, 0.55827984508264517, 0.34589242057405939, 0.6144275627847795, 0.75096042381039751, -0.19612727406574634, -0.78872177906031049, 0.029646930580497943, 0.49590260672839631, 0.079840002578371469, -1.0491520212286569, -2.2133069351689625, 0.082278705724815757, 1.3958450829260909, -2.4923883909800781, -2.8988227737472685, 2.926001047416845, -0.53321212268228979, -1.3511857905116138, 1.8127000456147735, 1.5104148448809913, -1.7379359185439534, 0.50115245917545159, 1.2694305395629717, 0.47614715038474426, -0.25176669622887887, -0.40518645419156096, 0.14885884441008229, 0.4065449504972391, -0.21171161290294366, -0.63795269671082933, -0.29355063118447033, -0.12355783613972898, -0.67188974240307053, 0.32112572063647804, 0.94614545335921341, 1.0020973416135777, -0.3198533678523926, -0.49440559267811113, 0.20235216162881259, 0.42286579957171511, 0.065590467240471767, -0.54580806133266224, 0.063469706678882465, 1.6693935905986201, 0.013400706408968283, -0.64333558032637317, 0.0059595089834898612, -0.65777424026102704, -1.1657398208090681, 1.1631005581009257, 2.7678867797785287, 1.2112325279336758, -1.6347625123407896, -0.16665348831683333, 0.5532247620533326, 0.13629795514777876, -0.033553295747053943, -0.012577652358336237, 0.068033049356555603, -0.20081299805530076, -0.0094930924522065932, 0.60855171967828092, 0.91400202990551482, 0.062779809082669502, -1.1808955745571674, -0.10356786689233179, 0.08864931978023799, -0.055468788382486117, 0.088335680660082266, 0.38401966930786247, 0.12109853545440752, -0.18687402270680636, -0.12179041297535122, 0.72822101015526997, 1.7612103334384188, 0.26659947141883078, -1.7065268205659894, 2.5847428019012186, 2.5163414932492363, 0.3876133258906464], "height": 32, "width": 32, "top": {"real": [28423.105313214044, 28674.724231095144, -722.69366896540907, 9225.7770064733304, 1497.6465357448014, 760.04278979701394, 247.10162746021342, 151.72529893327805, -4.8884885781823266, -16.133735393751934, -0.18360891080128469, 2.3500990684470797, -0.33005469194377962, 4.1571470713537551, 9.5943595112319517, -8.8624203891274274, -22.052590313243808, -8.8624203891274416, 9.5943595112320637, 4.1571470713537408, -0.33005469194377934, 2.3500990684471894, -0.18360891080150321, -16.133735393751511, -4.8884885781823266, 151.72529893327811, 247.10162746021339, 760.04278979701553, 1497.6465357448021, 9225.777006473334, -722.69366896540839, 28674.724231095115, 25390.170503473099, 2752.5053486176007, -7213.0026112046817, -848.38159326591301, 982.95511309135748, 457.86146922204989, -46.175546007130123, -28.684822585718617, 4.5612631126941601, 36.180920465642473, 1.491875160093084, -21.191137754573024, 2.8803824684767365, 32.414130280804258, 20.161840527236397, -4.0194858939287581, -5.5658589086089485, -1.4949158508676244, -19.561354112987054, -17.959748575409641, 0.86872374588173218, 25.323206346284437, 8.3348052170650675, -41.926948021480371, -20.687109086504861, 218.3167491556907, 546.49872794031398, 514.9954980598236, 620.49539711803413, 4452.6929959791041, -174.99103969876961, 2133.8618335997025, 26666.274860226469, 9631.0824500605449, -10095.4436331661, -4944.5276302554494, 770.97093894980139, 234.73611402062764, -189.92210588558362, -126.31904474729288, -4.4359398121268772, 25.844521173618485, 1.2207482283869857, -12.318944408119624, 7.2506028858091991, 18.769456353148023, 2.7720670784771717, 0.13907690271807935, 9.7740131156133714, 6.2313507558256029, -20.012525822291419, -16.040469196891664, 3.7834180501306807, 18.113814308198215, 6.9628905148897537, -1.8812165005783674, -3.1507841384785769, 24.526337675319898, 193.3623500499944, 465.72794392086701, 284.66528985874095, -3081.1066694335791, -9076.4400559658607, 1118.2132640961638, 5705.1501208043383, 397.85150159824235, -2822.6768689275941, 728.40381948841912, 1249.2695734137342, 82.616255878071726, -93.950748347298983, -33.623549275177439, -5.1522911915584819, -7.2338183321331133, -7.001283565832134, 11.310122449566075, 7.3973207504467258, -10.314744048939033, -17.670460817927417, 0.86416108685457238, -1.7856630822843305, 4.9636496941116963, 3.7892183180180301, 4.3540479322804604, 0.81912298615372481, -8.9239476494738241, -0.63615178952006057, 26.029536485331942, 20.179218397178587, -95.964038421947748, -279.42683310552798, -11.991282367617261, 1111.9285745591587, 12.384349101876612, -5014.4780810602624, -931.02314429185174, -2935.685284408914, -1215.2968180059599, 2222.0566542865231, 1545.4091719722733, -307.58274676435752, -163.25068439377958, 122.1532745420013, 76.416221889183532, 3.1644160240378296, -19.634567061108559, -1.3809484232923637, 15.595649759531634, 4.7705608814238305, -10.468288519634084, -9.7282165445191495, -3.892040076973144, -8.4797405266260863, -0.5408298481218079, 13.233921729082965, 15.992639239497516, 3.5976801907925586, -15.812600063085762, -8.7583525837485485, 13.529650759569922, 11.041451779488147, -36.837920974757942, -116.57081449547842, -177.82612582226329, 206.8817050386096, 1116.6649976696201, 1551.5341746851843, 206.06587874917457, 221.21501338856706, 949.59692563201861, 2377.7643188321972, 271.30602644407116, -752.63562664968606, -131.94201270845676, 66.794183325011446, 26.328209125885053, -2.6512991036295719, -7.060878043009799, 3.4956142029525408, 4.0712276182145608, -0.49091417497970008, -0.54247114501895244, 2.5929708279440629, -2.2683391883792092, -3.9697444489461264, 0.64738652825819076, 4.555701357906309, 5.0432051545575858, 1.8637246814391786, -2.1415599665130838, -3.0402232986351168, -7.5278540025228704, -9.1564876386533562, 18.733705732232028, 116.47631097371497, 62.470104114045292, -587.35890158810116, -665.30895184878261, 1602.7477447230021, 2320.4028678586192, 84.3231427941042, 335.33509531572889, 111.12995285997569, -246.89163612982301, 99.59266396905916, 121.29447232003599, -19.935724961316957, -24.271547137145927, -9.9392605214134129, 3.6463495838243953, 2.4659870551932221, -4.9118061115950002, -3.9830584925921726, 3.1158463847663604, 4.6325922286854171, 0.7426231797993057, 2.6761268245222913, 0.75707810610464332, -2.0529004071821726, -5.4726123906428121, -3.3500885842682195, 4.7318552060186496, 3.3081314176561212, -7.5747009667011485, -9.660327017316277, 13.948321679490391, 60.920555877786029, 51.912766255688908, -200.57409151559827, -358.55234539419581, 389.87395397760162, 626.9468569152699, 385.67355889894168, 266.46730452215979, -754.85949807698285, -357.47689087779764, 198.35300746583653, 104.20178335269868, 0.2335042399832746, -13.459048177551795, -2.4931441622280337, 3.3591145464251499, -0.87332830625456936, -5.0562417941567173, -2.0170485858323599, 2.3079461733716489, 1.2848757720394648, 1.0044515769395077, 2.2715095300739048, 1.0357721766880663, -1.8190548566089728, -3.9293196367766434, -3.2116043474898985, 1.2474845862739923, 2.207161661351936, 0.30672454240560637, -1.2664097847556852, 1.1634429445003909, -12.548270616696369, -13.623126322836848, 148.11914826060797, 160.05821428876476, -517.73406283289592, -683.78444654557211, 232.19478887738595, 129.53848012256918, -30.629684625724426, 14.007085088982263, -28.536726784912368, -22.150721493101905, 7.4458049666709201, 6.5426060710782901, 2.7181624419475532, -0.21791167804934167, -2.1894859760859342, -0.30261213114781382, 1.6929032656017511, 0.075295172141104427, -2.5525542005113677, 0.092868468976744334, 0.059811282681573222, 0.44341981227717964, 0.7816687865488906, 1.8071322433818207, 1.0194826794166407, -1.7022885447654383, -1.6578557975757291, 1.4780948040669197, 2.3190205805607031, -2.0993082250693513, -8.8242080507891387, 6.7426676795129614, 63.308016957216438, 32.614432065456008, -214.97833639893088, -154.136284333817, -153.00121169652448, -168.20144264926009, 132.73656142769508, 108.19035464369672, -32.411936148940164, -29.299646468639978, 0.48512698058416193, 5.624023137620874, 1.3789304004393061, -2.3621905210139289, -1.2100039550542188, 4.3583730663879736, 4.4422506314578856, -3.3529459489445013, -3.2593326279479276, -2.3921307524924811, -2.978651033636929, -0.78921784490688773, 2.0776847434633869, 4.6706759151301158, 3.7169173278476082, -1.8762573022143243, -3.6928619255631911, -0.82171694591384903, 1.0313698171467438, -0.47387208215225501, 4.5050179323404294, 12.279477314121408, -23.426373610246564, -47.509829762735897, 96.770610724801742, 142.54719834919302, -140.65053169937673, -123.6545784250871, -20.023908130365463, 5.7599623270112001, 10.838125249555288, 8.3690034326252576, -0.61869787578431057, -1.9872713177733001, -0.88566790635833359, -1.3475268812751358, 0.76129128976144478, 4.1066846542201834, 0.69320146991960074, -1.2677968128954245, 0.81553632831789258, -1.6303291884460738, -2.2291497640151472, -1.5668982951183865, 1.2058440679467928, 2.0699393017293768, 1.4972394562433364, -0.45863502618354141, -1.2690924739742997, -0.78463693252535771, -0.71980764244508078, 0.10250612713533153, 2.393822328408012, -0.41309740564872016, -15.44378212490165, 0.6609566018409474, 72.351368761661817, 25.384635851249769, 24.183834027615426, 48.560459752587064, -30.885786753212521, -41.646585437272115, 4.9406680758638473, 9.7637208498293564, -2.6994657893152145, -2.3673227042220928, 0.99131130124397382, 1.9229365129251841, 1.0659834826624002, -5.2481714738530103, -7.2759438909005807, 4.8682061863604567, 9.822573727789889, 5.6528275472549172, 2.0386422190351761, 0.27431668194701375, -2.1164683881366688, -6.0913412323542273, -4.1102964274349301, 3.1073479985221883, 4.720787089742764, 1.4415919680128015, 0.049935137368385736, 0.23499648430732389, -3.983837312738201, -10.315757961787851, 3.7701904804417365, 17.40344272954281, -26.485594572094836, -57.180963546905772, 56.164057478325546, 74.232658958160258, -2.1566648897744729, -33.253025139779027, -16.080807358669208, -7.6408862919476457, -0.061535710181698199, 4.3516423276699152, 3.0483876930594445, 1.4396821019147403, -2.1531487354432772, -12.330021507307762, -6.784080497103278, 6.2189314368004602, 6.5359347127328817, 5.8394886675864184, 6.5502057137602838, 2.8897971357633669, -4.5807084372558364, -7.1480702421459901, -3.5449281234624839, 3.1166956033252706, 5.7654746814446929, 1.4593710853505601, 0.079551299266885034, 1.7754263793290057, 1.1602778115858083, -4.1621952562095537, -6.1090111539332135, -21.585708623899716, -64.660963126416291, -42.918674159823304, -12.637618832694352, -23.660098526273554, -32.757377164957738, -16.139835139531076, -8.8214501105659302, -0.074083275956097649, 9.2347297800775099, 4.0583945463193585, -1.3379386144670409, -1.0708228123536387, -3.7494033803061741, -1.4014962110675557, 6.3397919866467625, -0.03663393601032304, -6.5449789794813107, -2.0617294503879311, 2.9031092319630374, 1.9851413256277737, 1.0607201932740675, 2.7050589244056695, 2.9910202735510598, -2.6114709035663148, -2.998378794740129, -0.21466478532365837, -0.045062120129980232, 0.26663892053888355, 4.6476599377621559, 4.3038853444793466, -6.8220974094569344, -12.449318624888502, -10.129633105210658, -14.243655171088259, -24.590264561101538, -60.147765518061014, -2.4700759029582726, 27.756533006476555, 4.2749753092209222, 1.5109008418257455, 2.3037162841058008, -3.3991123070026288, -2.3657348243984693, -1.7285717434362748, 1.4807803344279866, 11.452735641829591, 12.838038879276603, -0.48093805977912302, -8.4823730361517384, -10.096707565442667, -5.1613641497068938, -2.6506938623127332, 9.4081369631901755, 9.4967470257992304, 1.5732629424154292, -6.2329583900406389, -7.3741953717279571, -0.66458216201047882, 2.3894666174155379, 0.72026798365788192, -2.7056126524381918, -1.4278421900811593, 6.2735441200134945, 15.997118782527094, 32.340859723792008, 29.293996905608573, 6.5830123071218694, -6.0118236769643065, 35.32705272368031, 28.93384981751958, 4.6778289682139205, -4.8626411358427797, -9.0689375245571853, -5.8403695985513542, -0.88764146409061928, 0.44619327315923196, 2.0930545096716431, 8.2346460399114871, 4.4412927362425512, -3.9444092199360696, -3.9225599509162312, 0.038172103710441746, -1.1645390667947013, 3.8468081061273272, 3.825131103533594, 0.73794607986345129, -4.4683377641176865, -3.1226055206334693, -1.659659462142453, -1.5916869216083986, 0.66773943004769798, 3.4159390288117701, 1.5141668200491456, 0.24760595741359728, -0.60433400901725032, -18.385421885703135, -9.3028295113894721, 25.73026622408986, 16.23212758885586, 17.912434056418146, -8.8649857221999238, -22.650006821252305, -4.6057627844621933, 3.1371579845110453, -0.064465121107319889, -0.7788946841662594, -1.4905827462536891, -1.6111207980069511, 3.9054962114874257, 1.1954905638175628, -5.7282279624444916, -8.3976603765003119, -2.0078722367450874, 4.7029696271178913, 9.1972361583870761, 4.7029696271178825, -2.0078722367450905, -8.3976603765003119, -5.7282279624444836, 1.1954905638175473, 3.9054962114874288, -1.6111207980069395, -1.4905827462536891, -0.77889468416625518, -0.064465121107317946, 3.1371579845110462, -4.6057627844621942, -22.650006821252259, -8.8649857221999415, 17.912434056418164, 6.583012307121729, 25.730266224089799, -9.3028295113894721, -18.385421885703128, -0.60433400901726175, 0.24760595741359434, 1.5141668200491516, 3.415939028811767, 0.66773943004769509, -1.5916869216084077, -1.6596594621424434, -3.1226055206334529, -4.4683377641176723, 0.73794607986344696, 3.8251311035336037, 3.8468081061273467, -1.1645390667946849, 0.038172103710459718, -3.9225599509162259, -3.9444092199360838, 4.4412927362425298, 8.2346460399114854, 2.0930545096716502, 0.44619327315923041, -0.88764146409061584, -5.8403695985513515, -9.0689375245571728, -4.862641135842777, 4.6778289682139134, 28.933849817519487, 35.327052723680374, -6.0118236769642888, -24.590264561101595, 29.293996905608687, 32.340859723791993, 15.997118782527064, 6.2735441200134687, -1.4278421900811535, -2.7056126524381958, 0.72026798365787437, 2.3894666174155401, -0.66458216201047282, -7.3741953717279607, -6.2329583900406416, 1.5732629424154319, 9.4967470257992108, 9.4081369631901666, -2.6506938623127225, -5.1613641497068841, -10.096707565442674, -8.4823730361517544, -0.48093805977915227, 12.83803887927658, 11.452735641829598, 1.4807803344279824, -1.7285717434362824, -2.3657348243984719, -3.3991123070026203, 2.3037162841058088, 1.5109008418257512, 4.2749753092209266, 27.756533006476598, -2.470075902958246, -60.147765518061043, -12.637618832694358, -14.243655171088175, -10.12963310521061, -12.449318624888507, -6.8220974094569566, 4.3038853444793421, 4.6476599377621488, 0.26663892053888499, -0.045062120129979372, -0.21466478532365083, -2.998378794740133, -2.6114709035663206, 2.9910202735510656, 2.7050589244056806, 1.0607201932740935, 1.9851413256277779, 2.9031092319630249, -2.0617294503879293, -6.5449789794813169, -0.036633936010327744, 6.339791986646766, -1.4014962110675422, -3.7494033803061728, -1.0708228123536432, -1.3379386144670453, 4.0583945463193594, 9.2347297800775188, -0.074083275956095859, -8.8214501105659284, -16.139835139531023, -32.757377164957752, -23.660098526273632, 56.164057478325425, -42.918674159823318, -64.660963126416391, -21.585708623899666, -6.1090111539332215, -4.1621952562095581, 1.1602778115858134, 1.775426379329013, 0.079551299266884423, 1.4593710853505546, 5.7654746814447053, 3.1166956033252631, -3.5449281234624781, -7.1480702421459874, -4.5807084372558347, 2.8897971357633647, 6.5502057137602785, 5.8394886675864104, 6.5359347127329022, 6.2189314368004851, -6.78408049710327, -12.330021507307773, -2.1531487354432741, 1.439682101914743, 3.04838769305944, 4.3516423276699179, -0.061535710181697623, -7.6408862919476563, -16.080807358669187, -33.253025139779005, -2.1566648897745, 74.232658958160258, 24.183834027615593, -57.180963546905936, -26.485594572094925, 17.403442729542817, 3.7701904804417596, -10.315757961787877, -3.9838373127381965, 0.23499648430733011, 0.049935137368386437, 1.4415919680127984, 4.7207870897427613, 3.1073479985221901, -4.1102964274349274, -6.0913412323542424, -2.1164683881366799, 0.27431668194701325, 2.0386422190351805, 5.6528275472549048, 9.822573727789889, 4.8682061863604691, -7.2759438909005807, -5.2481714738530263, 1.0659834826623993, 1.9229365129251905, 0.99131130124397682, -2.3673227042220857, -2.699465789315211, 9.7637208498293848, 4.9406680758638624, -41.646585437272229, -30.885786753212596, 48.560459752587221, -140.65053169937659, 25.384635851249651, 72.351368761661789, 0.66095660184101279, -15.443782124901649, -0.41309740564871933, 2.3938223284080151, 0.10250612713533497, -0.71980764244507844, -0.78463693252535704, -1.2690924739742999, -0.45863502618354285, 1.4972394562433307, 2.0699393017293644, 1.2058440679467857, -1.5668982951183805, -2.2291497640151445, -1.6303291884460729, 0.81553632831788769, -1.2677968128954307, 0.69320146991959397, 4.1066846542201878, 0.76129128976144589, -1.3475268812751391, -0.88566790635833126, -1.9872713177733001, -0.61869787578431157, 8.3690034326252771, 10.838125249555295, 5.7599623270111371, -20.023908130365466, -123.65457842508674, -153.00121169652476, 142.547198349193, 96.770610724801799, -47.509829762735976, -23.426373610246678, 12.279477314121431, 4.505017932340448, -0.47387208215225296, 1.0313698171467449, -0.82171694591384781, -3.6928619255631867, -1.8762573022143267, 3.7169173278476135, 4.6706759151301114, 2.0776847434633798, -0.78921784490688629, -2.9786510336369223, -2.3921307524924669, -3.2593326279479267, -3.3529459489444933, 4.4422506314578865, 4.3583730663879798, -1.2100039550542185, -2.3621905210139329, 1.3789304004393068, 5.6240231376208731, 0.48512698058415527, -29.29964646863997, -32.411936148940157, 108.19035464369668, 132.73656142769508, -168.20144264926049, 232.19478887738595, -154.13628433381695, -214.97833639893091, 32.614432065455887, 63.308016957216388, 6.7426676795129818, -8.8242080507891405, -2.0993082250693487, 2.3190205805607031, 1.4780948040669208, -1.657855797575728, -1.7022885447654388, 1.0194826794166389, 1.8071322433818233, 0.78166878654889338, 0.44341981227717431, 0.059811282681573222, 0.092868468976748497, -2.5525542005113593, 0.075295172141105315, 1.6929032656017555, -0.30261213114781177, -2.1894859760859413, -0.21791167804934622, 2.7181624419475532, 6.5426060710782918, 7.4458049666709138, -22.150721493101912, -28.536726784912382, 14.007085088982294, -30.629684625724458, 129.53848012256904, 385.67355889894196, -683.78444654557279, -517.73406283289592, 160.05821428876459, 148.1191482606082, -13.623126322836866, -12.548270616696426, 1.1634429445003742, -1.2664097847556794, 0.30672454240560415, 2.2071616613519298, 1.2474845862739898, -3.2116043474898839, -3.9293196367766487, -1.8190548566089664, 1.0357721766880712, 2.2715095300739065, 1.0044515769394997, 1.2848757720394559, 2.3079461733716413, -2.0170485858323568, -5.0562417941567217, -0.87332830625457158, 3.3591145464251335, -2.4931441622280368, -13.459048177551766, 0.23350423998331427, 104.20178335269858, 198.35300746583647, -357.47689087779742, -754.85949807698285, 266.46730452215979, 84.323142794104228, 626.94685691527002, 389.87395397760116, -358.55234539419558, -200.57409151559838, 51.912766255688851, 60.920555877786029, 13.948321679490393, -9.6603270173162681, -7.5747009667011582, 3.3081314176561238, 4.7318552060186576, -3.3500885842682231, -5.472612390642829, -2.0529004071821806, 0.75707810610465265, 2.676126824522286, 0.74262317979931325, 4.6325922286854091, 3.1158463847663604, -3.9830584925921673, -4.9118061115949914, 2.4659870551932261, 3.6463495838243847, -9.9392605214134129, -24.271547137145948, -19.935724961316961, 121.29447232003592, 99.592663969059103, -246.89163612982315, 111.12995285997523, 335.33509531572906, 221.21501338856802, 2320.4028678586192, 1602.7477447230024, -665.30895184878284, -587.35890158810128, 62.470104114045164, 116.47631097371504, 18.733705732232092, -9.1564876386533669, -7.5278540025228837, -3.0402232986351114, -2.1415599665130745, 1.8637246814391684, 5.0432051545575796, 4.5557013579063117, 0.64738652825819132, -3.9697444489461211, -2.2683391883791986, 2.59297082794407, -0.54247114501893734, -0.49091417497970297, 4.0712276182145537, 3.4956142029525421, -7.0608780430097635, -2.6512991036295777, 26.328209125884918, 66.794183325011389, -131.94201270845636, -752.63562664968617, 271.3060264440702, 2377.7643188321958, 949.59692563201872, -2935.685284408913, 206.06587874917372, 1551.534174685185, 1116.6649976696197, 206.88170503860968, -177.82612582226307, -116.57081449547834, -36.837920974758035, 11.041451779488151, 13.529650759569909, -8.7583525837485361, -15.812600063085752, 3.5976801907925351, 15.992639239497519, 13.233921729082972, -0.54082984812181611, -8.479740526626081, -3.8920400769731613, -9.7282165445191335, -10.468288519634076, 4.7705608814238323, 15.595649759531605, -1.3809484232923479, -19.634567061108552, 3.1644160240378296, 76.416221889183575, 122.15327454200114, -163.25068439377961, -307.58274676435752, 1545.4091719722737, 2222.0566542865222, -1215.2968180059584, 5705.1501208043328, -931.02314429184867, -5014.4780810602606, 12.384349101875989, 1111.9285745591585, -11.991282367617289, -279.42683310552832, -95.964038421947791, 20.179218397178591, 26.029536485331974, -0.63615178952006546, -8.9239476494738614, 0.81912298615373047, 4.354047932280479, 3.7892183180180292, 4.9636496941116457, -1.7856630822843349, 0.86416108685458326, -17.670460817927413, -10.314744048939055, 7.3973207504467204, 11.310122449566087, -7.0012835658321206, -7.2338183321331515, -5.1522911915584801, -33.623549275177297, -93.950748347298841, 82.616255878071172, 1249.2695734137344, 728.4038194884231, -2822.6768689275882, 397.85150159823706, 26666.274860226469, 1118.2132640961736, -9076.4400559658625, -3081.1066694335805, 284.6652898587414, 465.72794392086666, 193.36235004999409, 24.526337675320004, -3.1507841384785733, -1.8812165005783184, 6.9628905148897147, 18.113814308198211, 3.7834180501306891, -16.040469196891639, -20.012525822291416, 6.2313507558256083, 9.7740131156133696, 0.1390769027181136, 2.7720670784771526, 18.76945635314798, 7.2506028858092133, -12.318944408119592, 1.2207482283869953, 25.844521173618411, -4.435939812126878, -126.31904474729296, -189.92210588558356, 234.73611402062767, 770.97093894980162, -4944.5276302554457, -10095.4436331661, 9631.082450060534, 25390.170503473091, 2133.8618335997035, -174.99103969877373, 4452.6929959791023, 620.49539711803243, 514.99549805982349, 546.49872794031364, 218.31674915569133, -20.687109086504822, -41.926948021480328, 8.3348052170650853, 25.323206346284447, 0.86872374588174384, -17.959748575409694, -19.561354112987079, -1.4949158508675975, -5.5658589086089423, -4.0194858939287954, 20.161840527236293, 32.414130280804187, 2.8803824684767667, -21.191137754573067, 1.4918751600931279, 36.180920465642465, 4.5612631126941521, -28.684822585719061, -46.175546007129988, 457.86146922204938, 982.95511309135657, -848.38159326591563, -7213.0026112046844, 2752.5053486175875], "imag": [0.0, -3169.9451614941381, -2389.0092924747519, -2824.6185770767256, 47.140985329040632, -205.51829185355012, -383.71835019762682, -205.9732988135564, 11.332172552374439, 43.76909201728548, -7.034291101336307, -32.133345787281364, -1.2408409398708855, 22.626534078219475, 22.834188196398234, 5.8606054504390173, 0.0, -5.8606054504387375, -22.834188196398308, -22.626534078219454, 1.2408409398708751, 32.133345787281435, 7.0342911013362928, -43.769092017285352, -11.332172552374439, 205.97329881355589, 383.71835019762727, 205.51829185355027, -47.140985329040632, 2824.6185770767256, 2389.009292474751, 3169.9451614941386, 14687.463554763033, -1246.2254521233822, -13582.059524928778, -4205.001741520543, 1374.1061578688877, -137.33727593318653, -632.81134552884873, -154.70037614560013, 13.450507164884565, 15.193108572125329, -6.1542966587055341, -15.818788310912929, -2.909480569030046, 1.479970160345879, -1.5973907882613358, 1.5293212848264928, 18.21275880080945, -1.003899882219808, -18.30035720783934, -15.99060672422979, 0.33906699281555863, 8.403557604549265, -3.6955816316308372, 1.2265587756840484, 4.4918801658948704, -32.498332906337446, -252.78924650714879, 118.6015387642415, 1871.5173348139303, -2304.7799937689852, -14411.746659687838, -4213.8766814139526, 7014.7325605010174, 2247.44595388478, -16.760963274859961, 900.76474301933899, -5.1342500455989466, -420.94056280958415, -12.516743930999253, 93.660446148871657, -5.3964791524595173, -25.576180637452808, -8.2514109979697761, 17.318312851322737, 9.236462137217643, -22.012718711107286, -15.490166786860247, -4.834205749446653, 9.5628562714065293, 1.836849747935801, 5.3481684451070093, 16.065001056209898, 7.1604513809609767, -15.578970641484018, -6.7835303274441205, 29.197525074885235, 24.587565667273296, -80.302667778037872, -341.00518268197084, -165.09457453510524, 812.92907888826301, -1514.0868881615295, -6442.5930626817562, 2384.0282361623322, -10283.309463536394, -4592.9695519937077, 4024.534672295305, 1566.1446188979135, -577.97842695498832, -13.866559817282136, 303.84181615530144, 107.13271532249853, -4.4304590515519831, -24.335491476624799, -1.0691687945057899, 24.162065431216654, 4.7495715205351985, -14.018208973927269, -8.9506230152518427, -4.4638345370409525, -7.1842950536944761, -0.75483699139922611, 9.34037405707282, 25.690847574014661, 10.204720176161787, -11.674788778672609, -2.2174348022320634, 10.712979752882786, 4.1447690963328192, -30.289408767911031, -12.158067002051448, -76.336688904244483, -15.045419751305701, 825.0044509954804, 3127.7274260756976, -92.692661642821449, -6218.4941130018287, -3848.3727657836507, 693.87265018831545, 545.97208874512432, -92.125598598764668, 150.80594875272075, 31.835009702890954, -5.9283896106206289, 5.1749362811852588, 3.5428080098191677, 8.1813203788089979, 0.80238728202918663, -2.1553941232205127, 3.896876060708947, 5.7415452177174027, -2.4223203414509196, -12.192718147122756, -6.4431256169971434, 0.78101397437949727, -0.4709674045364774, 4.0135477523785683, 5.3424403453362856, 1.5176299437256986, -10.74330995836436, -14.68235074512339, 24.624343673414469, 118.67852190927127, 172.09305386209979, -99.157790391266047, 517.50332981617737, 2037.7393191154626, -1363.1746812874464, -339.74333242555031, 32.123918954310476, -283.55446630414355, -87.787271289656218, 401.24269480211609, 97.679749329289763, -120.49954302359174, -51.176060542512822, -2.5863965882294027, 13.214576791319574, 4.0359196374926878, -8.3066986443292503, -3.2190392651304429, 10.42730204701207, 6.8931399993642719, 0.50989762348064183, -1.9729622551402084, -2.7447920706561999, -6.4951794944364067, -8.7659237408433199, -2.5623445767069972, 9.4029551910696547, 6.0787635497373449, -8.7738681104802421, -10.356090763505474, 25.994421343462481, 47.534456712956128, 36.427418067214397, -132.28171420843677, -55.780171242651143, 550.58818821416037, 230.04212220540037, 2282.8157342153072, 1692.5764998210254, -618.40106666814791, -406.75082987636517, 268.61096451191207, 88.797660850068112, -17.813285237066509, -23.19378111787497, -5.993920933714092, 3.5911964041653288, -1.1492389141172172, -3.281418277923168, 1.0895777711511168, 3.5282533189728529, -1.1949811908258732, 1.894384229023907, 4.6241332834085442, 0.37075703258422543, -2.0346603770225924, -4.5067903456406357, -1.1470927861162812, 2.3634060343879923, 3.2590535483912988, 1.2412658338184401, -2.2389815887732318, -8.267796716016413, -35.26417469610022, -42.695700376724766, 163.41685001540142, 139.99054216726472, -634.39240892418218, -59.277692870412778, 635.10435435478166, 336.10950761267088, -20.987908495686451, 62.381440709915225, -5.2608500919337384, -7.9431228598947987, 17.719913727215761, 2.2765757875228916, -0.5781253977177655, -1.861000889502646, -1.1416693103444284, 2.4821587471930475, 1.9877494352069631, -3.6722851782283747, -3.348161983991842, -0.65436436680629395, 1.4913973744886961, 1.3020502991963898, 1.5364454784416322, 2.0332502155623371, 0.082811915307875697, -2.7287340233180468, -2.0624150870013023, 3.1666191865848514, 2.1277795836536475, -15.762070711071239, -31.080087158567022, 16.264563798793048, 168.22104098804192, 119.10647254618513, -340.95280202269214, -119.21079977674056, -524.16143614722125, -474.83791951425451, 238.16973599672059, 238.87620399289383, -30.950251690797295, -43.007655043750781, -7.0781110181685483, 4.2933368018010754, 2.128510229721456, -1.3556643805285902, 0.67118052098401426, 4.1580113773740086, 1.6924135574018535, -3.2368514600901537, -2.3674255865410236, -2.2397386036010594, -2.8392755347081424, -0.22727952120054792, 2.1660066162361877, 4.1257252023454543, 1.8555476250524485, -3.0110538491549583, -3.3997614112807475, -0.064441197381949922, 1.4400236898496321, -2.5651430892865172, -0.57406913069513732, 14.545275998521815, -21.097880653370396, -8.386658477188135, 246.29297742969297, 177.82681762874435, -29.410757783669329, 21.206487630199256, 82.341423257084315, 9.4629909259569072, -12.117042155983494, -8.2057292966872932, -5.3672622769763416, 0.7159440642377497, 0.69394420462213224, -0.39501642572828111, 0.57804318775345176, 1.8269742232979342, 0.10217887910111716, 0.16688705386232044, 1.9755117613475777, -0.94372823495475977, -2.4667123640612325, -1.3772827491468491, 0.74627343874194729, 1.5703957699483431, 1.3943774862563845, 0.51087952435755024, -0.57473339559817926, -2.0019592491226121, -0.94447858069522983, 4.1105720381539621, 9.8748960802998482, -5.0693062852843767, -52.44341015820585, -37.642264259816841, 117.83245857703734, 130.78419594725884, 169.61465367155833, 186.83060708175802, -35.974218698264572, -86.880281148446372, -5.2203740194539208, 16.971669187755321, 6.0698179812651247, 0.35231673872141245, -0.53044914356261097, -0.81632535007713047, -0.39583117800855089, -4.4385250403688277, -5.1472849145985213, 2.545092404453277, 5.0071357876878793, 2.743807769745191, 3.4897745997776024, -0.063125314946314764, -1.9440922443950184, -5.9326946820069502, -3.385188090942465, 3.6658395382201929, 4.0455837767151035, -0.6661551017179177, -2.2326980338070728, 1.6846667556373658, 3.8137132042051891, -1.9181620538698931, 1.6441956870289249, -6.1270500694313146, -76.595893205927055, -49.969516616017785, -7.9132321269474106, -11.568908095829089, -47.805112772715709, -13.830481688679152, 18.277275877397457, 14.698934402888547, 6.2184742035979967, 1.4890022076822711, -0.74744399004349582, 1.078974533533704, -0.78904970661953722, -8.2729456489475783, -5.409011823874466, 2.7622883519807897, 0.8473850486901422, 1.8128818460693508, 2.8420219491550718, 1.5362703897962247, -3.7595900673998903, -5.6022288243818803, -4.1625158390656765, 0.71295082461726678, 3.6372516960945322, 1.3208871209715871, -0.62400754176455042, -1.768358539761187, -3.6168192973638713, 3.6735963806245331, 31.275163257132462, 32.479329698147204, -39.759969700967346, -68.584232650917357, -57.469468975158698, -64.297371445934317, 0.20861011566533649, 34.25783205331058, 6.9534765415767215, -5.3793483456417883, 1.2524657598045081, 1.5450348766267965, 0.56608571170600441, 1.3866526144820828, -2.467818437504425, -0.23634501606433136, 6.3450244574570114, 0.9543505178876851, -4.984602859992024, -6.3381420012322005, -2.7435850611580781, -1.5807425386703018, 2.421504137076397, 6.8428975986621223, 5.3939316426610251, -2.3287200765196823, -4.7978450785431628, -0.63133403867009485, 1.1146429476849253, 0.7514356381637266, 2.2717048597800691, 5.5350475212285941, 5.1571773922734927, 9.2792987920179275, 21.682075132354747, 1.4867450129376456, -4.4700114725605324, -18.272390809448236, 16.714318324621598, 7.3089787270008628, -20.071959549384122, -7.0841774280620697, 3.2022160216960311, -0.077988270864014025, -1.5775612503840553, -4.3715375274672654, -2.1765426316142653, 13.260687049653976, 13.879467714343647, -1.8852486869718339, -10.527030755482089, -6.8369811071974125, -3.0333474188096656, -2.1407969562984661, 3.722272454853548, 7.6257272547055521, 10.117490783509389, -0.39109059001006397, -6.9982476982268125, -4.2960092579610025, 0.55901791170159865, 2.6155137759572247, 6.5895285486459425, 7.4061452615413605, -10.366283361455007, -35.34703723782264, -16.933453520111545, 16.224692124004221, -34.34332526355967, -71.738587010679367, -34.450969879654501, -6.2640778700882249, 11.746214635705909, 13.031958951769729, -0.3480472785242843, -3.9968553356395629, -3.964707435958017, -4.2096432311062548, 4.9158294568057652, 12.338227697160551, 3.5088489717994391, -9.6887588471648289, -3.3007173968474173, 1.3223986051066356, 3.9779056054352555, 5.2139034331477543, 0.73966749617948313, -3.1538649748494341, -5.201358311154781, 1.2046804216345655, 2.9426249963390902, 0.16125203808628796, -0.12580690156457183, -1.0212362026563724, -6.277158135649886, -5.6679546723264744, 4.2381986446151707, 5.7560371617010828, 18.621646756873353, 24.734309444721209, -36.387091300098106, -10.759792351985398, -2.2461784763603254, 3.6933656200181786, 20.866503857704814, 3.7918232583171383, -8.2103085682208885, -3.9258378390443029, 0.83382202471681166, 4.801181266459511, 6.1897358407630447, -4.7613942589703724, -14.056893094185043, -2.2289578077004246, 10.245900399003714, 12.011271759567334, 7.3710550588087713, 3.5515726304902269, 1.2929923686914595, -7.4124476338006691, -7.5787947999111838, 1.7154740370529804, 9.3123854476054735, 4.9777565316787626, -0.24109318982965802, -5.1766732320109883, -9.3092191729240525, -5.246693773893865, 10.274800595678272, 28.322088715789157, 27.586929135138202, -13.506737972920812, 0.0, 72.992093909712537, 40.674766306359388, 3.6677612059140889, -7.0101784555215705, -11.074353780690299, -3.5600519087446321, 2.4941865000982566, 3.5007885216085395, 2.2952423730960096, -1.6579656325825838, -10.397334640078137, -8.5183394179138396, 4.679962930220257, 8.9265575080577193, 4.8985021447705659, 0.0, -4.8985021447705712, -8.9265575080577282, -4.6799629302202739, 8.5183394179138361, 10.397334640078139, 1.6579656325825878, -2.2952423730960114, -3.5007885216085395, -2.4941865000982615, 3.5600519087446361, 11.074353780690284, 7.010178455521566, -3.6677612059140743, -40.674766306359437, -72.992093909712509, 36.387091300098248, 13.506737972920931, -27.586929135138188, -28.322088715789224, -10.274800595678252, 5.2466937738938775, 9.3092191729240525, 5.1766732320109785, 0.24109318982965933, -4.9777565316787626, -9.3123854476054682, -1.7154740370529937, 7.5787947999111918, 7.4124476338006797, -1.2929923686914602, -3.5515726304902286, -7.3710550588087731, -12.011271759567332, -10.245900399003729, 2.2289578077004006, 14.05689309418503, 4.7613942589703955, -6.1897358407630483, -4.8011812664595261, -0.83382202471681333, 3.9258378390442905, 8.2103085682208921, -3.7918232583171019, -20.866503857704799, -3.6933656200181462, 2.2461784763603472, 10.759792351985324, 34.343325263559734, -24.734309444721188, -18.621646756873407, -5.7560371617010961, -4.2381986446151565, 5.6679546723264433, 6.2771581356498745, 1.0212362026563664, 0.12580690156457094, -0.16125203808628427, -2.9426249963390938, -1.2046804216345817, 5.2013583111547899, 3.1538649748494616, -0.73966749617946026, -5.2139034331477525, -3.9779056054352657, -1.322398605106651, 3.3007173968474182, 9.6887588471648343, -3.5088489717994329, -12.338227697160564, -4.9158294568057723, 4.2096432311062539, 3.9647074359580197, 3.9968553356395535, 0.34804727852429029, -13.031958951769711, -11.746214635705918, 6.2640778700882196, 34.450969879654494, 71.738587010679424, 4.4700114725605502, -16.224692124004207, 16.933453520111492, 35.34703723782269, 10.366283361455015, -7.4061452615413437, -6.5895285486459567, -2.615513775957226, -0.55901791170159942, 4.2960092579609945, 6.9982476982268116, 0.39109059001006968, -10.117490783509375, -7.6257272547055521, -3.7222724548535622, 2.1407969562984639, 3.0333474188096563, 6.8369811071973849, 10.527030755482111, 1.8852486869718446, -13.879467714343662, -13.260687049653979, 2.1765426316142595, 4.3715375274672708, 1.5775612503840555, 0.077988270864025142, -3.2022160216960267, 7.0841774280620511, 20.071959549384133, -7.3089787270008086, -16.714318324621601, 18.272390809448193, 57.469468975158712, -1.4867450129376421, -21.682075132354715, -9.2792987920179293, -5.1571773922734714, -5.5350475212285986, -2.2717048597800669, -0.75143563816372472, -1.114642947684924, 0.63133403867008997, 4.7978450785431628, 2.3287200765196983, -5.3939316426610153, -6.842897598662133, -2.4215041370764028, 1.5807425386703056, 2.7435850611580817, 6.3381420012321907, 4.9846028599920196, -0.95435051788768221, -6.3450244574570167, 0.23634501606432906, 2.4678184375044308, -1.3866526144820814, -0.56608571170600686, -1.5450348766267858, -1.2524657598045066, 5.3793483456417848, -6.9534765415767081, -34.25783205331058, -0.20861011566532392, 64.297371445934417, 7.9132321269475003, 68.584232650917386, 39.759969700967275, -32.479329698147232, -31.275163257132508, -3.6735963806245575, 3.616819297363866, 1.7683585397611854, 0.6240075417645492, -1.3208871209715913, -3.6372516960945265, -0.71295082461726456, 4.1625158390656667, 5.6022288243818847, 3.7595900673999001, -1.5362703897962169, -2.842021949155066, -1.8128818460693434, -0.8473850486901302, -2.7622883519807888, 5.4090118238744633, 8.2729456489475819, 0.78904970661953955, -1.0789745335337066, 0.74744399004349849, -1.4890022076822718, -6.2184742035979834, -14.69893440288851, -18.277275877397457, 13.830481688678995, 47.805112772715752, 11.568908095829199, -169.61465367155867, 49.969516616017778, 76.595893205927254, 6.1270500694312791, -1.6441956870289614, 1.918162053869898, -3.8137132042051767, -1.6846667556373722, 2.2326980338070745, 0.66615510171792158, -4.0455837767150955, -3.6658395382201951, 3.3851880909424605, 5.9326946820069546, 1.9440922443950184, 0.063125314946314778, -3.4897745997776015, -2.7438077697451946, -5.0071357876878766, -2.5450924044532854, 5.1472849145985169, 4.4385250403688321, 0.39583117800854778, 0.81632535007713181, 0.53044914356261075, -0.35231673872140901, -6.0698179812651212, -16.971669187755335, 5.2203740194539012, 86.880281148446528, 35.974218698264636, -186.83060708175819, 29.41075778366919, -130.78419594725855, -117.83245857703733, 37.64226425981672, 52.443410158205879, 5.0693062852844104, -9.8748960802998642, -4.1105720381539701, 0.94447858069523327, 2.0019592491226157, 0.57473339559817749, -0.5108795243575508, -1.3943774862563805, -1.570395769948336, -0.74627343874194474, 1.3772827491468478, 2.4667123640612241, 0.94372823495475699, -1.9755117613475803, -0.16688705386232, -0.10217887910111442, -1.8269742232979298, -0.57804318775345009, 0.39501642572828077, -0.69394420462213291, -0.71594406423774049, 5.367262276976339, 8.2057292966872506, 12.117042155983503, -9.4629909259566443, -82.341423257084145, -21.206487630199604, 524.16143614722125, -177.82681762874424, -246.29297742969288, 8.386658477188103, 21.097880653370403, -14.545275998521824, 0.57406913069513366, 2.5651430892865226, -1.4400236898496321, 0.064441197381950838, 3.3997614112807506, 3.0110538491549557, -1.8555476250524514, -4.1257252023454569, -2.1660066162361895, 0.22727952120054773, 2.8392755347081424, 2.2397386036010616, 2.3674255865410174, 3.236851460090151, -1.6924135574018513, -4.1580113773740104, -0.67118052098401537, 1.3556643805285893, -2.128510229721456, -4.2933368018010798, 7.0781110181685527, 43.007655043750773, 30.950251690797295, -238.87620399289392, -238.16973599672059, 474.83791951425417, -635.10435435478075, 119.21079977674036, 340.95280202269191, -119.10647254618499, -168.22104098804189, -16.264563798793112, 31.080087158567054, 15.762070711071249, -2.1277795836536488, -3.1666191865848456, 2.0624150870013005, 2.7287340233180508, -0.082811915307879028, -2.0332502155623482, -1.5364454784416388, -1.3020502991963789, -1.4913973744886957, 0.65436436680629262, 3.3481619839918371, 3.6722851782283725, -1.987749435206966, -2.4821587471930564, 1.1416693103444246, 1.8610008895026517, 0.5781253977177665, -2.2765757875228969, -17.719913727215747, 7.9431228598948822, 5.2608500919337864, -62.381440709915822, 20.987908495685961, -336.10950761266997, -2282.8157342153086, 59.27769287041221, 634.3924089241824, -139.99054216726466, -163.41685001540142, 42.695700376724787, 35.264174696100213, 8.2677967160164005, 2.2389815887732354, -1.2412658338184486, -3.2590535483912864, -2.3634060343879861, 1.1470927861162765, 4.5067903456406286, 2.0346603770225951, -0.37075703258422554, -4.6241332834085505, -1.8943842290239064, 1.1949811908258721, -3.5282533189728493, -1.0895777711511203, 3.281418277923172, 1.1492389141172139, -3.591196404165319, 5.9939209337140893, 23.193781117874966, 17.813285237066506, -88.797660850068027, -268.61096451191219, 406.75082987636472, 618.40106666814768, -1692.5764998210257, 339.74333242554815, -230.04212220540018, -550.58818821415935, 55.780171242650994, 132.2817142084364, -36.427418067214319, -47.534456712956064, -25.994421343462484, 10.356090763505458, 8.773868110480235, -6.0787635497373476, -9.4029551910696316, 2.5623445767070061, 8.7659237408433039, 6.4951794944364281, 2.7447920706561946, 1.972962255140204, -0.50989762348062517, -6.8931399993642568, -10.427302047012086, 3.2190392651304447, 8.3066986443292699, -4.0359196374926896, -13.214576791319564, 2.5863965882294058, 51.176060542512751, 120.49954302359184, -97.679749329289564, -401.24269480211632, 87.787271289656246, 283.554466304144, -32.12391895431216, 6218.4941130018287, 1363.174681287448, -2037.7393191154631, -517.5033298161776, 99.157790391266019, -172.09305386210005, -118.67852190927132, -24.624343673414536, 14.682350745123385, 10.743309958364414, -1.5176299437256995, -5.3424403453363087, -4.013547752378579, 0.47096740453648078, -0.7810139743795077, 6.4431256169971372, 12.192718147122749, 2.4223203414509316, -5.7415452177173938, -3.8968760607089528, 2.1553941232205212, -0.80238728202918486, -8.1813203788090068, -3.5428080098191872, -5.1749362811852562, 5.9283896106206555, -31.835009702890844, -150.80594875272081, 92.125598598764682, -545.97208874512432, -693.87265018831545, 3848.372765783648, 10283.309463536396, 92.692661642825414, -3127.7274260757022, -825.00445099548233, 15.045419751306099, 76.336688904244284, 12.158067002051251, 30.289408767911102, -4.1447690963328059, -10.712979752882784, 2.2174348022320558, 11.674788778672612, -10.204720176161779, -25.690847574014658, -9.3403740570728662, 0.75483699139922822, 7.1842950536944734, 4.4638345370409516, 8.9506230152518249, 14.018208973927262, -4.7495715205351878, -24.162065431216647, 1.0691687945057857, 24.335491476624739, 4.4304590515519813, -107.13271532249837, -303.84181615530116, 13.866559817282113, 577.97842695498844, -1566.1446188979132, -4024.5346722953059, 4592.969551993704, -7014.7325605010174, -2384.0282361623326, 6442.5930626817571, 1514.086888161532, -812.92907888826267, 165.09457453510592, 341.00518268197106, 80.302667778037787, -24.587565667273314, -29.197525074885242, 6.783530327444133, 15.578970641484096, -7.1604513809610006, -16.065001056209955, -5.3481684451070297, -1.8368497479357557, -9.5628562714065364, 4.8342057494466477, 15.490166786860224, 22.012718711107244, -9.236462137217643, -17.318312851322709, 8.2514109979697903, 25.57618063745285, 5.3964791524595155, -93.660446148871785, 12.516743930999144, 420.94056280958409, 5.1342500455991793, -900.76474301933945, 16.760963274859485, -2247.4459538847777, -14687.463554763033, 4213.8766814139472, 14411.746659687837, 2304.7799937689902, -1871.5173348139317, -118.60153876424121, 252.7892465071493, 32.498332906337396, -4.4918801658948837, -1.2265587756841234, 3.6955816316309309, -8.4035576045492331, -0.33906699281557884, 15.990606724229716, 18.300357207839266, 1.0038998822198608, -18.212758800809453, -1.5293212848264821, 1.5973907882613065, -1.4799701603458557, 2.909480569030038, 15.818788310912904, 6.1542966587054897, -15.193108572125247, -13.450507164884552, 154.70037614559999, 632.81134552884851, 137.3372759331867, -1374.1061578688873, 4205.0017415205384, 13582.05952492878, 1246.225452123387]}};

/*
 * MOSSE correlation filter
 *
 * Optional parameters to constructor:
 *   drawResponse {canvasElement} : draws the correlation filter output on the given canvas element (default is none)
 *   psrThreshold {number} : peak-to-sidelobe-ratio threshold to use when updating filter while tracking (default is 10)
 *   eta {number} : adjusts how much new input affects the mosse filter, when updating filter while tracking
 *     number should be between 0 and 1 (default is 0.1)
 *   convertToGrayscale {boolean} : whether to convert canvas output to grayscale (default is true)
 *     if this is set to false, we assume all channels are equal and only grab values from red channel
 *
 * @author auduno / github.com/auduno
 */

function mosseFilter(params) {
    
    var _filter, _top, _bottom;
    var _fft;
    var _w,_h;
    var _im_part;
    var _arrlen;
    var _cc;
    var _image_array;
    
    this.psr_prev = undefined;
    this.peak_prev = undefined;
    var updateable = false;
    
    if (!params) params = {};
    // setup of canvas for drawing responses, if given
    if (params.drawResponse === undefined) {
        params.drawResponse = false;
    } else {
        if (params.drawResponse.tagName != 'CANVAS') {
            params.drawResponse = false;
        } else {
            var responseContext = params.drawResponse.getContext('2d');
        }
    }
    if (params.psrThreshold === undefined) params.psrThreshold = 10;
    if (params.eta === undefined) params.eta = 0.10;
    if (params.convertToGrayscale === undefined) params.convertToGrayscale = true;
    
    this.load = function(filter) {
        // initialize filter width and height
        _w = filter.width;
        _h = filter.height;
        _arrlen = _w*_h;
        _filter = [filter.real, filter.imag];
        // handling top and bottom when they're not present
        if (filter.top && filter.bottom) {
          updateable = true;
          _top = [filter.top.real, filter.top.imag];
          _bottom = [filter.bottom.real, filter.bottom.imag];
        }
        
        // initialize fft to given width
        _fft = new FFT();
        _fft.init(filter.width);
        
        // set up temporary variables
        if(typeof Float64Array !== 'undefined') {
            _im_part = new Float64Array(_arrlen);
            _image_array = new Float64Array(_arrlen);
        } else {
            _im_part = new Array(_arrlen);
            _image_array = new Array(_arrlen);
        }
        var canvas = document.createElement("canvas");
        canvas.setAttribute('width', _w);
        canvas.setAttribute('height', _h);
        _cc = canvas.getContext('2d');
    };
    
    this.init = function(w,h) {
        // initialize filter width and height for a blank filter
        _w = w;
        _h = h;
        _arrlen = _w*_h;
        
        _filter = [[],[]];
        _top = [[],[]];
        _bottom = [[],[]];
        for (var i = 0;i < _arrlen;i++) {
            _filter[0][i] = 0;
            _filter[1][i] = 0;
            _top[0][i] = 0;
            _top[1][i] = 0;
            _bottom[0][i] = 0;
            _bottom[1][i] = 0;
        }
        updateable = true;
        
        // initialize fft to given width
        _fft = new FFT();
        _fft.init(w);
        
        // set up temporary variables
        if(typeof Float64Array !== 'undefined') {
            _im_part = new Float64Array(_arrlen);
        } else {
            _im_part = new Array(_arrlen);
        }
        var canvas = document.createElement("canvas");
        canvas.setAttribute('width', _w);
        canvas.setAttribute('height', _h);
        _cc = canvas.getContext('2d');
    };
    
    // fft function
    this.fft = function(array) {
        // not in-place
        
        var cn = new Array(_arrlen);
        for (var i = 0;i < _arrlen;i++) {
          cn[i] = 0.0;
        }
        
        _fft.fft2d(array,cn);
        return [array, cn];
    };
    
    // fft function
    this.fft_inplace = function(array) {
        // in-place
        
        for (var i = 0;i < _arrlen;i++) {
          _im_part[i] = 0.0;
        }
        
        _fft.fft2d(array,_im_part);
        return [array, _im_part];
    };
    
    this.ifft = function(rn, cn) {
        // in-place
        _fft.ifft2d(rn, cn);
        return rn;
    };

    // peak to sidelobe ratio function (optional)
    this.psr = function(array) {
        // proper
        var sum = 0;
        var max = 0;
        var maxpos = [0, 0];
        var sdo = 0;
        var val;
        for (var x = 0;x < _w;x++) {
            for (var y = 0;y < _h;y++) {
                val = array[(y*_w)+x];
                sum += val;
                sdo += (val*val);
                if (max < val) {
                    max = val;
                    maxpos = [x,y];
                }
            }
        }
        
        // subtract values around peak
        for (var x = -5;x < 6;x++) {
            for (var y = -5;y < 6;y++) {
                if (Math.sqrt(x*x+y*y) < 5) {
                    val = array[((maxpos[1]+y)*_w)+(maxpos[0]+x)];
                    sdo -= (val*val);
                    sum -= val;
                }
            }
        }
        
        var mean = sum/array.length;
        var sd = Math.sqrt((sdo/array.length)-(mean*mean));
        
        // get mean/variance of output around peak
        var psr = (max-mean)/sd;
        return psr;
    };
    
    this.getResponse = function(imageData) {
        // in-place
        
        // preprocess
        var prepImage = preprocess(imageData);
        prepImage = cosine_window(prepImage);
        
        // filter
        var res = this.fft_inplace(prepImage);
        
        // elementwise multiplication with filter
        complex_mult_inplace(res, _filter);
        
        // do inverse 2d fft
        var filtered = this.ifft(res[0],res[1]);
        return filtered;
    };
    
    this.track = function(input, left, top, width, height, updateFilter, gaussianPrior, calcPSR) {
        // finds position of filter in input image
        
        if (!_filter) {
            console.log("Mosse-filter needs to be initialized or trained before starting tracking.");
            return false;
        }
        
        if (input.tagName == "VIDEO" || input.tagName == "IMG") {
            // scale selection according to original source image
            var videoLeft = Math.round((left/input.width)*input.videoWidth);
            var videoTop = Math.round((top/input.height)*input.videoHeight);
            var videoWidth = Math.round((width/input.width)*input.videoWidth);
            var videoHeight = Math.round((height/input.height)*input.videoHeight);
            _cc.drawImage(input, videoLeft, videoTop, videoWidth, videoHeight, 0, 0, _w, _h);
        } else if (input.tagName == "CANVAS") {
            _cc.drawImage(input, left, top, width, height, 0, 0, _w, _h);
        }
        
        var image = _cc.getImageData(0,0,_w,_h);
        var id = image.data;
        
        if (params.convertToGrayscale) {
            // convert to grayscale
            for (var i = 0;i < _arrlen;i++) {
                _image_array[i] = id[(4*i)]*0.3;
                _image_array[i] += id[(4*i)+1]*0.59;
                _image_array[i] += id[(4*i)+2]*0.11;
            } 
        } else {
            // use only one channel
            for (var i = 0;i < _arrlen;i++) {
                _image_array[i] = id[(4*i)];
            } 
        }
        
        // preprocess
        var prepImage = preprocess(_image_array);
        prepImage = cosine_window(prepImage);
        
        // filter
        var res = this.fft_inplace(prepImage);
        // elementwise multiplication with filter
        var nures = complex_mult(res, _filter);
        // do inverse 2d fft
        var filtered = this.ifft(nures[0],nures[1]);
        
        // find max and min
        var max = 0;
        var min = 0;
        var maxpos = [0, 0];
        
        //method using centered gaussian prior
        if (gaussianPrior) {
            var prior, dx, dy;
            var variance = 128;
            for (var x = 0;x < _w;x++) {
                for (var y = 0;y < _h;y++) {
                    dx = x - _w/2;
                    dy = y - _h/2;
                    prior = Math.exp(-0.5*((dx*dx)+(dy*dy))/variance);
                    if ((filtered[(y*_w)+x]*prior) > max) {
                        max = filtered[(y*_w)+x]*prior;
                        maxpos = [x,y];
                    }
                    if (filtered[(y*_w)+x] < min) {
                        min = filtered[(y*_w)+x];
                    }
                }
            }
        } else {
            for (var x = 0;x < _w;x++) {
                for (var y = 0;y < _h;y++) {
                    if (filtered[(y*_w)+x] > max) {
                        max = filtered[(y*_w)+x];
                        maxpos = [x,y];
                    }
                    if (filtered[(y*_w)+x] < min) {
                        min = filtered[(y*_w)+x];
                    }
                }
            }
        }
        this.peak_prev = max;
        
        if (params.drawResponse) {
            // draw response
            var diff = max-min;
            var dc = document.createElement('canvas');
            dc.setAttribute('width', 32);
            dc.setAttribute('height', 32);
            var dcc = dc.getContext('2d');
            var psci = dcc.createImageData(32, 32);
            var pscidata = psci.data;
            for (var j = 0;j < 32*32;j++) {
                //draw with priors
                //var val = filtered[j]*Math.exp(-0.5*(((j%_w - _w/2)*(j%_w -_w/2))+((Math.floor(j/_h)-(_h/2))*(Math.floor(j/_h)-(_h/2))))/128);
                var val = filtered[j];
                val = Math.round((val+Math.abs(min))*(255/diff));
                pscidata[j*4] = val;
                pscidata[(j*4)+1] = val;
                pscidata[(j*4)+2] = val;
                pscidata[(j*4)+3] = 255;
            }
            dcc.putImageData(psci, 0, 0);
            responseContext.drawImage(dc, left, top, width, width);
        }
        
        if (calcPSR) {
          this.psr_prev = this.psr(filtered);
        }
        
        if (updateFilter) {
            if (!updateable) {
                console.log("The loaded filter does not support updating. Ignoring parameter 'updateFilter'.");
            } else {
                if (calcPSR) {
                  var psr = this.psr_prev;
                } else {
                  var psr = this.psr(filtered);
                }
                
                if (psr > params.psrThreshold) {
                    // create target
                    var target = [];
                    var nux = maxpos[0];
                    var nuy = maxpos[1];
                    for (var x = 0;x < _w;x++) {
                        for (var y = 0;y < _h;y++) {
                            target[(y*_w)+x] = Math.exp(-(((x-nux)*(x-nux))+((y-nuy)*(y-nuy)))/(2*2));
                        }
                    }
                    
                    //fft target
                    target = this.fft(target);
                    
                    // create filter
                    var res_conj = complex_conj(res);
                    var fuTop = complex_mult(target,res_conj);
                    var fuBottom = complex_mult(res,res_conj);
                    
                    // add up
                    var eta = params.eta;
                    for (var i = 0;i < _arrlen;i++) {
                        _top[0][i] = eta*fuTop[0][i] + (1-eta)*_top[0][i];
                        _top[1][i] = eta*fuTop[1][i] + (1-eta)*_top[1][i];
                        _bottom[0][i] = eta*fuBottom[0][i] + (1-eta)*_bottom[0][i];
                        _bottom[1][i] = eta*fuBottom[1][i] + (1-eta)*_bottom[1][i];
                    }
                    
                    _filter = complex_div(_top,_bottom);
                }
            }
        }
        
        /*if (psr < 5) {
          maxpos = [_w/2,_h/2]; 
        }*/
        
        maxpos[0] = maxpos[0]*(width/_w);
        maxpos[1] = maxpos[1]*(width/_h);
        
        // check if output is strong enough
        // if not, return false?
        if (max < 0) {
          return false;
        } else {
          return maxpos;
        }
    };
    
    this.train = function(input, left, top, width, height) {
        
        if (!updateable) {
          console.log("The loaded filter does not support updating. Unable to do training.");
          return false;
        }
        
        if (input.tagName == "VIDEO" || input.tagName == "IMG") {
            // scale selection according to original source image
            var videoLeft = Math.round((left/input.width)*input.videoWidth);
            var videoTop = Math.round((top/input.height)*input.videoHeight);
            var videoWidth = Math.round((width/input.width)*input.videoWidth);
            var videoHeight = Math.round((height/input.height)*input.videoHeight);
            _cc.drawImage(input, videoLeft, videoTop, videoWidth, videoHeight, 0, 0, _w, _h);
        } else if (input.tagName == "CANVAS") {
            _cc.drawImage(input, left, top, width, height, 0, 0, _w, _h);
        }
        
        var image = _cc.getImageData(0,0,_w,_h);
        var id = image.data;
         
        // convert to grayscale
        for (var i = 0;i < _arrlen;i++) {
            _image_array[i] = id[(4*i)]*0.3;
            _image_array[i] += id[(4*i)+1]*0.59;
            _image_array[i] += id[(4*i)+2]*0.11;
        }
        
        // preprocess
        var prepImage = preprocess(_image_array);
        prepImage = cosine_window(prepImage);
        
        // create target
        var target = [];
        var nux = _w/2;
        var nuy = _h/2;
        for (var x = 0;x < _w;x++) {
            for (var y = 0;y < _h;y++) {
                target[(y*_w)+x] = Math.exp(-(((x-nux)*(x-nux))+((y-nuy)*(y-nuy)))/(2*2));
            }
        }
        
        //fft target
        target = this.fft(target);
        
        // filter
        var res = this.fft(prepImage);
        // create filter
        var res_conj = complex_conj(res);
        var fuTop = complex_mult(target,res_conj);
        var fuBottom = complex_mult(res,res_conj);
        
        // add up
        var eta = params.eta;
        for (var i = 0;i < _arrlen;i++) {
            _top[0][i] = eta*fuTop[0][i] + (1-eta)*_top[0][i];
            _top[1][i] = eta*fuTop[1][i] + (1-eta)*_top[1][i];
            _bottom[0][i] = eta*fuBottom[0][i] + (1-eta)*_bottom[0][i];
            _bottom[1][i] = eta*fuBottom[1][i] + (1-eta)*_bottom[1][i];
        }
        
        _filter = complex_div(_top,_bottom);
        
        return true;
    };
    
    var preprocess = function(array) {
        // in-place
        
        // log adjusting
        for (var i = 0;i < _arrlen;i++) {
          array[i] = Math.log(array[i]+1);
        }
        
        // normalize to mean 0 and norm 1
        var mean = 0;
        for (var i = 0;i < _arrlen;i++) {
          mean += array[i];
        }
        mean /= _arrlen;
        
        for (var i = 0;i < _arrlen;i++) {
          array[i] -= mean;
        }
        var norm = 0.0;
        for (var i = 0;i < _arrlen;i++) {
          norm += (array[i]*array[i]);
        }
        norm = Math.sqrt(norm);
        if (norm !== 0) {
            for (var i = 0;i < _arrlen;i++) {
              array[i] /= norm;
            }
        }
        
        return array;
    };
    
    var cosine_window = function(array) {
        // calculate rect cosine window (in-place)
        var pos = 0;
        for (var i = 0;i < _w;i++) {
            for (var j = 0;j < _h;j++) {
                //pos = (i%_w)+(j*_w);
                var cww = Math.sin((Math.PI*i)/(_w-1));
                var cwh = Math.sin((Math.PI*j)/(_h-1));
                array[pos] = Math.min(cww,cwh)*array[pos];
                pos++;
            }
        }
        
        return array;
    };
    
    var complex_mult = function(cn1, cn2) {
        // not in-place
        var re_part = new Array(_w);
        var im_part = new Array(_w);
        var nucn = [re_part, im_part];
        for (var r = 0;r < _arrlen;r++) {
            nucn[0][r] = (cn1[0][r]*cn2[0][r]) - (cn1[1][r]*cn2[1][r]);
            nucn[1][r] = (cn1[0][r]*cn2[1][r]) + (cn1[1][r]*cn2[0][r]);
        }
        return nucn;
    };
    
    var complex_mult_inplace = function(cn1, cn2) {
        // in-place
        var temp1, temp2;
        for (var r = 0;r < _arrlen;r++) {
            temp1 = (cn1[0][r]*cn2[0][r]) - (cn1[1][r]*cn2[1][r]);
            temp2 = (cn1[0][r]*cn2[1][r]) + (cn1[1][r]*cn2[0][r]);
            cn1[0][r] = temp1;
            cn1[1][r] = temp2;
        }
    };
    
    var complex_conj = function(cn) {
        // not in-place (TODO)
        var nucn = [[],[]];
        for (var i = 0;i < _arrlen;i++) {
            nucn[0][i] = cn[0][i];
            nucn[1][i] = -cn[1][i];
        }
        return nucn;
    };
    
    var complex_div = function(cn1, cn2) {
        // not in-place (TODO)
        var nucn = [[],[]];
        for (var r = 0;r < _arrlen;r++) {
            nucn[0][r] = ((cn1[0][r]*cn2[0][r])+(cn1[1][r]*cn2[1][r])) / ((cn2[0][r]*cn2[0][r]) + (cn2[1][r]*cn2[1][r]));
            nucn[1][r] = ((cn1[1][r]*cn2[0][r])-(cn1[0][r]*cn2[1][r])) / ((cn2[0][r]*cn2[0][r]) + (cn2[1][r]*cn2[1][r]));
        }
        return nucn;
    };
}

var mosse = {
    mosseFilter : mosseFilter,
    filters : {
        left_eye_filter : left_eye_filter,
        right_eye_filter : right_eye_filter,
        mouth_filter : mouth_filter,
        nose_filter : nose_filter,
        face_filter : face_filter
    }
};

var jsfeat_1 = createCommonjsModule(function (module) {
/**
 * @author Eugene Zatepyakin / http://inspirit.ru/
 */

// namespace ?
var jsfeat = jsfeat || { REVISION: 'ALPHA' };

// PATCHED IN to avoid loading the jsfeat library twice
window.jsfeat = jsfeat;

/**
 * @author Eugene Zatepyakin / http://inspirit.ru/
 */

(function(global) {
    "use strict";
    //

    // CONSTANTS
    var EPSILON = 0.0000001192092896;
    var FLT_MIN = 1E-37;

    // implementation from CCV project
    // currently working only with u8,s32,f32
    var U8_t = 0x0100,
        S32_t = 0x0200,
        F32_t = 0x0400,
        S64_t = 0x0800,
        F64_t = 0x1000;

    var C1_t = 0x01,
        C2_t = 0x02,
        C3_t = 0x03,
        C4_t = 0x04;

    var _data_type_size = new Int32Array([ -1, 1, 4, -1, 4, -1, -1, -1, 8, -1, -1, -1, -1, -1, -1, -1, 8 ]);

    var get_data_type = (function () {
        return function(type) {
            return (type & 0xFF00);
        }
    })();

    var get_channel = (function () {
        return function(type) {
            return (type & 0xFF);
        }
    })();

    var get_data_type_size = (function () {
        return function(type) {
            return _data_type_size[(type & 0xFF00) >> 8];
        }
    })();

    // color conversion
    var COLOR_RGBA2GRAY = 0;
    var COLOR_RGB2GRAY = 1;
    var COLOR_BGRA2GRAY = 2;
    var COLOR_BGR2GRAY = 3;

    // box blur option
    var BOX_BLUR_NOSCALE = 0x01;
    // svd options
    var SVD_U_T = 0x01;
    var SVD_V_T = 0x02;

    var data_t = (function () {
        function data_t(size_in_bytes, buffer) {
            // we need align size to multiple of 8
            this.size = ((size_in_bytes + 7) | 0) & -8;
            if (typeof buffer === "undefined") { 
                this.buffer = new ArrayBuffer(this.size);
            } else {
                this.buffer = buffer;
                this.size = buffer.length;
            }
            this.u8 = new Uint8Array(this.buffer);
            this.i32 = new Int32Array(this.buffer);
            this.f32 = new Float32Array(this.buffer);
            this.f64 = new Float64Array(this.buffer);
        }
        return data_t;
    })();

    var matrix_t = (function () {
        // columns, rows, data_type
        function matrix_t(c, r, data_type, data_buffer) {
            this.type = get_data_type(data_type)|0;
            this.channel = get_channel(data_type)|0;
            this.cols = c|0;
            this.rows = r|0;
            if (typeof data_buffer === "undefined") { 
                this.allocate();
            } else {
                this.buffer = data_buffer;
                // data user asked for
                this.data = this.type&U8_t ? this.buffer.u8 : (this.type&S32_t ? this.buffer.i32 : (this.type&F32_t ? this.buffer.f32 : this.buffer.f64));
            }
        }
        matrix_t.prototype.allocate = function() {
            // clear references
            delete this.data;
            delete this.buffer;
            //
            this.buffer = new data_t((this.cols * get_data_type_size(this.type) * this.channel) * this.rows);
            this.data = this.type&U8_t ? this.buffer.u8 : (this.type&S32_t ? this.buffer.i32 : (this.type&F32_t ? this.buffer.f32 : this.buffer.f64));
        };
        matrix_t.prototype.copy_to = function(other) {
            var od = other.data, td = this.data;
            var i = 0, n = (this.cols*this.rows*this.channel)|0;
            for(; i < n-4; i+=4) {
                od[i] = td[i];
                od[i+1] = td[i+1];
                od[i+2] = td[i+2];
                od[i+3] = td[i+3];
            }
            for(; i < n; ++i) {
                od[i] = td[i];
            }
        };
        matrix_t.prototype.resize = function(c, r, ch) {
            if (typeof ch === "undefined") { ch = this.channel; }
            // relocate buffer only if new size doesnt fit
            var new_size = (c * get_data_type_size(this.type) * ch) * r;
            if(new_size > this.buffer.size) {
                this.cols = c;
                this.rows = r;
                this.channel = ch;
                this.allocate();
            } else {
                this.cols = c;
                this.rows = r;
                this.channel = ch;
            }
        };

        return matrix_t;
    })();

    var pyramid_t = (function () {

        function pyramid_t(levels) {
            this.levels = levels|0;
            this.data = new Array(levels);
            this.pyrdown = jsfeat.imgproc.pyrdown;
        }

        pyramid_t.prototype.allocate = function(start_w, start_h, data_type) {
            var i = this.levels;
            while(--i >= 0) {
                this.data[i] = new matrix_t(start_w >> i, start_h >> i, data_type);
            }
        };

        pyramid_t.prototype.build = function(input, skip_first_level) {
            if (typeof skip_first_level === "undefined") { skip_first_level = true; }
            // just copy data to first level
            var i = 2, a = input, b = this.data[0];
            if(!skip_first_level) {
                var j=input.cols*input.rows;
                while(--j >= 0) {
                    b.data[j] = input.data[j];
                }
            }
            b = this.data[1];
            this.pyrdown(a, b);
            for(; i < this.levels; ++i) {
                a = b;
                b = this.data[i];
                this.pyrdown(a, b);
            }
        };

        return pyramid_t;
    })();

    var keypoint_t = (function () {
        function keypoint_t(x,y,score,level,angle) {
            if (typeof x === "undefined") { x=0; }
            if (typeof y === "undefined") { y=0; }
            if (typeof score === "undefined") { score=0; }
            if (typeof level === "undefined") { level=0; }
            if (typeof angle === "undefined") { angle=-1.0; }

            this.x = x;
            this.y = y;
            this.score = score;
            this.level = level;
            this.angle = angle;
        }
        return keypoint_t;
    })();


    // data types
    global.U8_t = U8_t;
    global.S32_t = S32_t;
    global.F32_t = F32_t;
    global.S64_t = S64_t;
    global.F64_t = F64_t;
    // data channels
    global.C1_t = C1_t;
    global.C2_t = C2_t;
    global.C3_t = C3_t;
    global.C4_t = C4_t;

    // popular formats
    global.U8C1_t = U8_t | C1_t;
    global.U8C3_t = U8_t | C3_t;
    global.U8C4_t = U8_t | C4_t;

    global.F32C1_t = F32_t | C1_t;
    global.F32C2_t = F32_t | C2_t;
    global.S32C1_t = S32_t | C1_t;
    global.S32C2_t = S32_t | C2_t;

    // constants
    global.EPSILON = EPSILON;
    global.FLT_MIN = FLT_MIN;

    // color convert
    global.COLOR_RGBA2GRAY = COLOR_RGBA2GRAY;
    global.COLOR_RGB2GRAY = COLOR_RGB2GRAY;
    global.COLOR_BGRA2GRAY = COLOR_BGRA2GRAY;
    global.COLOR_BGR2GRAY = COLOR_BGR2GRAY;

    // options
    global.BOX_BLUR_NOSCALE = BOX_BLUR_NOSCALE;
    global.SVD_U_T = SVD_U_T;
    global.SVD_V_T = SVD_V_T;

    global.get_data_type = get_data_type;
    global.get_channel = get_channel;
    global.get_data_type_size = get_data_type_size;

    global.data_t = data_t;
    global.matrix_t = matrix_t;
    global.pyramid_t = pyramid_t;
    global.keypoint_t = keypoint_t;

})(jsfeat);
/**
 * @author Eugene Zatepyakin / http://inspirit.ru/
 */

(function(global) {
    "use strict";
    //

    var cache = (function() {

        // very primitive array cache, still need testing if it helps
        // of course V8 has its own powerful cache sys but i'm not sure
        // it caches several multichannel 640x480 buffer creations each frame

        var _pool_node_t = (function () {
            function _pool_node_t(size_in_bytes) {
                this.next = null;
                this.data = new jsfeat.data_t(size_in_bytes);
                this.size = this.data.size;
                this.buffer = this.data.buffer;
                this.u8 = this.data.u8;
                this.i32 = this.data.i32;
                this.f32 = this.data.f32;
                this.f64 = this.data.f64;
            }
            _pool_node_t.prototype.resize = function(size_in_bytes) {
                delete this.data;
                this.data = new jsfeat.data_t(size_in_bytes);
                this.size = this.data.size;
                this.buffer = this.data.buffer;
                this.u8 = this.data.u8;
                this.i32 = this.data.i32;
                this.f32 = this.data.f32;
                this.f64 = this.data.f64;
            };
            return _pool_node_t;
        })();

        var _pool_head, _pool_tail;
        var _pool_size = 0;

        return {

            allocate: function(capacity, data_size) {
                _pool_head = _pool_tail = new _pool_node_t(data_size);
                for (var i = 0; i < capacity; ++i) {
                    var node = new _pool_node_t(data_size);
                    _pool_tail = _pool_tail.next = node;

                    _pool_size++;
                }
            },

            get_buffer: function(size_in_bytes) {
                // assume we have enough free nodes
                var node = _pool_head;
                _pool_head = _pool_head.next;
                _pool_size--;

                if(size_in_bytes > node.size) {
                    node.resize(size_in_bytes);
                }

                return node;
            },

            put_buffer: function(node) {
                _pool_tail = _pool_tail.next = node;
                _pool_size++;
            }
        };
    })();

    global.cache = cache;
    // for now we dont need more than 30 buffers
    // if having cache sys really helps we can add auto extending sys
    cache.allocate(30, 640*4);

})(jsfeat);
/**
 * @author Eugene Zatepyakin / http://inspirit.ru/
 */

(function(global) {
    "use strict";
    //

    var math = (function() {

        var qsort_stack = new Int32Array(48*2);

        return {
            get_gaussian_kernel: function(size, sigma, kernel, data_type) {
                var i=0,x=0.0,t=0.0,sigma_x=0.0,scale_2x=0.0;
                var sum = 0.0;
                var kern_node = jsfeat.cache.get_buffer(size<<2);
                var _kernel = kern_node.f32;//new Float32Array(size);

                if((size&1) == 1 && size <= 7 && sigma <= 0) {
                    switch(size>>1) {
                        case 0:
                        _kernel[0] = 1.0;
                        sum = 1.0;
                        break;
                        case 1:
                        _kernel[0] = 0.25, _kernel[1] = 0.5, _kernel[2] = 0.25;
                        sum = 0.25+0.5+0.25;
                        break;
                        case 2:
                        _kernel[0] = 0.0625, _kernel[1] = 0.25, _kernel[2] = 0.375, 
                        _kernel[3] = 0.25, _kernel[4] = 0.0625;
                        sum = 0.0625+0.25+0.375+0.25+0.0625;
                        break;
                        case 3:
                        _kernel[0] = 0.03125, _kernel[1] = 0.109375, _kernel[2] = 0.21875, 
                        _kernel[3] = 0.28125, _kernel[4] = 0.21875, _kernel[5] = 0.109375, _kernel[6] = 0.03125;
                        sum = 0.03125+0.109375+0.21875+0.28125+0.21875+0.109375+0.03125;
                        break;
                    }
                } else {
                    sigma_x = sigma > 0 ? sigma : ((size-1)*0.5 - 1.0)*0.3 + 0.8;
                    scale_2x = -0.5/(sigma_x*sigma_x);

                    for( ; i < size; ++i )
                    {
                        x = i - (size-1)*0.5;
                        t = Math.exp(scale_2x*x*x);

                        _kernel[i] = t;
                        sum += t;
                    }
                }

                if(data_type & jsfeat.U8_t) {
                    // int based kernel
                    sum = 256.0/sum;
                    for (i = 0; i < size; ++i) {
                        kernel[i] = (_kernel[i] * sum + 0.5)|0;
                    }
                } else {
                    // classic kernel
                    sum = 1.0/sum;
                    for (i = 0; i < size; ++i) {
                        kernel[i] = _kernel[i] * sum;
                    }
                }

                jsfeat.cache.put_buffer(kern_node);
            },

            // model is 3x3 matrix_t
            perspective_4point_transform: function(model, src_x0, src_y0, dst_x0, dst_y0,
                                                        src_x1, src_y1, dst_x1, dst_y1,
                                                        src_x2, src_y2, dst_x2, dst_y2,
                                                        src_x3, src_y3, dst_x3, dst_y3) {
                var t1 = src_x0;
                var t2 = src_x2;
                var t4 = src_y1;
                var t5 = t1 * t2 * t4;
                var t6 = src_y3;
                var t7 = t1 * t6;
                var t8 = t2 * t7;
                var t9 = src_y2;
                var t10 = t1 * t9;
                var t11 = src_x1;
                var t14 = src_y0;
                var t15 = src_x3;
                var t16 = t14 * t15;
                var t18 = t16 * t11;
                var t20 = t15 * t11 * t9;
                var t21 = t15 * t4;
                var t24 = t15 * t9;
                var t25 = t2 * t4;
                var t26 = t6 * t2;
                var t27 = t6 * t11;
                var t28 = t9 * t11;
                var t30 = 1.0 / (t21-t24 - t25 + t26 - t27 + t28);
                var t32 = t1 * t15;
                var t35 = t14 * t11;
                var t41 = t4 * t1;
                var t42 = t6 * t41;
                var t43 = t14 * t2;
                var t46 = t16 * t9;
                var t48 = t14 * t9 * t11;
                var t51 = t4 * t6 * t2;
                var t55 = t6 * t14;
                var Hr0 = -(t8-t5 + t10 * t11 - t11 * t7 - t16 * t2 + t18 - t20 + t21 * t2) * t30;
                var Hr1 = (t5 - t8 - t32 * t4 + t32 * t9 + t18 - t2 * t35 + t27 * t2 - t20) * t30;
                var Hr2 = t1;
                var Hr3 = (-t9 * t7 + t42 + t43 * t4 - t16 * t4 + t46 - t48 + t27 * t9 - t51) * t30;
                var Hr4 = (-t42 + t41 * t9 - t55 * t2 + t46 - t48 + t55 * t11 + t51 - t21 * t9) * t30;
                var Hr5 = t14;
                var Hr6 = (-t10 + t41 + t43 - t35 + t24 - t21 - t26 + t27) * t30;
                var Hr7 = (-t7 + t10 + t16 - t43 + t27 - t28 - t21 + t25) * t30;
                
                t1 = dst_x0;
                t2 = dst_x2;
                t4 = dst_y1;
                t5 = t1 * t2 * t4;
                t6 = dst_y3;
                t7 = t1 * t6;
                t8 = t2 * t7;
                t9 = dst_y2;
                t10 = t1 * t9;
                t11 = dst_x1;
                t14 = dst_y0;
                t15 = dst_x3;
                t16 = t14 * t15;
                t18 = t16 * t11;
                t20 = t15 * t11 * t9;
                t21 = t15 * t4;
                t24 = t15 * t9;
                t25 = t2 * t4;
                t26 = t6 * t2;
                t27 = t6 * t11;
                t28 = t9 * t11;
                t30 = 1.0 / (t21-t24 - t25 + t26 - t27 + t28);
                t32 = t1 * t15;
                t35 = t14 * t11;
                t41 = t4 * t1;
                t42 = t6 * t41;
                t43 = t14 * t2;
                t46 = t16 * t9;
                t48 = t14 * t9 * t11;
                t51 = t4 * t6 * t2;
                t55 = t6 * t14;
                var Hl0 = -(t8-t5 + t10 * t11 - t11 * t7 - t16 * t2 + t18 - t20 + t21 * t2) * t30;
                var Hl1 = (t5 - t8 - t32 * t4 + t32 * t9 + t18 - t2 * t35 + t27 * t2 - t20) * t30;
                var Hl2 = t1;
                var Hl3 = (-t9 * t7 + t42 + t43 * t4 - t16 * t4 + t46 - t48 + t27 * t9 - t51) * t30;
                var Hl4 = (-t42 + t41 * t9 - t55 * t2 + t46 - t48 + t55 * t11 + t51 - t21 * t9) * t30;
                var Hl5 = t14;
                var Hl6 = (-t10 + t41 + t43 - t35 + t24 - t21 - t26 + t27) * t30;
                var Hl7 = (-t7 + t10 + t16 - t43 + t27 - t28 - t21 + t25) * t30;

                // the following code computes R = Hl * inverse Hr
                t2 = Hr4-Hr7*Hr5;
                t4 = Hr0*Hr4;
                t5 = Hr0*Hr5;
                t7 = Hr3*Hr1;
                t8 = Hr2*Hr3;
                t10 = Hr1*Hr6;
                var t12 = Hr2*Hr6;
                t15 = 1.0 / (t4-t5*Hr7-t7+t8*Hr7+t10*Hr5-t12*Hr4);
                t18 = -Hr3+Hr5*Hr6;
                var t23 = -Hr3*Hr7+Hr4*Hr6;
                t28 = -Hr1+Hr2*Hr7;
                var t31 = Hr0-t12;
                t35 = Hr0*Hr7-t10;
                t41 = -Hr1*Hr5+Hr2*Hr4;
                var t44 = t5-t8;
                var t47 = t4-t7;
                t48 = t2*t15;
                var t49 = t28*t15;
                var t50 = t41*t15;
                var mat = model.data;
                mat[0] = Hl0*t48+Hl1*(t18*t15)-Hl2*(t23*t15);
                mat[1] = Hl0*t49+Hl1*(t31*t15)-Hl2*(t35*t15);
                mat[2] = -Hl0*t50-Hl1*(t44*t15)+Hl2*(t47*t15);
                mat[3] = Hl3*t48+Hl4*(t18*t15)-Hl5*(t23*t15);
                mat[4] = Hl3*t49+Hl4*(t31*t15)-Hl5*(t35*t15);
                mat[5] = -Hl3*t50-Hl4*(t44*t15)+Hl5*(t47*t15);
                mat[6] = Hl6*t48+Hl7*(t18*t15)-t23*t15;
                mat[7] = Hl6*t49+Hl7*(t31*t15)-t35*t15;
                mat[8] = -Hl6*t50-Hl7*(t44*t15)+t47*t15;
            },

            // The current implementation was derived from *BSD system qsort():
            // Copyright (c) 1992, 1993
            // The Regents of the University of California.  All rights reserved.
            qsort: function(array, low, high, cmp) {
                var isort_thresh = 7;
                var t,ta,tb,tc;
                var sp = 0,left=0,right=0,i=0,n=0,m=0,ptr=0,ptr2=0,d=0;
                var left0=0,left1=0,right0=0,right1=0,pivot=0,a=0,b=0,c=0,swap_cnt=0;

                var stack = qsort_stack;

                if( (high-low+1) <= 1 ) return;

                stack[0] = low;
                stack[1] = high;

                while( sp >= 0 ) {
                
                    left = stack[sp<<1];
                    right = stack[(sp<<1)+1];
                    sp--;

                    for(;;) {
                        n = (right - left) + 1;

                        if( n <= isort_thresh ) {
                        //insert_sort:
                            for( ptr = left + 1; ptr <= right; ptr++ ) {
                                for( ptr2 = ptr; ptr2 > left && cmp(array[ptr2],array[ptr2-1]); ptr2--) {
                                    t = array[ptr2];
                                    array[ptr2] = array[ptr2-1];
                                    array[ptr2-1] = t;
                                }
                            }
                            break;
                        } else {
                            swap_cnt = 0;

                            left0 = left;
                            right0 = right;
                            pivot = left + (n>>1);

                            if( n > 40 ) {
                                d = n >> 3;
                                a = left, b = left + d, c = left + (d<<1);
                                ta = array[a],tb = array[b],tc = array[c];
                                left = cmp(ta, tb) ? (cmp(tb, tc) ? b : (cmp(ta, tc) ? c : a))
                                                  : (cmp(tc, tb) ? b : (cmp(ta, tc) ? a : c));

                                a = pivot - d, b = pivot, c = pivot + d;
                                ta = array[a],tb = array[b],tc = array[c];
                                pivot = cmp(ta, tb) ? (cmp(tb, tc) ? b : (cmp(ta, tc) ? c : a))
                                                  : (cmp(tc, tb) ? b : (cmp(ta, tc) ? a : c));

                                a = right - (d<<1), b = right - d, c = right;
                                ta = array[a],tb = array[b],tc = array[c];
                                right = cmp(ta, tb) ? (cmp(tb, tc) ? b : (cmp(ta, tc) ? c : a))
                                                  : (cmp(tc, tb) ? b : (cmp(ta, tc) ? a : c));
                            }

                            a = left, b = pivot, c = right;
                            ta = array[a],tb = array[b],tc = array[c];
                            pivot = cmp(ta, tb) ? (cmp(tb, tc) ? b : (cmp(ta, tc) ? c : a))   
                                               : (cmp(tc, tb) ? b : (cmp(ta, tc) ? a : c));
                            if( pivot != left0 ) {
                                t = array[pivot];
                                array[pivot] = array[left0];
                                array[left0] = t;
                                pivot = left0;
                            }
                            left = left1 = left0 + 1;
                            right = right1 = right0;

                            ta = array[pivot];
                            for(;;) {
                                while( left <= right && !cmp(ta, array[left]) ) {
                                    if( !cmp(array[left], ta) ) {
                                        if( left > left1 ) {
                                            t = array[left1];
                                            array[left1] = array[left];
                                            array[left] = t;
                                        }
                                        swap_cnt = 1;
                                        left1++;
                                    }
                                    left++;
                                }

                                while( left <= right && !cmp(array[right], ta) ) {
                                    if( !cmp(ta, array[right]) ) {
                                        if( right < right1 ) {
                                            t = array[right1];
                                            array[right1] = array[right];
                                            array[right] = t;
                                        }
                                        swap_cnt = 1;
                                        right1--;
                                    }
                                    right--;
                                }

                                if( left > right ) break;
                                
                                t = array[left];
                                array[left] = array[right];
                                array[right] = t;
                                swap_cnt = 1;
                                left++;
                                right--;
                            }

                            if( swap_cnt == 0 ) {
                                left = left0, right = right0;
                                //goto insert_sort;
                                for( ptr = left + 1; ptr <= right; ptr++ ) {
                                    for( ptr2 = ptr; ptr2 > left && cmp(array[ptr2],array[ptr2-1]); ptr2--) {
                                        t = array[ptr2];
                                        array[ptr2] = array[ptr2-1];
                                        array[ptr2-1] = t;
                                    }
                                }
                                break;
                            }

                            n = Math.min( (left1 - left0), (left - left1) );
                            m = (left-n)|0;
                            for( i = 0; i < n; ++i,++m ) {
                                t = array[left0+i];
                                array[left0+i] = array[m];
                                array[m] = t;
                            }

                            n = Math.min( (right0 - right1), (right1 - right) );
                            m = (right0-n+1)|0;
                            for( i = 0; i < n; ++i,++m ) {
                                t = array[left+i];
                                array[left+i] = array[m];
                                array[m] = t;
                            }
                            n = (left - left1);
                            m = (right1 - right);
                            if( n > 1 ) {
                                if( m > 1 ) {
                                    if( n > m ) {
                                        ++sp;
                                        stack[sp<<1] = left0;
                                        stack[(sp<<1)+1] = left0 + n - 1;
                                        left = right0 - m + 1, right = right0;
                                    } else {
                                        ++sp;
                                        stack[sp<<1] = right0 - m + 1;
                                        stack[(sp<<1)+1] = right0;
                                        left = left0, right = left0 + n - 1;
                                    }
                                } else {
                                    left = left0, right = left0 + n - 1;
                                }
                            }
                            else if( m > 1 )
                                left = right0 - m + 1, right = right0;
                            else
                                break;
                        }
                    }
                }
            },

            median: function(array, low, high) {
                var w;
                var middle=0,ll=0,hh=0,median=(low+high)>>1;
                for (;;) {
                    if (high <= low) return array[median];
                    if (high == (low + 1)) {
                        if (array[low] > array[high]) {
                            w = array[low];
                            array[low] = array[high];
                            array[high] = w;
                        }
                        return array[median];
                    }
                    middle = ((low + high) >> 1);
                    if (array[middle] > array[high]) {
                        w = array[middle];
                        array[middle] = array[high];
                        array[high] = w;
                    }
                    if (array[low] > array[high]) {
                        w = array[low];
                        array[low] = array[high];
                        array[high] = w;
                    }
                    if (array[middle] > array[low]) {
                        w = array[middle];
                        array[middle] = array[low];
                        array[low] = w;
                    }
                    ll = (low + 1);
                    w = array[middle];
                    array[middle] = array[ll];
                    array[ll] = w;
                    hh = high;
                    for (;;) {
                        do ++ll; while (array[low] > array[ll]);
                        do --hh; while (array[hh] > array[low]);
                        if (hh < ll) break;
                        w = array[ll];
                        array[ll] = array[hh];
                        array[hh] = w;
                    }
                    w = array[low];
                    array[low] = array[hh];
                    array[hh] = w;
                    if (hh <= median)
                        low = ll;
                    else if (hh >= median)
                        high = (hh - 1);
                }
                return 0;
            }
        };

    })();

    global.math = math;

})(jsfeat);
/**
 * @author Eugene Zatepyakin / http://inspirit.ru/
 *
 */

(function(global) {
    "use strict";
    //

    var matmath = (function() {
        
        return {
            identity: function(M, value) {
                if (typeof value === "undefined") { value=1; }
                var src=M.data;
                var rows=M.rows, cols=M.cols, cols_1=(cols+1)|0;
                var len = rows * cols;
                var k = len;
                while(--len >= 0) src[len] = 0.0;
                len = k;
                k = 0;
                while(k < len)  {
                    src[k] = value;
                    k = k + cols_1;
                }
            },

            transpose: function(At, A) {
                var i=0,j=0,nrows=A.rows,ncols=A.cols;
                var Ai=0,Ati=0,pAt=0;
                var ad=A.data,atd=At.data;

                for (; i < nrows; Ati += 1, Ai += ncols, i++) {
                    pAt = Ati;
                    for (j = 0; j < ncols; pAt += nrows, j++) atd[pAt] = ad[Ai+j];
                }
            },

            // C = A * B
            multiply: function(C, A, B) {
                var i=0,j=0,k=0;
                var Ap=0,pA=0,pB=0,p_B=0,Cp=0;
                var ncols=A.cols,nrows=A.rows,mcols=B.cols;
                var ad=A.data,bd=B.data,cd=C.data;
                var sum=0.0;

                for (; i < nrows; Ap += ncols, i++) {
                    for (p_B = 0, j = 0; j < mcols; Cp++, p_B++, j++) {
                        pB = p_B;
                        pA = Ap;
                        sum = 0.0;
                        for (k = 0; k < ncols; pA++, pB += mcols, k++) {
                            sum += ad[pA] * bd[pB];
                        }
                        cd[Cp] = sum;
                    }
                }
            },

            // C = A * B'
            multiply_ABt: function(C, A, B) {
                var i=0,j=0,k=0;
                var Ap=0,pA=0,pB=0,Cp=0;
                var ncols=A.cols,nrows=A.rows,mrows=B.rows;
                var ad=A.data,bd=B.data,cd=C.data;
                var sum=0.0;

                for (; i < nrows; Ap += ncols, i++) {
                    for (pB = 0, j = 0; j < mrows; Cp++, j++) {
                        pA = Ap;
                        sum = 0.0;
                        for (k = 0; k < ncols; pA++, pB++, k++) {
                            sum += ad[pA] * bd[pB];
                        }
                        cd[Cp] = sum;
                    }
                }
            },

            // C = A' * B
            multiply_AtB: function(C, A, B) {
                var i=0,j=0,k=0;
                var Ap=0,pA=0,pB=0,p_B=0,Cp=0;
                var ncols=A.cols,nrows=A.rows,mcols=B.cols;
                var ad=A.data,bd=B.data,cd=C.data;
                var sum=0.0;

                for (; i < ncols; Ap++, i++) {
                    for (p_B = 0, j = 0; j < mcols; Cp++, p_B++, j++) {
                        pB = p_B;
                        pA = Ap;
                        sum = 0.0;
                        for (k = 0; k < nrows; pA += ncols, pB += mcols, k++) {
                            sum += ad[pA] * bd[pB];
                        }
                        cd[Cp] = sum;
                    }
                }
            },

            // C = A * A'
            multiply_AAt: function(C, A) {
                var i=0,j=0,k=0;
                var pCdiag=0,p_A=0,pA=0,pB=0,pC=0,pCt=0;
                var ncols=A.cols,nrows=A.rows;
                var ad=A.data,cd=C.data;
                var sum=0.0;

                for (; i < nrows; pCdiag += nrows + 1, p_A = pA, i++) {
                    pC = pCdiag;
                    pCt = pCdiag;
                    pB = p_A; 
                    for (j = i; j < nrows; pC++, pCt += nrows, j++) {
                        pA = p_A;
                        sum = 0.0;
                        for (k = 0; k < ncols; k++) {
                            sum += ad[pA++] * ad[pB++];
                        }
                        cd[pC] = sum;
                        cd[pCt] = sum;
                    }
                }
            },

            // C = A' * A
            multiply_AtA: function(C, A) {
                var i=0,j=0,k=0;
                var p_A=0,pA=0,pB=0,p_C=0,pC=0,p_CC=0;
                var ncols=A.cols,nrows=A.rows;
                var ad=A.data,cd=C.data;
                var sum=0.0;

                for (; i < ncols; p_C += ncols, i++) {
                    p_A = i;
                    p_CC = p_C + i;
                    pC = p_CC;
                    for (j = i; j < ncols; pC++, p_CC += ncols, j++) {
                        pA = p_A;
                        pB = j;
                        sum = 0.0;
                        for (k = 0; k < nrows; pA += ncols, pB += ncols, k++) {
                            sum += ad[pA] * ad[pB];
                        }
                        cd[pC] = sum;
                        cd[p_CC] = sum;
                    }
                }
            },

            // various small matrix operations
            identity_3x3: function(M, value) {
                if (typeof value === "undefined") { value=1; }
                var dt=M.data;
                dt[0] = dt[4] = dt[8] = value;
                dt[1] = dt[2] = dt[3] = 0;
                dt[5] = dt[6] = dt[7] = 0;
            },

            invert_3x3: function(from, to) {
                var A = from.data, invA = to.data;
                var t1 = A[4];
                var t2 = A[8];
                var t4 = A[5];
                var t5 = A[7];
                var t8 = A[0];

                var t9 = t8*t1;
                var t11 = t8*t4;
                var t13 = A[3];
                var t14 = A[1];
                var t15 = t13*t14;
                var t17 = A[2];
                var t18 = t13*t17;
                var t20 = A[6];
                var t21 = t20*t14;
                var t23 = t20*t17;
                var t26 = 1.0/(t9*t2-t11*t5-t15*t2+t18*t5+t21*t4-t23*t1);
                invA[0] = (t1*t2-t4*t5)*t26;
                invA[1] = -(t14*t2-t17*t5)*t26;
                invA[2] = -(-t14*t4+t17*t1)*t26;
                invA[3] = -(t13*t2-t4*t20)*t26;
                invA[4] = (t8*t2-t23)*t26;
                invA[5] = -(t11-t18)*t26;
                invA[6] = -(-t13*t5+t1*t20)*t26;
                invA[7] = -(t8*t5-t21)*t26;
                invA[8] = (t9-t15)*t26;
            },
            // C = A * B
            multiply_3x3: function(C, A, B) {
                var Cd=C.data, Ad=A.data, Bd=B.data;
                var m1_0 = Ad[0], m1_1 = Ad[1], m1_2 = Ad[2];
                var m1_3 = Ad[3], m1_4 = Ad[4], m1_5 = Ad[5];
                var m1_6 = Ad[6], m1_7 = Ad[7], m1_8 = Ad[8];

                var m2_0 = Bd[0], m2_1 = Bd[1], m2_2 = Bd[2];
                var m2_3 = Bd[3], m2_4 = Bd[4], m2_5 = Bd[5];
                var m2_6 = Bd[6], m2_7 = Bd[7], m2_8 = Bd[8];

                Cd[0] = m1_0 * m2_0 + m1_1 * m2_3 + m1_2 * m2_6;
                Cd[1] = m1_0 * m2_1 + m1_1 * m2_4 + m1_2 * m2_7;
                Cd[2] = m1_0 * m2_2 + m1_1 * m2_5 + m1_2 * m2_8;
                Cd[3] = m1_3 * m2_0 + m1_4 * m2_3 + m1_5 * m2_6;
                Cd[4] = m1_3 * m2_1 + m1_4 * m2_4 + m1_5 * m2_7;
                Cd[5] = m1_3 * m2_2 + m1_4 * m2_5 + m1_5 * m2_8;
                Cd[6] = m1_6 * m2_0 + m1_7 * m2_3 + m1_8 * m2_6;
                Cd[7] = m1_6 * m2_1 + m1_7 * m2_4 + m1_8 * m2_7;
                Cd[8] = m1_6 * m2_2 + m1_7 * m2_5 + m1_8 * m2_8;
            },

            mat3x3_determinant: function(M) {
                var md=M.data;
                return  md[0] * md[4] * md[8] -
                        md[0] * md[5] * md[7] -
                        md[3] * md[1] * md[8] +
                        md[3] * md[2] * md[7] +
                        md[6] * md[1] * md[5] -
                        md[6] * md[2] * md[4];
            },

            determinant_3x3: function(M11, M12, M13, 
                                      M21, M22, M23, 
                                      M31, M32, M33) {
                return  M11 * M22 * M33 - M11 * M23 * M32 -
                          M21 * M12 * M33 + M21 * M13 * M32 +
                          M31 * M12 * M23 - M31 * M13 * M22;
            }
        };

    })();

    global.matmath = matmath;

})(jsfeat);
/**
 * @author Eugene Zatepyakin / http://inspirit.ru/
 *
 */

(function(global) {
    "use strict";
    //

    var linalg = (function() {

        var swap = function(A, i0, i1, t) {
            t = A[i0];
            A[i0] = A[i1];
            A[i1] = t;
        };

        var hypot = function(a, b) {
            a = Math.abs(a);
            b = Math.abs(b);
            if( a > b ) {
                b /= a;
                return a*Math.sqrt(1.0 + b*b);
            }
            if( b > 0 ) {
                a /= b;
                return b*Math.sqrt(1.0 + a*a);
            }
            return 0.0;
        };

        var JacobiImpl = function(A, astep, W, V, vstep, n) {
            var eps = jsfeat.EPSILON;
            var i=0,j=0,k=0,m=0,l=0,idx=0,_in=0,_in2=0;
            var iters=0,max_iter=n*n*30;
            var mv=0.0,val=0.0,p=0.0,y=0.0,t=0.0,s=0.0,c=0.0,a0=0.0,b0=0.0;

            var indR_buff = jsfeat.cache.get_buffer(n<<2);
            var indC_buff = jsfeat.cache.get_buffer(n<<2);
            var indR = indR_buff.i32;
            var indC = indC_buff.i32;

            if(V) {
                for(; i < n; i++) {
                    k = i*vstep;
                    for(j = 0; j < n; j++) {
                        V[k + j] = 0.0;
                    }
                    V[k + i] = 1.0;
                }
            }

            for(k = 0; k < n; k++) {
                W[k] = A[(astep + 1)*k];
                if(k < n - 1) {
                    for(m = k+1, mv = Math.abs(A[astep*k + m]), i = k+2; i < n; i++) {
                        val = Math.abs(A[astep*k+i]);
                        if(mv < val)
                            mv = val, m = i;
                    }
                    indR[k] = m;
                }
                if(k > 0) {
                    for(m = 0, mv = Math.abs(A[k]), i = 1; i < k; i++) {
                        val = Math.abs(A[astep*i+k]);
                        if(mv < val)
                            mv = val, m = i;
                    }
                    indC[k] = m;
                }
            }

            if(n > 1) for( ; iters < max_iter; iters++) {
                // find index (k,l) of pivot p
                for(k = 0, mv = Math.abs(A[indR[0]]), i = 1; i < n-1; i++) {
                    val = Math.abs(A[astep*i + indR[i]]);
                    if( mv < val )
                        mv = val, k = i;
                }
                l = indR[k];
                for(i = 1; i < n; i++) {
                    val = Math.abs(A[astep*indC[i] + i]);
                    if( mv < val )
                        mv = val, k = indC[i], l = i;
                }
                
                p = A[astep*k + l];

                if(Math.abs(p) <= eps) break;

                y = (W[l] - W[k])*0.5;
                t = Math.abs(y) + hypot(p, y);
                s = hypot(p, t);
                c = t/s;
                s = p/s; t = (p/t)*p;
                if(y < 0)
                    s = -s, t = -t;
                A[astep*k + l] = 0;
                
                W[k] -= t;
                W[l] += t;
                
                // rotate rows and columns k and l
                for (i = 0; i < k; i++) {
                    _in = (astep * i + k);
                    _in2 = (astep * i + l);
                    a0 = A[_in];
                    b0 = A[_in2];
                    A[_in] = a0 * c - b0 * s;
                    A[_in2] = a0 * s + b0 * c;
                }
                for (i = (k + 1); i < l; i++) {
                    _in = (astep * k + i);
                    _in2 = (astep * i + l);
                    a0 = A[_in];
                    b0 = A[_in2];
                    A[_in] = a0 * c - b0 * s;
                    A[_in2] = a0 * s + b0 * c;
                }
                i = l + 1;
                _in = (astep * k + i);
                _in2 = (astep * l + i);
                for (; i < n; i++, _in++, _in2++) {
                    a0 = A[_in];
                    b0 = A[_in2];
                    A[_in] = a0 * c - b0 * s;
                    A[_in2] = a0 * s + b0 * c;
                }
                
                // rotate eigenvectors
                if (V) {
                    _in = vstep * k;
                    _in2 = vstep * l;
                    for (i = 0; i < n; i++, _in++, _in2++) {
                        a0 = V[_in];
                        b0 = V[_in2];
                        V[_in] = a0 * c - b0 * s;
                        V[_in2] = a0 * s + b0 * c;
                    }
                }
                
                for(j = 0; j < 2; j++) {
                    idx = j == 0 ? k : l;
                    if(idx < n - 1) {
                        for(m = idx+1, mv = Math.abs(A[astep*idx + m]), i = idx+2; i < n; i++) {
                            val = Math.abs(A[astep*idx+i]);
                            if( mv < val )
                                mv = val, m = i;
                        }
                        indR[idx] = m;
                    }
                    if(idx > 0) {
                        for(m = 0, mv = Math.abs(A[idx]), i = 1; i < idx; i++) {
                            val = Math.abs(A[astep*i+idx]);
                            if( mv < val )
                                mv = val, m = i;
                        }
                        indC[idx] = m;
                    }
                }
            }

            // sort eigenvalues & eigenvectors
            for(k = 0; k < n-1; k++) {
                m = k;
                for(i = k+1; i < n; i++) {
                    if(W[m] < W[i])
                        m = i;
                }
                if(k != m) {
                    swap(W, m, k, mv);
                    if(V) {
                        for(i = 0; i < n; i++) {
                            swap(V, vstep*m + i, vstep*k + i, mv);
                        }
                    }
                }
            }


            jsfeat.cache.put_buffer(indR_buff);
            jsfeat.cache.put_buffer(indC_buff);
        };

        var JacobiSVDImpl = function(At, astep, _W, Vt, vstep, m, n, n1) {
            var eps = jsfeat.EPSILON * 2.0;
            var minval = jsfeat.FLT_MIN;
            var i=0,j=0,k=0,iter=0,max_iter=Math.max(m, 30);
            var Ai=0,Aj=0,Vi=0,Vj=0,changed=0;
            var c=0.0, s=0.0, t=0.0;
            var t0=0.0,t1=0.0,sd=0.0,beta=0.0,gamma=0.0,delta=0.0,a=0.0,p=0.0,b=0.0;
            var seed = 0x1234;
            var val=0.0,val0=0.0,asum=0.0;

            var W_buff = jsfeat.cache.get_buffer(n<<3);
            var W = W_buff.f64;
            
            for(; i < n; i++) {
                for(k = 0, sd = 0; k < m; k++) {
                    t = At[i*astep + k];
                    sd += t*t;
                }
                W[i] = sd;
                
                if(Vt) {
                    for(k = 0; k < n; k++) {
                        Vt[i*vstep + k] = 0;
                    }
                    Vt[i*vstep + i] = 1;
                }
            }
            
            for(; iter < max_iter; iter++) {
                changed = 0;
                
                for(i = 0; i < n-1; i++) {
                    for(j = i+1; j < n; j++) {
                        Ai = (i*astep)|0, Aj = (j*astep)|0;
                        a = W[i], p = 0, b = W[j];
                        
                        k = 2;
                        p += At[Ai]*At[Aj];
                        p += At[Ai+1]*At[Aj+1];

                        for(; k < m; k++)
                            p += At[Ai+k]*At[Aj+k];
                        
                        if(Math.abs(p) <= eps*Math.sqrt(a*b)) continue;
                        
                        p *= 2.0;
                        beta = a - b, gamma = hypot(p, beta);
                        if( beta < 0 ) {
                            delta = (gamma - beta)*0.5;
                            s = Math.sqrt(delta/gamma);
                            c = (p/(gamma*s*2.0));
                        } else {
                            c = Math.sqrt((gamma + beta)/(gamma*2.0));
                            s = (p/(gamma*c*2.0));
                        }
                        
                        a=0.0, b=0.0;
                        
                        k = 2; // unroll
                        t0 = c*At[Ai] + s*At[Aj];
                        t1 = -s*At[Ai] + c*At[Aj];
                        At[Ai] = t0; At[Aj] = t1;
                        a += t0*t0; b += t1*t1;

                        t0 = c*At[Ai+1] + s*At[Aj+1];
                        t1 = -s*At[Ai+1] + c*At[Aj+1];
                        At[Ai+1] = t0; At[Aj+1] = t1;
                        a += t0*t0; b += t1*t1;

                        for( ; k < m; k++ )
                        {
                            t0 = c*At[Ai+k] + s*At[Aj+k];
                            t1 = -s*At[Ai+k] + c*At[Aj+k];
                            At[Ai+k] = t0; At[Aj+k] = t1;
                            
                            a += t0*t0; b += t1*t1;
                        }
                        
                        W[i] = a; W[j] = b;
                        
                        changed = 1;
                        
                        if(Vt) {
                            Vi = (i*vstep)|0, Vj = (j*vstep)|0;

                            k = 2;
                            t0 = c*Vt[Vi] + s*Vt[Vj];
                            t1 = -s*Vt[Vi] + c*Vt[Vj];
                            Vt[Vi] = t0; Vt[Vj] = t1;

                            t0 = c*Vt[Vi+1] + s*Vt[Vj+1];
                            t1 = -s*Vt[Vi+1] + c*Vt[Vj+1];
                            Vt[Vi+1] = t0; Vt[Vj+1] = t1;

                            for(; k < n; k++) {
                                t0 = c*Vt[Vi+k] + s*Vt[Vj+k];
                                t1 = -s*Vt[Vi+k] + c*Vt[Vj+k];
                                Vt[Vi+k] = t0; Vt[Vj+k] = t1;
                            }
                        }
                    }
                }
                if(changed == 0) break;
            }
            
            for(i = 0; i < n; i++) {
                for(k = 0, sd = 0; k < m; k++) {
                    t = At[i*astep + k];
                    sd += t*t;
                }
                W[i] = Math.sqrt(sd);
            }
            
            for(i = 0; i < n-1; i++) {
                j = i;
                for(k = i+1; k < n; k++) {
                    if(W[j] < W[k])
                        j = k;
                }
                if(i != j) {
                    swap(W, i, j, sd);
                    if(Vt) {
                        for(k = 0; k < m; k++) {
                            swap(At, i*astep + k, j*astep + k, t);
                        }
                        
                        for(k = 0; k < n; k++) {
                            swap(Vt, i*vstep + k, j*vstep + k, t);
                        }
                    }
                }
            }
            
            for(i = 0; i < n; i++) {
                _W[i] = W[i];
            }
            
            if(!Vt) {
                jsfeat.cache.put_buffer(W_buff);
                return;
            }

            for(i = 0; i < n1; i++) {

                sd = i < n ? W[i] : 0;
                
                while(sd <= minval) {
                    // if we got a zero singular value, then in order to get the corresponding left singular vector
                    // we generate a random vector, project it to the previously computed left singular vectors,
                    // subtract the projection and normalize the difference.
                    val0 = (1.0/m);
                    for(k = 0; k < m; k++) {
                        seed = (seed * 214013 + 2531011);
                        val = (((seed >> 16) & 0x7fff) & 256) != 0 ? val0 : -val0;
                        At[i*astep + k] = val;
                    }
                    for(iter = 0; iter < 2; iter++) {
                        for(j = 0; j < i; j++) {
                            sd = 0;
                            for(k = 0; k < m; k++) {
                                sd += At[i*astep + k]*At[j*astep + k];
                            }
                            asum = 0.0;
                            for(k = 0; k < m; k++) {
                                t = (At[i*astep + k] - sd*At[j*astep + k]);
                                At[i*astep + k] = t;
                                asum += Math.abs(t);
                            }
                            asum = asum ? 1.0/asum : 0;
                            for(k = 0; k < m; k++) {
                                At[i*astep + k] *= asum;
                            }
                        }
                    }
                    sd = 0;
                    for(k = 0; k < m; k++) {
                        t = At[i*astep + k];
                        sd += t*t;
                    }
                    sd = Math.sqrt(sd);
                }
                
                s = (1.0/sd);
                for(k = 0; k < m; k++) {
                    At[i*astep + k] *= s;
                }
            }

            jsfeat.cache.put_buffer(W_buff);
        };
        
        return {

            lu_solve: function(A, B) {
                var i=0,j=0,k=0,p=1,astep=A.cols;
                var ad=A.data, bd=B.data;
                var t,alpha,d,s;

                for(i = 0; i < astep; i++) {
                    k = i;                    
                    for(j = i+1; j < astep; j++) {
                        if(Math.abs(ad[j*astep + i]) > Math.abs(ad[k*astep+i])) {
                            k = j;
                        }
                    }
                    
                    if(Math.abs(ad[k*astep+i]) < jsfeat.EPSILON) {
                        return 0; // FAILED
                    }
                    
                    if(k != i) {
                        for(j = i; j < astep; j++ ) {
                            swap(ad, i*astep+j, k*astep+j, t);
                        }
                        
                        swap(bd, i, k, t);
                        p = -p;
                    }
                    
                    d = -1.0/ad[i*astep+i];
                    
                    for(j = i+1; j < astep; j++) {
                        alpha = ad[j*astep+i]*d;
                        
                        for(k = i+1; k < astep; k++) {
                            ad[j*astep+k] += alpha*ad[i*astep+k];
                        }
                        
                        bd[j] += alpha*bd[i];
                    }
                    
                    ad[i*astep+i] = -d;
                }
                
                for(i = astep-1; i >= 0; i--) {
                    s = bd[i];
                    for(k = i+1; k < astep; k++) {
                        s -= ad[i*astep+k]*bd[k];
                    }
                    bd[i] = s*ad[i*astep+i];
                }

                return 1; // OK
            },

            cholesky_solve: function(A, B) {
                var col=0,row=0,col2=0,cs=0,rs=0,i=0,j=0;
                var size = A.cols;
                var ad=A.data, bd=B.data;
                var val,inv_diag;

                for (col = 0; col < size; col++) {
                    inv_diag = 1.0;
                    cs = (col * size);
                    rs = cs;
                    for (row = col; row < size; row++)
                    {
                        // correct for the parts of cholesky already computed
                        val = ad[(rs+col)];
                        for (col2 = 0; col2 < col; col2++) {
                            val -= ad[(col2*size+col)] * ad[(rs+col2)];
                        }
                        if (row == col) {
                            // this is the diagonal element so don't divide
                            ad[(rs+col)] = val;
                            if(val == 0) {
                                return 0;
                            }
                            inv_diag = 1.0 / val;
                        } else {
                            // cache the value without division in the upper half
                            ad[(cs+row)] = val;
                            // divide my the diagonal element for all others
                            ad[(rs+col)] = val * inv_diag;
                        }
                        rs = (rs + size);
                    }
                }

                // first backsub through L
                cs = 0;
                for (i = 0; i < size; i++) {
                    val = bd[i];
                    for (j = 0; j < i; j++) {
                        val -= ad[(cs+j)] * bd[j];
                    }
                    bd[i] = val;
                    cs = (cs + size);
                }
                // backsub through diagonal
                cs = 0;
                for (i = 0; i < size; i++) {
                    bd[i] /= ad[(cs + i)];
                    cs = (cs + size);
                }
                // backsub through L Transpose
                i = (size-1);
                for (; i >= 0; i--) {
                    val = bd[i];
                    j = (i + 1);
                    cs = (j * size);
                    for (; j < size; j++) {
                        val -= ad[(cs + i)] * bd[j];
                        cs = (cs + size);
                    }
                    bd[i] = val;
                }

                return 1;
            },

            svd_decompose: function(A, W, U, V, options) {
                if (typeof options === "undefined") { options = 0; }
                var at=0,i=0,j=0,_m=A.rows,_n=A.cols,m=_m,n=_n;
                var dt = A.type | jsfeat.C1_t; // we only work with single channel

                if(m < n) {
                    at = 1;
                    i = m;
                    m = n;
                    n = i;
                }

                var a_buff = jsfeat.cache.get_buffer((m*m)<<3);
                var w_buff = jsfeat.cache.get_buffer(n<<3);
                var v_buff = jsfeat.cache.get_buffer((n*n)<<3);

                var a_mt = new jsfeat.matrix_t(m, m, dt, a_buff.data);
                var w_mt = new jsfeat.matrix_t(1, n, dt, w_buff.data);
                var v_mt = new jsfeat.matrix_t(n, n, dt, v_buff.data);

                if(at == 0) {
                    // transpose
                    jsfeat.matmath.transpose(a_mt, A);
                } else {
                    for(i = 0; i < _n*_m; i++) {
                        a_mt.data[i] = A.data[i];
                    }
                    for(; i < n*m; i++) {
                        a_mt.data[i] = 0;
                    }
                }

                JacobiSVDImpl(a_mt.data, m, w_mt.data, v_mt.data, n, m, n, m);

                if(W) {
                    for(i=0; i < n; i++) {
                        W.data[i] = w_mt.data[i];
                    }
                    for(; i < _n; i++) {
                        W.data[i] = 0;
                    }
                }

                if (at == 0) {
                    if(U && (options & jsfeat.SVD_U_T)) {
                        i = m*m;
                        while(--i >= 0) {
                            U.data[i] = a_mt.data[i];
                        }
                    } else if(U) {
                        jsfeat.matmath.transpose(U, a_mt);
                    }

                    if(V && (options & jsfeat.SVD_V_T)) {
                        i = n*n;
                        while(--i >= 0) {
                            V.data[i] = v_mt.data[i];
                        }
                    } else if(V) {
                        jsfeat.matmath.transpose(V, v_mt);
                    }
                } else {
                    if(U && (options & jsfeat.SVD_U_T)) {
                        i = n*n;
                        while(--i >= 0) {
                            U.data[i] = v_mt.data[i];
                        }
                    } else if(U) {
                        jsfeat.matmath.transpose(U, v_mt);
                    }

                    if(V && (options & jsfeat.SVD_V_T)) {
                        i = m*m;
                        while(--i >= 0) {
                            V.data[i] = a_mt.data[i];
                        }
                    } else if(V) {
                        jsfeat.matmath.transpose(V, a_mt);
                    }
                }

                jsfeat.cache.put_buffer(a_buff);
                jsfeat.cache.put_buffer(w_buff);
                jsfeat.cache.put_buffer(v_buff);

            },

            svd_solve: function(A, X, B) {
                var i=0,j=0,k=0;
                var pu=0,pv=0;
                var nrows=A.rows,ncols=A.cols;
                var sum=0.0,xsum=0.0,tol=0.0;
                var dt = A.type | jsfeat.C1_t;

                var u_buff = jsfeat.cache.get_buffer((nrows*nrows)<<3);
                var w_buff = jsfeat.cache.get_buffer(ncols<<3);
                var v_buff = jsfeat.cache.get_buffer((ncols*ncols)<<3);

                var u_mt = new jsfeat.matrix_t(nrows, nrows, dt, u_buff.data);
                var w_mt = new jsfeat.matrix_t(1, ncols, dt, w_buff.data);
                var v_mt = new jsfeat.matrix_t(ncols, ncols, dt, v_buff.data);

                var bd = B.data, ud = u_mt.data, wd = w_mt.data, vd = v_mt.data;

                this.svd_decompose(A, w_mt, u_mt, v_mt, 0);

                tol = jsfeat.EPSILON * wd[0] * ncols;

                for (; i < ncols; i++, pv += ncols) {
                    xsum = 0.0;
                    for(j = 0; j < ncols; j++) {
                        if(wd[j] > tol) {
                            for(k = 0, sum = 0.0, pu = 0; k < nrows; k++, pu += ncols) {
                                sum += ud[pu + j] * bd[k];
                            }
                            xsum += sum * vd[pv + j] / wd[j];
                        }
                    }
                    X.data[i] = xsum;
                }

                jsfeat.cache.put_buffer(u_buff);
                jsfeat.cache.put_buffer(w_buff);
                jsfeat.cache.put_buffer(v_buff);
            },

            svd_invert: function(Ai, A) {
                var i=0,j=0,k=0;
                var pu=0,pv=0,pa=0;
                var nrows=A.rows,ncols=A.cols;
                var sum=0.0,tol=0.0;
                var dt = A.type | jsfeat.C1_t;

                var u_buff = jsfeat.cache.get_buffer((nrows*nrows)<<3);
                var w_buff = jsfeat.cache.get_buffer(ncols<<3);
                var v_buff = jsfeat.cache.get_buffer((ncols*ncols)<<3);

                var u_mt = new jsfeat.matrix_t(nrows, nrows, dt, u_buff.data);
                var w_mt = new jsfeat.matrix_t(1, ncols, dt, w_buff.data);
                var v_mt = new jsfeat.matrix_t(ncols, ncols, dt, v_buff.data);

                var id = Ai.data, ud = u_mt.data, wd = w_mt.data, vd = v_mt.data;

                this.svd_decompose(A, w_mt, u_mt, v_mt, 0);

                tol = jsfeat.EPSILON * wd[0] * ncols;

                for (; i < ncols; i++, pv += ncols) {
                    for (j = 0, pu = 0; j < nrows; j++, pa++) {
                        for (k = 0, sum = 0.0; k < ncols; k++, pu++) {
                            if (wd[k] > tol) sum += vd[pv + k] * ud[pu] / wd[k];
                        }
                        id[pa] = sum;
                    }
                }

                jsfeat.cache.put_buffer(u_buff);
                jsfeat.cache.put_buffer(w_buff);
                jsfeat.cache.put_buffer(v_buff);
            },

            eigenVV: function(A, vects, vals) {
                var n=A.cols,i=n*n;
                var dt = A.type | jsfeat.C1_t;

                var a_buff = jsfeat.cache.get_buffer((n*n)<<3);
                var w_buff = jsfeat.cache.get_buffer(n<<3);
                var a_mt = new jsfeat.matrix_t(n, n, dt, a_buff.data);
                var w_mt = new jsfeat.matrix_t(1, n, dt, w_buff.data);

                while(--i >= 0) {
                    a_mt.data[i] = A.data[i];
                }

                JacobiImpl(a_mt.data, n, w_mt.data, vects ? vects.data : null, n, n);

                if(vals) {
                    while(--n >= 0) {
                        vals.data[n] = w_mt.data[n];
                    }
                }

                jsfeat.cache.put_buffer(a_buff);
                jsfeat.cache.put_buffer(w_buff);
            }

        };

    })();

    global.linalg = linalg;

})(jsfeat);
/**
 * @author Eugene Zatepyakin / http://inspirit.ru/
 *
 */

(function(global) {
    "use strict";
    //

    var motion_model = (function() {

    	var sqr = function(x) {
    		return x*x;
    	};

    	// does isotropic normalization
    	var iso_normalize_points = function(from, to, T0, T1, count) {
			var i=0;
		    var cx0=0.0, cy0=0.0, d0=0.0, s0=0.0;
		    var cx1=0.0, cy1=0.0, d1=0.0, s1=0.0;
		    var dx=0.0,dy=0.0;

		    for (; i < count; ++i) {
		        cx0 += from[i].x;
		        cy0 += from[i].y;
		        cx1 += to[i].x;
		        cy1 += to[i].y;
		    }

		    cx0 /= count; cy0 /= count;
		    cx1 /= count; cy1 /= count;

		    for (i = 0; i < count; ++i) {
		        dx = from[i].x - cx0;
		        dy = from[i].y - cy0;
		        d0 += Math.sqrt(dx*dx + dy*dy);
		        dx = to[i].x - cx1;
		        dy = to[i].y - cy1;
		        d1 += Math.sqrt(dx*dx + dy*dy);
		    }

		    d0 /= count; d1 /= count;

		    s0 = Math.SQRT2 / d0; s1 = Math.SQRT2 / d1;

		    T0[0] = T0[4] = s0;
		    T0[2] = -cx0*s0;
		    T0[5] = -cy0*s0;
		    T0[1] = T0[3] = T0[6] = T0[7] = 0.0;
		    T0[8] = 1.0;

		    T1[0] = T1[4] = s1;
		    T1[2] = -cx1*s1;
		    T1[5] = -cy1*s1;
		    T1[1] = T1[3] = T1[6] = T1[7] = 0.0;
		    T1[8] = 1.0;
		};

		var have_collinear_points = function(points, count) {
		    var j=0,k=0,i=(count-1)|0;
		    var dx1=0.0,dy1=0.0,dx2=0.0,dy2=0.0;

		    // check that the i-th selected point does not belong
		    // to a line connecting some previously selected points
		    for(; j < i; ++j) {
		        dx1 = points[j].x - points[i].x;
		        dy1 = points[j].y - points[i].y;
		        for(k = 0; k < j; ++k) {
		            dx2 = points[k].x - points[i].x;
		            dy2 = points[k].y - points[i].y;
		            if( Math.abs(dx2*dy1 - dy2*dx1) <= jsfeat.EPSILON*(Math.abs(dx1) + Math.abs(dy1) + Math.abs(dx2) + Math.abs(dy2)))
		                return true;
		        }
		    }
		    return false;
		};

		var T0 = new jsfeat.matrix_t(3, 3, jsfeat.F32_t|jsfeat.C1_t);
    	var T1 = new jsfeat.matrix_t(3, 3, jsfeat.F32_t|jsfeat.C1_t);
    	var AtA = new jsfeat.matrix_t(6, 6, jsfeat.F32_t|jsfeat.C1_t);
    	var AtB = new jsfeat.matrix_t(6, 1, jsfeat.F32_t|jsfeat.C1_t);
    	
    	var affine2d = (function () {

	        function affine2d() {
	        	// empty constructor
	        }

	        affine2d.prototype.run = function(from, to, model, count) {
	        	var i=0,j=0;
	        	var dt=model.type|jsfeat.C1_t;
	        	var md=model.data, t0d=T0.data, t1d=T1.data;
	        	var pt0,pt1,px=0.0,py=0.0;

	            iso_normalize_points(from, to, t0d, t1d, count);

	            var a_buff = jsfeat.cache.get_buffer((2*count*6)<<3);
                var b_buff = jsfeat.cache.get_buffer((2*count)<<3);

                var a_mt = new jsfeat.matrix_t(6, 2*count, dt, a_buff.data);
                var b_mt = new jsfeat.matrix_t(1, 2*count, dt, b_buff.data);
                var ad=a_mt.data, bd=b_mt.data;

			    for (; i < count; ++i) {
			    	pt0 = from[i];
			        pt1 = to[i];

			        px = t0d[0]*pt0.x + t0d[1]*pt0.y + t0d[2];
			        py = t0d[3]*pt0.x + t0d[4]*pt0.y + t0d[5];

			        j = i*2*6;
			        ad[j]=px, ad[j+1]=py, ad[j+2]=1.0, ad[j+3]=0.0, ad[j+4]=0.0, ad[j+5]=0.0;

			        j += 6;
			        ad[j]=0.0, ad[j+1]=0.0, ad[j+2]=0.0, ad[j+3]=px, ad[j+4]=py, ad[j+5]=1.0;

			        bd[i<<1] = t1d[0]*pt1.x + t1d[1]*pt1.y + t1d[2];
			        bd[(i<<1)+1] = t1d[3]*pt1.x + t1d[4]*pt1.y + t1d[5];
			    }

			    jsfeat.matmath.multiply_AtA(AtA, a_mt);
			    jsfeat.matmath.multiply_AtB(AtB, a_mt, b_mt);

			    jsfeat.linalg.lu_solve(AtA, AtB);

			    md[0] = AtB.data[0], md[1]=AtB.data[1], md[2]=AtB.data[2];
			    md[3] = AtB.data[3], md[4]=AtB.data[4], md[5]=AtB.data[5];
			    md[6] = 0.0, md[7] = 0.0, md[8] = 1.0; // fill last row

			    // denormalize
			    jsfeat.matmath.invert_3x3(T1, T1);
			    jsfeat.matmath.multiply_3x3(model, T1, model);
			    jsfeat.matmath.multiply_3x3(model, model, T0);

			    // free buffer
			    jsfeat.cache.put_buffer(a_buff);
			    jsfeat.cache.put_buffer(b_buff);

			    return 1;
	        };

	        affine2d.prototype.error = function(from, to, model, err, count) {
	        	var i=0;
	        	var pt0,pt1;
	        	var m=model.data;

			    for (; i < count; ++i) {
			        pt0 = from[i];
			        pt1 = to[i];

			        err[i] = sqr(pt1.x - m[0]*pt0.x - m[1]*pt0.y - m[2]) +
			                 sqr(pt1.y - m[3]*pt0.x - m[4]*pt0.y - m[5]);
			    }
	        };

	        affine2d.prototype.check_subset = function(from, to, count) {
	            return true; // all good
	        };

	        return affine2d;
	    })();

	    var mLtL = new jsfeat.matrix_t(9, 9, jsfeat.F32_t|jsfeat.C1_t);
	    var Evec = new jsfeat.matrix_t(9, 9, jsfeat.F32_t|jsfeat.C1_t);

	    var homography2d = (function () {

	        function homography2d() {
	        	// empty constructor
	        	//this.T0 = new jsfeat.matrix_t(3, 3, jsfeat.F32_t|jsfeat.C1_t);
	        	//this.T1 = new jsfeat.matrix_t(3, 3, jsfeat.F32_t|jsfeat.C1_t);
	        	//this.mLtL = new jsfeat.matrix_t(9, 9, jsfeat.F32_t|jsfeat.C1_t);
	        	//this.Evec = new jsfeat.matrix_t(9, 9, jsfeat.F32_t|jsfeat.C1_t);
	        }

	        homography2d.prototype.run = function(from, to, model, count) {
	        	var i=0,j=0;
	        	var md=model.data, t0d=T0.data, t1d=T1.data;
	        	var LtL=mLtL.data, evd=Evec.data;
	        	var x=0.0,y=0.0,X=0.0,Y=0.0;

			    // norm
				var smx=0.0, smy=0.0, cmx=0.0, cmy=0.0, sMx=0.0, sMy=0.0, cMx=0.0, cMy=0.0;

				for(; i < count; ++i) {
				    cmx += to[i].x;
				    cmy += to[i].y;
				    cMx += from[i].x;
				    cMy += from[i].y;
				}

			    cmx /= count; cmy /= count;
			    cMx /= count; cMy /= count;

			    for(i = 0; i < count; ++i)
			    {
				    smx += Math.abs(to[i].x - cmx);
				    smy += Math.abs(to[i].y - cmy);
				    sMx += Math.abs(from[i].x - cMx);
				    sMy += Math.abs(from[i].y - cMy);
				}

			    if( Math.abs(smx) < jsfeat.EPSILON 
			    	|| Math.abs(smy) < jsfeat.EPSILON 
			    	|| Math.abs(sMx) < jsfeat.EPSILON 
			    	|| Math.abs(sMy) < jsfeat.EPSILON ) return 0;

			    smx = count/smx; smy = count/smy;
			    sMx = count/sMx; sMy = count/sMy;

			    t0d[0] = sMx; 	t0d[1] = 0; 	t0d[2] = -cMx*sMx; 
			    t0d[3] = 0; 	t0d[4] = sMy; 	t0d[5] = -cMy*sMy; 
			    t0d[6] = 0; 	t0d[7] = 0; 	t0d[8] = 1;

				t1d[0] = 1.0/smx; 	t1d[1] = 0; 		t1d[2] = cmx;
				t1d[3] = 0; 		t1d[4] = 1.0/smy; 	t1d[5] = cmy;
				t1d[6] = 0; 		t1d[7] = 0; 		t1d[8] = 1;
				//

				// construct system
				i = 81;
				while(--i >= 0) {
					LtL[i] = 0.0;
				}
				for(i = 0; i < count; ++i) {
					x = (to[i].x - cmx) * smx;
					y = (to[i].y - cmy) * smy;
					X = (from[i].x - cMx) * sMx;
					Y = (from[i].y - cMy) * sMy;

					LtL[0] += X*X;
					LtL[1] += X*Y;
					LtL[2] += X;

					LtL[6] += X*-x*X;
					LtL[7] += X*-x*Y;
					LtL[8] += X*-x;
					LtL[10] += Y*Y;
					LtL[11] += Y;

					LtL[15] += Y*-x*X;
					LtL[16] += Y*-x*Y;
					LtL[17] += Y*-x;
					LtL[20] += 1.0;

					LtL[24] += -x*X;
					LtL[25] += -x*Y;
					LtL[26] += -x;
					LtL[30] += X*X;
					LtL[31] += X*Y;
					LtL[32] += X;
					LtL[33] += X*-y*X;
					LtL[34] += X*-y*Y;
					LtL[35] += X*-y;
					LtL[40] += Y*Y;
					LtL[41] += Y;
					LtL[42] += Y*-y*X;
					LtL[43] += Y*-y*Y;
					LtL[44] += Y*-y;
					LtL[50] += 1.0;
					LtL[51] += -y*X;
					LtL[52] += -y*Y;
					LtL[53] += -y;
					LtL[60] += -x*X*-x*X + -y*X*-y*X;
					LtL[61] += -x*X*-x*Y + -y*X*-y*Y;
					LtL[62] += -x*X*-x + -y*X*-y;
					LtL[70] += -x*Y*-x*Y + -y*Y*-y*Y;
					LtL[71] += -x*Y*-x + -y*Y*-y;
					LtL[80] += -x*-x + -y*-y;
				}
				//

				// symmetry
			    for(i = 0; i < 9; ++i) {
			        for(j = 0; j < i; ++j)
			            LtL[i*9+j] = LtL[j*9+i];
			    }

				jsfeat.linalg.eigenVV(mLtL, Evec);

				md[0]=evd[72], md[1]=evd[73], md[2]=evd[74];
			    md[3]=evd[75], md[4]=evd[76], md[5]=evd[77];
			    md[6]=evd[78], md[7]=evd[79], md[8]=evd[80];

				// denormalize
			    jsfeat.matmath.multiply_3x3(model, T1, model);
			    jsfeat.matmath.multiply_3x3(model, model, T0);

			    // set bottom right to 1.0
			    x = 1.0/md[8];
			    md[0] *= x; md[1] *= x; md[2] *= x;
			    md[3] *= x; md[4] *= x; md[5] *= x;
			    md[6] *= x; md[7] *= x; md[8] = 1.0;

			    return 1;
	        };

	        homography2d.prototype.error = function(from, to, model, err, count) {
	        	var i=0;
	        	var pt0,pt1,ww=0.0,dx=0.0,dy=0.0;
	        	var m=model.data;

			    for (; i < count; ++i) {
			        pt0 = from[i];
			        pt1 = to[i];

			        ww = 1.0/(m[6]*pt0.x + m[7]*pt0.y + 1.0);
			        dx = (m[0]*pt0.x + m[1]*pt0.y + m[2])*ww - pt1.x;
			        dy = (m[3]*pt0.x + m[4]*pt0.y + m[5])*ww - pt1.y;
			        err[i] = (dx*dx + dy*dy);
			    }
	        };

	        homography2d.prototype.check_subset = function(from, to, count) {
	        	// seems to reject good subsets actually
	        	//if( have_collinear_points(from, count) || have_collinear_points(to, count) ) {
        			//return false;
        		//}
        		if( count == 4 ) {
			        var negative = 0;

			        var fp0=from[0],fp1=from[1],fp2=from[2],fp3=from[3];
			        var tp0=to[0],tp1=to[1],tp2=to[2],tp3=to[3];

			        // set1
			        var A11=fp0.x, A12=fp0.y, A13=1.0;
			        var A21=fp1.x, A22=fp1.y, A23=1.0;
			        var A31=fp2.x, A32=fp2.y, A33=1.0;

			        var B11=tp0.x, B12=tp0.y, B13=1.0;
			        var B21=tp1.x, B22=tp1.y, B23=1.0;
			        var B31=tp2.x, B32=tp2.y, B33=1.0;

			        var detA = jsfeat.matmath.determinant_3x3(A11,A12,A13, A21,A22,A23, A31,A32,A33);
					var detB = jsfeat.matmath.determinant_3x3(B11,B12,B13, B21,B22,B23, B31,B32,B33);

					if(detA*detB < 0) negative++;

					// set2
					A11=fp1.x, A12=fp1.y;
			        A21=fp2.x, A22=fp2.y;
			        A31=fp3.x, A32=fp3.y;

			        B11=tp1.x, B12=tp1.y;
			        B21=tp2.x, B22=tp2.y;
			        B31=tp3.x, B32=tp3.y;

			        detA = jsfeat.matmath.determinant_3x3(A11,A12,A13, A21,A22,A23, A31,A32,A33);
					detB = jsfeat.matmath.determinant_3x3(B11,B12,B13, B21,B22,B23, B31,B32,B33);

					if(detA*detB < 0) negative++;

					// set3
					A11=fp0.x, A12=fp0.y;
			        A21=fp2.x, A22=fp2.y;
			        A31=fp3.x, A32=fp3.y;

			        B11=tp0.x, B12=tp0.y;
			        B21=tp2.x, B22=tp2.y;
			        B31=tp3.x, B32=tp3.y;

			        detA = jsfeat.matmath.determinant_3x3(A11,A12,A13, A21,A22,A23, A31,A32,A33);
					detB = jsfeat.matmath.determinant_3x3(B11,B12,B13, B21,B22,B23, B31,B32,B33);

					if(detA*detB < 0) negative++;

					// set4
					A11=fp0.x, A12=fp0.y;
			        A21=fp1.x, A22=fp1.y;
			        A31=fp3.x, A32=fp3.y;

			        B11=tp0.x, B12=tp0.y;
			        B21=tp1.x, B22=tp1.y;
			        B31=tp3.x, B32=tp3.y;

			        detA = jsfeat.matmath.determinant_3x3(A11,A12,A13, A21,A22,A23, A31,A32,A33);
					detB = jsfeat.matmath.determinant_3x3(B11,B12,B13, B21,B22,B23, B31,B32,B33);

					if(detA*detB < 0) negative++;

			        if(negative != 0 && negative != 4) {
			        	return false;
			        }
			    }
	            return true; // all good
	        };

	        return homography2d;
	    })();

	    return {

    		affine2d:affine2d,
    		homography2d:homography2d

    	};

    })();

    var ransac_params_t = (function () {
        function ransac_params_t(size, thresh, eps, prob) {
            if (typeof size === "undefined") { size=0; }
            if (typeof thresh === "undefined") { thresh=0.5; }
            if (typeof eps === "undefined") { eps=0.5; }
            if (typeof prob === "undefined") { prob=0.99; }

            this.size = size;
            this.thresh = thresh;
            this.eps = eps;
            this.prob = prob;
        }
        ransac_params_t.prototype.update_iters = function(_eps, max_iters) {
	        var num = Math.log(1 - this.prob);
	        var denom = Math.log(1 - Math.pow(1 - _eps, this.size));
	        return (denom >= 0 || -num >= max_iters*(-denom) ? max_iters : Math.round(num/denom))|0;
        };
        return ransac_params_t;
    })();

    var motion_estimator = (function() {

    	var get_subset = function(kernel, from, to, need_cnt, max_cnt, from_sub, to_sub) {
    		var max_try = 1000;
    		var indices = [];
		    var i=0, j=0, ssiter=0, idx_i=0, ok=false;
		    for(; ssiter < max_try; ++ssiter)  {
		        i = 0;
		        for (; i < need_cnt && ssiter < max_try;) {
		            ok = false;
		            idx_i = 0;
		            while (!ok) {
		                ok = true;
		                idx_i = indices[i] = Math.floor(Math.random() * max_cnt)|0;
		                for (j = 0; j < i; ++j) {
		                    if (idx_i == indices[j])
		                    { ok = false; break; }
		                }
		            }
		            from_sub[i] = from[idx_i];
		            to_sub[i] = to[idx_i];
		            if( !kernel.check_subset( from_sub, to_sub, i+1 ) ) {
		                ssiter++;
		                continue;
		            }
		            ++i;
		        }
		        break;
		    }

		    return (i == need_cnt && ssiter < max_try);
    	};

    	var find_inliers = function(kernel, model, from, to, count, thresh, err, mask) {
    		var numinliers = 0, i=0, f=0;
    		var t = thresh*thresh;

    		kernel.error(from, to, model, err, count);

		    for(; i < count; ++i) {
		        f = err[i] <= t;
		        mask[i] = f;
		        numinliers += f;
		    }
		    return numinliers;
    	};

    	return {

    		ransac: function(params, kernel, from, to, count, model, mask, max_iters) {
    			if (typeof max_iters === "undefined") { max_iters=1000; }

    			if(count < params.size) return false;

    			var model_points = params.size;
			    var niters = max_iters, iter=0;
			    var result = false;

			    var subset0 = [];
			    var subset1 = [];
			    var found = false;

			    var mc=model.cols,mr=model.rows;
                var dt = model.type | jsfeat.C1_t;

			    var m_buff = jsfeat.cache.get_buffer((mc*mr)<<3);
			    var ms_buff = jsfeat.cache.get_buffer(count);
			    var err_buff = jsfeat.cache.get_buffer(count<<2);
			    var M = new jsfeat.matrix_t(mc, mr, dt, m_buff.data);
			    var curr_mask = new jsfeat.matrix_t(count, 1, jsfeat.U8C1_t, ms_buff.data);

			    var inliers_max = -1, numinliers=0;
			    var nmodels = 0;

			    var err = err_buff.f32;

			    // special case
			    if(count == model_points) {
			        if(kernel.run(from, to, M, count) <= 0) {
			        	jsfeat.cache.put_buffer(m_buff);
			        	jsfeat.cache.put_buffer(ms_buff);
			        	jsfeat.cache.put_buffer(err_buff);
			        	return false;
			        }

			        M.copy_to(model);
			        if(mask) {
			        	while(--count >= 0) {
			        		mask.data[count] = 1;
			        	}
			        }
			        jsfeat.cache.put_buffer(m_buff);
			        jsfeat.cache.put_buffer(ms_buff);
			        jsfeat.cache.put_buffer(err_buff);
			        return true;
			    }

			    for (; iter < niters; ++iter) {
			        // generate subset
			        found = get_subset(kernel, from, to, model_points, count, subset0, subset1);
			        if(!found) {
			            if(iter == 0) {
			            	jsfeat.cache.put_buffer(m_buff);
			            	jsfeat.cache.put_buffer(ms_buff);
			            	jsfeat.cache.put_buffer(err_buff);
			                return false;
			            }
			            break;
			        }

			        nmodels = kernel.run( subset0, subset1, M, model_points );
			        if(nmodels <= 0)
			            continue;

			        // TODO handle multimodel output

			        numinliers = find_inliers(kernel, M, from, to, count, params.thresh, err, curr_mask.data);

			        if( numinliers > Math.max(inliers_max, model_points-1) ) {
			            M.copy_to(model);
			            inliers_max = numinliers;
			            if(mask) curr_mask.copy_to(mask);
			            niters = params.update_iters((count - numinliers)/count, niters);
			            result = true;
			        }
			    }

			    jsfeat.cache.put_buffer(m_buff);
			    jsfeat.cache.put_buffer(ms_buff);
			    jsfeat.cache.put_buffer(err_buff);

			    return result;
    		},

    		lmeds: function(params, kernel, from, to, count, model, mask, max_iters) {
    			if (typeof max_iters === "undefined") { max_iters=1000; }

    			if(count < params.size) return false;

    			var model_points = params.size;
			    var niters = max_iters, iter=0;
			    var result = false;

			    var subset0 = [];
			    var subset1 = [];
			    var found = false;

			    var mc=model.cols,mr=model.rows;
                var dt = model.type | jsfeat.C1_t;

			    var m_buff = jsfeat.cache.get_buffer((mc*mr)<<3);
			    var ms_buff = jsfeat.cache.get_buffer(count);
			    var err_buff = jsfeat.cache.get_buffer(count<<2);
			    var M = new jsfeat.matrix_t(mc, mr, dt, m_buff.data);
			    var curr_mask = new jsfeat.matrix_t(count, 1, jsfeat.U8_t|jsfeat.C1_t, ms_buff.data);

			    var numinliers=0;
			    var nmodels = 0;

			    var err = err_buff.f32;
			    var min_median = 1000000000.0, sigma=0.0, median=0.0;

			    params.eps = 0.45;
			    niters = params.update_iters(params.eps, niters);

			    // special case
			    if(count == model_points) {
			        if(kernel.run(from, to, M, count) <= 0) {
			        	jsfeat.cache.put_buffer(m_buff);
			        	jsfeat.cache.put_buffer(ms_buff);
			        	jsfeat.cache.put_buffer(err_buff);
			        	return false;
			        }

			        M.copy_to(model);
			        if(mask) {
			        	while(--count >= 0) {
			        		mask.data[count] = 1;
			        	}
			        }
			        jsfeat.cache.put_buffer(m_buff);
			        jsfeat.cache.put_buffer(ms_buff);
			        jsfeat.cache.put_buffer(err_buff);
			        return true;
			    }

			    for (; iter < niters; ++iter) {
			        // generate subset
			        found = get_subset(kernel, from, to, model_points, count, subset0, subset1);
			        if(!found) {
			            if(iter == 0) {
			            	jsfeat.cache.put_buffer(m_buff);
			            	jsfeat.cache.put_buffer(ms_buff);
			            	jsfeat.cache.put_buffer(err_buff);
			                return false;
			            }
			            break;
			        }

			        nmodels = kernel.run( subset0, subset1, M, model_points );
			        if(nmodels <= 0)
			            continue;

			        // TODO handle multimodel output

			        kernel.error(from, to, M, err, count);
			        median = jsfeat.math.median(err, 0, count-1);

			        if(median < min_median) {
			            min_median = median;
			            M.copy_to(model);
			            result = true;
			        }
			    }

			    if(result) {
			        sigma = 2.5*1.4826*(1 + 5.0/(count - model_points))*Math.sqrt(min_median);
			        sigma = Math.max(sigma, 0.001);

			        numinliers = find_inliers(kernel, model, from, to, count, sigma, err, curr_mask.data);
			        if(mask) curr_mask.copy_to(mask);
			        
			        result = numinliers >= model_points;
			    }

			    jsfeat.cache.put_buffer(m_buff);
			    jsfeat.cache.put_buffer(ms_buff);
			    jsfeat.cache.put_buffer(err_buff);

			    return result;
    		}

    	};

    })();

    global.ransac_params_t = ransac_params_t;
    global.motion_model = motion_model;
    global.motion_estimator = motion_estimator;

})(jsfeat);
/**
 * @author Eugene Zatepyakin / http://inspirit.ru/
 */

(function(global) {
    "use strict";
    //

    var imgproc = (function() {

        var _resample_u8 = function(src, dst, nw, nh) {
            var xofs_count=0;
            var ch=src.channel,w=src.cols,h=src.rows;
            var src_d=src.data,dst_d=dst.data;
            var scale_x = w / nw, scale_y = h / nh;
            var inv_scale_256 = (scale_x * scale_y * 0x10000)|0;
            var dx=0,dy=0,sx=0,sy=0,sx1=0,sx2=0,i=0,k=0,fsx1=0.0,fsx2=0.0;
            var a=0,b=0,dxn=0,alpha=0,beta=0,beta1=0;

            var buf_node = jsfeat.cache.get_buffer((nw*ch)<<2);
            var sum_node = jsfeat.cache.get_buffer((nw*ch)<<2);
            var xofs_node = jsfeat.cache.get_buffer((w*2*3)<<2);

            var buf = buf_node.i32;
            var sum = sum_node.i32;
            var xofs = xofs_node.i32;

            for (; dx < nw; dx++) {
                fsx1 = dx * scale_x, fsx2 = fsx1 + scale_x;
                sx1 = (fsx1 + 1.0 - 1e-6)|0, sx2 = fsx2|0;
                sx1 = Math.min(sx1, w - 1);
                sx2 = Math.min(sx2, w - 1);

                if(sx1 > fsx1) {
                    xofs[k++] = (dx * ch)|0;
                    xofs[k++] = ((sx1 - 1)*ch)|0; 
                    xofs[k++] = ((sx1 - fsx1) * 0x100)|0;
                    xofs_count++;
                }
                for(sx = sx1; sx < sx2; sx++){
                    xofs_count++;
                    xofs[k++] = (dx * ch)|0;
                    xofs[k++] = (sx * ch)|0;
                    xofs[k++] = 256;
                }
                if(fsx2 - sx2 > 1e-3) {
                    xofs_count++;
                    xofs[k++] = (dx * ch)|0;
                    xofs[k++] = (sx2 * ch)|0;
                    xofs[k++] = ((fsx2 - sx2) * 256)|0;
                }
            }

            for (dx = 0; dx < nw * ch; dx++) {
                buf[dx] = sum[dx] = 0;
            }
            dy = 0;
            for (sy = 0; sy < h; sy++) {
                a = w * sy;
                for (k = 0; k < xofs_count; k++) {
                    dxn = xofs[k*3];
                    sx1 = xofs[k*3+1];
                    alpha = xofs[k*3+2];
                    for (i = 0; i < ch; i++) {
                        buf[dxn + i] += src_d[a+sx1+i] * alpha;
                    }
                }
                if ((dy + 1) * scale_y <= sy + 1 || sy == h - 1) {
                    beta = (Math.max(sy + 1 - (dy + 1) * scale_y, 0.0) * 256)|0;
                    beta1 = 256 - beta;
                    b = nw * dy;
                    if (beta <= 0) {
                        for (dx = 0; dx < nw * ch; dx++) {
                            dst_d[b+dx] = Math.min(Math.max((sum[dx] + buf[dx] * 256) / inv_scale_256, 0), 255);
                            sum[dx] = buf[dx] = 0;
                        }
                    } else {
                        for (dx = 0; dx < nw * ch; dx++) {
                            dst_d[b+dx] = Math.min(Math.max((sum[dx] + buf[dx] * beta1) / inv_scale_256, 0), 255);
                            sum[dx] = buf[dx] * beta;
                            buf[dx] = 0;
                        }
                    }
                    dy++;
                } else {
                    for(dx = 0; dx < nw * ch; dx++) {
                        sum[dx] += buf[dx] * 256;
                        buf[dx] = 0;
                    }
                }
            }

            jsfeat.cache.put_buffer(sum_node);
            jsfeat.cache.put_buffer(buf_node);
            jsfeat.cache.put_buffer(xofs_node);
        };

        var _resample = function(src, dst, nw, nh) {
            var xofs_count=0;
            var ch=src.channel,w=src.cols,h=src.rows;
            var src_d=src.data,dst_d=dst.data;
            var scale_x = w / nw, scale_y = h / nh;
            var scale = 1.0 / (scale_x * scale_y);
            var dx=0,dy=0,sx=0,sy=0,sx1=0,sx2=0,i=0,k=0,fsx1=0.0,fsx2=0.0;
            var a=0,b=0,dxn=0,alpha=0.0,beta=0.0,beta1=0.0;

            var buf_node = jsfeat.cache.get_buffer((nw*ch)<<2);
            var sum_node = jsfeat.cache.get_buffer((nw*ch)<<2);
            var xofs_node = jsfeat.cache.get_buffer((w*2*3)<<2);

            var buf = buf_node.f32;
            var sum = sum_node.f32;
            var xofs = xofs_node.f32;

            for (; dx < nw; dx++) {
                fsx1 = dx * scale_x, fsx2 = fsx1 + scale_x;
                sx1 = (fsx1 + 1.0 - 1e-6)|0, sx2 = fsx2|0;
                sx1 = Math.min(sx1, w - 1);
                sx2 = Math.min(sx2, w - 1);

                if(sx1 > fsx1) {
                    xofs_count++;
                    xofs[k++] = ((sx1 - 1)*ch)|0;
                    xofs[k++] = (dx * ch)|0;
                    xofs[k++] = (sx1 - fsx1) * scale;
                }
                for(sx = sx1; sx < sx2; sx++){
                    xofs_count++;
                    xofs[k++] = (sx * ch)|0;
                    xofs[k++] = (dx * ch)|0; 
                    xofs[k++] = scale;
                }
                if(fsx2 - sx2 > 1e-3) {
                    xofs_count++;
                    xofs[k++] = (sx2 * ch)|0;
                    xofs[k++] = (dx * ch)|0;
                    xofs[k++] = (fsx2 - sx2) * scale;
                }
            }

            for (dx = 0; dx < nw * ch; dx++) {
                buf[dx] = sum[dx] = 0;
            }
            dy = 0;
            for (sy = 0; sy < h; sy++) {
                a = w * sy;
                for (k = 0; k < xofs_count; k++) {
                    sx1 = xofs[k*3]|0;
                    dxn = xofs[k*3+1]|0;
                    alpha = xofs[k*3+2];
                    for (i = 0; i < ch; i++) {
                        buf[dxn + i] += src_d[a+sx1+i] * alpha;
                    }
                }
                if ((dy + 1) * scale_y <= sy + 1 || sy == h - 1) {
                    beta = Math.max(sy + 1 - (dy + 1) * scale_y, 0.0);
                    beta1 = 1.0 - beta;
                    b = nw * dy;
                    if (Math.abs(beta) < 1e-3) {
                        for (dx = 0; dx < nw * ch; dx++) {
                            dst_d[b+dx] = sum[dx] + buf[dx];
                            sum[dx] = buf[dx] = 0;
                        }
                    } else {
                        for (dx = 0; dx < nw * ch; dx++) {
                            dst_d[b+dx] = sum[dx] + buf[dx] * beta1;
                            sum[dx] = buf[dx] * beta;
                            buf[dx] = 0;
                        }
                    }
                    dy++;
                } else {
                    for(dx = 0; dx < nw * ch; dx++) {
                        sum[dx] += buf[dx]; 
                        buf[dx] = 0;
                    }
                }
            }
            jsfeat.cache.put_buffer(sum_node);
            jsfeat.cache.put_buffer(buf_node);
            jsfeat.cache.put_buffer(xofs_node);
        };

        var _convol_u8 = function(buf, src_d, dst_d, w, h, filter, kernel_size, half_kernel) {
            var i=0,j=0,k=0,sp=0,dp=0,sum=0,sum1=0,sum2=0,sum3=0,f0=filter[0],fk=0;
            var w2=w<<1,w3=w*3,w4=w<<2;
            // hor pass
            for (; i < h; ++i) { 
                sum = src_d[sp];
                for (j = 0; j < half_kernel; ++j) {
                    buf[j] = sum;
                }
                for (j = 0; j <= w-2; j+=2) {
                    buf[j + half_kernel] = src_d[sp+j];
                    buf[j + half_kernel+1] = src_d[sp+j+1];
                }
                for (; j < w; ++j) {
                    buf[j + half_kernel] = src_d[sp+j];
                }
                sum = src_d[sp+w-1];
                for (j = w; j < half_kernel + w; ++j) {
                    buf[j + half_kernel] = sum;
                }
                for (j = 0; j <= w-4; j+=4) {
                    sum = buf[j] * f0, 
                    sum1 = buf[j+1] * f0,
                    sum2 = buf[j+2] * f0,
                    sum3 = buf[j+3] * f0;
                    for (k = 1; k < kernel_size; ++k) {
                        fk = filter[k];
                        sum += buf[k + j] * fk;
                        sum1 += buf[k + j+1] * fk;
                        sum2 += buf[k + j+2] * fk;
                        sum3 += buf[k + j+3] * fk;
                    }
                    dst_d[dp+j] = Math.min(sum >> 8, 255);
                    dst_d[dp+j+1] = Math.min(sum1 >> 8, 255);
                    dst_d[dp+j+2] = Math.min(sum2 >> 8, 255);
                    dst_d[dp+j+3] = Math.min(sum3 >> 8, 255);
                }
                for (; j < w; ++j) {
                    sum = buf[j] * f0;
                    for (k = 1; k < kernel_size; ++k) {
                        sum += buf[k + j] * filter[k];
                    }
                    dst_d[dp+j] = Math.min(sum >> 8, 255);
                }
                sp += w;
                dp += w;
            }

            // vert pass
            for (i = 0; i < w; ++i) {
                sum = dst_d[i];
                for (j = 0; j < half_kernel; ++j) {
                    buf[j] = sum;
                }
                k = i;
                for (j = 0; j <= h-2; j+=2, k+=w2) {
                    buf[j+half_kernel] = dst_d[k];
                    buf[j+half_kernel+1] = dst_d[k+w];
                }
                for (; j < h; ++j, k+=w) {
                    buf[j+half_kernel] = dst_d[k];
                }
                sum = dst_d[(h-1)*w + i];
                for (j = h; j < half_kernel + h; ++j) {
                    buf[j + half_kernel] = sum;
                }
                dp = i;
                for (j = 0; j <= h-4; j+=4, dp+=w4) { 
                    sum = buf[j] * f0, 
                    sum1 = buf[j+1] * f0,
                    sum2 = buf[j+2] * f0,
                    sum3 = buf[j+3] * f0;
                    for (k = 1; k < kernel_size; ++k) {
                        fk = filter[k];
                        sum += buf[k + j] * fk;
                        sum1 += buf[k + j+1] * fk;
                        sum2 += buf[k + j+2] * fk;
                        sum3 += buf[k + j+3] * fk;
                    }
                    dst_d[dp] = Math.min(sum >> 8, 255);
                    dst_d[dp+w] = Math.min(sum1 >> 8, 255);
                    dst_d[dp+w2] = Math.min(sum2 >> 8, 255);
                    dst_d[dp+w3] = Math.min(sum3 >> 8, 255);
                }
                for (; j < h; ++j, dp+=w) {
                    sum = buf[j] * f0;
                    for (k = 1; k < kernel_size; ++k) {
                        sum += buf[k + j] * filter[k];
                    }
                    dst_d[dp] = Math.min(sum >> 8, 255);
                }
            }
        };

        var _convol = function(buf, src_d, dst_d, w, h, filter, kernel_size, half_kernel) {
            var i=0,j=0,k=0,sp=0,dp=0,sum=0.0,sum1=0.0,sum2=0.0,sum3=0.0,f0=filter[0],fk=0.0;
            var w2=w<<1,w3=w*3,w4=w<<2;
            // hor pass
            for (; i < h; ++i) { 
                sum = src_d[sp];
                for (j = 0; j < half_kernel; ++j) {
                    buf[j] = sum;
                }
                for (j = 0; j <= w-2; j+=2) {
                    buf[j + half_kernel] = src_d[sp+j];
                    buf[j + half_kernel+1] = src_d[sp+j+1];
                }
                for (; j < w; ++j) {
                    buf[j + half_kernel] = src_d[sp+j];
                }
                sum = src_d[sp+w-1];
                for (j = w; j < half_kernel + w; ++j) {
                    buf[j + half_kernel] = sum;
                }
                for (j = 0; j <= w-4; j+=4) {
                    sum = buf[j] * f0, 
                    sum1 = buf[j+1] * f0,
                    sum2 = buf[j+2] * f0,
                    sum3 = buf[j+3] * f0;
                    for (k = 1; k < kernel_size; ++k) {
                        fk = filter[k];
                        sum += buf[k + j] * fk;
                        sum1 += buf[k + j+1] * fk;
                        sum2 += buf[k + j+2] * fk;
                        sum3 += buf[k + j+3] * fk;
                    }
                    dst_d[dp+j] = sum;
                    dst_d[dp+j+1] = sum1;
                    dst_d[dp+j+2] = sum2;
                    dst_d[dp+j+3] = sum3;
                }
                for (; j < w; ++j) {
                    sum = buf[j] * f0;
                    for (k = 1; k < kernel_size; ++k) {
                        sum += buf[k + j] * filter[k];
                    }
                    dst_d[dp+j] = sum;
                }
                sp += w;
                dp += w;
            }

            // vert pass
            for (i = 0; i < w; ++i) {
                sum = dst_d[i];
                for (j = 0; j < half_kernel; ++j) {
                    buf[j] = sum;
                }
                k = i;
                for (j = 0; j <= h-2; j+=2, k+=w2) {
                    buf[j+half_kernel] = dst_d[k];
                    buf[j+half_kernel+1] = dst_d[k+w];
                }
                for (; j < h; ++j, k+=w) {
                    buf[j+half_kernel] = dst_d[k];
                }
                sum = dst_d[(h-1)*w + i];
                for (j = h; j < half_kernel + h; ++j) {
                    buf[j + half_kernel] = sum;
                }
                dp = i;
                for (j = 0; j <= h-4; j+=4, dp+=w4) { 
                    sum = buf[j] * f0, 
                    sum1 = buf[j+1] * f0,
                    sum2 = buf[j+2] * f0,
                    sum3 = buf[j+3] * f0;
                    for (k = 1; k < kernel_size; ++k) {
                        fk = filter[k];
                        sum += buf[k + j] * fk;
                        sum1 += buf[k + j+1] * fk;
                        sum2 += buf[k + j+2] * fk;
                        sum3 += buf[k + j+3] * fk;
                    }
                    dst_d[dp] = sum;
                    dst_d[dp+w] = sum1;
                    dst_d[dp+w2] = sum2;
                    dst_d[dp+w3] = sum3;
                }
                for (; j < h; ++j, dp+=w) {
                    sum = buf[j] * f0;
                    for (k = 1; k < kernel_size; ++k) {
                        sum += buf[k + j] * filter[k];
                    }
                    dst_d[dp] = sum;
                }
            }
        };

        return {
            // TODO: add support for RGB/BGR order
            // for raw arrays
            grayscale: function(src, w, h, dst, code) {
                // this is default image data representation in browser
                if (typeof code === "undefined") { code = jsfeat.COLOR_RGBA2GRAY; }
                var x=0, y=0, i=0, j=0, ir=0,jr=0;
                var coeff_r = 4899, coeff_g = 9617, coeff_b = 1868, cn = 4;

                if(code == jsfeat.COLOR_BGRA2GRAY || code == jsfeat.COLOR_BGR2GRAY) {
                    coeff_r = 1868;
                    coeff_b = 4899;
                }
                if(code == jsfeat.COLOR_RGB2GRAY || code == jsfeat.COLOR_BGR2GRAY) {
                    cn = 3;
                }
                var cn2 = cn<<1, cn3 = (cn*3)|0;

                dst.resize(w, h, 1);
                var dst_u8 = dst.data;

                for(y = 0; y < h; ++y, j+=w, i+=w*cn) {
                    for(x = 0, ir = i, jr = j; x <= w-4; x+=4, ir+=cn<<2, jr+=4) {
                        dst_u8[jr]     = (src[ir] * coeff_r + src[ir+1] * coeff_g + src[ir+2] * coeff_b + 8192) >> 14;
                        dst_u8[jr + 1] = (src[ir+cn] * coeff_r + src[ir+cn+1] * coeff_g + src[ir+cn+2] * coeff_b + 8192) >> 14;
                        dst_u8[jr + 2] = (src[ir+cn2] * coeff_r + src[ir+cn2+1] * coeff_g + src[ir+cn2+2] * coeff_b + 8192) >> 14;
                        dst_u8[jr + 3] = (src[ir+cn3] * coeff_r + src[ir+cn3+1] * coeff_g + src[ir+cn3+2] * coeff_b + 8192) >> 14;
                    }
                    for (; x < w; ++x, ++jr, ir+=cn) {
                        dst_u8[jr] = (src[ir] * coeff_r + src[ir+1] * coeff_g + src[ir+2] * coeff_b + 8192) >> 14;
                    }
                }
            },
            // derived from CCV library
            resample: function(src, dst, nw, nh) {
                var h=src.rows,w=src.cols;
                if (h > nh && w > nw) {
                    dst.resize(nw, nh, src.channel);
                    // using the fast alternative (fix point scale, 0x100 to avoid overflow)
                    if (src.type&jsfeat.U8_t && dst.type&jsfeat.U8_t && h * w / (nh * nw) < 0x100) {
                        _resample_u8(src, dst, nw, nh);
                    } else {
                        _resample(src, dst, nw, nh);
                    }
                }
            },

            box_blur_gray: function(src, dst, radius, options) {
                if (typeof options === "undefined") { options = 0; }
                var w=src.cols, h=src.rows, h2=h<<1, w2=w<<1;
                var i=0,x=0,y=0,end=0;
                var windowSize = ((radius << 1) + 1)|0;
                var radiusPlusOne = (radius + 1)|0, radiusPlus2 = (radiusPlusOne+1)|0;
                var scale = options&jsfeat.BOX_BLUR_NOSCALE ? 1 : (1.0 / (windowSize*windowSize));

                var tmp_buff = jsfeat.cache.get_buffer((w*h)<<2);

                var sum=0, dstIndex=0, srcIndex = 0, nextPixelIndex=0, previousPixelIndex=0;
                var data_i32 = tmp_buff.i32; // to prevent overflow
                var data_u8 = src.data;
                var hold=0;

                dst.resize(w, h, src.channel);

                // first pass
                // no need to scale 
                //data_u8 = src.data;
                //data_i32 = tmp;
                for (y = 0; y < h; ++y) {
                    dstIndex = y;
                    sum = radiusPlusOne * data_u8[srcIndex];

                    for(i = (srcIndex+1)|0, end=(srcIndex+radius)|0; i <= end; ++i) {
                        sum += data_u8[i];
                    }

                    nextPixelIndex = (srcIndex + radiusPlusOne)|0;
                    previousPixelIndex = srcIndex;
                    hold = data_u8[previousPixelIndex];
                    for(x = 0; x < radius; ++x, dstIndex += h) {
                        data_i32[dstIndex] = sum;
                        sum += data_u8[nextPixelIndex]- hold;
                        nextPixelIndex ++;
                    }
                    for(; x < w-radiusPlus2; x+=2, dstIndex += h2) {
                        data_i32[dstIndex] = sum;
                        sum += data_u8[nextPixelIndex]- data_u8[previousPixelIndex];

                        data_i32[dstIndex+h] = sum;
                        sum += data_u8[nextPixelIndex+1]- data_u8[previousPixelIndex+1];

                        nextPixelIndex +=2;
                        previousPixelIndex +=2;
                    }
                    for(; x < w-radiusPlusOne; ++x, dstIndex += h) {
                        data_i32[dstIndex] = sum;
                        sum += data_u8[nextPixelIndex]- data_u8[previousPixelIndex];

                        nextPixelIndex ++;
                        previousPixelIndex ++;
                    }
                    
                    hold = data_u8[nextPixelIndex-1];
                    for(; x < w; ++x, dstIndex += h) {
                        data_i32[dstIndex] = sum;

                        sum += hold- data_u8[previousPixelIndex];
                        previousPixelIndex ++;
                    }

                    srcIndex += w;
                }
                //
                // second pass
                srcIndex = 0;
                //data_i32 = tmp; // this is a transpose
                data_u8 = dst.data;

                // dont scale result
                if(scale == 1) {
                    for (y = 0; y < w; ++y) {
                        dstIndex = y;
                        sum = radiusPlusOne * data_i32[srcIndex];

                        for(i = (srcIndex+1)|0, end=(srcIndex+radius)|0; i <= end; ++i) {
                            sum += data_i32[i];
                        }

                        nextPixelIndex = srcIndex + radiusPlusOne;
                        previousPixelIndex = srcIndex;
                        hold = data_i32[previousPixelIndex];

                        for(x = 0; x < radius; ++x, dstIndex += w) {
                            data_u8[dstIndex] = sum;
                            sum += data_i32[nextPixelIndex]- hold;
                            nextPixelIndex ++;
                        }
                        for(; x < h-radiusPlus2; x+=2, dstIndex += w2) {
                            data_u8[dstIndex] = sum;
                            sum += data_i32[nextPixelIndex]- data_i32[previousPixelIndex];

                            data_u8[dstIndex+w] = sum;
                            sum += data_i32[nextPixelIndex+1]- data_i32[previousPixelIndex+1];

                            nextPixelIndex +=2;
                            previousPixelIndex +=2;
                        }
                        for(; x < h-radiusPlusOne; ++x, dstIndex += w) {
                            data_u8[dstIndex] = sum;

                            sum += data_i32[nextPixelIndex]- data_i32[previousPixelIndex];
                            nextPixelIndex ++;
                            previousPixelIndex ++;
                        }
                        hold = data_i32[nextPixelIndex-1];
                        for(; x < h; ++x, dstIndex += w) {
                            data_u8[dstIndex] = sum;

                            sum += hold- data_i32[previousPixelIndex];
                            previousPixelIndex ++;
                        }

                        srcIndex += h;
                    }
                } else {
                    for (y = 0; y < w; ++y) {
                        dstIndex = y;
                        sum = radiusPlusOne * data_i32[srcIndex];

                        for(i = (srcIndex+1)|0, end=(srcIndex+radius)|0; i <= end; ++i) {
                            sum += data_i32[i];
                        }

                        nextPixelIndex = srcIndex + radiusPlusOne;
                        previousPixelIndex = srcIndex;
                        hold = data_i32[previousPixelIndex];

                        for(x = 0; x < radius; ++x, dstIndex += w) {
                            data_u8[dstIndex] = sum*scale;
                            sum += data_i32[nextPixelIndex]- hold;
                            nextPixelIndex ++;
                        }
                        for(; x < h-radiusPlus2; x+=2, dstIndex += w2) {
                            data_u8[dstIndex] = sum*scale;
                            sum += data_i32[nextPixelIndex]- data_i32[previousPixelIndex];

                            data_u8[dstIndex+w] = sum*scale;
                            sum += data_i32[nextPixelIndex+1]- data_i32[previousPixelIndex+1];

                            nextPixelIndex +=2;
                            previousPixelIndex +=2;
                        }
                        for(; x < h-radiusPlusOne; ++x, dstIndex += w) {
                            data_u8[dstIndex] = sum*scale;

                            sum += data_i32[nextPixelIndex]- data_i32[previousPixelIndex];
                            nextPixelIndex ++;
                            previousPixelIndex ++;
                        }
                        hold = data_i32[nextPixelIndex-1];
                        for(; x < h; ++x, dstIndex += w) {
                            data_u8[dstIndex] = sum*scale;

                            sum += hold- data_i32[previousPixelIndex];
                            previousPixelIndex ++;
                        }

                        srcIndex += h;
                    }
                }

                jsfeat.cache.put_buffer(tmp_buff);
            },

            gaussian_blur: function(src, dst, kernel_size, sigma) {
                if (typeof sigma === "undefined") { sigma = 0.0; }
                if (typeof kernel_size === "undefined") { kernel_size = 0; }
                kernel_size = kernel_size == 0 ? (Math.max(1, (4.0 * sigma + 1.0 - 1e-8)) * 2 + 1)|0 : kernel_size;
                var half_kernel = kernel_size >> 1;
                var w = src.cols, h = src.rows;
                var data_type = src.type, is_u8 = data_type&jsfeat.U8_t;

                dst.resize(w, h, src.channel);

                var src_d = src.data, dst_d = dst.data;
                var buf,filter,buf_sz=(kernel_size + Math.max(h, w))|0;

                var buf_node = jsfeat.cache.get_buffer(buf_sz<<2);
                var filt_node = jsfeat.cache.get_buffer(kernel_size<<2);

                if(is_u8) {
                    buf = buf_node.i32;
                    filter = filt_node.i32;
                } else if(data_type&jsfeat.S32_t) {
                    buf = buf_node.i32;
                    filter = filt_node.f32;
                } else {
                    buf = buf_node.f32;
                    filter = filt_node.f32;
                }

                jsfeat.math.get_gaussian_kernel(kernel_size, sigma, filter, data_type);

                if(is_u8) {
                    _convol_u8(buf, src_d, dst_d, w, h, filter, kernel_size, half_kernel);
                } else {
                    _convol(buf, src_d, dst_d, w, h, filter, kernel_size, half_kernel);
                }

                jsfeat.cache.put_buffer(buf_node);
                jsfeat.cache.put_buffer(filt_node);
            },
            hough_transform: function( img, rho_res, theta_res, threshold ) {
                var image = img.data;

                var width = img.cols;
                var height = img.rows;
                var step = width;

                min_theta = 0.0;
                max_theta = Math.PI;

                numangle = Math.round((max_theta - min_theta) / theta_res);
                numrho = Math.round(((width + height) * 2 + 1) / rho_res);
                irho = 1.0 / rho_res;

                var accum = new Int32Array((numangle+2) * (numrho+2)); //typed arrays are initialized to 0
                var tabSin = new Float32Array(numangle);
                var tabCos = new Float32Array(numangle);

                var n=0;
                var ang = min_theta;
                for(; n < numangle; n++ ) {
                    tabSin[n] = Math.sin(ang) * irho;
                    tabCos[n] = Math.cos(ang) * irho;
                    ang += theta_res;
                }

                // stage 1. fill accumulator
                for( var i = 0; i < height; i++ ) {
                    for( var j = 0; j < width; j++ ) {
                        if( image[i * step + j] != 0 ) {
                            //console.log(r, (n+1) * (numrho+2) + r+1, tabCos[n], tabSin[n]);
                            for(var n = 0; n < numangle; n++ ) {
                                var r = Math.round( j * tabCos[n] + i * tabSin[n] );
                                r += (numrho - 1) / 2;
                                accum[(n+1) * (numrho+2) + r+1] += 1;
                            }
                        }
                    }
                }

                // stage 2. find local maximums
                //TODO: Consider making a vector class that uses typed arrays
                _sort_buf = new Array();
                for(var r = 0; r < numrho; r++ ) {
                    for(var n = 0; n < numangle; n++ ) {
                        var base = (n+1) * (numrho+2) + r+1;
                        if( accum[base] > threshold &&
                            accum[base] > accum[base - 1] && accum[base] >= accum[base + 1] &&
                            accum[base] > accum[base - numrho - 2] && accum[base] >= accum[base + numrho + 2] ) {
                            _sort_buf.push(base);
                        }
                    }
                }

                // stage 3. sort the detected lines by accumulator value
                _sort_buf.sort(function(l1, l2) {
                    return accum[l1] > accum[l2] || (accum[l1] == accum[l2] && l1 < l2);
                });

                // stage 4. store the first min(total,linesMax) lines to the output buffer
                linesMax = Math.min(numangle*numrho, _sort_buf.length);
                scale = 1.0 / (numrho+2);
                lines = new Array();
                for( var i = 0; i < linesMax; i++ ) {
                    var idx = _sort_buf[i];
                    var n = Math.floor(idx*scale) - 1;
                    var r = idx - (n+1)*(numrho+2) - 1;
                    var lrho = (r - (numrho - 1)*0.5) * rho_res;
                    var langle = n * theta_res;
                    lines.push([lrho, langle]);
                }
                return lines;
            },
            // assume we always need it for u8 image
            pyrdown: function(src, dst, sx, sy) {
                // this is needed for bbf
                if (typeof sx === "undefined") { sx = 0; }
                if (typeof sy === "undefined") { sy = 0; }

                var w = src.cols, h = src.rows;
                var w2 = w >> 1, h2 = h >> 1;
                var _w2 = w2 - (sx << 1), _h2 = h2 - (sy << 1);
                var x=0,y=0,sptr=sx+sy*w,sline=0,dptr=0,dline=0;

                dst.resize(w2, h2, src.channel);

                var src_d = src.data, dst_d = dst.data;

                for(y = 0; y < _h2; ++y) {
                    sline = sptr;
                    dline = dptr;
                    for(x = 0; x <= _w2-2; x+=2, dline+=2, sline += 4) {
                        dst_d[dline] = (src_d[sline] + src_d[sline+1] +
                                            src_d[sline+w] + src_d[sline+w+1] + 2) >> 2;
                        dst_d[dline+1] = (src_d[sline+2] + src_d[sline+3] +
                                            src_d[sline+w+2] + src_d[sline+w+3] + 2) >> 2;
                    }
                    for(; x < _w2; ++x, ++dline, sline += 2) {
                        dst_d[dline] = (src_d[sline] + src_d[sline+1] +
                                            src_d[sline+w] + src_d[sline+w+1] + 2) >> 2;
                    }
                    sptr += w << 1;
                    dptr += w2;
                }
            },

            // dst: [gx,gy,...]
            scharr_derivatives: function(src, dst) {
                var w = src.cols, h = src.rows;
                var dstep = w<<1,x=0,y=0,x1=0,a,b,c,d,e,f;
                var srow0=0,srow1=0,srow2=0,drow=0;
                var trow0,trow1;

                dst.resize(w, h, 2); // 2 channel output gx, gy

                var img = src.data, gxgy=dst.data;

                var buf0_node = jsfeat.cache.get_buffer((w+2)<<2);
                var buf1_node = jsfeat.cache.get_buffer((w+2)<<2);

                if(src.type&jsfeat.U8_t || src.type&jsfeat.S32_t) {
                    trow0 = buf0_node.i32;
                    trow1 = buf1_node.i32;
                } else {
                    trow0 = buf0_node.f32;
                    trow1 = buf1_node.f32;
                }

                for(; y < h; ++y, srow1+=w) {
                    srow0 = ((y > 0 ? y-1 : 1)*w)|0;
                    srow2 = ((y < h-1 ? y+1 : h-2)*w)|0;
                    drow = (y*dstep)|0;
                    // do vertical convolution
                    for(x = 0, x1 = 1; x <= w-2; x+=2, x1+=2) {
                        a = img[srow0+x], b = img[srow2+x];
                        trow0[x1] = ( (a + b)*3 + (img[srow1+x])*10 );
                        trow1[x1] = ( b - a );
                        //
                        a = img[srow0+x+1], b = img[srow2+x+1];
                        trow0[x1+1] = ( (a + b)*3 + (img[srow1+x+1])*10 );
                        trow1[x1+1] = ( b - a );
                    }
                    for(; x < w; ++x, ++x1) {
                        a = img[srow0+x], b = img[srow2+x];
                        trow0[x1] = ( (a + b)*3 + (img[srow1+x])*10 );
                        trow1[x1] = ( b - a );
                    }
                    // make border
                    x = (w + 1)|0;
                    trow0[0] = trow0[1]; trow0[x] = trow0[w];
                    trow1[0] = trow1[1]; trow1[x] = trow1[w];
                    // do horizontal convolution, interleave the results and store them
                    for(x = 0; x <= w-4; x+=4) {
                        a = trow1[x+2], b = trow1[x+1], c = trow1[x+3], d = trow1[x+4],
                        e = trow0[x+2], f = trow0[x+3];
                        gxgy[drow++] = ( e - trow0[x] );
                        gxgy[drow++] = ( (a + trow1[x])*3 + b*10 );
                        gxgy[drow++] = ( f - trow0[x+1] );
                        gxgy[drow++] = ( (c + b)*3 + a*10 );

                        gxgy[drow++] = ( (trow0[x+4] - e) );
                        gxgy[drow++] = ( ((d + a)*3 + c*10) );
                        gxgy[drow++] = ( (trow0[x+5] - f) );
                        gxgy[drow++] = ( ((trow1[x+5] + c)*3 + d*10) );
                    }
                    for(; x < w; ++x) {
                        gxgy[drow++] = ( (trow0[x+2] - trow0[x]) );
                        gxgy[drow++] = ( ((trow1[x+2] + trow1[x])*3 + trow1[x+1]*10) );
                    }
                }
                jsfeat.cache.put_buffer(buf0_node);
                jsfeat.cache.put_buffer(buf1_node);
            },

            // compute gradient using Sobel kernel [1 2 1] * [-1 0 1]^T
            // dst: [gx,gy,...]
            sobel_derivatives: function(src, dst) {
                var w = src.cols, h = src.rows;
                var dstep = w<<1,x=0,y=0,x1=0,a,b,c,d,e,f;
                var srow0=0,srow1=0,srow2=0,drow=0;
                var trow0,trow1;

                dst.resize(w, h, 2); // 2 channel output gx, gy

                var img = src.data, gxgy=dst.data;

                var buf0_node = jsfeat.cache.get_buffer((w+2)<<2);
                var buf1_node = jsfeat.cache.get_buffer((w+2)<<2);

                if(src.type&jsfeat.U8_t || src.type&jsfeat.S32_t) {
                    trow0 = buf0_node.i32;
                    trow1 = buf1_node.i32;
                } else {
                    trow0 = buf0_node.f32;
                    trow1 = buf1_node.f32;
                }

                for(; y < h; ++y, srow1+=w) {
                    srow0 = ((y > 0 ? y-1 : 1)*w)|0;
                    srow2 = ((y < h-1 ? y+1 : h-2)*w)|0;
                    drow = (y*dstep)|0;
                    // do vertical convolution
                    for(x = 0, x1 = 1; x <= w-2; x+=2, x1+=2) {
                        a = img[srow0+x], b = img[srow2+x];
                        trow0[x1] = ( (a + b) + (img[srow1+x]*2) );
                        trow1[x1] = ( b - a );
                        //
                        a = img[srow0+x+1], b = img[srow2+x+1];
                        trow0[x1+1] = ( (a + b) + (img[srow1+x+1]*2) );
                        trow1[x1+1] = ( b - a );
                    }
                    for(; x < w; ++x, ++x1) {
                        a = img[srow0+x], b = img[srow2+x];
                        trow0[x1] = ( (a + b) + (img[srow1+x]*2) );
                        trow1[x1] = ( b - a );
                    }
                    // make border
                    x = (w + 1)|0;
                    trow0[0] = trow0[1]; trow0[x] = trow0[w];
                    trow1[0] = trow1[1]; trow1[x] = trow1[w];
                    // do horizontal convolution, interleave the results and store them
                    for(x = 0; x <= w-4; x+=4) {
                        a = trow1[x+2], b = trow1[x+1], c = trow1[x+3], d = trow1[x+4],
                        e = trow0[x+2], f = trow0[x+3];
                        gxgy[drow++] = ( e - trow0[x] );
                        gxgy[drow++] = ( a + trow1[x] + b*2 );
                        gxgy[drow++] = ( f - trow0[x+1] );
                        gxgy[drow++] = ( c + b + a*2 );

                        gxgy[drow++] = ( trow0[x+4] - e );
                        gxgy[drow++] = ( d + a + c*2 );
                        gxgy[drow++] = ( trow0[x+5] - f );
                        gxgy[drow++] = ( trow1[x+5] + c + d*2 );
                    }
                    for(; x < w; ++x) {
                        gxgy[drow++] = ( trow0[x+2] - trow0[x] );
                        gxgy[drow++] = ( trow1[x+2] + trow1[x] + trow1[x+1]*2 );
                    }
                }
                jsfeat.cache.put_buffer(buf0_node);
                jsfeat.cache.put_buffer(buf1_node);
            },

            // please note: 
            // dst_(type) size should be cols = src.cols+1, rows = src.rows+1
            compute_integral_image: function(src, dst_sum, dst_sqsum, dst_tilted) {
                var w0=src.cols|0,h0=src.rows|0,src_d=src.data;
                var w1=(w0+1)|0;
                var s=0,s2=0,p=0,pup=0,i=0,j=0,v=0,k=0;

                if(dst_sum && dst_sqsum) {
                    // fill first row with zeros
                    for(; i < w1; ++i) {
                        dst_sum[i] = 0, dst_sqsum[i] = 0;
                    }
                    p = (w1+1)|0, pup = 1;
                    for(i = 0, k = 0; i < h0; ++i, ++p, ++pup) {
                        s = s2 = 0;
                        for(j = 0; j <= w0-2; j+=2, k+=2, p+=2, pup+=2) {
                            v = src_d[k];
                            s += v, s2 += v*v;
                            dst_sum[p] = dst_sum[pup] + s;
                            dst_sqsum[p] = dst_sqsum[pup] + s2;

                            v = src_d[k+1];
                            s += v, s2 += v*v;
                            dst_sum[p+1] = dst_sum[pup+1] + s;
                            dst_sqsum[p+1] = dst_sqsum[pup+1] + s2;
                        }
                        for(; j < w0; ++j, ++k, ++p, ++pup) {
                            v = src_d[k];
                            s += v, s2 += v*v;
                            dst_sum[p] = dst_sum[pup] + s;
                            dst_sqsum[p] = dst_sqsum[pup] + s2;
                        }
                    }
                } else if(dst_sum) {
                    // fill first row with zeros
                    for(; i < w1; ++i) {
                        dst_sum[i] = 0;
                    }
                    p = (w1+1)|0, pup = 1;
                    for(i = 0, k = 0; i < h0; ++i, ++p, ++pup) {
                        s = 0;
                        for(j = 0; j <= w0-2; j+=2, k+=2, p+=2, pup+=2) {
                            s += src_d[k];
                            dst_sum[p] = dst_sum[pup] + s;
                            s += src_d[k+1];
                            dst_sum[p+1] = dst_sum[pup+1] + s;
                        }
                        for(; j < w0; ++j, ++k, ++p, ++pup) {
                            s += src_d[k];
                            dst_sum[p] = dst_sum[pup] + s;
                        }
                    }
                } else if(dst_sqsum) {
                    // fill first row with zeros
                    for(; i < w1; ++i) {
                        dst_sqsum[i] = 0;
                    }
                    p = (w1+1)|0, pup = 1;
                    for(i = 0, k = 0; i < h0; ++i, ++p, ++pup) {
                        s2 = 0;
                        for(j = 0; j <= w0-2; j+=2, k+=2, p+=2, pup+=2) {
                            v = src_d[k];
                            s2 += v*v;
                            dst_sqsum[p] = dst_sqsum[pup] + s2;
                            v = src_d[k+1];
                            s2 += v*v;
                            dst_sqsum[p+1] = dst_sqsum[pup+1] + s2;
                        }
                        for(; j < w0; ++j, ++k, ++p, ++pup) {
                            v = src_d[k];
                            s2 += v*v;
                            dst_sqsum[p] = dst_sqsum[pup] + s2;
                        }
                    }
                }

                if(dst_tilted) {
                    // fill first row with zeros
                    for(i = 0; i < w1; ++i) {
                        dst_tilted[i] = 0;
                    }
                    // diagonal
                    p = (w1+1)|0, pup = 0;
                    for(i = 0, k = 0; i < h0; ++i, ++p, ++pup) {
                        for(j = 0; j <= w0-2; j+=2, k+=2, p+=2, pup+=2) {
                            dst_tilted[p] = src_d[k] + dst_tilted[pup];
                            dst_tilted[p+1] = src_d[k+1] + dst_tilted[pup+1];
                        }
                        for(; j < w0; ++j, ++k, ++p, ++pup) {
                            dst_tilted[p] = src_d[k] + dst_tilted[pup];
                        }
                    }
                    // diagonal
                    p = (w1+w0)|0, pup = w0;
                    for(i = 0; i < h0; ++i, p+=w1, pup+=w1) {
                        dst_tilted[p] += dst_tilted[pup];
                    }

                    for(j = w0-1; j > 0; --j) {
                        p = j+h0*w1, pup=p-w1;
                        for(i = h0; i > 0; --i, p-=w1, pup-=w1) {
                            dst_tilted[p] += dst_tilted[pup] + dst_tilted[pup+1];
                        }
                    }
                }
            },
            equalize_histogram: function(src, dst) {
                var w=src.cols,h=src.rows,src_d=src.data;

                dst.resize(w, h, src.channel);

                var dst_d=dst.data,size=w*h;
                var i=0,prev=0,hist0,norm;

                var hist0_node = jsfeat.cache.get_buffer(256<<2);
                hist0 = hist0_node.i32;
                for(; i < 256; ++i) hist0[i] = 0;
                for (i = 0; i < size; ++i) {
                    ++hist0[src_d[i]];
                }

                prev = hist0[0];
                for (i = 1; i < 256; ++i) {
                    prev = hist0[i] += prev;
                }

                norm = 255 / size;
                for (i = 0; i < size; ++i) {
                    dst_d[i] = (hist0[src_d[i]] * norm + 0.5)|0;
                }
                jsfeat.cache.put_buffer(hist0_node);
            },

            canny: function(src, dst, low_thresh, high_thresh) {
                var w=src.cols,h=src.rows,src_d=src.data;

                dst.resize(w, h, src.channel);
                
                var dst_d=dst.data;
                var i=0,j=0,grad=0,w2=w<<1,_grad=0,suppress=0,f=0,x=0,y=0,s=0;
                var tg22x=0,tg67x=0;

                // cache buffers
                var dxdy_node = jsfeat.cache.get_buffer((h * w2)<<2);
                var buf_node = jsfeat.cache.get_buffer((3 * (w + 2))<<2);
                var map_node = jsfeat.cache.get_buffer(((h+2) * (w + 2))<<2);
                var stack_node = jsfeat.cache.get_buffer((h * w)<<2);
                

                var buf = buf_node.i32;
                var map = map_node.i32;
                var stack = stack_node.i32;
                var dxdy = dxdy_node.i32;
                var dxdy_m = new jsfeat.matrix_t(w, h, jsfeat.S32C2_t, dxdy_node.data);
                var row0=1,row1=(w+2+1)|0,row2=(2*(w+2)+1)|0,map_w=(w+2)|0,map_i=(map_w+1)|0,stack_i=0;

                this.sobel_derivatives(src, dxdy_m);

                if(low_thresh > high_thresh) {
                    i = low_thresh;
                    low_thresh = high_thresh;
                    high_thresh = i;
                }

                i = (3 * (w + 2))|0;
                while(--i>=0) {
                    buf[i] = 0;
                }

                i = ((h+2) * (w + 2))|0;
                while(--i>=0) {
                    map[i] = 0;
                }

                for (; j < w; ++j, grad+=2) {
                    //buf[row1+j] = Math.abs(dxdy[grad]) + Math.abs(dxdy[grad+1]);
                    x = dxdy[grad], y = dxdy[grad+1];
                    //buf[row1+j] = x*x + y*y;
                    buf[row1+j] = ((x ^ (x >> 31)) - (x >> 31)) + ((y ^ (y >> 31)) - (y >> 31));
                }

                for(i=1; i <= h; ++i, grad+=w2) {
                    if(i == h) {
                        j = row2+w;
                        while(--j>=row2) {
                            buf[j] = 0;
                        }
                    } else {
                        for (j = 0; j < w; j++) {
                            //buf[row2+j] =  Math.abs(dxdy[grad+(j<<1)]) + Math.abs(dxdy[grad+(j<<1)+1]);
                            x = dxdy[grad+(j<<1)], y = dxdy[grad+(j<<1)+1];
                            //buf[row2+j] = x*x + y*y;
                            buf[row2+j] = ((x ^ (x >> 31)) - (x >> 31)) + ((y ^ (y >> 31)) - (y >> 31));
                        }
                    }
                    _grad = (grad - w2)|0;
                    map[map_i-1] = 0;
                    suppress = 0;
                    for(j = 0; j < w; ++j, _grad+=2) {
                        f = buf[row1+j];
                        if (f > low_thresh) {
                            x = dxdy[_grad];
                            y = dxdy[_grad+1];
                            s = x ^ y;
                            // seems ot be faster than Math.abs
                            x = ((x ^ (x >> 31)) - (x >> 31))|0;
                            y = ((y ^ (y >> 31)) - (y >> 31))|0;
                            //x * tan(22.5) x * tan(67.5) == 2 * x + x * tan(22.5)
                            tg22x = x * 13573;
                            tg67x = tg22x + ((x + x) << 15);
                            y <<= 15;
                            if (y < tg22x) {
                                if (f > buf[row1+j-1] && f >= buf[row1+j+1]) {
                                    if (f > high_thresh && !suppress && map[map_i+j-map_w] != 2) {
                                        map[map_i+j] = 2;
                                        suppress = 1;
                                        stack[stack_i++] = map_i + j;
                                    } else {
                                        map[map_i+j] = 1;
                                    }
                                    continue;
                                }
                            } else if (y > tg67x) {
                                if (f > buf[row0+j] && f >= buf[row2+j]) {
                                    if (f > high_thresh && !suppress && map[map_i+j-map_w] != 2) {
                                        map[map_i+j] = 2;
                                        suppress = 1;
                                        stack[stack_i++] = map_i + j;
                                    } else {
                                        map[map_i+j] = 1;
                                    }
                                    continue;
                                }
                            } else {
                                s = s < 0 ? -1 : 1;
                                if (f > buf[row0+j-s] && f > buf[row2+j+s]) {
                                    if (f > high_thresh && !suppress && map[map_i+j-map_w] != 2) {
                                        map[map_i+j] = 2;
                                        suppress = 1;
                                        stack[stack_i++] = map_i + j;
                                    } else {
                                        map[map_i+j] = 1;
                                    }
                                    continue;
                                }
                            }
                        }
                        map[map_i+j] = 0;
                        suppress = 0;
                    }
                    map[map_i+w] = 0;
                    map_i += map_w;
                    j = row0;
                    row0 = row1;
                    row1 = row2;
                    row2 = j;
                }

                j = map_i - map_w - 1;
                for(i = 0; i < map_w; ++i, ++j) {
                    map[j] = 0;
                }
                // path following
                while(stack_i > 0) {
                    map_i = stack[--stack_i];
                    map_i -= map_w+1;
                    if(map[map_i] == 1) map[map_i] = 2, stack[stack_i++] = map_i;
                    map_i += 1;
                    if(map[map_i] == 1) map[map_i] = 2, stack[stack_i++] = map_i;
                    map_i += 1;
                    if(map[map_i] == 1) map[map_i] = 2, stack[stack_i++] = map_i;
                    map_i += map_w;
                    if(map[map_i] == 1) map[map_i] = 2, stack[stack_i++] = map_i;
                    map_i -= 2;
                    if(map[map_i] == 1) map[map_i] = 2, stack[stack_i++] = map_i;
                    map_i += map_w;
                    if(map[map_i] == 1) map[map_i] = 2, stack[stack_i++] = map_i;
                    map_i += 1;
                    if(map[map_i] == 1) map[map_i] = 2, stack[stack_i++] = map_i;
                    map_i += 1;
                    if(map[map_i] == 1) map[map_i] = 2, stack[stack_i++] = map_i;
                }

                map_i = map_w + 1;
                row0 = 0;
                for(i = 0; i < h; ++i, map_i+=map_w) {
                    for(j = 0; j < w; ++j) {
                        dst_d[row0++] = (map[map_i+j] == 2) * 0xff;
                    }
                }

                // free buffers
                jsfeat.cache.put_buffer(dxdy_node);
                jsfeat.cache.put_buffer(buf_node);
                jsfeat.cache.put_buffer(map_node);
                jsfeat.cache.put_buffer(stack_node);
            },
            // transform is 3x3 matrix_t
            warp_perspective: function(src, dst, transform, fill_value) {
                if (typeof fill_value === "undefined") { fill_value = 0; }
                var src_width=src.cols|0, src_height=src.rows|0, dst_width=dst.cols|0, dst_height=dst.rows|0;
                var src_d=src.data, dst_d=dst.data;
                var x=0,y=0,off=0,ixs=0,iys=0,xs=0.0,ys=0.0,xs0=0.0,ys0=0.0,ws=0.0,sc=0.0,a=0.0,b=0.0,p0=0.0,p1=0.0;
                var td=transform.data;
                var m00=td[0],m01=td[1],m02=td[2],
                    m10=td[3],m11=td[4],m12=td[5],
                    m20=td[6],m21=td[7],m22=td[8];

                for(var dptr = 0; y < dst_height; ++y) {
                    xs0 = m01 * y + m02,
                    ys0 = m11 * y + m12,
                    ws  = m21 * y + m22;
                    for(x = 0; x < dst_width; ++x, ++dptr, xs0+=m00, ys0+=m10, ws+=m20) {
                        sc = 1.0 / ws;
                        xs = xs0 * sc, ys = ys0 * sc;
                        ixs = xs | 0, iys = ys | 0;

                        if(xs > 0 && ys > 0 && ixs < (src_width - 1) && iys < (src_height - 1)) {
                            a = Math.max(xs - ixs, 0.0);
                            b = Math.max(ys - iys, 0.0);
                            off = (src_width*iys + ixs)|0;

                            p0 = src_d[off] +  a * (src_d[off+1] - src_d[off]);
                            p1 = src_d[off+src_width] + a * (src_d[off+src_width+1] - src_d[off+src_width]);

                            dst_d[dptr] = p0 + b * (p1 - p0);
                        }
                        else dst_d[dptr] = fill_value;
                    }
                }
            },
            // transform is 3x3 or 2x3 matrix_t only first 6 values referenced
            warp_affine: function(src, dst, transform, fill_value) {
                if (typeof fill_value === "undefined") { fill_value = 0; }
                var src_width=src.cols, src_height=src.rows, dst_width=dst.cols, dst_height=dst.rows;
                var src_d=src.data, dst_d=dst.data;
                var x=0,y=0,off=0,ixs=0,iys=0,xs=0.0,ys=0.0,a=0.0,b=0.0,p0=0.0,p1=0.0;
                var td=transform.data;
                var m00=td[0],m01=td[1],m02=td[2],
                    m10=td[3],m11=td[4],m12=td[5];

                for(var dptr = 0; y < dst_height; ++y) {
                    xs = m01 * y + m02;
                    ys = m11 * y + m12;
                    for(x = 0; x < dst_width; ++x, ++dptr, xs+=m00, ys+=m10) {
                        ixs = xs | 0; iys = ys | 0;

                        if(ixs >= 0 && iys >= 0 && ixs < (src_width - 1) && iys < (src_height - 1)) {
                            a = xs - ixs;
                            b = ys - iys;
                            off = src_width*iys + ixs;

                            p0 = src_d[off] +  a * (src_d[off+1] - src_d[off]);
                            p1 = src_d[off+src_width] + a * (src_d[off+src_width+1] - src_d[off+src_width]);

                            dst_d[dptr] = p0 + b * (p1 - p0);
                        }
                        else dst_d[dptr] = fill_value;
                    }
                }
            },
            
            // Basic RGB Skin detection filter
            // from http://popscan.blogspot.fr/2012/08/skin-detection-in-digital-images.html
            skindetector: function(src,dst) {
                var r,g,b,j;
                var i = src.width*src.height;
                while(i--){
                    j = i*4;
                    r = src.data[j];
                    g = src.data[j+1];
                    b = src.data[j+2];
                    if((r>95)&&(g>40)&&(b>20)
                     &&(r>g)&&(r>b)
                     &&(r-Math.min(g,b)>15)
                     &&(Math.abs(r-g)>15)){
                         dst[i] = 255;
                    } else {
                        dst[i] = 0;
                    }
                }                
            }
        };
    })();

    global.imgproc = imgproc;

})(jsfeat);
/**
 * @author Eugene Zatepyakin / http://inspirit.ru/
 *
 * This is FAST corner detector, contributed to OpenCV by the author, Edward Rosten.
 */

/*
The references are:
 * Machine learning for high-speed corner detection,
   E. Rosten and T. Drummond, ECCV 2006
 * Faster and better: A machine learning approach to corner detection
   E. Rosten, R. Porter and T. Drummond, PAMI, 2009  
*/

(function(global) {
    "use strict";
    //
    var fast_corners = (function() {

        var offsets16 = new Int32Array([0, 3, 1, 3, 2, 2, 3, 1, 3, 0, 3, -1, 2, -2, 1, -3, 0, -3, -1, -3, -2, -2, -3, -1, -3, 0, -3, 1, -2, 2, -1, 3]);

        var threshold_tab = new Uint8Array(512);
        var pixel_off = new Int32Array(25);
        var score_diff = new Int32Array(25);

        // private functions
        var _cmp_offsets = function(pixel, step, pattern_size) {
            var k = 0;
            var offsets = offsets16;
            for( ; k < pattern_size; ++k ) {
                pixel[k] = offsets[k<<1] + offsets[(k<<1)+1] * step;
            }
            for( ; k < 25; ++k ) {
                pixel[k] = pixel[k - pattern_size];
            }
        },

        _cmp_score_16 = function(src, off, pixel, d, threshold) {
            var N = 25, k = 0, v = src[off];
            var a0 = threshold,a=0,b0=0,b=0;

            for( ; k < N; ++k ) {
                d[k] = v - src[off+pixel[k]];
            }

            for( k = 0; k < 16; k += 2 ) {
                a = Math.min(d[k+1], d[k+2]);
                a = Math.min(a, d[k+3]);

                if( a <= a0 ) continue;

                a = Math.min(a, d[k+4]);
                a = Math.min(a, d[k+5]);
                a = Math.min(a, d[k+6]);
                a = Math.min(a, d[k+7]);
                a = Math.min(a, d[k+8]);
                a0 = Math.max(a0, Math.min(a, d[k]));
                a0 = Math.max(a0, Math.min(a, d[k+9]));
            }

            b0 = -a0;
            for( k = 0; k < 16; k += 2 ) {
                b = Math.max(d[k+1], d[k+2]);
                b = Math.max(b, d[k+3]);
                b = Math.max(b, d[k+4]);
                b = Math.max(b, d[k+5]);

                if( b >= b0 ) continue;
                b = Math.max(b, d[k+6]);
                b = Math.max(b, d[k+7]);
                b = Math.max(b, d[k+8]);
                b0 = Math.min(b0, Math.max(b, d[k]));
                b0 = Math.min(b0, Math.max(b, d[k+9]));
            }

            return -b0-1;
        };

        var _threshold = 20;

        return {
            set_threshold: function(threshold) {
                _threshold = Math.min(Math.max(threshold, 0), 255);
                for (var i = -255; i <= 255; ++i) {
                    threshold_tab[(i + 255)] = (i < -_threshold ? 1 : (i > _threshold ? 2 : 0));
                }
                return _threshold;
            },
            
            detect: function(src, corners, border) {
                if (typeof border === "undefined") { border = 3; }

                var K = 8, N = 25;
                var img = src.data, w = src.cols, h = src.rows;
                var i=0, j=0, k=0, vt=0, x=0, m3=0;
                var buf_node = jsfeat.cache.get_buffer(3 * w);
                var cpbuf_node = jsfeat.cache.get_buffer(((w+1)*3)<<2);
                var buf = buf_node.u8;
                var cpbuf = cpbuf_node.i32;
                var pixel = pixel_off;
                var sd = score_diff;
                var sy = Math.max(3, border);
                var ey = Math.min((h-2), (h-border));
                var sx = Math.max(3, border);
                var ex = Math.min((w - 3), (w - border));
                var _count = 0, corners_cnt = 0, pt;
                var score_func = _cmp_score_16;
                var thresh_tab = threshold_tab;
                var threshold = _threshold;

                var v=0,tab=0,d=0,ncorners=0,cornerpos=0,curr=0,ptr=0,prev=0,pprev=0;
                var jp1=0,jm1=0,score=0;

                _cmp_offsets(pixel, w, 16);

                // local vars are faster?
                var pixel0 = pixel[0];
                var pixel1 = pixel[1];
                var pixel2 = pixel[2];
                var pixel3 = pixel[3];
                var pixel4 = pixel[4];
                var pixel5 = pixel[5];
                var pixel6 = pixel[6];
                var pixel7 = pixel[7];
                var pixel8 = pixel[8];
                var pixel9 = pixel[9];
                var pixel10 = pixel[10];
                var pixel11 = pixel[11];
                var pixel12 = pixel[12];
                var pixel13 = pixel[13];
                var pixel14 = pixel[14];
                var pixel15 = pixel[15];

                for(i = 0; i < w*3; ++i) {
                    buf[i] = 0;
                }

                for(i = sy; i < ey; ++i) {
                    ptr = ((i * w) + sx)|0;
                    m3 = (i - 3)%3;
                    curr = (m3*w)|0;
                    cornerpos = (m3*(w+1))|0;
                    for (j = 0; j < w; ++j) buf[curr+j] = 0;
                    ncorners = 0;
                    
                    if( i < (ey - 1) ) {
                        j = sx;
                        
                        for( ; j < ex; ++j, ++ptr ) {
                            v = img[ptr];
                            tab = ( - v + 255 );
                            d = ( thresh_tab[tab+img[ptr+pixel0]] | thresh_tab[tab+img[ptr+pixel8]] );
                            
                            if( d == 0 ) {
                                continue;
                            }
                            
                            d &= ( thresh_tab[tab+img[ptr+pixel2]] | thresh_tab[tab+img[ptr+pixel10]] );
                            d &= ( thresh_tab[tab+img[ptr+pixel4]] | thresh_tab[tab+img[ptr+pixel12]] );
                            d &= ( thresh_tab[tab+img[ptr+pixel6]] | thresh_tab[tab+img[ptr+pixel14]] );
                            
                            if( d == 0 ) {
                                continue;
                            }
                            
                            d &= ( thresh_tab[tab+img[ptr+pixel1]] | thresh_tab[tab+img[ptr+pixel9]] );
                            d &= ( thresh_tab[tab+img[ptr+pixel3]] | thresh_tab[tab+img[ptr+pixel11]] );
                            d &= ( thresh_tab[tab+img[ptr+pixel5]] | thresh_tab[tab+img[ptr+pixel13]] );
                            d &= ( thresh_tab[tab+img[ptr+pixel7]] | thresh_tab[tab+img[ptr+pixel15]] );
                            
                            if( d & 1 ) {
                                vt = (v - threshold);
                                _count = 0;
                                
                                for( k = 0; k < N; ++k ) {
                                    x = img[(ptr+pixel[k])];
                                    if(x < vt) {
                                        ++_count;
                                        if( _count > K ) {
                                            ++ncorners;
                                            cpbuf[cornerpos+ncorners] = j;
                                            buf[curr+j] = score_func(img, ptr, pixel, sd, threshold);
                                            break;
                                        }
                                    }
                                    else {
                                        _count = 0;
                                    }
                                }
                            }
                            
                            if( d & 2 ) {
                                vt = (v + threshold);
                                _count = 0;
                                
                                for( k = 0; k < N; ++k ) {
                                    x = img[(ptr+pixel[k])];
                                    if(x > vt) {
                                        ++_count;
                                        if( _count > K ) {
                                            ++ncorners;
                                            cpbuf[cornerpos+ncorners] = j;
                                            buf[curr+j] = score_func(img, ptr, pixel, sd, threshold);
                                            break;
                                        }
                                    }
                                    else {
                                        _count = 0;
                                    }
                                }
                            }
                        }
                    }
                    
                    cpbuf[cornerpos+w] = ncorners;
            
                    if ( i == sy ) {
                        continue;
                    }
                    
                    m3 = (i - 4 + 3)%3;
                    prev = (m3*w)|0;
                    cornerpos = (m3*(w+1))|0;
                    m3 = (i - 5 + 3)%3;
                    pprev = (m3*w)|0;

                    ncorners = cpbuf[cornerpos+w];
                    
                    for( k = 0; k < ncorners; ++k ) {
                        j = cpbuf[cornerpos+k];
                        jp1 = (j+1)|0;
                        jm1 = (j-1)|0;
                        score = buf[prev+j];
                        if( (score > buf[prev+jp1] && score > buf[prev+jm1] &&
                            score > buf[pprev+jm1] && score > buf[pprev+j] && score > buf[pprev+jp1] &&
                            score > buf[curr+jm1] && score > buf[curr+j] && score > buf[curr+jp1]) ) {
                            // save corner
                            pt = corners[corners_cnt];
                            pt.x = j, pt.y = (i-1), pt.score = score;
                            corners_cnt++;
                        }
                    }
                } // y loop
                jsfeat.cache.put_buffer(buf_node);
                jsfeat.cache.put_buffer(cpbuf_node);
                return corners_cnt;
            }
        };
    })();

    global.fast_corners = fast_corners;
    fast_corners.set_threshold(20); // set default

})(jsfeat);
/**
 * @author Eugene Zatepyakin / http://inspirit.ru/
 *
 * Copyright 2007 Computer Vision Lab,
 * Ecole Polytechnique Federale de Lausanne (EPFL), Switzerland.
 * @author Vincent Lepetit (http://cvlab.epfl.ch/~lepetit)
 */

(function(global) {
    "use strict";
    //

    var yape06 = (function() {
        
        var compute_laplacian = function(src, dst, w, h, Dxx, Dyy, sx,sy, ex,ey) {
            var y=0,x=0,yrow=(sy*w+sx)|0,row=yrow;

            for(y = sy; y < ey; ++y, yrow+=w, row = yrow) {
                for(x = sx; x < ex; ++x, ++row) {
                    dst[row] = -4 * src[row] + src[row+Dxx] + src[row-Dxx] + src[row+Dyy] + src[row-Dyy];
                }
            }
        };

        var hessian_min_eigen_value = function(src, off, tr, Dxx, Dyy, Dxy, Dyx) {
            var Ixx = -2 * src[off] + src[off + Dxx] + src[off - Dxx];
            var Iyy = -2 * src[off] + src[off + Dyy] + src[off - Dyy];
            var Ixy = src[off + Dxy] + src[off - Dxy] - src[off + Dyx] - src[off - Dyx];
            var sqrt_delta = ( Math.sqrt(((Ixx - Iyy) * (Ixx - Iyy) + 4 * Ixy * Ixy) ) )|0;

            return Math.min(Math.abs(tr - sqrt_delta), Math.abs(-(tr + sqrt_delta)));
        };

        return {

            laplacian_threshold: 30,
            min_eigen_value_threshold: 25,

            detect: function(src, points, border) {
                if (typeof border === "undefined") { border = 5; }
                var x=0,y=0;
                var w=src.cols, h=src.rows, srd_d=src.data;
                var Dxx = 5, Dyy = (5 * w)|0;
                var Dxy = (3 + 3 * w)|0, Dyx = (3 - 3 * w)|0;
                var lap_buf = jsfeat.cache.get_buffer((w*h)<<2);
                var laplacian = lap_buf.i32;
                var lv=0, row=0,rowx=0,min_eigen_value=0,pt;
                var number_of_points = 0;
                var lap_thresh = this.laplacian_threshold;
                var eigen_thresh = this.min_eigen_value_threshold;

                var sx = Math.max(5, border)|0;
                var sy = Math.max(3, border)|0;
                var ex = Math.min(w-5, w-border)|0;
                var ey = Math.min(h-3, h-border)|0;

                x = w*h;
                while(--x>=0) {laplacian[x]=0;}
                compute_laplacian(srd_d, laplacian, w, h, Dxx, Dyy, sx,sy, ex,ey);

                row = (sy*w+sx)|0;
                for(y = sy; y < ey; ++y, row += w) {
                    for(x = sx, rowx=row; x < ex; ++x, ++rowx) {

                        lv = laplacian[rowx];
                        if ((lv < -lap_thresh &&
                            lv < laplacian[rowx - 1]      && lv < laplacian[rowx + 1] &&
                            lv < laplacian[rowx - w]     && lv < laplacian[rowx + w] &&
                            lv < laplacian[rowx - w - 1] && lv < laplacian[rowx + w - 1] &&
                            lv < laplacian[rowx - w + 1] && lv < laplacian[rowx + w + 1])
                            ||
                            (lv > lap_thresh &&
                            lv > laplacian[rowx - 1]      && lv > laplacian[rowx + 1] &&
                            lv > laplacian[rowx - w]     && lv > laplacian[rowx + w] &&
                            lv > laplacian[rowx - w - 1] && lv > laplacian[rowx + w - 1] &&
                            lv > laplacian[rowx - w + 1] && lv > laplacian[rowx + w + 1])
                            ) {

                            min_eigen_value = hessian_min_eigen_value(srd_d, rowx, lv, Dxx, Dyy, Dxy, Dyx);
                            if (min_eigen_value > eigen_thresh) {
                                pt = points[number_of_points];
                                pt.x = x, pt.y = y, pt.score = min_eigen_value;
                                ++number_of_points;
                                ++x, ++rowx; // skip next pixel since this is maxima in 3x3
                            }
                        }
                    }
                }

                jsfeat.cache.put_buffer(lap_buf);

                return number_of_points;
            }

        };
    })();

    global.yape06 = yape06;

})(jsfeat);
/**
 * @author Eugene Zatepyakin / http://inspirit.ru/
 *
 * Copyright 2007 Computer Vision Lab,
 * Ecole Polytechnique Federale de Lausanne (EPFL), Switzerland.
 */

(function(global) {
    "use strict";
    //

    var yape = (function() {

        var precompute_directions = function(step, dirs, R) {
            var i = 0;
            var x, y;

            x = R;
            for(y = 0; y < x; y++, i++)
            {
                x = (Math.sqrt((R * R - y * y)) + 0.5)|0;
                dirs[i] = (x + step * y);
            }
            for(x-- ; x < y && x >= 0; x--, i++)
            {
                y = (Math.sqrt((R * R - x * x)) + 0.5)|0;
                dirs[i] = (x + step * y);
            }
            for( ; -x < y; x--, i++)
            {
                y = (Math.sqrt((R * R - x * x)) + 0.5)|0;
                dirs[i] = (x + step * y);
            }
            for(y-- ; y >= 0; y--, i++)
            {
                x = (-Math.sqrt((R * R - y * y)) - 0.5)|0;
                dirs[i] = (x + step * y);
            }
            for(; y > x; y--, i++)
            {
                x = (-Math.sqrt((R * R - y * y)) - 0.5)|0;
                dirs[i] = (x + step * y);
            }
            for(x++ ; x <= 0; x++, i++)
            {
                y = (-Math.sqrt((R * R - x * x)) - 0.5)|0;
                dirs[i] = (x + step * y);
            }
            for( ; x < -y; x++, i++)
            {
                y = (-Math.sqrt((R * R - x * x)) - 0.5)|0;
                dirs[i] = (x + step * y);
            }
            for(y++ ; y < 0; y++, i++)
            {
                x = (Math.sqrt((R * R - y * y)) + 0.5)|0;
                dirs[i] = (x + step * y);
            }

            dirs[i] = dirs[0];
            dirs[i + 1] = dirs[1];
            return i;
        };

        var third_check = function (Sb, off, step) {
            var n = 0;
            if(Sb[off+1]   != 0) n++;
            if(Sb[off-1]   != 0) n++;
            if(Sb[off+step]   != 0) n++;
            if(Sb[off+step+1] != 0) n++;
            if(Sb[off+step-1] != 0) n++;
            if(Sb[off-step]   != 0) n++;
            if(Sb[off-step+1] != 0) n++;
            if(Sb[off-step-1] != 0) n++;

            return n;
        };

        var is_local_maxima = function(p, off, v, step, neighborhood) {
            var x, y;

            if (v > 0) {
                off -= step*neighborhood;
                for (y= -neighborhood; y<=neighborhood; ++y) {
                    for (x= -neighborhood; x<=neighborhood; ++x) {
                        if (p[off+x] > v) return false;
                    }
                    off += step;
                }
            } else {
                off -= step*neighborhood;
                for (y= -neighborhood; y<=neighborhood; ++y) {
                    for (x= -neighborhood; x<=neighborhood; ++x) {
                        if (p[off+x] < v) return false;
                    }
                    off += step;
                }
            }
            return true;
        };

        var perform_one_point = function(I, x, Scores, Im, Ip, dirs, opposite, dirs_nb) {
          var score = 0;
          var a = 0, b = (opposite - 1)|0;
          var A=0, B0=0, B1=0, B2=0;
          var state=0;

          // WE KNOW THAT NOT(A ~ I0 & B1 ~ I0):
          A = I[x+dirs[a]];
          if ((A <= Ip)) {
            if ((A >= Im)) { // A ~ I0
              B0 = I[x+dirs[b]];
              if ((B0 <= Ip)) {
                if ((B0 >= Im)) { Scores[x] = 0; return; }
                else {
                  b++; B1 = I[x+dirs[b]];
                  if ((B1 > Ip)) {
                    b++; B2 = I[x+dirs[b]];
                    if ((B2 > Ip)) state = 3;
                    else if ((B2 < Im)) state = 6;
                    else { Scores[x] = 0; return; } // A ~ I0, B2 ~ I0
                  }
                  else/* if ((B1 < Im))*/ {
                    b++; B2 = I[x+dirs[b]];
                    if ((B2 > Ip)) state = 7;
                    else if ((B2 < Im)) state = 2;
                    else { Scores[x] = 0; return; } // A ~ I0, B2 ~ I0
                  }
                  //else { Scores[x] = 0; return; } // A ~ I0, B1 ~ I0
                }
              }
              else { // B0 < I0
                b++; B1 = I[x+dirs[b]];
                if ((B1 > Ip)) {
                  b++; B2 = I[x+dirs[b]];
                  if ((B2 > Ip)) state = 3;
                  else if ((B2 < Im)) state = 6;
                  else { Scores[x] = 0; return; } // A ~ I0, B2 ~ I0
                }
                else if ((B1 < Im)) {
                  b++; B2 = I[x+dirs[b]];
                  if ((B2 > Ip)) state = 7;
                  else if ((B2 < Im)) state = 2;
                  else { Scores[x] = 0; return; } // A ~ I0, B2 ~ I0
                }
                else { Scores[x] = 0; return; } // A ~ I0, B1 ~ I0
              }
            }
            else { // A > I0
              B0 = I[x+dirs[b]];
              if ((B0 > Ip)) { Scores[x] = 0; return; }
                b++; B1 = I[x+dirs[b]];
              if ((B1 > Ip)) { Scores[x] = 0; return; }
                b++; B2 = I[x+dirs[b]];
              if ((B2 > Ip)) { Scores[x] = 0; return; }
                state = 1;
            }
          }
          else // A < I0
          {
            B0 = I[x+dirs[b]];
            if ((B0 < Im)) { Scores[x] = 0; return; }
              b++; B1 = I[x+dirs[b]];
            if ((B1 < Im)) { Scores[x] = 0; return; }
              b++; B2 = I[x+dirs[b]];
            if ((B2 < Im)) { Scores[x] = 0; return; }
              state = 0;
          }

          for(a = 1; a <= opposite; a++)
          {
            A = I[x+dirs[a]];

            switch(state)
            {
            case 0:
              if ((A > Ip)) {
                B1 = B2; b++; B2 = I[x+dirs[b]];
                if ((B2 < Im)) { Scores[x] = 0; return; }
                  { score -= A + B1; state = 0; break; }
              }
              if ((A < Im)) {
                if ((B1 > Ip)) { Scores[x] = 0; return; }
                  if ((B2 > Ip)) { Scores[x] = 0; return; }
                    B1 = B2; b++; B2 = I[x+dirs[b]];
                if ((B2 > Ip)) { Scores[x] = 0; return; }
                  { score -= A + B1; state = 8; break; }
              } 
              // A ~ I0
              if ((B1 <= Ip)) { Scores[x] = 0; return; }
                if ((B2 <= Ip)) { Scores[x] = 0; return; }
                  B1 = B2; b++; B2 = I[x+dirs[b]];
              if ((B2 > Ip)) { score -= A + B1; state = 3; break; };
              if ((B2 < Im)) { score -= A + B1; state = 6; break; };
              { Scores[x] = 0; return; }

            case 1:
              if ((A < Im)) {
                B1 = B2; b++; B2 = I[x+dirs[b]];
                if ((B2 > Ip)) { Scores[x] = 0; return; }
                  { score -= A + B1; state = 1; break; }
              }
              if ((A > Ip)) {
                if ((B1 < Im)) { Scores[x] = 0; return; }
                  if ((B2 < Im)) { Scores[x] = 0; return; }
                    B1 = B2; b++; B2 = I[x+dirs[b]];
                if ((B2 < Im)) { Scores[x] = 0; return; }
                  { score -= A + B1; state = 9; break; }
              }
              // A ~ I0
              if ((B1 >= Im)) { Scores[x] = 0; return; }
                if ((B2 >= Im)) { Scores[x] = 0; return; }
                  B1 = B2; b++; B2 = I[x+dirs[b]];
              if ((B2 < Im)) { score -= A + B1; state = 2; break; };
              if ((B2 > Ip)) { score -= A + B1; state = 7; break; };
              { Scores[x] = 0; return; }

            case 2:
              if ((A > Ip)) { Scores[x] = 0; return; }
                B1 = B2; b++; B2 = I[x+dirs[b]];
              if ((A < Im))
              {
                if ((B2 > Ip)) { Scores[x] = 0; return; }
                  { score -= A + B1; state = 4; break; }
              } 
              // A ~ I0
              if ((B2 > Ip)) { score -= A + B1; state = 7; break; };
              if ((B2 < Im)) { score -= A + B1; state = 2; break; };
              { Scores[x] = 0; return; } // A ~ I0, B2 ~ I0

            case 3:
              if ((A < Im)) { Scores[x] = 0; return; }
                B1 = B2; b++; B2 = I[x+dirs[b]];
              if ((A > Ip)) {
                if ((B2 < Im)) { Scores[x] = 0; return; }
                  { score -= A + B1; state = 5; break; }
              }
              // A ~ I0
              if ((B2 > Ip)) { score -= A + B1; state = 3; break; };
              if ((B2 < Im)) { score -= A + B1; state = 6; break; };
              { Scores[x] = 0; return; }

            case 4:
              if ((A > Ip)) { Scores[x] = 0; return; }
                if ((A < Im)) {
                  B1 = B2; b++; B2 = I[x+dirs[b]];
                  if ((B2 > Ip)) { Scores[x] = 0; return; }
                    { score -= A + B1; state = 1; break; }
                }
                if ((B2 >= Im)) { Scores[x] = 0; return; }
                  B1 = B2; b++; B2 = I[x+dirs[b]];
                if ((B2 < Im)) { score -= A + B1; state = 2; break; };
                if ((B2 > Ip)) { score -= A + B1; state = 7; break; };
                { Scores[x] = 0; return; }

            case 5:
              if ((A < Im)) { Scores[x] = 0; return; }
                if ((A > Ip)) {
                  B1 = B2; b++; B2 = I[x+dirs[b]];
                  if ((B2 < Im)) { Scores[x] = 0; return; }
                    { score -= A + B1; state = 0; break; }
                }
                // A ~ I0
                if ((B2 <= Ip)) { Scores[x] = 0; return; }
                  B1 = B2; b++; B2 = I[x+dirs[b]];
                if ((B2 > Ip)) { score -= A + B1; state = 3; break; };
                if ((B2 < Im)) { score -= A + B1; state = 6; break; };
                { Scores[x] = 0; return; }

            case 7:
              if ((A > Ip)) { Scores[x] = 0; return; }
                if ((A < Im)) { Scores[x] = 0; return; }
                  B1 = B2; b++; B2 = I[x+dirs[b]];
              // A ~ I0
              if ((B2 > Ip)) { score -= A + B1; state = 3; break; };
              if ((B2 < Im)) { score -= A + B1; state = 6; break; };
              { Scores[x] = 0; return; } // A ~ I0, B2 ~ I0

            case 6:
              if ((A > Ip)) { Scores[x] = 0; return; }
                if ((A < Im)) { Scores[x] = 0; return; }
                  B1 = B2; b++; B2 = I[x+dirs[b]];
              // A ~ I0
              if ((B2 < Im)) { score -= A + B1; state = 2; break; };
              if ((B2 > Ip)) { score -= A + B1; state = 7; break; };
              { Scores[x] = 0; return; } // A ~ I0, B2 ~ I0

            case 8:
              if ((A > Ip)) {
                if ((B2 < Im)) { Scores[x] = 0; return; }
                  B1 = B2; b++; B2 = I[x+dirs[b]];
                if ((B2 < Im)) { Scores[x] = 0; return; }
                  { score -= A + B1; state = 9; break; }
              }
              if ((A < Im)) {
                B1 = B2; b++; B2 = I[x+dirs[b]];
                if ((B2 > Ip)) { Scores[x] = 0; return; }
                  { score -= A + B1; state = 1; break; }
              }
              { Scores[x] = 0; return; }

            case 9:
              if ((A < Im)) {
                if ((B2 > Ip)) { Scores[x] = 0; return; }
                  B1 = B2; b++; B2 = I[x+dirs[b]];
                if ((B2 > Ip)) { Scores[x] = 0; return; }
                  { score -= A + B1; state = 8; break; }
              }
              if ((A > Ip)) {
                B1 = B2; b++; B2 = I[x+dirs[b]];
                if ((B2 < Im)) { Scores[x] = 0; return; }
                  { score -= A + B1; state = 0; break; }
              }
              { Scores[x] = 0; return; }

            default:
              //"PB default";
              break;
            } // switch(state)
          } // for(a...)

          Scores[x] = (score + dirs_nb * I[x]);
        };

        var lev_table_t = (function () {
            function lev_table_t(w, h, r) {
                this.dirs = new Int32Array(1024);
                this.dirs_count = precompute_directions(w, this.dirs, r)|0;
                this.scores = new Int32Array(w*h);
                this.radius = r|0;
            }
            return lev_table_t;
        })();
        
        return {

            level_tables: [],
            tau: 7,

            init: function(width, height, radius, pyramid_levels) {
                if (typeof pyramid_levels === "undefined") { pyramid_levels = 1; }
                var i;
                radius = Math.min(radius, 7);
                radius = Math.max(radius, 3);
                for(i = 0; i < pyramid_levels; ++i) {
                    this.level_tables[i] = new lev_table_t(width>>i, height>>i, radius);
                }
            },

            detect: function(src, points, border) {
                if (typeof border === "undefined") { border = 4; }
                var t = this.level_tables[0];
                var R = t.radius|0, Rm1 = (R-1)|0;
                var dirs = t.dirs;
                var dirs_count = t.dirs_count|0;
                var opposite = dirs_count >> 1;
                var img = src.data, w=src.cols|0, h=src.rows|0,hw=w>>1;
                var scores = t.scores;
                var x=0,y=0,row=0,rowx=0,ip=0,im=0,abs_score=0, score=0;
                var tau = this.tau|0;
                var number_of_points = 0, pt;

                var sx = Math.max(R+1, border)|0;
                var sy = Math.max(R+1, border)|0;
                var ex = Math.min(w-R-2, w-border)|0;
                var ey = Math.min(h-R-2, h-border)|0;

                row = (sy*w+sx)|0;
                for(y = sy; y < ey; ++y, row+=w) {
                    for(x = sx, rowx = row; x < ex; ++x, ++rowx) {
                        ip = img[rowx] + tau, im = img[rowx] - tau;

                        if (im<img[rowx+R] && img[rowx+R]<ip && im<img[rowx-R] && img[rowx-R]<ip) {
                            scores[rowx] = 0;
                        } else {
                            perform_one_point(img, rowx, scores, im, ip, dirs, opposite, dirs_count);
                        }
                    }
                }

                // local maxima
                row = (sy*w+sx)|0;
                for(y = sy; y < ey; ++y, row+=w) {
                    for(x = sx, rowx = row; x < ex; ++x, ++rowx) {
                        score = scores[rowx];
                        abs_score = Math.abs(score);
                        if(abs_score < 5) {
                            // if this pixel is 0, the next one will not be good enough. Skip it.
                            ++x, ++rowx;
                        } else {
                            if(third_check(scores, rowx, w) >= 3 && is_local_maxima(scores, rowx, score, hw, R)) {
                                pt = points[number_of_points];
                                pt.x = x, pt.y = y, pt.score = abs_score;
                                ++number_of_points;

                                x += Rm1, rowx += Rm1;
                            }
                        }
                    }
                }

                return number_of_points;
            }
        };

    })();

    global.yape = yape;

})(jsfeat);
/**
 * @author Eugene Zatepyakin / http://inspirit.ru/
 *
 * Original implementation derived from OpenCV,
 * @authors Ethan Rublee, Vincent Rabaud, Gary Bradski
 */

(function(global) {
    "use strict";
    //

    var orb = (function() {

    	var bit_pattern_31_ = new Int32Array([
		    8,-3, 9,5/*mean (0), correlation (0)*/,
		    4,2, 7,-12/*mean (1.12461e-05), correlation (0.0437584)*/,
		    -11,9, -8,2/*mean (3.37382e-05), correlation (0.0617409)*/,
		    7,-12, 12,-13/*mean (5.62303e-05), correlation (0.0636977)*/,
		    2,-13, 2,12/*mean (0.000134953), correlation (0.085099)*/,
		    1,-7, 1,6/*mean (0.000528565), correlation (0.0857175)*/,
		    -2,-10, -2,-4/*mean (0.0188821), correlation (0.0985774)*/,
		    -13,-13, -11,-8/*mean (0.0363135), correlation (0.0899616)*/,
		    -13,-3, -12,-9/*mean (0.121806), correlation (0.099849)*/,
		    10,4, 11,9/*mean (0.122065), correlation (0.093285)*/,
		    -13,-8, -8,-9/*mean (0.162787), correlation (0.0942748)*/,
		    -11,7, -9,12/*mean (0.21561), correlation (0.0974438)*/,
		    7,7, 12,6/*mean (0.160583), correlation (0.130064)*/,
		    -4,-5, -3,0/*mean (0.228171), correlation (0.132998)*/,
		    -13,2, -12,-3/*mean (0.00997526), correlation (0.145926)*/,
		    -9,0, -7,5/*mean (0.198234), correlation (0.143636)*/,
		    12,-6, 12,-1/*mean (0.0676226), correlation (0.16689)*/,
		    -3,6, -2,12/*mean (0.166847), correlation (0.171682)*/,
		    -6,-13, -4,-8/*mean (0.101215), correlation (0.179716)*/,
		    11,-13, 12,-8/*mean (0.200641), correlation (0.192279)*/,
		    4,7, 5,1/*mean (0.205106), correlation (0.186848)*/,
		    5,-3, 10,-3/*mean (0.234908), correlation (0.192319)*/,
		    3,-7, 6,12/*mean (0.0709964), correlation (0.210872)*/,
		    -8,-7, -6,-2/*mean (0.0939834), correlation (0.212589)*/,
		    -2,11, -1,-10/*mean (0.127778), correlation (0.20866)*/,
		    -13,12, -8,10/*mean (0.14783), correlation (0.206356)*/,
		    -7,3, -5,-3/*mean (0.182141), correlation (0.198942)*/,
		    -4,2, -3,7/*mean (0.188237), correlation (0.21384)*/,
		    -10,-12, -6,11/*mean (0.14865), correlation (0.23571)*/,
		    5,-12, 6,-7/*mean (0.222312), correlation (0.23324)*/,
		    5,-6, 7,-1/*mean (0.229082), correlation (0.23389)*/,
		    1,0, 4,-5/*mean (0.241577), correlation (0.215286)*/,
		    9,11, 11,-13/*mean (0.00338507), correlation (0.251373)*/,
		    4,7, 4,12/*mean (0.131005), correlation (0.257622)*/,
		    2,-1, 4,4/*mean (0.152755), correlation (0.255205)*/,
		    -4,-12, -2,7/*mean (0.182771), correlation (0.244867)*/,
		    -8,-5, -7,-10/*mean (0.186898), correlation (0.23901)*/,
		    4,11, 9,12/*mean (0.226226), correlation (0.258255)*/,
		    0,-8, 1,-13/*mean (0.0897886), correlation (0.274827)*/,
		    -13,-2, -8,2/*mean (0.148774), correlation (0.28065)*/,
		    -3,-2, -2,3/*mean (0.153048), correlation (0.283063)*/,
		    -6,9, -4,-9/*mean (0.169523), correlation (0.278248)*/,
		    8,12, 10,7/*mean (0.225337), correlation (0.282851)*/,
		    0,9, 1,3/*mean (0.226687), correlation (0.278734)*/,
		    7,-5, 11,-10/*mean (0.00693882), correlation (0.305161)*/,
		    -13,-6, -11,0/*mean (0.0227283), correlation (0.300181)*/,
		    10,7, 12,1/*mean (0.125517), correlation (0.31089)*/,
		    -6,-3, -6,12/*mean (0.131748), correlation (0.312779)*/,
		    10,-9, 12,-4/*mean (0.144827), correlation (0.292797)*/,
		    -13,8, -8,-12/*mean (0.149202), correlation (0.308918)*/,
		    -13,0, -8,-4/*mean (0.160909), correlation (0.310013)*/,
		    3,3, 7,8/*mean (0.177755), correlation (0.309394)*/,
		    5,7, 10,-7/*mean (0.212337), correlation (0.310315)*/,
		    -1,7, 1,-12/*mean (0.214429), correlation (0.311933)*/,
		    3,-10, 5,6/*mean (0.235807), correlation (0.313104)*/,
		    2,-4, 3,-10/*mean (0.00494827), correlation (0.344948)*/,
		    -13,0, -13,5/*mean (0.0549145), correlation (0.344675)*/,
		    -13,-7, -12,12/*mean (0.103385), correlation (0.342715)*/,
		    -13,3, -11,8/*mean (0.134222), correlation (0.322922)*/,
		    -7,12, -4,7/*mean (0.153284), correlation (0.337061)*/,
		    6,-10, 12,8/*mean (0.154881), correlation (0.329257)*/,
		    -9,-1, -7,-6/*mean (0.200967), correlation (0.33312)*/,
		    -2,-5, 0,12/*mean (0.201518), correlation (0.340635)*/,
		    -12,5, -7,5/*mean (0.207805), correlation (0.335631)*/,
		    3,-10, 8,-13/*mean (0.224438), correlation (0.34504)*/,
		    -7,-7, -4,5/*mean (0.239361), correlation (0.338053)*/,
		    -3,-2, -1,-7/*mean (0.240744), correlation (0.344322)*/,
		    2,9, 5,-11/*mean (0.242949), correlation (0.34145)*/,
		    -11,-13, -5,-13/*mean (0.244028), correlation (0.336861)*/,
		    -1,6, 0,-1/*mean (0.247571), correlation (0.343684)*/,
		    5,-3, 5,2/*mean (0.000697256), correlation (0.357265)*/,
		    -4,-13, -4,12/*mean (0.00213675), correlation (0.373827)*/,
		    -9,-6, -9,6/*mean (0.0126856), correlation (0.373938)*/,
		    -12,-10, -8,-4/*mean (0.0152497), correlation (0.364237)*/,
		    10,2, 12,-3/*mean (0.0299933), correlation (0.345292)*/,
		    7,12, 12,12/*mean (0.0307242), correlation (0.366299)*/,
		    -7,-13, -6,5/*mean (0.0534975), correlation (0.368357)*/,
		    -4,9, -3,4/*mean (0.099865), correlation (0.372276)*/,
		    7,-1, 12,2/*mean (0.117083), correlation (0.364529)*/,
		    -7,6, -5,1/*mean (0.126125), correlation (0.369606)*/,
		    -13,11, -12,5/*mean (0.130364), correlation (0.358502)*/,
		    -3,7, -2,-6/*mean (0.131691), correlation (0.375531)*/,
		    7,-8, 12,-7/*mean (0.160166), correlation (0.379508)*/,
		    -13,-7, -11,-12/*mean (0.167848), correlation (0.353343)*/,
		    1,-3, 12,12/*mean (0.183378), correlation (0.371916)*/,
		    2,-6, 3,0/*mean (0.228711), correlation (0.371761)*/,
		    -4,3, -2,-13/*mean (0.247211), correlation (0.364063)*/,
		    -1,-13, 1,9/*mean (0.249325), correlation (0.378139)*/,
		    7,1, 8,-6/*mean (0.000652272), correlation (0.411682)*/,
		    1,-1, 3,12/*mean (0.00248538), correlation (0.392988)*/,
		    9,1, 12,6/*mean (0.0206815), correlation (0.386106)*/,
		    -1,-9, -1,3/*mean (0.0364485), correlation (0.410752)*/,
		    -13,-13, -10,5/*mean (0.0376068), correlation (0.398374)*/,
		    7,7, 10,12/*mean (0.0424202), correlation (0.405663)*/,
		    12,-5, 12,9/*mean (0.0942645), correlation (0.410422)*/,
		    6,3, 7,11/*mean (0.1074), correlation (0.413224)*/,
		    5,-13, 6,10/*mean (0.109256), correlation (0.408646)*/,
		    2,-12, 2,3/*mean (0.131691), correlation (0.416076)*/,
		    3,8, 4,-6/*mean (0.165081), correlation (0.417569)*/,
		    2,6, 12,-13/*mean (0.171874), correlation (0.408471)*/,
		    9,-12, 10,3/*mean (0.175146), correlation (0.41296)*/,
		    -8,4, -7,9/*mean (0.183682), correlation (0.402956)*/,
		    -11,12, -4,-6/*mean (0.184672), correlation (0.416125)*/,
		    1,12, 2,-8/*mean (0.191487), correlation (0.386696)*/,
		    6,-9, 7,-4/*mean (0.192668), correlation (0.394771)*/,
		    2,3, 3,-2/*mean (0.200157), correlation (0.408303)*/,
		    6,3, 11,0/*mean (0.204588), correlation (0.411762)*/,
		    3,-3, 8,-8/*mean (0.205904), correlation (0.416294)*/,
		    7,8, 9,3/*mean (0.213237), correlation (0.409306)*/,
		    -11,-5, -6,-4/*mean (0.243444), correlation (0.395069)*/,
		    -10,11, -5,10/*mean (0.247672), correlation (0.413392)*/,
		    -5,-8, -3,12/*mean (0.24774), correlation (0.411416)*/,
		    -10,5, -9,0/*mean (0.00213675), correlation (0.454003)*/,
		    8,-1, 12,-6/*mean (0.0293635), correlation (0.455368)*/,
		    4,-6, 6,-11/*mean (0.0404971), correlation (0.457393)*/,
		    -10,12, -8,7/*mean (0.0481107), correlation (0.448364)*/,
		    4,-2, 6,7/*mean (0.050641), correlation (0.455019)*/,
		    -2,0, -2,12/*mean (0.0525978), correlation (0.44338)*/,
		    -5,-8, -5,2/*mean (0.0629667), correlation (0.457096)*/,
		    7,-6, 10,12/*mean (0.0653846), correlation (0.445623)*/,
		    -9,-13, -8,-8/*mean (0.0858749), correlation (0.449789)*/,
		    -5,-13, -5,-2/*mean (0.122402), correlation (0.450201)*/,
		    8,-8, 9,-13/*mean (0.125416), correlation (0.453224)*/,
		    -9,-11, -9,0/*mean (0.130128), correlation (0.458724)*/,
		    1,-8, 1,-2/*mean (0.132467), correlation (0.440133)*/,
		    7,-4, 9,1/*mean (0.132692), correlation (0.454)*/,
		    -2,1, -1,-4/*mean (0.135695), correlation (0.455739)*/,
		    11,-6, 12,-11/*mean (0.142904), correlation (0.446114)*/,
		    -12,-9, -6,4/*mean (0.146165), correlation (0.451473)*/,
		    3,7, 7,12/*mean (0.147627), correlation (0.456643)*/,
		    5,5, 10,8/*mean (0.152901), correlation (0.455036)*/,
		    0,-4, 2,8/*mean (0.167083), correlation (0.459315)*/,
		    -9,12, -5,-13/*mean (0.173234), correlation (0.454706)*/,
		    0,7, 2,12/*mean (0.18312), correlation (0.433855)*/,
		    -1,2, 1,7/*mean (0.185504), correlation (0.443838)*/,
		    5,11, 7,-9/*mean (0.185706), correlation (0.451123)*/,
		    3,5, 6,-8/*mean (0.188968), correlation (0.455808)*/,
		    -13,-4, -8,9/*mean (0.191667), correlation (0.459128)*/,
		    -5,9, -3,-3/*mean (0.193196), correlation (0.458364)*/,
		    -4,-7, -3,-12/*mean (0.196536), correlation (0.455782)*/,
		    6,5, 8,0/*mean (0.1972), correlation (0.450481)*/,
		    -7,6, -6,12/*mean (0.199438), correlation (0.458156)*/,
		    -13,6, -5,-2/*mean (0.211224), correlation (0.449548)*/,
		    1,-10, 3,10/*mean (0.211718), correlation (0.440606)*/,
		    4,1, 8,-4/*mean (0.213034), correlation (0.443177)*/,
		    -2,-2, 2,-13/*mean (0.234334), correlation (0.455304)*/,
		    2,-12, 12,12/*mean (0.235684), correlation (0.443436)*/,
		    -2,-13, 0,-6/*mean (0.237674), correlation (0.452525)*/,
		    4,1, 9,3/*mean (0.23962), correlation (0.444824)*/,
		    -6,-10, -3,-5/*mean (0.248459), correlation (0.439621)*/,
		    -3,-13, -1,1/*mean (0.249505), correlation (0.456666)*/,
		    7,5, 12,-11/*mean (0.00119208), correlation (0.495466)*/,
		    4,-2, 5,-7/*mean (0.00372245), correlation (0.484214)*/,
		    -13,9, -9,-5/*mean (0.00741116), correlation (0.499854)*/,
		    7,1, 8,6/*mean (0.0208952), correlation (0.499773)*/,
		    7,-8, 7,6/*mean (0.0220085), correlation (0.501609)*/,
		    -7,-4, -7,1/*mean (0.0233806), correlation (0.496568)*/,
		    -8,11, -7,-8/*mean (0.0236505), correlation (0.489719)*/,
		    -13,6, -12,-8/*mean (0.0268781), correlation (0.503487)*/,
		    2,4, 3,9/*mean (0.0323324), correlation (0.501938)*/,
		    10,-5, 12,3/*mean (0.0399235), correlation (0.494029)*/,
		    -6,-5, -6,7/*mean (0.0420153), correlation (0.486579)*/,
		    8,-3, 9,-8/*mean (0.0548021), correlation (0.484237)*/,
		    2,-12, 2,8/*mean (0.0616622), correlation (0.496642)*/,
		    -11,-2, -10,3/*mean (0.0627755), correlation (0.498563)*/,
		    -12,-13, -7,-9/*mean (0.0829622), correlation (0.495491)*/,
		    -11,0, -10,-5/*mean (0.0843342), correlation (0.487146)*/,
		    5,-3, 11,8/*mean (0.0929937), correlation (0.502315)*/,
		    -2,-13, -1,12/*mean (0.113327), correlation (0.48941)*/,
		    -1,-8, 0,9/*mean (0.132119), correlation (0.467268)*/,
		    -13,-11, -12,-5/*mean (0.136269), correlation (0.498771)*/,
		    -10,-2, -10,11/*mean (0.142173), correlation (0.498714)*/,
		    -3,9, -2,-13/*mean (0.144141), correlation (0.491973)*/,
		    2,-3, 3,2/*mean (0.14892), correlation (0.500782)*/,
		    -9,-13, -4,0/*mean (0.150371), correlation (0.498211)*/,
		    -4,6, -3,-10/*mean (0.152159), correlation (0.495547)*/,
		    -4,12, -2,-7/*mean (0.156152), correlation (0.496925)*/,
		    -6,-11, -4,9/*mean (0.15749), correlation (0.499222)*/,
		    6,-3, 6,11/*mean (0.159211), correlation (0.503821)*/,
		    -13,11, -5,5/*mean (0.162427), correlation (0.501907)*/,
		    11,11, 12,6/*mean (0.16652), correlation (0.497632)*/,
		    7,-5, 12,-2/*mean (0.169141), correlation (0.484474)*/,
		    -1,12, 0,7/*mean (0.169456), correlation (0.495339)*/,
		    -4,-8, -3,-2/*mean (0.171457), correlation (0.487251)*/,
		    -7,1, -6,7/*mean (0.175), correlation (0.500024)*/,
		    -13,-12, -8,-13/*mean (0.175866), correlation (0.497523)*/,
		    -7,-2, -6,-8/*mean (0.178273), correlation (0.501854)*/,
		    -8,5, -6,-9/*mean (0.181107), correlation (0.494888)*/,
		    -5,-1, -4,5/*mean (0.190227), correlation (0.482557)*/,
		    -13,7, -8,10/*mean (0.196739), correlation (0.496503)*/,
		    1,5, 5,-13/*mean (0.19973), correlation (0.499759)*/,
		    1,0, 10,-13/*mean (0.204465), correlation (0.49873)*/,
		    9,12, 10,-1/*mean (0.209334), correlation (0.49063)*/,
		    5,-8, 10,-9/*mean (0.211134), correlation (0.503011)*/,
		    -1,11, 1,-13/*mean (0.212), correlation (0.499414)*/,
		    -9,-3, -6,2/*mean (0.212168), correlation (0.480739)*/,
		    -1,-10, 1,12/*mean (0.212731), correlation (0.502523)*/,
		    -13,1, -8,-10/*mean (0.21327), correlation (0.489786)*/,
		    8,-11, 10,-6/*mean (0.214159), correlation (0.488246)*/,
		    2,-13, 3,-6/*mean (0.216993), correlation (0.50287)*/,
		    7,-13, 12,-9/*mean (0.223639), correlation (0.470502)*/,
		    -10,-10, -5,-7/*mean (0.224089), correlation (0.500852)*/,
		    -10,-8, -8,-13/*mean (0.228666), correlation (0.502629)*/,
		    4,-6, 8,5/*mean (0.22906), correlation (0.498305)*/,
		    3,12, 8,-13/*mean (0.233378), correlation (0.503825)*/,
		    -4,2, -3,-3/*mean (0.234323), correlation (0.476692)*/,
		    5,-13, 10,-12/*mean (0.236392), correlation (0.475462)*/,
		    4,-13, 5,-1/*mean (0.236842), correlation (0.504132)*/,
		    -9,9, -4,3/*mean (0.236977), correlation (0.497739)*/,
		    0,3, 3,-9/*mean (0.24314), correlation (0.499398)*/,
		    -12,1, -6,1/*mean (0.243297), correlation (0.489447)*/,
		    3,2, 4,-8/*mean (0.00155196), correlation (0.553496)*/,
		    -10,-10, -10,9/*mean (0.00239541), correlation (0.54297)*/,
		    8,-13, 12,12/*mean (0.0034413), correlation (0.544361)*/,
		    -8,-12, -6,-5/*mean (0.003565), correlation (0.551225)*/,
		    2,2, 3,7/*mean (0.00835583), correlation (0.55285)*/,
		    10,6, 11,-8/*mean (0.00885065), correlation (0.540913)*/,
		    6,8, 8,-12/*mean (0.0101552), correlation (0.551085)*/,
		    -7,10, -6,5/*mean (0.0102227), correlation (0.533635)*/,
		    -3,-9, -3,9/*mean (0.0110211), correlation (0.543121)*/,
		    -1,-13, -1,5/*mean (0.0113473), correlation (0.550173)*/,
		    -3,-7, -3,4/*mean (0.0140913), correlation (0.554774)*/,
		    -8,-2, -8,3/*mean (0.017049), correlation (0.55461)*/,
		    4,2, 12,12/*mean (0.01778), correlation (0.546921)*/,
		    2,-5, 3,11/*mean (0.0224022), correlation (0.549667)*/,
		    6,-9, 11,-13/*mean (0.029161), correlation (0.546295)*/,
		    3,-1, 7,12/*mean (0.0303081), correlation (0.548599)*/,
		    11,-1, 12,4/*mean (0.0355151), correlation (0.523943)*/,
		    -3,0, -3,6/*mean (0.0417904), correlation (0.543395)*/,
		    4,-11, 4,12/*mean (0.0487292), correlation (0.542818)*/,
		    2,-4, 2,1/*mean (0.0575124), correlation (0.554888)*/,
		    -10,-6, -8,1/*mean (0.0594242), correlation (0.544026)*/,
		    -13,7, -11,1/*mean (0.0597391), correlation (0.550524)*/,
		    -13,12, -11,-13/*mean (0.0608974), correlation (0.55383)*/,
		    6,0, 11,-13/*mean (0.065126), correlation (0.552006)*/,
		    0,-1, 1,4/*mean (0.074224), correlation (0.546372)*/,
		    -13,3, -9,-2/*mean (0.0808592), correlation (0.554875)*/,
		    -9,8, -6,-3/*mean (0.0883378), correlation (0.551178)*/,
		    -13,-6, -8,-2/*mean (0.0901035), correlation (0.548446)*/,
		    5,-9, 8,10/*mean (0.0949843), correlation (0.554694)*/,
		    2,7, 3,-9/*mean (0.0994152), correlation (0.550979)*/,
		    -1,-6, -1,-1/*mean (0.10045), correlation (0.552714)*/,
		    9,5, 11,-2/*mean (0.100686), correlation (0.552594)*/,
		    11,-3, 12,-8/*mean (0.101091), correlation (0.532394)*/,
		    3,0, 3,5/*mean (0.101147), correlation (0.525576)*/,
		    -1,4, 0,10/*mean (0.105263), correlation (0.531498)*/,
		    3,-6, 4,5/*mean (0.110785), correlation (0.540491)*/,
		    -13,0, -10,5/*mean (0.112798), correlation (0.536582)*/,
		    5,8, 12,11/*mean (0.114181), correlation (0.555793)*/,
		    8,9, 9,-6/*mean (0.117431), correlation (0.553763)*/,
		    7,-4, 8,-12/*mean (0.118522), correlation (0.553452)*/,
		    -10,4, -10,9/*mean (0.12094), correlation (0.554785)*/,
		    7,3, 12,4/*mean (0.122582), correlation (0.555825)*/,
		    9,-7, 10,-2/*mean (0.124978), correlation (0.549846)*/,
		    7,0, 12,-2/*mean (0.127002), correlation (0.537452)*/,
		    -1,-6, 0,-11/*mean (0.127148), correlation (0.547401)*/
		]);

	    var H = new jsfeat.matrix_t(3, 3, jsfeat.F32_t|jsfeat.C1_t);
	    var patch_img = new jsfeat.matrix_t(32, 32, jsfeat.U8_t|jsfeat.C1_t);

	    var rectify_patch = function(src, dst, angle, px, py, psize) {
	    	var cosine = Math.cos(angle);
	    	var sine   = Math.sin(angle);

	        H.data[0] = cosine, H.data[1] = -sine,    H.data[2] = (-cosine + sine  ) * psize*0.5 + px,
	        H.data[3] = sine,   H.data[4] =  cosine,  H.data[5] = (-sine   - cosine) * psize*0.5 + py;

	        jsfeat.imgproc.warp_affine(src, dst, H, 128);
	    };

    	return {

    		describe: function(src, corners, count, descriptors) {
    			var DESCR_SIZE = 32; // bytes;
				var i=0,b=0,px=0.0,py=0.0,angle=0.0;
				var t0=0, t1=0, val=0;
				var img = src.data, w = src.cols, h = src.rows;
				var patch_d = patch_img.data;
				var patch_off = 16*32 + 16; // center of patch
				var patt=0;

				if(!(descriptors.type&jsfeat.U8_t)) {
					// relocate to U8 type
					descriptors.type = jsfeat.U8_t;
					descriptors.cols = DESCR_SIZE;
	                descriptors.rows = count;
	                descriptors.channel = 1;
					descriptors.allocate();
				} else {
					descriptors.resize(DESCR_SIZE, count, 1);
				}

				var descr_d = descriptors.data;
				var descr_off = 0;

				for(i = 0; i < count; ++i) {
					px = corners[i].x;
					py = corners[i].y;
					angle = corners[i].angle;

					rectify_patch(src, patch_img, angle, px, py, 32);

					// describe the patch
					patt = 0;
					for (b = 0; b < DESCR_SIZE; ++b) {
			            
			            t0 = patch_d[patch_off + bit_pattern_31_[patt+1] * 32 + bit_pattern_31_[patt]]; patt += 2;
			            t1 = patch_d[patch_off + bit_pattern_31_[patt+1] * 32 + bit_pattern_31_[patt]]; patt += 2;
			            val = (t0 < t1)|0;
			            
			            t0 = patch_d[patch_off + bit_pattern_31_[patt+1] * 32 + bit_pattern_31_[patt]]; patt += 2;
			            t1 = patch_d[patch_off + bit_pattern_31_[patt+1] * 32 + bit_pattern_31_[patt]]; patt += 2;
			            val |= (t0 < t1) << 1;
			            
			            t0 = patch_d[patch_off + bit_pattern_31_[patt+1] * 32 + bit_pattern_31_[patt]]; patt += 2;
			            t1 = patch_d[patch_off + bit_pattern_31_[patt+1] * 32 + bit_pattern_31_[patt]]; patt += 2;
			            val |= (t0 < t1) << 2;
			            
			            t0 = patch_d[patch_off + bit_pattern_31_[patt+1] * 32 + bit_pattern_31_[patt]]; patt += 2;
			            t1 = patch_d[patch_off + bit_pattern_31_[patt+1] * 32 + bit_pattern_31_[patt]]; patt += 2;
			            val |= (t0 < t1) << 3;
			            
			            t0 = patch_d[patch_off + bit_pattern_31_[patt+1] * 32 + bit_pattern_31_[patt]]; patt += 2;
			            t1 = patch_d[patch_off + bit_pattern_31_[patt+1] * 32 + bit_pattern_31_[patt]]; patt += 2;
			            val |= (t0 < t1) << 4;
			            
			            t0 = patch_d[patch_off + bit_pattern_31_[patt+1] * 32 + bit_pattern_31_[patt]]; patt += 2;
			            t1 = patch_d[patch_off + bit_pattern_31_[patt+1] * 32 + bit_pattern_31_[patt]]; patt += 2;
			            val |= (t0 < t1) << 5;
			            
			            t0 = patch_d[patch_off + bit_pattern_31_[patt+1] * 32 + bit_pattern_31_[patt]]; patt += 2;
			            t1 = patch_d[patch_off + bit_pattern_31_[patt+1] * 32 + bit_pattern_31_[patt]]; patt += 2;
			            val |= (t0 < t1) << 6;
			            
			            t0 = patch_d[patch_off + bit_pattern_31_[patt+1] * 32 + bit_pattern_31_[patt]]; patt += 2;
			            t1 = patch_d[patch_off + bit_pattern_31_[patt+1] * 32 + bit_pattern_31_[patt]]; patt += 2;
			            val |= (t0 < t1) << 7;
			            
			            descr_d[descr_off+b] = val;
			        }
			        descr_off += DESCR_SIZE;
				}
    		}
    	};
    })();

    global.orb = orb;

})(jsfeat);
/**
 * @author Eugene Zatepyakin / http://inspirit.ru/
 *
 * this code is a rewrite from OpenCV's Lucas-Kanade optical flow implementation
 */

(function(global) {
    "use strict";
    //
    var optical_flow_lk = (function() {

        // short link to shar deriv
        var scharr_deriv = jsfeat.imgproc.scharr_derivatives;

        return {
            track: function(prev_pyr, curr_pyr, prev_xy, curr_xy, count, win_size, max_iter, status, eps, min_eigen_threshold) {
                if (typeof max_iter === "undefined") { max_iter = 30; }
                if (typeof status === "undefined") { status = new Uint8Array(count); }
                if (typeof eps === "undefined") { eps = 0.01; }
                if (typeof min_eigen_threshold === "undefined") { min_eigen_threshold = 0.0001; }

                var half_win = (win_size-1)*0.5;
                var win_area = (win_size*win_size)|0;
                var win_area2 = win_area << 1;
                var prev_imgs = prev_pyr.data, next_imgs = curr_pyr.data;
                var img_prev=prev_imgs[0].data,img_next=next_imgs[0].data;
                var w0 = prev_imgs[0].cols, h0 = prev_imgs[0].rows,lw=0,lh=0;

                var iwin_node = jsfeat.cache.get_buffer(win_area<<2);
                var deriv_iwin_node = jsfeat.cache.get_buffer(win_area2<<2);
                var deriv_lev_node = jsfeat.cache.get_buffer((h0*(w0<<1))<<2);

                var deriv_m = new jsfeat.matrix_t(w0, h0, jsfeat.S32C2_t, deriv_lev_node.data);

                var iwin_buf = iwin_node.i32;
                var deriv_iwin = deriv_iwin_node.i32;
                var deriv_lev = deriv_lev_node.i32;

                var dstep=0,src=0,dsrc=0,iptr=0,diptr=0,jptr=0;
                var lev_sc=0.0,prev_x=0.0,prev_y=0.0,next_x=0.0,next_y=0.0;
                var prev_delta_x=0.0,prev_delta_y=0.0,delta_x=0.0,delta_y=0.0;
                var iprev_x=0,iprev_y=0,inext_x=0,inext_y=0;
                var i=0,j=0,x=0,y=0,level=0,ptid=0,iter=0;
                var brd_tl=0,brd_r=0,brd_b=0;
                var a=0.0,b=0.0,b1=0.0,b2=0.0;

                // fixed point math
                var W_BITS14 = 14;
                var W_BITS4 = 14;
                var W_BITS1m5 = W_BITS4 - 5;
                var W_BITS1m51 = (1 << ((W_BITS1m5) - 1));
                var W_BITS14_ = (1 << W_BITS14);
                var W_BITS41 = (1 << ((W_BITS4) - 1));
                var FLT_SCALE = 1.0/(1 << 20);
                var iw00=0,iw01=0,iw10=0,iw11=0,ival=0,ixval=0,iyval=0;
                var A11=0.0,A12=0.0,A22=0.0,D=0.0,min_eig=0.0;

                var FLT_EPSILON = 0.00000011920929;
                eps *= eps;

                // reset status
                for(; i < count; ++i) {
                    status[i] = 1;
                }

                var max_level = (prev_pyr.levels - 1)|0;
                level = max_level;

                for(; level >= 0; --level) {
                    lev_sc = (1.0/(1 << level));
                    lw = w0 >> level;
                    lh = h0 >> level;
                    dstep = lw << 1;
                    img_prev = prev_imgs[level].data;
                    img_next = next_imgs[level].data;
                    
                    brd_r = (lw - win_size)|0;
                    brd_b = (lh - win_size)|0;

                    // calculate level derivatives
                    scharr_deriv(prev_imgs[level], deriv_m);

                    // iterate through points
                    for(ptid = 0; ptid < count; ++ptid) {
                        i = ptid << 1;
                        j = i + 1;
                        prev_x = prev_xy[i]*lev_sc;
                        prev_y = prev_xy[j]*lev_sc;

                        if( level == max_level ) {
                            next_x = prev_x;
                            next_y = prev_y;
                        } else {
                            next_x = curr_xy[i]*2.0;
                            next_y = curr_xy[j]*2.0;
                        }
                        curr_xy[i] = next_x;
                        curr_xy[j] = next_y;

                        prev_x -= half_win;
                        prev_y -= half_win;
                        iprev_x = prev_x|0;
                        iprev_y = prev_y|0;

                        // border check
                        x = (iprev_x <= brd_tl)|(iprev_x >= brd_r)|(iprev_y <= brd_tl)|(iprev_y >= brd_b);
                        if( x != 0 ) {
                            if( level == 0 ) {
                                status[ptid] = 0;
                            }
                            continue;
                        }

                        a = prev_x - iprev_x;
                        b = prev_y - iprev_y;
                        iw00 = (((1.0 - a)*(1.0 - b)*W_BITS14_) + 0.5)|0;
                        iw01 = ((a*(1.0 - b)*W_BITS14_) + 0.5)|0;
                        iw10 = (((1.0 - a)*b*W_BITS14_) + 0.5)|0;
                        iw11 = (W_BITS14_ - iw00 - iw01 - iw10);

                        A11 = 0.0, A12 = 0.0, A22 = 0.0;

                        // extract the patch from the first image, compute covariation matrix of derivatives
                        for( y = 0; y < win_size; ++y ) {
                            src = ( (y + iprev_y)*lw + iprev_x )|0;
                            dsrc = src << 1;

                            iptr = (y*win_size)|0;
                            diptr = iptr << 1;
                            for(x = 0 ; x < win_size; ++x, ++src, ++iptr, dsrc += 2) {
                                ival = ( (img_prev[src])*iw00 + (img_prev[src+1])*iw01 +
                                        (img_prev[src+lw])*iw10 + (img_prev[src+lw+1])*iw11 );
                                ival = (((ival) + W_BITS1m51) >> (W_BITS1m5));

                                ixval = ( deriv_lev[dsrc]*iw00 + deriv_lev[dsrc+2]*iw01 +
                                        deriv_lev[dsrc+dstep]*iw10 + deriv_lev[dsrc+dstep+2]*iw11 );
                                ixval = (((ixval) + W_BITS41) >> (W_BITS4));

                                iyval = ( deriv_lev[dsrc+1]*iw00 + deriv_lev[dsrc+3]*iw01 + deriv_lev[dsrc+dstep+1]*iw10 +
                                        deriv_lev[dsrc+dstep+3]*iw11 );
                                iyval = (((iyval) + W_BITS41) >> (W_BITS4));

                                iwin_buf[iptr] = ival;
                                deriv_iwin[diptr++] = ixval;
                                deriv_iwin[diptr++] = iyval;

                                A11 += ixval*ixval;
                                A12 += ixval*iyval;
                                A22 += iyval*iyval;
                            }
                        }

                        A11 *= FLT_SCALE; A12 *= FLT_SCALE; A22 *= FLT_SCALE;

                        D = A11*A22 - A12*A12;
                        min_eig = (A22 + A11 - Math.sqrt((A11-A22)*(A11-A22) + 4.0*A12*A12)) / win_area2;

                        if( min_eig < min_eigen_threshold || D < FLT_EPSILON )
                        {
                            if( level == 0 ) {
                                status[ptid] = 0;
                            }
                            continue;
                        }

                        D = 1.0/D;

                        next_x -= half_win;
                        next_y -= half_win;
                        prev_delta_x = 0.0;
                        prev_delta_y = 0.0;

                        for( iter = 0; iter < max_iter; ++iter ) {
                            inext_x = next_x|0;
                            inext_y = next_y|0;

                            x = (inext_x <= brd_tl)|(inext_x >= brd_r)|(inext_y <= brd_tl)|(inext_y >= brd_b);
                            if( x != 0 ) {
                                if( level == 0 ) {
                                    status[ptid] = 0;
                                }
                                break;
                            }

                            a = next_x - inext_x;
                            b = next_y - inext_y;
                            iw00 = (((1.0 - a)*(1.0 - b)*W_BITS14_) + 0.5)|0;
                            iw01 = ((a*(1.0 - b)*W_BITS14_) + 0.5)|0;
                            iw10 = (((1.0 - a)*b*W_BITS14_) + 0.5)|0;
                            iw11 = (W_BITS14_ - iw00 - iw01 - iw10);
                            b1 = 0.0, b2 = 0.0;

                            for( y = 0; y < win_size; ++y ) {
                                jptr = ( (y + inext_y)*lw + inext_x )|0;

                                iptr = (y*win_size)|0;
                                diptr = iptr << 1;
                                for( x = 0 ; x < win_size; ++x, ++jptr, ++iptr ) {
                                    ival = ( (img_next[jptr])*iw00 + (img_next[jptr+1])*iw01 +
                                            (img_next[jptr+lw])*iw10 + (img_next[jptr+lw+1])*iw11 );
                                    ival = (((ival) + W_BITS1m51) >> (W_BITS1m5));
                                    ival = (ival - iwin_buf[iptr]);

                                    b1 += ival * deriv_iwin[diptr++];
                                    b2 += ival * deriv_iwin[diptr++];
                                }
                            }

                            b1 *= FLT_SCALE;
                            b2 *= FLT_SCALE;

                            delta_x = ((A12*b2 - A22*b1) * D);
                            delta_y = ((A12*b1 - A11*b2) * D);

                            next_x += delta_x;
                            next_y += delta_y;
                            curr_xy[i] = next_x + half_win;
                            curr_xy[j] = next_y + half_win;

                            if( delta_x*delta_x + delta_y*delta_y <= eps ) {
                                break;
                            }

                            if( iter > 0 && Math.abs(delta_x + prev_delta_x) < 0.01 &&
                                            Math.abs(delta_y + prev_delta_y) < 0.01 ) {
                                curr_xy[i] -= delta_x*0.5;
                                curr_xy[j] -= delta_y*0.5;
                                break;
                            }

                            prev_delta_x = delta_x;
                            prev_delta_y = delta_y;
                        }
                    } // points loop
                } // levels loop

                jsfeat.cache.put_buffer(iwin_node);
                jsfeat.cache.put_buffer(deriv_iwin_node);
                jsfeat.cache.put_buffer(deriv_lev_node);
            }
        };
    })();

    global.optical_flow_lk = optical_flow_lk;

})(jsfeat);
/**
 * @author Eugene Zatepyakin / http://inspirit.ru/
 *
 * this code is a rewrite from https://github.com/mtschirs/js-objectdetect implementation
 * @author Martin Tschirsich / http://www.tu-darmstadt.de/~m_t
 */

(function(global) {
    "use strict";
    //
    var haar = (function() {

        var _group_func = function(r1, r2) {
            var distance = (r1.width * 0.25 + 0.5)|0;

            return r2.x <= r1.x + distance &&
                   r2.x >= r1.x - distance &&
                   r2.y <= r1.y + distance &&
                   r2.y >= r1.y - distance &&
                   r2.width <= (r1.width * 1.5 + 0.5)|0 &&
                   (r2.width * 1.5 + 0.5)|0 >= r1.width;
        };
        
        return {

            edges_density: 0.07,

            detect_single_scale: function(int_sum, int_sqsum, int_tilted, int_canny_sum, width, height, scale, classifier) {
                var win_w = (classifier.size[0] * scale)|0,
                    win_h = (classifier.size[1] * scale)|0,
                    step_x = (0.5 * scale + 1.5)|0,
                    step_y = step_x;
                var i,j,k,x,y,ex=(width-win_w)|0,ey=(height-win_h)|0;
                var w1=(width+1)|0,edge_dens,mean,variance,std;
                var inv_area = 1.0 / (win_w * win_h);
                var stages,stage,trees,tree,sn,tn,fn,found=true,stage_thresh,stage_sum,tree_sum,feature,features;
                var fi_a,fi_b,fi_c,fi_d,fw,fh;

                var ii_a=0,ii_b=win_w,ii_c=win_h*w1,ii_d=ii_c+win_w;
                var edges_thresh = ((win_w*win_h) * 0xff * this.edges_density)|0;
                // if too much gradient we also can skip
                //var edges_thresh_high = ((win_w*win_h) * 0xff * 0.3)|0;

                var rects = [];
                for(y = 0; y < ey; y += step_y) {
                    ii_a = y * w1;
                    for(x = 0; x < ex; x += step_x, ii_a += step_x) {

                        mean =    int_sum[ii_a] 
                                - int_sum[ii_a+ii_b]
                                - int_sum[ii_a+ii_c]
                                + int_sum[ii_a+ii_d];

                        // canny prune
                        if(int_canny_sum) {
                            edge_dens = (int_canny_sum[ii_a] 
                                        - int_canny_sum[ii_a+ii_b]
                                        - int_canny_sum[ii_a+ii_c]
                                        + int_canny_sum[ii_a+ii_d]);
                            if(edge_dens < edges_thresh || mean < 20) {
                                x += step_x, ii_a += step_x;
                                continue;
                            }
                        }

                        mean *= inv_area;
                        variance = (int_sqsum[ii_a] 
                                    - int_sqsum[ii_a+ii_b]
                                    - int_sqsum[ii_a+ii_c]
                                    + int_sqsum[ii_a+ii_d]) * inv_area - mean * mean;

                        std = variance > 0. ? Math.sqrt(variance) : 1;

                        stages = classifier.complexClassifiers;
                        sn = stages.length;
                        found =  true;
                        for(i = 0; i < sn; ++i) {
                            stage = stages[i];
                            stage_thresh = stage.threshold;
                            trees = stage.simpleClassifiers;
                            tn = trees.length;
                            stage_sum = 0;
                            for(j = 0; j < tn; ++j) {
                                tree = trees[j];
                                tree_sum = 0;
                                features = tree.features;
                                fn = features.length;
                                if(tree.tilted === 1) {
                                    for(k=0; k < fn; ++k) {
                                        feature = features[k];
                                        fi_a = ~~(x + feature[0] * scale) + ~~(y + feature[1] * scale) * w1;
                                        fw = ~~(feature[2] * scale);
                                        fh = ~~(feature[3] * scale);
                                        fi_b = fw * w1;
                                        fi_c =  fh * w1;

                                        tree_sum += (int_tilted[fi_a]
                                                    - int_tilted[fi_a + fw + fi_b]
                                                    - int_tilted[fi_a - fh + fi_c]
                                                    + int_tilted[fi_a + fw - fh + fi_b + fi_c]) * feature[4];
                                    }
                                } else {
                                    for(k=0; k < fn; ++k) {
                                        feature = features[k];
                                        fi_a = ~~(x + feature[0] * scale) + ~~(y + feature[1] * scale) * w1;
                                        fw = ~~(feature[2] * scale);
                                        fh = ~~(feature[3] * scale);
                                        fi_c = fh * w1;

                                        tree_sum += (int_sum[fi_a] 
                                                    - int_sum[fi_a+fw]
                                                    - int_sum[fi_a+fi_c]
                                                    + int_sum[fi_a+fi_c+fw]) * feature[4];
                                    }
                                }
                                stage_sum += (tree_sum * inv_area < tree.threshold * std) ? tree.left_val : tree.right_val;
                            }
                            if (stage_sum < stage_thresh) {
                                found = false;
                                break;
                            }
                        }
                        
                        if(found) {
                            rects.push({"x" : x,
                                        "y" : y,
                                        "width" : win_w,
                                        "height" : win_h,
                                        "neighbor" : 1,
                                        "confidence" : stage_sum});
                            x += step_x, ii_a += step_x;
                        }
                    }
                }
                return rects;
            },

            detect_multi_scale: function(int_sum, int_sqsum, int_tilted, int_canny_sum, width, height, classifier, scale_factor, scale_min) {
                if (typeof scale_factor === "undefined") { scale_factor = 1.2; }
                if (typeof scale_min === "undefined") { scale_min = 1.0; }
                var win_w = classifier.size[0];
                var win_h = classifier.size[1];
                var rects = [];
                while (scale_min * win_w < width && scale_min * win_h < height) {
                    rects = rects.concat(this.detect_single_scale(int_sum, int_sqsum, int_tilted, int_canny_sum, width, height, scale_min, classifier));
                    scale_min *= scale_factor;
                }
                return rects;
            },

            // OpenCV method to group detected rectangles
            group_rectangles: function(rects, min_neighbors) {
                if (typeof min_neighbors === "undefined") { min_neighbors = 1; }
                var i, j, n = rects.length;
                var node = [];
                for (i = 0; i < n; ++i) {
                    node[i] = {"parent" : -1,
                               "element" : rects[i],
                               "rank" : 0};
                }
                for (i = 0; i < n; ++i) {
                    if (!node[i].element)
                        continue;
                    var root = i;
                    while (node[root].parent != -1)
                        root = node[root].parent;
                    for (j = 0; j < n; ++j) {
                        if( i != j && node[j].element && _group_func(node[i].element, node[j].element)) {
                            var root2 = j;

                            while (node[root2].parent != -1)
                                root2 = node[root2].parent;

                            if(root2 != root) {
                                if(node[root].rank > node[root2].rank)
                                    node[root2].parent = root;
                                else {
                                    node[root].parent = root2;
                                    if (node[root].rank == node[root2].rank)
                                    node[root2].rank++;
                                    root = root2;
                                }

                                /* compress path from node2 to the root: */
                                var temp, node2 = j;
                                while (node[node2].parent != -1) {
                                    temp = node2;
                                    node2 = node[node2].parent;
                                    node[temp].parent = root;
                                }

                                /* compress path from node to the root: */
                                node2 = i;
                                while (node[node2].parent != -1) {
                                    temp = node2;
                                    node2 = node[node2].parent;
                                    node[temp].parent = root;
                                }
                            }
                        }
                    }
                }
                var idx_seq = [];
                var class_idx = 0;
                for(i = 0; i < n; i++) {
                    j = -1;
                    var node1 = i;
                    if(node[node1].element) {
                        while (node[node1].parent != -1)
                            node1 = node[node1].parent;
                        if(node[node1].rank >= 0)
                            node[node1].rank = ~class_idx++;
                        j = ~node[node1].rank;
                    }
                    idx_seq[i] = j;
                }
                
                var comps = [];
                for (i = 0; i < class_idx+1; ++i) {
                    comps[i] = {"neighbors" : 0,
                                "x" : 0,
                                "y" : 0,
                                "width" : 0,
                                "height" : 0,
                                "confidence" : 0};
                }

                // count number of neighbors
                for(i = 0; i < n; ++i) {
                    var r1 = rects[i];
                    var idx = idx_seq[i];

                    if (comps[idx].neighbors == 0)
                        comps[idx].confidence = r1.confidence;

                    ++comps[idx].neighbors;

                    comps[idx].x += r1.x;
                    comps[idx].y += r1.y;
                    comps[idx].width += r1.width;
                    comps[idx].height += r1.height;
                    comps[idx].confidence = Math.max(comps[idx].confidence, r1.confidence);
                }

                var seq2 = [];
                // calculate average bounding box
                for(i = 0; i < class_idx; ++i) {
                    n = comps[i].neighbors;
                    if (n >= min_neighbors)
                        seq2.push({"x" : (comps[i].x * 2 + n) / (2 * n),
                                   "y" : (comps[i].y * 2 + n) / (2 * n),
                                   "width" : (comps[i].width * 2 + n) / (2 * n),
                                   "height" : (comps[i].height * 2 + n) / (2 * n),
                                   "neighbors" : comps[i].neighbors,
                                   "confidence" : comps[i].confidence});
                }

                var result_seq = [];
                n = seq2.length;
                // filter out small face rectangles inside large face rectangles
                for(i = 0; i < n; ++i) {
                    var r1 = seq2[i];
                    var flag = true;
                    for(j = 0; j < n; ++j) {
                        var r2 = seq2[j];
                        var distance = (r2.width * 0.25 + 0.5)|0;

                        if(i != j &&
                           r1.x >= r2.x - distance &&
                           r1.y >= r2.y - distance &&
                           r1.x + r1.width <= r2.x + r2.width + distance &&
                           r1.y + r1.height <= r2.y + r2.height + distance &&
                           (r2.neighbors > Math.max(3, r1.neighbors) || r1.neighbors < 3)) {
                            flag = false;
                            break;
                        }
                    }

                    if(flag)
                        result_seq.push(r1);
                }
                return result_seq;
            }
        };

    })();

    global.haar = haar;

})(jsfeat);
/**
 * BBF: Brightness Binary Feature
 *
 * @author Eugene Zatepyakin / http://inspirit.ru/
 *
 * this code is a rewrite from https://github.com/liuliu/ccv implementation
 * @author Liu Liu / http://liuliu.me/
 *
 * The original paper refers to: YEF∗ Real-Time Object Detection, Yotam Abramson and Bruno Steux
 */

(function(global) {
    "use strict";
    //
    var bbf = (function() {

        var _group_func = function(r1, r2) {
            var distance = (r1.width * 0.25 + 0.5)|0;

            return r2.x <= r1.x + distance &&
                   r2.x >= r1.x - distance &&
                   r2.y <= r1.y + distance &&
                   r2.y >= r1.y - distance &&
                   r2.width <= (r1.width * 1.5 + 0.5)|0 &&
                   (r2.width * 1.5 + 0.5)|0 >= r1.width;
        };

        var img_pyr = new jsfeat.pyramid_t(1);

        return {

            interval: 4,
            scale: 1.1486,
            next: 5,
            scale_to: 1,

            // make features local copy
            // to avoid array allocation with each scale
            // this is strange but array works faster than Int32 version???
            prepare_cascade: function(cascade) {
                var sn = cascade.stage_classifier.length;
                for (var j = 0; j < sn; j++) {
                    var orig_feature = cascade.stage_classifier[j].feature;
                    var f_cnt = cascade.stage_classifier[j].count;
                    var feature = cascade.stage_classifier[j]._feature = new Array(f_cnt);
                    for (var k = 0; k < f_cnt; k++) {
                        feature[k] = {"size" : orig_feature[k].size,
                                      "px" : new Array(orig_feature[k].size),
                                      "pz" : new Array(orig_feature[k].size),
                                      "nx" : new Array(orig_feature[k].size),
                                      "nz" : new Array(orig_feature[k].size)};
                    }
                }
            },

            build_pyramid: function(src, min_width, min_height, interval) {
                if (typeof interval === "undefined") { interval = 4; }

                var sw=src.cols,sh=src.rows;
                var i=0,nw=0,nh=0;
                var new_pyr=false;
                var src0=src,src1=src;
                var data_type = jsfeat.U8_t | jsfeat.C1_t;

                this.interval = interval;
                this.scale = Math.pow(2, 1 / (this.interval + 1));
                this.next = (this.interval + 1)|0;
                this.scale_to = (Math.log(Math.min(sw / min_width, sh / min_height)) / Math.log(this.scale))|0;

                var pyr_l = ((this.scale_to + this.next * 2) * 4) | 0;
                if(img_pyr.levels != pyr_l) {
                    img_pyr.levels = pyr_l;
                    img_pyr.data = new Array(pyr_l);
                    new_pyr = true;
                    img_pyr.data[0] = src; // first is src
                }

                for (i = 1; i <= this.interval; ++i) {
                    nw = (sw / Math.pow(this.scale, i))|0;
                    nh = (sh / Math.pow(this.scale, i))|0;
                    src0 = img_pyr.data[i<<2];
                    if(new_pyr || nw != src0.cols || nh != src0.rows) {
                        img_pyr.data[i<<2] = new jsfeat.matrix_t(nw, nh, data_type);
                        src0 = img_pyr.data[i<<2];
                    }
                    jsfeat.imgproc.resample(src, src0, nw, nh);
                }
                for (i = this.next; i < this.scale_to + this.next * 2; ++i) {
                    src1 = img_pyr.data[(i << 2) - (this.next << 2)];
                    src0 = img_pyr.data[i<<2];
                    nw = src1.cols >> 1;
                    nh = src1.rows >> 1;
                    if(new_pyr || nw != src0.cols || nh != src0.rows) {
                        img_pyr.data[i<<2] = new jsfeat.matrix_t(nw, nh, data_type);
                        src0 = img_pyr.data[i<<2];
                    }
                    jsfeat.imgproc.pyrdown(src1, src0);
                }
                for (i = this.next * 2; i < this.scale_to + this.next * 2; ++i) {
                    src1 = img_pyr.data[(i << 2) - (this.next << 2)];
                    nw = src1.cols >> 1;
                    nh = src1.rows >> 1;
                    src0 = img_pyr.data[(i<<2)+1];
                    if(new_pyr || nw != src0.cols || nh != src0.rows) {
                        img_pyr.data[(i<<2)+1] = new jsfeat.matrix_t(nw, nh, data_type);
                        src0 = img_pyr.data[(i<<2)+1];
                    }
                    jsfeat.imgproc.pyrdown(src1, src0, 1, 0);
                    //
                    src0 = img_pyr.data[(i<<2)+2];
                    if(new_pyr || nw != src0.cols || nh != src0.rows) {
                        img_pyr.data[(i<<2)+2] = new jsfeat.matrix_t(nw, nh, data_type);
                        src0 = img_pyr.data[(i<<2)+2];
                    }
                    jsfeat.imgproc.pyrdown(src1, src0, 0, 1);
                    //
                    src0 = img_pyr.data[(i<<2)+3];
                    if(new_pyr || nw != src0.cols || nh != src0.rows) {
                        img_pyr.data[(i<<2)+3] = new jsfeat.matrix_t(nw, nh, data_type);
                        src0 = img_pyr.data[(i<<2)+3];
                    }
                    jsfeat.imgproc.pyrdown(src1, src0, 1, 1);
                }
                return img_pyr;
            },

            detect: function(pyramid, cascade) {
                var interval = this.interval;
                var scale = this.scale;
                var next = this.next;
                var scale_upto = this.scale_to;
                var i=0,j=0,k=0,n=0,x=0,y=0,q=0,sn=0,f_cnt=0,q_cnt=0,p=0,pmin=0,nmax=0,f=0,i4=0,qw=0,qh=0;
                var sum=0.0, alpha, feature, orig_feature, feature_k, feature_o, flag = true, shortcut=true;
                var scale_x = 1.0, scale_y = 1.0;
                var dx = [0, 1, 0, 1];
                var dy = [0, 0, 1, 1];
                var seq = [];
                var pyr=pyramid.data, bpp = 1, bpp2 = 2, bpp4 = 4;

                var u8 = [], u8o = [0,0,0];
                var step = [0,0,0];
                var paddings = [0,0,0];

                for (i = 0; i < scale_upto; i++) {
                    i4 = (i<<2);
                    qw = pyr[i4 + (next << 3)].cols - (cascade.width >> 2);
                    qh = pyr[i4 + (next << 3)].rows - (cascade.height >> 2);
                    step[0] = pyr[i4].cols * bpp;
                    step[1] = pyr[i4 + (next << 2)].cols * bpp;
                    step[2] = pyr[i4 + (next << 3)].cols * bpp;
                    paddings[0] = (pyr[i4].cols * bpp4) - (qw * bpp4);
                    paddings[1] = (pyr[i4 + (next << 2)].cols * bpp2) - (qw * bpp2);
                    paddings[2] = (pyr[i4 + (next << 3)].cols * bpp) - (qw * bpp);
                    sn = cascade.stage_classifier.length;
                    for (j = 0; j < sn; j++) {
                        orig_feature = cascade.stage_classifier[j].feature;
                        feature = cascade.stage_classifier[j]._feature;
                        f_cnt = cascade.stage_classifier[j].count;
                        for (k = 0; k < f_cnt; k++) {
                            feature_k = feature[k];
                            feature_o = orig_feature[k];
                            q_cnt = feature_o.size|0;
                            for (q = 0; q < q_cnt; q++) {
                                feature_k.px[q] = (feature_o.px[q] * bpp) + feature_o.py[q] * step[feature_o.pz[q]];
                                feature_k.pz[q] = feature_o.pz[q];
                                feature_k.nx[q] = (feature_o.nx[q] * bpp) + feature_o.ny[q] * step[feature_o.nz[q]];
                                feature_k.nz[q] = feature_o.nz[q];
                            }
                        }
                    }
                    u8[0] = pyr[i4].data; u8[1] = pyr[i4 + (next<<2)].data;
                    for (q = 0; q < 4; q++) {
                        u8[2] = pyr[i4 + (next<<3) + q].data;
                        u8o[0] = (dx[q]*bpp2) + dy[q] * (pyr[i4].cols*bpp2); 
                        u8o[1] = (dx[q]*bpp) + dy[q] * (pyr[i4 + (next<<2)].cols*bpp); 
                        u8o[2] = 0;
                        for (y = 0; y < qh; y++) {
                            for (x = 0; x < qw; x++) {
                                sum = 0;
                                flag = true;
                                sn = cascade.stage_classifier.length;
                                for (j = 0; j < sn; j++) {
                                    sum = 0;
                                    alpha = cascade.stage_classifier[j].alpha;
                                    feature = cascade.stage_classifier[j]._feature;
                                    f_cnt = cascade.stage_classifier[j].count;
                                    for (k = 0; k < f_cnt; k++) {
                                        feature_k = feature[k];
                                        pmin = u8[feature_k.pz[0]][u8o[feature_k.pz[0]] + feature_k.px[0]];
                                        nmax = u8[feature_k.nz[0]][u8o[feature_k.nz[0]] + feature_k.nx[0]];
                                        if (pmin <= nmax) {
                                            sum += alpha[k << 1];
                                        } else {
                                            shortcut = true;
                                            q_cnt = feature_k.size;
                                            for (f = 1; f < q_cnt; f++) {
                                                if (feature_k.pz[f] >= 0) {
                                                    p = u8[feature_k.pz[f]][u8o[feature_k.pz[f]] + feature_k.px[f]];
                                                    if (p < pmin) {
                                                        if (p <= nmax) {
                                                            shortcut = false;
                                                            break;
                                                        }
                                                        pmin = p;
                                                    }
                                                }
                                                if (feature_k.nz[f] >= 0) {
                                                    n = u8[feature_k.nz[f]][u8o[feature_k.nz[f]] + feature_k.nx[f]];
                                                    if (n > nmax) {
                                                        if (pmin <= n) {
                                                            shortcut = false;
                                                            break;
                                                        }
                                                        nmax = n;
                                                    }
                                                }
                                            }
                                            sum += (shortcut) ? alpha[(k << 1) + 1] : alpha[k << 1];
                                        }
                                    }
                                    if (sum < cascade.stage_classifier[j].threshold) {
                                        flag = false;
                                        break;
                                    }
                                }
                                if (flag) {
                                    seq.push({"x" : (x * 4 + dx[q] * 2) * scale_x,
                                              "y" : (y * 4 + dy[q] * 2) * scale_y,
                                              "width" : cascade.width * scale_x,
                                              "height" : cascade.height * scale_y,
                                              "neighbor" : 1,
                                              "confidence" : sum});
                                    ++x;
                                    u8o[0] += bpp4;
                                    u8o[1] += bpp2;
                                    u8o[2] += bpp;
                                }
                                u8o[0] += bpp4;
                                u8o[1] += bpp2;
                                u8o[2] += bpp;
                            }
                            u8o[0] += paddings[0];
                            u8o[1] += paddings[1];
                            u8o[2] += paddings[2];
                        }
                    }
                    scale_x *= scale;
                    scale_y *= scale;
                }

                return seq;
            },

            // OpenCV method to group detected rectangles
            group_rectangles: function(rects, min_neighbors) {
                if (typeof min_neighbors === "undefined") { min_neighbors = 1; }
                var i, j, n = rects.length;
                var node = [];
                for (i = 0; i < n; ++i) {
                    node[i] = {"parent" : -1,
                               "element" : rects[i],
                               "rank" : 0};
                }
                for (i = 0; i < n; ++i) {
                    if (!node[i].element)
                        continue;
                    var root = i;
                    while (node[root].parent != -1)
                        root = node[root].parent;
                    for (j = 0; j < n; ++j) {
                        if( i != j && node[j].element && _group_func(node[i].element, node[j].element)) {
                            var root2 = j;

                            while (node[root2].parent != -1)
                                root2 = node[root2].parent;

                            if(root2 != root) {
                                if(node[root].rank > node[root2].rank)
                                    node[root2].parent = root;
                                else {
                                    node[root].parent = root2;
                                    if (node[root].rank == node[root2].rank)
                                    node[root2].rank++;
                                    root = root2;
                                }

                                /* compress path from node2 to the root: */
                                var temp, node2 = j;
                                while (node[node2].parent != -1) {
                                    temp = node2;
                                    node2 = node[node2].parent;
                                    node[temp].parent = root;
                                }

                                /* compress path from node to the root: */
                                node2 = i;
                                while (node[node2].parent != -1) {
                                    temp = node2;
                                    node2 = node[node2].parent;
                                    node[temp].parent = root;
                                }
                            }
                        }
                    }
                }
                var idx_seq = [];
                var class_idx = 0;
                for(i = 0; i < n; i++) {
                    j = -1;
                    var node1 = i;
                    if(node[node1].element) {
                        while (node[node1].parent != -1)
                            node1 = node[node1].parent;
                        if(node[node1].rank >= 0)
                            node[node1].rank = ~class_idx++;
                        j = ~node[node1].rank;
                    }
                    idx_seq[i] = j;
                }
                
                var comps = [];
                for (i = 0; i < class_idx+1; ++i) {
                    comps[i] = {"neighbors" : 0,
                                "x" : 0,
                                "y" : 0,
                                "width" : 0,
                                "height" : 0,
                                "confidence" : 0};
                }

                // count number of neighbors
                for(i = 0; i < n; ++i) {
                    var r1 = rects[i];
                    var idx = idx_seq[i];

                    if (comps[idx].neighbors == 0)
                        comps[idx].confidence = r1.confidence;

                    ++comps[idx].neighbors;

                    comps[idx].x += r1.x;
                    comps[idx].y += r1.y;
                    comps[idx].width += r1.width;
                    comps[idx].height += r1.height;
                    comps[idx].confidence = Math.max(comps[idx].confidence, r1.confidence);
                }

                var seq2 = [];
                // calculate average bounding box
                for(i = 0; i < class_idx; ++i) {
                    n = comps[i].neighbors;
                    if (n >= min_neighbors)
                        seq2.push({"x" : (comps[i].x * 2 + n) / (2 * n),
                                   "y" : (comps[i].y * 2 + n) / (2 * n),
                                   "width" : (comps[i].width * 2 + n) / (2 * n),
                                   "height" : (comps[i].height * 2 + n) / (2 * n),
                                   "neighbors" : comps[i].neighbors,
                                   "confidence" : comps[i].confidence});
                }

                var result_seq = [];
                n = seq2.length;
                // filter out small face rectangles inside large face rectangles
                for(i = 0; i < n; ++i) {
                    var r1 = seq2[i];
                    var flag = true;
                    for(j = 0; j < n; ++j) {
                        var r2 = seq2[j];
                        var distance = (r2.width * 0.25 + 0.5)|0;

                        if(i != j &&
                           r1.x >= r2.x - distance &&
                           r1.y >= r2.y - distance &&
                           r1.x + r1.width <= r2.x + r2.width + distance &&
                           r1.y + r1.height <= r2.y + r2.height + distance &&
                           (r2.neighbors > Math.max(3, r1.neighbors) || r1.neighbors < 3)) {
                            flag = false;
                            break;
                        }
                    }

                    if(flag)
                        result_seq.push(r1);
                }
                return result_seq;
            }

        };

    })();

    global.bbf = bbf;

})(jsfeat);
/**
 * @author Eugene Zatepyakin / http://inspirit.ru/
 */

(function(lib) {
    "use strict";

    {
        // in commonjs, or when AMD wrapping has been applied, define its namespaces as exports
        module.exports = lib;
    }
})(jsfeat);
});

var findFaceWorker = function(e) {
	var window = self;

	var jsfeat=jsfeat||{REVISION:"ALPHA"};(function(r){var o=1.192092896e-7;var l=1e-37;var m=256,i=512,h=1024,x=2048,w=4096;var A=1,n=2,b=3,p=4;var z=new Int32Array([-1,1,4,-1,4,-1,-1,-1,8,-1,-1,-1,-1,-1,-1,-1,8]);var y=(function(){return function(B){return(B&65280)}})();var k=(function(){return function(B){return(B&255)}})();var c=(function(){return function(B){return z[(B&65280)>>8]}})();var a=0;var f=1;var e=2;var u=3;var d=1;var s=1;var g=2;var v=(function(){function B(D,C){this.size=((D+7)|0)&-8;if(typeof C==="undefined"){this.buffer=new ArrayBuffer(this.size);}else{this.buffer=C;this.size=C.length;}this.u8=new Uint8Array(this.buffer);this.i32=new Int32Array(this.buffer);this.f32=new Float32Array(this.buffer);this.f64=new Float64Array(this.buffer);}return B})();var q=(function(){function B(F,D,E,C){this.type=y(E)|0;this.channel=k(E)|0;this.cols=F|0;this.rows=D|0;if(typeof C==="undefined"){this.allocate();}else{this.buffer=C;this.data=this.type&m?this.buffer.u8:(this.type&i?this.buffer.i32:(this.type&h?this.buffer.f32:this.buffer.f64));}}B.prototype.allocate=function(){delete this.data;delete this.buffer;this.buffer=new v((this.cols*c(this.type)*this.channel)*this.rows);this.data=this.type&m?this.buffer.u8:(this.type&i?this.buffer.i32:(this.type&h?this.buffer.f32:this.buffer.f64));};B.prototype.copy_to=function(D){var C=D.data,G=this.data;var E=0,F=(this.cols*this.rows*this.channel)|0;for(;E<F-4;E+=4){C[E]=G[E];C[E+1]=G[E+1];C[E+2]=G[E+2];C[E+3]=G[E+3];}for(;E<F;++E){C[E]=G[E];}};B.prototype.resize=function(F,D,C){if(typeof C==="undefined"){C=this.channel;}var E=(F*c(this.type)*C)*D;if(E>this.buffer.size){this.cols=F;this.rows=D;this.channel=C;this.allocate();}else{this.cols=F;this.rows=D;this.channel=C;}};return B})();var t=(function(){function B(C){this.levels=C|0;this.data=new Array(C);this.pyrdown=jsfeat.imgproc.pyrdown;}B.prototype.allocate=function(C,E,F){var D=this.levels;while(--D>=0){this.data[D]=new q(C>>D,E>>D,F);}};B.prototype.build=function(F,E){if(typeof E==="undefined"){E=true;}var H=2,D=F,C=this.data[0];if(!E){var G=F.cols*F.rows;while(--G>=0){C.data[G]=F.data[G];}}C=this.data[1];this.pyrdown(D,C);for(;H<this.levels;++H){D=C;C=this.data[H];this.pyrdown(D,C);}};return B})();var j=(function(){function B(C,G,E,F,D){if(typeof C==="undefined"){C=0;}if(typeof G==="undefined"){G=0;}if(typeof E==="undefined"){E=0;}if(typeof F==="undefined"){F=0;}if(typeof D==="undefined"){D=-1;}this.x=C;this.y=G;this.score=E;this.level=F;this.angle=D;}return B})();r.U8_t=m;r.S32_t=i;r.F32_t=h;r.S64_t=x;r.F64_t=w;r.C1_t=A;r.C2_t=n;r.C3_t=b;r.C4_t=p;r.U8C1_t=m|A;r.U8C3_t=m|b;r.U8C4_t=m|p;r.F32C1_t=h|A;r.F32C2_t=h|n;r.S32C1_t=i|A;r.S32C2_t=i|n;r.EPSILON=o;r.FLT_MIN=l;r.COLOR_RGBA2GRAY=a;r.COLOR_RGB2GRAY=f;r.COLOR_BGRA2GRAY=e;r.COLOR_BGR2GRAY=u;r.BOX_BLUR_NOSCALE=d;r.SVD_U_T=s;r.SVD_V_T=g;r.get_data_type=y;r.get_channel=k;r.get_data_type_size=c;r.data_t=v;r.matrix_t=q;r.pyramid_t=t;r.keypoint_t=j;})(jsfeat);(function(b){var a=(function(){var f=(function(){function g(h){this.next=null;this.data=new jsfeat.data_t(h);this.size=this.data.size;this.buffer=this.data.buffer;this.u8=this.data.u8;this.i32=this.data.i32;this.f32=this.data.f32;this.f64=this.data.f64;}g.prototype.resize=function(h){delete this.data;this.data=new jsfeat.data_t(h);this.size=this.data.size;this.buffer=this.data.buffer;this.u8=this.data.u8;this.i32=this.data.i32;this.f32=this.data.f32;this.f64=this.data.f64;};return g})();var e,c;var d=0;return{allocate:function(g,k){e=c=new f(k);for(var h=0;h<g;++h){var j=new f(k);c=c.next=j;d++;}},get_buffer:function(g){var h=e;e=e.next;d--;if(g>h.size){h.resize(g);}return h},put_buffer:function(g){c=c.next=g;d++;}}})();b.cache=a;a.allocate(30,640*4);})(jsfeat);(function(b){var a=(function(){var c=new Int32Array(48*2);return{get_gaussian_kernel:function(p,m,e,l){var f=0,j=0,o=0,n=0,d=0;var g=0;var h=jsfeat.cache.get_buffer(p<<2);var k=h.f32;if((p&1)==1&&p<=7&&m<=0){switch(p>>1){case 0:k[0]=1;g=1;break;case 1:k[0]=0.25,k[1]=0.5,k[2]=0.25;g=0.25+0.5+0.25;break;case 2:k[0]=0.0625,k[1]=0.25,k[2]=0.375,k[3]=0.25,k[4]=0.0625;g=0.0625+0.25+0.375+0.25+0.0625;break;case 3:k[0]=0.03125,k[1]=0.109375,k[2]=0.21875,k[3]=0.28125,k[4]=0.21875,k[5]=0.109375,k[6]=0.03125;g=0.03125+0.109375+0.21875+0.28125+0.21875+0.109375+0.03125;break}}else{n=m>0?m:((p-1)*0.5-1)*0.3+0.8;d=-0.5/(n*n);for(;f<p;++f){j=f-(p-1)*0.5;o=Math.exp(d*j*j);k[f]=o;g+=o;}}if(l&jsfeat.U8_t){g=256/g;for(f=0;f<p;++f){e[f]=(k[f]*g+0.5)|0;}}else{g=1/g;for(f=0;f<p;++f){e[f]=k[f]*g;}}jsfeat.cache.put_buffer(h);},perspective_4point_transform:function(x,B,r,w,g,A,q,v,f,z,p,u,e,y,o,t,d){var Y=B;var X=z;var W=q;var V=Y*X*W;var U=o;var T=Y*U;var S=X*T;var R=p;var n=Y*R;var m=A;var k=r;var j=y;var i=k*j;var h=i*m;var ax=j*m*R;var aw=j*W;var aq=j*R;var ao=X*W;var am=U*X;var aj=U*m;var ag=R*m;var Q=1/(aw-aq-ao+am-aj+ag);var O=Y*j;var N=k*m;var M=W*Y;var L=U*M;var K=k*X;var I=i*R;var G=k*R*m;var D=W*U*X;var C=U*k;var av=-(S-V+n*m-m*T-i*X+h-ax+aw*X)*Q;var au=(V-S-O*W+O*R+h-X*N+aj*X-ax)*Q;var ar=Y;var ap=(-R*T+L+K*W-i*W+I-G+aj*R-D)*Q;var an=(-L+M*R-C*X+I-G+C*m+D-aw*R)*Q;var al=k;var ai=(-n+M+K-N+aq-aw-am+aj)*Q;var af=(-T+n+i-K+aj-ag-aw+ao)*Q;Y=w;X=u;W=f;V=Y*X*W;U=d;T=Y*U;S=X*T;R=e;n=Y*R;m=v;k=g;j=t;i=k*j;h=i*m;ax=j*m*R;aw=j*W;aq=j*R;ao=X*W;am=U*X;aj=U*m;ag=R*m;Q=1/(aw-aq-ao+am-aj+ag);O=Y*j;N=k*m;M=W*Y;L=U*M;K=k*X;I=i*R;G=k*R*m;D=W*U*X;C=U*k;var ak=-(S-V+n*m-m*T-i*X+h-ax+aw*X)*Q;var ah=(V-S-O*W+O*R+h-X*N+aj*X-ax)*Q;var ae=Y;var ad=(-R*T+L+K*W-i*W+I-G+aj*R-D)*Q;var ac=(-L+M*R-C*X+I-G+C*m+D-aw*R)*Q;var ab=k;var aa=(-n+M+K-N+aq-aw-am+aj)*Q;var Z=(-T+n+i-K+aj-ag-aw+ao)*Q;X=an-af*al;W=av*an;V=av*al;T=ap*au;S=ar*ap;n=au*ai;var l=ar*ai;j=1/(W-V*af-T+S*af+n*al-l*an);h=-ap+al*ai;var at=-ap*af+an*ai;ag=-au+ar*af;var P=av-l;N=av*af-n;M=-au*al+ar*an;var J=V-S;var H=W-T;G=X*j;var F=ag*j;var E=M*j;var s=x.data;s[0]=ak*G+ah*(h*j)-ae*(at*j);s[1]=ak*F+ah*(P*j)-ae*(N*j);s[2]=-ak*E-ah*(J*j)+ae*(H*j);s[3]=ad*G+ac*(h*j)-ab*(at*j);s[4]=ad*F+ac*(P*j)-ab*(N*j);s[5]=-ad*E-ac*(J*j)+ab*(H*j);s[6]=aa*G+Z*(h*j)-at*j;s[7]=aa*F+Z*(P*j)-N*j;s[8]=-aa*E-Z*(J*j)+H*j;},qsort:function(o,J,s,u){var D=7;var v,r,q,p;var C=0,j=0,G=0,B=0,z=0,A=0,e=0,y=0,E=0;var x=0,w=0,h=0,g=0,l=0,I=0,H=0,F=0,f=0;var k=c;if((s-J+1)<=1){return}k[0]=J;k[1]=s;while(C>=0){j=k[C<<1];G=k[(C<<1)+1];C--;for(;;){z=(G-j)+1;if(z<=D){for(e=j+1;e<=G;e++){for(y=e;y>j&&u(o[y],o[y-1]);y--){v=o[y];o[y]=o[y-1];o[y-1]=v;}}break}else{f=0;x=j;h=G;l=j+(z>>1);if(z>40){E=z>>3;I=j,H=j+E,F=j+(E<<1);r=o[I],q=o[H],p=o[F];j=u(r,q)?(u(q,p)?H:(u(r,p)?F:I)):(u(p,q)?H:(u(r,p)?I:F));I=l-E,H=l,F=l+E;r=o[I],q=o[H],p=o[F];l=u(r,q)?(u(q,p)?H:(u(r,p)?F:I)):(u(p,q)?H:(u(r,p)?I:F));I=G-(E<<1),H=G-E,F=G;r=o[I],q=o[H],p=o[F];G=u(r,q)?(u(q,p)?H:(u(r,p)?F:I)):(u(p,q)?H:(u(r,p)?I:F));}I=j,H=l,F=G;r=o[I],q=o[H],p=o[F];l=u(r,q)?(u(q,p)?H:(u(r,p)?F:I)):(u(p,q)?H:(u(r,p)?I:F));if(l!=x){v=o[l];o[l]=o[x];o[x]=v;l=x;}j=w=x+1;G=g=h;r=o[l];for(;;){while(j<=G&&!u(r,o[j])){if(!u(o[j],r)){if(j>w){v=o[w];o[w]=o[j];o[j]=v;}f=1;w++;}j++;}while(j<=G&&!u(o[G],r)){if(!u(r,o[G])){if(G<g){v=o[g];o[g]=o[G];o[G]=v;}f=1;g--;}G--;}if(j>G){break}v=o[j];o[j]=o[G];o[G]=v;f=1;j++;G--;}if(f==0){j=x,G=h;for(e=j+1;e<=G;e++){for(y=e;y>j&&u(o[y],o[y-1]);y--){v=o[y];o[y]=o[y-1];o[y-1]=v;}}break}z=Math.min((w-x),(j-w));A=(j-z)|0;for(B=0;B<z;++B,++A){v=o[x+B];o[x+B]=o[A];o[A]=v;}z=Math.min((h-g),(g-G));A=(h-z+1)|0;for(B=0;B<z;++B,++A){v=o[j+B];o[j+B]=o[A];o[A]=v;}z=(j-w);A=(g-G);if(z>1){if(A>1){if(z>A){++C;k[C<<1]=x;k[(C<<1)+1]=x+z-1;j=h-A+1,G=h;}else{++C;k[C<<1]=h-A+1;k[(C<<1)+1]=h;j=x,G=x+z-1;}}else{j=x,G=x+z-1;}}else{if(A>1){j=h-A+1,G=h;}else{break}}}}}},median:function(k,d,i){var e;var f=0,j=0,g=0,h=(d+i)>>1;for(;;){if(i<=d){return k[h]}if(i==(d+1)){if(k[d]>k[i]){e=k[d];k[d]=k[i];k[i]=e;}return k[h]}f=((d+i)>>1);if(k[f]>k[i]){e=k[f];k[f]=k[i];k[i]=e;}if(k[d]>k[i]){e=k[d];k[d]=k[i];k[i]=e;}if(k[f]>k[d]){e=k[f];k[f]=k[d];k[d]=e;}j=(d+1);e=k[f];k[f]=k[j];k[j]=e;g=i;for(;;){do{++j;}while(k[d]>k[j]);do{--g;}while(k[g]>k[d]);if(g<j){break}e=k[j];k[j]=k[g];k[g]=e;}e=k[d];k[d]=k[g];k[g]=e;if(g<=h){d=j;}else{if(g>=h){i=(g-1);}}}return 0}}})();b.math=a;})(jsfeat);(function(b){var a=(function(){return{identity:function(j,g){if(typeof g==="undefined"){g=1;}var i=j.data;var f=j.rows,h=j.cols,e=(h+1)|0;var c=f*h;var d=c;while(--c>=0){i[c]=0;}c=d;d=0;while(d<c){i[d]=g;d=d+e;}},transpose:function(f,d){var l=0,h=0,k=d.rows,c=d.cols;var n=0,e=0,m=0;var o=d.data,g=f.data;for(;l<k;e+=1,n+=c,l++){m=e;for(h=0;h<c;m+=k,h++){g[m]=o[n+h];}}},multiply:function(l,n,m){var u=0,s=0,o=0;var r=0,t=0,q=0,w=0,g=0;var f=n.cols,e=n.rows,p=m.cols;var v=n.data,d=m.data,h=l.data;var c=0;for(;u<e;r+=f,u++){for(w=0,s=0;s<p;g++,w++,s++){q=w;t=r;c=0;for(o=0;o<f;t++,q+=p,o++){c+=v[t]*d[q];}h[g]=c;}}},multiply_ABt:function(c,g,d){var p=0,n=0,m=0;var r=0,l=0,f=0,u=0;var e=g.cols,o=g.rows,q=d.rows;var v=g.data,t=d.data,h=c.data;var s=0;for(;p<o;r+=e,p++){for(f=0,n=0;n<q;u++,n++){l=r;s=0;for(m=0;m<e;l++,f++,m++){s+=v[l]*t[f];}h[u]=s;}}},multiply_AtB:function(l,n,m){var u=0,s=0,o=0;var r=0,t=0,q=0,w=0,g=0;var f=n.cols,e=n.rows,p=m.cols;var v=n.data,d=m.data,h=l.data;var c=0;for(;u<f;r++,u++){for(w=0,s=0;s<p;g++,w++,s++){q=w;t=r;c=0;for(o=0;o<e;t+=f,q+=p,o++){c+=v[t]*d[q];}h[g]=c;}}},multiply_AAt:function(d,h){var q=0,o=0,n=0;var c=0,r=0,m=0,g=0,e=0,u=0;var f=h.cols,p=h.rows;var t=h.data,l=d.data;var s=0;for(;q<p;c+=p+1,r=m,q++){e=c;u=c;g=r;for(o=q;o<p;e++,u+=p,o++){m=r;s=0;for(n=0;n<f;n++){s+=t[m++]*t[g++];}l[e]=s;l[u]=s;}}},multiply_AtA:function(c,g){var r=0,p=0,n=0;var s=0,m=0,f=0,o=0,d=0,l=0;var e=g.cols,q=g.rows;var u=g.data,h=c.data;var t=0;for(;r<e;o+=e,r++){s=r;l=o+r;d=l;for(p=r;p<e;d++,l+=e,p++){m=s;f=p;t=0;for(n=0;n<q;m+=e,f+=e,n++){t+=u[m]*u[f];}h[d]=t;h[l]=t;}}},identity_3x3:function(e,d){if(typeof d==="undefined"){d=1;}var c=e.data;c[0]=c[4]=c[8]=d;c[1]=c[2]=c[3]=0;c[5]=c[6]=c[7]=0;},invert_3x3:function(s,e){var o=s.data,h=e.data;var n=o[4];var m=o[8];var l=o[5];var k=o[7];var j=o[0];var i=j*n;var v=j*l;var u=o[3];var t=o[1];var r=u*t;var q=o[2];var p=u*q;var g=o[6];var f=g*t;var d=g*q;var c=1/(i*m-v*k-r*m+p*k+f*l-d*n);h[0]=(n*m-l*k)*c;h[1]=-(t*m-q*k)*c;h[2]=-(-t*l+q*n)*c;h[3]=-(u*m-l*g)*c;h[4]=(j*m-d)*c;h[5]=-(v-p)*c;h[6]=-(-u*k+n*g)*c;h[7]=-(j*k-f)*c;h[8]=(i-r)*c;},multiply_3x3:function(r,v,t){var y=r.data,z=v.data,l=t.data;var x=z[0],w=z[1],u=z[2];var s=z[3],q=z[4],p=z[5];var o=z[6],n=z[7],m=z[8];var k=l[0],j=l[1],i=l[2];var h=l[3],g=l[4],f=l[5];var e=l[6],d=l[7],c=l[8];y[0]=x*k+w*h+u*e;y[1]=x*j+w*g+u*d;y[2]=x*i+w*f+u*c;y[3]=s*k+q*h+p*e;y[4]=s*j+q*g+p*d;y[5]=s*i+q*f+p*c;y[6]=o*k+n*h+m*e;y[7]=o*j+n*g+m*d;y[8]=o*i+n*f+m*c;},mat3x3_determinant:function(d){var c=d.data;return c[0]*c[4]*c[8]-c[0]*c[5]*c[7]-c[3]*c[1]*c[8]+c[3]*c[2]*c[7]+c[6]*c[1]*c[5]-c[6]*c[2]*c[4]},determinant_3x3:function(h,g,f,e,d,c,k,j,i){return h*d*i-h*c*j-e*g*i+e*f*j+k*g*c-k*f*d}}})();b.matmath=a;})(jsfeat);(function(b){var a=(function(){var f=function(g,j,i,h){h=g[j];g[j]=g[i];g[i]=h;};var d=function(h,g){h=Math.abs(h);g=Math.abs(g);if(h>g){g/=h;return h*Math.sqrt(1+g*g)}if(g>0){h/=g;return g*Math.sqrt(1+h*h)}return 0};var c=function(H,o,q,r,h,I){var C=jsfeat.EPSILON;var N=0,M=0,L=0,J=0,K=0,D=0,R=0,G=0;var u=0,v=I*I*30;var E=0,U=0,F=0,x=0,z=0,B=0,Q=0,T=0,w=0;var P=jsfeat.cache.get_buffer(I<<2);var S=jsfeat.cache.get_buffer(I<<2);var O=P.i32;var g=S.i32;if(r){for(;N<I;N++){L=N*h;for(M=0;M<I;M++){r[L+M]=0;}r[L+N]=1;}}for(L=0;L<I;L++){q[L]=H[(o+1)*L];if(L<I-1){for(J=L+1,E=Math.abs(H[o*L+J]),N=L+2;N<I;N++){U=Math.abs(H[o*L+N]);if(E<U){E=U,J=N;}}O[L]=J;}if(L>0){for(J=0,E=Math.abs(H[L]),N=1;N<L;N++){U=Math.abs(H[o*N+L]);if(E<U){E=U,J=N;}}g[L]=J;}}if(I>1){for(;u<v;u++){for(L=0,E=Math.abs(H[O[0]]),N=1;N<I-1;N++){U=Math.abs(H[o*N+O[N]]);if(E<U){E=U,L=N;}}K=O[L];for(N=1;N<I;N++){U=Math.abs(H[o*g[N]+N]);if(E<U){E=U,L=g[N],K=N;}}F=H[o*L+K];if(Math.abs(F)<=C){break}x=(q[K]-q[L])*0.5;z=Math.abs(x)+d(F,x);B=d(F,z);Q=z/B;B=F/B;z=(F/z)*F;if(x<0){B=-B,z=-z;}H[o*L+K]=0;q[L]-=z;q[K]+=z;for(N=0;N<L;N++){R=(o*N+L);G=(o*N+K);T=H[R];w=H[G];H[R]=T*Q-w*B;H[G]=T*B+w*Q;}for(N=(L+1);N<K;N++){R=(o*L+N);G=(o*N+K);T=H[R];w=H[G];H[R]=T*Q-w*B;H[G]=T*B+w*Q;}N=K+1;R=(o*L+N);G=(o*K+N);for(;N<I;N++,R++,G++){T=H[R];w=H[G];H[R]=T*Q-w*B;H[G]=T*B+w*Q;}if(r){R=h*L;G=h*K;for(N=0;N<I;N++,R++,G++){T=r[R];w=r[G];r[R]=T*Q-w*B;r[G]=T*B+w*Q;}}for(M=0;M<2;M++){D=M==0?L:K;if(D<I-1){for(J=D+1,E=Math.abs(H[o*D+J]),N=D+2;N<I;N++){U=Math.abs(H[o*D+N]);if(E<U){E=U,J=N;}}O[D]=J;}if(D>0){for(J=0,E=Math.abs(H[D]),N=1;N<D;N++){U=Math.abs(H[o*N+D]);if(E<U){E=U,J=N;}}g[D]=J;}}}}for(L=0;L<I-1;L++){J=L;for(N=L+1;N<I;N++){if(q[J]<q[N]){J=N;}}if(L!=J){f(q,J,L,E);if(r){for(N=0;N<I;N++){f(r,h*J+N,h*L+N,E);}}}}jsfeat.cache.put_buffer(P);jsfeat.cache.put_buffer(S);};var e=function(D,l,h,M,v,T,S,E){var C=jsfeat.EPSILON*2;var q=jsfeat.FLT_MIN;var X=0,V=0,U=0,A=0,u=Math.max(T,30);var K=0,J=0,R=0,Q=0,F=0;var Y=0,O=0,N=0;var H=0,G=0,x=0,I=0,w=0,L=0,aa=0,P=0,Z=0;var z=4660;var B=0,y=0,o=0;var r=jsfeat.cache.get_buffer(S<<3);var g=r.f64;for(;X<S;X++){for(U=0,x=0;U<T;U++){N=D[X*l+U];x+=N*N;}g[X]=x;if(M){for(U=0;U<S;U++){M[X*v+U]=0;}M[X*v+X]=1;}}for(;A<u;A++){F=0;for(X=0;X<S-1;X++){for(V=X+1;V<S;V++){K=(X*l)|0,J=(V*l)|0;aa=g[X],P=0,Z=g[V];U=2;P+=D[K]*D[J];P+=D[K+1]*D[J+1];for(;U<T;U++){P+=D[K+U]*D[J+U];}if(Math.abs(P)<=C*Math.sqrt(aa*Z)){continue}P*=2;I=aa-Z,w=d(P,I);if(I<0){L=(w-I)*0.5;O=Math.sqrt(L/w);Y=(P/(w*O*2));}else{Y=Math.sqrt((w+I)/(w*2));O=(P/(w*Y*2));}aa=0,Z=0;U=2;H=Y*D[K]+O*D[J];G=-O*D[K]+Y*D[J];D[K]=H;D[J]=G;aa+=H*H;Z+=G*G;H=Y*D[K+1]+O*D[J+1];G=-O*D[K+1]+Y*D[J+1];D[K+1]=H;D[J+1]=G;aa+=H*H;Z+=G*G;for(;U<T;U++){H=Y*D[K+U]+O*D[J+U];G=-O*D[K+U]+Y*D[J+U];D[K+U]=H;D[J+U]=G;aa+=H*H;Z+=G*G;}g[X]=aa;g[V]=Z;F=1;if(M){R=(X*v)|0,Q=(V*v)|0;U=2;H=Y*M[R]+O*M[Q];G=-O*M[R]+Y*M[Q];M[R]=H;M[Q]=G;H=Y*M[R+1]+O*M[Q+1];G=-O*M[R+1]+Y*M[Q+1];M[R+1]=H;M[Q+1]=G;for(;U<S;U++){H=Y*M[R+U]+O*M[Q+U];G=-O*M[R+U]+Y*M[Q+U];M[R+U]=H;M[Q+U]=G;}}}}if(F==0){break}}for(X=0;X<S;X++){for(U=0,x=0;U<T;U++){N=D[X*l+U];x+=N*N;}g[X]=Math.sqrt(x);}for(X=0;X<S-1;X++){V=X;for(U=X+1;U<S;U++){if(g[V]<g[U]){V=U;}}if(X!=V){f(g,X,V,x);if(M){for(U=0;U<T;U++){f(D,X*l+U,V*l+U,N);}for(U=0;U<S;U++){f(M,X*v+U,V*v+U,N);}}}}for(X=0;X<S;X++){h[X]=g[X];}if(!M){jsfeat.cache.put_buffer(r);return}for(X=0;X<E;X++){x=X<S?g[X]:0;while(x<=q){y=(1/T);for(U=0;U<T;U++){z=(z*214013+2531011);B=(((z>>16)&32767)&256)!=0?y:-y;D[X*l+U]=B;}for(A=0;A<2;A++){for(V=0;V<X;V++){x=0;for(U=0;U<T;U++){x+=D[X*l+U]*D[V*l+U];}o=0;for(U=0;U<T;U++){N=(D[X*l+U]-x*D[V*l+U]);D[X*l+U]=N;o+=Math.abs(N);}o=o?1/o:0;for(U=0;U<T;U++){D[X*l+U]*=o;}}}x=0;for(U=0;U<T;U++){N=D[X*l+U];x+=N*N;}x=Math.sqrt(x);}O=(1/x);for(U=0;U<T;U++){D[X*l+U]*=O;}}jsfeat.cache.put_buffer(r);};return{lu_solve:function(l,g){var q=0,o=0,n=0,h=1,v=l.cols;var w=l.data,r=g.data;var x,m,u,y;for(q=0;q<v;q++){n=q;for(o=q+1;o<v;o++){if(Math.abs(w[o*v+q])>Math.abs(w[n*v+q])){n=o;}}if(Math.abs(w[n*v+q])<jsfeat.EPSILON){return 0}if(n!=q){for(o=q;o<v;o++){f(w,q*v+o,n*v+o,x);}f(r,q,n,x);h=-h;}u=-1/w[q*v+q];for(o=q+1;o<v;o++){m=w[o*v+q]*u;for(n=q+1;n<v;n++){w[o*v+n]+=m*w[q*v+n];}r[o]+=m*r[q];}w[q*v+q]=-u;}for(q=v-1;q>=0;q--){y=r[q];for(n=q+1;n<v;n++){y-=w[q*v+n]*r[n];}r[q]=y*w[q*v+q];}return 1},cholesky_solve:function(h,g){var l=0,v=0,r=0,s=0,n=0,p=0,o=0;var u=h.cols;var t=h.data,q=g.data;var k,m;for(l=0;l<u;l++){m=1;s=(l*u);n=s;for(v=l;v<u;v++){k=t[(n+l)];for(r=0;r<l;r++){k-=t[(r*u+l)]*t[(n+r)];}if(v==l){t[(n+l)]=k;if(k==0){return 0}m=1/k;}else{t[(s+v)]=k;t[(n+l)]=k*m;}n=(n+u);}}s=0;for(p=0;p<u;p++){k=q[p];for(o=0;o<p;o++){k-=t[(s+o)]*q[o];}q[p]=k;s=(s+u);}s=0;for(p=0;p<u;p++){q[p]/=t[(s+p)];s=(s+u);}p=(u-1);for(;p>=0;p--){k=q[p];o=(p+1);s=(o*u);for(;o<u;o++){k-=t[(s+p)]*q[o];s=(s+u);}q[p]=k;}return 1},svd_decompose:function(t,k,p,l,o){if(typeof o==="undefined"){o=0;}var r=0,z=0,x=0,g=t.rows,D=t.cols,w=g,v=D;var s=t.type|jsfeat.C1_t;if(w<v){r=1;z=w;w=v;v=z;}var q=jsfeat.cache.get_buffer((w*w)<<3);var h=jsfeat.cache.get_buffer(v<<3);var C=jsfeat.cache.get_buffer((v*v)<<3);var u=new jsfeat.matrix_t(w,w,s,q.data);var B=new jsfeat.matrix_t(1,v,s,h.data);var y=new jsfeat.matrix_t(v,v,s,C.data);if(r==0){jsfeat.matmath.transpose(u,t);}else{for(z=0;z<D*g;z++){u.data[z]=t.data[z];}for(;z<v*w;z++){u.data[z]=0;}}e(u.data,w,B.data,y.data,v,w,v,w);if(k){for(z=0;z<v;z++){k.data[z]=B.data[z];}for(;z<D;z++){k.data[z]=0;}}if(r==0){if(p&&(o&jsfeat.SVD_U_T)){z=w*w;while(--z>=0){p.data[z]=u.data[z];}}else{if(p){jsfeat.matmath.transpose(p,u);}}if(l&&(o&jsfeat.SVD_V_T)){z=v*v;while(--z>=0){l.data[z]=y.data[z];}}else{if(l){jsfeat.matmath.transpose(l,y);}}}else{if(p&&(o&jsfeat.SVD_U_T)){z=v*v;while(--z>=0){p.data[z]=y.data[z];}}else{if(p){jsfeat.matmath.transpose(p,y);}}if(l&&(o&jsfeat.SVD_V_T)){z=w*w;while(--z>=0){l.data[z]=u.data[z];}}else{if(l){jsfeat.matmath.transpose(l,u);}}}jsfeat.cache.put_buffer(q);jsfeat.cache.put_buffer(h);jsfeat.cache.put_buffer(C);},svd_solve:function(v,l,s){var E=0,C=0,z=0;var w=0,u=0;var o=v.rows,p=v.cols;var h=0,I=0,x=0;var r=v.type|jsfeat.C1_t;var F=jsfeat.cache.get_buffer((o*o)<<3);var m=jsfeat.cache.get_buffer(p<<3);var H=jsfeat.cache.get_buffer((p*p)<<3);var t=new jsfeat.matrix_t(o,o,r,F.data);var G=new jsfeat.matrix_t(1,p,r,m.data);var D=new jsfeat.matrix_t(p,p,r,H.data);var n=s.data,y=t.data,q=G.data,g=D.data;this.svd_decompose(v,G,t,D,0);x=jsfeat.EPSILON*q[0]*p;for(;E<p;E++,u+=p){I=0;for(C=0;C<p;C++){if(q[C]>x){for(z=0,h=0,w=0;z<o;z++,w+=p){h+=y[w+C]*n[z];}I+=h*g[u+C]/q[C];}}l.data[E]=I;}jsfeat.cache.put_buffer(F);jsfeat.cache.put_buffer(m);jsfeat.cache.put_buffer(H);},svd_invert:function(E,t){var C=0,z=0,y=0;var v=0,s=0,h=0;var n=t.rows,o=t.cols;var l=0,w=0;var q=t.type|jsfeat.C1_t;var D=jsfeat.cache.get_buffer((n*n)<<3);var m=jsfeat.cache.get_buffer(o<<3);var G=jsfeat.cache.get_buffer((o*o)<<3);var u=new jsfeat.matrix_t(n,n,q,D.data);var F=new jsfeat.matrix_t(1,o,q,m.data);var B=new jsfeat.matrix_t(o,o,q,G.data);var r=E.data,x=u.data,p=F.data,g=B.data;this.svd_decompose(t,F,u,B,0);w=jsfeat.EPSILON*p[0]*o;for(;C<o;C++,s+=o){for(z=0,v=0;z<n;z++,h++){for(y=0,l=0;y<o;y++,v++){if(p[y]>w){l+=g[s+y]*x[v]/p[y];}}r[h]=l;}}jsfeat.cache.put_buffer(D);jsfeat.cache.put_buffer(m);jsfeat.cache.put_buffer(G);},eigenVV:function(j,p,r){var k=j.cols,m=k*k;var g=j.type|jsfeat.C1_t;var o=jsfeat.cache.get_buffer((k*k)<<3);var h=jsfeat.cache.get_buffer(k<<3);var l=new jsfeat.matrix_t(k,k,g,o.data);var q=new jsfeat.matrix_t(1,k,g,h.data);while(--m>=0){l.data[m]=j.data[m];}c(l.data,k,q.data,p?p.data:null,k,k);if(r){while(--k>=0){r.data[k]=q.data[k];}}jsfeat.cache.put_buffer(o);jsfeat.cache.put_buffer(h);}}})();b.linalg=a;})(jsfeat);(function(a){var c=(function(){var m=function(p){return p*p};var e=function(z,A,x,w,u){var t=0;var y=0,s=0,q=0,C=0;var v=0,r=0,p=0,B=0;var E=0,D=0;for(;t<u;++t){y+=z[t].x;s+=z[t].y;v+=A[t].x;r+=A[t].y;}y/=u;s/=u;v/=u;r/=u;for(t=0;t<u;++t){E=z[t].x-y;D=z[t].y-s;q+=Math.sqrt(E*E+D*D);E=A[t].x-v;D=A[t].y-r;p+=Math.sqrt(E*E+D*D);}q/=u;p/=u;C=Math.SQRT2/q;B=Math.SQRT2/p;x[0]=x[4]=C;x[2]=-y*C;x[5]=-s*C;x[1]=x[3]=x[6]=x[7]=0;x[8]=1;w[0]=w[4]=B;w[2]=-v*B;w[5]=-r*B;w[1]=w[3]=w[6]=w[7]=0;w[8]=1;};var h=function(x,u){var q=0,p=0,r=(u-1)|0;var w=0,t=0,v=0,s=0;for(;q<r;++q){w=x[q].x-x[r].x;t=x[q].y-x[r].y;for(p=0;p<q;++p){v=x[p].x-x[r].x;s=x[p].y-x[r].y;if(Math.abs(v*t-s*w)<=jsfeat.EPSILON*(Math.abs(w)+Math.abs(t)+Math.abs(v)+Math.abs(s))){return true}}}return false};var k=new jsfeat.matrix_t(3,3,jsfeat.F32_t|jsfeat.C1_t);var i=new jsfeat.matrix_t(3,3,jsfeat.F32_t|jsfeat.C1_t);var o=new jsfeat.matrix_t(6,6,jsfeat.F32_t|jsfeat.C1_t);var n=new jsfeat.matrix_t(6,1,jsfeat.F32_t|jsfeat.C1_t);var j=(function(){function p(){}p.prototype.run=function(D,q,r,t){var G=0,F=0;var B=r.type|jsfeat.C1_t;var J=r.data,v=k.data,E=i.data;var x,w,A=0,z=0;e(D,q,v,E,t);var u=jsfeat.cache.get_buffer((2*t*6)<<3);var y=jsfeat.cache.get_buffer((2*t)<<3);var C=new jsfeat.matrix_t(6,2*t,B,u.data);var H=new jsfeat.matrix_t(1,2*t,B,y.data);var I=C.data,s=H.data;for(;G<t;++G){x=D[G];w=q[G];A=v[0]*x.x+v[1]*x.y+v[2];z=v[3]*x.x+v[4]*x.y+v[5];F=G*2*6;I[F]=A,I[F+1]=z,I[F+2]=1,I[F+3]=0,I[F+4]=0,I[F+5]=0;F+=6;I[F]=0,I[F+1]=0,I[F+2]=0,I[F+3]=A,I[F+4]=z,I[F+5]=1;s[G<<1]=E[0]*w.x+E[1]*w.y+E[2];s[(G<<1)+1]=E[3]*w.x+E[4]*w.y+E[5];}jsfeat.matmath.multiply_AtA(o,C);jsfeat.matmath.multiply_AtB(n,C,H);jsfeat.linalg.lu_solve(o,n);J[0]=n.data[0],J[1]=n.data[1],J[2]=n.data[2];J[3]=n.data[3],J[4]=n.data[4],J[5]=n.data[5];J[6]=0,J[7]=0,J[8]=1;jsfeat.matmath.invert_3x3(i,i);jsfeat.matmath.multiply_3x3(r,i,r);jsfeat.matmath.multiply_3x3(r,r,k);jsfeat.cache.put_buffer(u);jsfeat.cache.put_buffer(y);return 1};p.prototype.error=function(v,w,t,r,u){var s=0;var y,x;var q=t.data;for(;s<u;++s){y=v[s];x=w[s];r[s]=m(x.x-q[0]*y.x-q[1]*y.y-q[2])+m(x.y-q[3]*y.x-q[4]*y.y-q[5]);}};p.prototype.check_subset=function(s,r,q){return true};return p})();var g=new jsfeat.matrix_t(9,9,jsfeat.F32_t|jsfeat.C1_t);var f=new jsfeat.matrix_t(9,9,jsfeat.F32_t|jsfeat.C1_t);var l=(function(){function p(){}p.prototype.run=function(I,r,v,C){var L=0,K=0;var O=v.data,D=k.data,J=i.data;var M=g.data,N=f.data;var H=0,G=0,s=0,q=0;var u=0,t=0,B=0,A=0,z=0,w=0,F=0,E=0;for(;L<C;++L){B+=r[L].x;A+=r[L].y;F+=I[L].x;E+=I[L].y;}B/=C;A/=C;F/=C;E/=C;for(L=0;L<C;++L){u+=Math.abs(r[L].x-B);t+=Math.abs(r[L].y-A);z+=Math.abs(I[L].x-F);w+=Math.abs(I[L].y-E);}if(Math.abs(u)<jsfeat.EPSILON||Math.abs(t)<jsfeat.EPSILON||Math.abs(z)<jsfeat.EPSILON||Math.abs(w)<jsfeat.EPSILON){return 0}u=C/u;t=C/t;z=C/z;w=C/w;D[0]=z;D[1]=0;D[2]=-F*z;D[3]=0;D[4]=w;D[5]=-E*w;D[6]=0;D[7]=0;D[8]=1;J[0]=1/u;J[1]=0;J[2]=B;J[3]=0;J[4]=1/t;J[5]=A;J[6]=0;J[7]=0;J[8]=1;L=81;while(--L>=0){M[L]=0;}for(L=0;L<C;++L){H=(r[L].x-B)*u;G=(r[L].y-A)*t;s=(I[L].x-F)*z;q=(I[L].y-E)*w;M[0]+=s*s;M[1]+=s*q;M[2]+=s;M[6]+=s*-H*s;M[7]+=s*-H*q;M[8]+=s*-H;M[10]+=q*q;M[11]+=q;M[15]+=q*-H*s;M[16]+=q*-H*q;M[17]+=q*-H;M[20]+=1;M[24]+=-H*s;M[25]+=-H*q;M[26]+=-H;M[30]+=s*s;M[31]+=s*q;M[32]+=s;M[33]+=s*-G*s;M[34]+=s*-G*q;M[35]+=s*-G;M[40]+=q*q;M[41]+=q;M[42]+=q*-G*s;M[43]+=q*-G*q;M[44]+=q*-G;M[50]+=1;M[51]+=-G*s;M[52]+=-G*q;M[53]+=-G;M[60]+=-H*s*-H*s+-G*s*-G*s;M[61]+=-H*s*-H*q+-G*s*-G*q;M[62]+=-H*s*-H+-G*s*-G;M[70]+=-H*q*-H*q+-G*q*-G*q;M[71]+=-H*q*-H+-G*q*-G;M[80]+=-H*-H+-G*-G;}for(L=0;L<9;++L){for(K=0;K<L;++K){M[L*9+K]=M[K*9+L];}}jsfeat.linalg.eigenVV(g,f);O[0]=N[72],O[1]=N[73],O[2]=N[74];O[3]=N[75],O[4]=N[76],O[5]=N[77];O[6]=N[78],O[7]=N[79],O[8]=N[80];jsfeat.matmath.multiply_3x3(v,i,v);jsfeat.matmath.multiply_3x3(v,v,k);H=1/O[8];O[0]*=H;O[1]*=H;O[2]*=H;O[3]*=H;O[4]*=H;O[5]*=H;O[6]*=H;O[7]*=H;O[8]=1;return 1};p.prototype.error=function(w,x,u,r,v){var t=0;var z,y,s=0,B=0,A=0;var q=u.data;for(;t<v;++t){z=w[t];y=x[t];s=1/(q[6]*z.x+q[7]*z.y+1);B=(q[0]*z.x+q[1]*z.y+q[2])*s-y.x;A=(q[3]*z.x+q[4]*z.y+q[5])*s-y.y;r[t]=(B*B+A*A);}};p.prototype.check_subset=function(M,s,B){if(B==4){var N=0;var I=M[0],H=M[1],G=M[2],E=M[3];var A=s[0],y=s[1],w=s[2],u=s[3];var L=I.x,K=I.y,J=1;var V=H.x,U=H.y,T=1;var z=G.x,x=G.y,v=1;var t=A.x,r=A.y,q=1;var F=y.x,D=y.y,C=1;var Q=w.x,P=w.y,O=1;var S=jsfeat.matmath.determinant_3x3(L,K,J,V,U,T,z,x,v);var R=jsfeat.matmath.determinant_3x3(t,r,q,F,D,C,Q,P,O);if(S*R<0){N++;}L=H.x,K=H.y;V=G.x,U=G.y;z=E.x,x=E.y;t=y.x,r=y.y;F=w.x,D=w.y;Q=u.x,P=u.y;S=jsfeat.matmath.determinant_3x3(L,K,J,V,U,T,z,x,v);R=jsfeat.matmath.determinant_3x3(t,r,q,F,D,C,Q,P,O);if(S*R<0){N++;}L=I.x,K=I.y;V=G.x,U=G.y;z=E.x,x=E.y;t=A.x,r=A.y;F=w.x,D=w.y;Q=u.x,P=u.y;S=jsfeat.matmath.determinant_3x3(L,K,J,V,U,T,z,x,v);R=jsfeat.matmath.determinant_3x3(t,r,q,F,D,C,Q,P,O);if(S*R<0){N++;}L=I.x,K=I.y;V=H.x,U=H.y;z=E.x,x=E.y;t=A.x,r=A.y;F=y.x,D=y.y;Q=u.x,P=u.y;S=jsfeat.matmath.determinant_3x3(L,K,J,V,U,T,z,x,v);R=jsfeat.matmath.determinant_3x3(t,r,q,F,D,C,Q,P,O);if(S*R<0){N++;}if(N!=0&&N!=4){return false}}return true};return p})();return{affine2d:j,homography2d:l}})();var b=(function(){function e(h,i,f,g){if(typeof h==="undefined"){h=0;}if(typeof i==="undefined"){i=0.5;}if(typeof f==="undefined"){f=0.5;}if(typeof g==="undefined"){g=0.99;}this.size=h;this.thresh=i;this.eps=f;this.prob=g;}e.prototype.update_iters=function(g,i){var h=Math.log(1-this.prob);var f=Math.log(1-Math.pow(1-g,this.size));return(f>=0||-h>=i*(-f)?i:Math.round(h/f))|0};return e})();var d=(function(){var e=function(l,q,r,p,t,m,g){var v=1000;var s=[];var n=0,k=0,u=0,h=0,o=false;for(;u<v;++u){n=0;for(;n<p&&u<v;){o=false;h=0;while(!o){o=true;h=s[n]=Math.floor(Math.random()*t)|0;for(k=0;k<n;++k){if(h==s[k]){o=false;break}}}m[n]=q[h];g[n]=r[h];if(!l.check_subset(m,g,n+1)){u++;continue}++n;}break}return(n==p&&u<v)};var f=function(k,m,p,q,o,g,h,s){var j=0,l=0,n=0;var r=g*g;k.error(p,q,m,h,o);for(;l<o;++l){n=h[l]<=r;s[l]=n;j+=n;}return j};return{ransac:function(E,m,x,i,l,j,y,g){if(typeof g==="undefined"){g=1000;}if(l<E.size){return false}var v=E.size;var A=g,z=0;var q=false;var D=[];var C=[];var r=false;var G=j.cols,w=j.rows;var u=j.type|jsfeat.C1_t;var B=jsfeat.cache.get_buffer((G*w)<<3);var h=jsfeat.cache.get_buffer(l);var t=jsfeat.cache.get_buffer(l<<2);var o=new jsfeat.matrix_t(G,w,u,B.data);var s=new jsfeat.matrix_t(l,1,jsfeat.U8C1_t,h.data);var F=-1,p=0;var n=0;var k=t.f32;if(l==v){if(m.run(x,i,o,l)<=0){jsfeat.cache.put_buffer(B);jsfeat.cache.put_buffer(h);jsfeat.cache.put_buffer(t);return false}o.copy_to(j);if(y){while(--l>=0){y.data[l]=1;}}jsfeat.cache.put_buffer(B);jsfeat.cache.put_buffer(h);jsfeat.cache.put_buffer(t);return true}for(;z<A;++z){r=e(m,x,i,v,l,D,C);if(!r){if(z==0){jsfeat.cache.put_buffer(B);jsfeat.cache.put_buffer(h);jsfeat.cache.put_buffer(t);return false}break}n=m.run(D,C,o,v);if(n<=0){continue}p=f(m,o,x,i,l,E.thresh,k,s.data);if(p>Math.max(F,v-1)){o.copy_to(j);F=p;if(y){s.copy_to(y);}A=E.update_iters((l-p)/l,A);q=true;}}jsfeat.cache.put_buffer(B);jsfeat.cache.put_buffer(h);jsfeat.cache.put_buffer(t);return q},lmeds:function(H,n,z,i,l,j,B,g){if(typeof g==="undefined"){g=1000;}if(l<H.size){return false}var w=H.size;var D=g,C=0;var r=false;var G=[];var F=[];var s=false;var I=j.cols,y=j.rows;var v=j.type|jsfeat.C1_t;var E=jsfeat.cache.get_buffer((I*y)<<3);var h=jsfeat.cache.get_buffer(l);var u=jsfeat.cache.get_buffer(l<<2);var p=new jsfeat.matrix_t(I,y,v,E.data);var t=new jsfeat.matrix_t(l,1,jsfeat.U8_t|jsfeat.C1_t,h.data);var q=0;var o=0;var k=u.f32;var A=1000000000,x=0,m=0;H.eps=0.45;D=H.update_iters(H.eps,D);if(l==w){if(n.run(z,i,p,l)<=0){jsfeat.cache.put_buffer(E);jsfeat.cache.put_buffer(h);jsfeat.cache.put_buffer(u);return false}p.copy_to(j);if(B){while(--l>=0){B.data[l]=1;}}jsfeat.cache.put_buffer(E);jsfeat.cache.put_buffer(h);jsfeat.cache.put_buffer(u);return true}for(;C<D;++C){s=e(n,z,i,w,l,G,F);if(!s){if(C==0){jsfeat.cache.put_buffer(E);jsfeat.cache.put_buffer(h);jsfeat.cache.put_buffer(u);return false}break}o=n.run(G,F,p,w);if(o<=0){continue}n.error(z,i,p,k,l);m=jsfeat.math.median(k,0,l-1);if(m<A){A=m;p.copy_to(j);r=true;}}if(r){x=2.5*1.4826*(1+5/(l-w))*Math.sqrt(A);x=Math.max(x,0.001);q=f(n,j,z,i,l,x,k,t.data);if(B){t.copy_to(B);}r=q>=w;}jsfeat.cache.put_buffer(E);jsfeat.cache.put_buffer(h);jsfeat.cache.put_buffer(u);return r}}})();a.ransac_params_t=b;a.motion_model=c;a.motion_estimator=d;})(jsfeat);(function(b){var a=(function(){var c=function(q,S,O,p){var r=0;var y=q.channel,v=q.cols,J=q.rows;var P=q.data,m=S.data;var I=v/O,H=J/p;var n=(I*H*65536)|0;var x=0,u=0,C=0,A=0,t=0,s=0,G=0,F=0,D=0,B=0;var Q=0,N=0,K=0,o=0,M=0,E=0;var l=jsfeat.cache.get_buffer((O*y)<<2);var g=jsfeat.cache.get_buffer((O*y)<<2);var R=jsfeat.cache.get_buffer((v*2*3)<<2);var L=l.i32;var j=g.i32;var z=R.i32;for(;x<O;x++){D=x*I,B=D+I;t=(D+1-0.000001)|0,s=B|0;t=Math.min(t,v-1);s=Math.min(s,v-1);if(t>D){z[F++]=(x*y)|0;z[F++]=((t-1)*y)|0;z[F++]=((t-D)*256)|0;r++;}for(C=t;C<s;C++){r++;z[F++]=(x*y)|0;z[F++]=(C*y)|0;z[F++]=256;}if(B-s>0.001){r++;z[F++]=(x*y)|0;z[F++]=(s*y)|0;z[F++]=((B-s)*256)|0;}}for(x=0;x<O*y;x++){L[x]=j[x]=0;}u=0;for(A=0;A<J;A++){Q=v*A;for(F=0;F<r;F++){K=z[F*3];t=z[F*3+1];o=z[F*3+2];for(G=0;G<y;G++){L[K+G]+=P[Q+t+G]*o;}}if((u+1)*H<=A+1||A==J-1){M=(Math.max(A+1-(u+1)*H,0)*256)|0;E=256-M;N=O*u;if(M<=0){for(x=0;x<O*y;x++){m[N+x]=Math.min(Math.max((j[x]+L[x]*256)/n,0),255);j[x]=L[x]=0;}}else{for(x=0;x<O*y;x++){m[N+x]=Math.min(Math.max((j[x]+L[x]*E)/n,0),255);j[x]=L[x]*M;L[x]=0;}}u++;}else{for(x=0;x<O*y;x++){j[x]+=L[x]*256;L[x]=0;}}}jsfeat.cache.put_buffer(g);jsfeat.cache.put_buffer(l);jsfeat.cache.put_buffer(R);};var f=function(p,S,N,o){var q=0;var x=p.channel,u=p.cols,I=p.rows;var O=p.data,m=S.data;var H=u/N,G=I/o;var Q=1/(H*G);var v=0,t=0,B=0,z=0,s=0,r=0,F=0,E=0,C=0,A=0;var P=0,M=0,J=0,n=0,L=0,D=0;var l=jsfeat.cache.get_buffer((N*x)<<2);var g=jsfeat.cache.get_buffer((N*x)<<2);var R=jsfeat.cache.get_buffer((u*2*3)<<2);var K=l.f32;var j=g.f32;var y=R.f32;for(;v<N;v++){C=v*H,A=C+H;s=(C+1-0.000001)|0,r=A|0;s=Math.min(s,u-1);r=Math.min(r,u-1);if(s>C){q++;y[E++]=((s-1)*x)|0;y[E++]=(v*x)|0;y[E++]=(s-C)*Q;}for(B=s;B<r;B++){q++;y[E++]=(B*x)|0;y[E++]=(v*x)|0;y[E++]=Q;}if(A-r>0.001){q++;y[E++]=(r*x)|0;y[E++]=(v*x)|0;y[E++]=(A-r)*Q;}}for(v=0;v<N*x;v++){K[v]=j[v]=0;}t=0;for(z=0;z<I;z++){P=u*z;for(E=0;E<q;E++){s=y[E*3]|0;J=y[E*3+1]|0;n=y[E*3+2];for(F=0;F<x;F++){K[J+F]+=O[P+s+F]*n;}}if((t+1)*G<=z+1||z==I-1){L=Math.max(z+1-(t+1)*G,0);D=1-L;M=N*t;if(Math.abs(L)<0.001){for(v=0;v<N*x;v++){m[M+v]=j[v]+K[v];j[v]=K[v]=0;}}else{for(v=0;v<N*x;v++){m[M+v]=j[v]+K[v]*D;j[v]=K[v]*L;K[v]=0;}}t++;}else{for(v=0;v<N*x;v++){j[v]+=K[v];K[v]=0;}}}jsfeat.cache.put_buffer(g);jsfeat.cache.put_buffer(l);jsfeat.cache.put_buffer(R);};var e=function(D,F,m,s,B,t,g,n){var z=0,y=0,x=0,A=0,u=0,l=0,G=0,E=0,C=0,v=t[0],r=0;var q=s<<1,p=s*3,o=s<<2;for(;z<B;++z){l=F[A];for(y=0;y<n;++y){D[y]=l;}for(y=0;y<=s-2;y+=2){D[y+n]=F[A+y];D[y+n+1]=F[A+y+1];}for(;y<s;++y){D[y+n]=F[A+y];}l=F[A+s-1];for(y=s;y<n+s;++y){D[y+n]=l;}for(y=0;y<=s-4;y+=4){l=D[y]*v,G=D[y+1]*v,E=D[y+2]*v,C=D[y+3]*v;for(x=1;x<g;++x){r=t[x];l+=D[x+y]*r;G+=D[x+y+1]*r;E+=D[x+y+2]*r;C+=D[x+y+3]*r;}m[u+y]=Math.min(l>>8,255);m[u+y+1]=Math.min(G>>8,255);m[u+y+2]=Math.min(E>>8,255);m[u+y+3]=Math.min(C>>8,255);}for(;y<s;++y){l=D[y]*v;for(x=1;x<g;++x){l+=D[x+y]*t[x];}m[u+y]=Math.min(l>>8,255);}A+=s;u+=s;}for(z=0;z<s;++z){l=m[z];for(y=0;y<n;++y){D[y]=l;}x=z;for(y=0;y<=B-2;y+=2,x+=q){D[y+n]=m[x];D[y+n+1]=m[x+s];}for(;y<B;++y,x+=s){D[y+n]=m[x];}l=m[(B-1)*s+z];for(y=B;y<n+B;++y){D[y+n]=l;}u=z;for(y=0;y<=B-4;y+=4,u+=o){l=D[y]*v,G=D[y+1]*v,E=D[y+2]*v,C=D[y+3]*v;for(x=1;x<g;++x){r=t[x];l+=D[x+y]*r;G+=D[x+y+1]*r;E+=D[x+y+2]*r;C+=D[x+y+3]*r;}m[u]=Math.min(l>>8,255);m[u+s]=Math.min(G>>8,255);m[u+q]=Math.min(E>>8,255);m[u+p]=Math.min(C>>8,255);}for(;y<B;++y,u+=s){l=D[y]*v;for(x=1;x<g;++x){l+=D[x+y]*t[x];}m[u]=Math.min(l>>8,255);}}};var d=function(D,F,m,s,B,t,g,n){var z=0,y=0,x=0,A=0,u=0,l=0,G=0,E=0,C=0,v=t[0],r=0;var q=s<<1,p=s*3,o=s<<2;for(;z<B;++z){l=F[A];for(y=0;y<n;++y){D[y]=l;}for(y=0;y<=s-2;y+=2){D[y+n]=F[A+y];D[y+n+1]=F[A+y+1];}for(;y<s;++y){D[y+n]=F[A+y];}l=F[A+s-1];for(y=s;y<n+s;++y){D[y+n]=l;}for(y=0;y<=s-4;y+=4){l=D[y]*v,G=D[y+1]*v,E=D[y+2]*v,C=D[y+3]*v;for(x=1;x<g;++x){r=t[x];l+=D[x+y]*r;G+=D[x+y+1]*r;E+=D[x+y+2]*r;C+=D[x+y+3]*r;}m[u+y]=l;m[u+y+1]=G;m[u+y+2]=E;m[u+y+3]=C;}for(;y<s;++y){l=D[y]*v;for(x=1;x<g;++x){l+=D[x+y]*t[x];}m[u+y]=l;}A+=s;u+=s;}for(z=0;z<s;++z){l=m[z];for(y=0;y<n;++y){D[y]=l;}x=z;for(y=0;y<=B-2;y+=2,x+=q){D[y+n]=m[x];D[y+n+1]=m[x+s];}for(;y<B;++y,x+=s){D[y+n]=m[x];}l=m[(B-1)*s+z];for(y=B;y<n+B;++y){D[y+n]=l;}u=z;for(y=0;y<=B-4;y+=4,u+=o){l=D[y]*v,G=D[y+1]*v,E=D[y+2]*v,C=D[y+3]*v;for(x=1;x<g;++x){r=t[x];l+=D[x+y]*r;G+=D[x+y+1]*r;E+=D[x+y+2]*r;C+=D[x+y+3]*r;}m[u]=l;m[u+s]=G;m[u+q]=E;m[u+p]=C;}for(;y<B;++y,u+=s){l=D[y]*v;for(x=1;x<g;++x){l+=D[x+y]*t[x];}m[u]=l;}}};return{grayscale:function(n,r,A,D,g){if(typeof g==="undefined"){g=jsfeat.COLOR_RGBA2GRAY;}var q=0,p=0,z=0,v=0,m=0,u=0;var s=4899,B=9617,C=1868,o=4;if(g==jsfeat.COLOR_BGRA2GRAY||g==jsfeat.COLOR_BGR2GRAY){s=1868;C=4899;}if(g==jsfeat.COLOR_RGB2GRAY||g==jsfeat.COLOR_BGR2GRAY){o=3;}var l=o<<1,k=(o*3)|0;D.resize(r,A,1);var t=D.data;for(p=0;p<A;++p,v+=r,z+=r*o){for(q=0,m=z,u=v;q<=r-4;q+=4,m+=o<<2,u+=4){t[u]=(n[m]*s+n[m+1]*B+n[m+2]*C+8192)>>14;t[u+1]=(n[m+o]*s+n[m+o+1]*B+n[m+o+2]*C+8192)>>14;t[u+2]=(n[m+l]*s+n[m+l+1]*B+n[m+l+2]*C+8192)>>14;t[u+3]=(n[m+k]*s+n[m+k+1]*B+n[m+k+2]*C+8192)>>14;}for(;q<r;++q,++u,m+=o){t[u]=(n[m]*s+n[m+1]*B+n[m+2]*C+8192)>>14;}}},resample:function(l,m,i,k){var j=l.rows,g=l.cols;if(j>k&&g>i){m.res