module.exports = {
    parser: 'babel-eslint',
    plugins: [
        'import',
    ],
    env: {
        browser: true,
        node: true,
        commonjs: true,
        'shared-node-browser': true,
        es6: true,
        mocha: true,
        amd: true,
    },
    globals: {
        requestIdleCallback: true,
        JSON: true,
        alert: true,
        chrome: true
    },
    rules: {
        'no-unused-vars': ['error', { args: 'none' }],
        'comma-dangle': ['warn', 'only-multiline'],
        'prefer-const': 'warn',
        'no-var': 'warn',
        'no-new-object': 'error',
        'quote-props': ['warn', 'as-needed'],
        'no-array-constructor': 'error',
        'array-callback-return': 'error',
        'quotes': ['warn', 'single', { 'avoidEscape': true, 'allowTemplateLiterals': true }],
        'template-curly-spacing': 'warn',
        'no-useless-escape': 'warn',
        'func-style': ['warn',
        'declaration', { 'allowArrowFunctions': true }],
        'wrap-iife': ['error', 'any', {'functionPrototypeMethods': true}],
        'prefer-rest-params': 'warn',
        'no-new-func': 'error',
        'space-before-function-paren': ['warn', {
            'anonymous': 'never',
            'named': 'never',
            'asyncArrow': 'always'
        }],
        'space-before-blocks': ['warn', 'always'],
        'no-param-reassign': 'error',
        'prefer-spread': 'warn',
        'prefer-arrow-callback': 'warn',
        'arrow-spacing': 'warn',
        'arrow-body-style': 'error',
        'arrow-parens': ['error', 'as-needed'],
        'no-useless-constructor': 'warn',
        'no-dupe-class-members': 'error',
        'no-duplicate-imports': 'error',
        'generator-star-spacing': ['warn', {'before': false, 'after':true}],
        'no-undef': 'error',
        'eqeqeq': 'error',
        'no-case-declarations': 'error',
        'no-unneeded-ternary': 'warn',
        'no-nested-ternary': 'warn',
        'brace-style': ['error', '1tbs', { 'allowSingleLine': true }],
        'spaced-comment': ['warn', 'always'],
        'indent': ['error', 4, { 'SwitchCase': 1 }],
        'keyword-spacing': 'error',
        'space-infix-ops': 'warn',
        'eol-last': 'warn',
        'no-whitespace-before-property': 'error',
        'padded-blocks': ['warn', 'never'],
        'space-in-parens': 'warn',
        'array-bracket-spacing': 'warn',
        'object-curly-spacing': ['warn', 'always'],
        'semi': 'warn',
        'radix': 'error',
        'new-cap': 'error',
        'no-extra-boolean-cast': 'off',
        'no-loop-func': 'error',
        'import/no-webpack-loader-syntax': 'error',
        'import/first': 'error',
    }
};
