
# ![](images/icons/windows-update-32x32.png) [98.js](https://98.js.org)

[![Discord](https://img.shields.io/discord/1141194608525713478)](https://discord.com/invite/SyFweYjTKx)
[![GitHub Repo stars](https://img.shields.io/github/stars/1j01/98)](https://github.com/1j01/98/stargazers)

A web based Windows 98 desktop remake.

Includes:
* ![](images/icons/notepad-16x16.png) Notepad ([separate README](programs/notepad/README.md))
* ![](images/icons/speaker-16x16.png) Sound Recorder ([separate README](programs/sound-recorder/README.md))
* ![](images/icons/paint-16x16.png) Paint ([separate repository](https://github.com/1j01/jspaint))
* ![](images/icons/calculator-16x16.png) Calculator ([separate README](programs/calculator/README.md))
* ![](images/icons/pipes-16x16.png) 3D Pipes ([separate repository](https://github.com/1j01/pipes))
* ![](images/icons/pipes-16x16.png) 3D FlowerBox ([original repository](https://github.com/kevin-shannon/3D-FlowerBox)) by [Kevin Shannon](https://github.com/kevin-shannon)
* ![](images/icons/minesweeper-16x16.png) Minesweeper ([separate README](programs/minesweeper/README.md); [original repository](https://github.com/ziebelje/minesweeper)) by [Jon Ziebell](https://github.com/ziebelje/)
* ![](images/icons/solitaire-16x16.png) Solitaire ([original repository](https://github.com/rjanjic/js-solitaire)) by [Radovan Janjic](https://github.com/rjanjic)
* ![](images/icons/pinball-16x16.png) Pinball ([original repository](https://github.com/alula/SpaceCadetPinball)) ported by [Muzychenko Andrey](https://github.com/k4zmu2a) and [Alula](https://github.com/alula)
* ![](images/icons/winamp2-16x16.png) Winamp 2.9 ([separate README](programs/winamp/README.md); [original repository](https://github.com/captbaritone/webamp)) by [Jordan Eldredge](https://jordaneldredge.com/)
* ![](images/icons/folder-open-16x16.png) Windows Explorer / ![](images/icons/internet-explorer-16x16.png) Internet Explorer ([separate README](programs/explorer/README.md))
* ![](images/icons/chm-16x16.png) Help Viewer
* 📎 Clippy ([original repository](https://github.com/smore-inc/clippy.js))

Features:
* Drop files onto the desktop, and they'll be stored in a virtual filesystem
* Load Windows themes! Many are included in the Themes folder on the desktop.
* Easter eggs (try a famous cheat code 😉)
* Meticulous detail in many areas (although there's obviously lots "missing")
* **Help > Help Topics** in Paint, Sound Recorder, Notepad, and Minesweeper
* You can add the site to your homescreen on mobile

## Try it out

[ ＥＮＴＥＲ　![](images/icons/windows-update-16x16.png)　ＷＩＮＤＯＷＳ　９８　体験へようこそ](https://98.js.org/)

[![](images/3d.jpg)](https://98.js.org/)

## License

Not yet licensed.
This project is currently [source-available / shared source](https://en.wikipedia.org/wiki/Source-available_software), but not [open source](https://en.wikipedia.org/wiki/Open-source_software).

## Related Projects

Apps that it would be nice to integrate:
* [![](images/icons/settings-16x16.png) Windows Classic theme designer](https://github.com/tpenguinltg/winclassic)
* [![](images/icons/media-player-16x16.png) Win95 Media Player](https://benwiley4000.github.io/win95-media-player/)

Other online operating systems / web desktops:

| Name & Link                                                                                           | Vague Description                | Repo & License                                                                                                                                         | Chat                                    |
|-------------------------------------------------------------------------------------------------------|----------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------|-----------------------------------------|
| [![](images/start.png)&nbsp;Rahul.io](https://rahul.io/)                                              | another Windows 98 remake        | [repo here](https://github.com/lolstring/window98-html-css-js) - MIT license                                                                           |                                         |
| [![](images/icons/windows-93-16x16.png)&nbsp;Windows&nbsp;93](https://www.windows93.net/)             | a "fictional version of Windows" | (not open source currently)                                                                                                                            | [Discord](https://discord.gg/vAmMu7q)   |
| [🏡 ZineOS](https://whimsy.space/)                                                                     | emojis everywhere                | [repo here](https://github.com/STRd6/zine) - MIT license                                                                                               | [Discord](https://discord.gg/tUj4zYA)   |
| [![](images/icons/emuos-16x16.png)&nbsp;EmuOS](https://emupedia.net/beta/emuos/)                      | emulator-focused Win9X desktop   | [repo here](https://github.com/Emupedia/emupedia.github.io) - shared source                                                                            | [Discord](https://discord.gg/5u4VR9v)   |
| [![](images/icons/os-js-16x16.png)&nbsp;OS.js](https://www.os-js.org/)                                | a more serious web desktop       | [repo here](https://github.com/os-js/OS.js) - simplified BSD license                                                                                   | [Gitter](https://gitter.im/os-js/OS.js) |
| [![](images/icons/friend-16x16.png)&nbsp;Friend](https://friendup.cloud/)                             | another serious one              | [repo here](https://github.com/FriendUPCloud/friendup) - different licenses for different [parts](https://github.com/FriendUPCloud/friendup#licensing) |                                         |
| [![](images/icons/clouddesk-16x16.png)&nbsp;CloudDesk](http://altaica.altervista.org/)                | another serious one              | (explicitly not open source)                                                                                                                           |                                         |
| [![](images/icons/aaronos-16x16.png)&nbsp;AaronOS](https://aaronos.dev/AaronOS/aosBeta.php)           | interesting aesthetic            | [repo here](https://github.com/MineAndCraft12/AaronOS) - shared source                                                                                 | [Discord](https://discord.gg/eWDac7E)   |
| [![](images/icons/webdesktop-16x16.png)&nbsp;Web&nbsp;Desktop](https://webdesktop.net/)               | Windows 10 like "startpage"      |                                                                                                                                                        |                                         |
| [![](images/icons/system-16x16.png)&nbsp;System](https://system-developer-beta.000webhostapp.com/)    | Windows 10 like thing            |                                                                                                                                                        |                                         |
| [![](images/icons/winxp-doge-16x16.png)&nbsp;WinXP](https://winxp.now.sh/)                            | Windows XP                       | [repo here](https://github.com/ShizukuIchi/winXP/) - MIT license                                                                                       |                                         |
| [Windows 98 - Packard Belle](https://packard-belle.netlify.com/)                                      | Windows 98                       | [repo here](https://github.com/padraigfl/packard-belle-desktop) - shared source                                                                        |                                         |
| [X-WebDesktop-Vue](http://47.93.49.248/X-WebDesktop-Vue/)                                             | Windows 7                        | [repo here](https://github.com/OXOYO/X-WebDesktop-Vue) - MIT license                                                                                   |                                         |
| [![](images/icons/vue-win3.1-16x16.png)&nbsp;vue win3.1](https://disjfa.github.io/vue-win-3.1/)       | Windows 3.1                      | [repo here](https://github.com/disjfa/vue-win-3.1) - shared source                                                                                     |                                         |
| [![](images/icons/virtualdesktop.org-16x16.png)&nbsp;VirtualDesktop](http://virtualdesktop.org/)      | Screenshot flows, several OSes   |                                                                                                                                                        |                                         |
| [GUIdebook](https://guidebookgallery.org/guis/windows/)                                               | Screenshots, several OSes        |                                                                                                                                                        |                                         |


Plus many more [web desktops on Wikipedia](https://en.wikipedia.org/wiki/Web_desktop),
[awesome-web-desktops](https://github.com/syxanash/awesome-web-desktops),
and [awesome-OS](https://github.com/zriyans/awesome-OS).

Libraries:
* [![](images/icons/task-16x16.png) OS-GUI](https://os-gui.js.org), which grew out of this project
* ![](images/icons/task-16x16.png) [Packard Belle](https://github.com/padraigfl/packard-belle/),
  [React95](https://github.com/React95/React95/),
  and another one called [React95](https://github.com/arturbien/React95), with similar goals to OS-GUI
* [![](images/icons/folder-16x16.png) BrowserFS](https://github.com/jvilk/BrowserFS), a filesystem abstraction library powering 98.js

Also:
* [Awesome Atwood's Law](https://github.com/captbaritone/awesome-attwoods-law), a curated list of JavaScript reimplementations, similar to [/r/atwoodslaw/](https://www.reddit.com/r/atwoodslaw/)

## Contributing

See [CONTRIBUTING](CONTRIBUTING.md)

## Development Setup

- Install [Git](https://git-scm.com/) if you don't already have it.
- Install [Node.js](https://nodejs.org/) if you don't already have it.
- [Clone the repository.](https://docs.github.com/en/github/creating-cloning-and-archiving-repositories/cloning-a-repository)
- Open up a terminal / command prompt in the project directory, and run `npm install` to install dependencies.
- Install one global dependency: `npm i -g browserfs@2.0.0` (this will be simplified in the future; I'm using two different versions of BrowserFS for some reason)
- Run `npm start` to start up a live-reloading development web server.

When pulling changes from git, run `npm install` again in case there are any new or updated dependencies.
(If you know `package-lock.json` hasn't changed, you shouldn't need to do this.)

Some dependencies are versioned with npm, but pulled into the repo with `npm run pull-libs`

### Quality Assurance

Tests are written with Playwright. Spell checking is done with Cspell.

```
npm test
npm run lint
```

Debug tests or run them when code changes using the Playwright UI:

```
npx playwright test --ui
```

Quickly add tests using the code generator:

```
# Note: this runs the server, and currently leaves it running when closing the browser.
# Could use `start-server-and-test` to fix this, or see if there's an option in `npm-run-all`'s `run-p` command.
# (There's no option in `playwright codegen --help` to run the server, even though it's configured in `playwright.config.js`)
npm run test-codegen
```

There are also VS Code extensions for Playwright and Cspell (Code Spell Checker).


### Managing Subrepos

To update subrepos, or push changes to them, install [git-subrepo](https://github.com/ingydotnet/git-subrepo). You don't need this tool to clone the project and get up and running, as subrepos are just normal subdirectories with a `.gitrepo` metadata file.

Note that the metadata file references specific commit hashes, including between repositories, so it's best to avoid rebasing when subrepo updates are involved, i.e. once you do a subrepo command, it makes a commit, and you should leave it (and earlier commits) alone, and you should leave commits in the subrepo alone, before and up to any commits referenced by the containing project.

When making changes to a subrepo within the containing project:
I'd recommend phrasing commit messages to apply to the subrepo, primarily, rather than the containing project,
so that when you push the changes to the subrepo, the commit message will be appropriate.

If you so much as edit the commit message for a `git subrepo push`ed commit, you'd have to update the `.gitrepo` metadata file manually in the containing project,
OR you could drop the commit you pushed and the `git subrepo push` commit (which updates the metadata) and do `git subrepo pull` instead (which btw gives you an option to rename the commit; and I think renaming that commit would be safe after the fact anyways as long as it's the last commit and not pushed).

## TODO

See [TODO](TODO.md)
