**General Services Administration**

Federal Acquisition Service
Technology Transformation Services

1800 F St NW | Washington, DC | 20405

Request for Quotation

Bug Bounty 2

TCTOA-18-0013

**From:** Michelle McNellis, Contracting Officer, GSA TTS
**Subject:** Request for Quotation (RFQ)

**Date:** July 24, 2018
**Reply By:** **August 07, 2018** **4:00PM EST**

**Document Type:** Combined Synopsis/Solicitation Solicitation

**Set Aside:** Small Business

**NAICS Code:** 541519 – Other Computer Related Services

**Authority:** The solicitation document and incorporated provisions and
clauses are those in effect through Federal Acquisition Regulation
Subpart 12.6 Streamlined Procedures for Evaluation and Solicitation for
Commercial Items with supplementing information from FAR subpart 13.106
Soliciting Competition, Evaluation of Quotations or Offers, Award and
Documentation

[<span class="underline">1.0 Instructions</span>](#instructions)

[<span class="underline">2.0 Background</span>](#background)

[<span class="underline">3.0 Requirements</span>](#requirements)

[<span class="underline">4.0 Evaluation</span>](#_4d34og8)

[<span class="underline">5.0 Period of
Performance</span>](#period-of-performance)

[<span class="underline">6.0 Type of Contract</span>](#type-of-contract)

[<span class="underline">7.0 Invoicing</span>](#invoicing)

[<span class="underline">8.0 Administration</span>](#administration)

[<span class="underline">9.0 Post Award and Kickoff
Meeting</span>](#post-award-and-kickoff-meeting)

[<span class="underline">10.0 TTS Transparency
Policy</span>](#tts-transparency-policy)

[<span class="underline">11.0 Clauses</span>](#_2xcytpi)

# 1.0 Instructions

## 1.1 Quote Instructions

Quotes will only be accepted via the referenced Google Forms below. The
vendor must complete the [<span class="underline">Technical Response
Google Form</span>](https://goo.gl/forms/5weHl7f8my1S7QCv2) and
[<span class="underline">Price Response Google
Form</span>](https://goo.gl/forms/Vmvv6CRXLzMBpwLd2).

## 1.2 Questions

Any questions concerning the RFQ must be submitted using the issue
template in the associated repository no later than July 30, 2018 4:00PM
Eastern Time (ET). The government will provided responses to open issues
no later than August 01, 2018 4:00PM.

## **1.3 Potential Organizational Conflicts of Interest Statement.**

Every offeror who wishes to be considered for the award shall provide a
signed Organizational Conflict of Interest statement with their
quotation submission, which describes concisely all relevant facts
concerning any past, present, or planned interest (financial,
contractual, organizational, or otherwise) relating to the work to be
performed under the proposed contract and bearing on whether the offeror
has a possible organizational or personal conflict of interest with
respect to:

1.  > Being able to render impartial, technically sound, and objective
    > assistance or advice; or,

2.  > Being given an unfair competitive advantage.

Offerors may also provide relevant facts that show how its
organizational structure and/or management systems limit its knowledge
of possible organizational conflicts of interest relating to other
divisions or sections of the organization and how that structure or
system would avoid or mitigate such organizational conflict.

No contract award shall be made until any potential conflict of interest
has been neutralized or mitigated to the satisfaction of the CO in
accordance with Subpart FAR 9.5 [<span class="underline">Organizational
and Consultant Conflicts of
Interest</span>](https://www.acquisition.gov/browsefar). Refusal to
provide the requested information or the willful misrepresentation of
any relevant information by an offeror shall disqualify the offeror from
further consideration for award of a contract under this solicitation.
If the CO determines that a potential conflict can be avoided,
effectively mitigated, or otherwise resolved through the inclusion of a
special contract clause, the terms of the clause will be subject to
negotiation.

# 2.0 Background

TTS needs to purchase access to a pre-existing, commercially available
Bug Bounty SaaS Platform that will allow it to manage the TTS Bug Bounty
program. This acquisition will give TTS access to a large network of
security researchers, people who have an interest - both personally and
financially - in helping to find and address bugs and other technical
issues within TTS-owned web applications.

The TTS [<span class="underline">vulnerability disclosure
policy</span>](https://18f.gsa.gov/vulnerability-disclosure-policy/)
that was released in November 2016 outlines how researchers can report
system vulnerabilities, while keeping personal and financial information
safe. TTS wishes to incentivize security researchers and other
interested users to report security issues directly to the system owner
through the use of financial rewards - also known as, a bug bounty.

By the very nature of a bug bounty program, a contractor that provides a
Bug Bounty SaaS Platform that can achieve the goals of TTS while
providing the best value to the government must be one that is
well-established. The more well-known the provider of a Bug Bounty SaaS
Platform, the larger and more talented the pool of security researchers
they have in their community. The larger the community of security
researchers in the Bug Bounty SaaS Platform provider’s network, the
better the chance TTS has of finding bugs and technical issues within
their web applications.

Beyond the software that makes up a SaaS Platform and the network of
security researchers, a successful contractor will also need to have the
ability to provide program management and triage services.

Program management services include services related to promotion of the
program, tracking and workflow, and payouts. With thousands of competing
bug bounty programs, the contractor must be able to emphasize the
attractiveness of the TTS Bug Bounty program. There must also be a level
of expertise in relation to how submissions will be received and how
they will be managed throughout their lifecycle. By way of example,
payouts often average around $300, with dozens or even hundreds of
payouts over the life of a program.

Successful bug bounty programs result in dozens of reports per month, on
average, only about 10% of submissions turn out to be valid. All
submissions needs responses, however, or else there is a risk of
alienating researchers. The workload of filtering submissions and
communicating with researchers can be quite heavy. A successful
contractor will, among other things, assign a severity-rating to each
vulnerability (e.g., low, medium, high critical), provide responses to
invalid reports, provide initial responses to valid reports, and forward
valid reports to TTS within a reasonable time based on the severity.

Platforms typically provide triage services as a separate option, so
this means that the acquisition will involve 2 components, all of which
are necessary:

1.  > The cost of access to the network and use of the SaaS platform,
    > inclusive of triage and communication services; and,

2.  > A “bounty pool” from which researchers are paid for valid reports.

# 3.0 Requirements

The contractor will provide a Software-as-a-Service platform, with a
publicly-available website, for researchers to report security
vulnerabilities on publicly available government websites in a manner
consistent with the TTS vulnerability disclosure policy. The platform
will:

  - > Communicate the procedures of how to discover and report security
    > vulnerabilities on publicly available government online services
    > in a manner consistent with the TTS Vulnerability Disclosure
    > Policy.

  - > Advertise that there are available awards for successful
    > vulnerability disclosure on the stated applications that TTS
    > posts.

  - > Provide a secure means for researchers to submit the
    > vulnerabilities they discover.

  - > Ensure that researchers are aware of the TTS Vulnerability
    > Disclosure Policy and any other relevant discovery or reporting
    > procedures.

  - > Permit TTS to post any number of concurrent bounty targets, with
    > specific scopes, instructions, and bounty structures, during the
    > initial period of performance.

  - > Permit TTS to add or remove any of the posted applications at any
    > time during the period of performance.

  - > Provide access to a network of security researchers and bounty
    > hunters.

  - > Provide a platform for TTS staff to view reported vulnerabilities
    > and update their status as the issues are managed and resolved.

  - > Support both public bounties (open to any researcher on the
    > platform) and private, invite-only bounties (open to only
    > researchers TTS and/or the vendor select).

  - > Provide a programmatic interface (API) to vulnerability report
    > data.

  - > Triage of severity of reported vulnerabilities. The contractor
    > will provide services to:

      - > Screen reported vulnerabilities and filter out invalid and
        > duplicate reports.

      - > Classify vulnerabilities according to TTS guidelines developed
        > for the vendor and assign them to the proper TTS staff, while
        > TTS maintains the rights to update these guidelines at any
        > time.

      - > Communicate with researchers about their reports, escalating
        > to TTS staff if needed.

Bug bounty pool management:

  - > Work with TTS to identify the proper scope of vulnerability
    > identification, disclosure, and assessment, controlling for risk.
    > Also, criteria for most significant vulnerabilities will be
    > established with TTS before applications are advertised.

  - > Work with TTS to identify the proper scope of vulnerability
    > identification and ranking. With TTS assistance, determine, and/or
    > adjust bounty reward tiers to manage our bounty pool most
    > effectively.

  - > Once classified and deemed within the scope of the
    > vulnerabilities, the vendor will manage payout to the reporter
    > based on the agreed up bounty reward tiers by the contractor and
    > TTS.

  - > Forward to TTS the vulnerability reports, the names of the
    > researchers, and the award amounts.

The contractor will not be responsible for performing the following:

  - > Remedying discovered vulnerabilities.


## 3.1 Key Personnel

Contractor’s Technical Account Manager for this project must be listed
as Key Personnel.

To ensure successful performance of the requirement, contractor shall
satisfy the following:

1.  > The contractor shall provide a Technical Account Manager (TAM) as
    > the primary point of contact for the government’s program office
    > to enable timely problem resolution, reporting in a timely manner,
    > and properly aligning staffing requirements. The contractor will
    > be expected to work with the CO/COR and the TTS Product Owner.

2.  > If any individual proposed as Key Personnel becomes unavailable
    > during the course of the solicitation and evaluation process, the
    > contractor shall notify the CO immediately. Any Key Personnel
    > proposed who are not currently employed by the contractor shall be
    > identified as such and an the letter shall be signed by the
    > proposed Key Person and shall state that (1) the proposed Key
    > Person named is employed by the offeror or has an offer of
    > employment from the offeror that the Key Person intends to accept
    > in the event of an award being made to the offeror; and (2) the
    > proposed Key Person is available and committed to begin work on
    > the project start date.

3.  > The contractor agrees that through the duration of the base period
    > of performance of the contract, no Key Personnel substitutions
    > shall be made unless necessitated by an individual’s sudden
    > illness, death, or termination of employment for cause. In any of
    > such event, the contractor shall promptly notify the CO/COR and
    > the TTS Product Owner and provide the information required by
    > paragraphs below on the proposed replacement for Government
    > approval.

4.  > All requests for substitutions/additions of Key Personnel must
    > include a detailed explanation of the circumstances necessitating
    > the proposed substitution or addition. As determined by the CO,
    > all proposed substitutes/additions must have qualifications that
    > meet or exceed the qualifications of the person to be replaced.

5.  > The CO, or duly designated CO/COR and the TTS Product Owner, will
    > evaluate the request(s) for substitutions/additions of Key
    > Personnel and the CO will notify the contractor, in writing, of
    > approval or disapproval. Disapproval of the proposed individual(s)
    > shall not provide grounds for non-performance by the contractor or
    > form the basis of any claim for monies, delivery schedule
    > extension, or any other equitable adjustment.

6.  > Key Personnel must have a full understanding of the technical
    > approach discussed in section 3.0 requirements and delivered by
    > the contractor after award. NOTE - the labor category proposed is
    > at the contractor's discretion.

7.  > Key Personnel will be a direct liaison to the CO/COR and the TTS
    > Product Owner. Key Personnel shall be responsible for the
    > supervision and management of the contractor’s personnel,
    > technical assistance, and interface.

## 3.2 Deliverables

### 3.2.1 Vulnerability Reports

The contractor will submit through their security disclosure platform
vulnerability reports for those on the TTS application list. These
vulnerabilities will be triaged and classified based on the severity of
the vulnerability before being submitted to TTS.

### 3.2.2 Impact Reports

The contractor shall be responsible for providing timely notification to
the CO/COR and the TTS Product Owner when activities or issues outside
of the contractor’s control may directly impact the contractor’s
performance. This notification shall be provided in writing or via email
within 24 hours of any anticipated or known
impact.

### 3.2.3 List of Deliverables

| **Deliverable**                                                 | **Due date**                                                           | **Description**                                                                                                                             |
| --------------------------------------------------------------- | ---------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------- |
| Vulnerability reports delivered through the bug bounty platform | Within one business day of the researcher reporting the vulnerability. | Through the platform, the contractor will alert TTS that there is a triaged vulnerability report pending on one of the listed applications. |
| Impact Reports                                                  | Within 24 hours of any anticipated or known impact                     | Activities or issues outside of the contractor’s control may directly impact the contractor’s performance.                                  |

The contractor shall submit all deliverables to CO/COR and TTS Product
Owner.

### 3.2.4 Quality Assurance

The Government will use [<span class="underline">Quality Assurance
Surveillance
Plan</span>](QASP.md)
(QASP) to monitor the contractor’s performance. The QASP will provide
oversight help to ensure that service levels reach and maintain the
required levels for performance of this task. The QASP is a living
document and may be updated by the Government as necessary. Any updates
to the QASP will be provided to the contractor. If needed, the draft
QASP will be updated within 10 business days of contract kick off
meeting by TTS Product Lead and/or the COR.

# 4.0 Basis for Award

This procurement is being conducted in accordance with Federal
Acquisition Regulation (FAR) subpart 12.6, “Streamlined Procedures for
Evaluation and Solicitation for Commercial Items,” as supplemented with
additional information included in the RFQ. Technical Factors will be
evaluated in accordance with FAR subpart 12.602 “Streamlined Evaluation
of Offers”. Price will be evaluated in accordance with FAR subpart
13.106. Provision
[52.212-2](http://farsite.hill.af.mil/reghtml/regs/far2afmcfars/fardfars/far/52_000.htm#P1584_221596),
Evaluation -- Commercial Items, does not apply to this requirement. The
offerors agree to and are bound by all instructions, procedures and
rules of this RFQ. The Government is not obligated to determine a
competitive range, conduct discussions, solicit final revised
quotations, and use other techniques associated with FAR part
[15](https://www.acquisition.gov/far/html/Subpart%2015_1.html#wp1095839).

The final award for this requirement will be based on best-value
principles, utilizing the trade-off process. The Government is more
concerned with obtaining superior technical capabilities than with
making awards at the lowest overall price to the Government. Offerors
are advised that the technical evaluation factors combined are
significantly more important than price. Note that as submissions become
more technically equal in their merit, the total evaluated price becomes
more important.

# 5.0 Evaluation Process

The Government intends to utilize a phased approach for this procurement
as described below. To be considered for award, offerors must
successfully pass through each phase.

1.  > Phase 1: Technical Evaluation - The Government will evaluate the
    > offeror’s performance or capability acceptability based on the
    > following non-price technical factors which are of equal
    > importance to each other, Technical Understanding and Approach and
    > Similar Experience.

2.  > Phase 2: Pricing Schedule - Offeror’s Price as provided in the
    > price quotation received via the Google Form will be reviewed
    > separately from the technical evaluation.

The evaluation factors for award are as follows in descending order of
importance:

  - > Factor 1: Technical Understanding and Approach

  - > Factor 2: Similar Experience

  - > Factor 3: Price

For this solicitation, technical factors are more important than price.

## 5.1 - Phase 1 Technical Evaluation

*Technical Understanding and Approach.*

The offeror shall describe within the [<span class="underline">Technical
Evaluation Google Form</span>](https://goo.gl/forms/9i2hHwXwUJTp4KKI3),
level of knowledge, technical expertise and overall understanding of the
requirement as set forth in the Requirements, Section 3.0.

  - > Level of knowledge, technical expertise, and overall understanding
    > of the requirements to manage a bug bounty program for large and
    > high-profile corporations.

  - > Maintaining a reliable, secure bug bounty SaaS platform.

  - > Maintaining a community of security researchers with adequate
    > levels of skill and talent, among other factors outlined in the
    > solicitation.

  - > Approach to responding to researchers and communicating with
    > issues to the government

  - > Describe any modifications to the commercially-available SaaS
    > offering to meet the government requirements

*Similar* *Experience*

The Government will evaluate the offeror’s experience in delivering bug
bounty services to private and public sector clients meeting
substantially the same size, scope and complexity of the requirements
listed within section 3.0 of the RFQ. The government will not accept any
past experience performed by the offeror’s parent company, other
corporate affiliate, subcontractor or teaming partner. Experience
includes measuring platform-wide metrics, including but not limited to
average time to triage a new report, average time to respond to
researchers, average time to forward verified reports based on severity,
etc.

## 5.2 - Phase 2 Price Evaluation

Prices shall be submitted via the [<span class="underline">Price
Evaluation Form</span>](https://goo.gl/forms/Vmvv6CRXLzMBpwLd2).
Proposed prices shall be evaluated for reasonableness and consistency
with industry standards.

Evaluation of options under FAR
[<span class="underline">52.217-8</span>](https://www.acquisition.gov/far/html/52_217_221.html#wp1135887)
will be accomplished by using the prices offered for the last option
period to determine the price for a 6-month option period, which will be
added to the base and other option years to arrive at the total price.
Evaluation of options will not obligate the Government to exercise the
option(s).

The Government also reserves the right to make no award.

# 6.0 Period of Performance

The Period of Performance (POP) consists of a Base Period of six months
and 9 Option Periods of six months each, totaling 5 years.

# 7.0 Type of Contract

Based on the nature of this requirement, the government intends to award
a hybrid Firm-Fixed-Price (FFP) and Firm-Fixed-Price Not-To-Exceed (NTE)
contract type. The contract will include a FFP CLIN for access to the
platform and triage services. The bounty pool will be NTE, with varying
vulnerability levels but with all costs paid directly to the
researchers.

# 8.0 Invoicing

The selected vendor must submit invoices on a monthly basis and a final
invoice at the end of the period of performance within 60 calendar days
from contract completion. No further charges are to be billed following
the final invoice submission. A completed and signed Release of Claims
(GSA Form 1142) must be provided to the CO with the submission of a
final invoice.

## 8.1 Content of Invoice

The selected vendor will be provided with the following information when
the acquisition has been awarded:

  - > Contract/order number

  - > Period of performance covered by the invoice

  - > CLIN number and title

  - > The accounting number associated with the task order

All of this information must be included on each invoice in addition to
the requirements for a proper invoice specified in FAR 52.212-4 (g) and
the Prompt Payment clause, FAR 52.212-4(i)(2).

## 8.2 Invoice Submission

The selected vendor is required to submit invoices to GSA Vendor
Customer Self Service (VCSS) and the Contracting Officer Representative
(COR). All invoicing questions can be directed to customer support at
866-450-6588 or the VCSS customer service site
[<span class="underline">https://vcss.ocfo.gsa.gov/</span>](https://vcss.ocfo.gsa.gov/).
GSA TTS is unable to address any questions related to the invoicing
system.

# 9.0 Administration

This acquisition will be administered by the following individuals, who
will also monitor the selected vendor’s performance:

1.  > GSA Technical Point of Contact: Kimber Dowsett,
    > [<span class="underline">kimberly.dowsett@gsa.gov</span>](mailto:kimberly.dowsett@gsa.gov)

2.  > GSA TTS Contracting Officer: Michelle McNellis,
    > [<span class="underline">michelle.mcnellis@gsa.gov</span>](mailto:michelle.mcnellis@gsa.gov)

3.  > GSA TTS Contracting Officer Representative: Erik Burgess
    > [<span class="underline">erik.burgess@gsa.gov</span>](mailto:erik.burgess@gsa.gov)

# 10.0 Post Award and Kickoff Meeting

## 10.1 Post Award Orientation Conference

The government's team, CO/COR, and the TTS Product Owner will hold a
kickoff meeting/post-award conference with the selected vendor within 10
calendar days of the acquisition award. This kickoff will include the
selected vendor’s team and other relevant government staff to review and
clarify the project’s objectives, expectations from the government, and
address any questions the selected vendor may have.

## 10.2 Early Termination

Should the selected vendor be terminated prior to the end of the period
of performance, the selected vendor shall transfer all project materials
to the CO/COR and the TTS Product Owner. This will be completed within
two weeks of the CO/COR’s and the TTS Product Owner’s request.

## 10.3 Travel

No travel is anticipated or will be required as part of this task order.

## 10.4 Daily Operations

The place of performance will primarily be at the vendor’s work site.

## 10.5 Transition Activities

During the transition to the government or a new selected vendor, the
selected vendor shall perform all necessary transition activities. Time
and budget permitting, expected transition activities will include, but
are not limited to:

  - > Continuation of full services to TTS and customers.

  - > Participation in meetings with the government or a new selected
    > vendor to conduct a smooth transition and provide detailed
    > information on the operation of all deliverables at the COR and
    > TTS Product Lead's discretion.

# 11.0 TTS Transparency Policy

Vendors are advised that TTS reserves the right to publish documents
associated with this acquisition on a publicly-available website,
including any Requests for Quotation or their amendments, as well as
question and answer exchanges with vendors without source-identifying
information removed. TTS reserves the right to publish any other
relevant information that is not confidential or proprietary in nature,
but will not publish any source-selection sensitive information that
would otherwise implicate procurement integrity concerns.

Upon award of the acquisition, TTS may publish the total price of the
selected proposal and certain non-source-identifying data (e.g. the
number of bids, the mean price, the median, and the standard deviation
of price). During the performance of this task order, TTS may similarly
publish data related to project management (e.g. user stories,
milestones, and performance metrics) and top-line spending data.

# 12.0 Attachments

[<span class="underline">See Addendum - Commercial Contract
Clauses</span>](https://github.com/18F/tts-buy-bug-bounty/blob/master/2018-procurement/Addendum%20-%20Commercial%20Contract%20Clauses.md)

[<span class="underline">Quality Assurance Surveillance
Plan</span>](QASP.md)
