**General Services Administration**

Federal Acquisition Service
Technology Transformation Services

1800 F St NW | Washington, DC | 20405

QUALITY ASSURANCE SURVEILLANCE PLAN (QASP)

Bug Bounty 2

TCTOA-18-0013

# 1.0 INTRODUCTION

This Quality Assurance Surveillance Plan (QASP) has been developed to
evaluate contractor actions while implementing the requirements within
Section 3.0 *Requirements* of the [<span class="underline">Request for
Quotation</span>](RFQ.md).
It is designed to provide an effective surveillance method of monitoring
contractor performance for each listed objective on the Performance
Requirements Matrix in the call order. It also provides a systematic
method to evaluate the services the contractor is required to furnish.

# 2.0 STANDARD

The contractor is responsible for management and quality control actions
to meet the terms of the contract. The role of the CO/COR is quality
assurance to ensure contract standards are achieved. The contractor
shall perform all work required in a satisfactory manner in accordance
with the requirements of the RFQ. The COR shall notify the CO for
appropriate action if it is likely that the contractor will not achieve
successful final delivery of the software code in accordance with the
performance objectives and acceptable quality levels (AQLs) identified
below.

## 2.1 Performance Requirements Matrix

The CO/COR will evaluate the performance objectives through surveillance
as reflected below by reviews and acceptance of work products and
services. Note that the performance requirements listed throughout the
length of the period of performance. Deliverable or Required Services
Performance Standard(s):

<table>
<thead>
<tr class="header">
<th><strong>Deliverable or Required Services</strong></th>
<th><strong>Performance Standard(s)</strong></th>
<th><strong>Acceptable Quality Level (AQL)</strong></th>
<th><strong>Method of Surveillance</strong></th>
</tr>
</thead>
<tbody>
<tr class="odd">
<td>Vulnerability Reports</td>
<td>Average time to assign to appropriate team with TTS</td>
<td><blockquote>
<p>95% assigned/tagged within 1 business day</p>
</blockquote></td>
<td>Timestamps within platform and information included in monthly report</td>
</tr>
<tr class="even">
<td>Vulnerability Reports</td>
<td>Average time-to-triage initial reports</td>
<td><blockquote>
<p>95% triaged within 1 business day</p>
</blockquote></td>
<td>Timestamps within platform and information included in monthly report</td>
</tr>
<tr class="odd">
<td>Vulnerability Reports</td>
<td>Minimal escalations</td>
<td>No more than 1% of reports result in escalations</td>
<td>Escalations observed via email, platform-specific escalation features, or other out-of-band communication with TTS staff about mistakes. Escalations where TTS determines that the vendor was correct originally do not apply to this metric.</td>
</tr>
<tr class="even">
<td>Impact Reports</td>
<td>Time to update appropriate team with TTS</td>
<td>Within 24 hours of any anticipated or known impact</td>
<td>Activities or issues outside of the contractor’s control may directly impact the contractor’s performance.</td>
</tr>
</tbody>
</table>


## 2.2 Procedures

The CO/COR, along with the TTS Product Owner, will inspect all tasks
required by the call order to ensure contractor compliance with the
solicitation requirements at the conclusion of every month.

At the conclusion of month, the CO/COR, along with the TTS Product
Owner, will review the reported vulnerabilities.

At the conclusion of the period of performance, a similar procedure will
be followed to document discrepancies and to assess overall performance.

If any of the services do not conform to the call order requirements,
the CO/COR may require the contractor to perform the services again in
conformity with solicitation requirements. The CO/COR shall not certify
satisfactory performance for the call order until all defects have been
corrected. When the defects in services cannot be corrected by
re-performance, the Government may:

1)  > Require the contractor to take necessary action to ensure that
    > future performance conforms to solicitation requirements; and,

2)  > Reduce the solicitation price to reflect the reduced value of the
    > services performed. The CO/COR shall, in addition to providing
    > documentation to the CO, maintain a complete quality assurance
    > file. The file will contain copies of all reports, evaluations,
    > recommendations, and any actions relating to the Government’s
    > performance of the quality assurance function, including originals
    > of all surveillance activity checklists. All such records will be
    > retained for the life of the call order. The CO/COR shall forward
    > these records to the CO at completion or termination of the call
    > order.


## 2.3 Acceptance of Services

Acceptance of services shall be based upon compliance with performance
standards described in the RFQ and surveillance procedures described in
this QASP. Before approving/certifying any contractor invoices, the
CO/COR will verify that all invoiced services have been performed in
compliance with call order requirements. The CO/COR shall not certify
satisfactory performance for the call order until all defects have been
corrected.

## 2.4 Non-Disclosure Agreement

All contractor key personnel, employees, agents, subcontractors and
subcontractor personnel who will have access to documents or data during
the performance of their duties under the contract shall execute the
attached Non-Disclosure Agreement and return it to the CO within 5
calendar days of award and before being given access to such information
or documents.
