# **Performance Based Quality Assurance Surveillance Plan (“QASP”)**

# **TTS Bug Bounty**

## 1.0 INTRODUCTION

This Quality Assurance Surveillance Plan ("QASP") has been developed to evaluate contractor actions while implementing [the Performance Work Statement](003_PWS.md) ("PWS"). It is designed to provide an effective surveillance method of monitoring contractor performance for each listed objective on the Performance Requirements Matrix in the call order. It also provides a systematic method to evaluate the services the contractor is required to furnish. 

## 2.0 STANDARD

The contractor is responsible for management and quality control actions to meet the terms of the contract. The role of the CO/COR is quality assurance to ensure contract standards are achieved. The contractor shall perform all work required in a satisfactory manner in accordance with the requirements of the PWS. The COR shall notify the CO for appropriate action if it is likely that the contractor will not achieve successful final delivery of the software code in accordance with the performance objectives and acceptable quality levels ("AQLs") identified below.

### 2.1 PERFORMANCE REQUIREMENTS MATRIX

The CO/COR will evaluate the performance objectives through surveillance as reflected below by reviews and acceptance of work products and services. Note that the performance requirements listed throughout the length of the period of performance. Deliverable or Required Services Performance Standard(s):

**Deliverable or Required Services** | **Performance Standard(s)** | **Acceptable Quality Level (AQL)** | **Method of Surveillance**
--- | --- | --- | ---
Vulnerability Reports | Average time-to-triage initial reports | > 95% triaged within 1 business day | Timestamps within platform and information included in monthly report
Vulnerability Reports | Triage accuracy | 90% of valid reports triaged correctly | TTS manual assessment of report triage and concurrence with the severity rating and category
Vulnerability Reports | Minimal false negatives | No more than 5% false negatives (valid reports improperly classified as invalid or duplicate) | TTS manual assessment of report triage and concurrence with the severity rating and category

### 2.2 PROCEDURES

The CO/COR, along with the TTS Product Owner, will inspect all tasks required by the call order to ensure contractor compliance with the solicitation requirements at the conclusion of every month. 

At the conclusion of month, the CO/COR, along with the TTS Product Owner, will review the reported vulnerabilities.
At the conclusion of the period of performance, a similar procedure will be followed to document discrepancies and to assess overall performance.

If any of the services do not conform to the call order requirements, the CO/COR may require the contractor to perform the services again in conformity with solicitation requirements. The CO/COR shall not certify satisfactory performance for the call order until all defects have been corrected. When the defects in services cannot be corrected by re-performance, the Government may:

1.  Require the contractor to take necessary action to ensure that future performance conforms to solicitation  requirements; and,

2.  Reduce the solicitation price to reflect the reduced value of the services performed. The CO/COR shall, in addition to providing documentation to the CO, maintain a complete quality assurance file. The file will contain copies of all reports, evaluations, recommendations, and any actions relating to the Government’s performance of the quality assurance function, including originals of all surveillance activity checklists. All such records will be retained for the life of the call order. The CO/COR shall forward these records to the CO at completion or termination of the call order.

### 2.3 ACCEPTANCE OF SERVICES

Acceptance of services shall be based upon compliance with performance standards described in the PWS and surveillance procedures described in this QASP. Before approving/certifying any contractor invoices, the CO/COR will verify that all invoiced services have been performed in compliance with call order requirements. The CO/COR shall not certify satisfactory performance for the call order until all defects have been corrected.

### 2.4 NON-DISCLOSURE AGREEMENT

All contractor key personnel, employees, agents, subcontractors and subcontractor personnel who will have access to documents or data during the performance of their duties under the contract shall execute the attached Non-Disclosure Agreement and return it to the CO within 5 calendar days of award and before being given access to such information or documents.

## 3.0 KICK-OFF and DAILY ACTIVITIES

### 3.1 Post Award Orientation Conference

The Government's team, CO/COR, and the TTS Product Owner will hold a Kick-Off Meeting/Post-Award Conference with the the contractor. Ideally, this will physically located in Washington, DC, but may be done virtually with contractor’s team and other relevant Government staff to review and clarify the project’s objectives, expectations from the Government, and address any questions the contractor may have. Discussion topics shall include, but not be limited to:

* Introduction of the contractor and Government Staff;

* Understanding of the workflow;

* Project management expectations;

* Agreement on communication methods; and

* Discussion of any other relevant specific concerns.

The Kick-Off Meeting/Post-Award Conference will take place within 10 calendar days from award. The contractor shall provide any finalized contractor Teaming Arrangements ("CTAs")/Subcontractor arrangements at this time.

### 3.2 Transition

During the transition to the Government, or a new contractor, the contractor shall perform all necessary transition activities. Expected transition activities may include, but not be limited to, continuation of full services to TTS and other customers; participation in meetings with the Government or new contractor to effect a smooth transition and provide detailed information on the operation of all deliverables, at CO/COR and the TTS Product Owner's discretion; training of new personnel, either Government or new contractor, during transition period; and appropriate close-out of any outstanding technical and related performance elements for this task.

Should the contractor be terminated prior to the end of the period of performance, the contractor shall transfer all project materials to the CO/COR and the TTS Product Owner within two weeks of the CO/COR and the TTS Product Owner’s request.

### 3.3 GSA AAS Business Systems (AASBS) Web Portal

The GSA AASBS (Assisted Acquisition Services Business Systems also known as IT Solutions Shop (ITSS)) web portal will be accessible to the contractor during the performance of the contract and be used in the administration of the contract. This web-based system at [https://portal.fas.gsa.gov/web/guest](https://portal.fas.gsa.gov/web/guest) shall be used by the contractor to upload status reports, deliverables, invoices, and to respond to inquiries. The contractor shall maintain a current account on this system.

### 3.4 Travel

No travel is anticipated or will be required as part of this task order.

### 3.5 Government Furnished Items

The Government will provide access to the Application Programming Interface and its underlying data at the time of award. No other hardware or software will be provided by the Government.

### 3.6 Place and Hours of Performance

The primary place of performance will be at the contractor’s facility. Work may be performed at GSA Headquarters at 1800 F St. NW, Washington, DC, and Alternate Sites. TTS is a distributed team, and as such, there is no anticipated need for travel. Any work done, whether onsite or offsite, must be covered by the fixed-rate agreed upon between the Government and contractor.

## 4.0 INVOICING & PAYMENT

The period of performance for each invoice shall be for one calendar month. The contractor shall submit only one invoice per month per order/contract.

*The Government reserves the right to audit, thus; the contractor shall keep on file all backup support documentation for travels as applicable.*

### 4.1 Content of Invoice

The contractor’s invoice will be submitted monthly for work performed the prior month. The contractor may invoice only for the services used in direct support of the contract. The invoice shall be submitted on official letterhead and shall include the following information at a minimum.

* Client Order ID Number

* ACT Number

* Prompt Payment Discount

* Remittance Address

* Period of Performance for Billing Period

* Point of Contact and Phone Number

* Invoice Amount

* Skill Level Name and Associated Skill Level Number (for Labor Hour)

* Actual Hours Worked During the Billing Period (for Labor Hour)

* Clearly indicate both the current invoice’s monthly “burn rate” and the total average monthly “burn rate” (for Labor Hour)

### 4.2 Invoice Submission

All invoicing shall be submitted by email to the COR and CO within 10 days after the end of the month. The contractor shall NOT submit any invoices directly to the GSA Finance Center. If the invoices are acceptable, then the CO/COR will approve them for payment and complete the information.

### 4.3 Final Invoice

Invoices for final payment must be so identified and submitted within 60 calendar days from contract completion and no further charges are to be billed. A copy of the written acceptance of contract completion must be attached to final invoices. The contractor shall request for an extension from the CO/COR for final invoices that may exceed the 60-day time frame.

The Government reserves the right to require certification by a CO/COR before payment is processed, if necessary.

### 4.4 Close-out

The contractor shall submit a final invoice within 60 calendar days after the end of the performance period. After the final invoice has been paid the contractor shall furnish a completed and signed Release of Claims (GSA Form 1142) to the CO. This release of claims is due with final invoice submission.
