# **Performance Work Statement (PWS)**

# **TTS Bug Bounty**

## 1.0 OBJECTIVES

With bug bounties becoming an established industry-wide best practice, TTS desires to establish one of its own. The TTS [vulnerability disclosure policy](https://18f.gsa.gov/vulnerability-disclosure-policy/) that was released in November 2016 outlines how researchers can report system vulnerabilities, while keeping personal and financial information safe. TTS wishes to incentivize security researchers and other interested users to report security issues directly to the system owner through the use of financial rewards - or, a bug bounty.

## 2.0 BACKGROUND

As part of its programmatic focus on security, TTS needs to purchase access to a pre-existing, commercially available Bug Bounty SaaS Platform that will allow it to launch and manage the TTS Bug Bounty program. This acquisition will give TTS access to a large network of security researchers, people who have an interest - both personally and financially - in helping to find and address bugs and other technical issues within TTS-owned web applications. While the Department of Defense has conducted a bug bounty program, this TTS program will be the first of its kind to be generated by a civilian (or non-DOD) federal agency. Only a select few small businesses are able to provide this Software-as-a-Service (“SaaS”) platform and that large network of researchers.

Bug bounties serve as a legal and social arrangement with the security community: bounty operators, like TTS, define what researchers are permitted to do in regards to discovering and reporting security issues of a production system, and in turn, researchers are assured they will not be punished for anything they do within that scope and are awarded for their findings.

While many in the research community are simply seeking to disclose vulnerabilities for recognition and out of goodwill alone, it is understood that there is a financial marketplace for unreported security issues in important systems. Where there are no legitimate means by which disclosure can occur and/or be acknowledged, there is a risk of a black marketplace taking the place of an open one. Bug bounties are a proven method of mitigating security risk in production systems: they incentivise researchers to report issues to the system owner who can fix them before they’re discovered by malicious actors.

By the very nature of a bug bounty program, a contractor that provides a Bug Bounty SaaS Platform that can achieve the goals of TTS while providing the best value to the government must be one that is well-established. The more well-known the provider of a Bug Bounty SaaS Platform, the larger and more talented the pool of security researchers they have in their community. The larger the community of security researchers in the Bug Bounty SaaS Platform provider’s network, the better the chance TTS has of finding bugs and technical issues within their web applications.

Beyond the software that makes up a SaaS Platform and the network of security researchers, a successful contractor will also need to have the ability to provide program management and triage services.

Program management services include services related to promotion of the program, tracking and workflow, and payouts. With thousands of competing bug bounty programs, the contractor must be able to emphasize the attractiveness of the TTS Bug Bounty program. There must also be a level of expertise in relation to how submissions will be received and how they will be managed throughout their lifecycle. Finally, for valid payouts, including the numerous small payments that will be made for the low-severity bugs that are found to be viable. By way of example, payouts average around $300, with dozens or even hundreds of payouts over the life of a program.

In terms of triage services, as mentioned, TTS has already received reports through the vulnerability policy. Successful bug bounty programs result in dozens of reports per month, but the signal-to-noise ratio is low. On average, only about 10% of submissions turn out to be valid. All submissions needs responses, however, or else there is a risk of alienating researchers. The workload of filtering submissions and communicating with researchers can be quite heavy. A successful contractor will, among other things, assign a severity-rating to each vulnerability (e.g., low, medium, high), provide responses to invalid reports, provide initial responses to valid reports, and forward valid reports to TTS within a reasonable time based on the severity.

Platforms typically provide triage services as a separate option, so this means that the acquisition will involve 3 components, all of which are necessary:

1.  The cost of access to the network and use of the SaaS platform;

2.  The cost of first-line triage and communication services; and,

3.  A “bounty pool” from which researchers are paid for valid reports.

## 3.0 SCOPE

The purpose of this solicitation is for the contractor to deliver a Bug Bounty program which TTS will utilize for TTS-owned web applications. The contractor will provide access to their Bug Bounty SaaS Platform for researchers to report vulnerabilities (“Platform/Network Access”) and allow TTS to manage and track issues across multiple public web applications, triage services for those reported vulnerabilities, disburse rewards for effective vulnerabilities, and explain the reasons behind rejections (“Vulnerability Report Triage Services”).

For the Platform Access, GSA IT has already begun the approval process for the three known contractors in the industry. For the Vulnerability Report Triage Services, they must be provided on a “per web application” basis, allowing TTS to operate a Bug Bounty for a web application independently of the other web applications that are utilizing the Platform/Network Access for their own tests. As part of these services, the contractor must provide staff who are specialists in reviewing vulnerability reports and communicating with researchers.

## 4.0 TASKS

The contractor will provide the following services:

* A Software-as-a-Service platform, with a publically available website, for researchers to report security vulnerabilities on publically available government websites in a manner consistent with the TTS Vulnerability Security Policy. The platform will:

	* Communicate the procedures of how to discover and report the security vulnerabilities on publically available government websites in manner consistent with the TTS Vulnerability Security Policy.

	* Advertise that there are available awards for successful vulnerability disclosure on stated the applications that 18F posts.

	* Provide a secure means for researchers to submit the site vulnerabilities they discover.

	* Ensure that researchers are aware of TTS Vulnerability Security Policy and any other relevant discovery or reporting procedures.

	* Permit TTS to post up to five concurrent (5) applications on the platform during the initial period of performance.

	* Permit TTS to add or remove any of the posted applications at any time during the period of performance.

	* Provide access to a network of security researchers and bounty hunters.

	* Provide a platform for TTS staff to view reported vulnerabilities and update their status as the issues are managed and resolved.

	* Support both public bounties (open to any researcher on the platform) and private, invite-only bounties (open to only researchers TTS and the vendor select).

* Triage of severity of reported vulnerabilities. The contractor will provide services to:

    * Screen reported vulnerabilities and filter out invalid and duplicate reports.

    * Classify vulnerabilities according to TTS guidelines developed for the vendor and assign them to the proper TTS staff, while TTS maintains the rights to update these guidelines at any time.

    * Communicate with researchers about their reports, escalating to TTS staff if needed.

* Bug bounty pool management:

    * Work with TTS to identify the proper scope of vulnerability identification, disclosure and assessment, controlling for risk. Also, criteria for most significant vulnerabilities will be established with the TTS before applications are advertised.

    * Work with TTS to identify the proper scope of vulnerability identification and ranking. With TTS assistance, determine, and/or adjust bounty reward tiers to manage our bounty pool most effectively.

    * Once classified and deemed within the scope of the vulnerabilities, the vendor will manage payout to the reporter based on the agreed up bounty reward tiers by the contractor and TTS.

   * Forward to TTS the vulnerability reports, the names of the researchers, and the award amounts.

The contractor will not be responsible to perform the following:

* For remedying discovered vulnerabilities.

## 5.0 ROLES & RESPONSIBILITIES

**Contracting Officer.** The Contracting Officer ("CO") is responsible for monitoring contract contract compliance, contract administration, and cost control and for resolving any differences between the observations documented by the Government and the contractor. The CO will designate, at a minimum, one (1) CO’s Representative ("COR") as the Government authority for performance management. The CO may, at their discretion, designate in writing any number of additional representatives to serve as technical inspectors depending on the complexity of the services measured as well as the contractor’s performance.

**Contracting Officer’s Representative and Alternate Contracting Officer’s Representative.** The COR is designated in writing by the CO to act as his or her authorized representative to assist in administering a contract. CO/COR limitations are contained in the written appointment letter. The CO/COR are responsible for technical administration of the project and ensure proper Government surveillance of the contractor’s performance. The COR is not empowered to make any contractual commitments or to authorize any contractual changes on the Government’s behalf. Any changes that the contractor deems may affect contract price, terms, or conditions shall be referred to the CO for action. The CO/COR will have the responsibility to document the inspection and evaluation of the contractor’s work performance. The CO/COR’s acceptance of the vendor product is dependant on the Product Owner’s approval.

**Product Owner (TTS).** The Product Owner is the project’s key stakeholder and is a member of  the TTS team. The Product Owner is responsible for advocating on behalf of the agency’s needs and responsible for decision-making during implementation. The Product Owner will work with the CO/COR to inspect vendor work.

## 6.0 OPERATIONAL REQUIREMENTS

### 6.1 Key Personnel

Contractor’s Technical Account Manager for this project must be listed as Key Personnel.

To ensure successful performance of the requirement, contractor shall satisfy the following:

A.  The contractor shall provide a Technical Account Manager ("TAM") as the primary point of contact for the government’s program office to enable timely problem resolution, reporting in a timely manner, and properly aligning staffing requirements. The contractor will be expected to work with the CO/COR and the TTS Product Owner.

B.  If any individual proposed as Key Personnel becomes unavailable during the course of the solicitation and evaluation process, the contractor shall notify the CO immediately. Any Key Personnel proposed who are not currently employed by the contractor shall be identified as such and an additional letters of intent signed by the proposed Key Personnel shall be provided that indicates that person's intent to be employed by the contractor if awarded this contract.

C.  The contractor agrees that through the duration of the base period of performance of the contract, no Key Personnel substitutions shall be made unless necessitated by an individual’s sudden illness, death, or termination of employment for cause. In any of such event, the contractor shall promptly notify the CO/COR and the TTS Product Owner and provide the information required by paragraphs below on the proposed replacement for Government approval.

D.  All requests for substitutions/additions of Key Personnel must include a detailed explanation of the circumstances necessitating the proposed substitution or addition. As determined by the CO, all proposed substitutes/additions must have qualifications that meet or exceed the qualifications of the person to be replaced.

E.  The CO, or duly designated CO/COR and the TTS Product Owner, will evaluate the request(s) for substitutions/additions of Key Personnel and the CO will notify the contractor, in writing, of approval or disapproval. Disapproval of the proposed individual(s) shall not provide grounds for non-performance by the contractor or form the basis of any claim for monies, delivery schedule extension, or any other equitable adjustment.

F.  Key Personnel must have a full understanding of the technical approach discussed in the Oral Presentations and delivered by the contractor after award. NOTE - the labor category proposed is at the contractor's discretion.

G.  Key Personnel will be a direct liaison to the CO/COR and the TTS Product Owner. Key Personnel shall be responsible for the supervision and management of the contractor’s personnel, technical assistance, and interface.

### 6.2 Deliverables

#### 6.2.1 Vulnerability Reports

The contractor will submit through their security disclosure platform vulnerability reports for those on the TTS application list. These vulnerabilities will be triaged and classified based on the severity of the vulnerability before submitted to TTS.

#### 6.2.2 Monthly Status Reports

At the conclusion of each month, the contractor will submit a status report summarizing the contractor’s work and submit it to the the CO/COR and  the TTS Product Owner. This report will be mutually agreed to between the CO/COR, TTS Product Owner, and the contractor.

#### 6.2.3 Impact Reports

The contractor shall be responsible for providing timely notification to the CO/COR and the TTS Product Owner when activities or issues outside of the contractor’s control may directly impact the contractor’s performance. This notification shall be provided in writing or via email within 24 hours of any anticipated or known impact.

#### 6.2.4 List of Deliverables

**Deliverable** | **Due date** | **Description**
--- | --- | ---
Vulnerability reports delivered through the bug bounty platform | Within one business day of the researcher reporting the vulnerability. | Through the platform, the contractor will alert TTS that there is a triaged vulnerability report pending on one of the listed applications.
Monthly status reports | At the end of each month of the period of performance | Monthly report of the metrics of the contractor delivered in a format to be agreed upon by the TTS Product Owner and the Contractor.
Impact Reports| Within 24 hours of any anticipated or known impact | Activities or issues outside of the contractor’s control may directly impact the contractor’s performance.

The contractor shall submit all deliverables to CO/COR and TTS Product Owner.

#### 6.2.5 Quality Assurance

The Government will use [the attached Quality Assurance Surveillance Plan](004_QASP.md) (QASP) to monitor the contractor’s performance. The QASP will provide oversight help to ensure that service levels reach and maintain the required levels for performance of this task. The QASP is a living document and may be updated by the Government as necessary. Any updates to the QASP will be provided to the contractor. If needed, the draft QASP will be updated within 10 business days of contract kick off meeting by TTS Product Lead and/or the COR.

## 7.0 TERMS AND CONDITIONS

### 7.1 Administration Points of Contact

The following Points of Contact ("POC") are applicable to this contract: 

1.  Contracting Officer ("CO"): Michelle McNellis Technology Transformation Services, Acquisitions, [michelle.mcnellis@gsa.gov](mailto:michelle.mcnellis@gsa.gov)

2.  CO’s Representative ("COR"): Laura Gerhardt, GSA, Technology Transformation Services, [laura.gerhardt@gsa.gov](mailto:laura.gerhardt@gsa.gov)

3.  TTS Product Owner ("PO"): Jacob Kaplan-Moss, GSA, Technology Transformation Services, [jacob.kaplan-moss@gsa.gov](mailto:jacob.kaplan-moss@gsa.gov)
