# **Addendum: Commercial Contract Clauses**

# **TTS Bug Bounty**

## Section 508 Compliance

The contractor shall support the Government in its conformance with Section 508 throughout the development and implementation of the work to be performed.

Section 508 of the Rehabilitation Act of 1973, as amended (29 U.S.C. 794d) requires that when Federal agencies develop, procure, maintain, or use electronic information technology, Federal employees with disabilities have access to and use of information and data that is comparable to the access and use by Federal employees who do not have disabilities, unless an undue burden would be imposed on the agency. Section 508 also requires that individuals with disabilities, who are members of the public seeking information or services from a Federal agency, have access to and use of information and data that is comparable to that provided to the public who are not individuals with disabilities, unless an undue burden would be imposed on the agency.

The following standard is applicable for compliance:

1194.22 Web-based Intranet and Internet Information and Applications.

The contractor should review the following websites for additional 508 information:

* [http://www.section508.gov/](http://www.section508.gov/)

* [http://www.access-board.gov/508.htm](http://www.access-board.gov/508.htm)

* [http://www.w3.org/WAI/Resources](http://www.w3.org/WAI/Resources)

## Internet Protocol Version 6 Compliance

IPv6 applies to this acquisition. Reference NIST 500-267 and NIST 500-281 for additional guidance on IPv6 requirements. A Supplier's Declaration of Conformity (SDOC) is required, as outlined in the two previous NIST documents. The template for the SDOC can be found at the following URL: [http://www-x.antd.nist.gov/usgv6/sdoc.html](http://www-x.antd.nist.gov/usgv6/sdoc.html).

**Note to potential offerros:** This addendum includes the commercial provisions and clauses required by [Part 12](https://www.acquisition.gov/far/current/html/FARTOCP12.html) of the Federal Acquisition Regulations (FAR) and [Part 512](https://www.acquisition.gov/?q=/browse/gsam/512/512Acquisition) of the General Services Acquisition Manual (GSAM). Although they may appear daunting, they are in line with the FAR’s guidance that commercial buys should line up as much as possible with customary commercial practices.  We are only including the full text where required -- everything else can be found via the links to the clauses that are incorporated by reference.

## Contract Provisions and Clauses Incorporated by Reference

### FAR 52.252-1 - Solicitation Provisions Incorporated by Reference (Feb 1998)

This solicitation incorporates one or more solicitation provisions by reference, with the same force and effect as if they were given in full text. Upon request, the Contracting Officer will make their full text available. The offeror is cautioned that the listed provisions may include blocks that must be completed by the offeror and submitted with its quotation or offer. In lieu of submitting the full text of those provisions, the offeror may identify the provision by paragraph identifier and provide the appropriate information with its quotation or offer. Also, the full text of a solicitation provision may be accessed electronically at this/these address(es):

Federal Acquisition Regulation:
[*https://www.acquisition.gov/far/current/html/FARTOCP52.html*](https://www.acquisition.gov/far/current/html/FARTOCP52.html)

GSA Acquisition Manual:
[*https://www.acquisition.gov/?q=browsegsam*](https://www.acquisition.gov/?q=browsegsam)

[*FAR 52.204-16 - Commercial and Government Entity Code Reporting (JULY 2016)*](https://www.acquisition.gov/sites/default/files/current/far/html/52_200_206.html#wp1152012)

**(End of Provision)**

### FAR 52.252-2 - Clauses Incorporated by Reference (Feb 1998)

This contract incorporates one or more clauses by reference, with the same force and effect as if they were given in full text. Upon request, the Contracting Officer will make their full text available. Also, the full text of a clause may be accessed electronically at this/these address(es):

Federal Acquisition Regulation:
[*https://www.acquisition.gov/far/current/html/FARTOCP52.html*](https://www.acquisition.gov/far/current/html/FARTOCP52.html)

GSA Acquisition Manual:
[*https://www.acquisition.gov/?q=browsegsam*](https://www.acquisition.gov/?q=browsegsam)

[*FAR 52.204-18 - Commercial and Government Entity Code Maintenance (JULY 2016)*](https://www.acquisition.gov/sites/default/files/current/far/html/52_200_206.html#wp1152565)

[*FAR 52.212-4 - Contract Terms and Conditions - Commercial items (JAN 2017)*](https://www.acquisition.gov/sites/default/files/current/far/html/52_212_213.html#wp1179465)

[*FAR 52.232-40 - Providing Accelerated Payments to Small Business Subcontractors (DEC 2013)*](https://www.acquisition.gov/sites/default/files/current/far/html/52_232.html#wp1160491)

[*GSAM 552.212-4 Alternate II (FAR Deviation)(July 2015) - Contract Terms and Conditions-Commercial Items*](https://www.acquisition.gov/?q=/browse/gsam/552/552Solicitation)

[*GSAM 552.232-39 (FAR Deviation)(July 2015) - Unenforceability of Unauthorized Obligations*](http://www.esi.mil/download.aspx?id=5726)

**(End of Provision)**

## Provisions Incorporated in Full Text

### 52.203-18 – Prohibition on Contracting with Entities that Require Certain Internal Confidentiality Agreements or Statements--Representation.

As prescribed in 3.909-3(a), insert the following provision:

Prohibition on Contracting with Entities that Require Certain Internal Confidentiality Agreements or Statements--Representation (Jan 2017)

(a) Definition. As used in this provision--

“Internal confidentiality agreement or statement”, “subcontract”, and “subcontractor”, are defined in the clause at 52.203-19, Prohibition on Requiring Certain Internal Confidentiality Agreements or Statements.

(b) In accordance with section 743 of Division E, Title VII, of the Consolidated and Further Continuing Appropriations Act, 2015 (Pub. L. 113-235) and its successor provisions in subsequent appropriations acts (and as extended in continuing resolutions), Government agencies are not permitted to use funds appropriated (or otherwise made available) for contracts with an entity that requires employees or subcontractors of such entity seeking to report waste, fraud, or abuse to sign internal confidentiality agreements or statements prohibiting or otherwise restricting such employees or subcontractors from lawfully reporting such waste, fraud, or abuse to a designated investigative or law enforcement representative of a Federal department or agency authorized to receive such information.

(c) The prohibition in paragraph (b) of this provision does not contravene requirements applicable to Standard Form 312, (Classified Information Nondisclosure Agreement), Form 4414 (Sensitive Compartmented Information Nondisclosure Agreement), or any other form issued by a Federal department or agency governing the nondisclosure of classified information.

(d) Representation. By submission of its offer, the Offeror represents that it will not require its employees or subcontractors to sign or comply with internal confidentiality agreements or statements prohibiting or otherwise restricting such employees or subcontractors from lawfully reporting waste, fraud, or abuse related to the performance of a Government contract to a designated investigative or law enforcement representative of a Federal department or agency authorized to receive such information (e.g., agency Office of the Inspector General).

**(End of Provision)**

## Contract Clauses Incorporated in Full Text

### FAR 52.217-8 - Option to Extend Services (Nov 1999)

The Government may require continued performance of any services within the limits and at the rates specified in the contract. These rates may be adjusted only as a result of revisions to prevailing labor rates provided by the Secretary of Labor. The option provision may be exercised more than once, but the total extension of performance hereunder shall not exceed 6 months. The Contracting Officer may exercise the option by written notice to the Contractor within 10 calendar days before the contract expires.

**(End of Clause)**

### FAR 52.217-9 - Option to Extend the Term of the Contract (Mar 2000)

(a) The Government may extend the term of this contract by written notice to the Contractor within 5 days provided that the Government gives the Contractor a preliminary written notice of its intent to extend at least 15 days before the contract expires. The preliminary notice does not commit the Government to an extension.

(b) If the Government exercises this option, the extended contract shall be considered to include this option clause.

(c) The total duration of this contract, including the exercise of any options under this clause, shall not exceed 18 months.

**(End of Clause)**

### GSAR 552.217-71 – Notice Regarding Option(s) (Nov 1992)

GSA has included an option to extend the term of this contract in order to demonstrate the value it places on quality performance by providing a mechanism for continuing a contractual relationship with a successful Offeror that performs at a level which meets or exceeds GSA’s quality performance expectations as communicated to the Contractor, in writing, by the Contracting Officer or designated representative. When deciding whether to exercise the option, the Contracting Officer will consider the quality of the Contractor’s past performance under this contract in accordance with 48 CFR 517.207.

**(End of Clause)**

### 52.212-5 - Contract Terms and Conditions Required to Implement Statutes or Executive Orders - Commercial Items

As prescribed in 12.301(b)(4), insert the following clause:

Contract Terms and Conditions Required to Implement Statutes or Executive Orders -- Commercial Items (Jan 2017)

(a) The Contractor shall comply with the following Federal Acquisition Regulation (FAR) clauses, which are incorporated in this contract by reference, to implement provisions of law or Executive orders applicable to acquisitions of commercial items;

  (1) 52.209-10, Prohibition on Contracting with Inverted Domestic Corporations (Nov 2015)

  (2) 52.233-3, Protest After Award (AUG 1996) (31 U.S.C. 3553).

  (3) 52.233-4, Applicable Law for Breach of Contract Claim (OCT 2004) (Public Laws 108-77, 108-78 (19 U.S.C. 3805 note)).

  (4) 52.233-4, Applicable Law for Breach of Contract Claim (OCT 2004) (Public Laws 108-77, 108-78 (19 U.S.C. 3805 note)).

(b) The Contractor shall comply with the FAR clauses in this paragraph (b) that the contracting officer has indicated as being incorporated in this contract by reference to implement provisions of law or Executive orders applicable to acquisitions of commercial items:
    
  (1) 52.203-6, Restrictions on Subcontractor Sales to the Government (Sept 2006), with Alternate I (Oct 1995) (41 U.S.C. 4704 and 10 U.S.C. 2402).

  (4) 52.204-10, Reporting Executive compensation and First-Tier Subcontract Awards (Oct 2016) (Pub. L. 109-282) (31 U.S.C. 6101 note).

  (6) 52.204-14, Service Contract Reporting Requirements (Oct 2016) (Pub. L. 111-117, section 743 of Div. C).
   
  (8) 52.209-6, Protecting the Government’s Interest When Subcontracting with Contractors Debarred, Suspended, or Proposed for Debarment (Oct 2015) (31 U.S.C. 6101 note).
   
  (14) (i) 52.219-6, Notice of Total Small Business Aside (Nov 2011) (15 U.S.C. 644).
  
  (18) 52.219-13, Notice of Set-Aside of Orders (Nov 2011) (15 U.S.C. 644(r)).
   
  (19) 52.219-14, Limitations on Subcontracting (Nov 2011) (15 U.S.C. 637(a)(14)).
   
  (22) 52.219-28, Post Award Small Business Program Rerepresentation (Jul 2013) (15 U.S.C. 632(a)(2)).
   
  (25) 52.222-3, Convict Labor (June 2003) (E.O. 11755).
   
  (27) 52.222-21, Prohibition of Segregated Facilities (Apr 2015).
   
  (28) 52.222-26, Equal Opportunity (Sep 2016) (E.O. 11246).
   
  (29) 52.222-35, Equal Opportunity for Veterans (Oct 2015) (38 U.S.C. 4212).
   
  (30) 52.222-36, Equal Opportunity for Workers with Disabilities (Jul 2014) (29 U.S.C. 793).
   
  (31) 52.222-37, Employment Reports on Veterans (Feb 2016) (38 U.S.C. 4212).
   
  (32) 52.222-40, Notification of Employee Rights Under the National Labor Relations Act (Dec 2010) (E.O. 13496).
   
  (33) (i) 52.222-50, Combating Trafficking in Persons (Mar 2015) (22 U.S.C. chapter 78 and E.O. 13627).
  
  (34) 52.222-54, Employment Eligibility Verification (Oct 2015). (E. O. 12989).
   
  (44) 52.223-18, Encouraging Contractor Policies to Ban Text Messaging while Driving (Aug 2011) (E.O. 13513).
   
  (51) 52.225-13, Restrictions on Certain Foreign Purchases (Jun 2008) (E.O.’s, proclamations, and statutes administered by the Office of Foreign Assets Control of the Department of the Treasury).
   
  (57) 52.232-33, Payment by Electronic Funds Transfer— System for Award Management (Jul 2013) (31 U.S.C. 3332).
   
  (60) 52.239-1, Privacy or Security Safeguards (Aug 1996) (5 U.S.C. 552a).

(c) The Contractor shall comply with the FAR clauses in this paragraph (c), applicable to commercial services, that the Contracting Officer has indicated as being incorporated in this contract by reference to implement provisions of law or executive orders applicable to acquisitions of commercial items: (Not applicable.)

(d) Comptroller General Examination of Record The Contractor shall comply with the provisions of this paragraph (d) if this contract was awarded using other than sealed bid, is in excess of the simplified acquisition threshold, and does not contain the clause at 52.215-2, Audit and Records -- Negotiation.

  (1) The Comptroller General of the United States, or an authorized representative of the Comptroller General, shall have access to and right to examine any of the Contractor’s directly pertinent records involving transactions related to this contract.

  (2) The Contractor shall make available at its offices at all reasonable times the records, materials, and other evidence for examination, audit, or reproduction, until 3 years after final payment under this contract or for any shorter period specified in FAR Subpart 4.7, Contractor Records Retention, of the other clauses of this contract. If this contract is completely or partially terminated, the records relating to the work terminated shall be made available for 3 years after any resulting final termination settlement. Records relating to appeals under the disputes clause or to litigation or the settlement of claims arising under or relating to this contract shall be made available until such appeals, litigation, or claims are finally resolved.

  (3) As used in this clause, records include books, documents, accounting procedures and practices, and other data, regardless of type and regardless of form. This does not require the Contractor to create or maintain any record that the Contractor does not maintain in the ordinary course of business or pursuant to a provision of law.

(e)

  (1) Notwithstanding the requirements of the clauses in paragraphs (a), (b), (c) and (d) of this clause, the Contractor is not required to flow down any FAR clause, other than those in this paragraph (e)(1) in a subcontract for commercial items. Unless otherwise indicated below, the extent of the flow down shall be as required by the clause -
      
    (i) 52.203-13, Contractor Code of Business Ethics and Conduct (Oct 2015) (41 U.S.C. 3509).

    (ii) 52.219-8, Utilization of Small Business Concerns (Nov 2016) (15 U.S.C. 637(d)(2) and (3)), in all subcontracts that offer further subcontracting opportunities. If the subcontract (except subcontracts to small business concerns) exceeds $700,000 ($1.5 million for construction of any public facility), the subcontractor must include 52.219-8 in lower tier subcontracts that offer subcontracting opportunities.

     (iii) 52.222-17, Nondisplacement of Qualified Workers (May 2014) (E.O. 13495). Flow down required in accordance with paragraph (1) of FAR clause 52.222-17.

    (iv) 52.222-21, Prohibition of Segregated Facilities (Apr 2015).

    (v) 52.222-26, Equal Opportunity (Sep 2016) (E.O. 11246).

    (vi) 52.222-35, Equal Opportunity for Veterans (Oct 2015) (38 U.S.C. 4212).

    (vii) 52.222-36, Equal Opportunity for Workers with Disabilities (Jul 2014) (29 U.S.C. 793).

    (viii) 52.222-37, Employment Reports on Veterans (Feb 2016) (38 U.S.C. 4212).

    (ix) 52.222-40, Notification of Employee Rights Under the National Labor Relations Act (Dec 2010) (E.O. 13496). Flow down required in accordance with paragraph (f) of FAR clause 52.222-40.

    (x) 52.222-41, Service Contract Labor Standards (May 2014), (41 U.S.C. chapter 67).

    (xi) 52.222-50, Combating Trafficking in Persons (Mar 2015) (22 U.S.C. chapter 78 and E.O. 13627). Alternate I (Mar 2015) of 52.222-50 (22 U.S.C. chapter 78 E.O. 13627).

    (xii) 52.222-51, Exemption from Application of the Service Contract Labor Standards to Contracts for Maintenance, Calibration, or Repair of Certain Equipment--Requirements (May 2014) (41 U.S.C. chapter 67.)

    (xiii) 52.222-53, Exemption from Application of the Service Contract Labor Standards to Contracts for Certain Services--Requirements (May 2014) (41 U.S.C. chapter 67)

    (xiv) 52.222-54, Employment Eligibility Verification (Oct 2015) (E. O. 12989).

    (xv) 52.222-55, Minimum Wages Under Executive Order 13658 (Dec 2015).

    (xvi) 52.222-60, Paycheck Transparency (Executive Order 13673) (Oct 2016).

    (xvii) 52.225-26, Contractors Performing Private Security Functions Outside the United States (Oct 2016) (Section 862, as amended, of the National Defense Authorization Act for Fiscal Year 2008; 10 U.S.C. 2302 Note).

    (xviii) 52.226-6, Promoting Excess Food Donation to Nonprofit Organizations. (May 2014) (42 U.S.C. 1792). Flow down required in accordance with paragraph (e) of FAR clause 52.226-6.

    (xix) 52.247-64, Preference for Privately-Owned U.S. Flag Commercial Vessels (Feb 2006) (46 U.S.C. Appx 1241(b) and 10 U.S.C. 2631). Flow down required in accordance with paragraph (d) of FAR clause 52.247-64.

  (2)While not required, the Contractor may include in its subcontracts for commercial items a minimal number of additional clauses necessary to satisfy its contractual obligations.

**(End of Clause)**

**Note to Potential Offerors:** Because SAM.gov registration is required for this contract, the only section of this clause that will affect you is highlighted in red.  The rest of the clause is required by the FAR to be included in full text, but you have already taken care of this by registering and maintaining your sam.gov account.

### 52.212-3 Offeror Representations and Certifications -- Commercial Items (Jan 2017)

**The offeror shall complete only paragraphs (b) of this provision if the Offeror has completed the annual representations and certification electronically via the System for Award Management (SAM) Web site accessed through [http://www.sam.gov/portal](http://www.sam.gov/portal).** The offeror shall complete only paragraphs (b) of this provision if the Offeror has completed the annual representations and certification electronically via the System for Award Management (SAM) Web site located at [http://www.sam.gov/portal](http://www.sam.gov/portal). If the Offeror has not completed the annual representations and certifications electronically, the Offeror shall complete only paragraphs (c) through (u) of this provision.

(a) Definitions. As used in this provision -

“Administrative merits determination” means certain notices or findings of labor law violations issued by an enforcement agency following an investigation. An administrative merits determination may be final or be subject to appeal or further review. To determine whether a particular notice or finding is covered by this definition, it is necessary to consult section II.B. in the DOL Guidance.

“Arbitral award or decision” means an arbitrator or arbitral panel determination that a labor law violation occurred, or that enjoined or restrained a violation of labor law. It includes an award or decision that is not final or is subject to being confirmed, modified, or vacated by a court, and includes an award or decision resulting from private or confidential proceedings. To determine whether a particular award or decision is covered by this definition, it is necessary to consult section II.B. in the DOL Guidance.

“Civil judgment” means -

  (1) In paragraph (h) of this provision: A judgment or finding of a civil offense by any court of competent jurisdiction.

  (2) In paragraph (s) of this provision: Any judgment or order entered by any Federal or State court in which the court determined that a labor law violation occurred, or enjoined or restrained a violation of labor law. It includes a judgment or order that is not final or is subject to appeal. To determine whether a particular judgment or order is covered by this definition, it is necessary to consult section II.B. in the DOL Guidance.

“DOL Guidance” means the Department of Labor (DOL) Guidance entitled: “Guidance for Executive Order 13673, ‘Fair Pay and Safe Workplaces’ “. The DOL Guidance, dated August 25, 2016, can be obtained from [https://www.dol.gov/fairpayandsafeworkplaces](https://www.dol.gov/asp/fairpayandsafeworkplaces/).

“Economically disadvantaged women-owned small business (EDWOSB) concern” means a small business concern that is at least 51 percent directly and unconditionally owned by, and the management and daily business operations of which are controlled by, one or more women who are citizens of the United States and who are economically disadvantaged in accordance with 13 CFR part 127. It automatically qualifies as a women-owned small business eligible under the WOSB Program.

“Enforcement agency” means any agency granted authority to enforce the Federal labor laws. It includes the enforcement components of DOL (Wage and Hour Division, Office of Federal Contract Compliance Programs, and Occupational Safety and Health Administration), the Equal Employment Opportunity Commission, the Occupational Safety and Health Review Commission, and the National Labor Relations Board. It also means a State agency designated to administer an OSHA-approved State Plan, but only to the extent that the State agency is acting in its capacity as administrator of such plan. It does not include other Federal agencies which, in their capacity as contracting agencies, conduct investigations of potential labor law violations. The enforcement agencies associated with each labor law under E.O. 13673 are--

(1) Department of Labor Wage and Hour Division (WHD) for--

  (i) The Fair Labor Standards Act;

  (ii) The Migrant and Seasonal Agricultural Worker Protection Act;

  (iii) 40 U.S.C. chapter 31, subchapter IV, formerly known as the Davis-Bacon Act;

  (v) 41 U.S.C. chapter 67, formerly known as the Service Contract Act;

  (vi) The Family and Medical Leave Act; and

  (vii) E.O. 13658 of February 12, 2014 (Establishing a Minimum Wage for Contractors);

(2) Department of Labor Occupational Safety and Health Administration (OSHA) for--

  (i) The Occupational Safety and Health Act of 1970; and

  (ii) OSHA-approved State Plans;

(4) Department of Labor Office of Federal Contract Compliance Programs (OFCCP) for--

  (i) Section 503 of the Rehabilitation Act of 1973;

  (ii) The Vietnam Era Veterans' Readjustment Assistance Act of 1972 and the Vietnam Era Veterans' Readjustment Assistance Act of 1974; and

  (iii) E.O. 11246 of September 24, 1965 (Equal Employment Opportunity);

(5) National Labor Relations Board (NLRB) for the National Labor Relations Act; and

(6) Equal Employment Opportunity Commission (EEOC) for--

  (i) Title VII of the Civil Rights Act of 1964;

  (ii) The Americans with Disabilities Act of 1990;

  (iii) The Age Discrimination in Employment Act of 1967; and

  (iv) Section 6(d) of the Fair Labor Standards Act (Equal Pay Act).

“Forced or indentured child labor” means all work or service—

  (1) Exacted from any person under the age of 18 under the menace of any penalty for its nonperformance and for which the worker does not offer himself voluntarily; or

  (2) Performed by any person under the age of 18 pursuant to a contract the enforcement of which can be accomplished by process or penalties.

“Highest-level owner” means the entity that owns or controls an immediate owner of the offeror, or that owns or controls one or more entities that control an immediate owner of the offeror. No entity owns or exercises control of the highest level owner.

“Immediate owner” means an entity, other than the offeror, that has direct control of the offeror. Indicators of control include, but are not limited to, one or more of the following: Ownership or interlocking management, identity of interests among family members, shared facilities and equipment, and the common use of employees.

“Inverted domestic corporation,” means a foreign incorporated entity that meets the definition of an inverted domestic corporation under 6 U.S.C. 395(b), applied in accordance with the rules and definitions of 6 U.S.C. 395(c).

“Labor compliance agreement” means an agreement entered into between a contractor or subcontractor and an enforcement agency to address appropriate remedial measures, compliance assistance, steps to resolve issues to increase compliance with the labor laws, or other related matters.

“Labor laws” means the following labor laws and E.O.s:

  (1) The Fair Labor Standards Act.

  (2) The Occupational Safety and Health Act (OSHA) of 1970.

  (3) The Migrant and Seasonal Agricultural Worker Protection Act.

  (4) The National Labor Relations Act.

  (5) 40 U.S.C. chapter 31, subchapter IV, formerly known as the Davis-Bacon Act.

  (6) 41 U.S.C. chapter 67, formerly known as the Service Contract Act.

  (7) E.O. 11246 of September 24, 1965 (Equal Employment Opportunity).

  (8) Section 503 of the Rehabilitation Act of 1973.

  (9) The Vietnam Era Veterans' Readjustment Assistance Act of 1972 and the Vietnam Era Veterans' Readjustment Assistance Act of 1974.

  (10) The Family and Medical Leave Act.

  (11) Title VII of the Civil Rights Act of 1964.

  (12) The Americans with Disabilities Act of 1990.

  (13) The Age Discrimination in Employment Act of 1967.

  (14) E.O. 13658 of February 12, 2014 (Establishing a Minimum Wage for Contractors).

  (15) Equivalent State laws as defined in the DOL Guidance. (The only equivalent State laws implemented in the FAR are OSHA-approved State Plans, which can be found at www.osha.gov/dcsp/osp/approved_state_plans.html).

“Labor law decision” means an administrative merits determination, arbitral award or decision, or civil judgment, which resulted from a violation of one or more of the laws listed in the definition of “labor laws”.

“Manufactured end product” means any end product in product and service codes (PSCs) 1000-9999, except - 

  (1) PSC 5510, Lumber and Related Basic Wood Materials;

  (2) Product or Service Group (PSG) 87, Agricultural Supplies;

  (3) PSG 88, Live Animals;

  (4) PSG 89, Subsistence;

  (5) PSC 9410, Crude Grades of Plant Materials;

  (6) PSC 9430, Miscellaneous Crude Animal Products, Inedible;

  (7) PSC 9440, Miscellaneous Crude Agricultural and Forestry Products;

  (8) PSC 9610, Ores;

  (9) PSC 9620, Minerals, Natural and Synthetic; and

  (10) PSC 9630, Additive Metal Materials.

“Place of manufacture” means the place where an end product is assembled out of components, or otherwise made or processed from raw materials into the finished product that is to be provided to the Government. If a product is disassembled and reassembled, the place of reassembly is not the place of manufacture.

“Predecessor” means an entity that is replaced by a successor and includes any predecessors of the predecessor.

“Restricted business operations” means business operations in Sudan that include power production activities, mineral extraction activities, oil-related activities, or the production of military equipment, as those terms are defined in the Sudan Accountability and Divestment Act of 2007 (Pub. L. 110-174). Restricted business operations do not include business operations that the person (as that term is defined in Section 2 of the Sudan Accountability and Divestment Act of 2007) conducting the business can demonstrate—

  (1) Are conducted under contract directly and exclusively with the regional government of southern Sudan;

  (2) Are conducted pursuant to specific authorization from the Office of Foreign Assets Control in the Department of the Treasury, or are expressly exempted under Federal law from the requirement to be conducted under such authorization;

  (3) Consist of providing goods or services to marginalized populations of Sudan;

  (4) Consist of providing goods or services to an internationally recognized peacekeeping force or humanitarian organization;

  (5) Consist of providing goods or services that are used only to promote health or education; or

  (6) Have been voluntarily suspended.

Sensitive technology -

  (1) Means hardware, software, telecommunications equipment, or any other technology that is to be used specifically—

    (i)  To restrict the free flow of unbiased information in Iran; or

    (ii) To disrupt, monitor, or otherwise restrict speech of the people of Iran; and

  (2) Does not include information or informational materials the export of which the President does not have the authority to regulate or prohibit pursuant to section 203(b)(3) of the International Emergency Economic Powers Act (50 U.S.C. 1702(b)(3)).

“Service-disabled veteran-owned small business concern” -

  (1) Means a small business concern-

    (i)  Not less than 51 percent of which is owned by one or more service-disabled veterans or, in the case of any publicly owned business, not less than 51 percent of the stock of which is owned by one or more service-disabled veterans; and

    (ii) The management and daily business operations of which are controlled by one or more service-disabled veterans or, in the case of a service-disabled veteran with permanent and severe disability, the spouse or permanent caregiver of such veteran.

  (2) Service-disabled veteran means a veteran, as defined in 38 U.S.C. 101(2), with a disability that is service-connected, as defined in 38 U.S.C. 101(16).

“Small business concern” means a concern, including its affiliates, that is independently owned and operated, not dominant in the field of operation in which it is bidding on Government contracts, and qualified as a small business under the criteria in 13 CFR Part 121 and size standards in this solicitation.

“Small disadvantaged business concern, consistent with 13 CFR 124.1002,” means a small business concern under the size standard applicable to the acquisition, that--

  (1) Is at least 51 percent unconditionally and directly owned (as defined at 13 CFR 124.105) by -

    (i)  One or more socially disadvantaged (as defined at 13 CFR 124.103) and economically disadvantaged (as defined at 13 CFR 124.104) individuals who are citizens of the United States; and

    (ii) Each individual claiming economic disadvantage has a net worth not exceeding $750,000 after taking into account the applicable exclusions set forth at 13 CFR 124.104(c)(2); and

  (2) The management and daily business operations of which are controlled (as defined at 13.CFR 124.106) by individuals, who meet the criteria in paragraphs (1)(i) and (ii) of this definition.

“Subsidiary” means an entity in which more than 50 percent of the entity is owned -

  (1) Directly by a parent corporation; or

  (2) Through another subsidiary of a parent corporation.

“Successor” means an entity that has replaced a predecessor by acquiring the assets and carrying out the affairs of the predecessor under a new name (often through acquisition or merger). The term “successor” does not include new offices/divisions of the same company or a company that only changes its name. The extent of the responsibility of the successor for the liabilities of the predecessor may vary, depending on State law and specific circumstances.

“Veteran-owned small business concern” means a small business concern-

  (1) Not less than 51 percent of which is owned by one or more veterans(as defined at 38 U.S.C. 101(2)) or, in the case of any publicly owned business, not less than 51 percent of the stock of which is owned by one or more veterans; and

  (2) The management and daily business operations of which are controlled by one or more veterans.

“Women-owned business concern” means a concern which is at least 51 percent owned by one or more women; or in the case of any publicly owned business, at least 51 percent of the its stock is owned by one or more women; and whose management and daily business operations are controlled by one or more women.

“Women-owned small business concern” means a small business concern  -

  (1) That is at least 51 percent owned by one or more women or, in the case of any publicly owned business, at least 51 percent of the stock of which is owned by one or more women; and

  (2) Whose management and daily business operations are controlled by one or more women.

“Women-owned small business (WOSB) concern eligible under the WOSB Program (in accordance with 13 CFR part 127),” means a small business concern that is at least 51 percent directly and unconditionally owned by, and the management and daily business operations of which are controlled by, one or more women who are citizens of the United States.

**Note to paragraph (a):** By a court order issued on October 24, 2016, the following definitions in this paragraph (a) are enjoined indefinitely as of the date of the order: “Administrative merits determination”, “Arbitral award or decision”, paragraph (2) of “Civil judgment”, “DOL Guidance”, “Enforcement agency”, “Labor compliance agreement”, “Labor laws”, and “Labor law decision”. The enjoined definitions will become effective immediately if the court terminates the injunction. At that time, DoD, GSA, and NASA will publish a document in the Federal Register advising the public of the termination of the injunction.

**(b)**

  **(1) Annual Representations and Certifications. Any changes provided by the offeror in paragraph (b)(2) of this provision do not automatically change the representations and certifications posted on the SAM website.**

  **(2) The offeror has completed the annual representations and certifications electronically via the SAM website accessed through [https://www.acquisition.gov/](https://www.acquisition.gov/). After reviewing the SAM database information, the offeror verifies by submission of this offer that the representation and certifications currently posted electronically at FAR 52.212-3, Offeror Representations and Certifications—Commercial Items, have been entered or updated in the last 12 months, are current, accurate, complete, and applicable to this solicitation (including the business size standard applicable to the NAICS code referenced for this solicitation), as of the date of this offer and are incorporated in this offer by reference (see FAR 4.1201), except for paragraphs ____________. [Offeror to identify the applicable paragraphs at (c) through (u) of this provision that the offeror has completed for the purposes of this solicitation only, if any. These amended representation(s) and/or certification(s) are also incorporated in this offer and are current, accurate, and complete as of the date of this offer. Any changes provided by the offeror are applicable to this solicitation only, and do not result in an update to the representations and certifications posted electronically on SAM.]**

(c) Offerors must complete the following representations when the resulting contract is to be performed in the United States or its outlying areas. Check all that apply.

  (1) Small business concern. The offeror represents as part of its offer that it [ ] is, [ ] is not a small business concern.

  (2) Veteran-owned small business concern. [Complete only if the offeror represented itself as a small business concern in paragraph (c)(1) of this provision.] The offeror represents as part of its offer that it [ ] is, [ ] is not a veteran-owned small business concern.

  (3) Service-disabled veteran-owned small business concern. [Complete only if the offeror represented itself as a veteran-owned small business concern in paragraph (c)(2) of this provision.] The offeror represents as part of its offer that it [ ] is, [ ] is not a service-disabled veteran-owned small business concern.

  (4) Small disadvantaged business concern. [Complete only if the offeror represented itself as a small business concern in paragraph (c)(1) of this provision.] The offeror represents that it [ ] is, [ ] is not, a small disadvantaged business concern as defined in 13 CFR 124.1002.

  (5) Women-owned small business concern. [Complete only if the offeror represented itself as a small business concern in paragraph (c)(1) of this provision.] The offeror represents that it [ ] is, [ ] is not a women-owned small business concern.

  **Note:** Complete paragraphs (c)(8) and (c)(9) only if this solicitation is expected to exceed the simplified acquisition threshold.

  (6) WOSB concern eligible under the WOSB Program. [Complete only if the offeror represented itself as a women-owned small business concern in paragraph (c)(5) of this provision.] The offeror represents that—

    (i) It [ ] is, [ ] is not a WOSB concern eligible under the WOSB Program, has provided all the required documents to the WOSB Repository, and no change in circumstances or adverse decisions have been issued that affects its eligibility; and

    (ii) It [ ] is, [ ] is not a joint venture that complies with the requirements of 13 CFR part 127, and the representation in paragraph (c)(6)(i) of this provision is accurate for each WOSB concern eligible under the WOSB Program participating in the joint venture. [The offeror shall enter the name or names of the WOSB concern eligible under the WOSB Program and other small businesses that are participating in the joint venture: _________.] Each WOSB concern eligible under the WOSB Program participating in the joint venture shall submit a separate signed copy of the WOSB representation.

  (7) Economically disadvantaged women-owned small business (EDWOSB) concern. [Complete only if the offeror represented itself as a WOSB concern eligible under the WOSB Program in (c)(6) of this provision.] The offeror represents that —

    (i) It [ ] is, [ ] is not an EDWOSB concern, has provided all the required documents to the WOSB Repository, and no change in circumstances or adverse decisions have been issued that affects its eligibility; and

    (ii) It [ ] is, [ ] is not a joint venture that complies with the requirements of 13 CFR part 127, and the representation in paragraph (c)(7)(i) of this provision is accurate for each EDWOSB concern participating in the joint venture. [The offeror shall enter the name or names of the EDWOSB concern and other small businesses that are participating in the joint venture: _____________.] Each EDWOSB concern participating in the joint venture shall submit a separate signed copy of the EDWOSB representation.

  (8) Women-owned business concern (other than small business concern). [Complete only if the offeror is a women-owned business concern and did not represent itself as a small business concern in paragraph (c)(1) of this provision.] The offeror represents that it [ ] is, a women-owned business concern.

  (9) Tie bid priority for labor surplus area concerns. If this is an invitation for bid, small business offerors may identify the labor surplus areas in which costs to be incurred on account of manufacturing or production (by offeror or first-tier subcontractors) amount to more than 50 percent of the contract price: __________________________________________.

  (10) HUBZone small business concern. [Complete only if the offeror represented itself as a small business concern in paragraph (c)(1) of this provision.] The offeror represents, as part of its offer, that -

    (i) It [ ] is, [ ] is not a HUBZone small business concern listed, on the date of this representation, on the List of Qualified HUBZone Small Business Concerns maintained by the Small Business Administration, and no material changes in ownership and control, principal office, or HUBZone employee percentage have occurred since it was certified in accordance with 13 CFR part 126; and

    (ii) It [ ] is, [ ] is not a HUBZone joint venture that complies with the requirements of 13 CFR part 126, and the representation in paragraph (c)(10)(i) of this provision is accurate for each HUBZone small business concern participating in the HUBZone joint venture. [The offeror shall enter the names of each of the HUBZone small business concerns participating in the HUBZone joint venture: __________.] Each HUBZone small business concern participating in the HUBZone joint venture shall submit a separate signed copy of the HUBZone representation.

(d) Representations required to implement provisions of Executive Order 11246 -

  (1) Previous contracts and compliance. The offeror represents that -

    (i)  It [ ] has, [ ] has not, participated in a previous contract or subcontract subject to the Equal Opportunity clause of this solicitation; and

    (ii) It [ ] has, [ ] has not, filed all required compliance reports.

(2) Affirmative Action Compliance. The offeror represents that  -

    (i)  It [ ] has developed and has on file, [ ] has not developed and does not have on file, at each establishment, affirmative action programs required by rules and regulations of the Secretary of Labor (41 CFR parts 60-1 and 60-2), or

    (ii) It [ ] has not previously had contracts subject to the written affirmative action programs requirement of the rules and regulations of the Secretary of Labor.

(e) Certification Regarding Payments to Influence Federal Transactions (31 U.S.C. 1352). (Applies only if the contract is expected to exceed $150,000.) By submission of its offer, the offeror certifies to the best of its knowledge and belief that no Federal appropriated funds have been paid or will be paid to any person for influencing or attempting to influence an officer or employee of any agency, a Member of Congress, an officer or employee of Congress or an employee of a Member of Congress on his or her behalf in connection with the award of any resultant contract. If any registrants under the Lobbying Disclosure Act of 1995 have made a lobbying contact on behalf of the offeror with respect to this contract, the offeror shall complete and submit, with its offer, OMB Standard Form LLL, Disclosure of Lobbying Activities, to provide the name of the registrants. The offeror need not report regularly employed officers or employees of the offeror to whom payments of reasonable compensation were made.

(f) Buy American Certificate. (Applies only if the clause at Federal Acquisition Regulation (FAR) 52.225-1, Buy American – Supplies, is included in this solicitation.)

  (1) The offeror certifies that each end product, except those listed in paragraph (f)(2) of this provision, is a domestic end product and that for other than COTS items, the offeror has considered components of unknown origin to have been mined, produced, or manufactured outside the United States. The offeror shall list as foreign end products those end products manufactured in the United States that do not qualify as domestic end products, i.e., an end product that is not a COTS item and does not meet the component test in paragraph (2) of the definition of “domestic end product.” The terms “commercially available off-the-shelf (COTS) item,” “component,” “domestic end product,” “end product,” “foreign end product,” and “United States” are defined in the clause of this solicitation entitled “Buy American—Supplies.”

  (2) Foreign End Products:

LINE ITEM NO. | COUNTRY OF ORIGIN
--- | ---
_______________ | _______________
_______________ | _______________
_______________ | _______________
[List as necessary]

  (3) The Government will evaluate offers in accordance with the policies and procedures of FAR Part 25.

(g)

  (1) Buy American -- Free Trade Agreements -- Israeli Trade Act Certificate. (Applies only if the clause at FAR 52.225-3, Buy American -- Free Trade Agreements -- Israeli Trade Act, is included in this solicitation.)

    (i) The offeror certifies that each end product, except those listed in paragraph (g)(1)(ii) or (g)(1)(iii) of this provision, is a domestic end product and that for other than COTS items, the offeror has considered components of unknown origin to have been mined, produced, or manufactured outside the United States. The terms “Bahrainian, Moroccan, Omani, Panamanian, or Peruvian end product,” “commercially available off-the-shelf (COTS) item,” “component,” “domestic end product,” “end product,” “foreign end product,” “Free Trade Agreement country,” “Free Trade Agreement country end product,” “Israeli end product,” and “United States” are defined in the clause of this solicitation entitled “Buy American--Free Trade Agreements--Israeli Trade Act.”

    (ii) The offeror certifies that the following supplies are Free Trade Agreement country end products (other than Bahrainian, Moroccan, Omani, Panamanian, or Peruvian end products) or Israeli end products as defined in the clause of this solicitation entitled “Buy American—Free Trade Agreements—Israeli Trade Act”:

    Free Trade Agreement Country End Products (Other than Bahrainian, Moroccan, Omani, Panamanian, or Peruvian End Products) or Israeli End Products:

LINE ITEM NO. | COUNTRY OF ORIGIN
--- | ---
_______________ | _______________
_______________ | _______________
_______________ | _______________
[List as necessary]

    (iii) The offeror shall list those supplies that are foreign end products (other than those listed in paragraph (g)(1)(ii) or this provision) as defined in the clause of this solicitation entitled “Buy American—Free Trade Agreements—Israeli Trade Act.” The offeror shall list as other foreign end products those end products manufactured in the United States that do not qualify as domestic end products, i.e., an end product that is not a COTS item and does not meet the component test in paragraph (2) of the definition of “domestic end product.”

Other Foreign End Products:

LINE ITEM NO. | COUNTRY OF ORIGIN
--- | ---
_______________ | _______________
_______________ | _______________
_______________ | _______________
[List as necessary]

    (iv) The Government will evaluate offers in accordance with the policies and procedures of FAR Part 25.

  (2) Buy American—Free Trade Agreements—Israeli Trade Act Certificate, Alternate I. If Alternate I to the clause at FAR 52.225-3 is included in this solicitation, substitute the following paragraph (g)(1)(ii) for paragraph (g)(1)(ii) of the basic provision:

    (g)(1)(ii) The offeror certifies that the following supplies are Canadian end products as defined in the clause of this solicitation entitled “Buy American-Free Trade Agreements-Israeli Trade Act”:

Canadian End Products:

LINE ITEM NO. | COUNTRY OF ORIGIN
--- | ---
_______________ | Canada
_______________ | Canada
_______________ | Canada
[List as necessary]

  (3) Buy American—Free Trade Agreements—Israeli Trade Act Certificate, Alternate II. If Alternate II to the clause at FAR 52.225-3 is included in this solicitation, substitute the following paragraph (g)(1)(ii) for paragraph (g)(1)(ii) of the basic provision:

    (g)(1)(ii) The offeror certifies that the following supplies are Canadian end products or Israeli end products as defined in the clause of this solicitation entitled “Buy American--Free Trade Agreements--Israeli Trade Act'':

Canadian or Israeli End Products:

LINE ITEM NO. | COUNTRY OF ORIGIN
--- | ---
_______________ | _______________
_______________ | _______________
_______________ | _______________
[List as necessary]

  (4) Buy American—Free Trade Agreements—Israeli Trade Act Certificate, Alternate III. If Alternate III to the clause at 52.225-3 is included in this solicitation, substitute the following paragraph (g)(1)(ii) for paragraph (g)(1)(ii) of the basic provision:

    (g)(1)(ii) The offeror certifies that the following supplies are Free Trade Agreement country end products (other than Bahrainian, Korean, Moroccan, Omani, Panamanian, or Peruvian end products) or Israeli end products as defined in the clause of this solicitation entitled “Buy American—Free Trade Agreements—Israeli Trade Act”:

Free Trade Agreement Country End Products (Other than Bahrainian, Korean, Moroccan, Omani, Panamanian, or Peruvian End Products) or Israeli End Products:

LINE ITEM NO. | COUNTRY OF ORIGIN
--- | ---
_______________ | _______________
_______________ | _______________
_______________ | _______________
[List as necessary]

  (5) Trade Agreements Certificate. (Applies only if the clause at FAR 52.225-5, Trade Agreements, is included in this solicitation.)

    (i) The offeror certifies that each end product, except those listed in paragraph (g)(5)(ii) of this provision, is a U.S.-made or designated country end product as defined in the clause of this solicitation entitled “Trade Agreements.”

    (ii) The offeror shall list as other end products those end products that are not U.S.-made or designated country end products.

Other End Products

LINE ITEM NO. | COUNTRY OF ORIGIN
--- | ---
_______________ | _______________
_______________ | _______________
_______________ | _______________
[List as necessary]

    (iii) The Government will evaluate offers in accordance with the policies and procedures of FAR Part 25. For line items covered by the WTO GPA, the Government will evaluate offers of U.S.-made or designated country end products without regard to the restrictions of the Buy American statute. The Government will consider for award only offers of U.S.-made or designated country end products unless the Contracting Officer determines that there are no offers for such products or that the offers for such products are insufficient to fulfill the requirements of the solicitation.

(h) Certification Regarding Responsibility Matters (Executive Order 12689). (Applies only if the contract value is expected to exceed the simplified acquisition threshold.) The offeror certifies, to the best of its knowledge and belief, that the offeror and/or any of its principals -

  (1) [ ] Are, [ ] are not presently debarred, suspended, proposed for debarment, or declared ineligible for the award of contracts by any Federal agency;

  (2) [ ] Have, [ ] have not, within a three-year period preceding this offer, been convicted of or had a civil judgment rendered against them for: commission of fraud or a criminal offense in connection with obtaining, attempting to obtain, or performing a Federal, state or local government contract or subcontract; violation of Federal or state antitrust statutes relating to the submission of offers; or commission of embezzlement, theft, forgery, bribery, falsification or destruction of records, making false statements, tax evasion, violating Federal criminal tax laws, or receiving stolen property; and

  (3) [ ] Are, [ ] are not presently indicted for, or otherwise criminally or civilly charged by a Government entity with, commission of any of these offenses enumerated in paragraph (h)(2) of this clause; and

  (4) [ ] Have, [ ] have not, within a three-year period preceding this offer, been notified of any delinquent Federal taxes in an amount that exceeds $3,500 for which the liability remains unsatisfied.

    (i) Taxes are considered delinquent if both of the following criteria apply:

      (A) The tax liability is finally determined. The liability is finally determined if it has been assessed. A liability is not finally determined if there is a pending administrative or judicial challenge. In the case of a judicial challenge to the liability, the liability is not finally determined until all judicial appeal rights have been exhausted.

      (B) The taxpayer is delinquent in making payment. A taxpayer is delinquent if the taxpayer has failed to pay the tax liability when full payment was due and required. A taxpayer is not delinquent in cases where enforced collection action is precluded.

    (ii) Examples.

      (A) The taxpayer has received a statutory notice of deficiency, under I.R.C. §6212, which entitles the taxpayer to seek Tax Court review of a proposed tax deficiency. This is not a delinquent tax because it is not a final tax liability. Should the taxpayer seek Tax Court review, this will not be a final tax liability until the taxpayer has exercised all judicial appear rights.
            
      (B) The IRS has filed a notice of Federal tax lien with respect to an assessed tax liability, and the taxpayer has been issued a notice under I.R.C. §6320 entitling the taxpayer to request a hearing with the IRS Office of Appeals Contesting the lien filing, and to further appeal to the Tax Court if the IRS determines to sustain the lien filing. In the course of the hearing, the taxpayer is entitled to contest the underlying tax liability because the taxpayer has had no prior opportunity to contest the liability. This is not a delinquent tax because it is not a final tax liability. Should the taxpayer seek tax court review, this will not be a final tax liability until the taxpayer has exercised all judicial appeal rights.
            
      (C) The taxpayer has entered into an installment agreement pursuant to I.R.C. §6159. The taxpayer is making timely payments and is in full compliance with the agreement terms. The taxpayer is not delinquent because the taxpayer is not currently required to make full payment.
            
      (D) The taxpayer has filed for bankruptcy protection. The taxpayer is not delinquent because enforced collection action is stayed under 11 U.S.C. §362 (the Bankruptcy Code).

(i) Certification Regarding Knowledge of Child Labor for Listed End Products (Executive Order 13126). [The Contracting Officer must list in paragraph (i)(1) any end products being acquired under this solicitation that are included in the List of Products Requiring Contractor Certification as to Forced or Indentured Child Labor, unless excluded at 22.1503(b).]

  (1) Listed End Product

LINE ITEM NO. | COUNTRY OF ORIGIN
--- | ---
_______________ | _______________
_______________ | _______________
_______________ | _______________
[List as necessary]

  (2) Certification. [If the Contracting Officer has identified end products and countries of origin in paragraph (i)(1) of this provision, then the offeror must certify to either (i)(2)(i) or (i)(2)(ii) by checking the appropriate block.]

    [ ] (i) The offeror will not supply any end product listed in paragraph (i)(1) of this provision that was mined, produced, or manufactured in the corresponding country as listed for that product.

    [ ] (ii) The offeror may supply an end product listed in paragraph (i)(1) of this provision that was mined, produced, or manufactured in the corresponding country as listed for that product. The offeror certifies that is has made a good faith effort to determine whether forced or indentured child labor was used to mine, produce, or manufacture any such end product furnished under this contract. On the basis of those efforts, the offeror certifies that it is not aware of any such use of child labor.

(j) Place of manufacture. (Does not apply unless the solicitation is predominantly for the acquisition of manufactured end products.) For statistical purposes only, the offeror shall indicate whether the place of manufacture of the end products it expects to provide in response to this solicitation is predominantly —

  (1) [ ] In the United States (Check this box if the total anticipated price of offered end products manufactured in the United States exceeds the total anticipated price of offered end products manufactured outside the United States); or

  (2) [ ] Outside the United States.

(k) Certificates regarding exemptions from the application of the Service Contract Labor Standards. (Certification by the offeror as to its compliance with respect to the contract also constitutes its certification as to compliance by its subcontractor if it subcontracts out the exempt services.) [The contracting officer is to check a box to indicate if paragraph (k)(1) or (k)(2) applies.]

  (1) [ ] Maintenance, calibration, or repair of certain equipment as described in FAR 22.1003-4(c)(1). The offeror [ ] does [ ] does not certify that—

    (i) The items of equipment to be serviced under this contract are used regularly for other than Governmental purposes and are sold or traded by the offeror (or subcontractor in the case of an exempt subcontract) in substantial quantities to the general public in the course of normal business operations;
        
    (ii) The services will be furnished at prices which are, or are based on, established catalog or market prices (see FAR 22.1003-4(c)(2)(ii)) for the maintenance, calibration, or repair of such equipment; and
        
    (iii) The compensation (wage and fringe benefits) plan for all service employees performing work under the contract will be the same as that used for these employees and equivalent employees servicing the same equipment of commercial customers.

  (2) [ ] Certain services as described in FAR 22.1003-4(d)(1). The offeror [ ] does [ ] does not certify that —

    (i) The services under the contract are offered and sold regularly to non-Governmental customers, and are provided by the offeror (or subcontractor in the case of an exempt subcontract) to the general public in substantial quantities in the course of normal business operations;

    (ii) The contract services will be furnished at prices that are, or are based on, established catalog or market prices (see FAR 22.1003-4(d)(2)(iii));

    (iii) Each service employee who will perform the services under the contract will spend only a small portion of his or her time (a monthly average of less than 20 percent of the available hours on an annualized basis, or less than 20 percent of available hours during the contract period if the contract period is less than a month) servicing the Government contract; and

    (iv) The compensation (wage and fringe benefits) plan for all service employees performing work under the contract is the same as that used for these employees and equivalent employees servicing commercial customers.

  (3) If paragraph (k)(1) or (k)(2) of this clause applies-

    (i) If the offeror does not certify to the conditions in paragraph (k)(1) or (k)(2) and the Contracting Officer did not attach a Service Contract Labor Standards wage determination to the solicitation, the offeror shall notify the Contracting Officer as soon as possible; and

    (ii) The Contracting Officer may not make an award to the offeror if the offeror fails to execute the certification in paragraph (k)(1) or (k)(2) of this clause or to contact the Contracting Officer as required in paragraph (k)(3)(i) of this clause.

(l) Taxpayer identification number (TIN) (26 U.S.C. 6109, 31 U.S.C. 7701). (Not applicable if the offeror is required to provide this information to the SAM database to be eligible for award.)

  (1) All offerors must submit the information required in paragraphs (l)(3) through (l)(5) of this provision to comply with debt collection requirements of 31 U.S.C. 7701(c) and 3325(d), reporting requirements of 26 U.S.C. 6041, 6041A, and 6050M, and implementing regulations issued by the Internal Revenue Service (IRS).

  (2) The TIN may be used by the government to collect and report on any delinquent amounts arising out of the offeror’s relationship with the Government (31 U.S.C. 7701(c)(3)). If the resulting contract is subject to the payment reporting requirements described in FAR 4.904, the TIN provided hereunder may be matched with IRS records to verify the accuracy of the offeror’s TIN.

  (3) Taxpayer Identification Number (TIN).

* [ ] TIN:_____________________.

* [ ] TIN has been applied for.

* [ ] TIN is not required because:

  * [ ] Offeror is a nonresident alien, foreign corporation, or foreign partnership that does not have income effectively connected with the conduct of a trade or business in the United States and does not have an office or place of business or a fiscal paying agent in the United States;

  * [ ] Offeror is an agency or instrumentality of a foreign government;

  * [ ] Offeror is an agency or instrumentality of the Federal Government;

  (4) Type of organization.

* [ ] Sole proprietorship;

* [ ] Partnership;

* [ ] Corporate entity (not tax-exempt);

* [ ] Corporate entity (tax-exempt);

* [ ] Government entity (Federal, State, or local);

* [ ] Foreign government;

* [ ] International organization per 26 CFR 1.6049-4;

* [ ] Other ____________________.

  (5) Common parent.

* [ ] Offeror is not owned or controlled by a common parent:

* [ ] Name and TIN of common parent:

  * Name: ____________________________________

  * TIN ______________________________________

(m) Restricted business operations in Sudan. By submission of its offer, the offeror certifies that the offeror does not conduct any restricted business operations in Sudan.

(n) Prohibition on Contracting with Inverted Domestic Corporations - 

  (1) Government agencies are not permitted to use appropriated (or otherwise made available) funds for contracts with either an inverted domestic corporation, or a subsidiary of an inverted domestic corporation, unless the exception at 9.108-2(b) applies or the requirement is waived in accordance with the procedures at 9.108-4.

  (2) Representation. The offeror represents that-

    (i) It [ ] is, [ ] is not an inverted domestic corporation; and

    (ii) It [ ] is, [ ] is not a subsidiary of an inverted domestic corporation.

(o) Prohibition on contracting with entities engaging in certain activities or transactions relating to Iran.

  (1) The offeror shall email questions concerning sensitive technology to the Department of State at [*CISADA106@state.gov*](mailto:CISADA106@state.gov).

  (2) Representation and Certification. Unless a waiver is granted or an exception applies as provided in paragraph (o)(3) of this provision, by submission of its offer, the offeror—

    (i) Represents, to the best of its knowledge and belief, that the offeror does not export any sensitive technology to the government of Iran or any entities or individuals owned or controlled by, or acting on behalf or at the direction of, the government of Iran;

    (ii) Certifies that the offeror, or any person owned or controlled by the offeror, does not engage in any activities for which sanctions may be imposed under section 5 of the Iran Sanctions Act; and

    (iii) Certifies that the offeror, and any person owned or controlled by the offeror, does not knowingly engage in any transaction that exceeds $3,500 with Iran’s Revolutionary Guard Corps or any of its officials, agents, or affiliates, the property and interests in property of which are blocked pursuant to the International Emergency Economic Powers Act (50(U.S.C. 1701 et seq.) (see OFAC’s Specially Designated Nationals and Blocked Persons List at [http://www.treasury.gov/ofac/downloads/t11sdn.pdf](http://www.treasury.gov/ofac/downloads/t11sdn.pdf)).

  (3) The representation and certification requirements of paragraph (o)(2) of this provision do not apply if-

    (i)  This solicitation includes a trade agreements certification (e.g., 52.212-3(g) or a comparable agency provision); and

    (ii) The offeror has certified that all the offered products to be supplied are designated country end products.

(p) Ownership or Control of Offeror. (Applies in all solicitations when there is a requirement to be registered in SAM or a requirement to have a unique entity identifier in the solicitation.

  (1) The Offeror represents that it [ ] has or [ ] does not have an immediate owner. If the Offeror has more than one immediate owner (such as a joint venture), then the Offeror shall respond to paragraph (2) and if applicable, paragraph (3) of this provision for each participant in the joint venture.

  (2) If the Offeror indicates “has” in paragraph (p)(1) of this provision, enter the following information:

  Immediate owner CAGE code: _____________________________________________

  Immediate owner legal name: ______________________________________________ (Do not use a “doing business as” name)

  Is the immediate owner owned or controlled by another entity:

  [ ] Yes or [ ] No.

  (3) If the Offeror indicates “yes” in paragraph (p)(2) of this provision, indicating that the immediate owner is owned or controlled by another entity, then enter the following information:

  Highest level owner CAGE code: _____________________________________________

  Highest level owner legal name: ______________________________________________ (Do not use a “doing business as” name)

(q) Representation by Corporations Regarding Delinquent Tax Liability or a Felony Conviction under any Federal Law.

  (1) As required by section 744 and 745 of Division E of the Consolidated and Further Continuing Appropriations Act, 2015 (Pub. L. 113-235), and similar provisions, if contained in subsequent appropriations acts, the Government will not enter into a contract with any corporation that -

    (i)  Has any unpaid Federal tax liability that has been assessed, for which all judicial and administrative remedies have been exhausted or have lapsed, and that is not being paid in a timely manner pursuant to an agreement with the authority responsible for collecting the tax liability, where the awarding agency is aware of the unpaid tax liability, unless and agency has considered suspension or debarment of the corporation and made a determination that suspension or debarment is not necessary to protect the interests of the Government; or

    (ii) Was convicted of a felony criminal violation under any Federal law within the preceding 24 months, where the awarding agency is aware of the conviction, unless an agency has considered suspension or debarment of the corporation and made a determination that this action is not necessary to protect the interests of the Government.

  (2) The Offeror represents that -

    (i) It is [ ] is not [ ] a corporation that has any unpaid Federal tax liability that has been assessed, for which all judicial and administrative remedies have been exhausted or have lapsed, and that is not being paid in a timely manner pursuant to an agreement with the authority responsible for collecting the tax liability; and

    (ii) It is [ ] is not [ ] a corporation that was convicted of a felony criminal violation under a Federal law within the preceding 24 months.

(r) Predecessor of Offeror. (Applies in all solicitations that include the provision at 52.204-16, Commercial and Government Entity Code Reporting.)

  (1) The Offeror represents that it [ ] is or [ ] is not a successor to a predecessor that held a Federal contract or grant within the last three years.

  (2) If the Offeror has indicated “is” in paragraph (r)(1) of this provision, enter the following information for all predecessors that held a Federal contract or grant within the last three years (if more than one predecessor, list in reverse chronological order):

    * Predecessor CAGE code ______(or mark “Unknown).

    * Predecessor legal name: _________________________ (Do not use a “doing business as” name).

(s) Representation regarding compliance with labor laws (Executive Order 13673). If the offeror is a joint venture that is not itself a separate legal entity, each concern participating in the joint venture shall separately comply with the requirements of this provision.
    
  (1)

    (i) For solicitations issued on or after October 25, 2016 through April 24, 2017: The Offeror [ ] does [ ] does not anticipate submitting an offer with an estimated contract value of greater than $50 million.

    (ii) For solicitations issued after April 24, 2017: The Offeror [ ] does [ ] does not anticipate submitting an offer with an estimated contract value of greater than $500,000.
    
  (2) If the Offeror checked ``does'' in paragraph (s)(1)(i) or (ii) of this provision, the Offeror represents to the best of the Offeror's knowledge and belief [Offeror to check appropriate block]:

    [ ] (i) There has been no administrative merits determination, arbitral award or decision, or civil judgment for any labor law violation(s) rendered against the offeror (see definitions in paragraph (a) of this section) during the period beginning on October 25, 2015 to the date of the offer, or for three years preceding the date of the offer, whichever period is shorter; or

    [ ] (ii) There has been an administrative merits determination, arbitral award or decision, or civil judgment for any labor law violation(s) rendered against the Offeror during the period beginning on October 25, 2015 to the date of the offer, or for three years preceding the date of the offer, whichever period is shorter.

  (3)

    (i) If the box at paragraph (s)(2)(ii) of this provision is checked and the Contracting Officer has initiated a responsibility determination and has requested additional information, the Offeror shall provide--

      (A) The following information for each disclosed labor law decision in the System for Award Management (SAM) atwww.sam.gov, unless the information is already current, accurate, and complete in SAM. This information will be publicly available in the Federal Awardee Performance and Integrity Information System (FAPIIS):

        (1) The labor law violated.
                
        (2) The case number, inspection number, charge number, docket number, or other unique identification number.
                
        (3) The date rendered.

        (4) The name of the court, arbitrator(s), agency, board, or commission that rendered the determination or decision;

      (B) The administrative merits determination, arbitral award or decision, or civil judgment document, to the Contracting Officer, if the Contracting Officer requires it;

      (C) In SAM, such additional information as the Offeror deems necessary to demonstrate its responsibility, including mitigating factors and remedial measures such as offeror actions taken to address the violations, labor compliance agreements, and other steps taken to achieve compliance with labor laws. Offerors may provide explanatory text and upload documents. This information will not be made public unless the contractor determines that it wants the information to be made public; and

      (D) The information in paragraphs (s)(3)(i)(A) and (s)(3)(i)(C) of this provision to the Contracting Officer, if the Offeror meets an exception to SAM registration (see FAR 4.1102(a)).

    (ii)

      (A) The Contracting Officer will consider all information provided under (s)(3)(i) of this provision as part of making a responsibility determination.

      (B) A representation that any labor law decision(s) were rendered against the Offeror will not necessarily result in withholding of an award under this solicitation. Failure of the Offeror to furnish a representation or provide such additional information as requested by the Contracting Officer may render the Offeror nonresponsible.

      (C) The representation in paragraph (s)(2) of this provision is a material representation of fact upon which reliance was placed when making award. If it is later determined that the Offeror knowingly rendered an erroneous representation, in addition to other remedies available to the Government, the Contracting Officer may terminate the contract resulting from this solicitation in accordance with the procedures set forth in FAR 12.403.

  (4) The Offeror shall provide immediate written notice to the Contracting Officer if at any time prior to contract award the Offeror learns that its representation at paragraph (s)(2) of this provision is no longer accurate.

  (5) The representation in paragraph (s)(2) of this provision will be public information in the Federal Awardee Performance and Integrity Information System (FAPIIS).

**Note to paragraph (s):** By a court order issued on October 24, 2016, this paragraph (s) is enjoined indefinitely as of the date of the order. The enjoined paragraph will become effective immediately if the court terminates the injunction. At that time, DoD, GSA, and NASA will publish a document in the Federal Register advising the public of the termination of the injunction.

(t) Public Disclosure of Greenhouse Gas Emissions and Reduction Goals. Applies in all solicitations that require offerors to register in SAM (52.212-1(k)).

  (1) This representation shall be completed if the Offeror received $7.5 million or more in contract awards in the prior Federal fiscal year. The representation is optional if the Offeror received less than $7.5 million in Federal contract awards in the prior Federal fiscal year.

  (2) Representation. [Offeror to check applicable block(s) in paragraph (t)(2)(i) and (ii)].

    (i) The Offeror (itself or through its immediate owner or highest-level owner) [ ] does, [ ] does not publicly disclose greenhouse gas emissions, i.e., makes available on a publicly accessible Web site the results of a greenhouse gas inventory, performed in accordance with an accounting standard with publicly available and consistently applied criteria, such as the Greenhouse Gas Protocol Corporate Standard.

    (ii) The Offeror (itself or through its immediate owner or highest-level owner) [ ] does, [ ] does not publicly disclose a quantitative greenhouse gas emissions reduction goal, i.e., make available on a publicly accessible Web site a target to reduce absolute emissions or emissions intensity by a specific quantity or percentage.

    (iii) A publicly accessible Web site includes the Offeror's own Web site or a recognized, third-party greenhouse gas emissions reporting program.

  (3) If the Offeror checked ``does'' in paragraphs (t)(2)(i) or (t)(2)(ii) of this provision, respectively, the Offeror shall provide the publicly accessible Web site(s) where greenhouse gas emissions and/or reduction goals are reported:_____.

(u)

  (1) In accordance with section 743 of Division E, Title VII, of the Consolidated and Further Continuing Appropriations Act, 2015 (Pub. L. 113-235) and its successor provisions in subsequent appropriations acts (and as extended in continuing resolutions), Government agencies are not permitted to use appropriated (or otherwise made available) funds for contracts with an entity that requires employees or subcontractors of such entity seeking to report waste, fraud, or abuse to sign internal confidentiality agreements or statements prohibiting or otherwise restricting such employees or subcontractors from lawfully reporting such waste, fraud, or abuse to a designated investigative or law enforcement representative of a Federal department or agency authorized to receive such information.

  (2) The prohibition in paragraph (u)(1) of this provision does not contravene requirements applicable to Standard Form 312 (Classified Information Nondisclosure Agreement), Form 4414 (Sensitive Compartmented Information Nondisclosure Agreement), or any other form issued by a Federal department or agency governing the nondisclosure of classified information.

  (3) Representation. By submission of its offer, the Offeror represents that it will not require its employees or subcontractors to sign or comply with internal confidentiality agreements or statements prohibiting or otherwise restricting such employees or subcontractors from lawfully reporting waste, fraud, or abuse related to the performance of a Government contract to a designated investigative or law enforcement representative of a Federal department or agency authorized to receive such information (e.g., agency Office of the Inspector General).

**(End of Provision)**

### 52.204-1 -- Approval of Contract.

As prescribed in 4.103, insert the following clause:

Approval of Contract (Dec 1989)

This contract is subject to the written approval of the Contracting Officer of TTS, GSA] and shall not be binding until so approved.

**(End of Clause)**

### 52.204-21 – Basic Safeguarding of Covered Contractor Information Systems.

As prescribed in 4.1903, insert the following clause:

Basic Safeguarding of Covered Contractor Information Systems (Jun 2016)

(a) Definitions. As used in this clause--

  “Covered contractor information system” means an information system that is owned or operated by a contractor that processes, stores, or transmits Federal contract information.

  “Federal contract information” means information, not intended for public release, that is provided by or generated for the Government under a contract to develop or deliver a product or service to the Government, but not including information provided by the Government to the public (such as on public Web sites) or simple transactional information, such as necessary to process payments.

  “Information” means any communication or representation of knowledge such as facts, data, or opinions, in any medium or form, including textual, numerical, graphic, cartographic, narrative, or audiovisual (Committee on National Security Systems Instruction (CNSSI) 4009).

  “Information system” means a discrete set of information resources organized for the collection, processing, maintenance, use, sharing, dissemination, or disposition of information (44 U.S.C. 3502).

  “Safeguarding” means measures or controls that are prescribed to protect information systems.

(b) Safeguarding requirements and procedures.

  (1) The Contractor shall apply the following basic safeguarding requirements and procedures to protect covered contractor information systems. Requirements and procedures for basic safeguarding of covered contractor information systems shall include, at a minimum, the following security controls:

    (i) Limit information system access to authorized users, processes acting on behalf of authorized users, or devices (including other information systems).
        
    (ii) Limit information system access to the types of transactions and functions that authorized users are permitted to execute.
        
    (iii) Verify and control/limit connections to and use of external information systems.
        
    (iv) Control information posted or processed on publicly accessible information systems.
        
    (v) Identify information system users, processes acting on behalf of users, or devices.
        
    (vi) Authenticate (or verify) the identities of those users, processes, or devices, as a prerequisite to allowing access to organizational information systems.
        
    (vii) Sanitize or destroy information system media containing Federal Contract Information before disposal or release for reuse.
        
    (viii) Limit physical access to organizational information systems, equipment, and the respective operating environments to authorized individuals.
        
    (ix) Escort visitors and monitor visitor activity; maintain audit logs of physical access; and control and manage physical access devices.
        
    (x) Monitor, control, and protect organizational communications (i.e., information transmitted or received by organizational information systems) at the external boundaries and key internal boundaries of the information systems.
        
    (xi) Implement subnetworks for publicly accessible system components that are physically or logically separated from internal networks.
        
    (xii) Identify, report, and correct information and information system flaws in a timely manner.
        
    (xiii) Provide protection from malicious code at appropriate locations within organizational information systems.
        
    (xiv) Update malicious code protection mechanisms when new releases are available.
        
    (xv) Perform periodic scans of the information system and real-time scans of files from external sources as files are downloaded, opened, or executed.

  (2) Other requirements. This clause does not relieve the Contractor of any other specific safeguarding requirements specified by Federal agencies and departments relating to covered contractor information systems generally or other Federal safeguarding requirements for controlled unclassified information (CUI) as established by Executive Order 13556.

(c) Subcontracts. The Contractor shall include the substance of this clause, including this paragraph (c), in subcontracts under this contract (including subcontracts for the acquisition of commercial items, other than commercially available off-the-shelf items), in which the subcontractor may have Federal contract information residing in or transiting through its information system.

**(End of Clause)**

### GSAR 552.212-71 - Contract Terms and Conditions Applicable to GSA Acquisition of Commercial Items.

As prescribed in 512.301(a)(2), insert the following clause:

**Contract Terms and Conditions Applicable to GSA Acquisition of Commercial Items (Jun 2016)**

(a) The Contractor agrees to comply with any clause that is incorporated herein by reference to implement agency policy applicable to acquisition of commercial items or components. The clause in effect based on the applicable regulation cited on the date the solicitation is issued applies unless otherwise stated herein. The clauses in paragraph (b) of this section are incorporated by reference:

(b) Clauses.

552.203-71 Restriction on Advertising

552.237-71 Qualifications of Employees

**(End of Clause)**
