# **Request for Quotation (RFQ)**

# **TTS Bug Bounty**

**From:** Michelle McNellis, Contracting Officer, GSA TTS Acquisitions

**Subject:** Request for Quotation (RFQ)

**Project Title:** TTS Bug Bounty

**Date:** February 14, 2017

**Reply By:** February 28, 2017 at 4:00pm EST

**Document Type:** Combined Synopsis/Solicitation Solicitation

**Set Aside:** Small Business

**NAICS Code:** 541519 – Other Computer Related Services

**Authority:** The solicitation document and incorporated provisions and clauses are those in effect through Federal Acquisition Circular 2005-89

**Clauses:** FAR 12.603(c)(2)(xii) and 12.603(c)(2)(xiii) apply to this requirement, see Addendum: Commercial Contract Clauses

The U.S. General Services Administration (“GSA”) Technology Transformation Service (“TTS”) hereby issues this Request for Quotation (“RFQ”) to deliver a Bug Bounty program as outlined in the Performance Work Statement (“PWS”). This is a combined synopsis/solicitation for commercial items prepared in accordance with the format in Federal Acquisition Regulation (“FAR”) subpart 12.6, “Streamlined Procedures for Evaluation and Solicitation for Commercial Items,” as supplemented with additional information included in this notice. Technical Factors will be evaluated in accordance with FAR subpart 12.602 “Streamlined Evaluation of Offers”. Price will be evaluated in accordance with FAR subpart 13.106. This announcement incorporates provisions and clauses in effect through the Federal Acquisition Regulations.

## 1.0 GENERAL

Vendors shall submit a quotation in accordance with the instructions specified in this RFQ letter and the terms and conditions of this quotation. Please ensure that a response includes all requested information and that your technical response clearly demonstrates the company’s capability to perform the objectives and requirements specified in the PWS. The Government intends to award based on initial quotations. Therefore, it is critical that you are fully responsive to the solicitation and submit your best quotation initially.

Questions or comments regarding this RFQ shall be submitted as issues within the GitHub repository at [https://github.com/18F/tts-buy-bug-bounty/](https://github.com/18F/tts-buy-bug-bounty/) no later than February 21, 2017 at 4:00pm EST, to allow the Government sufficient time to respond. All questions and comments will be publicly available. Please subscribe to the repository if your firm would like updates about changes and comments. Questions or comments received after the required deadline will not be answered. Any changes to this RFQ or attachments will be posted as an amendment on GitHub and GSA FedBizOps (“FBO”).

All quotations must be received electronically to [michelle.mcnellis@gsa.gov](mailto:michelle.mcnellis@gsa.gov), by the official closing date and time identified above. Late quotations will not be considered for award.

## 2.0 ADMINISTRATION

Each Offeror must submit a response to the solicitation, consistent with the instructions herein, in order to be considered for an award. Incomplete quotation submissions will not be evaluated and, therefore, will not be considered for a contract. Submission of these items, as detailed below, will constitute the Offeror’s compliance with the terms and conditions of the RFQ solicitation.

Unless expressly authorized by the RFQ, any Offeror planning to take exception to a term or condition of the RFQ should consult with the Contracting Officer (“CO”) in writing before submitting a quotation.

Offerors are advised to closely read the technical offer instructions, technical evaluation process, and evaluation criteria contained in the following sections before preparing a technical quotation.

## 3.0 PERIOD OF PERFORMANCE

The Period of Performance (“POP”) consists of one Base Period of three (3) months and  two (2) Option Periods of three (3) months each. The POP is expected to begin within 10 calendar days after award - specifically, from the day a kickoff is held with the contractor.

## 4.0 TYPE OF CONTRACT

Based on the nature of this requirement, the government intends to award a Firm-Fixed-Price (“FFP”) for basic access to the platform and FFP on a per-application basis. The bounty pool will be Firm-Fixed Unit Price Note-To-Exceed (“NTE”), with varying vulnerability levels but with *all costs paid directly to the researchers*.

## 5.0 PRICING STRUCTURE

The vendor is required to complete the attached [pricing file](response_templates/006_PRICING_FILE.yaml).

## 6.0 SPECIAL INSTRUCTIONS

1.  *Quotation Validation Date.* Quotation must be valid for at least 60 calendar days from quotation due date.

2.  *Communications Before Award.* The offeror shall direct all communications to the Contracting Officer. Communications with other officials may compromise the competitiveness of this acquisition and result in removal of the offeror from award consideration or cancellation of this requirement.

3.  *Potential Organizational Conflicts of Interest Statement.* Every offeror who wishes to be considered for the award shall provide a signed Organizational Conflict of Interest statement with their quotation submission, which describes concisely all relevant facts concerning any past, present, or planned interest (financial, contractual, organizational, or otherwise) relating to the work to be performed under the proposed contract and bearing on whether the offeror has a possible organizational or personnel conflict of interest with respect to:

    1.  Being able to render impartial, technically sound, and objective assistance or advice; or,

    2.  Being given an unfair competitive advantage.

    Offerors may also provide relevant facts that show how its organizational structure and/or management systems limit its knowledge of possible organizational conflicts of interest relating to other divisions or sections of the organization and how that structure or system would avoid or mitigate such organizational conflict.

    No contract award shall be made until any potential conflict of interest has been neutralized or mitigated to the satisfaction of the CO in accordance with Subpart FAR 9.5 [Organizational and Consultant Conflicts of Interest](http://farsite.hill.af.mil/reghtml/regs/far2afmcfars/fardfars/far/09.htm#P627_111537). Refusal to provide the requested information or the willful misrepresentation of any relevant information by an offeror shall disqualify the offeror from further consideration for award of a contract under this solicitation. If the CO determines that a potential conflict can be avoided, effectively mitigated, or otherwise resolved through the inclusion of a special contract clause, the terms of the clause will be subject to negotiation.

## 7.0 QUOTATION INSTRUCTIONS

Submissions in response to this solicitation shall include four separate attachments -- [a technical file](response_templates/005_TECHNICAL_FILE.yaml), [a pricing file](response_templates/006_PRICING_FILE.yaml), [a signature file](response_templates/007_SIGNATURE_FILE.md), and a **completed section 52.212-3(b) Offeror Representations and Certifications** -- Commercial Items. Quotations that fail to include any of the items identified above will not be considered for award. Inclusion of caveats, assumptions, or exceptions to the requirement of any kind, in any part of the quotation, will result in the quotation no longer being considered for award. 

1.  *Format.* Quotation shall be submitted using the attached templates as .txt, .yaml, or .pdf files.

2.  *General information and Technical Approach Sheet.* Your technical file must include responses to the provided general information metric sheet using this [template](response_templates/007_SIGNATURE_FILE.md).

    1.  *General Company and Contact Information.*

    2.  *Bug Bounty Platform Metrics.*

    3.  *Staffing Plan.* The offeror shall submit a Staffing Plan which will include the roles and number of personnel needed to satisfy the requirements in the PWS. Please include a 1-2 sentence description of the each of the roles included.

3.  *Price Proposal.* Offeror’s pricing quotation must use the provided template. The offeror shall submit a separate price quotation, using this [template](response_templates/006_PRICING_FILE.yaml), which includes the following, as one file:

    1.  *Pricing Narrative.* The pricing narrative should describe your basis of pricing for the required services and other costs used in the development of the proposed pricing. Include any basis of estimate or narrative in the Pricing Template provided with this RFQ.

4.  *Signature File.* This file provides the signature blocks verifying that the submitter has the legal authority and capacity to respond to the RFQ on behalf of the vendor as well as the offeror’s statement regarding organizational conflict of interest, reference 6.0c. Offerors should submit this file as a .pdf.

## 8.0 ORAL INTERVIEW

Each offeror will be provided the questions, via email, approximately 60 minutes before their Oral Presentation. The Government is much more interested in the informational content of the offeror’s answers rather than the particular style or technique used in delivering the answers. The Government may take notes during the presentation at its discretion and exclusive right and property, and may use such notes in the evaluation. The Government may also record the presentations. No copies of notes or recordings will be provided to the offeror.

Schedule and Agenda for Oral Presentations:

 **Agenda Item** | **Time Allocated**
--- | ---
Government Provides Questions to Offeror | Approximately 60 Minutes Before Oral Presentation (via email)
Introductions | Approximately 5 Minutes
Offeror Orals - Q&A on Technical Factors | 25 Minutes Maximum
Break for Offeror & Government Questions | 5 Minutes Maximum
Government Follow-Up Q&A (if needed) | 10 Minutes Maximum

1.  *Rules.* The oral presentation consists of an initial question and answer session on technical factors, and a follow-up question and answer session (if necessary), associated with this RFQ does not and will not constitute discussions or negotiations as defined in FAR part 15. The Government is not obligated to determine a competitive range, conduct discussions, and solicit or allow revised quotations. The entire oral presentation will be conducted remotely via video and audio. Offerors shall not bring or present slides, graphs, charts or any other written presentation materials nor will the Government accept or receive offeror handouts.

    1. **Technical Session.** The Technical Session. While the technical factors are identified in the RFQ, the core questions are not. All offerors will be asked the same core questions related to the technical factors. The questions are related to the offeror’s technical understanding and approach of the requirements identified in the Performance Work Statement (PWS) and quality control measures for overseeing performance. This part of the oral presentation of answers will not exceed 25 minutes, and may go shorter.

    2. **Follow Up Session (only if necessary).** The Government will allocate 10 minutes for follow-up questions following the offeror’s answers to the initial core questions on technical factors. During this time, the Government may ask questions on any information that had been presented by the offeror that the Government feels is unclear or needs elaboration. The Government’s questions may differ among the offerors based on what needs elaboration. If the Government has no follow-up questions with a particular offeror, then this part of the session will not take place. The answers given in this session are part of the offeror’s oral presentation.

2.  *Location.* The oral presentation sessions will be conducted by video conference, through audio may be substituted as needed. The Government will coordinate and set up the meeting space accordingly (providing dial in or links using a tool such as Zoom or Adobe Connect).

3.  *Date and Time.* The Government will schedule the date and time of the oral presentations with each offeror after the RFQ closing date and receipt of offeror submissions. The Government reserves the right to reschedule any offeror’s orals date at the discretion of the contracting officer.

4. *Participants.* Offerors may include as many participants as it feels is necessary. Offerors are advised to have technical personnel present since the Government will ask technical questions during the oral presentations. Type and number of participants included is at the offeror’s discretion and is the full responsibility of the offeror. The proposed Key Personnel (one Technical Account Manager) currently employed by the offeror or its teaming partners shall attend the session - the Government is most interested in hearing from staff that will have a direct role in performing on the task. The letter(s) of intent and resume will suffice for a Technical Account Manager that will serve as Key Personnel currently not employed by the offeror or its teaming partners.

After the presentations, offerors shall provide an email to confirm attendance with names of participants to the meeting organizers.

## 9.0 BASIS OF AWARD AND EVALUATION CRITERIA

This procurement is being conducted in accordance with Federal Acquisition Regulation (FAR) subpart 12.6, “Streamlined Procedures for Evaluation and Solicitation for Commercial Items,” as supplemented with additional information included in the RFQ. Technical Factors will be evaluated in accordance with FAR subpart 12.602 “Streamlined Evaluation of Offers”. Price will be evaluated in accordance with FAR subpart 13.106. Provision [52.212-2, Evaluation -- Commercial Items](http://farsite.hill.af.mil/reghtml/regs/far2afmcfars/fardfars/far/52_000.htm#P1584_221596), does not apply to this requirement. The offerors agree to and are bound by all instructions, procedures and rules of this RFQ. The Government is not obligated to determine a competitive range, conduct discussions, solicit final revised quotations, and use other techniques associated with FAR part 15. The contracting techniques associated with FAR Part 15 do not apply.

The final award for this requirement will be based on best-value principles, utilizing the trade-off process. Accordingly, award will be made to the responsible and technically acceptable offeror whose quotation provides the greatest overall value to the Government, price and other factors considered.

The Government is more concerned with obtaining superior technical and management capabilities than with making awards at the lowest overall price to the Government. However, the Government will not make awards at a significantly higher overall price to achieve slightly superior technical value. Offerors are advised that the technical evaluation factors combined are significantly more important than price.

1.  Evaluation Process. The Government intends to utilize a multi-phased approach for this procurement as described below. To be considered for award, offerors must successfully pass through each phase.

    Phase 1 (Pass/Fail): Offer Compliance Check - A compliance check will be conducted to ensure that offerors submit a complete quotation package, which was outlined in Section 7 Quotation Instructions. Only the offerors that receive Pass will advance to Phase 2. Those who do not advance will receive a notice of their quotations rejection before Phase 2 begins.

    Phase 2: Technical Evaluation and Oral Interview - Offerors that pass Phase 1 will be notified of the time and date of their oral interview. The oral interview will be focused on the offeror’s technical approach, level of knowledge, technical expertise, and overall understanding of the requirements to manage a bug bounty program for large and high-profile corporations; maintaining a reliable bug bounty SaaS platform; maintaining a community of security researchers with adequate levels of skill and talent, among other factors outlined in the solicitation. The Government will also evaluate the offeror’s bug bounty platform metrics and staffing plan as provided in the technical file. Each offeror will be provided the questions, via email, approximately 60 minutes before their Oral Presentation.

    Phase 3: Pricing Schedule and Pricing Narrative Check - Offeror’s Price will be reviewed.

2.  Technical Evaluation Factors. The Government will evaluate responses received during Phase 2 for an offeror’s performance or capability acceptability based on the following non-price technical factors, which are of equal importance to each other:

    1.  Technical Understanding and Approach: The Government will evaluate the offeror’s technical approach:

        * Level of knowledge, technical expertise, and overall understanding of the requirements to manage a bug bounty program for large and high-profile corporations.

        * Maintaining a reliable bug bounty SaaS platform.

        * Maintaining a community of security researchers with adequate levels of skill and talent, among other factors outlined in the solicitation.

        * The offeror’s skills with open source software development, human-centered design, and continuous deployment methods.

    2.  Similar Experience/Past Experience: The Government will evaluate the offeror’s experience in delivering bug bounty services to private and public sector clients by measuring platform-wide metrics, including but not limited to, average time to triage a new report, average time to respond to researchers, average time to forward verified reports based on severity, etc.

    3.  Price Evaluation Factors.

    Price Evaluation Factors. Each offeror’s price quotation will be evaluated separately from the technical quotation and oral interview. Pricing shall reflect reasonableness, consistency with industry standards. Note that as submissions become more technically equal in their merit, the evaluated price becomes more important. Therefore, it is critical that the Offeror submit their best quotation initially.

## 10.0 TRANSPARENCY POLICY

Vendors are advised that TTS will publish on a publicly available website documents associated with this requirement, including any Requests for Proposals (including amendments), Question and Answer exchanges with vendors (source-identifying information removed), and other relevant information that is not confidential/proprietary in nature or source selection sensitive information that would otherwise implicate procurement integrity concerns.

Upon award, TTS will publish the total price of the selected quotation and certain non-source-identifying data (for example, the number of quotations). During the performance of this, TTS will similarly publish data related to project management, and top-line spending data.

## 11.0 DATA RIGHTS AND OWNERSHIP OF DELIVERABLES

TTS reserves the right to release any data or deliverables created as a result of the work performed under the contract at its own discretion, all releases of which are subject to be committed to the public domain.

For submitted vulnerabilities, the contractor shall use open source technologies wherever possible, in support of the TTS Source Code Policy. All licenses must be expressly listed in the deliverable. Regardless of license(s) used (e.g., MIT, GPL, Creative Commons 0) the license(s) shall be clearly listed in the documentation.

If the contractor needs to use work that does not have an open source license, the contractor is required to request permission from TTS, in writing, before utilizing that work in any way in connection with the order. If approved, all licenses shall be clearly set forth in a conspicuous place when work is delivered to TTS.

If an open source license provides implementation guidance, the contractor shall ensure compliance with that guidance. If implementation guidance is not available, the contractor shall attach or include the license within the work itself. Examples of this include code comments at the beginning of a file or contained in a license file within a software repository.

## ATTACHMENTS TO THIS RFQ

1.  [Addendum - Commercial Contract Clauses](002_Addendum.md)

2.  [PWS](003_PWS.md)

3.  [QASP](004_QASP.md)

4.  [Technical File](response_templates/005_TECHNICAL_FILE.yaml)

5.  [Pricing File](response_templates/006_PRICING_FILE.yaml)

6.  [Signature File](response_templates/007_SIGNATURE_FILE.md)
