# Market Research Report

# TTS Bug Bounty

The purpose of this market research report is to satisfy the requirements as outlined within Federal Acquisition Regulation (FAR) Part 10, Market Research and to determine the most suitable approach to acquiring the services required in the development of a Bug Bounty program to be used by TTS for the primary purpose of incentivizing security researchers and other interested users to report security issues directly to the system owner. 

TTS needs to purchase access to a pre-existing, commercially available Bug Bounty SaaS Platform that will allow it to launch and manage the TTS Bug Bounty program. This acquisition will give TTS access to a large network of security researchers, people who have an interest - both personally and financially - in helping to find and address bugs and other technical issues within TTS-owned web applications. This program will be the first of its kind to be generated by a civilian (or non-DOD) federal agency. Only a select few small businesses are able to provide this Software-as-a-Service platform and that large network of researchers.

Bug bounties serve as a legal and social contract with the security community: bounty operators, like TTS, define what researchers are permitted to do in regards to discovering and reporting security issues of a production system, and in turn, researchers are assured they will not be punished for anything they do within that scope and are awarded for their findings.

With bug bounties becoming an established industry-wide best practice, TTS desires to establish one of its own. The vulnerability disclosure policy that was released in November 2016 outlines how researchers can report system vulnerabilities, while keeping personal and financial information safe. TTS [wishes to incentivize](Memorandum_on_Budgeting_and_Pricing.md) security researchers and other interested users to report security issues directly to the system owner through the use of financial rewards - or, a bug bounty.

While many in the research community are simply seeking to disclose vulnerabilities for recognition and out of goodwill alone, it is understood that there is a financial marketplace for unreported security issues in important systems. Where there are no legitimate means by which disclosure can occur and/or be acknowledged, there is a risk of a black marketplace taking the place of an open one. Bug bounties are a proven method of mitigating security risk in production systems: they incentivise researchers to report issues to the system owner who can fix them before they’re discovered by malicious actors. 

By the very nature of a bug bounty program, a contractor that provides a Bug Bounty SaaS Platform that can achieve the goals of TTS while providing the best value to the government must be one that is well-established. The more well-known the provider of a Bug Bounty SaaS Platform, the larger and more talented the pool of security researchers they have in their community. The larger the community of security researchers in the Bug Bounty SaaS Platform provider’s network, the better the chance TTS has of finding bugs and technical issues within their web applications.

Private companies have operated bug bounties for many years(FN1). The first program was created at Netscape in late 1995, and offered cash rewards to anyone who found bugs in Netscape Navigator (the precursor to Mozilla’s Firefox web browser). The basic concept is simple: reward independent researchers for software bugs they discover and report responsibly. Over the fifteen years a few companies offered similar programs, but it remained a niche concept. The idea really took off in 2010 when Google launched their Vulnerability Reward Program (VRP) for the company's web applications. Since its launch, Google has paid researchers over $6 million in bounty rewards(FN2). That success -- and the similar successes of other early bounties at Barracuda, Microsoft, and Facebook -- led to an explosion of similar programs. Today, hundreds of companies run bounty programs, which tens of thousands of researchers participate in. 

Security bug bounties provide many benefits to organizations that offer them: they provide an officially-sanctioned channel for users to report security issues; they incentivise independent researchers to use their expertise to improve the organization's’ security posture; they bring a broader base of expertise into play by opening up research to experts outside the organization; and they complement traditional security reviews and penetration tests by making security review an ongoing, iterative process. Thus, bug bounties have become an important component of a mature cybersecurity practice.

However, operating a bug bounty is difficult. The vast majority of reported issues turn out to be invalid(FN3), and even valid reports can require significant back-and-forth with researchers to fully understand the issue. Properly tracking and managing reports can be difficult: most off-the-shelf bug-tracking software is ill-suited to bug bounties. And, managing the multiple small payouts to researchers can be very time-consuming. 

Bug bounty platforms such as HackerOne and BugCrowd exist to solve these issues: they provide specialized software to receive, track, and manage bug reports. They offer staff who are specialists in reviewing vulnerability reports and communicating with researchers. They automate and manage payouts to researchers. On top of that, they build communities of experienced security researchers and help organizations put their bug bounties in front of that community.

To determine these types of services are not supported by a mandatory source or an existing GSA contract vehicle, the Market Research team interviewed industry partners.

First, the Market Research team focused on determining if mandatory sources were available for use. In accordance with FAR Part 8.002, Priorities for Use of Mandatory Sources and Part 8.003, Use of Other Mandatory Sources, this requirement could not be fulfilled by the higher priority sources such as Federal Prison Industries or SourceAmerica (formerly NISH).

Second, the Market Research team interviewed the three known companies within the commercial industry that provide access to their Bug Bounty SaaS Platform and their community of security researchers: HackerOne, BugCrowd, and Synack.

As part of policy [MV-12-07](https://insite.gsa.gov/portal/mediaId/672754/fileName/MV-12-07.action), “GSA Vehicles First” we made the determination these commercial bodies do not have existing government contract vehicles, such as a Federal Strategic Sourcing Initiative (FSSI). Although the minimum number of bids received before seeking additional bids is 3 per FAR Part 8, the goal of this action is to maximize participation from a wide variety of participants with the necessary skills and abilities to accomplish this effort. Therefore, given the small number of potential offerors, the Federal Supply Schedule (FSS) is not suitable at this time. A search of the GSA Schedules indicates that similar companies are not currently in the FSS contracts, specifically, pricelists for IT Schedule 70 SIN 132 40, Cloud Computing Service, which includes commercially available cloud computing services such as Infrastructure as a Service (IaaS), Platform as a Service (PaaS), and Software as a Service (SaaS), and emerging cloud services. 

Although bug bounty platforms are not currently available under FSS contracts, TTS has reached out to GSA IT Schedule 70 to determine the process / overview of how to get vendors on schedule utilizing the FAStLane program. This option is likely the best fit for the vendor community if a broader government need exists. Currently, only one civilian agency, GSA, and the Department of Defense have vulnerability policies. Without these policies in place, an agency is unable to procure bug bounty services.

Additionally, as it is too new to be either strategically sourced or managed as a category of spend, at this point in time, this requirement does not align with category management. 

Given the technical purpose of a bug bounty, anything other than full and open competition is limiting to the potential pool of participants. Given that this requirement is completely new, alternative, established vehicles may be more palatable to potential participants once they have accomplished this first effort. 

This requirement is the first of its kind to be generated by a civilian (or non-DOD) federal agency. Only a select few small businesses are able to provide this software as a service. These small businesses are not considered to be apart of any socioeconomic category.

Having conducted meaningful market research with industry partners and the Department of Defense (DOD), who successfully procured bug bounty services, TTS plans to issue a Request for Quotation on FedBizOpps. This Quotation will be a combined synopsis/solicitation for commercial items prepared in accordance with the format outlined in FAR Subpart 12.6, Streamlined Procedures for Evaluation and Solicitation for Commercial Items set-aside for small businesses.

In accordance with FAR 12.202(b)-- Market Research and Description of Agency Need, the Market Research team has ensured that the description of the agency’s need contains sufficient detail for potential offerors of commercial items to know which commercial products or services may be suitable. The type of product or service to be acquired is sufficiently described, the intended use can be explained, and the performance requirements are sufficiently outlined.

## Footnotes

FN1. For more on the history of bug bounties see https://bugcrowd.com/resources/history-of-bug-bounties 

FN2. See https://security.googleblog.com/2016/01/google-security-rewards-2015-year-in.html

FN3. Only 13% of issues reported on the Bugcrowd platform are valid, according to their State of the Bug Bounty 2016 report - https://pages.bugcrowd.com/2016-state-of-bug-bounty-report 
