# Acquisition Plan For TTS Bug Bounty

Plan ID | AP_T00_2017_3318
--- | ---
Project Title | TTS Bug Bounty
Plan Status | Final
Solicitation Number | TTS_Bug_Bounty
Estimated Dollar Value | $203,400.00
Nature of Action | Commercial contract (FAR Part 12)
Region | Central Office
Requiring Agency | General Services Administration (“GSA”)
Bureau | *Technology Transformation Services (“TTS”)*
Place of Performance (State): | District of Columbia
Place of Performance (City or Cities): | Washington, DC
High Risk? | **No**
Small Business Set-Aside? | **Yes**
General Counsel Participation Needed? | Yes

Full and Open Competition After the Exclusion of Sources (including, but not limited to, various Set-asides and Competitive 8(a) acquisitions).

## 7.105(a) Acquisition Background and Objectives

Private companies have operated “bug bounties” for many years. The first program was created at Netscape in late 1995, and offered cash rewards to anyone who found bugs in Netscape Navigator (the precursor to Mozilla’s Firefox web browser). The basic concept is simple: reward independent researchers for software bugs they discover and report responsibly. Over the fifteen years a few companies offered similar programs, but it remained a niche concept. The idea really took off in 2010 when Google launched their Vulnerability Reward Program (VRP) for the company's web applications. Since its launch, Google has paid researchers over $6 million in bounty rewards. That success -- and the similar successes of other early bounties at Barracuda, Microsoft, and Facebook -- led to an explosion of similar programs. Today, hundreds of companies have similar requirements to TTS, with the majority using one of the major commercial providers and a handful running their own bounty programs.

Security bug bounties provide many benefits to organizations that offer them: they provide an officially-sanctioned channel for users to report security issues; they incentivise independent researchers to use their expertise to improve the organization's’ security posture; they bring a broader base of expertise into play by opening up research to experts outside the organization; and they complement traditional security reviews and penetration tests by making security review an ongoing, iterative process. Thus, bug bounties have become an important component of a mature cybersecurity practice.

However, industry practice shows, operating a bug bounty program is difficult. The vast majority of reported issues turn out to be invalid, and even valid reports can require significant back-and-forth with researchers to fully understand the issue. Properly tracking and managing reports can be difficult: most off-the-shelf bug-tracking software is ill-suited to bug bounties. And, managing the multiple small payouts to researchers can be very time-consuming.

Commercial bug bounty platform providers began offering their services in order to solve these issues: they provide specialized software to receive, track, and manage bug reports. They offer staff who are specialists in reviewing vulnerability reports and communicating with researchers. Coordinating with their business partner, the vendor determines the classification for the type of vulnerabilities and manages payouts to researchers. On top of that, they build communities of experienced security researchers and help organizations put their bug bounties in front of that community.

As part of its programmatic focus on security, TTS needs to purchase access to a pre-existing, commercially available Bug Bounty SaaS Platform that will allow it to launch and manage the TTS Bug Bounty program. This acquisition will give TTS access to a large network of security researchers, people who have an interest - both personally and financially - in helping to find and address bugs and other technical issues within TTS-owned web applications. While the Department of Defense has conducted a bug bounty program, this TTS program will be the first of its kind to be generated by a civilian (or non-DOD) federal agency. Only a select few small businesses are able to provide this Software-as-a-Service (“SaaS”) platform and that large network of researchers.

Bug bounties serve as a legal and social arrangement with the security community: bounty operators, like TTS, define what researchers are permitted to do in regards to discovering and reporting security issues of a production system, and in turn, researchers are assured they will not be punished for anything they do within that scope and are awarded for their findings.

With bug bounties becoming an established industry-wide best practice, TTS desires to establish one of its own. The TTS vulnerability disclosure policy that was released in November 2016 outlines how researchers can report system vulnerabilities, while keeping personal and financial information safe. TTS wishes to incentivize security researchers and other interested users to report security issues directly to the system owner through the use of financial rewards - or, a bug bounty.

While many in the research community are simply seeking to disclose vulnerabilities for recognition and out of goodwill alone, it is understood that there is a financial marketplace for unreported security issues in important systems. Where there are no legitimate means by which disclosure can occur and/or be acknowledged, there is a risk of a black marketplace taking the place of an open one. Bug bounties are a proven method of mitigating security risk in production systems: they incentivise researchers to report issues to the system owner who can fix them before they’re discovered by malicious actors.

By the very nature of a bug bounty program, a contractor that provides a Bug Bounty SaaS Platform that can achieve the goals of TTS while providing the best value to the government must be one that is well-established. The more well-known the provider of a Bug Bounty SaaS Platform, the larger and more talented the pool of security researchers they have in their community. The larger the community of security researchers in the Bug Bounty SaaS Platform provider’s network, the better the chance TTS has of finding bugs and technical issues within their web applications.

Beyond the software that makes up a SaaS Platform and the network of security researchers, a successful contractor will also need to have the ability to provide program management and triage services.

Program management services include services related to promotion of the program, tracking and workflow, and payouts. With thousands of competing bug bounty programs, the contractor must be able to emphasize the attractiveness of the TTS Bug Bounty program. There must also be a level of expertise in relation to how submissions will be received and how they will be managed throughout their lifecycle. Finally, for valid payouts, including the numerous small payments that will be made for the low-severity bugs that are found to be viable. By way of example, payouts average around $300, with dozens or even hundreds of payouts over the life of a program.

In terms of triage services, as mentioned, TTS has already received reports through the vulnerability policy. Successful bug bounty programs result in dozens of reports per month, but the signal-to-noise ratio is low. On average, only about 10% of submissions turn out to be valid. All submissions needs responses, however, or else there is a risk of alienating researchers. The workload of filtering submissions and communicating with researchers can be quite heavy. A successful contractor will, among other things, assign a severity-rating to each vulnerability (e.g., low, medium, high), provide responses to invalid reports, provide initial responses to valid reports, and forward valid reports to TTS within a reasonable time based on the severity.

Platforms typically provide triage services as a separate option, so this means that the acquisition will involve 3 components, all of which are necessary:

1. The cost of access to the network and use of the SaaS platform;

2. The cost of first-line triage and communication services; and,

3. A “bounty pool” from which researchers are paid for valid reports.

## 7.105(a)(1) Statement of Need

Most of the US government does not have a defined method by which vulnerabilities can be reported and the reporters rewarded. To address this situation for itself, TTS has recently released a vulnerability disclosure policy and needs to create a Bug Bounty program in order to incentivize security researchers and other interested users to report security issues directly to the system owner. While this policy and Bug Bounty program are specifically for TTS only - they will not involve GSA in general or the government as a whole - successful implementation will potentially serve as the model for other agencies.

[The purpose](../solicitation_documents/003_PWS.md#30-scope) of this solicitation, as stated in the Performance Work Statement (PWS), is for the contractor to deliver a Bug Bounty program which TTS will utilize for TTS-owned web applications. The contractor will provide access to their Bug Bounty SaaS Platform for researchers to report vulnerabilities (“Platform/Network Access”) and allow TTS to manage and track issues across multiple public web applications, triage services for those reported vulnerabilities, disburse rewards for effective vulnerabilities, and explain the reasons behind rejections (“Vulnerability Report Triage Services”).

For the Platform Access, GSA IT has already begun the approval process for the three known contractors in the industry. For the Vulnerability Report Triage Services, they must be provided on a “per web application” basis, allowing TTS to operate a Bug Bounty for a web application independently of the other web applications that are utilizing the Platform/Network Access for their own tests. As part of these services, the contractor must provide staff who are specialists in reviewing vulnerability reports and communicating with researchers.

### Contractual History

This is the first purchase order for this functionality.

### Acquisition Alternatives

TTS considered making the software and hiring the personnel required to create a Bug Bounty program in-house. As summarized in section 7.105(b)(12) of this Acquisition Plan, Make or Buy, the estimated costs proved to be prohibitive. Furthermore, as detailed in section 7.105(b)(1), Sources, TTS considered existing vehicles, but none were able to fulfill the objectives and goals of this acquisition.

**Full and Open Competition:** Market research (set forth in the Market Research Report) revealed that the requirement is within scope of FAR 6.203, full and open competition after exclusion of sources with a small business set-aside. The total procurement will be set-aside for small business concerns.

## 7.105(a)(2) Applicable Conditions

The contractor shall abide by the following:

(i) Requirements for compatibility with existing or future systems or programs:

* The contractor is required to provide a SaaS platform, with a publically available website, for researchers to report security vulnerabilities about specific publically available government websites in manner consistent with the [TTS Vulnerability Security Policy.](https://18f.gsa.gov/vulnerability-disclosure-policy/)

(ii) Any known cost, schedule, and capability or performance constraints:

* The MOU between Office of Products and Programs (“OPP”) and TTS has a current budget of $210,000 for the Base Period and Option 1. Option 2 will be allocated on an as needed basis.

    * This project will be funded by OPP’s Federal Citizen Services Fund. The funds are no-year money with no FY restrictions. $60,000 is earmarked to TTS labor, $50,000 for the TTS fee, and the remaining $100,000 will cover the procurement of Platform and Network Access, Vulnerability Report Triage Services for each application, and the TTS Bug Bounty pool.

    * The Login.gov Bug Bounty pool will be funded by Login.gov directly. Half of the procurement costs will be paid by Login.gov with a separate Bug Bounty pool established for Login.gov.

* Each Period will last a total of 3 months (12 weeks).

* TTS requires a third-party to review the code base because best practice standards in terms of checks and balances dictate that the same individuals who developed the code should not review for vulnerabilities.

* The vendor must be willing to engage with TTS to develop a Bug Bounty pool management plan by no later than the vendor kickoff meeting and by taking the following actions:

* Work with TTS to identify the proper scope of vulnerability identification, disclosure and assessment, controlling for risk. Also, criteria for most significant vulnerabilities will be established with the TTS before applications are advertised.

* Work with TTS to identify the proper scope of vulnerability identification and ranking.

* With TTS assistance, determine and/or adjust bounty reward tiers to manage our bounty pool most effectively.

* Once classified and deemed within the scope of the vulnerabilities, the vendor will manage payout to the reporter based on the agreed up bounty reward tiers.

* Forward to TTS the vulnerability reports, the names of the researchers, and the award amounts.

* Make and suggest updates to the plan throughout the period of performance as necessary.

## 7.105(a)(3) Costs

The established cost goal for this acquisition is $203,400.00, which is representative of the anticipated cost to perform the services outlined as well as the bug bounty reward pools.

An [in-depth price analysis](Memorandum_on_Budgeting_and_Pricing.md) by the technical subject matter expert was completed to develop the [Independent Government Cost Estimate](IGCE_TTS-Bug-Bounty.xlsx) (“IGCE”). The Acquisition Team completed Market Research to determine who was capable of providing bug bounty services. An important revelation from the team’s work was that there are only three viable vendors, and of which, only two provide the open community and network of security researchers that is crucial for the success of this acquisition.

After review of the DOD project’s findings and a study by the Federal Trade Commission (“FTC”) on “Web Vulnerability Discovery Ecosystems”, costs that make up the IGCE were estimated. Specifically, rates related to access to a Bug Bounty SaaS Platform as a whole and services related to vulnerability triage for each web application that utilizes the Bug Bounty program, as well as the payout scheme for each reported vulnerability based on their severity, were derived.

This requirement is new to the government and historical pricing is not available for this purchase.

***Life Cycle Costs*:** The estimated life cycle cost (9 months) for this purchase order is approximately $203,400.00.

The government may require continued performance of any services within the limits and at the rates specified in the purchase order in accordance to FAR Subpart 52.217-8 - Option To Extend Services. In the unlikely event a six month extension is required, TTS OA will need to modify the IGCE and request a new quotation from the vendor. The risk of needing to do this, based on TTS OA’s understanding from the product owner, is very low.

Design-to-cost analysis was not performed because it was not applicable due to the nature of the requirement.

Should-cost analysis, as defined in FAR Subpart 15.407-4, will not be performed because Cost Analysis is not required when using FAR Subpart 12.602, or when adequate competition is likely to occur.

## 7.105(a)(4) Capability or Performance Conditions

The government will use the attached [Quality Assurance Surveillance Plan](../solicitation_documents/004_QASP.md) (“QASP”) to monitor the contractor’s performance. The QASP will provide oversight help to ensure that service levels reach and maintain the required levels for performance of this task. Further, the QASP provides the government with a proactive way to avoid unacceptable or deficient performance, and provides verifiable input for the required Past Performance Information Assessments. The QASP is a living document and may be updated by the government as necessary. Any updates to the QASP will be provided to the contractor.

## 7.105(a)(5) Delivery or Performance-period Requirements

### Period of Performance

The Period of Performance (POP) consists of one Base Period of three (3) months and two (2) Option Periods of three (3) months each. The POP is expected to begin within 10 calendar days after award - specifically, from the day a kickoff is held with the contractor. The anticipated award date is April 6, 2017.

### Place of Performance

The primary place of performance will be at the contractor’s facility. Work may be performed at GSA Headquarters at 1800 F St. NW, Washington, DC, and Alternate Sites. TTS is a distributed team, and as such, there is no anticipated need for travel. Any work done, whether onsite or offsite, must be covered by the fixed-rate agreed upon between the government and contractor.

## 7.105(a)(6) Trade Offs

A reliable Bug Bounty SaaS Platform along with access to a large and talented community of security researchers is essential to achieving the objectives of this acquisition and ensuring the government obtains the return on investment it is seeking. The technical capabilities of the Bug Bounty SaaS Platform, the size of the network, and the providers’ triage-management services substantially outweigh cost in importance.

With the bounty pool and its management, the government structured the IGCE specifically to limit the risk and provide the best cost trade-off.

There are a variety of ways a platform provider might structure a managed bug bounty, but they usually fall into one of two categories: percentage-based, or fixed-fee.

In a percentage-based fee structure, the government would pay the platform vendor an “overhead” on each bounty paid. For example, if the fee was 50% and we awarded a $5,000 bounty, we would actually pay the vendor $7,500: $5,000 to the researcher, and $2,500 (50% of the bounty) to the vendor.

In a fixed-fee structure, the government pays the vendor a fixed fee (monthly, quarterly, or yearly) regardless of bounties paid. Fixed-fee structures could be a single fee for the entire program, or a per-application fee.

Within the structure of TTS an approach using fixed fees and a per-application fee is considered the best value to our organization. This determination is derived from the following reasons:

* Predictability: The government cannot perfectly predict how many issues will be seen, so it will be hard to predict what will be paid to the vendor. Fixed fees are predictable: the government will know exactly what will be paid.

* Incentives: Since the vendor sees a percentage, they are incentivized to assume that issues are valid, and to reward more (and higher) bounties. TTS will be asking the vendor to make the ultimate decision about an issue’s reward, and want their incentives to be aligned with TTS.

* Flexibility: TTS is not a typical product company with just a single product; we have a portfolio of products and services. With a per-app structure, it allows the organization to add or remove apps from our portfolio as needed. In a percentage-based fee structure, the vendor might be reluctant to add new apps that might not see the same volume of payouts.

The government anticipates that a fixed-fee format is maximally advantageous to TTS: there is a fixed vendor fee, with aligned incentives. To handle payments to the researchers, the purchase order will include a Firm Fixed Unit Price for the bounties to be paid to the security researchers based on the TTS-approved classification level for the vulnerability. This approach will provide high budget predictability with maximum flexibility to spend that budget effectively.

And, finally, looking to the future: this structure is expected to serve TTS well if/when the program is expanded to include more applications and services.

## 7.105(a)(7) Risks

**Technical:** Technical risks are low for the following reasons: (1) these are widely used, commercially available services ; (2) a Technical Point of Contact (“POC”) from TTS Acquisitions will assist in the day to day activities of the contractor; and (3) the problem complexity of this task is modest.

First, due to these requirements being widely used successfully in the commercial marketplace, the risk of the unknown for the government is minimal.

Second, a dedicated Technical POC will ensure that communication between the contractor and TTS will remain consistent and clear, with one person that has the technical know-how to ensure the objectives of this acquisition are met. Considering the limited number of contractors that have a viable solution, the contractor will have an additional incentive to ensure the successful implementation of this project.

Third, due to the fact the contractors that have a viable Bug Bounty SaaS Platform and the network necessary to supports that platform have been in business for several years and have managed bug bounty programs for the industry’s leading companies (e.g., MasterCard, Western Union, Tesla Motors, General Motors, Uber, Adobe, Yahoo!, Twitter, etc.), they should have more-than-adequate technical and professional capabilities to handle this acquisition.

**Cost:** There is a low cost risk associated with this purchase order due to the contracting type being Firm-Fixed-Price and Firm-Fixed Unit Price Not to Exceed.

This type of purchase order places upon the contractor maximum risk and full responsibility for all costs and resulting profit or loss. The unit price for Platform/Network Access and Vulnerability Report Triage Services will not be subject to any adjustment on the basis of the contractor's cost experience in performing the purchase order. The unit price for each Bug Bounty payout can change only upon written agreement between the contractor and the government. Furthermore, if the total amount of Bug Bounty payouts made is less than the total amount earmarked for the Bug Bounty payout pool, the government will be refunded those unused amounts at the end of the POP. Finally, this type of purchase order provides maximum incentive for the contractor to control costs and perform effectively and imposes a minimum administrative burden upon the contracting parties.

It is being used because, after Market Research was performed and the scope established, there is a reasonably definite functional and detailed set of specifications from which we can establish a fair and reasonable price at the outset. This is because available cost or pricing information permits realistic estimates of the probable costs of performance and because performance uncertainties can be identified and reasonable estimates of their cost impact can be made. Furthermore, the potential contractors have expressed a willingness to accept a firm fixed price representing assumption of the risks involved.

There is a small risk that only one of the potential contractors actually makes a bid. In order to mitigate this risk we have done three main things. First, we structured our program so that it closely follows industry-standard practices. This reduces the amount of “custom” work the contractor will have to do. Second, our team has the contacts and reputation within the security industry that potential contractors will be confident in the way in which the project will be ran. Senior leadership at all 3 of the market leading commercial vendors are fully aware and following up with the status of this RFQ. Finally, the potential contractors have all expressed interest in working with government agencies, and in particular, with TTS and 18F. With US CISO Gregory Touhill on record as wanting a government-wide bug bounty program, the contractors are very motivated.

There is a small risk associated with allowing the vendor to make the final vulnerability classifications, which could theoretically lead to higher costs for the government if the vendor systematically over-classifies the vulnerabilities. The decision to allow the vendor to make final vulnerability classification determinations are based on the following factors: (a) it streamlines the process, (b) it insulates TTS from any arguments with researchers about severity, (c) it removes any incentive TTS might have to "underrate" vulnerabilities, and (d) it removes any potential conflicts of interest (e.g. if a known researcher reports an issue, TTS would not be able to reward them more). On the other hand, (a) TTS has less control over individual payouts, (b) greater trust must be placed in the vendor, and therefore (c) TTS must monitor the vendor’s performance more regularly to ensure proper classification.

There is also a small risk associated with the government being lost amongst the other programs on the market. Part of the services provided by the contractor and paid for as part of the Platform and Network Access fee will include marketing and promotional efforts undertaken to promote the TTS Bug Bounty Program. Market research has indicated that not only will most of the potential vendors be likely to provide satisfactory marketing services as part of their usual efforts, they will most likely expend additional efforts, free of charge, due to the fact that the prestige associated with this award will provide a substantial boost to the contractor’s reputation. Furthermore, our ability to raise bug bounty rewards provides an additional amount of flexibility in ensuring our bug bounty program stands out.

To maintain the low financial risk to the government, the following measures will be taken. First, through the use of a Firm-Fixed-Price and Firm-Fixed Unit Price Not To Exceed ("NTE") dollar amount for each bounty payout and the size of the bug bounty pool in total, the government's potential exposure is explicitly limited with the line item ceiling. Second, the government has developed a clear and detailed performance monitoring plan. Third, additional proven measures to prevent degradation in cost, schedule, and performance will be utilized by the technical and administrative POCs to ensure sufficient performance. Additional details related to these measures can be found in the QASP. Fourth, the relatively short duration of the POP (total of 9 months) will limit the government’s risk.

**Schedule:** With the overall procurement, there is a low schedule risk associated with having the contractor ready to begin work at time of award. The contractor’s SaaS platform will need to pass GSA IT Standard Procedures before we can begin to use the software. To mitigate this issue, the technical representatives have already begun working with GSA IT to determine what security measures are required before deployment and, as previously mentioned, have obtained Pilot Program approval already, and are on track to obtain approval prior to issuance of an award, but not later than when the pilot is ready for public launch. The government and contractor will work together to set realistic timeframes and control milestones associated with the support, and all other pertinent deliverables in accordance with the awarded purchase order. There is no cost risk associated with a delay in approval.

There is a low schedule risk associated with having an unknown contractor make a bid and have to start the GSA IT Standard Procedures approval process from the start. The familiarity the GSA IT team as well as the 18F team will have with starting this process will mitigate the impact. There is no cost risk associated with a delay in a start to due to a late approval.

## 7.105(a)(8) Acquisition Streamlining

### Industry Involvement Plan

This requirement has not been specifically designated as a requirement by GSA that is subject to acquisition streamlining, therefore an Industry Involvement Plan is not required.

### Selection and Tailoring of Requirements Plan

This requirement has not been specifically designated by GSA as a requirement that is subject to acquisition streamlining, therefore selection and tailoring of a requirements plan is not required.

### Timeframe for Finalizing Mandatory Requirements

This requirement has not been specifically designated by GSA as a requirement that is subject to acquisition streamlining.

## 7.105(b)(1) Sources

To determine these types of services are not supported by a mandatory source or an existing GSA contract vehicle, the Market Research team interviewed industry partners.

First, the Market Research team focused on determining if mandatory sources were available for use. In accordance with FAR Part 8.002, Priorities for Use of Mandatory Sources and Part 8.003, Use of Other Mandatory Sources, this requirement could not be fulfilled by the higher priority sources such as Federal Prison Industries or SourceAmerica (formerly NISH).

Second, the Market Research team interviewed three leading companies
within the commercial industry: [HackerOne](https://gsa.my.salesforce.com/a1Zt0000000ClpZ), [BugCrowd](https://gsa.my.salesforce.com/a1Zt0000000Clpe), and [Synack](https://gsa.my.salesforce.com/a1Zt0000000Clpo). Currently, these companies do not have existing government contract vehicles, such as a Federal Strategic Sourcing Initiative (FSSI) contracts, Multiple Award Schedule (MAS) contracts, Government-Wide Acquisition Contracts (GWACs) and other multiple agency solutions hosted by GSA.

This requirement is the first of its kind to be generated by a civilian (or non-DOD) federal agency. Only a select few small businesses are able to provide this software as a service.

An in-depth market analysis can be read [here](Market_Research_Report.md).

**Non-GSA GWACs, including NASA SEWP III, ECSIII, and NIH CIO-SP2:** Based on our market research, the absence of vulnerability disclosure policies limits the utility of a GWAC for bug bounty providers. Additionally, no current bug bounty provider is available on a non-GSA GWAC. Therefore, a non-GSA GWAC is not considered to be an optimal solution.

**GSA GWACs, including Alliant, Alliant SB, VETS:** Based on our market research, the absence of vulnerability disclosure policies limits the utility of a GWAC for Bug Bounty providers. Additionally, no current bug bounty provider is available on a GSA GWAC. Therefore, a GSA GWAC is not considered because the contractors who provide a Bug Bounty SaaS Platform with an adequately-sized community of security researchers are not available on a GSA GWAC.

Because this requirement is completely new, alternative established vehicles may be more palatable to potential participants once they have accomplished this first effort.

**FSS Schedule:** The Market Research team interviewed the three known companies within the commercial industry that provide access to their Bug Bounty SaaS Platform and their community of security researchers: [HackerOne](https://gsa.my.salesforce.com/a1Zt0000000ClpZ), [BugCrowd](https://gsa.my.salesforce.com/a1Zt0000000Clpe), [Synack](https://gsa.my.salesforce.com/a1Zt0000000Clpo).

As part of policy [MV-12-07](https://insite.gsa.gov/portal/mediaId/672754/fileName/MV-12-07.action), “GSA Vehicles First” we made the determination these commercial bodies do not have existing government contract vehicles, such as a Federal Strategic Sourcing Initiative (“FSSI”). Although the minimum number of quotation received before seeking additional quotation is 3 per FAR Part 8, the goal of this action is to maximize participation from a wide variety of participants with the necessary skills and abilities to accomplish this effort. Therefore, given the small number of potential offerors, the Federal Supply Schedule (“FSS”) is not suitable at this time. A search of the GSA Schedules indicates that similar companies are not currently in the FSS contracts, specifically, pricelists for IT Schedule 70 SIN 132 40, Cloud Computing Service, which includes commercially available cloud computing services such as Infrastructure-as-a-Service (“IaaS”), Platform-as-a-Service (“PaaS”), and SaaS, and emerging cloud services.

Although bug bounty platforms are not currently available under FSS contracts, TTS has reached out to GSA IT Schedule 70 to determine the process / overview of how to get vendors on schedule utilizing the FAStLane program. This option is likely the best fit for the vendor community if a broader government need exists. Currently, only one civilian agency, GSA, and the DOD have vulnerability policies. Without these policies in place, an agency is unable to procure bug bounty services.

Additionally, as it is too new to be either strategically sourced or managed as a category of spend, at this point in time, this requirement does not align with category management.

Our findings are consistent with similar findings from the DOD, who had a similar requirement that was recently completed with a similar strategy. Given the current market conditions, they also concluded that using FAR Part 15 (Full and Open) competition procedures would be most suitable for such an effort. However, unlike DOD, our approach differs in that we consider the services to be Commercially available to non-federal buyers, and thus are using the Streamlined Synopsis/Solicitation methods outlined in FAR 12.6.

**Small Business Set-Aside:** As indicated in our [Market Research
Report](Market_Research_Report.md), there are most likely only three businesses in the commercial marketplace that offer a suitable Bug Bounty SaaS Platform with a large enough community of security researchers to be considered viable, and they both fit the definition of a small business. Thus, this acquisition will be issued using the Streamlined Synopsis/Solicitation methods and set aside for small businesses.

## 7.105(b)(2) Competition

### Competition

This will be a full and open competition after exclusion of sources using best value determination from an evaluation of process, technical, scoring plan, and price. This allows the government to accomplish its mission in a more efficient and effective manner by gaining contractor expertise in the areas required. The intent of the government is to make a Best Value Selection based on the offer that provides the most advantageous and best value to the government, all factors and prices are considered.

When performing market research, the team utilized their extensive network gained from previous experience within the industry. It was quickly discovered that there are potentially only three - most likely only two - vendors who can satisfy all three required components of this acquisition. Several team members spoke with others in the industry to confirm these findings. Additionally, the team behind the similar DOD-led efforts spoke with the team in this acquisition to share their findings, which mirrored our own. While smaller providers may exist, none of them will have the large network of security research providers or the open community, which are essential parts of this project.

With the outreach program in place at 18F and TTS as a whole, a large number of social media outlets, media contacts, and internal blogs will allow this program to be publicized widely and throughout the industry. The contacts that the 18F team on this project have within the security researcher community as well as the tech industry as a whole will ensure the right people hear about this program as well.

### Consolidation/Bundling

This acquisition can not be considered consolidated or bundled, as the three (3) distinct components are indivisible and have never been acquired by the government prior to this acquisition, whether in part or in whole.

Consolidation or consolidated requirement is defined by FAR Part 2 as "a solicitation for a single contract ... to satisfy ... two or more requirements of the Federal agency for supplies or services that have been provided to or performed for the Federal agency under two or more separate contracts, each of which was lower in cost than the total cost of the contract for which offers are solicited." As previously mentioned, this acquisition will be the first of its kind for a civilian agency in the government as well as the first of its kind for the government as a whole due to the fact that the first government-run bug bounty program was open only to a private community of security researchers rather than a public community.

Bundling is defined as "a subset of consolidation that combines two or more requirements for supplies or services, previously provided or performed under separate small contracts ... into a solicitation for a single contract ... that is likely to be unsuitable for award to a small business concern". As mentioned, never before has there been a contract of this sort within the government. Furthermore, the only potential contractors identified by the market research team are all classified as small business concerns.

### Major Component Competition

There are no major components competition anticipated under this procurement.

### Spare and Repair Parts Competition

There are no spare and repair parts competitions anticipated under this procurement.

### Subcontracting Competition

Subcontracting Competition does not apply to this acquisition.

## 7.105(b)(3) Contract Type Selection

Based on the nature of this requirement, the government intends to award a Firm-Fixed-Price (“FFP”) for basic access to the platform and FFP on a per-application basis. The bounty pool will be Firm-Fixed Unit Price Note-To-Exceed (“NTE”), with varying vulnerability levels but with *all costs paid directly to the researchers*. This type of purchase order was chosen because of a reasonably definite functional and detailed set of specifications from which we can establish a fair and reasonable price at the outset: the contractor will provide Platform/Network Access and Vulnerability Report Triage Services.

## 7.105(b)(4) Source Selection Procedures

This procurement is being conducted in accordance with Federal Acquisition Regulation (FAR) [subpart 12.6](https://www.acquisition.gov/sites/default/files/current/far/html/Subpart%2012_6.html#wp1088488), “Streamlined Procedures for Evaluation and Solicitation for Commercial Items,” as supplemented with additional information included in the RFQ. Technical Factors will be evaluated in accordance with FAR [subpart 12.602](https://www.acquisition.gov/sites/default/files/current/far/html/Subpart%2012_6.html#wp1088491) “Streamlined Evaluation of Offers”. Price will be evaluated in accordance with FAR [subpart 13.106](https://www.acquisition.gov/sites/default/files/current/far/html/Subpart%2013_1.html#wp1125466). Provision [52.212-2](https://www.acquisition.gov/sites/default/files/current/far/html/52_212_213.html#wp1179178), Evaluation -- Commercial Items, does not apply to this requirement. The offerors agree to and are bound by all instructions, procedures and rules of this RFQ. The government is not obligated to determine a competitive range, conduct discussions, solicit final revised quotations, and use other techniques associated with FAR [part 15](https://www.acquisition.gov/sites/default/files/current/far/html/FARTOCP15.html#wp246607). The contracting techniques associated with FAR [part 15](https://www.acquisition.gov/sites/default/files/current/far/html/FARTOCP15.html#wp246607) do not apply.

The bid will be open for 10 days. The format chosen for submission of the bids have been designed to allow for minimal burden on the contractor. Several templates will be provided with the RFQ so that responses can be provided electronically and through pre-formatted documents that will be machine readable such that they are easier to share across platforms and among different people.

The final award for this requirement will be based on best-value principles, utilizing the trade-off process. Accordingly, award will be made to the responsible and technically acceptable offeror whose quotation provides the greatest overall value to the government, price and other factors considered.

The government is more concerned with obtaining superior technical and bug bounty program management capabilities than with making awards at the lowest overall price to the government. However, the government will not make awards at a significantly higher overall price to achieve slightly superior technical value. Offerors are advised that the technical evaluation factors combined are significantly more important than price.

a.  **Evaluation Process.** The government intends to utilize a multi-phased approach for this procurement as described below. To be considered for award, offerors must successfully pass through each Phase.

**Phase 1 (Pass/Fail):** Quote Compliance Check - A compliance check will be conducted to ensure that offerors submit a complete technical quotation and a price quotation following the instructions set on this RFQ letter. The compliance check will involve ensuring that every submission includes the sections outlined in the Quotation Instructions section of the RFQ and then ensuring that each section includes the information required by that same section. Only the offerors that receive Pass will advance to Phase 2. Those who do not advance will receive a notice of their quotation’s rejection via email within three (3) business days after the last quotation has been reviewed.

**Phase 2 :** Oral Interview - Offerors that pass Phase 1 will be notified of the time and date of their oral interview. The oral interview will be focused on the offeror’s technical approach, level of knowledge, technical expertise, and overall understanding of the requirements to manage a bug bounty program for large and high-profile corporations; maintaining a reliable bug bounty SaaS platform; maintaining a community of security researchers with adequate levels of skill and talent, among other factors outlined in the solicitation. The government will also evaluate the offeror’s skills with open source software development, human-centered design, and continuous deployment methods. Each offeror will be provided the questions, via email, approximately 60 minutes before their Oral Presentation.

**Phase 3:** Pricing Schedule and Pricing Narrative Check - Offeror’s Price Quotations will be reviewed.

b.  **Technical Evaluation Factors.** The government will evaluate responses received during Phase 2 for an offeror’s performance or capability acceptability based on the following non-price technical factors, which are of equal importance to each other:

**Technical Understanding and Approach:** The government will evaluate the offeror’s technical approach: level of knowledge, technical expertise, and overall understanding of the requirements to manage a bug bounty program for large and high-profile corporations, maintaining a reliable bug bounty SaaS platform, and maintaining a community of security researchers with adequate levels of skill and talent, among other factors outlined in the solicitation. The government will also evaluate the offeror’s skills with open source software development, human-centered design, and continuous deployment methods.

**Similar Experience/Past Experience:** The government will evaluate the offeror’s experience in delivering bug bounty services to private and public sector clients by measuring platform-wide metrics, including but not limited to, average time to triage a new report, average time to respond to researchers, average time to forward verified reports based on severity, etc.

c.  **Price Evaluation Factors.** Each offeror’s price quotation will be evaluated separately from the technical quotation and oral interview. The government will evaluate the offeror’s pricing schedule as well as pricing narrative after the Oral Interview to ensure that the offered price is fair, reasonable, and realistic. Pricing shall reflect reasonableness, consistency with industry standards. Note that as submissions become more technically equal in their merit, the evaluated price becomes more important. Therefore, offerors are expected to provide their best discounted rates.

d.  **Source Selection Organization.**

Chairperson: TBD, GSA

The Technical Evaluation Panel will consist of the following members:

1.  Jacob Kaplan-Moss

2.  Kimber Dowsett

3.  Omid Ghaffari-Tabrizi

## 7.105(b)(5) Acquisition Considerations

### Equipment Lease or Purchase

This requirement does not involve Lease or Purchase items.

### Section 508

The contractor shall support the government in its conformance with Section 508 throughout the development and implementation of the work to be performed.

The following standard is applicable for compliance: 1194.22 Web-based Intranet and Internet Information and Applications.

The contractor should review the following websites for additional 508 information:

* [http://www.section508.gov/](http://www.section508.gov/)

* [http://www.access-board.gov/508.htm](http://www.access-board.gov/508.htm)

* [http://www.w3.org/WAI/Resources](http://www.w3.org/WAI/Resources)

### Internet Protocol Version 6 Compliance

IPv6 applies to this acquisition. Reference NIST 500-267 and NIST 500-281 for additional guidance on IPv6 requirements. A Supplier's Declaration of Conformity (SDOC) is required, as outlined in the two previous NIST documents. The template for the SDOC can be found at the following URL: [http://www-x.antd.nist.gov/usgv6/sdoc.html](http://www-x.antd.nist.gov/usgv6/sdoc.html).

### Other Information

#### Option Clause: [FAR 52.217-8](https://www.acquisition.gov/sites/default/files/current/far/html/52_217_221.html#wp1135887) - Option to Extend Services

The government may require continued performance of any services within the limits and at the rates specified in the contract.

#### Option Clause: [FAR 52.217-9](https://www.acquisition.gov/sites/default/files/current/far/html/52_217_221.html#wp1135892) - Option to Extend the Term of the Contract

The government may extend the term of this contract by written notice to the contractor within 5 days provided that the government gives the contractor a preliminary written notice of its intent to extend at least 15 days before the contract expires.

#### Option Clause: [GSAR 552.217-71](https://www.acquisition.gov/sites/default/files/current/gsam/html/Part552_Sub2A.html#wp1883922) - Notice Regarding Option(s)

GSA has included an option to extend the term of this purchase order in order to demonstrate the value it places on quality performance by providing a mechanism for continuing a contractual relationship with a successful Offeror that performs at a level which meets or exceeds GSA’s quality performance expectations as communicated to the contractor, in writing, by the Contracting Officer or designated representative.

### Performance Based Elements

Performance based elements will be used to the maximum extent practicable because there are metrics and standards such as average time-to-triage initial reports, triage accuracy, and minimal duplication that need to be achieved in accordance with certain performance objectives. Requirements have been defined by the performance work statement with expected outcomes and the contractor’s performance will be monitored based on the government’s QASP.

### Monitoring Office (or Individual)

The following individuals will monitor contractor performance:

1.  GSA Technical Point of Contact: Jacob Kaplan-Moss

2.  GSA TTS Contracting Officer: Michelle McNellis

3.  GSA TTS Contracting Officer Representative: Laura Gerhardt

TTS will perform all Contracting Officer's Representative (COR) responsibilities for the resulting purchase order. The COR responsibilities will be described in a COR Letter of Appointment. The COR will be responsible for quality assurance surveillance. The TTS Contracting Officer has the authority to issue changes to the purchase order by issuing modifications.

### Rationale for Not Using Performance Based Contracting Methods

Performance based elements will be used.

## 7.105(b)(6) Budgeting & Funding

Funds have been designated for the base period under Purchase Request PR201701130008 in the amount of $67,800.00.

## 7.105(b)(7) Product or Service Descriptions

As part of its programmatic focus on security , TTS needs to purchase access to a pre-existing, commercially available Bug Bounty SaaS Platform that will allow it to launch and manage the TTS Bug Bounty program. This acquisition will give TTS access to a large network of security researchers, people who have an interest - both personally and financially - in helping to find and address bugs and other technical issues within TTS-owned web applications. This program will be the first of its kind to be generated by a civilian (or non-DOD) federal agency. Only a select few small businesses are able to provide this SaaS platform and that large network of researchers.

The contractor will provide access to their Bug Bounty SaaS Platform for researchers to report vulnerabilities (“Platform/Network Access”) and allow TTS to manage and track issues across multiple public web applications, triage services for those reported vulnerabilities, disburse rewards for effective vulnerabilities, and explain the reasons behind rejections (“Vulnerability Report Triage Services”).

The Vulnerability Report Triage Services must be provided on a “per web application” basis, allowing TTS to operate a bug bounty for a web application independently of the other web applications that are utilizing the Platform/Network Access for their own tests. As part of these services, the contractor must provide staff who are specialists in reviewing vulnerability reports and communicating with researchers.

## 7.105(b)(8) Priorities Allocations and Allotments

There is currently no priority rating assigned for performance under this requirement.  If the priority changes during the course of performance, GSA will obtain the appropriate rating and modify the purchase order accordingly.

## 7.105(b)(9) Contractor vs. Government Performance

There is no contractor versus government Performance Considerations under this purchase order. This acquisition is not related to an A-76 effort and does not compare government versus contractor performance of the requirements. This requirement does not fall under OMB Circular A-76 as the government intends to contract with the private sector.

## 7.105(b)(10) Inherently Governmental Functions Consideration

This requirement does not include any inherently governmental or critical functions based on a review of FAR Subpart 7.5; GSAM Subpart 507.5 Inherently Governmental Functions; OFPP Policy Letter 11-01 Performance of Inherently Governmental and Critical Functions; and, GSA Acquisition Alert 2011-07 Inherently Governmental and Critical Functions.

## 7.105(b)(11) Management Information Requirements

In accordance with the [Quality Assurance Surveillance Plan](../solicitation_documents/004_QASP.md) (“QASP”), the government will management the contractor’s performance as detailed within the document.

## 7.105(b)(12) Make or Buy

With regard to the Bug Bounty SaaS Platform, there are no existing government efforts to develop the same or similar tools or applications. To build a rudimentary version would take at least 2-3 person-months (and, likely, substantially longer). At TTS’s current billing rates, the cost would be approximately $100,000.

With regard to access to the network and community of security researchers, there are no existing government efforts to develop a community that can perform the same or similar work with in-house employees. TTS would need to hire an additional 3-4 FTEs, at at least a GS-12 level, to manage triage of incoming issues. The cost would likely exceed $200,000 per year.

Furthermore, it is not feasible for TTS to perform this effort in-house with government employees or under an agreement with another government agency due to the fact that neither TTS nor any other government agency have the requisite numbers of security researchers with the necessary skills or experience on staff.

Finally, In accordance with [FAR 15.407-2(c)](https://www.acquisition.gov/sites/default/files/current/far/html/Subpart%2015_4.html#wp1208671), this acquisition will not require a make-or-buy program because it is less than $13.5M, and the Contracting Officer does not consider the information necessary or applicable due to the nature of the project.

## 7.105(b)(13) Test and Evaluation

The [Quality Assurance Surveillance Plan](../solicitation_documents/004_QASP.md) (“QASP”) specifies particular testing and documentation that the government has determined will lead to positive outcomes from the vendor.

## 7.105(b)(14) Logistics Considerations

### Contractor or Agency Support Assumptions

There are no contractor or agency support assumptions.

### Quality Assurance, Warranty Plans

The contractor shall indicate the warranty period and license period of any software provided throughout the life cycle of this purchase order requirement.

The government will use a [Quality Assurance Surveillance Plan](../solicitation_documents/004_QASP.md) (“QASP”) to monitor the contractor’s performance. The QASP will provide oversight help to ensure that service levels reach and maintain the required levels for performance of this task. Further, the QASP provides the government with a proactive way to avoid unacceptable or deficient performance, and provides verifiable input for the required Past Performance Information Assessments. The QASP is a living document and may be updated by the government as necessary. Any updates to the QASP will be provided to the contractor.

### Data Rights and Ownership of Deliverables

TTS reserves the right to release any data or deliverables created as a result of the work performed under the contract at its own discretion, all releases of which are subject to be committed to the public domain.

For submitted vulnerabilities, the contractor shall use open source technologies wherever possible, in support of the TTS Source Code Policy. All licenses must be expressly listed in the deliverable. Regardless of license(s) used (e.g., MIT, GPL, Creative Commons 0) the license(s) shall be clearly listed in the documentation.

If the contractor needs to use work that does not have an open source license, the contractor is required to request permission from TTS, in writing, before utilizing that work in any way in connection with the order. If approved, all licenses shall be clearly set forth in a conspicuous place when work is delivered to TTS.

If an open source license provides implementation guidance, the contractor shall ensure compliance with that guidance. If implementation guidance is not available, the contractor shall attach or include the license within the work itself. Examples of this include code comments at the beginning of a file or contained in a license file within a software repository.

### Standardization Concepts

Standardization Concepts do not apply to this requirement.

## 7.105(b)(15) Government Furnished Property

The government will not furnish any property under this purchase order.

## 7.105(b)(16) Government Furnished Information

The government will furnish any necessary data within ten (10) days from the time of award.

## 7.105(b)(17) Environmental and Energy Conservation Objectives

### Environmental and Energy Conservation Objectives and Requirements

Pursuant to [FAR 23.000](https://www.acquisition.gov/sites/default/files/current/far/html/FARTOCP23.html#wp227606), no pollution control, energy conservation, hazardous material, or uses of recovered material issues have been identified for this acquisition. This purchase order will not require the use of Class 1 Ozone Depleting Substances (ODS).

### Proposed Environmental Assessment Statement Issue Resolution

There are no proposed environmental assessment statement issue
resolutions for this acquisition.

### Proposed Environmental Impact Statement Issue Resolution

There are no proposed environmental impact statement issue resolutions for this acquisition.

## 7.105(b)(18) Security Considerations

The existing bug bounty SaaS platforms were built off-site and exist within the contractor’s own infrastructure. The SaaS platform will not store or process GSA data, and it will not be owned or run by GSA. Therefore, it will not need a GSA Authority to Operate beyond that required by GSA’s standard IT Security Process.

The GSA’s standard IT Security Policy process, which the GSA applies to all externally-operated Software-as-a-Service providers, review began on November 29, 2016, and it will involve a Legal Review, a 508 Review, an IT Security Review, and an EARC Review. GSA IT believes that the review will be complete prior to award and no later than the anticipated public launch of the TTS Bug Bounty program.

As a result, privacy is a non-issue with respect to this procurement, and all security regulations will be followed.

## 7.105(b)(19) Contract Administration

### Administrators

This acquisition will be administered by the following individuals:

1.  Michelle McNellis , GSA/TTS/OA, Contracting Officer

2.  Laura Gerhardt, GSA/TTS/OA Contracting Officer Representative

### Standard

Please see Section 2.0 of the attached [Quality Assurance Surveillance Plan](../solicitation_documents/004_QASP.md) (“QASP”).

## 7.105(b)(20) Other Considerations

[See attached Addendum with additional contract clauses](../solicitation_documents/002_Addendum.md).

## 7.105(b) (21) Milestones for the Acquisition Cycle Applicable Milestones

See attached milestone schedule. *(Note: this was a link to an internal milestone chart that included the task, the projected date of completion, the actual date of completion, and a description of a reason for any delays that may have occurred.)*
