# TTS Bug Bounty

This solicitation is posted to FBO under [**TTS_Bug_Bounty**](https://www.fbo.gov/notices/e21b0d5dd866c3bf82c9013e24272403). Please submit any questions as GitHub issues in this repository by *February 21, 2017 at 4:00pm EST*. The TTS Contracting Officer will only be responding to questions submitted using the Issue Template. Comments from other parties or in other formats will still be considered but we cannot commit to responding to them.

**Proposals are due by February 28, 2017 at 4:00pm EST.**

## Background

As part of its programmatic focus on security, the [Technology Transformation Service](https://www.gsa.gov/portal/category/25729) (TTS) needs to purchase access to a pre-existing, commercially available Bug Bounty SaaS Platform that will allow it to launch and manage the TTS Bug Bounty program. This acquisition will give TTS access to a large network of security researchers, people who have an interest - both personally and financially - in helping to find and address bugs and other technical issues within TTS-owned web applications.

### What we're hoping to end up with

The purpose of this solicitation is for the contractor to deliver a Bug Bounty program which TTS will utilize for TTS-owned web applications. The contractor will provide access to their Bug Bounty SaaS Platform for researchers to report vulnerabilities (“Platform/Network Access”) and allow TTS to manage and track issues across multiple public web applications, triage services for those reported vulnerabilities, disburse rewards for effective vulnerabilities, and explain the reasons behind rejections (“Vulnerability Report Triage Services”).

### How to respond

Detailed instructions about how to respond and how to use our [response templates](solicitation_documents/response_templates) are explained in [section 7.0 of our RFQ](solicitation_documents/001_RFQ.md#70-quotation-instructions).

### Key personnel

Details about what we're looking for in a Technical Account Manager are explained in [section 6.1 of our PWS](solicitation_documents/003_PWS.md#61-key-personnel).

### Period of performance

There will be a Base Period of 3 months and two Option Periods of 3 months each. Details, including the official start date, are explained in [section 3.0 of our RFQ](solicitation_documents/001_RFQ.md#30-period-of-performance).

## Contents

1. [Request for Quotation (RFQ)](solicitation_documents/001_RFQ.md)

2. [Addendum](solicitation_documents/002_Addendum.md)

3. [Performance Work Statement (PWS)](solicitation_documents/003_PWS.md)

4. [Performance Based Quality Assurance Surveillance Plan (QASP)](solicitation_documents/004_QASP.md)

5. [Technical File](solicitation_documents/response_templates/005_TECHNICAL_FILE.yaml)

6. [Pricing File](solicitation_documents/response_templates/006_PRICING_FILE.yaml)

7. [Signature File](solicitation_documents/response_templates/007_SIGNATURE_FILE.md)

8. [SF30 Amendment 001](solicitation_documents/SF30-%20Bug%20Bounty-%20001.pdf)

## Contributing

See [CONTRIBUTING](../CONTRIBUTING.md) for additional information.

## Public domain

This project is in the worldwide [public domain](../LICENSE.md). As stated in [CONTRIBUTING](../CONTRIBUTING.md):

> This project is in the public domain within the United States, and copyright and related rights in the work worldwide are waived through the [CC0 1.0 Universal public domain dedication](https://creativecommons.org/publicdomain/zero/1.0/).
>
> All contributions to this project will be released under the CC0 dedication. By submitting a pull request, you are agreeing to comply with this waiver of copyright interest.
