/**
 * 
 */
package no.hvl.dat104.util;

import org.apache.commons.lang.StringEscapeUtils;

/**
 * @author krist
 *
 */
public class ValideringUtil {

	/**
	 * Fornavn skal vre 2-20 tegn og kan inneholde bokstaver(inkl. ),
	 * bindestrek og mellomrom. Frste tegn skal vre en stor bokstav
	 * 
	 * @param s
	 *            Fornavn
	 * @return True eller False
	 */
	public static boolean validerFornavn(String s) {
		String regex = "^[A-Z]([a-z\\']|(\\-|\\s)[A-Z]){1,19}$";
		return (s != null) && s.matches(regex);
	}

	/**
	 * Etternavn skal vre 2-20 tegn og kan inneholde bokstaver (inkl. ) og
	 * bindestrek (IKKE mellomrom). Frste tegn skal vre en stor bokstav.
	 * 
	 * @param s
	 * @return
	 */
	public static boolean validerEtternavn(String s) {
		String regex = "^[A-Z]([a-z\\']|\\-[A-Z]){1,19}$";
		return (s != null) && s.matches(regex);
	}

	/**
	 * Mobil skal vre eksakt 8 siffer, ingenting annet.
	 * 
	 * @param s
	 * @return
	 */
	public static boolean validerNummer(String s) {
		String regex = "^\\d{8}$";
		return (s != null) && s.matches(regex);
	}

	/**
	 * Escaper all html kode
	 * 
	 * @param s
	 *            String som skal valideres
	 * @return String uten html kode
	 */
	public static String escapeHTML(String s) {
		return StringEscapeUtils.escapeHtml(s);
	}
}
