--- Missing or renamed enums.
-- @module invokation.const.enums
local M = {}

--- Missing (GameActivity_t) ACT_INVALID
M.ACT_INVALID = -1

--- Renamed (ABILITY_TYPES) ABILITY_TYPE_ATTRIBUTES
M.DOTA_ABILITY_TYPE_ATTRIBUTES = ABILITY_TYPE_ATTRIBUTES
--- Renamed (ABILITY_TYPES) ABILITY_TYPE_BASIC
M.DOTA_ABILITY_TYPE_BASIC = ABILITY_TYPE_BASIC
--- Renamed (ABILITY_TYPES) ABILITY_TYPE_HIDDEN
M.DOTA_ABILITY_TYPE_HIDDEN = ABILITY_TYPE_HIDDEN
--- Renamed (ABILITY_TYPES) ABILITY_TYPE_ULTIMATE
M.DOTA_ABILITY_TYPE_ULTIMATE = ABILITY_TYPE_ULTIMATE

--- Missing (DOTA_ABILITY_BEHAVIOR) DOTA_ABILITY_BEHAVIOR_NOASSIST
M.DOTA_ABILITY_BEHAVIOR_NOASSIST = 0

--- No flags.
-- (0)
M.FCVAR_NONE = 0
--- Don't add to linked list, etc.
-- (1)
M.FCVAR_UNREGISTERED = bit.lshift(1, 0)
--- Hidden in released products.
-- (2)
M.FCVAR_DEVELOPMENTONLY = bit.lshift(1, 1)
--- Defined by the game DLL.
-- (4)
M.FCVAR_GAMEDLL = bit.lshift(1, 2)
--- Defined by the client DLL.
-- (8)
M.FCVAR_CLIENTDLL = bit.lshift(1, 3)
--- Hidden.
-- Doesn't appear in find or autocomplete. Like DEVELOPMENTONLY, but can't be compiled out.
-- (16)
M.FCVAR_HIDDEN = bit.lshift(1, 4)
--- Defined by the material system (EP1-only).
-- (16)
M.FCVAR_MATERIAL_SYSTEM = bit.lshift(1, 4)
--- Server cvar, but we don't send the data since it's a password, etc.
-- (32)
M.FCVAR_PROTECTED = bit.lshift(1, 5)
--- Cvar cannot be changed by clients connected to a multiplayer server.
-- (64)
M.FCVAR_SPONLY = bit.lshift(1, 6)
--- Cvar is saved (config.cfg, vars.rc, etc).
-- (128)
M.FCVAR_ARCHIVE = bit.lshift(1, 7)
--- Notifies players when changed.
-- (256)
M.FCVAR_NOTIFY = bit.lshift(1, 8)
--- Changes the client's info string.
-- (512)
M.FCVAR_USERINFO = bit.lshift(1, 9)
--- This var's string cannot contain unprintable characters.
-- (e.g., used for player name, etc.)
-- (1024)
M.FCVAR_PRINTABLEONLY = bit.lshift(1, 10)
--- If this is a server, don't log changes to the log file / console if we are creating a log.
-- (2048)
M.FCVAR_UNLOGGED = bit.lshift(1, 11)
--- Never try to print.
-- (4096)
M.FCVAR_NEVER_AS_STRING = bit.lshift(1, 12)
--- Server setting enforced on clients.
-- (8192)
M.FCVAR_REPLICATED = bit.lshift(1, 13)
--- Only useable in singleplayer / debug / multiplayer & `sv_cheats 1`.
-- (16384)
M.FCVAR_CHEAT = bit.lshift(1, 14)
--- Causes varnameN where N in interval (2, max) splitscreen slots for mod to be autogenerated.
-- (32768)
M.FCVAR_SS = bit.lshift(1, 15)
-- (32768)
M.FCVAR_STUDIORENDER = bit.lshift(1, 15)
--- Record the cvar when starting a demo file.
-- (65536)
M.FCVAR_DEMO = bit.lshift(1, 16)
--- Don't record the command in demo files.
-- (131072)
M.FCVAR_DONTRECORD = bit.lshift(1, 17)
--- This is one of the "added" @{FCVAR_SS} variables for the splitscreen players.
-- (262144)
M.FCVAR_SS_ADDED = bit.lshift(1, 18)
-- (262144)
M.FCVAR_PLUGIN = bit.lshift(1, 18)
--- Only available in released products.
-- (524288)
M.FCVAR_RELEASE = bit.lshift(1, 19)
-- (524288)
M.FCVAR_DATACACHE = bit.lshift(1, 19)
--- If the cvar changes, it forces a material reload.
-- (1048576)
M.FCVAR_RELOAD_MATERIALS = bit.lshift(1, 20)
-- (1048576)
M.FCVAR_TOOLSYSTEM = bit.lshift(1, 20)
--- If the cvar changes, if forces a texture reload.
-- (2097152)
M.FCVAR_RELOAD_TEXTURES = bit.lshift(1, 21)
-- (2097152)
M.FCVAR_FILESYSTEM = bit.lshift(1, 21)
--- Cvar cannot be changed by a client that is connected to a server.
-- (4194304)
M.FCVAR_NOT_CONNECTED = bit.lshift(1, 22)
--- Cvar is read from the material system thread.
-- (8388608)
M.FCVAR_MATERIAL_SYSTEM_THREAD = bit.lshift(1, 23)
-- (8388608)
M.FCVAR_SOUNDSYSTEM = bit.lshift(1, 23)
--- Cvar written to config.cfg on the Xbox.
-- (16777216)
M.FCVAR_ARCHIVE_XBOX = bit.lshift(1, 24)
--- Cvar written to config.cfg on the Xbox.
-- (16777216)
M.FCVAR_ARCHIVE_GAMECONSOLE = bit.lshift(1, 24)
--- Used as a debugging tool necessary to check material system thread cvars.
-- (33554432)
M.FCVAR_ACCESSIBLE_FROM_THREADS = bit.lshift(1, 25)
-- (33554432)
M.FCVAR_INPUTSYSTEM = bit.lshift(1, 25)
-- (67108864)
M.FCVAR_NETWORKSYSTEM = bit.lshift(1, 26)
-- (134217728)
M.FCVAR_VPHYSICS = bit.lshift(1, 27)
--- Server is allowed to execute the command on clients.
-- (268435456)
M.FCVAR_SERVER_CAN_EXECUTE = bit.lshift(1, 28)
--- Server is not allowed to query the cvar's value
-- (536870912)
M.FCVAR_SERVER_CANNOT_QUERY = bit.lshift(1, 29)
--- Focus vconsole on change?
-- (1073741824)
M.FCVAR_VCONSOLE_SET_FOCUS = bit.lshift(1, 30)
--- `clientcmd` is allowed to execute this command.
-- (1073741824)
M.FCVAR_CLIENTCMD_CAN_EXECUTE = bit.lshift(1, 30)

return M
