-- 
-- Generated by dota2-pos5
-- 

--# selene: allow(unscoped_variables)
--# selene: allow(unused_variable)

--- @module "dota2.types"
--- @module "dota2.enums"

--- @meta dota2

--- @class CBaseAnimatingActivity : CBaseModelEntity
CBaseAnimatingActivity = {}

--- Returns the duration in seconds of the active sequence.
--- 
--- (availability: server)
--- @return number
function CBaseAnimatingActivity:ActiveSequenceDuration() end

--- Get the cycle of the animation.
--- 
--- (availability: server)
--- @return number
function CBaseAnimatingActivity:GetCycle() end

--- Returns the name of the active sequence.
--- 
--- (availability: server)
--- @return string
function CBaseAnimatingActivity:GetSequence() end

--- Ask whether the main sequence is done playing.
--- 
--- (availability: server)
--- @return boolean
function CBaseAnimatingActivity:IsSequenceFinished() end

--- Sets the active sequence by name, resetting the current cycle.
--- 
--- (availability: server)
--- @param sequenceName string
--- @return nil
function CBaseAnimatingActivity:ResetSequence(sequenceName) end

--- Returns the duration in seconds of the given sequence name.
--- 
--- (availability: server)
--- @param sequenceName string
--- @return number
function CBaseAnimatingActivity:SequenceDuration(sequenceName) end

--- Set the cycle of the animation.
--- 
--- (availability: server)
--- @param cycle number
--- @return nil
function CBaseAnimatingActivity:SetCycle(cycle) end

--- Set the specified pose parameter to the specified value.
--- 
--- (availability: server)
--- @param name string
--- @param value number
--- @return number
function CBaseAnimatingActivity:SetPoseParameter(name, value) end

--- Sets the active sequence by name, keeping the current cycle.
--- 
--- (availability: server)
--- @param sequenceName string
--- @return nil
function CBaseAnimatingActivity:SetSequence(sequenceName) end

--- Stop the current animation by setting playback rate to 0.0.
--- 
--- (availability: server)
--- @return nil
function CBaseAnimatingActivity:StopAnimation() end


--- @class CBaseAnimGraph : CBaseModelEntity
CBaseAnimGraph = {}

--- Get the value of the given animGraph parameter.
--- 
--- (availability: server)
--- @param param string
--- @return table
function CBaseAnimGraph:GetGraphParameter(param) end

--- Pass the desired look target in world space to the graph.
--- 
--- (availability: server)
--- @param value Vector
--- @return nil
function CBaseAnimGraph:SetGraphLookTarget(value) end

--- Set the specific param value, type is inferred from the type in script.
--- 
--- (availability: server)
--- @param param string
--- @param svArg table
--- @return nil
function CBaseAnimGraph:SetGraphParameter(param, svArg) end

--- Set the specific param on or off.
--- 
--- (availability: server)
--- @param name string
--- @param value boolean
--- @return nil
function CBaseAnimGraph:SetGraphParameterBool(name, value) end

--- Pass the enum (int) value to the specified param.
--- 
--- (availability: server)
--- @param name string
--- @param value integer
--- @return nil
function CBaseAnimGraph:SetGraphParameterEnum(name, value) end

--- Pass the float value to the specified param.
--- 
--- (availability: server)
--- @param name string
--- @param value number
--- @return nil
function CBaseAnimGraph:SetGraphParameterFloat(name, value) end

--- Pass the int value to the specified param.
--- 
--- (availability: server)
--- @param name string
--- @param value integer
--- @return nil
function CBaseAnimGraph:SetGraphParameterInt(name, value) end

--- Pass the vector value to the specified param in the graph.
--- 
--- (availability: server)
--- @param name string
--- @param value Vector
--- @return nil
function CBaseAnimGraph:SetGraphParameterVector(name, value) end


--- @class CBaseCombatCharacter : CBaseFlex
CBaseCombatCharacter = {}

--- @class CBaseEntity : CEntityInstance
CBaseEntity = {}

--- Adds the render effect flag.
--- 
--- (availability: server)
--- @param flags EntityEffects
--- @return nil
function CBaseEntity:AddEffects(flags) end

--- Apply a Velocity Impulse.
--- 
--- (availability: server)
--- @param vecImpulse Vector
--- @return nil
function CBaseEntity:ApplyAbsVelocityImpulse(vecImpulse) end

--- Apply an Ang Velocity Impulse.
--- 
--- (availability: server)
--- @param angImpulse Vector
--- @return nil
function CBaseEntity:ApplyLocalAngularVelocityImpulse(angImpulse) end

--- Get float value for an entity attribute.
--- 
--- (availability: server)
--- @param name string
--- @param default number
--- @return number
function CBaseEntity:Attribute_GetFloatValue(name, default) end

--- Get int value for an entity attribute.
--- 
--- (availability: server)
--- @param name string
--- @param default integer
--- @return integer
function CBaseEntity:Attribute_GetIntValue(name, default) end

--- Set float value for an entity attribute.
--- 
--- (availability: server)
--- @param name string
--- @param value number
--- @return nil
function CBaseEntity:Attribute_SetFloatValue(name, value) end

--- Set int value for an entity attribute.
--- 
--- (availability: server)
--- @param name string
--- @param value integer
--- @return nil
function CBaseEntity:Attribute_SetIntValue(name, value) end

--- Delete an entity attribute.
--- 
--- (availability: server)
--- @param name string
--- @return nil
function CBaseEntity:DeleteAttribute(name) end

--- Plays a sound from this entity.
--- 
--- (availability: server)
--- @param soundname string
--- @return nil
function CBaseEntity:EmitSound(soundname) end

--- Plays/modifies a sound from this entity. changes sound if nPitch and/or flVol or flSoundTime is > 0.
--- 
--- (availability: server)
--- @param soundName string
--- @param pitch integer
--- @param volume number
--- @param delay number
--- @return nil
function CBaseEntity:EmitSoundParams(soundName, pitch, volume, delay) end

--- Get the qangles that this entity is looking at.
--- 
--- (availability: server)
--- @return QAngle
function CBaseEntity:EyeAngles() end

--- Get vector to eye position - absolute coords.
--- 
--- (availability: server)
--- @return Vector
function CBaseEntity:EyePosition() end

--- (availability: server)
--- @return CBaseEntity
function CBaseEntity:FirstMoveChild() end

--- (availability: server)
--- @param entity CBaseEntity
--- @param boneMerge boolean
--- @return nil
function CBaseEntity:FollowEntity(entity, boneMerge) end

--- HEntity to follow, string BoneOrAttachName.
--- 
--- (availability: server)
--- @param ent userdata
--- @param boneOrAttachName string
--- @return nil
function CBaseEntity:FollowEntityMerge(ent, boneOrAttachName) end

--- Returns a table containing the criteria that would be used for response queries on this entity. This is the same as the table that is passed to response rule script function callbacks.
--- 
--- (availability: server)
--- @param result userdata
--- @return nil
function CBaseEntity:GatherCriteria(result) end

--- (availability: server & client)
--- @return Vector
function CBaseEntity:GetAbsOrigin() end

--- (availability: server)
--- @return number
function CBaseEntity:GetAbsScale() end

--- (availability: server)
--- @return QAngle
function CBaseEntity:GetAngles() end

--- Get entity pitch, yaw, roll as a vector.
--- 
--- (availability: server)
--- @return Vector
function CBaseEntity:GetAnglesAsVector() end

--- Get the local angular velocity - returns a vector of pitch,yaw,roll.
--- 
--- (availability: server)
--- @return Vector
function CBaseEntity:GetAngularVelocity() end

--- Get Base? velocity.
--- 
--- (availability: server)
--- @return Vector
function CBaseEntity:GetBaseVelocity() end

--- Get a vector containing max bounds, centered on object.
--- 
--- (availability: server)
--- @return Vector
function CBaseEntity:GetBoundingMaxs() end

--- Get a vector containing min bounds, centered on object.
--- 
--- (availability: server)
--- @return Vector
function CBaseEntity:GetBoundingMins() end

--- Get a table containing the 'Mins' & 'Maxs' vector bounds, centered on object.
--- 
--- (availability: server)
--- @return EntityBounds
function CBaseEntity:GetBounds() end

--- Get vector to center of object - absolute coords.
--- 
--- (availability: server)
--- @return Vector
function CBaseEntity:GetCenter() end

--- Get the entities parented to this entity.
--- 
--- (availability: server)
--- @return CBaseEntity[]
function CBaseEntity:GetChildren() end

--- Looks up a context and returns it if available. May return string, float, or null (if the context isn't found).
--- 
--- (availability: server)
--- @param name string
--- @return string | number | nil
function CBaseEntity:GetContext(name) end

--- Get the forward vector of the entity.
--- 
--- (availability: server)
--- @return Vector
function CBaseEntity:GetForwardVector() end

--- Get the health of this entity.
--- 
--- (availability: server & client)
--- @return integer
function CBaseEntity:GetHealth() end

--- Get the left vector of the entity.
--- 
--- (availability: server)
--- @return Vector
function CBaseEntity:GetLeftVector() end

--- Get entity local pitch, yaw, roll as a QAngle.
--- 
--- (availability: server)
--- @return QAngle
function CBaseEntity:GetLocalAngles() end

--- Maybe local angvel.
--- 
--- (availability: server)
--- @return QAngle
function CBaseEntity:GetLocalAngularVelocity() end

--- Get entity local origin as a Vector.
--- 
--- (availability: server)
--- @return Vector
function CBaseEntity:GetLocalOrigin() end

--- (availability: server)
--- @return number
function CBaseEntity:GetLocalScale() end

--- Get Entity relative velocity.
--- 
--- (availability: server)
--- @return Vector
function CBaseEntity:GetLocalVelocity() end

--- Get the mass of an entity. (returns 0 if it doesn't have a physics object).
--- 
--- (availability: server)
--- @return number
function CBaseEntity:GetMass() end

--- Get the maximum health of this entity.
--- 
--- (availability: server & client)
--- @return integer
function CBaseEntity:GetMaxHealth() end

--- Returns the name of the model.
--- 
--- (availability: server)
--- @return string
function CBaseEntity:GetModelName() end

--- If in hierarchy, retrieves the entity's parent.
--- 
--- (availability: server)
--- @return CBaseEntity
function CBaseEntity:GetMoveParent() end

--- (availability: server)
--- @return Vector
function CBaseEntity:GetOrigin() end

--- Gets this entity's owner.
--- 
--- (availability: server)
--- @return CBaseEntity
function CBaseEntity:GetOwner() end

--- Get the owner entity, if there is one.
--- 
--- (availability: server)
--- @return CBaseEntity
function CBaseEntity:GetOwnerEntity() end

--- Get the right vector of the entity. WARNING: This produces a left-handed coordinate system. Use GetLeftVector instead (which is aligned with the y axis of the entity).
--- 
--- (availability: server)
--- @return Vector
function CBaseEntity:GetRightVector() end

--- If in hierarchy, walks up the hierarchy to find the root parent.
--- 
--- (availability: server)
--- @return CBaseEntity
function CBaseEntity:GetRootMoveParent() end

--- Returns float duration of the sound. Takes soundname and optional actormodelname.
--- 
--- (availability: server)
--- @param soundname string
--- @param actormodel string
--- @return number
function CBaseEntity:GetSoundDuration(soundname, actormodel) end

--- Returns the spawn group handle of this entity.
--- 
--- (availability: server)
--- @return SpawnGroupHandle
function CBaseEntity:GetSpawnGroupHandle() end

--- Get the team number of this entity.
--- 
--- (availability: server)
--- @return DOTATeam_t
function CBaseEntity:GetTeam() end

--- Get the team number of this entity.
--- 
--- (availability: server & client)
--- @return DOTATeam_t
function CBaseEntity:GetTeamNumber() end

--- Get the up vector of the entity.
--- 
--- (availability: server)
--- @return Vector
function CBaseEntity:GetUpVector() end

--- (availability: server)
--- @return Vector
function CBaseEntity:GetVelocity() end

--- See if an entity has a particular attribute.
--- 
--- (availability: server)
--- @param name string
--- @return boolean
function CBaseEntity:HasAttribute(name) end

--- Is this entity alive?
--- 
--- (availability: server)
--- @return boolean
function CBaseEntity:IsAlive() end

--- Is this entity an CDOTA_BaseNPC?
--- 
--- (availability: server & client)
--- @return boolean
function CBaseEntity:IsBaseNPC() end

--- Is this entity a Dota NPC?
--- 
--- (availability: server)
--- @return boolean
function CBaseEntity:IsDOTANPC() end

--- (availability: server & client)
--- @param classOrClassName string | table
--- @return boolean
function CBaseEntity:IsInstance(classOrClassName) end

--- Is this entity an CAI_BaseNPC?
--- 
--- (availability: server)
--- @return boolean
function CBaseEntity:IsNPC() end

--- Back compat: Is this entity a player pawn *or* controller?
--- 
--- (availability: server)
--- @return boolean
function CBaseEntity:IsPlayer() end

--- Is this entity a player controller?
--- 
--- (availability: server)
--- @return boolean
function CBaseEntity:IsPlayerController() end

--- Is this entity a player pawn?
--- 
--- (availability: server)
--- @return boolean
function CBaseEntity:IsPlayerPawn() end

--- (availability: server)
--- @return nil
function CBaseEntity:Kill() end

--- (availability: server)
--- @return CBaseEntity
function CBaseEntity:NextMovePeer() end

--- Takes duration, value for a temporary override.
--- 
--- (availability: server)
--- @param duration number
--- @param friction number
--- @return nil
function CBaseEntity:OverrideFriction(duration, friction) end

--- Precache a sound for later playing.
--- 
--- (availability: server)
--- @param soundname string
--- @return nil
function CBaseEntity:PrecacheScriptSound(soundname) end

--- Removes the render effect flag.
--- 
--- (availability: server)
--- @param flags EntityEffects
--- @return nil
function CBaseEntity:RemoveEffects(flags) end

--- Set entity pitch, yaw, roll by component.
--- 
--- (availability: server)
--- @param pitch number
--- @param yaw number
--- @param roll number
--- @return nil
function CBaseEntity:SetAbsAngles(pitch, yaw, roll) end

--- (availability: server)
--- @param origin Vector
--- @return nil
function CBaseEntity:SetAbsOrigin(origin) end

--- (availability: server)
--- @param scale number
--- @return nil
function CBaseEntity:SetAbsScale(scale) end

--- Set entity pitch, yaw, roll by component.
--- 
--- (availability: server)
--- @param pitch number
--- @param yaw number
--- @param roll number
--- @return nil
function CBaseEntity:SetAngles(pitch, yaw, roll) end

--- Set the local angular velocity.
--- 
--- (availability: server)
--- @param pitchVel number
--- @param yawVel number
--- @param rollVel number
--- @return nil
function CBaseEntity:SetAngularVelocity(pitchVel, yawVel, rollVel) end

--- Set the position of the constraint.
--- 
--- (availability: server)
--- @param pos Vector
--- @return nil
function CBaseEntity:SetConstraint(pos) end

--- Store any key/value pair in this entity's dialog contexts. Value must be a string. Will last for duration (set 0 to mean 'forever').
--- 
--- (availability: server)
--- @param name string
--- @param value string
--- @param duration number
--- @return nil
function CBaseEntity:SetContext(name, value, duration) end

--- Store any key/value pair in this entity's dialog contexts. Value must be a number (int or float). Will last for duration (set 0 to mean 'forever').
--- 
--- (availability: server)
--- @param name string
--- @param value number
--- @param duration number
--- @return nil
function CBaseEntity:SetContextNum(name, value, duration) end

--- Set a think function on this entity.
--- 
--- (availability: server & client)
--- @param contextName string
--- @param thinkFunc fun(entity: CBaseEntity): number | nil | nil
--- @param interval number
--- @return nil
function CBaseEntity:SetContextThink(contextName, thinkFunc, interval) end

--- Set the name of an entity.
--- 
--- (availability: server)
--- @param name string
--- @return nil
function CBaseEntity:SetEntityName(name) end

--- Set the orientation of the entity to have this forward vector.
--- 
--- (availability: server)
--- @param v Vector
--- @return nil
function CBaseEntity:SetForwardVector(v) end

--- Set PLAYER friction, ignored for objects.
--- 
--- (availability: server)
--- @param friction number
--- @return nil
function CBaseEntity:SetFriction(friction) end

--- Set PLAYER gravity, ignored for objects.
--- 
--- (availability: server)
--- @param gravity number
--- @return nil
function CBaseEntity:SetGravity(gravity) end

--- Set the health of this entity.
--- 
--- (availability: server)
--- @param health integer
--- @return nil
function CBaseEntity:SetHealth(health) end

--- Set entity local pitch, yaw, roll by component.
--- 
--- (availability: server)
--- @param pitch number
--- @param yaw number
--- @param roll number
--- @return nil
function CBaseEntity:SetLocalAngles(pitch, yaw, roll) end

--- Set entity local origin from a Vector.
--- 
--- (availability: server)
--- @param origin Vector
--- @return nil
function CBaseEntity:SetLocalOrigin(origin) end

--- (availability: server)
--- @param scale number
--- @return nil
function CBaseEntity:SetLocalScale(scale) end

--- Set the mass of an entity. (does nothing if it doesn't have a physics object).
--- 
--- (availability: server)
--- @param mass number
--- @return nil
function CBaseEntity:SetMass(mass) end

--- Set the maximum health of this entity.
--- 
--- (availability: server)
--- @param amt integer
--- @return nil
function CBaseEntity:SetMaxHealth(amt) end

--- (availability: server)
--- @param v Vector
--- @return nil
function CBaseEntity:SetOrigin(v) end

--- Sets this entity's owner. This entity will be returned by GetOwner() and GetOwnerEntity(). GetPlayerOwner() and GetPlayerOwnerID() will be automatically inferred from this entity.
--- 
--- (availability: server)
--- @param owner CBaseEntity
--- @return nil
function CBaseEntity:SetOwner(owner) end

--- Set the parent for this entity.
--- 
--- (availability: server)
--- @param parent CBaseEntity
--- @param attachmentname string
--- @return nil
function CBaseEntity:SetParent(parent, attachmentname) end

--- (availability: server)
--- @param teamNum DOTATeam_t
--- @return nil
function CBaseEntity:SetTeam(teamNum) end

--- Set a think function on this entity. Uses `CBaseEntity:SetContextThink` internally.
--- Note: optional parameters can be given in any order.
--- 
--- (availability: server & client)
--- @param functionName fun(entity: CBaseEntity): number | nil | string If `context` is provided, think function would perform a dynamic lookup on `context` table. Otherwise searches for that function name in caller scope.
--- @param context table | nil
--- @param contextName string | nil Defaults to `functionName` if it's a string.
--- @param initialDelay number | nil Defaults to 0 (next game frame).
--- @return nil
function CBaseEntity:SetThink(functionName, context, contextName, initialDelay) end

--- (availability: server)
--- @param vecVelocity Vector
--- @return nil
function CBaseEntity:SetVelocity(vecVelocity) end

--- Stops a named sound playing from this entity.
--- 
--- (availability: server)
--- @param soundname string
--- @return nil
function CBaseEntity:StopSound(soundname) end

--- Stops thinker created with `CBaseEntity.SetThink`.
--- Alias for `CBaseEntity:SetContextThink(contextName, nil, 0)`.
--- 
--- (availability: server & client)
--- @param contextName string
--- @return nil
function CBaseEntity:StopThink(contextName) end

--- Apply damage to this entity. Use CreateDamageInfo() to create a damageinfo object.
--- 
--- (availability: server)
--- @param damageInfo CTakeDamageInfo
--- @return integer
function CBaseEntity:TakeDamage(damageInfo) end

--- Returns the input Vector transformed from entity to world space.
--- 
--- (availability: server)
--- @param point Vector
--- @return Vector
function CBaseEntity:TransformPointEntityToWorld(point) end

--- Returns the input Vector transformed from world to entity space.
--- 
--- (availability: server)
--- @param point Vector
--- @return Vector
function CBaseEntity:TransformPointWorldToEntity(point) end

--- Fires off this entity's OnTrigger responses.
--- 
--- (availability: server)
--- @return nil
function CBaseEntity:Trigger() end

--- Validates the private script scope and creates it if one doesn't exist.
--- 
--- (availability: server)
--- @return nil
function CBaseEntity:ValidatePrivateScriptScope() end


--- @class CBaseFlex : CBaseAnimatingActivity
CBaseFlex = {}

--- Returns the instance of the oldest active scene entity (if any).
--- 
--- (availability: server)
--- @return CSceneEntity | nil
function CBaseFlex:GetCurrentScene() end

--- Returns the instance of the scene entity at the specified index.
--- 
--- (availability: server)
--- @param index integer
--- @return CSceneEntity | nil
function CBaseFlex:GetSceneByIndex(index) end

--- Play specified vcd file.
--- 
--- (availability: server)
--- @param scene string
--- @param delay number
--- @return number
function CBaseFlex:ScriptPlayScene(scene, delay) end


--- @class CBaseModelEntity : CBaseEntity
CBaseModelEntity = {}

--- Get the attachment id's angles as a p,y,r vector.
--- 
--- (availability: server)
--- @param attachment integer
--- @return Vector
function CBaseModelEntity:GetAttachmentAngles(attachment) end

--- Get the attachment id's forward vector.
--- 
--- (availability: server)
--- @param attachment integer
--- @return Vector
function CBaseModelEntity:GetAttachmentForward(attachment) end

--- Get the attachment id's origin vector.
--- 
--- (availability: server)
--- @param attachment integer
--- @return Vector
function CBaseModelEntity:GetAttachmentOrigin(attachment) end

--- Get the material group hash of this entity.
--- 
--- (availability: server)
--- @return integer
function CBaseModelEntity:GetMaterialGroupHash() end

--- Get the mesh group mask of this entity.
--- 
--- (availability: server)
--- @return Uint64
function CBaseModelEntity:GetMaterialGroupMask() end

--- Get scale of entity's model.
--- 
--- (availability: server)
--- @return number
function CBaseModelEntity:GetModelScale() end

--- Get the alpha modulation of this entity.
--- 
--- (availability: server & client)
--- @return integer
function CBaseModelEntity:GetRenderAlpha() end

--- Get the render color of the entity.
--- 
--- (availability: server)
--- @return Vector
function CBaseModelEntity:GetRenderColor() end

--- Get the named attachment id.
--- 
--- (availability: server)
--- @param attachmentName string
--- @return integer
function CBaseModelEntity:ScriptLookupAttachment(attachmentName) end

--- Sets a bodygroup.
--- 
--- (availability: server)
--- @param group integer
--- @param value integer
--- @return nil
function CBaseModelEntity:SetBodygroup(group, value) end

--- Sets a bodygroup by name.
--- 
--- (availability: server)
--- @param name string
--- @param value integer
--- @return nil
function CBaseModelEntity:SetBodygroupByName(name, value) end

--- Sets the light group of the entity.
--- 
--- (availability: server)
--- @param lightGroup string
--- @return nil
function CBaseModelEntity:SetLightGroup(lightGroup) end

--- Set the material group of this entity.
--- 
--- (availability: server)
--- @param materialGroup string
--- @return nil
function CBaseModelEntity:SetMaterialGroup(materialGroup) end

--- Set the material group hash of this entity.
--- 
--- (availability: server)
--- @param hash integer
--- @return nil
function CBaseModelEntity:SetMaterialGroupHash(hash) end

--- Set the mesh group mask of this entity.
--- 
--- (availability: server)
--- @param meshGroupMask Uint64
--- @return nil
function CBaseModelEntity:SetMaterialGroupMask(meshGroupMask) end

--- (availability: server)
--- @param modelName string
--- @return nil
function CBaseModelEntity:SetModel(modelName) end

--- Set scale of entity's model.
--- 
--- (availability: server)
--- @param scale number
--- @return nil
function CBaseModelEntity:SetModelScale(scale) end

--- Set the alpha modulation of this entity.
--- 
--- (availability: server)
--- @param alpha integer
--- @return nil
function CBaseModelEntity:SetRenderAlpha(alpha) end

--- Sets the render color of the entity.
--- 
--- (availability: server)
--- @param r integer
--- @param g integer
--- @param b integer
--- @return nil
function CBaseModelEntity:SetRenderColor(r, g, b) end

--- Sets the render mode of the entity.
--- 
--- (availability: server)
--- @param mode integer
--- @return nil
function CBaseModelEntity:SetRenderMode(mode) end

--- Set a single mesh group for this entity.
--- 
--- (availability: server)
--- @param meshGroupName string
--- @return nil
function CBaseModelEntity:SetSingleMeshGroup(meshGroupName) end

--- (availability: server)
--- @param mins Vector
--- @param maxs Vector
--- @return nil
function CBaseModelEntity:SetSize(mins, maxs) end

--- (availability: server)
--- @param skin integer
--- @return nil
function CBaseModelEntity:SetSkin(skin) end


--- @class CBasePlayerController : CBaseEntity
CBasePlayerController = {}

--- Returns the pawn for this controller.
--- 
--- (availability: server)
--- @return userdata
function CBasePlayerController:GetPawn() end


--- @class CBasePlayerPawn : CBaseCombatCharacter
CBasePlayerPawn = {}

--- Returns the controller for this pawn.
--- 
--- (availability: server)
--- @return userdata
function CBasePlayerPawn:GetController() end

--- Returns an array of all the equipped weapons.
--- 
--- (availability: server)
--- @return table
function CBasePlayerPawn:GetEquippedWeapons() end

--- Gets the number of weapons currently equipped.
--- 
--- (availability: server)
--- @return integer
function CBasePlayerPawn:GetWeaponCount() end

--- Returns true if the player is in noclip mode.
--- 
--- (availability: server)
--- @return boolean
function CBasePlayerPawn:IsNoclipping() end


--- @class CBaseTrigger : CBaseEntity
CBaseTrigger = {}

--- Disable's the trigger.
--- 
--- (availability: server)
--- @return nil
function CBaseTrigger:Disable() end

--- Enable the trigger.
--- 
--- (availability: server)
--- @return nil
function CBaseTrigger:Enable() end

--- Checks whether the passed entity is touching the trigger.
--- 
--- (availability: server)
--- @param ent CBaseEntity
--- @return boolean
function CBaseTrigger:IsTouching(ent) end


--- @class CBodyComponent
CBodyComponent = {}

--- Apply an impulse at a worldspace position to the physics.
--- 
--- (availability: server & client)
--- @param arg1 Vector
--- @param arg2 Vector
--- @return nil
function CBodyComponent:AddImpulseAtPosition(arg1, arg2) end

--- Add linear and angular velocity to the physics object.
--- 
--- (availability: server & client)
--- @param arg1 Vector
--- @param arg2 Vector
--- @return nil
function CBodyComponent:AddVelocity(arg1, arg2) end

--- Detach from its parent.
--- 
--- (availability: server & client)
--- @return nil
function CBodyComponent:DetachFromParent() end

--- Is attached to parent.
--- 
--- (availability: server & client)
--- @return boolean
function CBodyComponent:IsAttachedToParent() end

--- (availability: server & client)
--- @param arg1 Vector
--- @return nil
function CBodyComponent:SetAngularVelocity(arg1) end

--- (availability: server & client)
--- @param arg1 string
--- @return nil
function CBodyComponent:SetMaterialGroup(arg1) end

--- (availability: server & client)
--- @param arg1 Vector
--- @return nil
function CBodyComponent:SetVelocity(arg1) end


--- @class CCustomGameEventManager
CustomGameEventManager = {}

--- Register a callback to be called when a particular custom event arrives. Returns a listener ID that can be used to unregister later.
--- 
--- (availability: server)
--- @param eventName string
--- @param listener fun(userId: EntityIndex, event: table): nil
--- @return CustomGameEventListenerID
function CustomGameEventManager:RegisterListener(eventName, listener) end

--- (availability: server)
--- @param eventName string
--- @param eventData table
--- @return nil
function CustomGameEventManager:Send_ServerToAllClients(eventName, eventData) end

--- (availability: server)
--- @param player CDOTAPlayerController
--- @param eventName string
--- @param eventData table
--- @return nil
function CustomGameEventManager:Send_ServerToPlayer(player, eventName, eventData) end

--- (availability: server)
--- @param team DOTATeam_t
--- @param eventName string
--- @param eventData table
--- @return nil
function CustomGameEventManager:Send_ServerToTeam(team, eventName, eventData) end

--- Unregister a specific listener.
--- 
--- (availability: server)
--- @param listenerId CustomGameEventListenerID
--- @return nil
function CustomGameEventManager:UnregisterListener(listenerId) end


--- @class CCustomNetTableManager
CustomNetTables = {}

--- (availability: server & client)
--- @param tableName string
--- @param keyName string
--- @return table
function CustomNetTables:GetTableValue(tableName, keyName) end

--- (availability: server)
--- @param tableName string
--- @param keyName string
--- @param value userdata
--- @return boolean
function CustomNetTables:SetTableValue(tableName, keyName, value) end


--- @class CDebugOverlayScriptHelper
debugoverlay = {}

--- Draws an axis. Specify origin + orientation in world space.
--- 
--- (availability: server & client)
--- @param arg1 Vector
--- @param arg2 any
--- @param arg3 number
--- @param arg4 boolean
--- @param arg5 number
--- @return nil
function debugoverlay:Axis(arg1, arg2, arg3, arg4, arg5) end

--- Draws a world-space axis-aligned box. Specify bounds in world space.
--- 
--- (availability: server & client)
--- @param arg1 Vector
--- @param arg2 Vector
--- @param arg3 integer
--- @param arg4 integer
--- @param arg5 integer
--- @param arg6 integer
--- @param arg7 boolean
--- @param arg8 number
--- @return nil
function debugoverlay:Box(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8) end

--- Draws an oriented box at the origin. Specify bounds in local space.
--- 
--- (availability: server & client)
--- @param arg1 Vector
--- @param arg2 Vector
--- @param arg3 Vector
--- @param arg4 any
--- @param arg5 integer
--- @param arg6 integer
--- @param arg7 integer
--- @param arg8 integer
--- @param arg9 boolean
--- @param arg10 number
--- @return nil
function debugoverlay:BoxAngles(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10) end

--- Draws a capsule. Specify base in world space.
--- 
--- (availability: server & client)
--- @param arg1 Vector
--- @param arg2 any
--- @param arg3 number
--- @param arg4 number
--- @param arg5 integer
--- @param arg6 integer
--- @param arg7 integer
--- @param arg8 integer
--- @param arg9 boolean
--- @param arg10 number
--- @return nil
function debugoverlay:Capsule(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10) end

--- Draws a circle. Specify center in world space.
--- 
--- (availability: server & client)
--- @param arg1 Vector
--- @param arg2 any
--- @param arg3 number
--- @param arg4 integer
--- @param arg5 integer
--- @param arg6 integer
--- @param arg7 integer
--- @param arg8 boolean
--- @param arg9 number
--- @return nil
function debugoverlay:Circle(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9) end

--- Draws a circle oriented to the screen. Specify center in world space.
--- 
--- (availability: server & client)
--- @param arg1 Vector
--- @param arg2 number
--- @param arg3 integer
--- @param arg4 integer
--- @param arg5 integer
--- @param arg6 integer
--- @param arg7 boolean
--- @param arg8 number
--- @return nil
function debugoverlay:CircleScreenOriented(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8) end

--- Draws a wireframe cone. Specify endpoint and direction in world space.
--- 
--- (availability: server & client)
--- @param arg1 Vector
--- @param arg2 Vector
--- @param arg3 number
--- @param arg4 number
--- @param arg5 integer
--- @param arg6 integer
--- @param arg7 integer
--- @param arg8 integer
--- @param arg9 boolean
--- @param arg10 number
--- @return nil
function debugoverlay:Cone(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10) end

--- Draws a screen-aligned cross. Specify origin in world space.
--- 
--- (availability: server & client)
--- @param arg1 Vector
--- @param arg2 number
--- @param arg3 integer
--- @param arg4 integer
--- @param arg5 integer
--- @param arg6 integer
--- @param arg7 boolean
--- @param arg8 number
--- @return nil
function debugoverlay:Cross(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8) end

--- Draws a world-aligned cross. Specify origin in world space.
--- 
--- (availability: server & client)
--- @param arg1 Vector
--- @param arg2 number
--- @param arg3 integer
--- @param arg4 integer
--- @param arg5 integer
--- @param arg6 integer
--- @param arg7 boolean
--- @param arg8 number
--- @return nil
function debugoverlay:Cross3D(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8) end

--- Draws an oriented cross. Specify origin in world space.
--- 
--- (availability: server & client)
--- @param arg1 Vector
--- @param arg2 any
--- @param arg3 number
--- @param arg4 integer
--- @param arg5 integer
--- @param arg6 integer
--- @param arg7 integer
--- @param arg8 boolean
--- @param arg9 number
--- @return nil
function debugoverlay:Cross3DOriented(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9) end

--- Draws a dashed line. Specify endpoints in world space.
--- 
--- (availability: server & client)
--- @param arg1 Vector
--- @param arg2 Vector
--- @param arg3 number
--- @param arg4 integer
--- @param arg5 integer
--- @param arg6 integer
--- @param arg7 integer
--- @param arg8 integer
--- @param arg9 boolean
--- @param arg10 number
--- @return nil
function debugoverlay:DrawTickMarkedLine(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10) end

--- Draws the attachments of the entity.
--- 
--- (availability: server & client)
--- @param arg1 userdata
--- @param arg2 number
--- @param arg3 number
--- @return nil
function debugoverlay:EntityAttachments(arg1, arg2, arg3) end

--- Draws the axis of the entity origin.
--- 
--- (availability: server & client)
--- @param arg1 userdata
--- @param arg2 number
--- @param arg3 boolean
--- @param arg4 number
--- @return nil
function debugoverlay:EntityAxis(arg1, arg2, arg3, arg4) end

--- Draws bounds of an entity.
--- 
--- (availability: server & client)
--- @param arg1 userdata
--- @param arg2 integer
--- @param arg3 integer
--- @param arg4 integer
--- @param arg5 integer
--- @param arg6 boolean
--- @param arg7 number
--- @return nil
function debugoverlay:EntityBounds(arg1, arg2, arg3, arg4, arg5, arg6, arg7) end

--- Draws the skeleton of the entity.
--- 
--- (availability: server & client)
--- @param arg1 userdata
--- @param arg2 number
--- @return nil
function debugoverlay:EntitySkeleton(arg1, arg2) end

--- Draws text on an entity.
--- 
--- (availability: server & client)
--- @param arg1 userdata
--- @param arg2 integer
--- @param arg3 string
--- @param arg4 integer
--- @param arg5 integer
--- @param arg6 integer
--- @param arg7 integer
--- @param arg8 number
--- @return nil
function debugoverlay:EntityText(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8) end

--- Draws a screen-space filled 2D rectangle. Coordinates are in pixels.
--- 
--- (availability: server & client)
--- @param arg1 userdata
--- @param arg2 userdata
--- @param arg3 integer
--- @param arg4 integer
--- @param arg5 integer
--- @param arg6 integer
--- @param arg7 number
--- @return nil
function debugoverlay:FilledRect2D(arg1, arg2, arg3, arg4, arg5, arg6, arg7) end

--- Draws a horizontal arrow. Specify endpoints in world space.
--- 
--- (availability: server & client)
--- @param arg1 Vector
--- @param arg2 Vector
--- @param arg3 number
--- @param arg4 integer
--- @param arg5 integer
--- @param arg6 integer
--- @param arg7 integer
--- @param arg8 boolean
--- @param arg9 number
--- @return nil
function debugoverlay:HorzArrow(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9) end

--- Draws a line between two points.
--- 
--- (availability: server & client)
--- @param arg1 Vector
--- @param arg2 Vector
--- @param arg3 integer
--- @param arg4 integer
--- @param arg5 integer
--- @param arg6 integer
--- @param arg7 boolean
--- @param arg8 number
--- @return nil
function debugoverlay:Line(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8) end

--- Draws a line between two points in screenspace.
--- 
--- (availability: server & client)
--- @param arg1 userdata
--- @param arg2 userdata
--- @param arg3 integer
--- @param arg4 integer
--- @param arg5 integer
--- @param arg6 integer
--- @param arg7 number
--- @return nil
function debugoverlay:Line2D(arg1, arg2, arg3, arg4, arg5, arg6, arg7) end

--- Pops the identifier used to group overlays. Overlays marked with this identifier can be deleted in a big batch.
--- 
--- (availability: server & client)
--- @return nil
function debugoverlay:PopDebugOverlayScope() end

--- Pushes an identifier used to group overlays. Deletes all existing overlays using this overlay id.
--- 
--- (availability: server & client)
--- @param arg1 string
--- @return nil
function debugoverlay:PushAndClearDebugOverlayScope(arg1) end

--- Pushes an identifier used to group overlays. Overlays marked with this identifier can be deleted in a big batch.
--- 
--- (availability: server & client)
--- @param arg1 string
--- @return nil
function debugoverlay:PushDebugOverlayScope(arg1) end

--- Removes all overlays marked with a specific identifier, regardless of their lifetime.
--- 
--- (availability: server & client)
--- @param arg1 string
--- @return nil
function debugoverlay:RemoveAllInScope(arg1) end

--- Draws a solid cone. Specify endpoint and direction in world space.
--- 
--- (availability: server & client)
--- @param arg1 Vector
--- @param arg2 Vector
--- @param arg3 number
--- @param arg4 number
--- @param arg5 integer
--- @param arg6 integer
--- @param arg7 integer
--- @param arg8 integer
--- @param arg9 boolean
--- @param arg10 number
--- @return nil
function debugoverlay:SolidCone(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10) end

--- Draws a wireframe sphere. Specify center in world space.
--- 
--- (availability: server & client)
--- @param arg1 Vector
--- @param arg2 number
--- @param arg3 integer
--- @param arg4 integer
--- @param arg5 integer
--- @param arg6 integer
--- @param arg7 boolean
--- @param arg8 number
--- @return nil
function debugoverlay:Sphere(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8) end

--- Draws a swept box. Specify endpoints in world space and the bounds in local space.
--- 
--- (availability: server & client)
--- @param arg1 Vector
--- @param arg2 Vector
--- @param arg3 Vector
--- @param arg4 Vector
--- @param arg5 any
--- @param arg6 integer
--- @param arg7 integer
--- @param arg8 integer
--- @param arg9 integer
--- @param arg10 number
--- @return nil
function debugoverlay:SweptBox(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10) end

--- Draws 2D text. Specify origin in world space.
--- 
--- (availability: server & client)
--- @param arg1 Vector
--- @param arg2 integer
--- @param arg3 string
--- @param arg4 number
--- @param arg5 integer
--- @param arg6 integer
--- @param arg7 integer
--- @param arg8 integer
--- @param arg9 number
--- @return nil
function debugoverlay:Text(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9) end

--- Draws a screen-space texture. Coordinates are in pixels.
--- 
--- (availability: server & client)
--- @param arg1 string
--- @param arg2 userdata
--- @param arg3 userdata
--- @param arg4 integer
--- @param arg5 integer
--- @param arg6 integer
--- @param arg7 integer
--- @param arg8 userdata
--- @param arg9 userdata
--- @param arg10 number
--- @return nil
function debugoverlay:Texture(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10) end

--- Draws a filled triangle. Specify vertices in world space.
--- 
--- (availability: server & client)
--- @param arg1 Vector
--- @param arg2 Vector
--- @param arg3 Vector
--- @param arg4 integer
--- @param arg5 integer
--- @param arg6 integer
--- @param arg7 integer
--- @param arg8 boolean
--- @param arg9 number
--- @return nil
function debugoverlay:Triangle(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9) end

--- Draws 3D text. Specify origin + orientation in world space.
--- 
--- (availability: server & client)
--- @param arg1 Vector
--- @param arg2 any
--- @param arg3 string
--- @param arg4 integer
--- @param arg5 integer
--- @param arg6 integer
--- @param arg7 integer
--- @param arg8 boolean
--- @param arg9 number
--- @return nil
function debugoverlay:VectorText3D(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9) end

--- Draws a vertical arrow. Specify endpoints in world space.
--- 
--- (availability: server & client)
--- @param arg1 Vector
--- @param arg2 Vector
--- @param arg3 number
--- @param arg4 integer
--- @param arg5 integer
--- @param arg6 integer
--- @param arg7 integer
--- @param arg8 boolean
--- @param arg9 number
--- @return nil
function debugoverlay:VertArrow(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9) end

--- Draws a arrow associated with a specific yaw. Specify endpoints in world space.
--- 
--- (availability: server & client)
--- @param arg1 Vector
--- @param arg2 number
--- @param arg3 number
--- @param arg4 number
--- @param arg5 integer
--- @param arg6 integer
--- @param arg7 integer
--- @param arg8 integer
--- @param arg9 boolean
--- @param arg10 number
--- @return nil
function debugoverlay:YawArrow(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10) end


--- @class CDOTA_Ability_Aghanim_Spear : CDOTABaseAbility
CDOTA_Ability_Aghanim_Spear = {}

--- Launch Spear to a target position from a source position.
--- 
--- (availability: server)
--- @param target Vector
--- @param start Vector
--- @return nil
function CDOTA_Ability_Aghanim_Spear:LaunchSpear(target, start) end


--- @class CDOTA_Ability_Animation_Attack : CDOTABaseAbility
CDOTA_Ability_Animation_Attack = {}

--- Override playbackrate.
--- 
--- (availability: server)
--- @param rate number
--- @return nil
function CDOTA_Ability_Animation_Attack:SetPlaybackRate(rate) end


--- @class CDOTA_Ability_Animation_TailSpin : CDOTABaseAbility
CDOTA_Ability_Animation_TailSpin = {}

--- Override playbackrate.
--- 
--- (availability: server)
--- @param rate number
--- @return nil
function CDOTA_Ability_Animation_TailSpin:SetPlaybackRate(rate) end


--- @class CDOTA_Ability_DataDriven : CDOTABaseAbility
CDOTA_Ability_DataDriven = {}

--- Applies a data driven modifier to the target.
--- 
--- (availability: server)
--- @param caster CDOTA_BaseNPC
--- @param target CDOTA_BaseNPC
--- @param modifierName string
--- @param modifierTable table | nil
--- @return CDOTA_Buff
function CDOTA_Ability_DataDriven:ApplyDataDrivenModifier(caster, target, modifierName, modifierTable) end

--- Applies a data driven thinker at the location.
--- 
--- (availability: server)
--- @param caster CDOTA_BaseNPC
--- @param location Vector
--- @param modifierName string
--- @param modifierTable table | nil
--- @return CDOTA_Buff
function CDOTA_Ability_DataDriven:ApplyDataDrivenThinker(caster, location, modifierName, modifierTable) end


--- @class CDOTA_Ability_Lua : CDOTABaseAbility
CDOTA_Ability_Lua = {}

--- Determine whether an issued command with no target is valid.
--- 
--- (availability: server & client)
--- @return UnitFilterResult
function CDOTA_Ability_Lua:CastFilterResult() end

--- Determine whether an issued command on a location is valid.
--- 
--- (availability: server & client)
--- @param location Vector
--- @return UnitFilterResult
function CDOTA_Ability_Lua:CastFilterResultLocation(location) end

--- Determine whether an issued command on a target is valid.
--- 
--- (availability: server & client)
--- @param target CDOTA_BaseNPC
--- @return UnitFilterResult
function CDOTA_Ability_Lua:CastFilterResultTarget(target) end

--- (availability: server & client)
--- @param level integer
--- @return number
function CDOTA_Ability_Lua:GetAbilityChargeRestoreTime(level) end

--- Allows code overriding of the ability texture shown in the HUD.
--- 
--- (availability: client)
--- @return string
function CDOTA_Ability_Lua:GetAbilityTextureName() end

--- Controls the size of the AOE casting cursor.
--- 
--- (availability: server & client)
--- @return number
function CDOTA_Ability_Lua:GetAOERadius() end

--- Returns abilities that are stolen simultaneously, or otherwise related in functionality.
--- 
--- (availability: server)
--- @return string
function CDOTA_Ability_Lua:GetAssociatedPrimaryAbilities() end

--- Returns other abilities that are stolen simultaneously, or otherwise related in functionality.  Generally hidden abilities.
--- 
--- (availability: server)
--- @return string
function CDOTA_Ability_Lua:GetAssociatedSecondaryAbilities() end

--- Return cast behavior type of this ability.
--- 
--- (availability: server & client)
--- @return DOTA_ABILITY_BEHAVIOR
function CDOTA_Ability_Lua:GetBehavior() end

--- Return casting animation of this ability.
--- 
--- (availability: server)
--- @return GameActivity_t
function CDOTA_Ability_Lua:GetCastAnimation() end

--- Return cast point of this ability.
--- 
--- (availability: server & client)
--- @return number
function CDOTA_Ability_Lua:GetCastPoint() end

--- Return cast range of this ability.
--- 
--- (availability: server & client)
--- @param location Vector
--- @param target CDOTA_BaseNPC | nil
--- @return integer
function CDOTA_Ability_Lua:GetCastRange(location, target) end

--- (availability: server & client)
--- @param target userdata
--- @param pseudoCastRange integer
--- @return integer
function CDOTA_Ability_Lua:GetCastRangeBonus(target, pseudoCastRange) end

--- Return channel animation of this ability.
--- 
--- (availability: server)
--- @return GameActivity_t
function CDOTA_Ability_Lua:GetChannelAnimation() end

--- Return health cost per second of channeling at the given level (-1 is current).
--- 
--- (availability: server & client)
--- @param level integer
--- @return integer
function CDOTA_Ability_Lua:GetChannelledHealthCostPerSecond(level) end

--- Return mana cost at the given level per second while channeling (-1 is current).
--- 
--- (availability: server & client)
--- @param level integer
--- @return integer
function CDOTA_Ability_Lua:GetChannelledManaCostPerSecond(level) end

--- Return the channel start time of this ability.
--- 
--- (availability: server & client)
--- @return number
function CDOTA_Ability_Lua:GetChannelStartTime() end

--- Return the channel time of this ability.
--- 
--- (availability: server & client)
--- @return number
function CDOTA_Ability_Lua:GetChannelTime() end

--- Return who hears speech when this spell is cast.
--- 
--- (availability: server)
--- @return integer
function CDOTA_Ability_Lua:GetConceptRecipientType() end

--- Return cooldown of this ability.
--- 
--- (availability: server & client)
--- @param level integer
--- @return number
function CDOTA_Ability_Lua:GetCooldown(level) end

--- Return the error string of a failed command with no target.
--- 
--- (availability: server & client)
--- @return string
function CDOTA_Ability_Lua:GetCustomCastError() end

--- Return the error string of a failed command on a location.
--- 
--- (availability: server & client)
--- @param location Vector
--- @return string
function CDOTA_Ability_Lua:GetCustomCastErrorLocation(location) end

--- Return the error string of a failed command on a target.
--- 
--- (availability: server & client)
--- @param target CDOTA_BaseNPC
--- @return string
function CDOTA_Ability_Lua:GetCustomCastErrorTarget(target) end

--- (DOTA_INVALID_ORDERS nReason) Return the error string of a failed order.
--- 
--- (availability: server & client)
--- @param reason integer
--- @return string
function CDOTA_Ability_Lua:GetCustomHudErrorMessage(reason) end

--- Return cast range of this ability, accounting for modifiers.
--- 
--- (availability: server & client)
--- @param location Vector
--- @param target userdata
--- @return integer
function CDOTA_Ability_Lua:GetEffectiveCastRange(location, target) end

--- Return gold cost at the given level (-1 is current).
--- 
--- (availability: server & client)
--- @param level integer
--- @return integer
function CDOTA_Ability_Lua:GetGoldCost(level) end

--- Return health cost at the given level (-1 is current).
--- 
--- (availability: server & client)
--- @param level integer
--- @return integer
function CDOTA_Ability_Lua:GetHealthCost(level) end

--- Returns the name of the modifier applied passively by this ability.
--- 
--- (availability: server)
--- @return string
function CDOTA_Ability_Lua:GetIntrinsicModifierName() end

--- Return mana cost at the given level (-1 is current).
--- 
--- (availability: server & client)
--- @param level integer
--- @return integer
function CDOTA_Ability_Lua:GetManaCost(level) end

--- Return the animation rate of the cast animation.
--- 
--- (availability: server)
--- @return number
function CDOTA_Ability_Lua:GetPlaybackRateOverride() end

--- Is this ability an Attribute Bonus.
--- 
--- (availability: server & client)
--- @return boolean
function CDOTA_Ability_Lua:IsAttributeBonus() end

--- Is this a cosmetic only ability?
--- 
--- (availability: server)
--- @param entity userdata
--- @return boolean
function CDOTA_Ability_Lua:IsCosmetic(entity) end

--- Returns true if this ability can be used when not on the action panel.
--- 
--- (availability: server & client)
--- @return boolean
function CDOTA_Ability_Lua:IsHiddenAbilityCastable() end

--- Returns true if this ability is hidden when stolen by Spell Steal.
--- 
--- (availability: server)
--- @return boolean
function CDOTA_Ability_Lua:IsHiddenWhenStolen() end

--- Returns true if this ability is refreshed by Refresher Orb.
--- 
--- (availability: server)
--- @return boolean
function CDOTA_Ability_Lua:IsRefreshable() end

--- Returns true if this ability can be stolen by Spell Steal.
--- 
--- (availability: server)
--- @return boolean
function CDOTA_Ability_Lua:IsStealable() end

--- Cast time did not complete successfully.
--- 
--- (availability: server)
--- @return nil
function CDOTA_Ability_Lua:OnAbilityPhaseInterrupted() end

--- Cast time begins (return true for successful cast).
--- 
--- (availability: server)
--- @return boolean
function CDOTA_Ability_Lua:OnAbilityPhaseStart() end

--- The ability was pinged.
--- 
--- (availability: server)
--- @param playerId PlayerID
--- @param ctrlHeld boolean
--- @return nil
function CDOTA_Ability_Lua:OnAbilityPinged(playerId, ctrlHeld) end

--- (availability: server)
--- @param upgradeAbility userdata
--- @return nil
function CDOTA_Ability_Lua:OnAbilityUpgrade(upgradeAbility) end

--- Channel finished.
--- 
--- (availability: server)
--- @param interrupted boolean
--- @return nil
function CDOTA_Ability_Lua:OnChannelFinish(interrupted) end

--- Channeling is taking place.
--- 
--- (availability: server)
--- @param interval number
--- @return nil
function CDOTA_Ability_Lua:OnChannelThink(interval) end

--- Caster (hero only) gained a level, skilled an ability, or received a new stat bonus.
--- 
--- (availability: server)
--- @return nil
function CDOTA_Ability_Lua:OnHeroCalculateStatBonus() end

--- A hero has died in the vicinity (ie Urn), takes table of params.
--- 
--- (availability: server)
--- @param unit CDOTA_BaseNPC
--- @param attacker CDOTA_BaseNPC
--- @param event table
--- @return nil
function CDOTA_Ability_Lua:OnHeroDiedNearby(unit, attacker, event) end

--- Caster gained a level.
--- 
--- (availability: server)
--- @return nil
function CDOTA_Ability_Lua:OnHeroLevelUp() end

--- Caster inventory changed.
--- 
--- (availability: server)
--- @return nil
function CDOTA_Ability_Lua:OnInventoryContentsChanged() end

--- Caster equipped item.
--- 
--- (availability: server)
--- @param item CDOTA_Item
--- @return nil
function CDOTA_Ability_Lua:OnItemEquipped(item) end

--- Caster died.
--- 
--- (availability: server)
--- @return nil
function CDOTA_Ability_Lua:OnOwnerDied() end

--- Caster respawned or spawned for the first time.
--- 
--- (availability: server)
--- @return nil
function CDOTA_Ability_Lua:OnOwnerSpawned() end

--- Projectile has collided with a given target or reached its destination. If 'true` is returned, projectile would be destroyed.
--- 
--- (availability: server)
--- @param target CDOTA_BaseNPC | nil
--- @param location Vector
--- @return boolean | nil
function CDOTA_Ability_Lua:OnProjectileHit(target, location) end

--- Projectile has collided with a given target or reached its destination. If 'true` is returned, projectile would be destroyed.
--- 
--- (availability: server)
--- @param target CDOTA_BaseNPC | nil
--- @param location Vector
--- @param extraData table
--- @return boolean | nil
function CDOTA_Ability_Lua:OnProjectileHit_ExtraData(target, location, extraData) end

--- Projectile has collided with a given target or reached its destination. If 'true` is returned, projectile would be destroyed.
--- 
--- (availability: server)
--- @param target CDOTA_BaseNPC | nil
--- @param location Vector
--- @param projectileHandle ProjectileID
--- @return boolean | nil
function CDOTA_Ability_Lua:OnProjectileHitHandle(target, location, projectileHandle) end

--- Projectile is actively moving.
--- 
--- (availability: server)
--- @param location Vector
--- @return nil
function CDOTA_Ability_Lua:OnProjectileThink(location) end

--- Projectile is actively moving.
--- 
--- (availability: server)
--- @param location Vector
--- @param extraData table
--- @return nil
function CDOTA_Ability_Lua:OnProjectileThink_ExtraData(location, extraData) end

--- Projectile is actively moving.
--- 
--- (availability: server)
--- @param projectileHandle ProjectileID
--- @return nil
function CDOTA_Ability_Lua:OnProjectileThinkHandle(projectileHandle) end

--- Cast time finished, spell effects begin.
--- 
--- (availability: server)
--- @return nil
function CDOTA_Ability_Lua:OnSpellStart() end

--- Special behavior when stolen by Spell Steal.
--- 
--- (availability: server)
--- @param sourceAbility CDOTABaseAbility
--- @return nil
function CDOTA_Ability_Lua:OnStolen(sourceAbility) end

--- Ability is toggled on/off.
--- 
--- (availability: server)
--- @return nil
function CDOTA_Ability_Lua:OnToggle() end

--- Special behavior when lost by Spell Steal.
--- 
--- (availability: server)
--- @return nil
function CDOTA_Ability_Lua:OnUnStolen() end

--- Ability gained a level.
--- 
--- (availability: server)
--- @return nil
function CDOTA_Ability_Lua:OnUpgrade() end

--- (availability: server)
--- @return boolean
function CDOTA_Ability_Lua:OtherAbilitiesAlwaysInterruptChanneling() end

--- Returns true if this ability will generate magic stick charges for nearby enemies.
--- 
--- (availability: server)
--- @return boolean
function CDOTA_Ability_Lua:ProcsMagicStick() end

--- Does this ability need the caster to face the target before executing?
--- 
--- (availability: server)
--- @return boolean
function CDOTA_Ability_Lua:RequiresFacing() end

--- Returns true if this ability should return to the default toggle state when its parent respawns.
--- 
--- (availability: server)
--- @return boolean
function CDOTA_Ability_Lua:ResetToggleOnRespawn() end

--- Return the type of speech used.
--- 
--- (availability: server)
--- @return integer
function CDOTA_Ability_Lua:SpeakTrigger() end

--- Called first when ability entity is created.
--- 
--- (availability: server & client)
--- @return nil
function CDOTA_Ability_Lua:Init() end

--- (availability: server)
--- @param context CScriptPrecacheContext
--- @return nil
function CDOTA_Ability_Lua:Precache(context) end

--- Called when ability entity is created, after Init.
--- 
--- (availability: server & client)
--- @return nil
function CDOTA_Ability_Lua:Spawn() end


--- @class CDOTA_Ability_Nian_Dive : CDOTABaseAbility
CDOTA_Ability_Nian_Dive = {}

--- Override playbackrate.
--- 
--- (availability: server)
--- @param rate number
--- @return nil
function CDOTA_Ability_Nian_Dive:SetPlaybackRate(rate) end


--- @class CDOTA_Ability_Nian_Leap : CDOTABaseAbility
CDOTA_Ability_Nian_Leap = {}

--- Override playbackrate.
--- 
--- (availability: server)
--- @param rate number
--- @return nil
function CDOTA_Ability_Nian_Leap:SetPlaybackRate(rate) end


--- @class CDOTA_Ability_Nian_Roar : CDOTABaseAbility
CDOTA_Ability_Nian_Roar = {}

--- Number of times Nian has used the roar.
--- 
--- (availability: server)
--- @return integer
function CDOTA_Ability_Nian_Roar:GetCastCount() end


--- @class CDOTA_AghsFort_Ability_ArcWardenBoss_TempestDouble : CDOTABaseAbility
CDOTA_AghsFort_Ability_ArcWardenBoss_TempestDouble = {}

--- Sets the number of doubles to spawn.
--- 
--- (availability: server & client)
--- @param doubles integer
--- @return nil
function CDOTA_AghsFort_Ability_ArcWardenBoss_TempestDouble:SetNumDoubles(doubles) end


--- @class CDOTA_BaseNPC : CBaseFlex
CDOTA_BaseNPC = {}

--- Add an ability to this unit by name.
--- 
--- (availability: server)
--- @param abilityName string
--- @return CDOTABaseAbility
function CDOTA_BaseNPC:AddAbility(abilityName) end

--- Add an activity modifier that affects future StartGesture calls.
--- 
--- (availability: server)
--- @param name string The name of the activity modifier to add, e.g. 'haste'.
--- @return nil
function CDOTA_BaseNPC:AddActivityModifier(name) end

--- Add an item to this unit's inventory.
--- 
--- (availability: server)
--- @param item CDOTA_Item
--- @return CDOTA_Item
function CDOTA_BaseNPC:AddItem(item) end

--- Add an item to this unit's inventory.
--- 
--- (availability: server)
--- @param itemName string
--- @return CDOTA_Item
function CDOTA_BaseNPC:AddItemByName(itemName) end

--- Add a modifier to this unit.
--- 
--- (availability: server)
--- @param caster CDOTA_BaseNPC | nil
--- @param ability CDOTABaseAbility | nil
--- @param modifierName string
--- @param modifierTable table | nil
--- @return CDOTA_Buff
function CDOTA_BaseNPC:AddNewModifier(caster, ability, modifierName, modifierTable) end

--- Adds the no draw flag.
--- 
--- (availability: server)
--- @return nil
function CDOTA_BaseNPC:AddNoDraw() end

--- Add a speech bubble(1-4 live at a time) to this NPC.
--- 
--- (availability: server)
--- @param bubble integer
--- @param speech string
--- @param duration number
--- @param unOffsetX integer
--- @param unOffsetY integer
--- @return nil
function CDOTA_BaseNPC:AddSpeechBubble(bubble, speech, duration, unOffsetX, unOffsetY) end

--- (availability: server)
--- @param attacker CDOTA_BaseNPC
--- @param ability CDOTABaseAbility
--- @return nil
function CDOTA_BaseNPC:AlertNearbyUnits(attacker, ability) end

--- (availability: server)
--- @return nil
function CDOTA_BaseNPC:AngerNearbyUnits() end

--- (availability: server)
--- @param time number
--- @param timeDisparityTolerance number
--- @return nil
function CDOTA_BaseNPC:AttackNoEarlierThan(time, timeDisparityTolerance) end

--- (availability: server)
--- @return boolean
function CDOTA_BaseNPC:AttackReady() end

--- (availability: server)
--- @return number
function CDOTA_BaseNPC:BoundingRadius2D() end

--- (availability: server)
--- @return nil
function CDOTA_BaseNPC:CalculateGenericBonuses() end

--- (availability: server)
--- @return boolean
function CDOTA_BaseNPC:CanBeSeenByAnyOpposingTeam() end

--- Check FoW to see if an entity is visible.
--- 
--- (availability: server)
--- @param entity CDOTA_BaseNPC
--- @return boolean
function CDOTA_BaseNPC:CanEntityBeSeenByMyTeam(entity) end

--- Query if this unit can sell items.
--- 
--- (availability: server)
--- @return boolean
function CDOTA_BaseNPC:CanSellItems() end

--- Cast an ability immediately.
--- 
--- (availability: server)
--- @param ability CDOTABaseAbility
--- @param playerIndex integer
--- @return nil
function CDOTA_BaseNPC:CastAbilityImmediately(ability, playerIndex) end

--- Cast an ability with no target.
--- 
--- (availability: server)
--- @param ability CDOTABaseAbility
--- @param playerIndex integer
--- @return nil
function CDOTA_BaseNPC:CastAbilityNoTarget(ability, playerIndex) end

--- Cast an ability on a position.
--- 
--- (availability: server)
--- @param position Vector
--- @param ability CDOTABaseAbility
--- @param playerIndex integer
--- @return nil
function CDOTA_BaseNPC:CastAbilityOnPosition(position, ability, playerIndex) end

--- Cast an ability on a target entity.
--- 
--- (availability: server)
--- @param target CDOTA_BaseNPC
--- @param ability CDOTABaseAbility
--- @param playerIndex integer
--- @return nil
function CDOTA_BaseNPC:CastAbilityOnTarget(target, ability, playerIndex) end

--- Toggle an ability.
--- 
--- (availability: server)
--- @param ability CDOTABaseAbility
--- @param playerIndex integer
--- @return nil
function CDOTA_BaseNPC:CastAbilityToggle(ability, playerIndex) end

--- (availability: server)
--- @param teamNum integer
--- @return nil
function CDOTA_BaseNPC:ChangeTeam(teamNum) end

--- Clear Activity modifiers.
--- 
--- (availability: server)
--- @return nil
function CDOTA_BaseNPC:ClearActivityModifiers() end

--- (availability: server)
--- @return nil
function CDOTA_BaseNPC:DestroyAllSpeechBubbles() end

--- Disassemble the passed item in this unit's inventory.
--- 
--- (availability: server)
--- @param item CDOTA_Item
--- @return nil
function CDOTA_BaseNPC:DisassembleItem(item) end

--- Drop an item at a given point.
--- 
--- (availability: server)
--- @param dest Vector
--- @param item CDOTA_Item
--- @return nil
function CDOTA_BaseNPC:DropItemAtPosition(dest, item) end

--- Immediately drop a carried item at a given position.
--- 
--- (availability: server)
--- @param item CDOTA_Item
--- @param position Vector
--- @return nil
function CDOTA_BaseNPC:DropItemAtPositionImmediate(item, position) end

--- Drops the selected item out of this unit's stash.
--- 
--- (availability: server)
--- @param item CDOTA_Item
--- @return nil
function CDOTA_BaseNPC:EjectItemFromStash(item) end

--- This unit will be set to face the target point.
--- 
--- (availability: server)
--- @param target Vector
--- @return nil
function CDOTA_BaseNPC:FaceTowards(target) end

--- Fade and remove the given gesture activity.
--- 
--- (availability: server)
--- @param activity GameActivity_t
--- @return nil
function CDOTA_BaseNPC:FadeGesture(activity) end

--- Retrieve an ability by name from the unit.
--- 
--- (availability: server & client)
--- @param abilityName string
--- @return CDOTABaseAbility | nil
function CDOTA_BaseNPC:FindAbilityByName(abilityName) end

--- Returns a table of all of the modifiers on the NPC.
--- 
--- (availability: server)
--- @return CDOTA_Buff[]
function CDOTA_BaseNPC:FindAllModifiers() end

--- Returns a table of all of the modifiers on the NPC with the passed name (modifierName).
--- 
--- (availability: server)
--- @param modifierName string
--- @return CDOTA_Buff[]
function CDOTA_BaseNPC:FindAllModifiersByName(modifierName) end

--- Get handle to first item in inventory, else nil.
--- 
--- (availability: server)
--- @param itemName string
--- @return CDOTA_Item | nil
function CDOTA_BaseNPC:FindItemInInventory(itemName) end

--- Return a handle to the modifier of the given name if found, else nil (string Name ).
--- 
--- (availability: server)
--- @param modifierName string
--- @return CDOTA_Buff | nil
function CDOTA_BaseNPC:FindModifierByName(modifierName) end

--- Return a handle to the modifier of the given name from the passed caster if found, else nil.
--- 
--- (availability: server)
--- @param modifierName string
--- @param caster CDOTA_BaseNPC
--- @return CDOTA_Buff | nil
function CDOTA_BaseNPC:FindModifierByNameAndCaster(modifierName, caster) end

--- Kill this unit immediately.
--- 
--- (availability: server)
--- @param reincarnate boolean
--- @return nil
function CDOTA_BaseNPC:ForceKill(reincarnate) end

--- Play an activity once, and then go back to idle.
--- 
--- (availability: server)
--- @param activity GameActivity_t
--- @return nil
function CDOTA_BaseNPC:ForcePlayActivityOnce(activity) end

--- Retrieve an ability by index from the unit.
--- 
--- (availability: server)
--- @param index integer
--- @return CDOTABaseAbility | nil
function CDOTA_BaseNPC:GetAbilityByIndex(index) end

--- (availability: server & client)
--- @return integer
function CDOTA_BaseNPC:GetAbilityCount() end

--- Gets the range at which this unit will auto-acquire.
--- 
--- (availability: server)
--- @return number
function CDOTA_BaseNPC:GetAcquisitionRange() end

--- Combat involving this creature will have this weight added to the music calcuations.
--- 
--- (availability: server)
--- @return number
function CDOTA_BaseNPC:GetAdditionalBattleMusicWeight() end

--- Returns this unit's aggro target.
--- 
--- (availability: server)
--- @return CDOTA_BaseNPC | nil
function CDOTA_BaseNPC:GetAggroTarget() end

--- (availability: server)
--- @return number
function CDOTA_BaseNPC:GetAttackAnimationPoint() end

--- (availability: server)
--- @return DOTAUnitAttackCapability_t
function CDOTA_BaseNPC:GetAttackCapability() end

--- Returns a random integer between the minimum and maximum base damage of the unit.
--- 
--- (availability: server)
--- @return integer
function CDOTA_BaseNPC:GetAttackDamage() end

--- Gets the attack range buffer.
--- 
--- (availability: server)
--- @return number
function CDOTA_BaseNPC:GetAttackRangeBuffer() end

--- (availability: server & client)
--- @param ignoreTempAttackSpeed boolean
--- @return number
function CDOTA_BaseNPC:GetAttackSpeed(ignoreTempAttackSpeed) end

--- (availability: server & client)
--- @param ignoreTempAttackSpeed boolean
--- @return number
function CDOTA_BaseNPC:GetAttacksPerSecond(ignoreTempAttackSpeed) end

--- (availability: server)
--- @return CDOTA_BaseNPC | nil
function CDOTA_BaseNPC:GetAttackTarget() end

--- Returns the average value of the minimum and maximum damage values.
--- 
--- (availability: server)
--- @param target CDOTA_BaseNPC | nil
--- @return integer
function CDOTA_BaseNPC:GetAverageTrueAttackDamage(target) end

--- (availability: server)
--- @return integer
function CDOTA_BaseNPC:GetBaseAttackRange() end

--- (availability: server & client)
--- @return number
function CDOTA_BaseNPC:GetBaseAttackTime() end

--- Get the maximum attack damage of this unit.
--- 
--- (availability: server)
--- @return integer
function CDOTA_BaseNPC:GetBaseDamageMax() end

--- Get the minimum attack damage of this unit.
--- 
--- (availability: server)
--- @return integer
function CDOTA_BaseNPC:GetBaseDamageMin() end

--- Returns the vision range before modifiers.
--- 
--- (availability: server)
--- @return integer
function CDOTA_BaseNPC:GetBaseDayTimeVisionRange() end

--- (availability: server)
--- @return integer
function CDOTA_BaseNPC:GetBaseHealthBarOffset() end

--- (availability: server)
--- @return number
function CDOTA_BaseNPC:GetBaseHealthRegen() end

--- Returns base magical armor value.
--- 
--- (availability: server & client)
--- @return number
function CDOTA_BaseNPC:GetBaseMagicalResistanceValue() end

--- Gets the base max health value.
--- 
--- (availability: server)
--- @return number
function CDOTA_BaseNPC:GetBaseMaxHealth() end

--- (availability: server & client)
--- @return number
function CDOTA_BaseNPC:GetBaseMoveSpeed() end

--- Returns the vision range after modifiers.
--- 
--- (availability: server)
--- @return integer
function CDOTA_BaseNPC:GetBaseNightTimeVisionRange() end

--- This Mana regen is derived from constant bonuses like Basilius.
--- 
--- (availability: server)
--- @return number
function CDOTA_BaseNPC:GetBonusManaRegen() end

--- (availability: server)
--- @param attack boolean
--- @return number
function CDOTA_BaseNPC:GetCastPoint(attack) end

--- (availability: server & client)
--- @return number
function CDOTA_BaseNPC:GetCastRangeBonus() end

--- Get clone source (Meepo Prime, if this is a Meepo).
--- 
--- (availability: server)
--- @return CDOTA_BaseNPC | nil
function CDOTA_BaseNPC:GetCloneSource() end

--- Returns the size of the collision padding around the hull.
--- 
--- (availability: server & client)
--- @return number
function CDOTA_BaseNPC:GetCollisionPadding() end

--- (availability: server & client)
--- @return number
function CDOTA_BaseNPC:GetCooldownReduction() end

--- (availability: server)
--- @return number
function CDOTA_BaseNPC:GetCreationTime() end

--- Get the ability this unit is currently casting.
--- 
--- (availability: server)
--- @return CDOTABaseAbility | nil
function CDOTA_BaseNPC:GetCurrentActiveAbility() end

--- Gets the current vision range.
--- 
--- (availability: server & client)
--- @return integer
function CDOTA_BaseNPC:GetCurrentVisionRange() end

--- (availability: server)
--- @return CDOTA_BaseNPC | nil
function CDOTA_BaseNPC:GetCursorCastTarget() end

--- (availability: server)
--- @return Vector
function CDOTA_BaseNPC:GetCursorPosition() end

--- (availability: server)
--- @return boolean
function CDOTA_BaseNPC:GetCursorTargetingNothing() end

--- Get the maximum attack damage of this unit.
--- 
--- (availability: server & client)
--- @return integer
function CDOTA_BaseNPC:GetDamageMax() end

--- Get the minimum attack damage of this unit.
--- 
--- (availability: server & client)
--- @return integer
function CDOTA_BaseNPC:GetDamageMin() end

--- Returns the vision range after modifiers.
--- 
--- (availability: server & client)
--- @return integer
function CDOTA_BaseNPC:GetDayTimeVisionRange() end

--- Get the XP bounty on this unit.
--- 
--- (availability: server)
--- @return integer
function CDOTA_BaseNPC:GetDeathXP() end

--- Attack speed expressed as constant value.
--- 
--- (availability: server)
--- @return number
function CDOTA_BaseNPC:GetDisplayAttackSpeed() end

--- (availability: server)
--- @return number
function CDOTA_BaseNPC:GetEvasion() end

--- (availability: server)
--- @return CDOTA_BaseNPC | nil
function CDOTA_BaseNPC:GetForceAttackTarget() end

--- Get the gold bounty on this unit.
--- 
--- (availability: server)
--- @return integer
function CDOTA_BaseNPC:GetGoldBounty() end

--- (availability: server & client)
--- @return number
function CDOTA_BaseNPC:GetHasteFactor() end

--- Returns integer amount of health missing from max.
--- 
--- (availability: server)
--- @return integer
function CDOTA_BaseNPC:GetHealthDeficit() end

--- Get the current health percent of the unit.
--- 
--- (availability: server & client)
--- @return integer
function CDOTA_BaseNPC:GetHealthPercent() end

--- (availability: server)
--- @return number
function CDOTA_BaseNPC:GetHealthRegen() end

--- Get the collision hull radius of this NPC.
--- 
--- (availability: server & client)
--- @return number
function CDOTA_BaseNPC:GetHullRadius() end

--- Returns speed after all modifiers.
--- 
--- (availability: server & client)
--- @return number
function CDOTA_BaseNPC:GetIdealSpeed() end

--- Returns speed after all modifiers, but excluding those that reduce speed.
--- 
--- (availability: server & client)
--- @return number
function CDOTA_BaseNPC:GetIdealSpeedNoSlows() end

--- (availability: server & client)
--- @param ignoreTempAttackSpeed boolean
--- @return number
function CDOTA_BaseNPC:GetIncreasedAttackSpeed(ignoreTempAttackSpeed) end

--- Returns the initial waypoint goal for this NPC.
--- 
--- (availability: server)
--- @return CBaseEntity | nil
function CDOTA_BaseNPC:GetInitialGoalEntity() end

--- Get waypoint position for this NPC.
--- 
--- (availability: server)
--- @return Vector
function CDOTA_BaseNPC:GetInitialGoalPosition() end

--- Returns nth item in inventory slot (index is zero based).
--- 
--- (availability: server)
--- @param slot integer
--- @return CDOTA_Item | nil
function CDOTA_BaseNPC:GetItemInSlot(slot) end

--- (availability: server)
--- @return number
function CDOTA_BaseNPC:GetLastAttackTime() end

--- Get the last time this NPC took damage.
--- 
--- (availability: server)
--- @return number
function CDOTA_BaseNPC:GetLastDamageTime() end

--- Get the last game time that this unit switched to/from idle state.
--- 
--- (availability: server)
--- @return number
function CDOTA_BaseNPC:GetLastIdleChangeTime() end

--- Returns the level of this unit.
--- 
--- (availability: server & client)
--- @return integer
function CDOTA_BaseNPC:GetLevel() end

--- Returns the player ID of the controlling player.
--- 
--- (availability: server)
--- @return integer
function CDOTA_BaseNPC:GetMainControllingPlayer() end

--- Get the mana on this unit.
--- 
--- (availability: server & client)
--- @return number
function CDOTA_BaseNPC:GetMana() end

--- Get the percent of mana remaining.
--- 
--- (availability: server)
--- @return integer
function CDOTA_BaseNPC:GetManaPercent() end

--- (availability: server & client)
--- @return number
function CDOTA_BaseNPC:GetManaRegen() end

--- Get the maximum gold bounty for this unit.
--- 
--- (availability: server)
--- @return integer
function CDOTA_BaseNPC:GetMaximumGoldBounty() end

--- Get the maximum mana of this unit.
--- 
--- (availability: server & client)
--- @return number
function CDOTA_BaseNPC:GetMaxMana() end

--- Get the minimum gold bounty for this unit.
--- 
--- (availability: server)
--- @return integer
function CDOTA_BaseNPC:GetMinimumGoldBounty() end

--- (availability: server & client)
--- @return number
function CDOTA_BaseNPC:GetModelRadius() end

--- How many modifiers does this unit have?
--- 
--- (availability: server)
--- @return integer
function CDOTA_BaseNPC:GetModifierCount() end

--- Get a modifier name by index.
--- 
--- (availability: server)
--- @param index integer
--- @return string
function CDOTA_BaseNPC:GetModifierNameByIndex(index) end

--- Gets the stack count of a given modifier.
--- 
--- (availability: server & client)
--- @param modifierName string
--- @param caster CDOTA_BaseNPC
--- @return integer
function CDOTA_BaseNPC:GetModifierStackCount(modifierName, caster) end

--- (availability: server & client)
--- @param baseSpeed number
--- @param returnUnslowed boolean
--- @return number
function CDOTA_BaseNPC:GetMoveSpeedModifier(baseSpeed, returnUnslowed) end

--- Set whether this NPC is required to reach each goal entity, rather than being allowed to unkink their path.
--- 
--- (availability: server)
--- @return boolean
function CDOTA_BaseNPC:GetMustReachEachGoalEntity() end

--- Get the name of this camp's neutral spawner.
--- 
--- (availability: server)
--- @return string
function CDOTA_BaseNPC:GetNeutralSpawnerName() end

--- If set to true, we will never attempt to move this unit to clear space, even when it unphases.
--- 
--- (availability: server)
--- @return boolean
function CDOTA_BaseNPC:GetNeverMoveToClearSpace() end

--- Returns the vision range after modifiers.
--- 
--- (availability: server & client)
--- @return integer
function CDOTA_BaseNPC:GetNightTimeVisionRange() end

--- (availability: server & client)
--- @return DOTATeam_t
function CDOTA_BaseNPC:GetOpposingTeamNumber() end

--- Get the collision hull radius (including padding) of this NPC.
--- 
--- (availability: server & client)
--- @return number
function CDOTA_BaseNPC:GetPaddedCollisionRadius() end

--- Returns base physical armor value.
--- 
--- (availability: server & client)
--- @return number
function CDOTA_BaseNPC:GetPhysicalArmorBaseValue() end

--- Returns current physical armor value.
--- 
--- (availability: server & client)
--- @param ignoreBase boolean
--- @return number
function CDOTA_BaseNPC:GetPhysicalArmorValue(ignoreBase) end

--- Returns the player that owns this unit.
--- 
--- (availability: server)
--- @return CDOTAPlayerController
function CDOTA_BaseNPC:GetPlayerOwner() end

--- Get the owner player ID for this unit.
--- 
--- (availability: server & client)
--- @return PlayerID
function CDOTA_BaseNPC:GetPlayerOwnerID() end

--- (availability: server)
--- @return integer
function CDOTA_BaseNPC:GetProjectileSpeed() end

--- (availability: server)
--- @return string
function CDOTA_BaseNPC:GetRangedProjectileName() end

--- (availability: server)
--- @param npc CDOTA_BaseNPC
--- @return number
function CDOTA_BaseNPC:GetRangeToUnit(npc) end

--- (availability: server)
--- @return number
function CDOTA_BaseNPC:GetRemainingPathLength() end

--- (availability: server & client)
--- @param ignoreTempAttackSpeed boolean
--- @return number
function CDOTA_BaseNPC:GetSecondsPerAttack(ignoreTempAttackSpeed) end

--- (availability: server)
--- @param baseOnly boolean
--- @return number
function CDOTA_BaseNPC:GetSpellAmplification(baseOnly) end

--- (availability: server)
--- @return number
function CDOTA_BaseNPC:GetStatusResistance() end

--- Get how much gold has been spent on ability upgrades.
--- 
--- (availability: server & client)
--- @return integer
function CDOTA_BaseNPC:GetTotalPurchasedUpgradeGoldCost() end

--- (availability: server & client)
--- @return string
function CDOTA_BaseNPC:GetUnitLabel() end

--- Get the localization token for this unit's name.
--- 
--- (availability: client)
--- @return string
function CDOTA_BaseNPC:GetUnitLocToken() end

--- Get the name of this unit.
--- 
--- (availability: server & client)
--- @return string
function CDOTA_BaseNPC:GetUnitName() end

--- Give mana to this unit, this can be used for mana gained by abilities or item usage.
--- 
--- (availability: server)
--- @param mana number
--- @return nil
function CDOTA_BaseNPC:GiveMana(mana) end

--- See whether this unit has an ability by name.
--- 
--- (availability: server)
--- @param abilityName string
--- @return boolean
function CDOTA_BaseNPC:HasAbility(abilityName) end

--- (availability: server)
--- @return boolean
function CDOTA_BaseNPC:HasAnyActiveAbilities() end

--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:HasAttackCapability() end

--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:HasFlyingVision() end

--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:HasFlyMovementCapability() end

--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:HasGroundMovementCapability() end

--- Does this unit have an inventory.
--- 
--- (availability: server)
--- @return boolean
function CDOTA_BaseNPC:HasInventory() end

--- See whether this unit has an item by name.
--- 
--- (availability: server & client)
--- @param itemName string
--- @return boolean
function CDOTA_BaseNPC:HasItemInInventory(itemName) end

--- Sees if this unit has a given modifier.
--- 
--- (availability: server & client)
--- @param scriptName string
--- @return boolean
function CDOTA_BaseNPC:HasModifier(scriptName) end

--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:HasMovementCapability() end

--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:HasScepter() end

--- Heal this unit.
--- 
--- (availability: server)
--- @param amount number
--- @param inflictor CDOTABaseAbility | nil
--- @return nil
function CDOTA_BaseNPC:Heal(amount, inflictor) end

--- Heal this unit (with more parameters).
--- 
--- (availability: server)
--- @param amount number
--- @param inflictor userdata
--- @param lifesteal boolean
--- @param amplify boolean
--- @param source userdata
--- @param spellLifesteal boolean
--- @return nil
function CDOTA_BaseNPC:HealWithParams(amount, inflictor, lifesteal, amplify, source, spellLifesteal) end

--- Hold position.
--- 
--- (availability: server)
--- @return nil
function CDOTA_BaseNPC:Hold() end

--- (availability: server)
--- @return nil
function CDOTA_BaseNPC:Interrupt() end

--- (availability: server)
--- @return nil
function CDOTA_BaseNPC:InterruptChannel() end

--- (availability: server)
--- @param findClearSpace boolean
--- @return nil
function CDOTA_BaseNPC:InterruptMotionControllers(findClearSpace) end

--- Is this unit alive?
--- 
--- (availability: server)
--- @return boolean
function CDOTA_BaseNPC:IsAlive() end

--- Is this unit an Ancient?
--- 
--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsAncient() end

--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsAttackImmune() end

--- (availability: server)
--- @return boolean
function CDOTA_BaseNPC:IsAttacking() end

--- (availability: server)
--- @param entity CDOTA_BaseNPC
--- @return boolean
function CDOTA_BaseNPC:IsAttackingEntity(entity) end

--- Is this unit a Barracks?
--- 
--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsBarracks() end

--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsBlind() end

--- (availability: server)
--- @return boolean
function CDOTA_BaseNPC:IsBlockDisabled() end

--- Is this unit a boss?
--- 
--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsBoss() end

--- Is this unit a Boss Creature? (used by custom games).
--- 
--- (availability: server)
--- @return boolean
function CDOTA_BaseNPC:IsBossCreature() end

--- Is this unit a building?
--- 
--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsBuilding() end

--- Is this unit currently channeling a spell?
--- 
--- (availability: server)
--- @return boolean
function CDOTA_BaseNPC:IsChanneling() end

--- Is this unit a clone? (Meepo).
--- 
--- (availability: server)
--- @return boolean
function CDOTA_BaseNPC:IsClone() end

--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsCommandRestricted() end

--- Is this unit a considered a hero for targeting purposes?
--- 
--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsConsideredHero() end

--- Is this unit controlled by any non-bot player?
--- 
--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsControllableByAnyPlayer() end

--- Is this unit a courier?
--- 
--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsCourier() end

--- Is this a Creature type NPC?
--- 
--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsCreature() end

--- Is this unit a creep?
--- 
--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsCreep() end

--- Is this unit a creep hero?
--- 
--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsCreepHero() end

--- (availability: server)
--- @return boolean
function CDOTA_BaseNPC:IsCurrentlyHorizontalMotionControlled() end

--- (availability: server)
--- @return boolean
function CDOTA_BaseNPC:IsCurrentlyVerticalMotionControlled() end

--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsDebuffImmune() end

--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsDisarmed() end

--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsDominated() end

--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsEvadeDisabled() end

--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsFeared() end

--- Is this unit an Ancient?
--- 
--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsFort() end

--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsFrozen() end

--- Is this a hero or hero illusion?
--- 
--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsHero() end

--- Is this a Hero Ward?
--- 
--- (availability: server)
--- @return boolean
function CDOTA_BaseNPC:IsHeroWard() end

--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsHexed() end

--- Is this creature currently idle?
--- 
--- (availability: server)
--- @return boolean
function CDOTA_BaseNPC:IsIdle() end

--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsIllusion() end

--- Ask whether this unit is in range of the specified shop.
--- 
--- (availability: server)
--- @param shopType DOTA_SHOP_TYPE
--- @param physical boolean
--- @return boolean
function CDOTA_BaseNPC:IsInRangeOfShop(shopType, physical) end

--- Does this unit have an inventory.
--- 
--- (availability: client)
--- @return boolean
function CDOTA_BaseNPC:IsInventoryEnabled() end

--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsInvisible() end

--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsInvulnerable() end

--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsLowAttackPriority() end

--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsMagicImmune() end

--- (availability: server)
--- @return boolean
function CDOTA_BaseNPC:IsMovementImpaired() end

--- Is this unit moving?
--- 
--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsMoving() end

--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsMuted() end

--- Is this a neutral?
--- 
--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsNeutralUnitType() end

--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsNightmared() end

--- (availability: server)
--- @param team DOTATeam_t
--- @return boolean
function CDOTA_BaseNPC:IsOpposingTeam(team) end

--- Is this unit a ward-type unit?
--- 
--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsOther() end

--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsOutOfGame() end

--- Is this unit owned by any non-bot player?
--- 
--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsOwnedByAnyPlayer() end

--- Is this a phantom unit?
--- 
--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsPhantom() end

--- (availability: server)
--- @return boolean
function CDOTA_BaseNPC:IsPhantomBlocker() end

--- (availability: server)
--- @return boolean
function CDOTA_BaseNPC:IsPhased() end

--- (availability: server)
--- @param position Vector
--- @param range number
--- @return boolean
function CDOTA_BaseNPC:IsPositionInRange(position, range) end

--- Is this unit a ranged attacker?
--- 
--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsRangedAttacker() end

--- Is this a real hero?
--- 
--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsRealHero() end

--- (availability: server)
--- @return boolean
function CDOTA_BaseNPC:IsReincarnating() end

--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsRooted() end

--- Is this a shrine?
--- 
--- (availability: server)
--- @return boolean
function CDOTA_BaseNPC:IsShrine() end

--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsSilenced() end

--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsSpeciallyDeniable() end

--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsSpeciallyUndeniable() end

--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsStrongIllusion() end

--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsStunned() end

--- Is this unit summoned?
--- 
--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsSummoned() end

--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsTaunted() end

--- (availability: server)
--- @return boolean
function CDOTA_BaseNPC:IsTempestDouble() end

--- Is this a tower?
--- 
--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsTower() end

--- (availability: server)
--- @return boolean
function CDOTA_BaseNPC:IsUnableToMiss() end

--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:IsUnselectable() end

--- (availability: client)
--- @return boolean
function CDOTA_BaseNPC:IsUntargetable() end

--- (availability: server & client)
--- @param targettingSource userdata
--- @return boolean
function CDOTA_BaseNPC:IsUntargetableFrom(targettingSource) end

--- Is this a Ward?
--- 
--- (availability: server)
--- @return boolean
function CDOTA_BaseNPC:IsWard() end

--- Is this entity an Undying Zombie?
--- 
--- (availability: server)
--- @return boolean
function CDOTA_BaseNPC:IsZombie() end

--- Kills this NPC, with the params Ability and Attacker.
--- 
--- (availability: server)
--- @param ability CDOTABaseAbility | nil
--- @param attacker CDOTA_BaseNPC | nil
--- @return nil
function CDOTA_BaseNPC:Kill(ability, attacker) end

--- (availability: server)
--- @return nil
function CDOTA_BaseNPC:MakeIllusion() end

--- (availability: server)
--- @return nil
function CDOTA_BaseNPC:MakePhantomBlocker() end

--- (availability: server)
--- @param team DOTATeam_t
--- @param radius number
--- @return nil
function CDOTA_BaseNPC:MakeVisibleDueToAttack(team, radius) end

--- (availability: server)
--- @param team DOTATeam_t
--- @param duration number
--- @return nil
function CDOTA_BaseNPC:MakeVisibleToTeam(team, duration) end

--- (availability: server)
--- @return nil
function CDOTA_BaseNPC:ManageModelChanges() end

--- Sets the health to a specific value, with optional flags or inflictors.
--- 
--- (availability: server)
--- @param desiredHealthValue integer
--- @param ability CDOTABaseAbility | nil
--- @param lethal boolean
--- @param additionalFlags integer
--- @return nil
function CDOTA_BaseNPC:ModifyHealth(desiredHealthValue, ability, lethal, additionalFlags) end

--- Move to follow a unit.
--- 
--- (availability: server)
--- @param npc CDOTA_BaseNPC
--- @return nil
function CDOTA_BaseNPC:MoveToNPC(npc) end

--- Give an item to another unit.
--- 
--- (availability: server)
--- @param npc CDOTA_BaseNPC
--- @param item CDOTA_Item
--- @return nil
function CDOTA_BaseNPC:MoveToNPCToGiveItem(npc, item) end

--- Issue a Move-To command.
--- 
--- (availability: server)
--- @param dest Vector
--- @return nil
function CDOTA_BaseNPC:MoveToPosition(dest) end

--- Issue an Attack-Move-To command.
--- 
--- (availability: server)
--- @param dest Vector
--- @return nil
function CDOTA_BaseNPC:MoveToPositionAggressive(dest) end

--- Move to a target to attack.
--- 
--- (availability: server)
--- @param target CDOTA_BaseNPC
--- @return nil
function CDOTA_BaseNPC:MoveToTargetToAttack(target) end

--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:NoHealthBar() end

--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:NoTeamMoveTo() end

--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:NoTeamSelect() end

--- (availability: server)
--- @param originalModel boolean
--- @return nil
function CDOTA_BaseNPC:NotifyWearablesOfModelChange(originalModel) end

--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:NotOnMinimap() end

--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:NotOnMinimapForEnemies() end

--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:NoUnitCollision() end

--- Tells the underlying AI to move in the given direction, skipping Dota orders.
--- 
--- (availability: server)
--- @param pos Vector
--- @return nil
function CDOTA_BaseNPC:OnCommandMoveToDirection(pos) end

--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:PassivesDisabled() end

--- Issue a Patrol-To command.
--- 
--- (availability: server)
--- @param dest Vector
--- @return nil
function CDOTA_BaseNPC:PatrolToPosition(dest) end

--- Performs an attack on a target.
--- 
--- (availability: server)
--- @param target CDOTA_BaseNPC
--- @param useCastAttackOrb boolean
--- @param processProcs boolean
--- @param skipCooldown boolean
--- @param ignoreInvis boolean
--- @param useProjectile boolean
--- @param fakeAttack boolean
--- @param neverMiss boolean
--- @return nil
function CDOTA_BaseNPC:PerformAttack(target, useCastAttackOrb, processProcs, skipCooldown, ignoreInvis, useProjectile, fakeAttack, neverMiss) end

--- Pick up a dropped item.
--- 
--- (availability: server)
--- @param item CDOTA_Item
--- @return nil
function CDOTA_BaseNPC:PickupDroppedItem(item) end

--- Pick up a rune.
--- 
--- (availability: server)
--- @param item CDOTA_Item
--- @return nil
function CDOTA_BaseNPC:PickupRune(item) end

--- Play a VCD on the NPC.
--- 
--- (availability: server)
--- @param vcd string
--- @return nil
function CDOTA_BaseNPC:PlayVCD(vcd) end

--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:ProvidesVision() end

--- (availability: server)
--- @param removePositiveBuffs boolean
--- @param removeDebuffs boolean
--- @param frameOnly boolean
--- @param removeStuns boolean
--- @param removeExceptions boolean
--- @return nil
function CDOTA_BaseNPC:Purge(removePositiveBuffs, removeDebuffs, frameOnly, removeStuns, removeExceptions) end

--- Queue a response system concept with the TLK_DOTA_CUSTOM concept, after a delay.
--- 
--- (availability: server)
--- @param delay number
--- @param criteriaTable userdata
--- @param completionCallbackFn fun(didActuallySpeak: boolean, callbackInfo: table): nil
--- @param context table
--- @param callbackInfo table
--- @return nil
function CDOTA_BaseNPC:QueueConcept(delay, criteriaTable, completionCallbackFn, context, callbackInfo) end

--- Queue a response system concept with the TLK_DOTA_CUSTOM concept, after a delay, for the same team this speaker is on.
--- 
--- (availability: server)
--- @param delay number
--- @param criteriaTable userdata
--- @param completionCallbackFn fun(didActuallySpeak: boolean, callbackInfo: table): nil
--- @param context table
--- @param callbackInfo table
--- @return nil
function CDOTA_BaseNPC:QueueTeamConcept(delay, criteriaTable, completionCallbackFn, context, callbackInfo) end

--- Queue a response system concept with the TLK_DOTA_CUSTOM concept, after a delay, for the same team this speaker is on. Is not played for spectators.
--- 
--- (availability: server)
--- @param delay number
--- @param criteriaTable userdata
--- @param completionCallbackFn fun(didActuallySpeak: boolean, callbackInfo: table): nil
--- @param context table
--- @param callbackInfo table
--- @return nil
function CDOTA_BaseNPC:QueueTeamConceptNoSpectators(delay, criteriaTable, completionCallbackFn, context, callbackInfo) end

--- Remove an ability from this unit by name.
--- 
--- (availability: server)
--- @param abilityName string
--- @return nil
function CDOTA_BaseNPC:RemoveAbility(abilityName) end

--- Remove the passed ability from this unit.
--- 
--- (availability: server)
--- @param ability CDOTABaseAbility
--- @return nil
function CDOTA_BaseNPC:RemoveAbilityByHandle(ability) end

--- (availability: server)
--- @param abilityName string
--- @return nil
function CDOTA_BaseNPC:RemoveAbilityFromIndexByName(abilityName) end

--- (availability: server)
--- @param targets 0 | 1 | 2 0=all, 1=enemy, 2=ally
--- @param now boolean
--- @param permanent boolean
--- @param death boolean
--- @return nil
function CDOTA_BaseNPC:RemoveAllModifiers(targets, now, permanent, death) end

--- Removes all copies of a modifier.
--- 
--- (availability: server)
--- @param scriptName string
--- @return nil
function CDOTA_BaseNPC:RemoveAllModifiersOfName(scriptName) end

--- Remove the given gesture activity.
--- 
--- (availability: server)
--- @param activity GameActivity_t
--- @return nil
function CDOTA_BaseNPC:RemoveGesture(activity) end

--- (availability: server)
--- @param buff CDOTA_Buff
--- @return nil
function CDOTA_BaseNPC:RemoveHorizontalMotionController(buff) end

--- Removes the passed item from this unit's inventory and deletes it.
--- 
--- (availability: server)
--- @param item CDOTA_Item
--- @return nil
function CDOTA_BaseNPC:RemoveItem(item) end

--- Removes a modifier.
--- 
--- (availability: server)
--- @param scriptName string
--- @return nil
function CDOTA_BaseNPC:RemoveModifierByName(scriptName) end

--- Removes a modifier that was cast by the given caster.
--- 
--- (availability: server)
--- @param scriptName string
--- @param caster CDOTA_BaseNPC
--- @return nil
function CDOTA_BaseNPC:RemoveModifierByNameAndCaster(scriptName, caster) end

--- Remove the no draw flag.
--- 
--- (availability: server)
--- @return nil
function CDOTA_BaseNPC:RemoveNoDraw() end

--- (availability: server)
--- @param buff CDOTA_Buff
--- @return nil
function CDOTA_BaseNPC:RemoveVerticalMotionController(buff) end

--- Respawns the target unit if it can be respawned.
--- 
--- (availability: server)
--- @return nil
function CDOTA_BaseNPC:RespawnUnit() end

--- Gets this unit's attack range after all modifiers.
--- 
--- (availability: server & client)
--- @return number
function CDOTA_BaseNPC:Script_GetAttackRange() end

--- Returns current magical armor value.
--- 
--- (availability: server & client)
--- @param useExperimentalFormula boolean
--- @param inflictor userdata
--- @return number
function CDOTA_BaseNPC:Script_GetMagicalArmorValue(useExperimentalFormula, inflictor) end

--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:Script_IsDeniable() end

--- Remove mana from this unit, this can be used for involuntary mana loss, not for mana that is spent.
--- 
--- (availability: server)
--- @param mana number
--- @param ability userdata
--- @return number
function CDOTA_BaseNPC:Script_ReduceMana(mana, ability) end

--- Sells the passed item in this unit's inventory.
--- 
--- (availability: server)
--- @param item CDOTA_Item
--- @return nil
function CDOTA_BaseNPC:SellItem(item) end

--- Set the ability by index.
--- 
--- (availability: server)
--- @param ability CDOTABaseAbility
--- @param index integer
--- @return nil
function CDOTA_BaseNPC:SetAbilityByIndex(ability, index) end

--- (availability: server)
--- @param range integer
--- @return nil
function CDOTA_BaseNPC:SetAcquisitionRange(range) end

--- Combat involving this creature will have this weight added to the music calcuations.
--- 
--- (availability: server)
--- @param weight number
--- @return nil
function CDOTA_BaseNPC:SetAdditionalBattleMusicWeight(weight) end

--- Set this unit's aggro target to a specified unit.
--- 
--- (availability: server)
--- @param aggroTarget CDOTA_BaseNPC
--- @return nil
function CDOTA_BaseNPC:SetAggroTarget(aggroTarget) end

--- (availability: server)
--- @param attackCapabilities DOTAUnitAttackCapability_t
--- @return nil
function CDOTA_BaseNPC:SetAttackCapability(attackCapabilities) end

--- (availability: server)
--- @param attackTarget CDOTA_BaseNPC | nil
--- @return nil
function CDOTA_BaseNPC:SetAttacking(attackTarget) end

--- (availability: server)
--- @param baseAttackTime number
--- @return nil
function CDOTA_BaseNPC:SetBaseAttackTime(baseAttackTime) end

--- Sets the maximum base damage.
--- 
--- (availability: server)
--- @param max integer
--- @return nil
function CDOTA_BaseNPC:SetBaseDamageMax(max) end

--- Sets the minimum base damage.
--- 
--- (availability: server)
--- @param min integer
--- @return nil
function CDOTA_BaseNPC:SetBaseDamageMin(min) end

--- (availability: server)
--- @param healthRegen number
--- @return nil
function CDOTA_BaseNPC:SetBaseHealthRegen(healthRegen) end

--- Sets base magical armor value.
--- 
--- (availability: server)
--- @param magicalResistanceValue number
--- @return nil
function CDOTA_BaseNPC:SetBaseMagicalResistanceValue(magicalResistanceValue) end

--- (availability: server)
--- @param manaRegen number
--- @return nil
function CDOTA_BaseNPC:SetBaseManaRegen(manaRegen) end

--- Set a new base max health value.
--- 
--- (availability: server)
--- @param baseMaxHealth number
--- @return nil
function CDOTA_BaseNPC:SetBaseMaxHealth(baseMaxHealth) end

--- (availability: server)
--- @param moveSpeed integer
--- @return nil
function CDOTA_BaseNPC:SetBaseMoveSpeed(moveSpeed) end

--- Set whether or not this unit is allowed to sell items (bCanSellItems).
--- 
--- (availability: server)
--- @param canSell boolean
--- @return nil
function CDOTA_BaseNPC:SetCanSellItems(canSell) end

--- Set this unit controllable by the player with the passed ID.
--- 
--- (availability: server)
--- @param playerId PlayerID
--- @param skipAdjustingPosition boolean
--- @return nil
function CDOTA_BaseNPC:SetControllableByPlayer(playerId, skipAdjustingPosition) end

--- (availability: server)
--- @param entity CDOTA_BaseNPC | nil
--- @return nil
function CDOTA_BaseNPC:SetCursorCastTarget(entity) end

--- (availability: server)
--- @param location Vector
--- @return nil
function CDOTA_BaseNPC:SetCursorPosition(location) end

--- (availability: server)
--- @param targetingNothing boolean
--- @return nil
function CDOTA_BaseNPC:SetCursorTargetingNothing(targetingNothing) end

--- (availability: server)
--- @param label string
--- @param r integer
--- @param g integer
--- @param b integer
--- @return nil
function CDOTA_BaseNPC:SetCustomHealthLabel(label, r, g, b) end

--- Set the base vision range.
--- 
--- (availability: server)
--- @param range integer
--- @return nil
function CDOTA_BaseNPC:SetDayTimeVisionRange(range) end

--- Set the XP bounty on this unit.
--- 
--- (availability: server)
--- @param xpBounty integer
--- @return nil
function CDOTA_BaseNPC:SetDeathXP(xpBounty) end

--- (availability: server)
--- @param followRange number
--- @return nil
function CDOTA_BaseNPC:SetFollowRange(followRange) end

--- (availability: server)
--- @param npc CDOTA_BaseNPC | nil
--- @return nil
function CDOTA_BaseNPC:SetForceAttackTarget(npc) end

--- (availability: server)
--- @param npc CDOTA_BaseNPC | nil
--- @return nil
function CDOTA_BaseNPC:SetForceAttackTargetAlly(npc) end

--- Set if this unit has an inventory.
--- 
--- (availability: server)
--- @param hasInventory boolean
--- @return nil
function CDOTA_BaseNPC:SetHasInventory(hasInventory) end

--- (availability: server)
--- @param offset integer
--- @return nil
function CDOTA_BaseNPC:SetHealthBarOffsetOverride(offset) end

--- Set the collision hull radius of this NPC.
--- 
--- (availability: server)
--- @param hullRadius number
--- @return nil
function CDOTA_BaseNPC:SetHullRadius(hullRadius) end

--- (availability: server)
--- @param idleAcquire boolean
--- @return nil
function CDOTA_BaseNPC:SetIdleAcquire(idleAcquire) end

--- Sets the initial waypoint goal for this NPC.
--- 
--- (availability: server)
--- @param goal CBaseEntity | nil
--- @return nil
function CDOTA_BaseNPC:SetInitialGoalEntity(goal) end

--- Set waypoint position for this NPC.
--- 
--- (availability: server)
--- @param position Vector
--- @return nil
function CDOTA_BaseNPC:SetInitialGoalPosition(position) end

--- Set the mana on this unit.
--- 
--- (availability: server)
--- @param mana number
--- @return nil
function CDOTA_BaseNPC:SetMana(mana) end

--- Set the maximum gold bounty for this unit.
--- 
--- (availability: server)
--- @param goldBountyMax integer
--- @return nil
function CDOTA_BaseNPC:SetMaximumGoldBounty(goldBountyMax) end

--- Set the maximum mana of this unit.
--- 
--- (availability: server)
--- @param maxMana number
--- @return nil
function CDOTA_BaseNPC:SetMaxMana(maxMana) end

--- Set the minimum gold bounty for this unit.
--- 
--- (availability: server)
--- @param goldBountyMin integer
--- @return nil
function CDOTA_BaseNPC:SetMinimumGoldBounty(goldBountyMin) end

--- Sets the stack count of a given modifier.
--- 
--- (availability: server)
--- @param scriptName string
--- @param caster CDOTA_BaseNPC
--- @param stackCount integer
--- @return nil
function CDOTA_BaseNPC:SetModifierStackCount(scriptName, caster, stackCount) end

--- (availability: server)
--- @param moveCapabilities DOTAUnitMoveCapability_t
--- @return nil
function CDOTA_BaseNPC:SetMoveCapability(moveCapabilities) end

--- Set whether this NPC is required to reach each goal entity, rather than being allowed to unkink their path.
--- 
--- (availability: server)
--- @param must boolean
--- @return nil
function CDOTA_BaseNPC:SetMustReachEachGoalEntity(must) end

--- If set to true, we will never attempt to move this unit to clear space, even when it unphases.
--- 
--- (availability: server)
--- @param neverMoveToClearSpace boolean
--- @return nil
function CDOTA_BaseNPC:SetNeverMoveToClearSpace(neverMoveToClearSpace) end

--- Returns the vision range after modifiers.
--- 
--- (availability: server)
--- @param range integer
--- @return nil
function CDOTA_BaseNPC:SetNightTimeVisionRange(range) end

--- Set the unit's origin.
--- 
--- (availability: server)
--- @param location Vector
--- @return nil
function CDOTA_BaseNPC:SetOrigin(location) end

--- Sets the original model of this entity, which it will tend to fall back to anytime its state changes.
--- 
--- (availability: server)
--- @param modelName string
--- @return nil
function CDOTA_BaseNPC:SetOriginalModel(modelName) end

--- Sets base physical armor value.
--- 
--- (availability: server)
--- @param physicalArmorValue number
--- @return nil
function CDOTA_BaseNPC:SetPhysicalArmorBaseValue(physicalArmorValue) end

--- (availability: server)
--- @param projectileName string
--- @return nil
function CDOTA_BaseNPC:SetRangedProjectileName(projectileName) end

--- Sets the client side map reveal radius for this unit.
--- 
--- (availability: server)
--- @param revealRadius number
--- @return nil
function CDOTA_BaseNPC:SetRevealRadius(revealRadius) end

--- (availability: server)
--- @param compute boolean
--- @return nil
function CDOTA_BaseNPC:SetShouldComputeRemainingPathLength(compute) end

--- (availability: server)
--- @param shouldVisuallyFly boolean
--- @return nil
function CDOTA_BaseNPC:SetShouldDoFlyHeightVisual(shouldVisuallyFly) end

--- (availability: server)
--- @param stolenScepter boolean
--- @return nil
function CDOTA_BaseNPC:SetStolenScepter(stolenScepter) end

--- (availability: server)
--- @param canRespawn boolean
--- @return nil
function CDOTA_BaseNPC:SetUnitCanRespawn(canRespawn) end

--- (availability: server)
--- @param name string
--- @return nil
function CDOTA_BaseNPC:SetUnitName(name) end

--- (availability: server)
--- @return boolean
function CDOTA_BaseNPC:ShouldIdleAcquire() end

--- Speak a response system concept with the TLK_DOTA_CUSTOM concept.
--- 
--- (availability: server)
--- @param criteriaTable userdata
--- @return nil
function CDOTA_BaseNPC:SpeakConcept(criteriaTable) end

--- Spend mana from this unit, this can be used for spending mana from abilities or item usage.
--- 
--- (availability: server)
--- @param manaSpent number
--- @param ability CDOTABaseAbility
--- @return nil
function CDOTA_BaseNPC:SpendMana(manaSpent, ability) end

--- Add the given gesture activity.
--- 
--- (availability: server)
--- @param activity GameActivity_t
--- @return nil
function CDOTA_BaseNPC:StartGesture(activity) end

--- Add the given gesture activity faded according to its sequence settings.
--- 
--- (availability: server)
--- @param activity GameActivity_t
--- @return nil
function CDOTA_BaseNPC:StartGestureFadeWithSequenceSettings(activity) end

--- Add the given gesture activity faded according to to the parameters.
--- 
--- (availability: server)
--- @param activity GameActivity_t
--- @param fadeIn number
--- @param fadeOut number
--- @return nil
function CDOTA_BaseNPC:StartGestureWithFade(activity, fadeIn, fadeOut) end

--- Add the given gesture activity faded according to to the parameters and with a playback rate override.
--- 
--- (availability: server)
--- @param activity integer
--- @param fadeIn number
--- @param fadeOut number
--- @param rate number
--- @return nil
function CDOTA_BaseNPC:StartGestureWithFadeAndPlaybackRate(activity, fadeIn, fadeOut, rate) end

--- Add the given gesture activity with a playback rate override.
--- 
--- (availability: server)
--- @param activity GameActivity_t
--- @param rate number
--- @return nil
function CDOTA_BaseNPC:StartGestureWithPlaybackRate(activity, rate) end

--- Stop the current order.
--- 
--- (availability: server)
--- @return nil
function CDOTA_BaseNPC:Stop() end

--- (availability: server)
--- @return nil
function CDOTA_BaseNPC:StopFacing() end

--- Swaps the slots of the two passed abilities and sets them enabled/disabled.
--- 
--- (availability: server)
--- @param abilityName1 string
--- @param abilityName2 string
--- @param enable1 boolean
--- @param enable2 boolean
--- @return nil
function CDOTA_BaseNPC:SwapAbilities(abilityName1, abilityName2, enable1, enable2) end

--- Swap the contents of two item slots (slot1, slot2).
--- 
--- (availability: server)
--- @param slot1 integer
--- @param slot2 integer
--- @return nil
function CDOTA_BaseNPC:SwapItems(slot1, slot2) end

--- Removed the passed item from this unit's inventory. Returns the passed item.
--- 
--- (availability: server)
--- @param item CDOTA_Item
--- @return CDOTA_Item
function CDOTA_BaseNPC:TakeItem(item) end

--- (availability: server)
--- @return number
function CDOTA_BaseNPC:TimeUntilNextAttack() end

--- (availability: server)
--- @return boolean
function CDOTA_BaseNPC:TriggerModifierDodge() end

--- (availability: server)
--- @param ability CDOTABaseAbility
--- @return boolean
function CDOTA_BaseNPC:TriggerSpellAbsorb(ability) end

--- Trigger the Lotus Orb-like effect.(hAbility).
--- 
--- (availability: server)
--- @param ability CDOTABaseAbility
--- @return nil
function CDOTA_BaseNPC:TriggerSpellReflect(ability) end

--- Makes the first ability unhidden, and puts it where second ability currently is. Will do nothing if the first ability is already unhidden and in a valid slot.
--- 
--- (availability: server)
--- @param abilityName string
--- @param replacedAbilityName string
--- @return nil
function CDOTA_BaseNPC:UnHideAbilityToSlot(abilityName, replacedAbilityName) end

--- Can the unit respawn?
--- 
--- (availability: server & client)
--- @return boolean
function CDOTA_BaseNPC:UnitCanRespawn() end

--- (availability: server)
--- @return boolean
function CDOTA_BaseNPC:WasKilledPassively() end


--- @class CDOTA_BaseNPC_Building : CDOTA_BaseNPC
CDOTA_BaseNPC_Building = {}

--- Get the invulnerability count for a building.
--- 
--- (availability: server)
--- @return integer
function CDOTA_BaseNPC_Building:GetInvulnCount() end

--- Set the invulnerability counter of this building.
--- 
--- (availability: server)
--- @param invulnCount integer
--- @return nil
function CDOTA_BaseNPC_Building:SetInvulnCount(invulnCount) end


--- @class CDOTA_BaseNPC_Creature : CDOTA_BaseNPC
CDOTA_BaseNPC_Creature = {}

--- Add the specified item drop to this creature.
--- 
--- (availability: server)
--- @param dropData table
--- @return nil
function CDOTA_BaseNPC_Creature:AddItemDrop(dropData) end

--- Level the creature up by the specified number of levels.
--- 
--- (availability: server)
--- @param levels integer
--- @return nil
function CDOTA_BaseNPC_Creature:CreatureLevelUp(levels) end

--- Set creature's current disable resistance.
--- 
--- (availability: server)
--- @return number
function CDOTA_BaseNPC_Creature:GetDisableResistance() end

--- Set creature's current disable resistance from ultimates.
--- 
--- (availability: server)
--- @return number
function CDOTA_BaseNPC_Creature:GetUltimateDisableResistance() end

--- Is this unit a champion?
--- 
--- (availability: server)
--- @return boolean
function CDOTA_BaseNPC_Creature:IsChampion() end

--- Is this creature respawning?
--- 
--- (availability: server)
--- @return boolean
function CDOTA_BaseNPC_Creature:IsReincarnating() end

--- Remove all item drops from this creature.
--- 
--- (availability: server)
--- @return nil
function CDOTA_BaseNPC_Creature:RemoveAllItemDrops() end

--- Does this creature aggro on the owner of the attacking unit when taking damage?
--- 
--- (availability: server)
--- @param aggro boolean
--- @return nil
function CDOTA_BaseNPC_Creature:SetAggroOnOwnerOnDamage(aggro) end

--- Set the armor gained per level on this creature.
--- 
--- (availability: server)
--- @param armorGain number
--- @return nil
function CDOTA_BaseNPC_Creature:SetArmorGain(armorGain) end

--- Set the attack time gained per level on this creature.
--- 
--- (availability: server)
--- @param attackTimeGain number
--- @return nil
function CDOTA_BaseNPC_Creature:SetAttackTimeGain(attackTimeGain) end

--- Set the bounty gold gained per level on this creature.
--- 
--- (availability: server)
--- @param bountyGain integer
--- @return nil
function CDOTA_BaseNPC_Creature:SetBountyGain(bountyGain) end

--- Flag this unit as a champion creature.
--- 
--- (availability: server)
--- @param isChampion boolean
--- @return nil
function CDOTA_BaseNPC_Creature:SetChampion(isChampion) end

--- Set the damage gained per level on this creature.
--- 
--- (availability: server)
--- @param damageGain integer
--- @return nil
function CDOTA_BaseNPC_Creature:SetDamageGain(damageGain) end

--- Set creature's current disable resistance.
--- 
--- (availability: server)
--- @param disableResistance number
--- @return nil
function CDOTA_BaseNPC_Creature:SetDisableResistance(disableResistance) end

--- Set the disable resistance gained per level on this creature.
--- 
--- (availability: server)
--- @param disableResistanceGain number
--- @return nil
function CDOTA_BaseNPC_Creature:SetDisableResistanceGain(disableResistanceGain) end

--- Set the hit points gained per level on this creature.
--- 
--- (availability: server)
--- @param hpGain integer
--- @return nil
function CDOTA_BaseNPC_Creature:SetHPGain(hpGain) end

--- Set the hit points regen gained per level on this creature.
--- 
--- (availability: server)
--- @param hpRegenGain number
--- @return nil
function CDOTA_BaseNPC_Creature:SetHPRegenGain(hpRegenGain) end

--- Set the magic resistance gained per level on this creature.
--- 
--- (availability: server)
--- @param magicResistanceGain number
--- @return nil
function CDOTA_BaseNPC_Creature:SetMagicResistanceGain(magicResistanceGain) end

--- Set the mana points gained per level on this creature.
--- 
--- (availability: server)
--- @param manaGain integer
--- @return nil
function CDOTA_BaseNPC_Creature:SetManaGain(manaGain) end

--- Set the mana points regen gained per level on this creature.
--- 
--- (availability: server)
--- @param manaRegenGain number
--- @return nil
function CDOTA_BaseNPC_Creature:SetManaRegenGain(manaRegenGain) end

--- Set the move speed gained per level on this creature.
--- 
--- (availability: server)
--- @param moveSpeedGain integer
--- @return nil
function CDOTA_BaseNPC_Creature:SetMoveSpeedGain(moveSpeedGain) end

--- Set whether creatures require reaching their end path before becoming idle.
--- 
--- (availability: server)
--- @param requiresReachingEndPath boolean
--- @return nil
function CDOTA_BaseNPC_Creature:SetRequiresReachingEndPath(requiresReachingEndPath) end

--- Set creature's current disable resistance from ultimates.
--- 
--- (availability: server)
--- @param ultDisableResistance number
--- @return nil
function CDOTA_BaseNPC_Creature:SetUltimateDisableResistance(ultDisableResistance) end

--- Set the XP gained per level on this creature.
--- 
--- (availability: server)
--- @param xpGain integer
--- @return nil
function CDOTA_BaseNPC_Creature:SetXPGain(xpGain) end


--- @class CDOTA_BaseNPC_Hero : CDOTA_BaseNPC
CDOTA_BaseNPC_Hero = {}

--- (availability: server)
--- @param xp number
--- @param reason EDOTA_ModifyXP_Reason
--- @param applyBotDifficultyScaling boolean
--- @param incrementTotal boolean
--- @return boolean
function CDOTA_BaseNPC_Hero:AddExperience(xp, reason, applyBotDifficultyScaling, incrementTotal) end

--- Spend the gold and buyback with this hero.
--- 
--- (availability: server)
--- @return nil
function CDOTA_BaseNPC_Hero:Buyback() end

--- Recalculate all stats after the hero gains stats.
--- 
--- (availability: server)
--- @param force boolean
--- @return nil
function CDOTA_BaseNPC_Hero:CalculateStatBonus(force) end

--- Returns boolean value result of buyback gold limit time less than game time.
--- 
--- (availability: server)
--- @return boolean
function CDOTA_BaseNPC_Hero:CanEarnGold() end

--- Value is stored in PlayerResource.
--- 
--- (availability: server)
--- @return nil
function CDOTA_BaseNPC_Hero:ClearLastHitMultikill() end

--- Value is stored in PlayerResource.
--- 
--- (availability: server)
--- @return nil
function CDOTA_BaseNPC_Hero:ClearLastHitStreak() end

--- Value is stored in PlayerResource.
--- 
--- (availability: server)
--- @return nil
function CDOTA_BaseNPC_Hero:ClearStreak() end

--- Gets the current unspent ability points.
--- 
--- (availability: server)
--- @return integer
function CDOTA_BaseNPC_Hero:GetAbilityPoints() end

--- (availability: server)
--- @return CDOTA_BaseNPC[]
function CDOTA_BaseNPC_Hero:GetAdditionalOwnedUnits() end

--- (availability: server & client)
--- @return number
function CDOTA_BaseNPC_Hero:GetAgility() end

--- (availability: server)
--- @return number
function CDOTA_BaseNPC_Hero:GetAgilityGain() end

--- Value is stored in PlayerResource.
--- 
--- (availability: server)
--- @return integer
function CDOTA_BaseNPC_Hero:GetAssists() end

--- (availability: server)
--- @param index integer
--- @return integer
function CDOTA_BaseNPC_Hero:GetAttacker(index) end

--- (availability: server)
--- @return number
function CDOTA_BaseNPC_Hero:GetBaseAgility() end

--- Hero damage is also affected by attributes.
--- 
--- (availability: server)
--- @return integer
function CDOTA_BaseNPC_Hero:GetBaseDamageMax() end

--- Hero damage is also affected by attributes.
--- 
--- (availability: server)
--- @return integer
function CDOTA_BaseNPC_Hero:GetBaseDamageMin() end

--- (availability: server)
--- @return number
function CDOTA_BaseNPC_Hero:GetBaseIntellect() end

--- Returns the base mana regen.
--- 
--- (availability: server)
--- @return number
function CDOTA_BaseNPC_Hero:GetBaseManaRegen() end

--- (availability: server)
--- @return number
function CDOTA_BaseNPC_Hero:GetBaseStrength() end

--- (availability: server)
--- @return integer
function CDOTA_BaseNPC_Hero:GetBonusDamageFromPrimaryStat() end

--- Return float value for the amount of time left on cooldown for this hero's buyback.
--- 
--- (availability: server)
--- @return number
function CDOTA_BaseNPC_Hero:GetBuybackCooldownTime() end

--- Return integer value for the gold cost of a buyback.
--- 
--- (availability: server)
--- @param returnOldValues boolean
--- @return integer
function CDOTA_BaseNPC_Hero:GetBuybackCost(returnOldValues) end

--- Returns the amount of time gold gain is limited after buying back.
--- 
--- (availability: server)
--- @return number
function CDOTA_BaseNPC_Hero:GetBuybackGoldLimitTime() end

--- Returns the amount of XP.
--- 
--- (availability: server)
--- @return integer
function CDOTA_BaseNPC_Hero:GetCurrentXP() end

--- (availability: server)
--- @return integer
function CDOTA_BaseNPC_Hero:GetDeathGoldCost() end

--- Value is stored in PlayerResource.
--- 
--- (availability: server)
--- @return integer
function CDOTA_BaseNPC_Hero:GetDeaths() end

--- Value is stored in PlayerResource.
--- 
--- (availability: server)
--- @return integer
function CDOTA_BaseNPC_Hero:GetDenies() end

--- Returns gold amount for the player owning this hero.
--- 
--- (availability: server)
--- @return integer
function CDOTA_BaseNPC_Hero:GetGold() end

--- (availability: server)
--- @return integer
function CDOTA_BaseNPC_Hero:GetGoldBounty() end

--- (availability: server)
--- @return integer
function CDOTA_BaseNPC_Hero:GetHeroID() end

--- Hero attack speed is also affected by agility.
--- 
--- (availability: server)
--- @param ignoreTempAttackSpeed boolean
--- @return number
function CDOTA_BaseNPC_Hero:GetIncreasedAttackSpeed(ignoreTempAttackSpeed) end

--- (availability: server & client)
--- @return number
function CDOTA_BaseNPC_Hero:GetIntellect() end

--- (availability: server)
--- @return number
function CDOTA_BaseNPC_Hero:GetIntellectGain() end

--- Value is stored in PlayerResource.
--- 
--- (availability: server)
--- @return integer
function CDOTA_BaseNPC_Hero:GetKills() end

--- Value is stored in PlayerResource.
--- 
--- (availability: server)
--- @return integer
function CDOTA_BaseNPC_Hero:GetLastHits() end

--- (availability: server)
--- @return number
function CDOTA_BaseNPC_Hero:GetMostRecentDamageTime() end

--- (availability: server)
--- @return integer
function CDOTA_BaseNPC_Hero:GetMultipleKillCount() end

--- (availability: server)
--- @return integer
function CDOTA_BaseNPC_Hero:GetNumAttackers() end

--- (availability: server)
--- @return integer
function CDOTA_BaseNPC_Hero:GetNumItemsInInventory() end

--- (availability: server)
--- @return integer
function CDOTA_BaseNPC_Hero:GetNumItemsInStash() end

--- Hero armor is affected by attributes.
--- 
--- (availability: server)
--- @return number
function CDOTA_BaseNPC_Hero:GetPhysicalArmorBaseValue() end

--- Returns player ID of the player owning this hero.
--- 
--- (availability: server)
--- @return PlayerID
function CDOTA_BaseNPC_Hero:GetPlayerID() end

--- (availability: server)
--- @return Attributes
function CDOTA_BaseNPC_Hero:GetPrimaryAttribute() end

--- (availability: server)
--- @return number
function CDOTA_BaseNPC_Hero:GetPrimaryStatValue() end

--- If hero is under Replicate effect, returns original hero entity.
--- 
--- (availability: server)
--- @return CDOTA_BaseNPC_Hero | nil
function CDOTA_BaseNPC_Hero:GetReplicatingOtherHero() end

--- Is this hero prevented from respawning?
--- 
--- (availability: server)
--- @return boolean
function CDOTA_BaseNPC_Hero:GetRespawnsDisabled() end

--- (availability: server)
--- @return number
function CDOTA_BaseNPC_Hero:GetRespawnTime() end

--- Value is stored in PlayerResource.
--- 
--- (availability: server)
--- @return integer
function CDOTA_BaseNPC_Hero:GetStreak() end

--- (availability: server & client)
--- @return number
function CDOTA_BaseNPC_Hero:GetStrength() end

--- (availability: server)
--- @return number
function CDOTA_BaseNPC_Hero:GetStrengthGain() end

--- (availability: server)
--- @return number
function CDOTA_BaseNPC_Hero:GetTimeUntilRespawn() end

--- Get wearable entity in slot (slot).
--- 
--- (availability: server)
--- @param slotType DOTASlotType_t
--- @return CBaseFlex | nil
function CDOTA_BaseNPC_Hero:GetTogglableWearable(slotType) end

--- (availability: server)
--- @return boolean
function CDOTA_BaseNPC_Hero:HasAnyAvailableInventorySpace() end

--- (availability: server)
--- @return boolean
function CDOTA_BaseNPC_Hero:HasFlyingVision() end

--- (availability: server)
--- @return boolean
function CDOTA_BaseNPC_Hero:HasOwnerAbandoned() end

--- (availability: server)
--- @param itemName string
--- @param includeStashCombines boolean
--- @param allowSelling boolean
--- @return integer
function CDOTA_BaseNPC_Hero:HasRoomForItem(itemName, includeStashCombines, allowSelling) end

--- Levels up the hero, true or false to play effects.
--- 
--- (availability: server)
--- @param playEffects boolean
--- @return nil
function CDOTA_BaseNPC_Hero:HeroLevelUp(playEffects) end

--- Value is stored in PlayerResource.
--- 
--- (availability: server)
--- @param killerId PlayerID
--- @return nil
function CDOTA_BaseNPC_Hero:IncrementAssists(killerId) end

--- Value is stored in PlayerResource.
--- 
--- (availability: server)
--- @param killerId PlayerID
--- @return nil
function CDOTA_BaseNPC_Hero:IncrementDeaths(killerId) end

--- Value is stored in PlayerResource.
--- 
--- (availability: server)
--- @return nil
function CDOTA_BaseNPC_Hero:IncrementDenies() end

--- Passed ID is for the victim, killer ID is ID of the current hero.  Value is stored in PlayerResource.
--- 
--- (availability: server)
--- @param victimId PlayerID
--- @return nil
function CDOTA_BaseNPC_Hero:IncrementKills(victimId) end

--- Value is stored in PlayerResource.
--- 
--- (availability: server)
--- @return nil
function CDOTA_BaseNPC_Hero:IncrementLastHitMultikill() end

--- Value is stored in PlayerResource.
--- 
--- (availability: server)
--- @return nil
function CDOTA_BaseNPC_Hero:IncrementLastHits() end

--- Value is stored in PlayerResource.
--- 
--- (availability: server)
--- @return nil
function CDOTA_BaseNPC_Hero:IncrementLastHitStreak() end

--- Value is stored in PlayerResource.
--- 
--- (availability: server)
--- @return nil
function CDOTA_BaseNPC_Hero:IncrementNearbyCreepDeaths() end

--- Value is stored in PlayerResource.
--- 
--- (availability: server)
--- @return nil
function CDOTA_BaseNPC_Hero:IncrementStreak() end

--- (availability: server)
--- @return boolean
function CDOTA_BaseNPC_Hero:IsBuybackDisabledByReapersScythe() end

--- (availability: server)
--- @return boolean
function CDOTA_BaseNPC_Hero:IsReincarnating() end

--- (availability: server)
--- @return boolean
function CDOTA_BaseNPC_Hero:IsStashEnabled() end

--- (availability: server)
--- @param hero CDOTA_BaseNPC_Hero
--- @param inflictor CDOTABaseAbility | nil
--- @return nil
function CDOTA_BaseNPC_Hero:KilledHero(hero, inflictor) end

--- Adds passed value to base attribute value, then calls CalculateStatBonus.
--- 
--- (availability: server)
--- @param newAgility number
--- @return nil
function CDOTA_BaseNPC_Hero:ModifyAgility(newAgility) end

--- Gives this hero some gold.
--- 
--- (availability: server)
--- @param goldChange integer
--- @param reliable boolean
--- @param reason EDOTA_ModifyGold_Reason
--- @return integer
function CDOTA_BaseNPC_Hero:ModifyGold(goldChange, reliable, reason) end

--- Gives this hero some gold, using the gold filter if extra filtering is on.
--- 
--- (availability: server)
--- @param goldChange integer
--- @param reliable boolean
--- @param reason EDOTA_ModifyGold_Reason
--- @return integer
function CDOTA_BaseNPC_Hero:ModifyGoldFiltered(goldChange, reliable, reason) end

--- Adds passed value to base attribute value, then calls CalculateStatBonus.
--- 
--- (availability: server)
--- @param newIntellect number
--- @return nil
function CDOTA_BaseNPC_Hero:ModifyIntellect(newIntellect) end

--- Adds passed value to base attribute value, then calls CalculateStatBonus.
--- 
--- (availability: server)
--- @param newStrength number
--- @return nil
function CDOTA_BaseNPC_Hero:ModifyStrength(newStrength) end

--- (availability: server)
--- @return nil
function CDOTA_BaseNPC_Hero:PerformTaunt() end

--- (availability: server)
--- @return nil
function CDOTA_BaseNPC_Hero:RecordLastHit() end

--- Respawn this hero.
--- 
--- (availability: server)
--- @param buyBack boolean
--- @param respawnPenalty boolean
--- @return nil
function CDOTA_BaseNPC_Hero:RespawnHero(buyBack, respawnPenalty) end

--- Sets the current unspent ability points.
--- 
--- (availability: server)
--- @param points integer
--- @return nil
function CDOTA_BaseNPC_Hero:SetAbilityPoints(points) end

--- (availability: server)
--- @param agility number
--- @return nil
function CDOTA_BaseNPC_Hero:SetBaseAgility(agility) end

--- (availability: server)
--- @param intellect number
--- @return nil
function CDOTA_BaseNPC_Hero:SetBaseIntellect(intellect) end

--- (availability: server)
--- @param strength number
--- @return nil
function CDOTA_BaseNPC_Hero:SetBaseStrength(strength) end

--- (availability: server)
--- @param difficulty integer
--- @return nil
function CDOTA_BaseNPC_Hero:SetBotDifficulty(difficulty) end

--- Sets the buyback cooldown time.
--- 
--- (availability: server)
--- @param time number
--- @return nil
function CDOTA_BaseNPC_Hero:SetBuybackCooldownTime(time) end

--- (availability: server)
--- @param buybackDisabled boolean
--- @return nil
function CDOTA_BaseNPC_Hero:SetBuyBackDisabledByReapersScythe(buybackDisabled) end

--- Set the amount of time gold gain is limited after buying back.
--- 
--- (availability: server)
--- @param time number
--- @return nil
function CDOTA_BaseNPC_Hero:SetBuybackGoldLimitTime(time) end

--- Sets a custom experience value for this hero.  Note, GameRules boolean must be set for this to work!
--- 
--- (availability: server)
--- @param value integer
--- @return nil
function CDOTA_BaseNPC_Hero:SetCustomDeathXP(value) end

--- Sets the gold amount for the player owning this hero.
--- 
--- (availability: server)
--- @param gold integer
--- @param reliable boolean
--- @return nil
function CDOTA_BaseNPC_Hero:SetGold(gold, reliable) end

--- (availability: server)
--- @param playerId PlayerID
--- @return nil
function CDOTA_BaseNPC_Hero:SetPlayerID(playerId) end

--- Set this hero's primary attribute value.
--- 
--- (availability: server)
--- @param primaryAttribute Attributes
--- @return nil
function CDOTA_BaseNPC_Hero:SetPrimaryAttribute(primaryAttribute) end

--- (availability: server)
--- @param origin Vector
--- @return nil
function CDOTA_BaseNPC_Hero:SetRespawnPosition(origin) end

--- Prevent this hero from respawning.
--- 
--- (availability: server)
--- @param disableRespawns boolean
--- @return nil
function CDOTA_BaseNPC_Hero:SetRespawnsDisabled(disableRespawns) end

--- (availability: server)
--- @param enabled boolean
--- @return nil
function CDOTA_BaseNPC_Hero:SetStashEnabled(enabled) end

--- (availability: server)
--- @param time number
--- @return nil
function CDOTA_BaseNPC_Hero:SetTimeUntilRespawn(time) end

--- (availability: server)
--- @return boolean
function CDOTA_BaseNPC_Hero:ShouldDoFlyHeightVisual() end

--- (availability: server)
--- @param cost integer
--- @param reason EDOTA_ModifyGold_Reason
--- @return nil
function CDOTA_BaseNPC_Hero:SpendGold(cost, reason) end

--- This upgrades the passed ability if it exists and the hero has enough ability points.
--- 
--- (availability: server)
--- @param ability CDOTABaseAbility
--- @return nil
function CDOTA_BaseNPC_Hero:UpgradeAbility(ability) end

--- (availability: server)
--- @return boolean
function CDOTA_BaseNPC_Hero:WillReincarnate() end


--- @class CDOTA_BaseNPC_MangoTree : CDOTA_BaseNPC_Building
CDOTA_BaseNPC_MangoTree = {}

--- @class CDOTA_BaseNPC_NeutralItemStash : CDOTA_BaseNPC_Building
CDOTA_BaseNPC_NeutralItemStash = {}

--- @class CDOTA_BaseNPC_Shop : CDOTA_BaseNPC_Building
CDOTA_BaseNPC_Shop = {}

--- Get the DOTA_SHOP_TYPE.
--- 
--- (availability: server)
--- @return DOTA_SHOP_TYPE
function CDOTA_BaseNPC_Shop:GetShopType() end

--- Set the DOTA_SHOP_TYPE.
--- 
--- (availability: server)
--- @param shopType DOTA_SHOP_TYPE
--- @return nil
function CDOTA_BaseNPC_Shop:SetShopType(shopType) end


--- @class CDOTA_BaseNPC_Trap_Ward : CDOTA_BaseNPC_Creature
CDOTA_BaseNPC_Trap_Ward = {}

--- Get the trap target for this entity.
--- 
--- (availability: server)
--- @return Vector
function CDOTA_BaseNPC_Trap_Ward:GetTrapTarget() end

--- Set the animation sequence for this entity.
--- 
--- (availability: server)
--- @param animation string
--- @return nil
function CDOTA_BaseNPC_Trap_Ward:SetAnimation(animation) end


--- @class CDOTA_BaseNPC_Watch_Tower : CDOTA_BaseNPC_Building
CDOTA_BaseNPC_Watch_Tower = {}

--- The name of the ability used when triggering interaction on the outpost.
--- 
--- (availability: server)
--- @return string
function CDOTA_BaseNPC_Watch_Tower:GetInteractAbilityName() end

--- The name of the ability used when triggering interaction on the outpost.
--- 
--- (availability: server)
--- @param interactAbilityName string
--- @return nil
function CDOTA_BaseNPC_Watch_Tower:SetInteractAbilityName(interactAbilityName) end


--- @class CDOTA_Buff
CDOTA_Buff = {}

--- (availability: server & client)
--- @param index integer
--- @param destroyImmediately boolean
--- @param statusEffect boolean
--- @param priority integer
--- @param heroEffect boolean
--- @param overheadEffect boolean
--- @return nil
function CDOTA_Buff:AddParticle(index, destroyImmediately, statusEffect, priority, heroEffect, overheadEffect) end

--- (availability: server & client)
--- @param t userdata
--- @return nil
function CDOTA_Buff:CheckStateToTable(t) end

--- Decrease this modifier's stack count by 1.
--- 
--- (availability: server & client)
--- @return nil
function CDOTA_Buff:DecrementStackCount() end

--- Run all associated destroy functions, then remove the modifier.
--- 
--- (availability: server & client)
--- @return nil
function CDOTA_Buff:Destroy() end

--- (availability: server & client)
--- @return boolean
function CDOTA_Buff:DestroyOnExpire() end

--- Run all associated refresh functions on this modifier as if it was re-applied.
--- 
--- (availability: server & client)
--- @return nil
function CDOTA_Buff:ForceRefresh() end

--- Get the ability that generated the modifier.
--- 
--- (availability: server & client)
--- @return CDOTABaseAbility | nil
function CDOTA_Buff:GetAbility() end

--- Returns aura stickiness (default 0.5).
--- 
--- (availability: server & client)
--- @return number
function CDOTA_Buff:GetAuraDuration() end

--- Returns the owner of the aura modifier, that applied this modifier. Always `nil` on the client.
--- 
--- (availability: server & client)
--- @return CDOTA_BaseNPC | nil
function CDOTA_Buff:GetAuraOwner() end

--- Get the owner of the ability responsible for the modifier.
--- 
--- (availability: server & client)
--- @return CDOTA_BaseNPC | nil
function CDOTA_Buff:GetCaster() end

--- (availability: server & client)
--- @return string
function CDOTA_Buff:GetClass() end

--- (availability: server & client)
--- @return number
function CDOTA_Buff:GetCreationTime() end

--- (availability: server & client)
--- @return number
function CDOTA_Buff:GetDieTime() end

--- (availability: server & client)
--- @return number
function CDOTA_Buff:GetDuration() end

--- (availability: server & client)
--- @return number
function CDOTA_Buff:GetElapsedTime() end

--- (availability: server & client)
--- @return number
function CDOTA_Buff:GetLastAppliedTime() end

--- (availability: server & client)
--- @return string
function CDOTA_Buff:GetName() end

--- Get the unit the modifier is parented to.
--- 
--- (availability: server & client)
--- @return CDOTA_BaseNPC
function CDOTA_Buff:GetParent() end

--- (availability: server & client)
--- @return number
function CDOTA_Buff:GetRemainingTime() end

--- (availability: server & client)
--- @return integer
function CDOTA_Buff:GetSerialNumber() end

--- (availability: server & client)
--- @return integer
function CDOTA_Buff:GetStackCount() end

--- (availability: server & client)
--- @param fn modifierfunction
--- @return boolean
function CDOTA_Buff:HasFunction(fn) end

--- Increase this modifier's stack count by 1.
--- 
--- (availability: server & client)
--- @return nil
function CDOTA_Buff:IncrementStackCount() end

--- (availability: server & client)
--- @return boolean
function CDOTA_Buff:IsDebuff() end

--- (availability: server & client)
--- @return boolean
function CDOTA_Buff:IsHexDebuff() end

--- (availability: server & client)
--- @return boolean
function CDOTA_Buff:IsStunDebuff() end

--- (availability: server)
--- @return nil
function CDOTA_Buff:SendBuffRefreshToClients() end

--- (availability: server & client)
--- @param duration number
--- @param informClient boolean
--- @return nil
function CDOTA_Buff:SetDuration(duration, informClient) end

--- (availability: server & client)
--- @param offset number
--- @return boolean
function CDOTA_Buff:SetOverheadEffectOffset(offset) end

--- (availability: server & client)
--- @param count integer
--- @return nil
function CDOTA_Buff:SetStackCount(count) end

--- Start this modifier's think function (OnIntervalThink) with the given interval (float).  To stop, call with -1.
--- 
--- (availability: server & client)
--- @param interval number
--- @return nil
function CDOTA_Buff:StartIntervalThink(interval) end


--- @class CDOTA_CustomUIManager
CustomUI = {}

--- Create a new custom UI HUD element for the specified player(s).
--- 
--- (availability: server)
--- @param playerId PlayerID
--- @param elementId string
--- @param layoutFileName string
--- @param dialogVariables userdata
--- @return nil
function CustomUI:DynamicHud_Create(playerId, elementId, layoutFileName, dialogVariables) end

--- Destroy a custom hud element.
--- 
--- (availability: server)
--- @param playerId PlayerID
--- @param elementId string
--- @return nil
function CustomUI:DynamicHud_Destroy(playerId, elementId) end

--- Add or modify dialog variables for an existing custom hud element.
--- 
--- (availability: server)
--- @param playerId PlayerID
--- @param elementId string
--- @param dialogVariables userdata
--- @return nil
function CustomUI:DynamicHud_SetDialogVariables(playerId, elementId, dialogVariables) end

--- Toggle the visibility of an existing custom hud element.
--- 
--- (availability: server)
--- @param playerId PlayerID
--- @param elementId string
--- @param visible boolean
--- @return nil
function CustomUI:DynamicHud_SetVisible(playerId, elementId, visible) end


--- @class CDOTA_Item : CDOTABaseAbility
CDOTA_Item = {}

--- (availability: server)
--- @return boolean
function CDOTA_Item:CanBeUsedOutOfInventory() end

--- (availability: client)
--- @return boolean
function CDOTA_Item:CanOnlyPlayerHeroPickup() end

--- Get the container for this item.
--- 
--- (availability: server)
--- @return CDOTA_Item_Physical | nil
function CDOTA_Item:GetContainer() end

--- (availability: server)
--- @return integer
function CDOTA_Item:GetCost() end

--- Get the number of charges this item currently has.
--- 
--- (availability: server & client)
--- @return integer
function CDOTA_Item:GetCurrentCharges() end

--- Get the initial number of charges this item has.
--- 
--- (availability: server & client)
--- @return integer
function CDOTA_Item:GetInitialCharges() end

--- (availability: server & client)
--- @return -1 | DOTAScriptInventorySlot_t
function CDOTA_Item:GetItemSlot() end

--- Gets whether item is unequipped or ready.
--- 
--- (availability: server)
--- @return integer
function CDOTA_Item:GetItemState() end

--- Get the parent for this item.
--- 
--- (availability: server)
--- @return userdata
function CDOTA_Item:GetParent() end

--- Get the purchaser for this item.
--- 
--- (availability: server)
--- @return CDOTA_BaseNPC | nil
function CDOTA_Item:GetPurchaser() end

--- Get the purchase time of this item.
--- 
--- (availability: server)
--- @return number
function CDOTA_Item:GetPurchaseTime() end

--- Get the number of secondary charges this item currently has.
--- 
--- (availability: server & client)
--- @return integer
function CDOTA_Item:GetSecondaryCharges() end

--- (availability: server & client)
--- @return EShareAbility
function CDOTA_Item:GetShareability() end

--- Get the number of valueless charges this item currently has.
--- 
--- (availability: server)
--- @return integer
function CDOTA_Item:GetValuelessCharges() end

--- (availability: server & client)
--- @return boolean
function CDOTA_Item:IsAlertableItem() end

--- (availability: server & client)
--- @return boolean
function CDOTA_Item:IsCastOnPickup() end

--- (availability: server)
--- @return boolean
function CDOTA_Item:IsCombinable() end

--- (availability: server)
--- @return boolean
function CDOTA_Item:IsCombineLocked() end

--- (availability: server & client)
--- @return boolean
function CDOTA_Item:IsDisassemblable() end

--- (availability: server & client)
--- @return boolean
function CDOTA_Item:IsDroppable() end

--- (availability: server & client)
--- @return boolean
function CDOTA_Item:IsInBackpack() end

--- (availability: server & client)
--- @return boolean
function CDOTA_Item:IsItem() end

--- (availability: server & client)
--- @return boolean
function CDOTA_Item:IsKillable() end

--- (availability: server & client)
--- @return boolean
function CDOTA_Item:IsMuted() end

--- (availability: server)
--- @return boolean
function CDOTA_Item:IsNeutralDrop() end

--- Is this a permanent item?
--- 
--- (availability: server & client)
--- @return boolean
function CDOTA_Item:IsPermanent() end

--- (availability: server & client)
--- @return boolean
function CDOTA_Item:IsPurchasable() end

--- (availability: server & client)
--- @return boolean
function CDOTA_Item:IsRecipe() end

--- (availability: server & client)
--- @return boolean
function CDOTA_Item:IsRecipeGenerated() end

--- (availability: server & client)
--- @return boolean
function CDOTA_Item:IsSellable() end

--- (availability: server & client)
--- @return boolean
function CDOTA_Item:IsStackable() end

--- (availability: server)
--- @param autoUse boolean
--- @param height number
--- @param duration number
--- @param endPoint Vector
--- @param teleportOwner CDOTA_BaseNPC_Hero | nil
--- @return nil
function CDOTA_Item:LaunchLoot(autoUse, height, duration, endPoint, teleportOwner) end

--- (availability: server)
--- @param autoUse boolean
--- @param initialHeight number
--- @param launchHeight number
--- @param duration number
--- @param endPoint Vector
--- @return nil
function CDOTA_Item:LaunchLootInitialHeight(autoUse, initialHeight, launchHeight, duration, endPoint) end

--- (availability: server)
--- @param autoUse boolean
--- @param requiredHeight number
--- @param height number
--- @param duration number
--- @param endPoint Vector
--- @return nil
function CDOTA_Item:LaunchLootRequiredHeight(autoUse, requiredHeight, height, duration, endPoint) end

--- Modifies the number of valueless charges on this item.
--- 
--- (availability: server)
--- @param charges integer
--- @return nil
function CDOTA_Item:ModifyNumValuelessCharges(charges) end

--- (availability: server)
--- @return nil
function CDOTA_Item:OnEquip() end

--- (availability: server)
--- @return nil
function CDOTA_Item:OnUnequip() end

--- (availability: server & client)
--- @return boolean
function CDOTA_Item:RequiresCharges() end

--- (availability: server)
--- @param value boolean
--- @return nil
function CDOTA_Item:SetCanBeUsedOutOfInventory(value) end

--- (availability: server)
--- @param castOnPickUp boolean
--- @return nil
function CDOTA_Item:SetCastOnPickup(castOnPickUp) end

--- (availability: server)
--- @param combineLocked boolean
--- @return nil
function CDOTA_Item:SetCombineLocked(combineLocked) end

--- Set the number of charges on this item.
--- 
--- (availability: server)
--- @param charges integer
--- @return nil
function CDOTA_Item:SetCurrentCharges(charges) end

--- (availability: server)
--- @param droppable boolean
--- @return nil
function CDOTA_Item:SetDroppable(droppable) end

--- Sets whether item is unequipped or ready.
--- 
--- (availability: server)
--- @param state integer
--- @return nil
function CDOTA_Item:SetItemState(state) end

--- (availability: server)
--- @param onlyPlayerHero boolean
--- @return nil
function CDOTA_Item:SetOnlyPlayerHeroPickup(onlyPlayerHero) end

--- Set the purchaser of record for this item.
--- 
--- (availability: server)
--- @param purchaser CDOTA_BaseNPC | nil
--- @return nil
function CDOTA_Item:SetPurchaser(purchaser) end

--- Set the purchase time of this item.
--- 
--- (availability: server)
--- @param time number
--- @return nil
function CDOTA_Item:SetPurchaseTime(time) end

--- Set the number of secondary charges on this item.
--- 
--- (availability: server)
--- @param charges integer
--- @return nil
function CDOTA_Item:SetSecondaryCharges(charges) end

--- (availability: server)
--- @param sellable boolean
--- @return nil
function CDOTA_Item:SetSellable(sellable) end

--- (availability: server)
--- @param shareability EShareAbility
--- @return nil
function CDOTA_Item:SetShareability(shareability) end

--- (availability: server)
--- @param stacksWithOtherOwners boolean
--- @return nil
function CDOTA_Item:SetStacksWithOtherOwners(stacksWithOtherOwners) end

--- (availability: server)
--- @return nil
function CDOTA_Item:SpendCharge() end

--- (availability: server)
--- @return boolean
function CDOTA_Item:StacksWithOtherOwners() end

--- Think this item.
--- 
--- (availability: server)
--- @return nil
function CDOTA_Item:Think() end


--- @class CDOTA_Item_BagOfGold : CDOTA_Item
CDOTA_Item_BagOfGold = {}

--- Set the life time of this item.
--- 
--- (availability: server)
--- @param time number
--- @return nil
function CDOTA_Item_BagOfGold:SetLifeTime(time) end


--- @class CDOTA_Item_DataDriven : CDOTA_Item
CDOTA_Item_DataDriven = {}

--- Applies a data driven modifier to the target.
--- 
--- (availability: server)
--- @param caster CDOTA_BaseNPC
--- @param target CDOTA_BaseNPC
--- @param modifierName string
--- @param modifierTable table | nil
--- @return nil
function CDOTA_Item_DataDriven:ApplyDataDrivenModifier(caster, target, modifierName, modifierTable) end

--- Applies a data driven thinker at the location.
--- 
--- (availability: server)
--- @param caster CDOTA_BaseNPC
--- @param location Vector
--- @param modifierName string
--- @param modifierTable table | nil
--- @return CDOTA_Buff
function CDOTA_Item_DataDriven:ApplyDataDrivenThinker(caster, location, modifierName, modifierTable) end


--- @class CDOTA_Item_EmptyBottle : CDOTA_Item
CDOTA_Item_EmptyBottle = {}

--- Clear the stored rune.
--- 
--- (availability: server)
--- @return nil
function CDOTA_Item_EmptyBottle:ClearStoredRune() end

--- Place a rune in the bottle.
--- 
--- (availability: server)
--- @param runeType integer
--- @return boolean
function CDOTA_Item_EmptyBottle:OnRune(runeType) end

--- Set the stored rune.
--- 
--- (availability: server)
--- @param runeType integer
--- @return nil
function CDOTA_Item_EmptyBottle:SetStoredRune(runeType) end


--- @class CDOTA_Item_Lua : CDOTA_Item
CDOTA_Item_Lua = {}

--- Returns true if this item can be picked up by the target unit.
--- 
--- (availability: server)
--- @param unit CDOTA_BaseNPC Unit trying to pick up the item.
--- @return boolean
function CDOTA_Item_Lua:CanUnitPickUp(unit) end

--- Determine whether an issued command with no target is valid.
--- 
--- (availability: server & client)
--- @return UnitFilterResult
function CDOTA_Item_Lua:CastFilterResult() end

--- Determine whether an issued command on a location is valid.
--- 
--- (availability: server & client)
--- @param location Vector
--- @return UnitFilterResult
function CDOTA_Item_Lua:CastFilterResultLocation(location) end

--- Determine whether an issued command on a target is valid.
--- 
--- (availability: server & client)
--- @param target CDOTA_BaseNPC
--- @return UnitFilterResult
function CDOTA_Item_Lua:CastFilterResultTarget(target) end

--- Allows code overriding of the item texture shown in the HUD.
--- 
--- (availability: client)
--- @return string
function CDOTA_Item_Lua:GetAbilityTextureName() end

--- Controls the size of the AOE casting cursor.
--- 
--- (availability: client)
--- @return number
function CDOTA_Item_Lua:GetAOERadius() end

--- Returns abilities that are stolen simultaneously, or otherwise related in functionality.
--- 
--- (availability: server)
--- @return string
function CDOTA_Item_Lua:GetAssociatedPrimaryAbilities() end

--- Returns other abilities that are stolen simultaneously, or otherwise related in functionality.  Generally hidden abilities.
--- 
--- (availability: server)
--- @return string
function CDOTA_Item_Lua:GetAssociatedSecondaryAbilities() end

--- Return cast behavior type of this ability.
--- 
--- (availability: server & client)
--- @return DOTA_ABILITY_BEHAVIOR
function CDOTA_Item_Lua:GetBehavior() end

--- Return cast range of this ability.
--- 
--- (availability: server & client)
--- @param location Vector
--- @param target CDOTA_BaseNPC | nil
--- @return integer
function CDOTA_Item_Lua:GetCastRange(location, target) end

--- Return health cost per second of channeling at the given level (-1 is current).
--- 
--- (availability: server & client)
--- @param level integer
--- @return integer
function CDOTA_Item_Lua:GetChannelledHealthCostPerSecond(level) end

--- Return mana cost at the given level per second while channeling (-1 is current).
--- 
--- (availability: server & client)
--- @param level integer
--- @return integer
function CDOTA_Item_Lua:GetChannelledManaCostPerSecond(level) end

--- Return the channel start time of this ability.
--- 
--- (availability: server & client)
--- @return number
function CDOTA_Item_Lua:GetChannelStartTime() end

--- Return the channel time of this ability.
--- 
--- (availability: server & client)
--- @return number
function CDOTA_Item_Lua:GetChannelTime() end

--- Return who hears speech when this spell is cast.
--- 
--- (availability: server)
--- @return integer
function CDOTA_Item_Lua:GetConceptRecipientType() end

--- Return cooldown of this ability.
--- 
--- (availability: server & client)
--- @param level integer
--- @return number
function CDOTA_Item_Lua:GetCooldown(level) end

--- Return the error string of a failed command with no target.
--- 
--- (availability: server & client)
--- @return string
function CDOTA_Item_Lua:GetCustomCastError() end

--- Return the error string of a failed command on a location.
--- 
--- (availability: server & client)
--- @param location Vector
--- @return string
function CDOTA_Item_Lua:GetCustomCastErrorLocation(location) end

--- Return the error string of a failed command on a target.
--- 
--- (availability: server & client)
--- @param target CDOTA_BaseNPC
--- @return string
function CDOTA_Item_Lua:GetCustomCastErrorTarget(target) end

--- (DOTA_INVALID_ORDERS nReason) Return the error string of a failed order.
--- 
--- (availability: server & client)
--- @param reason integer
--- @return string
function CDOTA_Item_Lua:GetCustomHudErrorMessage(reason) end

--- Return cast range of this ability, taking modifiers into account.
--- 
--- (availability: server & client)
--- @param location Vector
--- @param target userdata
--- @return integer
function CDOTA_Item_Lua:GetEffectiveCastRange(location, target) end

--- Return gold cost at the given level (-1 is current).
--- 
--- (availability: server & client)
--- @param level integer
--- @return integer
function CDOTA_Item_Lua:GetGoldCost(level) end

--- Return health cost at the given level (-1 is current).
--- 
--- (availability: server & client)
--- @param level integer
--- @return integer
function CDOTA_Item_Lua:GetHealthCost(level) end

--- Returns the name of the modifier applied passively by this ability.
--- 
--- (availability: server)
--- @return string
function CDOTA_Item_Lua:GetIntrinsicModifierName() end

--- Return mana cost at the given level (-1 is current).
--- 
--- (availability: server & client)
--- @param level integer
--- @return integer
function CDOTA_Item_Lua:GetManaCost(level) end

--- Return the animation rate of the cast animation.
--- 
--- (availability: server)
--- @return number
function CDOTA_Item_Lua:GetPlaybackRateOverride() end

--- Returns true if this ability can be used when not on the action panel.
--- 
--- (availability: server)
--- @return boolean
function CDOTA_Item_Lua:IsHiddenAbilityCastable() end

--- Returns true if this ability is hidden when stolen by Spell Steal.
--- 
--- (availability: server)
--- @return boolean
function CDOTA_Item_Lua:IsHiddenWhenStolen() end

--- Returns whether this item is muted or not.
--- 
--- (availability: server & client)
--- @return boolean
function CDOTA_Item_Lua:IsMuted() end

--- Returns true if this ability is refreshed by Refresher Orb.
--- 
--- (availability: server)
--- @return boolean
function CDOTA_Item_Lua:IsRefreshable() end

--- Returns true if this ability can be stolen by Spell Steal.
--- 
--- (availability: server)
--- @return boolean
function CDOTA_Item_Lua:IsStealable() end

--- Cast time did not complete successfully.
--- 
--- (availability: server)
--- @return nil
function CDOTA_Item_Lua:OnAbilityPhaseInterrupted() end

--- Cast time begins (return true for successful cast).
--- 
--- (availability: server)
--- @return boolean
function CDOTA_Item_Lua:OnAbilityPhaseStart() end

--- Channel finished.
--- 
--- (availability: server)
--- @param interrupted boolean
--- @return nil
function CDOTA_Item_Lua:OnChannelFinish(interrupted) end

--- Channeling is taking place.
--- 
--- (availability: server)
--- @param interval number
--- @return nil
function CDOTA_Item_Lua:OnChannelThink(interval) end

--- Runs when item's charge count changes.
--- 
--- (availability: server)
--- @return nil
function CDOTA_Item_Lua:OnChargeCountChanged() end

--- Caster (hero only) gained a level, skilled an ability, or received a new stat bonus.
--- 
--- (availability: server)
--- @return nil
function CDOTA_Item_Lua:OnHeroCalculateStatBonus() end

--- A hero has died in the vicinity (ie Urn), takes table of params.
--- 
--- (availability: server)
--- @param unit CDOTA_BaseNPC
--- @param attacker CDOTA_BaseNPC
--- @param event table
--- @return nil
function CDOTA_Item_Lua:OnHeroDiedNearby(unit, attacker, event) end

--- Caster gained a level.
--- 
--- (availability: server)
--- @return nil
function CDOTA_Item_Lua:OnHeroLevelUp() end

--- Caster inventory changed.
--- 
--- (availability: server)
--- @return nil
function CDOTA_Item_Lua:OnInventoryContentsChanged() end

--- Caster equipped item.
--- 
--- (availability: server)
--- @param item CDOTA_Item
--- @return nil
function CDOTA_Item_Lua:OnItemEquipped(item) end

--- Caster died.
--- 
--- (availability: server)
--- @return nil
function CDOTA_Item_Lua:OnOwnerDied() end

--- Caster respawned or spawned for the first time.
--- 
--- (availability: server)
--- @return nil
function CDOTA_Item_Lua:OnOwnerSpawned() end

--- Projectile has collided with a given target or reached its destination. If 'true` is returned, projectile would be destroyed.
--- 
--- (availability: server)
--- @param target CDOTA_BaseNPC | nil
--- @param location Vector
--- @return boolean | nil
function CDOTA_Item_Lua:OnProjectileHit(target, location) end

--- Projectile is actively moving.
--- 
--- (availability: server)
--- @param location Vector
--- @return nil
function CDOTA_Item_Lua:OnProjectileThink(location) end

--- Cast time finished, spell effects begin.
--- 
--- (availability: server)
--- @return nil
function CDOTA_Item_Lua:OnSpellStart() end

--- Special behavior when stolen by Spell Steal.
--- 
--- (availability: server)
--- @param sourceAbility CDOTABaseAbility
--- @return nil
function CDOTA_Item_Lua:OnStolen(sourceAbility) end

--- Ability is toggled on/off.
--- 
--- (availability: server)
--- @return nil
function CDOTA_Item_Lua:OnToggle() end

--- Special behavior when lost by Spell Steal.
--- 
--- (availability: server)
--- @return nil
function CDOTA_Item_Lua:OnUnStolen() end

--- Ability gained a level.
--- 
--- (availability: server)
--- @return nil
function CDOTA_Item_Lua:OnUpgrade() end

--- Returns true if this ability will generate magic stick charges for nearby enemies.
--- 
--- (availability: server)
--- @return boolean
function CDOTA_Item_Lua:ProcsMagicStick() end

--- Return the type of speech used.
--- 
--- (availability: server)
--- @return integer
function CDOTA_Item_Lua:SpeakTrigger() end

--- (availability: server)
--- @param context CScriptPrecacheContext
--- @return nil
function CDOTA_Item_Lua:Precache(context) end

--- Called when ability entity is created, after Init.
--- 
--- (availability: server & client)
--- @return nil
function CDOTA_Item_Lua:Spawn() end


--- @class CDOTA_Item_Physical : CBaseAnimatingActivity
CDOTA_Item_Physical = {}

--- Returned the contained item.
--- 
--- (availability: server)
--- @return CDOTA_Item
function CDOTA_Item_Physical:GetContainedItem() end

--- Returns the game time when this item was created in the world.
--- 
--- (availability: server)
--- @return number
function CDOTA_Item_Physical:GetCreationTime() end

--- Set the contained item.
--- 
--- (availability: server)
--- @param item CDOTA_Item
--- @return nil
function CDOTA_Item_Physical:SetContainedItem(item) end


--- @class CDOTA_ItemSpawner : CBaseEntity
CDOTA_ItemSpawner = {}

--- Returns the item name.
--- 
--- (availability: server)
--- @return string
function CDOTA_ItemSpawner:GetItemName() end


--- @class CDOTA_MapTree : CBaseEntity
CDOTA_MapTree = {}

--- Cuts down this tree.
--- 
--- (availability: server)
--- @param teamNumberKnownTo integer
--- @return nil
function CDOTA_MapTree:CutDown(teamNumberKnownTo) end

--- Cuts down this tree.
--- 
--- (availability: server)
--- @param regrowAfter number
--- @param teamNumberKnownTo integer
--- @return nil
function CDOTA_MapTree:CutDownRegrowAfter(regrowAfter, teamNumberKnownTo) end

--- Grows back the tree if it was cut down.
--- 
--- (availability: server)
--- @return nil
function CDOTA_MapTree:GrowBack() end

--- Returns true if the tree is standing, false if it has been cut down.
--- 
--- (availability: server)
--- @return boolean
function CDOTA_MapTree:IsStanding() end


--- @class CDOTA_Modifier_Lua : CDOTA_Buff
CDOTA_Modifier_Lua = {}

--- True/false if this modifier is active on illusions.
--- 
--- (availability: server & client)
--- @return boolean
function CDOTA_Modifier_Lua:AllowIllusionDuplicate() end

--- (availability: server & client)
--- @return boolean
function CDOTA_Modifier_Lua:CanParentBeAutoAttacked() end

--- True/false if this buff is removed when the duration expires.
--- 
--- (availability: server & client)
--- @return boolean
function CDOTA_Modifier_Lua:DestroyOnExpire() end

--- Return the types of attributes applied to this modifier.
--- 
--- (availability: server & client)
--- @return DOTAModifierAttribute_t
function CDOTA_Modifier_Lua:GetAttributes() end

--- Returns aura stickiness.
--- 
--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetAuraDuration() end

--- Return true/false if this entity should receive the aura under specific conditions.
--- 
--- (availability: server & client)
--- @param entity CDOTA_BaseNPC
--- @return boolean
function CDOTA_Modifier_Lua:GetAuraEntityReject(entity) end

--- Return the range around the parent this aura tries to apply its buff.
--- 
--- (availability: server & client)
--- @return integer
function CDOTA_Modifier_Lua:GetAuraRadius() end

--- Return the unit flags this aura respects when placing buffs.
--- 
--- (availability: server & client)
--- @return DOTA_UNIT_TARGET_FLAGS
function CDOTA_Modifier_Lua:GetAuraSearchFlags() end

--- Return the teams this aura applies its buff to.
--- 
--- (availability: server & client)
--- @return DOTA_UNIT_TARGET_TEAM
function CDOTA_Modifier_Lua:GetAuraSearchTeam() end

--- Return the unit classifications this aura applies its buff to.
--- 
--- (availability: server & client)
--- @return DOTA_UNIT_TARGET_TYPE
function CDOTA_Modifier_Lua:GetAuraSearchType() end

--- A Modifier that listens to MODIFIER_PROPERTY_PREATTACK_CRITICALSTRIKE has to have a GetCritDamage implementation so we can know when to evaluate it. Value should be in 'times the original value format' e.g: 1.5 not 150.
--- 
--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetCritDamage() end

--- Return the attach type of the particle system from GetEffectName.
--- 
--- (availability: server & client)
--- @return ParticleAttachment_t
function CDOTA_Modifier_Lua:GetEffectAttachType() end

--- Return the name of the particle system that is created while this modifier is active.
--- 
--- (availability: server & client)
--- @return string
function CDOTA_Modifier_Lua:GetEffectName() end

--- Return the name of the hero effect particle system that is created while this modifier is active.
--- 
--- (availability: server & client)
--- @return string
function CDOTA_Modifier_Lua:GetHeroEffectName() end

--- The name of the secondary modifier that will be applied by this modifier (if it is an aura).
--- 
--- (availability: server & client)
--- @return string
function CDOTA_Modifier_Lua:GetModifierAura() end

--- Return the priority order this modifier will be applied over others.
--- 
--- (availability: server & client)
--- @return modifierpriority
function CDOTA_Modifier_Lua:GetPriority() end

--- Return the name of the status effect particle system that is created while this modifier is active.
--- 
--- (availability: server & client)
--- @return string
function CDOTA_Modifier_Lua:GetStatusEffectName() end

--- Return the name of the buff icon to be shown for this modifier.
--- 
--- (availability: server & client)
--- @return string
function CDOTA_Modifier_Lua:GetTexture() end

--- Relationship of this hero effect with those from other buffs (higher is more likely to be shown).
--- 
--- (availability: server & client)
--- @return modifierpriority
function CDOTA_Modifier_Lua:HeroEffectPriority() end

--- True/false if this modifier is an aura.
--- 
--- (availability: server & client)
--- @return boolean
function CDOTA_Modifier_Lua:IsAura() end

--- True/false if this aura provides buffs when the parent is dead.
--- 
--- (availability: server & client)
--- @return boolean
function CDOTA_Modifier_Lua:IsAuraActiveOnDeath() end

--- True/false if this modifier should be displayed as a debuff.
--- 
--- (availability: server & client)
--- @return boolean
function CDOTA_Modifier_Lua:IsDebuff() end

--- True/false if this modifier should be displayed on the buff bar.
--- 
--- (availability: server & client)
--- @return boolean
function CDOTA_Modifier_Lua:IsHidden() end

--- (availability: server & client)
--- @return boolean
function CDOTA_Modifier_Lua:IsPermanent() end

--- True/false if this modifier can be purged.
--- 
--- (availability: server & client)
--- @return boolean
function CDOTA_Modifier_Lua:IsPurgable() end

--- True/false if this modifier can be purged by strong dispels.
--- 
--- (availability: server & client)
--- @return boolean
function CDOTA_Modifier_Lua:IsPurgeException() end

--- True/false if this modifier is considered a stun for purge reasons.
--- 
--- (availability: server & client)
--- @return boolean
function CDOTA_Modifier_Lua:IsStunDebuff() end

--- Runs when the modifier is created.
--- 
--- (availability: server & client)
--- @param params table
--- @return nil
function CDOTA_Modifier_Lua:OnCreated(params) end

--- Runs when the modifier is destroyed (after unit loses modifier).
--- 
--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:OnDestroy() end

--- Runs when the think interval occurs.
--- 
--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:OnIntervalThink() end

--- Runs when the modifier is refreshed.
--- 
--- (availability: server & client)
--- @param params table
--- @return nil
function CDOTA_Modifier_Lua:OnRefresh(params) end

--- Runs when the modifier is destroyed (before unit loses modifier).
--- 
--- (availability: server & client)
--- @param death boolean
--- @return nil
function CDOTA_Modifier_Lua:OnRemoved(death) end

--- Runs when stack count changes (param is old count).
--- 
--- (availability: server & client)
--- @param stackCount integer
--- @return nil
function CDOTA_Modifier_Lua:OnStackCountChanged(stackCount) end

--- True/false if this modifier is removed when the parent dies.
--- 
--- (availability: server & client)
--- @return boolean
function CDOTA_Modifier_Lua:RemoveOnDeath() end

--- (availability: server & client)
--- @param hasCustomData boolean
--- @return nil
function CDOTA_Modifier_Lua:SetHasCustomTransmitterData(hasCustomData) end

--- Apply the overhead offset to the attached effect.
--- 
--- (availability: server & client)
--- @return boolean
function CDOTA_Modifier_Lua:ShouldUseOverheadOffset() end

--- Relationship of this status effect with those from other buffs (higher is more likely to be shown).
--- 
--- (availability: server & client)
--- @return modifierpriority
function CDOTA_Modifier_Lua:StatusEffectPriority() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:BotAttackScoreBonus() end

--- Return a map of enabled/disabled states.
--- 
--- (availability: server & client)
--- @return { [modifierstate]: boolean }
function CDOTA_Modifier_Lua:CheckState() end

--- Return a list of modifier functions this modifier implements.
--- 
--- (availability: server & client)
--- @return modifierfunction[]
function CDOTA_Modifier_Lua:DeclareFunctions() end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return 0 | 1
function CDOTA_Modifier_Lua:GetAbsoluteNoDamageMagical(event) end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return 0 | 1
function CDOTA_Modifier_Lua:GetAbsoluteNoDamagePhysical(event) end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return 0 | 1
function CDOTA_Modifier_Lua:GetAbsoluteNoDamagePure(event) end

--- (availability: server & client)
--- @param event ModifierAbilityEvent
--- @return 0 | 1
function CDOTA_Modifier_Lua:GetAbsorbSpell(event) end

--- (availability: server & client)
--- @return string
function CDOTA_Modifier_Lua:GetActivityTranslationModifiers() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetAllowEtherealAttack() end

--- (availability: server & client)
--- @return 0 | 1
function CDOTA_Modifier_Lua:GetAlwaysAllowAttack() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetAlwaysAutoAttackWhileHoldPosition() end

--- (availability: server & client)
--- @return string
function CDOTA_Modifier_Lua:GetAttackSound() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetBonusDayVision() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetBonusDayVisionPercentage() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetBonusNightVision() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetBonusNightVisionUnique() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetBonusVisionPercentage() end

--- (availability: server & client)
--- @return 0 | 1
function CDOTA_Modifier_Lua:GetDisableAutoAttack() end

--- (availability: server & client)
--- @return 0 | 1
function CDOTA_Modifier_Lua:GetDisableHealing() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetFixedDayVision() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetFixedNightVision() end

--- (availability: server & client)
--- @return 0 | 1
function CDOTA_Modifier_Lua:GetForceDrawOnMinimap() end

--- (availability: server & client)
--- @return 0 | 1
function CDOTA_Modifier_Lua:GetIsIllusion() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetMinHealth() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierAbilityLayout() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierAoEBonusConstant() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierAoEBonusPercentage() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierAttackPointConstant() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierAttackRangeBonus() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierAttackRangeBonusPercentage() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierAttackRangeBonusUnique() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierAttackRangeOverride() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierAttackSpeed_Limit() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierAttackSpeedBaseOverride() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierAttackSpeedBonus_Constant() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierAttackSpeedPercentage() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierAttackSpeedReductionPercentage() end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierAvoidDamage(event) end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierAvoidDamageAfterReductions(event) end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return 0 | 1
function CDOTA_Modifier_Lua:GetModifierAvoidSpell(event) end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierBaseAttack_BonusDamage() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierBaseAttackTimeConstant() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierBaseAttackTimeConstant_Adjust() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierBaseAttackTimePercentage() end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierBaseDamageOutgoing_Percentage(event) end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierBaseDamageOutgoing_PercentageUnique(event) end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierBaseRegen() end

--- (availability: server & client)
--- @return 0 | 1
function CDOTA_Modifier_Lua:GetModifierBecomeUniversal() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierBonusDamageOutgoing_Percentage() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierBonusStats_Agility() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierBonusStats_Agility_Percentage() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierBonusStats_Intellect() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierBonusStats_Intellect_Percentage() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierBonusStats_Strength() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierBonusStats_Strength_Percentage() end

--- (availability: server & client)
--- @return 0 | 1
function CDOTA_Modifier_Lua:GetModifierCanAttackTrees() end

--- (availability: server & client)
--- @param event ModifierAbilityEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierCastRangeBonus(event) end

--- (availability: server & client)
--- @param event ModifierAbilityEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierCastRangeBonusPercentage(event) end

--- (availability: server & client)
--- @param event ModifierAbilityEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierCastRangeBonusStacking(event) end

--- (availability: server & client)
--- @param event ModifierAbilityEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierCastRangeBonusTarget(event) end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierChangeAbilityValue() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierConstantDeathGoldCost() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierConstantHealthRegen() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierConstantManaRegen() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierConstantManaRegenUnique() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierConstantRespawnTime() end

--- (availability: server & client)
--- @param event ModifierAbilityEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierCooldownReduction_Constant(event) end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierDamageOutgoing_Percentage(event) end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierDamageOutgoing_Percentage_Illusion(event) end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierDamageOutgoing_Percentage_Illusion_Amplify() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierDamageOutgoing_PercentageMultiplicative() end

--- (availability: server & client)
--- @return 0 | 1
function CDOTA_Modifier_Lua:GetModifierDisableTurning() end

--- (availability: server & client)
--- @return 0 | 1
function CDOTA_Modifier_Lua:GetModifierDodgeProjectile() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierDoNotSinkAfterDeath() end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierEvasion_Constant(event) end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierExtraHealthBonus() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierExtraHealthPercentage() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierExtraManaBonus() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierExtraManaBonusPercentage() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierExtraManaPercentage() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierExtraStrengthBonus() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierFixedAttackRate() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierForceMaxHealth() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierHealAmplify_PercentageSource() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierHealAmplify_PercentageTarget() end

--- Return value is a count of pips.
--- 
--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierHealthBarPips(event) end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierHealthBonus() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierHealthcostReduction_Constant() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierHealthRegenPercentage() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierHealthRegenPercentageUnique() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierHPRegen_CanBeNegative() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierHPRegenAmplify_Percentage() end

--- (availability: server & client)
--- @return 0 | 1
function CDOTA_Modifier_Lua:GetModifierIgnoreCastAngle() end

--- (availability: server & client)
--- @return 0 | 1
function CDOTA_Modifier_Lua:GetModifierIgnoreCooldown() end

--- (availability: server & client)
--- @return 0 | 1
function CDOTA_Modifier_Lua:GetModifierIgnoreMovespeedLimit() end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierIgnorePhysicalArmor(event) end

--- (availability: server & client)
--- @return 0 | 1
function CDOTA_Modifier_Lua:GetModifierIllusionLabel() end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierIncomingDamage_Percentage(event) end

--- This property controls 'universal' shield, if defined both on client and server. Return value on client should be current shield health, as a positive integer, on server - amount of damage blocked.
--- 
--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierIncomingDamageConstant(event) end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierIncomingPhysicalDamage_Percentage(event) end

--- This property controls 'physical' shield, if defined both on client and server. Return value on client should be current shield health, as a positive integer, on server - amount of damage blocked.
--- 
--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierIncomingPhysicalDamageConstant(event) end

--- This property controls 'spell' shield, if defined both on client and server. Return value on client should be current shield health, as a positive integer, on server - amount of damage blocked.
--- 
--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierIncomingSpellDamageConstant(event) end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierInvisibilityAttackBehaviorException() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierInvisibilityLevel() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierIsRatPack() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierKnockbackAmplification_Percentage() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierLifestealRegenAmplify_Percentage() end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierMagical_ConstantBlock(event) end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierMagicalResistanceBaseReduction() end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierMagicalResistanceBonus(event) end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierMagicalResistanceBonusIllusions() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierMagicalResistanceBonusUnique() end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierMagicalResistanceDecrepifyUnique(event) end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierMagicalResistanceDirectModification(event) end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierManaBonus() end

--- (availability: server & client)
--- @param event ModifierAbilityEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierManacostReduction_Constant(event) end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierManaDrainAmplify_Percentage() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierMaxAttackRange() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierMaxDebuffDuration() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierMinPhysicalArmor() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierMiss_Percentage() end

--- (availability: server & client)
--- @return string
function CDOTA_Modifier_Lua:GetModifierModelChange() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierModelScale() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierModelScaleAnimateTime() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierModelScaleConstant() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierModelScaleUseInOutEase() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierMoveSpeed_Absolute() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierMoveSpeed_AbsoluteMax() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierMoveSpeed_AbsoluteMin() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierMoveSpeed_Limit() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierMoveSpeedBonus_Constant() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierMoveSpeedBonus_Constant_Unique() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierMoveSpeedBonus_Constant_Unique_2() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierMoveSpeedBonus_Percentage() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierMoveSpeedBonus_Percentage_Unique() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierMoveSpeedBonus_Special_Boots() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierMoveSpeedBonus_Special_Boots_2() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierMoveSpeedOverride() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierMoveSpeedReductionPercentage() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierMPRegenAmplify_Percentage() end

--- Total amplify value is clamped to 0.
--- 
--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierMPRestoreAmplify_Percentage() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierNegativeEvasion_Constant() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierNoVisionOfAttacker() end

--- (availability: server & client)
--- @param event ModifierOverrideAbilitySpecialEvent
--- @return 0 | 1
function CDOTA_Modifier_Lua:GetModifierOverrideAbilitySpecial(event) end

--- (availability: server & client)
--- @param event ModifierOverrideAbilitySpecialEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierOverrideAbilitySpecialValue(event) end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierOverrideAttackDamage() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierPercentageAttackAnimTime() end

--- (availability: server & client)
--- @param event ModifierAbilityEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierPercentageCasttime(event) end

--- (availability: server & client)
--- @param event ModifierAbilityEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierPercentageCooldown(event) end

--- (availability: server & client)
--- @param event ModifierAbilityEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierPercentageCooldownOngoing(event) end

--- (availability: server & client)
--- @param event ModifierAbilityEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierPercentageCooldownStacking(event) end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierPercentageExpRateBoost() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierPercentageGoldRateBoost() end

--- (availability: server & client)
--- @param event ModifierAbilityEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierPercentageHealthcost(event) end

--- (availability: server & client)
--- @param event ModifierAbilityEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierPercentageHealthcostStacking(event) end

--- (availability: server & client)
--- @param event ModifierAbilityEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierPercentageManacost(event) end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierPercentageManacostStacking() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierPercentageRespawnTime() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierPersistentInvisibility() end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierPhysical_ConstantBlock(event) end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierPhysical_ConstantBlockSpecial() end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierPhysical_ConstantBlockUnavoidablePreArmor(event) end

--- Values above 100% are ignored.
--- 
--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierPhysicalArmorBase_Percentage() end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierPhysicalArmorBonus(event) end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierPhysicalArmorBonusPost() end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierPhysicalArmorBonusUnique(event) end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierPhysicalArmorBonusUniqueActive(event) end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierPhysicalArmorTotal_Percentage() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierPhysicalDamageOutgoing_Percentage() end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierPreAttack(event) end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierPreAttack_BonusDamage() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierPreAttack_BonusDamage_Proc() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierPreAttack_BonusDamage_Target() end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierPreAttack_BonusDamagePostCrit(event) end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierPreAttack_CriticalStrike(event) end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierPreAttack_DeadlyBlow() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierPreAttack_Target_CriticalStrike() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierPrereduceIncomingDamage_Mult() end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierProcAttack_BonusDamage_Magical(event) end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierProcAttack_BonusDamage_Magical_Target() end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierProcAttack_BonusDamage_Physical(event) end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierProcAttack_BonusDamage_Pure(event) end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierProcAttack_ConvertPhysicalToMagical() end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierProcAttack_Feedback(event) end

--- (availability: server & client)
--- @return string
function CDOTA_Modifier_Lua:GetModifierProjectileName() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierProjectileSpeed() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierProjectileSpeedBonus() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierProjectileSpeedBonusPercentage() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierPropetyFailAttack() end

--- (availability: server & client)
--- @return 0 | 1
function CDOTA_Modifier_Lua:GetModifierProvidesFOWVision() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierRadarCooldownReduction() end

--- Applies scepter when this property is active
--- 
--- (availability: server & client)
--- @return 0 | 1
function CDOTA_Modifier_Lua:GetModifierScepter() end

--- Applies shard when this property is active
--- 
--- (availability: server & client)
--- @return 0 | 1
function CDOTA_Modifier_Lua:GetModifierShard() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierSlowResistance() end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierSpellAmplify_Percentage(event) end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierSpellAmplify_PercentageCreep() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierSpellAmplify_PercentageUnique() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierSpellLifestealRegenAmplify_Percentage() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierSpellRedirectTarget() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierSpellsRequireHP() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierStackingRespawnTime() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierStatusResistance() end

--- (availability: server & client)
--- @param event ModifierUnitEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierStatusResistanceCaster(event) end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierStatusResistanceStacking() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierStrongIllusion() end

--- (availability: server & client)
--- @return 0 | 1
function CDOTA_Modifier_Lua:GetModifierSuperIllusion() end

--- (availability: server & client)
--- @return 0 | 1
function CDOTA_Modifier_Lua:GetModifierSuperIllusionWithUltimate() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierSuppressFullscreenDeathFX() end

--- (availability: server & client)
--- @return 0 | 1
function CDOTA_Modifier_Lua:GetModifierTempestDouble() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierTickGold_Multiplier() end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierTotal_ConstantBlock(event) end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return number
function CDOTA_Modifier_Lua:GetModifierTotalDamageOutgoing_Percentage(event) end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierTotalPercentageManaRegen() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierTurnRate_Override() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierTurnRate_Percentage() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetModifierTurnRateConstant() end

--- (availability: server & client)
--- @return 0 | 1
function CDOTA_Modifier_Lua:GetModifierUnitDisllowUpgrading() end

--- (availability: server & client)
--- @return 0 | 1
function CDOTA_Modifier_Lua:GetModifierUnitStatsNeedsRefresh() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetModifierXPDuringDeath() end

--- (availability: server & client)
--- @return GameActivity_t
function CDOTA_Modifier_Lua:GetOverrideAnimation() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetOverrideAnimationRate() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetOverrideAnimationWeight() end

--- (availability: server & client)
--- @return 0 | 1
function CDOTA_Modifier_Lua:GetOverrideAttackMagical() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetPrimaryStatDamageMultiplier() end

--- (availability: server & client)
--- @param event ModifierAbilityEvent
--- @return 0 | 1
function CDOTA_Modifier_Lua:GetReflectSpell(event) end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return 0 | 1
function CDOTA_Modifier_Lua:GetSuppressCleave(event) end

--- (availability: server & client)
--- @return 0 | 1
function CDOTA_Modifier_Lua:GetSuppressTeleport() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetTriggerCosmeticAndEndAttack() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetUnitLifetimeFraction() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:GetVisualZDelta() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:GetVisualZSpeedBaseOverride() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:MODIFIER_PROPERTY_INCOMING_DAMAGE_CONSTANT_POST() end

--- (availability: server & client)
--- @param event ModifierAbilityEvent
--- @return nil
function CDOTA_Modifier_Lua:OnAbilityEndChannel(event) end

--- (availability: server & client)
--- @param event ModifierAbilityEvent
--- @return nil
function CDOTA_Modifier_Lua:OnAbilityExecuted(event) end

--- (availability: server & client)
--- @param event ModifierAbilityEvent
--- @return nil
function CDOTA_Modifier_Lua:OnAbilityFullyCast(event) end

--- (availability: server & client)
--- @param event ModifierAbilityEvent
--- @return nil
function CDOTA_Modifier_Lua:OnAbilityStart(event) end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:OnAssist() end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return nil
function CDOTA_Modifier_Lua:OnAttack(event) end

--- Happens even if attack can't be issued.
--- 
--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return nil
function CDOTA_Modifier_Lua:OnAttackAllied(event) end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return nil
function CDOTA_Modifier_Lua:OnAttackCancelled(event) end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return nil
function CDOTA_Modifier_Lua:OnAttacked(event) end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return nil
function CDOTA_Modifier_Lua:OnAttackFail(event) end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return nil
function CDOTA_Modifier_Lua:OnAttackFinished(event) end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return nil
function CDOTA_Modifier_Lua:OnAttackLanded(event) end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return nil
function CDOTA_Modifier_Lua:OnAttackRecord(event) end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return nil
function CDOTA_Modifier_Lua:OnAttackRecordDestroy(event) end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return nil
function CDOTA_Modifier_Lua:OnAttackStart(event) end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:OnAttemptProjectileDodge() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:OnBreakInvisibility() end

--- (availability: server & client)
--- @param event ModifierInstanceEvent
--- @return nil
function CDOTA_Modifier_Lua:OnBuildingKilled(event) end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return nil
function CDOTA_Modifier_Lua:OnDamageCalculated(event) end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:OnDamageHPLoss() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:OnDamagePrevented() end

--- (availability: server & client)
--- @param event ModifierInstanceEvent
--- @return nil
function CDOTA_Modifier_Lua:OnDeath(event) end

--- (availability: server & client)
--- @param event ModifierInstanceEvent
--- @return nil
function CDOTA_Modifier_Lua:OnDeathCompleted(event) end

--- (availability: server & client)
--- @param event ModifierUnitEvent
--- @return nil
function CDOTA_Modifier_Lua:OnDominated(event) end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:OnForceProcMagicStick() end

--- (availability: server & client)
--- @param event ModifierHealEvent
--- @return nil
function CDOTA_Modifier_Lua:OnHealReceived(event) end

--- (availability: server & client)
--- @param event ModifierHealEvent
--- @return nil
function CDOTA_Modifier_Lua:OnHealthGained(event) end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return nil
function CDOTA_Modifier_Lua:OnHeroKilled(event) end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:OnKill() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:OnMagicDamageCalculated() end

--- (availability: server & client)
--- @param event ModifierUnitEvent
--- @return nil
function CDOTA_Modifier_Lua:OnManaGained(event) end

--- (availability: server & client)
--- @param event ModifierUnitEvent
--- @return nil
function CDOTA_Modifier_Lua:OnModelChanged(event) end

--- (availability: server & client)
--- @param event ModifierAddedEvent
--- @return nil
function CDOTA_Modifier_Lua:OnModifierAdded(event) end

--- (availability: server & client)
--- @param event ModifierUnitEvent
--- @return nil
function CDOTA_Modifier_Lua:OnOrder(event) end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:OnPreDebuffApplied() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:OnProcessCleave() end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return nil
function CDOTA_Modifier_Lua:OnProjectileDodge(event) end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:OnProjectileObstructionHit() end

--- (availability: server & client)
--- @param event ModifierUnitEvent
--- @return nil
function CDOTA_Modifier_Lua:OnRespawn(event) end

--- (availability: server & client)
--- @param event ModifierUnitEvent
--- @return nil
function CDOTA_Modifier_Lua:OnSetLocation(event) end

--- (availability: server & client)
--- @param event ModifierAbilityEvent
--- @return nil
function CDOTA_Modifier_Lua:OnSpellAppliedSuccessfully(event) end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:OnSpellTargetReady() end

--- (availability: server & client)
--- @param event ModifierAbilityEvent
--- @return nil
function CDOTA_Modifier_Lua:OnSpentHealth(event) end

--- (availability: server & client)
--- @param event ModifierAbilityEvent
--- @return nil
function CDOTA_Modifier_Lua:OnSpentMana(event) end

--- (availability: server & client)
--- @param event ModifierUnitEvent
--- @return nil
function CDOTA_Modifier_Lua:OnStateChanged(event) end

--- (availability: server & client)
--- @param event ModifierInstanceEvent
--- @return nil
function CDOTA_Modifier_Lua:OnTakeDamage(event) end

--- (availability: server & client)
--- @param event ModifierAttackEvent
--- @return nil
function CDOTA_Modifier_Lua:OnTakeDamageKillCredit(event) end

--- (availability: server & client)
--- @param event ModifierUnitEvent
--- @return nil
function CDOTA_Modifier_Lua:OnTeleported(event) end

--- (availability: server & client)
--- @param event ModifierUnitEvent
--- @return nil
function CDOTA_Modifier_Lua:OnTeleporting(event) end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:OnTooltip() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:OnTooltip2() end

--- (availability: server & client)
--- @param event ModifierUnitEvent
--- @return nil
function CDOTA_Modifier_Lua:OnUnitMoved(event) end

--- (availability: server & client)
--- @return 0 | 1
function CDOTA_Modifier_Lua:PreserveParticlesOnModelChanged() end

--- (availability: server & client)
--- @return nil
function CDOTA_Modifier_Lua:ReincarnateSuppressFX() end

--- (availability: server & client)
--- @return number
function CDOTA_Modifier_Lua:ReincarnateTime() end


--- @class CDOTA_Modifier_Lua_Horizontal_Motion : CDOTA_Modifier_Lua
CDOTA_Modifier_Lua_Horizontal_Motion = {}

--- Starts the horizontal motion controller effects for this buff.  Returns true if successful.
--- 
--- (availability: server)
--- @return boolean
function CDOTA_Modifier_Lua_Horizontal_Motion:ApplyHorizontalMotionController() end

--- Get the priority.
--- 
--- (availability: server)
--- @return modifierpriority
function CDOTA_Modifier_Lua_Horizontal_Motion:GetPriority() end

--- Called when the motion gets interrupted.
--- 
--- (availability: server)
--- @return nil
function CDOTA_Modifier_Lua_Horizontal_Motion:OnHorizontalMotionInterrupted() end

--- Set the priority.
--- 
--- (availability: server)
--- @param motionPriority modifierpriority
--- @return nil
function CDOTA_Modifier_Lua_Horizontal_Motion:SetPriority(motionPriority) end

--- Perform any motion from the given interval on the NPC.
--- 
--- (availability: server)
--- @param me CDOTA_BaseNPC
--- @param dt number
--- @return nil
function CDOTA_Modifier_Lua_Horizontal_Motion:UpdateHorizontalMotion(me, dt) end


--- @class CDOTA_Modifier_Lua_Motion_Both : CDOTA_Modifier_Lua
CDOTA_Modifier_Lua_Motion_Both = {}

--- Starts the horizontal motion controller effects for this buff.  Returns true if successful.
--- 
--- (availability: server)
--- @return boolean
function CDOTA_Modifier_Lua_Motion_Both:ApplyHorizontalMotionController() end

--- Starts the vertical motion controller effects for this buff.  Returns true if successful.
--- 
--- (availability: server)
--- @return boolean
function CDOTA_Modifier_Lua_Motion_Both:ApplyVerticalMotionController() end

--- Get the priority.
--- 
--- (availability: server)
--- @return modifierpriority
function CDOTA_Modifier_Lua_Motion_Both:GetPriority() end

--- Called when the motion gets interrupted.
--- 
--- (availability: server)
--- @return nil
function CDOTA_Modifier_Lua_Motion_Both:OnHorizontalMotionInterrupted() end

--- Called when the motion gets interrupted.
--- 
--- (availability: server)
--- @return nil
function CDOTA_Modifier_Lua_Motion_Both:OnVerticalMotionInterrupted() end

--- Set the priority.
--- 
--- (availability: server)
--- @param motionPriority modifierpriority
--- @return nil
function CDOTA_Modifier_Lua_Motion_Both:SetPriority(motionPriority) end

--- Perform any motion from the given interval on the NPC.
--- 
--- (availability: server)
--- @param me CDOTA_BaseNPC
--- @param dt number
--- @return nil
function CDOTA_Modifier_Lua_Motion_Both:UpdateHorizontalMotion(me, dt) end

--- Perform any motion from the given interval on the NPC.
--- 
--- (availability: server)
--- @param me CDOTA_BaseNPC
--- @param dt number
--- @return nil
function CDOTA_Modifier_Lua_Motion_Both:UpdateVerticalMotion(me, dt) end


--- @class CDOTA_Modifier_Lua_Vertical_Motion : CDOTA_Modifier_Lua
CDOTA_Modifier_Lua_Vertical_Motion = {}

--- Starts the vertical motion controller effects for this buff.  Returns true if successful.
--- 
--- (availability: server)
--- @return boolean
function CDOTA_Modifier_Lua_Vertical_Motion:ApplyVerticalMotionController() end

--- Get the priority.
--- 
--- (availability: server)
--- @return modifierpriority
function CDOTA_Modifier_Lua_Vertical_Motion:GetMotionPriority() end

--- Called when the motion gets interrupted.
--- 
--- (availability: server)
--- @return nil
function CDOTA_Modifier_Lua_Vertical_Motion:OnVerticalMotionInterrupted() end

--- Set the priority.
--- 
--- (availability: server)
--- @param motionPriority modifierpriority
--- @return nil
function CDOTA_Modifier_Lua_Vertical_Motion:SetMotionPriority(motionPriority) end

--- Perform any motion from the given interval on the NPC.
--- 
--- (availability: server)
--- @param me CDOTA_BaseNPC
--- @param dt number
--- @return nil
function CDOTA_Modifier_Lua_Vertical_Motion:UpdateVerticalMotion(me, dt) end


--- @class CDOTA_NeutralSpawner : CPointEntity
CDOTA_NeutralSpawner = {}

--- (availability: server)
--- @return nil
function CDOTA_NeutralSpawner:CreatePendingUnits() end

--- (availability: server)
--- @return nil
function CDOTA_NeutralSpawner:SelectSpawnType() end

--- (availability: server)
--- @param ignoreBlockers boolean
--- @return nil
function CDOTA_NeutralSpawner:SpawnNextBatch(ignoreBlockers) end


--- @class CDOTA_PlayerResource : CBaseEntity
PlayerResource = {}

--- (availability: server)
--- @param playerId PlayerID
--- @return nil
function PlayerResource:AddAegisPickup(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @param reason integer
--- @return nil
function PlayerResource:AddCandyEvent(playerId, reason) end

--- (availability: server)
--- @param playerId PlayerID
--- @param farmValue number
--- @param earnedValue boolean
--- @return nil
function PlayerResource:AddClaimedFarm(playerId, farmValue, earnedValue) end

--- (availability: server)
--- @param playerId PlayerID
--- @param cost integer
--- @return nil
function PlayerResource:AddGoldSpentOnSupport(playerId, cost) end

--- (availability: server)
--- @param playerId PlayerID
--- @param teamNumber DOTATeam_t
--- @param item CDOTA_Item
--- @return nil
function PlayerResource:AddNeutralItemToStash(playerId, teamNumber, item) end

--- (availability: server)
--- @param playerId PlayerID
--- @param runes integer
--- @return nil
function PlayerResource:AddRunePickup(playerId, runes) end

--- (availability: server)
--- @param unitOwnerPlayerId PlayerID
--- @param otherPlayerId PlayerID
--- @return boolean
function PlayerResource:AreUnitsSharedWithPlayerID(unitOwnerPlayerId, otherPlayerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return boolean
function PlayerResource:CanRepick(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return nil
function PlayerResource:ClearKillsMatrix(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return nil
function PlayerResource:ClearLastHitMultikill(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return nil
function PlayerResource:ClearLastHitStreak(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return nil
function PlayerResource:ClearPlayer(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return nil
function PlayerResource:ClearRawPlayerDamageMatrix(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return nil
function PlayerResource:ClearStreak(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return integer
function PlayerResource:GetAegisPickups(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return integer
function PlayerResource:GetAssists(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return integer
function PlayerResource:GetBroadcasterChannel(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return integer
function PlayerResource:GetBroadcasterChannelSlot(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return integer
function PlayerResource:GetClaimedDenies(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @param onlyEarned boolean
--- @return number
function PlayerResource:GetClaimedFarm(playerId, onlyEarned) end

--- (availability: server)
--- @param playerId PlayerID
--- @return integer
function PlayerResource:GetClaimedMisses(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return DOTAConnectionState_t
function PlayerResource:GetConnectionState(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @param total boolean
--- @return integer
function PlayerResource:GetCreepDamageTaken(playerId, total) end

--- (availability: server)
--- @param playerId PlayerID
--- @return number
function PlayerResource:GetCustomBuybackCooldown(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return integer
function PlayerResource:GetCustomBuybackCost(playerId) end

--- Get the current custom team assignment for this player.
--- 
--- (availability: server)
--- @param playerId PlayerID
--- @return integer
function PlayerResource:GetCustomTeamAssignment(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @param victimId PlayerID
--- @return integer
function PlayerResource:GetDamageDoneToHero(playerId, victimId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return integer
function PlayerResource:GetDeaths(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return integer
function PlayerResource:GetDenies(playerId) end

--- (nPlayerID).
--- 
--- (availability: server)
--- @param playerId PlayerID
--- @return userdata
function PlayerResource:GetEventGameUpgrades(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return integer
function PlayerResource:GetEventPointsForPlayerID(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return integer
function PlayerResource:GetEventPremiumPoints(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return any
function PlayerResource:GetEventRanks(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return integer
function PlayerResource:GetGold(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return integer
function PlayerResource:GetGoldLostToDeath(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return number
function PlayerResource:GetGoldPerMin(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return integer
function PlayerResource:GetGoldSpentOnBuybacks(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return integer
function PlayerResource:GetGoldSpentOnConsumables(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return integer
function PlayerResource:GetGoldSpentOnItems(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return integer
function PlayerResource:GetGoldSpentOnSupport(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return number
function PlayerResource:GetHealing(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @param total boolean
--- @return integer
function PlayerResource:GetHeroDamageTaken(playerId, total) end

--- (availability: server)
--- @param playerId PlayerID
--- @return integer
function PlayerResource:GetKills(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @param victimId PlayerID
--- @return integer
function PlayerResource:GetKillsDoneToHero(playerId, victimId) end

--- (nPlayerID).
--- 
--- (availability: server)
--- @param playerId PlayerID
--- @return userdata
function PlayerResource:GetLabyrinthEventGameHeroUnlocks(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return integer
function PlayerResource:GetLastHitMultikill(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return integer
function PlayerResource:GetLastHits(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return integer
function PlayerResource:GetLastHitStreak(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return integer
function PlayerResource:GetLevel(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return DOTATeam_t | -1
function PlayerResource:GetLiveSpectatorTeam(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return integer
function PlayerResource:GetMisses(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return integer
function PlayerResource:GetNearbyCreepDeaths(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @param eventId integer
--- @param unActionId integer
--- @return integer
function PlayerResource:GetNetworkedEventActionClaimCount(playerId, eventId, unActionId) end

--- (availability: server)
--- @param playerId PlayerID
--- @param eventId integer
--- @param actionName string
--- @return integer
function PlayerResource:GetNetworkedEventActionClaimCountByName(playerId, eventId, actionName) end

--- (availability: server)
--- @param playerId PlayerID
--- @return integer
function PlayerResource:GetNetWorth(playerId) end

--- (availability: server)
--- @param courierIndex integer
--- @param teamNumber DOTATeam_t
--- @return CDOTA_Unit_Courier | nil
function PlayerResource:GetNthCourierForTeam(courierIndex, teamNumber) end

--- (availability: server)
--- @param teamNumber DOTATeam_t
--- @param nthPlayer integer
--- @return PlayerID
function PlayerResource:GetNthPlayerIDOnTeam(teamNumber, nthPlayer) end

--- Players on a valid team (radiant, dire, or custom*) who haven't abandoned the game.
--- 
--- (availability: server)
--- @return integer
function PlayerResource:GetNumConnectedHumanPlayers() end

--- (availability: server)
--- @param playerId PlayerID
--- @return integer
function PlayerResource:GetNumConsumablesPurchased(playerId) end

--- (availability: server)
--- @param teamNumber DOTATeam_t
--- @return integer
function PlayerResource:GetNumCouriersForTeam(teamNumber) end

--- (availability: server)
--- @param playerId PlayerID
--- @return integer
function PlayerResource:GetNumItemsPurchased(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return Uint64
function PlayerResource:GetPartyID(playerId) end

--- Returns player entity for a player with specified id. Player entity represents a single connection, so a different entity might be returned. When player is disconnected nil would be returned.
--- 
--- (availability: server)
--- @param playerId PlayerID
--- @return CDOTAPlayerController | nil
function PlayerResource:GetPlayer(playerId) end

--- Includes spectators and players not assigned to a team.
--- 
--- (availability: server)
--- @return integer
function PlayerResource:GetPlayerCount() end

--- (availability: server)
--- @param team DOTATeam_t
--- @return integer
function PlayerResource:GetPlayerCountForTeam(team) end

--- (availability: server)
--- @param playerId PlayerID
--- @return boolean
function PlayerResource:GetPlayerLoadedCompletely(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return string
function PlayerResource:GetPlayerName(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return userdata
function PlayerResource:GetPreferredCourierForPlayer(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return integer
function PlayerResource:GetRawPlayerDamage(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return integer
function PlayerResource:GetReliableGold(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return integer
function PlayerResource:GetRespawnSeconds(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return integer
function PlayerResource:GetRoshanKills(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return integer
function PlayerResource:GetRunePickups(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return CDOTA_BaseNPC_Hero | nil
function PlayerResource:GetSelectedHeroEntity(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return integer
function PlayerResource:GetSelectedHeroID(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return string
function PlayerResource:GetSelectedHeroName(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return integer
function PlayerResource:GetSteamAccountID(playerId) end

--- Get the 64 bit steam ID for a given player.
--- 
--- (availability: server)
--- @param playerId PlayerID
--- @return Uint64
function PlayerResource:GetSteamID(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return integer
function PlayerResource:GetStreak(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return number
function PlayerResource:GetStuns(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return DOTATeam_t
function PlayerResource:GetTeam(playerId) end

--- (availability: server)
--- @param team DOTATeam_t
--- @return integer
function PlayerResource:GetTeamKills(team) end

--- (Deprecated: use GetNumConnectedHumanPlayers) Players on a valid team (radiant, dire, or custom*) who haven't abandoned the game.
--- 
--- (availability: server)
--- @return integer
function PlayerResource:GetTeamPlayerCount() end

--- (availability: server)
--- @param playerId PlayerID
--- @return number
function PlayerResource:GetTimeOfLastConsumablePurchase(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return number
function PlayerResource:GetTimeOfLastDeath(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return number
function PlayerResource:GetTimeOfLastItemPurchase(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return integer
function PlayerResource:GetTotalEarnedGold(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return integer
function PlayerResource:GetTotalEarnedXP(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return integer
function PlayerResource:GetTotalGoldSpent(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @param total boolean
--- @return integer
function PlayerResource:GetTowerDamageTaken(playerId, total) end

--- (availability: server)
--- @param playerId PlayerID
--- @return integer
function PlayerResource:GetTowerKills(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @param otherPlayerId PlayerID
--- @return integer
function PlayerResource:GetUnitShareMaskForPlayer(playerId, otherPlayerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return integer
function PlayerResource:GetUnreliableGold(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return number
function PlayerResource:GetXPPerMin(playerId) end

--- Does this player have a custom game ticket for this game?
--- 
--- (availability: server)
--- @param playerId PlayerID
--- @return boolean
function PlayerResource:HasCustomGameTicketForPlayerID(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return boolean
function PlayerResource:HasRandomed(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return boolean
function PlayerResource:HasSelectedHero(playerId) end

--- (availability: server)
--- @return boolean
function PlayerResource:HasSetNetworkedEventActionClaimCount() end

--- (availability: server)
--- @return boolean
function PlayerResource:HaveAllPlayersJoined() end

--- (availability: server)
--- @param playerId PlayerID
--- @param victimId PlayerID
--- @return nil
function PlayerResource:IncrementAssists(playerId, victimId) end

--- (availability: server)
--- @param playerId PlayerID
--- @param value integer
--- @return nil
function PlayerResource:IncrementClaimedDenies(playerId, value) end

--- (availability: server)
--- @param playerId PlayerID
--- @param value integer
--- @return nil
function PlayerResource:IncrementClaimedMisses(playerId, value) end

--- (availability: server)
--- @param playerId PlayerID
--- @param killerId PlayerID
--- @return nil
function PlayerResource:IncrementDeaths(playerId, killerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @param value integer
--- @return nil
function PlayerResource:IncrementDenies(playerId, value) end

--- (availability: server)
--- @param playerId PlayerID
--- @param victimId PlayerID
--- @return nil
function PlayerResource:IncrementKills(playerId, victimId) end

--- (availability: server)
--- @param playerId PlayerID
--- @param count integer
--- @return nil
function PlayerResource:IncrementLastHitMultikill(playerId, count) end

--- (availability: server)
--- @param playerId PlayerID
--- @param count integer
--- @return nil
function PlayerResource:IncrementLastHits(playerId, count) end

--- (availability: server)
--- @param playerId PlayerID
--- @param count integer
--- @return nil
function PlayerResource:IncrementLastHitStreak(playerId, count) end

--- (availability: server)
--- @param playerId PlayerID
--- @param value integer
--- @return nil
function PlayerResource:IncrementMisses(playerId, value) end

--- (availability: server)
--- @param playerId PlayerID
--- @param creeps integer
--- @return nil
function PlayerResource:IncrementNearbyCreepDeaths(playerId, creeps) end

--- (availability: server)
--- @param playerId PlayerID
--- @param count integer
--- @return nil
function PlayerResource:IncrementStreak(playerId, count) end

--- (availability: server)
--- @param playerId PlayerID
--- @param xp integer
--- @param reason EDOTA_ModifyXP_Reason
--- @return nil
function PlayerResource:IncrementTotalEarnedXP(playerId, xp, reason) end

--- (availability: server)
--- @param playerId PlayerID
--- @return boolean
function PlayerResource:IsBroadcaster(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @param otherPlayerId PlayerID
--- @return boolean
function PlayerResource:IsDisableHelpSetForPlayerID(playerId, otherPlayerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return boolean
function PlayerResource:IsFakeClient(playerId) end

--- (availability: server)
--- @param heroname string
--- @param ignoreUnrevealedPick boolean
--- @return boolean
function PlayerResource:IsHeroSelected(heroname, ignoreUnrevealedPick) end

--- (availability: server)
--- @param unitOwnerPlayerId PlayerID
--- @param otherPlayerId PlayerID
--- @return boolean
function PlayerResource:IsHeroSharedWithPlayerID(unitOwnerPlayerId, otherPlayerId) end

--- (availability: server)
--- @param playerId integer
--- @return boolean
function PlayerResource:IsValidPlayer(playerId) end

--- (availability: server)
--- @param playerId integer
--- @return boolean
function PlayerResource:IsValidPlayerID(playerId) end

--- (availability: server)
--- @param playerId integer
--- @return boolean
function PlayerResource:IsValidTeamPlayer(playerId) end

--- (availability: server)
--- @param playerId integer
--- @return boolean
function PlayerResource:IsValidTeamPlayerID(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @param goldChange integer
--- @param reliable boolean
--- @param reason EDOTA_ModifyGold_Reason
--- @return integer
function PlayerResource:ModifyGold(playerId, goldChange, reliable, reason) end

--- (availability: server)
--- @return integer
function PlayerResource:NumPlayers() end

--- (availability: server)
--- @return integer
function PlayerResource:NumTeamPlayers() end

--- Increment or decrement consumable charges (nPlayerID, item_definition_index, nChargeIncrementOrDecrement).
--- 
--- (availability: server)
--- @param playerId PlayerID
--- @param itemDefinitionIndex integer
--- @param chargeIncrementOrDecrement integer
--- @return nil
function PlayerResource:RecordConsumableAbilityChargeChange(playerId, itemDefinitionIndex, chargeIncrementOrDecrement) end

--- (availability: server)
--- @param playerId PlayerID
--- @param event integer
--- @param unActionId integer
--- @param unAudit integer
--- @param unQuantity integer
--- @param unAuditData integer
--- @return nil
function PlayerResource:RecordEventActionGrant(playerId, event, unActionId, unAudit, unQuantity, unAuditData) end

--- (availability: server)
--- @param playerId PlayerID
--- @param actionName string
--- @param unAudit integer
--- @param unQuantity integer
--- @param unAuditData integer
--- @return nil
function PlayerResource:RecordEventActionGrantForPrimaryEvent(playerId, actionName, unAudit, unQuantity, unAuditData) end

--- Replaces the player's hero with a new one of the specified class, gold and XP.
--- 
--- (availability: server)
--- @param playerId PlayerID
--- @param heroClass string
--- @param gold integer
--- @param xp integer
--- @return CDOTA_BaseNPC_Hero
function PlayerResource:ReplaceHeroWith(playerId, heroClass, gold, xp) end

--- Replaces the player's hero with a new one of the specified class, gold and XP, without transferring items/abilities if same hero.
--- 
--- (availability: server)
--- @param playerId PlayerID
--- @param heroClass string
--- @param gold integer
--- @param xp integer
--- @return userdata
function PlayerResource:ReplaceHeroWithNoTransfer(playerId, heroClass, gold, xp) end

--- (availability: server)
--- @param playerId PlayerID
--- @return nil
function PlayerResource:ResetBuybackCostTime(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @return nil
function PlayerResource:ResetTotalEarnedGold(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @param buybackCooldown number
--- @return nil
function PlayerResource:SetBuybackCooldownTime(playerId, buybackCooldown) end

--- (availability: server)
--- @param playerId PlayerID
--- @param buybackCooldown number
--- @return nil
function PlayerResource:SetBuybackGoldLimitTime(playerId, buybackCooldown) end

--- Force the given player's camera to follow the given entity.
--- 
--- (availability: server)
--- @param playerId PlayerID
--- @param target CBaseEntity | nil
--- @return nil
function PlayerResource:SetCameraTarget(playerId, target) end

--- (availability: server)
--- @param playerId PlayerID
--- @param canRepick boolean
--- @return nil
function PlayerResource:SetCanRepick(playerId, canRepick) end

--- Set the buyback cooldown for this player.
--- 
--- (availability: server)
--- @param playerId PlayerID
--- @param cooldownTime number
--- @return nil
function PlayerResource:SetCustomBuybackCooldown(playerId, cooldownTime) end

--- Set the buyback cost for this player.
--- 
--- (availability: server)
--- @param playerId PlayerID
--- @param goldCost integer
--- @return nil
function PlayerResource:SetCustomBuybackCost(playerId, goldCost) end

--- (availability: server)
--- @param playerId PlayerID
--- @param param integer
--- @return nil
function PlayerResource:SetCustomIntParam(playerId, param) end

--- Set custom color for player.
--- 
--- (availability: server)
--- @param playerId PlayerID
--- @param r integer
--- @param g integer
--- @param b integer
--- @return nil
function PlayerResource:SetCustomPlayerColor(playerId, r, g, b) end

--- Set custom team assignment for this player.
--- 
--- (availability: server)
--- @param playerId PlayerID
--- @param teamAssignment DOTATeam_t
--- @return nil
function PlayerResource:SetCustomTeamAssignment(playerId, teamAssignment) end

--- (availability: server)
--- @param playerId PlayerID
--- @param gold integer
--- @param reliable boolean
--- @return nil
function PlayerResource:SetGold(playerId, gold, reliable) end

--- (availability: server)
--- @param playerId PlayerID
--- @return nil
function PlayerResource:SetHasRandomed(playerId) end

--- (availability: server)
--- @param playerId PlayerID
--- @param lastBuybackTime number
--- @return nil
function PlayerResource:SetLastBuybackTime(playerId, lastBuybackTime) end

--- Set the forced selection entity for a player.
--- 
--- (availability: server)
--- @param playerId PlayerID
--- @param entity CDOTA_BaseNPC
--- @return nil
function PlayerResource:SetOverrideSelectionEntity(playerId, entity) end

--- (availability: server)
--- @param playerId PlayerID
--- @param otherPlayerId PlayerID
--- @param flag integer
--- @param state boolean
--- @return nil
function PlayerResource:SetUnitShareMaskForPlayer(playerId, otherPlayerId, flag, state) end

--- (availability: server)
--- @param playerId PlayerID
--- @param cost integer
--- @param reason EDOTA_ModifyGold_Reason
--- @return nil
function PlayerResource:SpendGold(playerId, cost, reason) end

--- (availability: server)
--- @param playerId PlayerID
--- @param teamNumber DOTATeam_t
--- @param desiredSlot integer
--- @return nil
function PlayerResource:UpdateTeamSlot(playerId, teamNumber, desiredSlot) end

--- (availability: server)
--- @param heroFilename string
--- @param ignoreUnrevealedPick boolean
--- @return PlayerID
function PlayerResource:WhoSelectedHero(heroFilename, ignoreUnrevealedPick) end


--- @class CDOTA_ShopTrigger : CBaseTrigger
CDOTA_ShopTrigger = {}

--- Get the DOTA_SHOP_TYPE.
--- 
--- (availability: server)
--- @return DOTA_SHOP_TYPE
function CDOTA_ShopTrigger:GetShopType() end

--- Set the DOTA_SHOP_TYPE.
--- 
--- (availability: server)
--- @param shopType DOTA_SHOP_TYPE
--- @return nil
function CDOTA_ShopTrigger:SetShopType(shopType) end


--- @class CDOTA_SimpleObstruction : CBaseEntity
CDOTA_SimpleObstruction = {}

--- Returns whether the obstruction is currently active.
--- 
--- (availability: server)
--- @return boolean
function CDOTA_SimpleObstruction:IsEnabled() end

--- Enable or disable the obstruction.
--- 
--- (availability: server)
--- @param enabled boolean
--- @param force boolean
--- @return nil
function CDOTA_SimpleObstruction:SetEnabled(enabled, force) end


--- @class CDOTA_Unit_Courier : CDOTA_BaseNPC
CDOTA_Unit_Courier = {}

--- Upgrade the courier ( int param ) times.
--- 
--- (availability: server)
--- @param level integer
--- @return nil
function CDOTA_Unit_Courier:UpgradeCourier(level) end


--- @class CDOTA_Unit_CustomGameAnnouncer : CDOTA_BaseNPC
CDOTA_Unit_CustomGameAnnouncer = {}

--- Determines whether response criteria is matched on server or client.
--- 
--- (availability: server)
--- @param isServerAuthoritative boolean
--- @return nil
function CDOTA_Unit_CustomGameAnnouncer:SetServerAuthoritative(isServerAuthoritative) end


--- @class CDOTA_Unit_CustomGameAnnouncerAghanim : CDOTA_BaseNPC
CDOTA_Unit_CustomGameAnnouncerAghanim = {}

--- Set the animation sequence for this entity.
--- 
--- (availability: server)
--- @param animation string
--- @return nil
function CDOTA_Unit_CustomGameAnnouncerAghanim:SetAnimation(animation) end

--- Determines whether response criteria is matched on server or client.
--- 
--- (availability: server)
--- @param isServerAuthoritative boolean
--- @return nil
function CDOTA_Unit_CustomGameAnnouncerAghanim:SetServerAuthoritative(isServerAuthoritative) end


--- @class CDOTA_Unit_Diretide_Portal : CDOTA_BaseNPC_Building
CDOTA_Unit_Diretide_Portal = {}

--- (availability: server)
--- @return userdata
function CDOTA_Unit_Diretide_Portal:GetPartnerPortal() end

--- (availability: server)
--- @return nil
function CDOTA_Unit_Diretide_Portal:ResetPortal() end

--- (availability: server)
--- @param runeType integer
--- @return nil
function CDOTA_Unit_Diretide_Portal:SetInvasionRuneType(runeType) end

--- (availability: server)
--- @param portal userdata
--- @return nil
function CDOTA_Unit_Diretide_Portal:SetPartnerPortal(portal) end

--- (availability: server)
--- @param active boolean
--- @return nil
function CDOTA_Unit_Diretide_Portal:SetPortalActive(active) end


--- @class CDOTA_Unit_Nian : CDOTA_BaseNPC_Creature
CDOTA_Unit_Nian = {}

--- Is the Nian horn?
--- 
--- (availability: server)
--- @return userdata
function CDOTA_Unit_Nian:GetHorn() end

--- Is the Nian's tail broken?
--- 
--- (availability: server)
--- @return userdata
function CDOTA_Unit_Nian:GetTail() end

--- Is the Nian's horn broken?
--- 
--- (availability: server)
--- @return boolean
function CDOTA_Unit_Nian:IsHornAlive() end

--- Is the Nian's tail broken?
--- 
--- (availability: server)
--- @return boolean
function CDOTA_Unit_Nian:IsTailAlive() end


--- @class CDOTA_Unit_Scout : CDOTA_BaseNPC
CDOTA_Unit_Scout = {}

--- @class CDOTABaseAbility : CBaseEntity
CDOTABaseAbility = {}

--- (availability: server)
--- @return boolean
function CDOTABaseAbility:CanAbilityBeUpgraded() end

--- (availability: server)
--- @return boolean
function CDOTABaseAbility:CastAbility() end

--- (availability: server)
--- @return boolean
function CDOTABaseAbility:ContinueCasting() end

--- (availability: server)
--- @param location Vector
--- @param radius number
--- @param duration number
--- @return nil
function CDOTABaseAbility:CreateVisibilityNode(location, radius, duration) end

--- (availability: server)
--- @return nil
function CDOTABaseAbility:DecrementModifierRefCount() end

--- (availability: server)
--- @param ability userdata
--- @param talentName string
--- @return nil
function CDOTABaseAbility:EnableAbilityChargesOnTalentUpgrade(ability, talentName) end

--- (availability: server)
--- @param interrupted boolean
--- @return nil
function CDOTABaseAbility:EndChannel(interrupted) end

--- Clear the cooldown remaining on this ability.
--- 
--- (availability: server)
--- @return nil
function CDOTABaseAbility:EndCooldown() end

--- (availability: server)
--- @param value integer
--- @return nil
function CDOTABaseAbility:ForceSetFrozenCooldown(value) end

--- (availability: server)
--- @param level integer
--- @return number
function CDOTABaseAbility:GetAbilityChargeRestoreTime(level) end

--- (availability: server)
--- @return integer
function CDOTABaseAbility:GetAbilityDamage() end

--- (availability: server)
--- @return DAMAGE_TYPES
function CDOTABaseAbility:GetAbilityDamageType() end

--- (availability: server)
--- @return integer
function CDOTABaseAbility:GetAbilityIndex() end

--- Gets the key values definition for this ability.
--- 
--- (availability: server)
--- @return table
function CDOTABaseAbility:GetAbilityKeyValues() end

--- Returns the name of this ability.
--- 
--- (availability: server & client)
--- @return string
function CDOTABaseAbility:GetAbilityName() end

--- (availability: server)
--- @return DOTA_UNIT_TARGET_FLAGS
function CDOTABaseAbility:GetAbilityTargetFlags() end

--- (availability: server)
--- @return DOTA_UNIT_TARGET_TEAM
function CDOTABaseAbility:GetAbilityTargetTeam() end

--- (availability: server)
--- @return DOTA_UNIT_TARGET_TYPE
function CDOTABaseAbility:GetAbilityTargetType() end

--- (availability: server)
--- @return integer
function CDOTABaseAbility:GetAbilityType() end

--- (availability: server)
--- @return boolean
function CDOTABaseAbility:GetAnimationIgnoresModelScale() end

--- (availability: server)
--- @return integer
function CDOTABaseAbility:GetAOERadius() end

--- (availability: server)
--- @return string
function CDOTABaseAbility:GetAssociatedPrimaryAbilities() end

--- (availability: server)
--- @return string
function CDOTABaseAbility:GetAssociatedSecondaryAbilities() end

--- (availability: server)
--- @return boolean
function CDOTABaseAbility:GetAutoCastState() end

--- (availability: server)
--- @return number
function CDOTABaseAbility:GetBackswingTime() end

--- (availability: server & client)
--- @return DOTA_ABILITY_BEHAVIOR
function CDOTABaseAbility:GetBehavior() end

--- Get ability behavior flags as an int for compatability.
--- 
--- (availability: server & client)
--- @return DOTA_ABILITY_BEHAVIOR
function CDOTABaseAbility:GetBehaviorInt() end

--- Get the owner of this ability.
--- 
--- (availability: server & client)
--- @return CDOTA_BaseNPC
function CDOTABaseAbility:GetCaster() end

--- (availability: server)
--- @return number
function CDOTABaseAbility:GetCastPoint() end

--- (availability: server & client)
--- @return number
function CDOTABaseAbility:GetCastPointModifier() end

--- Gets the cast range of the ability.
--- 
--- (availability: server)
--- @param location Vector | nil
--- @param target CDOTA_BaseNPC | nil
--- @return integer
function CDOTABaseAbility:GetCastRange(location, target) end

--- (availability: server)
--- @param level integer
--- @return integer
function CDOTABaseAbility:GetChannelledHealthCostPerSecond(level) end

--- (availability: server)
--- @param level integer
--- @return integer
function CDOTABaseAbility:GetChannelledManaCostPerSecond(level) end

--- (availability: server)
--- @return number
function CDOTABaseAbility:GetChannelStartTime() end

--- (availability: server)
--- @return number
function CDOTABaseAbility:GetChannelTime() end

--- (availability: server)
--- @return CDOTA_BaseNPC | nil
function CDOTABaseAbility:GetCloneSource() end

--- (availability: server)
--- @return integer
function CDOTABaseAbility:GetConceptRecipientType() end

--- Get the cooldown duration for this ability at a given level, not the amount of cooldown actually left.
--- 
--- (availability: server)
--- @param level integer
--- @return number
function CDOTABaseAbility:GetCooldown(level) end

--- (availability: server)
--- @return number
function CDOTABaseAbility:GetCooldownTime() end

--- (availability: server)
--- @return number
function CDOTABaseAbility:GetCooldownTimeRemaining() end

--- The number of charges remaining on this ability.
--- 
--- (availability: server & client)
--- @return integer
function CDOTABaseAbility:GetCurrentAbilityCharges() end

--- (availability: server)
--- @return Vector
function CDOTABaseAbility:GetCursorPosition() end

--- (availability: server)
--- @return CDOTA_BaseNPC | nil
function CDOTABaseAbility:GetCursorTarget() end

--- (availability: server)
--- @return boolean
function CDOTABaseAbility:GetCursorTargetingNothing() end

--- (availability: server)
--- @return number
function CDOTABaseAbility:GetDuration() end

--- Gets the cast range of the ability, taking modifiers into account.
--- 
--- (availability: server)
--- @param location Vector
--- @param target userdata
--- @return integer
function CDOTABaseAbility:GetEffectiveCastRange(location, target) end

--- (availability: server)
--- @param level integer
--- @return number
function CDOTABaseAbility:GetEffectiveCooldown(level) end

--- (availability: server)
--- @param level integer
--- @return integer
function CDOTABaseAbility:GetEffectiveHealthCost(level) end

--- (availability: server)
--- @param level integer
--- @return integer
function CDOTABaseAbility:GetEffectiveManaCost(level) end

--- (availability: server)
--- @param level integer
--- @return integer
function CDOTABaseAbility:GetGoldCost(level) end

--- (availability: server)
--- @param level integer
--- @return integer
function CDOTABaseAbility:GetGoldCostForUpgrade(level) end

--- (availability: server)
--- @param level integer
--- @return integer
function CDOTABaseAbility:GetHealthCost(level) end

--- (availability: server)
--- @return integer
function CDOTABaseAbility:GetHeroLevelRequiredToUpgrade() end

--- (availability: server)
--- @param level integer
--- @return integer
function CDOTABaseAbility:GetInitialAbilityCharges(level) end

--- (availability: server)
--- @return string
function CDOTABaseAbility:GetIntrinsicModifierName() end

--- Get the current level of the ability.
--- 
--- (availability: server & client)
--- @return integer
function CDOTABaseAbility:GetLevel() end

--- Gets a value from this ability's special value block for passed level.
--- 
--- (availability: server & client)
--- @param name string
--- @param level integer
--- @return number
function CDOTABaseAbility:GetLevelSpecialValueFor(name, level) end

--- Gets a value from this ability's special value block for passed level, ignoring MODIFIER_PROPERTY_OVERRIDE_ABILITY_SPECIAL.
--- 
--- (availability: server & client)
--- @param name string
--- @param level integer
--- @return number
function CDOTABaseAbility:GetLevelSpecialValueNoOverride(name, level) end

--- (availability: server)
--- @param level integer
--- @return integer
function CDOTABaseAbility:GetManaCost(level) end

--- (availability: server)
--- @param level integer
--- @return integer
function CDOTABaseAbility:GetMaxAbilityCharges(level) end

--- (availability: server)
--- @return integer
function CDOTABaseAbility:GetMaxLevel() end

--- (availability: server)
--- @return number
function CDOTABaseAbility:GetModifierValue() end

--- (availability: server)
--- @return number
function CDOTABaseAbility:GetModifierValueBonus() end

--- (availability: server)
--- @return number
function CDOTABaseAbility:GetPlaybackRateOverride() end

--- (availability: server)
--- @return string
function CDOTABaseAbility:GetSharedCooldownName() end

--- Gets a value from this ability's special value block for its current level.
--- 
--- (availability: server & client)
--- @param name string
--- @return number
function CDOTABaseAbility:GetSpecialValueFor(name) end

--- (availability: server)
--- @return string
function CDOTABaseAbility:GetStolenActivityModifier() end

--- Whether or not this ability is toggled.
--- 
--- (availability: server & client)
--- @return boolean
function CDOTABaseAbility:GetToggleState() end

--- (availability: server)
--- @return boolean
function CDOTABaseAbility:GetUpgradeRecommended() end

--- (availability: server)
--- @param xp number
--- @return boolean
function CDOTABaseAbility:HeroXPChange(xp) end

--- (availability: server)
--- @return nil
function CDOTABaseAbility:IncrementModifierRefCount() end

--- (availability: server)
--- @return boolean
function CDOTABaseAbility:IsActivated() end

--- (availability: server)
--- @return boolean
function CDOTABaseAbility:IsAttributeBonus() end

--- Returns whether the ability is currently channeling.
--- 
--- (availability: server)
--- @return boolean
function CDOTABaseAbility:IsChanneling() end

--- (availability: server)
--- @return boolean
function CDOTABaseAbility:IsCooldownReady() end

--- (availability: server)
--- @param entity CBaseEntity
--- @return boolean
function CDOTABaseAbility:IsCosmetic(entity) end

--- Returns whether the ability can be cast.
--- 
--- (availability: server)
--- @return boolean
function CDOTABaseAbility:IsFullyCastable() end

--- (availability: server)
--- @return boolean
function CDOTABaseAbility:IsHidden() end

--- (availability: server)
--- @return boolean
function CDOTABaseAbility:IsHiddenAsSecondaryAbility() end

--- (availability: server)
--- @return boolean
function CDOTABaseAbility:IsHiddenWhenStolen() end

--- Returns whether the ability is currently casting.
--- 
--- (availability: server)
--- @return boolean
function CDOTABaseAbility:IsInAbilityPhase() end

--- Whether or not this ability is an item.
--- 
--- (availability: server & client)
--- @return boolean
function CDOTABaseAbility:IsItem() end

--- (availability: server)
--- @param issuerPlayerId PlayerID
--- @return boolean
function CDOTABaseAbility:IsOwnersGoldEnough(issuerPlayerId) end

--- (availability: server)
--- @return boolean
function CDOTABaseAbility:IsOwnersGoldEnoughForUpgrade() end

--- (availability: server)
--- @return boolean
function CDOTABaseAbility:IsOwnersManaEnough() end

--- (availability: server)
--- @return boolean
function CDOTABaseAbility:IsPassive() end

--- (availability: server)
--- @return boolean
function CDOTABaseAbility:IsRefreshable() end

--- (availability: server)
--- @return boolean
function CDOTABaseAbility:IsSharedWithTeammates() end

--- (availability: server)
--- @return boolean
function CDOTABaseAbility:IsStealable() end

--- (availability: server)
--- @return boolean
function CDOTABaseAbility:IsStolen() end

--- (availability: server)
--- @return boolean
function CDOTABaseAbility:IsToggle() end

--- (availability: server)
--- @return boolean
function CDOTABaseAbility:IsTrained() end

--- Mark the ability button for this ability as needing a refresh.
--- 
--- (availability: server)
--- @return nil
function CDOTABaseAbility:MarkAbilityButtonDirty() end

--- (availability: server)
--- @return integer
function CDOTABaseAbility:NumModifiersUsingAbility() end

--- (availability: server)
--- @return nil
function CDOTABaseAbility:OnAbilityPhaseInterrupted() end

--- (availability: server)
--- @return boolean
function CDOTABaseAbility:OnAbilityPhaseStart() end

--- (availability: server)
--- @param playerId PlayerID
--- @param ctrlHeld boolean
--- @return nil
function CDOTABaseAbility:OnAbilityPinged(playerId, ctrlHeld) end

--- (availability: server)
--- @param interrupted boolean
--- @return nil
function CDOTABaseAbility:OnChannelFinish(interrupted) end

--- (availability: server)
--- @param interval number
--- @return nil
function CDOTABaseAbility:OnChannelThink(interval) end

--- (availability: server)
--- @return nil
function CDOTABaseAbility:OnHeroCalculateStatBonus() end

--- (availability: server)
--- @return nil
function CDOTABaseAbility:OnHeroLevelUp() end

--- (availability: server)
--- @return nil
function CDOTABaseAbility:OnOwnerDied() end

--- (availability: server)
--- @return nil
function CDOTABaseAbility:OnOwnerSpawned() end

--- (availability: server)
--- @return nil
function CDOTABaseAbility:OnSpellStart() end

--- (availability: server)
--- @return nil
function CDOTABaseAbility:OnToggle() end

--- (availability: server)
--- @return nil
function CDOTABaseAbility:OnUpgrade() end

--- (availability: server)
--- @return nil
function CDOTABaseAbility:PayGoldCost() end

--- (availability: server)
--- @return nil
function CDOTABaseAbility:PayGoldCostForUpgrade() end

--- (availability: server)
--- @return nil
function CDOTABaseAbility:PayHealthCost() end

--- (availability: server)
--- @return nil
function CDOTABaseAbility:PayManaCost() end

--- (availability: server)
--- @return boolean
function CDOTABaseAbility:PlaysDefaultAnimWhenStolen() end

--- (availability: server)
--- @return boolean
function CDOTABaseAbility:ProcsMagicStick() end

--- (availability: server)
--- @return boolean
function CDOTABaseAbility:RefCountsModifiers() end

--- (availability: server)
--- @return nil
function CDOTABaseAbility:RefreshCharges() end

--- (availability: server)
--- @return nil
function CDOTABaseAbility:RefreshIntrinsicModifier() end

--- (availability: server)
--- @return nil
function CDOTABaseAbility:RefundHealthCost() end

--- (availability: server)
--- @return nil
function CDOTABaseAbility:RefundManaCost() end

--- (availability: server)
--- @return boolean
function CDOTABaseAbility:RequiresFacing() end

--- (availability: server)
--- @return boolean
function CDOTABaseAbility:ResetToggleOnRespawn() end

--- (availability: server)
--- @param index integer
--- @return nil
function CDOTABaseAbility:SetAbilityIndex(index) end

--- (availability: server)
--- @param activated boolean
--- @return nil
function CDOTABaseAbility:SetActivated(activated) end

--- (availability: server)
--- @param channeling boolean
--- @return nil
function CDOTABaseAbility:SetChanneling(channeling) end

--- (availability: server)
--- @param charges integer
--- @return nil
function CDOTABaseAbility:SetCurrentAbilityCharges(charges) end

--- (availability: server)
--- @param frozenCooldown boolean
--- @return nil
function CDOTABaseAbility:SetFrozenCooldown(frozenCooldown) end

--- (availability: server)
--- @param hidden boolean
--- @return nil
function CDOTABaseAbility:SetHidden(hidden) end

--- (availability: server)
--- @param inAbilityPhase boolean
--- @return nil
function CDOTABaseAbility:SetInAbilityPhase(inAbilityPhase) end

--- Sets the level of this ability.
--- 
--- (availability: server)
--- @param level integer
--- @return nil
function CDOTABaseAbility:SetLevel(level) end

--- (availability: server)
--- @param castPoint number
--- @return nil
function CDOTABaseAbility:SetOverrideCastPoint(castPoint) end

--- (availability: server)
--- @param refCounts boolean
--- @return nil
function CDOTABaseAbility:SetRefCountsModifiers(refCounts) end

--- (availability: server)
--- @param stealable boolean
--- @return nil
function CDOTABaseAbility:SetStealable(stealable) end

--- (availability: server)
--- @param stolen boolean
--- @return nil
function CDOTABaseAbility:SetStolen(stolen) end

--- (availability: server)
--- @param upgradeRecommended boolean
--- @return nil
function CDOTABaseAbility:SetUpgradeRecommended(upgradeRecommended) end

--- (availability: server)
--- @return boolean
function CDOTABaseAbility:ShouldUseResources() end

--- (availability: server)
--- @param concept integer
--- @return nil
function CDOTABaseAbility:SpeakAbilityConcept(concept) end

--- (availability: server)
--- @return any
function CDOTABaseAbility:SpeakTrigger() end

--- (availability: server)
--- @param cooldown number
--- @return nil
function CDOTABaseAbility:StartCooldown(cooldown) end

--- (availability: server)
--- @return nil
function CDOTABaseAbility:ToggleAbility() end

--- (availability: server)
--- @return nil
function CDOTABaseAbility:ToggleAutoCast() end

--- (availability: server)
--- @param supressSpeech boolean
--- @return nil
function CDOTABaseAbility:UpgradeAbility(supressSpeech) end

--- (availability: server)
--- @param mana boolean
--- @param useHealth boolean
--- @param gold boolean
--- @param cooldown boolean
--- @return nil
function CDOTABaseAbility:UseResources(mana, useHealth, gold, cooldown) end


--- @class CDOTABaseGameMode : CBaseEntity
CDOTABaseGameMode = {}

--- Const char* pszAbilityName.
--- 
--- (availability: server)
--- @param abilityName string
--- @return nil
function CDOTABaseGameMode:AddAbilityUpgradeToWhitelist(abilityName) end

--- Add an item to purchase at a custom shop.
--- 
--- (availability: server)
--- @param itemName string
--- @param shopName string
--- @param category string
--- @return nil
function CDOTABaseGameMode:AddItemToCustomShop(itemName, shopName, category) end

--- Begin tracking a sequence of events using the real time combat analyzer.
--- 
--- (availability: server)
--- @param queryTable userdata
--- @param player CDOTAPlayerController
--- @param queryName string
--- @return CombatAnalyzerQueryID
function CDOTABaseGameMode:AddRealTimeCombatAnalyzerQuery(queryTable, player, queryName) end

--- Allocates an entity which can be used by custom games to control FoW occlusion volumes.
--- 
--- (availability: server)
--- @param minX number
--- @param minY number
--- @param maxX number
--- @param maxY number
--- @param gridSize number
--- @return CFoWBlockerRegion
function CDOTABaseGameMode:AllocateFowBlockerRegion(minX, minY, maxX, maxY, gridSize) end

--- Get if weather effects are disabled on the client.
--- 
--- (availability: server)
--- @return boolean
function CDOTABaseGameMode:AreWeatherEffectsDisabled() end

--- Clear the script filter that controls bounty rune pickup behavior.
--- 
--- (availability: server)
--- @return nil
function CDOTABaseGameMode:ClearBountyRunePickupFilter() end

--- Clear the script filter that controls how a unit takes damage.
--- 
--- (availability: server)
--- @return nil
function CDOTABaseGameMode:ClearDamageFilter() end

--- Clear the script filter that controls when a unit picks up an item.
--- 
--- (availability: server)
--- @return nil
function CDOTABaseGameMode:ClearExecuteOrderFilter() end

--- Clear the script filter that controls how a unit heals.
--- 
--- (availability: server)
--- @return nil
function CDOTABaseGameMode:ClearHealingFilter() end

--- Clear the script filter that controls the item added to inventory filter.
--- 
--- (availability: server)
--- @return nil
function CDOTABaseGameMode:ClearItemAddedToInventoryFilter() end

--- Clear the script filter that controls the modifier filter.
--- 
--- (availability: server)
--- @return nil
function CDOTABaseGameMode:ClearModifierGainedFilter() end

--- Clear the script filter that controls how hero experience is modified.
--- 
--- (availability: server)
--- @return nil
function CDOTABaseGameMode:ClearModifyExperienceFilter() end

--- Clear the script filter that controls how hero gold is modified.
--- 
--- (availability: server)
--- @return nil
function CDOTABaseGameMode:ClearModifyGoldFilter() end

--- Clear the script filter that controls what rune spawns.
--- 
--- (availability: server)
--- @return nil
function CDOTABaseGameMode:ClearRuneSpawnFilter() end

--- Clear the script filter that controls when tracking projectiles are launched.
--- 
--- (availability: server)
--- @return nil
function CDOTABaseGameMode:ClearTrackingProjectileFilter() end

--- Disable npc_dota_creature clumping behavior by default.
--- 
--- (availability: server)
--- @param disabled boolean
--- @return nil
function CDOTABaseGameMode:DisableClumpingBehaviorByDefault(disabled) end

--- Use to disable hud flip for this mod.
--- 
--- (availability: server)
--- @param disable boolean
--- @return nil
function CDOTABaseGameMode:DisableHudFlip(disable) end

--- Bool bEnabled.
--- 
--- (availability: server)
--- @param enabled boolean
--- @return nil
function CDOTABaseGameMode:EnableAbilityUpgradeWhitelist(enabled) end

--- Show the player hero's inventory in the HUD, regardless of what unit is selected.
--- 
--- (availability: server)
--- @return boolean
function CDOTABaseGameMode:GetAlwaysShowPlayerInventory() end

--- Get whether player names are always shown, regardless of client setting.
--- 
--- (availability: server)
--- @return boolean
function CDOTABaseGameMode:GetAlwaysShowPlayerNames() end

--- Are in-game announcers disabled?
--- 
--- (availability: server)
--- @return boolean
function CDOTABaseGameMode:GetAnnouncerDisabled() end

--- Is the announcer announcing the mode / saying Choose Your Hero on start of custom games disabled?
--- 
--- (availability: server)
--- @return boolean
function CDOTABaseGameMode:GetAnnouncerGameModeAnnounceDisabled() end

--- Set a different camera distance; dota default is 1134.
--- 
--- (availability: server)
--- @return number
function CDOTABaseGameMode:GetCameraDistanceOverride() end

--- Get current derived stat value constant.
--- 
--- (availability: server)
--- @param derivedStatType AttributeDerivedStats
--- @return number
function CDOTABaseGameMode:GetCustomAttributeDerivedStatValue(derivedStatType) end

--- Get the current rate cooldown ticks down for items in the backpack.
--- 
--- (availability: server)
--- @return number
function CDOTABaseGameMode:GetCustomBackpackCooldownPercent() end

--- Get the current custom backpack swap cooldown.
--- 
--- (availability: server)
--- @return number
function CDOTABaseGameMode:GetCustomBackpackSwapCooldown() end

--- Turns on capability to define custom buyback cooldowns.
--- 
--- (availability: server)
--- @return boolean
function CDOTABaseGameMode:GetCustomBuybackCooldownEnabled() end

--- Turns on capability to define custom buyback costs.
--- 
--- (availability: server)
--- @return boolean
function CDOTABaseGameMode:GetCustomBuybackCostEnabled() end

--- Get the topbar score display value for dire.
--- 
--- (availability: server)
--- @return integer
function CDOTABaseGameMode:GetCustomDireScore() end

--- Get the current custom glyph cooldown.
--- 
--- (availability: server)
--- @return number
function CDOTABaseGameMode:GetCustomGlyphCooldown() end

--- Allows definition of the max level heroes can achieve (default is 25).
--- 
--- (availability: server)
--- @return integer
function CDOTABaseGameMode:GetCustomHeroMaxLevel() end

--- Get the topbar score display value for radiant.
--- 
--- (availability: server)
--- @return integer
function CDOTABaseGameMode:GetCustomRadiantScore() end

--- Get the current custom scan cooldown.
--- 
--- (availability: server)
--- @return number
function CDOTABaseGameMode:GetCustomScanCooldown() end

--- Get the rate at which the day/night cycle advances (1.0 = default).
--- 
--- (availability: server)
--- @return number
function CDOTABaseGameMode:GetDaynightCycleAdvanceRate() end

--- Get the Game Seed passed from the GC.
--- 
--- (availability: server)
--- @return integer
function CDOTABaseGameMode:GetEventGameSeed() end

--- Get the Event Window Start Time passed from the GC.
--- 
--- (availability: server)
--- @return integer
function CDOTABaseGameMode:GetEventWindowStartTime() end

--- Gets the fixed respawn time.
--- 
--- (availability: server)
--- @return number
function CDOTABaseGameMode:GetFixedRespawnTime() end

--- Turn the fog of war on or off.
--- 
--- (availability: server)
--- @return boolean
function CDOTABaseGameMode:GetFogOfWarDisabled() end

--- Turn the sound when gold is acquired off/on.
--- 
--- (availability: server)
--- @return boolean
function CDOTABaseGameMode:GetGoldSoundDisabled() end

--- Returns the HUD element visibility.
--- 
--- (availability: server)
--- @param element integer
--- @return boolean
function CDOTABaseGameMode:GetHUDVisible(element) end

--- Get the maximum attack speed for units.
--- 
--- (availability: server)
--- @return integer
function CDOTABaseGameMode:GetMaximumAttackSpeed() end

--- Get the minimum attack speed for units.
--- 
--- (availability: server)
--- @return integer
function CDOTABaseGameMode:GetMinimumAttackSpeed() end

--- Turn the panel for showing recommended items at the shop off/on.
--- 
--- (availability: server)
--- @return boolean
function CDOTABaseGameMode:GetRecommendedItemsDisabled() end

--- Returns the scale applied to non-fixed respawn times.
--- 
--- (availability: server)
--- @return number
function CDOTABaseGameMode:GetRespawnTimeScale() end

--- Turn purchasing items to the stash off/on. If purchasing to the stash is off the player must be at a shop to purchase items.
--- 
--- (availability: server)
--- @return boolean
function CDOTABaseGameMode:GetStashPurchasingDisabled() end

--- Hide the sticky item in the quickbuy.
--- 
--- (availability: server)
--- @return boolean
function CDOTABaseGameMode:GetStickyItemDisabled() end

--- Override the values of the team values on the top game bar.
--- 
--- (availability: server)
--- @return boolean
function CDOTABaseGameMode:GetTopBarTeamValuesOverride() end

--- Turning on/off the team values on the top game bar.
--- 
--- (availability: server)
--- @return boolean
function CDOTABaseGameMode:GetTopBarTeamValuesVisible() end

--- Gets whether tower backdoor protection is enabled or not.
--- 
--- (availability: server)
--- @return boolean
function CDOTABaseGameMode:GetTowerBackdoorProtectionEnabled() end

--- Are custom-defined XP values for hero level ups in use?
--- 
--- (availability: server)
--- @return boolean
function CDOTABaseGameMode:GetUseCustomHeroLevels() end

--- Gets the time from game start during which water runes spawn.
--- 
--- (availability: server)
--- @return number
function CDOTABaseGameMode:GetWaterRuneLastSpawnTime() end

--- Const char* pszAbilityName.
--- 
--- (availability: server)
--- @param abilityName string
--- @return boolean
function CDOTABaseGameMode:IsAbilityUpgradeWhitelisted(abilityName) end

--- Enables or disables buyback completely.
--- 
--- (availability: server)
--- @return boolean
function CDOTABaseGameMode:IsBuybackEnabled() end

--- Is the day/night cycle disabled?
--- 
--- (availability: server)
--- @return boolean
function CDOTABaseGameMode:IsDaynightCycleDisabled() end

--- Set function and context for real time combat analyzer query failed.
--- 
--- (availability: server)
--- @param fn fun(result: CombatAnalyzerQueryResult): nil
--- @param context table
--- @return nil
function CDOTABaseGameMode:ListenForQueryFailed(fn, context) end

--- Set function and context for real time combat analyzer query progress changed.
--- 
--- (availability: server)
--- @param fn fun(result: CombatAnalyzerQueryResult): nil
--- @param context table
--- @return nil
function CDOTABaseGameMode:ListenForQueryProgressChanged(fn, context) end

--- Set function and context for real time combat analyzer query succeeded.
--- 
--- (availability: server)
--- @param fn fun(result: CombatAnalyzerQueryResult): nil
--- @param context table
--- @return nil
function CDOTABaseGameMode:ListenForQuerySucceeded(fn, context) end

--- Const char* pszAbilityName.
--- 
--- (availability: server)
--- @param abilityName string
--- @return nil
function CDOTABaseGameMode:RemoveAbilityUpgradeFromWhitelist(abilityName) end

--- Remove an item to purchase at a custom shop.
--- 
--- (availability: server)
--- @param itemName string
--- @param shopName string
--- @return nil
function CDOTABaseGameMode:RemoveItemFromCustomShop(itemName, shopName) end

--- Stop tracking a combat analyzer query.
--- 
--- (availability: server)
--- @param queryId CombatAnalyzerQueryID
--- @return nil
function CDOTABaseGameMode:RemoveRealTimeCombatAnalyzerQuery(queryId) end

--- Set a filter function to control the tuning values that abilities use. (Modify the table and Return true to use new values, return false to use the old values).
--- 
--- (availability: server)
--- @param filterFunc fun(event: AbilityTuningValueFilterEvent): boolean
--- @param context table
--- @return nil
function CDOTABaseGameMode:SetAbilityTuningValueFilter(filterFunc, context) end

--- If set to true, neutral items will be dropped on killing neutral monsters.  Otherwise nothing will be dropped.
--- 
--- (availability: server)
--- @param enabled boolean
--- @return nil
function CDOTABaseGameMode:SetAllowNeutralItemDrops(enabled) end

--- Show the player hero's inventory in the HUD, regardless of what unit is selected.
--- 
--- (availability: server)
--- @param alwaysShow boolean
--- @return nil
function CDOTABaseGameMode:SetAlwaysShowPlayerInventory(alwaysShow) end

--- Set whether player names are always shown, regardless of client setting.
--- 
--- (availability: server)
--- @param enabled boolean
--- @return nil
function CDOTABaseGameMode:SetAlwaysShowPlayerNames(enabled) end

--- Mutes the in-game announcer.
--- 
--- (availability: server)
--- @param disabled boolean
--- @return nil
function CDOTABaseGameMode:SetAnnouncerDisabled(disabled) end

--- Disables the announcer announcing the mode / saying Choose Your Hero on start of custom games.
--- 
--- (availability: server)
--- @param disabled boolean
--- @return nil
function CDOTABaseGameMode:SetAnnouncerGameModeAnnounceDisabled(disabled) end

--- Set if the bots should try their best to push with a human player.
--- 
--- (availability: server)
--- @param alwaysPush boolean
--- @return nil
function CDOTABaseGameMode:SetBotsAlwaysPushWithHuman(alwaysPush) end

--- Set if bots should enable their late game behavior.
--- 
--- (availability: server)
--- @param lateGame boolean
--- @return nil
function CDOTABaseGameMode:SetBotsInLateGame(lateGame) end

--- Set the max tier of tower that bots want to push. (-1 to disable).
--- 
--- (availability: server)
--- @param maxTier integer
--- @return nil
function CDOTABaseGameMode:SetBotsMaxPushTier(maxTier) end

--- Enables/Disables bots in custom games. Note: this will only work with default heroes in the dota map.
--- 
--- (availability: server)
--- @param enabled boolean
--- @return nil
function CDOTABaseGameMode:SetBotThinkingEnabled(enabled) end

--- Set a filter function to control the behavior when a bounty rune is picked up. (Modify the table and Return true to use new values, return false to cancel the event).
--- 
--- (availability: server)
--- @param filterFunc fun(event: BountyRunePickupFilterEvent): boolean
--- @param context table
--- @return nil
function CDOTABaseGameMode:SetBountyRunePickupFilter(filterFunc, context) end

--- Set bounty rune spawn rate.
--- 
--- (availability: server)
--- @param interval number
--- @return nil
function CDOTABaseGameMode:SetBountyRuneSpawnInterval(interval) end

--- Enables or disables buyback completely.
--- 
--- (availability: server)
--- @param enabled boolean
--- @return nil
function CDOTABaseGameMode:SetBuybackEnabled(enabled) end

--- Set a different camera distance; dota default is 1134.
--- 
--- (availability: server)
--- @param cameraDistanceOverride number
--- @return nil
function CDOTABaseGameMode:SetCameraDistanceOverride(cameraDistanceOverride) end

--- Set a different camera smooth count; dota default is 8.
--- 
--- (availability: server)
--- @param smoothCount integer
--- @return nil
function CDOTABaseGameMode:SetCameraSmoothCountOverride(smoothCount) end

--- Sets the camera Z range.
--- 
--- (availability: server)
--- @param minZ number
--- @param maxZ number
--- @return nil
function CDOTABaseGameMode:SetCameraZRange(minZ, maxZ) end

--- Bool bAllow.
--- 
--- (availability: server)
--- @param allow boolean
--- @return nil
function CDOTABaseGameMode:SetCanSellAnywhere(allow) end

--- Modify derived stat value constants.
--- 
--- (availability: server)
--- @param statType AttributeDerivedStats
--- @param newValue number
--- @return nil
function CDOTABaseGameMode:SetCustomAttributeDerivedStatValue(statType, newValue) end

--- Set the rate cooldown ticks down for items in the backpack.
--- 
--- (availability: server)
--- @param percent number
--- @return nil
function CDOTABaseGameMode:SetCustomBackpackCooldownPercent(percent) end

--- Set a custom cooldown for swapping items into the backpack.
--- 
--- (availability: server)
--- @param cooldown number
--- @return nil
function CDOTABaseGameMode:SetCustomBackpackSwapCooldown(cooldown) end

--- Turns on capability to define custom buyback cooldowns.
--- 
--- (availability: server)
--- @param enabled boolean
--- @return nil
function CDOTABaseGameMode:SetCustomBuybackCooldownEnabled(enabled) end

--- Turns on capability to define custom buyback costs.
--- 
--- (availability: server)
--- @param enabled boolean
--- @return nil
function CDOTABaseGameMode:SetCustomBuybackCostEnabled(enabled) end

--- Sets the topbar score display value for dire.
--- 
--- (availability: server)
--- @param score integer
--- @return nil
function CDOTABaseGameMode:SetCustomDireScore(score) end

--- Force all players to use the specified hero and disable the normal hero selection process. Must be used before hero selection.
--- 
--- (availability: server)
--- @param heroName string
--- @return nil
function CDOTABaseGameMode:SetCustomGameForceHero(heroName) end

--- Set a custom cooldown for team Glyph ability.
--- 
--- (availability: server)
--- @param cooldown number
--- @return nil
function CDOTABaseGameMode:SetCustomGlyphCooldown(cooldown) end

--- Allows definition of the max level heroes can achieve (default is 25).
--- 
--- (availability: server)
--- @param maxLevel integer
--- @return nil
function CDOTABaseGameMode:SetCustomHeroMaxLevel(maxLevel) end

--- Sets the topbar score display value for radiant.
--- 
--- (availability: server)
--- @param score integer
--- @return nil
function CDOTABaseGameMode:SetCustomRadiantScore(score) end

--- Set a custom cooldown for team Scan ability.
--- 
--- (availability: server)
--- @param cooldown number
--- @return nil
function CDOTABaseGameMode:SetCustomScanCooldown(cooldown) end

--- Set a custom max charges for team Scan ability.
--- 
--- (availability: server)
--- @param maxCharges integer
--- @return nil
function CDOTABaseGameMode:SetCustomScanMaxCharges(maxCharges) end

--- Set the effect used as a custom weather effect, when units are on non-default terrain, in this mode.
--- 
--- (availability: server)
--- @param effectName string
--- @return nil
function CDOTABaseGameMode:SetCustomTerrainWeatherEffect(effectName) end

--- Allows definition of a table of hero XP values.
--- Requires `SetUseCustomHeroLevels` to be enabled.
--- 
--- (availability: server)
--- @param t { [integer]: integer }
--- @return nil
function CDOTABaseGameMode:SetCustomXPRequiredToReachNextLevel(t) end

--- Set a filter function to control the behavior when a unit takes damage. (Modify the table and Return true to use new values, return false to cancel the event).
--- 
--- (availability: server)
--- @param filterFunc fun(event: DamageFilterEvent): boolean
--- @param context table
--- @return nil
function CDOTABaseGameMode:SetDamageFilter(filterFunc, context) end

--- Sets the rate at which the day/night cycle advances (1.0 = default).
--- 
--- (availability: server)
--- @param rate number
--- @return nil
function CDOTABaseGameMode:SetDaynightCycleAdvanceRate(rate) end

--- Enable or disable the day/night cycle.
--- 
--- (availability: server)
--- @param disable boolean
--- @return nil
function CDOTABaseGameMode:SetDaynightCycleDisabled(disable) end

--- Specify whether the full screen death overlay effect plays when the selected hero dies.
--- 
--- (availability: server)
--- @param disabled boolean
--- @return nil
function CDOTABaseGameMode:SetDeathOverlayDisabled(disabled) end

--- Disables chat tips on death.
--- 
--- (availability: server)
--- @param disabled boolean
--- @return nil
function CDOTABaseGameMode:SetDeathTipsDisabled(disabled) end

--- Sets the default sticky item in the quickbuy.
--- 
--- (availability: server)
--- @param item string
--- @return nil
function CDOTABaseGameMode:SetDefaultStickyItem(item) end

--- Set drafting hero banning time.
--- 
--- (availability: server)
--- @param value number
--- @return nil
function CDOTABaseGameMode:SetDraftingBanningTimeOverride(value) end

--- Set drafting hero pick time.
--- 
--- (availability: server)
--- @param value number
--- @return nil
function CDOTABaseGameMode:SetDraftingHeroPickSelectTimeOverride(value) end

--- Set a filter function to control the behavior when a unit picks up an item. (Modify the table and Return true to use new values, return false to cancel the event).
--- 
--- (availability: server)
--- @param filterFunc fun(event: ExecuteOrderFilterEvent): boolean
--- @param context table
--- @return nil
function CDOTABaseGameMode:SetExecuteOrderFilter(filterFunc, context) end

--- Set a fixed delay for all players to respawn after.
--- 
--- (availability: server)
--- @param fixedRespawnTime number
--- @return nil
function CDOTABaseGameMode:SetFixedRespawnTime(fixedRespawnTime) end

--- Turn the fog of war on or off.
--- 
--- (availability: server)
--- @param disabled boolean
--- @return nil
function CDOTABaseGameMode:SetFogOfWarDisabled(disabled) end

--- Specify a HUD skin that is forced on for this game mode.
--- 
--- (availability: server)
--- @param value string
--- @return nil
function CDOTABaseGameMode:SetForcedHUDSkin(value) end

--- Prevent users from using the right click deny setting.
--- 
--- (availability: server)
--- @param disabled boolean
--- @return nil
function CDOTABaseGameMode:SetForceRightClickAttackDisabled(disabled) end

--- Set the constant rate that the fountain will regen mana. (-1 for default).
--- 
--- (availability: server)
--- @param constantManaRegen number
--- @return nil
function CDOTABaseGameMode:SetFountainConstantManaRegen(constantManaRegen) end

--- Set the percentage rate that the fountain will regen health. (-1 for default).
--- 
--- (availability: server)
--- @param percentageHealthRegen number
--- @return nil
function CDOTABaseGameMode:SetFountainPercentageHealthRegen(percentageHealthRegen) end

--- Set the percentage rate that the fountain will regen mana. (-1 for default).
--- 
--- (availability: server)
--- @param percentageManaRegen number
--- @return nil
function CDOTABaseGameMode:SetFountainPercentageManaRegen(percentageManaRegen) end

--- If set to true, enable 7.23 free courier mode.
--- 
--- (availability: server)
--- @param enabled boolean
--- @return nil
function CDOTABaseGameMode:SetFreeCourierModeEnabled(enabled) end

--- Allows clicks on friendly buildings to be handled normally.
--- 
--- (availability: server)
--- @param enabled boolean
--- @return nil
function CDOTABaseGameMode:SetFriendlyBuildingMoveToEnabled(enabled) end

--- Bool bGive.
--- 
--- (availability: server)
--- @param give boolean
--- @return nil
function CDOTABaseGameMode:SetGiveFreeTPOnDeath(give) end

--- Turn the sound when gold is acquired off/on.
--- 
--- (availability: server)
--- @param disabled boolean
--- @return nil
function CDOTABaseGameMode:SetGoldSoundDisabled(disabled) end

--- Set a filter function to control the behavior when a unit heals. (Modify the table and Return true to use new values, return false to cancel the event).
--- 
--- (availability: server)
--- @param filterFunc fun(event: HealingFilterEvent): boolean
--- @param context table
--- @return nil
function CDOTABaseGameMode:SetHealingFilter(filterFunc, context) end

--- Specify whether the default combat events will show in the HUD.
--- 
--- (availability: server)
--- @param disabled boolean
--- @return nil
function CDOTABaseGameMode:SetHudCombatEventsDisabled(disabled) end

--- Set the HUD element visibility.
--- 
--- (availability: server)
--- @param hudElement DOTAHUDVisibility_t
--- @param visible boolean
--- @return nil
function CDOTABaseGameMode:SetHUDVisible(hudElement, visible) end

--- Set the amount blocked innately by melee heroes.
--- 
--- (availability: server)
--- @param amount integer
--- @return nil
function CDOTABaseGameMode:SetInnateMeleeDamageBlockAmount(amount) end

--- Set the percent chance a melee hero will innately block damage.
--- 
--- (availability: server)
--- @param percent integer
--- @return nil
function CDOTABaseGameMode:SetInnateMeleeDamageBlockPercent(percent) end

--- Set the amount innately blocked by melee heroes gained per level.
--- 
--- (availability: server)
--- @param perLevelAmount integer
--- @return nil
function CDOTABaseGameMode:SetInnateMeleeDamageBlockPerLevelAmount(perLevelAmount) end

--- Set a filter function to control what happens to items that are added to an inventory, return false to cancel the event.
--- 
--- (availability: server)
--- @param filterFunc fun(event: ItemAddedToInventoryFilterEvent): boolean
--- @param context table
--- @return nil
function CDOTABaseGameMode:SetItemAddedToInventoryFilter(filterFunc, context) end

--- Set whether tombstones can be channeled to be removed by enemy heroes.
--- 
--- (availability: server)
--- @param enabled boolean
--- @return nil
function CDOTABaseGameMode:SetKillableTombstones(enabled) end

--- Mutes the in-game killing spree announcer.
--- 
--- (availability: server)
--- @param disabled boolean
--- @return nil
function CDOTABaseGameMode:SetKillingSpreeAnnouncerDisabled(disabled) end

--- Use to disable gold loss on death.
--- 
--- (availability: server)
--- @param enabled boolean
--- @return nil
function CDOTABaseGameMode:SetLoseGoldOnDeath(enabled) end

--- Set the maximum attack speed for units.
--- 
--- (availability: server)
--- @param maxSpeed integer
--- @return nil
function CDOTABaseGameMode:SetMaximumAttackSpeed(maxSpeed) end

--- Set the minimum attack speed for units.
--- 
--- (availability: server)
--- @param minSpeed integer
--- @return nil
function CDOTABaseGameMode:SetMinimumAttackSpeed(minSpeed) end

--- Set a filter function to control modifiers that are gained, return false to destroy modifier.
--- 
--- (availability: server)
--- @param filterFunc fun(event: ModifierGainedFilterEvent): boolean
--- @param context table
--- @return nil
function CDOTABaseGameMode:SetModifierGainedFilter(filterFunc, context) end

--- Set a filter function to control the behavior when a hero's experience is modified. (Modify the table and Return true to use new values, return false to cancel the event).
--- 
--- (availability: server)
--- @param filterFunc fun(event: ModifyExperienceFilterEvent): boolean
--- @param context table
--- @return nil
function CDOTABaseGameMode:SetModifyExperienceFilter(filterFunc, context) end

--- Set a filter function to control the behavior when a hero's gold is modified. (Modify the table and Return true to use new values, return false to cancel the event).
--- 
--- (availability: server)
--- @param filterFunc fun(event: ModifyGoldFilterEvent): boolean
--- @param context table
--- @return nil
function CDOTABaseGameMode:SetModifyGoldFilter(filterFunc, context) end

--- When enabled, undiscovered items in the neutral item stash are hidden.
--- 
--- (availability: server)
--- @param enable boolean
--- @return nil
function CDOTABaseGameMode:SetNeutralItemHideUndiscoveredEnabled(enable) end

--- Allow items to be sent to the neutral stash.
--- 
--- (availability: server)
--- @param enable boolean
--- @return nil
function CDOTABaseGameMode:SetNeutralStashEnabled(enable) end

--- When enabled, the all neutral items tab cannot be viewed.
--- 
--- (availability: server)
--- @param enable boolean
--- @return nil
function CDOTABaseGameMode:SetNeutralStashTeamViewOnlyEnabled(enable) end

--- Set an override for the default selection entity, instead of each player's hero.
--- 
--- (availability: server)
--- @param overrideEntity CDOTA_BaseNPC | nil
--- @return nil
function CDOTABaseGameMode:SetOverrideSelectionEntity(overrideEntity) end

--- Set pausing enabled/disabled.
--- 
--- (availability: server)
--- @param enabled boolean
--- @return nil
function CDOTABaseGameMode:SetPauseEnabled(enabled) end

--- Bool bFilter.
--- 
--- (availability: server)
--- @param filter boolean
--- @return nil
function CDOTABaseGameMode:SetPlayerHeroAvailabilityFiltered(filter) end

--- Set power rune spawn rate.
--- 
--- (availability: server)
--- @param interval number
--- @return nil
function CDOTABaseGameMode:SetPowerRuneSpawnInterval(interval) end

--- Disables bonus items for randoming a hero.
--- 
--- (availability: server)
--- @param disabled boolean
--- @return nil
function CDOTABaseGameMode:SetRandomHeroBonusItemGrantDisabled(disabled) end

--- Turn the panel for showing recommended items at the shop off/on.
--- 
--- (availability: server)
--- @param disabled boolean
--- @return nil
function CDOTABaseGameMode:SetRecommendedItemsDisabled(disabled) end

--- Make it so illusions are immediately removed upon death, rather than sticking around for a few seconds.
--- 
--- (availability: server)
--- @param remove boolean
--- @return nil
function CDOTABaseGameMode:SetRemoveIllusionsOnDeath(remove) end

--- Sets the scale applied to non-fixed respawn times. 1 = default DOTA respawn calculations.
--- 
--- (availability: server)
--- @param value number
--- @return nil
function CDOTABaseGameMode:SetRespawnTimeScale(value) end

--- Set if a given type of rune is enabled.
--- 
--- (availability: server)
--- @param rune DOTA_RUNES
--- @param enabled boolean
--- @return nil
function CDOTABaseGameMode:SetRuneEnabled(rune, enabled) end

--- Set a filter function to control what rune spawns. (Modify the table and Return true to use new values, return false to cancel the event).
--- 
--- (availability: server)
--- @param filterFunc fun(event: RuneSpawnFilterEvent): boolean
--- @param context table
--- @return nil
function CDOTABaseGameMode:SetRuneSpawnFilter(filterFunc, context) end

--- Enable/disable gold penalty for late picking.
--- 
--- (availability: server)
--- @param enabled boolean
--- @return nil
function CDOTABaseGameMode:SetSelectionGoldPenaltyEnabled(enabled) end

--- Allow items to be sent to the stash.
--- 
--- (availability: server)
--- @param enable boolean
--- @return nil
function CDOTABaseGameMode:SetSendToStashEnabled(enable) end

--- Turn purchasing items to the stash off/on. If purchasing to the stash is off the player must be at a shop to purchase items.
--- 
--- (availability: server)
--- @param disabled boolean
--- @return nil
function CDOTABaseGameMode:SetStashPurchasingDisabled(disabled) end

--- Hide the sticky item in the quickbuy.
--- 
--- (availability: server)
--- @param disabled boolean
--- @return nil
function CDOTABaseGameMode:SetStickyItemDisabled(disabled) end

--- Set the team values on the top game bar.
--- 
--- (availability: server)
--- @param team DOTATeam_t
--- @param value integer
--- @return nil
function CDOTABaseGameMode:SetTopBarTeamValue(team, value) end

--- Override the values of the team values on the top game bar.
--- 
--- (availability: server)
--- @param override boolean
--- @return nil
function CDOTABaseGameMode:SetTopBarTeamValuesOverride(override) end

--- Turning on/off the team values on the top game bar.
--- 
--- (availability: server)
--- @param visible boolean
--- @return nil
function CDOTABaseGameMode:SetTopBarTeamValuesVisible(visible) end

--- Enables/Disables tower backdoor protection.
--- 
--- (availability: server)
--- @param enabled boolean
--- @return nil
function CDOTABaseGameMode:SetTowerBackdoorProtectionEnabled(enabled) end

--- Sets the item which goes in the TP scroll slot.
--- 
--- (availability: server)
--- @param itemName string
--- @return nil
function CDOTABaseGameMode:SetTPScrollSlotItemOverride(itemName) end

--- Set a filter function to control when tracking projectiles are launched. (Modify the table and Return true to use new values, return false to cancel the event).
--- 
--- (availability: server)
--- @param filterFunc fun(event: TrackingProjectileFilterEvent): boolean
--- @param context table
--- @return nil
function CDOTABaseGameMode:SetTrackingProjectileFilter(filterFunc, context) end

--- Enable or disable unseen fog of war. When enabled parts of the map the player has never seen will be completely hidden by fog of war.
--- 
--- (availability: server)
--- @param enabled boolean
--- @return nil
function CDOTABaseGameMode:SetUnseenFogOfWarEnabled(enabled) end

--- Turn on custom-defined XP values for hero level ups.  The table should be defined before switching this on.
--- 
--- (availability: server)
--- @param enabled boolean
--- @return nil
function CDOTABaseGameMode:SetUseCustomHeroLevels(enabled) end

--- If set to true, use current rune spawn rules.  Either setting respects custom spawn intervals.
--- 
--- (availability: server)
--- @param enabled boolean
--- @return nil
function CDOTABaseGameMode:SetUseDefaultDOTARuneSpawnLogic(enabled) end

--- Enables or disables turbo couriers.
--- 
--- (availability: server)
--- @param enabled boolean
--- @return nil
function CDOTABaseGameMode:SetUseTurboCouriers(enabled) end

--- Sets the time from game start during which water runes spawn.
--- 
--- (availability: server)
--- @param value number
--- @return nil
function CDOTABaseGameMode:SetWaterRuneLastSpawnTime(value) end

--- Set if weather effects are disabled.
--- 
--- (availability: server)
--- @param disable boolean
--- @return nil
function CDOTABaseGameMode:SetWeatherEffectsDisabled(disable) end

--- Set xp rune spawn rate.
--- 
--- (availability: server)
--- @param interval number
--- @return nil
function CDOTABaseGameMode:SetXPRuneSpawnInterval(interval) end

--- (availability: server)
--- @return boolean
function CDOTABaseGameMode:ShouldGiveFreeTPOnDeath() end


--- @class CDOTAGameManager
DOTAGameManager = {}

--- Get the hero unit.
--- 
--- (availability: server & client)
--- @param heroName string
--- @return table
function DOTAGameManager:GetHeroDataByName_Script(heroName) end

--- Get the hero ID given the hero name.
--- 
--- (availability: server & client)
--- @param heroName string
--- @return integer
function DOTAGameManager:GetHeroIDByName(heroName) end

--- Get the localization token for the given hero ID.
--- 
--- (availability: server & client)
--- @param arg1 integer
--- @return string
function DOTAGameManager:GetHeroLocTokenByID(arg1) end

--- Get the hero name given a hero ID.
--- 
--- (availability: server & client)
--- @param heroId integer
--- @return string
function DOTAGameManager:GetHeroNameByID(heroId) end

--- Get the hero name given a unit name.
--- 
--- (availability: server & client)
--- @param unitName string
--- @return string
function DOTAGameManager:GetHeroNameForUnitName(unitName) end

--- Get the hero unit name given the hero ID.
--- 
--- (availability: server & client)
--- @param heroId integer
--- @return string
function DOTAGameManager:GetHeroUnitNameByID(heroId) end


--- @class CDOTAGameRules
GameRules = {}

--- Spawn a bot player of the passed hero name, player name, and team.
--- 
--- (availability: server)
--- @param heroName string
--- @param playerName string
--- @param team DOTATeam_t
--- @param entityScript string Path to a script file executed in the context of spawned hero entity.
--- @param arg5 boolean
--- @return CDOTA_BaseNPC_Hero | nil
function GameRules:AddBotPlayerWithEntityScript(heroName, playerName, team, entityScript, arg5) end

--- Event-only.
--- 
--- (availability: server)
--- @param nameSuffix string
--- @param stars integer
--- @param maxStars integer
--- @param extraData1 integer
--- @param extraData2 integer
--- @param extraData3 integer
--- @param extraData4 integer
--- @param extraData5 integer
--- @param extraData6 integer
--- @return boolean
function GameRules:AddEventMetadataLeaderboardEntry(nameSuffix, stars, maxStars, extraData1, extraData2, extraData3, extraData4, extraData5, extraData6) end

--- Event-only.
--- 
--- (availability: server)
--- @param nameSuffix string
--- @param score integer
--- @param extraData1 integer
--- @param extraData2 integer
--- @param extraData3 integer
--- @param extraData4 integer
--- @param extraData5 integer
--- @param extraData6 integer
--- @return boolean
function GameRules:AddEventMetadataLeaderboardEntryRawScore(nameSuffix, score, extraData1, extraData2, extraData3, extraData4, extraData5, extraData6) end

--- Add the hero ID to the hero blacklist if it is not already present.
--- 
--- (availability: server)
--- @param arg1 integer
--- @return nil
function GameRules:AddHeroIDToBlacklist(arg1) end

--- Add the hero ID to the hero whitelist if it is not already present.
--- 
--- (availability: server)
--- @param arg1 integer
--- @return nil
function GameRules:AddHeroIDToWhitelist(arg1) end

--- Add the hero to the hero blacklist if it is not already present.
--- 
--- (availability: server)
--- @param arg1 string
--- @return nil
function GameRules:AddHeroToBlacklist(arg1) end

--- Adds hero of given ID to available heroes of player of given ID.
--- 
--- (availability: server)
--- @param arg1 integer
--- @param arg2 integer
--- @return nil
function GameRules:AddHeroToPlayerAvailability(arg1, arg2) end

--- Add the hero to the hero whitelist if it is not already present.
--- 
--- (availability: server)
--- @param arg1 string
--- @return nil
function GameRules:AddHeroToWhitelist(arg1) end

--- Add an item to the whitelist.
--- 
--- (availability: server)
--- @param itemName string
--- @return nil
function GameRules:AddItemToWhiteList(itemName) end

--- Add a point on the minimap.
--- 
--- (availability: server)
--- @param arg1 integer
--- @param arg2 Vector
--- @param arg3 integer
--- @param arg4 integer
--- @param arg5 integer
--- @param arg6 integer
--- @param arg7 number
--- @return nil
function GameRules:AddMinimapDebugPoint(arg1, arg2, arg3, arg4, arg5, arg6, arg7) end

--- Add a point on the minimap for a specific team.
--- 
--- (availability: server)
--- @param arg1 integer
--- @param arg2 Vector
--- @param arg3 integer
--- @param arg4 integer
--- @param arg5 integer
--- @param arg6 integer
--- @param arg7 number
--- @param arg8 integer
--- @return nil
function GameRules:AddMinimapDebugPointForTeam(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8) end

--- Begin night stalker night.
--- 
--- (availability: server)
--- @param duration number
--- @return nil
function GameRules:BeginNightstalkerNight(duration) end

--- Begin temporary night.
--- 
--- (availability: server)
--- @param duration number
--- @return nil
function GameRules:BeginTemporaryNight(duration) end

--- Fills all the teams with bots if cheat mode is enabled.
--- 
--- (availability: server)
--- @return nil
function GameRules:BotPopulate() end

--- Clears the hero blacklist.
--- 
--- (availability: server)
--- @return nil
function GameRules:ClearHeroBlacklist() end

--- Clears the hero whitelist.
--- 
--- (availability: server)
--- @return nil
function GameRules:ClearHeroWhitelist() end

--- Clears available heroes of player of given ID.
--- 
--- (availability: server)
--- @param arg1 integer
--- @return nil
function GameRules:ClearPlayerHeroAvailability(arg1) end

--- Clears the current river paint.
--- 
--- (availability: server)
--- @return nil
function GameRules:ClearRiverPaint() end

--- Kills the ancient, etc.
--- 
--- (availability: server)
--- @return nil
function GameRules:Defeated() end

--- True when we have waited some time after end of the game and not received signout.
--- 
--- (availability: server)
--- @return boolean
function GameRules:DidMatchSignoutTimeOut() end

--- Enabled (true) or disable (false) auto launch for custom game setup.
--- 
--- (availability: server)
--- @param enabled boolean
--- @return nil
function GameRules:EnableCustomGameSetupAutoLaunch(enabled) end

--- Sends a minimap ping to all players on the team.
--- 
--- (availability: server)
--- @param team DOTATeam_t
--- @param xCoord number
--- @param yCoord number
--- @param entity CBaseEntity | nil
--- @param type 0 | 1 | 2 | 3 | 4 | 5 | 6
--- @return nil
function GameRules:ExecuteTeamPing(team, xCoord, yCoord, entity, type) end

--- Indicate that the custom game setup phase is complete, and advance to the game.
--- 
--- (availability: server)
--- @return nil
function GameRules:FinishCustomGameSetup() end

--- Spawn the next wave of creeps.
--- 
--- (availability: server)
--- @return nil
function GameRules:ForceCreepSpawn() end

--- Transition game state to DOTA_GAMERULES_STATE_GAME_IN_PROGRESS.
--- 
--- (availability: server)
--- @return nil
function GameRules:ForceGameStart() end

--- Get the announcer for a team.
--- 
--- (availability: server)
--- @param team DOTATeam_t
--- @return CDOTA_BaseNPC | nil
function GameRules:GetAnnouncer(team) end

--- Returns the hero unit names banned in this game, if any.
--- 
--- (availability: server & client)
--- @return string[]
function GameRules:GetBannedHeroes() end

--- Returns the hero unit IDs banned in this game, if any.
--- 
--- (availability: server & client)
--- @return table
function GameRules:GetBannedHeroIDs() end

--- Returns the difficulty level of the custom game mode.
--- 
--- (availability: server & client)
--- @return integer
function GameRules:GetCustomGameDifficulty() end

--- Get whether a team is selectable during game setup.
--- 
--- (availability: server)
--- @param team DOTATeam_t
--- @return integer
function GameRules:GetCustomGameTeamMaxPlayers(team) end

--- Returns difficulty level of the custom game mode.
--- 
--- (availability: server & client)
--- @return integer
function GameRules:GetDifficulty() end

--- Returns the actual DOTA in-game clock time.
--- 
--- (availability: server & client)
--- @param includePreGame boolean
--- @param includeNegativeTime boolean
--- @return number
function GameRules:GetDOTATime(includePreGame, includeNegativeTime) end

--- Gets the Xth dropped item.
--- 
--- (availability: server)
--- @param index integer
--- @return CDOTA_Item_Physical | nil
function GameRules:GetDroppedItem(index) end

--- Returns the number of seconds elapsed since the last frame was renderered. This time doesn't count up when the game is paused.
--- 
--- (availability: server & client)
--- @return number
function GameRules:GetGameFrameTime() end

--- Get the game mode entity.
--- 
--- (availability: server)
--- @return CDOTABaseGameMode
function GameRules:GetGameModeEntity() end

--- Get a string value from the game session config (map options).
--- 
--- (availability: server)
--- @param arg1 string
--- @param arg2 string
--- @return string
function GameRules:GetGameSessionConfigValue(arg1, arg2) end

--- Returns the number of seconds elapsed since map start. This time doesn't count up when the game is paused.
--- 
--- (availability: server & client)
--- @return number
function GameRules:GetGameTime() end

--- Get the time it takes to add a new item to stock.
--- 
--- (availability: server & client)
--- @param arg1 integer
--- @param arg2 string
--- @param arg3 integer
--- @return number
function GameRules:GetIetmStockDuration(arg1, arg2, arg3) end

--- Get the stock count of the item.
--- 
--- (availability: server & client)
--- @param team DOTATeam_t
--- @param itemName string
--- @param playerId PlayerID Used only for items with "PlayerSpecificCooldown"
--- @return integer
function GameRules:GetItemStockCount(team, itemName, playerId) end

--- Get the time an item will be added to stock.
--- 
--- (availability: server & client)
--- @param team DOTATeam_t
--- @param itemName string
--- @param playerId PlayerID Used only for items with "PlayerSpecificCooldown"
--- @return number
function GameRules:GetItemStockTime(team, itemName, playerId) end

--- Have we received the post match signout message that includes reward information.
--- 
--- (availability: server)
--- @return boolean
function GameRules:GetMatchSignoutComplete() end

--- Gets the extra offset to initial neutral creep spawn delay.
--- 
--- (availability: server & client)
--- @return number
function GameRules:GetNeutralInitialSpawnOffset() end

--- Gets next bounty rune spawn time.
--- 
--- (availability: server)
--- @return number
function GameRules:GetNextBountyRuneSpawnTime() end

--- Gets next rune spawn time.
--- 
--- (availability: server)
--- @return number
function GameRules:GetNextRuneSpawnTime() end

--- For New Bloom, get total damage taken by the Nian / Year Beast.
--- 
--- (availability: server)
--- @return integer
function GameRules:GetNianTotalDamageTaken() end

--- Gets the player's custom game account record, as it looked at the start of this session.
--- 
--- (availability: server)
--- @deprecated
--- @param playerId PlayerID
--- @return table
function GameRules:GetPlayerCustomGameAccountRecord(playerId) end

--- Get time remaining between state changes.
--- 
--- (availability: server)
--- @return number
function GameRules:GetStateTransitionTime() end

--- Get the time of day.
--- 
--- (availability: server)
--- @return number
function GameRules:GetTimeOfDay() end

--- Get Weather Wind Direction Vector.
--- 
--- (availability: server & client)
--- @return Vector
function GameRules:GetWeatherWindDirection() end

--- Increase an item's stock count, clamped to item max.
--- 
--- (availability: server)
--- @param team DOTATeam_t
--- @param itemName string
--- @param count integer Negative values decrease stock count.
--- @param playerId PlayerID Values other than -1 work only for items with "PlayerSpecificCooldown" property.
--- @return nil
function GameRules:IncreaseItemStock(team, itemName, count, playerId) end

--- Are cheats enabled on the server.
--- 
--- (availability: server & client)
--- @return boolean
function GameRules:IsCheatMode() end

--- Is it day time?
--- 
--- (availability: server)
--- @return boolean
function GameRules:IsDaytime() end

--- (availability: server & client)
--- @return boolean
function GameRules:IsDev() end

--- Returns whether the game is paused.
--- 
--- (availability: server)
--- @return boolean
function GameRules:IsGamePaused() end

--- Is the hero not blacklisted, and is it either whitelisted or the whitelist is empty?
--- 
--- (availability: server & client)
--- @param arg1 string
--- @return boolean
function GameRules:IsHeroEnabledViaLists(arg1) end

--- Returns whether hero respawn is enabled.
--- 
--- (availability: server)
--- @return boolean
function GameRules:IsHeroRespawnEnabled() end

--- Are we in the ban phase of hero pick?
--- 
--- (availability: server)
--- @return boolean
function GameRules:IsInBanPhase() end

--- Query an item in the whitelist.
--- 
--- (availability: server)
--- @param itemName string
--- @return boolean
function GameRules:IsItemInWhiteList(itemName) end

--- Is it night stalker night-time?
--- 
--- (availability: server)
--- @return boolean
function GameRules:IsNightstalkerNight() end

--- Returns whether Dota Plus ability suggestions are enabled or disabled.
--- 
--- (availability: server)
--- @return boolean
function GameRules:IsSuggestAbilitiesEnabled() end

--- Returns whether Dota Plus item suggestions are enabled or disabled.
--- 
--- (availability: server)
--- @return boolean
function GameRules:IsSuggestItemsEnabled() end

--- Is it temporarily night-time?
--- 
--- (availability: server)
--- @return boolean
function GameRules:IsTemporaryNight() end

--- Lock (true) or unlock (false) team assignemnt. If team assignment is locked players cannot change teams.
--- 
--- (availability: server)
--- @param locked boolean
--- @return nil
function GameRules:LockCustomGameSetupTeamAssignment(locked) end

--- Makes the specified team lose.
--- 
--- (availability: server)
--- @param team DOTATeam_t
--- @return nil
function GameRules:MakeTeamLose(team) end

--- Like ModifyGold, but will use the gold filter if SetFilterMoreGold has been set true.
--- 
--- (availability: server)
--- @param playerId PlayerID
--- @param goldChange integer
--- @param reliable boolean
--- @param reason EDOTA_ModifyGold_Reason
--- @return integer
function GameRules:ModifyGoldFiltered(playerId, goldChange, reliable, reason) end

--- Returns the number of items currently dropped on the ground.
--- 
--- (availability: server)
--- @return integer
function GameRules:NumDroppedItems() end

--- Whether a player has custom game host privileges (shuffle teams, etc.).
--- 
--- (availability: server)
--- @param player CDOTAPlayerController
--- @return boolean
function GameRules:PlayerHasCustomGameHostPrivileges(player) end

--- Updates custom hero, unit and ability KeyValues in memory with the latest values from disk.
--- 
--- (availability: server)
--- @return nil
function GameRules:Playtesting_UpdateAddOnKeyValues() end

--- Prepare Dota lane style spawners with a given interval.
--- 
--- (availability: server)
--- @param arg1 number
--- @return nil
function GameRules:PrepareSpawners(arg1) end

--- Removes a fake client.
--- 
--- (availability: server)
--- @param playerId PlayerID
--- @return nil
function GameRules:RemoveFakeClient(playerId) end

--- Remove the hero from the hero blacklist if present.
--- 
--- (availability: server)
--- @param arg1 string
--- @return nil
function GameRules:RemoveHeroFromBlacklist(arg1) end

--- Remove the hero from the hero whitelist if present.
--- 
--- (availability: server)
--- @param arg1 string
--- @return nil
function GameRules:RemoveHeroFromWhitelist(arg1) end

--- Remove the hero ID from the hero blacklist if present.
--- 
--- (availability: server)
--- @param arg1 integer
--- @return nil
function GameRules:RemoveHeroIDFromBlacklist(arg1) end

--- Remove the hero ID from the hero whitelist if present.
--- 
--- (availability: server)
--- @param arg1 integer
--- @return nil
function GameRules:RemoveHeroIDFromWhitelist(arg1) end

--- Remove an item from the whitelist.
--- 
--- (availability: server)
--- @param itemName string
--- @return nil
function GameRules:RemoveItemFromWhiteList(itemName) end

--- Restart after killing the ancient, etc.
--- 
--- (availability: server)
--- @return nil
function GameRules:ResetDefeated() end

--- Restart gametime from 0.
--- 
--- (availability: server)
--- @return nil
function GameRules:ResetGameTime() end

--- Resets the player of a given ID.
--- 
--- (availability: server)
--- @param arg1 integer
--- @return nil
function GameRules:ResetPlayer(arg1) end

--- Restart at custom game setup.
--- 
--- (availability: server)
--- @return nil
function GameRules:ResetToCustomGameSetup() end

--- Restart the game at hero selection.
--- 
--- (availability: server)
--- @return nil
function GameRules:ResetToHeroSelection() end

--- Get the MatchID for this game.
--- 
--- (availability: server)
--- @return Uint64
function GameRules:Script_GetMatchID() end

--- Sends a message on behalf of a player.
--- 
--- (availability: server)
--- @param arg1 string
--- @param arg2 integer
--- @param arg3 integer
--- @return nil
function GameRules:SendCustomMessage(arg1, arg2, arg3) end

--- Sends a message on behalf of a player to the specified team.
--- 
--- (availability: server)
--- @param arg1 string
--- @param arg2 integer
--- @param arg3 integer
--- @param arg4 integer
--- @return nil
function GameRules:SendCustomMessageToTeam(arg1, arg2, arg3, arg4) end

--- Allow Outposts granting XP.
--- 
--- (availability: server)
--- @param arg1 boolean
--- @return nil
function GameRules:SetAllowOutpostBonuses(arg1) end

--- Scale the creep icons on the minimap.
--- 
--- (availability: server)
--- @param scale number
--- @return nil
function GameRules:SetCreepMinimapIconScale(scale) end

--- Sets whether the regular Dota creeps spawn.
--- 
--- (availability: server)
--- @param arg1 boolean
--- @return nil
function GameRules:SetCreepSpawningEnabled(arg1) end

--- Sets a callback to handle saving custom game account records (callback is passed a Player ID and should return a flat simple table).
--- 
--- (availability: server)
--- @deprecated
--- @param arg1 userdata
--- @param arg2 userdata
--- @return nil
function GameRules:SetCustomGameAccountRecordSaveFunction(arg1, arg2) end

--- Sets a flag to enable/disable the default music handling code for custom games.
--- 
--- (availability: server)
--- @param allow boolean
--- @return nil
function GameRules:SetCustomGameAllowBattleMusic(allow) end

--- Sets a flag to enable/disable the default music handling code for custom games.
--- 
--- (availability: server)
--- @param allow boolean
--- @return nil
function GameRules:SetCustomGameAllowHeroPickMusic(allow) end

--- Sets a flag to enable/disable the default music handling code for custom games.
--- 
--- (availability: server)
--- @param allow boolean
--- @return nil
function GameRules:SetCustomGameAllowMusicAtGameStart(allow) end

--- Sets a flag to enable/disable the casting secondary abilities from units other than the player's own hero.
--- 
--- (availability: server)
--- @param arg1 boolean
--- @return nil
function GameRules:SetCustomGameAllowSecondaryAbilitiesOnOtherUnits(arg1) end

--- Set number of hero bans each team gets.
--- 
--- (availability: server)
--- @param arg1 integer
--- @return nil
function GameRules:SetCustomGameBansPerTeam(arg1) end

--- Set the difficulty level of the custom game mode.
--- 
--- (availability: server)
--- @param difficulty integer
--- @return nil
function GameRules:SetCustomGameDifficulty(difficulty) end

--- Sets the game end delay.
--- 
--- (availability: server)
--- @param delay number
--- @return nil
function GameRules:SetCustomGameEndDelay(delay) end

--- Set the amount of time to wait for auto launch.
--- 
--- (availability: server)
--- @param delay number
--- @return nil
function GameRules:SetCustomGameSetupAutoLaunchDelay(delay) end

--- Set the amount of remaining time, in seconds, for custom game setup. 0 = finish immediately, -1 = wait forever.
--- 
--- (availability: server)
--- @param remainingTime number
--- @return nil
function GameRules:SetCustomGameSetupRemainingTime(remainingTime) end

--- Setup (pre-gameplay) phase timeout. 0 = instant, -1 = forever (until FinishCustomGameSetup is called).
--- 
--- (availability: server)
--- @param timeout number
--- @return nil
function GameRules:SetCustomGameSetupTimeout(timeout) end

--- Set whether a team is selectable during game setup.
--- 
--- (availability: server)
--- @param team DOTATeam_t
--- @param maxPlayers integer
--- @return nil
function GameRules:SetCustomGameTeamMaxPlayers(team, maxPlayers) end

--- Sets the victory message.
--- 
--- (availability: server)
--- @param message string
--- @return nil
function GameRules:SetCustomVictoryMessage(message) end

--- Sets the victory message duration.
--- 
--- (availability: server)
--- @param duration number
--- @return nil
function GameRules:SetCustomVictoryMessageDuration(duration) end

--- Allow alternate hero grids to be used (DOTA+, etc).  True by default.
--- 
--- (availability: server)
--- @param arg1 boolean
--- @return nil
function GameRules:SetEnableAlternateHeroGrids(arg1) end

--- Event-only.
--- 
--- (availability: server)
--- @param metadataTable userdata
--- @return boolean
function GameRules:SetEventMetadataCustomTable(metadataTable) end

--- Event-only.
--- 
--- (availability: server)
--- @param metadataTable userdata
--- @return boolean
function GameRules:SetEventSignoutCustomTable(metadataTable) end

--- Sets whether to filter more gold events than normal.
--- 
--- (availability: server)
--- @param arg1 boolean
--- @return nil
function GameRules:SetFilterMoreGold(arg1) end

--- Sets whether First Blood has been triggered.
--- 
--- (availability: server)
--- @param active boolean
--- @return nil
function GameRules:SetFirstBloodActive(active) end

--- Makes the specified team win.
--- 
--- (availability: server)
--- @param team DOTATeam_t
--- @return nil
function GameRules:SetGameWinner(team) end

--- Set Glyph cooldown for team.
--- 
--- (availability: server)
--- @param team DOTATeam_t
--- @param cooldown number
--- @return nil
function GameRules:SetGlyphCooldown(team, cooldown) end

--- Set the auto gold increase per timed interval.
--- 
--- (availability: server)
--- @param amount integer
--- @return nil
function GameRules:SetGoldPerTick(amount) end

--- Set the time interval between auto gold increases.
--- 
--- (availability: server)
--- @param time number
--- @return nil
function GameRules:SetGoldTickTime(time) end

--- Scale the hero minimap icons on the minimap.
--- 
--- (availability: server)
--- @param scale number
--- @return nil
function GameRules:SetHeroMinimapIconScale(scale) end

--- Control if the normal DOTA hero respawn rules apply.
--- 
--- (availability: server)
--- @param enabled boolean
--- @return nil
function GameRules:SetHeroRespawnEnabled(enabled) end

--- Sets the amount of time players have to pick their hero.
--- 
--- (availability: server)
--- @param selectionTime number
--- @return nil
function GameRules:SetHeroSelectionTime(selectionTime) end

--- Sets amount of penalty time before randoming a hero.
--- 
--- (availability: server)
--- @param arg1 number
--- @return nil
function GameRules:SetHeroSelectPenaltyTime(arg1) end

--- Should blacklisted heroes be hidden, or just dimmed, in hero picking?
--- 
--- (availability: server)
--- @param arg1 boolean
--- @return nil
function GameRules:SetHideBlacklistedHeroes(arg1) end

--- Sets whether the multikill, streak, and first-blood banners appear at the top of the screen.
--- 
--- (availability: server)
--- @param hideHeaders boolean
--- @return nil
function GameRules:SetHideKillMessageHeaders(hideHeaders) end

--- Set whether custom and event games should ignore Lobby teams when assigning players to teams. Defaults to true.
--- 
--- (availability: server)
--- @param arg1 boolean
--- @return nil
function GameRules:SetIgnoreLobbyTeamsInCustomGame(arg1) end

--- Set the stock count of the item.
--- 
--- (availability: server)
--- @param count integer
--- @param team DOTATeam_t
--- @param itemName string
--- @param playerId PlayerID Used only for items with "PlayerSpecificCooldown"
--- @return nil
function GameRules:SetItemStockCount(count, team, itemName, playerId) end

--- Sets the extra offset to initial neutral creep spawn delay.
--- 
--- (availability: server)
--- @param arg1 number
--- @return nil
function GameRules:SetNeutralInitialSpawnOffset(arg1) end

--- Sets next bounty rune spawn time.
--- 
--- (availability: server)
--- @param arg1 number
--- @return nil
function GameRules:SetNextBountyRuneSpawnTime(arg1) end

--- Sets next rune spawn time.
--- 
--- (availability: server)
--- @param arg1 number
--- @return nil
function GameRules:SetNextRuneSpawnTime(arg1) end

--- Show this unit's health on the overlay health bar.
--- 
--- (availability: server)
--- @param unit CDOTA_BaseNPC
--- @param style integer
--- @return nil
function GameRules:SetOverlayHealthBarUnit(unit, style) end

--- Set columns to show in post game.
--- 
--- (availability: server)
--- @param arg1 userdata
--- @return boolean
function GameRules:SetPostGameColumns(arg1) end

--- Configure post game to be single or double column layout.
--- 
--- (availability: server)
--- @param arg1 integer
--- @return nil
function GameRules:SetPostGameLayout(arg1) end

--- Set score value for each team. First element is for DOTA_TEAM_GOODGUYS.
--- 
--- (availability: server)
--- @param arg1 userdata
--- @return boolean
function GameRules:SetPostGameTeamScores(arg1) end

--- Sets the amount of time players have between the game ending and the server disconnecting them.
--- 
--- (availability: server)
--- @param time number
--- @return nil
function GameRules:SetPostGameTime(time) end

--- Sets the amount of time players have between picking their hero and game start.
--- 
--- (availability: server)
--- @param time number
--- @return nil
function GameRules:SetPreGameTime(time) end

--- Paints the river for a duration.
--- 
--- (availability: server)
--- @param arg1 integer
--- @param arg2 number
--- @return nil
function GameRules:SetRiverPaint(arg1, arg2) end

--- Scale the rune icons on the minimap.
--- 
--- (availability: server)
--- @param minimapRuneIconScale number
--- @return nil
function GameRules:SetRuneMinimapIconScale(minimapRuneIconScale) end

--- Sets the amount of time between rune spawns.
--- 
--- (availability: server)
--- @param time number
--- @return nil
function GameRules:SetRuneSpawnTime(time) end

--- Mark this game as safe to leave.
--- 
--- (availability: server)
--- @param safeToLeave boolean
--- @return nil
function GameRules:SetSafeToLeave(safeToLeave) end

--- When true, players can repeatedly pick the same hero.
--- 
--- (availability: server)
--- @param enabled boolean
--- @return nil
function GameRules:SetSameHeroSelectionEnabled(enabled) end

--- Sets the amount of time players have between the strategy phase and entering the pre-game phase.
--- 
--- (availability: server)
--- @param time number
--- @return nil
function GameRules:SetShowcaseTime(time) end

--- Set whether to speak a Spawn concept instead of a Respawn concept on respawn.
--- 
--- (availability: server)
--- @param arg1 boolean
--- @return nil
function GameRules:SetSpeechUseSpawnInsteadOfRespawnConcept(arg1) end

--- Set the starting gold amount.
--- 
--- (availability: server)
--- @param amount integer
--- @return nil
function GameRules:SetStartingGold(amount) end

--- Sets the amount of time players have between the hero selection and entering the showcase phase.
--- 
--- (availability: server)
--- @param time number
--- @return nil
function GameRules:SetStrategyTime(time) end

--- Sets Dota Plus ability suggestions enabled or disabled.
--- 
--- (availability: server)
--- @param arg1 boolean
--- @return nil
function GameRules:SetSuggestAbilitiesEnabled(arg1) end

--- Sets Dota Plus ability item enabled or disabled.
--- 
--- (availability: server)
--- @param arg1 boolean
--- @return nil
function GameRules:SetSuggestItemsEnabled(arg1) end

--- Set the time of day.
--- 
--- (availability: server)
--- @param time number
--- @return nil
function GameRules:SetTimeOfDay(time) end

--- Sets the tree regrow time in seconds.
--- 
--- (availability: server)
--- @param time number
--- @return nil
function GameRules:SetTreeRegrowTime(time) end

--- Heroes will use the basic NPC functionality for determining their bounty, rather than DOTA specific formulas.
--- 
--- (availability: server)
--- @param useBaseGoldBounties boolean
--- @return nil
function GameRules:SetUseBaseGoldBountyOnHeroes(useBaseGoldBounties) end

--- Allows heroes in the map to give a specific amount of XP (this value must be set).
--- 
--- (availability: server)
--- @param useCustomXPValues boolean
--- @return nil
function GameRules:SetUseCustomHeroXPValues(useCustomXPValues) end

--- When true, all items are available at as long as any shop is in range.
--- 
--- (availability: server)
--- @param useUniversalShopMode boolean
--- @return nil
function GameRules:SetUseUniversalShopMode(useUniversalShopMode) end

--- Set Weather Wind Direction Vector.
--- 
--- (availability: server)
--- @param arg1 Vector
--- @return nil
function GameRules:SetWeatherWindDirection(arg1) end

--- Item whitelist functionality enable/disable.
--- 
--- (availability: server)
--- @param whiteListEnabled boolean
--- @return nil
function GameRules:SetWhiteListEnabled(whiteListEnabled) end

--- Are blacklisted heroes hidden, or just dimmed, in hero picking?
--- 
--- (availability: server & client)
--- @return boolean
function GameRules:ShouldHideBlacklistedHeroes() end

--- Spawn and release the next creep wave from Dota lane style spawners.
--- 
--- (availability: server)
--- @return nil
function GameRules:SpawnAndReleaseCreeps() end

--- Spawn and release the next set of neutral camps.
--- 
--- (availability: server)
--- @return nil
function GameRules:SpawnNeutralCreeps() end

--- Get the current Gamerules state.
--- 
--- (availability: server & client)
--- @return DOTA_GameState
function GameRules:State_Get() end


--- @class CDOTAPlayerController : CBaseAnimatingActivity
CDOTAPlayerController = {}

--- Attempt to spawn the appropriate couriers for this mode.
--- 
--- (availability: server)
--- @param hero CDOTA_BaseNPC_Hero
--- @return userdata
function CDOTAPlayerController:CheckForCourierSpawning(hero) end

--- (availability: client)
--- @return userdata
function CDOTAPlayerController:GetActiveAbility() end

--- Get the player's hero.
--- 
--- (availability: server)
--- @return CDOTA_BaseNPC_Hero
function CDOTAPlayerController:GetAssignedHero() end

--- (availability: client)
--- @return any
function CDOTAPlayerController:GetClickBehaviors() end

--- Get the player's official PlayerID; notably is -1 when the player isn't yet on a team.
--- 
--- (availability: server)
--- @return PlayerID
function CDOTAPlayerController:GetPlayerID() end

--- (availability: client)
--- @return userdata
function CDOTAPlayerController:GetQueryUnit() end

--- Randoms this player's hero.
--- 
--- (availability: server)
--- @return nil
function CDOTAPlayerController:MakeRandomHeroSelection() end

--- Sets this player's hero .
--- 
--- (availability: server)
--- @param hero userdata
--- @return nil
function CDOTAPlayerController:SetAssignedHeroEntity(hero) end

--- Set the kill cam unit for this hero.
--- 
--- (availability: server)
--- @param entity CDOTA_BaseNPC
--- @return nil
function CDOTAPlayerController:SetKillCamUnit(entity) end

--- Set the music status for this player, note this will only really apply if dota_music_battle_enable is off.
--- 
--- (availability: server)
--- @param musicStatus integer
--- @param intensity number
--- @return nil
function CDOTAPlayerController:SetMusicStatus(musicStatus, intensity) end

--- Sets this player's hero selection.
--- 
--- (availability: server)
--- @param heroName string
--- @return nil
function CDOTAPlayerController:SetSelectedHero(heroName) end

--- (availability: client)
--- @return boolean
function CDOTAPlayerController:ShouldDisplayInWorldUIElements() end

--- Spawn a courier for this player at the given position.
--- 
--- (availability: server)
--- @param location Vector
--- @return CDOTA_Unit_Courier
function CDOTAPlayerController:SpawnCourierAtPosition(location) end


--- @class CDotaQuest : CBaseEntity
CDotaQuest = {}

--- Add a subquest to this quest.
--- 
--- (availability: server)
--- @param subquest userdata
--- @return nil
function CDotaQuest:AddSubquest(subquest) end

--- Mark this quest complete.
--- 
--- (availability: server)
--- @return nil
function CDotaQuest:CompleteQuest() end

--- Finds a subquest from this quest by index.
--- 
--- (availability: server)
--- @param index integer
--- @return userdata
function CDotaQuest:GetSubquest(index) end

--- Finds a subquest from this quest by name.
--- 
--- (availability: server)
--- @param name string
--- @return userdata
function CDotaQuest:GetSubquestByName(name) end

--- Remove a subquest from this quest.
--- 
--- (availability: server)
--- @param subquest userdata
--- @return nil
function CDotaQuest:RemoveSubquest(subquest) end

--- Set the text replace string for this quest.
--- 
--- (availability: server)
--- @param string string
--- @return nil
function CDotaQuest:SetTextReplaceString(string) end

--- Set a quest value.
--- 
--- (availability: server)
--- @param valueSlot integer
--- @param value integer
--- @return nil
function CDotaQuest:SetTextReplaceValue(valueSlot, value) end


--- @class CDotaSubquestBase : CBaseEntity
CDotaSubquestBase = {}

--- Mark this subquest complete.
--- 
--- (availability: server)
--- @return nil
function CDotaSubquestBase:CompleteSubquest() end

--- Set the text replace string for this subquest.
--- 
--- (availability: server)
--- @param string string
--- @return nil
function CDotaSubquestBase:SetTextReplaceString(string) end

--- Set a subquest value.
--- 
--- (availability: server)
--- @param valueSlot integer
--- @param value integer
--- @return nil
function CDotaSubquestBase:SetTextReplaceValue(valueSlot, value) end


--- @class CDOTATutorial
Tutorial = {}

--- Add a computer controlled bot.
--- 
--- (availability: server)
--- @param heroName string
--- @param arg2 string
--- @param arg3 string
--- @param arg4 boolean
--- @return boolean
function Tutorial:AddBot(heroName, arg2, arg3, arg4) end

--- Add a quest to the quest log.
--- 
--- (availability: server)
--- @param arg1 string
--- @param arg2 integer
--- @param arg3 string
--- @param arg4 string
--- @return nil
function Tutorial:AddQuest(arg1, arg2, arg3, arg4) end

--- Add an item to the shop whitelist.
--- 
--- (availability: server)
--- @param itemName string
--- @return nil
function Tutorial:AddShopWhitelistItem(itemName) end

--- Complete a quest,.
--- 
--- (availability: server)
--- @param arg1 string
--- @return nil
function Tutorial:CompleteQuest(arg1) end

--- Add a task to move to a specific location.
--- 
--- (availability: server)
--- @param arg1 Vector
--- @return nil
function Tutorial:CreateLocationTask(arg1) end

--- Alert the player when a creep becomes agro to their hero.
--- 
--- (availability: server)
--- @param arg1 boolean
--- @return nil
function Tutorial:EnableCreepAggroViz(arg1) end

--- Enable the tip to alert players how to find their hero.
--- 
--- (availability: server)
--- @param arg1 boolean
--- @return nil
function Tutorial:EnablePlayerOffscreenTip(arg1) end

--- Alert the player when a tower becomes agro to their hero.
--- 
--- (availability: server)
--- @param arg1 boolean
--- @return nil
function Tutorial:EnableTowerAggroViz(arg1) end

--- End the tutorial.
--- 
--- (availability: server)
--- @return nil
function Tutorial:FinishTutorial() end

--- Force the start of the game.
--- 
--- (availability: server)
--- @return nil
function Tutorial:ForceGameStart() end

--- Is this item currently in the white list.
--- 
--- (availability: server)
--- @param itemName string
--- @return boolean
function Tutorial:IsItemInWhiteList(itemName) end

--- Remove an item from the shop whitelist.
--- 
--- (availability: server)
--- @param itemName string
--- @return nil
function Tutorial:RemoveShopWhitelistItem(itemName) end

--- Select a hero for the local player.
--- 
--- (availability: server)
--- @param heroName string
--- @return nil
function Tutorial:SelectHero(heroName) end

--- Select the team for the local player.
--- 
--- (availability: server)
--- @param arg1 string
--- @return nil
function Tutorial:SelectPlayerTeam(arg1) end

--- Set the current item guide.
--- 
--- (availability: server)
--- @param arg1 string
--- @return nil
function Tutorial:SetItemGuide(arg1) end

--- Set gold amount for the tutorial player.
--- 
--- (availability: server)
--- @param goldAmount integer
--- @param setNotModify boolean When true sets gold amount, otherwise modifies it
--- @return nil
function Tutorial:SetOrModifyPlayerGold(goldAmount, setNotModify) end

--- Set players quick buy item.
--- 
--- (availability: server)
--- @param itemName string
--- @return nil
function Tutorial:SetQuickBuy(itemName) end

--- Set the shop open or closed.
--- 
--- (availability: server)
--- @param open boolean
--- @return nil
function Tutorial:SetShopOpen(open) end

--- Set a tutorial convar.
--- 
--- (availability: server)
--- @param arg1 string
--- @param arg2 string
--- @return nil
function Tutorial:SetTutorialConvar(arg1, arg2) end

--- Set the UI to use a reduced version to focus attention to specific elements.
--- 
--- (availability: server)
--- @param arg1 integer
--- @return nil
function Tutorial:SetTutorialUI(arg1) end

--- Set if we should whitelist shop items.
--- 
--- (availability: server)
--- @param whiteListEnabled boolean
--- @return nil
function Tutorial:SetWhiteListEnabled(whiteListEnabled) end

--- Initialize Tutorial Mode.
--- 
--- (availability: server)
--- @return nil
function Tutorial:StartTutorialMode() end

--- Upgrade a specific ability for the local hero.
--- 
--- (availability: server)
--- @param abilityName string
--- @return nil
function Tutorial:UpgradePlayerAbility(abilityName) end


--- @class CDotaTutorialNPCBlocker : CBaseFlex
CDotaTutorialNPCBlocker = {}

--- (availability: server)
--- @param enabled boolean
--- @return nil
function CDotaTutorialNPCBlocker:SetEnabled(enabled) end

--- (availability: server)
--- @param blocker userdata
--- @return nil
function CDotaTutorialNPCBlocker:SetOtherBlocker(blocker) end


--- @class CDOTAVoteSystem
VoteSystem = {}

--- Starts a vote, based upon a table of parameters.
--- 
--- (availability: server)
--- @param arg1 userdata
--- @return nil
function VoteSystem:StartVote(arg1) end


--- @class CEntities
Entities = {}

--- Creates an entity by classname.
--- 
--- (availability: server)
--- @param className string
--- @return CBaseEntity
function Entities:CreateByClassname(className) end

--- Finds all entities by class name. Returns an array containing all the found entities.
--- 
--- (availability: server)
--- @param className string
--- @return CBaseEntity[]
function Entities:FindAllByClassname(className) end

--- Find entities by class name within a radius.
--- 
--- (availability: server)
--- @param className string
--- @param location Vector
--- @param radius number
--- @return CBaseEntity[]
function Entities:FindAllByClassnameWithin(className, location, radius) end

--- Find entities by model name.
--- 
--- (availability: server)
--- @param modelName string
--- @return CBaseEntity[]
function Entities:FindAllByModel(modelName) end

--- Find all entities by name. Returns an array containing all the found entities in it.
--- 
--- (availability: server)
--- @param name string
--- @return CBaseEntity[]
function Entities:FindAllByName(name) end

--- Find entities by name within a radius.
--- 
--- (availability: server)
--- @param name string
--- @param location Vector
--- @param radius number
--- @return CBaseEntity[]
function Entities:FindAllByNameWithin(name, location, radius) end

--- Find entities by targetname.
--- 
--- (availability: server)
--- @param target string
--- @return CBaseEntity[]
function Entities:FindAllByTarget(target) end

--- Find entities within a radius.
--- 
--- (availability: server)
--- @param location Vector
--- @param radius number
--- @return CBaseEntity[]
function Entities:FindAllInSphere(location, radius) end

--- Find entities by class name. Pass 'null' to start an iteration, or reference to a previously found entity to continue a search.
--- 
--- (availability: server)
--- @param previous CBaseEntity | nil
--- @param className string
--- @return CBaseEntity | nil
function Entities:FindByClassname(previous, className) end

--- Find entities by class name nearest to a point.
--- 
--- (availability: server)
--- @param className string
--- @param location Vector
--- @param radius number
--- @return CBaseEntity | nil
function Entities:FindByClassnameNearest(className, location, radius) end

--- Find entities by class name within a radius. Pass 'null' to start an iteration, or reference to a previously found entity to continue a search.
--- 
--- (availability: server)
--- @param previous CBaseEntity | nil
--- @param className string
--- @param location Vector
--- @param radius number
--- @return CBaseEntity | nil
function Entities:FindByClassnameWithin(previous, className, location, radius) end

--- Find entities by model name. Pass 'null' to start an iteration, or reference to a previously found entity to continue a search.
--- 
--- (availability: server)
--- @param previous CBaseEntity | nil
--- @param modelName string
--- @return CBaseEntity | nil
function Entities:FindByModel(previous, modelName) end

--- Find entities by model name within a radius. Pass 'null' to start an iteration, or reference to a previously found entity to continue a search.
--- 
--- (availability: server)
--- @param previous CBaseEntity | nil
--- @param modelName string
--- @param location Vector
--- @param radius number
--- @return CBaseEntity | nil
function Entities:FindByModelWithin(previous, modelName, location, radius) end

--- Find entities by name. Pass 'null' to start an iteration, or reference to a previously found entity to continue a search.
--- 
--- (availability: server)
--- @param previous CBaseEntity | nil
--- @param name string
--- @return CBaseEntity | nil
function Entities:FindByName(previous, name) end

--- Find entities by name nearest to a point.
--- 
--- (availability: server)
--- @param name string
--- @param location Vector
--- @param radius number
--- @return CBaseEntity | nil
function Entities:FindByNameNearest(name, location, radius) end

--- Find entities by name within a radius. Pass 'null' to start an iteration, or reference to a previously found entity to continue a search.
--- 
--- (availability: server)
--- @param previous CBaseEntity | nil
--- @param name string
--- @param location Vector
--- @param radius number
--- @return CBaseEntity | nil
function Entities:FindByNameWithin(previous, name, location, radius) end

--- Find entities by targetname. Pass 'null' to start an iteration, or reference to a previously found entity to continue a search.
--- 
--- (availability: server)
--- @param previous CBaseEntity | nil
--- @param target string
--- @return CBaseEntity | nil
function Entities:FindByTarget(previous, target) end

--- Find entities within a radius. Pass 'null' to start an iteration, or reference to a previously found entity to continue a search.
--- 
--- (availability: server)
--- @param previous CBaseEntity | nil
--- @param location Vector
--- @param radius number
--- @return CBaseEntity | nil
function Entities:FindInSphere(previous, location, radius) end

--- Begin an iteration over the list of entities.
--- 
--- (availability: server & client)
--- @return CBaseEntity
function Entities:First() end

--- Get the local player controller (backcompat).
--- 
--- (availability: server & client)
--- @return CDOTAPlayerController
function Entities:GetLocalPlayer() end

--- Get the local player controller.
--- 
--- (availability: server & client)
--- @return userdata
function Entities:GetLocalPlayerController() end

--- Get the local player pawn.
--- 
--- (availability: server & client)
--- @return userdata
function Entities:GetLocalPlayerPawn() end

--- Continue an iteration over the list of entities, providing reference to a previously found entity.
--- 
--- (availability: server & client)
--- @param previous CBaseEntity | nil
--- @return CBaseEntity | nil
function Entities:Next(previous) end


--- @class CEntityInstance
CEntityInstance = {}

--- Adds an I/O connection that will call the named function on this entity when the specified output fires.
--- 
--- (availability: server & client)
--- @param arg1 string
--- @param arg2 string
--- @return nil
function CEntityInstance:ConnectOutput(arg1, arg2) end

--- (availability: server & client)
--- @return nil
function CEntityInstance:Destroy() end

--- Removes a connected script function from an I/O event on this entity.
--- 
--- (availability: server & client)
--- @param arg1 string
--- @param arg2 string
--- @return nil
function CEntityInstance:DisconnectOutput(arg1, arg2) end

--- Removes a connected script function from an I/O event on the passed entity.
--- 
--- (availability: server & client)
--- @param arg1 string
--- @param arg2 string
--- @param arg3 userdata
--- @return nil
function CEntityInstance:DisconnectRedirectedOutput(arg1, arg2, arg3) end

--- (availability: server & client)
--- @return EntityIndex
function CEntityInstance:entindex() end

--- Fire an entity output.
--- 
--- (availability: server & client)
--- @param arg1 string
--- @param arg2 userdata
--- @param arg3 userdata
--- @param arg4 table
--- @param arg5 number
--- @return nil
function CEntityInstance:FireOutput(arg1, arg2, arg3, arg4, arg5) end

--- (availability: server & client)
--- @return string
function CEntityInstance:GetClassname() end

--- Get the entity name w/help if not defined (i.e. classname/etc).
--- 
--- (availability: server & client)
--- @return string
function CEntityInstance:GetDebugName() end

--- Get the entity as an EHANDLE.
--- 
--- (availability: server & client)
--- @return userdata
function CEntityInstance:GetEntityHandle() end

--- (availability: server & client)
--- @return EntityIndex
function CEntityInstance:GetEntityIndex() end

--- Get Integer Attribute.
--- 
--- (availability: server & client)
--- @param arg1 string
--- @return integer
function CEntityInstance:GetIntAttr(arg1) end

--- Get the entity name.
--- 
--- (availability: server & client)
--- @return string
function CEntityInstance:GetName() end

--- Retrieve, creating if necessary, the private per-instance script-side data associated with an entity.
--- 
--- (availability: server & client)
--- @return userdata
function CEntityInstance:GetOrCreatePrivateScriptScope() end

--- Retrieve, creating if necessary, the public script-side data associated with an entity.
--- 
--- (availability: server & client)
--- @return userdata
function CEntityInstance:GetOrCreatePublicScriptScope() end

--- Retrieve the private per-instance script-side data associated with an entity.
--- 
--- (availability: server & client)
--- @return userdata
function CEntityInstance:GetPrivateScriptScope() end

--- Retrieve the public script-side data associated with an entity.
--- 
--- (availability: server & client)
--- @return userdata
function CEntityInstance:GetPublicScriptScope() end

--- Has underlying C++ entity object been deleted?
--- 
--- (availability: server & client)
--- @return boolean
function CEntityInstance:IsNull() end

--- Adds an I/O connection that will call the named function on the passed entity when the specified output fires.
--- 
--- (availability: server & client)
--- @param arg1 string
--- @param arg2 string
--- @param arg3 userdata
--- @return nil
function CEntityInstance:RedirectOutput(arg1, arg2, arg3) end

--- Delete this entity.
--- 
--- (availability: server & client)
--- @return nil
function CEntityInstance:RemoveSelf() end

--- Set Integer Attribute.
--- 
--- (availability: server & client)
--- @param arg1 string
--- @param arg2 integer
--- @return nil
function CEntityInstance:SetIntAttr(arg1, arg2) end


--- @class CEntityScriptFramework
NativeFunctions = {}

--- @class CEnvEntityMaker : CBaseEntity
CEnvEntityMaker = {}

--- Create an entity at the location of the maker.
--- 
--- (availability: server)
--- @return nil
function CEnvEntityMaker:SpawnEntity() end

--- Create an entity at the location of a specified entity instance.
--- 
--- (availability: server)
--- @param entity userdata
--- @return nil
function CEnvEntityMaker:SpawnEntityAtEntityOrigin(entity) end

--- Create an entity at a specified location and orientaton, orientation is Euler angle in degrees.
--- 
--- (availability: server)
--- @param vecAlternateOrigin Vector
--- @param vecAlternateAngles Vector
--- @return nil
function CEnvEntityMaker:SpawnEntityAtLocation(vecAlternateOrigin, vecAlternateAngles) end

--- Create an entity at the location of a named entity.
--- 
--- (availability: server)
--- @param name string
--- @return nil
function CEnvEntityMaker:SpawnEntityAtNamedEntityOrigin(name) end


--- @class CEnvProjectedTexture : CBaseEntity
CEnvProjectedTexture = {}

--- Set light maximum range.
--- 
--- (availability: server)
--- @param range number
--- @return nil
function CEnvProjectedTexture:SetFarRange(range) end

--- Set light linear attenuation value.
--- 
--- (availability: server)
--- @param atten number
--- @return nil
function CEnvProjectedTexture:SetLinearAttenuation(atten) end

--- Set light minimum range.
--- 
--- (availability: server)
--- @param range number
--- @return nil
function CEnvProjectedTexture:SetNearRange(range) end

--- Set light quadratic attenuation value.
--- 
--- (availability: server)
--- @param atten number
--- @return nil
function CEnvProjectedTexture:SetQuadraticAttenuation(atten) end

--- Turn on/off light volumetrics.
--- 
--- (availability: server)
--- @param on boolean
--- @param intensity number
--- @param noise number
--- @param planes integer
--- @param planeOffset number
--- @return nil
function CEnvProjectedTexture:SetVolumetrics(on, intensity, noise, planes, planeOffset) end


--- @class CFoWBlockerRegion : CBaseEntity
CFoWBlockerRegion = {}

--- Sets or clears a blocker rectangle.
--- 
--- (availability: server)
--- @param mins Vector
--- @param maxs Vector
--- @param clearRegion boolean
--- @return nil
function CFoWBlockerRegion:AddRectangularBlocker(mins, maxs, clearRegion) end

--- Sets or clears a blocker rectangle outline.
--- 
--- (availability: server)
--- @param mins Vector
--- @param maxs Vector
--- @param clearRegion boolean
--- @return nil
function CFoWBlockerRegion:AddRectangularOutlineBlocker(mins, maxs, clearRegion) end


--- @class CInfoData : CBaseEntity
CInfoData = {}

--- Query color data for this key.
--- 
--- (availability: server)
--- @param tok string
--- @param default Vector
--- @return Vector
function CInfoData:QueryColor(tok, default) end

--- Query float data for this key.
--- 
--- (availability: server)
--- @param tok string
--- @param default number
--- @return number
function CInfoData:QueryFloat(tok, default) end

--- Query int data for this key.
--- 
--- (availability: server)
--- @param tok string
--- @param default integer
--- @return integer
function CInfoData:QueryInt(tok, default) end

--- Query number data for this key.
--- 
--- (availability: server)
--- @param tok string
--- @param default number
--- @return number
function CInfoData:QueryNumber(tok, default) end

--- Query string data for this key.
--- 
--- (availability: server)
--- @param tok string
--- @param default string
--- @return string
function CInfoData:QueryString(tok, default) end

--- Query vector data for this key.
--- 
--- (availability: server)
--- @param tok string
--- @param default Vector
--- @return Vector
function CInfoData:QueryVector(tok, default) end


--- @class CInfoPlayerStartDota : CPointEntity
CInfoPlayerStartDota = {}

--- Returns whether the object is currently active.
--- 
--- (availability: server)
--- @return boolean
function CInfoPlayerStartDota:IsEnabled() end

--- Enable or disable the obstruction.
--- 
--- (availability: server)
--- @param enabled boolean
--- @return nil
function CInfoPlayerStartDota:SetEnabled(enabled) end


--- @class CInfoWorldLayer : CBaseEntity
CInfoWorldLayer = {}

--- Hides this layer.
--- 
--- (availability: server & client)
--- @return nil
function CInfoWorldLayer:HideWorldLayer() end

--- Shows this layer.
--- 
--- (availability: server & client)
--- @return nil
function CInfoWorldLayer:ShowWorldLayer() end


--- @class CLogicRelay : CBaseEntity
CLogicRelay = {}

--- Triggers the logic_relay.
--- 
--- (availability: server & client)
--- @param activator CBaseEntity | nil
--- @param caller CBaseEntity | nil
--- @return nil
function CLogicRelay:Trigger(activator, caller) end


--- @class CLogicScript : CBaseEntity
CLogicScript = {}

--- @class CMarkupVolumeTagged : CBaseEntity
CMarkupVolumeTagged = {}

--- Does this volume have the given tag.
--- 
--- (availability: server)
--- @param tagName string
--- @return boolean
function CMarkupVolumeTagged:HasTag(tagName) end


--- @class CNativeOutputs
CNativeOutputs = {}

--- Add an output.
--- 
--- (availability: server & client)
--- @param arg1 string
--- @param arg2 string
--- @return nil
function CNativeOutputs:AddOutput(arg1, arg2) end

--- Initialize with number of outputs.
--- 
--- (availability: server & client)
--- @param arg1 integer
--- @return nil
function CNativeOutputs:Init(arg1) end


--- @class Convars
Convars = {}

--- Returns the convar as a boolean flag.
--- 
--- (availability: server & client)
--- @param name string
--- @return boolean | nil
function Convars:GetBool(name) end

--- Returns the player who issued this console command.
--- 
--- (availability: server & client)
--- @return CDOTAPlayerController
function Convars:GetCommandClient() end

--- Returns the DOTA player who issued this console command.
--- 
--- (availability: server & client)
--- @return CDOTAPlayerController
function Convars:GetDOTACommandClient() end

--- Returns the convar as a float. May return null if no such convar.
--- 
--- (availability: server & client)
--- @param name string
--- @return number | nil
function Convars:GetFloat(name) end

--- Returns the convar as an int. May return null if no such convar.
--- 
--- (availability: server & client)
--- @param name string
--- @return integer | nil
function Convars:GetInt(name) end

--- Returns the convar as a string. May return null if no such convar.
--- 
--- (availability: server & client)
--- @param name string
--- @return string | nil
function Convars:GetStr(name) end

--- Register a console command.
--- 
--- (availability: server & client)
--- @param name string
--- @param callback fun(name: string, ...: string): nil
--- @param helpString string
--- @param flags ConVarFlags
--- @return nil
function Convars:RegisterCommand(name, callback, helpString, flags) end

--- Register a new console variable.
--- 
--- (availability: server & client)
--- @param name string
--- @param defaultValue string
--- @param helpString string
--- @param flags ConVarFlags
--- @return nil
function Convars:RegisterConvar(name, defaultValue, helpString, flags) end

--- Sets the value of the convar to the bool.
--- 
--- (availability: server & client)
--- @param name string
--- @param value boolean
--- @return nil
function Convars:SetBool(name, value) end

--- Sets the value of the convar to the float.
--- 
--- (availability: server & client)
--- @param name string
--- @param value number
--- @return nil
function Convars:SetFloat(name, value) end

--- Sets the value of the convar to the int.
--- 
--- (availability: server & client)
--- @param name string
--- @param value integer
--- @return nil
function Convars:SetInt(name, value) end

--- Sets the value of the convar to the string.
--- 
--- (availability: server & client)
--- @param name string
--- @param value string
--- @return nil
function Convars:SetStr(name, value) end


--- @class CParticleSystem : CBaseModelEntity
CParticleSystem = {}

--- @class CPhysicsProp : CBaseAnimatingActivity
CPhysicsProp = {}

--- Disable motion for the prop.
--- 
--- (availability: server)
--- @return nil
function CPhysicsProp:DisableMotion() end

--- Enable motion for the prop.
--- 
--- (availability: server)
--- @return nil
function CPhysicsProp:EnableMotion() end

--- Enable/disable dynamic vs dynamic continuous collision traces.
--- 
--- (availability: server)
--- @param isDynamicVsDynamicContinuousEnabled boolean
--- @return nil
function CPhysicsProp:SetDynamicVsDynamicContinuous(isDynamicVsDynamicContinuousEnabled) end


--- @class CPointClientUIWorldPanel : CBaseModelEntity
CPointClientUIWorldPanel = {}

--- Tells the panel to accept user input.
--- 
--- (availability: server)
--- @return nil
function CPointClientUIWorldPanel:AcceptUserInput() end

--- Adds CSS class(es) to the panel.
--- 
--- (availability: server)
--- @param classes string
--- @return nil
function CPointClientUIWorldPanel:AddCSSClasses(classes) end

--- Tells the panel to ignore user input.
--- 
--- (availability: server)
--- @return nil
function CPointClientUIWorldPanel:IgnoreUserInput() end

--- Returns whether this entity is grabbable.
--- 
--- (availability: server)
--- @return boolean
function CPointClientUIWorldPanel:IsGrabbable() end

--- Remove CSS class(es) from the panel.
--- 
--- (availability: server)
--- @param classes string
--- @return nil
function CPointClientUIWorldPanel:RemoveCSSClasses(classes) end


--- @class CPointEntity : CBaseEntity
CPointEntity = {}

--- @class CPointTemplate : CBaseEntity
CPointTemplate = {}

--- Deletes any spawn groups that this point_template has spawned. Note: The point_template will not be deleted by this.
--- 
--- (availability: server & client)
--- @return nil
function CPointTemplate:DeleteCreatedSpawnGroups() end

--- Spawns all of the entities the point_template is pointing at.
--- 
--- (availability: server & client)
--- @return nil
function CPointTemplate:ForceSpawn() end

--- Get the list of the most recent spawned entities.
--- 
--- (availability: server & client)
--- @return userdata
function CPointTemplate:GetSpawnedEntities() end

--- Set a callback for when the template spawns entities. The spawned entities will be passed in as an array.
--- 
--- (availability: server & client)
--- @param callbackFunc userdata
--- @param callbackScope userdata
--- @return nil
function CPointTemplate:SetSpawnCallback(callbackFunc, callbackScope) end


--- @class CPointWorldText : CBaseModelEntity
CPointWorldText = {}

--- Set the message on this entity.
--- 
--- (availability: server & client)
--- @param message string
--- @return nil
function CPointWorldText:SetMessage(message) end


--- @class CSceneEntity : CBaseEntity
CSceneEntity = {}

--- Adds a team (by index) to the broadcast list.
--- 
--- (availability: server)
--- @param arg1 integer
--- @return nil
function CSceneEntity:AddBroadcastTeamTarget(arg1) end

--- Cancel scene playback.
--- 
--- (availability: server)
--- @return nil
function CSceneEntity:Cancel() end

--- Returns length of this scene in seconds.
--- 
--- (availability: server)
--- @return number
function CSceneEntity:EstimateLength() end

--- Given an entity reference, such as !target, get actual entity from scene object.
--- 
--- (availability: server)
--- @param arg1 string
--- @return userdata
function CSceneEntity:FindNamedEntity(arg1) end

--- If this scene is currently paused.
--- 
--- (availability: server)
--- @return boolean
function CSceneEntity:IsPaused() end

--- If this scene is currently playing.
--- 
--- (availability: server)
--- @return boolean
function CSceneEntity:IsPlayingBack() end

--- Given a dummy scene name and a vcd string, load the scene.
--- 
--- (availability: server)
--- @param arg1 string
--- @param arg2 string
--- @return boolean
function CSceneEntity:LoadSceneFromString(arg1, arg2) end

--- Removes a team (by index) from the broadcast list.
--- 
--- (availability: server)
--- @param arg1 integer
--- @return nil
function CSceneEntity:RemoveBroadcastTeamTarget(arg1) end

--- Start scene playback, takes activatorEntity as param.
--- 
--- (availability: server)
--- @param arg1 userdata
--- @return nil
function CSceneEntity:Start(arg1) end


--- @class CScriptHeroList
HeroList = {}

--- Returns all the heroes in the world.
--- 
--- (availability: server)
--- @return CDOTA_BaseNPC_Hero[]
function HeroList:GetAllHeroes() end

--- Get the Nth hero in the Hero List.
--- 
--- (availability: server)
--- @param nth integer
--- @return CDOTA_BaseNPC_Hero | nil
function HeroList:GetHero(nth) end

--- Returns the number of heroes in the world.
--- 
--- (availability: server)
--- @return integer
function HeroList:GetHeroCount() end


--- Note: Actual `CScriptHTTPRequest` global exists only after CreateHTTPRequest is called.
--- 
--- Note: Actual `CScriptHTTPRequest` global exists only after CreateHTTPRequest is called.
--- @class CScriptHTTPRequest
CScriptHTTPRequest = {}

--- Send a HTTP request.
--- 
--- (availability: server & client)
--- @param callback fun(response: CScriptHTTPResponse): nil
--- @return boolean
function CScriptHTTPRequest:Send(callback) end

--- Set the total timeout on the request.
--- 
--- (availability: server & client)
--- @param milliseconds integer
--- @return boolean
function CScriptHTTPRequest:SetHTTPRequestAbsoluteTimeoutMS(milliseconds) end

--- Set a POST or GET parameter on the request.
--- 
--- (availability: server & client)
--- @param name string
--- @param value string
--- @return boolean
function CScriptHTTPRequest:SetHTTPRequestGetOrPostParameter(name, value) end

--- Set a header value on the request.
--- 
--- (availability: server & client)
--- @param name string
--- @param value string
--- @return boolean
function CScriptHTTPRequest:SetHTTPRequestHeaderValue(name, value) end

--- Set the network timeout on the request - this timer is reset when any data is received.
--- 
--- (availability: server & client)
--- @param seconds integer
--- @return boolean
function CScriptHTTPRequest:SetHTTPRequestNetworkActivityTimeout(seconds) end

--- Set the literal body of a post - invalid after setting a post parameter.
--- 
--- (availability: server & client)
--- @param contentType string
--- @param body string
--- @return boolean
function CScriptHTTPRequest:SetHTTPRequestRawPostBody(contentType, body) end


--- @class CScriptKeyValues
CScriptKeyValues = {}

--- Reads a spawn key.
--- 
--- (availability: server & client)
--- @param arg1 string
--- @return table
function CScriptKeyValues:GetValue(arg1) end


--- @class CScriptParticleManager
ParticleManager = {}

--- Creates a new particle effect.
--- 
--- (availability: server & client)
--- @param particleName string
--- @param particleAttach ParticleAttachment_t
--- @param owner CBaseEntity | nil
--- @return ParticleID
function ParticleManager:CreateParticle(particleName, particleAttach, owner) end

--- Creates a new particle effect that only plays for the specified player.
--- 
--- (availability: server & client)
--- @param particleName string
--- @param particleAttach ParticleAttachment_t
--- @param owner CBaseEntity | nil
--- @param player CDOTAPlayerController
--- @return ParticleID
function ParticleManager:CreateParticleForPlayer(particleName, particleAttach, owner, player) end

--- Creates a new particle effect that only plays for the specified team.
--- 
--- (availability: server & client)
--- @param particleName string
--- @param particleAttach ParticleAttachment_t
--- @param owner CBaseEntity | nil
--- @param team DOTATeam_t
--- @return ParticleID
function ParticleManager:CreateParticleForTeam(particleName, particleAttach, owner, team) end

--- Destroy a particle, if bDestroyImmediately destroy it without playing end caps.
--- 
--- (availability: server & client)
--- @param particle ParticleID
--- @param immediate boolean
--- @return nil
function ParticleManager:DestroyParticle(particle, immediate) end

--- (availability: server & client)
--- @param particleName string
--- @param hero CDOTA_BaseNPC_Hero | nil
--- @return string
function ParticleManager:GetParticleReplacement(particleName, hero) end

--- Frees the specified particle index.
--- 
--- (availability: server & client)
--- @param particle ParticleID
--- @return nil
function ParticleManager:ReleaseParticleIndex(particle) end

--- (availability: server & client)
--- @param particle ParticleID
--- @return nil
function ParticleManager:SetParticleAlwaysSimulate(particle) end

--- Set the control point data for a control on a particle effect.
--- 
--- (availability: server & client)
--- @param particle ParticleID
--- @param controlPoint integer
--- @param value Vector
--- @return nil
function ParticleManager:SetParticleControl(particle, controlPoint, value) end

--- (availability: server & client)
--- @param particle ParticleID
--- @param controlPoint integer
--- @param unit CBaseEntity
--- @param particleAttach ParticleAttachment_t
--- @param attachment string
--- @param offset Vector
--- @param lockOrientation boolean
--- @return nil
function ParticleManager:SetParticleControlEnt(particle, controlPoint, unit, particleAttach, attachment, offset, lockOrientation) end

--- (availability: server & client)
--- @param particle ParticleID
--- @param controlPoint integer
--- @param vecPosition Vector
--- @return nil
function ParticleManager:SetParticleControlFallback(particle, controlPoint, vecPosition) end

--- [OBSOLETE - Use SetParticleControlTransformForward] (int nFXIndex, int nPoint, vForward).
--- 
--- (availability: server & client)
--- @param particle ParticleID
--- @param controlPoint integer
--- @param arg3 Vector
--- @return nil
function ParticleManager:SetParticleControlForward(particle, controlPoint, arg3) end

--- [OBSOLETE - Use SetParticleControlTransform] (int nFXIndex, int nPoint, vForward, vRight, vUp) - Set the orientation for a control on a particle effect (NOTE: This is left handed -- bad!!).
--- 
--- (availability: server & client)
--- @param particle ParticleID
--- @param controlPoint integer
--- @param arg3 Vector
--- @param arg4 Vector
--- @param arg5 Vector
--- @return nil
function ParticleManager:SetParticleControlOrientation(particle, controlPoint, arg3, arg4, arg5) end

--- [OBSOLETE - Use SetParticleControlTransform] (int nFXIndex, int nPoint, Vector vecForward, Vector vecLeft, Vector vecUp) - Set the orientation for a control on a particle effect.
--- 
--- (availability: server & client)
--- @param particle ParticleID
--- @param controlPoint integer
--- @param arg3 Vector
--- @param arg4 Vector
--- @param arg5 Vector
--- @return nil
function ParticleManager:SetParticleControlOrientationFLU(particle, controlPoint, arg3, arg4, arg5) end

--- (availability: server & client)
--- @param fxIndex integer
--- @param point integer
--- @param origin Vector
--- @param qAngles QAngle
--- @return nil
function ParticleManager:SetParticleControlTransform(fxIndex, point, origin, qAngles) end

--- (availability: server & client)
--- @param fxIndex integer
--- @param point integer
--- @param origin Vector
--- @param forward Vector
--- @return nil
function ParticleManager:SetParticleControlTransformForward(fxIndex, point, origin, forward) end

--- (availability: server & client)
--- @param particle ParticleID
--- @param controlPoint integer
--- @param controlPoint2 integer
--- @param radius number
--- @return nil
function ParticleManager:SetParticleFoWProperties(particle, controlPoint, controlPoint2, radius) end

--- (availability: server & client)
--- @param particle ParticleID
--- @param checkFoW boolean
--- @return boolean
function ParticleManager:SetParticleShouldCheckFoW(particle, checkFoW) end


--- @class CScriptPrecacheContext
CScriptPrecacheContext = {}

--- Precaches a specific resource.
--- 
--- (availability: server & client)
--- @param resource string
--- @return nil
function CScriptPrecacheContext:AddResource(resource) end

--- Reads a spawn key.
--- 
--- (availability: server & client)
--- @param key string
--- @return table
function CScriptPrecacheContext:GetValue(key) end


--- @class CScriptUniformRandomStream
CScriptUniformRandomStream = {}

--- (availability: server & client)
--- @param minVal number
--- @param maxVal number
--- @return number
function CScriptUniformRandomStream:RandomFloat(minVal, maxVal) end

--- (availability: server & client)
--- @param minVal number
--- @param maxVal number
--- @param exponent number
--- @return number
function CScriptUniformRandomStream:RandomFloatExp(minVal, maxVal, exponent) end

--- (availability: server & client)
--- @param minVal integer
--- @param maxVal integer
--- @return integer
function CScriptUniformRandomStream:RandomInt(minVal, maxVal) end

--- (availability: server & client)
--- @param percentage integer
--- @return boolean
function CScriptUniformRandomStream:RollPercentage(percentage) end


--- @class CTakeDamageInfo
CTakeDamageInfo = {}

--- (availability: server)
--- @param addAmount number
--- @return nil
function CTakeDamageInfo:AddDamage(addAmount) end

--- (availability: server)
--- @param bitsDamageType integer
--- @return nil
function CTakeDamageInfo:AddDamageType(bitsDamageType) end

--- (availability: server)
--- @return integer
function CTakeDamageInfo:GetAmmoType() end

--- (availability: server)
--- @return userdata
function CTakeDamageInfo:GetAttacker() end

--- (availability: server)
--- @return number
function CTakeDamageInfo:GetDamage() end

--- (availability: server)
--- @return integer
function CTakeDamageInfo:GetDamageCustom() end

--- (availability: server)
--- @return Vector
function CTakeDamageInfo:GetDamageForce() end

--- (availability: server)
--- @return Vector
function CTakeDamageInfo:GetDamagePosition() end

--- (availability: server)
--- @return integer
function CTakeDamageInfo:GetDamageType() end

--- (availability: server)
--- @return userdata
function CTakeDamageInfo:GetInflictor() end

--- (availability: server)
--- @return number
function CTakeDamageInfo:GetOriginalDamage() end

--- (availability: server)
--- @return Vector
function CTakeDamageInfo:GetReportedPosition() end

--- (availability: server)
--- @param bitsToTest integer
--- @return boolean
function CTakeDamageInfo:HasDamageType(bitsToTest) end

--- (availability: server)
--- @param scaleAmount number
--- @return nil
function CTakeDamageInfo:ScaleDamage(scaleAmount) end

--- (availability: server)
--- @param ammoType integer
--- @return nil
function CTakeDamageInfo:SetAmmoType(ammoType) end

--- (availability: server)
--- @param attacker userdata
--- @return nil
function CTakeDamageInfo:SetAttacker(attacker) end

--- (availability: server)
--- @param damage number
--- @return nil
function CTakeDamageInfo:SetDamage(damage) end

--- (availability: server)
--- @param damageCustom integer
--- @return nil
function CTakeDamageInfo:SetDamageCustom(damageCustom) end

--- (availability: server)
--- @param damageForce Vector
--- @return nil
function CTakeDamageInfo:SetDamageForce(damageForce) end

--- (availability: server)
--- @param damagePosition Vector
--- @return nil
function CTakeDamageInfo:SetDamagePosition(damagePosition) end

--- (availability: server)
--- @param bitsDamageType integer
--- @return nil
function CTakeDamageInfo:SetDamageType(bitsDamageType) end

--- (availability: server)
--- @param originalDamage number
--- @return nil
function CTakeDamageInfo:SetOriginalDamage(originalDamage) end

--- (availability: server)
--- @param reportedPosition Vector
--- @return nil
function CTakeDamageInfo:SetReportedPosition(reportedPosition) end


--- @class GlobalSys
GlobalSys = {}

--- Returns true if the command line param was used, otherwise false.
--- 
--- (availability: server & client)
--- @param name string
--- @return table
function GlobalSys:CommandLineCheck(name) end

--- Returns the command line param as a float.
--- 
--- (availability: server & client)
--- @param arg1 string
--- @param arg2 number
--- @return table
function GlobalSys:CommandLineFloat(arg1, arg2) end

--- Returns the command line param as an int.
--- 
--- (availability: server & client)
--- @param arg1 string
--- @param arg2 integer
--- @return table
function GlobalSys:CommandLineInt(arg1, arg2) end

--- Returns the command line param as a string.
--- 
--- (availability: server & client)
--- @param arg1 string
--- @param arg2 string
--- @return table
function GlobalSys:CommandLineStr(arg1, arg2) end


--- @class GridNav
GridNav = {}

--- Determine if it is possible to reach the specified end point from the specified start point. bool.
--- 
--- (availability: server)
--- @param start Vector
--- @param end_ Vector
--- @return boolean
function GridNav:CanFindPath(start, end_) end

--- Destroy all trees in the area(vPosition, flRadius, bFullCollision.
--- 
--- (availability: server)
--- @param arg1 Vector
--- @param arg2 number
--- @param arg3 boolean
--- @return nil
function GridNav:DestroyTreesAroundPoint(arg1, arg2, arg3) end

--- Find a path between the two points an return the length of the path. If there is not a path between the points the returned value will be -1.
--- 
--- (availability: server)
--- @param start Vector
--- @param end_ Vector
--- @return number
function GridNav:FindPathLength(start, end_) end

--- Returns a table full of tree HSCRIPTS.
--- 
--- (availability: server)
--- @param position Vector
--- @param radius number
--- @param fullCollision boolean
--- @return CDOTA_MapTree[]
function GridNav:GetAllTreesAroundPoint(position, radius, fullCollision) end

--- Get the X position of the center of a given X index.
--- 
--- (availability: server)
--- @param arg1 integer
--- @return number
function GridNav:GridPosToWorldCenterX(arg1) end

--- Get the Y position of the center of a given Y index.
--- 
--- (availability: server)
--- @param arg1 integer
--- @return number
function GridNav:GridPosToWorldCenterY(arg1) end

--- Checks whether the given position is blocked.
--- 
--- (availability: server)
--- @param arg1 Vector
--- @return boolean
function GridNav:IsBlocked(arg1) end

--- Checks whether there are any trees overlapping the given point.
--- 
--- (availability: server)
--- @param position Vector
--- @param radius number
--- @param checkFullTreeRadius boolean
--- @return boolean
function GridNav:IsNearbyTree(position, radius, checkFullTreeRadius) end

--- Checks whether the given position is traversable.
--- 
--- (availability: server)
--- @param arg1 Vector
--- @return boolean
function GridNav:IsTraversable(arg1) end

--- Causes all trees in the map to regrow.
--- 
--- (availability: server)
--- @return nil
function GridNav:RegrowAllTrees() end

--- Get the X index of a given world X position.
--- 
--- (availability: server)
--- @param arg1 number
--- @return integer
function GridNav:WorldToGridPosX(arg1) end

--- Get the Y index of a given world Y position.
--- 
--- (availability: server)
--- @param arg1 number
--- @return integer
function GridNav:WorldToGridPosY(arg1) end


--- @class ProjectileManager
ProjectileManager = {}

--- Update speed.
--- 
--- (availability: server)
--- @param ability CDOTABaseAbility
--- @param speed integer
--- @return nil
function ProjectileManager:ChangeTrackingProjectileSpeed(ability, speed) end

--- Creates a linear projectile and returns the projectile ID.
--- 
--- (availability: server)
--- @param options CreateLinearProjectileOptions
--- @return ProjectileID
function ProjectileManager:CreateLinearProjectile(options) end

--- Creates a tracking projectile.
--- 
--- (availability: server)
--- @param options CreateTrackingProjectileOptions
--- @return ProjectileID
function ProjectileManager:CreateTrackingProjectile(options) end

--- Destroys the linear projectile matching the argument ID.
--- 
--- (availability: server)
--- @param projectile ProjectileID
--- @return nil
function ProjectileManager:DestroyLinearProjectile(projectile) end

--- Destroy a tracking projectile early.
--- 
--- (availability: server)
--- @param projectile ProjectileID
--- @return nil
function ProjectileManager:DestroyTrackingProjectile(projectile) end

--- Returns current location of projectile.
--- 
--- (availability: server)
--- @param projectile ProjectileID
--- @return Vector
function ProjectileManager:GetLinearProjectileLocation(projectile) end

--- Returns current radius of projectile.
--- 
--- (availability: server)
--- @param projectile ProjectileID
--- @return number
function ProjectileManager:GetLinearProjectileRadius(projectile) end

--- Returns a vector representing the current velocity of the projectile.
--- 
--- (availability: server)
--- @param projectile ProjectileID
--- @return Vector
function ProjectileManager:GetLinearProjectileVelocity(projectile) end

--- Returns current location of projectile.
--- 
--- (availability: server)
--- @param projectile ProjectileID
--- @return Vector
function ProjectileManager:GetTrackingProjectileLocation(projectile) end

--- Is this a valid projectile?
--- 
--- (availability: server)
--- @param value integer
--- @return boolean
function ProjectileManager:IsValidProjectile(value) end

--- Makes the specified unit dodge projectiles.
--- 
--- (availability: server)
--- @param unit CDOTA_BaseNPC
--- @return nil
function ProjectileManager:ProjectileDodge(unit) end

--- Update velocity.
--- 
--- (availability: server)
--- @param projectile ProjectileID
--- @param direction Vector
--- @param speed number
--- @return nil
function ProjectileManager:UpdateLinearProjectileDirection(projectile, direction, speed) end


--- QAngle class.
--- 
--- QAngle class.
--- @class QAngle
--- @field x number Pitch angle
--- @field y number Yaw angle
--- @field z number Roll angle
--- @overload fun(x: number | nil, y: number | nil, z: number | nil): QAngle
QAngle = {}

--- Overloaded +. Adds angles together.
--- 
--- (availability: server & client)
--- @param b QAngle
--- @return QAngle
function QAngle:__add(b) end

--- Overloaded ==. Tests for Equality.
--- 
--- (availability: server & client)
--- @param b QAngle
--- @return boolean
function QAngle:__eq(b) end

--- Overloaded .. Converts the QAngles to strings.
--- 
--- (availability: server & client)
--- @return string
function QAngle:__tostring() end

--- Returns the forward vector.
--- 
--- (availability: server & client)
--- @return Vector
function QAngle:Forward() end

--- Returns the left vector.
--- 
--- (availability: server & client)
--- @return Vector
function QAngle:Left() end

--- Returns the up vector.
--- 
--- (availability: server & client)
--- @return Vector
function QAngle:Up() end


--- @class SteamInfo
SteamInfo = {}

--- Is the script connected to the public Steam universe.
--- 
--- (availability: server)
--- @return boolean
function SteamInfo:IsPublicUniverse() end


--- Integer with binary operations.
--- 
--- Integer with binary operations.
--- @class Uint64
Uint64 = {}

--- (availability: server)
--- @param b Uint64
--- @return boolean
function Uint64:__eq(b) end

--- Overloaded .. Converts Uint64s to strings.
--- 
--- (availability: server)
--- @return string
function Uint64:__tostring() end

--- Performs bitwise AND between two integers.
--- 
--- (availability: server)
--- @param operand Uint64
--- @return Uint64
function Uint64:BitwiseAnd(operand) end

--- Performs bitwise OR between two integers.
--- 
--- (availability: server)
--- @param operand Uint64
--- @return Uint64
function Uint64:BitwiseOr(operand) end

--- Performs bitwise XOR between two integers.
--- 
--- (availability: server)
--- @param operand Uint64
--- @return Uint64
function Uint64:BitwiseXor(operand) end

--- Performs bitwise NOT.
--- 
--- (availability: server)
--- @return Uint64
function Uint64:BitwiseNot() end

--- Sets the specified bit.
--- 
--- (availability: server)
--- @param bitvalue integer
--- @return nil
function Uint64:SetBit(bitvalue) end

--- Clears the specified bit.
--- 
--- (availability: server)
--- @param bitvalue integer
--- @return integer
function Uint64:ClearBit(bitvalue) end

--- Checks if bit is set.
--- 
--- (availability: server)
--- @param bitvalue integer
--- @return integer | nil
function Uint64:IsBitSet(bitvalue) end

--- Toggles the specified bit.
--- 
--- (availability: server)
--- @param bitvalue integer
--- @return integer
function Uint64:ToggleBit(bitvalue) end

--- Returns a hexadecimal string representation of the integer.
--- 
--- (availability: server)
--- @return string
function Uint64:ToHexString() end


--- 3D Vector class.
--- 
--- 3D Vector class.
--- @class Vector
--- @field x number X-axis
--- @field y number Y-axis
--- @field z number Z-axis
--- @overload fun(x: number | nil, y: number | nil, z: number | nil): Vector
Vector = {}

--- Overloaded +. Adds vectors together.
--- 
--- (availability: server & client)
--- @param b Vector
--- @return Vector
function Vector:__add(b) end

--- Overloaded /. Divides vectors.
--- 
--- (availability: server & client)
--- @param b Vector
--- @return Vector
function Vector:__div(b) end

--- Overloaded ==. Tests for Equality.
--- 
--- (availability: server & client)
--- @param b Vector
--- @return boolean
function Vector:__eq(b) end

--- Overloaded # returns the length of the vector.
--- 
--- (availability: server & client)
--- @return number
function Vector:__len() end

--- Overloaded * returns the vectors multiplied together. Can also be used to multiply with scalars.
--- 
--- (availability: server & client)
--- @param b Vector | number
--- @return Vector
function Vector:__mul(b) end

--- Overloaded -. Subtracts vectors.
--- 
--- (availability: server & client)
--- @param b Vector
--- @return Vector
function Vector:__sub(b) end

--- Overloaded .. Converts vectors to strings.
--- 
--- (availability: server & client)
--- @return string
function Vector:__tostring() end

--- Overloaded - operator. Reverses the vector.
--- 
--- (availability: server & client)
--- @return Vector
function Vector:__unm() end

--- Cross product of two vectors.
--- 
--- (availability: server & client)
--- @param b Vector
--- @return Vector
function Vector:Cross(b) end

--- Dot product of two vectors.
--- 
--- (availability: server & client)
--- @param b Vector
--- @return number
function Vector:Dot(b) end

--- Length of the Vector.
--- 
--- (availability: server & client)
--- @return number
function Vector:Length() end

--- Length of the Vector in the XY plane.
--- 
--- (availability: server & client)
--- @return number
function Vector:Length2D() end

--- Returns the vector normalized.
--- 
--- (availability: server & client)
--- @return Vector
function Vector:Normalized() end

--- Linearly interpolates between two vectors.
--- This is most commonly used to find a point some fraction of the way along a line between two endpoints.
--- Same as `this + (b - this) * t`.
--- 
--- (availability: server & client)
--- @param b Vector
--- @param t number Interpolant
--- @return Vector
function Vector:Lerp(b, t) end


--- Add temporary vision for a given team.
--- 
--- (availability: server)
--- @param teamId DOTATeam_t
--- @param location Vector
--- @param radius number
--- @param duration number
--- @param obstructedVision boolean
--- @return ViewerID
function AddFOWViewer(teamId, location, radius, duration, obstructedVision) end

--- Returns the number of degrees difference between two yaw angles.
--- 
--- (availability: server & client)
--- @param arg1 number
--- @param arg2 number
--- @return number
function AngleDiff(arg1, arg2) end

--- Generate a vector given a QAngles.
--- 
--- (availability: server & client)
--- @param arg1 QAngle
--- @return Vector
function AnglesToVector(arg1) end

--- (availability: server & client)
--- @deprecated
--- @param arg1 string
--- @param arg2 string
--- @return nil
function AppendToLogFile(arg1, arg2) end

--- Damage an npc.
--- 
--- (availability: server)
--- @param options ApplyDamageOptions
--- @return number
function ApplyDamage(options) end

--- Constructs a quaternion representing a rotation by angle around the specified vector axis.
--- 
--- (availability: server & client)
--- @param arg1 Vector
--- @param arg2 number
--- @return userdata
function AxisAngleToQuaternion(arg1, arg2) end

--- Compute the closest point on the OBB of an entity.
--- 
--- (availability: server & client)
--- @param arg1 userdata
--- @param arg2 Vector
--- @return Vector
function CalcClosestPointOnEntityOBB(arg1, arg2) end

--- Compute the distance between two entity OBB. A negative return value indicates an input error. A return value of zero indicates that the OBBs are overlapping.
--- 
--- (availability: server & client)
--- @param arg1 userdata
--- @param arg2 userdata
--- @return number
function CalcDistanceBetweenEntityOBB(arg1, arg2) end

--- (availability: server & client)
--- @param arg1 Vector
--- @param arg2 Vector
--- @param arg3 Vector
--- @return number
function CalcDistanceToLineSegment2D(arg1, arg2, arg3) end

--- Create all I/O events for a particular entity.
--- 
--- (availability: server & client)
--- @param arg1 userdata
--- @return nil
function CancelEntityIOEvents(arg1) end

--- Centers each players' camera on a unit.
--- 
--- (availability: server)
--- @param playerId PlayerID
--- @param unit CBaseEntity | nil
--- @return nil
function CenterCameraOnUnit(playerId, unit) end

--- (availability: server)
--- @param team DOTATeam_t
--- @return nil
function ClearTeamCustomHealthbarColor(team) end

--- Allocate a damageinfo object, used as an argument to TakeDamage(). Call DestroyDamageInfo( hInfo ) to free the object.
--- 
--- (availability: server)
--- @param arg1 userdata
--- @param arg2 userdata
--- @param arg3 Vector
--- @param arg4 Vector
--- @param arg5 number
--- @param arg6 integer
--- @return CTakeDamageInfo
function CreateDamageInfo(arg1, arg2, arg3, arg4, arg5, arg6) end

--- Pass table - Inputs: entity, effect.
--- 
--- (availability: server & client)
--- @param arg1 userdata
--- @return boolean
function CreateEffect(arg1) end

--- Creates a DOTA hero by its dota_npc_units.txt name and sets it as the given player's controlled hero.
--- 
--- (availability: server)
--- @param heroName string
--- @param player CDOTAPlayerController
--- @return CDOTA_BaseNPC_Hero
function CreateHeroForPlayer(heroName, player) end

--- Create an HTTP request.
--- 
--- (availability: server & client)
--- @param method string
--- @param url string
--- @return CScriptHTTPRequest
function CreateHTTPRequest(method, url) end

--- Create an HTTP request.
--- 
--- (availability: server & client)
--- @param method string
--- @param url string
--- @return CScriptHTTPRequest
function CreateHTTPRequestScriptVM(method, url) end

--- Create illusions of the passed hero that belong to passed unit using passed modifier data.
--- 
--- (availability: server)
--- @param owner CBaseEntity
--- @param heroToCopy CDOTA_BaseNPC_Hero
--- @param modifierKeys CreateIllusionsModifierKeys
--- @param numIllusions integer
--- @param padding integer
--- @param scramblePosition boolean
--- @param findClearSpace boolean
--- @return CDOTA_BaseNPC_Hero[]
function CreateIllusions(owner, heroToCopy, modifierKeys, numIllusions, padding, scramblePosition, findClearSpace) end

--- Create a DOTA item.
--- 
--- (availability: server)
--- @param itemName string
--- @param owner CDOTAPlayerController | nil
--- @param purchaser CDOTAPlayerController | nil
--- @return CDOTA_Item | nil
function CreateItem(itemName, owner, purchaser) end

--- Create a physical item at a given location, can start in air (but doesn't clear a space).
--- 
--- (availability: server)
--- @param location Vector
--- @param item CDOTA_Item | nil
--- @return CDOTA_Item_Physical
function CreateItemOnPositionForLaunch(location, item) end

--- Create a physical item at a given location.
--- 
--- (availability: server)
--- @param location Vector
--- @param item CDOTA_Item | nil
--- @return CDOTA_Item_Physical
function CreateItemOnPositionSync(location, item) end

--- Create a modifier not associated with an NPC.
--- 
--- (availability: server)
--- @param caster CDOTA_BaseNPC | nil
--- @param ability CDOTABaseAbility | nil
--- @param modifierName string
--- @param paramTable table | nil
--- @param origin Vector
--- @param teamNumber DOTATeam_t
--- @param phantomBlocker boolean
--- @return CDOTA_BaseNPC
function CreateModifierThinker(caster, ability, modifierName, paramTable, origin, teamNumber, phantomBlocker) end

--- Create a rune of the specified type.
--- 
--- (availability: server)
--- @param location Vector
--- @param runeType DOTA_RUNES
--- @return CBaseAnimatingActivity
function CreateRune(location, runeType) end

--- Create a scene entity to play the specified scene.
--- 
--- (availability: server)
--- @param arg1 string
--- @return CBaseAnimatingActivity
function CreateSceneEntity(arg1) end

--- Create a temporary tree, uses a default tree model.
--- 
--- (availability: server)
--- @param location Vector
--- @param duration number
--- @return CBaseAnimatingActivity
function CreateTempTree(location, duration) end

--- Create a temporary tree, specifying the tree model name.
--- 
--- (availability: server)
--- @param location Vector
--- @param duration number
--- @param modelName string
--- @return CBaseAnimatingActivity
function CreateTempTreeWithModel(location, duration, modelName) end

--- Creates and returns an AABB trigger.
--- 
--- (availability: server)
--- @param arg1 Vector
--- @param arg2 Vector
--- @param arg3 Vector
--- @return CBaseTrigger
function CreateTrigger(arg1, arg2, arg3) end

--- Creates and returns an AABB trigger thats bigger than the radius provided.
--- 
--- (availability: server)
--- @param vecOrigin Vector
--- @param radius number
--- @return CBaseTrigger
function CreateTriggerRadiusApproximate(vecOrigin, radius) end

--- Creates a separate random number stream.
--- 
--- (availability: server & client)
--- @param seed integer
--- @return CScriptUniformRandomStream
function CreateUniformRandomStream(seed) end

--- Creates a unit by its dota_npc_units.txt name.
--- The spawned unit will not be controllable by default. You can use unit.SetControllableByPlayer() to change this.
--- Warning: mass synchronous unit spawning may be slow. Prefer CreateUnitByNameAsync unless synchronous access is required.
--- 
--- (availability: server)
--- @param unitName string
--- @param location Vector
--- @param findClearSpace boolean
--- @param npcOwner CBaseEntity | nil
--- @param entityOwner CBaseEntity | nil This entity will be returned by GetOwner() and GetOwnerEntity(). GetPlayerOwner() and GetPlayerOwnerID() will be automatically inferred from this entity. Can be changed after spawn using SetOwner(entity). When spawning heroes, passing CDOTAPlayerController makes hero use owned wearables.
--- @param team DOTATeam_t
--- @return CDOTA_BaseNPC
function CreateUnitByName(unitName, location, findClearSpace, npcOwner, entityOwner, team) end

--- Creates a unit by its dota_npc_units.txt name.
--- The spawned unit will not be controllable by default. You can use unit.SetControllableByPlayer() to change this.
--- 
--- (availability: server)
--- @param unitName string
--- @param location Vector
--- @param findClearSpace boolean
--- @param npcOwner CBaseEntity | nil
--- @param entityOwner CBaseEntity | nil This entity will be returned by GetOwner() and GetOwnerEntity(). GetPlayerOwner() and GetPlayerOwnerID() will be automatically inferred from this entity. Can be changed after spawn using SetOwner(entity). When spawning heroes, passing CDOTAPlayerController makes hero use owned wearables.
--- @param team DOTATeam_t
--- @param callback fun(unit: CDOTA_BaseNPC): nil
--- @return SpawnGroupHandle
function CreateUnitByNameAsync(unitName, location, findClearSpace, npcOwner, entityOwner, team, callback) end

--- Creates a DOTA unit by its dota_npc_units.txt name from a table of entity key values and a position to spawn at.
--- 
--- (availability: server)
--- @param options CreateUnitFromTableOptions
--- @param location Vector
--- @return CDOTA_BaseNPC
function CreateUnitFromTable(options, location) end

--- Cross product between two vectors.
--- 
--- (availability: server & client)
--- @param arg1 Vector
--- @param arg2 Vector
--- @return Vector
function CrossVectors(arg1, arg2) end

--- Gets the value of the given cvar, as a float.
--- 
--- (availability: server & client)
--- @param arg1 string
--- @return number
function cvar_getf(arg1) end

--- Sets the value of the given cvar, as a float.
--- 
--- (availability: server & client)
--- @param arg1 string
--- @param arg2 number
--- @return boolean
function cvar_setf(arg1, arg2) end

--- Breaks in the debugger.
--- 
--- (availability: server & client)
--- @return nil
function DebugBreak() end

--- Creates a test unit controllable by the specified player.
--- 
--- (availability: server)
--- @param playerOwner CDOTAPlayerController
--- @param unitName string
--- @param team DOTATeam_t
--- @param arg4 boolean
--- @param callback fun(unit: CDOTA_BaseNPC): nil
--- @return integer
function DebugCreateUnit(playerOwner, unitName, team, arg4, callback) end

--- Draw a debug overlay box.
--- 
--- (availability: server & client)
--- @param arg1 Vector
--- @param arg2 Vector
--- @param arg3 Vector
--- @param arg4 integer
--- @param arg5 integer
--- @param arg6 integer
--- @param arg7 integer
--- @param arg8 number
--- @return nil
function DebugDrawBox(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8) end

--- Draw a debug forward box.
--- 
--- (availability: server & client)
--- @param cent Vector
--- @param min Vector
--- @param max Vector
--- @param forward Vector
--- @param rgb Vector
--- @param a number
--- @param duration number
--- @return nil
function DebugDrawBoxDirection(cent, min, max, forward, rgb, a, duration) end

--- Draw a debug circle.
--- 
--- (availability: server & client)
--- @param center Vector
--- @param rgb Vector
--- @param a number
--- @param rad number
--- @param ztest boolean
--- @param duration number
--- @return nil
function DebugDrawCircle(center, rgb, a, rad, ztest, duration) end

--- Try to clear all the debug overlay info.
--- 
--- (availability: server & client)
--- @return nil
function DebugDrawClear() end

--- Draw a debug overlay line.
--- 
--- (availability: server & client)
--- @param origin Vector
--- @param target Vector
--- @param r integer
--- @param g integer
--- @param b integer
--- @param ztest boolean
--- @param duration number
--- @return nil
function DebugDrawLine(origin, target, r, g, b, ztest, duration) end

--- Draw a debug line using color vec.
--- 
--- (availability: server & client)
--- @param arg1 Vector
--- @param arg2 Vector
--- @param arg3 Vector
--- @param arg4 boolean
--- @param arg5 number
--- @return nil
function DebugDrawLine_vCol(arg1, arg2, arg3, arg4, arg5) end

--- Draw text with a line offset.
--- 
--- (availability: server & client)
--- @param x number
--- @param y number
--- @param lineOffset integer
--- @param text string
--- @param r integer
--- @param g integer
--- @param b integer
--- @param a integer
--- @param duration number
--- @return nil
function DebugDrawScreenTextLine(x, y, lineOffset, text, r, g, b, a, duration) end

--- Draw a debug sphere.
--- 
--- (availability: server & client)
--- @param center Vector
--- @param rgb Vector
--- @param a number
--- @param rad number
--- @param ztest boolean
--- @param duration number
--- @return nil
function DebugDrawSphere(center, rgb, a, rad, ztest, duration) end

--- Draw text in 3d.
--- 
--- (availability: server & client)
--- @param origin Vector
--- @param text string
--- @param viewCheck boolean
--- @param duration number
--- @return nil
function DebugDrawText(origin, text, viewCheck, duration) end

--- Draw pretty debug text.
--- 
--- (availability: server & client)
--- @param x number
--- @param y number
--- @param lineOffset integer
--- @param text string
--- @param r integer
--- @param g integer
--- @param b integer
--- @param a integer
--- @param duration number
--- @param font string
--- @param size integer
--- @param bold boolean
--- @return nil
function DebugScreenTextPretty(x, y, lineOffset, text, r, g, b, a, duration, font, size, bold) end

--- Print out a table (and subtables) to the console.
--- 
--- (availability: server & client)
--- @param t table | nil
--- @return nil
function DeepPrintTable(t) end

--- Free a damageinfo object that was created with CreateDamageInfo().
--- 
--- (availability: server)
--- @param damageInfo CTakeDamageInfo
--- @return nil
function DestroyDamageInfo(damageInfo) end

--- Kick a specific player from the game.
--- 
--- (availability: server)
--- @param arg1 integer
--- @param arg2 boolean
--- @return nil
function DisconnectClient(arg1, arg2) end

--- (availability: server)
--- @param attacker CDOTA_BaseNPC
--- @param target CDOTA_BaseNPC
--- @param ability CDOTABaseAbility | nil
--- @param damage number
--- @param startRadius number
--- @param endRadius number
--- @param distance number
--- @param effectName string
--- @return integer
function DoCleaveAttack(attacker, target, ability, damage, startRadius, endRadius, distance, effectName) end

--- Generate and entity i/o event.
--- 
--- (availability: server)
--- @param arg1 string
--- @param arg2 string
--- @param arg3 string
--- @param arg4 number
--- @param arg5 userdata
--- @param arg6 userdata
--- @return nil
function DoEntFire(arg1, arg2, arg3, arg4, arg5, arg6) end

--- Generate and entity i/o event.
--- 
--- (availability: server)
--- @param arg1 userdata
--- @param arg2 string
--- @param arg3 string
--- @param arg4 number
--- @param arg5 userdata
--- @param arg6 userdata
--- @return nil
function DoEntFireByInstanceHandle(arg1, arg2, arg3, arg4, arg5, arg6) end

--- Execute a script (internal).
--- 
--- (availability: server & client)
--- @param arg1 string
--- @param arg2 userdata
--- @return boolean
function DoIncludeScript(arg1, arg2) end

--- Asserts the passed in value. Prints out a message and brings up the assert dialog.
--- 
--- (availability: server & client)
--- @param arg1 boolean
--- @param arg2 string
--- @return nil
function DoScriptAssert(arg1, arg2) end

--- Spawn a .vmap at the target location.
--- 
--- (availability: server)
--- @param mapName string A map name without extension, relative to "maps" directory.
--- @param location Vector The value of x and y must be multiple the grid size 64. To avoid GridNav conflicts, tiles on these coordinates on the base map must be empty.
--- @param deferCompletion boolean If true, to finish map loading you need to call ManuallyTriggerSpawnGroupCompletion(spawnGroupHandle).
--- @param onReadyToSpawn fun(spawnGroupHandle: SpawnGroupHandle): nil Called only when deferCompletion is true.
--- @param onSpawnComplete fun(spawnGroupHandle: SpawnGroupHandle): nil
--- @param context table | nil
--- @return SpawnGroupHandle
function DOTA_SpawnMapAtPosition(mapName, location, deferCompletion, onReadyToSpawn, onSpawnComplete, context) end

--- (availability: server)
--- @param arg1 Vector
--- @param arg2 Vector
--- @return number
function DotProduct(arg1, arg2) end

--- Generate a string guaranteed to be unique across the life of the script VM, with an optional root string. Useful for adding data to tables when not sure what keys are already in use in that table.
--- 
--- (availability: server & client)
--- @param seed string
--- @return string
function DoUniqueString(seed) end

--- Drop a neutral item for the team of the hero at the given tier.
--- 
--- (availability: server)
--- @param itemName string Can be any item name, it does not have to be neutral.
--- @param location Vector
--- @param unit CDOTA_BaseNPC
--- @param tier integer Zero-based tier number.
--- @param arg5 boolean
--- @return CDOTA_Item_Physical
function DropNeutralItemAtPositionForHero(itemName, location, unit, tier, arg5) end

--- Drop a neutral item for the team of the hero at the given tier.
--- 
--- (availability: server)
--- @param arg1 string
--- @param arg2 Vector
--- @param arg3 userdata
--- @param arg4 integer
--- @param arg5 boolean
--- @param arg6 Vector
--- @return userdata
function DropNeutralItemAtPositionForHeroWithOffset(arg1, arg2, arg3, arg4, arg5, arg6) end

--- A function to re-lookup a function by name every time.
--- 
--- (availability: server & client)
--- @param context table
--- @param name string
--- @return any
function Dynamic_Wrap(context, name) end

--- Emit an announcer sound for all players.
--- 
--- (availability: server)
--- @param soundName string
--- @return nil
function EmitAnnouncerSound(soundName) end

--- Emit an announcer sound for a player.
--- 
--- (availability: server)
--- @param soundName string
--- @param playerId PlayerID
--- @return nil
function EmitAnnouncerSoundForPlayer(soundName, playerId) end

--- Emit an announcer sound for a team.
--- 
--- (availability: server)
--- @param soundName string
--- @param team DOTATeam_t
--- @return nil
function EmitAnnouncerSoundForTeam(soundName, team) end

--- Emit an announcer sound for a team at a specific location.
--- 
--- (availability: server)
--- @param soundName string
--- @param team DOTATeam_t
--- @param location Vector
--- @return nil
function EmitAnnouncerSoundForTeamOnLocation(soundName, team, location) end

--- Play named sound for all players.
--- 
--- (availability: server)
--- @param soundName string
--- @return nil
function EmitGlobalSound(soundName) end

--- Play named sound on Entity.
--- 
--- (availability: server & client)
--- @param soundName string
--- @param entity CBaseEntity
--- @return nil
function EmitSoundOn(soundName, entity) end

--- Play named sound only on the client for the passed in player.
--- 
--- (availability: server & client)
--- @param soundName string
--- @param arg2 userdata
--- @return nil
function EmitSoundOnClient(soundName, arg2) end

--- Emit a sound on an entity for only a specific player.
--- 
--- (availability: server)
--- @param arg1 string
--- @param arg2 userdata
--- @param arg3 integer
--- @return nil
function EmitSoundOnEntityForPlayer(arg1, arg2, arg3) end

--- Emit a sound on a location from a unit, only for players allied with that unit.
--- 
--- (availability: server)
--- @param location Vector
--- @param soundName string
--- @param caster CBaseEntity
--- @return nil
function EmitSoundOnLocationForAllies(location, soundName, caster) end

--- Emit a sound on a location for only a specific player.
--- 
--- (availability: server)
--- @param arg1 string
--- @param arg2 Vector
--- @param arg3 integer
--- @return nil
function EmitSoundOnLocationForPlayer(arg1, arg2, arg3) end

--- Emit a sound on a location from a unit.
--- 
--- (availability: server)
--- @param location Vector
--- @param soundName string
--- @param caster CDOTA_BaseNPC
--- @return nil
function EmitSoundOnLocationWithCaster(location, soundName, caster) end

--- Turn an entity index integer to an HScript representing that entity's script instance.
--- 
--- (availability: server & client)
--- @param entityIndex EntityIndex
--- @return CBaseEntity | nil
function EntIndexToHScript(entityIndex) end

--- Issue an order from a script table.
--- 
--- (availability: server)
--- @param order ExecuteOrderOptions
--- @return nil
function ExecuteOrderFromTable(order) end

--- Smooth curve decreasing slower as it approaches zero.
--- 
--- (availability: server & client)
--- @param arg1 number
--- @param arg2 number
--- @param arg3 number
--- @return number
function ExponentialDecay(arg1, arg2, arg3) end

--- Finds a clear random position around a given target unit, using the target unit's padded collision radius.
--- 
--- (availability: server)
--- @param arg1 userdata
--- @param arg2 userdata
--- @param arg3 integer
--- @return boolean
function FindClearRandomPositionAroundUnit(arg1, arg2, arg3) end

--- Place a unit somewhere not already occupied.
--- 
--- (availability: server)
--- @param unit CDOTA_BaseNPC
--- @param location Vector
--- @param arg3 boolean
--- @return boolean
function FindClearSpaceForUnit(unit, location, arg3) end

--- Find a spawn point for the given team.
--- 
--- (availability: server)
--- @param team DOTATeam_t
--- @return CBaseEntity | nil
function FindSpawnEntityForTeam(team) end

--- Find units that intersect the given line with the given flags.
--- 
--- (availability: server)
--- @param team DOTATeam_t
--- @param startPos Vector
--- @param endPos Vector
--- @param cacheUnit CBaseEntity | nil
--- @param width number
--- @param teamFilter DOTA_UNIT_TARGET_TEAM
--- @param typeFilter DOTA_UNIT_TARGET_TYPE
--- @param flagFilter DOTA_UNIT_TARGET_FLAGS
--- @return CDOTA_BaseNPC[]
function FindUnitsInLine(team, startPos, endPos, cacheUnit, width, teamFilter, typeFilter, flagFilter) end

--- Finds the units in a given radius with the given flags.
--- 
--- (availability: server)
--- @param team DOTATeam_t
--- @param location Vector
--- @param cacheUnit CBaseEntity | nil
--- @param radius number
--- @param teamFilter DOTA_UNIT_TARGET_TEAM
--- @param typeFilter DOTA_UNIT_TARGET_TYPE
--- @param flagFilter DOTA_UNIT_TARGET_FLAGS
--- @param order FindOrder
--- @param canGrowCache boolean
--- @return CDOTA_BaseNPC[]
function FindUnitsInRadius(team, location, cacheUnit, radius, teamFilter, typeFilter, flagFilter, order, canGrowCache) end

--- Fire Entity's Action Input w/no data.
--- 
--- (availability: server & client)
--- @param arg1 userdata
--- @param arg2 string
--- @return nil
function FireEntityIOInputNameOnly(arg1, arg2) end

--- Fire Entity's Action Input with passed String - you own the memory.
--- 
--- (availability: server & client)
--- @param arg1 userdata
--- @param arg2 string
--- @param arg3 string
--- @return nil
function FireEntityIOInputString(arg1, arg2, arg3) end

--- Fire Entity's Action Input with passed Vector - you own the memory.
--- 
--- (availability: server & client)
--- @param arg1 userdata
--- @param arg2 string
--- @param arg3 Vector
--- @return nil
function FireEntityIOInputVec(arg1, arg2, arg3) end

--- Fire a game event.
--- 
--- (availability: server & client)
--- @param eventName string
--- @param eventData table
--- @return nil
function FireGameEvent(eventName, eventData) end

--- Fire a game event without broadcasting to the client.
--- 
--- (availability: server & client)
--- @param eventName string
--- @param eventData table
--- @return nil
function FireGameEventLocal(eventName, eventData) end

--- Get the time spent on the server in the last frame.
--- 
--- (availability: server & client)
--- @return number
function FrameTime() end

--- Get ability data by ability name.
--- 
--- (availability: server & client)
--- @param arg1 string
--- @return table
function GetAbilityKeyValuesByName(arg1) end

--- Gets the ability texture name for an ability.
--- 
--- (availability: server & client)
--- @param abilityName string
--- @return string
function GetAbilityTextureNameForAbility(abilityName) end

--- Returns the currently active spawn group handle.
--- 
--- (availability: server & client)
--- @return SpawnGroupHandle
function GetActiveSpawnGroupHandle() end

--- Returns a location for the unit that is not already occupied.
--- 
--- (availability: server)
--- @param arg1 userdata
--- @param arg2 Vector
--- @return Vector
function GetClearSpaceForUnit(arg1, arg2) end

--- (availability: server)
--- @deprecated
--- @param version string
--- @return string
function GetDedicatedServerKey(version) end

--- (availability: server)
--- @param version string
--- @return string
function GetDedicatedServerKeyV2(version) end

--- (availability: server)
--- @param version string
--- @return string
function GetDedicatedServerKeyV3(version) end

--- Get the enity index for a tree id specified as the entindex_target of a DOTA_UNIT_ORDER_CAST_TARGET_TREE.
--- 
--- (availability: server)
--- @param treeId integer
--- @return EntityIndex
function GetEntityIndexForTreeId(treeId) end

--- Returns the engines current frame count.
--- 
--- (availability: server & client)
--- @return integer
function GetFrameCount() end

--- (availability: server)
--- @param location Vector
--- @param unitHull CDOTA_BaseNPC | nil
--- @return number
function GetGroundHeight(location, unitHull) end

--- Returns the supplied position moved to the ground. Second parameter is an NPC for measuring movement collision hull offset.
--- 
--- (availability: server)
--- @param location Vector
--- @param unitHull CDOTA_BaseNPC | nil
--- @return Vector
function GetGroundPosition(location, unitHull) end

--- Get the cost of an item by name.
--- 
--- (availability: server)
--- @param arg1 string
--- @return integer
function GetItemCost(arg1) end

--- (availability: server)
--- @param arg1 integer
--- @param arg2 integer
--- @return integer
function GetItemDefOwnedCount(arg1, arg2) end

--- (availability: server)
--- @param arg1 integer
--- @param arg2 integer
--- @return integer
function GetItemDefQuantity(arg1, arg2) end

--- Get the local player on a listen server.
--- 
--- (availability: server & client)
--- @return CDOTAPlayerController
function GetListenServerHost() end

--- (availability: server)
--- @return table
function GetLobbyEventGameDetails() end

--- Get the local player ID.
--- 
--- (availability: client)
--- @return PlayerID
function GetLocalPlayerID() end

--- Get the local player team.
--- 
--- (availability: client)
--- @param arg1 integer
--- @return DOTATeam_t
function GetLocalPlayerTeam(arg1) end

--- Get the name of the map.
--- 
--- (availability: server & client)
--- @return string
function GetMapName() end

--- Get the longest delay for all events attached to an output.
--- 
--- (availability: server & client)
--- @param arg1 userdata
--- @param arg2 string
--- @return number
function GetMaxOutputDelay(arg1, arg2) end

--- Get Angular Velocity for VPHYS or normal object. Returns a vector of the axis of rotation, multiplied by the degrees of rotation per second.
--- 
--- (availability: server & client)
--- @param arg1 userdata
--- @return Vector
function GetPhysAngularVelocity(arg1) end

--- Get Velocity for VPHYS or normal object.
--- 
--- (availability: server & client)
--- @param arg1 userdata
--- @return Vector
function GetPhysVelocity(arg1) end

--- Given the item tier and the team, roll for the name of a valid neutral item drop, considering previous drops and consumables.
--- 
--- (availability: server)
--- @param tier integer
--- @param team DOTATeam_t
--- @return string
function GetPotentialNeutralItemDrop(tier, team) end

--- Get the current real world date.
--- 
--- (availability: server)
--- @return string
function GetSystemDate() end

--- Get the current real world time.
--- 
--- (availability: server)
--- @return string
function GetSystemTime() end

--- Get system time in milliseconds.
--- 
--- (availability: server)
--- @return number
function GetSystemTimeMS() end

--- (availability: server)
--- @param arg1 integer
--- @param arg2 integer
--- @param arg3 integer
--- @param arg4 Vector
--- @param arg5 integer
--- @param arg6 integer
--- @param arg7 integer
--- @return Vector
function GetTargetAOELocation(arg1, arg2, arg3, arg4, arg5, arg6, arg7) end

--- (availability: server)
--- @param arg1 integer
--- @param arg2 integer
--- @param arg3 integer
--- @param arg4 Vector
--- @param arg5 integer
--- @param arg6 integer
--- @param arg7 integer
--- @return Vector
function GetTargetLinearLocation(arg1, arg2, arg3, arg4, arg5, arg6, arg7) end

--- (availability: server)
--- @param team DOTATeam_t
--- @return integer
function GetTeamHeroKills(team) end

--- (availability: server)
--- @param team DOTATeam_t
--- @return string
function GetTeamName(team) end

--- Given and entity index of a tree, get the tree id for use for use with with unit orders.
--- 
--- (availability: server)
--- @param entityIndex EntityIndex
--- @return integer
function GetTreeIdForEntityIndex(entityIndex) end

--- Get unit data by ability name.
--- 
--- (availability: server & client)
--- @param arg1 string
--- @return table
function GetUnitKeyValuesByName(arg1) end

--- Gets the world's maximum X position.
--- 
--- (availability: server)
--- @return number
function GetWorldMaxX() end

--- Gets the world's maximum Y position.
--- 
--- (availability: server)
--- @return number
function GetWorldMaxY() end

--- Gets the world's minimum X position.
--- 
--- (availability: server)
--- @return number
function GetWorldMinX() end

--- Gets the world's minimum Y position.
--- 
--- (availability: server)
--- @return number
function GetWorldMinY() end

--- Get amount of XP required to reach the next level.
--- 
--- (availability: server)
--- @param level integer
--- @return integer
function GetXPNeededToReachNextLevel(level) end

--- Max out a hero's level and give them all appropriate abilities and talents.
--- 
--- (availability: server)
--- @param arg1 userdata
--- @return nil
function HeroMaxLevel(arg1) end

--- (availability: server & client)
--- @deprecated
--- @param arg1 string
--- @param arg2 string
--- @return nil
function InitLogFile(arg1, arg2) end

--- Returns true if this is lua running from the client.dll.
--- 
--- (availability: server & client)
--- @return boolean
function IsClient() end

--- Returns true if this server is a dedicated server.
--- 
--- (availability: server & client)
--- @return boolean
function IsDedicatedServer() end

--- Returns true if whatever alt is remapped to is pressed.
--- 
--- (availability: client)
--- @return boolean
function IsDotaAltPressed() end

--- Returns true if whatever ctrl is remapped to is pressed.
--- 
--- (availability: client)
--- @return boolean
function IsDotaCtrlPressed() end

--- Returns true if this is lua running within tools mode.
--- 
--- (availability: server & client)
--- @return boolean
function IsInToolsMode() end

--- Ask fog of war if a location is visible to a certain team.
--- 
--- (availability: server)
--- @param team DOTATeam_t
--- @param location Vector
--- @return boolean
function IsLocationVisible(team, location) end

--- Is this entity a mango tree? (hEntity).
--- 
--- (availability: server)
--- @param entity CBaseEntity
--- @return boolean
function IsMangoTree(entity) end

--- Returns true if the entity is valid and marked for deletion.
--- 
--- (availability: server & client)
--- @param entity CBaseEntity
--- @return boolean
function IsMarkedForDeletion(entity) end

--- Returns true if this is lua running from the server.dll.
--- 
--- (availability: server & client)
--- @return boolean
function IsServer() end

--- Returns true if the unit is in a valid position in the gridnav.
--- 
--- (availability: server)
--- @param unit CBaseEntity
--- @return boolean
function IsUnitInValidPosition(unit) end

--- Checks to see if the given hScript is a valid entity.
--- 
--- (availability: server & client)
--- @param entity table | nil
--- @return boolean
function IsValidEntity(entity) end

--- Lerp between two vectors by a float factor returning new vector.
--- 
--- (availability: server & client)
--- @param arg1 Vector
--- @param arg2 Vector
--- @param arg3 number
--- @return Vector
function LerpVectors(arg1, arg2, arg3) end

--- Set the limit on the pathfinding search space.
--- 
--- (availability: server)
--- @param arg1 number
--- @return nil
function LimitPathingSearchDepth(arg1) end

--- Link a lua-defined modifier with the associated class.
--- 
--- (availability: server & client)
--- @param className string
--- @param filePath string
--- @param luaModifierType LuaModifierType
--- @return nil
function LinkLuaModifier(className, filePath, luaModifierType) end

--- Register as a listener for a game event from script.
--- 
--- (availability: server & client)
--- @param eventName string
--- @param listener fun(event: table): nil
--- @param context table | nil
--- @return EventListenerID
function ListenToGameEvent(eventName, listener, context) end

--- Creates a table from the specified keyvalues text file.
--- 
--- (availability: server & client)
--- @param filePath string
--- @return table
function LoadKeyValues(filePath) end

--- Creates a table from the specified keyvalues string.
--- 
--- (availability: server & client)
--- @param kvString string
--- @return table
function LoadKeyValuesFromString(kvString) end

--- Get the current local time.
--- 
--- (availability: server & client)
--- @return LocalTime
function LocalTime() end

--- Checks to see if the given hScript is a valid entity.
--- 
--- (availability: server & client)
--- @param arg1 string
--- @return integer
function MakeStringToken(arg1) end

--- Triggers the creation of entities in a manually-completed spawn group.
--- 
--- (availability: server & client)
--- @param handle SpawnGroupHandle
--- @return nil
function ManuallyTriggerSpawnGroupCompletion(handle) end

--- Start a minimap event.
--- 
--- (availability: server)
--- @param team DOTATeam_t
--- @param entity CBaseEntity
--- @param xCoord integer
--- @param yCoord integer
--- @param eventType DOTAMinimapEvent_t
--- @param eventDuration integer
--- @return nil
function MinimapEvent(team, entity, xCoord, yCoord, eventType, eventDuration) end

--- Print a message.
--- 
--- (availability: server & client)
--- @param message string
--- @return nil
function Msg(message) end

--- Pause or unpause the game.
--- 
--- (availability: server)
--- @param paused boolean
--- @return nil
function PauseGame(paused) end

--- Get the current float time from the engine.
--- 
--- (availability: server & client)
--- @return number
function Plat_FloatTime() end

--- Get a script instance of a player by index.
--- 
--- (availability: server & client)
--- @param entityIndex EntityIndex
--- @return CDOTAPlayerController | nil
function PlayerInstanceFromIndex(entityIndex) end

--- Precache an entity from KeyValues in table.
--- 
--- (availability: server & client)
--- @param arg1 string
--- @param arg2 userdata
--- @param context CScriptPrecacheContext
--- @return nil
function PrecacheEntityFromTable(arg1, arg2, context) end

--- Precache a list of entity KeyValues tables.
--- 
--- (availability: server & client)
--- @param arg1 userdata
--- @param context CScriptPrecacheContext
--- @return nil
function PrecacheEntityListFromTable(arg1, context) end

--- Asynchronously precaches a DOTA item by its dota_npc_items.txt name, provides a callback when it's finished.
--- 
--- (availability: server)
--- @param itemName string
--- @param callback fun(precacheId: integer): nil
--- @return nil
function PrecacheItemByNameAsync(itemName, callback) end

--- Precaches a DOTA item by its dota_npc_items.txt name.
--- 
--- (availability: server)
--- @param itemName string
--- @param context CScriptPrecacheContext
--- @return nil
function PrecacheItemByNameSync(itemName, context) end

--- Manually precache a single model.
--- 
--- (availability: server)
--- @param modelName string
--- @param context CScriptPrecacheContext
--- @return nil
function PrecacheModel(modelName, context) end

--- Manually precache a single resource.
--- 
--- (availability: server)
--- @param arg1 string
--- @param arg2 string
--- @param context CScriptPrecacheContext
--- @return nil
function PrecacheResource(arg1, arg2, context) end

--- Asynchronously precaches a DOTA unit by its dota_npc_units.txt name, provides a callback when it's finished.
--- 
--- (availability: server)
--- @param unitName string
--- @param callback fun(precacheId: integer): nil
--- @param playerId PlayerID | nil
--- @return nil
function PrecacheUnitByNameAsync(unitName, callback, playerId) end

--- Precaches a DOTA unit by its dota_npc_units.txt name.
--- 
--- (availability: server)
--- @param unitName string
--- @param context CScriptPrecacheContext
--- @param playerId PlayerID | nil
--- @return nil
function PrecacheUnitByNameSync(unitName, context, playerId) end

--- Precaches a DOTA unit from a table of entity key values.
--- 
--- (availability: server)
--- @param arg1 userdata
--- @param callback fun(precacheId: integer): nil
--- @return nil
function PrecacheUnitFromTableAsync(arg1, callback) end

--- Precaches a DOTA unit from a table of entity key values.
--- 
--- (availability: server)
--- @param arg1 userdata
--- @param context CScriptPrecacheContext
--- @return nil
function PrecacheUnitFromTableSync(arg1, context) end

--- Print a console message with a linked console command.
--- 
--- (availability: server & client)
--- @param message string
--- @param tooltip string
--- @return nil
function PrintLinkedConsoleMessage(message, tooltip) end

--- Spherical lerp of angle from->to based on time.
--- 
--- (availability: server & client)
--- @param from_angle QAngle
--- @param to_angle QAngle
--- @param time number
--- @return QAngle
function QSlerp(from_angle, to_angle, time) end

--- Get a random float within a range.
--- 
--- (availability: server)
--- @param min number
--- @param max number
--- @return number
function RandomFloat(min, max) end

--- Generate a random floating point number within a range, inclusive.
--- 
--- (availability: server & client)
--- @param arg1 number
--- @param arg2 number
--- @return number
function RandomFloatWrapper(arg1, arg2) end

--- Get a random int within a range.
--- 
--- (availability: server & client)
--- @param min integer
--- @param max integer
--- @return integer
function RandomInt(min, max) end

--- Get a random 2D vector of the given length.
--- 
--- (availability: server)
--- @param length number
--- @return Vector
function RandomVector(length) end

--- Record in player resources that a new neutral item has been created, if it hasn't already been, and show a toast.
--- 
--- (availability: server)
--- @param arg1 userdata
--- @param arg2 userdata
--- @param arg3 integer
--- @return nil
function RecordNeutralItemEarned(arg1, arg2, arg3) end

--- Register a custom animation script to run when a model loads.
--- 
--- (availability: server)
--- @param arg1 string
--- @param arg2 string
--- @return nil
function RegisterCustomAnimationScriptForModel(arg1, arg2) end

--- Create a C proxy for a script-based spawn group filter.
--- 
--- (availability: server & client)
--- @param arg1 string
--- @return nil
function RegisterSpawnGroupFilterProxy(arg1) end

--- Reloads the MotD file.
--- 
--- (availability: server & client)
--- @return nil
function ReloadMOTD() end

--- Remove temporary vision for a given team.
--- 
--- (availability: server)
--- @param teamId DOTATeam_t
--- @param viewerId ViewerID
--- @return nil
function RemoveFOWViewer(teamId, viewerId) end

--- Remove the C proxy for a script-based spawn group filter.
--- 
--- (availability: server & client)
--- @param arg1 string
--- @return nil
function RemoveSpawnGroupFilterProxy(arg1) end

--- Check and fix units that have been assigned a position inside collision radius of other NPCs.
--- 
--- (availability: server)
--- @param location Vector
--- @param radius number
--- @return nil
function ResolveNPCPositions(location, radius) end

--- Rolls a number from 1 to 100 and returns true if the roll is less than or equal to the number specified.
--- 
--- (availability: server)
--- @param successPercentage integer
--- @return boolean
function RollPercentage(successPercentage) end

--- (availability: server)
--- @param chance integer
--- @param pseudoRandomId PseudoRandom Any number can be specified. Using DOTA_PSEUDO_RANDOM_NONE makes it act as a pure RNG.
--- @param unit CDOTA_BaseNPC
--- @return boolean
function RollPseudoRandomPercentage(chance, pseudoRandomId, unit) end

--- Rotate a QAngle by another QAngle.
--- 
--- (availability: server & client)
--- @param arg1 QAngle
--- @param arg2 QAngle
--- @return QAngle
function RotateOrientation(arg1, arg2) end

--- Rotate a Vector around a point.
--- 
--- (availability: server & client)
--- @param arg1 Vector
--- @param arg2 QAngle
--- @param arg3 Vector
--- @return Vector
function RotatePosition(arg1, arg2, arg3) end

--- Rotates a quaternion by the specified angle around the specified vector axis.
--- 
--- (availability: server & client)
--- @param arg1 userdata
--- @param arg2 Vector
--- @param arg3 number
--- @return userdata
function RotateQuaternionByAxisAngle(arg1, arg2, arg3) end

--- Find the delta between two QAngles.
--- 
--- (availability: server & client)
--- @param arg1 QAngle
--- @param arg2 QAngle
--- @return QAngle
function RotationDelta(arg1, arg2) end

--- Converts delta QAngle to an angular velocity Vector.
--- 
--- (availability: server & client)
--- @param arg1 QAngle
--- @param arg2 QAngle
--- @return Vector
function RotationDeltaAsAngularVelocity(arg1, arg2) end

--- Have Entity say string, and teamOnly or not.
--- 
--- (availability: server)
--- @param entity CBaseEntity | nil
--- @param message string
--- @param teamOnly boolean
--- @return nil
function Say(entity, message, teamOnly) end

--- Start a screenshake.
--- 
--- (availability: server & client)
--- @param center Vector
--- @param amplitude number
--- @param frequency number
--- @param duration number
--- @param radius number
--- @param command 0 | 1 SHAKE_START = 0, SHAKE_STOP = 1
--- @param airShake boolean
--- @return nil
function ScreenShake(center, amplitude, frequency, duration, radius, command, airShake) end

--- Get a random float within a range.
--- 
--- (availability: server & client)
--- @param arg1 number
--- @param arg2 number
--- @return number
function Script_RandomFloat(arg1, arg2) end

--- RemapValClamped.
--- 
--- (availability: server)
--- @param arg1 number
--- @param arg2 number
--- @param arg3 number
--- @param arg4 number
--- @param arg5 number
--- @return number
function Script_RemapValClamped(arg1, arg2, arg3, arg4, arg5) end

--- (availability: server)
--- @param sendToPlayer CDOTAPlayerController | nil
--- @param messageType DOTA_OVERHEAD_ALERT
--- @param targetEntity CDOTA_BaseNPC
--- @param value integer
--- @param sourcePlayer CDOTAPlayerController | nil
--- @return nil
function SendOverheadEventMessage(sendToPlayer, messageType, targetEntity, value, sourcePlayer) end

--- Send a string to the console as a client command.
--- 
--- (availability: server & client)
--- @param arg1 string
--- @return nil
function SendToConsole(arg1) end

--- Send a string to the console as a server command.
--- 
--- (availability: server)
--- @param arg1 string
--- @return nil
function SendToServerConsole(arg1) end

--- Sets an opvar value for all players.
--- 
--- (availability: server & client)
--- @param arg1 string
--- @param arg2 string
--- @param arg3 string
--- @param arg4 number
--- @return nil
function SetOpvarFloatAll(arg1, arg2, arg3, arg4) end

--- Sets an opvar value for a single player.
--- 
--- (availability: server & client)
--- @param arg1 string
--- @param arg2 string
--- @param arg3 string
--- @param arg4 number
--- @param arg5 userdata
--- @return nil
function SetOpvarFloatPlayer(arg1, arg2, arg3, arg4, arg5) end

--- Set Angular Velocity for VPHYS or normal object, from a vector of the axis of rotation, multiplied by the degrees of rotation per second.
--- 
--- (availability: server & client)
--- @param arg1 userdata
--- @param arg2 Vector
--- @return nil
function SetPhysAngularVelocity(arg1, arg2) end

--- Set the current quest name.
--- 
--- (availability: server & client)
--- @param arg1 string
--- @return nil
function SetQuestName(arg1) end

--- Set the current quest phase.
--- 
--- (availability: server & client)
--- @param arg1 integer
--- @return nil
function SetQuestPhase(arg1) end

--- Set rendering on/off for an ehandle.
--- 
--- (availability: server & client)
--- @deprecated
--- @param arg1 userdata
--- @param arg2 boolean
--- @return nil
function SetRenderingEnabled(arg1, arg2) end

--- (availability: server)
--- @param team DOTATeam_t
--- @param r integer
--- @param g integer
--- @param b integer
--- @return nil
function SetTeamCustomHealthbarColor(team, r, g, b) end

--- Supports localized strings - %s1 = PlayerName, %s2 = Value, %s3 = TeamName.
--- 
--- (availability: server)
--- @param message string
--- @param playerId PlayerID
--- @param value integer
--- @param time number
--- @return nil
function ShowCustomHeaderMessage(message, playerId, value, time) end

--- Show a generic popup dialog for all players.
--- 
--- (availability: server)
--- @param arg1 string
--- @param arg2 string
--- @param arg3 string
--- @param arg4 string
--- @param arg5 integer
--- @return nil
function ShowGenericPopup(arg1, arg2, arg3, arg4, arg5) end

--- Show a generic popup dialog to a specific player.
--- 
--- (availability: server)
--- @param arg1 userdata
--- @param arg2 string
--- @param arg3 string
--- @param arg4 string
--- @param arg5 string
--- @param arg6 integer
--- @return nil
function ShowGenericPopupToPlayer(arg1, arg2, arg3, arg4, arg5, arg6) end

--- Print a hud message on all clients.
--- 
--- (availability: server)
--- @param arg1 string
--- @return nil
function ShowMessage(arg1) end

--- (availability: server)
--- @param origin Vector
--- @param radius number
--- @return CDOTA_ShopTrigger
function SpawnDOTAShopTriggerRadiusApproximate(origin, radius) end

--- Spawn an effigy of the target unit.
--- 
--- (availability: server)
--- @param arg1 string
--- @param arg2 integer
--- @param arg3 Vector
--- @param arg4 Vector
--- @param arg5 number
--- @param arg6 number
--- @param arg7 integer
--- @return userdata
function SpawnEffigyOfUnitOrModel(arg1, arg2, arg3, arg4, arg5, arg6, arg7) end

--- Asynchronously spawns a single entity from a table.
--- 
--- (availability: server & client)
--- @param arg1 string
--- @param arg2 userdata
--- @param arg3 userdata
--- @param arg4 userdata
--- @return nil
function SpawnEntityFromTableAsynchronous(arg1, arg2, arg3, arg4) end

--- Synchronously spawns a single entity from a table.
--- 
--- (availability: server & client)
--- @param baseclass string
--- @param data table
--- @return CBaseEntity
function SpawnEntityFromTableSynchronous(baseclass, data) end

--- Hierarchically spawn an entity group from a set of spawn tables.
--- 
--- (availability: server & client)
--- @param arg1 userdata
--- @param arg2 boolean
--- @param arg3 userdata
--- @return boolean
function SpawnEntityGroupFromTable(arg1, arg2, arg3) end

--- Asynchronously spawn an entity group from a list of spawn tables. A callback will be triggered when the spawning is complete.
--- 
--- (availability: server & client)
--- @param arg1 userdata
--- @param arg2 userdata
--- @return integer
function SpawnEntityListFromTableAsynchronous(arg1, arg2) end

--- Synchronously spawn an entity group from a list of spawn tables.
--- 
--- (availability: server & client)
--- @param arg1 userdata
--- @return userdata
function SpawnEntityListFromTableSynchronous(arg1) end

--- Spawn a mango tree.
--- 
--- (availability: server)
--- @param pos Vector
--- @param team integer
--- @param duration number
--- @param mangoInterval number
--- @param initialMangoes integer
--- @return userdata
function SpawnMangoTree(pos, team, duration, mangoInterval, initialMangoes) end

--- Very basic interpolation of v0 to v1 over t on [0,1].
--- 
--- (availability: server & client)
--- @param arg1 userdata
--- @param arg2 userdata
--- @param arg3 number
--- @return userdata
function SplineQuaternions(arg1, arg2, arg3) end

--- Very basic interpolation of v0 to v1 over t on [0,1].
--- 
--- (availability: server & client)
--- @param arg1 Vector
--- @param arg2 Vector
--- @param arg3 number
--- @return Vector
function SplineVectors(arg1, arg2, arg3) end

--- Start a sound event.
--- 
--- (availability: server & client)
--- @param arg1 string
--- @param arg2 userdata
--- @return nil
function StartSoundEvent(arg1, arg2) end

--- Start a sound event from position.
--- 
--- (availability: server & client)
--- @param soundName string
--- @param position Vector
--- @return nil
function StartSoundEventFromPosition(soundName, position) end

--- Start a sound event from position with reliable delivery.
--- 
--- (availability: server & client)
--- @param soundName string
--- @param position Vector
--- @return nil
function StartSoundEventFromPositionReliable(soundName, position) end

--- Start a sound event from position with optional delivery.
--- 
--- (availability: server & client)
--- @param soundName string
--- @param position Vector
--- @return nil
function StartSoundEventFromPositionUnreliable(soundName, position) end

--- Start a sound event with reliable delivery.
--- 
--- (availability: server & client)
--- @param arg1 string
--- @param arg2 userdata
--- @return nil
function StartSoundEventReliable(arg1, arg2) end

--- Start a sound event with optional delivery.
--- 
--- (availability: server & client)
--- @param arg1 string
--- @param arg2 userdata
--- @return nil
function StartSoundEventUnreliable(arg1, arg2) end

--- Pass entity and effect name.
--- 
--- (availability: server & client)
--- @param arg1 userdata
--- @param arg2 string
--- @return nil
function StopEffect(arg1, arg2) end

--- Stop named sound for all players.
--- 
--- (availability: server)
--- @param arg1 string
--- @return nil
function StopGlobalSound(arg1) end

--- Stop listening to all game events within a specific context.
--- 
--- (availability: server & client)
--- @param arg1 userdata
--- @return nil
function StopListeningToAllGameEvents(arg1) end

--- Stop listening to a particular game event.
--- 
--- (availability: server & client)
--- @param listenerId EventListenerID
--- @return boolean
function StopListeningToGameEvent(listenerId) end

--- Stops a sound event with optional delivery.
--- 
--- (availability: server & client)
--- @param arg1 string
--- @param arg2 userdata
--- @return nil
function StopSoundEvent(arg1, arg2) end

--- Stop named sound on Entity.
--- 
--- (availability: server & client)
--- @param arg1 string
--- @param arg2 userdata
--- @return nil
function StopSoundOn(arg1, arg2) end

--- Get the current server time.
--- 
--- (availability: server & client)
--- @return number
function Time() end

--- (availability: server & client)
--- @param query TraceCollideableInputs
--- @return boolean
function TraceCollideable(query) end

--- (availability: server & client)
--- @param query TraceHullInputs
--- @return boolean
function TraceHull(query) end

--- (availability: server & client)
--- @param query TraceLineInputs
--- @return boolean
function TraceLine(query) end

--- Check if a unit passes a set of filters.
--- 
--- (availability: server & client)
--- @param npc CDOTA_BaseNPC
--- @param teamFilter DOTA_UNIT_TARGET_TEAM
--- @param typeFilter DOTA_UNIT_TARGET_TYPE
--- @param flagFilter DOTA_UNIT_TARGET_FLAGS
--- @param team DOTATeam_t
--- @return UnitFilterResult
function UnitFilter(npc, teamFilter, typeFilter, flagFilter, team) end

--- Unload a spawn group by name.
--- 
--- (availability: server & client)
--- @param arg1 string
--- @return nil
function UnloadSpawnGroup(arg1) end

--- Unload a spawn group by handle.
--- 
--- (availability: server & client)
--- @param handle SpawnGroupHandle
--- @return nil
function UnloadSpawnGroupByHandle(handle) end

--- (availability: server)
--- @param eventPointData userdata
--- @return nil
function UpdateEventPoints(eventPointData) end

--- Turn a userid integer (typically, fields named 'userid' in game events) to an HScript representing the associated player controller's script instance.
--- 
--- (availability: server & client)
--- @param arg1 integer
--- @return userdata
function UserIDToControllerHScript(arg1) end

--- Sends colored text to one client.
--- 
--- (availability: server)
--- @param arg1 integer
--- @param arg2 string
--- @param arg3 integer
--- @param arg4 integer
--- @param arg5 integer
--- @param arg6 integer
--- @return nil
function UTIL_MessageText(arg1, arg2, arg3, arg4, arg5, arg6) end

--- Sends colored text to one client. (Valid context keys: player_id, value, team_id).
--- 
--- (availability: server)
--- @param arg1 integer
--- @param arg2 string
--- @param arg3 integer
--- @param arg4 integer
--- @param arg5 integer
--- @param arg6 integer
--- @param arg7 userdata
--- @return nil
function UTIL_MessageText_WithContext(arg1, arg2, arg3, arg4, arg5, arg6, arg7) end

--- Sends colored text to all clients.
--- 
--- (availability: server)
--- @param arg1 string
--- @param arg2 integer
--- @param arg3 integer
--- @param arg4 integer
--- @param arg5 integer
--- @return nil
function UTIL_MessageTextAll(arg1, arg2, arg3, arg4, arg5) end

--- Sends colored text to all clients. (Valid context keys: player_id, value, team_id).
--- 
--- (availability: server)
--- @param arg1 string
--- @param arg2 integer
--- @param arg3 integer
--- @param arg4 integer
--- @param arg5 integer
--- @param arg6 userdata
--- @return nil
function UTIL_MessageTextAll_WithContext(arg1, arg2, arg3, arg4, arg5, arg6) end

--- Removes the specified entity.
--- 
--- (availability: server & client)
--- @param entity CBaseEntity | nil
--- @return nil
function UTIL_Remove(entity) end

--- Immediately removes the specified entity.
--- 
--- (availability: server & client)
--- @param entity CBaseEntity | nil
--- @return nil
function UTIL_RemoveImmediate(entity) end

--- Clear all message text on one client.
--- 
--- (availability: server)
--- @param arg1 integer
--- @return nil
function UTIL_ResetMessageText(arg1) end

--- Clear all message text from all clients.
--- 
--- (availability: server)
--- @return nil
function UTIL_ResetMessageTextAll() end

--- (availability: server)
--- @param arg1 Vector
--- @return QAngle
function VectorAngles(arg1) end

--- Get Qangles (with no roll) for a Vector.
--- 
--- (availability: server & client)
--- @param arg1 Vector
--- @return QAngle
function VectorToAngles(arg1) end

--- Print a warning.
--- 
--- (availability: server & client)
--- @param message string
--- @return nil
function Warning(message) end


