-- 
-- Generated by dota2-pos5
-- 

--# selene: allow(unscoped_variables)
--# selene: allow(unused_variable)

--- @module "dota2.types"
--- @module "dota2.enums"

--- @meta dota2.events

--- Send once a server starts.
--- @class dota2.events.server_spawn
--- @field hostname string Public host name.
--- @field address string Hostame, IP or DNS name.
--- @field port integer Server port.
--- @field game string Game dir.
--- @field mapname string Map name.
--- @field addonname string Addon name.
--- @field maxplayers integer Max players.
--- @field os string WIN32, LINUX.
--- @field dedicated boolean True if dedicated server.
--- @field password boolean True if password protected.

--- Server is about to be shut down.
--- @class dota2.events.server_pre_shutdown
--- @field reason string Reason why server is about to be shut down.

--- Server shut down.
--- @class dota2.events.server_shutdown
--- @field reason string Reason why server was shut down.

--- A generic server message.
--- @class dota2.events.server_message
--- @field text string The message text.

--- A server console var has changed.
--- @class dota2.events.server_cvar
--- @field cvarname string Cvar name, eg "mp_roundtime".
--- @field cvarvalue string New cvar value.

--- @class dota2.events.player_activate
--- @field userid EntityIndex User ID on server.

--- Player has sent final message in the connection sequence.
--- @class dota2.events.player_connect_full
--- @field userid EntityIndex User ID on server (unique on server).
--- @field index integer
--- @field PlayerID PlayerID

--- @class dota2.events.player_full_update
--- @field userid EntityIndex User ID on server.
--- @field count integer Number of this full update.

--- A new client connected.
--- @class dota2.events.player_connect
--- @field name string Player name.
--- @field userid EntityIndex User ID on server (unique on server).
--- @field networkid string Player network (i.e steam) id.
--- @field xuid integer Steam id.
--- @field address string Ip:port.
--- @field bot boolean
--- @field index integer Player slot (entity index-1).

--- A client was disconnected.
--- @class dota2.events.player_disconnect
--- @field userid EntityIndex User ID on server.
--- @field reason integer See networkdisconnect enum protobuf.
--- @field name string Player name.
--- @field networkid string Player network (i.e steam) id.
--- @field xuid integer Steam id.
--- @field PlayerID PlayerID

--- A player changed his name.
--- @class dota2.events.player_info
--- @field name string Player name.
--- @field userid EntityIndex User ID on server (unique on server).
--- @field steamid integer Player network (i.e steam) id.
--- @field bot boolean True if player is a AI bot.

--- Player spawned in game.
--- @class dota2.events.player_spawn
--- @field userid EntityIndex

--- @class dota2.events.player_team
--- @field userid EntityIndex
--- @field team integer Team id.
--- @field oldteam integer Old team id.
--- @field disconnect boolean Team change because player disconnects.
--- @field silent boolean
--- @field name string
--- @field isbot boolean

--- @class dota2.events.local_player_team

--- @class dota2.events.local_player_controller_team

--- @class dota2.events.player_changename
--- @field userid EntityIndex User ID on server.
--- @field oldname string Players old (current) name.
--- @field newname string Players new name.

--- @class dota2.events.player_hurt
--- @field userid EntityIndex Player who was hurt.
--- @field attacker player_controller_and_pawn Player who attacked.
--- @field health integer Remaining health points.

--- A public player chat.
--- @class dota2.events.player_chat
--- @field teamonly boolean True if team only chat.
--- @field userid EntityIndex Chatting player.
--- @field playerid PlayerID Chatting player ID.
--- @field text string Chat text.

--- @class dota2.events.local_player_pawn_changed

--- Emits a sound to everyone on a team.
--- @class dota2.events.teamplay_broadcast_audio
--- @field team integer Unique team id.
--- @field sound string Name of the sound to emit.

--- @class dota2.events.finale_start
--- @field rushes integer

--- @class dota2.events.player_stats_updated
--- @field forceupload boolean

--- Fired when achievements/stats are downloaded from Steam or XBox Live.
--- @class dota2.events.user_data_downloaded

--- @class dota2.events.ragdoll_dissolved
--- @field entindex EntityIndex

--- Info about team.
--- @class dota2.events.team_info
--- @field teamid integer Unique team id.
--- @field teamname string Team name eg "Team Blue".

--- Team score changed.
--- @class dota2.events.team_score
--- @field teamid integer Team id.
--- @field score integer Total team score.

--- A spectator/player is a cameraman.
--- @class dota2.events.hltv_cameraman
--- @field userid EntityIndex Camera man entity index.

--- Shot of a single entity.
--- @class dota2.events.hltv_chase
--- @field target1 player_controller Primary traget index.
--- @field target2 player_controller Secondary traget index or 0.
--- @field distance integer Camera distance.
--- @field theta integer View angle horizontal.
--- @field phi integer View angle vertical.
--- @field inertia integer Camera inertia.
--- @field ineye integer Diretcor suggests to show ineye.

--- A camera ranking.
--- @class dota2.events.hltv_rank_camera
--- @field index integer Fixed camera index.
--- @field rank number Ranking, how interesting is this camera view.
--- @field target player_controller Best/closest target entity.

--- An entity ranking.
--- @class dota2.events.hltv_rank_entity
--- @field userid EntityIndex Player slot.
--- @field rank number Ranking, how interesting is this entity to view.
--- @field target player_controller Best/closest target entity.

--- Show from fixed view.
--- @class dota2.events.hltv_fixed
--- @field posx integer Camera position in world.
--- @field posy integer
--- @field posz integer
--- @field theta integer Camera angles.
--- @field phi integer
--- @field offset integer
--- @field fov number
--- @field target player_controller Follow this player.

--- A HLTV message send by moderators.
--- @class dota2.events.hltv_message
--- @field text string

--- General HLTV status.
--- @class dota2.events.hltv_status
--- @field clients integer Number of HLTV spectators.
--- @field slots integer Number of HLTV slots.
--- @field proxies integer Number of HLTV proxies.
--- @field master string Disptach master IP:port.

--- @class dota2.events.hltv_title
--- @field text string

--- A HLTV chat msg sent by spectators.
--- @class dota2.events.hltv_chat
--- @field text string
--- @field steamID integer Steam id.
--- @field name string

--- @class dota2.events.hltv_versioninfo
--- @field version integer

--- @class dota2.events.hltv_replay
--- @field delay integer Number of seconds in killer replay delay.
--- @field reason integer Reason for replay	(ReplayEventType_t).

--- @class dota2.events.hltv_replay_status
--- @field reason integer Reason for hltv replay status change ().

--- @class dota2.events.demo_start
--- @field dota_combatlog_list local CSVCMsgList_GameEvents that are combat log events.
--- @field dota_hero_chase_list local CSVCMsgList_GameEvents.
--- @field dota_pick_hero_list local CSVCMsgList_GameEvents.

--- @class dota2.events.demo_stop

--- @class dota2.events.demo_skip
--- @field playback_tick integer Current playback tick.
--- @field skipto_tick integer Tick we're going to.
--- @field user_message_list local CSVCMsgList_UserMessages.
--- @field dota_hero_chase_list local CSVCMsgList_GameEvents.

--- @class dota2.events.map_shutdown

--- @class dota2.events.map_transition

--- @class dota2.events.hostname_changed
--- @field hostname string

--- @class dota2.events.difficulty_changed
--- @field newDifficulty integer
--- @field oldDifficulty integer
--- @field strDifficulty string New difficulty as string.

--- A message send by game logic to everyone.
--- @class dota2.events.game_message
--- @field target integer 0 = console, 1 = HUD.
--- @field text string The message text.

--- Send when new map is completely loaded.
--- @class dota2.events.game_newmap
--- @field mapname string Map name.
--- @field transition boolean True if this is a transition from one map to another.

--- @class dota2.events.round_start
--- @field timelimit integer Round time limit in seconds.
--- @field fraglimit integer Frag limit in seconds.
--- @field objective string Round objective.

--- @class dota2.events.round_end
--- @field winner integer Winner team/user i.
--- @field reason integer Reson why team won.
--- @field message string End round message.
--- @field time number

--- @class dota2.events.round_start_pre_entity

--- @class dota2.events.round_start_post_nav

--- @class dota2.events.round_freeze_end

--- Round restart.
--- @class dota2.events.teamplay_round_start
--- @field full_reset boolean Is this a full reset of the map.

--- A game event, name may be 32 charaters long.
--- @class dota2.events.player_death
--- @field userid EntityIndex User ID who died.
--- @field attacker player_controller_and_pawn User ID who killed.

--- @class dota2.events.player_footstep
--- @field userid EntityIndex

--- @class dota2.events.player_hintmessage
--- @field hintmessage string Localizable string of a hint.

--- @class dota2.events.break_breakable
--- @field entindex EntityIndex
--- @field userid EntityIndex
--- @field material integer BREAK_GLASS, BREAK_WOOD, etc.

--- @class dota2.events.broken_breakable
--- @field entindex EntityIndex
--- @field userid EntityIndex
--- @field material integer BREAK_GLASS, BREAK_WOOD, etc.

--- @class dota2.events.break_prop
--- @field entindex EntityIndex
--- @field userid EntityIndex
--- @field player_held boolean
--- @field player_thrown boolean
--- @field player_dropped boolean

--- @class dota2.events.entity_killed
--- @field entindex_killed EntityIndex
--- @field entindex_attacker EntityIndex
--- @field entindex_inflictor EntityIndex
--- @field damagebits integer

--- @class dota2.events.door_close
--- @field userid EntityIndex Who closed the door.
--- @field checkpoint boolean Is the door a checkpoint door.

--- @class dota2.events.vote_started
--- @field issue string
--- @field param1 string
--- @field votedata string
--- @field team integer
--- @field initiator integer Entity id of the player who initiated the vote.
--- @field reliable 1 This event is reliable.

--- @class dota2.events.vote_failed
--- @field team integer
--- @field reliable 1 This event is reliable.

--- @class dota2.events.vote_passed
--- @field details string
--- @field param1 string
--- @field team integer
--- @field reliable 1 This event is reliable.

--- @class dota2.events.vote_changed
--- @field yesVotes integer
--- @field noVotes integer
--- @field potentialVotes integer

--- @class dota2.events.vote_cast_yes
--- @field team integer
--- @field entityid integer Entity id of the voter.

--- @class dota2.events.vote_cast_no
--- @field team integer
--- @field entityid integer Entity id of the voter.

--- @class dota2.events.achievement_event
--- @field achievement_name string Non-localized name of achievement.
--- @field cur_val integer # of steps toward achievement.
--- @field max_val integer Total # of steps in achievement.

--- @class dota2.events.achievement_earned
--- @field player player_controller Entindex of the player.
--- @field achievement integer Achievement ID.

--- @class dota2.events.achievement_write_failed

--- @class dota2.events.bonus_updated
--- @field numadvanced integer
--- @field numbronze integer
--- @field numsilver integer
--- @field numgold integer

--- @class dota2.events.spec_target_updated
--- @field userid EntityIndex Spectating player.
--- @field target userdata Ehandle of the target.

--- @class dota2.events.spec_mode_updated
--- @field userid EntityIndex Spectating player.

--- @class dota2.events.entity_visible
--- @field userid EntityIndex The player who sees the entity.
--- @field subject integer Entindex of the entity they see.
--- @field classname string Classname of the entity they see.
--- @field entityname string Name of the entity they see.

--- @class dota2.events.gameinstructor_draw

--- @class dota2.events.gameinstructor_nodraw

--- @class dota2.events.flare_ignite_npc
--- @field entindex EntityIndex Entity ignited.

--- @class dota2.events.helicopter_grenade_punt_miss

--- @class dota2.events.physgun_pickup
--- @field target userdata Entity picked up.

--- @class dota2.events.inventory_updated
--- @field itemdef integer
--- @field itemid integer

--- @class dota2.events.cart_updated

--- @class dota2.events.store_pricesheet_updated

--- @class dota2.events.item_schema_initialized

--- @class dota2.events.drop_rate_modified

--- @class dota2.events.event_ticket_modified

--- @class dota2.events.gc_connected

--- @class dota2.events.instructor_start_lesson
--- @field userid EntityIndex The player who this lesson is intended for.
--- @field hint_name string Name of the lesson to start.  Must match instructor_lesson.txt.
--- @field hint_target integer Entity id that the hint should display at. Leave empty if controller target.
--- @field vr_movement_type integer
--- @field vr_single_controller boolean
--- @field vr_controller_type integer

--- @class dota2.events.instructor_close_lesson
--- @field userid EntityIndex The player who this lesson is intended for.
--- @field hint_name string Name of the lesson to start.  Must match instructor_lesson.txt.

--- @class dota2.events.instructor_server_hint_create
--- @field userid EntityIndex User ID of the player that triggered the hint.
--- @field hint_entindex EntityIndex Entity id of the env_instructor_hint that fired the event.
--- @field hint_name string What to name the hint. For referencing it again later (e.g. a kill command for the hint instead of a timeout).
--- @field hint_replace_key string Type name so that messages of the same type will replace each other.
--- @field hint_target integer Entity id that the hint should display at.
--- @field hint_activator_userid EntityIndex Playerslot of the activator.
--- @field hint_timeout integer How long in seconds until the hint automatically times out, 0 = never.
--- @field hint_icon_onscreen string The hint icon to use when the hint is onscreen. e.g. "icon_alert_red".
--- @field hint_icon_offscreen string The hint icon to use when the hint is offscreen. e.g. "icon_alert".
--- @field hint_caption string The hint caption. e.g. "#ThisIsDangerous".
--- @field hint_activator_caption string The hint caption that only the activator sees e.g. "#YouPushedItGood".
--- @field hint_color string The hint color in "r,g,b" format where each component is 0-255.
--- @field hint_icon_offset number How far on the z axis to offset the hint from entity origin.
--- @field hint_range number Range before the hint is culled.
--- @field hint_flags integer Hint flags.
--- @field hint_binding string Bindings to use when use_binding is the onscreen icon.
--- @field hint_allow_nodraw_target boolean If false, the hint will dissappear if the target entity is invisible.
--- @field hint_nooffscreen boolean If true, the hint will not show when outside the player view.
--- @field hint_forcecaption boolean If true, the hint caption will show even if the hint is occluded.
--- @field hint_local_player_only boolean If true, only the local player will see the hint.
--- @field hint_start_sound string Game sound to play.
--- @field hint_layoutfile string Path for Panorama layout file.
--- @field hint_vr_panel_type integer Attachment type for the Panorama panel.
--- @field hint_vr_height_offset number Height offset for attached panels.
--- @field hint_vr_offset_x number Offset for attached panels.
--- @field hint_vr_offset_y number Offset for attached panels.
--- @field hint_vr_offset_z number Offset for attached panels.

--- @class dota2.events.instructor_server_hint_stop
--- @field hint_name string The hint to stop. Will stop ALL hints with this name.
--- @field hint_entindex EntityIndex Entity id of the env_instructor_hint that fired the event.

--- @class dota2.events.set_instructor_group_enabled
--- @field group string
--- @field enabled integer

--- @class dota2.events.clientside_lesson_closed
--- @field lesson_name string

--- @class dota2.events.dynamic_shadow_light_changed

--- Shot of a single entity.
--- @class dota2.events.dota_chase_hero
--- @field target1 integer Primary traget index.
--- @field target2 integer Secondary traget index or 0.
--- @field type integer
--- @field priority integer
--- @field gametime number
--- @field highlight boolean If set, a result of highlight reel mode.
--- @field target1playerid PlayerID
--- @field target2playerid PlayerID
--- @field eventtype integer EDOTAHeroChaseEventType.

--- @class dota2.events.dota_combatlog
--- @field type integer
--- @field sourcename integer
--- @field targetname integer
--- @field attackername integer
--- @field inflictorname integer
--- @field attackerillusion boolean
--- @field targetillusion boolean
--- @field value integer
--- @field health integer
--- @field timestamp number
--- @field targetsourcename integer
--- @field timestampraw number
--- @field attackerhero boolean
--- @field targethero boolean
--- @field ability_toggle_on boolean
--- @field ability_toggle_off boolean
--- @field ability_level integer
--- @field gold_reason integer
--- @field xp_reason integer

--- @class dota2.events.dota_game_state_change
--- @field old_state integer
--- @field new_state integer

--- @class dota2.events.hero_selected
--- @field player_id PlayerID
--- @field team_number integer
--- @field hero_unit string

--- @class dota2.events.dota_player_pick_hero
--- @field player integer
--- @field heroindex integer
--- @field hero string

--- @class dota2.events.modifier_event
--- @field eventname string
--- @field caster integer
--- @field ability integer

--- @class dota2.events.dota_player_kill
--- @field victim_userid EntityIndex
--- @field killer1_userid EntityIndex
--- @field killer2_userid EntityIndex
--- @field killer3_userid EntityIndex
--- @field killer4_userid EntityIndex
--- @field killer5_userid EntityIndex
--- @field bounty integer
--- @field neutral integer
--- @field greevil integer

--- @class dota2.events.dota_player_deny
--- @field killer_userid EntityIndex
--- @field victim_userid EntityIndex

--- @class dota2.events.dota_barracks_kill
--- @field barracks_id integer
--- @field killer_playerid PlayerID
--- @field killer_team integer
--- @field bounty_amount integer

--- @class dota2.events.dota_tower_kill
--- @field killer_userid EntityIndex
--- @field teamnumber integer
--- @field gold integer

--- @class dota2.events.dota_tower_deny
--- @field killer_userid EntityIndex

--- @class dota2.events.dota_effigy_kill
--- @field owner_userid EntityIndex

--- @class dota2.events.dota_roshan_kill
--- @field teamnumber integer
--- @field gold integer

--- @class dota2.events.dota_miniboss_kill
--- @field shard_recipient_id integer
--- @field teamnumber integer
--- @field gold integer

--- @class dota2.events.dota_banner_planted
--- @field teamnumber integer

--- @class dota2.events.dota_courier_lost
--- @field killerid integer
--- @field teamnumber integer
--- @field bounty_gold integer

--- @class dota2.events.dota_courier_respawned
--- @field teamnumber integer

--- @class dota2.events.dota_glyph_used
--- @field teamnumber integer

--- @class dota2.events.dota_super_creeps
--- @field teamnumber integer

--- @class dota2.events.dota_item_purchase
--- @field userid EntityIndex
--- @field item_ability_id integer

--- @class dota2.events.dota_item_gifted
--- @field userid EntityIndex
--- @field item_ability_id integer
--- @field sourceid integer

--- @class dota2.events.dota_item_placed_in_neutral_stash
--- @field userid EntityIndex
--- @field item_ability_id integer

--- @class dota2.events.dota_rune_pickup
--- @field userid EntityIndex
--- @field type integer
--- @field rune integer
--- @field bounty_amount integer

--- @class dota2.events.dota_rune_deny
--- @field userid EntityIndex
--- @field rune integer

--- @class dota2.events.dota_ward_killed
--- @field userid EntityIndex
--- @field type integer
--- @field bounty_amount integer

--- @class dota2.events.dota_rune_spotted
--- @field userid EntityIndex
--- @field rune integer
--- @field map_location string
--- @field rune_team integer

--- @class dota2.events.dota_item_spotted
--- @field userid EntityIndex
--- @field item_ability_id integer

--- @class dota2.events.dota_no_battle_points
--- @field userid EntityIndex
--- @field reason integer

--- @class dota2.events.dota_chat_informational
--- @field userid EntityIndex
--- @field type integer

--- @class dota2.events.dota_action_item
--- @field reason integer
--- @field itemdef integer
--- @field message integer

--- @class dota2.events.dota_chat_ban_notification
--- @field userid EntityIndex

--- @class dota2.events.dota_chat_event
--- @field userid EntityIndex
--- @field gold integer
--- @field message integer

--- @class dota2.events.dota_chat_timed_reward
--- @field userid EntityIndex
--- @field itmedef integer
--- @field message integer

--- @class dota2.events.dota_pause_event
--- @field userid EntityIndex
--- @field value integer
--- @field message integer

--- @class dota2.events.dota_chat_kill_streak
--- @field gold integer
--- @field killer_id integer
--- @field killer_streak integer
--- @field killer_multikill integer
--- @field victim_id integer
--- @field victim_streak integer

--- @class dota2.events.dota_chat_first_blood
--- @field gold integer
--- @field killer_id integer
--- @field victim_id integer

--- @class dota2.events.dota_chat_assassin_announce
--- @field assassin_id integer
--- @field target_id integer
--- @field message integer

--- @class dota2.events.dota_chat_assassin_denied
--- @field assassin_id integer
--- @field target_id integer
--- @field message integer

--- @class dota2.events.dota_chat_assassin_success
--- @field assassin_id integer
--- @field target_id integer
--- @field message integer

--- @class dota2.events.dota_player_update_hero_selection
--- @field tabcycle boolean

--- @class dota2.events.dota_player_update_selected_unit

--- @class dota2.events.dota_player_update_query_unit

--- @class dota2.events.dota_player_update_killcam_unit

--- @class dota2.events.dota_player_take_tower_damage
--- @field PlayerID PlayerID
--- @field damage integer

--- @class dota2.events.dota_hud_error_message
--- @field reason integer
--- @field message string
--- @field sequenceNumber integer

--- @class dota2.events.dota_action_success

--- @class dota2.events.dota_starting_position_changed

--- @class dota2.events.dota_team_neutral_stash_items_changed
--- @field teamnumber integer

--- @class dota2.events.dota_team_neutral_stash_items_acknowledged_changed
--- @field teamnumber integer

--- @class dota2.events.dota_money_changed

--- @class dota2.events.dota_enemy_money_changed

--- @class dota2.events.dota_portrait_unit_stats_changed

--- @class dota2.events.dota_portrait_unit_modifiers_changed
--- @field modifier_affects_abilities boolean

--- @class dota2.events.dota_force_portrait_update

--- @class dota2.events.dota_inventory_changed

--- @class dota2.events.dota_item_suggestions_changed

--- @class dota2.events.dota_estimated_match_duration_changed

--- @class dota2.events.dota_hero_ability_points_changed

--- @class dota2.events.dota_item_picked_up
--- @field itemname string
--- @field PlayerID PlayerID
--- @field ItemEntityIndex EntityIndex
--- @field HeroEntityIndex EntityIndex

--- @class dota2.events.dota_item_physical_destroyed
--- @field itemname string
--- @field PlayerID PlayerID
--- @field ItemEntityIndex EntityIndex
--- @field HeroEntityIndex EntityIndex

--- @class dota2.events.dota_neutral_item_sent_to_stash
--- @field player_id PlayerID
--- @field itemname string
--- @field item_entindex EntityIndex

--- @class dota2.events.dota_inventory_item_changed
--- @field entityIndex EntityIndex

--- @class dota2.events.dota_ability_changed
--- @field entityIndex EntityIndex

--- @class dota2.events.dota_spectator_talent_changed
--- @field abilityname string
--- @field playerid PlayerID

--- @class dota2.events.dota_portrait_ability_layout_changed

--- @class dota2.events.dota_inventory_item_added
--- @field item_slot integer
--- @field inventory_player_id PlayerID
--- @field itemname string
--- @field item_entindex EntityIndex
--- @field inventory_parent_entindex EntityIndex
--- @field is_courier boolean

--- @class dota2.events.dota_inventory_changed_query_unit

--- @class dota2.events.dota_link_clicked
--- @field link string
--- @field nav boolean Internal to item panel - preserve the nav stack.
--- @field nav_back boolean Internal to item panel - preserve the nav stack.
--- @field recipe integer
--- @field shop integer Show the item in a particular shop.

--- @class dota2.events.dota_set_quick_buy
--- @field item string
--- @field recipe integer
--- @field toggle boolean

--- @class dota2.events.dota_quick_buy_changed
--- @field item string
--- @field recipe integer

--- @class dota2.events.dota_player_shop_changed
--- @field prevshopmask integer
--- @field shopmask integer

--- @class dota2.events.dota_hero_entered_shop
--- @field shop_type integer
--- @field shop_entindex EntityIndex
--- @field hero_entindex EntityIndex

--- @class dota2.events.dota_player_show_killcam
--- @field nodes integer
--- @field player integer

--- @class dota2.events.dota_player_show_minikillcam
--- @field nodes integer
--- @field player integer

--- @class dota2.events.gc_user_session_created

--- @class dota2.events.team_data_updated

--- @class dota2.events.guild_data_updated

--- @class dota2.events.guild_open_parties_updated

--- @class dota2.events.fantasy_updated

--- @class dota2.events.fantasy_league_changed

--- @class dota2.events.fantasy_score_info_changed

--- @class dota2.events.league_admin_info_updated

--- @class dota2.events.league_series_info_updated

--- @class dota2.events.player_info_updated

--- @class dota2.events.player_info_individual_updated
--- @field account_id integer

--- @class dota2.events.game_rules_state_change

--- @class dota2.events.match_history_updated
--- @field SteamID integer

--- @class dota2.events.match_details_updated
--- @field matchID integer

--- @class dota2.events.team_details_updated
--- @field teamID integer

--- @class dota2.events.live_games_updated

--- @class dota2.events.recent_matches_updated
--- @field Page integer

--- @class dota2.events.news_updated

--- @class dota2.events.persona_updated
--- @field SteamID integer

--- @class dota2.events.tournament_state_updated

--- @class dota2.events.party_updated

--- @class dota2.events.lobby_updated

--- @class dota2.events.dashboard_caches_cleared

--- @class dota2.events.last_hit
--- @field PlayerID PlayerID
--- @field EntKilled integer
--- @field FirstBlood boolean
--- @field HeroKill boolean
--- @field TowerKill boolean

--- @class dota2.events.player_completed_game
--- @field PlayerID PlayerID
--- @field Winner integer

--- @class dota2.events.player_reconnected
--- @field PlayerID PlayerID

--- @class dota2.events.nommed_tree
--- @field PlayerID PlayerID

--- @class dota2.events.dota_rune_activated_server
--- @field PlayerID PlayerID
--- @field rune integer

--- @class dota2.events.dota_player_gained_level
--- @field player integer
--- @field player_id PlayerID
--- @field level integer
--- @field hero_entindex EntityIndex
--- @field PlayerID PlayerID

--- @class dota2.events.dota_player_learned_ability
--- @field PlayerID PlayerID
--- @field player integer
--- @field abilityname string

--- @class dota2.events.dota_player_used_ability
--- @field PlayerID PlayerID
--- @field abilityname string
--- @field caster_entindex EntityIndex

--- @class dota2.events.dota_non_player_used_ability
--- @field abilityname string
--- @field caster_entindex EntityIndex

--- @class dota2.events.dota_player_begin_cast
--- @field PlayerID PlayerID
--- @field abilityname string
--- @field caster_entindex EntityIndex

--- @class dota2.events.dota_non_player_begin_cast
--- @field abilityname string
--- @field caster_entindex EntityIndex

--- @class dota2.events.dota_ability_channel_finished
--- @field abilityname string
--- @field interrupted boolean
--- @field caster_entindex EntityIndex

--- @class dota2.events.dota_holdout_revive_complete
--- @field caster integer
--- @field target integer
--- @field channel_time number

--- @class dota2.events.dota_holdout_revive_eliminated
--- @field caster integer
--- @field target integer
--- @field channel_time number

--- @class dota2.events.dota_player_killed
--- @field PlayerID PlayerID
--- @field HeroKill boolean
--- @field TowerKill boolean

--- @class dota2.events.dota_assist_earned
--- @field entindex_hero EntityIndex

--- @class dota2.events.bindpanel_open

--- @class dota2.events.bindpanel_close

--- @class dota2.events.keybind_changed

--- @class dota2.events.dota_item_drag_begin

--- @class dota2.events.dota_item_drag_end

--- @class dota2.events.dota_shop_item_drag_begin

--- @class dota2.events.dota_shop_item_drag_end

--- @class dota2.events.dota_item_purchased
--- @field PlayerID PlayerID
--- @field itemname string
--- @field itemcost integer

--- @class dota2.events.dota_item_combined
--- @field PlayerID PlayerID
--- @field itemname string
--- @field itemcost integer

--- @class dota2.events.dota_item_used
--- @field PlayerID PlayerID
--- @field itemname string

--- @class dota2.events.dota_item_auto_purchase
--- @field item_id integer

--- @class dota2.events.dota_unit_event
--- @field victim integer
--- @field attacker integer
--- @field basepriority integer
--- @field priority integer
--- @field eventtype integer EDOTAHeroChaseEventType.

--- @class dota2.events.dota_quest_started
--- @field questIndex integer Entity index.

--- @class dota2.events.dota_quest_completed
--- @field questIndex integer Entity index.

--- @class dota2.events.gameui_activated

--- @class dota2.events.gameui_hidden

--- @class dota2.events.player_fullyjoined
--- @field userid EntityIndex User ID on server.
--- @field name string Player name.

--- @class dota2.events.dota_spectate_hero
--- @field entindex EntityIndex

--- @class dota2.events.dota_match_done
--- @field winningteam integer The ID of the winning team.

--- @class dota2.events.dota_match_done_client

--- @class dota2.events.joined_chat_channel
--- @field channelName string

--- @class dota2.events.left_chat_channel
--- @field channelName string

--- @class dota2.events.gc_chat_channel_list_updated

--- @class dota2.events.file_downloaded
--- @field success boolean
--- @field local_filename string
--- @field remote_url string

--- @class dota2.events.player_report_counts_updated
--- @field positive_remaining integer
--- @field negative_remaining integer
--- @field positive_total integer
--- @field negative_total integer

--- @class dota2.events.scaleform_file_download_complete
--- @field success boolean
--- @field local_filename string
--- @field remote_url string

--- @class dota2.events.item_purchased
--- @field itemid integer

--- @class dota2.events.gc_mismatched_version

--- @class dota2.events.dota_workshop_fileselected
--- @field filename string

--- @class dota2.events.dota_workshop_filecanceled

--- @class dota2.events.rich_presence_updated

--- @class dota2.events.live_leagues_updated

--- @class dota2.events.dota_hero_random
--- @field userid EntityIndex
--- @field heroid integer

--- @class dota2.events.dota_river_painted
--- @field userid EntityIndex
--- @field riverid integer

--- @class dota2.events.dota_scan_used
--- @field teamnumber integer

--- @class dota2.events.dota_scan_found_enemy
--- @field teamnumber integer

--- @class dota2.events.dota_rd_chat_turn
--- @field userid EntityIndex

--- @class dota2.events.dota_ad_nominated_ban
--- @field heroid integer

--- @class dota2.events.dota_ad_ban
--- @field heroid integer

--- @class dota2.events.dota_ad_ban_count
--- @field count integer

--- @class dota2.events.dota_ad_hero_collision
--- @field heroid integer
--- @field playerid1 PlayerID
--- @field playerid2 PlayerID

--- @class dota2.events.dota_favorite_heroes_updated

--- @class dota2.events.profile_opened

--- @class dota2.events.profile_closed

--- @class dota2.events.item_preview_closed

--- @class dota2.events.dashboard_switched_section
--- @field section integer

--- @class dota2.events.dota_tournament_item_event
--- @field winner_count integer
--- @field event_type integer

--- @class dota2.events.dota_hero_swap
--- @field playerid1 PlayerID
--- @field playerid2 PlayerID

--- @class dota2.events.dota_reset_suggested_items

--- @class dota2.events.halloween_high_score_received

--- @class dota2.events.halloween_phase_end
--- @field phase integer
--- @field team integer

--- @class dota2.events.halloween_high_score_request_failed

--- @class dota2.events.dota_hud_skin_changed
--- @field skin string
--- @field style integer

--- @class dota2.events.dota_inventory_player_got_item
--- @field itemname string

--- @class dota2.events.player_is_experienced

--- @class dota2.events.player_is_notexperienced

--- @class dota2.events.dota_tutorial_lesson_start

--- @class dota2.events.dota_tutorial_task_advance

--- @class dota2.events.dota_tutorial_shop_toggled
--- @field shop_opened boolean

--- @class dota2.events.map_location_updated

--- @class dota2.events.richpresence_custom_updated

--- @class dota2.events.game_end_visible

--- @class dota2.events.enable_china_logomark

--- @class dota2.events.highlight_hud_element
--- @field elementname string
--- @field duration number

--- @class dota2.events.hide_highlight_hud_element

--- @class dota2.events.intro_video_finished

--- @class dota2.events.matchmaking_status_visibility_changed

--- @class dota2.events.practice_lobby_visibility_changed

--- @class dota2.events.dota_courier_transfer_item
--- @field hero_entindex EntityIndex
--- @field courier_entindex EntityIndex
--- @field item_entindex EntityIndex

--- @class dota2.events.full_ui_unlocked

--- @class dota2.events.client_disconnect
--- @field reason_code integer
--- @field reason_desc string

--- @class dota2.events.hero_selector_preview_set
--- @field setindex integer

--- @class dota2.events.antiaddiction_toast
--- @field message string
--- @field duration number

--- @class dota2.events.hero_picker_shown

--- @class dota2.events.hero_picker_hidden

--- @class dota2.events.dota_local_quickbuy_changed

--- @class dota2.events.hud_flip_changed
--- @field flipped boolean

--- @class dota2.events.frosty_points_updated

--- @class dota2.events.defeated
--- @field entindex EntityIndex

--- @class dota2.events.reset_defeated

--- @class dota2.events.booster_state_updated

--- @class dota2.events.tree_cut
--- @field tree_x number
--- @field tree_y number

--- @class dota2.events.ugc_details_arrived
--- @field published_file_id integer

--- @class dota2.events.ugc_subscribed
--- @field published_file_id integer

--- @class dota2.events.ugc_unsubscribed
--- @field published_file_id integer

--- @class dota2.events.ugc_download_requested
--- @field published_file_id integer

--- @class dota2.events.ugc_installed
--- @field published_file_id integer

--- @class dota2.events.prizepool_received
--- @field success boolean
--- @field prizepool integer
--- @field leagueid integer

--- @class dota2.events.microtransaction_success
--- @field txnid integer

--- @class dota2.events.dota_rubick_ability_steal
--- @field abilityIndex integer
--- @field abilityLevel integer

--- @class dota2.events.community_cached_names_updated

--- @class dota2.events.spec_item_pickup
--- @field player_id PlayerID
--- @field item_name string
--- @field purchase boolean
--- @field gift boolean
--- @field gift_player_id PlayerID

--- @class dota2.events.spec_aegis_reclaim_time
--- @field reclaim_time number

--- @class dota2.events.account_all_hero_challenge_changed
--- @field account_id integer

--- @class dota2.events.team_showcase_ui_update
--- @field show boolean
--- @field account_id integer
--- @field hero_entindex EntityIndex
--- @field display_ui_on_left boolean

--- @class dota2.events.dota_match_signout

--- @class dota2.events.dota_illusions_created
--- @field original_entindex EntityIndex

--- @class dota2.events.dota_year_beast_killed
--- @field killer_player_id PlayerID
--- @field message integer
--- @field beast_id integer

--- @class dota2.events.dota_player_spawned
--- @field PlayerID PlayerID

--- @class dota2.events.dota_hero_undoselection
--- @field playerid1 PlayerID

--- @class dota2.events.dota_challenge_socache_updated

--- @class dota2.events.dota_player_team_changed

--- @class dota2.events.party_invites_updated

--- @class dota2.events.lobby_invites_updated

--- @class dota2.events.custom_game_mode_list_updated

--- @class dota2.events.custom_game_lobby_list_updated

--- @class dota2.events.friend_lobby_list_updated

--- @class dota2.events.dota_team_player_list_changed

--- @class dota2.events.dota_player_connection_state_changed

--- @class dota2.events.dota_player_details_changed

--- @class dota2.events.custom_game_player_count_updated
--- @field custom_game_id integer

--- @class dota2.events.custom_game_friends_played_updated
--- @field custom_game_id integer

--- @class dota2.events.custom_games_friends_play_updated

--- @class dota2.events.dota_player_update_assigned_hero
--- @field playerid PlayerID

--- @class dota2.events.dota_player_hero_selection_dirty

--- @class dota2.events.dota_npc_goal_reached
--- @field npc_entindex EntityIndex Entity index of the npc which was following a path and has reached a goal entity.
--- @field goal_entindex EntityIndex Entity index of the path goal entity which has been reached.
--- @field next_goal_entindex EntityIndex Entity index of the next goal entity on the path (if any) which the npc will now be pathing towards.

--- @class dota2.events.dota_player_selected_custom_team
--- @field player_id PlayerID Player id of the player who select a team.
--- @field team_id integer Id of the team the player selected.
--- @field success boolean Was the player successfully assigned to the selected team.

--- @class dota2.events.dota_coin_wager
--- @field userid EntityIndex
--- @field message integer
--- @field coins integer

--- @class dota2.events.dota_wager_token
--- @field userid EntityIndex
--- @field message integer
--- @field amount integer

--- @class dota2.events.dota_rank_wager
--- @field userid EntityIndex

--- @class dota2.events.dota_bounty
--- @field userid EntityIndex
--- @field target integer
--- @field bounty_event integer

--- @class dota2.events.dota_candy
--- @field userid EntityIndex
--- @field candy_event integer

--- @class dota2.events.dota_ad_randomed
--- @field userid EntityIndex
--- @field item_ability_id integer

--- @class dota2.events.colorblind_mode_changed

--- @class dota2.events.dota_report_submitted
--- @field result integer
--- @field report_flags integer
--- @field message string

--- @class dota2.events.client_reload_game_keyvalues

--- @class dota2.events.dota_hero_inventory_item_change
--- @field player_id integer
--- @field hero_entindex EntityIndex
--- @field item_entindex EntityIndex
--- @field item_ability_id integer
--- @field removed boolean
--- @field dropped boolean
--- @field sold boolean
--- @field in_sellback_windown boolean

--- @class dota2.events.game_rules_shutdown

--- @class dota2.events.aegis_event
--- @field player_id PlayerID
--- @field chat_message_type integer

--- @class dota2.events.dota_buyback
--- @field entindex EntityIndex
--- @field player_id integer

--- @class dota2.events.bought_back
--- @field player_id PlayerID

--- @class dota2.events.dota_shrine_kill
--- @field killer_userid EntityIndex
--- @field teamnumber integer
--- @field gold integer

--- @class dota2.events.particle_system_start
--- @field targetname string

--- @class dota2.events.particle_system_stop
--- @field targetname string
--- @field immediate boolean

--- @class dota2.events.dota_combat_event_message
--- @field message string
--- @field teamnumber integer
--- @field player_id integer
--- @field player_id2 integer
--- @field value number
--- @field value1 number
--- @field value2 number
--- @field value3 number
--- @field int_value integer
--- @field int_value2 integer
--- @field ability_name string
--- @field locstring_value string
--- @field locstring_value2 string
--- @field string_replace_token string

--- @class dota2.events.dota_item_spawned
--- @field item_ent_index EntityIndex
--- @field player_id integer

--- @class dota2.events.dota_player_reconnected
--- @field player_id integer

--- @class dota2.events.dota_on_hero_finish_spawn
--- @field heroindex integer
--- @field hero string

--- @class dota2.events.dota_creature_gained_level
--- @field entindex EntityIndex
--- @field level integer

--- @class dota2.events.dota_hero_teleport_to_unit
--- @field hero_entindex EntityIndex
--- @field unit_entindex EntityIndex

--- @class dota2.events.dota_neutral_creep_camp_cleared
--- @field camp_name string
--- @field camp_type integer
--- @field killer_player_id integer

--- @class dota2.events.dota_watch_tower_captured
--- @field entindex EntityIndex
--- @field team_number integer
--- @field old_team_number integer

--- @class dota2.events.dota_team_kill_credit
--- @field killer_userid EntityIndex
--- @field victim_userid EntityIndex
--- @field teamnumber integer
--- @field herokills integer

--- @class dota2.events.npc_spawned
--- @field entindex EntityIndex
--- @field is_respawn integer

--- @class dota2.events.npc_spawn_finished
--- @field entindex EntityIndex

--- @class dota2.events.npc_replaced
--- @field old_entindex EntityIndex
--- @field new_entindex EntityIndex

--- @class dota2.events.entity_hurt
--- @field entindex_killed EntityIndex
--- @field entindex_attacker EntityIndex
--- @field entindex_inflictor EntityIndex
--- @field damagebits integer
--- @field damage number

--- The specified channel contains new messages.
--- @class dota2.events.chat_new_message
--- @field channel integer

--- The specified channel has had players leave or join.
--- @class dota2.events.chat_members_changed
--- @field channel integer


