---
title: Configuring TailwindCSS
date: 2020-09-12T17:44:03.000Z
excerpt: The TailwindCSS configs are pretty basic but there are some things to know about.
author: shane-robinson
draft:
seo:
  title:
  description:
  image: 2020/09/tailwindcss.png
images: # relative to /src/assets/images/
  feature:
  thumb: 2020/09/tailwindcss.png
  align: # object-center (default) - other options at https://tailwindcss.com/docs/object-position
  height: # optional. Default = h-48 md:h-1/3
tags:
  - tailwindcss
  - customization
---

The [TailwindCSS](https://tailwindcss.com/) settings for this system are very basic. But there are a few settings to note.

## tailwind.css

Because TailwindCSS uses [Normalize.css](https://necolas.github.io/normalize.css/) to set sensible defaults for all browsers, we lose basic formatting on many top level elements like Headers, \<a> and \<p> tags, etc. So you'll want to set your own overrides in the `/src/assets/css/tailwind.css` file. Here are the current settings for this system as of the writing of this post.

{% wrap "p-2 my-4 rounded-lg bg-red-100 text-gray-700 border border-red-300" %}

:fire: **NOTE:** We do set a couple text colors in this file. So if you're looking for them in the `/src/_data/colors.js` file, I left a comment there at the top to look here in the `/src/assets/css/tailwind.css` file.

{% endwrap %}

```css
/* /src/assets/css/tailwind.css  */
@tailwind base;

h1,
h2,
h3,
h4,
h5,
h6 {
	@apply font-semibold text-gray-700;
}
h1 {
	@apply text-4xl;
}
h2 {
	@apply pt-12 text-3xl;
}
h3 {
	@apply text-2xl;
}
h4 {
	@apply text-xl;
}
h5 {
	@apply text-lg;
}
p a,
li a,
blockquote a,
dd a {
	@apply font-medium text-indigo-700;
}
p {
	@apply mt-4;
}
.wrapper > p:first-of-type {
	@apply p-0 m-0;
}

ol {
	@apply pt-4 ml-8 list-decimal;
}
ul {
	@apply pt-4 ml-8 list-disc;
}
blockquote {
	@apply pl-4 m-4 border-l-4 border-gray-500;
}
code {
	@apply p-1 text-sm bg-gray-200 border border-gray-300 rounded-lg;
}
pre code {
	@apply bg-transparent border-0 rounded-none;
}

@tailwind components;

@tailwind utilities;
```

## tailwind.config.js

This system also uses TailwindCSS' built-in support for [PurgeCSS](https://www.npmjs.com/package/purgecss). And because the system uses `_data` files to control some CSS classes, we have to include them in the `/tailwind.config.js` settings file so those CSS classes are NOT purged.

And while we're in the `/tailwind.config.js` file, let's take a peek at those custom theme **height** values that were setup to allow Editors to control the Hero and Featured Images heights:

_(always check the [TailwindCSS Release Notes](https://tailwindcss.com/docs/release-notes) page for info on the other settings.)_

```js
// /tailwind.config.js
const defaultTheme = require('tailwindcss/defaultTheme')

module.exports = {
	purge: [
		'./src/**/*.html',
		'./src/**/*.njk',
		'./src/**/*.md',
		'./src/_data/colors.js',
		'./src/_data/structure.js',
	],
	experimental: {
		applyComplexClasses: true,
	},
	future: {
		removeDeprecatedGapUtilities: true,
	},
	theme: {
		extend: {
			// created my own heights so can specify for Heros
			height: (theme) => ({
				'1/2': '50vh',
				'3/4': '75vh',
				'9/10': '90vh',
				'1/1': '100vh',
				'1/3': 'calc(100vh / 3)',
				'1/4': 'calc(100vh / 4)',
				'1/5': 'calc(100vh / 5)',
			}),
		},
	},
	variants: {},
	plugins: [require('@tailwindcss/forms')],
}
```
