---
title: Wrap & Columns - Shortcodes
date: 2020-09-03T17:44:03.000Z
author: shane-robinson
excerpt: There's no way to create multiple columns in Markdown... Unless you use shortcodes!
draft: 
seo:
  title:
  description:
  image: 2020/09/columns.jpg
images: # relative to /src/assets/images/
  feature:
  thumb: 2020/09/columns.jpg
  slide:
tags:
  - shortcodes
  - wrap
  - columns
---

The columns below use the `wrap`, `columns`, and `cols` shortcodes as shown in the following code.

**Additional instructions are included in the `/utils/paired-shortcodes.js` file.**

> **NOTE:** in Markdown you must provide an empty line above a heading, as in the `## Columns` below or else it won't be processed by Markdown.

**The `wrap` wrapper is optional** and only used if you want to include any content within the "block."  
For example, if you wanted to wrap the columns in a background color _(like below)_ and include the header or other content in that block.

> **ALSO NOTE:** All the border, rounded, and background color stuff is optional and for example only. Margins and Padding are minimal on the `cols` shortcode _(p-4, m-2)_) in order to preserve responsive spacing.

{% raw %}

```js
{% wrap "px-2 mt-8 rounded-lg pb-2 border border-gray-300 bg-gray-200" %}

  ### Columns Example

  {% columns %}

    {% cols "bg-gray-100 rounded-lg" %}
      Left column
    {% endcols %}

    {% cols "bg-gray-100 rounded-lg" %}
      Right column
    {% endcols %}

  {% endcolumns %}

{% endwrap %}
```

{% endraw %}

{% wrap "px-2 mt-8 rounded-lg pb-2 border border-gray-300 bg-gray-200" %}

### Columns Example

{% columns %}

{% cols "bg-gray-100 rounded-lg" %}
Left column
{% endcols %}

{% cols "bg-gray-100 rounded-lg" %}
Right column
{% endcols %}

{% endcolumns %}

{% endwrap %}
