# 视频直播iOS端技术

直播架构

　　想必了解过直播的人都清楚直播主要分为3部分:推流->流媒体服务器->拉流。

![img](https://pic3.zhimg.com/80/v2-7fba8f181122e09818e7c7592caf88fe_720w.webp)

　　而我们今天需要讲的就是推流这部分，它主要包括音视频采集，音视频前处理，音视频编码，推流和传输4个方面。但是由于网络的复杂性和大数据的统计，推流还需要有全局负载均衡调度GSLB（Global Server Load Balance）,以及实时的统计数据上报服务器，包括提供频道管理给用户运营，因此推流SDK需要接入GSLB中心调度，统计服务器，心跳服务器，用于推流分配到网络最好的节点，有大数据的统计和分析。

![img](https://pic4.zhimg.com/80/v2-4a9b30dd3de6f53a4bc46e23b25722af_720w.webp)

　　下图涵盖了直播相关的所有服务，红色小标的线条代表指令流向，绿色小标的线条代表数据流向。

![img](https://pic3.zhimg.com/80/v2-d924c2a29a9e365c811b0feb89bfd96e_720w.webp)

　　●●●

直播技术点

![img](https://pic4.zhimg.com/80/v2-99dacb8cd68341a92d0344bdd76d9477_720w.webp)

　　音视频采集

　　采集是所有环节中的第一环，网易云通信与视频使用的系统原生框架AVFoundation采集数据。通过iPhone摄像头(AVCaptureSession)采集视频数据，通过麦克风(AudioUnit)采集音频数据。目前视频的采集源主要来自摄像头采集、屏幕录制（ReplayKit）、从视频文件读取推流。

　　音视频都支持参数配置。音频可以设置采样率、声道数、帧大小、音频码率、是否使用外部采集、是否使用外部音频前处理；视频可以设置帧率、码率、分辨率、前后摄像头、摄像头采集方向、视频端显示比例、是否开启摄像头闪光灯、是否打开摄像头响应变焦、是否镜像前置摄像头预览、是否镜像前置摄像头编码、是否打开滤镜功能、滤镜类型、是否打开水印支持、是否打开QoS功能、是否输出RGB数据、是否使用外部视频采集。

　　音视频处理

　　前处理模块也是主观影响主播观看效果最主要的环节。目前iOS端比较知名的是GPUImage，提供了丰富的预处理效果，我们也在此基础上进行了封装开发。视频前处理包含滤镜、美颜、水印、涂鸦等功能，同时在人脸识别和特效方面接入了第三方厂商FaceU。SDK内置4款滤镜黑白、自然、粉嫩、怀旧；支持16:9裁剪；支持磨皮和美白（高斯模糊加边缘检测）；支持静态水印，动态水印，涂鸦等功能。音频前处理则包括回声抑制、啸叫、增益控制等。音视频都支持外部前处理。

![img](https://pic1.zhimg.com/80/v2-ce8c118370a7571e1a9c34576ef3a4dc_720w.webp)

　　音视频编码

　　编码最主要的两个难点是:

　　处理硬件兼容性问题

　　在高FPS、低bitrate和音质画质之间找个一个平衡点

　　由于iOS端硬件兼容性比较好，因此可以采用硬编。SDK目前支持软件编码openH264，硬件编码VideoToolbox。而音频支持软件编码FDK-AAC和硬件编码AudioToolbox。

　　视频编码的核心思想就是去除冗余信息:

　　空间冗余:图像相邻像素之间有较强的相关性。

　　时间冗余:视频序列的相邻图像之间内容相似。

　　编码冗余:不同像素值出现的概率不同。

　　视觉冗余:人的视觉系统对某些细节不敏感。

　　音视频发送

　　推流SDK使用的流媒体协议是RTMP（RealTime Messaging Protocol）。而音视频发送最困难的就是针对网络的带宽评估。由于从直播端到RTMP服务器的网络情况复杂，尤其是在3G和带宽较差的Wifi环境下，网络丢包、抖动和延迟经常发生，导致直播推流不畅。RTMP基于TCP进行传输，TCP自身实现了网络拥塞下的处理，内部的机制较为复杂，而且对开发者不可见，开发者无法根据TCP协议的信息判断当时的网络情况，导致发送码率大于实际网络带宽，造成比较严重的网络拥塞。因此我们自研开发了一款实时根据网络变化的QoS算法，用于实时调节码率、帧率、分辨率，同时将数据实时上报统计平台。

　　●●●

　　模块设计&线程模型

　　模块设计

　　鉴于推流的主流程分为上述描述的4个部分：音视频采集、音视频前处理、音视频编码、音视频发送。因此将推流SDK进行模块划分为LSMediacapture层（对外API+服务器交互）、视频融合模块（视频采集+视频前处理）、音频融合模块（音频采集+音频前处理）、基础服务模块、音视频编码模块、网络发送模块。

![img](https://pic3.zhimg.com/80/v2-b5df0ed24f36202083b6395ae42e133e_720w.webp)

　　线程模型

　　推流SDK总共含有10个线程。视频包含AVCaptureSession的原始采集线程、前处理线程、硬件编码线程、数据流向定义的采集线程、编码线程、发送线程。音频包含AudioUnit包含的原始采集线程、数据流向定义的采集线程、编码线程、发送线程。在数据流向定义的采集线程、编码线程、发送线程之间会创建2个bufferQueue，用于缓存音视频数据。采集编码队列可以有效的控制编码码率，编码发送队列可以有效自适应网络推流。

![img](https://pic2.zhimg.com/80/v2-90d9e8bf70bac625ac813e450091b19d_720w.webp)

　　QoS&跳帧

　　下图是直播的主要流程，用户初始化SDK，创建线程，开始直播，音视频数据采集，编码，发送。在发送线程下，音视频数据发送，QoS开启，根据网络实时评估带宽，调整帧率，码率控制编码器参数，同时触发跳帧，调整分辨率控制采集分辨率参数。用户停止直播，反初始化SDK，销毁线程。QoS&跳帧可以有效的解决用户在网络不好的情况下，直播卡顿的问题。在不同的码率和分辨率情况下，都能够做到让用户流畅地观看视频直播。

![img](https://pic4.zhimg.com/80/v2-2b8310a58acd9abddf1e9069744920e3_720w.webp)

原文https://zhuanlan.zhihu.com/p/31178008