# iOS音视频同步探讨

## 1.音视频同步的原理

音视频采集的数据分别来自于麦克风与摄像头，而摄像头与麦克风其实是两个独立的硬件，而音视频同步的原理是相信摄像头与麦克风采集数据是实时的，并在采集到数据时给他们一个时间戳来标明数据所属的时间，而编码封装模块只要不改动音视频时间的相对关系就能保证音频与视频在时间上的对应。如此封装好数据之后，播放端就能够根据音视频的时间戳来播放对应的音视频，从实现音视频同步的效果。

## 2.时间戳参考标准

- 取格林威治时间做为对比标准，即音视频时间戳都为采集时间点相对于格林威治标准时间的时间差
- 取系统开机时间做为对比标准，即音视频时间戳都是采集时间点相对于手机开机时间的时间差。目前iOS上AVCaptureSession这套API就是参考这个时间标准给的时间戳
- 其它时间戳标准

## 3.基于“开源项目1”的音视频同步探讨

- 原生某开源框架

- - 如图：

![img](https://pic2.zhimg.com/80/v2-739435aa0160ba1a3cfa530b6d9f1e55_720w.webp)

- - 简介

  - - 音/视频被采集到之后会先经过音/视频处理模块，音/视频在被处理之后才进入计算时间戳的模块
    - 在第一帧到达时记一个计时起点，然后根据采集的帧间隔对接下来每一帧的时间戳进行计算：frameTimeStamp = lastFrameTimeStamp + frameDuration

  - 优点

  - - 能输出**frame duration**稳定的音视频时间戳

  - 风险

  - - 无论是音频还是视频，在手机过热、性能不足等极端情况下有可能出现采集不稳定的情况，比如说预计1s采集30帧，实际只采集到28帧，而音视频的时间戳是通过累加来计算的，这样就有会出现音视频不同步的情况
    - **Video Process**(人脸检测、滤镜、3D贴纸)有可能无法在一帧时间内处理完当前帧，这样就会出现帧数比预期低的情况，从而出现音视频不同步
    - 帧间隔涉及到无限小数时，因为计算机的精度有限会引发的时间戳偏移，此偏移会随着帧数的增加而逐渐被放大

- 基于**开源项目1**的改进方案1

- - 如图：

![img](https://pic3.zhimg.com/80/v2-2e35a9575eb5093a27c8e6ec77975072_720w.webp)

- 简介

- - - 音/视频被采集到之后会先经过音/视频处理模块，音/视频在被处理之后才进入计算时间戳的模块
    - 时间戳的获取方法非常直接——每一帧都在改帧进入时间戳计算模块时获取当前系统时间作为时间戳

  - 优点：

  - - APP性能正常的情况下肯定不会出现音视频不同步
    - 能够实时纠正时间戳，只要APP正常运转，就能立即恢复正确的时间戳

  - 风险：

  - - 依赖**Video Process**与**Audio Process**模块处理时长相近，而实际工程中因为人脸检测、贴纸等原因，**Video Process**可能会出现阻塞的情况，从而导致临时性的音视频不同步
    - 在**Audio Process**与**Video Process**模块处理帧耗时不均匀的情况下会出现音视频时间戳不均匀的问题，能否正常播放依赖于终端

- 基于**开源项目1**的一个改进方案2

- - 如图：

![img](https://pic1.zhimg.com/80/v2-7c63822aec44096e639ccf6666b180bc_720w.webp)

- 简介

- - - 音/视频被采集到之后，先获取采集模块提供的音视频时间戳，然后在音/视频处理模块透传采集模块获取到的音/视频时间戳，在时间戳计算模块继续透传采集模块给的时间戳

    - 优点：

    - - 除非采集模块给出错误数据，否则音视频都一定是同步的

    - 风险：

    - - 可能会出现音视频时间戳不均匀的情况，尤其是在手机过热、性能不足等极端情况下

- 直播方向更进一步的优化探讨

- - 大致流程如图：



![img](https://pic1.zhimg.com/80/v2-ab7607b8c5cc174d48efca60fed39f30_720w.webp)

- 简介

- - - - 音/视频被采集到之后，先获取采集模块提供的音视频时间戳，然后在音/视频处理模块透传采集模块获取到的音/视频时间戳
      - 在时间戳计算模块透传视频时间戳，并根据下文中提到的方法计算音频时间戳

    - 音频时间戳计算方法

    - - 实时计算时间戳：当前时间戳=起始时间戳+帧数*帧采样数/采样率
      - 如果时间戳偏移量超出阈值，纠正时间戳
      - 纠正频率达到超出阈值，直接透传采集时间戳

    - 优点：

    - - 能够提供一个稳定的音频时间戳，可以兼容帧间隔小幅抖动造成的音频时间戳不均匀
      - 兼容性能不足时导致实际采集帧数低于帧率

    - 风险

    - - 纠正时间戳时可能会造成声音卡顿的感觉

- 总结

- - 具体方案最好是针对实际应用场景有选择性的做优化，比如说，在可以控制播放器策略的情况，可以考虑根据自研播放器特性做时间戳处理。而如果播放器不可控，则尽量通过策略保障帧间隔稳定。

原文https://zhuanlan.zhihu.com/p/28557179