# iOS:学习音视频的过程

## 1.音视频学习中涉及到的概念

1.我们常见的音视频格式有.mp4,mkv.avi,正如我们常见的.word 需要word 工具打开，不同格式的音视频也需要不同格式的播放器打开，这种视频格式相当于存储视频信息的容器，里面包含了音频信息，视频信息和相关的配置信息（比如.mp4格式 音视频是如何关联的信息，如何解码等）

2.封装格式：简单的来说就是一个容器，里面存储已经编码压缩好的视频数据 和 音频数据，按照一定的格式存放到一个文件中，这个文件可以称之为容器；通常除了存储音频/视频数据，还有存放音视频同步的元数据比如说字幕。

常见的视频容器格式有：mp4 mov AVI  mkv 等等

通俗的来说：

容器指的是一种音视频文件格式比如.avi，协议指的是存放在音视频文件中的数据的编解码方式，一个容器可以装有各种不同的编解码方式的数据，每种编解码方式都需要不同的编解码器。MPEG、H.26X等等编码方式比较常见。 AVI、MPG、MP4等等容器比较常见。

## 2.视频编解码方式

视频解编码的过程：对数字视频进行压缩或者解压缩 的一个过程，这期间需要考虑：视频的质量，视频的码率（用来表示视频所需要的数据量），编码算法/解码算法的复杂度，针对数据存储的错误与延迟等等因素

### 2.1 常见的编码方式有

H.26X系列，其中H.265被称为高效视频编码，常用的是H.264，优势在于低码率，高质量的图像，容错能力强，网络适用性强
MPEG系列
视频编解码方式与视频封装格式之间有啥关系呐？

【视频封装格式】可以理解为 装着视频/音频/【视频编解码方式】等信息的容器

一种视频封装格式可以支持多种视频编码方式，但是无法确切的知道视频编解码方式

### 2.2音频编码方式

视频中除了画面通常还有声音这就涉及到了音频编解码。视频中经常使用的音频编码方式有AAC，MP3等等，中AAC是目前比较热门的有损压缩编码技术。

为什么要做音频编码：从存储的角度或者实时传播的角度来说，数据量较大，所以需要通过压缩编码

压缩编码的基本指标是压缩比，压缩比通常小于1，如果大于1就没有意义了，压缩算法分为2种有损压缩+无损压缩

无损压缩：解压后的数据可以完全复原，有所压缩用的较多
有损压缩：解压后的数据不能完全复原，会丢失一部分信息，压缩比越小，丢失的信息就会越多，信号还有的失真就会越大
压缩编码的原理实际上就是压缩冗余的信号.冗余信号就是指不能被人耳感知的信号.包括人耳听觉范围之外的音频信号以及被掩盖掉的音频信号.

何为编码？编码就是按照一杜杰不到个格式记录采样和量化后的数据

硬编码: 使用非CPU进行编码,例如使用GPU芯片处理，性能高，低码率下通常质量低于硬编码器，但部分产品在GPU硬件平台移植了优秀的软编码算法（如X264）的，质量基本等同于软编码。
软编码: 使用CPU来进行编码计算.实现直接、简单，参数调整方便，升级易，但CPU负载重，性能较硬编码低，低码率下质量通常比硬编码要好一点。

## 3.直播项目的流程

音视频采集
主要使用原生框架AVFoundation.framework

视频滤镜
开发中比较倾向于第三方框架GPUImage，框架是基于OpenGL ES

音视频编码压缩
硬编码：

视频: VideoToolBox框架                   音频: AudioToolBox 框架

软编码：

视频: 使用FFmpeg,X264算法把视频原数据YUV/RGB编码成H264

音频: 使用fdk_aac 将音频数据PCM转换成AAC

推流
什么是推流？将采集的音频.视频数据通过流媒体协议发送到流媒体服务器

推流的技术如下：

.1流媒体协议: RTMP\RTSP\HLS\FLV

RTMP：长连接（TCP）每个时刻的数据收到立刻转发，低延时，跨平台差

HLS：基于http协议，集合一段时间数据，生成 ts 切片文件。

.2视频封装格式: TS\FLV

.3音频封装格式: Mp3\AAC

流媒体服务器处理
.1数据分发  .2 截屏 .3实时转码 .4内容检测

拉流
什么是拉流？从流媒体服务器中 获取音频\视频数据；

拉流框架有：LFLiveKit，七牛等。

音视频解码
硬解码：

视频: VideoToolBox框架                   音频: AudioToolBox 框架

软解码：

视频: 使用FFmpeg,X264算法解码

音频: 使用fdk_aac 解码

音视频播放
ijkplayer /kxmovie 播放框架；全部都是基于FFmpeg框架封装的

从网上盗了张图，方便了解直播的整个流程。


原文链接：https://blog.csdn.net/qq_33726122/article/details/89182802