# <h3 id="subject_001">面试题1</h3>

为什么巨大的原始视频可以编码成很小的视频呢?这其中的技术是什么呢?

##### 参考答案

* 1）空间冗余：图像相邻像素之间有较强的相关性
* 2）时间冗余：视频序列的相邻图像之间内容相似
* 3）编码冗余：不同像素值出现的概率不同
* 4）视觉冗余：人的视觉系统对某些细节不敏感
* 5）知识冗余：规律性的结构可由先验知识和背景知识得到

# <h3 id="subject_002">面试题2</h3>

怎么做到直播秒开优化？

##### 参考答案

* DNS 解析慢
  为了有效降低 DNS 解析对首开的影响，我们可以提前完成播放域名->IP 地址的解析，
  并缓存起来，播放的时候，直接传入带 IP 地址的播放地址，从而省去了 DNS 解析的耗时。
  如果要支持用 IP 地址播放，是需要修改底层 ffmpeg 源码的。

* 播放策略
  很多侧重点播的播放器，为了减少卡顿，会有一些缓冲策略，当缓冲足够多的数据之后 ，再送入解码播放。

而为了加快首开效果，需要对播放的缓冲策略做一些调整，如果第一帧还没有渲染出来的情况下，
不要做任何缓冲，直接送入解码器解码播放，这样就可以保证没有任何因为「主动」缓冲带来的首开延时。

* 播放参数设置
  所有基于 ffmpeg 的播放器，都会遇到avformat_find_stream_info这个函数耗时比较久，
  从而增大了首开时间，该函数主要作用是通过读取一定字节的码流数据，
  来分析码流的基本信息，如编码信息、时长、码率、帧率等等，它由两个参数来控制其读取的数据量大小和时长，
  一个是 probesize，一个是 analyzeduration。

减少 probesize 和 analyzeduration 可以有效地减少avformat_find_stream_info的函数耗时，
从而加快首开，但是需要注意的是，设置地太小可能会导致读取的数据量不足，从而无法解析出码流信息，导致播放失败，
或者出现只有音频没有视频，只有视频没有音频的问题。

* 服务端优化
* 服务器关键帧缓冲
* CDN最近策略

# <h3 id="subject_003">面试题3</h3>

直方图在图像处理里面最重要的作用是什么？

##### 参考答案

1. 灰度直方图的定义：灰度级的函数，描述图像中该灰度级的像素个数或该灰度级像素出现的频率。反映了图像灰度分布的情况。
2. 灰度直方图只能反映图像的灰度分布情况，不能反映图像像素的位置，即所有的空间信息全部丢失。

* 直方图的应用：

* a.数字化参数：判断一幅图像是否合理的利用了全部被允许的灰度级范围。一般一幅图应该利用全部或几乎全部可能的灰度级，否则等于增加了量化间隔，丢失的信息将不能恢复。
* b.边界阈值选取（确定图像二值化的阈值）：假定某图像的灰度直方图具有二峰性，则表明这个图像的较亮区域和较暗区域可以很好地分离，以这一点为阈值点，可以得到很好地2值处理效果（区分物体与背景）。
* c.当物体部分的灰度值比其他部分的灰度值大时，可利用直方图统计图像中物体的面积。
* d.计算图像的信息量H。

# <h3 id="subject_004">面试题4</h3>

数字图像滤波有哪些方法？

##### 参考答案

均值滤波（邻域平均法）、中值滤波（消除独立的噪声点）、高斯滤波（线性平滑滤波，消除高斯噪声，对整幅图像进行加权平均，每一个像素点的值都由其本身和邻域内的其他像素值经过加权平均后得到）、KNN滤波、高通滤波、低通滤波等。

# <h3 id="subject_005">面试题5</h3>

图像可以提取的特征有哪些？

##### 参考答案

颜色、纹理（粗糙度、方向度、对比度）、形状（曲率、离心率、主轴方向）、色彩等。

# <h3 id="subject_005">面试题6</h3>

衡量图像重建好坏的标准有哪些？怎样计算？

##### 参考答案

* SNR（信噪比）

* PSNR=10*log10((2^n-1)^2/MSE)
  （MSE是原图像与处理图像之间均方误差，所以计算PSNR需要2幅图像的数据！）

* SSIM
  （结构相似性分别从亮度对比度、对比度、结构3方面度量图像的相似性）


# <h3 id="subject_007">面试题7</h3>

AAC和PCM的区别？

##### 参考答案

AAC在数据开始时候加了一些参数：采样率、声道、采样大小

# <h3 id="subject_008">面试题8</h3>

H264存储的两个形态？

##### 参考答案

* a. Annex B : 

>StartCode ：NALU单元，开头一般是0001或者001<br/>
>防竞争字节：为了区分 0 0 0 1，它采用0 0 0 0x3 1作为区分<br/>
>多用于网络流媒体中：rtmp、rtp格式

* b. AVCC :

>表示NALU长度的前缀，不定长用4、2、1来存储这个NALU的长度<br/>
>防竞争字节<br/>
>多用于文件存储中mp4的格式

# <h3 id="subject_009">面试题9</h3>

FFMPEG:图片如何合成视频

##### 参考答案

编码流程：

1. av_register_all
2. 为AVFormatContext  分配内存
3. 打开文件
4. 创建输出码流AVSream
5. 找到编码器
6. 打开编码器
7. 写文件头，没有的就不写入
8. 循环编码视频像素数据->视频压缩数据

>*  循环编码音频采样数据->音频压缩数据  ———>AVFrame转化为AVPacket
>
>9. 将编码后的视频码流写入文件  ——>AVPacket转化为AVFormat函数

10. 关闭编码器
11. 写文件尾
12. 关闭资源文件

解码流程：

1. av_register_all
2. 创建AVFormatContext的对象上下文
3. 打开文件
4. avformat_find_stream_info
5. 找到解码器
6. 打开解码器
7. 创建AVCodecContext上下文
8. av_read_frame ：将avPacket数据转换为avFrame数据

glUniform1i() ——>这个可以设置对应纹理的第几层
glTexSubImage2D() 和glTexImage2D区别————>替换纹理的内容

# <h3 id="subject_010">面试题10</h3>

常见的音视频格式有哪些？

##### 参考答案

1. MPEG（运动图像专家组）是Motion Picture Experts Group 的缩写。这类格式包括了MPEG-1,MPEG-2和MPEG-4在内的多种视频格式。
2. AVI，音频视频交错(Audio Video Interleaved)的英文缩写。AVI这个由微软公司发布的视频格式，在视频领域可以说是最悠久的格式之一。
3. MOV，使用过Mac机的朋友应该多少接触过QuickTime。QuickTime原本是Apple公司用于Mac计算机上的一种图像视频处理软件。
4. ASF(Advanced Streaming format高级流格式)。ASF 是MICROSOFT 为了和的Real player 竞争而发展出来的一种可以直接在网上观看视频节目的文件压缩格式。
5. WMV，一种独立于编码方式的在Internet上实时传播多媒体的技术标准，Microsoft公司希望用其取代QuickTime之类的技术标准以及WAV、AVI之类的文件扩展名。
6. NAVI，如果发现原来的播放软件突然打不开此类格式的AVI文件，那你就要考虑是不是碰到了n AVI。n AVI是New AVI 的缩写，是一个名为Shadow Realm 的地下组织发展起来的一种新视频格式。
7. 3GP是一种3G流媒体的视频编码格式，主要是为了配合3G网络的高传输速度而开发的，也是目前手机中最为常见的一种视频格式。
8. REAL VIDEO（RA、RAM）格式由一开始就是定位在视频流应用方面的，也可以说是视频流技术的始创者。
9. MKV，一种后缀为MKV的视频文件频频出现在网络上，它可在一个文件中集成多条不同类型的音轨和字幕轨，而且其视频编码的自由度也非常大，可以是常见的DivX、XviD、3IVX，甚至可以是RealVideo、QuickTime、WMV 这类流式视频。
10. FLV是FLASH VIDEO的简称，FLV流媒体格式是一种新的视频格式。由于它形成的文件极小、加载速度极快，使得网络观看视频文件成为可能，它的出现有效地解决了视频文件导入Flash后，使导出的SWF文件体积庞大，不能在网络上很好的使用等缺点。
11. F4V，作为一种更小更清晰，更利于在网络传播的格式，F4V已经逐渐取代了传统FLV，也已经被大多数主流播放器兼容播放，而不需要通过转换等复杂的方式。

# <h3 id="subject_011">面试题11</h3>

请指出“1080p”的意义？

# <h3 id="subject_012">面试题12</h3>

请解释颜色的本质及其数字记录原理，并说出几个你所知道的色域。

# <h3 id="subject_013">面试题13</h3>

请解释“矢量图”和“位图”的区别？

# <h3 id="subject_014">面试题14</h3>

请从“光圈”“快门速度”“感光度”“白平衡”“景深”中任选2个进行叙述？

# <h3 id="subject_015">面试题15</h3>

视频分量YUV的意义及数字化格式？

##### 参考答案

4:2:0；4:1:1；4:2:2；4:4:4；多种

# <h3 id="subject_016">面试题16</h3>

在MPEG标准中图像类型有哪些？

##### 参考答案

I帧图像，  P帧图像，  B帧图像

# <h3 id="subject_017">面试题17</h3>

列举一些音频编解码常用的实现方案？

##### 参考答案

* 第一种就是采用专用的音频芯片对 语音信号进行采集和处理，音频编解码算法集成在硬件内部，如 MP3 编解码芯片、语音合成 分析芯片等。使用这种方案的优点就是处理速度块，设计周期短；缺点是局限性比较大，不灵活，难以进行系统升级。
* 第二种方案就是利用 A/D 采集卡加上计算机组成硬件平台，音频编解码算法由计算机上的软件来实现。使用这种方案的优点是价格便 宜，开发灵活并且利于系统的升级；缺点是处理速度较慢，开发难度较大。
* 第三种方案是使用高精度、高速度 的 A/D 采集芯片来完成语音信号的采集，使用可编程的数据处理能力强的芯片来实现语音信号处理的算法，然后 用 ARM 进行控制。采用这种方案的优点是系统升级能力强，可以兼容多种音频压缩格式甚至未来的音频压缩格 式，系统成本较低；缺点是开发难度较大，设计者需要移植音频的解码算法到相应的 ARM 芯 片中去。

# <h3 id="subject_018">面试题18</h3>

请叙述MPEG视频基本码流结构？

##### 参考答案

1. Sequence Header
2. Sequence Extention
3. Group of picture Header
4. Picture Header
5. Picture coding extension

# <h3 id="subject_019">面试题19</h3>

sps和pps的区别？

##### 参考答案

SPS是序列参数集    0x67
PPS是图像参数集    0x68
在SPS序列参数集中可以解析出图像的宽，高和帧率等信息。而在h264文件中，最开始的两帧数据就是SPS和PPS，这个h264文件只存在一个SPS帧和一个PPS帧。

# <h3 id="subject_020">面试题20</h3>

请叙述AMR基本码流结构？

##### 参考答案

AMR文件由文件头和数据帧组成，文件头标识占6个字节，后面紧跟着就是音频帧；

格式如下所示：

文件头（占 6 字节）|
：--- |
语音帧1 |
语音帧2 |
… |

* 文件头：
  单声道和多声道情况下文件的头部是不一致的，单声道情况下的文件头只包括一个Magic number，而多声道情况下文件头既包含Magic number，在其之后还包含一个32位的Chanel description field。多声道情况下的32位通道描述字符，前28位都是保留字符，必须设置成0，最后4位说明使用的声道个数。

* 语音数据：
  文件头之后就是时间上连续的语音帧块了，每个帧块包含若干个8位组对齐的语音帧，相对于若干个声道，从第一个声道开始依次排列。每一个语音帧都是从一个8位的帧头开始：其中P为填充位必须设为0，每个帧都是8位组对齐的。

# <h3 id="subject_021">面试题21</h3>

说一说ffmpeg的数据结构？

##### 参考答案

ffmpeg的数据结构可以分为以下几类：
![image](https://user-images.githubusercontent.com/87458342/127322083-11b41004-9943-45e5-879c-978e8cfd089f.png)

* (1)解协议（http,rtsp,rtmp,mms）
  AVIOContext，URLProtocol，URLContext主要存储视音频使用的协议的类型以及状态。
  URLProtocol存储输入音视频使用的封装格式。每种协议都对应一个URLProtocol结构。（注意：FFMPEG中文件也被当做一种协议“file”）
* (2)解封装（flv,avi,rmvb,mp4）
  AVFormatContext主要存储视音频封装格式中包含的信息
  ffmpeg支持各种各样的音视频输入和输出文件格式（例如FLV, MKV, MP4, AVI），而 AVInputFormat和AVOutputFormat 结构体则保存了这些格式的信息和一些常规设置。
* (3)解码（h264,mpeg2,aac,mp3）
  AVStream是存储每一个视频/音频流信息的结构体。
  AVCodecContext: 编解码器上下文结构体，存储该视频/音频流使用解码方式的相关数据。
  AVCodec: 每种视频（音频）编解码器(例如H.264解码器)对应一 个该结构体。
  三者的关系如下图:
  ![image](https://user-images.githubusercontent.com/87458342/127322117-99c30273-f25f-42a6-b9cc-16f5358ecf50.png)
* (4)存数据
  对于视频，每个结构一般是存一帧；音频可能有好几帧
  * 解码前数据：AVPacket
  * 解码后数据：AVFrame

# <h3 id="subject_022">面试题22</h3>

说一说AVFormatContext 和 AVInputFormat之间的关系？

##### 参考答案

![image](https://user-images.githubusercontent.com/87458342/127322362-0ff60540-c900-45b9-aa77-77835d7f7386.png)

* AVInputFormat被封装在AVFormatContext里
* AVFormatContext 作为API被外界调用
* AVInputFormat 主要是FFmpeg内部调用
* AVFormatContext里保存了视频文件封装格式相关信息，它是负责储存数据的结构体。而AVInputFormat代表了各个封装格式，属于方法，这是一种面向对象的封装。

通过 int avformat_open_input(AVFormatContext **ps, const char *filename,AVInputFormat *fmt, AVDictionary **options)函数装载解封装器.
AVFormatContext 和 AVInputFormat之间的关系

# <h3 id="subject_023">面试题23</h3>

说一说AVFormatContext, AVStream和AVCodecContext之间的关系？

##### 参考答案

![image](https://user-images.githubusercontent.com/87458342/127322480-74df8276-4929-44f5-a350-feebcfcaa0c4.png)

AVStream和AVpacket中都有index字段用于区分不同的码流（视频、音频、字幕等），AVFormatContext中包含输入的AVStream数组用于记录各个码流，nb_streams记录输入码流的数量。AVCodecContext记录着AVStream需要用那种解码器来进行解码。

# <h3 id="subject_024">面试题24</h3>

说一说视频拼接处理步骤？（细节处理，比如分辨率大小不一，时间处理等等）

##### 参考答案

解封装、解码、决定分辨率大小、编码、时间处理、封装。

# <h3 id="subject_025">面试题25</h3>

NV21如何转换成I420？

##### 参考答案

>首先需要明白为什么需要将NV21转换成I420，这是因为x264只支持编码I420的数据。
>实际上就是YUV420p与YUV420sp之间的转换。
>YUV420p与YUV420sp的相关知识请参考：《音视频基础知识-YUV图像》

# <h3 id="subject_026">面试题26</h3>

DTS与PTS共同点？

##### 参考答案

* PTS就是Presentation Time Stamp也就说这个帧什么时候会放在显示器上;
* DTS就是Decode Time Stamp，就是说这个帧什么时候被放在编码器去解。
  在没有B帧的情况下，DTS和PTS的输出顺序是一样的。

# <h3 id="subject_027">面试题27</h3>

影响视频清晰度的指标有哪些？

##### 参考答案

帧率
码率
分辨率
量化参数（压缩比）

# <h3 id="subject_028">面试题28</h3>

编解码处理时遇到什么困难？

##### 参考答案

ffmpeg 在编解码的过程：

* 使用 ffmpeg 的 libavcoder，libavformat 的库及可能性编解码
* 编码过程：
  * 采集出来的视频、音频数据使用 ffmpeg 进行压缩
  * 进行按连续的视频，音频进行分组打包，为了区分各种包，也要包加上包头，包头写上显示时间戳 PTS，解码时间戳 DTS，通过网络传输到播放端
* 解码过程：
  * 通过 TCP 协议接收到媒体流，FFmpeg 解封装，解码
  * 最终获取到原始视频 YUV，音频 PCM 格式，利用播放器进行播放

# <h3 id="subject_029">面试题29</h3>

如何秒开视频？什么是秒开视频？

##### 参考答案

* 1. 什么是秒开视频？
     秒开是指用户点击播放到看到画面的时间非常短，在 1 秒之内。

* 2. 为什么需要秒开？
     目前主流的直播协议是 RTMP，HTTP-FLV 和 HLS，都是基于 TCP 的长连接。在播放的过程中，若播放端所处的网络环境在一个较佳的状态，此时播放会很流畅。若网络环境不是很稳定，经常会发生抖动，如果播放端没有特殊处理，可能会经常发生卡顿，严重的甚至会出现黑屏。而移动直播由于其便捷性，用户可以随时随地发起和观看直播，我们无法保证用户的网络一直处于非常好的状态，所以，在网络不稳定的情况下保证播放的流畅度是非常重要的。

* 3. 解决思路

   * 3.1 获取关键帧后显示
     改写播放器逻辑让播放器拿到第一个关键帧后就给予显示。
     GOP 的第一个帧通常都是关键帧，由于加载的数据较少，可以达到 "首帧秒开"。如果直播服务器支持 GOP 缓存，意味着播放器在和服务器建立连接后可立即拿到数据，从而省却跨地域和跨运营商的回源传输时间。
     GOP 体现了关键帧的周期，也就是两个关键帧之间的距离，即一个帧组的最大帧数。假设一个视频的恒定帧率是 24fps（即 1 秒 24 帧图像），关键帧周期为 2s，那么一个 GOP 就是 48 张图像。一般而言，每一秒视频至少需要使用一个关键帧。
     增加关键帧个数可改善画质（GOP通常为 FPS 的倍数），但是同时增加了带宽和网络负载。这意味着，客户端播放器下载一个 GOP，毕竟该 GOP 存在一定的数据体积，如果播放端网络不佳，有可能不是能够快速在秒级以内下载完该 GOP，进而影响观感体验。
     如果不能更改播放器行为逻辑为首帧秒开，直播服务器也可以做一些取巧处理，比如从缓存 GOP 改成缓存双关键帧（减少图像数量），这样可以极大程度地减少播放器加载 GOP 要传输的内容体积。

   * 3.2 app 业务逻辑层面优化
     比如提前做好 DNS 解析（省却几十毫秒），和提前做好测速选线（择取最优线路）。经过这样的预处理之后，在点击播放按钮时，将极大提高下载性能。

一方面，可以围绕传输层面做性能优化；另一方面，可以围绕客户播放行为做业务逻辑优化。两者可以有效的互为补充，作为秒开的优化空间。

* 4. 秒开视频方案

   * 4.1 优化服务器策略
     播放器接入服务器请求数据的时间点的视频不一定是关键帧，那么需要等到下一个关键帧的到来，如果关键帧的周期是 2s 的话，那么等待的时间可能会在 0~2s 的范围内，这段等待的时间会影响首屏的加载时间。如果服务器有缓存，则播放端在接入的时候，服务器可以向前找最近的关键帧发给播放端，这样就可以省去等待的时间，可以大大的减少首屏的加载时间。

   * 4.2 优化播放端策略
     播放端请求到的第一帧数据肯定是关键帧，关键帧能够通过帧内参考进行解码。这样播放端就可以在接收到第一个关键帧的时候就立即开始解码显示，而不需要等到缓存一定数量的视频帧才开始解码，这样也能减少首屏画面显示的时间。

* 5 播放端首屏时长的优化
  播放器的首屏过程中的几个步骤：

>* 首屏时间，指的是从进入直播间开始到第一次看到直播画面的时间。首屏时间过长极易导致用户失去对直播的耐心，降低用户的留存。但游戏直播对画面质量和连贯性的要求高，对应推流端编码后的数据量和其他类型直播相比大的多，如何降低首屏时间是一个不小的难题。
>* 在播放端的首屏过程中，主要有以下三个操作需要进行：加载直播间 UI（包括播放器本身）、下载直播数据流（未解码）和解码数据播放。其中数据解码播放又细分为以下几个步骤：
>* 检测传输协议类型（RTMP、RTSP、HTTP 等）并与服务器建立连接接收数据；
>* 视频流解复用得到音视频编码数据（H.264/H.265、AAC 等）；
>* 音视频数据解码，音频数据同步至外设，视频数据渲染都屏幕，至此，视频开始播放，首屏时间结束。

* 总结： 首先，加载 UI 可以以单例的方式进行，能够一定程度地提升首屏展示速度；其次，可以预设解码类型，减少数据类型检测时间；再次，设定合理的下载缓冲区大小，尽可能减少下载的数据量，当检测到 I 帧数据，立即开始解码单帧画面进行播放，提高首屏展示时间。

# <h3 id="subject_030">面试题30</h3>

如何降低延迟？如何保证流畅性？如何解决卡顿？解决网络抖动？

##### 参考答案

* 1. 产生原因
     保证直播的流畅性是指在直播过程中保证播放不发生卡顿，卡顿是指在播放过程中声音和画面出现停滞，非常影响用户体验。造成卡顿的原因有几种情况：

推流端网络抖动导致数据无法发送到服务器，造成播放端卡顿；
播放端网络抖动导致数据累计在服务器上拉不下来，造成博凡卡顿。
由于从服务器到播放器的网络情况复杂，尤其是在 3G 和带宽较差的 WIFI 环境下，抖动和延迟经常发生，导致播放不流畅，播放不流畅带来的负面影响就是延时增大。如何在网络抖动的情况下保证播放的流畅性和实时性是保障直播性能的难点。

* 2. 流畅度优化
     目前主流的直播协议是 RTMP、HTTP-FLV 和 HLS，都是基于 TCP 的长连接。在播放的过程中，若播放端所处的网络环境在一个较佳的状态，此时播放会很流畅。若网络环境不是很稳定，经常会发生抖动，如果播放端没有做特殊处理，可能会经常发生卡顿，严重的甚至会出现黑屏。而移动直播由于其便捷性，用户可以随时随地发起和观看直播，我们无法保证用户的网络一直处于一个非常好的状态，所以，在网络不稳定的情况下保证播放的流畅度是非常重要的。

为了解决这个问题，首先播放器需要将拉流线程和解码线程分开，并建立一个缓冲队列用于缓冲音视频数据。拉流线程将从服务器上获取到的音视频流放入队列，解码线程从队列中获取音视频数据进行解码播放，队列的长度可以调整。当网络发生抖动时，播放器无法从服务器上获取到数据或获取数据的速度较慢，此时队列中缓存的数据可以起到一个过渡的作用，让用户感觉不到网络发生了抖动。

当然这是对于网络发生抖动的情况所采取的策略，如果播放端的网络迟迟不能恢复或服务器的边缘结点出现宕机，则需要应用层进行重连或调度。

# <h3 id="subject_031">面试题31</h3>

预测编码的基本原理是什么？

##### 参考答案

预测编码是数据压缩理论的一个重要分支。根据离散信号之间存在一定相关性特点，利用前面的一个或多个信号对下一个信号进行预测，然后对实际值和预值的差（预测误差）进行编码。如果预测比较准确，那么误差信号就会很小，就可以用较少的码位进行编码，以达到数据压缩的目的。

>* 原理：利用以往的样本值对新样本值进行预测，将新样本值的实际值与其预测值相减，得到误差值，对该误差值进行编码，传送此编码即可。理论上数据源可以准确地用一个数学模型表示，使其输出数据总是与模型的输出一致，因此可以准确地预测数据，但是实际上预测器不可能找到如此完美的数学模型；预测本身不会造成失真。误差值的編码可以采用无失真压縮法或失真压縮法。

# <h3 id="subject_032">面试题32</h3>

需要把网络上一段视频存储下来（比如作为mp4 ), 请实现并说出方法（第一个视频需要翻墙才能进）？

# <h3 id="subject_033">面试题33</h3>

需要把网络上一段语音存储下来（比如作为mp3 ), 请实现并说出方法？

# <h3 id="subject_034">面试题34</h3>

为什么要有YUV这种数据出来？（YUV相比RGB来说的优点）

##### 参考答案

RGB是指光学三原色红、绿和蓝，通过这3种的数值（0-255）改变可以组成其他颜色，全0时为黑色，全255时为白色。RGB是一种依赖于设备的颜色空间：不同设备对特定RGB值的检测和重现都不一样，因为颜色物质（荧光剂或者染料）和它们对红、绿和蓝的单独响应水平随着制造商的不同而不同，甚至是同样的设备不同的时间也不同。

YUV，是一种颜色编码方法。常使用在各个视频处理组件中。三个字母分别表示亮度信号Y和两个色差信号R－Y（即U）、B－Y（即V），作用是描述影像色彩及饱和度，用于指定像素的颜色。Y'UV的发明是由于彩色电视与黑白电视的过渡时期。黑白视频只有Y视频，也就是灰阶值。与我们熟知的RGB类似，YUV也是一种颜色编码方法，主要用于电视系统以及模拟视频领域，它将亮度信息（Y）与色彩信息（UV）分离，没有UV信息一样可以显示完整的图像，只不过是黑白的，这样的设计很好地解决了彩色电视机与黑白电视的兼容问题。并且，YUV不像RGB那样要求三个独立的视频信号同时传输，所以用YUV方式传送占用极少的频宽。

YUV和RGB是可以相互转换的，基本上所有图像算法都是基于YUV的，所有显示面板都是接收RGB数据。

# <h3 id="subject_035">面试题35</h3>

H264/H265有什么区别？

##### 参考答案

同样的画质和同样的码率，H.265比H2.64 占用的存储空间要少理论50%。如果存储空间一样大，那么意味着，在一样的码率下H.265会比H.264 画质要高一些理论值是30%~40%。

比起H.264，H.265提供了更多不同的工具来降低码率，以编码单位来说，最小的8x8到最大的64x64。信息量不多的区域(颜色变化不明显)划分的宏块较大，编码后的码字较少，而细节多的地方划分的宏块就相应的小和多一些，编码后的码字较多，这样就相当于对图像进行了有重点的编码，从而降低了整体的码率，编码效率就相应提高了。

H.265标准主要是围绕着现有的视频编码标准H.264，在保留了原有的某些技术外，增加了能够改善码流、编码质量、延时及算法复杂度之间的关系等相关的技术。H.265研究的主要内容包括，提高压缩效率、提高鲁棒性和错误恢复能力、减少实时的时延、减少信道获取时间和随机接入时延、降低复杂度。

# <h3 id="subject_036">面试题36</h3>

视频或者音频传输，你会选择TCP协议还是UDP协议？为什么？

##### 参考答案

选择UDP协议，UDP实时性好。TCP要保证丢失的package会被再次重发，确保对方能够收到。 而在视频播放中，如果有一秒钟的信号确实，导致画面出现了一点瑕疵，那么最合适的办法是把这点瑕疵用随便哪些信号补充上，这样虽然画面有一点点瑕疵但是不影响观看。如果用的TCP的话，这点缺失的信号会被一遍又一遍的发送过来直到接收端确认收到。这不是音视频播放所期待的。而UDP就很适合这种情况。UDP不会一遍遍发送丢失的package。

# <h3 id="subject_037">面试题37</h3>

平时说的软解和硬解，具体是什么？

##### 参考答案

硬解就是硬件解码，指利用GPU来部分代替CPU进行解码，软解就是软件解码，指利用软件让CPU来进行解码。两者的具体区别如下所示：

硬解码：是将原来全部交由CPU来处理的视频数据的一部分交由GPU来做，而GPU的并行运算能力要远远高于CPU，这样可以大大的降低对CPU的负载，CPU的占用率较低了之后就可以同时运行一些其他的程序了，当然，对于较好的处理器来说，比如i5 2320，或者AMD 任何一款四核心处理器来说，硬解和软件的区别只是个人偏好问题了吧。　　

软解码：即通过软件让CPU来对视频进行解码处理；而硬解码：指不借助于CPU，而通过专用的子卡设备来独立完成视频解码任务。曾经的VCD/DVD解压卡、视频压缩卡等都隶属于硬解码这个范畴。而现如今，要完成高清解码已经不再需要额外的子卡，因为硬解码的模块已经被整合到显卡GPU的内部，所以目前的主流显卡（集显）都能够支持硬解码技术。

# <h3 id="subject_038">面试题38</h3>

何为直播？何为点播？

##### 参考答案

直播：是一个三方交互(主播、服务器、观众)，这个交互式实时的！尽管会根据选择的协议不同而有一些延迟，但我们仍认为它直播是实时的！--->主播在本地发送音视频给服务器（推流），观众从服务器实时解码（拉流）收看收听主播发送给服务器的音视频（直播内容）。直播是不能快进的点播：首先一定要明确的一点，点播不存在推流这一过程，你本身你的流已经早就推给服务器了，或者这么说也不对，应该是你的音视频早就上传到了服务器，观众只需要在线收看即可，由于你的音视频上传到了服务器，观众则可以通过快进，快退，调整进度条等方式进行收看！ 

# <h3 id="subject_039">面试题39</h3>

简述推流、拉流的工作流程？

##### 参考答案

推流：在直播中，一方向服务器发送请求，向服务器推送自己正在实时直播的数据，而这些内容在推送到服务器的这一过程中是以 “流” 的形式传递的，这就是“推流”，把音视频数据以流的方式推送（或上传）到服务器的过程就是“推流”！ 推流方的音视频往往会很大，在推流的过程中首先按照 aac音频-编码 和 h264视【公众平台不能出现视频这两个字，真是坑】频-编码的标准把推过来的音视频压缩 ，然后合并成 MP4或者 FLV格式，然后根据直播的封装协议，最后传给服务器完成推流过程。 

拉流：与推流正好相反，拉流是用户从服务器获取推流方给服务器的音视频的过程，这就是“拉流”！拉流首先aac音频-解码 和 h.264视【公众平台不能出现视频这两个字，真是坑】 频-解码的内部把推过来的音视频解压缩，然后合成 MP4或者 FLV 格式，再解封装，最后到我们的客户端与观众进行交互。

# <h3 id="subject_040">面试题40</h3>

如何在直播中I帧间隔设置、与帧率分辨率选定？

# <h3 id="subject_041">面试题41</h3>

直播推流中推I帧与推非I帧区别是什么？

# <h3 id="subject_042">面试题42</h3>

常见的直播协议有哪些？之间有什么区别？

# <h3 id="subject_043">面试题43</h3>

点播中常见的数据传输协议主要有哪些？

# <h3 id="subject_044">面试题44</h3>

RTMP、HLS协议各自的默认端口号是？

# <h3 id="subject_045">面试题45</h3>

简述RTMP协议，如何封装RTMP包？

# <h3 id="subject_046">面试题46</h3>

m3u8构成是？直播中m3u8、ts如何实时更新？

# <h3 id="subject_047">面试题47</h3>

何为音视频同步，音视频同步是什么标准？

# <h3 id="subject_048">面试题48</h3>

播放器暂停、快进快退、seek、逐帧、变速怎么实现？

# <h3 id="subject_049">面试题49</h3>

说说你平时在播放过程中做的优化工作？

# <h3 id="subject_050">面试题50</h3>

你研究过哪些具体的流媒体服务器，是否做过二次开发？

