vim.cmd("let g:netrw_liststyle = 3")

local opt = vim.opt

opt.updatetime = 300 -- refresh time to improve Trouble for a while

-- activate relative number
opt.relativenumber = true

-- activate actual number line at cursor
opt.number = true

-- tabs & indentation
opt.tabstop = 2 -- 2 spaces for tabs (prettier default)
opt.shiftwidth = 2 -- 2 spaces for indent width
opt.expandtab = true -- expand tab to spaces
opt.autoindent = true -- copy indent from current line when starting new one

opt.wrap = false

-- search settings
opt.ignorecase = true -- ignore case when searching
opt.smartcase = true -- if you include mixed case in your search, assumes you want case-sensitive

opt.cursorline = true

-- turn on termguicm2 or any other true color terminal)
opt.termguicolors = true
opt.background = "dark" -- colorschemes that can be light or dark will be made dark
opt.signcolumn = "yes" -- show sign column so that text doesn't shift

-- backspace
opt.backspace = "indent,eol,start" -- allow backspace on indent, end of line or insert mode start position

-- clipboard
opt.clipboard:append("unnamedplus") -- use system clipboard as default register

-- split windows
opt.splitright = true -- split vertical window to the right
opt.splitbelow = true -- split horizontal window to the bottom

-- turn off swapfile
opt.swapfile = false

-- enable automatic folding

-- Set the fold method to syntax-based folding
opt.foldmethod = "indent"

-- Set the default fold level to 99 to keep all folds open when opening a file
opt.foldlevel = 99

-- Enable folding automatically when opening a file
opt.foldenable = true
