
# Neovim Configuration

This README provides an overview of the plugins included in my Neovim configuration.

## Core

* `init.lua`: The main configuration file for Neovim.
* `keymaps.lua`: Custom key mappings.
* `options.lua`: Neovim options.

## Plugins

### General

* `autopairs`: Automatic pair creation and completion.
* `auto-session`: Automatic session saving and restoring.
* `bufferline`: A customizable status line for Neovim.
* `colorscheme`: A colorscheme for Neovim.
* `comment`: Commenting and uncommenting lines of code.
* `dressing`: A popup menu for Neovim.
* `flash`: A plugin for highlighting text.
* `formatting`: A plugin for formatting code.
* `f-person`: A plugin for formatting personal information.
* `indent-blankline`: A plugin for showing indentation lines.
* `lazygit`: A Git GUI for Neovim.
* `lualine`: A status line for Neovim.
* `mini-icons`: A plugin for using icons in Neovim.
* `nvim-cmp`: A completion plugin for Neovim.
* `nvim-tree`: A file explorer for Neovim.
* `spectre`: A search and replace plugin for Neovim.
* `surround`: A plugin for surrounding text with characters.
* `telescope`: A fuzzy finder for Neovim.
* `todo-comments`: A plugin for managing TODO comments.
* `treesitter`: A syntax highlighting engine for Neovim.
* `trouble`: A diagnostic information window for Neovim.
* `vim-maximizer`: A plugin for maximizing the current window.
* `which-key`: A plugin for displaying key bindings.

### LSP

* `lspconfig`: A configuration library for LSP clients.
* `mason`: A plugin for managing LSP servers.

## Usage

1. Clone this repository to your Neovim configuration directory.
2. Install the plugins using your preferred plugin manager.
3. Restart Neovim.

This README provides a brief overview of the plugins included in my Neovim configuration. For more details, please refer to the documentation of each plugin.
