import Layout from '@/views/layout/CommonLayout'

const layout = function(menu, requiresAuth = true) {
  if (menu.meta) {
    menu.meta.requiresAuth = requiresAuth
  }
  return {
    code: 'report',
    path: '/report',
    component: Layout,
    meta: {
      requiresAuth: true
    },
    children: [
      menu
    ]
  }
}

export default { type: 'report', router: [
  {
    ...layout({
      code: 'report_definition',
      path: 'definition',
      component: () => import('@/views/report/definition'),
      meta: {
        title: '报表管理',
        icon: 'icon-title'
      }
    })
  },
  {
    ...layout({
      code: 'report_design',
      path: 'design',
      component: () => import('@/views/report/design'),
      meta: {
        title: '首页设计',
        icon: 'board'
      }
    })
  }]
}
